import axios from "axios";
import jwt from "jsonwebtoken";
import * as cheerio from "cheerio";

import { PrismaClient as PrismaClient1 } from "../../prisma/generated/client1/index.js";
import { PrismaClient as PrismaClient2 } from "../../prisma/generated/client2/index.js";
import errorCodes from "./errorCodes.js";

// Use the clients...

const prismaMasterDb = new PrismaClient1();

const prismaSubMasterDb = new PrismaClient2();

const createToken = (slug, expiresIn) => {
  // console.log(slug,"jwtte key secrete ")
  // const maxAge = 3 * 24 * 60 * 60; // Default to 3 days
  return jwt.sign(slug, process.env.JWT_SECRET_KEY, { expiresIn: expiresIn });
};

const recordsFetch = (page_no = 1, number_of_rows = 10) => {
  const pageNumber = Number(page_no);
  const recordsPerPage = Number(number_of_rows);
  const skipRecords = (pageNumber - 1) * recordsPerPage;
  return { skipRecords, recordsPerPage };
};

const convertArrayValuesToSingle = (obj) => {
  Object.keys(obj).forEach((prop) => {
    if (Array.isArray(obj[prop])) {
      obj[prop] = obj[prop][0];
    }
  });
  return obj;
};

const generateUniqueString = () => {
  // Generate a random 6-digit number
  return Math.floor(100000 + Math.random() * 900000).toString();
};

//checking index function//

const checkIndexedInGoogle = async (url) => {
  try {
    // Google "site:" search query to check indexing
    const searchQuery = `site:${url}`;

    const headers = {
      "User-Agent":
        "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.82 Safari/537.36",
    };

    const searchResponse = await axios.get(
      `https://www.google.com/search?q=${searchQuery}`,
      { headers }
    );
    let found = false;
    const $ = cheerio.load(searchResponse.data);

    const resultElements = $("h3");

    if (resultElements.length === 0) {
      return found;
    }

    // Loop through each result element to check for the presence of the site URL
    resultElements.each((index, element) => {
      const linkTag = $(element).parent("a");
      if (linkTag && linkTag.attr("href")) {
        const link = linkTag.attr("href"); // Get the href attribute of the anchor tag
        if (link.includes(url)) {
          found = true;
          return false; // Break the loop as we've found the URL
        }
      }
    });

    // Return the result based on whether the URL was found in the search results
    if (found) {
      console.log("url is found");
      return found;
    } else {
      console.log("url is found not");

      return found;
    }
  } catch (error) {
    console.error("Error checking if URL is indexed in Google:", error);
    return false;
  }
};

// get sub domain //

// function extractDomain(link) {
//   try {
//     // Create a URL object from the link
//     const url = new URL(link);

//     // Get the full hostname (subdomain + domain + TLD)
//     const hostname = url.hostname;

//     // Get the pathname (full URL path)
//     const pathname = url.pathname;

//     // Split the hostname into parts (subdomain, domain, tld)
//     const parts = hostname.split(".");

//     // If the hostname has more than two parts (indicating a subdomain), return the full subdomain
//     let subdomain = "";
//     if (parts.length > 2) {
//       subdomain =
//         parts.slice(0, parts.length - 2).join(".") +
//         "." +
//         parts.slice(parts.length - 2).join(".");
//     } else {
//       subdomain = hostname; // If no subdomain, return the full hostname
//     }

//     // Construct the full URL path
//     const fullUrl = subdomain + pathname;

//     // Return both subdomain and full URL
//     return { subdomain: subdomain, fullUrl: fullUrl };
//   } catch (error) {
//     console.error("Invalid URL", error);
//     return null;
//   }
// }

function extractDomain(link) {
  try {
    // Check if the URL has a protocol (http:// or https://)
    // If not, prepend 'http://' to make it valid for the URL constructor
    if (!/^https?:\/\//i.test(link)) {
      link = "http://" + link;
    }

    // Create a URL object from the link
    const url = new URL(link);

    // Get the full hostname (subdomain + domain + TLD)
    const hostname = url.hostname;

    // Get the pathname (full URL path)
    const pathname = url.pathname;

    // Split the hostname into parts (subdomain, domain, tld)
    const parts = hostname.split(".");

    // If the hostname has more than two parts (indicating a subdomain), return the full subdomain
    let subdomain = "";
    if (parts.length > 2) {
      subdomain =
        parts.slice(0, parts.length - 2).join(".") +
        "." +
        parts.slice(parts.length - 2).join(".");
    } else {
      subdomain = hostname; // If no subdomain, return the full hostname
    }

    // Construct the full URL path without the protocol
    const fullUrl = subdomain + pathname;

    // Return both subdomain and full URL without the protocol
    return { subdomain: subdomain, fullUrl: fullUrl };
  } catch (error) {
    console.error("Invalid URL", error);
    return null;
  }
}

// check url status for cron job//
const checkUrlStatus = async (url, domain, userId, job_id, category_id) => {
  try {
    // Fetch the URL
    const controller = new AbortController();
    const timeoutId = setTimeout(() => controller.abort(), 60000); // 60 seconds timeout

    // Fetch the URL with timeout handling
    const response = await fetch(url, { signal: controller.signal }).catch(
      (err) => {
        if (err.name === "AbortError") {
          console.log(`Timeout: URL ${url} took too long to respond.`);
        }
        return null; // Return null if request is aborted
      }
    );

    clearTimeout(timeoutId); // Clear timeout once response is received

    const { subdomain, fullUrl } = extractDomain(url);
    // console.log(response,"response of links")
    if (!response?.ok) {

      let data = {
        link: fullUrl,
        refer_domain: subdomain,
        status_code: response.status,
        targeted_url: null,
        is_index: false,
        anchor_text: null,
        relation: null,
        first_seen: null,
        last_seen: null,
        added_date: null,
        uploaded_by_id: userId,
        job_id: job_id,
        link_category: category_id,
      };

      let result = await saveIntoDB(fullUrl, domain, data);
      return result;
    } else {
      const html = await response.text();

      const statusCode = response?.status;

      const domainDetails = await prismaSubMasterDb.Project.findUnique({
        where: {
          id: Number(domain),
          deleted_at: null,
        },
      });

      const $ = cheerio.load(html);

      let datePublished = null;
      let dateModified = null;
      let addedDate = null;
      // Check if the page contains a publish date (common meta tags or time tags)
      const metaDate =
        $('meta[property="article:published_time"]').attr("content") ||
        $('meta[name="date"]').attr("content") ||
        $("time").attr("datetime");

      if (metaDate) {

        const formattedDate = metaDate.replace(/GMT([+-]\d{4})/, "T$1");

        datePublished = formattedDate ? new Date(formattedDate) : null;
        addedDate = formattedDate ? new Date(formattedDate) : null;
      } else {

        const scriptTags = $("script[type='application/ld+json']");

        scriptTags.each((index, element) => {
          const jsonData = $(element).html();

          try {
            const parsedData = JSON.parse(jsonData);

            const dateDetails =
              parsedData["@graph"] &&
              parsedData["@graph"]
                .filter((item) => item.datePublished && item.dateModified) // Filter objects with datePublished and dateModified
                .map((item) => ({
                  datePublished: item.datePublished,
                  dateModified: item.dateModified,
                }));

            if (dateDetails) {
        
              datePublished =
                dateDetails.length > 0
                  ? new Date(dateDetails[0]?.datePublished)
                  : null;
              addedDate =
                dateDetails.length > 0
                  ? new Date(dateDetails[0]?.datePublished)
                  : null;

              dateModified =
                dateDetails.length > 0
                  ? new Date(dateDetails[0]?.dateModified)
                  : null;
            }

            // Check if the JSON contains 'datePublished' or 'dateModified'
          } catch (error) {
            console.error("Error parsing JSON-LD data: ", error);
          }
        });
      }

      // // Extract all anchor tags
      const anchorTags = $("a");
      let targetedUrl = null;
      let achorText = null;
      let rel = null;
      // // Check if any anchor tag href matches the current URL
      anchorTags.each((index, element) => {
        const href = $(element).attr("href");
        const text = $(element).text();
        const relationLink = $(element).attr("rel");
        // console.log(domain_url,"domain urlllll",href)
        const regex = new RegExp(domainDetails.domain_url, "i");

        if (regex.test(href)) {
          targetedUrl = href;
          achorText = text;
          rel = relationLink;
        }
      });
   
      // // Check if the URL is indexed by Google (simulated by a search query)
      let data = {
        link: fullUrl,
        refer_domain: subdomain,
        status_code: statusCode,
        targeted_url: targetedUrl ? targetedUrl : null, // If no targeted URL is found, use the original URL
        is_index: false,
        anchor_text: achorText ? achorText : null,
        relation: rel === undefined ? "Do-follow" : rel,
        first_seen: datePublished,
        last_seen: dateModified,
        added_date: addedDate,
        uploaded_by_id: userId,
        job_id: job_id,
        link_category: category_id,
      };

      const result = await saveIntoDB(fullUrl, domain, data);
      return result;
    }
  } catch (error) {
    console.log(error, domain, "erroer return from here");
    let data = {
      link: url,
      refer_domain: "",
      status_code: 404,
      targeted_url: null,
      is_index: false,
      anchor_text: null,
      relation: null,
      first_seen: null,
      last_seen: null,
      added_date: null,
      uploaded_by_id: userId,
      job_id: job_id,
      link_category: category_id,
    };

    const result = await saveIntoDB(url, domain, data);
    return result;
    // console.log(`Error fetching URL ${url}:${error}`);
  }
};

// check url status function for job/queue
// const checkUrlStatus = async (url, domain) => {
//   try {
//     // Fetch the URL
//     // const response = await axios.get(url);

//     const response = await fetch(url);
//     const { subdomain, fullUrl } = extractDomain(url);
//     if (!response.ok) {
//       return {
//         link_url: fullUrl,
//         refer_domain: subdomain,
//         link_status: response.status,
//         targeted_url: null,
//         is_index: false,
//         anchor_text: null,
//         link_rel: null,
//         first_seen: null,
//         last_seen: null,
//         added_date: null,
//       };
//       // throw new Error(`Failed to fetch: ${response.status}`);
//     }

//     const html = await response.text();

//     const statusCode = response?.status;

//     const domainDetails = await prismaSubMasterDb.Project.findUnique({
//       where: {
//         id: Number(domain),
//         deleted_at: null,
//       },
//     });

//     const $ = cheerio.load(html);

//     let datePublished = null;
//     let dateModified = null;
//     let addedDate = null;
//     // Check if the page contains a publish date (common meta tags or time tags)
//     const metaDate =
//       $('meta[property="article:published_time"]').attr("content") ||
//       $('meta[name="date"]').attr("content") ||
//       $("time").attr("datetime");

//     if (metaDate) {
//       datePublished = new Date(metaDate) ? new Date(metaDate) : null;
//       addedDate = new Date(metaDate) ? new Date(metaDate) : null;
//     } else {
//       const scriptTags = $("script[type='application/ld+json']");

//       scriptTags.each((index, element) => {
//         const jsonData = $(element).html();

//         try {
//           const parsedData = JSON.parse(jsonData);

//           const dateDetails =
//             parsedData["@graph"] &&
//             parsedData["@graph"]
//               .filter((item) => item.datePublished && item.dateModified) // Filter objects with datePublished and dateModified
//               .map((item) => ({
//                 datePublished: item.datePublished,
//                 dateModified: item.dateModified,
//               }));

//           if (dateDetails) {
//             datePublished = new Date(dateDetails[0]?.datePublished);
//             addedDate = new Date(dateDetails[0]?.datePublished);

//             dateModified = new Date(dateDetails[0]?.dateModified);
//           }

//           // Check if the JSON contains 'datePublished' or 'dateModified'
//         } catch (error) {
//           console.error("Error parsing JSON-LD data: ", error);
//         }
//       });
//     }

//     // // Extract all anchor tags
//     const anchorTags = $("a");
//     let targetedUrl = null;
//     let achorText = null;
//     let rel = null;
//     // // Check if any anchor tag href matches the current URL
//     anchorTags.each((index, element) => {
//       const href = $(element).attr("href");
//       const text = $(element).text();
//       const relationLink = $(element).attr("rel");
//       // console.log(domain_url,"domain urlllll",href)
//       const regex = new RegExp(domainDetails.domain_url, "i");

//       if (regex.test(href)) {
//         targetedUrl = href;
//         achorText = text;
//         rel = relationLink;
//       }
//     });

//     // // Check if the URL is indexed by Google (simulated by a search query)
//     return {
//       link_url: fullUrl,
//       refer_domain: subdomain,
//       link_status: statusCode,
//       targeted_url: targetedUrl ? targetedUrl : null, // If no targeted URL is found, use the original URL
//       is_index: false,
//       anchor_text: achorText ? achorText : null,
//       link_rel: rel === undefined ? "Do-follow" : rel,
//       first_seen: datePublished,
//       last_seen: dateModified,
//       added_date: addedDate,
//     };
//   } catch (error) {
//     console.log(error, "erroer");
//     return {
//       link_url: url,
//       refer_domain: "",
//       link_status: 404,
//       targeted_url: null,
//       is_index: false,
//       anchor_text: null,
//       link_rel: null,
//       first_seen: null,
//       last_seen: null,
//       added_date: null,
//     };

//   }
// };
// save links to database //

async function saveIntoDB(link, domain, data) {

  try {
    const existingBacklink = await prismaSubMasterDb.backlink.findFirst({
      where: {
        project_id: Number(domain),
        OR: [{ link_url: link }, { refer_domain: data?.refer_domain }],
        deleted_at: null,
      },
    });

    let domainDuplicate = false;
    let reffringDomainDuplicate = false;

    if (existingBacklink) {
      const { subdomain, fullUrl } = extractDomain(existingBacklink.link_url);

      if (fullUrl == existingBacklink.link_url) domainDuplicate = true;
      if (subdomain == domain) reffringDomainDuplicate = true;
    }

    let uploadLinksdata = {
      ...data,
      backlink_duplicate: domainDuplicate,
      refering_domain: reffringDomainDuplicate,
    };

    // save back link to database
    const newBacklink = await prismaSubMasterDb.backlink.create({
      data: {
        link_url: data.link,
        link_status: data.status_code,
        is_index: data.is_index,
        link_rel: data.relation,
        anchor_text: data.anchor_text,
        targeted_url: data.targeted_url,
        project_id: Number(domain),
        uploaded_by_id: data?.uploaded_by_id,
        backlink_duplicate: domainDuplicate, // Set duplicate flag
        refering_domain: reffringDomainDuplicate,
        refer_domain: data?.refer_domain,
        first_seen: data.first_seen,
        last_seen: data.last_seen,
        added_date: data.added_date,
        job_id: data.job_id,
        link_category: data.link_category,
      },
    });

    // const newBacklink = await prismaSubMasterDb.backlink.createMany({
    //   data: {
    //     uploadLinksdata,
    //   },
    // });
    if (newBacklink) {
      let status = 200;
      return status;
    }
    // console.log(newBacklink,"links successs")
  } catch (error) {
    console.log(`saveIntoDB error : ${data} , and ${link}`, error);
  }
}

// async function saveIntoDB(datalist) {
//   try {

// console.log(datalist,"datasd list checking")

//       for(let i=0;i< datalist.length;i++){
//           let data = datalist[i]
//     const existingBacklink = await prismaSubMasterDb.backlink.findFirst({
//       where: {
//         project_id: Number(data.domain_id),
//         OR: [{ link_url: link }, { refer_domain: data?.refer_domain }],
//         deleted_at: null,
//       },
//     });
//     let domainDuplicate = false;
//     let reffringDomainDuplicate = false;
//     if (existingBacklink) {
//       const { subdomain, fullUrl } = extractDomain(existingBacklink.link_url);
//       if (fullUrl == existingBacklink.link_url){
//            domainDuplicate = true;
//       }
//       if (subdomain == domain) {
//           reffringDomainDuplicate = true
//       }
//       data[i]["backlink_duplicate"] = domainDuplicate
//       data[i]["refering_domain"] = reffringDomainDuplicate
//     }
//       }
//     // const newBacklink = await prismaSubMasterDb.backlink.createMany({
//     //   data: {
//     //     data,
//     //   },
//     // });
//     // if (newBacklink) {
//     //   let status = 200;
//     //   return status;
//     // }
//     // console.log(newBacklink,"links successs")
//   } catch (error) {
//     console.log(`saveIntoDB error : ${data} , and ${link}`, error);
//   }
// }

// async function saveIntoDB(domain, datalist, job_id) {
//   try {
//     let count = 0;

//     for (let i = 0; i < datalist.length; i++) {
//       datalist[i];
//       const existingBacklink = await prismaSubMasterDb.backlink.findFirst({
//         where: {
//           project_id: Number(datalist[i].project_id),
//           OR: [
//             { link_url: datalist[i].link_url },
//             { refer_domain: datalist[i]?.refer_domain },
//           ],
//           deleted_at: null,
//         },
//       });
//       let domainDuplicate = false;
//       let reffringDomainDuplicate = false;
//       if (existingBacklink) {
//         const { subdomain, fullUrl } = extractDomain(existingBacklink.link_url);
//         if (fullUrl == existingBacklink.link_url) {
//           domainDuplicate = true;
//         }
//         if (subdomain == domain) {
//           reffringDomainDuplicate = true;
//         }
//         datalist[i]["backlink_duplicate"] = domainDuplicate;
//         datalist[i]["refering_domain"] = reffringDomainDuplicate;
//       }
//     }

//     // console.log(datalist, "DATATSTD LISTS");
//     const newBacklink = await prismaSubMasterDb.backlink.createMany({
//       data: datalist,
//     });

//     const findJob = await prismaSubMasterDb.userJobs.findUnique({
//       where: {
//         id: job_id,
//       },
//       include: {
//         Backlink: true,
//       },
//     });

//     if (!findJob) {
//       return responseHandler.error(
//         res,
//         errorCodes.BAD_REQUEST.code,
//         "Erro while fetching job.",
//         400
//       );
//     }

//     if (findJob.total_links === findJob?.Backlink.length) {
//       await prismaSubMasterDb.userJobs.update({
//         where: {
//           id: job_id,
//         },
//         data: {
//           status: "COMPLETED",
//           processing_status: 2,
//         },
//       });
//     }

//     // console.log(newBacklink,"links successs")
//   } catch (error) {
//     console.log(error);
//     // console.log(`saveIntoDB error : ${data} , and ${link}`, error);
//   }
// }

function generateUniqueFourDigitNumber() {
  const timestamp = Date.now(); // Get the current timestamp (in milliseconds)

  // Get the last 4 digits of the timestamp by using modulo 10000
  const uniqueNumber = timestamp % 10000;

  // If the generated number is less than 1000, pad it with leading zeros
  return uniqueNumber < 1000 ? uniqueNumber + 1000 : uniqueNumber;
}

const projectTimefn = (selectedDays, createdTime) => {

  const currentDate = createdTime ? new Date(createdTime) : new Date(); // Get the current date and time

  // Add the selected number of days to the current date
  currentDate.setDate(currentDate.getDate() + selectedDays);

  // Return the calculated deadline
  return currentDate.toISOString(); //
};


const convertKey = (key) => {
  return key
    .split("_")
    .map((part) => part.charAt(0).toUpperCase() + part.slice(1))
    .join(" ");
};

// Helper functions (implement or adjust as needed)
function searchVolumeLabels(volumeData) {
  // Example: if volumeData = [{ month: "Jan", value: 100 }, { month: "Feb", value: 200 }, …]
  // return an array of month labels
  if (!Array.isArray(volumeData)) return [];
  return volumeData.map((item) => item.month ?? "");
}

function searchVolumeValues(volumeData) {
  // Example: if volumeData = [{ month: "Jan", value: 100 }, …], return [100, …]
  if (!Array.isArray(volumeData)) return [];
  return volumeData.map((item) => item.value ?? 0);
}

function rankHistoryValues(rankHistory) {
  // Example: if rankHistory = [{ date: "2025-06-01", rank: 10 }, …], return [10, …]
  if (!Array.isArray(rankHistory)) return [];
  return rankHistory.map((item) => item.rank ?? null);
}

function safeRound(num) {
  if (typeof num !== "number") return null;
  return Math.round(num);
}

function capitalizedWord(str) {
  if (typeof str !== "string" || !str.length) return "";
  return str.charAt(0).toUpperCase() + str.slice(1).toLowerCase();
}


// function mapTaskToAssignStatus(taskCounts, featureFlags) {
//   // Extract the first object from the array
//   const flags = featureFlags[0] || {};

//   return taskCounts.map((task) => {
//     const flagKey = task.task_name;
//     const assignValue = flags[flagKey] !== undefined ? flags[flagKey] : false;

//     return {
//       task_name: flagKey,
//       delivered: task.count,
//       assign: assignValue,
//     };
//   });
// }

function mapTaskToAssignStatus(taskCounts, featureFlags) {
  const flags = featureFlags[0] || {};
  const taskMap = taskCounts.reduce((acc, task) => {
    acc[task.task_name] = task.count;
    return acc;
  }, {});

  return Object.keys(flags).map((key) => ({
    task_name: key,
    delivered: taskMap[key] || 0,
    assign: flags[key],
  }));
}
export {
  createToken,
  recordsFetch,
  convertArrayValuesToSingle,
  generateUniqueString,
  checkUrlStatus,
  extractDomain,
  saveIntoDB,
  generateUniqueFourDigitNumber,
  projectTimefn,
  convertKey,
  searchVolumeLabels,
  searchVolumeValues,
  rankHistoryValues,
  safeRound,
  capitalizedWord,
  mapTaskToAssignStatus
};
