import fs from "fs";
import csvParser from "fast-csv";
import xlsx from "xlsx";

/**
 * Parses a CSV file efficiently using streams.
 * @param {string} filePath - Path to the CSV file.
 * @returns {Promise<Array>} - Parsed data as an array of objects.
 */
const parseCSV = (filePath) => {
  return new Promise((resolve, reject) => {
    const data = [];
    fs.createReadStream(filePath)
      .pipe(csvParser.parse({ headers: true, trim: true }))
      .on("data", (row) => data.push(row.Links))
      .on("end", () => resolve(data))
      .on("error", reject);
  });
};

/**
 * Parses an Excel file efficiently.
 * @param {string} filePath - Path to the Excel file.
 * @returns {Promise<Array>} - Parsed data as an array of objects.
 */

const parseExcel = (filePath) => {
  return new Promise((resolve, reject) => {
    try {
      if (fs.existsSync(filePath)) {
        try {
          // Pass the buffer to the xlsx reader
          const workbook = xlsx.readFile(filePath);

          //   const workbook = xlsx.readFile(path);

          const sheetName = workbook.SheetNames[0];
          const data = xlsx.utils.sheet_to_json(workbook.Sheets[sheetName], {
            defval: "",
          });

          const returnData = data.map((item) => item["link"].Backlink);
          // console.log(data,"datatatatat--->")
          resolve(data);
        } catch (err) {
          console.log(err, "err in parsing excel.");
        }
      }
    } catch (error) {
      console.log("err while parsing excel.", error);
      reject(error);
    }
  });
};

export { parseCSV, parseExcel };
