export default {
  // 4xx Client Errors
  BAD_REQUEST: {
    code: "BAD_REQUEST",
    message: "Invalid request parameters",
    status: 400,
  },
  UNAUTHORIZED: {
    code: "UNAUTHORIZED",
    message: "Authentication required",
    status: 401,
  },
  FORBIDDEN: { code: "FORBIDDEN", message: "Access denied", status: 403 },
  NOT_FOUND: { code: "NOT_FOUND", message: "Resource not found", status: 404 },
  METHOD_NOT_ALLOWED: {
    code: "METHOD_NOT_ALLOWED",
    message: "HTTP method not allowed",
    status: 405,
  },

  NOT_ACCEPTABLE: {
    code: "NOT_ACCEPTABLE",
    message: "Requested format is not acceptable",
    status: 406,
  },
  CONFLICT: {
    code: "CONFLICT",
    message: "Data conflict occurred",
    status: 409,
  },
  PAYLOAD_TOO_LARGE: {
    code: "PAYLOAD_TOO_LARGE",
    message: "Payload exceeds size limit",
    status: 413,
  },
  UNSUPPORTED_MEDIA_TYPE: {
    code: "UNSUPPORTED_MEDIA_TYPE",
    message: "Unsupported media type",
    status: 415,
  },
  TOO_MANY_REQUESTS: {
    code: "TOO_MANY_REQUESTS",
    message: "Too many requests, slow down",
    status: 429,
  },

  // 5xx Server Errors
  INTERNAL_SERVER_ERROR: {
    code: "INTERNAL_SERVER_ERROR",
    message: "Something went wrong",
    status: 500,
  },
  NOT_IMPLEMENTED: {
    code: "NOT_IMPLEMENTED",
    message: "Feature not implemented",
    status: 501,
  },
  SERVICE_UNAVAILABLE: {
    code: "SERVICE_UNAVAILABLE",
    message: "Service is temporarily unavailable",
    status: 503,
  },
  GATEWAY_TIMEOUT: {
    code: "GATEWAY_TIMEOUT",
    message: "Gateway timeout",
    status: 504,
  },

  // Authentication & Authorization Errors
  TOKEN_EXPIRED: {
    code: "TOKEN_EXPIRED",
    message: "Token has expired",
    status: 401,
  },
  INVALID_TOKEN: {
    code: "INVALID_TOKEN",
    message: "Invalid or malformed token",
    status: 401,
  },
  ACCOUNT_LOCKED: {
    code: "ACCOUNT_LOCKED",
    message: "Too many failed login attempts, account locked",
    status: 403,
  },
  PERMISSION_DENIED: {
    code: "PERMISSION_DENIED",
    message: "You do not have permission to perform this action",
    status: 403,
  },

  // Database & Validation Errors
  DUPLICATE_ENTRY: {
    code: "DUPLICATE_ENTRY",
    message: "Duplicate entry, unique constraint violated",
    status: 409,
  },
  PACKAGE: {
    code: "PACKAGE_NOT_FOUND",
    message: "Package not found",
    status: 404,
  },
  RECORD_NOT_FOUND: {
    code: "RECORD_NOT_FOUND",
    message: "Requested record does not exist",
    status: 404,
  },
  VALIDATION_ERROR: {
    code: "VALIDATION_ERROR",
    message: "Data validation failed",
    status: 400,
  },
  DATABASE_ERROR: {
    code: "DATABASE_ERROR",
    message: "Database error occurred",
    status: 500,
  },

  // File Upload Errors
  FILE_TOO_LARGE: {
    code: "FILE_TOO_LARGE",
    message: "Uploaded file size exceeds the limit",
    status: 413,
  },
  UNSUPPORTED_FILE_TYPE: {
    code: "UNSUPPORTED_FILE_TYPE",
    message: "File format is not supported",
    status: 415,
  },

  // External API & Network Errors
  THIRD_PARTY_SERVICE_ERROR: {
    code: "THIRD_PARTY_SERVICE_ERROR",
    message: "External service error",
    status: 502,
  },
  NETWORK_ERROR: {
    code: "NETWORK_ERROR",
    message: "Network connectivity issue",
    status: 503,
  },
  TIMEOUT_ERROR: {
    code: "TIMEOUT_ERROR",
    message: "Request timeout",
    status: 504,
  },

  // Payment Errors
  PAYMENT_REQUIRED: {
    code: "PAYMENT_REQUIRED",
    message: "Payment is required",
    status: 402,
  },
  PAYMENT_FAILED: {
    code: "PAYMENT_FAILED",
    message: "Payment processing failed",
    status: 402,
  },

  // WebSocket Errors
  WS_CONNECTION_FAILED: {
    code: "WS_CONNECTION_FAILED",
    message: "WebSocket connection failed",
    status: 500,
  },
  WS_DISCONNECTED: {
    code: "WS_DISCONNECTED",
    message: "WebSocket disconnected unexpectedly",
    status: 500,
  },
  DOMAIN: { code: "DOMAIN", message: "Domain not found", status: 500 },
  CATEGORY: {
    code: "DOMAIN_CATEGORY",
    message: "Domain category not found",
    status: 400,
  },
  USER_NOT_EXIST: {
    code: "USER",
    message: "User does not exists.",
    status: 400,
  },

  CATEGORY_NOT_EXIST: {
    code: "CATEGORY",
    message: "Category does not exists.",
    status: 400,
  },
  PASSWORD: {
    code: "PASSWORD",
    message: "Incorrect credentials.",
    status: 400,
  },
  ALREADY: {
    code: "PERMISSION",
    message: "Permission already exists",
    status: 400,
  },
  EMAIL: {
    code: "Email Duplicate",
    message: "Email is already taken.",
    status: 400,
  },
  PROJECT_NOT_EXIST: {
    code: "Project error.",
    message: "Project not exists.",
    status: 400,
  },
  UPLOAD_LINKS: {
    code: "Uploading Links.",
    message: "Error while uploading links.",
    status: 400,
  },
};
