import { verifyToken } from "../utils/jwt.js";

export function authenticateAdmin(req, res, next) {
  try {
// console.log(req.headers)
    // Get token from cookies or Authorization header
    const token = req.headers.access_token;

    if (!token) {
      return res.status(401).json({ error: "Unauthorized: No token provided" });
    }
    // Verify the token
    const decoded = verifyToken(token);


    // Attach user data to request object
    req.admin = decoded;

    next(); // Proceed to the next middleware
  } catch (error) {
    console.error("Auth Error:", error.message);

    // Handle token-specific errors
    if (error.name === "TokenExpiredError") {
      return res.status(403).json({ error: "Token expired. Please login again." });
    }
    if (error.name === "JsonWebTokenError") {
      return res.status(403).json({ error: "Invalid token." });
    }

    return res.status(500).json({ error: "Internal Server Error" });
  }
}
