import { Router } from "express";
import {
  allReferDomain,
  allReferDomainCategory,
  assignProject,
  createDomain,
  deleteProject,
  editProject,
  fetchAllCompititors,
  // domainDetail,
  fetchAllDomain,
  fetchAllKewords,
  fetchAllLanguagse,
  fetchAllMongoProjects,
  fetchDomainCategory,
  fetchprojectPackages,
  fetchProjectsPackages,
  fetchAllRegions,
  fetchSingleProject,
  fethAllGuidelines,
  getSeoPackages,
  projectDetails,
  projectGuideLineDetails,
  projectGuideLines,
  projectLinksDetails,
  projectUserDetails,
  reportsCounter,
  fetchAllKeywordsByProjectId,
  getProjectById,
  addKeywords,
  deleteKeyword,
  gettAllGuidelines
} from "./domainController.js";
import { authenticateUser } from "../../middlewares/authMiddleware.js";

const domainRouter = Router();

domainRouter.post("/create-domain", authenticateUser, createDomain);

domainRouter.get("/get-all-domains", authenticateUser, fetchAllDomain);

domainRouter.get("/all-categories",authenticateUser, fetchDomainCategory);

domainRouter.post("/assign-project", authenticateUser, assignProject);
domainRouter.get("/project-details/:id", authenticateUser, projectDetails);
domainRouter.get("/project-links", authenticateUser, projectLinksDetails);
domainRouter.get("/project-userdetails", authenticateUser, projectUserDetails);
domainRouter.get(
  "/fetch-project-details/:id",
  authenticateUser,
  fetchSingleProject
);
domainRouter.post("/update-project", authenticateUser, editProject);
domainRouter.post("/delete-project", authenticateUser, deleteProject);
domainRouter.get("/report-counter", authenticateUser, reportsCounter);

domainRouter.get(
  "/all-refer-category",
  authenticateUser,
  allReferDomainCategory
);


domainRouter.get("/all-refering-domain",authenticateUser,allReferDomain)


domainRouter.get("/get-all-guidelines", authenticateUser, fethAllGuidelines);
domainRouter.get("/get-all-projectguide", authenticateUser, projectGuideLines);

domainRouter.get("/all-seo-packages",authenticateUser,getSeoPackages)
domainRouter.get("/get-package-details",authenticateUser,fetchprojectPackages)
domainRouter.get("/completed-guidelines/:id",authenticateUser,projectGuideLineDetails)

domainRouter.get("/fetch-project-packages/:project_id",authenticateUser,fetchProjectsPackages)

domainRouter.get("/get-mongo-projects",authenticateUser,fetchAllMongoProjects)
domainRouter.get("/get-all-compititors",authenticateUser,fetchAllCompititors)
domainRouter.get("/get-all-keywords",authenticateUser,fetchAllKewords)
domainRouter.get("/get-all-languages",authenticateUser,fetchAllLanguagse)
domainRouter.get("/get-all-Regions",authenticateUser,fetchAllRegions)
domainRouter.get("/get-all-keywords-by-project/:project_id",authenticateUser,fetchAllKeywordsByProjectId)

domainRouter.get("/get-project-by-id/:project_id",authenticateUser,getProjectById)
domainRouter.post("/add-keywords", authenticateUser,addKeywords)

domainRouter.get("/delete-keyword",authenticateUser, deleteKeyword)

domainRouter.get("/getallguidelines", gettAllGuidelines)










export default domainRouter;
