import Joi from "joi";
const addReferDomainSchema = Joi.object({
  category_id: Joi.string()
    .required()
    .error(new Error("Please enter valid category id.")),
  category_name: Joi.string().optional(),
  rd_links: Joi.array()
    .items(Joi.string())
    .min(1)
    .max(4)
    .required()
    .error(
      new Error(
        "Please enter a valid array of links with a maximum of 4 items."
      )
    ),
});

export { addReferDomainSchema };
