import { Router } from "express";

import {
  addProjectMembers,
  allUserList,
  assignPermission,
  createTeam,
  fetchAllRole,
  fetchManagementTeamList,
  fetchProjectMembers,
  forgotPassword,
  getAllUserPermissions,
  login,
  myPermission,
  registration,
  resetPassword,
  singleUserDetails,
  teamList,
  updateTeam,
  uploadRd,
  userDetailReport,
  userDetails,
  userPermission,
  userProjects,
  userRd,
  userReportLinks,
  userReports,
  verifyEmail,
} from "./authController.js";
import { authenticateUser } from "../../middlewares/authMiddleware.js";
import { validateUploadRd } from "../../middlewares/validator.js";

const authRouter = Router();

authRouter.post("/signup", registration);

authRouter.post("/login", login);
authRouter.get("/all-roles", authenticateUser, fetchAllRole);
authRouter.post("/add-member", authenticateUser, createTeam);
authRouter.get("/project-member", authenticateUser, fetchProjectMembers);
authRouter.get("/user-details/:id", authenticateUser, userDetails);
authRouter.post("/assign-permission", authenticateUser, assignPermission);
authRouter.get("/all-users-list", authenticateUser, allUserList);
authRouter.get("/all-permissons-list", authenticateUser, getAllUserPermissions);
authRouter.get("/user-permissions/:user_id", authenticateUser, userPermission);
authRouter.get("/my-permisson", authenticateUser, myPermission);
authRouter.post("/confirm-email", verifyEmail);
authRouter.post("/forgot-password", forgotPassword);
authRouter.post("/reset-password", resetPassword);
authRouter.get("/user-reports/",authenticateUser,userReports)
authRouter.get("/reports-links",authenticateUser,userReportLinks)
authRouter.post("/upload-rd",authenticateUser,validateUploadRd,uploadRd)
authRouter.get("/user-projects",authenticateUser,userProjects)
authRouter.get("/user-rd",authenticateUser,userRd)
authRouter.get("/get-report-details",authenticateUser,userDetailReport)
authRouter.get("/all-team-list",authenticateUser,teamList)
authRouter.get("/management-team",authenticateUser,fetchManagementTeamList)
authRouter.get("/user-details",authenticateUser,singleUserDetails)
authRouter.put("/update-team",authenticateUser,updateTeam)
export default authRouter;
