import express from "express";
import helmet from "helmet";
import cors from "cors";
import { authenticateUser } from "./middlewares/authMiddleware.js";
import responseHandler from "./utils/responseHandler.js";
import Queue from "bull";
import { parseCSV, parseExcel } from "./utils/fileParser.js";
import backlinkRouter from "./features/backlink/routes.js";
import domainRouter from "./features/domain/routes.js";
import adminRouter from "./features/admin/routes.js";
import authRouter from "./features/Auth/routes.js";
// import { processingQueue } from "./queues/index.js";
// import { processingQueue  } from "./queues/index.js";

const app = express();
const PORT = process.env.PORT || 8002;

app.use(helmet());

app.use(
  cors({
    origin: "*", // Allow all origins (adjust as needed)
    methods: ["GET", "POST", "PUT", "DELETE"],
    // allowedHeaders: ["Content-Type"],
  })
);

app.use(express.json());

// Sample Route
// app.get("/",handleCSVUpload, async (req, res) => {
//   let data;

// console.log(data,"DATSTDSTD SEND")
//   responseHandler.success(res,{fileResponse:req.file,data},"File upload successful")
// });

// app.use("/user",)
app.use("/backlinks", backlinkRouter);

app.use("/domain", domainRouter);

app.use("/admin", adminRouter);

app.use("/user", authRouter);

// Function to clear the queue on application start
// async function clearQueueOnStartup() {
//   try {
//     // Clear all jobs from the queue (both waiting and active jobs)
//     await processingQueue.empty();
//     // await saveToDbQueue.empty();
//     console.log("Queue has been cleared.");
//   } catch (err) {
//     console.error("Error clearing queue:", err);
//   }
// }

// Invoke the clearQueueOnStartup function when the app starts
// clearQueueOnStartup();



app.listen(PORT, () => {
  console.log(`🚀 Server running on http://localhost:${PORT}`);
});
