
Object.defineProperty(exports, "__esModule", { value: true });

const {
  PrismaClientKnownRequestError,
  PrismaClientUnknownRequestError,
  PrismaClientRustPanicError,
  PrismaClientInitializationError,
  PrismaClientValidationError,
  getPrismaClient,
  sqltag,
  empty,
  join,
  raw,
  skip,
  Decimal,
  Debug,
  objectEnumValues,
  makeStrictEnum,
  Extensions,
  warnOnce,
  defineDmmfProperty,
  Public,
  getRuntime,
  createParam,
} = require('./runtime/library.js')


const Prisma = {}

exports.Prisma = Prisma
exports.$Enums = {}

/**
 * Prisma Client JS version: 6.4.1
 * Query Engine version: a9055b89e58b4b5bfb59600785423b1db3d0e75d
 */
Prisma.prismaVersion = {
  client: "6.4.1",
  engine: "a9055b89e58b4b5bfb59600785423b1db3d0e75d"
}

Prisma.PrismaClientKnownRequestError = PrismaClientKnownRequestError;
Prisma.PrismaClientUnknownRequestError = PrismaClientUnknownRequestError
Prisma.PrismaClientRustPanicError = PrismaClientRustPanicError
Prisma.PrismaClientInitializationError = PrismaClientInitializationError
Prisma.PrismaClientValidationError = PrismaClientValidationError
Prisma.Decimal = Decimal

/**
 * Re-export of sql-template-tag
 */
Prisma.sql = sqltag
Prisma.empty = empty
Prisma.join = join
Prisma.raw = raw
Prisma.validator = Public.validator

/**
* Extensions
*/
Prisma.getExtensionContext = Extensions.getExtensionContext
Prisma.defineExtension = Extensions.defineExtension

/**
 * Shorthand utilities for JSON filtering
 */
Prisma.DbNull = objectEnumValues.instances.DbNull
Prisma.JsonNull = objectEnumValues.instances.JsonNull
Prisma.AnyNull = objectEnumValues.instances.AnyNull

Prisma.NullTypes = {
  DbNull: objectEnumValues.classes.DbNull,
  JsonNull: objectEnumValues.classes.JsonNull,
  AnyNull: objectEnumValues.classes.AnyNull
}




  const path = require('path')

/**
 * Enums
 */
exports.Prisma.Schema__ScalarFieldEnum = {
  id: 'id',
  name: 'name'
};

exports.Prisma.AccountScalarFieldEnum = {
  id: 'id',
  account_status: 'account_status',
  date_joined: 'date_joined',
  email: 'email',
  id_: 'id_',
  is_active: 'is_active',
  is_admin: 'is_admin',
  is_staff: 'is_staff',
  is_superuser: 'is_superuser',
  last_home_visit: 'last_home_visit',
  last_login: 'last_login',
  last_logout: 'last_logout',
  password: 'password',
  username: 'username'
};

exports.Prisma.Account_trackerScalarFieldEnum = {
  id: 'id',
  city: 'city',
  client_agent: 'client_agent',
  client_ip: 'client_ip',
  country: 'country',
  country_code: 'country_code',
  created_date: 'created_date',
  fb_user_id: 'fb_user_id',
  id_: 'id_',
  mobile: 'mobile',
  modified_date: 'modified_date',
  other_info: 'other_info',
  region: 'region',
  status: 'status',
  time_zone: 'time_zone',
  user_automation_time: 'user_automation_time'
};

exports.Prisma.AccountusageScalarFieldEnum = {
  mongoId: 'mongoId',
  fb_user_id: 'fb_user_id',
  id: 'id'
};

exports.Prisma.Auth_groupScalarFieldEnum = {
  mongoId: 'mongoId',
  id: 'id',
  name: 'name'
};

exports.Prisma.Auth_group_permissionsScalarFieldEnum = {
  mongoId: 'mongoId',
  group_id: 'group_id',
  id: 'id',
  permission_id: 'permission_id'
};

exports.Prisma.Auth_permissionScalarFieldEnum = {
  id: 'id',
  codename: 'codename',
  content_type_id: 'content_type_id',
  id_: 'id_',
  name: 'name'
};

exports.Prisma.Authtoken_tokenScalarFieldEnum = {
  id: 'id',
  created: 'created',
  key: 'key',
  user_id: 'user_id'
};

exports.Prisma.CompetitorsScalarFieldEnum = {
  id: 'id',
  created_date: 'created_date',
  fk_group_id: 'fk_group_id',
  fk_user_id: 'fk_user_id',
  id_: 'id_',
  modified_date: 'modified_date',
  track_status: 'track_status',
  url: 'url'
};

exports.Prisma.Django_admin_logScalarFieldEnum = {
  mongoId: 'mongoId',
  content_type_id: 'content_type_id',
  id: 'id',
  user_id: 'user_id'
};

exports.Prisma.Django_content_typeScalarFieldEnum = {
  id: 'id',
  app_label: 'app_label',
  id_: 'id_',
  model: 'model'
};

exports.Prisma.Django_migrationsScalarFieldEnum = {
  id: 'id',
  app: 'app',
  applied: 'applied',
  id_: 'id_',
  name: 'name'
};

exports.Prisma.Django_sessionScalarFieldEnum = {
  id: 'id',
  expire_date: 'expire_date',
  session_key: 'session_key'
};

exports.Prisma.GroupScalarFieldEnum = {
  id: 'id',
  created_date: 'created_date',
  domain_name: 'domain_name',
  downtrend_cnt: 'downtrend_cnt',
  fk_user_id: 'fk_user_id',
  group_call_end: 'group_call_end',
  group_call_start: 'group_call_start',
  group_call_status: 'group_call_status',
  group_name: 'group_name',
  id_: 'id_',
  keyword_difficulty: 'keyword_difficulty',
  metric_status: 'metric_status',
  project_automation_time: 'project_automation_time',
  track_status: 'track_status',
  updated_date: 'updated_date',
  uptrend_cnt: 'uptrend_cnt'
};

exports.Prisma.KeywordScalarFieldEnum = {
  id: 'id',
  auto_call_status: 'auto_call_status',
  auto_refresh_count: 'auto_refresh_count',
  cpc: 'cpc',
  crawlurl: 'crawlurl',
  created_date: 'created_date',
  daymark: 'daymark',
  dayval: 'dayval',
  exactdomain: 'exactdomain',
  fk_group_id: 'fk_group_id',
  fk_user_id: 'fk_user_id',
  halfmonthmark: 'halfmonthmark',
  halfmonthval: 'halfmonthval',
  id_: 'id_',
  isocode: 'isocode',
  keyword: 'keyword',
  keyword_difficulty: 'keyword_difficulty',
  keyword_suggestions: 'keyword_suggestions',
  language: 'language',
  language_code: 'language_code',
  lastranked_date: 'lastranked_date',
  location: 'location',
  location_code: 'location_code',
  metric_status: 'metric_status',
  modified_date: 'modified_date',
  monthmark: 'monthmark',
  monthval: 'monthval',
  page_uuid: 'page_uuid',
  page_uuid_url: 'page_uuid_url',
  platform: 'platform',
  rank: 'rank',
  rank_sincestart: 'rank_sincestart',
  rank_trend: 'rank_trend',
  ranked_url: 'ranked_url',
  ranknow: 'ranknow',
  region: 'region',
  search_intent: 'search_intent',
  search_volume: 'search_volume',
  site_url: 'site_url',
  status_from_start: 'status_from_start',
  target: 'target',
  top_rank: 'top_rank',
  track_status: 'track_status',
  traffic: 'traffic',
  updated_date: 'updated_date',
  weekmark: 'weekmark',
  weekval: 'weekval'
};

exports.Prisma.Keyword_metricsScalarFieldEnum = {
  mongoId: 'mongoId',
  fk_group_id: 'fk_group_id',
  fk_keyword_id: 'fk_keyword_id',
  fk_user_id: 'fk_user_id',
  id: 'id'
};

exports.Prisma.LanguageScalarFieldEnum = {
  id: 'id',
  created_date: 'created_date',
  id_: 'id_',
  language_code: 'language_code',
  language_name: 'language_name',
  updated_date: 'updated_date'
};

exports.Prisma.MainsettingsScalarFieldEnum = {
  mongoId: 'mongoId',
  id: 'id'
};

exports.Prisma.RegionScalarFieldEnum = {
  id: 'id',
  created_date: 'created_date',
  id_: 'id_',
  region_code: 'region_code',
  region_country: 'region_country',
  region_name: 'region_name',
  searchvolume_country_id: 'searchvolume_country_id',
  updated_date: 'updated_date'
};

exports.Prisma.SortOrder = {
  asc: 'asc',
  desc: 'desc'
};

exports.Prisma.QueryMode = {
  default: 'default',
  insensitive: 'insensitive'
};


exports.Prisma.ModelName = {
  schema__: 'schema__',
  account: 'account',
  account_tracker: 'account_tracker',
  accountusage: 'accountusage',
  auth_group: 'auth_group',
  auth_group_permissions: 'auth_group_permissions',
  auth_permission: 'auth_permission',
  authtoken_token: 'authtoken_token',
  competitors: 'competitors',
  django_admin_log: 'django_admin_log',
  django_content_type: 'django_content_type',
  django_migrations: 'django_migrations',
  django_session: 'django_session',
  Group: 'Group',
  keyword: 'keyword',
  keyword_metrics: 'keyword_metrics',
  language: 'language',
  mainsettings: 'mainsettings',
  region: 'region'
};
/**
 * Create the Client
 */
const config = {
  "generator": {
    "name": "client",
    "provider": {
      "fromEnvVar": null,
      "value": "prisma-client-js"
    },
    "output": {
      "value": "/home/rs/Projects/Inhouse/theseotrends-backend/prisma/generated/mongo-client",
      "fromEnvVar": null
    },
    "config": {
      "engineType": "library"
    },
    "binaryTargets": [
      {
        "fromEnvVar": null,
        "value": "debian-openssl-3.0.x",
        "native": true
      }
    ],
    "previewFeatures": [],
    "sourceFilePath": "/home/rs/Projects/Inhouse/theseotrends-backend/prisma/schema3/schema3.prisma",
    "isCustomOutput": true
  },
  "relativeEnvPaths": {
    "rootEnvPath": null,
    "schemaEnvPath": "../../../.env"
  },
  "relativePath": "../../schema3",
  "clientVersion": "6.4.1",
  "engineVersion": "a9055b89e58b4b5bfb59600785423b1db3d0e75d",
  "datasourceNames": [
    "db"
  ],
  "activeProvider": "mongodb",
  "postinstall": false,
  "inlineDatasources": {
    "db": {
      "url": {
        "fromEnvVar": "LOCAL_MONGO_URL",
        "value": null
      }
    }
  },
  "inlineSchema": "generator client {\n  provider = \"prisma-client-js\"\n  output   = \"../generated/mongo-client\"\n}\n\ndatasource db {\n  provider = \"mongodb\"\n  url      = env(\"LOCAL_MONGO_URL\")\n}\n\ntype CompetitorsKeywords {\n  keyword String\n  rank    Int\n}\n\ntype KeywordRankHistory {\n  date  Int\n  month Int\n  rank  Int\n  year  Int\n}\n\ntype KeywordSearchVolumeData {\n  month         Int\n  search_volume Int\n  year          Int\n}\n\ntype SchemaAuto {\n  field_names String[]\n  seq         Int\n}\n\ntype SchemaFields {\n  account_status           SchemaFieldsAccountStatus?\n  action_flag              SchemaFieldsActionFlag?\n  action_time              SchemaFieldsActionTime?\n  app                      SchemaFieldsApp?\n  app_label                SchemaFieldsAppLabel?\n  applied                  SchemaFieldsApplied?\n  auto_call_status         SchemaFieldsAutoCallStatus?\n  auto_refresh_count       SchemaFieldsAutoRefreshCount?\n  change_message           SchemaFieldsChangeMessage?\n  city                     SchemaFieldsCity?\n  client_agent             SchemaFieldsClientAgent?\n  client_ip                SchemaFieldsClientIp?\n  codename                 SchemaFieldsCodename?\n  content_type_id          SchemaFieldsContentTypeId?\n  core_manual_mail         SchemaFieldsCoreManualMail?\n  core_mode                SchemaFieldsCoreMode?\n  core_refresh_time        SchemaFieldsCoreRefreshTime?\n  country                  SchemaFieldsCountry?\n  country_code             SchemaFieldsCountryCode?\n  cpc                      SchemaFieldsCpc?\n  crawlurl                 SchemaFieldsCrawlurl?\n  created                  SchemaFieldsCreated?\n  created_date             SchemaFieldsCreatedDate?\n  date_joined              SchemaFieldsDateJoined?\n  daymark                  SchemaFieldsDaymark?\n  dayval                   SchemaFieldsDayval?\n  domain_name              SchemaFieldsDomainName?\n  downtrend_cnt            SchemaFieldsDowntrendCnt?\n  email                    SchemaFieldsEmail?\n  exactdomain              SchemaFieldsExactdomain?\n  expire_date              SchemaFieldsExpireDate?\n  fb_user_id               SchemaFieldsFbUserId?\n  fk_group_id              SchemaFieldsFkGroupId?\n  fk_keyword_id            SchemaFieldsFkKeywordId?\n  fk_user_id               SchemaFieldsFkUserId?\n  group_call_end           SchemaFieldsGroupCallEnd?\n  group_call_start         SchemaFieldsGroupCallStart?\n  group_call_status        SchemaFieldsGroupCallStatus?\n  group_id                 SchemaFieldsGroupId?\n  group_name               SchemaFieldsGroupName?\n  halfmonthmark            SchemaFieldsHalfmonthmark?\n  halfmonthval             SchemaFieldsHalfmonthval?\n  id                       SchemaFieldsId?\n  is_active                SchemaFieldsIsActive?\n  is_admin                 SchemaFieldsIsAdmin?\n  is_staff                 SchemaFieldsIsStaff?\n  is_superuser             SchemaFieldsIsSuperuser?\n  isocode                  SchemaFieldsIsocode?\n  key                      SchemaFieldsKey?\n  keyword                  SchemaFieldsKeyword?\n  keyword_difficulty       SchemaFieldsKeywordDifficulty?\n  keyword_slug             SchemaFieldsKeywordSlug?\n  language                 SchemaFieldsLanguage?\n  language_code            SchemaFieldsLanguageCode?\n  language_name            SchemaFieldsLanguageName?\n  last_home_visit          SchemaFieldsLastHomeVisit?\n  last_login               SchemaFieldsLastLogin?\n  last_logout              SchemaFieldsLastLogout?\n  lastranked_date          SchemaFieldsLastrankedDate?\n  location                 SchemaFieldsLocation?\n  location_code            SchemaFieldsLocationCode?\n  metric_status            SchemaFieldsMetricStatus?\n  mobile                   SchemaFieldsMobile?\n  model                    SchemaFieldsModel?\n  modified_date            SchemaFieldsModifiedDate?\n  monthmark                SchemaFieldsMonthmark?\n  monthval                 SchemaFieldsMonthval?\n  name                     SchemaFieldsName?\n  object_id                SchemaFieldsObjectId?\n  object_repr              SchemaFieldsObjectRepr?\n  page_uuid                SchemaFieldsPageUuid?\n  page_uuid_url            SchemaFieldsPageUuidUrl?\n  password                 SchemaFieldsPassword?\n  permission_id            SchemaFieldsPermissionId?\n  plan_keyword_limit       SchemaFieldsPlanKeywordLimit?\n  plan_project_limit       SchemaFieldsPlanProjectLimit?\n  platform                 SchemaFieldsPlatform?\n  project_automation_time  SchemaFieldsProjectAutomationTime?\n  proxy_exceeds_count      SchemaFieldsProxyExceedsCount?\n  proxy_invalid_count      SchemaFieldsProxyInvalidCount?\n  proxy_maximum_load_limit SchemaFieldsProxyMaximumLoadLimit?\n  proxy_reset_counter      SchemaFieldsProxyResetCounter?\n  proxy_success_count      SchemaFieldsProxySuccessCount?\n  rank_sincestart          SchemaFieldsRankSincestart?\n  rank_trend               SchemaFieldsRankTrend?\n  ranked_url               SchemaFieldsRankedUrl?\n  ranknow                  SchemaFieldsRanknow?\n  region                   SchemaFieldsRegion?\n  region_code              SchemaFieldsRegionCode?\n  region_country           SchemaFieldsRegionCountry?\n  region_name              SchemaFieldsRegionName?\n  results_per_page         SchemaFieldsResultsPerPage?\n  search_intent            SchemaFieldsSearchIntent?\n  search_volume            SchemaFieldsSearchVolume?\n  searchvolume_country_id  SchemaFieldsSearchvolumeCountryId?\n  session_data             SchemaFieldsSessionData?\n  session_key              SchemaFieldsSessionKey?\n  site_url                 SchemaFieldsSiteUrl?\n  status                   SchemaFieldsStatus?\n  status_from_start        SchemaFieldsStatusFromStart?\n  target                   SchemaFieldsTarget?\n  time_zone                SchemaFieldsTimeZone?\n  top_rank                 SchemaFieldsTopRank?\n  track_status             SchemaFieldsTrackStatus?\n  traffic                  SchemaFieldsTraffic?\n  updated_date             SchemaFieldsUpdatedDate?\n  uptrend_cnt              SchemaFieldsUptrendCnt?\n  url                      SchemaFieldsUrl?\n  user_automation_time     SchemaFieldsUserAutomationTime?\n  user_id                  SchemaFieldsUserId?\n  username                 SchemaFieldsUsername?\n  weekmark                 SchemaFieldsWeekmark?\n  weekval                  SchemaFieldsWeekval?\n}\n\ntype SchemaFieldsAccountStatus {\n  type_code String\n}\n\ntype SchemaFieldsActionFlag {\n  type_code String\n}\n\ntype SchemaFieldsActionTime {\n  type_code String\n}\n\ntype SchemaFieldsApp {\n  type_code String\n}\n\ntype SchemaFieldsAppLabel {\n  type_code String\n}\n\ntype SchemaFieldsApplied {\n  type_code String\n}\n\ntype SchemaFieldsAutoCallStatus {\n  type_code String\n}\n\ntype SchemaFieldsAutoRefreshCount {\n  type_code String\n}\n\ntype SchemaFieldsChangeMessage {\n  type_code String\n}\n\ntype SchemaFieldsCity {\n  type_code String\n}\n\ntype SchemaFieldsClientAgent {\n  type_code String\n}\n\ntype SchemaFieldsClientIp {\n  type_code String\n}\n\ntype SchemaFieldsCodename {\n  type_code String\n}\n\ntype SchemaFieldsContentTypeId {\n  type_code String\n}\n\ntype SchemaFieldsCoreManualMail {\n  type_code String\n}\n\ntype SchemaFieldsCoreMode {\n  type_code String\n}\n\ntype SchemaFieldsCoreRefreshTime {\n  type_code String\n}\n\ntype SchemaFieldsCountry {\n  type_code String\n}\n\ntype SchemaFieldsCountryCode {\n  type_code String\n}\n\ntype SchemaFieldsCpc {\n  type_code String\n}\n\ntype SchemaFieldsCrawlurl {\n  type_code String\n}\n\ntype SchemaFieldsCreated {\n  type_code String\n}\n\ntype SchemaFieldsCreatedDate {\n  type_code String\n}\n\ntype SchemaFieldsDateJoined {\n  type_code String\n}\n\ntype SchemaFieldsDaymark {\n  type_code String\n}\n\ntype SchemaFieldsDayval {\n  type_code String\n}\n\ntype SchemaFieldsDomainName {\n  type_code String\n}\n\ntype SchemaFieldsDowntrendCnt {\n  type_code String\n}\n\ntype SchemaFieldsEmail {\n  type_code String\n}\n\ntype SchemaFieldsExactdomain {\n  type_code String\n}\n\ntype SchemaFieldsExpireDate {\n  type_code String\n}\n\ntype SchemaFieldsFbUserId {\n  type_code String\n}\n\ntype SchemaFieldsFkGroupId {\n  type_code String\n}\n\ntype SchemaFieldsFkKeywordId {\n  type_code String\n}\n\ntype SchemaFieldsFkUserId {\n  type_code String\n}\n\ntype SchemaFieldsGroupCallEnd {\n  type_code String\n}\n\ntype SchemaFieldsGroupCallStart {\n  type_code String\n}\n\ntype SchemaFieldsGroupCallStatus {\n  type_code String\n}\n\ntype SchemaFieldsGroupId {\n  type_code String\n}\n\ntype SchemaFieldsGroupName {\n  type_code String\n}\n\ntype SchemaFieldsHalfmonthmark {\n  type_code String\n}\n\ntype SchemaFieldsHalfmonthval {\n  type_code String\n}\n\ntype SchemaFieldsId {\n  type_code String\n}\n\ntype SchemaFieldsIsActive {\n  type_code String\n}\n\ntype SchemaFieldsIsAdmin {\n  type_code String\n}\n\ntype SchemaFieldsIsStaff {\n  type_code String\n}\n\ntype SchemaFieldsIsSuperuser {\n  type_code String\n}\n\ntype SchemaFieldsIsocode {\n  type_code String\n}\n\ntype SchemaFieldsKey {\n  type_code String\n}\n\ntype SchemaFieldsKeyword {\n  type_code String\n}\n\ntype SchemaFieldsKeywordDifficulty {\n  type_code String?\n}\n\ntype SchemaFieldsKeywordSlug {\n  type_code String\n}\n\ntype SchemaFieldsLanguage {\n  type_code String\n}\n\ntype SchemaFieldsLanguageCode {\n  type_code String\n}\n\ntype SchemaFieldsLanguageName {\n  type_code String\n}\n\ntype SchemaFieldsLastHomeVisit {\n  type_code String\n}\n\ntype SchemaFieldsLastLogin {\n  type_code String\n}\n\ntype SchemaFieldsLastLogout {\n  type_code String\n}\n\ntype SchemaFieldsLastrankedDate {\n  type_code String\n}\n\ntype SchemaFieldsLocation {\n  type_code String\n}\n\ntype SchemaFieldsLocationCode {\n  type_code String\n}\n\ntype SchemaFieldsMetricStatus {\n  /// Could not determine type: the field only had null or empty values in the sample set.\n  type_code Json?\n}\n\ntype SchemaFieldsMobile {\n  type_code String\n}\n\ntype SchemaFieldsModel {\n  type_code String\n}\n\ntype SchemaFieldsModifiedDate {\n  type_code String\n}\n\ntype SchemaFieldsMonthmark {\n  type_code String\n}\n\ntype SchemaFieldsMonthval {\n  type_code String\n}\n\ntype SchemaFieldsName {\n  type_code String\n}\n\ntype SchemaFieldsObjectId {\n  type_code String\n}\n\ntype SchemaFieldsObjectRepr {\n  type_code String\n}\n\ntype SchemaFieldsPageUuid {\n  type_code String\n}\n\ntype SchemaFieldsPageUuidUrl {\n  type_code String\n}\n\ntype SchemaFieldsPassword {\n  type_code String\n}\n\ntype SchemaFieldsPermissionId {\n  type_code String\n}\n\ntype SchemaFieldsPlanKeywordLimit {\n  type_code String\n}\n\ntype SchemaFieldsPlanProjectLimit {\n  type_code String\n}\n\ntype SchemaFieldsPlatform {\n  type_code String\n}\n\ntype SchemaFieldsProjectAutomationTime {\n  type_code String\n}\n\ntype SchemaFieldsProxyExceedsCount {\n  type_code String\n}\n\ntype SchemaFieldsProxyInvalidCount {\n  type_code String\n}\n\ntype SchemaFieldsProxyMaximumLoadLimit {\n  type_code String\n}\n\ntype SchemaFieldsProxyResetCounter {\n  type_code String\n}\n\ntype SchemaFieldsProxySuccessCount {\n  type_code String\n}\n\ntype SchemaFieldsRankSincestart {\n  type_code String\n}\n\ntype SchemaFieldsRankTrend {\n  /// Could not determine type: the field only had null or empty values in the sample set.\n  type_code Json?\n}\n\ntype SchemaFieldsRankedUrl {\n  /// Could not determine type: the field only had null or empty values in the sample set.\n  type_code Json?\n}\n\ntype SchemaFieldsRanknow {\n  type_code String\n}\n\ntype SchemaFieldsRegion {\n  type_code String\n}\n\ntype SchemaFieldsRegionCode {\n  type_code String\n}\n\ntype SchemaFieldsRegionCountry {\n  type_code String\n}\n\ntype SchemaFieldsRegionName {\n  type_code String\n}\n\ntype SchemaFieldsResultsPerPage {\n  type_code String\n}\n\ntype SchemaFieldsSearchIntent {\n  /// Could not determine type: the field only had null or empty values in the sample set.\n  type_code Json?\n}\n\ntype SchemaFieldsSearchVolume {\n  /// Could not determine type: the field only had null or empty values in the sample set.\n  type_code Json?\n}\n\ntype SchemaFieldsSearchvolumeCountryId {\n  type_code String\n}\n\ntype SchemaFieldsSessionData {\n  type_code String\n}\n\ntype SchemaFieldsSessionKey {\n  type_code String\n}\n\ntype SchemaFieldsSiteUrl {\n  type_code String\n}\n\ntype SchemaFieldsStatus {\n  type_code String\n}\n\ntype SchemaFieldsStatusFromStart {\n  type_code String\n}\n\ntype SchemaFieldsTarget {\n  type_code String\n}\n\ntype SchemaFieldsTimeZone {\n  type_code String\n}\n\ntype SchemaFieldsTopRank {\n  type_code String\n}\n\ntype SchemaFieldsTrackStatus {\n  type_code String\n}\n\ntype SchemaFieldsTraffic {\n  /// Could not determine type: the field only had null or empty values in the sample set.\n  type_code Json?\n}\n\ntype SchemaFieldsUpdatedDate {\n  type_code String\n}\n\ntype SchemaFieldsUptrendCnt {\n  type_code String\n}\n\ntype SchemaFieldsUrl {\n  type_code String\n}\n\ntype SchemaFieldsUserAutomationTime {\n  type_code String\n}\n\ntype SchemaFieldsUserId {\n  type_code String\n}\n\ntype SchemaFieldsUsername {\n  type_code String\n}\n\ntype SchemaFieldsWeekmark {\n  type_code String\n}\n\ntype SchemaFieldsWeekval {\n  type_code String\n}\n\nmodel schema__ {\n  id     String       @id @default(auto()) @map(\"_id\") @db.ObjectId\n  auto   SchemaAuto?\n  fields SchemaFields\n  name   String       @unique(map: \"name_1\")\n\n  @@index([auto], map: \"auto_1\")\n  @@map(\"__schema__\")\n}\n\nmodel account {\n  id              String   @id @default(auto()) @map(\"_id\") @db.ObjectId\n  account_status  String\n  date_joined     DateTime @db.Date\n  email           String   @unique(map: \"email_1\")\n  id_             Int      @unique(map: \"__primary_key__\") @map(\"id\")\n  is_active       Boolean\n  is_admin        Boolean\n  is_staff        Boolean\n  is_superuser    Boolean\n  /// Could not determine type: the field only had null or empty values in the sample set.\n  last_home_visit Json?\n  last_login      DateTime @db.Date\n  last_logout     DateTime @db.Date\n  password        String\n  username        String\n}\n\nmodel account_tracker {\n  id                   String   @id @default(auto()) @map(\"_id\") @db.ObjectId\n  /// Could not determine type: the field only had null or empty values in the sample set.\n  city                 Json?\n  client_agent         String\n  client_ip            String\n  /// Could not determine type: the field only had null or empty values in the sample set.\n  country              Json?\n  /// Could not determine type: the field only had null or empty values in the sample set.\n  country_code         Json?\n  created_date         DateTime @db.Date\n  fb_user_id           Int\n  id_                  Int      @unique(map: \"__primary_key__\") @map(\"id\")\n  mobile               Boolean\n  modified_date        DateTime @db.Date\n  /// Nested objects had no data in the sample dataset to introspect a nested type.\n  other_info           Json\n  /// Could not determine type: the field only had null or empty values in the sample set.\n  region               Json?\n  status               String\n  /// Could not determine type: the field only had null or empty values in the sample set.\n  time_zone            Json?\n  /// Could not determine type: the field only had null or empty values in the sample set.\n  user_automation_time Json?\n\n  @@index([fb_user_id], map: \"account_tracker_fb_user_id_2f32bb90\")\n}\n\nmodel accountusage {\n  mongoId    String @id @default(auto()) @map(\"_id\") @db.ObjectId\n  /// Field referred in an index, but found no data to define the type.\n  fb_user_id Json?\n  /// Field referred in an index, but found no data to define the type.\n  id         Json?  @unique(map: \"__primary_key__\")\n\n  @@index([fb_user_id], map: \"accountusage_fb_user_id_8a5060db\")\n}\n\nmodel auth_group {\n  mongoId String @id @default(auto()) @map(\"_id\") @db.ObjectId\n  /// Field referred in an index, but found no data to define the type.\n  id      Json?  @unique(map: \"__primary_key__\")\n  /// Field referred in an index, but found no data to define the type.\n  name    Json?  @unique(map: \"name_1\")\n}\n\nmodel auth_group_permissions {\n  mongoId       String @id @default(auto()) @map(\"_id\") @db.ObjectId\n  /// Field referred in an index, but found no data to define the type.\n  group_id      Json?\n  /// Field referred in an index, but found no data to define the type.\n  id            Json?  @unique(map: \"__primary_key__\")\n  /// Field referred in an index, but found no data to define the type.\n  permission_id Json?\n\n  @@unique([group_id, permission_id], map: \"auth_group_permissions_group_id_permission_id_0cd325b0_uniq\")\n  @@index([group_id], map: \"auth_group_permissions_group_id_b120cbf9\")\n  @@index([permission_id], map: \"auth_group_permissions_permission_id_84c5c92e\")\n}\n\nmodel auth_permission {\n  id              String @id @default(auto()) @map(\"_id\") @db.ObjectId\n  codename        String\n  content_type_id Int\n  id_             Int    @unique(map: \"__primary_key__\") @map(\"id\")\n  name            String\n\n  @@unique([content_type_id, codename], map: \"auth_permission_content_type_id_codename_01ab375a_uniq\")\n  @@index([content_type_id], map: \"auth_permission_content_type_id_2f476e4b\")\n}\n\nmodel authtoken_token {\n  id      String   @id @default(auto()) @map(\"_id\") @db.ObjectId\n  created DateTime @db.Date\n  key     String   @unique(map: \"__primary_key__\")\n  user_id Int      @unique(map: \"user_id_1\")\n}\n\nmodel competitors {\n  id            String                @id @default(auto()) @map(\"_id\") @db.ObjectId\n  created_date  DateTime              @db.Date\n  fk_group_id   Int\n  fk_user_id    Int\n  id_           Int                   @map(\"id\")\n  keywords      CompetitorsKeywords[]\n  modified_date DateTime              @db.Date\n  track_status  String\n  url           String\n}\n\nmodel django_admin_log {\n  mongoId         String @id @default(auto()) @map(\"_id\") @db.ObjectId\n  /// Field referred in an index, but found no data to define the type.\n  content_type_id Json?\n  /// Field referred in an index, but found no data to define the type.\n  id              Json?  @unique(map: \"__primary_key__\")\n  /// Field referred in an index, but found no data to define the type.\n  user_id         Json?\n\n  @@index([content_type_id], map: \"django_admin_log_content_type_id_c4bce8eb\")\n  @@index([user_id], map: \"django_admin_log_user_id_c564eba6\")\n}\n\nmodel django_content_type {\n  id        String @id @default(auto()) @map(\"_id\") @db.ObjectId\n  app_label String\n  id_       Int    @unique(map: \"__primary_key__\") @map(\"id\")\n  model     String\n\n  @@unique([app_label, model], map: \"django_content_type_app_label_model_76bd3d3b_uniq\")\n}\n\nmodel django_migrations {\n  id      String   @id @default(auto()) @map(\"_id\") @db.ObjectId\n  app     String\n  applied DateTime @db.Date\n  id_     Int      @unique(map: \"__primary_key__\") @map(\"id\")\n  name    String\n}\n\nmodel django_session {\n  id          String @id @default(auto()) @map(\"_id\") @db.ObjectId\n  /// Field referred in an index, but found no data to define the type.\n  expire_date Json?\n  /// Field referred in an index, but found no data to define the type.\n  session_key Json?  @unique(map: \"__primary_key__\")\n\n  @@index([expire_date], map: \"django_session_expire_date_a5c62663\")\n}\n\nmodel Group {\n  id                      String   @id @default(auto()) @map(\"_id\") @db.ObjectId\n  created_date            DateTime @db.Date\n  domain_name             String\n  downtrend_cnt           Int\n  fk_user_id              Int\n  group_call_end          DateTime @db.Date\n  group_call_start        DateTime @db.Date\n  group_call_status       String\n  group_name              String\n  id_                     Int      @map(\"id\")\n  keyword_difficulty      String\n  metric_status           String\n  project_automation_time DateTime @db.Date\n  track_status            String\n  updated_date            DateTime @db.Date\n  uptrend_cnt             Int\n\n  @@map(\"group\")\n}\n\nmodel keyword {\n  id                  String                    @id @default(auto()) @map(\"_id\") @db.ObjectId\n  auto_call_status    String\n  auto_refresh_count  Int\n  cpc                 String\n  crawlurl            String\n  created_date        DateTime                  @db.Date\n  daymark             String\n  dayval              Int\n  exactdomain         Boolean\n  fk_group_id         Int\n  fk_user_id          Int\n  halfmonthmark       String\n  halfmonthval        Int\n  id_                 Int                       @map(\"id\")\n  isocode             String\n  keyword             String\n  keyword_difficulty  String?\n  /// Could not determine type: the field only had null or empty values in the sample set.\n  keyword_suggestions Json?\n  language            String\n  language_code       String\n  lastranked_date     DateTime                  @db.Date\n  location            String\n  location_code       Int\n  metric_status       String\n  modified_date       DateTime                  @db.Date\n  monthmark           String\n  monthval            Int\n  page_uuid           String\n  page_uuid_url       String\n  platform            String\n  rank                Int[]\n  rank_history        KeywordRankHistory[]\n  rank_sincestart     Int\n  rank_trend          String\n  ranked_url          String\n  ranknow             Int\n  region              String\n  search_intent       String\n  search_volume       String\n  search_volume_data  KeywordSearchVolumeData[]\n  site_url            String\n  status_from_start   String\n  target              String\n  top_rank            Int\n  track_status        String\n  traffic             String\n  updated_date        DateTime                  @db.Date\n  weekmark            String\n  weekval             Int\n}\n\nmodel keyword_metrics {\n  mongoId       String @id @default(auto()) @map(\"_id\") @db.ObjectId\n  /// Field referred in an index, but found no data to define the type.\n  fk_group_id   Json?\n  /// Field referred in an index, but found no data to define the type.\n  fk_keyword_id Json?\n  /// Field referred in an index, but found no data to define the type.\n  fk_user_id    Json?\n  /// Field referred in an index, but found no data to define the type.\n  id            Json?  @unique(map: \"__primary_key__\")\n\n  @@index([fk_user_id], map: \"keyword_metrics_fk_user_id_b39e01e4\")\n  @@index([fk_group_id], map: \"keyword_metrics_fk_group_id_1d7b1cef\")\n  @@index([fk_keyword_id], map: \"keyword_metrics_fk_keyword_id_12fb90e1\")\n}\n\nmodel language {\n  id            String   @id @default(auto()) @map(\"_id\") @db.ObjectId\n  created_date  DateTime @db.Date\n  id_           Int      @unique(map: \"__primary_key__\") @map(\"id\")\n  language_code String\n  language_name String\n  updated_date  DateTime @db.Date\n}\n\nmodel mainsettings {\n  mongoId String @id @default(auto()) @map(\"_id\") @db.ObjectId\n  /// Field referred in an index, but found no data to define the type.\n  id      Json?  @unique(map: \"__primary_key__\")\n}\n\nmodel region {\n  id                      String   @id @default(auto()) @map(\"_id\") @db.ObjectId\n  created_date            DateTime @db.Date\n  id_                     Float    @unique(map: \"__primary_key__\") @map(\"id\")\n  region_code             String\n  region_country          String\n  region_name             String\n  searchvolume_country_id String?\n  updated_date            DateTime @db.Date\n}\n",
  "inlineSchemaHash": "5b387227d015cba53ab4610b3fab69e77b9ac675db569ef950afd78db1aab4dd",
  "copyEngine": true
}

const fs = require('fs')

config.dirname = __dirname
if (!fs.existsSync(path.join(__dirname, 'schema.prisma'))) {
  const alternativePaths = [
    "prisma/generated/mongo-client",
    "generated/mongo-client",
  ]
  
  const alternativePath = alternativePaths.find((altPath) => {
    return fs.existsSync(path.join(process.cwd(), altPath, 'schema.prisma'))
  }) ?? alternativePaths[0]

  config.dirname = path.join(process.cwd(), alternativePath)
  config.isBundled = true
}

config.runtimeDataModel = JSON.parse("{\"models\":{\"schema__\":{\"dbName\":\"__schema__\",\"schema\":null,\"fields\":[{\"name\":\"id\",\"dbName\":\"_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"nativeType\":[\"ObjectId\",[]],\"default\":{\"name\":\"auto\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"auto\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaAuto\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"fields\",\"kind\":\"object\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFields\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":true,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"account\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"id\",\"dbName\":\"_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"nativeType\":[\"ObjectId\",[]],\"default\":{\"name\":\"auto\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"account_status\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"date_joined\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"nativeType\":[\"Date\",[]],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"email\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":true,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"id_\",\"dbName\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":true,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_active\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Boolean\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_admin\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Boolean\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_staff\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Boolean\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"is_superuser\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Boolean\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"last_home_visit\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Could not determine type: the field only had null or empty values in the sample set.\"},{\"name\":\"last_login\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"nativeType\":[\"Date\",[]],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"last_logout\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"nativeType\":[\"Date\",[]],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"password\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"username\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"account_tracker\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"id\",\"dbName\":\"_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"nativeType\":[\"ObjectId\",[]],\"default\":{\"name\":\"auto\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"city\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Could not determine type: the field only had null or empty values in the sample set.\"},{\"name\":\"client_agent\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"client_ip\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"country\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Could not determine type: the field only had null or empty values in the sample set.\"},{\"name\":\"country_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Could not determine type: the field only had null or empty values in the sample set.\"},{\"name\":\"created_date\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"nativeType\":[\"Date\",[]],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"fb_user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"id_\",\"dbName\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":true,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"mobile\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Boolean\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"modified_date\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"nativeType\":[\"Date\",[]],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"other_info\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Nested objects had no data in the sample dataset to introspect a nested type.\"},{\"name\":\"region\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Could not determine type: the field only had null or empty values in the sample set.\"},{\"name\":\"status\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"time_zone\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Could not determine type: the field only had null or empty values in the sample set.\"},{\"name\":\"user_automation_time\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Could not determine type: the field only had null or empty values in the sample set.\"}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"accountusage\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"mongoId\",\"dbName\":\"_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"nativeType\":[\"ObjectId\",[]],\"default\":{\"name\":\"auto\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"fb_user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Field referred in an index, but found no data to define the type.\"},{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":true,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Field referred in an index, but found no data to define the type.\"}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"auth_group\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"mongoId\",\"dbName\":\"_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"nativeType\":[\"ObjectId\",[]],\"default\":{\"name\":\"auto\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":true,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Field referred in an index, but found no data to define the type.\"},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":true,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Field referred in an index, but found no data to define the type.\"}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"auth_group_permissions\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"mongoId\",\"dbName\":\"_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"nativeType\":[\"ObjectId\",[]],\"default\":{\"name\":\"auto\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"group_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Field referred in an index, but found no data to define the type.\"},{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":true,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Field referred in an index, but found no data to define the type.\"},{\"name\":\"permission_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Field referred in an index, but found no data to define the type.\"}],\"primaryKey\":null,\"uniqueFields\":[[\"group_id\",\"permission_id\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"group_id\",\"permission_id\"]}],\"isGenerated\":false},\"auth_permission\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"id\",\"dbName\":\"_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"nativeType\":[\"ObjectId\",[]],\"default\":{\"name\":\"auto\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"codename\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"content_type_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"id_\",\"dbName\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":true,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"content_type_id\",\"codename\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"content_type_id\",\"codename\"]}],\"isGenerated\":false},\"authtoken_token\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"id\",\"dbName\":\"_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"nativeType\":[\"ObjectId\",[]],\"default\":{\"name\":\"auto\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"nativeType\":[\"Date\",[]],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"key\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":true,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":true,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"competitors\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"id\",\"dbName\":\"_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"nativeType\":[\"ObjectId\",[]],\"default\":{\"name\":\"auto\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_date\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"nativeType\":[\"Date\",[]],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"fk_group_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"fk_user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"id_\",\"dbName\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"keywords\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"CompetitorsKeywords\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"modified_date\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"nativeType\":[\"Date\",[]],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"track_status\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"url\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"django_admin_log\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"mongoId\",\"dbName\":\"_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"nativeType\":[\"ObjectId\",[]],\"default\":{\"name\":\"auto\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"content_type_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Field referred in an index, but found no data to define the type.\"},{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":true,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Field referred in an index, but found no data to define the type.\"},{\"name\":\"user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Field referred in an index, but found no data to define the type.\"}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"django_content_type\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"id\",\"dbName\":\"_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"nativeType\":[\"ObjectId\",[]],\"default\":{\"name\":\"auto\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"app_label\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"id_\",\"dbName\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":true,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"model\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[[\"app_label\",\"model\"]],\"uniqueIndexes\":[{\"name\":null,\"fields\":[\"app_label\",\"model\"]}],\"isGenerated\":false},\"django_migrations\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"id\",\"dbName\":\"_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"nativeType\":[\"ObjectId\",[]],\"default\":{\"name\":\"auto\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"app\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"applied\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"nativeType\":[\"Date\",[]],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"id_\",\"dbName\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":true,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"django_session\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"id\",\"dbName\":\"_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"nativeType\":[\"ObjectId\",[]],\"default\":{\"name\":\"auto\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"expire_date\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Field referred in an index, but found no data to define the type.\"},{\"name\":\"session_key\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":true,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Field referred in an index, but found no data to define the type.\"}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"Group\":{\"dbName\":\"group\",\"schema\":null,\"fields\":[{\"name\":\"id\",\"dbName\":\"_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"nativeType\":[\"ObjectId\",[]],\"default\":{\"name\":\"auto\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_date\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"nativeType\":[\"Date\",[]],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"domain_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"downtrend_cnt\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"fk_user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"group_call_end\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"nativeType\":[\"Date\",[]],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"group_call_start\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"nativeType\":[\"Date\",[]],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"group_call_status\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"group_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"id_\",\"dbName\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"keyword_difficulty\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"metric_status\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"project_automation_time\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"nativeType\":[\"Date\",[]],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"track_status\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_date\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"nativeType\":[\"Date\",[]],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"uptrend_cnt\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"keyword\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"id\",\"dbName\":\"_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"nativeType\":[\"ObjectId\",[]],\"default\":{\"name\":\"auto\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"auto_call_status\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"auto_refresh_count\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"cpc\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"crawlurl\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_date\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"nativeType\":[\"Date\",[]],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"daymark\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"dayval\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"exactdomain\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Boolean\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"fk_group_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"fk_user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"halfmonthmark\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"halfmonthval\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"id_\",\"dbName\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"isocode\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"keyword\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"keyword_difficulty\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"keyword_suggestions\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Could not determine type: the field only had null or empty values in the sample set.\"},{\"name\":\"language\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"language_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"lastranked_date\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"nativeType\":[\"Date\",[]],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"location\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"location_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"metric_status\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"modified_date\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"nativeType\":[\"Date\",[]],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"monthmark\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"monthval\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"page_uuid\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"page_uuid_url\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"platform\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"rank\",\"kind\":\"scalar\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"rank_history\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"KeywordRankHistory\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"rank_sincestart\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"rank_trend\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"ranked_url\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"ranknow\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"region\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"search_intent\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"search_volume\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"search_volume_data\",\"kind\":\"object\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"KeywordSearchVolumeData\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"site_url\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"status_from_start\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"target\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"top_rank\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"track_status\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"traffic\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_date\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"nativeType\":[\"Date\",[]],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"weekmark\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"weekval\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"keyword_metrics\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"mongoId\",\"dbName\":\"_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"nativeType\":[\"ObjectId\",[]],\"default\":{\"name\":\"auto\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"fk_group_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Field referred in an index, but found no data to define the type.\"},{\"name\":\"fk_keyword_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Field referred in an index, but found no data to define the type.\"},{\"name\":\"fk_user_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Field referred in an index, but found no data to define the type.\"},{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":true,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Field referred in an index, but found no data to define the type.\"}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"language\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"id\",\"dbName\":\"_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"nativeType\":[\"ObjectId\",[]],\"default\":{\"name\":\"auto\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_date\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"nativeType\":[\"Date\",[]],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"id_\",\"dbName\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":true,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"language_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"language_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_date\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"nativeType\":[\"Date\",[]],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"mainsettings\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"mongoId\",\"dbName\":\"_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"nativeType\":[\"ObjectId\",[]],\"default\":{\"name\":\"auto\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":true,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false,\"documentation\":\"Field referred in an index, but found no data to define the type.\"}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false},\"region\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"id\",\"dbName\":\"_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":true,\"isReadOnly\":false,\"hasDefaultValue\":true,\"type\":\"String\",\"nativeType\":[\"ObjectId\",[]],\"default\":{\"name\":\"auto\",\"args\":[]},\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"created_date\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"nativeType\":[\"Date\",[]],\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"id_\",\"dbName\":\"id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":true,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Float\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"region_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"region_country\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"region_name\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"searchvolume_country_id\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null,\"isGenerated\":false,\"isUpdatedAt\":false},{\"name\":\"updated_date\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"DateTime\",\"nativeType\":[\"Date\",[]],\"isGenerated\":false,\"isUpdatedAt\":false}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[],\"isGenerated\":false}},\"enums\":{},\"types\":{\"CompetitorsKeywords\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"keyword\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null},{\"name\":\"rank\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"KeywordRankHistory\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"date\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null},{\"name\":\"month\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null},{\"name\":\"rank\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null},{\"name\":\"year\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"KeywordSearchVolumeData\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"month\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null},{\"name\":\"search_volume\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null},{\"name\":\"year\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaAuto\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"field_names\",\"kind\":\"scalar\",\"isList\":true,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null},{\"name\":\"seq\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Int\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFields\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"account_status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsAccountStatus\",\"nativeType\":null},{\"name\":\"action_flag\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsActionFlag\",\"nativeType\":null},{\"name\":\"action_time\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsActionTime\",\"nativeType\":null},{\"name\":\"app\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsApp\",\"nativeType\":null},{\"name\":\"app_label\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsAppLabel\",\"nativeType\":null},{\"name\":\"applied\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsApplied\",\"nativeType\":null},{\"name\":\"auto_call_status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsAutoCallStatus\",\"nativeType\":null},{\"name\":\"auto_refresh_count\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsAutoRefreshCount\",\"nativeType\":null},{\"name\":\"change_message\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsChangeMessage\",\"nativeType\":null},{\"name\":\"city\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsCity\",\"nativeType\":null},{\"name\":\"client_agent\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsClientAgent\",\"nativeType\":null},{\"name\":\"client_ip\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsClientIp\",\"nativeType\":null},{\"name\":\"codename\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsCodename\",\"nativeType\":null},{\"name\":\"content_type_id\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsContentTypeId\",\"nativeType\":null},{\"name\":\"core_manual_mail\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsCoreManualMail\",\"nativeType\":null},{\"name\":\"core_mode\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsCoreMode\",\"nativeType\":null},{\"name\":\"core_refresh_time\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsCoreRefreshTime\",\"nativeType\":null},{\"name\":\"country\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsCountry\",\"nativeType\":null},{\"name\":\"country_code\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsCountryCode\",\"nativeType\":null},{\"name\":\"cpc\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsCpc\",\"nativeType\":null},{\"name\":\"crawlurl\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsCrawlurl\",\"nativeType\":null},{\"name\":\"created\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsCreated\",\"nativeType\":null},{\"name\":\"created_date\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsCreatedDate\",\"nativeType\":null},{\"name\":\"date_joined\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsDateJoined\",\"nativeType\":null},{\"name\":\"daymark\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsDaymark\",\"nativeType\":null},{\"name\":\"dayval\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsDayval\",\"nativeType\":null},{\"name\":\"domain_name\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsDomainName\",\"nativeType\":null},{\"name\":\"downtrend_cnt\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsDowntrendCnt\",\"nativeType\":null},{\"name\":\"email\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsEmail\",\"nativeType\":null},{\"name\":\"exactdomain\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsExactdomain\",\"nativeType\":null},{\"name\":\"expire_date\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsExpireDate\",\"nativeType\":null},{\"name\":\"fb_user_id\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsFbUserId\",\"nativeType\":null},{\"name\":\"fk_group_id\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsFkGroupId\",\"nativeType\":null},{\"name\":\"fk_keyword_id\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsFkKeywordId\",\"nativeType\":null},{\"name\":\"fk_user_id\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsFkUserId\",\"nativeType\":null},{\"name\":\"group_call_end\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsGroupCallEnd\",\"nativeType\":null},{\"name\":\"group_call_start\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsGroupCallStart\",\"nativeType\":null},{\"name\":\"group_call_status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsGroupCallStatus\",\"nativeType\":null},{\"name\":\"group_id\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsGroupId\",\"nativeType\":null},{\"name\":\"group_name\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsGroupName\",\"nativeType\":null},{\"name\":\"halfmonthmark\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsHalfmonthmark\",\"nativeType\":null},{\"name\":\"halfmonthval\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsHalfmonthval\",\"nativeType\":null},{\"name\":\"id\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsId\",\"nativeType\":null},{\"name\":\"is_active\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsIsActive\",\"nativeType\":null},{\"name\":\"is_admin\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsIsAdmin\",\"nativeType\":null},{\"name\":\"is_staff\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsIsStaff\",\"nativeType\":null},{\"name\":\"is_superuser\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsIsSuperuser\",\"nativeType\":null},{\"name\":\"isocode\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsIsocode\",\"nativeType\":null},{\"name\":\"key\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsKey\",\"nativeType\":null},{\"name\":\"keyword\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsKeyword\",\"nativeType\":null},{\"name\":\"keyword_difficulty\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsKeywordDifficulty\",\"nativeType\":null},{\"name\":\"keyword_slug\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsKeywordSlug\",\"nativeType\":null},{\"name\":\"language\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsLanguage\",\"nativeType\":null},{\"name\":\"language_code\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsLanguageCode\",\"nativeType\":null},{\"name\":\"language_name\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsLanguageName\",\"nativeType\":null},{\"name\":\"last_home_visit\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsLastHomeVisit\",\"nativeType\":null},{\"name\":\"last_login\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsLastLogin\",\"nativeType\":null},{\"name\":\"last_logout\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsLastLogout\",\"nativeType\":null},{\"name\":\"lastranked_date\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsLastrankedDate\",\"nativeType\":null},{\"name\":\"location\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsLocation\",\"nativeType\":null},{\"name\":\"location_code\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsLocationCode\",\"nativeType\":null},{\"name\":\"metric_status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsMetricStatus\",\"nativeType\":null},{\"name\":\"mobile\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsMobile\",\"nativeType\":null},{\"name\":\"model\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsModel\",\"nativeType\":null},{\"name\":\"modified_date\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsModifiedDate\",\"nativeType\":null},{\"name\":\"monthmark\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsMonthmark\",\"nativeType\":null},{\"name\":\"monthval\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsMonthval\",\"nativeType\":null},{\"name\":\"name\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsName\",\"nativeType\":null},{\"name\":\"object_id\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsObjectId\",\"nativeType\":null},{\"name\":\"object_repr\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsObjectRepr\",\"nativeType\":null},{\"name\":\"page_uuid\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsPageUuid\",\"nativeType\":null},{\"name\":\"page_uuid_url\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsPageUuidUrl\",\"nativeType\":null},{\"name\":\"password\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsPassword\",\"nativeType\":null},{\"name\":\"permission_id\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsPermissionId\",\"nativeType\":null},{\"name\":\"plan_keyword_limit\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsPlanKeywordLimit\",\"nativeType\":null},{\"name\":\"plan_project_limit\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsPlanProjectLimit\",\"nativeType\":null},{\"name\":\"platform\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsPlatform\",\"nativeType\":null},{\"name\":\"project_automation_time\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsProjectAutomationTime\",\"nativeType\":null},{\"name\":\"proxy_exceeds_count\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsProxyExceedsCount\",\"nativeType\":null},{\"name\":\"proxy_invalid_count\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsProxyInvalidCount\",\"nativeType\":null},{\"name\":\"proxy_maximum_load_limit\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsProxyMaximumLoadLimit\",\"nativeType\":null},{\"name\":\"proxy_reset_counter\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsProxyResetCounter\",\"nativeType\":null},{\"name\":\"proxy_success_count\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsProxySuccessCount\",\"nativeType\":null},{\"name\":\"rank_sincestart\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsRankSincestart\",\"nativeType\":null},{\"name\":\"rank_trend\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsRankTrend\",\"nativeType\":null},{\"name\":\"ranked_url\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsRankedUrl\",\"nativeType\":null},{\"name\":\"ranknow\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsRanknow\",\"nativeType\":null},{\"name\":\"region\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsRegion\",\"nativeType\":null},{\"name\":\"region_code\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsRegionCode\",\"nativeType\":null},{\"name\":\"region_country\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsRegionCountry\",\"nativeType\":null},{\"name\":\"region_name\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsRegionName\",\"nativeType\":null},{\"name\":\"results_per_page\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsResultsPerPage\",\"nativeType\":null},{\"name\":\"search_intent\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsSearchIntent\",\"nativeType\":null},{\"name\":\"search_volume\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsSearchVolume\",\"nativeType\":null},{\"name\":\"searchvolume_country_id\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsSearchvolumeCountryId\",\"nativeType\":null},{\"name\":\"session_data\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsSessionData\",\"nativeType\":null},{\"name\":\"session_key\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsSessionKey\",\"nativeType\":null},{\"name\":\"site_url\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsSiteUrl\",\"nativeType\":null},{\"name\":\"status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsStatus\",\"nativeType\":null},{\"name\":\"status_from_start\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsStatusFromStart\",\"nativeType\":null},{\"name\":\"target\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsTarget\",\"nativeType\":null},{\"name\":\"time_zone\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsTimeZone\",\"nativeType\":null},{\"name\":\"top_rank\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsTopRank\",\"nativeType\":null},{\"name\":\"track_status\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsTrackStatus\",\"nativeType\":null},{\"name\":\"traffic\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsTraffic\",\"nativeType\":null},{\"name\":\"updated_date\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsUpdatedDate\",\"nativeType\":null},{\"name\":\"uptrend_cnt\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsUptrendCnt\",\"nativeType\":null},{\"name\":\"url\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsUrl\",\"nativeType\":null},{\"name\":\"user_automation_time\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsUserAutomationTime\",\"nativeType\":null},{\"name\":\"user_id\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsUserId\",\"nativeType\":null},{\"name\":\"username\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsUsername\",\"nativeType\":null},{\"name\":\"weekmark\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsWeekmark\",\"nativeType\":null},{\"name\":\"weekval\",\"kind\":\"object\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"SchemaFieldsWeekval\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsAccountStatus\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsActionFlag\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsActionTime\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsApp\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsAppLabel\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsApplied\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsAutoCallStatus\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsAutoRefreshCount\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsChangeMessage\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsCity\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsClientAgent\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsClientIp\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsCodename\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsContentTypeId\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsCoreManualMail\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsCoreMode\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsCoreRefreshTime\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsCountry\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsCountryCode\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsCpc\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsCrawlurl\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsCreated\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsCreatedDate\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsDateJoined\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsDaymark\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsDayval\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsDomainName\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsDowntrendCnt\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsEmail\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsExactdomain\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsExpireDate\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsFbUserId\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsFkGroupId\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsFkKeywordId\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsFkUserId\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsGroupCallEnd\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsGroupCallStart\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsGroupCallStatus\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsGroupId\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsGroupName\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsHalfmonthmark\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsHalfmonthval\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsId\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsIsActive\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsIsAdmin\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsIsStaff\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsIsSuperuser\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsIsocode\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsKey\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsKeyword\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsKeywordDifficulty\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsKeywordSlug\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsLanguage\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsLanguageCode\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsLanguageName\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsLastHomeVisit\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsLastLogin\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsLastLogout\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsLastrankedDate\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsLocation\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsLocationCode\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsMetricStatus\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"documentation\":\"Could not determine type: the field only had null or empty values in the sample set.\"}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsMobile\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsModel\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsModifiedDate\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsMonthmark\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsMonthval\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsName\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsObjectId\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsObjectRepr\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsPageUuid\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsPageUuidUrl\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsPassword\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsPermissionId\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsPlanKeywordLimit\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsPlanProjectLimit\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsPlatform\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsProjectAutomationTime\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsProxyExceedsCount\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsProxyInvalidCount\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsProxyMaximumLoadLimit\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsProxyResetCounter\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsProxySuccessCount\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsRankSincestart\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsRankTrend\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"documentation\":\"Could not determine type: the field only had null or empty values in the sample set.\"}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsRankedUrl\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"documentation\":\"Could not determine type: the field only had null or empty values in the sample set.\"}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsRanknow\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsRegion\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsRegionCode\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsRegionCountry\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsRegionName\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsResultsPerPage\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsSearchIntent\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"documentation\":\"Could not determine type: the field only had null or empty values in the sample set.\"}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsSearchVolume\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"documentation\":\"Could not determine type: the field only had null or empty values in the sample set.\"}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsSearchvolumeCountryId\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsSessionData\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsSessionKey\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsSiteUrl\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsStatus\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsStatusFromStart\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsTarget\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsTimeZone\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsTopRank\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsTrackStatus\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsTraffic\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":false,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"Json\",\"nativeType\":null,\"documentation\":\"Could not determine type: the field only had null or empty values in the sample set.\"}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsUpdatedDate\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsUptrendCnt\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsUrl\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsUserAutomationTime\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsUserId\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsUsername\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsWeekmark\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]},\"SchemaFieldsWeekval\":{\"dbName\":null,\"schema\":null,\"fields\":[{\"name\":\"type_code\",\"kind\":\"scalar\",\"isList\":false,\"isRequired\":true,\"isUnique\":false,\"isId\":false,\"isReadOnly\":false,\"hasDefaultValue\":false,\"type\":\"String\",\"nativeType\":null}],\"primaryKey\":null,\"uniqueFields\":[],\"uniqueIndexes\":[]}}}")
defineDmmfProperty(exports.Prisma, config.runtimeDataModel)
config.engineWasm = undefined
config.compilerWasm = undefined


const { warnEnvConflicts } = require('./runtime/library.js')

warnEnvConflicts({
    rootEnvPath: config.relativeEnvPaths.rootEnvPath && path.resolve(config.dirname, config.relativeEnvPaths.rootEnvPath),
    schemaEnvPath: config.relativeEnvPaths.schemaEnvPath && path.resolve(config.dirname, config.relativeEnvPaths.schemaEnvPath)
})

const PrismaClient = getPrismaClient(config)
exports.PrismaClient = PrismaClient
Object.assign(exports, Prisma)

// file annotations for bundling tools to include these files
path.join(__dirname, "libquery_engine-debian-openssl-3.0.x.so.node");
path.join(process.cwd(), "prisma/generated/mongo-client/libquery_engine-debian-openssl-3.0.x.so.node")
// file annotations for bundling tools to include these files
path.join(__dirname, "schema.prisma");
path.join(process.cwd(), "prisma/generated/mongo-client/schema.prisma")
