
/**
 * Client
**/

import * as runtime from './runtime/library.js';
import $Types = runtime.Types // general types
import $Public = runtime.Types.Public
import $Utils = runtime.Types.Utils
import $Extensions = runtime.Types.Extensions
import $Result = runtime.Types.Result

export type PrismaPromise<T> = $Public.PrismaPromise<T>


/**
 * Model CompetitorsKeywords
 * 
 */
export type CompetitorsKeywords = $Result.DefaultSelection<Prisma.$CompetitorsKeywordsPayload>
/**
 * Model KeywordRankHistory
 * 
 */
export type KeywordRankHistory = $Result.DefaultSelection<Prisma.$KeywordRankHistoryPayload>
/**
 * Model KeywordSearchVolumeData
 * 
 */
export type KeywordSearchVolumeData = $Result.DefaultSelection<Prisma.$KeywordSearchVolumeDataPayload>
/**
 * Model SchemaAuto
 * 
 */
export type SchemaAuto = $Result.DefaultSelection<Prisma.$SchemaAutoPayload>
/**
 * Model SchemaFields
 * 
 */
export type SchemaFields = $Result.DefaultSelection<Prisma.$SchemaFieldsPayload>
/**
 * Model SchemaFieldsAccountStatus
 * 
 */
export type SchemaFieldsAccountStatus = $Result.DefaultSelection<Prisma.$SchemaFieldsAccountStatusPayload>
/**
 * Model SchemaFieldsActionFlag
 * 
 */
export type SchemaFieldsActionFlag = $Result.DefaultSelection<Prisma.$SchemaFieldsActionFlagPayload>
/**
 * Model SchemaFieldsActionTime
 * 
 */
export type SchemaFieldsActionTime = $Result.DefaultSelection<Prisma.$SchemaFieldsActionTimePayload>
/**
 * Model SchemaFieldsApp
 * 
 */
export type SchemaFieldsApp = $Result.DefaultSelection<Prisma.$SchemaFieldsAppPayload>
/**
 * Model SchemaFieldsAppLabel
 * 
 */
export type SchemaFieldsAppLabel = $Result.DefaultSelection<Prisma.$SchemaFieldsAppLabelPayload>
/**
 * Model SchemaFieldsApplied
 * 
 */
export type SchemaFieldsApplied = $Result.DefaultSelection<Prisma.$SchemaFieldsAppliedPayload>
/**
 * Model SchemaFieldsAutoCallStatus
 * 
 */
export type SchemaFieldsAutoCallStatus = $Result.DefaultSelection<Prisma.$SchemaFieldsAutoCallStatusPayload>
/**
 * Model SchemaFieldsAutoRefreshCount
 * 
 */
export type SchemaFieldsAutoRefreshCount = $Result.DefaultSelection<Prisma.$SchemaFieldsAutoRefreshCountPayload>
/**
 * Model SchemaFieldsChangeMessage
 * 
 */
export type SchemaFieldsChangeMessage = $Result.DefaultSelection<Prisma.$SchemaFieldsChangeMessagePayload>
/**
 * Model SchemaFieldsCity
 * 
 */
export type SchemaFieldsCity = $Result.DefaultSelection<Prisma.$SchemaFieldsCityPayload>
/**
 * Model SchemaFieldsClientAgent
 * 
 */
export type SchemaFieldsClientAgent = $Result.DefaultSelection<Prisma.$SchemaFieldsClientAgentPayload>
/**
 * Model SchemaFieldsClientIp
 * 
 */
export type SchemaFieldsClientIp = $Result.DefaultSelection<Prisma.$SchemaFieldsClientIpPayload>
/**
 * Model SchemaFieldsCodename
 * 
 */
export type SchemaFieldsCodename = $Result.DefaultSelection<Prisma.$SchemaFieldsCodenamePayload>
/**
 * Model SchemaFieldsContentTypeId
 * 
 */
export type SchemaFieldsContentTypeId = $Result.DefaultSelection<Prisma.$SchemaFieldsContentTypeIdPayload>
/**
 * Model SchemaFieldsCoreManualMail
 * 
 */
export type SchemaFieldsCoreManualMail = $Result.DefaultSelection<Prisma.$SchemaFieldsCoreManualMailPayload>
/**
 * Model SchemaFieldsCoreMode
 * 
 */
export type SchemaFieldsCoreMode = $Result.DefaultSelection<Prisma.$SchemaFieldsCoreModePayload>
/**
 * Model SchemaFieldsCoreRefreshTime
 * 
 */
export type SchemaFieldsCoreRefreshTime = $Result.DefaultSelection<Prisma.$SchemaFieldsCoreRefreshTimePayload>
/**
 * Model SchemaFieldsCountry
 * 
 */
export type SchemaFieldsCountry = $Result.DefaultSelection<Prisma.$SchemaFieldsCountryPayload>
/**
 * Model SchemaFieldsCountryCode
 * 
 */
export type SchemaFieldsCountryCode = $Result.DefaultSelection<Prisma.$SchemaFieldsCountryCodePayload>
/**
 * Model SchemaFieldsCpc
 * 
 */
export type SchemaFieldsCpc = $Result.DefaultSelection<Prisma.$SchemaFieldsCpcPayload>
/**
 * Model SchemaFieldsCrawlurl
 * 
 */
export type SchemaFieldsCrawlurl = $Result.DefaultSelection<Prisma.$SchemaFieldsCrawlurlPayload>
/**
 * Model SchemaFieldsCreated
 * 
 */
export type SchemaFieldsCreated = $Result.DefaultSelection<Prisma.$SchemaFieldsCreatedPayload>
/**
 * Model SchemaFieldsCreatedDate
 * 
 */
export type SchemaFieldsCreatedDate = $Result.DefaultSelection<Prisma.$SchemaFieldsCreatedDatePayload>
/**
 * Model SchemaFieldsDateJoined
 * 
 */
export type SchemaFieldsDateJoined = $Result.DefaultSelection<Prisma.$SchemaFieldsDateJoinedPayload>
/**
 * Model SchemaFieldsDaymark
 * 
 */
export type SchemaFieldsDaymark = $Result.DefaultSelection<Prisma.$SchemaFieldsDaymarkPayload>
/**
 * Model SchemaFieldsDayval
 * 
 */
export type SchemaFieldsDayval = $Result.DefaultSelection<Prisma.$SchemaFieldsDayvalPayload>
/**
 * Model SchemaFieldsDomainName
 * 
 */
export type SchemaFieldsDomainName = $Result.DefaultSelection<Prisma.$SchemaFieldsDomainNamePayload>
/**
 * Model SchemaFieldsDowntrendCnt
 * 
 */
export type SchemaFieldsDowntrendCnt = $Result.DefaultSelection<Prisma.$SchemaFieldsDowntrendCntPayload>
/**
 * Model SchemaFieldsEmail
 * 
 */
export type SchemaFieldsEmail = $Result.DefaultSelection<Prisma.$SchemaFieldsEmailPayload>
/**
 * Model SchemaFieldsExactdomain
 * 
 */
export type SchemaFieldsExactdomain = $Result.DefaultSelection<Prisma.$SchemaFieldsExactdomainPayload>
/**
 * Model SchemaFieldsExpireDate
 * 
 */
export type SchemaFieldsExpireDate = $Result.DefaultSelection<Prisma.$SchemaFieldsExpireDatePayload>
/**
 * Model SchemaFieldsFbUserId
 * 
 */
export type SchemaFieldsFbUserId = $Result.DefaultSelection<Prisma.$SchemaFieldsFbUserIdPayload>
/**
 * Model SchemaFieldsFkGroupId
 * 
 */
export type SchemaFieldsFkGroupId = $Result.DefaultSelection<Prisma.$SchemaFieldsFkGroupIdPayload>
/**
 * Model SchemaFieldsFkKeywordId
 * 
 */
export type SchemaFieldsFkKeywordId = $Result.DefaultSelection<Prisma.$SchemaFieldsFkKeywordIdPayload>
/**
 * Model SchemaFieldsFkUserId
 * 
 */
export type SchemaFieldsFkUserId = $Result.DefaultSelection<Prisma.$SchemaFieldsFkUserIdPayload>
/**
 * Model SchemaFieldsGroupCallEnd
 * 
 */
export type SchemaFieldsGroupCallEnd = $Result.DefaultSelection<Prisma.$SchemaFieldsGroupCallEndPayload>
/**
 * Model SchemaFieldsGroupCallStart
 * 
 */
export type SchemaFieldsGroupCallStart = $Result.DefaultSelection<Prisma.$SchemaFieldsGroupCallStartPayload>
/**
 * Model SchemaFieldsGroupCallStatus
 * 
 */
export type SchemaFieldsGroupCallStatus = $Result.DefaultSelection<Prisma.$SchemaFieldsGroupCallStatusPayload>
/**
 * Model SchemaFieldsGroupId
 * 
 */
export type SchemaFieldsGroupId = $Result.DefaultSelection<Prisma.$SchemaFieldsGroupIdPayload>
/**
 * Model SchemaFieldsGroupName
 * 
 */
export type SchemaFieldsGroupName = $Result.DefaultSelection<Prisma.$SchemaFieldsGroupNamePayload>
/**
 * Model SchemaFieldsHalfmonthmark
 * 
 */
export type SchemaFieldsHalfmonthmark = $Result.DefaultSelection<Prisma.$SchemaFieldsHalfmonthmarkPayload>
/**
 * Model SchemaFieldsHalfmonthval
 * 
 */
export type SchemaFieldsHalfmonthval = $Result.DefaultSelection<Prisma.$SchemaFieldsHalfmonthvalPayload>
/**
 * Model SchemaFieldsId
 * 
 */
export type SchemaFieldsId = $Result.DefaultSelection<Prisma.$SchemaFieldsIdPayload>
/**
 * Model SchemaFieldsIsActive
 * 
 */
export type SchemaFieldsIsActive = $Result.DefaultSelection<Prisma.$SchemaFieldsIsActivePayload>
/**
 * Model SchemaFieldsIsAdmin
 * 
 */
export type SchemaFieldsIsAdmin = $Result.DefaultSelection<Prisma.$SchemaFieldsIsAdminPayload>
/**
 * Model SchemaFieldsIsStaff
 * 
 */
export type SchemaFieldsIsStaff = $Result.DefaultSelection<Prisma.$SchemaFieldsIsStaffPayload>
/**
 * Model SchemaFieldsIsSuperuser
 * 
 */
export type SchemaFieldsIsSuperuser = $Result.DefaultSelection<Prisma.$SchemaFieldsIsSuperuserPayload>
/**
 * Model SchemaFieldsIsocode
 * 
 */
export type SchemaFieldsIsocode = $Result.DefaultSelection<Prisma.$SchemaFieldsIsocodePayload>
/**
 * Model SchemaFieldsKey
 * 
 */
export type SchemaFieldsKey = $Result.DefaultSelection<Prisma.$SchemaFieldsKeyPayload>
/**
 * Model SchemaFieldsKeyword
 * 
 */
export type SchemaFieldsKeyword = $Result.DefaultSelection<Prisma.$SchemaFieldsKeywordPayload>
/**
 * Model SchemaFieldsKeywordDifficulty
 * 
 */
export type SchemaFieldsKeywordDifficulty = $Result.DefaultSelection<Prisma.$SchemaFieldsKeywordDifficultyPayload>
/**
 * Model SchemaFieldsKeywordSlug
 * 
 */
export type SchemaFieldsKeywordSlug = $Result.DefaultSelection<Prisma.$SchemaFieldsKeywordSlugPayload>
/**
 * Model SchemaFieldsLanguage
 * 
 */
export type SchemaFieldsLanguage = $Result.DefaultSelection<Prisma.$SchemaFieldsLanguagePayload>
/**
 * Model SchemaFieldsLanguageCode
 * 
 */
export type SchemaFieldsLanguageCode = $Result.DefaultSelection<Prisma.$SchemaFieldsLanguageCodePayload>
/**
 * Model SchemaFieldsLanguageName
 * 
 */
export type SchemaFieldsLanguageName = $Result.DefaultSelection<Prisma.$SchemaFieldsLanguageNamePayload>
/**
 * Model SchemaFieldsLastHomeVisit
 * 
 */
export type SchemaFieldsLastHomeVisit = $Result.DefaultSelection<Prisma.$SchemaFieldsLastHomeVisitPayload>
/**
 * Model SchemaFieldsLastLogin
 * 
 */
export type SchemaFieldsLastLogin = $Result.DefaultSelection<Prisma.$SchemaFieldsLastLoginPayload>
/**
 * Model SchemaFieldsLastLogout
 * 
 */
export type SchemaFieldsLastLogout = $Result.DefaultSelection<Prisma.$SchemaFieldsLastLogoutPayload>
/**
 * Model SchemaFieldsLastrankedDate
 * 
 */
export type SchemaFieldsLastrankedDate = $Result.DefaultSelection<Prisma.$SchemaFieldsLastrankedDatePayload>
/**
 * Model SchemaFieldsLocation
 * 
 */
export type SchemaFieldsLocation = $Result.DefaultSelection<Prisma.$SchemaFieldsLocationPayload>
/**
 * Model SchemaFieldsLocationCode
 * 
 */
export type SchemaFieldsLocationCode = $Result.DefaultSelection<Prisma.$SchemaFieldsLocationCodePayload>
/**
 * Model SchemaFieldsMetricStatus
 * 
 */
export type SchemaFieldsMetricStatus = $Result.DefaultSelection<Prisma.$SchemaFieldsMetricStatusPayload>
/**
 * Model SchemaFieldsMobile
 * 
 */
export type SchemaFieldsMobile = $Result.DefaultSelection<Prisma.$SchemaFieldsMobilePayload>
/**
 * Model SchemaFieldsModel
 * 
 */
export type SchemaFieldsModel = $Result.DefaultSelection<Prisma.$SchemaFieldsModelPayload>
/**
 * Model SchemaFieldsModifiedDate
 * 
 */
export type SchemaFieldsModifiedDate = $Result.DefaultSelection<Prisma.$SchemaFieldsModifiedDatePayload>
/**
 * Model SchemaFieldsMonthmark
 * 
 */
export type SchemaFieldsMonthmark = $Result.DefaultSelection<Prisma.$SchemaFieldsMonthmarkPayload>
/**
 * Model SchemaFieldsMonthval
 * 
 */
export type SchemaFieldsMonthval = $Result.DefaultSelection<Prisma.$SchemaFieldsMonthvalPayload>
/**
 * Model SchemaFieldsName
 * 
 */
export type SchemaFieldsName = $Result.DefaultSelection<Prisma.$SchemaFieldsNamePayload>
/**
 * Model SchemaFieldsObjectId
 * 
 */
export type SchemaFieldsObjectId = $Result.DefaultSelection<Prisma.$SchemaFieldsObjectIdPayload>
/**
 * Model SchemaFieldsObjectRepr
 * 
 */
export type SchemaFieldsObjectRepr = $Result.DefaultSelection<Prisma.$SchemaFieldsObjectReprPayload>
/**
 * Model SchemaFieldsPageUuid
 * 
 */
export type SchemaFieldsPageUuid = $Result.DefaultSelection<Prisma.$SchemaFieldsPageUuidPayload>
/**
 * Model SchemaFieldsPageUuidUrl
 * 
 */
export type SchemaFieldsPageUuidUrl = $Result.DefaultSelection<Prisma.$SchemaFieldsPageUuidUrlPayload>
/**
 * Model SchemaFieldsPassword
 * 
 */
export type SchemaFieldsPassword = $Result.DefaultSelection<Prisma.$SchemaFieldsPasswordPayload>
/**
 * Model SchemaFieldsPermissionId
 * 
 */
export type SchemaFieldsPermissionId = $Result.DefaultSelection<Prisma.$SchemaFieldsPermissionIdPayload>
/**
 * Model SchemaFieldsPlanKeywordLimit
 * 
 */
export type SchemaFieldsPlanKeywordLimit = $Result.DefaultSelection<Prisma.$SchemaFieldsPlanKeywordLimitPayload>
/**
 * Model SchemaFieldsPlanProjectLimit
 * 
 */
export type SchemaFieldsPlanProjectLimit = $Result.DefaultSelection<Prisma.$SchemaFieldsPlanProjectLimitPayload>
/**
 * Model SchemaFieldsPlatform
 * 
 */
export type SchemaFieldsPlatform = $Result.DefaultSelection<Prisma.$SchemaFieldsPlatformPayload>
/**
 * Model SchemaFieldsProjectAutomationTime
 * 
 */
export type SchemaFieldsProjectAutomationTime = $Result.DefaultSelection<Prisma.$SchemaFieldsProjectAutomationTimePayload>
/**
 * Model SchemaFieldsProxyExceedsCount
 * 
 */
export type SchemaFieldsProxyExceedsCount = $Result.DefaultSelection<Prisma.$SchemaFieldsProxyExceedsCountPayload>
/**
 * Model SchemaFieldsProxyInvalidCount
 * 
 */
export type SchemaFieldsProxyInvalidCount = $Result.DefaultSelection<Prisma.$SchemaFieldsProxyInvalidCountPayload>
/**
 * Model SchemaFieldsProxyMaximumLoadLimit
 * 
 */
export type SchemaFieldsProxyMaximumLoadLimit = $Result.DefaultSelection<Prisma.$SchemaFieldsProxyMaximumLoadLimitPayload>
/**
 * Model SchemaFieldsProxyResetCounter
 * 
 */
export type SchemaFieldsProxyResetCounter = $Result.DefaultSelection<Prisma.$SchemaFieldsProxyResetCounterPayload>
/**
 * Model SchemaFieldsProxySuccessCount
 * 
 */
export type SchemaFieldsProxySuccessCount = $Result.DefaultSelection<Prisma.$SchemaFieldsProxySuccessCountPayload>
/**
 * Model SchemaFieldsRankSincestart
 * 
 */
export type SchemaFieldsRankSincestart = $Result.DefaultSelection<Prisma.$SchemaFieldsRankSincestartPayload>
/**
 * Model SchemaFieldsRankTrend
 * 
 */
export type SchemaFieldsRankTrend = $Result.DefaultSelection<Prisma.$SchemaFieldsRankTrendPayload>
/**
 * Model SchemaFieldsRankedUrl
 * 
 */
export type SchemaFieldsRankedUrl = $Result.DefaultSelection<Prisma.$SchemaFieldsRankedUrlPayload>
/**
 * Model SchemaFieldsRanknow
 * 
 */
export type SchemaFieldsRanknow = $Result.DefaultSelection<Prisma.$SchemaFieldsRanknowPayload>
/**
 * Model SchemaFieldsRegion
 * 
 */
export type SchemaFieldsRegion = $Result.DefaultSelection<Prisma.$SchemaFieldsRegionPayload>
/**
 * Model SchemaFieldsRegionCode
 * 
 */
export type SchemaFieldsRegionCode = $Result.DefaultSelection<Prisma.$SchemaFieldsRegionCodePayload>
/**
 * Model SchemaFieldsRegionCountry
 * 
 */
export type SchemaFieldsRegionCountry = $Result.DefaultSelection<Prisma.$SchemaFieldsRegionCountryPayload>
/**
 * Model SchemaFieldsRegionName
 * 
 */
export type SchemaFieldsRegionName = $Result.DefaultSelection<Prisma.$SchemaFieldsRegionNamePayload>
/**
 * Model SchemaFieldsResultsPerPage
 * 
 */
export type SchemaFieldsResultsPerPage = $Result.DefaultSelection<Prisma.$SchemaFieldsResultsPerPagePayload>
/**
 * Model SchemaFieldsSearchIntent
 * 
 */
export type SchemaFieldsSearchIntent = $Result.DefaultSelection<Prisma.$SchemaFieldsSearchIntentPayload>
/**
 * Model SchemaFieldsSearchVolume
 * 
 */
export type SchemaFieldsSearchVolume = $Result.DefaultSelection<Prisma.$SchemaFieldsSearchVolumePayload>
/**
 * Model SchemaFieldsSearchvolumeCountryId
 * 
 */
export type SchemaFieldsSearchvolumeCountryId = $Result.DefaultSelection<Prisma.$SchemaFieldsSearchvolumeCountryIdPayload>
/**
 * Model SchemaFieldsSessionData
 * 
 */
export type SchemaFieldsSessionData = $Result.DefaultSelection<Prisma.$SchemaFieldsSessionDataPayload>
/**
 * Model SchemaFieldsSessionKey
 * 
 */
export type SchemaFieldsSessionKey = $Result.DefaultSelection<Prisma.$SchemaFieldsSessionKeyPayload>
/**
 * Model SchemaFieldsSiteUrl
 * 
 */
export type SchemaFieldsSiteUrl = $Result.DefaultSelection<Prisma.$SchemaFieldsSiteUrlPayload>
/**
 * Model SchemaFieldsStatus
 * 
 */
export type SchemaFieldsStatus = $Result.DefaultSelection<Prisma.$SchemaFieldsStatusPayload>
/**
 * Model SchemaFieldsStatusFromStart
 * 
 */
export type SchemaFieldsStatusFromStart = $Result.DefaultSelection<Prisma.$SchemaFieldsStatusFromStartPayload>
/**
 * Model SchemaFieldsTarget
 * 
 */
export type SchemaFieldsTarget = $Result.DefaultSelection<Prisma.$SchemaFieldsTargetPayload>
/**
 * Model SchemaFieldsTimeZone
 * 
 */
export type SchemaFieldsTimeZone = $Result.DefaultSelection<Prisma.$SchemaFieldsTimeZonePayload>
/**
 * Model SchemaFieldsTopRank
 * 
 */
export type SchemaFieldsTopRank = $Result.DefaultSelection<Prisma.$SchemaFieldsTopRankPayload>
/**
 * Model SchemaFieldsTrackStatus
 * 
 */
export type SchemaFieldsTrackStatus = $Result.DefaultSelection<Prisma.$SchemaFieldsTrackStatusPayload>
/**
 * Model SchemaFieldsTraffic
 * 
 */
export type SchemaFieldsTraffic = $Result.DefaultSelection<Prisma.$SchemaFieldsTrafficPayload>
/**
 * Model SchemaFieldsUpdatedDate
 * 
 */
export type SchemaFieldsUpdatedDate = $Result.DefaultSelection<Prisma.$SchemaFieldsUpdatedDatePayload>
/**
 * Model SchemaFieldsUptrendCnt
 * 
 */
export type SchemaFieldsUptrendCnt = $Result.DefaultSelection<Prisma.$SchemaFieldsUptrendCntPayload>
/**
 * Model SchemaFieldsUrl
 * 
 */
export type SchemaFieldsUrl = $Result.DefaultSelection<Prisma.$SchemaFieldsUrlPayload>
/**
 * Model SchemaFieldsUserAutomationTime
 * 
 */
export type SchemaFieldsUserAutomationTime = $Result.DefaultSelection<Prisma.$SchemaFieldsUserAutomationTimePayload>
/**
 * Model SchemaFieldsUserId
 * 
 */
export type SchemaFieldsUserId = $Result.DefaultSelection<Prisma.$SchemaFieldsUserIdPayload>
/**
 * Model SchemaFieldsUsername
 * 
 */
export type SchemaFieldsUsername = $Result.DefaultSelection<Prisma.$SchemaFieldsUsernamePayload>
/**
 * Model SchemaFieldsWeekmark
 * 
 */
export type SchemaFieldsWeekmark = $Result.DefaultSelection<Prisma.$SchemaFieldsWeekmarkPayload>
/**
 * Model SchemaFieldsWeekval
 * 
 */
export type SchemaFieldsWeekval = $Result.DefaultSelection<Prisma.$SchemaFieldsWeekvalPayload>
/**
 * Model schema__
 * 
 */
export type schema__ = $Result.DefaultSelection<Prisma.$schema__Payload>
/**
 * Model account
 * 
 */
export type account = $Result.DefaultSelection<Prisma.$accountPayload>
/**
 * Model account_tracker
 * 
 */
export type account_tracker = $Result.DefaultSelection<Prisma.$account_trackerPayload>
/**
 * Model accountusage
 * 
 */
export type accountusage = $Result.DefaultSelection<Prisma.$accountusagePayload>
/**
 * Model auth_group
 * 
 */
export type auth_group = $Result.DefaultSelection<Prisma.$auth_groupPayload>
/**
 * Model auth_group_permissions
 * 
 */
export type auth_group_permissions = $Result.DefaultSelection<Prisma.$auth_group_permissionsPayload>
/**
 * Model auth_permission
 * 
 */
export type auth_permission = $Result.DefaultSelection<Prisma.$auth_permissionPayload>
/**
 * Model authtoken_token
 * 
 */
export type authtoken_token = $Result.DefaultSelection<Prisma.$authtoken_tokenPayload>
/**
 * Model competitors
 * 
 */
export type competitors = $Result.DefaultSelection<Prisma.$competitorsPayload>
/**
 * Model django_admin_log
 * 
 */
export type django_admin_log = $Result.DefaultSelection<Prisma.$django_admin_logPayload>
/**
 * Model django_content_type
 * 
 */
export type django_content_type = $Result.DefaultSelection<Prisma.$django_content_typePayload>
/**
 * Model django_migrations
 * 
 */
export type django_migrations = $Result.DefaultSelection<Prisma.$django_migrationsPayload>
/**
 * Model django_session
 * 
 */
export type django_session = $Result.DefaultSelection<Prisma.$django_sessionPayload>
/**
 * Model Group
 * 
 */
export type Group = $Result.DefaultSelection<Prisma.$GroupPayload>
/**
 * Model keyword
 * 
 */
export type keyword = $Result.DefaultSelection<Prisma.$keywordPayload>
/**
 * Model keyword_metrics
 * 
 */
export type keyword_metrics = $Result.DefaultSelection<Prisma.$keyword_metricsPayload>
/**
 * Model language
 * 
 */
export type language = $Result.DefaultSelection<Prisma.$languagePayload>
/**
 * Model mainsettings
 * 
 */
export type mainsettings = $Result.DefaultSelection<Prisma.$mainsettingsPayload>
/**
 * Model region
 * 
 */
export type region = $Result.DefaultSelection<Prisma.$regionPayload>

/**
 * ##  Prisma Client ʲˢ
 *
 * Type-safe database client for TypeScript & Node.js
 * @example
 * ```
 * const prisma = new PrismaClient()
 * // Fetch zero or more Schema__s
 * const schema__s = await prisma.schema__.findMany()
 * ```
 *
 *
 * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
 */
export class PrismaClient<
  ClientOptions extends Prisma.PrismaClientOptions = Prisma.PrismaClientOptions,
  U = 'log' extends keyof ClientOptions ? ClientOptions['log'] extends Array<Prisma.LogLevel | Prisma.LogDefinition> ? Prisma.GetEvents<ClientOptions['log']> : never : never,
  ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs
> {
  [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['other'] }

    /**
   * ##  Prisma Client ʲˢ
   *
   * Type-safe database client for TypeScript & Node.js
   * @example
   * ```
   * const prisma = new PrismaClient()
   * // Fetch zero or more Schema__s
   * const schema__s = await prisma.schema__.findMany()
   * ```
   *
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
   */

  constructor(optionsArg ?: Prisma.Subset<ClientOptions, Prisma.PrismaClientOptions>);
  $on<V extends U>(eventType: V, callback: (event: V extends 'query' ? Prisma.QueryEvent : Prisma.LogEvent) => void): void;

  /**
   * Connect with the database
   */
  $connect(): $Utils.JsPromise<void>;

  /**
   * Disconnect from the database
   */
  $disconnect(): $Utils.JsPromise<void>;

  /**
   * Add a middleware
   * @deprecated since 4.16.0. For new code, prefer client extensions instead.
   * @see https://pris.ly/d/extensions
   */
  $use(cb: Prisma.Middleware): void

/**
   * Allows the running of a sequence of read/write operations that are guaranteed to either succeed or fail as a whole.
   * @example
   * ```
   * const [george, bob, alice] = await prisma.$transaction([
   *   prisma.user.create({ data: { name: 'George' } }),
   *   prisma.user.create({ data: { name: 'Bob' } }),
   *   prisma.user.create({ data: { name: 'Alice' } }),
   * ])
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/concepts/components/prisma-client/transactions).
   */
  $transaction<P extends Prisma.PrismaPromise<any>[]>(arg: [...P]): $Utils.JsPromise<runtime.Types.Utils.UnwrapTuple<P>>

  $transaction<R>(fn: (prisma: Omit<PrismaClient, runtime.ITXClientDenyList>) => $Utils.JsPromise<R>, options?: { maxWait?: number, timeout?: number }): $Utils.JsPromise<R>

  /**
   * Executes a raw MongoDB command and returns the result of it.
   * @example
   * ```
   * const user = await prisma.$runCommandRaw({
   *   aggregate: 'User',
   *   pipeline: [{ $match: { name: 'Bob' } }, { $project: { email: true, _id: false } }],
   *   explain: false,
   * })
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $runCommandRaw(command: Prisma.InputJsonObject): Prisma.PrismaPromise<Prisma.JsonObject>

  $extends: $Extensions.ExtendsHook<"extends", Prisma.TypeMapCb, ExtArgs, $Utils.Call<Prisma.TypeMapCb, {
    extArgs: ExtArgs
  }>, ClientOptions>

      /**
   * `prisma.schema__`: Exposes CRUD operations for the **schema__** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Schema__s
    * const schema__s = await prisma.schema__.findMany()
    * ```
    */
  get schema__(): Prisma.schema__Delegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.account`: Exposes CRUD operations for the **account** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Accounts
    * const accounts = await prisma.account.findMany()
    * ```
    */
  get account(): Prisma.accountDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.account_tracker`: Exposes CRUD operations for the **account_tracker** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Account_trackers
    * const account_trackers = await prisma.account_tracker.findMany()
    * ```
    */
  get account_tracker(): Prisma.account_trackerDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.accountusage`: Exposes CRUD operations for the **accountusage** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Accountusages
    * const accountusages = await prisma.accountusage.findMany()
    * ```
    */
  get accountusage(): Prisma.accountusageDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.auth_group`: Exposes CRUD operations for the **auth_group** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Auth_groups
    * const auth_groups = await prisma.auth_group.findMany()
    * ```
    */
  get auth_group(): Prisma.auth_groupDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.auth_group_permissions`: Exposes CRUD operations for the **auth_group_permissions** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Auth_group_permissions
    * const auth_group_permissions = await prisma.auth_group_permissions.findMany()
    * ```
    */
  get auth_group_permissions(): Prisma.auth_group_permissionsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.auth_permission`: Exposes CRUD operations for the **auth_permission** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Auth_permissions
    * const auth_permissions = await prisma.auth_permission.findMany()
    * ```
    */
  get auth_permission(): Prisma.auth_permissionDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.authtoken_token`: Exposes CRUD operations for the **authtoken_token** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Authtoken_tokens
    * const authtoken_tokens = await prisma.authtoken_token.findMany()
    * ```
    */
  get authtoken_token(): Prisma.authtoken_tokenDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.competitors`: Exposes CRUD operations for the **competitors** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Competitors
    * const competitors = await prisma.competitors.findMany()
    * ```
    */
  get competitors(): Prisma.competitorsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.django_admin_log`: Exposes CRUD operations for the **django_admin_log** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Django_admin_logs
    * const django_admin_logs = await prisma.django_admin_log.findMany()
    * ```
    */
  get django_admin_log(): Prisma.django_admin_logDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.django_content_type`: Exposes CRUD operations for the **django_content_type** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Django_content_types
    * const django_content_types = await prisma.django_content_type.findMany()
    * ```
    */
  get django_content_type(): Prisma.django_content_typeDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.django_migrations`: Exposes CRUD operations for the **django_migrations** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Django_migrations
    * const django_migrations = await prisma.django_migrations.findMany()
    * ```
    */
  get django_migrations(): Prisma.django_migrationsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.django_session`: Exposes CRUD operations for the **django_session** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Django_sessions
    * const django_sessions = await prisma.django_session.findMany()
    * ```
    */
  get django_session(): Prisma.django_sessionDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.group`: Exposes CRUD operations for the **Group** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Groups
    * const groups = await prisma.group.findMany()
    * ```
    */
  get group(): Prisma.GroupDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.keyword`: Exposes CRUD operations for the **keyword** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Keywords
    * const keywords = await prisma.keyword.findMany()
    * ```
    */
  get keyword(): Prisma.keywordDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.keyword_metrics`: Exposes CRUD operations for the **keyword_metrics** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Keyword_metrics
    * const keyword_metrics = await prisma.keyword_metrics.findMany()
    * ```
    */
  get keyword_metrics(): Prisma.keyword_metricsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.language`: Exposes CRUD operations for the **language** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Languages
    * const languages = await prisma.language.findMany()
    * ```
    */
  get language(): Prisma.languageDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.mainsettings`: Exposes CRUD operations for the **mainsettings** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Mainsettings
    * const mainsettings = await prisma.mainsettings.findMany()
    * ```
    */
  get mainsettings(): Prisma.mainsettingsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.region`: Exposes CRUD operations for the **region** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Regions
    * const regions = await prisma.region.findMany()
    * ```
    */
  get region(): Prisma.regionDelegate<ExtArgs, ClientOptions>;
}

export namespace Prisma {
  export import DMMF = runtime.DMMF

  export type PrismaPromise<T> = $Public.PrismaPromise<T>

  /**
   * Validator
   */
  export import validator = runtime.Public.validator

  /**
   * Prisma Errors
   */
  export import PrismaClientKnownRequestError = runtime.PrismaClientKnownRequestError
  export import PrismaClientUnknownRequestError = runtime.PrismaClientUnknownRequestError
  export import PrismaClientRustPanicError = runtime.PrismaClientRustPanicError
  export import PrismaClientInitializationError = runtime.PrismaClientInitializationError
  export import PrismaClientValidationError = runtime.PrismaClientValidationError

  /**
   * Re-export of sql-template-tag
   */
  export import sql = runtime.sqltag
  export import empty = runtime.empty
  export import join = runtime.join
  export import raw = runtime.raw
  export import Sql = runtime.Sql



  /**
   * Decimal.js
   */
  export import Decimal = runtime.Decimal

  export type DecimalJsLike = runtime.DecimalJsLike

  /**
   * Metrics
   */
  export type Metrics = runtime.Metrics
  export type Metric<T> = runtime.Metric<T>
  export type MetricHistogram = runtime.MetricHistogram
  export type MetricHistogramBucket = runtime.MetricHistogramBucket

  /**
  * Extensions
  */
  export import Extension = $Extensions.UserArgs
  export import getExtensionContext = runtime.Extensions.getExtensionContext
  export import Args = $Public.Args
  export import Payload = $Public.Payload
  export import Result = $Public.Result
  export import Exact = $Public.Exact

  /**
   * Prisma Client JS version: 6.4.1
   * Query Engine version: a9055b89e58b4b5bfb59600785423b1db3d0e75d
   */
  export type PrismaVersion = {
    client: string
  }

  export const prismaVersion: PrismaVersion

  /**
   * Utility Types
   */


  export import JsonObject = runtime.JsonObject
  export import JsonArray = runtime.JsonArray
  export import JsonValue = runtime.JsonValue
  export import InputJsonObject = runtime.InputJsonObject
  export import InputJsonArray = runtime.InputJsonArray
  export import InputJsonValue = runtime.InputJsonValue

  /**
   * Types of the values used to represent different kinds of `null` values when working with JSON fields.
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  namespace NullTypes {
    /**
    * Type of `Prisma.DbNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.DbNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class DbNull {
      private DbNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.JsonNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.JsonNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class JsonNull {
      private JsonNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.AnyNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.AnyNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class AnyNull {
      private AnyNull: never
      private constructor()
    }
  }

  /**
   * Helper for filtering JSON entries that have `null` on the database (empty on the db)
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const DbNull: NullTypes.DbNull

  /**
   * Helper for filtering JSON entries that have JSON `null` values (not empty on the db)
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const JsonNull: NullTypes.JsonNull

  /**
   * Helper for filtering JSON entries that are `Prisma.DbNull` or `Prisma.JsonNull`
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const AnyNull: NullTypes.AnyNull

  type SelectAndInclude = {
    select: any
    include: any
  }

  type SelectAndOmit = {
    select: any
    omit: any
  }

  /**
   * Get the type of the value, that the Promise holds.
   */
  export type PromiseType<T extends PromiseLike<any>> = T extends PromiseLike<infer U> ? U : T;

  /**
   * Get the return type of a function which returns a Promise.
   */
  export type PromiseReturnType<T extends (...args: any) => $Utils.JsPromise<any>> = PromiseType<ReturnType<T>>

  /**
   * From T, pick a set of properties whose keys are in the union K
   */
  type Prisma__Pick<T, K extends keyof T> = {
      [P in K]: T[P];
  };


  export type Enumerable<T> = T | Array<T>;

  export type RequiredKeys<T> = {
    [K in keyof T]-?: {} extends Prisma__Pick<T, K> ? never : K
  }[keyof T]

  export type TruthyKeys<T> = keyof {
    [K in keyof T as T[K] extends false | undefined | null ? never : K]: K
  }

  export type TrueKeys<T> = TruthyKeys<Prisma__Pick<T, RequiredKeys<T>>>

  /**
   * Subset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection
   */
  export type Subset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never;
  };

  /**
   * SelectSubset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection.
   * Additionally, it validates, if both select and include are present. If the case, it errors.
   */
  export type SelectSubset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    (T extends SelectAndInclude
      ? 'Please either choose `select` or `include`.'
      : T extends SelectAndOmit
        ? 'Please either choose `select` or `omit`.'
        : {})

  /**
   * Subset + Intersection
   * @desc From `T` pick properties that exist in `U` and intersect `K`
   */
  export type SubsetIntersection<T, U, K> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    K

  type Without<T, U> = { [P in Exclude<keyof T, keyof U>]?: never };

  /**
   * XOR is needed to have a real mutually exclusive union type
   * https://stackoverflow.com/questions/42123407/does-typescript-support-mutually-exclusive-types
   */
  type XOR<T, U> =
    T extends object ?
    U extends object ?
      (Without<T, U> & U) | (Without<U, T> & T)
    : U : T


  /**
   * Is T a Record?
   */
  type IsObject<T extends any> = T extends Array<any>
  ? False
  : T extends Date
  ? False
  : T extends Uint8Array
  ? False
  : T extends BigInt
  ? False
  : T extends object
  ? True
  : False


  /**
   * If it's T[], return T
   */
  export type UnEnumerate<T extends unknown> = T extends Array<infer U> ? U : T

  /**
   * From ts-toolbelt
   */

  type __Either<O extends object, K extends Key> = Omit<O, K> &
    {
      // Merge all but K
      [P in K]: Prisma__Pick<O, P & keyof O> // With K possibilities
    }[K]

  type EitherStrict<O extends object, K extends Key> = Strict<__Either<O, K>>

  type EitherLoose<O extends object, K extends Key> = ComputeRaw<__Either<O, K>>

  type _Either<
    O extends object,
    K extends Key,
    strict extends Boolean
  > = {
    1: EitherStrict<O, K>
    0: EitherLoose<O, K>
  }[strict]

  type Either<
    O extends object,
    K extends Key,
    strict extends Boolean = 1
  > = O extends unknown ? _Either<O, K, strict> : never

  export type Union = any

  type PatchUndefined<O extends object, O1 extends object> = {
    [K in keyof O]: O[K] extends undefined ? At<O1, K> : O[K]
  } & {}

  /** Helper Types for "Merge" **/
  export type IntersectOf<U extends Union> = (
    U extends unknown ? (k: U) => void : never
  ) extends (k: infer I) => void
    ? I
    : never

  export type Overwrite<O extends object, O1 extends object> = {
      [K in keyof O]: K extends keyof O1 ? O1[K] : O[K];
  } & {};

  type _Merge<U extends object> = IntersectOf<Overwrite<U, {
      [K in keyof U]-?: At<U, K>;
  }>>;

  type Key = string | number | symbol;
  type AtBasic<O extends object, K extends Key> = K extends keyof O ? O[K] : never;
  type AtStrict<O extends object, K extends Key> = O[K & keyof O];
  type AtLoose<O extends object, K extends Key> = O extends unknown ? AtStrict<O, K> : never;
  export type At<O extends object, K extends Key, strict extends Boolean = 1> = {
      1: AtStrict<O, K>;
      0: AtLoose<O, K>;
  }[strict];

  export type ComputeRaw<A extends any> = A extends Function ? A : {
    [K in keyof A]: A[K];
  } & {};

  export type OptionalFlat<O> = {
    [K in keyof O]?: O[K];
  } & {};

  type _Record<K extends keyof any, T> = {
    [P in K]: T;
  };

  // cause typescript not to expand types and preserve names
  type NoExpand<T> = T extends unknown ? T : never;

  // this type assumes the passed object is entirely optional
  type AtLeast<O extends object, K extends string> = NoExpand<
    O extends unknown
    ? | (K extends keyof O ? { [P in K]: O[P] } & O : O)
      | {[P in keyof O as P extends K ? K : never]-?: O[P]} & O
    : never>;

  type _Strict<U, _U = U> = U extends unknown ? U & OptionalFlat<_Record<Exclude<Keys<_U>, keyof U>, never>> : never;

  export type Strict<U extends object> = ComputeRaw<_Strict<U>>;
  /** End Helper Types for "Merge" **/

  export type Merge<U extends object> = ComputeRaw<_Merge<Strict<U>>>;

  /**
  A [[Boolean]]
  */
  export type Boolean = True | False

  // /**
  // 1
  // */
  export type True = 1

  /**
  0
  */
  export type False = 0

  export type Not<B extends Boolean> = {
    0: 1
    1: 0
  }[B]

  export type Extends<A1 extends any, A2 extends any> = [A1] extends [never]
    ? 0 // anything `never` is false
    : A1 extends A2
    ? 1
    : 0

  export type Has<U extends Union, U1 extends Union> = Not<
    Extends<Exclude<U1, U>, U1>
  >

  export type Or<B1 extends Boolean, B2 extends Boolean> = {
    0: {
      0: 0
      1: 1
    }
    1: {
      0: 1
      1: 1
    }
  }[B1][B2]

  export type Keys<U extends Union> = U extends unknown ? keyof U : never

  type Cast<A, B> = A extends B ? A : B;

  export const type: unique symbol;



  /**
   * Used by group by
   */

  export type GetScalarType<T, O> = O extends object ? {
    [P in keyof T]: P extends keyof O
      ? O[P]
      : never
  } : never

  type FieldPaths<
    T,
    U = Omit<T, '_avg' | '_sum' | '_count' | '_min' | '_max'>
  > = IsObject<T> extends True ? U : T

  type GetHavingFields<T> = {
    [K in keyof T]: Or<
      Or<Extends<'OR', K>, Extends<'AND', K>>,
      Extends<'NOT', K>
    > extends True
      ? // infer is only needed to not hit TS limit
        // based on the brilliant idea of Pierre-Antoine Mills
        // https://github.com/microsoft/TypeScript/issues/30188#issuecomment-478938437
        T[K] extends infer TK
        ? GetHavingFields<UnEnumerate<TK> extends object ? Merge<UnEnumerate<TK>> : never>
        : never
      : {} extends FieldPaths<T[K]>
      ? never
      : K
  }[keyof T]

  /**
   * Convert tuple to union
   */
  type _TupleToUnion<T> = T extends (infer E)[] ? E : never
  type TupleToUnion<K extends readonly any[]> = _TupleToUnion<K>
  type MaybeTupleToUnion<T> = T extends any[] ? TupleToUnion<T> : T

  /**
   * Like `Pick`, but additionally can also accept an array of keys
   */
  type PickEnumerable<T, K extends Enumerable<keyof T> | keyof T> = Prisma__Pick<T, MaybeTupleToUnion<K>>

  /**
   * Exclude all keys with underscores
   */
  type ExcludeUnderscoreKeys<T extends string> = T extends `_${string}` ? never : T


  export type FieldRef<Model, FieldType> = runtime.FieldRef<Model, FieldType>

  type FieldRefInputType<Model, FieldType> = Model extends never ? never : FieldRef<Model, FieldType>


  export const ModelName: {
    schema__: 'schema__',
    account: 'account',
    account_tracker: 'account_tracker',
    accountusage: 'accountusage',
    auth_group: 'auth_group',
    auth_group_permissions: 'auth_group_permissions',
    auth_permission: 'auth_permission',
    authtoken_token: 'authtoken_token',
    competitors: 'competitors',
    django_admin_log: 'django_admin_log',
    django_content_type: 'django_content_type',
    django_migrations: 'django_migrations',
    django_session: 'django_session',
    Group: 'Group',
    keyword: 'keyword',
    keyword_metrics: 'keyword_metrics',
    language: 'language',
    mainsettings: 'mainsettings',
    region: 'region'
  };

  export type ModelName = (typeof ModelName)[keyof typeof ModelName]


  export type Datasources = {
    db?: Datasource
  }

  interface TypeMapCb extends $Utils.Fn<{extArgs: $Extensions.InternalArgs, clientOptions: PrismaClientOptions }, $Utils.Record<string, any>> {
    returns: Prisma.TypeMap<this['params']['extArgs'], this['params']['clientOptions']>
  }

  export type TypeMap<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> = {
    meta: {
      modelProps: "schema__" | "account" | "account_tracker" | "accountusage" | "auth_group" | "auth_group_permissions" | "auth_permission" | "authtoken_token" | "competitors" | "django_admin_log" | "django_content_type" | "django_migrations" | "django_session" | "group" | "keyword" | "keyword_metrics" | "language" | "mainsettings" | "region"
      txIsolationLevel: never
    }
    model: {
      schema__: {
        payload: Prisma.$schema__Payload<ExtArgs>
        fields: Prisma.schema__FieldRefs
        operations: {
          findUnique: {
            args: Prisma.schema__FindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$schema__Payload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.schema__FindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$schema__Payload>
          }
          findFirst: {
            args: Prisma.schema__FindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$schema__Payload> | null
          }
          findFirstOrThrow: {
            args: Prisma.schema__FindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$schema__Payload>
          }
          findMany: {
            args: Prisma.schema__FindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$schema__Payload>[]
          }
          create: {
            args: Prisma.schema__CreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$schema__Payload>
          }
          createMany: {
            args: Prisma.schema__CreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.schema__DeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$schema__Payload>
          }
          update: {
            args: Prisma.schema__UpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$schema__Payload>
          }
          deleteMany: {
            args: Prisma.schema__DeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.schema__UpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.schema__UpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$schema__Payload>
          }
          aggregate: {
            args: Prisma.Schema__AggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateSchema__>
          }
          groupBy: {
            args: Prisma.schema__GroupByArgs<ExtArgs>
            result: $Utils.Optional<Schema__GroupByOutputType>[]
          }
          findRaw: {
            args: Prisma.schema__FindRawArgs<ExtArgs>
            result: JsonObject
          }
          aggregateRaw: {
            args: Prisma.schema__AggregateRawArgs<ExtArgs>
            result: JsonObject
          }
          count: {
            args: Prisma.schema__CountArgs<ExtArgs>
            result: $Utils.Optional<Schema__CountAggregateOutputType> | number
          }
        }
      }
      account: {
        payload: Prisma.$accountPayload<ExtArgs>
        fields: Prisma.accountFieldRefs
        operations: {
          findUnique: {
            args: Prisma.accountFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$accountPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.accountFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$accountPayload>
          }
          findFirst: {
            args: Prisma.accountFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$accountPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.accountFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$accountPayload>
          }
          findMany: {
            args: Prisma.accountFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$accountPayload>[]
          }
          create: {
            args: Prisma.accountCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$accountPayload>
          }
          createMany: {
            args: Prisma.accountCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.accountDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$accountPayload>
          }
          update: {
            args: Prisma.accountUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$accountPayload>
          }
          deleteMany: {
            args: Prisma.accountDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.accountUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.accountUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$accountPayload>
          }
          aggregate: {
            args: Prisma.AccountAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAccount>
          }
          groupBy: {
            args: Prisma.accountGroupByArgs<ExtArgs>
            result: $Utils.Optional<AccountGroupByOutputType>[]
          }
          findRaw: {
            args: Prisma.accountFindRawArgs<ExtArgs>
            result: JsonObject
          }
          aggregateRaw: {
            args: Prisma.accountAggregateRawArgs<ExtArgs>
            result: JsonObject
          }
          count: {
            args: Prisma.accountCountArgs<ExtArgs>
            result: $Utils.Optional<AccountCountAggregateOutputType> | number
          }
        }
      }
      account_tracker: {
        payload: Prisma.$account_trackerPayload<ExtArgs>
        fields: Prisma.account_trackerFieldRefs
        operations: {
          findUnique: {
            args: Prisma.account_trackerFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$account_trackerPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.account_trackerFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$account_trackerPayload>
          }
          findFirst: {
            args: Prisma.account_trackerFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$account_trackerPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.account_trackerFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$account_trackerPayload>
          }
          findMany: {
            args: Prisma.account_trackerFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$account_trackerPayload>[]
          }
          create: {
            args: Prisma.account_trackerCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$account_trackerPayload>
          }
          createMany: {
            args: Prisma.account_trackerCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.account_trackerDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$account_trackerPayload>
          }
          update: {
            args: Prisma.account_trackerUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$account_trackerPayload>
          }
          deleteMany: {
            args: Prisma.account_trackerDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.account_trackerUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.account_trackerUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$account_trackerPayload>
          }
          aggregate: {
            args: Prisma.Account_trackerAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAccount_tracker>
          }
          groupBy: {
            args: Prisma.account_trackerGroupByArgs<ExtArgs>
            result: $Utils.Optional<Account_trackerGroupByOutputType>[]
          }
          findRaw: {
            args: Prisma.account_trackerFindRawArgs<ExtArgs>
            result: JsonObject
          }
          aggregateRaw: {
            args: Prisma.account_trackerAggregateRawArgs<ExtArgs>
            result: JsonObject
          }
          count: {
            args: Prisma.account_trackerCountArgs<ExtArgs>
            result: $Utils.Optional<Account_trackerCountAggregateOutputType> | number
          }
        }
      }
      accountusage: {
        payload: Prisma.$accountusagePayload<ExtArgs>
        fields: Prisma.accountusageFieldRefs
        operations: {
          findUnique: {
            args: Prisma.accountusageFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$accountusagePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.accountusageFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$accountusagePayload>
          }
          findFirst: {
            args: Prisma.accountusageFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$accountusagePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.accountusageFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$accountusagePayload>
          }
          findMany: {
            args: Prisma.accountusageFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$accountusagePayload>[]
          }
          create: {
            args: Prisma.accountusageCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$accountusagePayload>
          }
          createMany: {
            args: Prisma.accountusageCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.accountusageDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$accountusagePayload>
          }
          update: {
            args: Prisma.accountusageUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$accountusagePayload>
          }
          deleteMany: {
            args: Prisma.accountusageDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.accountusageUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.accountusageUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$accountusagePayload>
          }
          aggregate: {
            args: Prisma.AccountusageAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAccountusage>
          }
          groupBy: {
            args: Prisma.accountusageGroupByArgs<ExtArgs>
            result: $Utils.Optional<AccountusageGroupByOutputType>[]
          }
          findRaw: {
            args: Prisma.accountusageFindRawArgs<ExtArgs>
            result: JsonObject
          }
          aggregateRaw: {
            args: Prisma.accountusageAggregateRawArgs<ExtArgs>
            result: JsonObject
          }
          count: {
            args: Prisma.accountusageCountArgs<ExtArgs>
            result: $Utils.Optional<AccountusageCountAggregateOutputType> | number
          }
        }
      }
      auth_group: {
        payload: Prisma.$auth_groupPayload<ExtArgs>
        fields: Prisma.auth_groupFieldRefs
        operations: {
          findUnique: {
            args: Prisma.auth_groupFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_groupPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.auth_groupFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_groupPayload>
          }
          findFirst: {
            args: Prisma.auth_groupFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_groupPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.auth_groupFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_groupPayload>
          }
          findMany: {
            args: Prisma.auth_groupFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_groupPayload>[]
          }
          create: {
            args: Prisma.auth_groupCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_groupPayload>
          }
          createMany: {
            args: Prisma.auth_groupCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.auth_groupDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_groupPayload>
          }
          update: {
            args: Prisma.auth_groupUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_groupPayload>
          }
          deleteMany: {
            args: Prisma.auth_groupDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.auth_groupUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.auth_groupUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_groupPayload>
          }
          aggregate: {
            args: Prisma.Auth_groupAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAuth_group>
          }
          groupBy: {
            args: Prisma.auth_groupGroupByArgs<ExtArgs>
            result: $Utils.Optional<Auth_groupGroupByOutputType>[]
          }
          findRaw: {
            args: Prisma.auth_groupFindRawArgs<ExtArgs>
            result: JsonObject
          }
          aggregateRaw: {
            args: Prisma.auth_groupAggregateRawArgs<ExtArgs>
            result: JsonObject
          }
          count: {
            args: Prisma.auth_groupCountArgs<ExtArgs>
            result: $Utils.Optional<Auth_groupCountAggregateOutputType> | number
          }
        }
      }
      auth_group_permissions: {
        payload: Prisma.$auth_group_permissionsPayload<ExtArgs>
        fields: Prisma.auth_group_permissionsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.auth_group_permissionsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_group_permissionsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.auth_group_permissionsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_group_permissionsPayload>
          }
          findFirst: {
            args: Prisma.auth_group_permissionsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_group_permissionsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.auth_group_permissionsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_group_permissionsPayload>
          }
          findMany: {
            args: Prisma.auth_group_permissionsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_group_permissionsPayload>[]
          }
          create: {
            args: Prisma.auth_group_permissionsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_group_permissionsPayload>
          }
          createMany: {
            args: Prisma.auth_group_permissionsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.auth_group_permissionsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_group_permissionsPayload>
          }
          update: {
            args: Prisma.auth_group_permissionsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_group_permissionsPayload>
          }
          deleteMany: {
            args: Prisma.auth_group_permissionsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.auth_group_permissionsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.auth_group_permissionsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_group_permissionsPayload>
          }
          aggregate: {
            args: Prisma.Auth_group_permissionsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAuth_group_permissions>
          }
          groupBy: {
            args: Prisma.auth_group_permissionsGroupByArgs<ExtArgs>
            result: $Utils.Optional<Auth_group_permissionsGroupByOutputType>[]
          }
          findRaw: {
            args: Prisma.auth_group_permissionsFindRawArgs<ExtArgs>
            result: JsonObject
          }
          aggregateRaw: {
            args: Prisma.auth_group_permissionsAggregateRawArgs<ExtArgs>
            result: JsonObject
          }
          count: {
            args: Prisma.auth_group_permissionsCountArgs<ExtArgs>
            result: $Utils.Optional<Auth_group_permissionsCountAggregateOutputType> | number
          }
        }
      }
      auth_permission: {
        payload: Prisma.$auth_permissionPayload<ExtArgs>
        fields: Prisma.auth_permissionFieldRefs
        operations: {
          findUnique: {
            args: Prisma.auth_permissionFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_permissionPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.auth_permissionFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_permissionPayload>
          }
          findFirst: {
            args: Prisma.auth_permissionFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_permissionPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.auth_permissionFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_permissionPayload>
          }
          findMany: {
            args: Prisma.auth_permissionFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_permissionPayload>[]
          }
          create: {
            args: Prisma.auth_permissionCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_permissionPayload>
          }
          createMany: {
            args: Prisma.auth_permissionCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.auth_permissionDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_permissionPayload>
          }
          update: {
            args: Prisma.auth_permissionUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_permissionPayload>
          }
          deleteMany: {
            args: Prisma.auth_permissionDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.auth_permissionUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.auth_permissionUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$auth_permissionPayload>
          }
          aggregate: {
            args: Prisma.Auth_permissionAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAuth_permission>
          }
          groupBy: {
            args: Prisma.auth_permissionGroupByArgs<ExtArgs>
            result: $Utils.Optional<Auth_permissionGroupByOutputType>[]
          }
          findRaw: {
            args: Prisma.auth_permissionFindRawArgs<ExtArgs>
            result: JsonObject
          }
          aggregateRaw: {
            args: Prisma.auth_permissionAggregateRawArgs<ExtArgs>
            result: JsonObject
          }
          count: {
            args: Prisma.auth_permissionCountArgs<ExtArgs>
            result: $Utils.Optional<Auth_permissionCountAggregateOutputType> | number
          }
        }
      }
      authtoken_token: {
        payload: Prisma.$authtoken_tokenPayload<ExtArgs>
        fields: Prisma.authtoken_tokenFieldRefs
        operations: {
          findUnique: {
            args: Prisma.authtoken_tokenFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$authtoken_tokenPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.authtoken_tokenFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$authtoken_tokenPayload>
          }
          findFirst: {
            args: Prisma.authtoken_tokenFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$authtoken_tokenPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.authtoken_tokenFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$authtoken_tokenPayload>
          }
          findMany: {
            args: Prisma.authtoken_tokenFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$authtoken_tokenPayload>[]
          }
          create: {
            args: Prisma.authtoken_tokenCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$authtoken_tokenPayload>
          }
          createMany: {
            args: Prisma.authtoken_tokenCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.authtoken_tokenDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$authtoken_tokenPayload>
          }
          update: {
            args: Prisma.authtoken_tokenUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$authtoken_tokenPayload>
          }
          deleteMany: {
            args: Prisma.authtoken_tokenDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.authtoken_tokenUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.authtoken_tokenUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$authtoken_tokenPayload>
          }
          aggregate: {
            args: Prisma.Authtoken_tokenAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAuthtoken_token>
          }
          groupBy: {
            args: Prisma.authtoken_tokenGroupByArgs<ExtArgs>
            result: $Utils.Optional<Authtoken_tokenGroupByOutputType>[]
          }
          findRaw: {
            args: Prisma.authtoken_tokenFindRawArgs<ExtArgs>
            result: JsonObject
          }
          aggregateRaw: {
            args: Prisma.authtoken_tokenAggregateRawArgs<ExtArgs>
            result: JsonObject
          }
          count: {
            args: Prisma.authtoken_tokenCountArgs<ExtArgs>
            result: $Utils.Optional<Authtoken_tokenCountAggregateOutputType> | number
          }
        }
      }
      competitors: {
        payload: Prisma.$competitorsPayload<ExtArgs>
        fields: Prisma.competitorsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.competitorsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$competitorsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.competitorsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$competitorsPayload>
          }
          findFirst: {
            args: Prisma.competitorsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$competitorsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.competitorsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$competitorsPayload>
          }
          findMany: {
            args: Prisma.competitorsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$competitorsPayload>[]
          }
          create: {
            args: Prisma.competitorsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$competitorsPayload>
          }
          createMany: {
            args: Prisma.competitorsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.competitorsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$competitorsPayload>
          }
          update: {
            args: Prisma.competitorsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$competitorsPayload>
          }
          deleteMany: {
            args: Prisma.competitorsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.competitorsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.competitorsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$competitorsPayload>
          }
          aggregate: {
            args: Prisma.CompetitorsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateCompetitors>
          }
          groupBy: {
            args: Prisma.competitorsGroupByArgs<ExtArgs>
            result: $Utils.Optional<CompetitorsGroupByOutputType>[]
          }
          findRaw: {
            args: Prisma.competitorsFindRawArgs<ExtArgs>
            result: JsonObject
          }
          aggregateRaw: {
            args: Prisma.competitorsAggregateRawArgs<ExtArgs>
            result: JsonObject
          }
          count: {
            args: Prisma.competitorsCountArgs<ExtArgs>
            result: $Utils.Optional<CompetitorsCountAggregateOutputType> | number
          }
        }
      }
      django_admin_log: {
        payload: Prisma.$django_admin_logPayload<ExtArgs>
        fields: Prisma.django_admin_logFieldRefs
        operations: {
          findUnique: {
            args: Prisma.django_admin_logFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_admin_logPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.django_admin_logFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_admin_logPayload>
          }
          findFirst: {
            args: Prisma.django_admin_logFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_admin_logPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.django_admin_logFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_admin_logPayload>
          }
          findMany: {
            args: Prisma.django_admin_logFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_admin_logPayload>[]
          }
          create: {
            args: Prisma.django_admin_logCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_admin_logPayload>
          }
          createMany: {
            args: Prisma.django_admin_logCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.django_admin_logDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_admin_logPayload>
          }
          update: {
            args: Prisma.django_admin_logUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_admin_logPayload>
          }
          deleteMany: {
            args: Prisma.django_admin_logDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.django_admin_logUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.django_admin_logUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_admin_logPayload>
          }
          aggregate: {
            args: Prisma.Django_admin_logAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateDjango_admin_log>
          }
          groupBy: {
            args: Prisma.django_admin_logGroupByArgs<ExtArgs>
            result: $Utils.Optional<Django_admin_logGroupByOutputType>[]
          }
          findRaw: {
            args: Prisma.django_admin_logFindRawArgs<ExtArgs>
            result: JsonObject
          }
          aggregateRaw: {
            args: Prisma.django_admin_logAggregateRawArgs<ExtArgs>
            result: JsonObject
          }
          count: {
            args: Prisma.django_admin_logCountArgs<ExtArgs>
            result: $Utils.Optional<Django_admin_logCountAggregateOutputType> | number
          }
        }
      }
      django_content_type: {
        payload: Prisma.$django_content_typePayload<ExtArgs>
        fields: Prisma.django_content_typeFieldRefs
        operations: {
          findUnique: {
            args: Prisma.django_content_typeFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_content_typePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.django_content_typeFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_content_typePayload>
          }
          findFirst: {
            args: Prisma.django_content_typeFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_content_typePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.django_content_typeFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_content_typePayload>
          }
          findMany: {
            args: Prisma.django_content_typeFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_content_typePayload>[]
          }
          create: {
            args: Prisma.django_content_typeCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_content_typePayload>
          }
          createMany: {
            args: Prisma.django_content_typeCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.django_content_typeDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_content_typePayload>
          }
          update: {
            args: Prisma.django_content_typeUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_content_typePayload>
          }
          deleteMany: {
            args: Prisma.django_content_typeDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.django_content_typeUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.django_content_typeUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_content_typePayload>
          }
          aggregate: {
            args: Prisma.Django_content_typeAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateDjango_content_type>
          }
          groupBy: {
            args: Prisma.django_content_typeGroupByArgs<ExtArgs>
            result: $Utils.Optional<Django_content_typeGroupByOutputType>[]
          }
          findRaw: {
            args: Prisma.django_content_typeFindRawArgs<ExtArgs>
            result: JsonObject
          }
          aggregateRaw: {
            args: Prisma.django_content_typeAggregateRawArgs<ExtArgs>
            result: JsonObject
          }
          count: {
            args: Prisma.django_content_typeCountArgs<ExtArgs>
            result: $Utils.Optional<Django_content_typeCountAggregateOutputType> | number
          }
        }
      }
      django_migrations: {
        payload: Prisma.$django_migrationsPayload<ExtArgs>
        fields: Prisma.django_migrationsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.django_migrationsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_migrationsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.django_migrationsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_migrationsPayload>
          }
          findFirst: {
            args: Prisma.django_migrationsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_migrationsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.django_migrationsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_migrationsPayload>
          }
          findMany: {
            args: Prisma.django_migrationsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_migrationsPayload>[]
          }
          create: {
            args: Prisma.django_migrationsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_migrationsPayload>
          }
          createMany: {
            args: Prisma.django_migrationsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.django_migrationsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_migrationsPayload>
          }
          update: {
            args: Prisma.django_migrationsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_migrationsPayload>
          }
          deleteMany: {
            args: Prisma.django_migrationsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.django_migrationsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.django_migrationsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_migrationsPayload>
          }
          aggregate: {
            args: Prisma.Django_migrationsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateDjango_migrations>
          }
          groupBy: {
            args: Prisma.django_migrationsGroupByArgs<ExtArgs>
            result: $Utils.Optional<Django_migrationsGroupByOutputType>[]
          }
          findRaw: {
            args: Prisma.django_migrationsFindRawArgs<ExtArgs>
            result: JsonObject
          }
          aggregateRaw: {
            args: Prisma.django_migrationsAggregateRawArgs<ExtArgs>
            result: JsonObject
          }
          count: {
            args: Prisma.django_migrationsCountArgs<ExtArgs>
            result: $Utils.Optional<Django_migrationsCountAggregateOutputType> | number
          }
        }
      }
      django_session: {
        payload: Prisma.$django_sessionPayload<ExtArgs>
        fields: Prisma.django_sessionFieldRefs
        operations: {
          findUnique: {
            args: Prisma.django_sessionFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_sessionPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.django_sessionFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_sessionPayload>
          }
          findFirst: {
            args: Prisma.django_sessionFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_sessionPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.django_sessionFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_sessionPayload>
          }
          findMany: {
            args: Prisma.django_sessionFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_sessionPayload>[]
          }
          create: {
            args: Prisma.django_sessionCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_sessionPayload>
          }
          createMany: {
            args: Prisma.django_sessionCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.django_sessionDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_sessionPayload>
          }
          update: {
            args: Prisma.django_sessionUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_sessionPayload>
          }
          deleteMany: {
            args: Prisma.django_sessionDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.django_sessionUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.django_sessionUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$django_sessionPayload>
          }
          aggregate: {
            args: Prisma.Django_sessionAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateDjango_session>
          }
          groupBy: {
            args: Prisma.django_sessionGroupByArgs<ExtArgs>
            result: $Utils.Optional<Django_sessionGroupByOutputType>[]
          }
          findRaw: {
            args: Prisma.django_sessionFindRawArgs<ExtArgs>
            result: JsonObject
          }
          aggregateRaw: {
            args: Prisma.django_sessionAggregateRawArgs<ExtArgs>
            result: JsonObject
          }
          count: {
            args: Prisma.django_sessionCountArgs<ExtArgs>
            result: $Utils.Optional<Django_sessionCountAggregateOutputType> | number
          }
        }
      }
      Group: {
        payload: Prisma.$GroupPayload<ExtArgs>
        fields: Prisma.GroupFieldRefs
        operations: {
          findUnique: {
            args: Prisma.GroupFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GroupPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.GroupFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GroupPayload>
          }
          findFirst: {
            args: Prisma.GroupFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GroupPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.GroupFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GroupPayload>
          }
          findMany: {
            args: Prisma.GroupFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GroupPayload>[]
          }
          create: {
            args: Prisma.GroupCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GroupPayload>
          }
          createMany: {
            args: Prisma.GroupCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.GroupDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GroupPayload>
          }
          update: {
            args: Prisma.GroupUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GroupPayload>
          }
          deleteMany: {
            args: Prisma.GroupDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.GroupUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.GroupUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GroupPayload>
          }
          aggregate: {
            args: Prisma.GroupAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateGroup>
          }
          groupBy: {
            args: Prisma.GroupGroupByArgs<ExtArgs>
            result: $Utils.Optional<GroupGroupByOutputType>[]
          }
          findRaw: {
            args: Prisma.GroupFindRawArgs<ExtArgs>
            result: JsonObject
          }
          aggregateRaw: {
            args: Prisma.GroupAggregateRawArgs<ExtArgs>
            result: JsonObject
          }
          count: {
            args: Prisma.GroupCountArgs<ExtArgs>
            result: $Utils.Optional<GroupCountAggregateOutputType> | number
          }
        }
      }
      keyword: {
        payload: Prisma.$keywordPayload<ExtArgs>
        fields: Prisma.keywordFieldRefs
        operations: {
          findUnique: {
            args: Prisma.keywordFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$keywordPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.keywordFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$keywordPayload>
          }
          findFirst: {
            args: Prisma.keywordFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$keywordPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.keywordFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$keywordPayload>
          }
          findMany: {
            args: Prisma.keywordFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$keywordPayload>[]
          }
          create: {
            args: Prisma.keywordCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$keywordPayload>
          }
          createMany: {
            args: Prisma.keywordCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.keywordDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$keywordPayload>
          }
          update: {
            args: Prisma.keywordUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$keywordPayload>
          }
          deleteMany: {
            args: Prisma.keywordDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.keywordUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.keywordUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$keywordPayload>
          }
          aggregate: {
            args: Prisma.KeywordAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateKeyword>
          }
          groupBy: {
            args: Prisma.keywordGroupByArgs<ExtArgs>
            result: $Utils.Optional<KeywordGroupByOutputType>[]
          }
          findRaw: {
            args: Prisma.keywordFindRawArgs<ExtArgs>
            result: JsonObject
          }
          aggregateRaw: {
            args: Prisma.keywordAggregateRawArgs<ExtArgs>
            result: JsonObject
          }
          count: {
            args: Prisma.keywordCountArgs<ExtArgs>
            result: $Utils.Optional<KeywordCountAggregateOutputType> | number
          }
        }
      }
      keyword_metrics: {
        payload: Prisma.$keyword_metricsPayload<ExtArgs>
        fields: Prisma.keyword_metricsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.keyword_metricsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$keyword_metricsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.keyword_metricsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$keyword_metricsPayload>
          }
          findFirst: {
            args: Prisma.keyword_metricsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$keyword_metricsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.keyword_metricsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$keyword_metricsPayload>
          }
          findMany: {
            args: Prisma.keyword_metricsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$keyword_metricsPayload>[]
          }
          create: {
            args: Prisma.keyword_metricsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$keyword_metricsPayload>
          }
          createMany: {
            args: Prisma.keyword_metricsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.keyword_metricsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$keyword_metricsPayload>
          }
          update: {
            args: Prisma.keyword_metricsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$keyword_metricsPayload>
          }
          deleteMany: {
            args: Prisma.keyword_metricsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.keyword_metricsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.keyword_metricsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$keyword_metricsPayload>
          }
          aggregate: {
            args: Prisma.Keyword_metricsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateKeyword_metrics>
          }
          groupBy: {
            args: Prisma.keyword_metricsGroupByArgs<ExtArgs>
            result: $Utils.Optional<Keyword_metricsGroupByOutputType>[]
          }
          findRaw: {
            args: Prisma.keyword_metricsFindRawArgs<ExtArgs>
            result: JsonObject
          }
          aggregateRaw: {
            args: Prisma.keyword_metricsAggregateRawArgs<ExtArgs>
            result: JsonObject
          }
          count: {
            args: Prisma.keyword_metricsCountArgs<ExtArgs>
            result: $Utils.Optional<Keyword_metricsCountAggregateOutputType> | number
          }
        }
      }
      language: {
        payload: Prisma.$languagePayload<ExtArgs>
        fields: Prisma.languageFieldRefs
        operations: {
          findUnique: {
            args: Prisma.languageFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$languagePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.languageFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$languagePayload>
          }
          findFirst: {
            args: Prisma.languageFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$languagePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.languageFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$languagePayload>
          }
          findMany: {
            args: Prisma.languageFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$languagePayload>[]
          }
          create: {
            args: Prisma.languageCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$languagePayload>
          }
          createMany: {
            args: Prisma.languageCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.languageDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$languagePayload>
          }
          update: {
            args: Prisma.languageUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$languagePayload>
          }
          deleteMany: {
            args: Prisma.languageDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.languageUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.languageUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$languagePayload>
          }
          aggregate: {
            args: Prisma.LanguageAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateLanguage>
          }
          groupBy: {
            args: Prisma.languageGroupByArgs<ExtArgs>
            result: $Utils.Optional<LanguageGroupByOutputType>[]
          }
          findRaw: {
            args: Prisma.languageFindRawArgs<ExtArgs>
            result: JsonObject
          }
          aggregateRaw: {
            args: Prisma.languageAggregateRawArgs<ExtArgs>
            result: JsonObject
          }
          count: {
            args: Prisma.languageCountArgs<ExtArgs>
            result: $Utils.Optional<LanguageCountAggregateOutputType> | number
          }
        }
      }
      mainsettings: {
        payload: Prisma.$mainsettingsPayload<ExtArgs>
        fields: Prisma.mainsettingsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.mainsettingsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$mainsettingsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.mainsettingsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$mainsettingsPayload>
          }
          findFirst: {
            args: Prisma.mainsettingsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$mainsettingsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.mainsettingsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$mainsettingsPayload>
          }
          findMany: {
            args: Prisma.mainsettingsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$mainsettingsPayload>[]
          }
          create: {
            args: Prisma.mainsettingsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$mainsettingsPayload>
          }
          createMany: {
            args: Prisma.mainsettingsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.mainsettingsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$mainsettingsPayload>
          }
          update: {
            args: Prisma.mainsettingsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$mainsettingsPayload>
          }
          deleteMany: {
            args: Prisma.mainsettingsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.mainsettingsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.mainsettingsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$mainsettingsPayload>
          }
          aggregate: {
            args: Prisma.MainsettingsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateMainsettings>
          }
          groupBy: {
            args: Prisma.mainsettingsGroupByArgs<ExtArgs>
            result: $Utils.Optional<MainsettingsGroupByOutputType>[]
          }
          findRaw: {
            args: Prisma.mainsettingsFindRawArgs<ExtArgs>
            result: JsonObject
          }
          aggregateRaw: {
            args: Prisma.mainsettingsAggregateRawArgs<ExtArgs>
            result: JsonObject
          }
          count: {
            args: Prisma.mainsettingsCountArgs<ExtArgs>
            result: $Utils.Optional<MainsettingsCountAggregateOutputType> | number
          }
        }
      }
      region: {
        payload: Prisma.$regionPayload<ExtArgs>
        fields: Prisma.regionFieldRefs
        operations: {
          findUnique: {
            args: Prisma.regionFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$regionPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.regionFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$regionPayload>
          }
          findFirst: {
            args: Prisma.regionFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$regionPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.regionFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$regionPayload>
          }
          findMany: {
            args: Prisma.regionFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$regionPayload>[]
          }
          create: {
            args: Prisma.regionCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$regionPayload>
          }
          createMany: {
            args: Prisma.regionCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          delete: {
            args: Prisma.regionDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$regionPayload>
          }
          update: {
            args: Prisma.regionUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$regionPayload>
          }
          deleteMany: {
            args: Prisma.regionDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.regionUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          upsert: {
            args: Prisma.regionUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$regionPayload>
          }
          aggregate: {
            args: Prisma.RegionAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateRegion>
          }
          groupBy: {
            args: Prisma.regionGroupByArgs<ExtArgs>
            result: $Utils.Optional<RegionGroupByOutputType>[]
          }
          findRaw: {
            args: Prisma.regionFindRawArgs<ExtArgs>
            result: JsonObject
          }
          aggregateRaw: {
            args: Prisma.regionAggregateRawArgs<ExtArgs>
            result: JsonObject
          }
          count: {
            args: Prisma.regionCountArgs<ExtArgs>
            result: $Utils.Optional<RegionCountAggregateOutputType> | number
          }
        }
      }
    }
  } & {
    other: {
      payload: any
      operations: {
        $runCommandRaw: {
          args: Prisma.InputJsonObject,
          result: Prisma.JsonObject
        }
      }
    }
  }
  export const defineExtension: $Extensions.ExtendsHook<"define", Prisma.TypeMapCb, $Extensions.DefaultArgs>
  export type DefaultPrismaClient = PrismaClient
  export type ErrorFormat = 'pretty' | 'colorless' | 'minimal'
  export interface PrismaClientOptions {
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasources?: Datasources
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasourceUrl?: string
    /**
     * @default "colorless"
     */
    errorFormat?: ErrorFormat
    /**
     * @example
     * ```
     * // Defaults to stdout
     * log: ['query', 'info', 'warn', 'error']
     * 
     * // Emit as events
     * log: [
     *   { emit: 'stdout', level: 'query' },
     *   { emit: 'stdout', level: 'info' },
     *   { emit: 'stdout', level: 'warn' }
     *   { emit: 'stdout', level: 'error' }
     * ]
     * ```
     * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/logging#the-log-option).
     */
    log?: (LogLevel | LogDefinition)[]
    /**
     * The default values for transactionOptions
     * maxWait ?= 2000
     * timeout ?= 5000
     */
    transactionOptions?: {
      maxWait?: number
      timeout?: number
    }
    /**
     * Global configuration for omitting model fields by default.
     * 
     * @example
     * ```
     * const prisma = new PrismaClient({
     *   omit: {
     *     user: {
     *       password: true
     *     }
     *   }
     * })
     * ```
     */
    omit?: Prisma.GlobalOmitConfig
  }
  export type GlobalOmitConfig = {
    schema__?: schema__Omit
    account?: accountOmit
    account_tracker?: account_trackerOmit
    accountusage?: accountusageOmit
    auth_group?: auth_groupOmit
    auth_group_permissions?: auth_group_permissionsOmit
    auth_permission?: auth_permissionOmit
    authtoken_token?: authtoken_tokenOmit
    competitors?: competitorsOmit
    django_admin_log?: django_admin_logOmit
    django_content_type?: django_content_typeOmit
    django_migrations?: django_migrationsOmit
    django_session?: django_sessionOmit
    group?: GroupOmit
    keyword?: keywordOmit
    keyword_metrics?: keyword_metricsOmit
    language?: languageOmit
    mainsettings?: mainsettingsOmit
    region?: regionOmit
  }

  /* Types for Logging */
  export type LogLevel = 'info' | 'query' | 'warn' | 'error'
  export type LogDefinition = {
    level: LogLevel
    emit: 'stdout' | 'event'
  }

  export type GetLogType<T extends LogLevel | LogDefinition> = T extends LogDefinition ? T['emit'] extends 'event' ? T['level'] : never : never
  export type GetEvents<T extends any> = T extends Array<LogLevel | LogDefinition> ?
    GetLogType<T[0]> | GetLogType<T[1]> | GetLogType<T[2]> | GetLogType<T[3]>
    : never

  export type QueryEvent = {
    timestamp: Date
    query: string
    params: string
    duration: number
    target: string
  }

  export type LogEvent = {
    timestamp: Date
    message: string
    target: string
  }
  /* End Types for Logging */


  export type PrismaAction =
    | 'findUnique'
    | 'findUniqueOrThrow'
    | 'findMany'
    | 'findFirst'
    | 'findFirstOrThrow'
    | 'create'
    | 'createMany'
    | 'createManyAndReturn'
    | 'update'
    | 'updateMany'
    | 'updateManyAndReturn'
    | 'upsert'
    | 'delete'
    | 'deleteMany'
    | 'executeRaw'
    | 'queryRaw'
    | 'aggregate'
    | 'count'
    | 'runCommandRaw'
    | 'findRaw'
    | 'groupBy'

  /**
   * These options are being passed into the middleware as "params"
   */
  export type MiddlewareParams = {
    model?: ModelName
    action: PrismaAction
    args: any
    dataPath: string[]
    runInTransaction: boolean
  }

  /**
   * The `T` type makes sure, that the `return proceed` is not forgotten in the middleware implementation
   */
  export type Middleware<T = any> = (
    params: MiddlewareParams,
    next: (params: MiddlewareParams) => $Utils.JsPromise<T>,
  ) => $Utils.JsPromise<T>

  // tested in getLogLevel.test.ts
  export function getLogLevel(log: Array<LogLevel | LogDefinition>): LogLevel | undefined;

  /**
   * `PrismaClient` proxy available in interactive transactions.
   */
  export type TransactionClient = Omit<Prisma.DefaultPrismaClient, runtime.ITXClientDenyList>

  export type Datasource = {
    url?: string
  }

  /**
   * Count Types
   */



  /**
   * Models
   */

  /**
   * Model CompetitorsKeywords
   */





  export type CompetitorsKeywordsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    keyword?: boolean
    rank?: boolean
  }, ExtArgs["result"]["competitorsKeywords"]>



  export type CompetitorsKeywordsSelectScalar = {
    keyword?: boolean
    rank?: boolean
  }

  export type CompetitorsKeywordsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"keyword" | "rank", ExtArgs["result"]["competitorsKeywords"]>

  export type $CompetitorsKeywordsPayload = {
    name: "CompetitorsKeywords"
    objects: {}
    scalars: {
      keyword: string
      rank: number
    }
    composites: {}
  }

  type CompetitorsKeywordsGetPayload<S extends boolean | null | undefined | CompetitorsKeywordsDefaultArgs> = $Result.GetResult<Prisma.$CompetitorsKeywordsPayload, S>





  /**
   * Fields of the CompetitorsKeywords model
   */ 
  interface CompetitorsKeywordsFieldRefs {
    readonly keyword: FieldRef<"CompetitorsKeywords", 'String'>
    readonly rank: FieldRef<"CompetitorsKeywords", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * CompetitorsKeywords without action
   */
  export type CompetitorsKeywordsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CompetitorsKeywords
     */
    select?: CompetitorsKeywordsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the CompetitorsKeywords
     */
    omit?: CompetitorsKeywordsOmit<ExtArgs> | null
  }


  /**
   * Model KeywordRankHistory
   */





  export type KeywordRankHistorySelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    date?: boolean
    month?: boolean
    rank?: boolean
    year?: boolean
  }, ExtArgs["result"]["keywordRankHistory"]>



  export type KeywordRankHistorySelectScalar = {
    date?: boolean
    month?: boolean
    rank?: boolean
    year?: boolean
  }

  export type KeywordRankHistoryOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"date" | "month" | "rank" | "year", ExtArgs["result"]["keywordRankHistory"]>

  export type $KeywordRankHistoryPayload = {
    name: "KeywordRankHistory"
    objects: {}
    scalars: {
      date: number
      month: number
      rank: number
      year: number
    }
    composites: {}
  }

  type KeywordRankHistoryGetPayload<S extends boolean | null | undefined | KeywordRankHistoryDefaultArgs> = $Result.GetResult<Prisma.$KeywordRankHistoryPayload, S>





  /**
   * Fields of the KeywordRankHistory model
   */ 
  interface KeywordRankHistoryFieldRefs {
    readonly date: FieldRef<"KeywordRankHistory", 'Int'>
    readonly month: FieldRef<"KeywordRankHistory", 'Int'>
    readonly rank: FieldRef<"KeywordRankHistory", 'Int'>
    readonly year: FieldRef<"KeywordRankHistory", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * KeywordRankHistory without action
   */
  export type KeywordRankHistoryDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the KeywordRankHistory
     */
    select?: KeywordRankHistorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the KeywordRankHistory
     */
    omit?: KeywordRankHistoryOmit<ExtArgs> | null
  }


  /**
   * Model KeywordSearchVolumeData
   */





  export type KeywordSearchVolumeDataSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    month?: boolean
    search_volume?: boolean
    year?: boolean
  }, ExtArgs["result"]["keywordSearchVolumeData"]>



  export type KeywordSearchVolumeDataSelectScalar = {
    month?: boolean
    search_volume?: boolean
    year?: boolean
  }

  export type KeywordSearchVolumeDataOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"month" | "search_volume" | "year", ExtArgs["result"]["keywordSearchVolumeData"]>

  export type $KeywordSearchVolumeDataPayload = {
    name: "KeywordSearchVolumeData"
    objects: {}
    scalars: {
      month: number
      search_volume: number
      year: number
    }
    composites: {}
  }

  type KeywordSearchVolumeDataGetPayload<S extends boolean | null | undefined | KeywordSearchVolumeDataDefaultArgs> = $Result.GetResult<Prisma.$KeywordSearchVolumeDataPayload, S>





  /**
   * Fields of the KeywordSearchVolumeData model
   */ 
  interface KeywordSearchVolumeDataFieldRefs {
    readonly month: FieldRef<"KeywordSearchVolumeData", 'Int'>
    readonly search_volume: FieldRef<"KeywordSearchVolumeData", 'Int'>
    readonly year: FieldRef<"KeywordSearchVolumeData", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * KeywordSearchVolumeData without action
   */
  export type KeywordSearchVolumeDataDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the KeywordSearchVolumeData
     */
    select?: KeywordSearchVolumeDataSelect<ExtArgs> | null
    /**
     * Omit specific fields from the KeywordSearchVolumeData
     */
    omit?: KeywordSearchVolumeDataOmit<ExtArgs> | null
  }


  /**
   * Model SchemaAuto
   */





  export type SchemaAutoSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    field_names?: boolean
    seq?: boolean
  }, ExtArgs["result"]["schemaAuto"]>



  export type SchemaAutoSelectScalar = {
    field_names?: boolean
    seq?: boolean
  }

  export type SchemaAutoOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"field_names" | "seq", ExtArgs["result"]["schemaAuto"]>

  export type $SchemaAutoPayload = {
    name: "SchemaAuto"
    objects: {}
    scalars: {
      field_names: string[]
      seq: number
    }
    composites: {}
  }

  type SchemaAutoGetPayload<S extends boolean | null | undefined | SchemaAutoDefaultArgs> = $Result.GetResult<Prisma.$SchemaAutoPayload, S>





  /**
   * Fields of the SchemaAuto model
   */ 
  interface SchemaAutoFieldRefs {
    readonly field_names: FieldRef<"SchemaAuto", 'String[]'>
    readonly seq: FieldRef<"SchemaAuto", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * SchemaAuto without action
   */
  export type SchemaAutoDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaAuto
     */
    select?: SchemaAutoSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaAuto
     */
    omit?: SchemaAutoOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFields
   */





  export type SchemaFieldsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    account_status?: boolean | SchemaFieldsAccountStatusDefaultArgs<ExtArgs>
    action_flag?: boolean | SchemaFieldsActionFlagDefaultArgs<ExtArgs>
    action_time?: boolean | SchemaFieldsActionTimeDefaultArgs<ExtArgs>
    app?: boolean | SchemaFieldsAppDefaultArgs<ExtArgs>
    app_label?: boolean | SchemaFieldsAppLabelDefaultArgs<ExtArgs>
    applied?: boolean | SchemaFieldsAppliedDefaultArgs<ExtArgs>
    auto_call_status?: boolean | SchemaFieldsAutoCallStatusDefaultArgs<ExtArgs>
    auto_refresh_count?: boolean | SchemaFieldsAutoRefreshCountDefaultArgs<ExtArgs>
    change_message?: boolean | SchemaFieldsChangeMessageDefaultArgs<ExtArgs>
    city?: boolean | SchemaFieldsCityDefaultArgs<ExtArgs>
    client_agent?: boolean | SchemaFieldsClientAgentDefaultArgs<ExtArgs>
    client_ip?: boolean | SchemaFieldsClientIpDefaultArgs<ExtArgs>
    codename?: boolean | SchemaFieldsCodenameDefaultArgs<ExtArgs>
    content_type_id?: boolean | SchemaFieldsContentTypeIdDefaultArgs<ExtArgs>
    core_manual_mail?: boolean | SchemaFieldsCoreManualMailDefaultArgs<ExtArgs>
    core_mode?: boolean | SchemaFieldsCoreModeDefaultArgs<ExtArgs>
    core_refresh_time?: boolean | SchemaFieldsCoreRefreshTimeDefaultArgs<ExtArgs>
    country?: boolean | SchemaFieldsCountryDefaultArgs<ExtArgs>
    country_code?: boolean | SchemaFieldsCountryCodeDefaultArgs<ExtArgs>
    cpc?: boolean | SchemaFieldsCpcDefaultArgs<ExtArgs>
    crawlurl?: boolean | SchemaFieldsCrawlurlDefaultArgs<ExtArgs>
    created?: boolean | SchemaFieldsCreatedDefaultArgs<ExtArgs>
    created_date?: boolean | SchemaFieldsCreatedDateDefaultArgs<ExtArgs>
    date_joined?: boolean | SchemaFieldsDateJoinedDefaultArgs<ExtArgs>
    daymark?: boolean | SchemaFieldsDaymarkDefaultArgs<ExtArgs>
    dayval?: boolean | SchemaFieldsDayvalDefaultArgs<ExtArgs>
    domain_name?: boolean | SchemaFieldsDomainNameDefaultArgs<ExtArgs>
    downtrend_cnt?: boolean | SchemaFieldsDowntrendCntDefaultArgs<ExtArgs>
    email?: boolean | SchemaFieldsEmailDefaultArgs<ExtArgs>
    exactdomain?: boolean | SchemaFieldsExactdomainDefaultArgs<ExtArgs>
    expire_date?: boolean | SchemaFieldsExpireDateDefaultArgs<ExtArgs>
    fb_user_id?: boolean | SchemaFieldsFbUserIdDefaultArgs<ExtArgs>
    fk_group_id?: boolean | SchemaFieldsFkGroupIdDefaultArgs<ExtArgs>
    fk_keyword_id?: boolean | SchemaFieldsFkKeywordIdDefaultArgs<ExtArgs>
    fk_user_id?: boolean | SchemaFieldsFkUserIdDefaultArgs<ExtArgs>
    group_call_end?: boolean | SchemaFieldsGroupCallEndDefaultArgs<ExtArgs>
    group_call_start?: boolean | SchemaFieldsGroupCallStartDefaultArgs<ExtArgs>
    group_call_status?: boolean | SchemaFieldsGroupCallStatusDefaultArgs<ExtArgs>
    group_id?: boolean | SchemaFieldsGroupIdDefaultArgs<ExtArgs>
    group_name?: boolean | SchemaFieldsGroupNameDefaultArgs<ExtArgs>
    halfmonthmark?: boolean | SchemaFieldsHalfmonthmarkDefaultArgs<ExtArgs>
    halfmonthval?: boolean | SchemaFieldsHalfmonthvalDefaultArgs<ExtArgs>
    id?: boolean | SchemaFieldsIdDefaultArgs<ExtArgs>
    is_active?: boolean | SchemaFieldsIsActiveDefaultArgs<ExtArgs>
    is_admin?: boolean | SchemaFieldsIsAdminDefaultArgs<ExtArgs>
    is_staff?: boolean | SchemaFieldsIsStaffDefaultArgs<ExtArgs>
    is_superuser?: boolean | SchemaFieldsIsSuperuserDefaultArgs<ExtArgs>
    isocode?: boolean | SchemaFieldsIsocodeDefaultArgs<ExtArgs>
    key?: boolean | SchemaFieldsKeyDefaultArgs<ExtArgs>
    keyword?: boolean | SchemaFieldsKeywordDefaultArgs<ExtArgs>
    keyword_difficulty?: boolean | SchemaFieldsKeywordDifficultyDefaultArgs<ExtArgs>
    keyword_slug?: boolean | SchemaFieldsKeywordSlugDefaultArgs<ExtArgs>
    language?: boolean | SchemaFieldsLanguageDefaultArgs<ExtArgs>
    language_code?: boolean | SchemaFieldsLanguageCodeDefaultArgs<ExtArgs>
    language_name?: boolean | SchemaFieldsLanguageNameDefaultArgs<ExtArgs>
    last_home_visit?: boolean | SchemaFieldsLastHomeVisitDefaultArgs<ExtArgs>
    last_login?: boolean | SchemaFieldsLastLoginDefaultArgs<ExtArgs>
    last_logout?: boolean | SchemaFieldsLastLogoutDefaultArgs<ExtArgs>
    lastranked_date?: boolean | SchemaFieldsLastrankedDateDefaultArgs<ExtArgs>
    location?: boolean | SchemaFieldsLocationDefaultArgs<ExtArgs>
    location_code?: boolean | SchemaFieldsLocationCodeDefaultArgs<ExtArgs>
    metric_status?: boolean | SchemaFieldsMetricStatusDefaultArgs<ExtArgs>
    mobile?: boolean | SchemaFieldsMobileDefaultArgs<ExtArgs>
    model?: boolean | SchemaFieldsModelDefaultArgs<ExtArgs>
    modified_date?: boolean | SchemaFieldsModifiedDateDefaultArgs<ExtArgs>
    monthmark?: boolean | SchemaFieldsMonthmarkDefaultArgs<ExtArgs>
    monthval?: boolean | SchemaFieldsMonthvalDefaultArgs<ExtArgs>
    name?: boolean | SchemaFieldsNameDefaultArgs<ExtArgs>
    object_id?: boolean | SchemaFieldsObjectIdDefaultArgs<ExtArgs>
    object_repr?: boolean | SchemaFieldsObjectReprDefaultArgs<ExtArgs>
    page_uuid?: boolean | SchemaFieldsPageUuidDefaultArgs<ExtArgs>
    page_uuid_url?: boolean | SchemaFieldsPageUuidUrlDefaultArgs<ExtArgs>
    password?: boolean | SchemaFieldsPasswordDefaultArgs<ExtArgs>
    permission_id?: boolean | SchemaFieldsPermissionIdDefaultArgs<ExtArgs>
    plan_keyword_limit?: boolean | SchemaFieldsPlanKeywordLimitDefaultArgs<ExtArgs>
    plan_project_limit?: boolean | SchemaFieldsPlanProjectLimitDefaultArgs<ExtArgs>
    platform?: boolean | SchemaFieldsPlatformDefaultArgs<ExtArgs>
    project_automation_time?: boolean | SchemaFieldsProjectAutomationTimeDefaultArgs<ExtArgs>
    proxy_exceeds_count?: boolean | SchemaFieldsProxyExceedsCountDefaultArgs<ExtArgs>
    proxy_invalid_count?: boolean | SchemaFieldsProxyInvalidCountDefaultArgs<ExtArgs>
    proxy_maximum_load_limit?: boolean | SchemaFieldsProxyMaximumLoadLimitDefaultArgs<ExtArgs>
    proxy_reset_counter?: boolean | SchemaFieldsProxyResetCounterDefaultArgs<ExtArgs>
    proxy_success_count?: boolean | SchemaFieldsProxySuccessCountDefaultArgs<ExtArgs>
    rank_sincestart?: boolean | SchemaFieldsRankSincestartDefaultArgs<ExtArgs>
    rank_trend?: boolean | SchemaFieldsRankTrendDefaultArgs<ExtArgs>
    ranked_url?: boolean | SchemaFieldsRankedUrlDefaultArgs<ExtArgs>
    ranknow?: boolean | SchemaFieldsRanknowDefaultArgs<ExtArgs>
    region?: boolean | SchemaFieldsRegionDefaultArgs<ExtArgs>
    region_code?: boolean | SchemaFieldsRegionCodeDefaultArgs<ExtArgs>
    region_country?: boolean | SchemaFieldsRegionCountryDefaultArgs<ExtArgs>
    region_name?: boolean | SchemaFieldsRegionNameDefaultArgs<ExtArgs>
    results_per_page?: boolean | SchemaFieldsResultsPerPageDefaultArgs<ExtArgs>
    search_intent?: boolean | SchemaFieldsSearchIntentDefaultArgs<ExtArgs>
    search_volume?: boolean | SchemaFieldsSearchVolumeDefaultArgs<ExtArgs>
    searchvolume_country_id?: boolean | SchemaFieldsSearchvolumeCountryIdDefaultArgs<ExtArgs>
    session_data?: boolean | SchemaFieldsSessionDataDefaultArgs<ExtArgs>
    session_key?: boolean | SchemaFieldsSessionKeyDefaultArgs<ExtArgs>
    site_url?: boolean | SchemaFieldsSiteUrlDefaultArgs<ExtArgs>
    status?: boolean | SchemaFieldsStatusDefaultArgs<ExtArgs>
    status_from_start?: boolean | SchemaFieldsStatusFromStartDefaultArgs<ExtArgs>
    target?: boolean | SchemaFieldsTargetDefaultArgs<ExtArgs>
    time_zone?: boolean | SchemaFieldsTimeZoneDefaultArgs<ExtArgs>
    top_rank?: boolean | SchemaFieldsTopRankDefaultArgs<ExtArgs>
    track_status?: boolean | SchemaFieldsTrackStatusDefaultArgs<ExtArgs>
    traffic?: boolean | SchemaFieldsTrafficDefaultArgs<ExtArgs>
    updated_date?: boolean | SchemaFieldsUpdatedDateDefaultArgs<ExtArgs>
    uptrend_cnt?: boolean | SchemaFieldsUptrendCntDefaultArgs<ExtArgs>
    url?: boolean | SchemaFieldsUrlDefaultArgs<ExtArgs>
    user_automation_time?: boolean | SchemaFieldsUserAutomationTimeDefaultArgs<ExtArgs>
    user_id?: boolean | SchemaFieldsUserIdDefaultArgs<ExtArgs>
    username?: boolean | SchemaFieldsUsernameDefaultArgs<ExtArgs>
    weekmark?: boolean | SchemaFieldsWeekmarkDefaultArgs<ExtArgs>
    weekval?: boolean | SchemaFieldsWeekvalDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["schemaFields"]>



  export type SchemaFieldsSelectScalar = {}

  export type SchemaFieldsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"account_status" | "action_flag" | "action_time" | "app" | "app_label" | "applied" | "auto_call_status" | "auto_refresh_count" | "change_message" | "city" | "client_agent" | "client_ip" | "codename" | "content_type_id" | "core_manual_mail" | "core_mode" | "core_refresh_time" | "country" | "country_code" | "cpc" | "crawlurl" | "created" | "created_date" | "date_joined" | "daymark" | "dayval" | "domain_name" | "downtrend_cnt" | "email" | "exactdomain" | "expire_date" | "fb_user_id" | "fk_group_id" | "fk_keyword_id" | "fk_user_id" | "group_call_end" | "group_call_start" | "group_call_status" | "group_id" | "group_name" | "halfmonthmark" | "halfmonthval" | "id" | "is_active" | "is_admin" | "is_staff" | "is_superuser" | "isocode" | "key" | "keyword" | "keyword_difficulty" | "keyword_slug" | "language" | "language_code" | "language_name" | "last_home_visit" | "last_login" | "last_logout" | "lastranked_date" | "location" | "location_code" | "metric_status" | "mobile" | "model" | "modified_date" | "monthmark" | "monthval" | "name" | "object_id" | "object_repr" | "page_uuid" | "page_uuid_url" | "password" | "permission_id" | "plan_keyword_limit" | "plan_project_limit" | "platform" | "project_automation_time" | "proxy_exceeds_count" | "proxy_invalid_count" | "proxy_maximum_load_limit" | "proxy_reset_counter" | "proxy_success_count" | "rank_sincestart" | "rank_trend" | "ranked_url" | "ranknow" | "region" | "region_code" | "region_country" | "region_name" | "results_per_page" | "search_intent" | "search_volume" | "searchvolume_country_id" | "session_data" | "session_key" | "site_url" | "status" | "status_from_start" | "target" | "time_zone" | "top_rank" | "track_status" | "traffic" | "updated_date" | "uptrend_cnt" | "url" | "user_automation_time" | "user_id" | "username" | "weekmark" | "weekval", ExtArgs["result"]["schemaFields"]>
  export type SchemaFieldsInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {}

  export type $SchemaFieldsPayload = {
    name: "SchemaFields"
    objects: {}
    scalars: {}
    composites: {
      account_status: Prisma.$SchemaFieldsAccountStatusPayload | null
      action_flag: Prisma.$SchemaFieldsActionFlagPayload | null
      action_time: Prisma.$SchemaFieldsActionTimePayload | null
      app: Prisma.$SchemaFieldsAppPayload | null
      app_label: Prisma.$SchemaFieldsAppLabelPayload | null
      applied: Prisma.$SchemaFieldsAppliedPayload | null
      auto_call_status: Prisma.$SchemaFieldsAutoCallStatusPayload | null
      auto_refresh_count: Prisma.$SchemaFieldsAutoRefreshCountPayload | null
      change_message: Prisma.$SchemaFieldsChangeMessagePayload | null
      city: Prisma.$SchemaFieldsCityPayload | null
      client_agent: Prisma.$SchemaFieldsClientAgentPayload | null
      client_ip: Prisma.$SchemaFieldsClientIpPayload | null
      codename: Prisma.$SchemaFieldsCodenamePayload | null
      content_type_id: Prisma.$SchemaFieldsContentTypeIdPayload | null
      core_manual_mail: Prisma.$SchemaFieldsCoreManualMailPayload | null
      core_mode: Prisma.$SchemaFieldsCoreModePayload | null
      core_refresh_time: Prisma.$SchemaFieldsCoreRefreshTimePayload | null
      country: Prisma.$SchemaFieldsCountryPayload | null
      country_code: Prisma.$SchemaFieldsCountryCodePayload | null
      cpc: Prisma.$SchemaFieldsCpcPayload | null
      crawlurl: Prisma.$SchemaFieldsCrawlurlPayload | null
      created: Prisma.$SchemaFieldsCreatedPayload | null
      created_date: Prisma.$SchemaFieldsCreatedDatePayload | null
      date_joined: Prisma.$SchemaFieldsDateJoinedPayload | null
      daymark: Prisma.$SchemaFieldsDaymarkPayload | null
      dayval: Prisma.$SchemaFieldsDayvalPayload | null
      domain_name: Prisma.$SchemaFieldsDomainNamePayload | null
      downtrend_cnt: Prisma.$SchemaFieldsDowntrendCntPayload | null
      email: Prisma.$SchemaFieldsEmailPayload | null
      exactdomain: Prisma.$SchemaFieldsExactdomainPayload | null
      expire_date: Prisma.$SchemaFieldsExpireDatePayload | null
      fb_user_id: Prisma.$SchemaFieldsFbUserIdPayload | null
      fk_group_id: Prisma.$SchemaFieldsFkGroupIdPayload | null
      fk_keyword_id: Prisma.$SchemaFieldsFkKeywordIdPayload | null
      fk_user_id: Prisma.$SchemaFieldsFkUserIdPayload | null
      group_call_end: Prisma.$SchemaFieldsGroupCallEndPayload | null
      group_call_start: Prisma.$SchemaFieldsGroupCallStartPayload | null
      group_call_status: Prisma.$SchemaFieldsGroupCallStatusPayload | null
      group_id: Prisma.$SchemaFieldsGroupIdPayload | null
      group_name: Prisma.$SchemaFieldsGroupNamePayload | null
      halfmonthmark: Prisma.$SchemaFieldsHalfmonthmarkPayload | null
      halfmonthval: Prisma.$SchemaFieldsHalfmonthvalPayload | null
      id: Prisma.$SchemaFieldsIdPayload | null
      is_active: Prisma.$SchemaFieldsIsActivePayload | null
      is_admin: Prisma.$SchemaFieldsIsAdminPayload | null
      is_staff: Prisma.$SchemaFieldsIsStaffPayload | null
      is_superuser: Prisma.$SchemaFieldsIsSuperuserPayload | null
      isocode: Prisma.$SchemaFieldsIsocodePayload | null
      key: Prisma.$SchemaFieldsKeyPayload | null
      keyword: Prisma.$SchemaFieldsKeywordPayload | null
      keyword_difficulty: Prisma.$SchemaFieldsKeywordDifficultyPayload | null
      keyword_slug: Prisma.$SchemaFieldsKeywordSlugPayload | null
      language: Prisma.$SchemaFieldsLanguagePayload | null
      language_code: Prisma.$SchemaFieldsLanguageCodePayload | null
      language_name: Prisma.$SchemaFieldsLanguageNamePayload | null
      last_home_visit: Prisma.$SchemaFieldsLastHomeVisitPayload | null
      last_login: Prisma.$SchemaFieldsLastLoginPayload | null
      last_logout: Prisma.$SchemaFieldsLastLogoutPayload | null
      lastranked_date: Prisma.$SchemaFieldsLastrankedDatePayload | null
      location: Prisma.$SchemaFieldsLocationPayload | null
      location_code: Prisma.$SchemaFieldsLocationCodePayload | null
      metric_status: Prisma.$SchemaFieldsMetricStatusPayload | null
      mobile: Prisma.$SchemaFieldsMobilePayload | null
      model: Prisma.$SchemaFieldsModelPayload | null
      modified_date: Prisma.$SchemaFieldsModifiedDatePayload | null
      monthmark: Prisma.$SchemaFieldsMonthmarkPayload | null
      monthval: Prisma.$SchemaFieldsMonthvalPayload | null
      name: Prisma.$SchemaFieldsNamePayload | null
      object_id: Prisma.$SchemaFieldsObjectIdPayload | null
      object_repr: Prisma.$SchemaFieldsObjectReprPayload | null
      page_uuid: Prisma.$SchemaFieldsPageUuidPayload | null
      page_uuid_url: Prisma.$SchemaFieldsPageUuidUrlPayload | null
      password: Prisma.$SchemaFieldsPasswordPayload | null
      permission_id: Prisma.$SchemaFieldsPermissionIdPayload | null
      plan_keyword_limit: Prisma.$SchemaFieldsPlanKeywordLimitPayload | null
      plan_project_limit: Prisma.$SchemaFieldsPlanProjectLimitPayload | null
      platform: Prisma.$SchemaFieldsPlatformPayload | null
      project_automation_time: Prisma.$SchemaFieldsProjectAutomationTimePayload | null
      proxy_exceeds_count: Prisma.$SchemaFieldsProxyExceedsCountPayload | null
      proxy_invalid_count: Prisma.$SchemaFieldsProxyInvalidCountPayload | null
      proxy_maximum_load_limit: Prisma.$SchemaFieldsProxyMaximumLoadLimitPayload | null
      proxy_reset_counter: Prisma.$SchemaFieldsProxyResetCounterPayload | null
      proxy_success_count: Prisma.$SchemaFieldsProxySuccessCountPayload | null
      rank_sincestart: Prisma.$SchemaFieldsRankSincestartPayload | null
      rank_trend: Prisma.$SchemaFieldsRankTrendPayload | null
      ranked_url: Prisma.$SchemaFieldsRankedUrlPayload | null
      ranknow: Prisma.$SchemaFieldsRanknowPayload | null
      region: Prisma.$SchemaFieldsRegionPayload | null
      region_code: Prisma.$SchemaFieldsRegionCodePayload | null
      region_country: Prisma.$SchemaFieldsRegionCountryPayload | null
      region_name: Prisma.$SchemaFieldsRegionNamePayload | null
      results_per_page: Prisma.$SchemaFieldsResultsPerPagePayload | null
      search_intent: Prisma.$SchemaFieldsSearchIntentPayload | null
      search_volume: Prisma.$SchemaFieldsSearchVolumePayload | null
      searchvolume_country_id: Prisma.$SchemaFieldsSearchvolumeCountryIdPayload | null
      session_data: Prisma.$SchemaFieldsSessionDataPayload | null
      session_key: Prisma.$SchemaFieldsSessionKeyPayload | null
      site_url: Prisma.$SchemaFieldsSiteUrlPayload | null
      status: Prisma.$SchemaFieldsStatusPayload | null
      status_from_start: Prisma.$SchemaFieldsStatusFromStartPayload | null
      target: Prisma.$SchemaFieldsTargetPayload | null
      time_zone: Prisma.$SchemaFieldsTimeZonePayload | null
      top_rank: Prisma.$SchemaFieldsTopRankPayload | null
      track_status: Prisma.$SchemaFieldsTrackStatusPayload | null
      traffic: Prisma.$SchemaFieldsTrafficPayload | null
      updated_date: Prisma.$SchemaFieldsUpdatedDatePayload | null
      uptrend_cnt: Prisma.$SchemaFieldsUptrendCntPayload | null
      url: Prisma.$SchemaFieldsUrlPayload | null
      user_automation_time: Prisma.$SchemaFieldsUserAutomationTimePayload | null
      user_id: Prisma.$SchemaFieldsUserIdPayload | null
      username: Prisma.$SchemaFieldsUsernamePayload | null
      weekmark: Prisma.$SchemaFieldsWeekmarkPayload | null
      weekval: Prisma.$SchemaFieldsWeekvalPayload | null
    }
  }

  type SchemaFieldsGetPayload<S extends boolean | null | undefined | SchemaFieldsDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsPayload, S>





  /**
   * Fields of the SchemaFields model
   */ 
  interface SchemaFieldsFieldRefs {

  }
    

  // Custom InputTypes
  /**
   * SchemaFields without action
   */
  export type SchemaFieldsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFields
     */
    select?: SchemaFieldsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFields
     */
    omit?: SchemaFieldsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: SchemaFieldsInclude<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsAccountStatus
   */





  export type SchemaFieldsAccountStatusSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsAccountStatus"]>



  export type SchemaFieldsAccountStatusSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsAccountStatusOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsAccountStatus"]>

  export type $SchemaFieldsAccountStatusPayload = {
    name: "SchemaFieldsAccountStatus"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsAccountStatusGetPayload<S extends boolean | null | undefined | SchemaFieldsAccountStatusDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsAccountStatusPayload, S>





  /**
   * Fields of the SchemaFieldsAccountStatus model
   */ 
  interface SchemaFieldsAccountStatusFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsAccountStatus", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsAccountStatus without action
   */
  export type SchemaFieldsAccountStatusDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsAccountStatus
     */
    select?: SchemaFieldsAccountStatusSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsAccountStatus
     */
    omit?: SchemaFieldsAccountStatusOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsActionFlag
   */





  export type SchemaFieldsActionFlagSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsActionFlag"]>



  export type SchemaFieldsActionFlagSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsActionFlagOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsActionFlag"]>

  export type $SchemaFieldsActionFlagPayload = {
    name: "SchemaFieldsActionFlag"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsActionFlagGetPayload<S extends boolean | null | undefined | SchemaFieldsActionFlagDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsActionFlagPayload, S>





  /**
   * Fields of the SchemaFieldsActionFlag model
   */ 
  interface SchemaFieldsActionFlagFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsActionFlag", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsActionFlag without action
   */
  export type SchemaFieldsActionFlagDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsActionFlag
     */
    select?: SchemaFieldsActionFlagSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsActionFlag
     */
    omit?: SchemaFieldsActionFlagOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsActionTime
   */





  export type SchemaFieldsActionTimeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsActionTime"]>



  export type SchemaFieldsActionTimeSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsActionTimeOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsActionTime"]>

  export type $SchemaFieldsActionTimePayload = {
    name: "SchemaFieldsActionTime"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsActionTimeGetPayload<S extends boolean | null | undefined | SchemaFieldsActionTimeDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsActionTimePayload, S>





  /**
   * Fields of the SchemaFieldsActionTime model
   */ 
  interface SchemaFieldsActionTimeFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsActionTime", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsActionTime without action
   */
  export type SchemaFieldsActionTimeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsActionTime
     */
    select?: SchemaFieldsActionTimeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsActionTime
     */
    omit?: SchemaFieldsActionTimeOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsApp
   */





  export type SchemaFieldsAppSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsApp"]>



  export type SchemaFieldsAppSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsAppOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsApp"]>

  export type $SchemaFieldsAppPayload = {
    name: "SchemaFieldsApp"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsAppGetPayload<S extends boolean | null | undefined | SchemaFieldsAppDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsAppPayload, S>





  /**
   * Fields of the SchemaFieldsApp model
   */ 
  interface SchemaFieldsAppFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsApp", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsApp without action
   */
  export type SchemaFieldsAppDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsApp
     */
    select?: SchemaFieldsAppSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsApp
     */
    omit?: SchemaFieldsAppOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsAppLabel
   */





  export type SchemaFieldsAppLabelSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsAppLabel"]>



  export type SchemaFieldsAppLabelSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsAppLabelOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsAppLabel"]>

  export type $SchemaFieldsAppLabelPayload = {
    name: "SchemaFieldsAppLabel"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsAppLabelGetPayload<S extends boolean | null | undefined | SchemaFieldsAppLabelDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsAppLabelPayload, S>





  /**
   * Fields of the SchemaFieldsAppLabel model
   */ 
  interface SchemaFieldsAppLabelFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsAppLabel", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsAppLabel without action
   */
  export type SchemaFieldsAppLabelDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsAppLabel
     */
    select?: SchemaFieldsAppLabelSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsAppLabel
     */
    omit?: SchemaFieldsAppLabelOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsApplied
   */





  export type SchemaFieldsAppliedSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsApplied"]>



  export type SchemaFieldsAppliedSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsAppliedOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsApplied"]>

  export type $SchemaFieldsAppliedPayload = {
    name: "SchemaFieldsApplied"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsAppliedGetPayload<S extends boolean | null | undefined | SchemaFieldsAppliedDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsAppliedPayload, S>





  /**
   * Fields of the SchemaFieldsApplied model
   */ 
  interface SchemaFieldsAppliedFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsApplied", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsApplied without action
   */
  export type SchemaFieldsAppliedDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsApplied
     */
    select?: SchemaFieldsAppliedSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsApplied
     */
    omit?: SchemaFieldsAppliedOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsAutoCallStatus
   */





  export type SchemaFieldsAutoCallStatusSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsAutoCallStatus"]>



  export type SchemaFieldsAutoCallStatusSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsAutoCallStatusOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsAutoCallStatus"]>

  export type $SchemaFieldsAutoCallStatusPayload = {
    name: "SchemaFieldsAutoCallStatus"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsAutoCallStatusGetPayload<S extends boolean | null | undefined | SchemaFieldsAutoCallStatusDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsAutoCallStatusPayload, S>





  /**
   * Fields of the SchemaFieldsAutoCallStatus model
   */ 
  interface SchemaFieldsAutoCallStatusFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsAutoCallStatus", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsAutoCallStatus without action
   */
  export type SchemaFieldsAutoCallStatusDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsAutoCallStatus
     */
    select?: SchemaFieldsAutoCallStatusSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsAutoCallStatus
     */
    omit?: SchemaFieldsAutoCallStatusOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsAutoRefreshCount
   */





  export type SchemaFieldsAutoRefreshCountSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsAutoRefreshCount"]>



  export type SchemaFieldsAutoRefreshCountSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsAutoRefreshCountOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsAutoRefreshCount"]>

  export type $SchemaFieldsAutoRefreshCountPayload = {
    name: "SchemaFieldsAutoRefreshCount"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsAutoRefreshCountGetPayload<S extends boolean | null | undefined | SchemaFieldsAutoRefreshCountDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsAutoRefreshCountPayload, S>





  /**
   * Fields of the SchemaFieldsAutoRefreshCount model
   */ 
  interface SchemaFieldsAutoRefreshCountFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsAutoRefreshCount", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsAutoRefreshCount without action
   */
  export type SchemaFieldsAutoRefreshCountDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsAutoRefreshCount
     */
    select?: SchemaFieldsAutoRefreshCountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsAutoRefreshCount
     */
    omit?: SchemaFieldsAutoRefreshCountOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsChangeMessage
   */





  export type SchemaFieldsChangeMessageSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsChangeMessage"]>



  export type SchemaFieldsChangeMessageSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsChangeMessageOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsChangeMessage"]>

  export type $SchemaFieldsChangeMessagePayload = {
    name: "SchemaFieldsChangeMessage"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsChangeMessageGetPayload<S extends boolean | null | undefined | SchemaFieldsChangeMessageDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsChangeMessagePayload, S>





  /**
   * Fields of the SchemaFieldsChangeMessage model
   */ 
  interface SchemaFieldsChangeMessageFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsChangeMessage", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsChangeMessage without action
   */
  export type SchemaFieldsChangeMessageDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsChangeMessage
     */
    select?: SchemaFieldsChangeMessageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsChangeMessage
     */
    omit?: SchemaFieldsChangeMessageOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsCity
   */





  export type SchemaFieldsCitySelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsCity"]>



  export type SchemaFieldsCitySelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsCityOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsCity"]>

  export type $SchemaFieldsCityPayload = {
    name: "SchemaFieldsCity"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsCityGetPayload<S extends boolean | null | undefined | SchemaFieldsCityDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsCityPayload, S>





  /**
   * Fields of the SchemaFieldsCity model
   */ 
  interface SchemaFieldsCityFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsCity", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsCity without action
   */
  export type SchemaFieldsCityDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsCity
     */
    select?: SchemaFieldsCitySelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsCity
     */
    omit?: SchemaFieldsCityOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsClientAgent
   */





  export type SchemaFieldsClientAgentSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsClientAgent"]>



  export type SchemaFieldsClientAgentSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsClientAgentOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsClientAgent"]>

  export type $SchemaFieldsClientAgentPayload = {
    name: "SchemaFieldsClientAgent"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsClientAgentGetPayload<S extends boolean | null | undefined | SchemaFieldsClientAgentDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsClientAgentPayload, S>





  /**
   * Fields of the SchemaFieldsClientAgent model
   */ 
  interface SchemaFieldsClientAgentFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsClientAgent", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsClientAgent without action
   */
  export type SchemaFieldsClientAgentDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsClientAgent
     */
    select?: SchemaFieldsClientAgentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsClientAgent
     */
    omit?: SchemaFieldsClientAgentOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsClientIp
   */





  export type SchemaFieldsClientIpSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsClientIp"]>



  export type SchemaFieldsClientIpSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsClientIpOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsClientIp"]>

  export type $SchemaFieldsClientIpPayload = {
    name: "SchemaFieldsClientIp"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsClientIpGetPayload<S extends boolean | null | undefined | SchemaFieldsClientIpDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsClientIpPayload, S>





  /**
   * Fields of the SchemaFieldsClientIp model
   */ 
  interface SchemaFieldsClientIpFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsClientIp", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsClientIp without action
   */
  export type SchemaFieldsClientIpDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsClientIp
     */
    select?: SchemaFieldsClientIpSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsClientIp
     */
    omit?: SchemaFieldsClientIpOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsCodename
   */





  export type SchemaFieldsCodenameSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsCodename"]>



  export type SchemaFieldsCodenameSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsCodenameOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsCodename"]>

  export type $SchemaFieldsCodenamePayload = {
    name: "SchemaFieldsCodename"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsCodenameGetPayload<S extends boolean | null | undefined | SchemaFieldsCodenameDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsCodenamePayload, S>





  /**
   * Fields of the SchemaFieldsCodename model
   */ 
  interface SchemaFieldsCodenameFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsCodename", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsCodename without action
   */
  export type SchemaFieldsCodenameDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsCodename
     */
    select?: SchemaFieldsCodenameSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsCodename
     */
    omit?: SchemaFieldsCodenameOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsContentTypeId
   */





  export type SchemaFieldsContentTypeIdSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsContentTypeId"]>



  export type SchemaFieldsContentTypeIdSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsContentTypeIdOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsContentTypeId"]>

  export type $SchemaFieldsContentTypeIdPayload = {
    name: "SchemaFieldsContentTypeId"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsContentTypeIdGetPayload<S extends boolean | null | undefined | SchemaFieldsContentTypeIdDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsContentTypeIdPayload, S>





  /**
   * Fields of the SchemaFieldsContentTypeId model
   */ 
  interface SchemaFieldsContentTypeIdFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsContentTypeId", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsContentTypeId without action
   */
  export type SchemaFieldsContentTypeIdDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsContentTypeId
     */
    select?: SchemaFieldsContentTypeIdSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsContentTypeId
     */
    omit?: SchemaFieldsContentTypeIdOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsCoreManualMail
   */





  export type SchemaFieldsCoreManualMailSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsCoreManualMail"]>



  export type SchemaFieldsCoreManualMailSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsCoreManualMailOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsCoreManualMail"]>

  export type $SchemaFieldsCoreManualMailPayload = {
    name: "SchemaFieldsCoreManualMail"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsCoreManualMailGetPayload<S extends boolean | null | undefined | SchemaFieldsCoreManualMailDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsCoreManualMailPayload, S>





  /**
   * Fields of the SchemaFieldsCoreManualMail model
   */ 
  interface SchemaFieldsCoreManualMailFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsCoreManualMail", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsCoreManualMail without action
   */
  export type SchemaFieldsCoreManualMailDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsCoreManualMail
     */
    select?: SchemaFieldsCoreManualMailSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsCoreManualMail
     */
    omit?: SchemaFieldsCoreManualMailOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsCoreMode
   */





  export type SchemaFieldsCoreModeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsCoreMode"]>



  export type SchemaFieldsCoreModeSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsCoreModeOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsCoreMode"]>

  export type $SchemaFieldsCoreModePayload = {
    name: "SchemaFieldsCoreMode"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsCoreModeGetPayload<S extends boolean | null | undefined | SchemaFieldsCoreModeDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsCoreModePayload, S>





  /**
   * Fields of the SchemaFieldsCoreMode model
   */ 
  interface SchemaFieldsCoreModeFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsCoreMode", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsCoreMode without action
   */
  export type SchemaFieldsCoreModeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsCoreMode
     */
    select?: SchemaFieldsCoreModeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsCoreMode
     */
    omit?: SchemaFieldsCoreModeOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsCoreRefreshTime
   */





  export type SchemaFieldsCoreRefreshTimeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsCoreRefreshTime"]>



  export type SchemaFieldsCoreRefreshTimeSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsCoreRefreshTimeOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsCoreRefreshTime"]>

  export type $SchemaFieldsCoreRefreshTimePayload = {
    name: "SchemaFieldsCoreRefreshTime"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsCoreRefreshTimeGetPayload<S extends boolean | null | undefined | SchemaFieldsCoreRefreshTimeDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsCoreRefreshTimePayload, S>





  /**
   * Fields of the SchemaFieldsCoreRefreshTime model
   */ 
  interface SchemaFieldsCoreRefreshTimeFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsCoreRefreshTime", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsCoreRefreshTime without action
   */
  export type SchemaFieldsCoreRefreshTimeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsCoreRefreshTime
     */
    select?: SchemaFieldsCoreRefreshTimeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsCoreRefreshTime
     */
    omit?: SchemaFieldsCoreRefreshTimeOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsCountry
   */





  export type SchemaFieldsCountrySelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsCountry"]>



  export type SchemaFieldsCountrySelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsCountryOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsCountry"]>

  export type $SchemaFieldsCountryPayload = {
    name: "SchemaFieldsCountry"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsCountryGetPayload<S extends boolean | null | undefined | SchemaFieldsCountryDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsCountryPayload, S>





  /**
   * Fields of the SchemaFieldsCountry model
   */ 
  interface SchemaFieldsCountryFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsCountry", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsCountry without action
   */
  export type SchemaFieldsCountryDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsCountry
     */
    select?: SchemaFieldsCountrySelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsCountry
     */
    omit?: SchemaFieldsCountryOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsCountryCode
   */





  export type SchemaFieldsCountryCodeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsCountryCode"]>



  export type SchemaFieldsCountryCodeSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsCountryCodeOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsCountryCode"]>

  export type $SchemaFieldsCountryCodePayload = {
    name: "SchemaFieldsCountryCode"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsCountryCodeGetPayload<S extends boolean | null | undefined | SchemaFieldsCountryCodeDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsCountryCodePayload, S>





  /**
   * Fields of the SchemaFieldsCountryCode model
   */ 
  interface SchemaFieldsCountryCodeFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsCountryCode", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsCountryCode without action
   */
  export type SchemaFieldsCountryCodeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsCountryCode
     */
    select?: SchemaFieldsCountryCodeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsCountryCode
     */
    omit?: SchemaFieldsCountryCodeOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsCpc
   */





  export type SchemaFieldsCpcSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsCpc"]>



  export type SchemaFieldsCpcSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsCpcOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsCpc"]>

  export type $SchemaFieldsCpcPayload = {
    name: "SchemaFieldsCpc"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsCpcGetPayload<S extends boolean | null | undefined | SchemaFieldsCpcDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsCpcPayload, S>





  /**
   * Fields of the SchemaFieldsCpc model
   */ 
  interface SchemaFieldsCpcFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsCpc", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsCpc without action
   */
  export type SchemaFieldsCpcDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsCpc
     */
    select?: SchemaFieldsCpcSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsCpc
     */
    omit?: SchemaFieldsCpcOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsCrawlurl
   */





  export type SchemaFieldsCrawlurlSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsCrawlurl"]>



  export type SchemaFieldsCrawlurlSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsCrawlurlOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsCrawlurl"]>

  export type $SchemaFieldsCrawlurlPayload = {
    name: "SchemaFieldsCrawlurl"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsCrawlurlGetPayload<S extends boolean | null | undefined | SchemaFieldsCrawlurlDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsCrawlurlPayload, S>





  /**
   * Fields of the SchemaFieldsCrawlurl model
   */ 
  interface SchemaFieldsCrawlurlFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsCrawlurl", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsCrawlurl without action
   */
  export type SchemaFieldsCrawlurlDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsCrawlurl
     */
    select?: SchemaFieldsCrawlurlSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsCrawlurl
     */
    omit?: SchemaFieldsCrawlurlOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsCreated
   */





  export type SchemaFieldsCreatedSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsCreated"]>



  export type SchemaFieldsCreatedSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsCreatedOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsCreated"]>

  export type $SchemaFieldsCreatedPayload = {
    name: "SchemaFieldsCreated"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsCreatedGetPayload<S extends boolean | null | undefined | SchemaFieldsCreatedDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsCreatedPayload, S>





  /**
   * Fields of the SchemaFieldsCreated model
   */ 
  interface SchemaFieldsCreatedFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsCreated", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsCreated without action
   */
  export type SchemaFieldsCreatedDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsCreated
     */
    select?: SchemaFieldsCreatedSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsCreated
     */
    omit?: SchemaFieldsCreatedOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsCreatedDate
   */





  export type SchemaFieldsCreatedDateSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsCreatedDate"]>



  export type SchemaFieldsCreatedDateSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsCreatedDateOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsCreatedDate"]>

  export type $SchemaFieldsCreatedDatePayload = {
    name: "SchemaFieldsCreatedDate"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsCreatedDateGetPayload<S extends boolean | null | undefined | SchemaFieldsCreatedDateDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsCreatedDatePayload, S>





  /**
   * Fields of the SchemaFieldsCreatedDate model
   */ 
  interface SchemaFieldsCreatedDateFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsCreatedDate", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsCreatedDate without action
   */
  export type SchemaFieldsCreatedDateDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsCreatedDate
     */
    select?: SchemaFieldsCreatedDateSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsCreatedDate
     */
    omit?: SchemaFieldsCreatedDateOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsDateJoined
   */





  export type SchemaFieldsDateJoinedSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsDateJoined"]>



  export type SchemaFieldsDateJoinedSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsDateJoinedOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsDateJoined"]>

  export type $SchemaFieldsDateJoinedPayload = {
    name: "SchemaFieldsDateJoined"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsDateJoinedGetPayload<S extends boolean | null | undefined | SchemaFieldsDateJoinedDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsDateJoinedPayload, S>





  /**
   * Fields of the SchemaFieldsDateJoined model
   */ 
  interface SchemaFieldsDateJoinedFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsDateJoined", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsDateJoined without action
   */
  export type SchemaFieldsDateJoinedDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsDateJoined
     */
    select?: SchemaFieldsDateJoinedSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsDateJoined
     */
    omit?: SchemaFieldsDateJoinedOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsDaymark
   */





  export type SchemaFieldsDaymarkSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsDaymark"]>



  export type SchemaFieldsDaymarkSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsDaymarkOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsDaymark"]>

  export type $SchemaFieldsDaymarkPayload = {
    name: "SchemaFieldsDaymark"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsDaymarkGetPayload<S extends boolean | null | undefined | SchemaFieldsDaymarkDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsDaymarkPayload, S>





  /**
   * Fields of the SchemaFieldsDaymark model
   */ 
  interface SchemaFieldsDaymarkFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsDaymark", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsDaymark without action
   */
  export type SchemaFieldsDaymarkDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsDaymark
     */
    select?: SchemaFieldsDaymarkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsDaymark
     */
    omit?: SchemaFieldsDaymarkOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsDayval
   */





  export type SchemaFieldsDayvalSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsDayval"]>



  export type SchemaFieldsDayvalSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsDayvalOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsDayval"]>

  export type $SchemaFieldsDayvalPayload = {
    name: "SchemaFieldsDayval"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsDayvalGetPayload<S extends boolean | null | undefined | SchemaFieldsDayvalDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsDayvalPayload, S>





  /**
   * Fields of the SchemaFieldsDayval model
   */ 
  interface SchemaFieldsDayvalFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsDayval", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsDayval without action
   */
  export type SchemaFieldsDayvalDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsDayval
     */
    select?: SchemaFieldsDayvalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsDayval
     */
    omit?: SchemaFieldsDayvalOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsDomainName
   */





  export type SchemaFieldsDomainNameSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsDomainName"]>



  export type SchemaFieldsDomainNameSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsDomainNameOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsDomainName"]>

  export type $SchemaFieldsDomainNamePayload = {
    name: "SchemaFieldsDomainName"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsDomainNameGetPayload<S extends boolean | null | undefined | SchemaFieldsDomainNameDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsDomainNamePayload, S>





  /**
   * Fields of the SchemaFieldsDomainName model
   */ 
  interface SchemaFieldsDomainNameFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsDomainName", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsDomainName without action
   */
  export type SchemaFieldsDomainNameDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsDomainName
     */
    select?: SchemaFieldsDomainNameSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsDomainName
     */
    omit?: SchemaFieldsDomainNameOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsDowntrendCnt
   */





  export type SchemaFieldsDowntrendCntSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsDowntrendCnt"]>



  export type SchemaFieldsDowntrendCntSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsDowntrendCntOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsDowntrendCnt"]>

  export type $SchemaFieldsDowntrendCntPayload = {
    name: "SchemaFieldsDowntrendCnt"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsDowntrendCntGetPayload<S extends boolean | null | undefined | SchemaFieldsDowntrendCntDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsDowntrendCntPayload, S>





  /**
   * Fields of the SchemaFieldsDowntrendCnt model
   */ 
  interface SchemaFieldsDowntrendCntFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsDowntrendCnt", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsDowntrendCnt without action
   */
  export type SchemaFieldsDowntrendCntDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsDowntrendCnt
     */
    select?: SchemaFieldsDowntrendCntSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsDowntrendCnt
     */
    omit?: SchemaFieldsDowntrendCntOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsEmail
   */





  export type SchemaFieldsEmailSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsEmail"]>



  export type SchemaFieldsEmailSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsEmailOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsEmail"]>

  export type $SchemaFieldsEmailPayload = {
    name: "SchemaFieldsEmail"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsEmailGetPayload<S extends boolean | null | undefined | SchemaFieldsEmailDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsEmailPayload, S>





  /**
   * Fields of the SchemaFieldsEmail model
   */ 
  interface SchemaFieldsEmailFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsEmail", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsEmail without action
   */
  export type SchemaFieldsEmailDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsEmail
     */
    select?: SchemaFieldsEmailSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsEmail
     */
    omit?: SchemaFieldsEmailOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsExactdomain
   */





  export type SchemaFieldsExactdomainSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsExactdomain"]>



  export type SchemaFieldsExactdomainSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsExactdomainOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsExactdomain"]>

  export type $SchemaFieldsExactdomainPayload = {
    name: "SchemaFieldsExactdomain"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsExactdomainGetPayload<S extends boolean | null | undefined | SchemaFieldsExactdomainDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsExactdomainPayload, S>





  /**
   * Fields of the SchemaFieldsExactdomain model
   */ 
  interface SchemaFieldsExactdomainFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsExactdomain", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsExactdomain without action
   */
  export type SchemaFieldsExactdomainDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsExactdomain
     */
    select?: SchemaFieldsExactdomainSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsExactdomain
     */
    omit?: SchemaFieldsExactdomainOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsExpireDate
   */





  export type SchemaFieldsExpireDateSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsExpireDate"]>



  export type SchemaFieldsExpireDateSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsExpireDateOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsExpireDate"]>

  export type $SchemaFieldsExpireDatePayload = {
    name: "SchemaFieldsExpireDate"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsExpireDateGetPayload<S extends boolean | null | undefined | SchemaFieldsExpireDateDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsExpireDatePayload, S>





  /**
   * Fields of the SchemaFieldsExpireDate model
   */ 
  interface SchemaFieldsExpireDateFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsExpireDate", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsExpireDate without action
   */
  export type SchemaFieldsExpireDateDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsExpireDate
     */
    select?: SchemaFieldsExpireDateSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsExpireDate
     */
    omit?: SchemaFieldsExpireDateOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsFbUserId
   */





  export type SchemaFieldsFbUserIdSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsFbUserId"]>



  export type SchemaFieldsFbUserIdSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsFbUserIdOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsFbUserId"]>

  export type $SchemaFieldsFbUserIdPayload = {
    name: "SchemaFieldsFbUserId"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsFbUserIdGetPayload<S extends boolean | null | undefined | SchemaFieldsFbUserIdDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsFbUserIdPayload, S>





  /**
   * Fields of the SchemaFieldsFbUserId model
   */ 
  interface SchemaFieldsFbUserIdFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsFbUserId", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsFbUserId without action
   */
  export type SchemaFieldsFbUserIdDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsFbUserId
     */
    select?: SchemaFieldsFbUserIdSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsFbUserId
     */
    omit?: SchemaFieldsFbUserIdOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsFkGroupId
   */





  export type SchemaFieldsFkGroupIdSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsFkGroupId"]>



  export type SchemaFieldsFkGroupIdSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsFkGroupIdOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsFkGroupId"]>

  export type $SchemaFieldsFkGroupIdPayload = {
    name: "SchemaFieldsFkGroupId"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsFkGroupIdGetPayload<S extends boolean | null | undefined | SchemaFieldsFkGroupIdDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsFkGroupIdPayload, S>





  /**
   * Fields of the SchemaFieldsFkGroupId model
   */ 
  interface SchemaFieldsFkGroupIdFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsFkGroupId", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsFkGroupId without action
   */
  export type SchemaFieldsFkGroupIdDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsFkGroupId
     */
    select?: SchemaFieldsFkGroupIdSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsFkGroupId
     */
    omit?: SchemaFieldsFkGroupIdOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsFkKeywordId
   */





  export type SchemaFieldsFkKeywordIdSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsFkKeywordId"]>



  export type SchemaFieldsFkKeywordIdSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsFkKeywordIdOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsFkKeywordId"]>

  export type $SchemaFieldsFkKeywordIdPayload = {
    name: "SchemaFieldsFkKeywordId"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsFkKeywordIdGetPayload<S extends boolean | null | undefined | SchemaFieldsFkKeywordIdDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsFkKeywordIdPayload, S>





  /**
   * Fields of the SchemaFieldsFkKeywordId model
   */ 
  interface SchemaFieldsFkKeywordIdFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsFkKeywordId", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsFkKeywordId without action
   */
  export type SchemaFieldsFkKeywordIdDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsFkKeywordId
     */
    select?: SchemaFieldsFkKeywordIdSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsFkKeywordId
     */
    omit?: SchemaFieldsFkKeywordIdOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsFkUserId
   */





  export type SchemaFieldsFkUserIdSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsFkUserId"]>



  export type SchemaFieldsFkUserIdSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsFkUserIdOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsFkUserId"]>

  export type $SchemaFieldsFkUserIdPayload = {
    name: "SchemaFieldsFkUserId"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsFkUserIdGetPayload<S extends boolean | null | undefined | SchemaFieldsFkUserIdDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsFkUserIdPayload, S>





  /**
   * Fields of the SchemaFieldsFkUserId model
   */ 
  interface SchemaFieldsFkUserIdFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsFkUserId", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsFkUserId without action
   */
  export type SchemaFieldsFkUserIdDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsFkUserId
     */
    select?: SchemaFieldsFkUserIdSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsFkUserId
     */
    omit?: SchemaFieldsFkUserIdOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsGroupCallEnd
   */





  export type SchemaFieldsGroupCallEndSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsGroupCallEnd"]>



  export type SchemaFieldsGroupCallEndSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsGroupCallEndOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsGroupCallEnd"]>

  export type $SchemaFieldsGroupCallEndPayload = {
    name: "SchemaFieldsGroupCallEnd"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsGroupCallEndGetPayload<S extends boolean | null | undefined | SchemaFieldsGroupCallEndDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsGroupCallEndPayload, S>





  /**
   * Fields of the SchemaFieldsGroupCallEnd model
   */ 
  interface SchemaFieldsGroupCallEndFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsGroupCallEnd", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsGroupCallEnd without action
   */
  export type SchemaFieldsGroupCallEndDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsGroupCallEnd
     */
    select?: SchemaFieldsGroupCallEndSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsGroupCallEnd
     */
    omit?: SchemaFieldsGroupCallEndOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsGroupCallStart
   */





  export type SchemaFieldsGroupCallStartSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsGroupCallStart"]>



  export type SchemaFieldsGroupCallStartSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsGroupCallStartOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsGroupCallStart"]>

  export type $SchemaFieldsGroupCallStartPayload = {
    name: "SchemaFieldsGroupCallStart"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsGroupCallStartGetPayload<S extends boolean | null | undefined | SchemaFieldsGroupCallStartDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsGroupCallStartPayload, S>





  /**
   * Fields of the SchemaFieldsGroupCallStart model
   */ 
  interface SchemaFieldsGroupCallStartFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsGroupCallStart", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsGroupCallStart without action
   */
  export type SchemaFieldsGroupCallStartDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsGroupCallStart
     */
    select?: SchemaFieldsGroupCallStartSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsGroupCallStart
     */
    omit?: SchemaFieldsGroupCallStartOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsGroupCallStatus
   */





  export type SchemaFieldsGroupCallStatusSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsGroupCallStatus"]>



  export type SchemaFieldsGroupCallStatusSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsGroupCallStatusOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsGroupCallStatus"]>

  export type $SchemaFieldsGroupCallStatusPayload = {
    name: "SchemaFieldsGroupCallStatus"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsGroupCallStatusGetPayload<S extends boolean | null | undefined | SchemaFieldsGroupCallStatusDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsGroupCallStatusPayload, S>





  /**
   * Fields of the SchemaFieldsGroupCallStatus model
   */ 
  interface SchemaFieldsGroupCallStatusFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsGroupCallStatus", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsGroupCallStatus without action
   */
  export type SchemaFieldsGroupCallStatusDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsGroupCallStatus
     */
    select?: SchemaFieldsGroupCallStatusSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsGroupCallStatus
     */
    omit?: SchemaFieldsGroupCallStatusOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsGroupId
   */





  export type SchemaFieldsGroupIdSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsGroupId"]>



  export type SchemaFieldsGroupIdSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsGroupIdOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsGroupId"]>

  export type $SchemaFieldsGroupIdPayload = {
    name: "SchemaFieldsGroupId"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsGroupIdGetPayload<S extends boolean | null | undefined | SchemaFieldsGroupIdDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsGroupIdPayload, S>





  /**
   * Fields of the SchemaFieldsGroupId model
   */ 
  interface SchemaFieldsGroupIdFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsGroupId", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsGroupId without action
   */
  export type SchemaFieldsGroupIdDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsGroupId
     */
    select?: SchemaFieldsGroupIdSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsGroupId
     */
    omit?: SchemaFieldsGroupIdOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsGroupName
   */





  export type SchemaFieldsGroupNameSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsGroupName"]>



  export type SchemaFieldsGroupNameSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsGroupNameOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsGroupName"]>

  export type $SchemaFieldsGroupNamePayload = {
    name: "SchemaFieldsGroupName"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsGroupNameGetPayload<S extends boolean | null | undefined | SchemaFieldsGroupNameDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsGroupNamePayload, S>





  /**
   * Fields of the SchemaFieldsGroupName model
   */ 
  interface SchemaFieldsGroupNameFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsGroupName", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsGroupName without action
   */
  export type SchemaFieldsGroupNameDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsGroupName
     */
    select?: SchemaFieldsGroupNameSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsGroupName
     */
    omit?: SchemaFieldsGroupNameOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsHalfmonthmark
   */





  export type SchemaFieldsHalfmonthmarkSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsHalfmonthmark"]>



  export type SchemaFieldsHalfmonthmarkSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsHalfmonthmarkOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsHalfmonthmark"]>

  export type $SchemaFieldsHalfmonthmarkPayload = {
    name: "SchemaFieldsHalfmonthmark"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsHalfmonthmarkGetPayload<S extends boolean | null | undefined | SchemaFieldsHalfmonthmarkDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsHalfmonthmarkPayload, S>





  /**
   * Fields of the SchemaFieldsHalfmonthmark model
   */ 
  interface SchemaFieldsHalfmonthmarkFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsHalfmonthmark", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsHalfmonthmark without action
   */
  export type SchemaFieldsHalfmonthmarkDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsHalfmonthmark
     */
    select?: SchemaFieldsHalfmonthmarkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsHalfmonthmark
     */
    omit?: SchemaFieldsHalfmonthmarkOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsHalfmonthval
   */





  export type SchemaFieldsHalfmonthvalSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsHalfmonthval"]>



  export type SchemaFieldsHalfmonthvalSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsHalfmonthvalOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsHalfmonthval"]>

  export type $SchemaFieldsHalfmonthvalPayload = {
    name: "SchemaFieldsHalfmonthval"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsHalfmonthvalGetPayload<S extends boolean | null | undefined | SchemaFieldsHalfmonthvalDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsHalfmonthvalPayload, S>





  /**
   * Fields of the SchemaFieldsHalfmonthval model
   */ 
  interface SchemaFieldsHalfmonthvalFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsHalfmonthval", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsHalfmonthval without action
   */
  export type SchemaFieldsHalfmonthvalDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsHalfmonthval
     */
    select?: SchemaFieldsHalfmonthvalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsHalfmonthval
     */
    omit?: SchemaFieldsHalfmonthvalOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsId
   */





  export type SchemaFieldsIdSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsId"]>



  export type SchemaFieldsIdSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsIdOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsId"]>

  export type $SchemaFieldsIdPayload = {
    name: "SchemaFieldsId"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsIdGetPayload<S extends boolean | null | undefined | SchemaFieldsIdDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsIdPayload, S>





  /**
   * Fields of the SchemaFieldsId model
   */ 
  interface SchemaFieldsIdFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsId", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsId without action
   */
  export type SchemaFieldsIdDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsId
     */
    select?: SchemaFieldsIdSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsId
     */
    omit?: SchemaFieldsIdOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsIsActive
   */





  export type SchemaFieldsIsActiveSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsIsActive"]>



  export type SchemaFieldsIsActiveSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsIsActiveOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsIsActive"]>

  export type $SchemaFieldsIsActivePayload = {
    name: "SchemaFieldsIsActive"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsIsActiveGetPayload<S extends boolean | null | undefined | SchemaFieldsIsActiveDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsIsActivePayload, S>





  /**
   * Fields of the SchemaFieldsIsActive model
   */ 
  interface SchemaFieldsIsActiveFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsIsActive", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsIsActive without action
   */
  export type SchemaFieldsIsActiveDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsIsActive
     */
    select?: SchemaFieldsIsActiveSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsIsActive
     */
    omit?: SchemaFieldsIsActiveOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsIsAdmin
   */





  export type SchemaFieldsIsAdminSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsIsAdmin"]>



  export type SchemaFieldsIsAdminSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsIsAdminOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsIsAdmin"]>

  export type $SchemaFieldsIsAdminPayload = {
    name: "SchemaFieldsIsAdmin"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsIsAdminGetPayload<S extends boolean | null | undefined | SchemaFieldsIsAdminDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsIsAdminPayload, S>





  /**
   * Fields of the SchemaFieldsIsAdmin model
   */ 
  interface SchemaFieldsIsAdminFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsIsAdmin", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsIsAdmin without action
   */
  export type SchemaFieldsIsAdminDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsIsAdmin
     */
    select?: SchemaFieldsIsAdminSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsIsAdmin
     */
    omit?: SchemaFieldsIsAdminOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsIsStaff
   */





  export type SchemaFieldsIsStaffSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsIsStaff"]>



  export type SchemaFieldsIsStaffSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsIsStaffOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsIsStaff"]>

  export type $SchemaFieldsIsStaffPayload = {
    name: "SchemaFieldsIsStaff"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsIsStaffGetPayload<S extends boolean | null | undefined | SchemaFieldsIsStaffDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsIsStaffPayload, S>





  /**
   * Fields of the SchemaFieldsIsStaff model
   */ 
  interface SchemaFieldsIsStaffFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsIsStaff", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsIsStaff without action
   */
  export type SchemaFieldsIsStaffDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsIsStaff
     */
    select?: SchemaFieldsIsStaffSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsIsStaff
     */
    omit?: SchemaFieldsIsStaffOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsIsSuperuser
   */





  export type SchemaFieldsIsSuperuserSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsIsSuperuser"]>



  export type SchemaFieldsIsSuperuserSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsIsSuperuserOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsIsSuperuser"]>

  export type $SchemaFieldsIsSuperuserPayload = {
    name: "SchemaFieldsIsSuperuser"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsIsSuperuserGetPayload<S extends boolean | null | undefined | SchemaFieldsIsSuperuserDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsIsSuperuserPayload, S>





  /**
   * Fields of the SchemaFieldsIsSuperuser model
   */ 
  interface SchemaFieldsIsSuperuserFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsIsSuperuser", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsIsSuperuser without action
   */
  export type SchemaFieldsIsSuperuserDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsIsSuperuser
     */
    select?: SchemaFieldsIsSuperuserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsIsSuperuser
     */
    omit?: SchemaFieldsIsSuperuserOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsIsocode
   */





  export type SchemaFieldsIsocodeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsIsocode"]>



  export type SchemaFieldsIsocodeSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsIsocodeOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsIsocode"]>

  export type $SchemaFieldsIsocodePayload = {
    name: "SchemaFieldsIsocode"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsIsocodeGetPayload<S extends boolean | null | undefined | SchemaFieldsIsocodeDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsIsocodePayload, S>





  /**
   * Fields of the SchemaFieldsIsocode model
   */ 
  interface SchemaFieldsIsocodeFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsIsocode", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsIsocode without action
   */
  export type SchemaFieldsIsocodeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsIsocode
     */
    select?: SchemaFieldsIsocodeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsIsocode
     */
    omit?: SchemaFieldsIsocodeOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsKey
   */





  export type SchemaFieldsKeySelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsKey"]>



  export type SchemaFieldsKeySelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsKeyOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsKey"]>

  export type $SchemaFieldsKeyPayload = {
    name: "SchemaFieldsKey"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsKeyGetPayload<S extends boolean | null | undefined | SchemaFieldsKeyDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsKeyPayload, S>





  /**
   * Fields of the SchemaFieldsKey model
   */ 
  interface SchemaFieldsKeyFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsKey", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsKey without action
   */
  export type SchemaFieldsKeyDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsKey
     */
    select?: SchemaFieldsKeySelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsKey
     */
    omit?: SchemaFieldsKeyOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsKeyword
   */





  export type SchemaFieldsKeywordSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsKeyword"]>



  export type SchemaFieldsKeywordSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsKeywordOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsKeyword"]>

  export type $SchemaFieldsKeywordPayload = {
    name: "SchemaFieldsKeyword"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsKeywordGetPayload<S extends boolean | null | undefined | SchemaFieldsKeywordDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsKeywordPayload, S>





  /**
   * Fields of the SchemaFieldsKeyword model
   */ 
  interface SchemaFieldsKeywordFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsKeyword", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsKeyword without action
   */
  export type SchemaFieldsKeywordDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsKeyword
     */
    select?: SchemaFieldsKeywordSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsKeyword
     */
    omit?: SchemaFieldsKeywordOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsKeywordDifficulty
   */





  export type SchemaFieldsKeywordDifficultySelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsKeywordDifficulty"]>



  export type SchemaFieldsKeywordDifficultySelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsKeywordDifficultyOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsKeywordDifficulty"]>

  export type $SchemaFieldsKeywordDifficultyPayload = {
    name: "SchemaFieldsKeywordDifficulty"
    objects: {}
    scalars: {
      type_code: string | null
    }
    composites: {}
  }

  type SchemaFieldsKeywordDifficultyGetPayload<S extends boolean | null | undefined | SchemaFieldsKeywordDifficultyDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsKeywordDifficultyPayload, S>





  /**
   * Fields of the SchemaFieldsKeywordDifficulty model
   */ 
  interface SchemaFieldsKeywordDifficultyFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsKeywordDifficulty", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsKeywordDifficulty without action
   */
  export type SchemaFieldsKeywordDifficultyDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsKeywordDifficulty
     */
    select?: SchemaFieldsKeywordDifficultySelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsKeywordDifficulty
     */
    omit?: SchemaFieldsKeywordDifficultyOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsKeywordSlug
   */





  export type SchemaFieldsKeywordSlugSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsKeywordSlug"]>



  export type SchemaFieldsKeywordSlugSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsKeywordSlugOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsKeywordSlug"]>

  export type $SchemaFieldsKeywordSlugPayload = {
    name: "SchemaFieldsKeywordSlug"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsKeywordSlugGetPayload<S extends boolean | null | undefined | SchemaFieldsKeywordSlugDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsKeywordSlugPayload, S>





  /**
   * Fields of the SchemaFieldsKeywordSlug model
   */ 
  interface SchemaFieldsKeywordSlugFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsKeywordSlug", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsKeywordSlug without action
   */
  export type SchemaFieldsKeywordSlugDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsKeywordSlug
     */
    select?: SchemaFieldsKeywordSlugSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsKeywordSlug
     */
    omit?: SchemaFieldsKeywordSlugOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsLanguage
   */





  export type SchemaFieldsLanguageSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsLanguage"]>



  export type SchemaFieldsLanguageSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsLanguageOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsLanguage"]>

  export type $SchemaFieldsLanguagePayload = {
    name: "SchemaFieldsLanguage"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsLanguageGetPayload<S extends boolean | null | undefined | SchemaFieldsLanguageDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsLanguagePayload, S>





  /**
   * Fields of the SchemaFieldsLanguage model
   */ 
  interface SchemaFieldsLanguageFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsLanguage", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsLanguage without action
   */
  export type SchemaFieldsLanguageDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsLanguage
     */
    select?: SchemaFieldsLanguageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsLanguage
     */
    omit?: SchemaFieldsLanguageOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsLanguageCode
   */





  export type SchemaFieldsLanguageCodeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsLanguageCode"]>



  export type SchemaFieldsLanguageCodeSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsLanguageCodeOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsLanguageCode"]>

  export type $SchemaFieldsLanguageCodePayload = {
    name: "SchemaFieldsLanguageCode"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsLanguageCodeGetPayload<S extends boolean | null | undefined | SchemaFieldsLanguageCodeDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsLanguageCodePayload, S>





  /**
   * Fields of the SchemaFieldsLanguageCode model
   */ 
  interface SchemaFieldsLanguageCodeFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsLanguageCode", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsLanguageCode without action
   */
  export type SchemaFieldsLanguageCodeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsLanguageCode
     */
    select?: SchemaFieldsLanguageCodeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsLanguageCode
     */
    omit?: SchemaFieldsLanguageCodeOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsLanguageName
   */





  export type SchemaFieldsLanguageNameSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsLanguageName"]>



  export type SchemaFieldsLanguageNameSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsLanguageNameOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsLanguageName"]>

  export type $SchemaFieldsLanguageNamePayload = {
    name: "SchemaFieldsLanguageName"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsLanguageNameGetPayload<S extends boolean | null | undefined | SchemaFieldsLanguageNameDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsLanguageNamePayload, S>





  /**
   * Fields of the SchemaFieldsLanguageName model
   */ 
  interface SchemaFieldsLanguageNameFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsLanguageName", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsLanguageName without action
   */
  export type SchemaFieldsLanguageNameDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsLanguageName
     */
    select?: SchemaFieldsLanguageNameSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsLanguageName
     */
    omit?: SchemaFieldsLanguageNameOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsLastHomeVisit
   */





  export type SchemaFieldsLastHomeVisitSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsLastHomeVisit"]>



  export type SchemaFieldsLastHomeVisitSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsLastHomeVisitOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsLastHomeVisit"]>

  export type $SchemaFieldsLastHomeVisitPayload = {
    name: "SchemaFieldsLastHomeVisit"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsLastHomeVisitGetPayload<S extends boolean | null | undefined | SchemaFieldsLastHomeVisitDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsLastHomeVisitPayload, S>





  /**
   * Fields of the SchemaFieldsLastHomeVisit model
   */ 
  interface SchemaFieldsLastHomeVisitFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsLastHomeVisit", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsLastHomeVisit without action
   */
  export type SchemaFieldsLastHomeVisitDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsLastHomeVisit
     */
    select?: SchemaFieldsLastHomeVisitSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsLastHomeVisit
     */
    omit?: SchemaFieldsLastHomeVisitOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsLastLogin
   */





  export type SchemaFieldsLastLoginSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsLastLogin"]>



  export type SchemaFieldsLastLoginSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsLastLoginOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsLastLogin"]>

  export type $SchemaFieldsLastLoginPayload = {
    name: "SchemaFieldsLastLogin"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsLastLoginGetPayload<S extends boolean | null | undefined | SchemaFieldsLastLoginDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsLastLoginPayload, S>





  /**
   * Fields of the SchemaFieldsLastLogin model
   */ 
  interface SchemaFieldsLastLoginFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsLastLogin", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsLastLogin without action
   */
  export type SchemaFieldsLastLoginDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsLastLogin
     */
    select?: SchemaFieldsLastLoginSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsLastLogin
     */
    omit?: SchemaFieldsLastLoginOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsLastLogout
   */





  export type SchemaFieldsLastLogoutSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsLastLogout"]>



  export type SchemaFieldsLastLogoutSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsLastLogoutOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsLastLogout"]>

  export type $SchemaFieldsLastLogoutPayload = {
    name: "SchemaFieldsLastLogout"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsLastLogoutGetPayload<S extends boolean | null | undefined | SchemaFieldsLastLogoutDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsLastLogoutPayload, S>





  /**
   * Fields of the SchemaFieldsLastLogout model
   */ 
  interface SchemaFieldsLastLogoutFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsLastLogout", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsLastLogout without action
   */
  export type SchemaFieldsLastLogoutDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsLastLogout
     */
    select?: SchemaFieldsLastLogoutSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsLastLogout
     */
    omit?: SchemaFieldsLastLogoutOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsLastrankedDate
   */





  export type SchemaFieldsLastrankedDateSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsLastrankedDate"]>



  export type SchemaFieldsLastrankedDateSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsLastrankedDateOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsLastrankedDate"]>

  export type $SchemaFieldsLastrankedDatePayload = {
    name: "SchemaFieldsLastrankedDate"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsLastrankedDateGetPayload<S extends boolean | null | undefined | SchemaFieldsLastrankedDateDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsLastrankedDatePayload, S>





  /**
   * Fields of the SchemaFieldsLastrankedDate model
   */ 
  interface SchemaFieldsLastrankedDateFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsLastrankedDate", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsLastrankedDate without action
   */
  export type SchemaFieldsLastrankedDateDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsLastrankedDate
     */
    select?: SchemaFieldsLastrankedDateSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsLastrankedDate
     */
    omit?: SchemaFieldsLastrankedDateOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsLocation
   */





  export type SchemaFieldsLocationSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsLocation"]>



  export type SchemaFieldsLocationSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsLocationOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsLocation"]>

  export type $SchemaFieldsLocationPayload = {
    name: "SchemaFieldsLocation"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsLocationGetPayload<S extends boolean | null | undefined | SchemaFieldsLocationDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsLocationPayload, S>





  /**
   * Fields of the SchemaFieldsLocation model
   */ 
  interface SchemaFieldsLocationFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsLocation", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsLocation without action
   */
  export type SchemaFieldsLocationDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsLocation
     */
    select?: SchemaFieldsLocationSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsLocation
     */
    omit?: SchemaFieldsLocationOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsLocationCode
   */





  export type SchemaFieldsLocationCodeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsLocationCode"]>



  export type SchemaFieldsLocationCodeSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsLocationCodeOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsLocationCode"]>

  export type $SchemaFieldsLocationCodePayload = {
    name: "SchemaFieldsLocationCode"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsLocationCodeGetPayload<S extends boolean | null | undefined | SchemaFieldsLocationCodeDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsLocationCodePayload, S>





  /**
   * Fields of the SchemaFieldsLocationCode model
   */ 
  interface SchemaFieldsLocationCodeFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsLocationCode", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsLocationCode without action
   */
  export type SchemaFieldsLocationCodeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsLocationCode
     */
    select?: SchemaFieldsLocationCodeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsLocationCode
     */
    omit?: SchemaFieldsLocationCodeOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsMetricStatus
   */





  export type SchemaFieldsMetricStatusSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsMetricStatus"]>



  export type SchemaFieldsMetricStatusSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsMetricStatusOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsMetricStatus"]>

  export type $SchemaFieldsMetricStatusPayload = {
    name: "SchemaFieldsMetricStatus"
    objects: {}
    scalars: {
      /**
       * Could not determine type: the field only had null or empty values in the sample set.
       */
      type_code: Prisma.JsonValue | null
    }
    composites: {}
  }

  type SchemaFieldsMetricStatusGetPayload<S extends boolean | null | undefined | SchemaFieldsMetricStatusDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsMetricStatusPayload, S>





  /**
   * Fields of the SchemaFieldsMetricStatus model
   */ 
  interface SchemaFieldsMetricStatusFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsMetricStatus", 'Json'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsMetricStatus without action
   */
  export type SchemaFieldsMetricStatusDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsMetricStatus
     */
    select?: SchemaFieldsMetricStatusSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsMetricStatus
     */
    omit?: SchemaFieldsMetricStatusOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsMobile
   */





  export type SchemaFieldsMobileSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsMobile"]>



  export type SchemaFieldsMobileSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsMobileOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsMobile"]>

  export type $SchemaFieldsMobilePayload = {
    name: "SchemaFieldsMobile"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsMobileGetPayload<S extends boolean | null | undefined | SchemaFieldsMobileDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsMobilePayload, S>





  /**
   * Fields of the SchemaFieldsMobile model
   */ 
  interface SchemaFieldsMobileFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsMobile", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsMobile without action
   */
  export type SchemaFieldsMobileDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsMobile
     */
    select?: SchemaFieldsMobileSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsMobile
     */
    omit?: SchemaFieldsMobileOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsModel
   */





  export type SchemaFieldsModelSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsModel"]>



  export type SchemaFieldsModelSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsModelOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsModel"]>

  export type $SchemaFieldsModelPayload = {
    name: "SchemaFieldsModel"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsModelGetPayload<S extends boolean | null | undefined | SchemaFieldsModelDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsModelPayload, S>





  /**
   * Fields of the SchemaFieldsModel model
   */ 
  interface SchemaFieldsModelFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsModel", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsModel without action
   */
  export type SchemaFieldsModelDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsModel
     */
    select?: SchemaFieldsModelSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsModel
     */
    omit?: SchemaFieldsModelOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsModifiedDate
   */





  export type SchemaFieldsModifiedDateSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsModifiedDate"]>



  export type SchemaFieldsModifiedDateSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsModifiedDateOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsModifiedDate"]>

  export type $SchemaFieldsModifiedDatePayload = {
    name: "SchemaFieldsModifiedDate"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsModifiedDateGetPayload<S extends boolean | null | undefined | SchemaFieldsModifiedDateDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsModifiedDatePayload, S>





  /**
   * Fields of the SchemaFieldsModifiedDate model
   */ 
  interface SchemaFieldsModifiedDateFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsModifiedDate", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsModifiedDate without action
   */
  export type SchemaFieldsModifiedDateDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsModifiedDate
     */
    select?: SchemaFieldsModifiedDateSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsModifiedDate
     */
    omit?: SchemaFieldsModifiedDateOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsMonthmark
   */





  export type SchemaFieldsMonthmarkSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsMonthmark"]>



  export type SchemaFieldsMonthmarkSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsMonthmarkOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsMonthmark"]>

  export type $SchemaFieldsMonthmarkPayload = {
    name: "SchemaFieldsMonthmark"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsMonthmarkGetPayload<S extends boolean | null | undefined | SchemaFieldsMonthmarkDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsMonthmarkPayload, S>





  /**
   * Fields of the SchemaFieldsMonthmark model
   */ 
  interface SchemaFieldsMonthmarkFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsMonthmark", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsMonthmark without action
   */
  export type SchemaFieldsMonthmarkDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsMonthmark
     */
    select?: SchemaFieldsMonthmarkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsMonthmark
     */
    omit?: SchemaFieldsMonthmarkOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsMonthval
   */





  export type SchemaFieldsMonthvalSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsMonthval"]>



  export type SchemaFieldsMonthvalSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsMonthvalOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsMonthval"]>

  export type $SchemaFieldsMonthvalPayload = {
    name: "SchemaFieldsMonthval"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsMonthvalGetPayload<S extends boolean | null | undefined | SchemaFieldsMonthvalDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsMonthvalPayload, S>





  /**
   * Fields of the SchemaFieldsMonthval model
   */ 
  interface SchemaFieldsMonthvalFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsMonthval", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsMonthval without action
   */
  export type SchemaFieldsMonthvalDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsMonthval
     */
    select?: SchemaFieldsMonthvalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsMonthval
     */
    omit?: SchemaFieldsMonthvalOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsName
   */





  export type SchemaFieldsNameSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsName"]>



  export type SchemaFieldsNameSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsNameOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsName"]>

  export type $SchemaFieldsNamePayload = {
    name: "SchemaFieldsName"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsNameGetPayload<S extends boolean | null | undefined | SchemaFieldsNameDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsNamePayload, S>





  /**
   * Fields of the SchemaFieldsName model
   */ 
  interface SchemaFieldsNameFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsName", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsName without action
   */
  export type SchemaFieldsNameDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsName
     */
    select?: SchemaFieldsNameSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsName
     */
    omit?: SchemaFieldsNameOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsObjectId
   */





  export type SchemaFieldsObjectIdSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsObjectId"]>



  export type SchemaFieldsObjectIdSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsObjectIdOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsObjectId"]>

  export type $SchemaFieldsObjectIdPayload = {
    name: "SchemaFieldsObjectId"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsObjectIdGetPayload<S extends boolean | null | undefined | SchemaFieldsObjectIdDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsObjectIdPayload, S>





  /**
   * Fields of the SchemaFieldsObjectId model
   */ 
  interface SchemaFieldsObjectIdFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsObjectId", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsObjectId without action
   */
  export type SchemaFieldsObjectIdDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsObjectId
     */
    select?: SchemaFieldsObjectIdSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsObjectId
     */
    omit?: SchemaFieldsObjectIdOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsObjectRepr
   */





  export type SchemaFieldsObjectReprSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsObjectRepr"]>



  export type SchemaFieldsObjectReprSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsObjectReprOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsObjectRepr"]>

  export type $SchemaFieldsObjectReprPayload = {
    name: "SchemaFieldsObjectRepr"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsObjectReprGetPayload<S extends boolean | null | undefined | SchemaFieldsObjectReprDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsObjectReprPayload, S>





  /**
   * Fields of the SchemaFieldsObjectRepr model
   */ 
  interface SchemaFieldsObjectReprFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsObjectRepr", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsObjectRepr without action
   */
  export type SchemaFieldsObjectReprDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsObjectRepr
     */
    select?: SchemaFieldsObjectReprSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsObjectRepr
     */
    omit?: SchemaFieldsObjectReprOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsPageUuid
   */





  export type SchemaFieldsPageUuidSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsPageUuid"]>



  export type SchemaFieldsPageUuidSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsPageUuidOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsPageUuid"]>

  export type $SchemaFieldsPageUuidPayload = {
    name: "SchemaFieldsPageUuid"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsPageUuidGetPayload<S extends boolean | null | undefined | SchemaFieldsPageUuidDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsPageUuidPayload, S>





  /**
   * Fields of the SchemaFieldsPageUuid model
   */ 
  interface SchemaFieldsPageUuidFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsPageUuid", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsPageUuid without action
   */
  export type SchemaFieldsPageUuidDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsPageUuid
     */
    select?: SchemaFieldsPageUuidSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsPageUuid
     */
    omit?: SchemaFieldsPageUuidOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsPageUuidUrl
   */





  export type SchemaFieldsPageUuidUrlSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsPageUuidUrl"]>



  export type SchemaFieldsPageUuidUrlSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsPageUuidUrlOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsPageUuidUrl"]>

  export type $SchemaFieldsPageUuidUrlPayload = {
    name: "SchemaFieldsPageUuidUrl"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsPageUuidUrlGetPayload<S extends boolean | null | undefined | SchemaFieldsPageUuidUrlDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsPageUuidUrlPayload, S>





  /**
   * Fields of the SchemaFieldsPageUuidUrl model
   */ 
  interface SchemaFieldsPageUuidUrlFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsPageUuidUrl", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsPageUuidUrl without action
   */
  export type SchemaFieldsPageUuidUrlDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsPageUuidUrl
     */
    select?: SchemaFieldsPageUuidUrlSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsPageUuidUrl
     */
    omit?: SchemaFieldsPageUuidUrlOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsPassword
   */





  export type SchemaFieldsPasswordSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsPassword"]>



  export type SchemaFieldsPasswordSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsPasswordOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsPassword"]>

  export type $SchemaFieldsPasswordPayload = {
    name: "SchemaFieldsPassword"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsPasswordGetPayload<S extends boolean | null | undefined | SchemaFieldsPasswordDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsPasswordPayload, S>





  /**
   * Fields of the SchemaFieldsPassword model
   */ 
  interface SchemaFieldsPasswordFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsPassword", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsPassword without action
   */
  export type SchemaFieldsPasswordDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsPassword
     */
    select?: SchemaFieldsPasswordSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsPassword
     */
    omit?: SchemaFieldsPasswordOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsPermissionId
   */





  export type SchemaFieldsPermissionIdSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsPermissionId"]>



  export type SchemaFieldsPermissionIdSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsPermissionIdOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsPermissionId"]>

  export type $SchemaFieldsPermissionIdPayload = {
    name: "SchemaFieldsPermissionId"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsPermissionIdGetPayload<S extends boolean | null | undefined | SchemaFieldsPermissionIdDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsPermissionIdPayload, S>





  /**
   * Fields of the SchemaFieldsPermissionId model
   */ 
  interface SchemaFieldsPermissionIdFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsPermissionId", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsPermissionId without action
   */
  export type SchemaFieldsPermissionIdDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsPermissionId
     */
    select?: SchemaFieldsPermissionIdSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsPermissionId
     */
    omit?: SchemaFieldsPermissionIdOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsPlanKeywordLimit
   */





  export type SchemaFieldsPlanKeywordLimitSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsPlanKeywordLimit"]>



  export type SchemaFieldsPlanKeywordLimitSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsPlanKeywordLimitOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsPlanKeywordLimit"]>

  export type $SchemaFieldsPlanKeywordLimitPayload = {
    name: "SchemaFieldsPlanKeywordLimit"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsPlanKeywordLimitGetPayload<S extends boolean | null | undefined | SchemaFieldsPlanKeywordLimitDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsPlanKeywordLimitPayload, S>





  /**
   * Fields of the SchemaFieldsPlanKeywordLimit model
   */ 
  interface SchemaFieldsPlanKeywordLimitFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsPlanKeywordLimit", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsPlanKeywordLimit without action
   */
  export type SchemaFieldsPlanKeywordLimitDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsPlanKeywordLimit
     */
    select?: SchemaFieldsPlanKeywordLimitSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsPlanKeywordLimit
     */
    omit?: SchemaFieldsPlanKeywordLimitOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsPlanProjectLimit
   */





  export type SchemaFieldsPlanProjectLimitSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsPlanProjectLimit"]>



  export type SchemaFieldsPlanProjectLimitSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsPlanProjectLimitOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsPlanProjectLimit"]>

  export type $SchemaFieldsPlanProjectLimitPayload = {
    name: "SchemaFieldsPlanProjectLimit"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsPlanProjectLimitGetPayload<S extends boolean | null | undefined | SchemaFieldsPlanProjectLimitDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsPlanProjectLimitPayload, S>





  /**
   * Fields of the SchemaFieldsPlanProjectLimit model
   */ 
  interface SchemaFieldsPlanProjectLimitFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsPlanProjectLimit", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsPlanProjectLimit without action
   */
  export type SchemaFieldsPlanProjectLimitDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsPlanProjectLimit
     */
    select?: SchemaFieldsPlanProjectLimitSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsPlanProjectLimit
     */
    omit?: SchemaFieldsPlanProjectLimitOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsPlatform
   */





  export type SchemaFieldsPlatformSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsPlatform"]>



  export type SchemaFieldsPlatformSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsPlatformOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsPlatform"]>

  export type $SchemaFieldsPlatformPayload = {
    name: "SchemaFieldsPlatform"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsPlatformGetPayload<S extends boolean | null | undefined | SchemaFieldsPlatformDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsPlatformPayload, S>





  /**
   * Fields of the SchemaFieldsPlatform model
   */ 
  interface SchemaFieldsPlatformFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsPlatform", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsPlatform without action
   */
  export type SchemaFieldsPlatformDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsPlatform
     */
    select?: SchemaFieldsPlatformSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsPlatform
     */
    omit?: SchemaFieldsPlatformOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsProjectAutomationTime
   */





  export type SchemaFieldsProjectAutomationTimeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsProjectAutomationTime"]>



  export type SchemaFieldsProjectAutomationTimeSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsProjectAutomationTimeOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsProjectAutomationTime"]>

  export type $SchemaFieldsProjectAutomationTimePayload = {
    name: "SchemaFieldsProjectAutomationTime"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsProjectAutomationTimeGetPayload<S extends boolean | null | undefined | SchemaFieldsProjectAutomationTimeDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsProjectAutomationTimePayload, S>





  /**
   * Fields of the SchemaFieldsProjectAutomationTime model
   */ 
  interface SchemaFieldsProjectAutomationTimeFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsProjectAutomationTime", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsProjectAutomationTime without action
   */
  export type SchemaFieldsProjectAutomationTimeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsProjectAutomationTime
     */
    select?: SchemaFieldsProjectAutomationTimeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsProjectAutomationTime
     */
    omit?: SchemaFieldsProjectAutomationTimeOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsProxyExceedsCount
   */





  export type SchemaFieldsProxyExceedsCountSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsProxyExceedsCount"]>



  export type SchemaFieldsProxyExceedsCountSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsProxyExceedsCountOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsProxyExceedsCount"]>

  export type $SchemaFieldsProxyExceedsCountPayload = {
    name: "SchemaFieldsProxyExceedsCount"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsProxyExceedsCountGetPayload<S extends boolean | null | undefined | SchemaFieldsProxyExceedsCountDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsProxyExceedsCountPayload, S>





  /**
   * Fields of the SchemaFieldsProxyExceedsCount model
   */ 
  interface SchemaFieldsProxyExceedsCountFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsProxyExceedsCount", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsProxyExceedsCount without action
   */
  export type SchemaFieldsProxyExceedsCountDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsProxyExceedsCount
     */
    select?: SchemaFieldsProxyExceedsCountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsProxyExceedsCount
     */
    omit?: SchemaFieldsProxyExceedsCountOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsProxyInvalidCount
   */





  export type SchemaFieldsProxyInvalidCountSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsProxyInvalidCount"]>



  export type SchemaFieldsProxyInvalidCountSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsProxyInvalidCountOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsProxyInvalidCount"]>

  export type $SchemaFieldsProxyInvalidCountPayload = {
    name: "SchemaFieldsProxyInvalidCount"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsProxyInvalidCountGetPayload<S extends boolean | null | undefined | SchemaFieldsProxyInvalidCountDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsProxyInvalidCountPayload, S>





  /**
   * Fields of the SchemaFieldsProxyInvalidCount model
   */ 
  interface SchemaFieldsProxyInvalidCountFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsProxyInvalidCount", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsProxyInvalidCount without action
   */
  export type SchemaFieldsProxyInvalidCountDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsProxyInvalidCount
     */
    select?: SchemaFieldsProxyInvalidCountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsProxyInvalidCount
     */
    omit?: SchemaFieldsProxyInvalidCountOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsProxyMaximumLoadLimit
   */





  export type SchemaFieldsProxyMaximumLoadLimitSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsProxyMaximumLoadLimit"]>



  export type SchemaFieldsProxyMaximumLoadLimitSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsProxyMaximumLoadLimitOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsProxyMaximumLoadLimit"]>

  export type $SchemaFieldsProxyMaximumLoadLimitPayload = {
    name: "SchemaFieldsProxyMaximumLoadLimit"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsProxyMaximumLoadLimitGetPayload<S extends boolean | null | undefined | SchemaFieldsProxyMaximumLoadLimitDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsProxyMaximumLoadLimitPayload, S>





  /**
   * Fields of the SchemaFieldsProxyMaximumLoadLimit model
   */ 
  interface SchemaFieldsProxyMaximumLoadLimitFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsProxyMaximumLoadLimit", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsProxyMaximumLoadLimit without action
   */
  export type SchemaFieldsProxyMaximumLoadLimitDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsProxyMaximumLoadLimit
     */
    select?: SchemaFieldsProxyMaximumLoadLimitSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsProxyMaximumLoadLimit
     */
    omit?: SchemaFieldsProxyMaximumLoadLimitOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsProxyResetCounter
   */





  export type SchemaFieldsProxyResetCounterSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsProxyResetCounter"]>



  export type SchemaFieldsProxyResetCounterSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsProxyResetCounterOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsProxyResetCounter"]>

  export type $SchemaFieldsProxyResetCounterPayload = {
    name: "SchemaFieldsProxyResetCounter"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsProxyResetCounterGetPayload<S extends boolean | null | undefined | SchemaFieldsProxyResetCounterDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsProxyResetCounterPayload, S>





  /**
   * Fields of the SchemaFieldsProxyResetCounter model
   */ 
  interface SchemaFieldsProxyResetCounterFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsProxyResetCounter", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsProxyResetCounter without action
   */
  export type SchemaFieldsProxyResetCounterDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsProxyResetCounter
     */
    select?: SchemaFieldsProxyResetCounterSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsProxyResetCounter
     */
    omit?: SchemaFieldsProxyResetCounterOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsProxySuccessCount
   */





  export type SchemaFieldsProxySuccessCountSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsProxySuccessCount"]>



  export type SchemaFieldsProxySuccessCountSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsProxySuccessCountOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsProxySuccessCount"]>

  export type $SchemaFieldsProxySuccessCountPayload = {
    name: "SchemaFieldsProxySuccessCount"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsProxySuccessCountGetPayload<S extends boolean | null | undefined | SchemaFieldsProxySuccessCountDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsProxySuccessCountPayload, S>





  /**
   * Fields of the SchemaFieldsProxySuccessCount model
   */ 
  interface SchemaFieldsProxySuccessCountFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsProxySuccessCount", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsProxySuccessCount without action
   */
  export type SchemaFieldsProxySuccessCountDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsProxySuccessCount
     */
    select?: SchemaFieldsProxySuccessCountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsProxySuccessCount
     */
    omit?: SchemaFieldsProxySuccessCountOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsRankSincestart
   */





  export type SchemaFieldsRankSincestartSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsRankSincestart"]>



  export type SchemaFieldsRankSincestartSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsRankSincestartOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsRankSincestart"]>

  export type $SchemaFieldsRankSincestartPayload = {
    name: "SchemaFieldsRankSincestart"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsRankSincestartGetPayload<S extends boolean | null | undefined | SchemaFieldsRankSincestartDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsRankSincestartPayload, S>





  /**
   * Fields of the SchemaFieldsRankSincestart model
   */ 
  interface SchemaFieldsRankSincestartFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsRankSincestart", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsRankSincestart without action
   */
  export type SchemaFieldsRankSincestartDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsRankSincestart
     */
    select?: SchemaFieldsRankSincestartSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsRankSincestart
     */
    omit?: SchemaFieldsRankSincestartOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsRankTrend
   */





  export type SchemaFieldsRankTrendSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsRankTrend"]>



  export type SchemaFieldsRankTrendSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsRankTrendOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsRankTrend"]>

  export type $SchemaFieldsRankTrendPayload = {
    name: "SchemaFieldsRankTrend"
    objects: {}
    scalars: {
      /**
       * Could not determine type: the field only had null or empty values in the sample set.
       */
      type_code: Prisma.JsonValue | null
    }
    composites: {}
  }

  type SchemaFieldsRankTrendGetPayload<S extends boolean | null | undefined | SchemaFieldsRankTrendDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsRankTrendPayload, S>





  /**
   * Fields of the SchemaFieldsRankTrend model
   */ 
  interface SchemaFieldsRankTrendFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsRankTrend", 'Json'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsRankTrend without action
   */
  export type SchemaFieldsRankTrendDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsRankTrend
     */
    select?: SchemaFieldsRankTrendSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsRankTrend
     */
    omit?: SchemaFieldsRankTrendOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsRankedUrl
   */





  export type SchemaFieldsRankedUrlSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsRankedUrl"]>



  export type SchemaFieldsRankedUrlSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsRankedUrlOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsRankedUrl"]>

  export type $SchemaFieldsRankedUrlPayload = {
    name: "SchemaFieldsRankedUrl"
    objects: {}
    scalars: {
      /**
       * Could not determine type: the field only had null or empty values in the sample set.
       */
      type_code: Prisma.JsonValue | null
    }
    composites: {}
  }

  type SchemaFieldsRankedUrlGetPayload<S extends boolean | null | undefined | SchemaFieldsRankedUrlDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsRankedUrlPayload, S>





  /**
   * Fields of the SchemaFieldsRankedUrl model
   */ 
  interface SchemaFieldsRankedUrlFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsRankedUrl", 'Json'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsRankedUrl without action
   */
  export type SchemaFieldsRankedUrlDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsRankedUrl
     */
    select?: SchemaFieldsRankedUrlSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsRankedUrl
     */
    omit?: SchemaFieldsRankedUrlOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsRanknow
   */





  export type SchemaFieldsRanknowSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsRanknow"]>



  export type SchemaFieldsRanknowSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsRanknowOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsRanknow"]>

  export type $SchemaFieldsRanknowPayload = {
    name: "SchemaFieldsRanknow"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsRanknowGetPayload<S extends boolean | null | undefined | SchemaFieldsRanknowDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsRanknowPayload, S>





  /**
   * Fields of the SchemaFieldsRanknow model
   */ 
  interface SchemaFieldsRanknowFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsRanknow", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsRanknow without action
   */
  export type SchemaFieldsRanknowDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsRanknow
     */
    select?: SchemaFieldsRanknowSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsRanknow
     */
    omit?: SchemaFieldsRanknowOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsRegion
   */





  export type SchemaFieldsRegionSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsRegion"]>



  export type SchemaFieldsRegionSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsRegionOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsRegion"]>

  export type $SchemaFieldsRegionPayload = {
    name: "SchemaFieldsRegion"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsRegionGetPayload<S extends boolean | null | undefined | SchemaFieldsRegionDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsRegionPayload, S>





  /**
   * Fields of the SchemaFieldsRegion model
   */ 
  interface SchemaFieldsRegionFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsRegion", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsRegion without action
   */
  export type SchemaFieldsRegionDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsRegion
     */
    select?: SchemaFieldsRegionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsRegion
     */
    omit?: SchemaFieldsRegionOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsRegionCode
   */





  export type SchemaFieldsRegionCodeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsRegionCode"]>



  export type SchemaFieldsRegionCodeSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsRegionCodeOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsRegionCode"]>

  export type $SchemaFieldsRegionCodePayload = {
    name: "SchemaFieldsRegionCode"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsRegionCodeGetPayload<S extends boolean | null | undefined | SchemaFieldsRegionCodeDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsRegionCodePayload, S>





  /**
   * Fields of the SchemaFieldsRegionCode model
   */ 
  interface SchemaFieldsRegionCodeFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsRegionCode", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsRegionCode without action
   */
  export type SchemaFieldsRegionCodeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsRegionCode
     */
    select?: SchemaFieldsRegionCodeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsRegionCode
     */
    omit?: SchemaFieldsRegionCodeOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsRegionCountry
   */





  export type SchemaFieldsRegionCountrySelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsRegionCountry"]>



  export type SchemaFieldsRegionCountrySelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsRegionCountryOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsRegionCountry"]>

  export type $SchemaFieldsRegionCountryPayload = {
    name: "SchemaFieldsRegionCountry"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsRegionCountryGetPayload<S extends boolean | null | undefined | SchemaFieldsRegionCountryDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsRegionCountryPayload, S>





  /**
   * Fields of the SchemaFieldsRegionCountry model
   */ 
  interface SchemaFieldsRegionCountryFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsRegionCountry", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsRegionCountry without action
   */
  export type SchemaFieldsRegionCountryDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsRegionCountry
     */
    select?: SchemaFieldsRegionCountrySelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsRegionCountry
     */
    omit?: SchemaFieldsRegionCountryOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsRegionName
   */





  export type SchemaFieldsRegionNameSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsRegionName"]>



  export type SchemaFieldsRegionNameSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsRegionNameOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsRegionName"]>

  export type $SchemaFieldsRegionNamePayload = {
    name: "SchemaFieldsRegionName"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsRegionNameGetPayload<S extends boolean | null | undefined | SchemaFieldsRegionNameDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsRegionNamePayload, S>





  /**
   * Fields of the SchemaFieldsRegionName model
   */ 
  interface SchemaFieldsRegionNameFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsRegionName", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsRegionName without action
   */
  export type SchemaFieldsRegionNameDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsRegionName
     */
    select?: SchemaFieldsRegionNameSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsRegionName
     */
    omit?: SchemaFieldsRegionNameOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsResultsPerPage
   */





  export type SchemaFieldsResultsPerPageSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsResultsPerPage"]>



  export type SchemaFieldsResultsPerPageSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsResultsPerPageOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsResultsPerPage"]>

  export type $SchemaFieldsResultsPerPagePayload = {
    name: "SchemaFieldsResultsPerPage"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsResultsPerPageGetPayload<S extends boolean | null | undefined | SchemaFieldsResultsPerPageDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsResultsPerPagePayload, S>





  /**
   * Fields of the SchemaFieldsResultsPerPage model
   */ 
  interface SchemaFieldsResultsPerPageFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsResultsPerPage", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsResultsPerPage without action
   */
  export type SchemaFieldsResultsPerPageDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsResultsPerPage
     */
    select?: SchemaFieldsResultsPerPageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsResultsPerPage
     */
    omit?: SchemaFieldsResultsPerPageOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsSearchIntent
   */





  export type SchemaFieldsSearchIntentSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsSearchIntent"]>



  export type SchemaFieldsSearchIntentSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsSearchIntentOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsSearchIntent"]>

  export type $SchemaFieldsSearchIntentPayload = {
    name: "SchemaFieldsSearchIntent"
    objects: {}
    scalars: {
      /**
       * Could not determine type: the field only had null or empty values in the sample set.
       */
      type_code: Prisma.JsonValue | null
    }
    composites: {}
  }

  type SchemaFieldsSearchIntentGetPayload<S extends boolean | null | undefined | SchemaFieldsSearchIntentDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsSearchIntentPayload, S>





  /**
   * Fields of the SchemaFieldsSearchIntent model
   */ 
  interface SchemaFieldsSearchIntentFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsSearchIntent", 'Json'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsSearchIntent without action
   */
  export type SchemaFieldsSearchIntentDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsSearchIntent
     */
    select?: SchemaFieldsSearchIntentSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsSearchIntent
     */
    omit?: SchemaFieldsSearchIntentOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsSearchVolume
   */





  export type SchemaFieldsSearchVolumeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsSearchVolume"]>



  export type SchemaFieldsSearchVolumeSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsSearchVolumeOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsSearchVolume"]>

  export type $SchemaFieldsSearchVolumePayload = {
    name: "SchemaFieldsSearchVolume"
    objects: {}
    scalars: {
      /**
       * Could not determine type: the field only had null or empty values in the sample set.
       */
      type_code: Prisma.JsonValue | null
    }
    composites: {}
  }

  type SchemaFieldsSearchVolumeGetPayload<S extends boolean | null | undefined | SchemaFieldsSearchVolumeDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsSearchVolumePayload, S>





  /**
   * Fields of the SchemaFieldsSearchVolume model
   */ 
  interface SchemaFieldsSearchVolumeFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsSearchVolume", 'Json'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsSearchVolume without action
   */
  export type SchemaFieldsSearchVolumeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsSearchVolume
     */
    select?: SchemaFieldsSearchVolumeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsSearchVolume
     */
    omit?: SchemaFieldsSearchVolumeOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsSearchvolumeCountryId
   */





  export type SchemaFieldsSearchvolumeCountryIdSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsSearchvolumeCountryId"]>



  export type SchemaFieldsSearchvolumeCountryIdSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsSearchvolumeCountryIdOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsSearchvolumeCountryId"]>

  export type $SchemaFieldsSearchvolumeCountryIdPayload = {
    name: "SchemaFieldsSearchvolumeCountryId"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsSearchvolumeCountryIdGetPayload<S extends boolean | null | undefined | SchemaFieldsSearchvolumeCountryIdDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsSearchvolumeCountryIdPayload, S>





  /**
   * Fields of the SchemaFieldsSearchvolumeCountryId model
   */ 
  interface SchemaFieldsSearchvolumeCountryIdFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsSearchvolumeCountryId", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsSearchvolumeCountryId without action
   */
  export type SchemaFieldsSearchvolumeCountryIdDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsSearchvolumeCountryId
     */
    select?: SchemaFieldsSearchvolumeCountryIdSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsSearchvolumeCountryId
     */
    omit?: SchemaFieldsSearchvolumeCountryIdOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsSessionData
   */





  export type SchemaFieldsSessionDataSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsSessionData"]>



  export type SchemaFieldsSessionDataSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsSessionDataOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsSessionData"]>

  export type $SchemaFieldsSessionDataPayload = {
    name: "SchemaFieldsSessionData"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsSessionDataGetPayload<S extends boolean | null | undefined | SchemaFieldsSessionDataDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsSessionDataPayload, S>





  /**
   * Fields of the SchemaFieldsSessionData model
   */ 
  interface SchemaFieldsSessionDataFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsSessionData", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsSessionData without action
   */
  export type SchemaFieldsSessionDataDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsSessionData
     */
    select?: SchemaFieldsSessionDataSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsSessionData
     */
    omit?: SchemaFieldsSessionDataOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsSessionKey
   */





  export type SchemaFieldsSessionKeySelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsSessionKey"]>



  export type SchemaFieldsSessionKeySelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsSessionKeyOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsSessionKey"]>

  export type $SchemaFieldsSessionKeyPayload = {
    name: "SchemaFieldsSessionKey"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsSessionKeyGetPayload<S extends boolean | null | undefined | SchemaFieldsSessionKeyDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsSessionKeyPayload, S>





  /**
   * Fields of the SchemaFieldsSessionKey model
   */ 
  interface SchemaFieldsSessionKeyFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsSessionKey", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsSessionKey without action
   */
  export type SchemaFieldsSessionKeyDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsSessionKey
     */
    select?: SchemaFieldsSessionKeySelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsSessionKey
     */
    omit?: SchemaFieldsSessionKeyOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsSiteUrl
   */





  export type SchemaFieldsSiteUrlSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsSiteUrl"]>



  export type SchemaFieldsSiteUrlSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsSiteUrlOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsSiteUrl"]>

  export type $SchemaFieldsSiteUrlPayload = {
    name: "SchemaFieldsSiteUrl"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsSiteUrlGetPayload<S extends boolean | null | undefined | SchemaFieldsSiteUrlDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsSiteUrlPayload, S>





  /**
   * Fields of the SchemaFieldsSiteUrl model
   */ 
  interface SchemaFieldsSiteUrlFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsSiteUrl", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsSiteUrl without action
   */
  export type SchemaFieldsSiteUrlDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsSiteUrl
     */
    select?: SchemaFieldsSiteUrlSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsSiteUrl
     */
    omit?: SchemaFieldsSiteUrlOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsStatus
   */





  export type SchemaFieldsStatusSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsStatus"]>



  export type SchemaFieldsStatusSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsStatusOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsStatus"]>

  export type $SchemaFieldsStatusPayload = {
    name: "SchemaFieldsStatus"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsStatusGetPayload<S extends boolean | null | undefined | SchemaFieldsStatusDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsStatusPayload, S>





  /**
   * Fields of the SchemaFieldsStatus model
   */ 
  interface SchemaFieldsStatusFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsStatus", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsStatus without action
   */
  export type SchemaFieldsStatusDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsStatus
     */
    select?: SchemaFieldsStatusSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsStatus
     */
    omit?: SchemaFieldsStatusOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsStatusFromStart
   */





  export type SchemaFieldsStatusFromStartSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsStatusFromStart"]>



  export type SchemaFieldsStatusFromStartSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsStatusFromStartOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsStatusFromStart"]>

  export type $SchemaFieldsStatusFromStartPayload = {
    name: "SchemaFieldsStatusFromStart"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsStatusFromStartGetPayload<S extends boolean | null | undefined | SchemaFieldsStatusFromStartDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsStatusFromStartPayload, S>





  /**
   * Fields of the SchemaFieldsStatusFromStart model
   */ 
  interface SchemaFieldsStatusFromStartFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsStatusFromStart", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsStatusFromStart without action
   */
  export type SchemaFieldsStatusFromStartDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsStatusFromStart
     */
    select?: SchemaFieldsStatusFromStartSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsStatusFromStart
     */
    omit?: SchemaFieldsStatusFromStartOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsTarget
   */





  export type SchemaFieldsTargetSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsTarget"]>



  export type SchemaFieldsTargetSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsTargetOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsTarget"]>

  export type $SchemaFieldsTargetPayload = {
    name: "SchemaFieldsTarget"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsTargetGetPayload<S extends boolean | null | undefined | SchemaFieldsTargetDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsTargetPayload, S>





  /**
   * Fields of the SchemaFieldsTarget model
   */ 
  interface SchemaFieldsTargetFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsTarget", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsTarget without action
   */
  export type SchemaFieldsTargetDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsTarget
     */
    select?: SchemaFieldsTargetSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsTarget
     */
    omit?: SchemaFieldsTargetOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsTimeZone
   */





  export type SchemaFieldsTimeZoneSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsTimeZone"]>



  export type SchemaFieldsTimeZoneSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsTimeZoneOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsTimeZone"]>

  export type $SchemaFieldsTimeZonePayload = {
    name: "SchemaFieldsTimeZone"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsTimeZoneGetPayload<S extends boolean | null | undefined | SchemaFieldsTimeZoneDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsTimeZonePayload, S>





  /**
   * Fields of the SchemaFieldsTimeZone model
   */ 
  interface SchemaFieldsTimeZoneFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsTimeZone", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsTimeZone without action
   */
  export type SchemaFieldsTimeZoneDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsTimeZone
     */
    select?: SchemaFieldsTimeZoneSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsTimeZone
     */
    omit?: SchemaFieldsTimeZoneOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsTopRank
   */





  export type SchemaFieldsTopRankSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsTopRank"]>



  export type SchemaFieldsTopRankSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsTopRankOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsTopRank"]>

  export type $SchemaFieldsTopRankPayload = {
    name: "SchemaFieldsTopRank"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsTopRankGetPayload<S extends boolean | null | undefined | SchemaFieldsTopRankDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsTopRankPayload, S>





  /**
   * Fields of the SchemaFieldsTopRank model
   */ 
  interface SchemaFieldsTopRankFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsTopRank", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsTopRank without action
   */
  export type SchemaFieldsTopRankDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsTopRank
     */
    select?: SchemaFieldsTopRankSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsTopRank
     */
    omit?: SchemaFieldsTopRankOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsTrackStatus
   */





  export type SchemaFieldsTrackStatusSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsTrackStatus"]>



  export type SchemaFieldsTrackStatusSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsTrackStatusOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsTrackStatus"]>

  export type $SchemaFieldsTrackStatusPayload = {
    name: "SchemaFieldsTrackStatus"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsTrackStatusGetPayload<S extends boolean | null | undefined | SchemaFieldsTrackStatusDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsTrackStatusPayload, S>





  /**
   * Fields of the SchemaFieldsTrackStatus model
   */ 
  interface SchemaFieldsTrackStatusFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsTrackStatus", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsTrackStatus without action
   */
  export type SchemaFieldsTrackStatusDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsTrackStatus
     */
    select?: SchemaFieldsTrackStatusSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsTrackStatus
     */
    omit?: SchemaFieldsTrackStatusOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsTraffic
   */





  export type SchemaFieldsTrafficSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsTraffic"]>



  export type SchemaFieldsTrafficSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsTrafficOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsTraffic"]>

  export type $SchemaFieldsTrafficPayload = {
    name: "SchemaFieldsTraffic"
    objects: {}
    scalars: {
      /**
       * Could not determine type: the field only had null or empty values in the sample set.
       */
      type_code: Prisma.JsonValue | null
    }
    composites: {}
  }

  type SchemaFieldsTrafficGetPayload<S extends boolean | null | undefined | SchemaFieldsTrafficDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsTrafficPayload, S>





  /**
   * Fields of the SchemaFieldsTraffic model
   */ 
  interface SchemaFieldsTrafficFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsTraffic", 'Json'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsTraffic without action
   */
  export type SchemaFieldsTrafficDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsTraffic
     */
    select?: SchemaFieldsTrafficSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsTraffic
     */
    omit?: SchemaFieldsTrafficOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsUpdatedDate
   */





  export type SchemaFieldsUpdatedDateSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsUpdatedDate"]>



  export type SchemaFieldsUpdatedDateSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsUpdatedDateOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsUpdatedDate"]>

  export type $SchemaFieldsUpdatedDatePayload = {
    name: "SchemaFieldsUpdatedDate"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsUpdatedDateGetPayload<S extends boolean | null | undefined | SchemaFieldsUpdatedDateDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsUpdatedDatePayload, S>





  /**
   * Fields of the SchemaFieldsUpdatedDate model
   */ 
  interface SchemaFieldsUpdatedDateFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsUpdatedDate", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsUpdatedDate without action
   */
  export type SchemaFieldsUpdatedDateDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsUpdatedDate
     */
    select?: SchemaFieldsUpdatedDateSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsUpdatedDate
     */
    omit?: SchemaFieldsUpdatedDateOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsUptrendCnt
   */





  export type SchemaFieldsUptrendCntSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsUptrendCnt"]>



  export type SchemaFieldsUptrendCntSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsUptrendCntOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsUptrendCnt"]>

  export type $SchemaFieldsUptrendCntPayload = {
    name: "SchemaFieldsUptrendCnt"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsUptrendCntGetPayload<S extends boolean | null | undefined | SchemaFieldsUptrendCntDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsUptrendCntPayload, S>





  /**
   * Fields of the SchemaFieldsUptrendCnt model
   */ 
  interface SchemaFieldsUptrendCntFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsUptrendCnt", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsUptrendCnt without action
   */
  export type SchemaFieldsUptrendCntDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsUptrendCnt
     */
    select?: SchemaFieldsUptrendCntSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsUptrendCnt
     */
    omit?: SchemaFieldsUptrendCntOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsUrl
   */





  export type SchemaFieldsUrlSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsUrl"]>



  export type SchemaFieldsUrlSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsUrlOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsUrl"]>

  export type $SchemaFieldsUrlPayload = {
    name: "SchemaFieldsUrl"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsUrlGetPayload<S extends boolean | null | undefined | SchemaFieldsUrlDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsUrlPayload, S>





  /**
   * Fields of the SchemaFieldsUrl model
   */ 
  interface SchemaFieldsUrlFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsUrl", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsUrl without action
   */
  export type SchemaFieldsUrlDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsUrl
     */
    select?: SchemaFieldsUrlSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsUrl
     */
    omit?: SchemaFieldsUrlOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsUserAutomationTime
   */





  export type SchemaFieldsUserAutomationTimeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsUserAutomationTime"]>



  export type SchemaFieldsUserAutomationTimeSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsUserAutomationTimeOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsUserAutomationTime"]>

  export type $SchemaFieldsUserAutomationTimePayload = {
    name: "SchemaFieldsUserAutomationTime"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsUserAutomationTimeGetPayload<S extends boolean | null | undefined | SchemaFieldsUserAutomationTimeDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsUserAutomationTimePayload, S>





  /**
   * Fields of the SchemaFieldsUserAutomationTime model
   */ 
  interface SchemaFieldsUserAutomationTimeFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsUserAutomationTime", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsUserAutomationTime without action
   */
  export type SchemaFieldsUserAutomationTimeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsUserAutomationTime
     */
    select?: SchemaFieldsUserAutomationTimeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsUserAutomationTime
     */
    omit?: SchemaFieldsUserAutomationTimeOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsUserId
   */





  export type SchemaFieldsUserIdSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsUserId"]>



  export type SchemaFieldsUserIdSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsUserIdOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsUserId"]>

  export type $SchemaFieldsUserIdPayload = {
    name: "SchemaFieldsUserId"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsUserIdGetPayload<S extends boolean | null | undefined | SchemaFieldsUserIdDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsUserIdPayload, S>





  /**
   * Fields of the SchemaFieldsUserId model
   */ 
  interface SchemaFieldsUserIdFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsUserId", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsUserId without action
   */
  export type SchemaFieldsUserIdDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsUserId
     */
    select?: SchemaFieldsUserIdSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsUserId
     */
    omit?: SchemaFieldsUserIdOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsUsername
   */





  export type SchemaFieldsUsernameSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsUsername"]>



  export type SchemaFieldsUsernameSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsUsernameOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsUsername"]>

  export type $SchemaFieldsUsernamePayload = {
    name: "SchemaFieldsUsername"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsUsernameGetPayload<S extends boolean | null | undefined | SchemaFieldsUsernameDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsUsernamePayload, S>





  /**
   * Fields of the SchemaFieldsUsername model
   */ 
  interface SchemaFieldsUsernameFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsUsername", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsUsername without action
   */
  export type SchemaFieldsUsernameDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsUsername
     */
    select?: SchemaFieldsUsernameSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsUsername
     */
    omit?: SchemaFieldsUsernameOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsWeekmark
   */





  export type SchemaFieldsWeekmarkSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsWeekmark"]>



  export type SchemaFieldsWeekmarkSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsWeekmarkOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsWeekmark"]>

  export type $SchemaFieldsWeekmarkPayload = {
    name: "SchemaFieldsWeekmark"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsWeekmarkGetPayload<S extends boolean | null | undefined | SchemaFieldsWeekmarkDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsWeekmarkPayload, S>





  /**
   * Fields of the SchemaFieldsWeekmark model
   */ 
  interface SchemaFieldsWeekmarkFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsWeekmark", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsWeekmark without action
   */
  export type SchemaFieldsWeekmarkDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsWeekmark
     */
    select?: SchemaFieldsWeekmarkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsWeekmark
     */
    omit?: SchemaFieldsWeekmarkOmit<ExtArgs> | null
  }


  /**
   * Model SchemaFieldsWeekval
   */





  export type SchemaFieldsWeekvalSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    type_code?: boolean
  }, ExtArgs["result"]["schemaFieldsWeekval"]>



  export type SchemaFieldsWeekvalSelectScalar = {
    type_code?: boolean
  }

  export type SchemaFieldsWeekvalOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"type_code", ExtArgs["result"]["schemaFieldsWeekval"]>

  export type $SchemaFieldsWeekvalPayload = {
    name: "SchemaFieldsWeekval"
    objects: {}
    scalars: {
      type_code: string
    }
    composites: {}
  }

  type SchemaFieldsWeekvalGetPayload<S extends boolean | null | undefined | SchemaFieldsWeekvalDefaultArgs> = $Result.GetResult<Prisma.$SchemaFieldsWeekvalPayload, S>





  /**
   * Fields of the SchemaFieldsWeekval model
   */ 
  interface SchemaFieldsWeekvalFieldRefs {
    readonly type_code: FieldRef<"SchemaFieldsWeekval", 'String'>
  }
    

  // Custom InputTypes
  /**
   * SchemaFieldsWeekval without action
   */
  export type SchemaFieldsWeekvalDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SchemaFieldsWeekval
     */
    select?: SchemaFieldsWeekvalSelect<ExtArgs> | null
    /**
     * Omit specific fields from the SchemaFieldsWeekval
     */
    omit?: SchemaFieldsWeekvalOmit<ExtArgs> | null
  }


  /**
   * Model schema__
   */

  export type AggregateSchema__ = {
    _count: Schema__CountAggregateOutputType | null
    _min: Schema__MinAggregateOutputType | null
    _max: Schema__MaxAggregateOutputType | null
  }

  export type Schema__MinAggregateOutputType = {
    id: string | null
    name: string | null
  }

  export type Schema__MaxAggregateOutputType = {
    id: string | null
    name: string | null
  }

  export type Schema__CountAggregateOutputType = {
    id: number
    name: number
    _all: number
  }


  export type Schema__MinAggregateInputType = {
    id?: true
    name?: true
  }

  export type Schema__MaxAggregateInputType = {
    id?: true
    name?: true
  }

  export type Schema__CountAggregateInputType = {
    id?: true
    name?: true
    _all?: true
  }

  export type Schema__AggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which schema__ to aggregate.
     */
    where?: schema__WhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of schema__s to fetch.
     */
    orderBy?: schema__OrderByWithRelationInput | schema__OrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: schema__WhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` schema__s from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` schema__s.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned schema__s
    **/
    _count?: true | Schema__CountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Schema__MinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Schema__MaxAggregateInputType
  }

  export type GetSchema__AggregateType<T extends Schema__AggregateArgs> = {
        [P in keyof T & keyof AggregateSchema__]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateSchema__[P]>
      : GetScalarType<T[P], AggregateSchema__[P]>
  }




  export type schema__GroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: schema__WhereInput
    orderBy?: schema__OrderByWithAggregationInput | schema__OrderByWithAggregationInput[]
    by: Schema__ScalarFieldEnum[] | Schema__ScalarFieldEnum
    having?: schema__ScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Schema__CountAggregateInputType | true
    _min?: Schema__MinAggregateInputType
    _max?: Schema__MaxAggregateInputType
  }

  export type Schema__GroupByOutputType = {
    id: string
    name: string
    _count: Schema__CountAggregateOutputType | null
    _min: Schema__MinAggregateOutputType | null
    _max: Schema__MaxAggregateOutputType | null
  }

  type GetSchema__GroupByPayload<T extends schema__GroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Schema__GroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Schema__GroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Schema__GroupByOutputType[P]>
            : GetScalarType<T[P], Schema__GroupByOutputType[P]>
        }
      >
    >


  export type schema__Select<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    auto?: boolean | SchemaAutoDefaultArgs<ExtArgs>
    fields?: boolean | SchemaFieldsDefaultArgs<ExtArgs>
    name?: boolean
  }, ExtArgs["result"]["schema__"]>



  export type schema__SelectScalar = {
    id?: boolean
    name?: boolean
  }

  export type schema__Omit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "auto" | "fields" | "name", ExtArgs["result"]["schema__"]>
  export type schema__Include<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {}

  export type $schema__Payload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "schema__"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: string
      name: string
    }, ExtArgs["result"]["schema__"]>
    composites: {
      auto: Prisma.$SchemaAutoPayload | null
      fields: Prisma.$SchemaFieldsPayload
    }
  }

  type schema__GetPayload<S extends boolean | null | undefined | schema__DefaultArgs> = $Result.GetResult<Prisma.$schema__Payload, S>

  type schema__CountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<schema__FindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Schema__CountAggregateInputType | true
    }

  export interface schema__Delegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['schema__'], meta: { name: 'schema__' } }
    /**
     * Find zero or one Schema__ that matches the filter.
     * @param {schema__FindUniqueArgs} args - Arguments to find a Schema__
     * @example
     * // Get one Schema__
     * const schema__ = await prisma.schema__.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends schema__FindUniqueArgs>(args: SelectSubset<T, schema__FindUniqueArgs<ExtArgs>>): Prisma__schema__Client<$Result.GetResult<Prisma.$schema__Payload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Schema__ that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {schema__FindUniqueOrThrowArgs} args - Arguments to find a Schema__
     * @example
     * // Get one Schema__
     * const schema__ = await prisma.schema__.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends schema__FindUniqueOrThrowArgs>(args: SelectSubset<T, schema__FindUniqueOrThrowArgs<ExtArgs>>): Prisma__schema__Client<$Result.GetResult<Prisma.$schema__Payload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Schema__ that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {schema__FindFirstArgs} args - Arguments to find a Schema__
     * @example
     * // Get one Schema__
     * const schema__ = await prisma.schema__.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends schema__FindFirstArgs>(args?: SelectSubset<T, schema__FindFirstArgs<ExtArgs>>): Prisma__schema__Client<$Result.GetResult<Prisma.$schema__Payload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Schema__ that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {schema__FindFirstOrThrowArgs} args - Arguments to find a Schema__
     * @example
     * // Get one Schema__
     * const schema__ = await prisma.schema__.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends schema__FindFirstOrThrowArgs>(args?: SelectSubset<T, schema__FindFirstOrThrowArgs<ExtArgs>>): Prisma__schema__Client<$Result.GetResult<Prisma.$schema__Payload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Schema__s that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {schema__FindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Schema__s
     * const schema__s = await prisma.schema__.findMany()
     * 
     * // Get first 10 Schema__s
     * const schema__s = await prisma.schema__.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const schema__WithIdOnly = await prisma.schema__.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends schema__FindManyArgs>(args?: SelectSubset<T, schema__FindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$schema__Payload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Schema__.
     * @param {schema__CreateArgs} args - Arguments to create a Schema__.
     * @example
     * // Create one Schema__
     * const Schema__ = await prisma.schema__.create({
     *   data: {
     *     // ... data to create a Schema__
     *   }
     * })
     * 
     */
    create<T extends schema__CreateArgs>(args: SelectSubset<T, schema__CreateArgs<ExtArgs>>): Prisma__schema__Client<$Result.GetResult<Prisma.$schema__Payload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Schema__s.
     * @param {schema__CreateManyArgs} args - Arguments to create many Schema__s.
     * @example
     * // Create many Schema__s
     * const schema__ = await prisma.schema__.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends schema__CreateManyArgs>(args?: SelectSubset<T, schema__CreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Schema__.
     * @param {schema__DeleteArgs} args - Arguments to delete one Schema__.
     * @example
     * // Delete one Schema__
     * const Schema__ = await prisma.schema__.delete({
     *   where: {
     *     // ... filter to delete one Schema__
     *   }
     * })
     * 
     */
    delete<T extends schema__DeleteArgs>(args: SelectSubset<T, schema__DeleteArgs<ExtArgs>>): Prisma__schema__Client<$Result.GetResult<Prisma.$schema__Payload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Schema__.
     * @param {schema__UpdateArgs} args - Arguments to update one Schema__.
     * @example
     * // Update one Schema__
     * const schema__ = await prisma.schema__.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends schema__UpdateArgs>(args: SelectSubset<T, schema__UpdateArgs<ExtArgs>>): Prisma__schema__Client<$Result.GetResult<Prisma.$schema__Payload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Schema__s.
     * @param {schema__DeleteManyArgs} args - Arguments to filter Schema__s to delete.
     * @example
     * // Delete a few Schema__s
     * const { count } = await prisma.schema__.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends schema__DeleteManyArgs>(args?: SelectSubset<T, schema__DeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Schema__s.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {schema__UpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Schema__s
     * const schema__ = await prisma.schema__.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends schema__UpdateManyArgs>(args: SelectSubset<T, schema__UpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Schema__.
     * @param {schema__UpsertArgs} args - Arguments to update or create a Schema__.
     * @example
     * // Update or create a Schema__
     * const schema__ = await prisma.schema__.upsert({
     *   create: {
     *     // ... data to create a Schema__
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Schema__ we want to update
     *   }
     * })
     */
    upsert<T extends schema__UpsertArgs>(args: SelectSubset<T, schema__UpsertArgs<ExtArgs>>): Prisma__schema__Client<$Result.GetResult<Prisma.$schema__Payload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Schema__s that matches the filter.
     * @param {schema__FindRawArgs} args - Select which filters you would like to apply.
     * @example
     * const schema__ = await prisma.schema__.findRaw({
     *   filter: { age: { $gt: 25 } }
     * })
     */
    findRaw(args?: schema__FindRawArgs): Prisma.PrismaPromise<JsonObject>

    /**
     * Perform aggregation operations on a Schema__.
     * @param {schema__AggregateRawArgs} args - Select which aggregations you would like to apply.
     * @example
     * const schema__ = await prisma.schema__.aggregateRaw({
     *   pipeline: [
     *     { $match: { status: "registered" } },
     *     { $group: { _id: "$country", total: { $sum: 1 } } }
     *   ]
     * })
     */
    aggregateRaw(args?: schema__AggregateRawArgs): Prisma.PrismaPromise<JsonObject>


    /**
     * Count the number of Schema__s.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {schema__CountArgs} args - Arguments to filter Schema__s to count.
     * @example
     * // Count the number of Schema__s
     * const count = await prisma.schema__.count({
     *   where: {
     *     // ... the filter for the Schema__s we want to count
     *   }
     * })
    **/
    count<T extends schema__CountArgs>(
      args?: Subset<T, schema__CountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Schema__CountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Schema__.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Schema__AggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Schema__AggregateArgs>(args: Subset<T, Schema__AggregateArgs>): Prisma.PrismaPromise<GetSchema__AggregateType<T>>

    /**
     * Group by Schema__.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {schema__GroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends schema__GroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: schema__GroupByArgs['orderBy'] }
        : { orderBy?: schema__GroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, schema__GroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetSchema__GroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the schema__ model
   */
  readonly fields: schema__FieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for schema__.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__schema__Client<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the schema__ model
   */ 
  interface schema__FieldRefs {
    readonly id: FieldRef<"schema__", 'String'>
    readonly name: FieldRef<"schema__", 'String'>
  }
    

  // Custom InputTypes
  /**
   * schema__ findUnique
   */
  export type schema__FindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the schema__
     */
    select?: schema__Select<ExtArgs> | null
    /**
     * Omit specific fields from the schema__
     */
    omit?: schema__Omit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: schema__Include<ExtArgs> | null
    /**
     * Filter, which schema__ to fetch.
     */
    where: schema__WhereUniqueInput
  }

  /**
   * schema__ findUniqueOrThrow
   */
  export type schema__FindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the schema__
     */
    select?: schema__Select<ExtArgs> | null
    /**
     * Omit specific fields from the schema__
     */
    omit?: schema__Omit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: schema__Include<ExtArgs> | null
    /**
     * Filter, which schema__ to fetch.
     */
    where: schema__WhereUniqueInput
  }

  /**
   * schema__ findFirst
   */
  export type schema__FindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the schema__
     */
    select?: schema__Select<ExtArgs> | null
    /**
     * Omit specific fields from the schema__
     */
    omit?: schema__Omit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: schema__Include<ExtArgs> | null
    /**
     * Filter, which schema__ to fetch.
     */
    where?: schema__WhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of schema__s to fetch.
     */
    orderBy?: schema__OrderByWithRelationInput | schema__OrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for schema__s.
     */
    cursor?: schema__WhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` schema__s from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` schema__s.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of schema__s.
     */
    distinct?: Schema__ScalarFieldEnum | Schema__ScalarFieldEnum[]
  }

  /**
   * schema__ findFirstOrThrow
   */
  export type schema__FindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the schema__
     */
    select?: schema__Select<ExtArgs> | null
    /**
     * Omit specific fields from the schema__
     */
    omit?: schema__Omit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: schema__Include<ExtArgs> | null
    /**
     * Filter, which schema__ to fetch.
     */
    where?: schema__WhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of schema__s to fetch.
     */
    orderBy?: schema__OrderByWithRelationInput | schema__OrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for schema__s.
     */
    cursor?: schema__WhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` schema__s from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` schema__s.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of schema__s.
     */
    distinct?: Schema__ScalarFieldEnum | Schema__ScalarFieldEnum[]
  }

  /**
   * schema__ findMany
   */
  export type schema__FindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the schema__
     */
    select?: schema__Select<ExtArgs> | null
    /**
     * Omit specific fields from the schema__
     */
    omit?: schema__Omit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: schema__Include<ExtArgs> | null
    /**
     * Filter, which schema__s to fetch.
     */
    where?: schema__WhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of schema__s to fetch.
     */
    orderBy?: schema__OrderByWithRelationInput | schema__OrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing schema__s.
     */
    cursor?: schema__WhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` schema__s from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` schema__s.
     */
    skip?: number
    distinct?: Schema__ScalarFieldEnum | Schema__ScalarFieldEnum[]
  }

  /**
   * schema__ create
   */
  export type schema__CreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the schema__
     */
    select?: schema__Select<ExtArgs> | null
    /**
     * Omit specific fields from the schema__
     */
    omit?: schema__Omit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: schema__Include<ExtArgs> | null
    /**
     * The data needed to create a schema__.
     */
    data: XOR<schema__CreateInput, schema__UncheckedCreateInput>
  }

  /**
   * schema__ createMany
   */
  export type schema__CreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many schema__s.
     */
    data: schema__CreateManyInput | schema__CreateManyInput[]
  }

  /**
   * schema__ update
   */
  export type schema__UpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the schema__
     */
    select?: schema__Select<ExtArgs> | null
    /**
     * Omit specific fields from the schema__
     */
    omit?: schema__Omit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: schema__Include<ExtArgs> | null
    /**
     * The data needed to update a schema__.
     */
    data: XOR<schema__UpdateInput, schema__UncheckedUpdateInput>
    /**
     * Choose, which schema__ to update.
     */
    where: schema__WhereUniqueInput
  }

  /**
   * schema__ updateMany
   */
  export type schema__UpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update schema__s.
     */
    data: XOR<schema__UpdateManyMutationInput, schema__UncheckedUpdateManyInput>
    /**
     * Filter which schema__s to update
     */
    where?: schema__WhereInput
    /**
     * Limit how many schema__s to update.
     */
    limit?: number
  }

  /**
   * schema__ upsert
   */
  export type schema__UpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the schema__
     */
    select?: schema__Select<ExtArgs> | null
    /**
     * Omit specific fields from the schema__
     */
    omit?: schema__Omit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: schema__Include<ExtArgs> | null
    /**
     * The filter to search for the schema__ to update in case it exists.
     */
    where: schema__WhereUniqueInput
    /**
     * In case the schema__ found by the `where` argument doesn't exist, create a new schema__ with this data.
     */
    create: XOR<schema__CreateInput, schema__UncheckedCreateInput>
    /**
     * In case the schema__ was found with the provided `where` argument, update it with this data.
     */
    update: XOR<schema__UpdateInput, schema__UncheckedUpdateInput>
  }

  /**
   * schema__ delete
   */
  export type schema__DeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the schema__
     */
    select?: schema__Select<ExtArgs> | null
    /**
     * Omit specific fields from the schema__
     */
    omit?: schema__Omit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: schema__Include<ExtArgs> | null
    /**
     * Filter which schema__ to delete.
     */
    where: schema__WhereUniqueInput
  }

  /**
   * schema__ deleteMany
   */
  export type schema__DeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which schema__s to delete
     */
    where?: schema__WhereInput
    /**
     * Limit how many schema__s to delete.
     */
    limit?: number
  }

  /**
   * schema__ findRaw
   */
  export type schema__FindRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The query predicate filter. If unspecified, then all documents in the collection will match the predicate. ${@link https://docs.mongodb.com/manual/reference/operator/query MongoDB Docs}.
     */
    filter?: InputJsonValue
    /**
     * Additional options to pass to the `find` command ${@link https://docs.mongodb.com/manual/reference/command/find/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * schema__ aggregateRaw
   */
  export type schema__AggregateRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * An array of aggregation stages to process and transform the document stream via the aggregation pipeline. ${@link https://docs.mongodb.com/manual/reference/operator/aggregation-pipeline MongoDB Docs}.
     */
    pipeline?: InputJsonValue[]
    /**
     * Additional options to pass to the `aggregate` command ${@link https://docs.mongodb.com/manual/reference/command/aggregate/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * schema__ without action
   */
  export type schema__DefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the schema__
     */
    select?: schema__Select<ExtArgs> | null
    /**
     * Omit specific fields from the schema__
     */
    omit?: schema__Omit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: schema__Include<ExtArgs> | null
  }


  /**
   * Model account
   */

  export type AggregateAccount = {
    _count: AccountCountAggregateOutputType | null
    _avg: AccountAvgAggregateOutputType | null
    _sum: AccountSumAggregateOutputType | null
    _min: AccountMinAggregateOutputType | null
    _max: AccountMaxAggregateOutputType | null
  }

  export type AccountAvgAggregateOutputType = {
    id_: number | null
  }

  export type AccountSumAggregateOutputType = {
    id_: number | null
  }

  export type AccountMinAggregateOutputType = {
    id: string | null
    account_status: string | null
    date_joined: Date | null
    email: string | null
    id_: number | null
    is_active: boolean | null
    is_admin: boolean | null
    is_staff: boolean | null
    is_superuser: boolean | null
    last_login: Date | null
    last_logout: Date | null
    password: string | null
    username: string | null
  }

  export type AccountMaxAggregateOutputType = {
    id: string | null
    account_status: string | null
    date_joined: Date | null
    email: string | null
    id_: number | null
    is_active: boolean | null
    is_admin: boolean | null
    is_staff: boolean | null
    is_superuser: boolean | null
    last_login: Date | null
    last_logout: Date | null
    password: string | null
    username: string | null
  }

  export type AccountCountAggregateOutputType = {
    id: number
    account_status: number
    date_joined: number
    email: number
    id_: number
    is_active: number
    is_admin: number
    is_staff: number
    is_superuser: number
    last_home_visit: number
    last_login: number
    last_logout: number
    password: number
    username: number
    _all: number
  }


  export type AccountAvgAggregateInputType = {
    id_?: true
  }

  export type AccountSumAggregateInputType = {
    id_?: true
  }

  export type AccountMinAggregateInputType = {
    id?: true
    account_status?: true
    date_joined?: true
    email?: true
    id_?: true
    is_active?: true
    is_admin?: true
    is_staff?: true
    is_superuser?: true
    last_login?: true
    last_logout?: true
    password?: true
    username?: true
  }

  export type AccountMaxAggregateInputType = {
    id?: true
    account_status?: true
    date_joined?: true
    email?: true
    id_?: true
    is_active?: true
    is_admin?: true
    is_staff?: true
    is_superuser?: true
    last_login?: true
    last_logout?: true
    password?: true
    username?: true
  }

  export type AccountCountAggregateInputType = {
    id?: true
    account_status?: true
    date_joined?: true
    email?: true
    id_?: true
    is_active?: true
    is_admin?: true
    is_staff?: true
    is_superuser?: true
    last_home_visit?: true
    last_login?: true
    last_logout?: true
    password?: true
    username?: true
    _all?: true
  }

  export type AccountAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which account to aggregate.
     */
    where?: accountWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of accounts to fetch.
     */
    orderBy?: accountOrderByWithRelationInput | accountOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: accountWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` accounts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` accounts.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned accounts
    **/
    _count?: true | AccountCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: AccountAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: AccountSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: AccountMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: AccountMaxAggregateInputType
  }

  export type GetAccountAggregateType<T extends AccountAggregateArgs> = {
        [P in keyof T & keyof AggregateAccount]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAccount[P]>
      : GetScalarType<T[P], AggregateAccount[P]>
  }




  export type accountGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: accountWhereInput
    orderBy?: accountOrderByWithAggregationInput | accountOrderByWithAggregationInput[]
    by: AccountScalarFieldEnum[] | AccountScalarFieldEnum
    having?: accountScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: AccountCountAggregateInputType | true
    _avg?: AccountAvgAggregateInputType
    _sum?: AccountSumAggregateInputType
    _min?: AccountMinAggregateInputType
    _max?: AccountMaxAggregateInputType
  }

  export type AccountGroupByOutputType = {
    id: string
    account_status: string
    date_joined: Date
    email: string
    id_: number
    is_active: boolean
    is_admin: boolean
    is_staff: boolean
    is_superuser: boolean
    last_home_visit: JsonValue | null
    last_login: Date
    last_logout: Date
    password: string
    username: string
    _count: AccountCountAggregateOutputType | null
    _avg: AccountAvgAggregateOutputType | null
    _sum: AccountSumAggregateOutputType | null
    _min: AccountMinAggregateOutputType | null
    _max: AccountMaxAggregateOutputType | null
  }

  type GetAccountGroupByPayload<T extends accountGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<AccountGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof AccountGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], AccountGroupByOutputType[P]>
            : GetScalarType<T[P], AccountGroupByOutputType[P]>
        }
      >
    >


  export type accountSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    account_status?: boolean
    date_joined?: boolean
    email?: boolean
    id_?: boolean
    is_active?: boolean
    is_admin?: boolean
    is_staff?: boolean
    is_superuser?: boolean
    last_home_visit?: boolean
    last_login?: boolean
    last_logout?: boolean
    password?: boolean
    username?: boolean
  }, ExtArgs["result"]["account"]>



  export type accountSelectScalar = {
    id?: boolean
    account_status?: boolean
    date_joined?: boolean
    email?: boolean
    id_?: boolean
    is_active?: boolean
    is_admin?: boolean
    is_staff?: boolean
    is_superuser?: boolean
    last_home_visit?: boolean
    last_login?: boolean
    last_logout?: boolean
    password?: boolean
    username?: boolean
  }

  export type accountOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "account_status" | "date_joined" | "email" | "id_" | "is_active" | "is_admin" | "is_staff" | "is_superuser" | "last_home_visit" | "last_login" | "last_logout" | "password" | "username", ExtArgs["result"]["account"]>

  export type $accountPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "account"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: string
      account_status: string
      date_joined: Date
      email: string
      id_: number
      is_active: boolean
      is_admin: boolean
      is_staff: boolean
      is_superuser: boolean
      /**
       * Could not determine type: the field only had null or empty values in the sample set.
       */
      last_home_visit: Prisma.JsonValue | null
      last_login: Date
      last_logout: Date
      password: string
      username: string
    }, ExtArgs["result"]["account"]>
    composites: {}
  }

  type accountGetPayload<S extends boolean | null | undefined | accountDefaultArgs> = $Result.GetResult<Prisma.$accountPayload, S>

  type accountCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<accountFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: AccountCountAggregateInputType | true
    }

  export interface accountDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['account'], meta: { name: 'account' } }
    /**
     * Find zero or one Account that matches the filter.
     * @param {accountFindUniqueArgs} args - Arguments to find a Account
     * @example
     * // Get one Account
     * const account = await prisma.account.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends accountFindUniqueArgs>(args: SelectSubset<T, accountFindUniqueArgs<ExtArgs>>): Prisma__accountClient<$Result.GetResult<Prisma.$accountPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Account that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {accountFindUniqueOrThrowArgs} args - Arguments to find a Account
     * @example
     * // Get one Account
     * const account = await prisma.account.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends accountFindUniqueOrThrowArgs>(args: SelectSubset<T, accountFindUniqueOrThrowArgs<ExtArgs>>): Prisma__accountClient<$Result.GetResult<Prisma.$accountPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Account that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {accountFindFirstArgs} args - Arguments to find a Account
     * @example
     * // Get one Account
     * const account = await prisma.account.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends accountFindFirstArgs>(args?: SelectSubset<T, accountFindFirstArgs<ExtArgs>>): Prisma__accountClient<$Result.GetResult<Prisma.$accountPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Account that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {accountFindFirstOrThrowArgs} args - Arguments to find a Account
     * @example
     * // Get one Account
     * const account = await prisma.account.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends accountFindFirstOrThrowArgs>(args?: SelectSubset<T, accountFindFirstOrThrowArgs<ExtArgs>>): Prisma__accountClient<$Result.GetResult<Prisma.$accountPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Accounts that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {accountFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Accounts
     * const accounts = await prisma.account.findMany()
     * 
     * // Get first 10 Accounts
     * const accounts = await prisma.account.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const accountWithIdOnly = await prisma.account.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends accountFindManyArgs>(args?: SelectSubset<T, accountFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$accountPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Account.
     * @param {accountCreateArgs} args - Arguments to create a Account.
     * @example
     * // Create one Account
     * const Account = await prisma.account.create({
     *   data: {
     *     // ... data to create a Account
     *   }
     * })
     * 
     */
    create<T extends accountCreateArgs>(args: SelectSubset<T, accountCreateArgs<ExtArgs>>): Prisma__accountClient<$Result.GetResult<Prisma.$accountPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Accounts.
     * @param {accountCreateManyArgs} args - Arguments to create many Accounts.
     * @example
     * // Create many Accounts
     * const account = await prisma.account.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends accountCreateManyArgs>(args?: SelectSubset<T, accountCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Account.
     * @param {accountDeleteArgs} args - Arguments to delete one Account.
     * @example
     * // Delete one Account
     * const Account = await prisma.account.delete({
     *   where: {
     *     // ... filter to delete one Account
     *   }
     * })
     * 
     */
    delete<T extends accountDeleteArgs>(args: SelectSubset<T, accountDeleteArgs<ExtArgs>>): Prisma__accountClient<$Result.GetResult<Prisma.$accountPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Account.
     * @param {accountUpdateArgs} args - Arguments to update one Account.
     * @example
     * // Update one Account
     * const account = await prisma.account.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends accountUpdateArgs>(args: SelectSubset<T, accountUpdateArgs<ExtArgs>>): Prisma__accountClient<$Result.GetResult<Prisma.$accountPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Accounts.
     * @param {accountDeleteManyArgs} args - Arguments to filter Accounts to delete.
     * @example
     * // Delete a few Accounts
     * const { count } = await prisma.account.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends accountDeleteManyArgs>(args?: SelectSubset<T, accountDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Accounts.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {accountUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Accounts
     * const account = await prisma.account.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends accountUpdateManyArgs>(args: SelectSubset<T, accountUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Account.
     * @param {accountUpsertArgs} args - Arguments to update or create a Account.
     * @example
     * // Update or create a Account
     * const account = await prisma.account.upsert({
     *   create: {
     *     // ... data to create a Account
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Account we want to update
     *   }
     * })
     */
    upsert<T extends accountUpsertArgs>(args: SelectSubset<T, accountUpsertArgs<ExtArgs>>): Prisma__accountClient<$Result.GetResult<Prisma.$accountPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Accounts that matches the filter.
     * @param {accountFindRawArgs} args - Select which filters you would like to apply.
     * @example
     * const account = await prisma.account.findRaw({
     *   filter: { age: { $gt: 25 } }
     * })
     */
    findRaw(args?: accountFindRawArgs): Prisma.PrismaPromise<JsonObject>

    /**
     * Perform aggregation operations on a Account.
     * @param {accountAggregateRawArgs} args - Select which aggregations you would like to apply.
     * @example
     * const account = await prisma.account.aggregateRaw({
     *   pipeline: [
     *     { $match: { status: "registered" } },
     *     { $group: { _id: "$country", total: { $sum: 1 } } }
     *   ]
     * })
     */
    aggregateRaw(args?: accountAggregateRawArgs): Prisma.PrismaPromise<JsonObject>


    /**
     * Count the number of Accounts.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {accountCountArgs} args - Arguments to filter Accounts to count.
     * @example
     * // Count the number of Accounts
     * const count = await prisma.account.count({
     *   where: {
     *     // ... the filter for the Accounts we want to count
     *   }
     * })
    **/
    count<T extends accountCountArgs>(
      args?: Subset<T, accountCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], AccountCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Account.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AccountAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends AccountAggregateArgs>(args: Subset<T, AccountAggregateArgs>): Prisma.PrismaPromise<GetAccountAggregateType<T>>

    /**
     * Group by Account.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {accountGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends accountGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: accountGroupByArgs['orderBy'] }
        : { orderBy?: accountGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, accountGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAccountGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the account model
   */
  readonly fields: accountFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for account.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__accountClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the account model
   */ 
  interface accountFieldRefs {
    readonly id: FieldRef<"account", 'String'>
    readonly account_status: FieldRef<"account", 'String'>
    readonly date_joined: FieldRef<"account", 'DateTime'>
    readonly email: FieldRef<"account", 'String'>
    readonly id_: FieldRef<"account", 'Int'>
    readonly is_active: FieldRef<"account", 'Boolean'>
    readonly is_admin: FieldRef<"account", 'Boolean'>
    readonly is_staff: FieldRef<"account", 'Boolean'>
    readonly is_superuser: FieldRef<"account", 'Boolean'>
    readonly last_home_visit: FieldRef<"account", 'Json'>
    readonly last_login: FieldRef<"account", 'DateTime'>
    readonly last_logout: FieldRef<"account", 'DateTime'>
    readonly password: FieldRef<"account", 'String'>
    readonly username: FieldRef<"account", 'String'>
  }
    

  // Custom InputTypes
  /**
   * account findUnique
   */
  export type accountFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the account
     */
    select?: accountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the account
     */
    omit?: accountOmit<ExtArgs> | null
    /**
     * Filter, which account to fetch.
     */
    where: accountWhereUniqueInput
  }

  /**
   * account findUniqueOrThrow
   */
  export type accountFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the account
     */
    select?: accountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the account
     */
    omit?: accountOmit<ExtArgs> | null
    /**
     * Filter, which account to fetch.
     */
    where: accountWhereUniqueInput
  }

  /**
   * account findFirst
   */
  export type accountFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the account
     */
    select?: accountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the account
     */
    omit?: accountOmit<ExtArgs> | null
    /**
     * Filter, which account to fetch.
     */
    where?: accountWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of accounts to fetch.
     */
    orderBy?: accountOrderByWithRelationInput | accountOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for accounts.
     */
    cursor?: accountWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` accounts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` accounts.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of accounts.
     */
    distinct?: AccountScalarFieldEnum | AccountScalarFieldEnum[]
  }

  /**
   * account findFirstOrThrow
   */
  export type accountFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the account
     */
    select?: accountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the account
     */
    omit?: accountOmit<ExtArgs> | null
    /**
     * Filter, which account to fetch.
     */
    where?: accountWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of accounts to fetch.
     */
    orderBy?: accountOrderByWithRelationInput | accountOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for accounts.
     */
    cursor?: accountWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` accounts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` accounts.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of accounts.
     */
    distinct?: AccountScalarFieldEnum | AccountScalarFieldEnum[]
  }

  /**
   * account findMany
   */
  export type accountFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the account
     */
    select?: accountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the account
     */
    omit?: accountOmit<ExtArgs> | null
    /**
     * Filter, which accounts to fetch.
     */
    where?: accountWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of accounts to fetch.
     */
    orderBy?: accountOrderByWithRelationInput | accountOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing accounts.
     */
    cursor?: accountWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` accounts from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` accounts.
     */
    skip?: number
    distinct?: AccountScalarFieldEnum | AccountScalarFieldEnum[]
  }

  /**
   * account create
   */
  export type accountCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the account
     */
    select?: accountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the account
     */
    omit?: accountOmit<ExtArgs> | null
    /**
     * The data needed to create a account.
     */
    data: XOR<accountCreateInput, accountUncheckedCreateInput>
  }

  /**
   * account createMany
   */
  export type accountCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many accounts.
     */
    data: accountCreateManyInput | accountCreateManyInput[]
  }

  /**
   * account update
   */
  export type accountUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the account
     */
    select?: accountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the account
     */
    omit?: accountOmit<ExtArgs> | null
    /**
     * The data needed to update a account.
     */
    data: XOR<accountUpdateInput, accountUncheckedUpdateInput>
    /**
     * Choose, which account to update.
     */
    where: accountWhereUniqueInput
  }

  /**
   * account updateMany
   */
  export type accountUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update accounts.
     */
    data: XOR<accountUpdateManyMutationInput, accountUncheckedUpdateManyInput>
    /**
     * Filter which accounts to update
     */
    where?: accountWhereInput
    /**
     * Limit how many accounts to update.
     */
    limit?: number
  }

  /**
   * account upsert
   */
  export type accountUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the account
     */
    select?: accountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the account
     */
    omit?: accountOmit<ExtArgs> | null
    /**
     * The filter to search for the account to update in case it exists.
     */
    where: accountWhereUniqueInput
    /**
     * In case the account found by the `where` argument doesn't exist, create a new account with this data.
     */
    create: XOR<accountCreateInput, accountUncheckedCreateInput>
    /**
     * In case the account was found with the provided `where` argument, update it with this data.
     */
    update: XOR<accountUpdateInput, accountUncheckedUpdateInput>
  }

  /**
   * account delete
   */
  export type accountDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the account
     */
    select?: accountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the account
     */
    omit?: accountOmit<ExtArgs> | null
    /**
     * Filter which account to delete.
     */
    where: accountWhereUniqueInput
  }

  /**
   * account deleteMany
   */
  export type accountDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which accounts to delete
     */
    where?: accountWhereInput
    /**
     * Limit how many accounts to delete.
     */
    limit?: number
  }

  /**
   * account findRaw
   */
  export type accountFindRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The query predicate filter. If unspecified, then all documents in the collection will match the predicate. ${@link https://docs.mongodb.com/manual/reference/operator/query MongoDB Docs}.
     */
    filter?: InputJsonValue
    /**
     * Additional options to pass to the `find` command ${@link https://docs.mongodb.com/manual/reference/command/find/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * account aggregateRaw
   */
  export type accountAggregateRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * An array of aggregation stages to process and transform the document stream via the aggregation pipeline. ${@link https://docs.mongodb.com/manual/reference/operator/aggregation-pipeline MongoDB Docs}.
     */
    pipeline?: InputJsonValue[]
    /**
     * Additional options to pass to the `aggregate` command ${@link https://docs.mongodb.com/manual/reference/command/aggregate/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * account without action
   */
  export type accountDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the account
     */
    select?: accountSelect<ExtArgs> | null
    /**
     * Omit specific fields from the account
     */
    omit?: accountOmit<ExtArgs> | null
  }


  /**
   * Model account_tracker
   */

  export type AggregateAccount_tracker = {
    _count: Account_trackerCountAggregateOutputType | null
    _avg: Account_trackerAvgAggregateOutputType | null
    _sum: Account_trackerSumAggregateOutputType | null
    _min: Account_trackerMinAggregateOutputType | null
    _max: Account_trackerMaxAggregateOutputType | null
  }

  export type Account_trackerAvgAggregateOutputType = {
    fb_user_id: number | null
    id_: number | null
  }

  export type Account_trackerSumAggregateOutputType = {
    fb_user_id: number | null
    id_: number | null
  }

  export type Account_trackerMinAggregateOutputType = {
    id: string | null
    client_agent: string | null
    client_ip: string | null
    created_date: Date | null
    fb_user_id: number | null
    id_: number | null
    mobile: boolean | null
    modified_date: Date | null
    status: string | null
  }

  export type Account_trackerMaxAggregateOutputType = {
    id: string | null
    client_agent: string | null
    client_ip: string | null
    created_date: Date | null
    fb_user_id: number | null
    id_: number | null
    mobile: boolean | null
    modified_date: Date | null
    status: string | null
  }

  export type Account_trackerCountAggregateOutputType = {
    id: number
    city: number
    client_agent: number
    client_ip: number
    country: number
    country_code: number
    created_date: number
    fb_user_id: number
    id_: number
    mobile: number
    modified_date: number
    other_info: number
    region: number
    status: number
    time_zone: number
    user_automation_time: number
    _all: number
  }


  export type Account_trackerAvgAggregateInputType = {
    fb_user_id?: true
    id_?: true
  }

  export type Account_trackerSumAggregateInputType = {
    fb_user_id?: true
    id_?: true
  }

  export type Account_trackerMinAggregateInputType = {
    id?: true
    client_agent?: true
    client_ip?: true
    created_date?: true
    fb_user_id?: true
    id_?: true
    mobile?: true
    modified_date?: true
    status?: true
  }

  export type Account_trackerMaxAggregateInputType = {
    id?: true
    client_agent?: true
    client_ip?: true
    created_date?: true
    fb_user_id?: true
    id_?: true
    mobile?: true
    modified_date?: true
    status?: true
  }

  export type Account_trackerCountAggregateInputType = {
    id?: true
    city?: true
    client_agent?: true
    client_ip?: true
    country?: true
    country_code?: true
    created_date?: true
    fb_user_id?: true
    id_?: true
    mobile?: true
    modified_date?: true
    other_info?: true
    region?: true
    status?: true
    time_zone?: true
    user_automation_time?: true
    _all?: true
  }

  export type Account_trackerAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which account_tracker to aggregate.
     */
    where?: account_trackerWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of account_trackers to fetch.
     */
    orderBy?: account_trackerOrderByWithRelationInput | account_trackerOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: account_trackerWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` account_trackers from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` account_trackers.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned account_trackers
    **/
    _count?: true | Account_trackerCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Account_trackerAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Account_trackerSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Account_trackerMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Account_trackerMaxAggregateInputType
  }

  export type GetAccount_trackerAggregateType<T extends Account_trackerAggregateArgs> = {
        [P in keyof T & keyof AggregateAccount_tracker]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAccount_tracker[P]>
      : GetScalarType<T[P], AggregateAccount_tracker[P]>
  }




  export type account_trackerGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: account_trackerWhereInput
    orderBy?: account_trackerOrderByWithAggregationInput | account_trackerOrderByWithAggregationInput[]
    by: Account_trackerScalarFieldEnum[] | Account_trackerScalarFieldEnum
    having?: account_trackerScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Account_trackerCountAggregateInputType | true
    _avg?: Account_trackerAvgAggregateInputType
    _sum?: Account_trackerSumAggregateInputType
    _min?: Account_trackerMinAggregateInputType
    _max?: Account_trackerMaxAggregateInputType
  }

  export type Account_trackerGroupByOutputType = {
    id: string
    city: JsonValue | null
    client_agent: string
    client_ip: string
    country: JsonValue | null
    country_code: JsonValue | null
    created_date: Date
    fb_user_id: number
    id_: number
    mobile: boolean
    modified_date: Date
    other_info: JsonValue
    region: JsonValue | null
    status: string
    time_zone: JsonValue | null
    user_automation_time: JsonValue | null
    _count: Account_trackerCountAggregateOutputType | null
    _avg: Account_trackerAvgAggregateOutputType | null
    _sum: Account_trackerSumAggregateOutputType | null
    _min: Account_trackerMinAggregateOutputType | null
    _max: Account_trackerMaxAggregateOutputType | null
  }

  type GetAccount_trackerGroupByPayload<T extends account_trackerGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Account_trackerGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Account_trackerGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Account_trackerGroupByOutputType[P]>
            : GetScalarType<T[P], Account_trackerGroupByOutputType[P]>
        }
      >
    >


  export type account_trackerSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    city?: boolean
    client_agent?: boolean
    client_ip?: boolean
    country?: boolean
    country_code?: boolean
    created_date?: boolean
    fb_user_id?: boolean
    id_?: boolean
    mobile?: boolean
    modified_date?: boolean
    other_info?: boolean
    region?: boolean
    status?: boolean
    time_zone?: boolean
    user_automation_time?: boolean
  }, ExtArgs["result"]["account_tracker"]>



  export type account_trackerSelectScalar = {
    id?: boolean
    city?: boolean
    client_agent?: boolean
    client_ip?: boolean
    country?: boolean
    country_code?: boolean
    created_date?: boolean
    fb_user_id?: boolean
    id_?: boolean
    mobile?: boolean
    modified_date?: boolean
    other_info?: boolean
    region?: boolean
    status?: boolean
    time_zone?: boolean
    user_automation_time?: boolean
  }

  export type account_trackerOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "city" | "client_agent" | "client_ip" | "country" | "country_code" | "created_date" | "fb_user_id" | "id_" | "mobile" | "modified_date" | "other_info" | "region" | "status" | "time_zone" | "user_automation_time", ExtArgs["result"]["account_tracker"]>

  export type $account_trackerPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "account_tracker"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: string
      /**
       * Could not determine type: the field only had null or empty values in the sample set.
       */
      city: Prisma.JsonValue | null
      client_agent: string
      client_ip: string
      /**
       * Could not determine type: the field only had null or empty values in the sample set.
       */
      country: Prisma.JsonValue | null
      /**
       * Could not determine type: the field only had null or empty values in the sample set.
       */
      country_code: Prisma.JsonValue | null
      created_date: Date
      fb_user_id: number
      id_: number
      mobile: boolean
      modified_date: Date
      /**
       * Nested objects had no data in the sample dataset to introspect a nested type.
       */
      other_info: Prisma.JsonValue
      /**
       * Could not determine type: the field only had null or empty values in the sample set.
       */
      region: Prisma.JsonValue | null
      status: string
      /**
       * Could not determine type: the field only had null or empty values in the sample set.
       */
      time_zone: Prisma.JsonValue | null
      /**
       * Could not determine type: the field only had null or empty values in the sample set.
       */
      user_automation_time: Prisma.JsonValue | null
    }, ExtArgs["result"]["account_tracker"]>
    composites: {}
  }

  type account_trackerGetPayload<S extends boolean | null | undefined | account_trackerDefaultArgs> = $Result.GetResult<Prisma.$account_trackerPayload, S>

  type account_trackerCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<account_trackerFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Account_trackerCountAggregateInputType | true
    }

  export interface account_trackerDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['account_tracker'], meta: { name: 'account_tracker' } }
    /**
     * Find zero or one Account_tracker that matches the filter.
     * @param {account_trackerFindUniqueArgs} args - Arguments to find a Account_tracker
     * @example
     * // Get one Account_tracker
     * const account_tracker = await prisma.account_tracker.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends account_trackerFindUniqueArgs>(args: SelectSubset<T, account_trackerFindUniqueArgs<ExtArgs>>): Prisma__account_trackerClient<$Result.GetResult<Prisma.$account_trackerPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Account_tracker that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {account_trackerFindUniqueOrThrowArgs} args - Arguments to find a Account_tracker
     * @example
     * // Get one Account_tracker
     * const account_tracker = await prisma.account_tracker.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends account_trackerFindUniqueOrThrowArgs>(args: SelectSubset<T, account_trackerFindUniqueOrThrowArgs<ExtArgs>>): Prisma__account_trackerClient<$Result.GetResult<Prisma.$account_trackerPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Account_tracker that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {account_trackerFindFirstArgs} args - Arguments to find a Account_tracker
     * @example
     * // Get one Account_tracker
     * const account_tracker = await prisma.account_tracker.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends account_trackerFindFirstArgs>(args?: SelectSubset<T, account_trackerFindFirstArgs<ExtArgs>>): Prisma__account_trackerClient<$Result.GetResult<Prisma.$account_trackerPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Account_tracker that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {account_trackerFindFirstOrThrowArgs} args - Arguments to find a Account_tracker
     * @example
     * // Get one Account_tracker
     * const account_tracker = await prisma.account_tracker.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends account_trackerFindFirstOrThrowArgs>(args?: SelectSubset<T, account_trackerFindFirstOrThrowArgs<ExtArgs>>): Prisma__account_trackerClient<$Result.GetResult<Prisma.$account_trackerPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Account_trackers that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {account_trackerFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Account_trackers
     * const account_trackers = await prisma.account_tracker.findMany()
     * 
     * // Get first 10 Account_trackers
     * const account_trackers = await prisma.account_tracker.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const account_trackerWithIdOnly = await prisma.account_tracker.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends account_trackerFindManyArgs>(args?: SelectSubset<T, account_trackerFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$account_trackerPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Account_tracker.
     * @param {account_trackerCreateArgs} args - Arguments to create a Account_tracker.
     * @example
     * // Create one Account_tracker
     * const Account_tracker = await prisma.account_tracker.create({
     *   data: {
     *     // ... data to create a Account_tracker
     *   }
     * })
     * 
     */
    create<T extends account_trackerCreateArgs>(args: SelectSubset<T, account_trackerCreateArgs<ExtArgs>>): Prisma__account_trackerClient<$Result.GetResult<Prisma.$account_trackerPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Account_trackers.
     * @param {account_trackerCreateManyArgs} args - Arguments to create many Account_trackers.
     * @example
     * // Create many Account_trackers
     * const account_tracker = await prisma.account_tracker.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends account_trackerCreateManyArgs>(args?: SelectSubset<T, account_trackerCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Account_tracker.
     * @param {account_trackerDeleteArgs} args - Arguments to delete one Account_tracker.
     * @example
     * // Delete one Account_tracker
     * const Account_tracker = await prisma.account_tracker.delete({
     *   where: {
     *     // ... filter to delete one Account_tracker
     *   }
     * })
     * 
     */
    delete<T extends account_trackerDeleteArgs>(args: SelectSubset<T, account_trackerDeleteArgs<ExtArgs>>): Prisma__account_trackerClient<$Result.GetResult<Prisma.$account_trackerPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Account_tracker.
     * @param {account_trackerUpdateArgs} args - Arguments to update one Account_tracker.
     * @example
     * // Update one Account_tracker
     * const account_tracker = await prisma.account_tracker.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends account_trackerUpdateArgs>(args: SelectSubset<T, account_trackerUpdateArgs<ExtArgs>>): Prisma__account_trackerClient<$Result.GetResult<Prisma.$account_trackerPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Account_trackers.
     * @param {account_trackerDeleteManyArgs} args - Arguments to filter Account_trackers to delete.
     * @example
     * // Delete a few Account_trackers
     * const { count } = await prisma.account_tracker.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends account_trackerDeleteManyArgs>(args?: SelectSubset<T, account_trackerDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Account_trackers.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {account_trackerUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Account_trackers
     * const account_tracker = await prisma.account_tracker.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends account_trackerUpdateManyArgs>(args: SelectSubset<T, account_trackerUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Account_tracker.
     * @param {account_trackerUpsertArgs} args - Arguments to update or create a Account_tracker.
     * @example
     * // Update or create a Account_tracker
     * const account_tracker = await prisma.account_tracker.upsert({
     *   create: {
     *     // ... data to create a Account_tracker
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Account_tracker we want to update
     *   }
     * })
     */
    upsert<T extends account_trackerUpsertArgs>(args: SelectSubset<T, account_trackerUpsertArgs<ExtArgs>>): Prisma__account_trackerClient<$Result.GetResult<Prisma.$account_trackerPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Account_trackers that matches the filter.
     * @param {account_trackerFindRawArgs} args - Select which filters you would like to apply.
     * @example
     * const account_tracker = await prisma.account_tracker.findRaw({
     *   filter: { age: { $gt: 25 } }
     * })
     */
    findRaw(args?: account_trackerFindRawArgs): Prisma.PrismaPromise<JsonObject>

    /**
     * Perform aggregation operations on a Account_tracker.
     * @param {account_trackerAggregateRawArgs} args - Select which aggregations you would like to apply.
     * @example
     * const account_tracker = await prisma.account_tracker.aggregateRaw({
     *   pipeline: [
     *     { $match: { status: "registered" } },
     *     { $group: { _id: "$country", total: { $sum: 1 } } }
     *   ]
     * })
     */
    aggregateRaw(args?: account_trackerAggregateRawArgs): Prisma.PrismaPromise<JsonObject>


    /**
     * Count the number of Account_trackers.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {account_trackerCountArgs} args - Arguments to filter Account_trackers to count.
     * @example
     * // Count the number of Account_trackers
     * const count = await prisma.account_tracker.count({
     *   where: {
     *     // ... the filter for the Account_trackers we want to count
     *   }
     * })
    **/
    count<T extends account_trackerCountArgs>(
      args?: Subset<T, account_trackerCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Account_trackerCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Account_tracker.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Account_trackerAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Account_trackerAggregateArgs>(args: Subset<T, Account_trackerAggregateArgs>): Prisma.PrismaPromise<GetAccount_trackerAggregateType<T>>

    /**
     * Group by Account_tracker.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {account_trackerGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends account_trackerGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: account_trackerGroupByArgs['orderBy'] }
        : { orderBy?: account_trackerGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, account_trackerGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAccount_trackerGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the account_tracker model
   */
  readonly fields: account_trackerFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for account_tracker.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__account_trackerClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the account_tracker model
   */ 
  interface account_trackerFieldRefs {
    readonly id: FieldRef<"account_tracker", 'String'>
    readonly city: FieldRef<"account_tracker", 'Json'>
    readonly client_agent: FieldRef<"account_tracker", 'String'>
    readonly client_ip: FieldRef<"account_tracker", 'String'>
    readonly country: FieldRef<"account_tracker", 'Json'>
    readonly country_code: FieldRef<"account_tracker", 'Json'>
    readonly created_date: FieldRef<"account_tracker", 'DateTime'>
    readonly fb_user_id: FieldRef<"account_tracker", 'Int'>
    readonly id_: FieldRef<"account_tracker", 'Int'>
    readonly mobile: FieldRef<"account_tracker", 'Boolean'>
    readonly modified_date: FieldRef<"account_tracker", 'DateTime'>
    readonly other_info: FieldRef<"account_tracker", 'Json'>
    readonly region: FieldRef<"account_tracker", 'Json'>
    readonly status: FieldRef<"account_tracker", 'String'>
    readonly time_zone: FieldRef<"account_tracker", 'Json'>
    readonly user_automation_time: FieldRef<"account_tracker", 'Json'>
  }
    

  // Custom InputTypes
  /**
   * account_tracker findUnique
   */
  export type account_trackerFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the account_tracker
     */
    select?: account_trackerSelect<ExtArgs> | null
    /**
     * Omit specific fields from the account_tracker
     */
    omit?: account_trackerOmit<ExtArgs> | null
    /**
     * Filter, which account_tracker to fetch.
     */
    where: account_trackerWhereUniqueInput
  }

  /**
   * account_tracker findUniqueOrThrow
   */
  export type account_trackerFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the account_tracker
     */
    select?: account_trackerSelect<ExtArgs> | null
    /**
     * Omit specific fields from the account_tracker
     */
    omit?: account_trackerOmit<ExtArgs> | null
    /**
     * Filter, which account_tracker to fetch.
     */
    where: account_trackerWhereUniqueInput
  }

  /**
   * account_tracker findFirst
   */
  export type account_trackerFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the account_tracker
     */
    select?: account_trackerSelect<ExtArgs> | null
    /**
     * Omit specific fields from the account_tracker
     */
    omit?: account_trackerOmit<ExtArgs> | null
    /**
     * Filter, which account_tracker to fetch.
     */
    where?: account_trackerWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of account_trackers to fetch.
     */
    orderBy?: account_trackerOrderByWithRelationInput | account_trackerOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for account_trackers.
     */
    cursor?: account_trackerWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` account_trackers from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` account_trackers.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of account_trackers.
     */
    distinct?: Account_trackerScalarFieldEnum | Account_trackerScalarFieldEnum[]
  }

  /**
   * account_tracker findFirstOrThrow
   */
  export type account_trackerFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the account_tracker
     */
    select?: account_trackerSelect<ExtArgs> | null
    /**
     * Omit specific fields from the account_tracker
     */
    omit?: account_trackerOmit<ExtArgs> | null
    /**
     * Filter, which account_tracker to fetch.
     */
    where?: account_trackerWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of account_trackers to fetch.
     */
    orderBy?: account_trackerOrderByWithRelationInput | account_trackerOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for account_trackers.
     */
    cursor?: account_trackerWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` account_trackers from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` account_trackers.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of account_trackers.
     */
    distinct?: Account_trackerScalarFieldEnum | Account_trackerScalarFieldEnum[]
  }

  /**
   * account_tracker findMany
   */
  export type account_trackerFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the account_tracker
     */
    select?: account_trackerSelect<ExtArgs> | null
    /**
     * Omit specific fields from the account_tracker
     */
    omit?: account_trackerOmit<ExtArgs> | null
    /**
     * Filter, which account_trackers to fetch.
     */
    where?: account_trackerWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of account_trackers to fetch.
     */
    orderBy?: account_trackerOrderByWithRelationInput | account_trackerOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing account_trackers.
     */
    cursor?: account_trackerWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` account_trackers from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` account_trackers.
     */
    skip?: number
    distinct?: Account_trackerScalarFieldEnum | Account_trackerScalarFieldEnum[]
  }

  /**
   * account_tracker create
   */
  export type account_trackerCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the account_tracker
     */
    select?: account_trackerSelect<ExtArgs> | null
    /**
     * Omit specific fields from the account_tracker
     */
    omit?: account_trackerOmit<ExtArgs> | null
    /**
     * The data needed to create a account_tracker.
     */
    data: XOR<account_trackerCreateInput, account_trackerUncheckedCreateInput>
  }

  /**
   * account_tracker createMany
   */
  export type account_trackerCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many account_trackers.
     */
    data: account_trackerCreateManyInput | account_trackerCreateManyInput[]
  }

  /**
   * account_tracker update
   */
  export type account_trackerUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the account_tracker
     */
    select?: account_trackerSelect<ExtArgs> | null
    /**
     * Omit specific fields from the account_tracker
     */
    omit?: account_trackerOmit<ExtArgs> | null
    /**
     * The data needed to update a account_tracker.
     */
    data: XOR<account_trackerUpdateInput, account_trackerUncheckedUpdateInput>
    /**
     * Choose, which account_tracker to update.
     */
    where: account_trackerWhereUniqueInput
  }

  /**
   * account_tracker updateMany
   */
  export type account_trackerUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update account_trackers.
     */
    data: XOR<account_trackerUpdateManyMutationInput, account_trackerUncheckedUpdateManyInput>
    /**
     * Filter which account_trackers to update
     */
    where?: account_trackerWhereInput
    /**
     * Limit how many account_trackers to update.
     */
    limit?: number
  }

  /**
   * account_tracker upsert
   */
  export type account_trackerUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the account_tracker
     */
    select?: account_trackerSelect<ExtArgs> | null
    /**
     * Omit specific fields from the account_tracker
     */
    omit?: account_trackerOmit<ExtArgs> | null
    /**
     * The filter to search for the account_tracker to update in case it exists.
     */
    where: account_trackerWhereUniqueInput
    /**
     * In case the account_tracker found by the `where` argument doesn't exist, create a new account_tracker with this data.
     */
    create: XOR<account_trackerCreateInput, account_trackerUncheckedCreateInput>
    /**
     * In case the account_tracker was found with the provided `where` argument, update it with this data.
     */
    update: XOR<account_trackerUpdateInput, account_trackerUncheckedUpdateInput>
  }

  /**
   * account_tracker delete
   */
  export type account_trackerDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the account_tracker
     */
    select?: account_trackerSelect<ExtArgs> | null
    /**
     * Omit specific fields from the account_tracker
     */
    omit?: account_trackerOmit<ExtArgs> | null
    /**
     * Filter which account_tracker to delete.
     */
    where: account_trackerWhereUniqueInput
  }

  /**
   * account_tracker deleteMany
   */
  export type account_trackerDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which account_trackers to delete
     */
    where?: account_trackerWhereInput
    /**
     * Limit how many account_trackers to delete.
     */
    limit?: number
  }

  /**
   * account_tracker findRaw
   */
  export type account_trackerFindRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The query predicate filter. If unspecified, then all documents in the collection will match the predicate. ${@link https://docs.mongodb.com/manual/reference/operator/query MongoDB Docs}.
     */
    filter?: InputJsonValue
    /**
     * Additional options to pass to the `find` command ${@link https://docs.mongodb.com/manual/reference/command/find/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * account_tracker aggregateRaw
   */
  export type account_trackerAggregateRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * An array of aggregation stages to process and transform the document stream via the aggregation pipeline. ${@link https://docs.mongodb.com/manual/reference/operator/aggregation-pipeline MongoDB Docs}.
     */
    pipeline?: InputJsonValue[]
    /**
     * Additional options to pass to the `aggregate` command ${@link https://docs.mongodb.com/manual/reference/command/aggregate/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * account_tracker without action
   */
  export type account_trackerDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the account_tracker
     */
    select?: account_trackerSelect<ExtArgs> | null
    /**
     * Omit specific fields from the account_tracker
     */
    omit?: account_trackerOmit<ExtArgs> | null
  }


  /**
   * Model accountusage
   */

  export type AggregateAccountusage = {
    _count: AccountusageCountAggregateOutputType | null
    _min: AccountusageMinAggregateOutputType | null
    _max: AccountusageMaxAggregateOutputType | null
  }

  export type AccountusageMinAggregateOutputType = {
    mongoId: string | null
  }

  export type AccountusageMaxAggregateOutputType = {
    mongoId: string | null
  }

  export type AccountusageCountAggregateOutputType = {
    mongoId: number
    fb_user_id: number
    id: number
    _all: number
  }


  export type AccountusageMinAggregateInputType = {
    mongoId?: true
  }

  export type AccountusageMaxAggregateInputType = {
    mongoId?: true
  }

  export type AccountusageCountAggregateInputType = {
    mongoId?: true
    fb_user_id?: true
    id?: true
    _all?: true
  }

  export type AccountusageAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which accountusage to aggregate.
     */
    where?: accountusageWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of accountusages to fetch.
     */
    orderBy?: accountusageOrderByWithRelationInput | accountusageOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: accountusageWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` accountusages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` accountusages.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned accountusages
    **/
    _count?: true | AccountusageCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: AccountusageMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: AccountusageMaxAggregateInputType
  }

  export type GetAccountusageAggregateType<T extends AccountusageAggregateArgs> = {
        [P in keyof T & keyof AggregateAccountusage]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAccountusage[P]>
      : GetScalarType<T[P], AggregateAccountusage[P]>
  }




  export type accountusageGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: accountusageWhereInput
    orderBy?: accountusageOrderByWithAggregationInput | accountusageOrderByWithAggregationInput[]
    by: AccountusageScalarFieldEnum[] | AccountusageScalarFieldEnum
    having?: accountusageScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: AccountusageCountAggregateInputType | true
    _min?: AccountusageMinAggregateInputType
    _max?: AccountusageMaxAggregateInputType
  }

  export type AccountusageGroupByOutputType = {
    mongoId: string
    fb_user_id: JsonValue | null
    id: JsonValue | null
    _count: AccountusageCountAggregateOutputType | null
    _min: AccountusageMinAggregateOutputType | null
    _max: AccountusageMaxAggregateOutputType | null
  }

  type GetAccountusageGroupByPayload<T extends accountusageGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<AccountusageGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof AccountusageGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], AccountusageGroupByOutputType[P]>
            : GetScalarType<T[P], AccountusageGroupByOutputType[P]>
        }
      >
    >


  export type accountusageSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    mongoId?: boolean
    fb_user_id?: boolean
    id?: boolean
  }, ExtArgs["result"]["accountusage"]>



  export type accountusageSelectScalar = {
    mongoId?: boolean
    fb_user_id?: boolean
    id?: boolean
  }

  export type accountusageOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"mongoId" | "fb_user_id" | "id", ExtArgs["result"]["accountusage"]>

  export type $accountusagePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "accountusage"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      mongoId: string
      /**
       * Field referred in an index, but found no data to define the type.
       */
      fb_user_id: Prisma.JsonValue | null
      /**
       * Field referred in an index, but found no data to define the type.
       */
      id: Prisma.JsonValue | null
    }, ExtArgs["result"]["accountusage"]>
    composites: {}
  }

  type accountusageGetPayload<S extends boolean | null | undefined | accountusageDefaultArgs> = $Result.GetResult<Prisma.$accountusagePayload, S>

  type accountusageCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<accountusageFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: AccountusageCountAggregateInputType | true
    }

  export interface accountusageDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['accountusage'], meta: { name: 'accountusage' } }
    /**
     * Find zero or one Accountusage that matches the filter.
     * @param {accountusageFindUniqueArgs} args - Arguments to find a Accountusage
     * @example
     * // Get one Accountusage
     * const accountusage = await prisma.accountusage.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends accountusageFindUniqueArgs>(args: SelectSubset<T, accountusageFindUniqueArgs<ExtArgs>>): Prisma__accountusageClient<$Result.GetResult<Prisma.$accountusagePayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Accountusage that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {accountusageFindUniqueOrThrowArgs} args - Arguments to find a Accountusage
     * @example
     * // Get one Accountusage
     * const accountusage = await prisma.accountusage.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends accountusageFindUniqueOrThrowArgs>(args: SelectSubset<T, accountusageFindUniqueOrThrowArgs<ExtArgs>>): Prisma__accountusageClient<$Result.GetResult<Prisma.$accountusagePayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Accountusage that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {accountusageFindFirstArgs} args - Arguments to find a Accountusage
     * @example
     * // Get one Accountusage
     * const accountusage = await prisma.accountusage.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends accountusageFindFirstArgs>(args?: SelectSubset<T, accountusageFindFirstArgs<ExtArgs>>): Prisma__accountusageClient<$Result.GetResult<Prisma.$accountusagePayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Accountusage that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {accountusageFindFirstOrThrowArgs} args - Arguments to find a Accountusage
     * @example
     * // Get one Accountusage
     * const accountusage = await prisma.accountusage.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends accountusageFindFirstOrThrowArgs>(args?: SelectSubset<T, accountusageFindFirstOrThrowArgs<ExtArgs>>): Prisma__accountusageClient<$Result.GetResult<Prisma.$accountusagePayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Accountusages that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {accountusageFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Accountusages
     * const accountusages = await prisma.accountusage.findMany()
     * 
     * // Get first 10 Accountusages
     * const accountusages = await prisma.accountusage.findMany({ take: 10 })
     * 
     * // Only select the `mongoId`
     * const accountusageWithMongoIdOnly = await prisma.accountusage.findMany({ select: { mongoId: true } })
     * 
     */
    findMany<T extends accountusageFindManyArgs>(args?: SelectSubset<T, accountusageFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$accountusagePayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Accountusage.
     * @param {accountusageCreateArgs} args - Arguments to create a Accountusage.
     * @example
     * // Create one Accountusage
     * const Accountusage = await prisma.accountusage.create({
     *   data: {
     *     // ... data to create a Accountusage
     *   }
     * })
     * 
     */
    create<T extends accountusageCreateArgs>(args: SelectSubset<T, accountusageCreateArgs<ExtArgs>>): Prisma__accountusageClient<$Result.GetResult<Prisma.$accountusagePayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Accountusages.
     * @param {accountusageCreateManyArgs} args - Arguments to create many Accountusages.
     * @example
     * // Create many Accountusages
     * const accountusage = await prisma.accountusage.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends accountusageCreateManyArgs>(args?: SelectSubset<T, accountusageCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Accountusage.
     * @param {accountusageDeleteArgs} args - Arguments to delete one Accountusage.
     * @example
     * // Delete one Accountusage
     * const Accountusage = await prisma.accountusage.delete({
     *   where: {
     *     // ... filter to delete one Accountusage
     *   }
     * })
     * 
     */
    delete<T extends accountusageDeleteArgs>(args: SelectSubset<T, accountusageDeleteArgs<ExtArgs>>): Prisma__accountusageClient<$Result.GetResult<Prisma.$accountusagePayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Accountusage.
     * @param {accountusageUpdateArgs} args - Arguments to update one Accountusage.
     * @example
     * // Update one Accountusage
     * const accountusage = await prisma.accountusage.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends accountusageUpdateArgs>(args: SelectSubset<T, accountusageUpdateArgs<ExtArgs>>): Prisma__accountusageClient<$Result.GetResult<Prisma.$accountusagePayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Accountusages.
     * @param {accountusageDeleteManyArgs} args - Arguments to filter Accountusages to delete.
     * @example
     * // Delete a few Accountusages
     * const { count } = await prisma.accountusage.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends accountusageDeleteManyArgs>(args?: SelectSubset<T, accountusageDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Accountusages.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {accountusageUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Accountusages
     * const accountusage = await prisma.accountusage.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends accountusageUpdateManyArgs>(args: SelectSubset<T, accountusageUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Accountusage.
     * @param {accountusageUpsertArgs} args - Arguments to update or create a Accountusage.
     * @example
     * // Update or create a Accountusage
     * const accountusage = await prisma.accountusage.upsert({
     *   create: {
     *     // ... data to create a Accountusage
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Accountusage we want to update
     *   }
     * })
     */
    upsert<T extends accountusageUpsertArgs>(args: SelectSubset<T, accountusageUpsertArgs<ExtArgs>>): Prisma__accountusageClient<$Result.GetResult<Prisma.$accountusagePayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Accountusages that matches the filter.
     * @param {accountusageFindRawArgs} args - Select which filters you would like to apply.
     * @example
     * const accountusage = await prisma.accountusage.findRaw({
     *   filter: { age: { $gt: 25 } }
     * })
     */
    findRaw(args?: accountusageFindRawArgs): Prisma.PrismaPromise<JsonObject>

    /**
     * Perform aggregation operations on a Accountusage.
     * @param {accountusageAggregateRawArgs} args - Select which aggregations you would like to apply.
     * @example
     * const accountusage = await prisma.accountusage.aggregateRaw({
     *   pipeline: [
     *     { $match: { status: "registered" } },
     *     { $group: { _id: "$country", total: { $sum: 1 } } }
     *   ]
     * })
     */
    aggregateRaw(args?: accountusageAggregateRawArgs): Prisma.PrismaPromise<JsonObject>


    /**
     * Count the number of Accountusages.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {accountusageCountArgs} args - Arguments to filter Accountusages to count.
     * @example
     * // Count the number of Accountusages
     * const count = await prisma.accountusage.count({
     *   where: {
     *     // ... the filter for the Accountusages we want to count
     *   }
     * })
    **/
    count<T extends accountusageCountArgs>(
      args?: Subset<T, accountusageCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], AccountusageCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Accountusage.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AccountusageAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends AccountusageAggregateArgs>(args: Subset<T, AccountusageAggregateArgs>): Prisma.PrismaPromise<GetAccountusageAggregateType<T>>

    /**
     * Group by Accountusage.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {accountusageGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends accountusageGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: accountusageGroupByArgs['orderBy'] }
        : { orderBy?: accountusageGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, accountusageGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAccountusageGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the accountusage model
   */
  readonly fields: accountusageFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for accountusage.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__accountusageClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the accountusage model
   */ 
  interface accountusageFieldRefs {
    readonly mongoId: FieldRef<"accountusage", 'String'>
    readonly fb_user_id: FieldRef<"accountusage", 'Json'>
    readonly id: FieldRef<"accountusage", 'Json'>
  }
    

  // Custom InputTypes
  /**
   * accountusage findUnique
   */
  export type accountusageFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the accountusage
     */
    select?: accountusageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the accountusage
     */
    omit?: accountusageOmit<ExtArgs> | null
    /**
     * Filter, which accountusage to fetch.
     */
    where: accountusageWhereUniqueInput
  }

  /**
   * accountusage findUniqueOrThrow
   */
  export type accountusageFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the accountusage
     */
    select?: accountusageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the accountusage
     */
    omit?: accountusageOmit<ExtArgs> | null
    /**
     * Filter, which accountusage to fetch.
     */
    where: accountusageWhereUniqueInput
  }

  /**
   * accountusage findFirst
   */
  export type accountusageFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the accountusage
     */
    select?: accountusageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the accountusage
     */
    omit?: accountusageOmit<ExtArgs> | null
    /**
     * Filter, which accountusage to fetch.
     */
    where?: accountusageWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of accountusages to fetch.
     */
    orderBy?: accountusageOrderByWithRelationInput | accountusageOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for accountusages.
     */
    cursor?: accountusageWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` accountusages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` accountusages.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of accountusages.
     */
    distinct?: AccountusageScalarFieldEnum | AccountusageScalarFieldEnum[]
  }

  /**
   * accountusage findFirstOrThrow
   */
  export type accountusageFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the accountusage
     */
    select?: accountusageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the accountusage
     */
    omit?: accountusageOmit<ExtArgs> | null
    /**
     * Filter, which accountusage to fetch.
     */
    where?: accountusageWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of accountusages to fetch.
     */
    orderBy?: accountusageOrderByWithRelationInput | accountusageOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for accountusages.
     */
    cursor?: accountusageWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` accountusages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` accountusages.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of accountusages.
     */
    distinct?: AccountusageScalarFieldEnum | AccountusageScalarFieldEnum[]
  }

  /**
   * accountusage findMany
   */
  export type accountusageFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the accountusage
     */
    select?: accountusageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the accountusage
     */
    omit?: accountusageOmit<ExtArgs> | null
    /**
     * Filter, which accountusages to fetch.
     */
    where?: accountusageWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of accountusages to fetch.
     */
    orderBy?: accountusageOrderByWithRelationInput | accountusageOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing accountusages.
     */
    cursor?: accountusageWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` accountusages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` accountusages.
     */
    skip?: number
    distinct?: AccountusageScalarFieldEnum | AccountusageScalarFieldEnum[]
  }

  /**
   * accountusage create
   */
  export type accountusageCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the accountusage
     */
    select?: accountusageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the accountusage
     */
    omit?: accountusageOmit<ExtArgs> | null
    /**
     * The data needed to create a accountusage.
     */
    data?: XOR<accountusageCreateInput, accountusageUncheckedCreateInput>
  }

  /**
   * accountusage createMany
   */
  export type accountusageCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many accountusages.
     */
    data: accountusageCreateManyInput | accountusageCreateManyInput[]
  }

  /**
   * accountusage update
   */
  export type accountusageUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the accountusage
     */
    select?: accountusageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the accountusage
     */
    omit?: accountusageOmit<ExtArgs> | null
    /**
     * The data needed to update a accountusage.
     */
    data: XOR<accountusageUpdateInput, accountusageUncheckedUpdateInput>
    /**
     * Choose, which accountusage to update.
     */
    where: accountusageWhereUniqueInput
  }

  /**
   * accountusage updateMany
   */
  export type accountusageUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update accountusages.
     */
    data: XOR<accountusageUpdateManyMutationInput, accountusageUncheckedUpdateManyInput>
    /**
     * Filter which accountusages to update
     */
    where?: accountusageWhereInput
    /**
     * Limit how many accountusages to update.
     */
    limit?: number
  }

  /**
   * accountusage upsert
   */
  export type accountusageUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the accountusage
     */
    select?: accountusageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the accountusage
     */
    omit?: accountusageOmit<ExtArgs> | null
    /**
     * The filter to search for the accountusage to update in case it exists.
     */
    where: accountusageWhereUniqueInput
    /**
     * In case the accountusage found by the `where` argument doesn't exist, create a new accountusage with this data.
     */
    create: XOR<accountusageCreateInput, accountusageUncheckedCreateInput>
    /**
     * In case the accountusage was found with the provided `where` argument, update it with this data.
     */
    update: XOR<accountusageUpdateInput, accountusageUncheckedUpdateInput>
  }

  /**
   * accountusage delete
   */
  export type accountusageDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the accountusage
     */
    select?: accountusageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the accountusage
     */
    omit?: accountusageOmit<ExtArgs> | null
    /**
     * Filter which accountusage to delete.
     */
    where: accountusageWhereUniqueInput
  }

  /**
   * accountusage deleteMany
   */
  export type accountusageDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which accountusages to delete
     */
    where?: accountusageWhereInput
    /**
     * Limit how many accountusages to delete.
     */
    limit?: number
  }

  /**
   * accountusage findRaw
   */
  export type accountusageFindRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The query predicate filter. If unspecified, then all documents in the collection will match the predicate. ${@link https://docs.mongodb.com/manual/reference/operator/query MongoDB Docs}.
     */
    filter?: InputJsonValue
    /**
     * Additional options to pass to the `find` command ${@link https://docs.mongodb.com/manual/reference/command/find/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * accountusage aggregateRaw
   */
  export type accountusageAggregateRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * An array of aggregation stages to process and transform the document stream via the aggregation pipeline. ${@link https://docs.mongodb.com/manual/reference/operator/aggregation-pipeline MongoDB Docs}.
     */
    pipeline?: InputJsonValue[]
    /**
     * Additional options to pass to the `aggregate` command ${@link https://docs.mongodb.com/manual/reference/command/aggregate/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * accountusage without action
   */
  export type accountusageDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the accountusage
     */
    select?: accountusageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the accountusage
     */
    omit?: accountusageOmit<ExtArgs> | null
  }


  /**
   * Model auth_group
   */

  export type AggregateAuth_group = {
    _count: Auth_groupCountAggregateOutputType | null
    _min: Auth_groupMinAggregateOutputType | null
    _max: Auth_groupMaxAggregateOutputType | null
  }

  export type Auth_groupMinAggregateOutputType = {
    mongoId: string | null
  }

  export type Auth_groupMaxAggregateOutputType = {
    mongoId: string | null
  }

  export type Auth_groupCountAggregateOutputType = {
    mongoId: number
    id: number
    name: number
    _all: number
  }


  export type Auth_groupMinAggregateInputType = {
    mongoId?: true
  }

  export type Auth_groupMaxAggregateInputType = {
    mongoId?: true
  }

  export type Auth_groupCountAggregateInputType = {
    mongoId?: true
    id?: true
    name?: true
    _all?: true
  }

  export type Auth_groupAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which auth_group to aggregate.
     */
    where?: auth_groupWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of auth_groups to fetch.
     */
    orderBy?: auth_groupOrderByWithRelationInput | auth_groupOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: auth_groupWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` auth_groups from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` auth_groups.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned auth_groups
    **/
    _count?: true | Auth_groupCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Auth_groupMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Auth_groupMaxAggregateInputType
  }

  export type GetAuth_groupAggregateType<T extends Auth_groupAggregateArgs> = {
        [P in keyof T & keyof AggregateAuth_group]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAuth_group[P]>
      : GetScalarType<T[P], AggregateAuth_group[P]>
  }




  export type auth_groupGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: auth_groupWhereInput
    orderBy?: auth_groupOrderByWithAggregationInput | auth_groupOrderByWithAggregationInput[]
    by: Auth_groupScalarFieldEnum[] | Auth_groupScalarFieldEnum
    having?: auth_groupScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Auth_groupCountAggregateInputType | true
    _min?: Auth_groupMinAggregateInputType
    _max?: Auth_groupMaxAggregateInputType
  }

  export type Auth_groupGroupByOutputType = {
    mongoId: string
    id: JsonValue | null
    name: JsonValue | null
    _count: Auth_groupCountAggregateOutputType | null
    _min: Auth_groupMinAggregateOutputType | null
    _max: Auth_groupMaxAggregateOutputType | null
  }

  type GetAuth_groupGroupByPayload<T extends auth_groupGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Auth_groupGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Auth_groupGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Auth_groupGroupByOutputType[P]>
            : GetScalarType<T[P], Auth_groupGroupByOutputType[P]>
        }
      >
    >


  export type auth_groupSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    mongoId?: boolean
    id?: boolean
    name?: boolean
  }, ExtArgs["result"]["auth_group"]>



  export type auth_groupSelectScalar = {
    mongoId?: boolean
    id?: boolean
    name?: boolean
  }

  export type auth_groupOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"mongoId" | "id" | "name", ExtArgs["result"]["auth_group"]>

  export type $auth_groupPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "auth_group"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      mongoId: string
      /**
       * Field referred in an index, but found no data to define the type.
       */
      id: Prisma.JsonValue | null
      /**
       * Field referred in an index, but found no data to define the type.
       */
      name: Prisma.JsonValue | null
    }, ExtArgs["result"]["auth_group"]>
    composites: {}
  }

  type auth_groupGetPayload<S extends boolean | null | undefined | auth_groupDefaultArgs> = $Result.GetResult<Prisma.$auth_groupPayload, S>

  type auth_groupCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<auth_groupFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Auth_groupCountAggregateInputType | true
    }

  export interface auth_groupDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['auth_group'], meta: { name: 'auth_group' } }
    /**
     * Find zero or one Auth_group that matches the filter.
     * @param {auth_groupFindUniqueArgs} args - Arguments to find a Auth_group
     * @example
     * // Get one Auth_group
     * const auth_group = await prisma.auth_group.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends auth_groupFindUniqueArgs>(args: SelectSubset<T, auth_groupFindUniqueArgs<ExtArgs>>): Prisma__auth_groupClient<$Result.GetResult<Prisma.$auth_groupPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Auth_group that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {auth_groupFindUniqueOrThrowArgs} args - Arguments to find a Auth_group
     * @example
     * // Get one Auth_group
     * const auth_group = await prisma.auth_group.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends auth_groupFindUniqueOrThrowArgs>(args: SelectSubset<T, auth_groupFindUniqueOrThrowArgs<ExtArgs>>): Prisma__auth_groupClient<$Result.GetResult<Prisma.$auth_groupPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Auth_group that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {auth_groupFindFirstArgs} args - Arguments to find a Auth_group
     * @example
     * // Get one Auth_group
     * const auth_group = await prisma.auth_group.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends auth_groupFindFirstArgs>(args?: SelectSubset<T, auth_groupFindFirstArgs<ExtArgs>>): Prisma__auth_groupClient<$Result.GetResult<Prisma.$auth_groupPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Auth_group that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {auth_groupFindFirstOrThrowArgs} args - Arguments to find a Auth_group
     * @example
     * // Get one Auth_group
     * const auth_group = await prisma.auth_group.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends auth_groupFindFirstOrThrowArgs>(args?: SelectSubset<T, auth_groupFindFirstOrThrowArgs<ExtArgs>>): Prisma__auth_groupClient<$Result.GetResult<Prisma.$auth_groupPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Auth_groups that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {auth_groupFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Auth_groups
     * const auth_groups = await prisma.auth_group.findMany()
     * 
     * // Get first 10 Auth_groups
     * const auth_groups = await prisma.auth_group.findMany({ take: 10 })
     * 
     * // Only select the `mongoId`
     * const auth_groupWithMongoIdOnly = await prisma.auth_group.findMany({ select: { mongoId: true } })
     * 
     */
    findMany<T extends auth_groupFindManyArgs>(args?: SelectSubset<T, auth_groupFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$auth_groupPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Auth_group.
     * @param {auth_groupCreateArgs} args - Arguments to create a Auth_group.
     * @example
     * // Create one Auth_group
     * const Auth_group = await prisma.auth_group.create({
     *   data: {
     *     // ... data to create a Auth_group
     *   }
     * })
     * 
     */
    create<T extends auth_groupCreateArgs>(args: SelectSubset<T, auth_groupCreateArgs<ExtArgs>>): Prisma__auth_groupClient<$Result.GetResult<Prisma.$auth_groupPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Auth_groups.
     * @param {auth_groupCreateManyArgs} args - Arguments to create many Auth_groups.
     * @example
     * // Create many Auth_groups
     * const auth_group = await prisma.auth_group.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends auth_groupCreateManyArgs>(args?: SelectSubset<T, auth_groupCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Auth_group.
     * @param {auth_groupDeleteArgs} args - Arguments to delete one Auth_group.
     * @example
     * // Delete one Auth_group
     * const Auth_group = await prisma.auth_group.delete({
     *   where: {
     *     // ... filter to delete one Auth_group
     *   }
     * })
     * 
     */
    delete<T extends auth_groupDeleteArgs>(args: SelectSubset<T, auth_groupDeleteArgs<ExtArgs>>): Prisma__auth_groupClient<$Result.GetResult<Prisma.$auth_groupPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Auth_group.
     * @param {auth_groupUpdateArgs} args - Arguments to update one Auth_group.
     * @example
     * // Update one Auth_group
     * const auth_group = await prisma.auth_group.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends auth_groupUpdateArgs>(args: SelectSubset<T, auth_groupUpdateArgs<ExtArgs>>): Prisma__auth_groupClient<$Result.GetResult<Prisma.$auth_groupPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Auth_groups.
     * @param {auth_groupDeleteManyArgs} args - Arguments to filter Auth_groups to delete.
     * @example
     * // Delete a few Auth_groups
     * const { count } = await prisma.auth_group.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends auth_groupDeleteManyArgs>(args?: SelectSubset<T, auth_groupDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Auth_groups.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {auth_groupUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Auth_groups
     * const auth_group = await prisma.auth_group.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends auth_groupUpdateManyArgs>(args: SelectSubset<T, auth_groupUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Auth_group.
     * @param {auth_groupUpsertArgs} args - Arguments to update or create a Auth_group.
     * @example
     * // Update or create a Auth_group
     * const auth_group = await prisma.auth_group.upsert({
     *   create: {
     *     // ... data to create a Auth_group
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Auth_group we want to update
     *   }
     * })
     */
    upsert<T extends auth_groupUpsertArgs>(args: SelectSubset<T, auth_groupUpsertArgs<ExtArgs>>): Prisma__auth_groupClient<$Result.GetResult<Prisma.$auth_groupPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Auth_groups that matches the filter.
     * @param {auth_groupFindRawArgs} args - Select which filters you would like to apply.
     * @example
     * const auth_group = await prisma.auth_group.findRaw({
     *   filter: { age: { $gt: 25 } }
     * })
     */
    findRaw(args?: auth_groupFindRawArgs): Prisma.PrismaPromise<JsonObject>

    /**
     * Perform aggregation operations on a Auth_group.
     * @param {auth_groupAggregateRawArgs} args - Select which aggregations you would like to apply.
     * @example
     * const auth_group = await prisma.auth_group.aggregateRaw({
     *   pipeline: [
     *     { $match: { status: "registered" } },
     *     { $group: { _id: "$country", total: { $sum: 1 } } }
     *   ]
     * })
     */
    aggregateRaw(args?: auth_groupAggregateRawArgs): Prisma.PrismaPromise<JsonObject>


    /**
     * Count the number of Auth_groups.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {auth_groupCountArgs} args - Arguments to filter Auth_groups to count.
     * @example
     * // Count the number of Auth_groups
     * const count = await prisma.auth_group.count({
     *   where: {
     *     // ... the filter for the Auth_groups we want to count
     *   }
     * })
    **/
    count<T extends auth_groupCountArgs>(
      args?: Subset<T, auth_groupCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Auth_groupCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Auth_group.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Auth_groupAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Auth_groupAggregateArgs>(args: Subset<T, Auth_groupAggregateArgs>): Prisma.PrismaPromise<GetAuth_groupAggregateType<T>>

    /**
     * Group by Auth_group.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {auth_groupGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends auth_groupGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: auth_groupGroupByArgs['orderBy'] }
        : { orderBy?: auth_groupGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, auth_groupGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAuth_groupGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the auth_group model
   */
  readonly fields: auth_groupFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for auth_group.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__auth_groupClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the auth_group model
   */ 
  interface auth_groupFieldRefs {
    readonly mongoId: FieldRef<"auth_group", 'String'>
    readonly id: FieldRef<"auth_group", 'Json'>
    readonly name: FieldRef<"auth_group", 'Json'>
  }
    

  // Custom InputTypes
  /**
   * auth_group findUnique
   */
  export type auth_groupFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_group
     */
    select?: auth_groupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_group
     */
    omit?: auth_groupOmit<ExtArgs> | null
    /**
     * Filter, which auth_group to fetch.
     */
    where: auth_groupWhereUniqueInput
  }

  /**
   * auth_group findUniqueOrThrow
   */
  export type auth_groupFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_group
     */
    select?: auth_groupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_group
     */
    omit?: auth_groupOmit<ExtArgs> | null
    /**
     * Filter, which auth_group to fetch.
     */
    where: auth_groupWhereUniqueInput
  }

  /**
   * auth_group findFirst
   */
  export type auth_groupFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_group
     */
    select?: auth_groupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_group
     */
    omit?: auth_groupOmit<ExtArgs> | null
    /**
     * Filter, which auth_group to fetch.
     */
    where?: auth_groupWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of auth_groups to fetch.
     */
    orderBy?: auth_groupOrderByWithRelationInput | auth_groupOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for auth_groups.
     */
    cursor?: auth_groupWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` auth_groups from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` auth_groups.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of auth_groups.
     */
    distinct?: Auth_groupScalarFieldEnum | Auth_groupScalarFieldEnum[]
  }

  /**
   * auth_group findFirstOrThrow
   */
  export type auth_groupFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_group
     */
    select?: auth_groupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_group
     */
    omit?: auth_groupOmit<ExtArgs> | null
    /**
     * Filter, which auth_group to fetch.
     */
    where?: auth_groupWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of auth_groups to fetch.
     */
    orderBy?: auth_groupOrderByWithRelationInput | auth_groupOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for auth_groups.
     */
    cursor?: auth_groupWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` auth_groups from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` auth_groups.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of auth_groups.
     */
    distinct?: Auth_groupScalarFieldEnum | Auth_groupScalarFieldEnum[]
  }

  /**
   * auth_group findMany
   */
  export type auth_groupFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_group
     */
    select?: auth_groupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_group
     */
    omit?: auth_groupOmit<ExtArgs> | null
    /**
     * Filter, which auth_groups to fetch.
     */
    where?: auth_groupWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of auth_groups to fetch.
     */
    orderBy?: auth_groupOrderByWithRelationInput | auth_groupOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing auth_groups.
     */
    cursor?: auth_groupWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` auth_groups from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` auth_groups.
     */
    skip?: number
    distinct?: Auth_groupScalarFieldEnum | Auth_groupScalarFieldEnum[]
  }

  /**
   * auth_group create
   */
  export type auth_groupCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_group
     */
    select?: auth_groupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_group
     */
    omit?: auth_groupOmit<ExtArgs> | null
    /**
     * The data needed to create a auth_group.
     */
    data?: XOR<auth_groupCreateInput, auth_groupUncheckedCreateInput>
  }

  /**
   * auth_group createMany
   */
  export type auth_groupCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many auth_groups.
     */
    data: auth_groupCreateManyInput | auth_groupCreateManyInput[]
  }

  /**
   * auth_group update
   */
  export type auth_groupUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_group
     */
    select?: auth_groupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_group
     */
    omit?: auth_groupOmit<ExtArgs> | null
    /**
     * The data needed to update a auth_group.
     */
    data: XOR<auth_groupUpdateInput, auth_groupUncheckedUpdateInput>
    /**
     * Choose, which auth_group to update.
     */
    where: auth_groupWhereUniqueInput
  }

  /**
   * auth_group updateMany
   */
  export type auth_groupUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update auth_groups.
     */
    data: XOR<auth_groupUpdateManyMutationInput, auth_groupUncheckedUpdateManyInput>
    /**
     * Filter which auth_groups to update
     */
    where?: auth_groupWhereInput
    /**
     * Limit how many auth_groups to update.
     */
    limit?: number
  }

  /**
   * auth_group upsert
   */
  export type auth_groupUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_group
     */
    select?: auth_groupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_group
     */
    omit?: auth_groupOmit<ExtArgs> | null
    /**
     * The filter to search for the auth_group to update in case it exists.
     */
    where: auth_groupWhereUniqueInput
    /**
     * In case the auth_group found by the `where` argument doesn't exist, create a new auth_group with this data.
     */
    create: XOR<auth_groupCreateInput, auth_groupUncheckedCreateInput>
    /**
     * In case the auth_group was found with the provided `where` argument, update it with this data.
     */
    update: XOR<auth_groupUpdateInput, auth_groupUncheckedUpdateInput>
  }

  /**
   * auth_group delete
   */
  export type auth_groupDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_group
     */
    select?: auth_groupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_group
     */
    omit?: auth_groupOmit<ExtArgs> | null
    /**
     * Filter which auth_group to delete.
     */
    where: auth_groupWhereUniqueInput
  }

  /**
   * auth_group deleteMany
   */
  export type auth_groupDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which auth_groups to delete
     */
    where?: auth_groupWhereInput
    /**
     * Limit how many auth_groups to delete.
     */
    limit?: number
  }

  /**
   * auth_group findRaw
   */
  export type auth_groupFindRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The query predicate filter. If unspecified, then all documents in the collection will match the predicate. ${@link https://docs.mongodb.com/manual/reference/operator/query MongoDB Docs}.
     */
    filter?: InputJsonValue
    /**
     * Additional options to pass to the `find` command ${@link https://docs.mongodb.com/manual/reference/command/find/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * auth_group aggregateRaw
   */
  export type auth_groupAggregateRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * An array of aggregation stages to process and transform the document stream via the aggregation pipeline. ${@link https://docs.mongodb.com/manual/reference/operator/aggregation-pipeline MongoDB Docs}.
     */
    pipeline?: InputJsonValue[]
    /**
     * Additional options to pass to the `aggregate` command ${@link https://docs.mongodb.com/manual/reference/command/aggregate/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * auth_group without action
   */
  export type auth_groupDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_group
     */
    select?: auth_groupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_group
     */
    omit?: auth_groupOmit<ExtArgs> | null
  }


  /**
   * Model auth_group_permissions
   */

  export type AggregateAuth_group_permissions = {
    _count: Auth_group_permissionsCountAggregateOutputType | null
    _min: Auth_group_permissionsMinAggregateOutputType | null
    _max: Auth_group_permissionsMaxAggregateOutputType | null
  }

  export type Auth_group_permissionsMinAggregateOutputType = {
    mongoId: string | null
  }

  export type Auth_group_permissionsMaxAggregateOutputType = {
    mongoId: string | null
  }

  export type Auth_group_permissionsCountAggregateOutputType = {
    mongoId: number
    group_id: number
    id: number
    permission_id: number
    _all: number
  }


  export type Auth_group_permissionsMinAggregateInputType = {
    mongoId?: true
  }

  export type Auth_group_permissionsMaxAggregateInputType = {
    mongoId?: true
  }

  export type Auth_group_permissionsCountAggregateInputType = {
    mongoId?: true
    group_id?: true
    id?: true
    permission_id?: true
    _all?: true
  }

  export type Auth_group_permissionsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which auth_group_permissions to aggregate.
     */
    where?: auth_group_permissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of auth_group_permissions to fetch.
     */
    orderBy?: auth_group_permissionsOrderByWithRelationInput | auth_group_permissionsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: auth_group_permissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` auth_group_permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` auth_group_permissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned auth_group_permissions
    **/
    _count?: true | Auth_group_permissionsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Auth_group_permissionsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Auth_group_permissionsMaxAggregateInputType
  }

  export type GetAuth_group_permissionsAggregateType<T extends Auth_group_permissionsAggregateArgs> = {
        [P in keyof T & keyof AggregateAuth_group_permissions]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAuth_group_permissions[P]>
      : GetScalarType<T[P], AggregateAuth_group_permissions[P]>
  }




  export type auth_group_permissionsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: auth_group_permissionsWhereInput
    orderBy?: auth_group_permissionsOrderByWithAggregationInput | auth_group_permissionsOrderByWithAggregationInput[]
    by: Auth_group_permissionsScalarFieldEnum[] | Auth_group_permissionsScalarFieldEnum
    having?: auth_group_permissionsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Auth_group_permissionsCountAggregateInputType | true
    _min?: Auth_group_permissionsMinAggregateInputType
    _max?: Auth_group_permissionsMaxAggregateInputType
  }

  export type Auth_group_permissionsGroupByOutputType = {
    mongoId: string
    group_id: JsonValue | null
    id: JsonValue | null
    permission_id: JsonValue | null
    _count: Auth_group_permissionsCountAggregateOutputType | null
    _min: Auth_group_permissionsMinAggregateOutputType | null
    _max: Auth_group_permissionsMaxAggregateOutputType | null
  }

  type GetAuth_group_permissionsGroupByPayload<T extends auth_group_permissionsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Auth_group_permissionsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Auth_group_permissionsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Auth_group_permissionsGroupByOutputType[P]>
            : GetScalarType<T[P], Auth_group_permissionsGroupByOutputType[P]>
        }
      >
    >


  export type auth_group_permissionsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    mongoId?: boolean
    group_id?: boolean
    id?: boolean
    permission_id?: boolean
  }, ExtArgs["result"]["auth_group_permissions"]>



  export type auth_group_permissionsSelectScalar = {
    mongoId?: boolean
    group_id?: boolean
    id?: boolean
    permission_id?: boolean
  }

  export type auth_group_permissionsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"mongoId" | "group_id" | "id" | "permission_id", ExtArgs["result"]["auth_group_permissions"]>

  export type $auth_group_permissionsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "auth_group_permissions"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      mongoId: string
      /**
       * Field referred in an index, but found no data to define the type.
       */
      group_id: Prisma.JsonValue | null
      /**
       * Field referred in an index, but found no data to define the type.
       */
      id: Prisma.JsonValue | null
      /**
       * Field referred in an index, but found no data to define the type.
       */
      permission_id: Prisma.JsonValue | null
    }, ExtArgs["result"]["auth_group_permissions"]>
    composites: {}
  }

  type auth_group_permissionsGetPayload<S extends boolean | null | undefined | auth_group_permissionsDefaultArgs> = $Result.GetResult<Prisma.$auth_group_permissionsPayload, S>

  type auth_group_permissionsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<auth_group_permissionsFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Auth_group_permissionsCountAggregateInputType | true
    }

  export interface auth_group_permissionsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['auth_group_permissions'], meta: { name: 'auth_group_permissions' } }
    /**
     * Find zero or one Auth_group_permissions that matches the filter.
     * @param {auth_group_permissionsFindUniqueArgs} args - Arguments to find a Auth_group_permissions
     * @example
     * // Get one Auth_group_permissions
     * const auth_group_permissions = await prisma.auth_group_permissions.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends auth_group_permissionsFindUniqueArgs>(args: SelectSubset<T, auth_group_permissionsFindUniqueArgs<ExtArgs>>): Prisma__auth_group_permissionsClient<$Result.GetResult<Prisma.$auth_group_permissionsPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Auth_group_permissions that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {auth_group_permissionsFindUniqueOrThrowArgs} args - Arguments to find a Auth_group_permissions
     * @example
     * // Get one Auth_group_permissions
     * const auth_group_permissions = await prisma.auth_group_permissions.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends auth_group_permissionsFindUniqueOrThrowArgs>(args: SelectSubset<T, auth_group_permissionsFindUniqueOrThrowArgs<ExtArgs>>): Prisma__auth_group_permissionsClient<$Result.GetResult<Prisma.$auth_group_permissionsPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Auth_group_permissions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {auth_group_permissionsFindFirstArgs} args - Arguments to find a Auth_group_permissions
     * @example
     * // Get one Auth_group_permissions
     * const auth_group_permissions = await prisma.auth_group_permissions.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends auth_group_permissionsFindFirstArgs>(args?: SelectSubset<T, auth_group_permissionsFindFirstArgs<ExtArgs>>): Prisma__auth_group_permissionsClient<$Result.GetResult<Prisma.$auth_group_permissionsPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Auth_group_permissions that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {auth_group_permissionsFindFirstOrThrowArgs} args - Arguments to find a Auth_group_permissions
     * @example
     * // Get one Auth_group_permissions
     * const auth_group_permissions = await prisma.auth_group_permissions.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends auth_group_permissionsFindFirstOrThrowArgs>(args?: SelectSubset<T, auth_group_permissionsFindFirstOrThrowArgs<ExtArgs>>): Prisma__auth_group_permissionsClient<$Result.GetResult<Prisma.$auth_group_permissionsPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Auth_group_permissions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {auth_group_permissionsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Auth_group_permissions
     * const auth_group_permissions = await prisma.auth_group_permissions.findMany()
     * 
     * // Get first 10 Auth_group_permissions
     * const auth_group_permissions = await prisma.auth_group_permissions.findMany({ take: 10 })
     * 
     * // Only select the `mongoId`
     * const auth_group_permissionsWithMongoIdOnly = await prisma.auth_group_permissions.findMany({ select: { mongoId: true } })
     * 
     */
    findMany<T extends auth_group_permissionsFindManyArgs>(args?: SelectSubset<T, auth_group_permissionsFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$auth_group_permissionsPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Auth_group_permissions.
     * @param {auth_group_permissionsCreateArgs} args - Arguments to create a Auth_group_permissions.
     * @example
     * // Create one Auth_group_permissions
     * const Auth_group_permissions = await prisma.auth_group_permissions.create({
     *   data: {
     *     // ... data to create a Auth_group_permissions
     *   }
     * })
     * 
     */
    create<T extends auth_group_permissionsCreateArgs>(args: SelectSubset<T, auth_group_permissionsCreateArgs<ExtArgs>>): Prisma__auth_group_permissionsClient<$Result.GetResult<Prisma.$auth_group_permissionsPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Auth_group_permissions.
     * @param {auth_group_permissionsCreateManyArgs} args - Arguments to create many Auth_group_permissions.
     * @example
     * // Create many Auth_group_permissions
     * const auth_group_permissions = await prisma.auth_group_permissions.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends auth_group_permissionsCreateManyArgs>(args?: SelectSubset<T, auth_group_permissionsCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Auth_group_permissions.
     * @param {auth_group_permissionsDeleteArgs} args - Arguments to delete one Auth_group_permissions.
     * @example
     * // Delete one Auth_group_permissions
     * const Auth_group_permissions = await prisma.auth_group_permissions.delete({
     *   where: {
     *     // ... filter to delete one Auth_group_permissions
     *   }
     * })
     * 
     */
    delete<T extends auth_group_permissionsDeleteArgs>(args: SelectSubset<T, auth_group_permissionsDeleteArgs<ExtArgs>>): Prisma__auth_group_permissionsClient<$Result.GetResult<Prisma.$auth_group_permissionsPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Auth_group_permissions.
     * @param {auth_group_permissionsUpdateArgs} args - Arguments to update one Auth_group_permissions.
     * @example
     * // Update one Auth_group_permissions
     * const auth_group_permissions = await prisma.auth_group_permissions.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends auth_group_permissionsUpdateArgs>(args: SelectSubset<T, auth_group_permissionsUpdateArgs<ExtArgs>>): Prisma__auth_group_permissionsClient<$Result.GetResult<Prisma.$auth_group_permissionsPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Auth_group_permissions.
     * @param {auth_group_permissionsDeleteManyArgs} args - Arguments to filter Auth_group_permissions to delete.
     * @example
     * // Delete a few Auth_group_permissions
     * const { count } = await prisma.auth_group_permissions.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends auth_group_permissionsDeleteManyArgs>(args?: SelectSubset<T, auth_group_permissionsDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Auth_group_permissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {auth_group_permissionsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Auth_group_permissions
     * const auth_group_permissions = await prisma.auth_group_permissions.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends auth_group_permissionsUpdateManyArgs>(args: SelectSubset<T, auth_group_permissionsUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Auth_group_permissions.
     * @param {auth_group_permissionsUpsertArgs} args - Arguments to update or create a Auth_group_permissions.
     * @example
     * // Update or create a Auth_group_permissions
     * const auth_group_permissions = await prisma.auth_group_permissions.upsert({
     *   create: {
     *     // ... data to create a Auth_group_permissions
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Auth_group_permissions we want to update
     *   }
     * })
     */
    upsert<T extends auth_group_permissionsUpsertArgs>(args: SelectSubset<T, auth_group_permissionsUpsertArgs<ExtArgs>>): Prisma__auth_group_permissionsClient<$Result.GetResult<Prisma.$auth_group_permissionsPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Auth_group_permissions that matches the filter.
     * @param {auth_group_permissionsFindRawArgs} args - Select which filters you would like to apply.
     * @example
     * const auth_group_permissions = await prisma.auth_group_permissions.findRaw({
     *   filter: { age: { $gt: 25 } }
     * })
     */
    findRaw(args?: auth_group_permissionsFindRawArgs): Prisma.PrismaPromise<JsonObject>

    /**
     * Perform aggregation operations on a Auth_group_permissions.
     * @param {auth_group_permissionsAggregateRawArgs} args - Select which aggregations you would like to apply.
     * @example
     * const auth_group_permissions = await prisma.auth_group_permissions.aggregateRaw({
     *   pipeline: [
     *     { $match: { status: "registered" } },
     *     { $group: { _id: "$country", total: { $sum: 1 } } }
     *   ]
     * })
     */
    aggregateRaw(args?: auth_group_permissionsAggregateRawArgs): Prisma.PrismaPromise<JsonObject>


    /**
     * Count the number of Auth_group_permissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {auth_group_permissionsCountArgs} args - Arguments to filter Auth_group_permissions to count.
     * @example
     * // Count the number of Auth_group_permissions
     * const count = await prisma.auth_group_permissions.count({
     *   where: {
     *     // ... the filter for the Auth_group_permissions we want to count
     *   }
     * })
    **/
    count<T extends auth_group_permissionsCountArgs>(
      args?: Subset<T, auth_group_permissionsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Auth_group_permissionsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Auth_group_permissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Auth_group_permissionsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Auth_group_permissionsAggregateArgs>(args: Subset<T, Auth_group_permissionsAggregateArgs>): Prisma.PrismaPromise<GetAuth_group_permissionsAggregateType<T>>

    /**
     * Group by Auth_group_permissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {auth_group_permissionsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends auth_group_permissionsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: auth_group_permissionsGroupByArgs['orderBy'] }
        : { orderBy?: auth_group_permissionsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, auth_group_permissionsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAuth_group_permissionsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the auth_group_permissions model
   */
  readonly fields: auth_group_permissionsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for auth_group_permissions.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__auth_group_permissionsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the auth_group_permissions model
   */ 
  interface auth_group_permissionsFieldRefs {
    readonly mongoId: FieldRef<"auth_group_permissions", 'String'>
    readonly group_id: FieldRef<"auth_group_permissions", 'Json'>
    readonly id: FieldRef<"auth_group_permissions", 'Json'>
    readonly permission_id: FieldRef<"auth_group_permissions", 'Json'>
  }
    

  // Custom InputTypes
  /**
   * auth_group_permissions findUnique
   */
  export type auth_group_permissionsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_group_permissions
     */
    select?: auth_group_permissionsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_group_permissions
     */
    omit?: auth_group_permissionsOmit<ExtArgs> | null
    /**
     * Filter, which auth_group_permissions to fetch.
     */
    where: auth_group_permissionsWhereUniqueInput
  }

  /**
   * auth_group_permissions findUniqueOrThrow
   */
  export type auth_group_permissionsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_group_permissions
     */
    select?: auth_group_permissionsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_group_permissions
     */
    omit?: auth_group_permissionsOmit<ExtArgs> | null
    /**
     * Filter, which auth_group_permissions to fetch.
     */
    where: auth_group_permissionsWhereUniqueInput
  }

  /**
   * auth_group_permissions findFirst
   */
  export type auth_group_permissionsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_group_permissions
     */
    select?: auth_group_permissionsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_group_permissions
     */
    omit?: auth_group_permissionsOmit<ExtArgs> | null
    /**
     * Filter, which auth_group_permissions to fetch.
     */
    where?: auth_group_permissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of auth_group_permissions to fetch.
     */
    orderBy?: auth_group_permissionsOrderByWithRelationInput | auth_group_permissionsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for auth_group_permissions.
     */
    cursor?: auth_group_permissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` auth_group_permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` auth_group_permissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of auth_group_permissions.
     */
    distinct?: Auth_group_permissionsScalarFieldEnum | Auth_group_permissionsScalarFieldEnum[]
  }

  /**
   * auth_group_permissions findFirstOrThrow
   */
  export type auth_group_permissionsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_group_permissions
     */
    select?: auth_group_permissionsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_group_permissions
     */
    omit?: auth_group_permissionsOmit<ExtArgs> | null
    /**
     * Filter, which auth_group_permissions to fetch.
     */
    where?: auth_group_permissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of auth_group_permissions to fetch.
     */
    orderBy?: auth_group_permissionsOrderByWithRelationInput | auth_group_permissionsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for auth_group_permissions.
     */
    cursor?: auth_group_permissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` auth_group_permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` auth_group_permissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of auth_group_permissions.
     */
    distinct?: Auth_group_permissionsScalarFieldEnum | Auth_group_permissionsScalarFieldEnum[]
  }

  /**
   * auth_group_permissions findMany
   */
  export type auth_group_permissionsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_group_permissions
     */
    select?: auth_group_permissionsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_group_permissions
     */
    omit?: auth_group_permissionsOmit<ExtArgs> | null
    /**
     * Filter, which auth_group_permissions to fetch.
     */
    where?: auth_group_permissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of auth_group_permissions to fetch.
     */
    orderBy?: auth_group_permissionsOrderByWithRelationInput | auth_group_permissionsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing auth_group_permissions.
     */
    cursor?: auth_group_permissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` auth_group_permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` auth_group_permissions.
     */
    skip?: number
    distinct?: Auth_group_permissionsScalarFieldEnum | Auth_group_permissionsScalarFieldEnum[]
  }

  /**
   * auth_group_permissions create
   */
  export type auth_group_permissionsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_group_permissions
     */
    select?: auth_group_permissionsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_group_permissions
     */
    omit?: auth_group_permissionsOmit<ExtArgs> | null
    /**
     * The data needed to create a auth_group_permissions.
     */
    data?: XOR<auth_group_permissionsCreateInput, auth_group_permissionsUncheckedCreateInput>
  }

  /**
   * auth_group_permissions createMany
   */
  export type auth_group_permissionsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many auth_group_permissions.
     */
    data: auth_group_permissionsCreateManyInput | auth_group_permissionsCreateManyInput[]
  }

  /**
   * auth_group_permissions update
   */
  export type auth_group_permissionsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_group_permissions
     */
    select?: auth_group_permissionsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_group_permissions
     */
    omit?: auth_group_permissionsOmit<ExtArgs> | null
    /**
     * The data needed to update a auth_group_permissions.
     */
    data: XOR<auth_group_permissionsUpdateInput, auth_group_permissionsUncheckedUpdateInput>
    /**
     * Choose, which auth_group_permissions to update.
     */
    where: auth_group_permissionsWhereUniqueInput
  }

  /**
   * auth_group_permissions updateMany
   */
  export type auth_group_permissionsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update auth_group_permissions.
     */
    data: XOR<auth_group_permissionsUpdateManyMutationInput, auth_group_permissionsUncheckedUpdateManyInput>
    /**
     * Filter which auth_group_permissions to update
     */
    where?: auth_group_permissionsWhereInput
    /**
     * Limit how many auth_group_permissions to update.
     */
    limit?: number
  }

  /**
   * auth_group_permissions upsert
   */
  export type auth_group_permissionsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_group_permissions
     */
    select?: auth_group_permissionsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_group_permissions
     */
    omit?: auth_group_permissionsOmit<ExtArgs> | null
    /**
     * The filter to search for the auth_group_permissions to update in case it exists.
     */
    where: auth_group_permissionsWhereUniqueInput
    /**
     * In case the auth_group_permissions found by the `where` argument doesn't exist, create a new auth_group_permissions with this data.
     */
    create: XOR<auth_group_permissionsCreateInput, auth_group_permissionsUncheckedCreateInput>
    /**
     * In case the auth_group_permissions was found with the provided `where` argument, update it with this data.
     */
    update: XOR<auth_group_permissionsUpdateInput, auth_group_permissionsUncheckedUpdateInput>
  }

  /**
   * auth_group_permissions delete
   */
  export type auth_group_permissionsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_group_permissions
     */
    select?: auth_group_permissionsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_group_permissions
     */
    omit?: auth_group_permissionsOmit<ExtArgs> | null
    /**
     * Filter which auth_group_permissions to delete.
     */
    where: auth_group_permissionsWhereUniqueInput
  }

  /**
   * auth_group_permissions deleteMany
   */
  export type auth_group_permissionsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which auth_group_permissions to delete
     */
    where?: auth_group_permissionsWhereInput
    /**
     * Limit how many auth_group_permissions to delete.
     */
    limit?: number
  }

  /**
   * auth_group_permissions findRaw
   */
  export type auth_group_permissionsFindRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The query predicate filter. If unspecified, then all documents in the collection will match the predicate. ${@link https://docs.mongodb.com/manual/reference/operator/query MongoDB Docs}.
     */
    filter?: InputJsonValue
    /**
     * Additional options to pass to the `find` command ${@link https://docs.mongodb.com/manual/reference/command/find/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * auth_group_permissions aggregateRaw
   */
  export type auth_group_permissionsAggregateRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * An array of aggregation stages to process and transform the document stream via the aggregation pipeline. ${@link https://docs.mongodb.com/manual/reference/operator/aggregation-pipeline MongoDB Docs}.
     */
    pipeline?: InputJsonValue[]
    /**
     * Additional options to pass to the `aggregate` command ${@link https://docs.mongodb.com/manual/reference/command/aggregate/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * auth_group_permissions without action
   */
  export type auth_group_permissionsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_group_permissions
     */
    select?: auth_group_permissionsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_group_permissions
     */
    omit?: auth_group_permissionsOmit<ExtArgs> | null
  }


  /**
   * Model auth_permission
   */

  export type AggregateAuth_permission = {
    _count: Auth_permissionCountAggregateOutputType | null
    _avg: Auth_permissionAvgAggregateOutputType | null
    _sum: Auth_permissionSumAggregateOutputType | null
    _min: Auth_permissionMinAggregateOutputType | null
    _max: Auth_permissionMaxAggregateOutputType | null
  }

  export type Auth_permissionAvgAggregateOutputType = {
    content_type_id: number | null
    id_: number | null
  }

  export type Auth_permissionSumAggregateOutputType = {
    content_type_id: number | null
    id_: number | null
  }

  export type Auth_permissionMinAggregateOutputType = {
    id: string | null
    codename: string | null
    content_type_id: number | null
    id_: number | null
    name: string | null
  }

  export type Auth_permissionMaxAggregateOutputType = {
    id: string | null
    codename: string | null
    content_type_id: number | null
    id_: number | null
    name: string | null
  }

  export type Auth_permissionCountAggregateOutputType = {
    id: number
    codename: number
    content_type_id: number
    id_: number
    name: number
    _all: number
  }


  export type Auth_permissionAvgAggregateInputType = {
    content_type_id?: true
    id_?: true
  }

  export type Auth_permissionSumAggregateInputType = {
    content_type_id?: true
    id_?: true
  }

  export type Auth_permissionMinAggregateInputType = {
    id?: true
    codename?: true
    content_type_id?: true
    id_?: true
    name?: true
  }

  export type Auth_permissionMaxAggregateInputType = {
    id?: true
    codename?: true
    content_type_id?: true
    id_?: true
    name?: true
  }

  export type Auth_permissionCountAggregateInputType = {
    id?: true
    codename?: true
    content_type_id?: true
    id_?: true
    name?: true
    _all?: true
  }

  export type Auth_permissionAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which auth_permission to aggregate.
     */
    where?: auth_permissionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of auth_permissions to fetch.
     */
    orderBy?: auth_permissionOrderByWithRelationInput | auth_permissionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: auth_permissionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` auth_permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` auth_permissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned auth_permissions
    **/
    _count?: true | Auth_permissionCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Auth_permissionAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Auth_permissionSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Auth_permissionMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Auth_permissionMaxAggregateInputType
  }

  export type GetAuth_permissionAggregateType<T extends Auth_permissionAggregateArgs> = {
        [P in keyof T & keyof AggregateAuth_permission]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAuth_permission[P]>
      : GetScalarType<T[P], AggregateAuth_permission[P]>
  }




  export type auth_permissionGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: auth_permissionWhereInput
    orderBy?: auth_permissionOrderByWithAggregationInput | auth_permissionOrderByWithAggregationInput[]
    by: Auth_permissionScalarFieldEnum[] | Auth_permissionScalarFieldEnum
    having?: auth_permissionScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Auth_permissionCountAggregateInputType | true
    _avg?: Auth_permissionAvgAggregateInputType
    _sum?: Auth_permissionSumAggregateInputType
    _min?: Auth_permissionMinAggregateInputType
    _max?: Auth_permissionMaxAggregateInputType
  }

  export type Auth_permissionGroupByOutputType = {
    id: string
    codename: string
    content_type_id: number
    id_: number
    name: string
    _count: Auth_permissionCountAggregateOutputType | null
    _avg: Auth_permissionAvgAggregateOutputType | null
    _sum: Auth_permissionSumAggregateOutputType | null
    _min: Auth_permissionMinAggregateOutputType | null
    _max: Auth_permissionMaxAggregateOutputType | null
  }

  type GetAuth_permissionGroupByPayload<T extends auth_permissionGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Auth_permissionGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Auth_permissionGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Auth_permissionGroupByOutputType[P]>
            : GetScalarType<T[P], Auth_permissionGroupByOutputType[P]>
        }
      >
    >


  export type auth_permissionSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    codename?: boolean
    content_type_id?: boolean
    id_?: boolean
    name?: boolean
  }, ExtArgs["result"]["auth_permission"]>



  export type auth_permissionSelectScalar = {
    id?: boolean
    codename?: boolean
    content_type_id?: boolean
    id_?: boolean
    name?: boolean
  }

  export type auth_permissionOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "codename" | "content_type_id" | "id_" | "name", ExtArgs["result"]["auth_permission"]>

  export type $auth_permissionPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "auth_permission"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: string
      codename: string
      content_type_id: number
      id_: number
      name: string
    }, ExtArgs["result"]["auth_permission"]>
    composites: {}
  }

  type auth_permissionGetPayload<S extends boolean | null | undefined | auth_permissionDefaultArgs> = $Result.GetResult<Prisma.$auth_permissionPayload, S>

  type auth_permissionCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<auth_permissionFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Auth_permissionCountAggregateInputType | true
    }

  export interface auth_permissionDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['auth_permission'], meta: { name: 'auth_permission' } }
    /**
     * Find zero or one Auth_permission that matches the filter.
     * @param {auth_permissionFindUniqueArgs} args - Arguments to find a Auth_permission
     * @example
     * // Get one Auth_permission
     * const auth_permission = await prisma.auth_permission.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends auth_permissionFindUniqueArgs>(args: SelectSubset<T, auth_permissionFindUniqueArgs<ExtArgs>>): Prisma__auth_permissionClient<$Result.GetResult<Prisma.$auth_permissionPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Auth_permission that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {auth_permissionFindUniqueOrThrowArgs} args - Arguments to find a Auth_permission
     * @example
     * // Get one Auth_permission
     * const auth_permission = await prisma.auth_permission.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends auth_permissionFindUniqueOrThrowArgs>(args: SelectSubset<T, auth_permissionFindUniqueOrThrowArgs<ExtArgs>>): Prisma__auth_permissionClient<$Result.GetResult<Prisma.$auth_permissionPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Auth_permission that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {auth_permissionFindFirstArgs} args - Arguments to find a Auth_permission
     * @example
     * // Get one Auth_permission
     * const auth_permission = await prisma.auth_permission.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends auth_permissionFindFirstArgs>(args?: SelectSubset<T, auth_permissionFindFirstArgs<ExtArgs>>): Prisma__auth_permissionClient<$Result.GetResult<Prisma.$auth_permissionPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Auth_permission that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {auth_permissionFindFirstOrThrowArgs} args - Arguments to find a Auth_permission
     * @example
     * // Get one Auth_permission
     * const auth_permission = await prisma.auth_permission.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends auth_permissionFindFirstOrThrowArgs>(args?: SelectSubset<T, auth_permissionFindFirstOrThrowArgs<ExtArgs>>): Prisma__auth_permissionClient<$Result.GetResult<Prisma.$auth_permissionPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Auth_permissions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {auth_permissionFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Auth_permissions
     * const auth_permissions = await prisma.auth_permission.findMany()
     * 
     * // Get first 10 Auth_permissions
     * const auth_permissions = await prisma.auth_permission.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const auth_permissionWithIdOnly = await prisma.auth_permission.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends auth_permissionFindManyArgs>(args?: SelectSubset<T, auth_permissionFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$auth_permissionPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Auth_permission.
     * @param {auth_permissionCreateArgs} args - Arguments to create a Auth_permission.
     * @example
     * // Create one Auth_permission
     * const Auth_permission = await prisma.auth_permission.create({
     *   data: {
     *     // ... data to create a Auth_permission
     *   }
     * })
     * 
     */
    create<T extends auth_permissionCreateArgs>(args: SelectSubset<T, auth_permissionCreateArgs<ExtArgs>>): Prisma__auth_permissionClient<$Result.GetResult<Prisma.$auth_permissionPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Auth_permissions.
     * @param {auth_permissionCreateManyArgs} args - Arguments to create many Auth_permissions.
     * @example
     * // Create many Auth_permissions
     * const auth_permission = await prisma.auth_permission.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends auth_permissionCreateManyArgs>(args?: SelectSubset<T, auth_permissionCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Auth_permission.
     * @param {auth_permissionDeleteArgs} args - Arguments to delete one Auth_permission.
     * @example
     * // Delete one Auth_permission
     * const Auth_permission = await prisma.auth_permission.delete({
     *   where: {
     *     // ... filter to delete one Auth_permission
     *   }
     * })
     * 
     */
    delete<T extends auth_permissionDeleteArgs>(args: SelectSubset<T, auth_permissionDeleteArgs<ExtArgs>>): Prisma__auth_permissionClient<$Result.GetResult<Prisma.$auth_permissionPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Auth_permission.
     * @param {auth_permissionUpdateArgs} args - Arguments to update one Auth_permission.
     * @example
     * // Update one Auth_permission
     * const auth_permission = await prisma.auth_permission.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends auth_permissionUpdateArgs>(args: SelectSubset<T, auth_permissionUpdateArgs<ExtArgs>>): Prisma__auth_permissionClient<$Result.GetResult<Prisma.$auth_permissionPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Auth_permissions.
     * @param {auth_permissionDeleteManyArgs} args - Arguments to filter Auth_permissions to delete.
     * @example
     * // Delete a few Auth_permissions
     * const { count } = await prisma.auth_permission.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends auth_permissionDeleteManyArgs>(args?: SelectSubset<T, auth_permissionDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Auth_permissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {auth_permissionUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Auth_permissions
     * const auth_permission = await prisma.auth_permission.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends auth_permissionUpdateManyArgs>(args: SelectSubset<T, auth_permissionUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Auth_permission.
     * @param {auth_permissionUpsertArgs} args - Arguments to update or create a Auth_permission.
     * @example
     * // Update or create a Auth_permission
     * const auth_permission = await prisma.auth_permission.upsert({
     *   create: {
     *     // ... data to create a Auth_permission
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Auth_permission we want to update
     *   }
     * })
     */
    upsert<T extends auth_permissionUpsertArgs>(args: SelectSubset<T, auth_permissionUpsertArgs<ExtArgs>>): Prisma__auth_permissionClient<$Result.GetResult<Prisma.$auth_permissionPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Auth_permissions that matches the filter.
     * @param {auth_permissionFindRawArgs} args - Select which filters you would like to apply.
     * @example
     * const auth_permission = await prisma.auth_permission.findRaw({
     *   filter: { age: { $gt: 25 } }
     * })
     */
    findRaw(args?: auth_permissionFindRawArgs): Prisma.PrismaPromise<JsonObject>

    /**
     * Perform aggregation operations on a Auth_permission.
     * @param {auth_permissionAggregateRawArgs} args - Select which aggregations you would like to apply.
     * @example
     * const auth_permission = await prisma.auth_permission.aggregateRaw({
     *   pipeline: [
     *     { $match: { status: "registered" } },
     *     { $group: { _id: "$country", total: { $sum: 1 } } }
     *   ]
     * })
     */
    aggregateRaw(args?: auth_permissionAggregateRawArgs): Prisma.PrismaPromise<JsonObject>


    /**
     * Count the number of Auth_permissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {auth_permissionCountArgs} args - Arguments to filter Auth_permissions to count.
     * @example
     * // Count the number of Auth_permissions
     * const count = await prisma.auth_permission.count({
     *   where: {
     *     // ... the filter for the Auth_permissions we want to count
     *   }
     * })
    **/
    count<T extends auth_permissionCountArgs>(
      args?: Subset<T, auth_permissionCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Auth_permissionCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Auth_permission.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Auth_permissionAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Auth_permissionAggregateArgs>(args: Subset<T, Auth_permissionAggregateArgs>): Prisma.PrismaPromise<GetAuth_permissionAggregateType<T>>

    /**
     * Group by Auth_permission.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {auth_permissionGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends auth_permissionGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: auth_permissionGroupByArgs['orderBy'] }
        : { orderBy?: auth_permissionGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, auth_permissionGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAuth_permissionGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the auth_permission model
   */
  readonly fields: auth_permissionFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for auth_permission.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__auth_permissionClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the auth_permission model
   */ 
  interface auth_permissionFieldRefs {
    readonly id: FieldRef<"auth_permission", 'String'>
    readonly codename: FieldRef<"auth_permission", 'String'>
    readonly content_type_id: FieldRef<"auth_permission", 'Int'>
    readonly id_: FieldRef<"auth_permission", 'Int'>
    readonly name: FieldRef<"auth_permission", 'String'>
  }
    

  // Custom InputTypes
  /**
   * auth_permission findUnique
   */
  export type auth_permissionFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_permission
     */
    select?: auth_permissionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_permission
     */
    omit?: auth_permissionOmit<ExtArgs> | null
    /**
     * Filter, which auth_permission to fetch.
     */
    where: auth_permissionWhereUniqueInput
  }

  /**
   * auth_permission findUniqueOrThrow
   */
  export type auth_permissionFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_permission
     */
    select?: auth_permissionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_permission
     */
    omit?: auth_permissionOmit<ExtArgs> | null
    /**
     * Filter, which auth_permission to fetch.
     */
    where: auth_permissionWhereUniqueInput
  }

  /**
   * auth_permission findFirst
   */
  export type auth_permissionFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_permission
     */
    select?: auth_permissionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_permission
     */
    omit?: auth_permissionOmit<ExtArgs> | null
    /**
     * Filter, which auth_permission to fetch.
     */
    where?: auth_permissionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of auth_permissions to fetch.
     */
    orderBy?: auth_permissionOrderByWithRelationInput | auth_permissionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for auth_permissions.
     */
    cursor?: auth_permissionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` auth_permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` auth_permissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of auth_permissions.
     */
    distinct?: Auth_permissionScalarFieldEnum | Auth_permissionScalarFieldEnum[]
  }

  /**
   * auth_permission findFirstOrThrow
   */
  export type auth_permissionFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_permission
     */
    select?: auth_permissionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_permission
     */
    omit?: auth_permissionOmit<ExtArgs> | null
    /**
     * Filter, which auth_permission to fetch.
     */
    where?: auth_permissionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of auth_permissions to fetch.
     */
    orderBy?: auth_permissionOrderByWithRelationInput | auth_permissionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for auth_permissions.
     */
    cursor?: auth_permissionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` auth_permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` auth_permissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of auth_permissions.
     */
    distinct?: Auth_permissionScalarFieldEnum | Auth_permissionScalarFieldEnum[]
  }

  /**
   * auth_permission findMany
   */
  export type auth_permissionFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_permission
     */
    select?: auth_permissionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_permission
     */
    omit?: auth_permissionOmit<ExtArgs> | null
    /**
     * Filter, which auth_permissions to fetch.
     */
    where?: auth_permissionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of auth_permissions to fetch.
     */
    orderBy?: auth_permissionOrderByWithRelationInput | auth_permissionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing auth_permissions.
     */
    cursor?: auth_permissionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` auth_permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` auth_permissions.
     */
    skip?: number
    distinct?: Auth_permissionScalarFieldEnum | Auth_permissionScalarFieldEnum[]
  }

  /**
   * auth_permission create
   */
  export type auth_permissionCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_permission
     */
    select?: auth_permissionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_permission
     */
    omit?: auth_permissionOmit<ExtArgs> | null
    /**
     * The data needed to create a auth_permission.
     */
    data: XOR<auth_permissionCreateInput, auth_permissionUncheckedCreateInput>
  }

  /**
   * auth_permission createMany
   */
  export type auth_permissionCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many auth_permissions.
     */
    data: auth_permissionCreateManyInput | auth_permissionCreateManyInput[]
  }

  /**
   * auth_permission update
   */
  export type auth_permissionUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_permission
     */
    select?: auth_permissionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_permission
     */
    omit?: auth_permissionOmit<ExtArgs> | null
    /**
     * The data needed to update a auth_permission.
     */
    data: XOR<auth_permissionUpdateInput, auth_permissionUncheckedUpdateInput>
    /**
     * Choose, which auth_permission to update.
     */
    where: auth_permissionWhereUniqueInput
  }

  /**
   * auth_permission updateMany
   */
  export type auth_permissionUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update auth_permissions.
     */
    data: XOR<auth_permissionUpdateManyMutationInput, auth_permissionUncheckedUpdateManyInput>
    /**
     * Filter which auth_permissions to update
     */
    where?: auth_permissionWhereInput
    /**
     * Limit how many auth_permissions to update.
     */
    limit?: number
  }

  /**
   * auth_permission upsert
   */
  export type auth_permissionUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_permission
     */
    select?: auth_permissionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_permission
     */
    omit?: auth_permissionOmit<ExtArgs> | null
    /**
     * The filter to search for the auth_permission to update in case it exists.
     */
    where: auth_permissionWhereUniqueInput
    /**
     * In case the auth_permission found by the `where` argument doesn't exist, create a new auth_permission with this data.
     */
    create: XOR<auth_permissionCreateInput, auth_permissionUncheckedCreateInput>
    /**
     * In case the auth_permission was found with the provided `where` argument, update it with this data.
     */
    update: XOR<auth_permissionUpdateInput, auth_permissionUncheckedUpdateInput>
  }

  /**
   * auth_permission delete
   */
  export type auth_permissionDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_permission
     */
    select?: auth_permissionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_permission
     */
    omit?: auth_permissionOmit<ExtArgs> | null
    /**
     * Filter which auth_permission to delete.
     */
    where: auth_permissionWhereUniqueInput
  }

  /**
   * auth_permission deleteMany
   */
  export type auth_permissionDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which auth_permissions to delete
     */
    where?: auth_permissionWhereInput
    /**
     * Limit how many auth_permissions to delete.
     */
    limit?: number
  }

  /**
   * auth_permission findRaw
   */
  export type auth_permissionFindRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The query predicate filter. If unspecified, then all documents in the collection will match the predicate. ${@link https://docs.mongodb.com/manual/reference/operator/query MongoDB Docs}.
     */
    filter?: InputJsonValue
    /**
     * Additional options to pass to the `find` command ${@link https://docs.mongodb.com/manual/reference/command/find/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * auth_permission aggregateRaw
   */
  export type auth_permissionAggregateRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * An array of aggregation stages to process and transform the document stream via the aggregation pipeline. ${@link https://docs.mongodb.com/manual/reference/operator/aggregation-pipeline MongoDB Docs}.
     */
    pipeline?: InputJsonValue[]
    /**
     * Additional options to pass to the `aggregate` command ${@link https://docs.mongodb.com/manual/reference/command/aggregate/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * auth_permission without action
   */
  export type auth_permissionDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the auth_permission
     */
    select?: auth_permissionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the auth_permission
     */
    omit?: auth_permissionOmit<ExtArgs> | null
  }


  /**
   * Model authtoken_token
   */

  export type AggregateAuthtoken_token = {
    _count: Authtoken_tokenCountAggregateOutputType | null
    _avg: Authtoken_tokenAvgAggregateOutputType | null
    _sum: Authtoken_tokenSumAggregateOutputType | null
    _min: Authtoken_tokenMinAggregateOutputType | null
    _max: Authtoken_tokenMaxAggregateOutputType | null
  }

  export type Authtoken_tokenAvgAggregateOutputType = {
    user_id: number | null
  }

  export type Authtoken_tokenSumAggregateOutputType = {
    user_id: number | null
  }

  export type Authtoken_tokenMinAggregateOutputType = {
    id: string | null
    created: Date | null
    key: string | null
    user_id: number | null
  }

  export type Authtoken_tokenMaxAggregateOutputType = {
    id: string | null
    created: Date | null
    key: string | null
    user_id: number | null
  }

  export type Authtoken_tokenCountAggregateOutputType = {
    id: number
    created: number
    key: number
    user_id: number
    _all: number
  }


  export type Authtoken_tokenAvgAggregateInputType = {
    user_id?: true
  }

  export type Authtoken_tokenSumAggregateInputType = {
    user_id?: true
  }

  export type Authtoken_tokenMinAggregateInputType = {
    id?: true
    created?: true
    key?: true
    user_id?: true
  }

  export type Authtoken_tokenMaxAggregateInputType = {
    id?: true
    created?: true
    key?: true
    user_id?: true
  }

  export type Authtoken_tokenCountAggregateInputType = {
    id?: true
    created?: true
    key?: true
    user_id?: true
    _all?: true
  }

  export type Authtoken_tokenAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which authtoken_token to aggregate.
     */
    where?: authtoken_tokenWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of authtoken_tokens to fetch.
     */
    orderBy?: authtoken_tokenOrderByWithRelationInput | authtoken_tokenOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: authtoken_tokenWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` authtoken_tokens from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` authtoken_tokens.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned authtoken_tokens
    **/
    _count?: true | Authtoken_tokenCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Authtoken_tokenAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Authtoken_tokenSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Authtoken_tokenMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Authtoken_tokenMaxAggregateInputType
  }

  export type GetAuthtoken_tokenAggregateType<T extends Authtoken_tokenAggregateArgs> = {
        [P in keyof T & keyof AggregateAuthtoken_token]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAuthtoken_token[P]>
      : GetScalarType<T[P], AggregateAuthtoken_token[P]>
  }




  export type authtoken_tokenGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: authtoken_tokenWhereInput
    orderBy?: authtoken_tokenOrderByWithAggregationInput | authtoken_tokenOrderByWithAggregationInput[]
    by: Authtoken_tokenScalarFieldEnum[] | Authtoken_tokenScalarFieldEnum
    having?: authtoken_tokenScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Authtoken_tokenCountAggregateInputType | true
    _avg?: Authtoken_tokenAvgAggregateInputType
    _sum?: Authtoken_tokenSumAggregateInputType
    _min?: Authtoken_tokenMinAggregateInputType
    _max?: Authtoken_tokenMaxAggregateInputType
  }

  export type Authtoken_tokenGroupByOutputType = {
    id: string
    created: Date
    key: string
    user_id: number
    _count: Authtoken_tokenCountAggregateOutputType | null
    _avg: Authtoken_tokenAvgAggregateOutputType | null
    _sum: Authtoken_tokenSumAggregateOutputType | null
    _min: Authtoken_tokenMinAggregateOutputType | null
    _max: Authtoken_tokenMaxAggregateOutputType | null
  }

  type GetAuthtoken_tokenGroupByPayload<T extends authtoken_tokenGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Authtoken_tokenGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Authtoken_tokenGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Authtoken_tokenGroupByOutputType[P]>
            : GetScalarType<T[P], Authtoken_tokenGroupByOutputType[P]>
        }
      >
    >


  export type authtoken_tokenSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    created?: boolean
    key?: boolean
    user_id?: boolean
  }, ExtArgs["result"]["authtoken_token"]>



  export type authtoken_tokenSelectScalar = {
    id?: boolean
    created?: boolean
    key?: boolean
    user_id?: boolean
  }

  export type authtoken_tokenOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "created" | "key" | "user_id", ExtArgs["result"]["authtoken_token"]>

  export type $authtoken_tokenPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "authtoken_token"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: string
      created: Date
      key: string
      user_id: number
    }, ExtArgs["result"]["authtoken_token"]>
    composites: {}
  }

  type authtoken_tokenGetPayload<S extends boolean | null | undefined | authtoken_tokenDefaultArgs> = $Result.GetResult<Prisma.$authtoken_tokenPayload, S>

  type authtoken_tokenCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<authtoken_tokenFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Authtoken_tokenCountAggregateInputType | true
    }

  export interface authtoken_tokenDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['authtoken_token'], meta: { name: 'authtoken_token' } }
    /**
     * Find zero or one Authtoken_token that matches the filter.
     * @param {authtoken_tokenFindUniqueArgs} args - Arguments to find a Authtoken_token
     * @example
     * // Get one Authtoken_token
     * const authtoken_token = await prisma.authtoken_token.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends authtoken_tokenFindUniqueArgs>(args: SelectSubset<T, authtoken_tokenFindUniqueArgs<ExtArgs>>): Prisma__authtoken_tokenClient<$Result.GetResult<Prisma.$authtoken_tokenPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Authtoken_token that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {authtoken_tokenFindUniqueOrThrowArgs} args - Arguments to find a Authtoken_token
     * @example
     * // Get one Authtoken_token
     * const authtoken_token = await prisma.authtoken_token.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends authtoken_tokenFindUniqueOrThrowArgs>(args: SelectSubset<T, authtoken_tokenFindUniqueOrThrowArgs<ExtArgs>>): Prisma__authtoken_tokenClient<$Result.GetResult<Prisma.$authtoken_tokenPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Authtoken_token that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {authtoken_tokenFindFirstArgs} args - Arguments to find a Authtoken_token
     * @example
     * // Get one Authtoken_token
     * const authtoken_token = await prisma.authtoken_token.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends authtoken_tokenFindFirstArgs>(args?: SelectSubset<T, authtoken_tokenFindFirstArgs<ExtArgs>>): Prisma__authtoken_tokenClient<$Result.GetResult<Prisma.$authtoken_tokenPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Authtoken_token that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {authtoken_tokenFindFirstOrThrowArgs} args - Arguments to find a Authtoken_token
     * @example
     * // Get one Authtoken_token
     * const authtoken_token = await prisma.authtoken_token.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends authtoken_tokenFindFirstOrThrowArgs>(args?: SelectSubset<T, authtoken_tokenFindFirstOrThrowArgs<ExtArgs>>): Prisma__authtoken_tokenClient<$Result.GetResult<Prisma.$authtoken_tokenPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Authtoken_tokens that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {authtoken_tokenFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Authtoken_tokens
     * const authtoken_tokens = await prisma.authtoken_token.findMany()
     * 
     * // Get first 10 Authtoken_tokens
     * const authtoken_tokens = await prisma.authtoken_token.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const authtoken_tokenWithIdOnly = await prisma.authtoken_token.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends authtoken_tokenFindManyArgs>(args?: SelectSubset<T, authtoken_tokenFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$authtoken_tokenPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Authtoken_token.
     * @param {authtoken_tokenCreateArgs} args - Arguments to create a Authtoken_token.
     * @example
     * // Create one Authtoken_token
     * const Authtoken_token = await prisma.authtoken_token.create({
     *   data: {
     *     // ... data to create a Authtoken_token
     *   }
     * })
     * 
     */
    create<T extends authtoken_tokenCreateArgs>(args: SelectSubset<T, authtoken_tokenCreateArgs<ExtArgs>>): Prisma__authtoken_tokenClient<$Result.GetResult<Prisma.$authtoken_tokenPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Authtoken_tokens.
     * @param {authtoken_tokenCreateManyArgs} args - Arguments to create many Authtoken_tokens.
     * @example
     * // Create many Authtoken_tokens
     * const authtoken_token = await prisma.authtoken_token.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends authtoken_tokenCreateManyArgs>(args?: SelectSubset<T, authtoken_tokenCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Authtoken_token.
     * @param {authtoken_tokenDeleteArgs} args - Arguments to delete one Authtoken_token.
     * @example
     * // Delete one Authtoken_token
     * const Authtoken_token = await prisma.authtoken_token.delete({
     *   where: {
     *     // ... filter to delete one Authtoken_token
     *   }
     * })
     * 
     */
    delete<T extends authtoken_tokenDeleteArgs>(args: SelectSubset<T, authtoken_tokenDeleteArgs<ExtArgs>>): Prisma__authtoken_tokenClient<$Result.GetResult<Prisma.$authtoken_tokenPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Authtoken_token.
     * @param {authtoken_tokenUpdateArgs} args - Arguments to update one Authtoken_token.
     * @example
     * // Update one Authtoken_token
     * const authtoken_token = await prisma.authtoken_token.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends authtoken_tokenUpdateArgs>(args: SelectSubset<T, authtoken_tokenUpdateArgs<ExtArgs>>): Prisma__authtoken_tokenClient<$Result.GetResult<Prisma.$authtoken_tokenPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Authtoken_tokens.
     * @param {authtoken_tokenDeleteManyArgs} args - Arguments to filter Authtoken_tokens to delete.
     * @example
     * // Delete a few Authtoken_tokens
     * const { count } = await prisma.authtoken_token.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends authtoken_tokenDeleteManyArgs>(args?: SelectSubset<T, authtoken_tokenDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Authtoken_tokens.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {authtoken_tokenUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Authtoken_tokens
     * const authtoken_token = await prisma.authtoken_token.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends authtoken_tokenUpdateManyArgs>(args: SelectSubset<T, authtoken_tokenUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Authtoken_token.
     * @param {authtoken_tokenUpsertArgs} args - Arguments to update or create a Authtoken_token.
     * @example
     * // Update or create a Authtoken_token
     * const authtoken_token = await prisma.authtoken_token.upsert({
     *   create: {
     *     // ... data to create a Authtoken_token
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Authtoken_token we want to update
     *   }
     * })
     */
    upsert<T extends authtoken_tokenUpsertArgs>(args: SelectSubset<T, authtoken_tokenUpsertArgs<ExtArgs>>): Prisma__authtoken_tokenClient<$Result.GetResult<Prisma.$authtoken_tokenPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Authtoken_tokens that matches the filter.
     * @param {authtoken_tokenFindRawArgs} args - Select which filters you would like to apply.
     * @example
     * const authtoken_token = await prisma.authtoken_token.findRaw({
     *   filter: { age: { $gt: 25 } }
     * })
     */
    findRaw(args?: authtoken_tokenFindRawArgs): Prisma.PrismaPromise<JsonObject>

    /**
     * Perform aggregation operations on a Authtoken_token.
     * @param {authtoken_tokenAggregateRawArgs} args - Select which aggregations you would like to apply.
     * @example
     * const authtoken_token = await prisma.authtoken_token.aggregateRaw({
     *   pipeline: [
     *     { $match: { status: "registered" } },
     *     { $group: { _id: "$country", total: { $sum: 1 } } }
     *   ]
     * })
     */
    aggregateRaw(args?: authtoken_tokenAggregateRawArgs): Prisma.PrismaPromise<JsonObject>


    /**
     * Count the number of Authtoken_tokens.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {authtoken_tokenCountArgs} args - Arguments to filter Authtoken_tokens to count.
     * @example
     * // Count the number of Authtoken_tokens
     * const count = await prisma.authtoken_token.count({
     *   where: {
     *     // ... the filter for the Authtoken_tokens we want to count
     *   }
     * })
    **/
    count<T extends authtoken_tokenCountArgs>(
      args?: Subset<T, authtoken_tokenCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Authtoken_tokenCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Authtoken_token.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Authtoken_tokenAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Authtoken_tokenAggregateArgs>(args: Subset<T, Authtoken_tokenAggregateArgs>): Prisma.PrismaPromise<GetAuthtoken_tokenAggregateType<T>>

    /**
     * Group by Authtoken_token.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {authtoken_tokenGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends authtoken_tokenGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: authtoken_tokenGroupByArgs['orderBy'] }
        : { orderBy?: authtoken_tokenGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, authtoken_tokenGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAuthtoken_tokenGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the authtoken_token model
   */
  readonly fields: authtoken_tokenFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for authtoken_token.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__authtoken_tokenClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the authtoken_token model
   */ 
  interface authtoken_tokenFieldRefs {
    readonly id: FieldRef<"authtoken_token", 'String'>
    readonly created: FieldRef<"authtoken_token", 'DateTime'>
    readonly key: FieldRef<"authtoken_token", 'String'>
    readonly user_id: FieldRef<"authtoken_token", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * authtoken_token findUnique
   */
  export type authtoken_tokenFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the authtoken_token
     */
    select?: authtoken_tokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the authtoken_token
     */
    omit?: authtoken_tokenOmit<ExtArgs> | null
    /**
     * Filter, which authtoken_token to fetch.
     */
    where: authtoken_tokenWhereUniqueInput
  }

  /**
   * authtoken_token findUniqueOrThrow
   */
  export type authtoken_tokenFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the authtoken_token
     */
    select?: authtoken_tokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the authtoken_token
     */
    omit?: authtoken_tokenOmit<ExtArgs> | null
    /**
     * Filter, which authtoken_token to fetch.
     */
    where: authtoken_tokenWhereUniqueInput
  }

  /**
   * authtoken_token findFirst
   */
  export type authtoken_tokenFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the authtoken_token
     */
    select?: authtoken_tokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the authtoken_token
     */
    omit?: authtoken_tokenOmit<ExtArgs> | null
    /**
     * Filter, which authtoken_token to fetch.
     */
    where?: authtoken_tokenWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of authtoken_tokens to fetch.
     */
    orderBy?: authtoken_tokenOrderByWithRelationInput | authtoken_tokenOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for authtoken_tokens.
     */
    cursor?: authtoken_tokenWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` authtoken_tokens from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` authtoken_tokens.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of authtoken_tokens.
     */
    distinct?: Authtoken_tokenScalarFieldEnum | Authtoken_tokenScalarFieldEnum[]
  }

  /**
   * authtoken_token findFirstOrThrow
   */
  export type authtoken_tokenFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the authtoken_token
     */
    select?: authtoken_tokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the authtoken_token
     */
    omit?: authtoken_tokenOmit<ExtArgs> | null
    /**
     * Filter, which authtoken_token to fetch.
     */
    where?: authtoken_tokenWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of authtoken_tokens to fetch.
     */
    orderBy?: authtoken_tokenOrderByWithRelationInput | authtoken_tokenOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for authtoken_tokens.
     */
    cursor?: authtoken_tokenWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` authtoken_tokens from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` authtoken_tokens.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of authtoken_tokens.
     */
    distinct?: Authtoken_tokenScalarFieldEnum | Authtoken_tokenScalarFieldEnum[]
  }

  /**
   * authtoken_token findMany
   */
  export type authtoken_tokenFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the authtoken_token
     */
    select?: authtoken_tokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the authtoken_token
     */
    omit?: authtoken_tokenOmit<ExtArgs> | null
    /**
     * Filter, which authtoken_tokens to fetch.
     */
    where?: authtoken_tokenWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of authtoken_tokens to fetch.
     */
    orderBy?: authtoken_tokenOrderByWithRelationInput | authtoken_tokenOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing authtoken_tokens.
     */
    cursor?: authtoken_tokenWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` authtoken_tokens from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` authtoken_tokens.
     */
    skip?: number
    distinct?: Authtoken_tokenScalarFieldEnum | Authtoken_tokenScalarFieldEnum[]
  }

  /**
   * authtoken_token create
   */
  export type authtoken_tokenCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the authtoken_token
     */
    select?: authtoken_tokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the authtoken_token
     */
    omit?: authtoken_tokenOmit<ExtArgs> | null
    /**
     * The data needed to create a authtoken_token.
     */
    data: XOR<authtoken_tokenCreateInput, authtoken_tokenUncheckedCreateInput>
  }

  /**
   * authtoken_token createMany
   */
  export type authtoken_tokenCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many authtoken_tokens.
     */
    data: authtoken_tokenCreateManyInput | authtoken_tokenCreateManyInput[]
  }

  /**
   * authtoken_token update
   */
  export type authtoken_tokenUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the authtoken_token
     */
    select?: authtoken_tokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the authtoken_token
     */
    omit?: authtoken_tokenOmit<ExtArgs> | null
    /**
     * The data needed to update a authtoken_token.
     */
    data: XOR<authtoken_tokenUpdateInput, authtoken_tokenUncheckedUpdateInput>
    /**
     * Choose, which authtoken_token to update.
     */
    where: authtoken_tokenWhereUniqueInput
  }

  /**
   * authtoken_token updateMany
   */
  export type authtoken_tokenUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update authtoken_tokens.
     */
    data: XOR<authtoken_tokenUpdateManyMutationInput, authtoken_tokenUncheckedUpdateManyInput>
    /**
     * Filter which authtoken_tokens to update
     */
    where?: authtoken_tokenWhereInput
    /**
     * Limit how many authtoken_tokens to update.
     */
    limit?: number
  }

  /**
   * authtoken_token upsert
   */
  export type authtoken_tokenUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the authtoken_token
     */
    select?: authtoken_tokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the authtoken_token
     */
    omit?: authtoken_tokenOmit<ExtArgs> | null
    /**
     * The filter to search for the authtoken_token to update in case it exists.
     */
    where: authtoken_tokenWhereUniqueInput
    /**
     * In case the authtoken_token found by the `where` argument doesn't exist, create a new authtoken_token with this data.
     */
    create: XOR<authtoken_tokenCreateInput, authtoken_tokenUncheckedCreateInput>
    /**
     * In case the authtoken_token was found with the provided `where` argument, update it with this data.
     */
    update: XOR<authtoken_tokenUpdateInput, authtoken_tokenUncheckedUpdateInput>
  }

  /**
   * authtoken_token delete
   */
  export type authtoken_tokenDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the authtoken_token
     */
    select?: authtoken_tokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the authtoken_token
     */
    omit?: authtoken_tokenOmit<ExtArgs> | null
    /**
     * Filter which authtoken_token to delete.
     */
    where: authtoken_tokenWhereUniqueInput
  }

  /**
   * authtoken_token deleteMany
   */
  export type authtoken_tokenDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which authtoken_tokens to delete
     */
    where?: authtoken_tokenWhereInput
    /**
     * Limit how many authtoken_tokens to delete.
     */
    limit?: number
  }

  /**
   * authtoken_token findRaw
   */
  export type authtoken_tokenFindRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The query predicate filter. If unspecified, then all documents in the collection will match the predicate. ${@link https://docs.mongodb.com/manual/reference/operator/query MongoDB Docs}.
     */
    filter?: InputJsonValue
    /**
     * Additional options to pass to the `find` command ${@link https://docs.mongodb.com/manual/reference/command/find/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * authtoken_token aggregateRaw
   */
  export type authtoken_tokenAggregateRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * An array of aggregation stages to process and transform the document stream via the aggregation pipeline. ${@link https://docs.mongodb.com/manual/reference/operator/aggregation-pipeline MongoDB Docs}.
     */
    pipeline?: InputJsonValue[]
    /**
     * Additional options to pass to the `aggregate` command ${@link https://docs.mongodb.com/manual/reference/command/aggregate/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * authtoken_token without action
   */
  export type authtoken_tokenDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the authtoken_token
     */
    select?: authtoken_tokenSelect<ExtArgs> | null
    /**
     * Omit specific fields from the authtoken_token
     */
    omit?: authtoken_tokenOmit<ExtArgs> | null
  }


  /**
   * Model competitors
   */

  export type AggregateCompetitors = {
    _count: CompetitorsCountAggregateOutputType | null
    _avg: CompetitorsAvgAggregateOutputType | null
    _sum: CompetitorsSumAggregateOutputType | null
    _min: CompetitorsMinAggregateOutputType | null
    _max: CompetitorsMaxAggregateOutputType | null
  }

  export type CompetitorsAvgAggregateOutputType = {
    fk_group_id: number | null
    fk_user_id: number | null
    id_: number | null
  }

  export type CompetitorsSumAggregateOutputType = {
    fk_group_id: number | null
    fk_user_id: number | null
    id_: number | null
  }

  export type CompetitorsMinAggregateOutputType = {
    id: string | null
    created_date: Date | null
    fk_group_id: number | null
    fk_user_id: number | null
    id_: number | null
    modified_date: Date | null
    track_status: string | null
    url: string | null
  }

  export type CompetitorsMaxAggregateOutputType = {
    id: string | null
    created_date: Date | null
    fk_group_id: number | null
    fk_user_id: number | null
    id_: number | null
    modified_date: Date | null
    track_status: string | null
    url: string | null
  }

  export type CompetitorsCountAggregateOutputType = {
    id: number
    created_date: number
    fk_group_id: number
    fk_user_id: number
    id_: number
    modified_date: number
    track_status: number
    url: number
    _all: number
  }


  export type CompetitorsAvgAggregateInputType = {
    fk_group_id?: true
    fk_user_id?: true
    id_?: true
  }

  export type CompetitorsSumAggregateInputType = {
    fk_group_id?: true
    fk_user_id?: true
    id_?: true
  }

  export type CompetitorsMinAggregateInputType = {
    id?: true
    created_date?: true
    fk_group_id?: true
    fk_user_id?: true
    id_?: true
    modified_date?: true
    track_status?: true
    url?: true
  }

  export type CompetitorsMaxAggregateInputType = {
    id?: true
    created_date?: true
    fk_group_id?: true
    fk_user_id?: true
    id_?: true
    modified_date?: true
    track_status?: true
    url?: true
  }

  export type CompetitorsCountAggregateInputType = {
    id?: true
    created_date?: true
    fk_group_id?: true
    fk_user_id?: true
    id_?: true
    modified_date?: true
    track_status?: true
    url?: true
    _all?: true
  }

  export type CompetitorsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which competitors to aggregate.
     */
    where?: competitorsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of competitors to fetch.
     */
    orderBy?: competitorsOrderByWithRelationInput | competitorsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: competitorsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` competitors from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` competitors.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned competitors
    **/
    _count?: true | CompetitorsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: CompetitorsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: CompetitorsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: CompetitorsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: CompetitorsMaxAggregateInputType
  }

  export type GetCompetitorsAggregateType<T extends CompetitorsAggregateArgs> = {
        [P in keyof T & keyof AggregateCompetitors]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateCompetitors[P]>
      : GetScalarType<T[P], AggregateCompetitors[P]>
  }




  export type competitorsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: competitorsWhereInput
    orderBy?: competitorsOrderByWithAggregationInput | competitorsOrderByWithAggregationInput[]
    by: CompetitorsScalarFieldEnum[] | CompetitorsScalarFieldEnum
    having?: competitorsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: CompetitorsCountAggregateInputType | true
    _avg?: CompetitorsAvgAggregateInputType
    _sum?: CompetitorsSumAggregateInputType
    _min?: CompetitorsMinAggregateInputType
    _max?: CompetitorsMaxAggregateInputType
  }

  export type CompetitorsGroupByOutputType = {
    id: string
    created_date: Date
    fk_group_id: number
    fk_user_id: number
    id_: number
    modified_date: Date
    track_status: string
    url: string
    _count: CompetitorsCountAggregateOutputType | null
    _avg: CompetitorsAvgAggregateOutputType | null
    _sum: CompetitorsSumAggregateOutputType | null
    _min: CompetitorsMinAggregateOutputType | null
    _max: CompetitorsMaxAggregateOutputType | null
  }

  type GetCompetitorsGroupByPayload<T extends competitorsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<CompetitorsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof CompetitorsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], CompetitorsGroupByOutputType[P]>
            : GetScalarType<T[P], CompetitorsGroupByOutputType[P]>
        }
      >
    >


  export type competitorsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    created_date?: boolean
    fk_group_id?: boolean
    fk_user_id?: boolean
    id_?: boolean
    keywords?: boolean | CompetitorsKeywordsDefaultArgs<ExtArgs>
    modified_date?: boolean
    track_status?: boolean
    url?: boolean
  }, ExtArgs["result"]["competitors"]>



  export type competitorsSelectScalar = {
    id?: boolean
    created_date?: boolean
    fk_group_id?: boolean
    fk_user_id?: boolean
    id_?: boolean
    modified_date?: boolean
    track_status?: boolean
    url?: boolean
  }

  export type competitorsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "created_date" | "fk_group_id" | "fk_user_id" | "id_" | "keywords" | "modified_date" | "track_status" | "url", ExtArgs["result"]["competitors"]>
  export type competitorsInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {}

  export type $competitorsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "competitors"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: string
      created_date: Date
      fk_group_id: number
      fk_user_id: number
      id_: number
      modified_date: Date
      track_status: string
      url: string
    }, ExtArgs["result"]["competitors"]>
    composites: {
      keywords: Prisma.$CompetitorsKeywordsPayload[]
    }
  }

  type competitorsGetPayload<S extends boolean | null | undefined | competitorsDefaultArgs> = $Result.GetResult<Prisma.$competitorsPayload, S>

  type competitorsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<competitorsFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: CompetitorsCountAggregateInputType | true
    }

  export interface competitorsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['competitors'], meta: { name: 'competitors' } }
    /**
     * Find zero or one Competitors that matches the filter.
     * @param {competitorsFindUniqueArgs} args - Arguments to find a Competitors
     * @example
     * // Get one Competitors
     * const competitors = await prisma.competitors.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends competitorsFindUniqueArgs>(args: SelectSubset<T, competitorsFindUniqueArgs<ExtArgs>>): Prisma__competitorsClient<$Result.GetResult<Prisma.$competitorsPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Competitors that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {competitorsFindUniqueOrThrowArgs} args - Arguments to find a Competitors
     * @example
     * // Get one Competitors
     * const competitors = await prisma.competitors.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends competitorsFindUniqueOrThrowArgs>(args: SelectSubset<T, competitorsFindUniqueOrThrowArgs<ExtArgs>>): Prisma__competitorsClient<$Result.GetResult<Prisma.$competitorsPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Competitors that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {competitorsFindFirstArgs} args - Arguments to find a Competitors
     * @example
     * // Get one Competitors
     * const competitors = await prisma.competitors.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends competitorsFindFirstArgs>(args?: SelectSubset<T, competitorsFindFirstArgs<ExtArgs>>): Prisma__competitorsClient<$Result.GetResult<Prisma.$competitorsPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Competitors that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {competitorsFindFirstOrThrowArgs} args - Arguments to find a Competitors
     * @example
     * // Get one Competitors
     * const competitors = await prisma.competitors.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends competitorsFindFirstOrThrowArgs>(args?: SelectSubset<T, competitorsFindFirstOrThrowArgs<ExtArgs>>): Prisma__competitorsClient<$Result.GetResult<Prisma.$competitorsPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Competitors that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {competitorsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Competitors
     * const competitors = await prisma.competitors.findMany()
     * 
     * // Get first 10 Competitors
     * const competitors = await prisma.competitors.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const competitorsWithIdOnly = await prisma.competitors.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends competitorsFindManyArgs>(args?: SelectSubset<T, competitorsFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$competitorsPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Competitors.
     * @param {competitorsCreateArgs} args - Arguments to create a Competitors.
     * @example
     * // Create one Competitors
     * const Competitors = await prisma.competitors.create({
     *   data: {
     *     // ... data to create a Competitors
     *   }
     * })
     * 
     */
    create<T extends competitorsCreateArgs>(args: SelectSubset<T, competitorsCreateArgs<ExtArgs>>): Prisma__competitorsClient<$Result.GetResult<Prisma.$competitorsPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Competitors.
     * @param {competitorsCreateManyArgs} args - Arguments to create many Competitors.
     * @example
     * // Create many Competitors
     * const competitors = await prisma.competitors.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends competitorsCreateManyArgs>(args?: SelectSubset<T, competitorsCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Competitors.
     * @param {competitorsDeleteArgs} args - Arguments to delete one Competitors.
     * @example
     * // Delete one Competitors
     * const Competitors = await prisma.competitors.delete({
     *   where: {
     *     // ... filter to delete one Competitors
     *   }
     * })
     * 
     */
    delete<T extends competitorsDeleteArgs>(args: SelectSubset<T, competitorsDeleteArgs<ExtArgs>>): Prisma__competitorsClient<$Result.GetResult<Prisma.$competitorsPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Competitors.
     * @param {competitorsUpdateArgs} args - Arguments to update one Competitors.
     * @example
     * // Update one Competitors
     * const competitors = await prisma.competitors.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends competitorsUpdateArgs>(args: SelectSubset<T, competitorsUpdateArgs<ExtArgs>>): Prisma__competitorsClient<$Result.GetResult<Prisma.$competitorsPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Competitors.
     * @param {competitorsDeleteManyArgs} args - Arguments to filter Competitors to delete.
     * @example
     * // Delete a few Competitors
     * const { count } = await prisma.competitors.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends competitorsDeleteManyArgs>(args?: SelectSubset<T, competitorsDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Competitors.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {competitorsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Competitors
     * const competitors = await prisma.competitors.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends competitorsUpdateManyArgs>(args: SelectSubset<T, competitorsUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Competitors.
     * @param {competitorsUpsertArgs} args - Arguments to update or create a Competitors.
     * @example
     * // Update or create a Competitors
     * const competitors = await prisma.competitors.upsert({
     *   create: {
     *     // ... data to create a Competitors
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Competitors we want to update
     *   }
     * })
     */
    upsert<T extends competitorsUpsertArgs>(args: SelectSubset<T, competitorsUpsertArgs<ExtArgs>>): Prisma__competitorsClient<$Result.GetResult<Prisma.$competitorsPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Competitors that matches the filter.
     * @param {competitorsFindRawArgs} args - Select which filters you would like to apply.
     * @example
     * const competitors = await prisma.competitors.findRaw({
     *   filter: { age: { $gt: 25 } }
     * })
     */
    findRaw(args?: competitorsFindRawArgs): Prisma.PrismaPromise<JsonObject>

    /**
     * Perform aggregation operations on a Competitors.
     * @param {competitorsAggregateRawArgs} args - Select which aggregations you would like to apply.
     * @example
     * const competitors = await prisma.competitors.aggregateRaw({
     *   pipeline: [
     *     { $match: { status: "registered" } },
     *     { $group: { _id: "$country", total: { $sum: 1 } } }
     *   ]
     * })
     */
    aggregateRaw(args?: competitorsAggregateRawArgs): Prisma.PrismaPromise<JsonObject>


    /**
     * Count the number of Competitors.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {competitorsCountArgs} args - Arguments to filter Competitors to count.
     * @example
     * // Count the number of Competitors
     * const count = await prisma.competitors.count({
     *   where: {
     *     // ... the filter for the Competitors we want to count
     *   }
     * })
    **/
    count<T extends competitorsCountArgs>(
      args?: Subset<T, competitorsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], CompetitorsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Competitors.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CompetitorsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends CompetitorsAggregateArgs>(args: Subset<T, CompetitorsAggregateArgs>): Prisma.PrismaPromise<GetCompetitorsAggregateType<T>>

    /**
     * Group by Competitors.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {competitorsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends competitorsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: competitorsGroupByArgs['orderBy'] }
        : { orderBy?: competitorsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, competitorsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetCompetitorsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the competitors model
   */
  readonly fields: competitorsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for competitors.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__competitorsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the competitors model
   */ 
  interface competitorsFieldRefs {
    readonly id: FieldRef<"competitors", 'String'>
    readonly created_date: FieldRef<"competitors", 'DateTime'>
    readonly fk_group_id: FieldRef<"competitors", 'Int'>
    readonly fk_user_id: FieldRef<"competitors", 'Int'>
    readonly id_: FieldRef<"competitors", 'Int'>
    readonly modified_date: FieldRef<"competitors", 'DateTime'>
    readonly track_status: FieldRef<"competitors", 'String'>
    readonly url: FieldRef<"competitors", 'String'>
  }
    

  // Custom InputTypes
  /**
   * competitors findUnique
   */
  export type competitorsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the competitors
     */
    select?: competitorsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the competitors
     */
    omit?: competitorsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: competitorsInclude<ExtArgs> | null
    /**
     * Filter, which competitors to fetch.
     */
    where: competitorsWhereUniqueInput
  }

  /**
   * competitors findUniqueOrThrow
   */
  export type competitorsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the competitors
     */
    select?: competitorsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the competitors
     */
    omit?: competitorsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: competitorsInclude<ExtArgs> | null
    /**
     * Filter, which competitors to fetch.
     */
    where: competitorsWhereUniqueInput
  }

  /**
   * competitors findFirst
   */
  export type competitorsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the competitors
     */
    select?: competitorsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the competitors
     */
    omit?: competitorsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: competitorsInclude<ExtArgs> | null
    /**
     * Filter, which competitors to fetch.
     */
    where?: competitorsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of competitors to fetch.
     */
    orderBy?: competitorsOrderByWithRelationInput | competitorsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for competitors.
     */
    cursor?: competitorsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` competitors from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` competitors.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of competitors.
     */
    distinct?: CompetitorsScalarFieldEnum | CompetitorsScalarFieldEnum[]
  }

  /**
   * competitors findFirstOrThrow
   */
  export type competitorsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the competitors
     */
    select?: competitorsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the competitors
     */
    omit?: competitorsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: competitorsInclude<ExtArgs> | null
    /**
     * Filter, which competitors to fetch.
     */
    where?: competitorsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of competitors to fetch.
     */
    orderBy?: competitorsOrderByWithRelationInput | competitorsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for competitors.
     */
    cursor?: competitorsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` competitors from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` competitors.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of competitors.
     */
    distinct?: CompetitorsScalarFieldEnum | CompetitorsScalarFieldEnum[]
  }

  /**
   * competitors findMany
   */
  export type competitorsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the competitors
     */
    select?: competitorsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the competitors
     */
    omit?: competitorsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: competitorsInclude<ExtArgs> | null
    /**
     * Filter, which competitors to fetch.
     */
    where?: competitorsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of competitors to fetch.
     */
    orderBy?: competitorsOrderByWithRelationInput | competitorsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing competitors.
     */
    cursor?: competitorsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` competitors from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` competitors.
     */
    skip?: number
    distinct?: CompetitorsScalarFieldEnum | CompetitorsScalarFieldEnum[]
  }

  /**
   * competitors create
   */
  export type competitorsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the competitors
     */
    select?: competitorsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the competitors
     */
    omit?: competitorsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: competitorsInclude<ExtArgs> | null
    /**
     * The data needed to create a competitors.
     */
    data: XOR<competitorsCreateInput, competitorsUncheckedCreateInput>
  }

  /**
   * competitors createMany
   */
  export type competitorsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many competitors.
     */
    data: competitorsCreateManyInput | competitorsCreateManyInput[]
  }

  /**
   * competitors update
   */
  export type competitorsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the competitors
     */
    select?: competitorsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the competitors
     */
    omit?: competitorsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: competitorsInclude<ExtArgs> | null
    /**
     * The data needed to update a competitors.
     */
    data: XOR<competitorsUpdateInput, competitorsUncheckedUpdateInput>
    /**
     * Choose, which competitors to update.
     */
    where: competitorsWhereUniqueInput
  }

  /**
   * competitors updateMany
   */
  export type competitorsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update competitors.
     */
    data: XOR<competitorsUpdateManyMutationInput, competitorsUncheckedUpdateManyInput>
    /**
     * Filter which competitors to update
     */
    where?: competitorsWhereInput
    /**
     * Limit how many competitors to update.
     */
    limit?: number
  }

  /**
   * competitors upsert
   */
  export type competitorsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the competitors
     */
    select?: competitorsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the competitors
     */
    omit?: competitorsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: competitorsInclude<ExtArgs> | null
    /**
     * The filter to search for the competitors to update in case it exists.
     */
    where: competitorsWhereUniqueInput
    /**
     * In case the competitors found by the `where` argument doesn't exist, create a new competitors with this data.
     */
    create: XOR<competitorsCreateInput, competitorsUncheckedCreateInput>
    /**
     * In case the competitors was found with the provided `where` argument, update it with this data.
     */
    update: XOR<competitorsUpdateInput, competitorsUncheckedUpdateInput>
  }

  /**
   * competitors delete
   */
  export type competitorsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the competitors
     */
    select?: competitorsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the competitors
     */
    omit?: competitorsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: competitorsInclude<ExtArgs> | null
    /**
     * Filter which competitors to delete.
     */
    where: competitorsWhereUniqueInput
  }

  /**
   * competitors deleteMany
   */
  export type competitorsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which competitors to delete
     */
    where?: competitorsWhereInput
    /**
     * Limit how many competitors to delete.
     */
    limit?: number
  }

  /**
   * competitors findRaw
   */
  export type competitorsFindRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The query predicate filter. If unspecified, then all documents in the collection will match the predicate. ${@link https://docs.mongodb.com/manual/reference/operator/query MongoDB Docs}.
     */
    filter?: InputJsonValue
    /**
     * Additional options to pass to the `find` command ${@link https://docs.mongodb.com/manual/reference/command/find/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * competitors aggregateRaw
   */
  export type competitorsAggregateRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * An array of aggregation stages to process and transform the document stream via the aggregation pipeline. ${@link https://docs.mongodb.com/manual/reference/operator/aggregation-pipeline MongoDB Docs}.
     */
    pipeline?: InputJsonValue[]
    /**
     * Additional options to pass to the `aggregate` command ${@link https://docs.mongodb.com/manual/reference/command/aggregate/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * competitors without action
   */
  export type competitorsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the competitors
     */
    select?: competitorsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the competitors
     */
    omit?: competitorsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: competitorsInclude<ExtArgs> | null
  }


  /**
   * Model django_admin_log
   */

  export type AggregateDjango_admin_log = {
    _count: Django_admin_logCountAggregateOutputType | null
    _min: Django_admin_logMinAggregateOutputType | null
    _max: Django_admin_logMaxAggregateOutputType | null
  }

  export type Django_admin_logMinAggregateOutputType = {
    mongoId: string | null
  }

  export type Django_admin_logMaxAggregateOutputType = {
    mongoId: string | null
  }

  export type Django_admin_logCountAggregateOutputType = {
    mongoId: number
    content_type_id: number
    id: number
    user_id: number
    _all: number
  }


  export type Django_admin_logMinAggregateInputType = {
    mongoId?: true
  }

  export type Django_admin_logMaxAggregateInputType = {
    mongoId?: true
  }

  export type Django_admin_logCountAggregateInputType = {
    mongoId?: true
    content_type_id?: true
    id?: true
    user_id?: true
    _all?: true
  }

  export type Django_admin_logAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which django_admin_log to aggregate.
     */
    where?: django_admin_logWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of django_admin_logs to fetch.
     */
    orderBy?: django_admin_logOrderByWithRelationInput | django_admin_logOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: django_admin_logWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` django_admin_logs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` django_admin_logs.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned django_admin_logs
    **/
    _count?: true | Django_admin_logCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Django_admin_logMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Django_admin_logMaxAggregateInputType
  }

  export type GetDjango_admin_logAggregateType<T extends Django_admin_logAggregateArgs> = {
        [P in keyof T & keyof AggregateDjango_admin_log]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateDjango_admin_log[P]>
      : GetScalarType<T[P], AggregateDjango_admin_log[P]>
  }




  export type django_admin_logGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: django_admin_logWhereInput
    orderBy?: django_admin_logOrderByWithAggregationInput | django_admin_logOrderByWithAggregationInput[]
    by: Django_admin_logScalarFieldEnum[] | Django_admin_logScalarFieldEnum
    having?: django_admin_logScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Django_admin_logCountAggregateInputType | true
    _min?: Django_admin_logMinAggregateInputType
    _max?: Django_admin_logMaxAggregateInputType
  }

  export type Django_admin_logGroupByOutputType = {
    mongoId: string
    content_type_id: JsonValue | null
    id: JsonValue | null
    user_id: JsonValue | null
    _count: Django_admin_logCountAggregateOutputType | null
    _min: Django_admin_logMinAggregateOutputType | null
    _max: Django_admin_logMaxAggregateOutputType | null
  }

  type GetDjango_admin_logGroupByPayload<T extends django_admin_logGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Django_admin_logGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Django_admin_logGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Django_admin_logGroupByOutputType[P]>
            : GetScalarType<T[P], Django_admin_logGroupByOutputType[P]>
        }
      >
    >


  export type django_admin_logSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    mongoId?: boolean
    content_type_id?: boolean
    id?: boolean
    user_id?: boolean
  }, ExtArgs["result"]["django_admin_log"]>



  export type django_admin_logSelectScalar = {
    mongoId?: boolean
    content_type_id?: boolean
    id?: boolean
    user_id?: boolean
  }

  export type django_admin_logOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"mongoId" | "content_type_id" | "id" | "user_id", ExtArgs["result"]["django_admin_log"]>

  export type $django_admin_logPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "django_admin_log"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      mongoId: string
      /**
       * Field referred in an index, but found no data to define the type.
       */
      content_type_id: Prisma.JsonValue | null
      /**
       * Field referred in an index, but found no data to define the type.
       */
      id: Prisma.JsonValue | null
      /**
       * Field referred in an index, but found no data to define the type.
       */
      user_id: Prisma.JsonValue | null
    }, ExtArgs["result"]["django_admin_log"]>
    composites: {}
  }

  type django_admin_logGetPayload<S extends boolean | null | undefined | django_admin_logDefaultArgs> = $Result.GetResult<Prisma.$django_admin_logPayload, S>

  type django_admin_logCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<django_admin_logFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Django_admin_logCountAggregateInputType | true
    }

  export interface django_admin_logDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['django_admin_log'], meta: { name: 'django_admin_log' } }
    /**
     * Find zero or one Django_admin_log that matches the filter.
     * @param {django_admin_logFindUniqueArgs} args - Arguments to find a Django_admin_log
     * @example
     * // Get one Django_admin_log
     * const django_admin_log = await prisma.django_admin_log.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends django_admin_logFindUniqueArgs>(args: SelectSubset<T, django_admin_logFindUniqueArgs<ExtArgs>>): Prisma__django_admin_logClient<$Result.GetResult<Prisma.$django_admin_logPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Django_admin_log that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {django_admin_logFindUniqueOrThrowArgs} args - Arguments to find a Django_admin_log
     * @example
     * // Get one Django_admin_log
     * const django_admin_log = await prisma.django_admin_log.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends django_admin_logFindUniqueOrThrowArgs>(args: SelectSubset<T, django_admin_logFindUniqueOrThrowArgs<ExtArgs>>): Prisma__django_admin_logClient<$Result.GetResult<Prisma.$django_admin_logPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Django_admin_log that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_admin_logFindFirstArgs} args - Arguments to find a Django_admin_log
     * @example
     * // Get one Django_admin_log
     * const django_admin_log = await prisma.django_admin_log.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends django_admin_logFindFirstArgs>(args?: SelectSubset<T, django_admin_logFindFirstArgs<ExtArgs>>): Prisma__django_admin_logClient<$Result.GetResult<Prisma.$django_admin_logPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Django_admin_log that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_admin_logFindFirstOrThrowArgs} args - Arguments to find a Django_admin_log
     * @example
     * // Get one Django_admin_log
     * const django_admin_log = await prisma.django_admin_log.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends django_admin_logFindFirstOrThrowArgs>(args?: SelectSubset<T, django_admin_logFindFirstOrThrowArgs<ExtArgs>>): Prisma__django_admin_logClient<$Result.GetResult<Prisma.$django_admin_logPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Django_admin_logs that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_admin_logFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Django_admin_logs
     * const django_admin_logs = await prisma.django_admin_log.findMany()
     * 
     * // Get first 10 Django_admin_logs
     * const django_admin_logs = await prisma.django_admin_log.findMany({ take: 10 })
     * 
     * // Only select the `mongoId`
     * const django_admin_logWithMongoIdOnly = await prisma.django_admin_log.findMany({ select: { mongoId: true } })
     * 
     */
    findMany<T extends django_admin_logFindManyArgs>(args?: SelectSubset<T, django_admin_logFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$django_admin_logPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Django_admin_log.
     * @param {django_admin_logCreateArgs} args - Arguments to create a Django_admin_log.
     * @example
     * // Create one Django_admin_log
     * const Django_admin_log = await prisma.django_admin_log.create({
     *   data: {
     *     // ... data to create a Django_admin_log
     *   }
     * })
     * 
     */
    create<T extends django_admin_logCreateArgs>(args: SelectSubset<T, django_admin_logCreateArgs<ExtArgs>>): Prisma__django_admin_logClient<$Result.GetResult<Prisma.$django_admin_logPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Django_admin_logs.
     * @param {django_admin_logCreateManyArgs} args - Arguments to create many Django_admin_logs.
     * @example
     * // Create many Django_admin_logs
     * const django_admin_log = await prisma.django_admin_log.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends django_admin_logCreateManyArgs>(args?: SelectSubset<T, django_admin_logCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Django_admin_log.
     * @param {django_admin_logDeleteArgs} args - Arguments to delete one Django_admin_log.
     * @example
     * // Delete one Django_admin_log
     * const Django_admin_log = await prisma.django_admin_log.delete({
     *   where: {
     *     // ... filter to delete one Django_admin_log
     *   }
     * })
     * 
     */
    delete<T extends django_admin_logDeleteArgs>(args: SelectSubset<T, django_admin_logDeleteArgs<ExtArgs>>): Prisma__django_admin_logClient<$Result.GetResult<Prisma.$django_admin_logPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Django_admin_log.
     * @param {django_admin_logUpdateArgs} args - Arguments to update one Django_admin_log.
     * @example
     * // Update one Django_admin_log
     * const django_admin_log = await prisma.django_admin_log.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends django_admin_logUpdateArgs>(args: SelectSubset<T, django_admin_logUpdateArgs<ExtArgs>>): Prisma__django_admin_logClient<$Result.GetResult<Prisma.$django_admin_logPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Django_admin_logs.
     * @param {django_admin_logDeleteManyArgs} args - Arguments to filter Django_admin_logs to delete.
     * @example
     * // Delete a few Django_admin_logs
     * const { count } = await prisma.django_admin_log.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends django_admin_logDeleteManyArgs>(args?: SelectSubset<T, django_admin_logDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Django_admin_logs.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_admin_logUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Django_admin_logs
     * const django_admin_log = await prisma.django_admin_log.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends django_admin_logUpdateManyArgs>(args: SelectSubset<T, django_admin_logUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Django_admin_log.
     * @param {django_admin_logUpsertArgs} args - Arguments to update or create a Django_admin_log.
     * @example
     * // Update or create a Django_admin_log
     * const django_admin_log = await prisma.django_admin_log.upsert({
     *   create: {
     *     // ... data to create a Django_admin_log
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Django_admin_log we want to update
     *   }
     * })
     */
    upsert<T extends django_admin_logUpsertArgs>(args: SelectSubset<T, django_admin_logUpsertArgs<ExtArgs>>): Prisma__django_admin_logClient<$Result.GetResult<Prisma.$django_admin_logPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Django_admin_logs that matches the filter.
     * @param {django_admin_logFindRawArgs} args - Select which filters you would like to apply.
     * @example
     * const django_admin_log = await prisma.django_admin_log.findRaw({
     *   filter: { age: { $gt: 25 } }
     * })
     */
    findRaw(args?: django_admin_logFindRawArgs): Prisma.PrismaPromise<JsonObject>

    /**
     * Perform aggregation operations on a Django_admin_log.
     * @param {django_admin_logAggregateRawArgs} args - Select which aggregations you would like to apply.
     * @example
     * const django_admin_log = await prisma.django_admin_log.aggregateRaw({
     *   pipeline: [
     *     { $match: { status: "registered" } },
     *     { $group: { _id: "$country", total: { $sum: 1 } } }
     *   ]
     * })
     */
    aggregateRaw(args?: django_admin_logAggregateRawArgs): Prisma.PrismaPromise<JsonObject>


    /**
     * Count the number of Django_admin_logs.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_admin_logCountArgs} args - Arguments to filter Django_admin_logs to count.
     * @example
     * // Count the number of Django_admin_logs
     * const count = await prisma.django_admin_log.count({
     *   where: {
     *     // ... the filter for the Django_admin_logs we want to count
     *   }
     * })
    **/
    count<T extends django_admin_logCountArgs>(
      args?: Subset<T, django_admin_logCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Django_admin_logCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Django_admin_log.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Django_admin_logAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Django_admin_logAggregateArgs>(args: Subset<T, Django_admin_logAggregateArgs>): Prisma.PrismaPromise<GetDjango_admin_logAggregateType<T>>

    /**
     * Group by Django_admin_log.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_admin_logGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends django_admin_logGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: django_admin_logGroupByArgs['orderBy'] }
        : { orderBy?: django_admin_logGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, django_admin_logGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetDjango_admin_logGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the django_admin_log model
   */
  readonly fields: django_admin_logFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for django_admin_log.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__django_admin_logClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the django_admin_log model
   */ 
  interface django_admin_logFieldRefs {
    readonly mongoId: FieldRef<"django_admin_log", 'String'>
    readonly content_type_id: FieldRef<"django_admin_log", 'Json'>
    readonly id: FieldRef<"django_admin_log", 'Json'>
    readonly user_id: FieldRef<"django_admin_log", 'Json'>
  }
    

  // Custom InputTypes
  /**
   * django_admin_log findUnique
   */
  export type django_admin_logFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_admin_log
     */
    select?: django_admin_logSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_admin_log
     */
    omit?: django_admin_logOmit<ExtArgs> | null
    /**
     * Filter, which django_admin_log to fetch.
     */
    where: django_admin_logWhereUniqueInput
  }

  /**
   * django_admin_log findUniqueOrThrow
   */
  export type django_admin_logFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_admin_log
     */
    select?: django_admin_logSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_admin_log
     */
    omit?: django_admin_logOmit<ExtArgs> | null
    /**
     * Filter, which django_admin_log to fetch.
     */
    where: django_admin_logWhereUniqueInput
  }

  /**
   * django_admin_log findFirst
   */
  export type django_admin_logFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_admin_log
     */
    select?: django_admin_logSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_admin_log
     */
    omit?: django_admin_logOmit<ExtArgs> | null
    /**
     * Filter, which django_admin_log to fetch.
     */
    where?: django_admin_logWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of django_admin_logs to fetch.
     */
    orderBy?: django_admin_logOrderByWithRelationInput | django_admin_logOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for django_admin_logs.
     */
    cursor?: django_admin_logWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` django_admin_logs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` django_admin_logs.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of django_admin_logs.
     */
    distinct?: Django_admin_logScalarFieldEnum | Django_admin_logScalarFieldEnum[]
  }

  /**
   * django_admin_log findFirstOrThrow
   */
  export type django_admin_logFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_admin_log
     */
    select?: django_admin_logSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_admin_log
     */
    omit?: django_admin_logOmit<ExtArgs> | null
    /**
     * Filter, which django_admin_log to fetch.
     */
    where?: django_admin_logWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of django_admin_logs to fetch.
     */
    orderBy?: django_admin_logOrderByWithRelationInput | django_admin_logOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for django_admin_logs.
     */
    cursor?: django_admin_logWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` django_admin_logs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` django_admin_logs.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of django_admin_logs.
     */
    distinct?: Django_admin_logScalarFieldEnum | Django_admin_logScalarFieldEnum[]
  }

  /**
   * django_admin_log findMany
   */
  export type django_admin_logFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_admin_log
     */
    select?: django_admin_logSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_admin_log
     */
    omit?: django_admin_logOmit<ExtArgs> | null
    /**
     * Filter, which django_admin_logs to fetch.
     */
    where?: django_admin_logWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of django_admin_logs to fetch.
     */
    orderBy?: django_admin_logOrderByWithRelationInput | django_admin_logOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing django_admin_logs.
     */
    cursor?: django_admin_logWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` django_admin_logs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` django_admin_logs.
     */
    skip?: number
    distinct?: Django_admin_logScalarFieldEnum | Django_admin_logScalarFieldEnum[]
  }

  /**
   * django_admin_log create
   */
  export type django_admin_logCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_admin_log
     */
    select?: django_admin_logSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_admin_log
     */
    omit?: django_admin_logOmit<ExtArgs> | null
    /**
     * The data needed to create a django_admin_log.
     */
    data?: XOR<django_admin_logCreateInput, django_admin_logUncheckedCreateInput>
  }

  /**
   * django_admin_log createMany
   */
  export type django_admin_logCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many django_admin_logs.
     */
    data: django_admin_logCreateManyInput | django_admin_logCreateManyInput[]
  }

  /**
   * django_admin_log update
   */
  export type django_admin_logUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_admin_log
     */
    select?: django_admin_logSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_admin_log
     */
    omit?: django_admin_logOmit<ExtArgs> | null
    /**
     * The data needed to update a django_admin_log.
     */
    data: XOR<django_admin_logUpdateInput, django_admin_logUncheckedUpdateInput>
    /**
     * Choose, which django_admin_log to update.
     */
    where: django_admin_logWhereUniqueInput
  }

  /**
   * django_admin_log updateMany
   */
  export type django_admin_logUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update django_admin_logs.
     */
    data: XOR<django_admin_logUpdateManyMutationInput, django_admin_logUncheckedUpdateManyInput>
    /**
     * Filter which django_admin_logs to update
     */
    where?: django_admin_logWhereInput
    /**
     * Limit how many django_admin_logs to update.
     */
    limit?: number
  }

  /**
   * django_admin_log upsert
   */
  export type django_admin_logUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_admin_log
     */
    select?: django_admin_logSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_admin_log
     */
    omit?: django_admin_logOmit<ExtArgs> | null
    /**
     * The filter to search for the django_admin_log to update in case it exists.
     */
    where: django_admin_logWhereUniqueInput
    /**
     * In case the django_admin_log found by the `where` argument doesn't exist, create a new django_admin_log with this data.
     */
    create: XOR<django_admin_logCreateInput, django_admin_logUncheckedCreateInput>
    /**
     * In case the django_admin_log was found with the provided `where` argument, update it with this data.
     */
    update: XOR<django_admin_logUpdateInput, django_admin_logUncheckedUpdateInput>
  }

  /**
   * django_admin_log delete
   */
  export type django_admin_logDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_admin_log
     */
    select?: django_admin_logSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_admin_log
     */
    omit?: django_admin_logOmit<ExtArgs> | null
    /**
     * Filter which django_admin_log to delete.
     */
    where: django_admin_logWhereUniqueInput
  }

  /**
   * django_admin_log deleteMany
   */
  export type django_admin_logDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which django_admin_logs to delete
     */
    where?: django_admin_logWhereInput
    /**
     * Limit how many django_admin_logs to delete.
     */
    limit?: number
  }

  /**
   * django_admin_log findRaw
   */
  export type django_admin_logFindRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The query predicate filter. If unspecified, then all documents in the collection will match the predicate. ${@link https://docs.mongodb.com/manual/reference/operator/query MongoDB Docs}.
     */
    filter?: InputJsonValue
    /**
     * Additional options to pass to the `find` command ${@link https://docs.mongodb.com/manual/reference/command/find/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * django_admin_log aggregateRaw
   */
  export type django_admin_logAggregateRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * An array of aggregation stages to process and transform the document stream via the aggregation pipeline. ${@link https://docs.mongodb.com/manual/reference/operator/aggregation-pipeline MongoDB Docs}.
     */
    pipeline?: InputJsonValue[]
    /**
     * Additional options to pass to the `aggregate` command ${@link https://docs.mongodb.com/manual/reference/command/aggregate/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * django_admin_log without action
   */
  export type django_admin_logDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_admin_log
     */
    select?: django_admin_logSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_admin_log
     */
    omit?: django_admin_logOmit<ExtArgs> | null
  }


  /**
   * Model django_content_type
   */

  export type AggregateDjango_content_type = {
    _count: Django_content_typeCountAggregateOutputType | null
    _avg: Django_content_typeAvgAggregateOutputType | null
    _sum: Django_content_typeSumAggregateOutputType | null
    _min: Django_content_typeMinAggregateOutputType | null
    _max: Django_content_typeMaxAggregateOutputType | null
  }

  export type Django_content_typeAvgAggregateOutputType = {
    id_: number | null
  }

  export type Django_content_typeSumAggregateOutputType = {
    id_: number | null
  }

  export type Django_content_typeMinAggregateOutputType = {
    id: string | null
    app_label: string | null
    id_: number | null
    model: string | null
  }

  export type Django_content_typeMaxAggregateOutputType = {
    id: string | null
    app_label: string | null
    id_: number | null
    model: string | null
  }

  export type Django_content_typeCountAggregateOutputType = {
    id: number
    app_label: number
    id_: number
    model: number
    _all: number
  }


  export type Django_content_typeAvgAggregateInputType = {
    id_?: true
  }

  export type Django_content_typeSumAggregateInputType = {
    id_?: true
  }

  export type Django_content_typeMinAggregateInputType = {
    id?: true
    app_label?: true
    id_?: true
    model?: true
  }

  export type Django_content_typeMaxAggregateInputType = {
    id?: true
    app_label?: true
    id_?: true
    model?: true
  }

  export type Django_content_typeCountAggregateInputType = {
    id?: true
    app_label?: true
    id_?: true
    model?: true
    _all?: true
  }

  export type Django_content_typeAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which django_content_type to aggregate.
     */
    where?: django_content_typeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of django_content_types to fetch.
     */
    orderBy?: django_content_typeOrderByWithRelationInput | django_content_typeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: django_content_typeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` django_content_types from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` django_content_types.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned django_content_types
    **/
    _count?: true | Django_content_typeCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Django_content_typeAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Django_content_typeSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Django_content_typeMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Django_content_typeMaxAggregateInputType
  }

  export type GetDjango_content_typeAggregateType<T extends Django_content_typeAggregateArgs> = {
        [P in keyof T & keyof AggregateDjango_content_type]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateDjango_content_type[P]>
      : GetScalarType<T[P], AggregateDjango_content_type[P]>
  }




  export type django_content_typeGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: django_content_typeWhereInput
    orderBy?: django_content_typeOrderByWithAggregationInput | django_content_typeOrderByWithAggregationInput[]
    by: Django_content_typeScalarFieldEnum[] | Django_content_typeScalarFieldEnum
    having?: django_content_typeScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Django_content_typeCountAggregateInputType | true
    _avg?: Django_content_typeAvgAggregateInputType
    _sum?: Django_content_typeSumAggregateInputType
    _min?: Django_content_typeMinAggregateInputType
    _max?: Django_content_typeMaxAggregateInputType
  }

  export type Django_content_typeGroupByOutputType = {
    id: string
    app_label: string
    id_: number
    model: string
    _count: Django_content_typeCountAggregateOutputType | null
    _avg: Django_content_typeAvgAggregateOutputType | null
    _sum: Django_content_typeSumAggregateOutputType | null
    _min: Django_content_typeMinAggregateOutputType | null
    _max: Django_content_typeMaxAggregateOutputType | null
  }

  type GetDjango_content_typeGroupByPayload<T extends django_content_typeGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Django_content_typeGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Django_content_typeGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Django_content_typeGroupByOutputType[P]>
            : GetScalarType<T[P], Django_content_typeGroupByOutputType[P]>
        }
      >
    >


  export type django_content_typeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    app_label?: boolean
    id_?: boolean
    model?: boolean
  }, ExtArgs["result"]["django_content_type"]>



  export type django_content_typeSelectScalar = {
    id?: boolean
    app_label?: boolean
    id_?: boolean
    model?: boolean
  }

  export type django_content_typeOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "app_label" | "id_" | "model", ExtArgs["result"]["django_content_type"]>

  export type $django_content_typePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "django_content_type"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: string
      app_label: string
      id_: number
      model: string
    }, ExtArgs["result"]["django_content_type"]>
    composites: {}
  }

  type django_content_typeGetPayload<S extends boolean | null | undefined | django_content_typeDefaultArgs> = $Result.GetResult<Prisma.$django_content_typePayload, S>

  type django_content_typeCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<django_content_typeFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Django_content_typeCountAggregateInputType | true
    }

  export interface django_content_typeDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['django_content_type'], meta: { name: 'django_content_type' } }
    /**
     * Find zero or one Django_content_type that matches the filter.
     * @param {django_content_typeFindUniqueArgs} args - Arguments to find a Django_content_type
     * @example
     * // Get one Django_content_type
     * const django_content_type = await prisma.django_content_type.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends django_content_typeFindUniqueArgs>(args: SelectSubset<T, django_content_typeFindUniqueArgs<ExtArgs>>): Prisma__django_content_typeClient<$Result.GetResult<Prisma.$django_content_typePayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Django_content_type that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {django_content_typeFindUniqueOrThrowArgs} args - Arguments to find a Django_content_type
     * @example
     * // Get one Django_content_type
     * const django_content_type = await prisma.django_content_type.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends django_content_typeFindUniqueOrThrowArgs>(args: SelectSubset<T, django_content_typeFindUniqueOrThrowArgs<ExtArgs>>): Prisma__django_content_typeClient<$Result.GetResult<Prisma.$django_content_typePayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Django_content_type that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_content_typeFindFirstArgs} args - Arguments to find a Django_content_type
     * @example
     * // Get one Django_content_type
     * const django_content_type = await prisma.django_content_type.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends django_content_typeFindFirstArgs>(args?: SelectSubset<T, django_content_typeFindFirstArgs<ExtArgs>>): Prisma__django_content_typeClient<$Result.GetResult<Prisma.$django_content_typePayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Django_content_type that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_content_typeFindFirstOrThrowArgs} args - Arguments to find a Django_content_type
     * @example
     * // Get one Django_content_type
     * const django_content_type = await prisma.django_content_type.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends django_content_typeFindFirstOrThrowArgs>(args?: SelectSubset<T, django_content_typeFindFirstOrThrowArgs<ExtArgs>>): Prisma__django_content_typeClient<$Result.GetResult<Prisma.$django_content_typePayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Django_content_types that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_content_typeFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Django_content_types
     * const django_content_types = await prisma.django_content_type.findMany()
     * 
     * // Get first 10 Django_content_types
     * const django_content_types = await prisma.django_content_type.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const django_content_typeWithIdOnly = await prisma.django_content_type.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends django_content_typeFindManyArgs>(args?: SelectSubset<T, django_content_typeFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$django_content_typePayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Django_content_type.
     * @param {django_content_typeCreateArgs} args - Arguments to create a Django_content_type.
     * @example
     * // Create one Django_content_type
     * const Django_content_type = await prisma.django_content_type.create({
     *   data: {
     *     // ... data to create a Django_content_type
     *   }
     * })
     * 
     */
    create<T extends django_content_typeCreateArgs>(args: SelectSubset<T, django_content_typeCreateArgs<ExtArgs>>): Prisma__django_content_typeClient<$Result.GetResult<Prisma.$django_content_typePayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Django_content_types.
     * @param {django_content_typeCreateManyArgs} args - Arguments to create many Django_content_types.
     * @example
     * // Create many Django_content_types
     * const django_content_type = await prisma.django_content_type.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends django_content_typeCreateManyArgs>(args?: SelectSubset<T, django_content_typeCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Django_content_type.
     * @param {django_content_typeDeleteArgs} args - Arguments to delete one Django_content_type.
     * @example
     * // Delete one Django_content_type
     * const Django_content_type = await prisma.django_content_type.delete({
     *   where: {
     *     // ... filter to delete one Django_content_type
     *   }
     * })
     * 
     */
    delete<T extends django_content_typeDeleteArgs>(args: SelectSubset<T, django_content_typeDeleteArgs<ExtArgs>>): Prisma__django_content_typeClient<$Result.GetResult<Prisma.$django_content_typePayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Django_content_type.
     * @param {django_content_typeUpdateArgs} args - Arguments to update one Django_content_type.
     * @example
     * // Update one Django_content_type
     * const django_content_type = await prisma.django_content_type.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends django_content_typeUpdateArgs>(args: SelectSubset<T, django_content_typeUpdateArgs<ExtArgs>>): Prisma__django_content_typeClient<$Result.GetResult<Prisma.$django_content_typePayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Django_content_types.
     * @param {django_content_typeDeleteManyArgs} args - Arguments to filter Django_content_types to delete.
     * @example
     * // Delete a few Django_content_types
     * const { count } = await prisma.django_content_type.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends django_content_typeDeleteManyArgs>(args?: SelectSubset<T, django_content_typeDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Django_content_types.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_content_typeUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Django_content_types
     * const django_content_type = await prisma.django_content_type.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends django_content_typeUpdateManyArgs>(args: SelectSubset<T, django_content_typeUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Django_content_type.
     * @param {django_content_typeUpsertArgs} args - Arguments to update or create a Django_content_type.
     * @example
     * // Update or create a Django_content_type
     * const django_content_type = await prisma.django_content_type.upsert({
     *   create: {
     *     // ... data to create a Django_content_type
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Django_content_type we want to update
     *   }
     * })
     */
    upsert<T extends django_content_typeUpsertArgs>(args: SelectSubset<T, django_content_typeUpsertArgs<ExtArgs>>): Prisma__django_content_typeClient<$Result.GetResult<Prisma.$django_content_typePayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Django_content_types that matches the filter.
     * @param {django_content_typeFindRawArgs} args - Select which filters you would like to apply.
     * @example
     * const django_content_type = await prisma.django_content_type.findRaw({
     *   filter: { age: { $gt: 25 } }
     * })
     */
    findRaw(args?: django_content_typeFindRawArgs): Prisma.PrismaPromise<JsonObject>

    /**
     * Perform aggregation operations on a Django_content_type.
     * @param {django_content_typeAggregateRawArgs} args - Select which aggregations you would like to apply.
     * @example
     * const django_content_type = await prisma.django_content_type.aggregateRaw({
     *   pipeline: [
     *     { $match: { status: "registered" } },
     *     { $group: { _id: "$country", total: { $sum: 1 } } }
     *   ]
     * })
     */
    aggregateRaw(args?: django_content_typeAggregateRawArgs): Prisma.PrismaPromise<JsonObject>


    /**
     * Count the number of Django_content_types.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_content_typeCountArgs} args - Arguments to filter Django_content_types to count.
     * @example
     * // Count the number of Django_content_types
     * const count = await prisma.django_content_type.count({
     *   where: {
     *     // ... the filter for the Django_content_types we want to count
     *   }
     * })
    **/
    count<T extends django_content_typeCountArgs>(
      args?: Subset<T, django_content_typeCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Django_content_typeCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Django_content_type.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Django_content_typeAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Django_content_typeAggregateArgs>(args: Subset<T, Django_content_typeAggregateArgs>): Prisma.PrismaPromise<GetDjango_content_typeAggregateType<T>>

    /**
     * Group by Django_content_type.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_content_typeGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends django_content_typeGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: django_content_typeGroupByArgs['orderBy'] }
        : { orderBy?: django_content_typeGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, django_content_typeGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetDjango_content_typeGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the django_content_type model
   */
  readonly fields: django_content_typeFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for django_content_type.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__django_content_typeClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the django_content_type model
   */ 
  interface django_content_typeFieldRefs {
    readonly id: FieldRef<"django_content_type", 'String'>
    readonly app_label: FieldRef<"django_content_type", 'String'>
    readonly id_: FieldRef<"django_content_type", 'Int'>
    readonly model: FieldRef<"django_content_type", 'String'>
  }
    

  // Custom InputTypes
  /**
   * django_content_type findUnique
   */
  export type django_content_typeFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_content_type
     */
    select?: django_content_typeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_content_type
     */
    omit?: django_content_typeOmit<ExtArgs> | null
    /**
     * Filter, which django_content_type to fetch.
     */
    where: django_content_typeWhereUniqueInput
  }

  /**
   * django_content_type findUniqueOrThrow
   */
  export type django_content_typeFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_content_type
     */
    select?: django_content_typeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_content_type
     */
    omit?: django_content_typeOmit<ExtArgs> | null
    /**
     * Filter, which django_content_type to fetch.
     */
    where: django_content_typeWhereUniqueInput
  }

  /**
   * django_content_type findFirst
   */
  export type django_content_typeFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_content_type
     */
    select?: django_content_typeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_content_type
     */
    omit?: django_content_typeOmit<ExtArgs> | null
    /**
     * Filter, which django_content_type to fetch.
     */
    where?: django_content_typeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of django_content_types to fetch.
     */
    orderBy?: django_content_typeOrderByWithRelationInput | django_content_typeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for django_content_types.
     */
    cursor?: django_content_typeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` django_content_types from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` django_content_types.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of django_content_types.
     */
    distinct?: Django_content_typeScalarFieldEnum | Django_content_typeScalarFieldEnum[]
  }

  /**
   * django_content_type findFirstOrThrow
   */
  export type django_content_typeFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_content_type
     */
    select?: django_content_typeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_content_type
     */
    omit?: django_content_typeOmit<ExtArgs> | null
    /**
     * Filter, which django_content_type to fetch.
     */
    where?: django_content_typeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of django_content_types to fetch.
     */
    orderBy?: django_content_typeOrderByWithRelationInput | django_content_typeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for django_content_types.
     */
    cursor?: django_content_typeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` django_content_types from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` django_content_types.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of django_content_types.
     */
    distinct?: Django_content_typeScalarFieldEnum | Django_content_typeScalarFieldEnum[]
  }

  /**
   * django_content_type findMany
   */
  export type django_content_typeFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_content_type
     */
    select?: django_content_typeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_content_type
     */
    omit?: django_content_typeOmit<ExtArgs> | null
    /**
     * Filter, which django_content_types to fetch.
     */
    where?: django_content_typeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of django_content_types to fetch.
     */
    orderBy?: django_content_typeOrderByWithRelationInput | django_content_typeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing django_content_types.
     */
    cursor?: django_content_typeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` django_content_types from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` django_content_types.
     */
    skip?: number
    distinct?: Django_content_typeScalarFieldEnum | Django_content_typeScalarFieldEnum[]
  }

  /**
   * django_content_type create
   */
  export type django_content_typeCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_content_type
     */
    select?: django_content_typeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_content_type
     */
    omit?: django_content_typeOmit<ExtArgs> | null
    /**
     * The data needed to create a django_content_type.
     */
    data: XOR<django_content_typeCreateInput, django_content_typeUncheckedCreateInput>
  }

  /**
   * django_content_type createMany
   */
  export type django_content_typeCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many django_content_types.
     */
    data: django_content_typeCreateManyInput | django_content_typeCreateManyInput[]
  }

  /**
   * django_content_type update
   */
  export type django_content_typeUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_content_type
     */
    select?: django_content_typeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_content_type
     */
    omit?: django_content_typeOmit<ExtArgs> | null
    /**
     * The data needed to update a django_content_type.
     */
    data: XOR<django_content_typeUpdateInput, django_content_typeUncheckedUpdateInput>
    /**
     * Choose, which django_content_type to update.
     */
    where: django_content_typeWhereUniqueInput
  }

  /**
   * django_content_type updateMany
   */
  export type django_content_typeUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update django_content_types.
     */
    data: XOR<django_content_typeUpdateManyMutationInput, django_content_typeUncheckedUpdateManyInput>
    /**
     * Filter which django_content_types to update
     */
    where?: django_content_typeWhereInput
    /**
     * Limit how many django_content_types to update.
     */
    limit?: number
  }

  /**
   * django_content_type upsert
   */
  export type django_content_typeUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_content_type
     */
    select?: django_content_typeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_content_type
     */
    omit?: django_content_typeOmit<ExtArgs> | null
    /**
     * The filter to search for the django_content_type to update in case it exists.
     */
    where: django_content_typeWhereUniqueInput
    /**
     * In case the django_content_type found by the `where` argument doesn't exist, create a new django_content_type with this data.
     */
    create: XOR<django_content_typeCreateInput, django_content_typeUncheckedCreateInput>
    /**
     * In case the django_content_type was found with the provided `where` argument, update it with this data.
     */
    update: XOR<django_content_typeUpdateInput, django_content_typeUncheckedUpdateInput>
  }

  /**
   * django_content_type delete
   */
  export type django_content_typeDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_content_type
     */
    select?: django_content_typeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_content_type
     */
    omit?: django_content_typeOmit<ExtArgs> | null
    /**
     * Filter which django_content_type to delete.
     */
    where: django_content_typeWhereUniqueInput
  }

  /**
   * django_content_type deleteMany
   */
  export type django_content_typeDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which django_content_types to delete
     */
    where?: django_content_typeWhereInput
    /**
     * Limit how many django_content_types to delete.
     */
    limit?: number
  }

  /**
   * django_content_type findRaw
   */
  export type django_content_typeFindRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The query predicate filter. If unspecified, then all documents in the collection will match the predicate. ${@link https://docs.mongodb.com/manual/reference/operator/query MongoDB Docs}.
     */
    filter?: InputJsonValue
    /**
     * Additional options to pass to the `find` command ${@link https://docs.mongodb.com/manual/reference/command/find/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * django_content_type aggregateRaw
   */
  export type django_content_typeAggregateRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * An array of aggregation stages to process and transform the document stream via the aggregation pipeline. ${@link https://docs.mongodb.com/manual/reference/operator/aggregation-pipeline MongoDB Docs}.
     */
    pipeline?: InputJsonValue[]
    /**
     * Additional options to pass to the `aggregate` command ${@link https://docs.mongodb.com/manual/reference/command/aggregate/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * django_content_type without action
   */
  export type django_content_typeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_content_type
     */
    select?: django_content_typeSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_content_type
     */
    omit?: django_content_typeOmit<ExtArgs> | null
  }


  /**
   * Model django_migrations
   */

  export type AggregateDjango_migrations = {
    _count: Django_migrationsCountAggregateOutputType | null
    _avg: Django_migrationsAvgAggregateOutputType | null
    _sum: Django_migrationsSumAggregateOutputType | null
    _min: Django_migrationsMinAggregateOutputType | null
    _max: Django_migrationsMaxAggregateOutputType | null
  }

  export type Django_migrationsAvgAggregateOutputType = {
    id_: number | null
  }

  export type Django_migrationsSumAggregateOutputType = {
    id_: number | null
  }

  export type Django_migrationsMinAggregateOutputType = {
    id: string | null
    app: string | null
    applied: Date | null
    id_: number | null
    name: string | null
  }

  export type Django_migrationsMaxAggregateOutputType = {
    id: string | null
    app: string | null
    applied: Date | null
    id_: number | null
    name: string | null
  }

  export type Django_migrationsCountAggregateOutputType = {
    id: number
    app: number
    applied: number
    id_: number
    name: number
    _all: number
  }


  export type Django_migrationsAvgAggregateInputType = {
    id_?: true
  }

  export type Django_migrationsSumAggregateInputType = {
    id_?: true
  }

  export type Django_migrationsMinAggregateInputType = {
    id?: true
    app?: true
    applied?: true
    id_?: true
    name?: true
  }

  export type Django_migrationsMaxAggregateInputType = {
    id?: true
    app?: true
    applied?: true
    id_?: true
    name?: true
  }

  export type Django_migrationsCountAggregateInputType = {
    id?: true
    app?: true
    applied?: true
    id_?: true
    name?: true
    _all?: true
  }

  export type Django_migrationsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which django_migrations to aggregate.
     */
    where?: django_migrationsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of django_migrations to fetch.
     */
    orderBy?: django_migrationsOrderByWithRelationInput | django_migrationsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: django_migrationsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` django_migrations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` django_migrations.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned django_migrations
    **/
    _count?: true | Django_migrationsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Django_migrationsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Django_migrationsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Django_migrationsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Django_migrationsMaxAggregateInputType
  }

  export type GetDjango_migrationsAggregateType<T extends Django_migrationsAggregateArgs> = {
        [P in keyof T & keyof AggregateDjango_migrations]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateDjango_migrations[P]>
      : GetScalarType<T[P], AggregateDjango_migrations[P]>
  }




  export type django_migrationsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: django_migrationsWhereInput
    orderBy?: django_migrationsOrderByWithAggregationInput | django_migrationsOrderByWithAggregationInput[]
    by: Django_migrationsScalarFieldEnum[] | Django_migrationsScalarFieldEnum
    having?: django_migrationsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Django_migrationsCountAggregateInputType | true
    _avg?: Django_migrationsAvgAggregateInputType
    _sum?: Django_migrationsSumAggregateInputType
    _min?: Django_migrationsMinAggregateInputType
    _max?: Django_migrationsMaxAggregateInputType
  }

  export type Django_migrationsGroupByOutputType = {
    id: string
    app: string
    applied: Date
    id_: number
    name: string
    _count: Django_migrationsCountAggregateOutputType | null
    _avg: Django_migrationsAvgAggregateOutputType | null
    _sum: Django_migrationsSumAggregateOutputType | null
    _min: Django_migrationsMinAggregateOutputType | null
    _max: Django_migrationsMaxAggregateOutputType | null
  }

  type GetDjango_migrationsGroupByPayload<T extends django_migrationsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Django_migrationsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Django_migrationsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Django_migrationsGroupByOutputType[P]>
            : GetScalarType<T[P], Django_migrationsGroupByOutputType[P]>
        }
      >
    >


  export type django_migrationsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    app?: boolean
    applied?: boolean
    id_?: boolean
    name?: boolean
  }, ExtArgs["result"]["django_migrations"]>



  export type django_migrationsSelectScalar = {
    id?: boolean
    app?: boolean
    applied?: boolean
    id_?: boolean
    name?: boolean
  }

  export type django_migrationsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "app" | "applied" | "id_" | "name", ExtArgs["result"]["django_migrations"]>

  export type $django_migrationsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "django_migrations"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: string
      app: string
      applied: Date
      id_: number
      name: string
    }, ExtArgs["result"]["django_migrations"]>
    composites: {}
  }

  type django_migrationsGetPayload<S extends boolean | null | undefined | django_migrationsDefaultArgs> = $Result.GetResult<Prisma.$django_migrationsPayload, S>

  type django_migrationsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<django_migrationsFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Django_migrationsCountAggregateInputType | true
    }

  export interface django_migrationsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['django_migrations'], meta: { name: 'django_migrations' } }
    /**
     * Find zero or one Django_migrations that matches the filter.
     * @param {django_migrationsFindUniqueArgs} args - Arguments to find a Django_migrations
     * @example
     * // Get one Django_migrations
     * const django_migrations = await prisma.django_migrations.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends django_migrationsFindUniqueArgs>(args: SelectSubset<T, django_migrationsFindUniqueArgs<ExtArgs>>): Prisma__django_migrationsClient<$Result.GetResult<Prisma.$django_migrationsPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Django_migrations that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {django_migrationsFindUniqueOrThrowArgs} args - Arguments to find a Django_migrations
     * @example
     * // Get one Django_migrations
     * const django_migrations = await prisma.django_migrations.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends django_migrationsFindUniqueOrThrowArgs>(args: SelectSubset<T, django_migrationsFindUniqueOrThrowArgs<ExtArgs>>): Prisma__django_migrationsClient<$Result.GetResult<Prisma.$django_migrationsPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Django_migrations that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_migrationsFindFirstArgs} args - Arguments to find a Django_migrations
     * @example
     * // Get one Django_migrations
     * const django_migrations = await prisma.django_migrations.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends django_migrationsFindFirstArgs>(args?: SelectSubset<T, django_migrationsFindFirstArgs<ExtArgs>>): Prisma__django_migrationsClient<$Result.GetResult<Prisma.$django_migrationsPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Django_migrations that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_migrationsFindFirstOrThrowArgs} args - Arguments to find a Django_migrations
     * @example
     * // Get one Django_migrations
     * const django_migrations = await prisma.django_migrations.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends django_migrationsFindFirstOrThrowArgs>(args?: SelectSubset<T, django_migrationsFindFirstOrThrowArgs<ExtArgs>>): Prisma__django_migrationsClient<$Result.GetResult<Prisma.$django_migrationsPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Django_migrations that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_migrationsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Django_migrations
     * const django_migrations = await prisma.django_migrations.findMany()
     * 
     * // Get first 10 Django_migrations
     * const django_migrations = await prisma.django_migrations.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const django_migrationsWithIdOnly = await prisma.django_migrations.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends django_migrationsFindManyArgs>(args?: SelectSubset<T, django_migrationsFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$django_migrationsPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Django_migrations.
     * @param {django_migrationsCreateArgs} args - Arguments to create a Django_migrations.
     * @example
     * // Create one Django_migrations
     * const Django_migrations = await prisma.django_migrations.create({
     *   data: {
     *     // ... data to create a Django_migrations
     *   }
     * })
     * 
     */
    create<T extends django_migrationsCreateArgs>(args: SelectSubset<T, django_migrationsCreateArgs<ExtArgs>>): Prisma__django_migrationsClient<$Result.GetResult<Prisma.$django_migrationsPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Django_migrations.
     * @param {django_migrationsCreateManyArgs} args - Arguments to create many Django_migrations.
     * @example
     * // Create many Django_migrations
     * const django_migrations = await prisma.django_migrations.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends django_migrationsCreateManyArgs>(args?: SelectSubset<T, django_migrationsCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Django_migrations.
     * @param {django_migrationsDeleteArgs} args - Arguments to delete one Django_migrations.
     * @example
     * // Delete one Django_migrations
     * const Django_migrations = await prisma.django_migrations.delete({
     *   where: {
     *     // ... filter to delete one Django_migrations
     *   }
     * })
     * 
     */
    delete<T extends django_migrationsDeleteArgs>(args: SelectSubset<T, django_migrationsDeleteArgs<ExtArgs>>): Prisma__django_migrationsClient<$Result.GetResult<Prisma.$django_migrationsPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Django_migrations.
     * @param {django_migrationsUpdateArgs} args - Arguments to update one Django_migrations.
     * @example
     * // Update one Django_migrations
     * const django_migrations = await prisma.django_migrations.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends django_migrationsUpdateArgs>(args: SelectSubset<T, django_migrationsUpdateArgs<ExtArgs>>): Prisma__django_migrationsClient<$Result.GetResult<Prisma.$django_migrationsPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Django_migrations.
     * @param {django_migrationsDeleteManyArgs} args - Arguments to filter Django_migrations to delete.
     * @example
     * // Delete a few Django_migrations
     * const { count } = await prisma.django_migrations.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends django_migrationsDeleteManyArgs>(args?: SelectSubset<T, django_migrationsDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Django_migrations.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_migrationsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Django_migrations
     * const django_migrations = await prisma.django_migrations.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends django_migrationsUpdateManyArgs>(args: SelectSubset<T, django_migrationsUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Django_migrations.
     * @param {django_migrationsUpsertArgs} args - Arguments to update or create a Django_migrations.
     * @example
     * // Update or create a Django_migrations
     * const django_migrations = await prisma.django_migrations.upsert({
     *   create: {
     *     // ... data to create a Django_migrations
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Django_migrations we want to update
     *   }
     * })
     */
    upsert<T extends django_migrationsUpsertArgs>(args: SelectSubset<T, django_migrationsUpsertArgs<ExtArgs>>): Prisma__django_migrationsClient<$Result.GetResult<Prisma.$django_migrationsPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Django_migrations that matches the filter.
     * @param {django_migrationsFindRawArgs} args - Select which filters you would like to apply.
     * @example
     * const django_migrations = await prisma.django_migrations.findRaw({
     *   filter: { age: { $gt: 25 } }
     * })
     */
    findRaw(args?: django_migrationsFindRawArgs): Prisma.PrismaPromise<JsonObject>

    /**
     * Perform aggregation operations on a Django_migrations.
     * @param {django_migrationsAggregateRawArgs} args - Select which aggregations you would like to apply.
     * @example
     * const django_migrations = await prisma.django_migrations.aggregateRaw({
     *   pipeline: [
     *     { $match: { status: "registered" } },
     *     { $group: { _id: "$country", total: { $sum: 1 } } }
     *   ]
     * })
     */
    aggregateRaw(args?: django_migrationsAggregateRawArgs): Prisma.PrismaPromise<JsonObject>


    /**
     * Count the number of Django_migrations.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_migrationsCountArgs} args - Arguments to filter Django_migrations to count.
     * @example
     * // Count the number of Django_migrations
     * const count = await prisma.django_migrations.count({
     *   where: {
     *     // ... the filter for the Django_migrations we want to count
     *   }
     * })
    **/
    count<T extends django_migrationsCountArgs>(
      args?: Subset<T, django_migrationsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Django_migrationsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Django_migrations.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Django_migrationsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Django_migrationsAggregateArgs>(args: Subset<T, Django_migrationsAggregateArgs>): Prisma.PrismaPromise<GetDjango_migrationsAggregateType<T>>

    /**
     * Group by Django_migrations.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_migrationsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends django_migrationsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: django_migrationsGroupByArgs['orderBy'] }
        : { orderBy?: django_migrationsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, django_migrationsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetDjango_migrationsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the django_migrations model
   */
  readonly fields: django_migrationsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for django_migrations.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__django_migrationsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the django_migrations model
   */ 
  interface django_migrationsFieldRefs {
    readonly id: FieldRef<"django_migrations", 'String'>
    readonly app: FieldRef<"django_migrations", 'String'>
    readonly applied: FieldRef<"django_migrations", 'DateTime'>
    readonly id_: FieldRef<"django_migrations", 'Int'>
    readonly name: FieldRef<"django_migrations", 'String'>
  }
    

  // Custom InputTypes
  /**
   * django_migrations findUnique
   */
  export type django_migrationsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_migrations
     */
    select?: django_migrationsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_migrations
     */
    omit?: django_migrationsOmit<ExtArgs> | null
    /**
     * Filter, which django_migrations to fetch.
     */
    where: django_migrationsWhereUniqueInput
  }

  /**
   * django_migrations findUniqueOrThrow
   */
  export type django_migrationsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_migrations
     */
    select?: django_migrationsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_migrations
     */
    omit?: django_migrationsOmit<ExtArgs> | null
    /**
     * Filter, which django_migrations to fetch.
     */
    where: django_migrationsWhereUniqueInput
  }

  /**
   * django_migrations findFirst
   */
  export type django_migrationsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_migrations
     */
    select?: django_migrationsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_migrations
     */
    omit?: django_migrationsOmit<ExtArgs> | null
    /**
     * Filter, which django_migrations to fetch.
     */
    where?: django_migrationsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of django_migrations to fetch.
     */
    orderBy?: django_migrationsOrderByWithRelationInput | django_migrationsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for django_migrations.
     */
    cursor?: django_migrationsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` django_migrations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` django_migrations.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of django_migrations.
     */
    distinct?: Django_migrationsScalarFieldEnum | Django_migrationsScalarFieldEnum[]
  }

  /**
   * django_migrations findFirstOrThrow
   */
  export type django_migrationsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_migrations
     */
    select?: django_migrationsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_migrations
     */
    omit?: django_migrationsOmit<ExtArgs> | null
    /**
     * Filter, which django_migrations to fetch.
     */
    where?: django_migrationsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of django_migrations to fetch.
     */
    orderBy?: django_migrationsOrderByWithRelationInput | django_migrationsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for django_migrations.
     */
    cursor?: django_migrationsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` django_migrations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` django_migrations.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of django_migrations.
     */
    distinct?: Django_migrationsScalarFieldEnum | Django_migrationsScalarFieldEnum[]
  }

  /**
   * django_migrations findMany
   */
  export type django_migrationsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_migrations
     */
    select?: django_migrationsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_migrations
     */
    omit?: django_migrationsOmit<ExtArgs> | null
    /**
     * Filter, which django_migrations to fetch.
     */
    where?: django_migrationsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of django_migrations to fetch.
     */
    orderBy?: django_migrationsOrderByWithRelationInput | django_migrationsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing django_migrations.
     */
    cursor?: django_migrationsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` django_migrations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` django_migrations.
     */
    skip?: number
    distinct?: Django_migrationsScalarFieldEnum | Django_migrationsScalarFieldEnum[]
  }

  /**
   * django_migrations create
   */
  export type django_migrationsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_migrations
     */
    select?: django_migrationsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_migrations
     */
    omit?: django_migrationsOmit<ExtArgs> | null
    /**
     * The data needed to create a django_migrations.
     */
    data: XOR<django_migrationsCreateInput, django_migrationsUncheckedCreateInput>
  }

  /**
   * django_migrations createMany
   */
  export type django_migrationsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many django_migrations.
     */
    data: django_migrationsCreateManyInput | django_migrationsCreateManyInput[]
  }

  /**
   * django_migrations update
   */
  export type django_migrationsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_migrations
     */
    select?: django_migrationsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_migrations
     */
    omit?: django_migrationsOmit<ExtArgs> | null
    /**
     * The data needed to update a django_migrations.
     */
    data: XOR<django_migrationsUpdateInput, django_migrationsUncheckedUpdateInput>
    /**
     * Choose, which django_migrations to update.
     */
    where: django_migrationsWhereUniqueInput
  }

  /**
   * django_migrations updateMany
   */
  export type django_migrationsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update django_migrations.
     */
    data: XOR<django_migrationsUpdateManyMutationInput, django_migrationsUncheckedUpdateManyInput>
    /**
     * Filter which django_migrations to update
     */
    where?: django_migrationsWhereInput
    /**
     * Limit how many django_migrations to update.
     */
    limit?: number
  }

  /**
   * django_migrations upsert
   */
  export type django_migrationsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_migrations
     */
    select?: django_migrationsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_migrations
     */
    omit?: django_migrationsOmit<ExtArgs> | null
    /**
     * The filter to search for the django_migrations to update in case it exists.
     */
    where: django_migrationsWhereUniqueInput
    /**
     * In case the django_migrations found by the `where` argument doesn't exist, create a new django_migrations with this data.
     */
    create: XOR<django_migrationsCreateInput, django_migrationsUncheckedCreateInput>
    /**
     * In case the django_migrations was found with the provided `where` argument, update it with this data.
     */
    update: XOR<django_migrationsUpdateInput, django_migrationsUncheckedUpdateInput>
  }

  /**
   * django_migrations delete
   */
  export type django_migrationsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_migrations
     */
    select?: django_migrationsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_migrations
     */
    omit?: django_migrationsOmit<ExtArgs> | null
    /**
     * Filter which django_migrations to delete.
     */
    where: django_migrationsWhereUniqueInput
  }

  /**
   * django_migrations deleteMany
   */
  export type django_migrationsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which django_migrations to delete
     */
    where?: django_migrationsWhereInput
    /**
     * Limit how many django_migrations to delete.
     */
    limit?: number
  }

  /**
   * django_migrations findRaw
   */
  export type django_migrationsFindRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The query predicate filter. If unspecified, then all documents in the collection will match the predicate. ${@link https://docs.mongodb.com/manual/reference/operator/query MongoDB Docs}.
     */
    filter?: InputJsonValue
    /**
     * Additional options to pass to the `find` command ${@link https://docs.mongodb.com/manual/reference/command/find/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * django_migrations aggregateRaw
   */
  export type django_migrationsAggregateRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * An array of aggregation stages to process and transform the document stream via the aggregation pipeline. ${@link https://docs.mongodb.com/manual/reference/operator/aggregation-pipeline MongoDB Docs}.
     */
    pipeline?: InputJsonValue[]
    /**
     * Additional options to pass to the `aggregate` command ${@link https://docs.mongodb.com/manual/reference/command/aggregate/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * django_migrations without action
   */
  export type django_migrationsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_migrations
     */
    select?: django_migrationsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_migrations
     */
    omit?: django_migrationsOmit<ExtArgs> | null
  }


  /**
   * Model django_session
   */

  export type AggregateDjango_session = {
    _count: Django_sessionCountAggregateOutputType | null
    _min: Django_sessionMinAggregateOutputType | null
    _max: Django_sessionMaxAggregateOutputType | null
  }

  export type Django_sessionMinAggregateOutputType = {
    id: string | null
  }

  export type Django_sessionMaxAggregateOutputType = {
    id: string | null
  }

  export type Django_sessionCountAggregateOutputType = {
    id: number
    expire_date: number
    session_key: number
    _all: number
  }


  export type Django_sessionMinAggregateInputType = {
    id?: true
  }

  export type Django_sessionMaxAggregateInputType = {
    id?: true
  }

  export type Django_sessionCountAggregateInputType = {
    id?: true
    expire_date?: true
    session_key?: true
    _all?: true
  }

  export type Django_sessionAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which django_session to aggregate.
     */
    where?: django_sessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of django_sessions to fetch.
     */
    orderBy?: django_sessionOrderByWithRelationInput | django_sessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: django_sessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` django_sessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` django_sessions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned django_sessions
    **/
    _count?: true | Django_sessionCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Django_sessionMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Django_sessionMaxAggregateInputType
  }

  export type GetDjango_sessionAggregateType<T extends Django_sessionAggregateArgs> = {
        [P in keyof T & keyof AggregateDjango_session]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateDjango_session[P]>
      : GetScalarType<T[P], AggregateDjango_session[P]>
  }




  export type django_sessionGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: django_sessionWhereInput
    orderBy?: django_sessionOrderByWithAggregationInput | django_sessionOrderByWithAggregationInput[]
    by: Django_sessionScalarFieldEnum[] | Django_sessionScalarFieldEnum
    having?: django_sessionScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Django_sessionCountAggregateInputType | true
    _min?: Django_sessionMinAggregateInputType
    _max?: Django_sessionMaxAggregateInputType
  }

  export type Django_sessionGroupByOutputType = {
    id: string
    expire_date: JsonValue | null
    session_key: JsonValue | null
    _count: Django_sessionCountAggregateOutputType | null
    _min: Django_sessionMinAggregateOutputType | null
    _max: Django_sessionMaxAggregateOutputType | null
  }

  type GetDjango_sessionGroupByPayload<T extends django_sessionGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Django_sessionGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Django_sessionGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Django_sessionGroupByOutputType[P]>
            : GetScalarType<T[P], Django_sessionGroupByOutputType[P]>
        }
      >
    >


  export type django_sessionSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    expire_date?: boolean
    session_key?: boolean
  }, ExtArgs["result"]["django_session"]>



  export type django_sessionSelectScalar = {
    id?: boolean
    expire_date?: boolean
    session_key?: boolean
  }

  export type django_sessionOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "expire_date" | "session_key", ExtArgs["result"]["django_session"]>

  export type $django_sessionPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "django_session"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: string
      /**
       * Field referred in an index, but found no data to define the type.
       */
      expire_date: Prisma.JsonValue | null
      /**
       * Field referred in an index, but found no data to define the type.
       */
      session_key: Prisma.JsonValue | null
    }, ExtArgs["result"]["django_session"]>
    composites: {}
  }

  type django_sessionGetPayload<S extends boolean | null | undefined | django_sessionDefaultArgs> = $Result.GetResult<Prisma.$django_sessionPayload, S>

  type django_sessionCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<django_sessionFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Django_sessionCountAggregateInputType | true
    }

  export interface django_sessionDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['django_session'], meta: { name: 'django_session' } }
    /**
     * Find zero or one Django_session that matches the filter.
     * @param {django_sessionFindUniqueArgs} args - Arguments to find a Django_session
     * @example
     * // Get one Django_session
     * const django_session = await prisma.django_session.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends django_sessionFindUniqueArgs>(args: SelectSubset<T, django_sessionFindUniqueArgs<ExtArgs>>): Prisma__django_sessionClient<$Result.GetResult<Prisma.$django_sessionPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Django_session that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {django_sessionFindUniqueOrThrowArgs} args - Arguments to find a Django_session
     * @example
     * // Get one Django_session
     * const django_session = await prisma.django_session.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends django_sessionFindUniqueOrThrowArgs>(args: SelectSubset<T, django_sessionFindUniqueOrThrowArgs<ExtArgs>>): Prisma__django_sessionClient<$Result.GetResult<Prisma.$django_sessionPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Django_session that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_sessionFindFirstArgs} args - Arguments to find a Django_session
     * @example
     * // Get one Django_session
     * const django_session = await prisma.django_session.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends django_sessionFindFirstArgs>(args?: SelectSubset<T, django_sessionFindFirstArgs<ExtArgs>>): Prisma__django_sessionClient<$Result.GetResult<Prisma.$django_sessionPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Django_session that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_sessionFindFirstOrThrowArgs} args - Arguments to find a Django_session
     * @example
     * // Get one Django_session
     * const django_session = await prisma.django_session.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends django_sessionFindFirstOrThrowArgs>(args?: SelectSubset<T, django_sessionFindFirstOrThrowArgs<ExtArgs>>): Prisma__django_sessionClient<$Result.GetResult<Prisma.$django_sessionPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Django_sessions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_sessionFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Django_sessions
     * const django_sessions = await prisma.django_session.findMany()
     * 
     * // Get first 10 Django_sessions
     * const django_sessions = await prisma.django_session.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const django_sessionWithIdOnly = await prisma.django_session.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends django_sessionFindManyArgs>(args?: SelectSubset<T, django_sessionFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$django_sessionPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Django_session.
     * @param {django_sessionCreateArgs} args - Arguments to create a Django_session.
     * @example
     * // Create one Django_session
     * const Django_session = await prisma.django_session.create({
     *   data: {
     *     // ... data to create a Django_session
     *   }
     * })
     * 
     */
    create<T extends django_sessionCreateArgs>(args: SelectSubset<T, django_sessionCreateArgs<ExtArgs>>): Prisma__django_sessionClient<$Result.GetResult<Prisma.$django_sessionPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Django_sessions.
     * @param {django_sessionCreateManyArgs} args - Arguments to create many Django_sessions.
     * @example
     * // Create many Django_sessions
     * const django_session = await prisma.django_session.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends django_sessionCreateManyArgs>(args?: SelectSubset<T, django_sessionCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Django_session.
     * @param {django_sessionDeleteArgs} args - Arguments to delete one Django_session.
     * @example
     * // Delete one Django_session
     * const Django_session = await prisma.django_session.delete({
     *   where: {
     *     // ... filter to delete one Django_session
     *   }
     * })
     * 
     */
    delete<T extends django_sessionDeleteArgs>(args: SelectSubset<T, django_sessionDeleteArgs<ExtArgs>>): Prisma__django_sessionClient<$Result.GetResult<Prisma.$django_sessionPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Django_session.
     * @param {django_sessionUpdateArgs} args - Arguments to update one Django_session.
     * @example
     * // Update one Django_session
     * const django_session = await prisma.django_session.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends django_sessionUpdateArgs>(args: SelectSubset<T, django_sessionUpdateArgs<ExtArgs>>): Prisma__django_sessionClient<$Result.GetResult<Prisma.$django_sessionPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Django_sessions.
     * @param {django_sessionDeleteManyArgs} args - Arguments to filter Django_sessions to delete.
     * @example
     * // Delete a few Django_sessions
     * const { count } = await prisma.django_session.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends django_sessionDeleteManyArgs>(args?: SelectSubset<T, django_sessionDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Django_sessions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_sessionUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Django_sessions
     * const django_session = await prisma.django_session.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends django_sessionUpdateManyArgs>(args: SelectSubset<T, django_sessionUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Django_session.
     * @param {django_sessionUpsertArgs} args - Arguments to update or create a Django_session.
     * @example
     * // Update or create a Django_session
     * const django_session = await prisma.django_session.upsert({
     *   create: {
     *     // ... data to create a Django_session
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Django_session we want to update
     *   }
     * })
     */
    upsert<T extends django_sessionUpsertArgs>(args: SelectSubset<T, django_sessionUpsertArgs<ExtArgs>>): Prisma__django_sessionClient<$Result.GetResult<Prisma.$django_sessionPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Django_sessions that matches the filter.
     * @param {django_sessionFindRawArgs} args - Select which filters you would like to apply.
     * @example
     * const django_session = await prisma.django_session.findRaw({
     *   filter: { age: { $gt: 25 } }
     * })
     */
    findRaw(args?: django_sessionFindRawArgs): Prisma.PrismaPromise<JsonObject>

    /**
     * Perform aggregation operations on a Django_session.
     * @param {django_sessionAggregateRawArgs} args - Select which aggregations you would like to apply.
     * @example
     * const django_session = await prisma.django_session.aggregateRaw({
     *   pipeline: [
     *     { $match: { status: "registered" } },
     *     { $group: { _id: "$country", total: { $sum: 1 } } }
     *   ]
     * })
     */
    aggregateRaw(args?: django_sessionAggregateRawArgs): Prisma.PrismaPromise<JsonObject>


    /**
     * Count the number of Django_sessions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_sessionCountArgs} args - Arguments to filter Django_sessions to count.
     * @example
     * // Count the number of Django_sessions
     * const count = await prisma.django_session.count({
     *   where: {
     *     // ... the filter for the Django_sessions we want to count
     *   }
     * })
    **/
    count<T extends django_sessionCountArgs>(
      args?: Subset<T, django_sessionCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Django_sessionCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Django_session.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Django_sessionAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Django_sessionAggregateArgs>(args: Subset<T, Django_sessionAggregateArgs>): Prisma.PrismaPromise<GetDjango_sessionAggregateType<T>>

    /**
     * Group by Django_session.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {django_sessionGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends django_sessionGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: django_sessionGroupByArgs['orderBy'] }
        : { orderBy?: django_sessionGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, django_sessionGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetDjango_sessionGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the django_session model
   */
  readonly fields: django_sessionFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for django_session.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__django_sessionClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the django_session model
   */ 
  interface django_sessionFieldRefs {
    readonly id: FieldRef<"django_session", 'String'>
    readonly expire_date: FieldRef<"django_session", 'Json'>
    readonly session_key: FieldRef<"django_session", 'Json'>
  }
    

  // Custom InputTypes
  /**
   * django_session findUnique
   */
  export type django_sessionFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_session
     */
    select?: django_sessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_session
     */
    omit?: django_sessionOmit<ExtArgs> | null
    /**
     * Filter, which django_session to fetch.
     */
    where: django_sessionWhereUniqueInput
  }

  /**
   * django_session findUniqueOrThrow
   */
  export type django_sessionFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_session
     */
    select?: django_sessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_session
     */
    omit?: django_sessionOmit<ExtArgs> | null
    /**
     * Filter, which django_session to fetch.
     */
    where: django_sessionWhereUniqueInput
  }

  /**
   * django_session findFirst
   */
  export type django_sessionFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_session
     */
    select?: django_sessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_session
     */
    omit?: django_sessionOmit<ExtArgs> | null
    /**
     * Filter, which django_session to fetch.
     */
    where?: django_sessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of django_sessions to fetch.
     */
    orderBy?: django_sessionOrderByWithRelationInput | django_sessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for django_sessions.
     */
    cursor?: django_sessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` django_sessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` django_sessions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of django_sessions.
     */
    distinct?: Django_sessionScalarFieldEnum | Django_sessionScalarFieldEnum[]
  }

  /**
   * django_session findFirstOrThrow
   */
  export type django_sessionFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_session
     */
    select?: django_sessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_session
     */
    omit?: django_sessionOmit<ExtArgs> | null
    /**
     * Filter, which django_session to fetch.
     */
    where?: django_sessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of django_sessions to fetch.
     */
    orderBy?: django_sessionOrderByWithRelationInput | django_sessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for django_sessions.
     */
    cursor?: django_sessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` django_sessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` django_sessions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of django_sessions.
     */
    distinct?: Django_sessionScalarFieldEnum | Django_sessionScalarFieldEnum[]
  }

  /**
   * django_session findMany
   */
  export type django_sessionFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_session
     */
    select?: django_sessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_session
     */
    omit?: django_sessionOmit<ExtArgs> | null
    /**
     * Filter, which django_sessions to fetch.
     */
    where?: django_sessionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of django_sessions to fetch.
     */
    orderBy?: django_sessionOrderByWithRelationInput | django_sessionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing django_sessions.
     */
    cursor?: django_sessionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` django_sessions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` django_sessions.
     */
    skip?: number
    distinct?: Django_sessionScalarFieldEnum | Django_sessionScalarFieldEnum[]
  }

  /**
   * django_session create
   */
  export type django_sessionCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_session
     */
    select?: django_sessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_session
     */
    omit?: django_sessionOmit<ExtArgs> | null
    /**
     * The data needed to create a django_session.
     */
    data?: XOR<django_sessionCreateInput, django_sessionUncheckedCreateInput>
  }

  /**
   * django_session createMany
   */
  export type django_sessionCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many django_sessions.
     */
    data: django_sessionCreateManyInput | django_sessionCreateManyInput[]
  }

  /**
   * django_session update
   */
  export type django_sessionUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_session
     */
    select?: django_sessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_session
     */
    omit?: django_sessionOmit<ExtArgs> | null
    /**
     * The data needed to update a django_session.
     */
    data: XOR<django_sessionUpdateInput, django_sessionUncheckedUpdateInput>
    /**
     * Choose, which django_session to update.
     */
    where: django_sessionWhereUniqueInput
  }

  /**
   * django_session updateMany
   */
  export type django_sessionUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update django_sessions.
     */
    data: XOR<django_sessionUpdateManyMutationInput, django_sessionUncheckedUpdateManyInput>
    /**
     * Filter which django_sessions to update
     */
    where?: django_sessionWhereInput
    /**
     * Limit how many django_sessions to update.
     */
    limit?: number
  }

  /**
   * django_session upsert
   */
  export type django_sessionUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_session
     */
    select?: django_sessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_session
     */
    omit?: django_sessionOmit<ExtArgs> | null
    /**
     * The filter to search for the django_session to update in case it exists.
     */
    where: django_sessionWhereUniqueInput
    /**
     * In case the django_session found by the `where` argument doesn't exist, create a new django_session with this data.
     */
    create: XOR<django_sessionCreateInput, django_sessionUncheckedCreateInput>
    /**
     * In case the django_session was found with the provided `where` argument, update it with this data.
     */
    update: XOR<django_sessionUpdateInput, django_sessionUncheckedUpdateInput>
  }

  /**
   * django_session delete
   */
  export type django_sessionDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_session
     */
    select?: django_sessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_session
     */
    omit?: django_sessionOmit<ExtArgs> | null
    /**
     * Filter which django_session to delete.
     */
    where: django_sessionWhereUniqueInput
  }

  /**
   * django_session deleteMany
   */
  export type django_sessionDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which django_sessions to delete
     */
    where?: django_sessionWhereInput
    /**
     * Limit how many django_sessions to delete.
     */
    limit?: number
  }

  /**
   * django_session findRaw
   */
  export type django_sessionFindRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The query predicate filter. If unspecified, then all documents in the collection will match the predicate. ${@link https://docs.mongodb.com/manual/reference/operator/query MongoDB Docs}.
     */
    filter?: InputJsonValue
    /**
     * Additional options to pass to the `find` command ${@link https://docs.mongodb.com/manual/reference/command/find/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * django_session aggregateRaw
   */
  export type django_sessionAggregateRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * An array of aggregation stages to process and transform the document stream via the aggregation pipeline. ${@link https://docs.mongodb.com/manual/reference/operator/aggregation-pipeline MongoDB Docs}.
     */
    pipeline?: InputJsonValue[]
    /**
     * Additional options to pass to the `aggregate` command ${@link https://docs.mongodb.com/manual/reference/command/aggregate/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * django_session without action
   */
  export type django_sessionDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the django_session
     */
    select?: django_sessionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the django_session
     */
    omit?: django_sessionOmit<ExtArgs> | null
  }


  /**
   * Model Group
   */

  export type AggregateGroup = {
    _count: GroupCountAggregateOutputType | null
    _avg: GroupAvgAggregateOutputType | null
    _sum: GroupSumAggregateOutputType | null
    _min: GroupMinAggregateOutputType | null
    _max: GroupMaxAggregateOutputType | null
  }

  export type GroupAvgAggregateOutputType = {
    downtrend_cnt: number | null
    fk_user_id: number | null
    id_: number | null
    uptrend_cnt: number | null
  }

  export type GroupSumAggregateOutputType = {
    downtrend_cnt: number | null
    fk_user_id: number | null
    id_: number | null
    uptrend_cnt: number | null
  }

  export type GroupMinAggregateOutputType = {
    id: string | null
    created_date: Date | null
    domain_name: string | null
    downtrend_cnt: number | null
    fk_user_id: number | null
    group_call_end: Date | null
    group_call_start: Date | null
    group_call_status: string | null
    group_name: string | null
    id_: number | null
    keyword_difficulty: string | null
    metric_status: string | null
    project_automation_time: Date | null
    track_status: string | null
    updated_date: Date | null
    uptrend_cnt: number | null
  }

  export type GroupMaxAggregateOutputType = {
    id: string | null
    created_date: Date | null
    domain_name: string | null
    downtrend_cnt: number | null
    fk_user_id: number | null
    group_call_end: Date | null
    group_call_start: Date | null
    group_call_status: string | null
    group_name: string | null
    id_: number | null
    keyword_difficulty: string | null
    metric_status: string | null
    project_automation_time: Date | null
    track_status: string | null
    updated_date: Date | null
    uptrend_cnt: number | null
  }

  export type GroupCountAggregateOutputType = {
    id: number
    created_date: number
    domain_name: number
    downtrend_cnt: number
    fk_user_id: number
    group_call_end: number
    group_call_start: number
    group_call_status: number
    group_name: number
    id_: number
    keyword_difficulty: number
    metric_status: number
    project_automation_time: number
    track_status: number
    updated_date: number
    uptrend_cnt: number
    _all: number
  }


  export type GroupAvgAggregateInputType = {
    downtrend_cnt?: true
    fk_user_id?: true
    id_?: true
    uptrend_cnt?: true
  }

  export type GroupSumAggregateInputType = {
    downtrend_cnt?: true
    fk_user_id?: true
    id_?: true
    uptrend_cnt?: true
  }

  export type GroupMinAggregateInputType = {
    id?: true
    created_date?: true
    domain_name?: true
    downtrend_cnt?: true
    fk_user_id?: true
    group_call_end?: true
    group_call_start?: true
    group_call_status?: true
    group_name?: true
    id_?: true
    keyword_difficulty?: true
    metric_status?: true
    project_automation_time?: true
    track_status?: true
    updated_date?: true
    uptrend_cnt?: true
  }

  export type GroupMaxAggregateInputType = {
    id?: true
    created_date?: true
    domain_name?: true
    downtrend_cnt?: true
    fk_user_id?: true
    group_call_end?: true
    group_call_start?: true
    group_call_status?: true
    group_name?: true
    id_?: true
    keyword_difficulty?: true
    metric_status?: true
    project_automation_time?: true
    track_status?: true
    updated_date?: true
    uptrend_cnt?: true
  }

  export type GroupCountAggregateInputType = {
    id?: true
    created_date?: true
    domain_name?: true
    downtrend_cnt?: true
    fk_user_id?: true
    group_call_end?: true
    group_call_start?: true
    group_call_status?: true
    group_name?: true
    id_?: true
    keyword_difficulty?: true
    metric_status?: true
    project_automation_time?: true
    track_status?: true
    updated_date?: true
    uptrend_cnt?: true
    _all?: true
  }

  export type GroupAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Group to aggregate.
     */
    where?: GroupWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Groups to fetch.
     */
    orderBy?: GroupOrderByWithRelationInput | GroupOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: GroupWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Groups from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Groups.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Groups
    **/
    _count?: true | GroupCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: GroupAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: GroupSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: GroupMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: GroupMaxAggregateInputType
  }

  export type GetGroupAggregateType<T extends GroupAggregateArgs> = {
        [P in keyof T & keyof AggregateGroup]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateGroup[P]>
      : GetScalarType<T[P], AggregateGroup[P]>
  }




  export type GroupGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: GroupWhereInput
    orderBy?: GroupOrderByWithAggregationInput | GroupOrderByWithAggregationInput[]
    by: GroupScalarFieldEnum[] | GroupScalarFieldEnum
    having?: GroupScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: GroupCountAggregateInputType | true
    _avg?: GroupAvgAggregateInputType
    _sum?: GroupSumAggregateInputType
    _min?: GroupMinAggregateInputType
    _max?: GroupMaxAggregateInputType
  }

  export type GroupGroupByOutputType = {
    id: string
    created_date: Date
    domain_name: string
    downtrend_cnt: number
    fk_user_id: number
    group_call_end: Date
    group_call_start: Date
    group_call_status: string
    group_name: string
    id_: number
    keyword_difficulty: string
    metric_status: string
    project_automation_time: Date
    track_status: string
    updated_date: Date
    uptrend_cnt: number
    _count: GroupCountAggregateOutputType | null
    _avg: GroupAvgAggregateOutputType | null
    _sum: GroupSumAggregateOutputType | null
    _min: GroupMinAggregateOutputType | null
    _max: GroupMaxAggregateOutputType | null
  }

  type GetGroupGroupByPayload<T extends GroupGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<GroupGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof GroupGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], GroupGroupByOutputType[P]>
            : GetScalarType<T[P], GroupGroupByOutputType[P]>
        }
      >
    >


  export type GroupSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    created_date?: boolean
    domain_name?: boolean
    downtrend_cnt?: boolean
    fk_user_id?: boolean
    group_call_end?: boolean
    group_call_start?: boolean
    group_call_status?: boolean
    group_name?: boolean
    id_?: boolean
    keyword_difficulty?: boolean
    metric_status?: boolean
    project_automation_time?: boolean
    track_status?: boolean
    updated_date?: boolean
    uptrend_cnt?: boolean
  }, ExtArgs["result"]["group"]>



  export type GroupSelectScalar = {
    id?: boolean
    created_date?: boolean
    domain_name?: boolean
    downtrend_cnt?: boolean
    fk_user_id?: boolean
    group_call_end?: boolean
    group_call_start?: boolean
    group_call_status?: boolean
    group_name?: boolean
    id_?: boolean
    keyword_difficulty?: boolean
    metric_status?: boolean
    project_automation_time?: boolean
    track_status?: boolean
    updated_date?: boolean
    uptrend_cnt?: boolean
  }

  export type GroupOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "created_date" | "domain_name" | "downtrend_cnt" | "fk_user_id" | "group_call_end" | "group_call_start" | "group_call_status" | "group_name" | "id_" | "keyword_difficulty" | "metric_status" | "project_automation_time" | "track_status" | "updated_date" | "uptrend_cnt", ExtArgs["result"]["group"]>

  export type $GroupPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Group"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: string
      created_date: Date
      domain_name: string
      downtrend_cnt: number
      fk_user_id: number
      group_call_end: Date
      group_call_start: Date
      group_call_status: string
      group_name: string
      id_: number
      keyword_difficulty: string
      metric_status: string
      project_automation_time: Date
      track_status: string
      updated_date: Date
      uptrend_cnt: number
    }, ExtArgs["result"]["group"]>
    composites: {}
  }

  type GroupGetPayload<S extends boolean | null | undefined | GroupDefaultArgs> = $Result.GetResult<Prisma.$GroupPayload, S>

  type GroupCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<GroupFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: GroupCountAggregateInputType | true
    }

  export interface GroupDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Group'], meta: { name: 'Group' } }
    /**
     * Find zero or one Group that matches the filter.
     * @param {GroupFindUniqueArgs} args - Arguments to find a Group
     * @example
     * // Get one Group
     * const group = await prisma.group.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends GroupFindUniqueArgs>(args: SelectSubset<T, GroupFindUniqueArgs<ExtArgs>>): Prisma__GroupClient<$Result.GetResult<Prisma.$GroupPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Group that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {GroupFindUniqueOrThrowArgs} args - Arguments to find a Group
     * @example
     * // Get one Group
     * const group = await prisma.group.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends GroupFindUniqueOrThrowArgs>(args: SelectSubset<T, GroupFindUniqueOrThrowArgs<ExtArgs>>): Prisma__GroupClient<$Result.GetResult<Prisma.$GroupPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Group that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GroupFindFirstArgs} args - Arguments to find a Group
     * @example
     * // Get one Group
     * const group = await prisma.group.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends GroupFindFirstArgs>(args?: SelectSubset<T, GroupFindFirstArgs<ExtArgs>>): Prisma__GroupClient<$Result.GetResult<Prisma.$GroupPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Group that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GroupFindFirstOrThrowArgs} args - Arguments to find a Group
     * @example
     * // Get one Group
     * const group = await prisma.group.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends GroupFindFirstOrThrowArgs>(args?: SelectSubset<T, GroupFindFirstOrThrowArgs<ExtArgs>>): Prisma__GroupClient<$Result.GetResult<Prisma.$GroupPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Groups that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GroupFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Groups
     * const groups = await prisma.group.findMany()
     * 
     * // Get first 10 Groups
     * const groups = await prisma.group.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const groupWithIdOnly = await prisma.group.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends GroupFindManyArgs>(args?: SelectSubset<T, GroupFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$GroupPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Group.
     * @param {GroupCreateArgs} args - Arguments to create a Group.
     * @example
     * // Create one Group
     * const Group = await prisma.group.create({
     *   data: {
     *     // ... data to create a Group
     *   }
     * })
     * 
     */
    create<T extends GroupCreateArgs>(args: SelectSubset<T, GroupCreateArgs<ExtArgs>>): Prisma__GroupClient<$Result.GetResult<Prisma.$GroupPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Groups.
     * @param {GroupCreateManyArgs} args - Arguments to create many Groups.
     * @example
     * // Create many Groups
     * const group = await prisma.group.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends GroupCreateManyArgs>(args?: SelectSubset<T, GroupCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Group.
     * @param {GroupDeleteArgs} args - Arguments to delete one Group.
     * @example
     * // Delete one Group
     * const Group = await prisma.group.delete({
     *   where: {
     *     // ... filter to delete one Group
     *   }
     * })
     * 
     */
    delete<T extends GroupDeleteArgs>(args: SelectSubset<T, GroupDeleteArgs<ExtArgs>>): Prisma__GroupClient<$Result.GetResult<Prisma.$GroupPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Group.
     * @param {GroupUpdateArgs} args - Arguments to update one Group.
     * @example
     * // Update one Group
     * const group = await prisma.group.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends GroupUpdateArgs>(args: SelectSubset<T, GroupUpdateArgs<ExtArgs>>): Prisma__GroupClient<$Result.GetResult<Prisma.$GroupPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Groups.
     * @param {GroupDeleteManyArgs} args - Arguments to filter Groups to delete.
     * @example
     * // Delete a few Groups
     * const { count } = await prisma.group.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends GroupDeleteManyArgs>(args?: SelectSubset<T, GroupDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Groups.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GroupUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Groups
     * const group = await prisma.group.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends GroupUpdateManyArgs>(args: SelectSubset<T, GroupUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Group.
     * @param {GroupUpsertArgs} args - Arguments to update or create a Group.
     * @example
     * // Update or create a Group
     * const group = await prisma.group.upsert({
     *   create: {
     *     // ... data to create a Group
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Group we want to update
     *   }
     * })
     */
    upsert<T extends GroupUpsertArgs>(args: SelectSubset<T, GroupUpsertArgs<ExtArgs>>): Prisma__GroupClient<$Result.GetResult<Prisma.$GroupPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Groups that matches the filter.
     * @param {GroupFindRawArgs} args - Select which filters you would like to apply.
     * @example
     * const group = await prisma.group.findRaw({
     *   filter: { age: { $gt: 25 } }
     * })
     */
    findRaw(args?: GroupFindRawArgs): Prisma.PrismaPromise<JsonObject>

    /**
     * Perform aggregation operations on a Group.
     * @param {GroupAggregateRawArgs} args - Select which aggregations you would like to apply.
     * @example
     * const group = await prisma.group.aggregateRaw({
     *   pipeline: [
     *     { $match: { status: "registered" } },
     *     { $group: { _id: "$country", total: { $sum: 1 } } }
     *   ]
     * })
     */
    aggregateRaw(args?: GroupAggregateRawArgs): Prisma.PrismaPromise<JsonObject>


    /**
     * Count the number of Groups.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GroupCountArgs} args - Arguments to filter Groups to count.
     * @example
     * // Count the number of Groups
     * const count = await prisma.group.count({
     *   where: {
     *     // ... the filter for the Groups we want to count
     *   }
     * })
    **/
    count<T extends GroupCountArgs>(
      args?: Subset<T, GroupCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], GroupCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Group.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GroupAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends GroupAggregateArgs>(args: Subset<T, GroupAggregateArgs>): Prisma.PrismaPromise<GetGroupAggregateType<T>>

    /**
     * Group by Group.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GroupGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends GroupGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: GroupGroupByArgs['orderBy'] }
        : { orderBy?: GroupGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, GroupGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetGroupGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Group model
   */
  readonly fields: GroupFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Group.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__GroupClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Group model
   */ 
  interface GroupFieldRefs {
    readonly id: FieldRef<"Group", 'String'>
    readonly created_date: FieldRef<"Group", 'DateTime'>
    readonly domain_name: FieldRef<"Group", 'String'>
    readonly downtrend_cnt: FieldRef<"Group", 'Int'>
    readonly fk_user_id: FieldRef<"Group", 'Int'>
    readonly group_call_end: FieldRef<"Group", 'DateTime'>
    readonly group_call_start: FieldRef<"Group", 'DateTime'>
    readonly group_call_status: FieldRef<"Group", 'String'>
    readonly group_name: FieldRef<"Group", 'String'>
    readonly id_: FieldRef<"Group", 'Int'>
    readonly keyword_difficulty: FieldRef<"Group", 'String'>
    readonly metric_status: FieldRef<"Group", 'String'>
    readonly project_automation_time: FieldRef<"Group", 'DateTime'>
    readonly track_status: FieldRef<"Group", 'String'>
    readonly updated_date: FieldRef<"Group", 'DateTime'>
    readonly uptrend_cnt: FieldRef<"Group", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * Group findUnique
   */
  export type GroupFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Group
     */
    select?: GroupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Group
     */
    omit?: GroupOmit<ExtArgs> | null
    /**
     * Filter, which Group to fetch.
     */
    where: GroupWhereUniqueInput
  }

  /**
   * Group findUniqueOrThrow
   */
  export type GroupFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Group
     */
    select?: GroupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Group
     */
    omit?: GroupOmit<ExtArgs> | null
    /**
     * Filter, which Group to fetch.
     */
    where: GroupWhereUniqueInput
  }

  /**
   * Group findFirst
   */
  export type GroupFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Group
     */
    select?: GroupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Group
     */
    omit?: GroupOmit<ExtArgs> | null
    /**
     * Filter, which Group to fetch.
     */
    where?: GroupWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Groups to fetch.
     */
    orderBy?: GroupOrderByWithRelationInput | GroupOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Groups.
     */
    cursor?: GroupWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Groups from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Groups.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Groups.
     */
    distinct?: GroupScalarFieldEnum | GroupScalarFieldEnum[]
  }

  /**
   * Group findFirstOrThrow
   */
  export type GroupFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Group
     */
    select?: GroupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Group
     */
    omit?: GroupOmit<ExtArgs> | null
    /**
     * Filter, which Group to fetch.
     */
    where?: GroupWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Groups to fetch.
     */
    orderBy?: GroupOrderByWithRelationInput | GroupOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Groups.
     */
    cursor?: GroupWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Groups from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Groups.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Groups.
     */
    distinct?: GroupScalarFieldEnum | GroupScalarFieldEnum[]
  }

  /**
   * Group findMany
   */
  export type GroupFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Group
     */
    select?: GroupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Group
     */
    omit?: GroupOmit<ExtArgs> | null
    /**
     * Filter, which Groups to fetch.
     */
    where?: GroupWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Groups to fetch.
     */
    orderBy?: GroupOrderByWithRelationInput | GroupOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Groups.
     */
    cursor?: GroupWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Groups from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Groups.
     */
    skip?: number
    distinct?: GroupScalarFieldEnum | GroupScalarFieldEnum[]
  }

  /**
   * Group create
   */
  export type GroupCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Group
     */
    select?: GroupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Group
     */
    omit?: GroupOmit<ExtArgs> | null
    /**
     * The data needed to create a Group.
     */
    data: XOR<GroupCreateInput, GroupUncheckedCreateInput>
  }

  /**
   * Group createMany
   */
  export type GroupCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Groups.
     */
    data: GroupCreateManyInput | GroupCreateManyInput[]
  }

  /**
   * Group update
   */
  export type GroupUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Group
     */
    select?: GroupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Group
     */
    omit?: GroupOmit<ExtArgs> | null
    /**
     * The data needed to update a Group.
     */
    data: XOR<GroupUpdateInput, GroupUncheckedUpdateInput>
    /**
     * Choose, which Group to update.
     */
    where: GroupWhereUniqueInput
  }

  /**
   * Group updateMany
   */
  export type GroupUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Groups.
     */
    data: XOR<GroupUpdateManyMutationInput, GroupUncheckedUpdateManyInput>
    /**
     * Filter which Groups to update
     */
    where?: GroupWhereInput
    /**
     * Limit how many Groups to update.
     */
    limit?: number
  }

  /**
   * Group upsert
   */
  export type GroupUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Group
     */
    select?: GroupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Group
     */
    omit?: GroupOmit<ExtArgs> | null
    /**
     * The filter to search for the Group to update in case it exists.
     */
    where: GroupWhereUniqueInput
    /**
     * In case the Group found by the `where` argument doesn't exist, create a new Group with this data.
     */
    create: XOR<GroupCreateInput, GroupUncheckedCreateInput>
    /**
     * In case the Group was found with the provided `where` argument, update it with this data.
     */
    update: XOR<GroupUpdateInput, GroupUncheckedUpdateInput>
  }

  /**
   * Group delete
   */
  export type GroupDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Group
     */
    select?: GroupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Group
     */
    omit?: GroupOmit<ExtArgs> | null
    /**
     * Filter which Group to delete.
     */
    where: GroupWhereUniqueInput
  }

  /**
   * Group deleteMany
   */
  export type GroupDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Groups to delete
     */
    where?: GroupWhereInput
    /**
     * Limit how many Groups to delete.
     */
    limit?: number
  }

  /**
   * Group findRaw
   */
  export type GroupFindRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The query predicate filter. If unspecified, then all documents in the collection will match the predicate. ${@link https://docs.mongodb.com/manual/reference/operator/query MongoDB Docs}.
     */
    filter?: InputJsonValue
    /**
     * Additional options to pass to the `find` command ${@link https://docs.mongodb.com/manual/reference/command/find/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * Group aggregateRaw
   */
  export type GroupAggregateRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * An array of aggregation stages to process and transform the document stream via the aggregation pipeline. ${@link https://docs.mongodb.com/manual/reference/operator/aggregation-pipeline MongoDB Docs}.
     */
    pipeline?: InputJsonValue[]
    /**
     * Additional options to pass to the `aggregate` command ${@link https://docs.mongodb.com/manual/reference/command/aggregate/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * Group without action
   */
  export type GroupDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Group
     */
    select?: GroupSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Group
     */
    omit?: GroupOmit<ExtArgs> | null
  }


  /**
   * Model keyword
   */

  export type AggregateKeyword = {
    _count: KeywordCountAggregateOutputType | null
    _avg: KeywordAvgAggregateOutputType | null
    _sum: KeywordSumAggregateOutputType | null
    _min: KeywordMinAggregateOutputType | null
    _max: KeywordMaxAggregateOutputType | null
  }

  export type KeywordAvgAggregateOutputType = {
    auto_refresh_count: number | null
    dayval: number | null
    fk_group_id: number | null
    fk_user_id: number | null
    halfmonthval: number | null
    id_: number | null
    location_code: number | null
    monthval: number | null
    rank: number | null
    rank_sincestart: number | null
    ranknow: number | null
    top_rank: number | null
    weekval: number | null
  }

  export type KeywordSumAggregateOutputType = {
    auto_refresh_count: number | null
    dayval: number | null
    fk_group_id: number | null
    fk_user_id: number | null
    halfmonthval: number | null
    id_: number | null
    location_code: number | null
    monthval: number | null
    rank: number[]
    rank_sincestart: number | null
    ranknow: number | null
    top_rank: number | null
    weekval: number | null
  }

  export type KeywordMinAggregateOutputType = {
    id: string | null
    auto_call_status: string | null
    auto_refresh_count: number | null
    cpc: string | null
    crawlurl: string | null
    created_date: Date | null
    daymark: string | null
    dayval: number | null
    exactdomain: boolean | null
    fk_group_id: number | null
    fk_user_id: number | null
    halfmonthmark: string | null
    halfmonthval: number | null
    id_: number | null
    isocode: string | null
    keyword: string | null
    keyword_difficulty: string | null
    language: string | null
    language_code: string | null
    lastranked_date: Date | null
    location: string | null
    location_code: number | null
    metric_status: string | null
    modified_date: Date | null
    monthmark: string | null
    monthval: number | null
    page_uuid: string | null
    page_uuid_url: string | null
    platform: string | null
    rank_sincestart: number | null
    rank_trend: string | null
    ranked_url: string | null
    ranknow: number | null
    region: string | null
    search_intent: string | null
    search_volume: string | null
    site_url: string | null
    status_from_start: string | null
    target: string | null
    top_rank: number | null
    track_status: string | null
    traffic: string | null
    updated_date: Date | null
    weekmark: string | null
    weekval: number | null
  }

  export type KeywordMaxAggregateOutputType = {
    id: string | null
    auto_call_status: string | null
    auto_refresh_count: number | null
    cpc: string | null
    crawlurl: string | null
    created_date: Date | null
    daymark: string | null
    dayval: number | null
    exactdomain: boolean | null
    fk_group_id: number | null
    fk_user_id: number | null
    halfmonthmark: string | null
    halfmonthval: number | null
    id_: number | null
    isocode: string | null
    keyword: string | null
    keyword_difficulty: string | null
    language: string | null
    language_code: string | null
    lastranked_date: Date | null
    location: string | null
    location_code: number | null
    metric_status: string | null
    modified_date: Date | null
    monthmark: string | null
    monthval: number | null
    page_uuid: string | null
    page_uuid_url: string | null
    platform: string | null
    rank_sincestart: number | null
    rank_trend: string | null
    ranked_url: string | null
    ranknow: number | null
    region: string | null
    search_intent: string | null
    search_volume: string | null
    site_url: string | null
    status_from_start: string | null
    target: string | null
    top_rank: number | null
    track_status: string | null
    traffic: string | null
    updated_date: Date | null
    weekmark: string | null
    weekval: number | null
  }

  export type KeywordCountAggregateOutputType = {
    id: number
    auto_call_status: number
    auto_refresh_count: number
    cpc: number
    crawlurl: number
    created_date: number
    daymark: number
    dayval: number
    exactdomain: number
    fk_group_id: number
    fk_user_id: number
    halfmonthmark: number
    halfmonthval: number
    id_: number
    isocode: number
    keyword: number
    keyword_difficulty: number
    keyword_suggestions: number
    language: number
    language_code: number
    lastranked_date: number
    location: number
    location_code: number
    metric_status: number
    modified_date: number
    monthmark: number
    monthval: number
    page_uuid: number
    page_uuid_url: number
    platform: number
    rank: number
    rank_sincestart: number
    rank_trend: number
    ranked_url: number
    ranknow: number
    region: number
    search_intent: number
    search_volume: number
    site_url: number
    status_from_start: number
    target: number
    top_rank: number
    track_status: number
    traffic: number
    updated_date: number
    weekmark: number
    weekval: number
    _all: number
  }


  export type KeywordAvgAggregateInputType = {
    auto_refresh_count?: true
    dayval?: true
    fk_group_id?: true
    fk_user_id?: true
    halfmonthval?: true
    id_?: true
    location_code?: true
    monthval?: true
    rank?: true
    rank_sincestart?: true
    ranknow?: true
    top_rank?: true
    weekval?: true
  }

  export type KeywordSumAggregateInputType = {
    auto_refresh_count?: true
    dayval?: true
    fk_group_id?: true
    fk_user_id?: true
    halfmonthval?: true
    id_?: true
    location_code?: true
    monthval?: true
    rank?: true
    rank_sincestart?: true
    ranknow?: true
    top_rank?: true
    weekval?: true
  }

  export type KeywordMinAggregateInputType = {
    id?: true
    auto_call_status?: true
    auto_refresh_count?: true
    cpc?: true
    crawlurl?: true
    created_date?: true
    daymark?: true
    dayval?: true
    exactdomain?: true
    fk_group_id?: true
    fk_user_id?: true
    halfmonthmark?: true
    halfmonthval?: true
    id_?: true
    isocode?: true
    keyword?: true
    keyword_difficulty?: true
    language?: true
    language_code?: true
    lastranked_date?: true
    location?: true
    location_code?: true
    metric_status?: true
    modified_date?: true
    monthmark?: true
    monthval?: true
    page_uuid?: true
    page_uuid_url?: true
    platform?: true
    rank_sincestart?: true
    rank_trend?: true
    ranked_url?: true
    ranknow?: true
    region?: true
    search_intent?: true
    search_volume?: true
    site_url?: true
    status_from_start?: true
    target?: true
    top_rank?: true
    track_status?: true
    traffic?: true
    updated_date?: true
    weekmark?: true
    weekval?: true
  }

  export type KeywordMaxAggregateInputType = {
    id?: true
    auto_call_status?: true
    auto_refresh_count?: true
    cpc?: true
    crawlurl?: true
    created_date?: true
    daymark?: true
    dayval?: true
    exactdomain?: true
    fk_group_id?: true
    fk_user_id?: true
    halfmonthmark?: true
    halfmonthval?: true
    id_?: true
    isocode?: true
    keyword?: true
    keyword_difficulty?: true
    language?: true
    language_code?: true
    lastranked_date?: true
    location?: true
    location_code?: true
    metric_status?: true
    modified_date?: true
    monthmark?: true
    monthval?: true
    page_uuid?: true
    page_uuid_url?: true
    platform?: true
    rank_sincestart?: true
    rank_trend?: true
    ranked_url?: true
    ranknow?: true
    region?: true
    search_intent?: true
    search_volume?: true
    site_url?: true
    status_from_start?: true
    target?: true
    top_rank?: true
    track_status?: true
    traffic?: true
    updated_date?: true
    weekmark?: true
    weekval?: true
  }

  export type KeywordCountAggregateInputType = {
    id?: true
    auto_call_status?: true
    auto_refresh_count?: true
    cpc?: true
    crawlurl?: true
    created_date?: true
    daymark?: true
    dayval?: true
    exactdomain?: true
    fk_group_id?: true
    fk_user_id?: true
    halfmonthmark?: true
    halfmonthval?: true
    id_?: true
    isocode?: true
    keyword?: true
    keyword_difficulty?: true
    keyword_suggestions?: true
    language?: true
    language_code?: true
    lastranked_date?: true
    location?: true
    location_code?: true
    metric_status?: true
    modified_date?: true
    monthmark?: true
    monthval?: true
    page_uuid?: true
    page_uuid_url?: true
    platform?: true
    rank?: true
    rank_sincestart?: true
    rank_trend?: true
    ranked_url?: true
    ranknow?: true
    region?: true
    search_intent?: true
    search_volume?: true
    site_url?: true
    status_from_start?: true
    target?: true
    top_rank?: true
    track_status?: true
    traffic?: true
    updated_date?: true
    weekmark?: true
    weekval?: true
    _all?: true
  }

  export type KeywordAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which keyword to aggregate.
     */
    where?: keywordWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of keywords to fetch.
     */
    orderBy?: keywordOrderByWithRelationInput | keywordOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: keywordWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` keywords from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` keywords.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned keywords
    **/
    _count?: true | KeywordCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: KeywordAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: KeywordSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: KeywordMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: KeywordMaxAggregateInputType
  }

  export type GetKeywordAggregateType<T extends KeywordAggregateArgs> = {
        [P in keyof T & keyof AggregateKeyword]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateKeyword[P]>
      : GetScalarType<T[P], AggregateKeyword[P]>
  }




  export type keywordGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: keywordWhereInput
    orderBy?: keywordOrderByWithAggregationInput | keywordOrderByWithAggregationInput[]
    by: KeywordScalarFieldEnum[] | KeywordScalarFieldEnum
    having?: keywordScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: KeywordCountAggregateInputType | true
    _avg?: KeywordAvgAggregateInputType
    _sum?: KeywordSumAggregateInputType
    _min?: KeywordMinAggregateInputType
    _max?: KeywordMaxAggregateInputType
  }

  export type KeywordGroupByOutputType = {
    id: string
    auto_call_status: string
    auto_refresh_count: number
    cpc: string
    crawlurl: string
    created_date: Date
    daymark: string
    dayval: number
    exactdomain: boolean
    fk_group_id: number
    fk_user_id: number
    halfmonthmark: string
    halfmonthval: number
    id_: number
    isocode: string
    keyword: string
    keyword_difficulty: string | null
    keyword_suggestions: JsonValue | null
    language: string
    language_code: string
    lastranked_date: Date
    location: string
    location_code: number
    metric_status: string
    modified_date: Date
    monthmark: string
    monthval: number
    page_uuid: string
    page_uuid_url: string
    platform: string
    rank: number[]
    rank_sincestart: number
    rank_trend: string
    ranked_url: string
    ranknow: number
    region: string
    search_intent: string
    search_volume: string
    site_url: string
    status_from_start: string
    target: string
    top_rank: number
    track_status: string
    traffic: string
    updated_date: Date
    weekmark: string
    weekval: number
    _count: KeywordCountAggregateOutputType | null
    _avg: KeywordAvgAggregateOutputType | null
    _sum: KeywordSumAggregateOutputType | null
    _min: KeywordMinAggregateOutputType | null
    _max: KeywordMaxAggregateOutputType | null
  }

  type GetKeywordGroupByPayload<T extends keywordGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<KeywordGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof KeywordGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], KeywordGroupByOutputType[P]>
            : GetScalarType<T[P], KeywordGroupByOutputType[P]>
        }
      >
    >


  export type keywordSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    auto_call_status?: boolean
    auto_refresh_count?: boolean
    cpc?: boolean
    crawlurl?: boolean
    created_date?: boolean
    daymark?: boolean
    dayval?: boolean
    exactdomain?: boolean
    fk_group_id?: boolean
    fk_user_id?: boolean
    halfmonthmark?: boolean
    halfmonthval?: boolean
    id_?: boolean
    isocode?: boolean
    keyword?: boolean
    keyword_difficulty?: boolean
    keyword_suggestions?: boolean
    language?: boolean
    language_code?: boolean
    lastranked_date?: boolean
    location?: boolean
    location_code?: boolean
    metric_status?: boolean
    modified_date?: boolean
    monthmark?: boolean
    monthval?: boolean
    page_uuid?: boolean
    page_uuid_url?: boolean
    platform?: boolean
    rank?: boolean
    rank_history?: boolean | KeywordRankHistoryDefaultArgs<ExtArgs>
    rank_sincestart?: boolean
    rank_trend?: boolean
    ranked_url?: boolean
    ranknow?: boolean
    region?: boolean
    search_intent?: boolean
    search_volume?: boolean
    search_volume_data?: boolean | KeywordSearchVolumeDataDefaultArgs<ExtArgs>
    site_url?: boolean
    status_from_start?: boolean
    target?: boolean
    top_rank?: boolean
    track_status?: boolean
    traffic?: boolean
    updated_date?: boolean
    weekmark?: boolean
    weekval?: boolean
  }, ExtArgs["result"]["keyword"]>



  export type keywordSelectScalar = {
    id?: boolean
    auto_call_status?: boolean
    auto_refresh_count?: boolean
    cpc?: boolean
    crawlurl?: boolean
    created_date?: boolean
    daymark?: boolean
    dayval?: boolean
    exactdomain?: boolean
    fk_group_id?: boolean
    fk_user_id?: boolean
    halfmonthmark?: boolean
    halfmonthval?: boolean
    id_?: boolean
    isocode?: boolean
    keyword?: boolean
    keyword_difficulty?: boolean
    keyword_suggestions?: boolean
    language?: boolean
    language_code?: boolean
    lastranked_date?: boolean
    location?: boolean
    location_code?: boolean
    metric_status?: boolean
    modified_date?: boolean
    monthmark?: boolean
    monthval?: boolean
    page_uuid?: boolean
    page_uuid_url?: boolean
    platform?: boolean
    rank?: boolean
    rank_sincestart?: boolean
    rank_trend?: boolean
    ranked_url?: boolean
    ranknow?: boolean
    region?: boolean
    search_intent?: boolean
    search_volume?: boolean
    site_url?: boolean
    status_from_start?: boolean
    target?: boolean
    top_rank?: boolean
    track_status?: boolean
    traffic?: boolean
    updated_date?: boolean
    weekmark?: boolean
    weekval?: boolean
  }

  export type keywordOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "auto_call_status" | "auto_refresh_count" | "cpc" | "crawlurl" | "created_date" | "daymark" | "dayval" | "exactdomain" | "fk_group_id" | "fk_user_id" | "halfmonthmark" | "halfmonthval" | "id_" | "isocode" | "keyword" | "keyword_difficulty" | "keyword_suggestions" | "language" | "language_code" | "lastranked_date" | "location" | "location_code" | "metric_status" | "modified_date" | "monthmark" | "monthval" | "page_uuid" | "page_uuid_url" | "platform" | "rank" | "rank_history" | "rank_sincestart" | "rank_trend" | "ranked_url" | "ranknow" | "region" | "search_intent" | "search_volume" | "search_volume_data" | "site_url" | "status_from_start" | "target" | "top_rank" | "track_status" | "traffic" | "updated_date" | "weekmark" | "weekval", ExtArgs["result"]["keyword"]>
  export type keywordInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {}

  export type $keywordPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "keyword"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: string
      auto_call_status: string
      auto_refresh_count: number
      cpc: string
      crawlurl: string
      created_date: Date
      daymark: string
      dayval: number
      exactdomain: boolean
      fk_group_id: number
      fk_user_id: number
      halfmonthmark: string
      halfmonthval: number
      id_: number
      isocode: string
      keyword: string
      keyword_difficulty: string | null
      /**
       * Could not determine type: the field only had null or empty values in the sample set.
       */
      keyword_suggestions: Prisma.JsonValue | null
      language: string
      language_code: string
      lastranked_date: Date
      location: string
      location_code: number
      metric_status: string
      modified_date: Date
      monthmark: string
      monthval: number
      page_uuid: string
      page_uuid_url: string
      platform: string
      rank: number[]
      rank_sincestart: number
      rank_trend: string
      ranked_url: string
      ranknow: number
      region: string
      search_intent: string
      search_volume: string
      site_url: string
      status_from_start: string
      target: string
      top_rank: number
      track_status: string
      traffic: string
      updated_date: Date
      weekmark: string
      weekval: number
    }, ExtArgs["result"]["keyword"]>
    composites: {
      rank_history: Prisma.$KeywordRankHistoryPayload[]
      search_volume_data: Prisma.$KeywordSearchVolumeDataPayload[]
    }
  }

  type keywordGetPayload<S extends boolean | null | undefined | keywordDefaultArgs> = $Result.GetResult<Prisma.$keywordPayload, S>

  type keywordCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<keywordFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: KeywordCountAggregateInputType | true
    }

  export interface keywordDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['keyword'], meta: { name: 'keyword' } }
    /**
     * Find zero or one Keyword that matches the filter.
     * @param {keywordFindUniqueArgs} args - Arguments to find a Keyword
     * @example
     * // Get one Keyword
     * const keyword = await prisma.keyword.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends keywordFindUniqueArgs>(args: SelectSubset<T, keywordFindUniqueArgs<ExtArgs>>): Prisma__keywordClient<$Result.GetResult<Prisma.$keywordPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Keyword that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {keywordFindUniqueOrThrowArgs} args - Arguments to find a Keyword
     * @example
     * // Get one Keyword
     * const keyword = await prisma.keyword.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends keywordFindUniqueOrThrowArgs>(args: SelectSubset<T, keywordFindUniqueOrThrowArgs<ExtArgs>>): Prisma__keywordClient<$Result.GetResult<Prisma.$keywordPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Keyword that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {keywordFindFirstArgs} args - Arguments to find a Keyword
     * @example
     * // Get one Keyword
     * const keyword = await prisma.keyword.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends keywordFindFirstArgs>(args?: SelectSubset<T, keywordFindFirstArgs<ExtArgs>>): Prisma__keywordClient<$Result.GetResult<Prisma.$keywordPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Keyword that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {keywordFindFirstOrThrowArgs} args - Arguments to find a Keyword
     * @example
     * // Get one Keyword
     * const keyword = await prisma.keyword.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends keywordFindFirstOrThrowArgs>(args?: SelectSubset<T, keywordFindFirstOrThrowArgs<ExtArgs>>): Prisma__keywordClient<$Result.GetResult<Prisma.$keywordPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Keywords that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {keywordFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Keywords
     * const keywords = await prisma.keyword.findMany()
     * 
     * // Get first 10 Keywords
     * const keywords = await prisma.keyword.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const keywordWithIdOnly = await prisma.keyword.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends keywordFindManyArgs>(args?: SelectSubset<T, keywordFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$keywordPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Keyword.
     * @param {keywordCreateArgs} args - Arguments to create a Keyword.
     * @example
     * // Create one Keyword
     * const Keyword = await prisma.keyword.create({
     *   data: {
     *     // ... data to create a Keyword
     *   }
     * })
     * 
     */
    create<T extends keywordCreateArgs>(args: SelectSubset<T, keywordCreateArgs<ExtArgs>>): Prisma__keywordClient<$Result.GetResult<Prisma.$keywordPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Keywords.
     * @param {keywordCreateManyArgs} args - Arguments to create many Keywords.
     * @example
     * // Create many Keywords
     * const keyword = await prisma.keyword.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends keywordCreateManyArgs>(args?: SelectSubset<T, keywordCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Keyword.
     * @param {keywordDeleteArgs} args - Arguments to delete one Keyword.
     * @example
     * // Delete one Keyword
     * const Keyword = await prisma.keyword.delete({
     *   where: {
     *     // ... filter to delete one Keyword
     *   }
     * })
     * 
     */
    delete<T extends keywordDeleteArgs>(args: SelectSubset<T, keywordDeleteArgs<ExtArgs>>): Prisma__keywordClient<$Result.GetResult<Prisma.$keywordPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Keyword.
     * @param {keywordUpdateArgs} args - Arguments to update one Keyword.
     * @example
     * // Update one Keyword
     * const keyword = await prisma.keyword.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends keywordUpdateArgs>(args: SelectSubset<T, keywordUpdateArgs<ExtArgs>>): Prisma__keywordClient<$Result.GetResult<Prisma.$keywordPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Keywords.
     * @param {keywordDeleteManyArgs} args - Arguments to filter Keywords to delete.
     * @example
     * // Delete a few Keywords
     * const { count } = await prisma.keyword.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends keywordDeleteManyArgs>(args?: SelectSubset<T, keywordDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Keywords.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {keywordUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Keywords
     * const keyword = await prisma.keyword.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends keywordUpdateManyArgs>(args: SelectSubset<T, keywordUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Keyword.
     * @param {keywordUpsertArgs} args - Arguments to update or create a Keyword.
     * @example
     * // Update or create a Keyword
     * const keyword = await prisma.keyword.upsert({
     *   create: {
     *     // ... data to create a Keyword
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Keyword we want to update
     *   }
     * })
     */
    upsert<T extends keywordUpsertArgs>(args: SelectSubset<T, keywordUpsertArgs<ExtArgs>>): Prisma__keywordClient<$Result.GetResult<Prisma.$keywordPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Keywords that matches the filter.
     * @param {keywordFindRawArgs} args - Select which filters you would like to apply.
     * @example
     * const keyword = await prisma.keyword.findRaw({
     *   filter: { age: { $gt: 25 } }
     * })
     */
    findRaw(args?: keywordFindRawArgs): Prisma.PrismaPromise<JsonObject>

    /**
     * Perform aggregation operations on a Keyword.
     * @param {keywordAggregateRawArgs} args - Select which aggregations you would like to apply.
     * @example
     * const keyword = await prisma.keyword.aggregateRaw({
     *   pipeline: [
     *     { $match: { status: "registered" } },
     *     { $group: { _id: "$country", total: { $sum: 1 } } }
     *   ]
     * })
     */
    aggregateRaw(args?: keywordAggregateRawArgs): Prisma.PrismaPromise<JsonObject>


    /**
     * Count the number of Keywords.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {keywordCountArgs} args - Arguments to filter Keywords to count.
     * @example
     * // Count the number of Keywords
     * const count = await prisma.keyword.count({
     *   where: {
     *     // ... the filter for the Keywords we want to count
     *   }
     * })
    **/
    count<T extends keywordCountArgs>(
      args?: Subset<T, keywordCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], KeywordCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Keyword.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {KeywordAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends KeywordAggregateArgs>(args: Subset<T, KeywordAggregateArgs>): Prisma.PrismaPromise<GetKeywordAggregateType<T>>

    /**
     * Group by Keyword.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {keywordGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends keywordGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: keywordGroupByArgs['orderBy'] }
        : { orderBy?: keywordGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, keywordGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetKeywordGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the keyword model
   */
  readonly fields: keywordFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for keyword.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__keywordClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the keyword model
   */ 
  interface keywordFieldRefs {
    readonly id: FieldRef<"keyword", 'String'>
    readonly auto_call_status: FieldRef<"keyword", 'String'>
    readonly auto_refresh_count: FieldRef<"keyword", 'Int'>
    readonly cpc: FieldRef<"keyword", 'String'>
    readonly crawlurl: FieldRef<"keyword", 'String'>
    readonly created_date: FieldRef<"keyword", 'DateTime'>
    readonly daymark: FieldRef<"keyword", 'String'>
    readonly dayval: FieldRef<"keyword", 'Int'>
    readonly exactdomain: FieldRef<"keyword", 'Boolean'>
    readonly fk_group_id: FieldRef<"keyword", 'Int'>
    readonly fk_user_id: FieldRef<"keyword", 'Int'>
    readonly halfmonthmark: FieldRef<"keyword", 'String'>
    readonly halfmonthval: FieldRef<"keyword", 'Int'>
    readonly id_: FieldRef<"keyword", 'Int'>
    readonly isocode: FieldRef<"keyword", 'String'>
    readonly keyword: FieldRef<"keyword", 'String'>
    readonly keyword_difficulty: FieldRef<"keyword", 'String'>
    readonly keyword_suggestions: FieldRef<"keyword", 'Json'>
    readonly language: FieldRef<"keyword", 'String'>
    readonly language_code: FieldRef<"keyword", 'String'>
    readonly lastranked_date: FieldRef<"keyword", 'DateTime'>
    readonly location: FieldRef<"keyword", 'String'>
    readonly location_code: FieldRef<"keyword", 'Int'>
    readonly metric_status: FieldRef<"keyword", 'String'>
    readonly modified_date: FieldRef<"keyword", 'DateTime'>
    readonly monthmark: FieldRef<"keyword", 'String'>
    readonly monthval: FieldRef<"keyword", 'Int'>
    readonly page_uuid: FieldRef<"keyword", 'String'>
    readonly page_uuid_url: FieldRef<"keyword", 'String'>
    readonly platform: FieldRef<"keyword", 'String'>
    readonly rank: FieldRef<"keyword", 'Int[]'>
    readonly rank_sincestart: FieldRef<"keyword", 'Int'>
    readonly rank_trend: FieldRef<"keyword", 'String'>
    readonly ranked_url: FieldRef<"keyword", 'String'>
    readonly ranknow: FieldRef<"keyword", 'Int'>
    readonly region: FieldRef<"keyword", 'String'>
    readonly search_intent: FieldRef<"keyword", 'String'>
    readonly search_volume: FieldRef<"keyword", 'String'>
    readonly site_url: FieldRef<"keyword", 'String'>
    readonly status_from_start: FieldRef<"keyword", 'String'>
    readonly target: FieldRef<"keyword", 'String'>
    readonly top_rank: FieldRef<"keyword", 'Int'>
    readonly track_status: FieldRef<"keyword", 'String'>
    readonly traffic: FieldRef<"keyword", 'String'>
    readonly updated_date: FieldRef<"keyword", 'DateTime'>
    readonly weekmark: FieldRef<"keyword", 'String'>
    readonly weekval: FieldRef<"keyword", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * keyword findUnique
   */
  export type keywordFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the keyword
     */
    select?: keywordSelect<ExtArgs> | null
    /**
     * Omit specific fields from the keyword
     */
    omit?: keywordOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: keywordInclude<ExtArgs> | null
    /**
     * Filter, which keyword to fetch.
     */
    where: keywordWhereUniqueInput
  }

  /**
   * keyword findUniqueOrThrow
   */
  export type keywordFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the keyword
     */
    select?: keywordSelect<ExtArgs> | null
    /**
     * Omit specific fields from the keyword
     */
    omit?: keywordOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: keywordInclude<ExtArgs> | null
    /**
     * Filter, which keyword to fetch.
     */
    where: keywordWhereUniqueInput
  }

  /**
   * keyword findFirst
   */
  export type keywordFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the keyword
     */
    select?: keywordSelect<ExtArgs> | null
    /**
     * Omit specific fields from the keyword
     */
    omit?: keywordOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: keywordInclude<ExtArgs> | null
    /**
     * Filter, which keyword to fetch.
     */
    where?: keywordWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of keywords to fetch.
     */
    orderBy?: keywordOrderByWithRelationInput | keywordOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for keywords.
     */
    cursor?: keywordWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` keywords from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` keywords.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of keywords.
     */
    distinct?: KeywordScalarFieldEnum | KeywordScalarFieldEnum[]
  }

  /**
   * keyword findFirstOrThrow
   */
  export type keywordFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the keyword
     */
    select?: keywordSelect<ExtArgs> | null
    /**
     * Omit specific fields from the keyword
     */
    omit?: keywordOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: keywordInclude<ExtArgs> | null
    /**
     * Filter, which keyword to fetch.
     */
    where?: keywordWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of keywords to fetch.
     */
    orderBy?: keywordOrderByWithRelationInput | keywordOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for keywords.
     */
    cursor?: keywordWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` keywords from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` keywords.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of keywords.
     */
    distinct?: KeywordScalarFieldEnum | KeywordScalarFieldEnum[]
  }

  /**
   * keyword findMany
   */
  export type keywordFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the keyword
     */
    select?: keywordSelect<ExtArgs> | null
    /**
     * Omit specific fields from the keyword
     */
    omit?: keywordOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: keywordInclude<ExtArgs> | null
    /**
     * Filter, which keywords to fetch.
     */
    where?: keywordWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of keywords to fetch.
     */
    orderBy?: keywordOrderByWithRelationInput | keywordOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing keywords.
     */
    cursor?: keywordWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` keywords from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` keywords.
     */
    skip?: number
    distinct?: KeywordScalarFieldEnum | KeywordScalarFieldEnum[]
  }

  /**
   * keyword create
   */
  export type keywordCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the keyword
     */
    select?: keywordSelect<ExtArgs> | null
    /**
     * Omit specific fields from the keyword
     */
    omit?: keywordOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: keywordInclude<ExtArgs> | null
    /**
     * The data needed to create a keyword.
     */
    data: XOR<keywordCreateInput, keywordUncheckedCreateInput>
  }

  /**
   * keyword createMany
   */
  export type keywordCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many keywords.
     */
    data: keywordCreateManyInput | keywordCreateManyInput[]
  }

  /**
   * keyword update
   */
  export type keywordUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the keyword
     */
    select?: keywordSelect<ExtArgs> | null
    /**
     * Omit specific fields from the keyword
     */
    omit?: keywordOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: keywordInclude<ExtArgs> | null
    /**
     * The data needed to update a keyword.
     */
    data: XOR<keywordUpdateInput, keywordUncheckedUpdateInput>
    /**
     * Choose, which keyword to update.
     */
    where: keywordWhereUniqueInput
  }

  /**
   * keyword updateMany
   */
  export type keywordUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update keywords.
     */
    data: XOR<keywordUpdateManyMutationInput, keywordUncheckedUpdateManyInput>
    /**
     * Filter which keywords to update
     */
    where?: keywordWhereInput
    /**
     * Limit how many keywords to update.
     */
    limit?: number
  }

  /**
   * keyword upsert
   */
  export type keywordUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the keyword
     */
    select?: keywordSelect<ExtArgs> | null
    /**
     * Omit specific fields from the keyword
     */
    omit?: keywordOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: keywordInclude<ExtArgs> | null
    /**
     * The filter to search for the keyword to update in case it exists.
     */
    where: keywordWhereUniqueInput
    /**
     * In case the keyword found by the `where` argument doesn't exist, create a new keyword with this data.
     */
    create: XOR<keywordCreateInput, keywordUncheckedCreateInput>
    /**
     * In case the keyword was found with the provided `where` argument, update it with this data.
     */
    update: XOR<keywordUpdateInput, keywordUncheckedUpdateInput>
  }

  /**
   * keyword delete
   */
  export type keywordDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the keyword
     */
    select?: keywordSelect<ExtArgs> | null
    /**
     * Omit specific fields from the keyword
     */
    omit?: keywordOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: keywordInclude<ExtArgs> | null
    /**
     * Filter which keyword to delete.
     */
    where: keywordWhereUniqueInput
  }

  /**
   * keyword deleteMany
   */
  export type keywordDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which keywords to delete
     */
    where?: keywordWhereInput
    /**
     * Limit how many keywords to delete.
     */
    limit?: number
  }

  /**
   * keyword findRaw
   */
  export type keywordFindRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The query predicate filter. If unspecified, then all documents in the collection will match the predicate. ${@link https://docs.mongodb.com/manual/reference/operator/query MongoDB Docs}.
     */
    filter?: InputJsonValue
    /**
     * Additional options to pass to the `find` command ${@link https://docs.mongodb.com/manual/reference/command/find/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * keyword aggregateRaw
   */
  export type keywordAggregateRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * An array of aggregation stages to process and transform the document stream via the aggregation pipeline. ${@link https://docs.mongodb.com/manual/reference/operator/aggregation-pipeline MongoDB Docs}.
     */
    pipeline?: InputJsonValue[]
    /**
     * Additional options to pass to the `aggregate` command ${@link https://docs.mongodb.com/manual/reference/command/aggregate/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * keyword without action
   */
  export type keywordDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the keyword
     */
    select?: keywordSelect<ExtArgs> | null
    /**
     * Omit specific fields from the keyword
     */
    omit?: keywordOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: keywordInclude<ExtArgs> | null
  }


  /**
   * Model keyword_metrics
   */

  export type AggregateKeyword_metrics = {
    _count: Keyword_metricsCountAggregateOutputType | null
    _min: Keyword_metricsMinAggregateOutputType | null
    _max: Keyword_metricsMaxAggregateOutputType | null
  }

  export type Keyword_metricsMinAggregateOutputType = {
    mongoId: string | null
  }

  export type Keyword_metricsMaxAggregateOutputType = {
    mongoId: string | null
  }

  export type Keyword_metricsCountAggregateOutputType = {
    mongoId: number
    fk_group_id: number
    fk_keyword_id: number
    fk_user_id: number
    id: number
    _all: number
  }


  export type Keyword_metricsMinAggregateInputType = {
    mongoId?: true
  }

  export type Keyword_metricsMaxAggregateInputType = {
    mongoId?: true
  }

  export type Keyword_metricsCountAggregateInputType = {
    mongoId?: true
    fk_group_id?: true
    fk_keyword_id?: true
    fk_user_id?: true
    id?: true
    _all?: true
  }

  export type Keyword_metricsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which keyword_metrics to aggregate.
     */
    where?: keyword_metricsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of keyword_metrics to fetch.
     */
    orderBy?: keyword_metricsOrderByWithRelationInput | keyword_metricsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: keyword_metricsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` keyword_metrics from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` keyword_metrics.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned keyword_metrics
    **/
    _count?: true | Keyword_metricsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Keyword_metricsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Keyword_metricsMaxAggregateInputType
  }

  export type GetKeyword_metricsAggregateType<T extends Keyword_metricsAggregateArgs> = {
        [P in keyof T & keyof AggregateKeyword_metrics]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateKeyword_metrics[P]>
      : GetScalarType<T[P], AggregateKeyword_metrics[P]>
  }




  export type keyword_metricsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: keyword_metricsWhereInput
    orderBy?: keyword_metricsOrderByWithAggregationInput | keyword_metricsOrderByWithAggregationInput[]
    by: Keyword_metricsScalarFieldEnum[] | Keyword_metricsScalarFieldEnum
    having?: keyword_metricsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Keyword_metricsCountAggregateInputType | true
    _min?: Keyword_metricsMinAggregateInputType
    _max?: Keyword_metricsMaxAggregateInputType
  }

  export type Keyword_metricsGroupByOutputType = {
    mongoId: string
    fk_group_id: JsonValue | null
    fk_keyword_id: JsonValue | null
    fk_user_id: JsonValue | null
    id: JsonValue | null
    _count: Keyword_metricsCountAggregateOutputType | null
    _min: Keyword_metricsMinAggregateOutputType | null
    _max: Keyword_metricsMaxAggregateOutputType | null
  }

  type GetKeyword_metricsGroupByPayload<T extends keyword_metricsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Keyword_metricsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Keyword_metricsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Keyword_metricsGroupByOutputType[P]>
            : GetScalarType<T[P], Keyword_metricsGroupByOutputType[P]>
        }
      >
    >


  export type keyword_metricsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    mongoId?: boolean
    fk_group_id?: boolean
    fk_keyword_id?: boolean
    fk_user_id?: boolean
    id?: boolean
  }, ExtArgs["result"]["keyword_metrics"]>



  export type keyword_metricsSelectScalar = {
    mongoId?: boolean
    fk_group_id?: boolean
    fk_keyword_id?: boolean
    fk_user_id?: boolean
    id?: boolean
  }

  export type keyword_metricsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"mongoId" | "fk_group_id" | "fk_keyword_id" | "fk_user_id" | "id", ExtArgs["result"]["keyword_metrics"]>

  export type $keyword_metricsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "keyword_metrics"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      mongoId: string
      /**
       * Field referred in an index, but found no data to define the type.
       */
      fk_group_id: Prisma.JsonValue | null
      /**
       * Field referred in an index, but found no data to define the type.
       */
      fk_keyword_id: Prisma.JsonValue | null
      /**
       * Field referred in an index, but found no data to define the type.
       */
      fk_user_id: Prisma.JsonValue | null
      /**
       * Field referred in an index, but found no data to define the type.
       */
      id: Prisma.JsonValue | null
    }, ExtArgs["result"]["keyword_metrics"]>
    composites: {}
  }

  type keyword_metricsGetPayload<S extends boolean | null | undefined | keyword_metricsDefaultArgs> = $Result.GetResult<Prisma.$keyword_metricsPayload, S>

  type keyword_metricsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<keyword_metricsFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Keyword_metricsCountAggregateInputType | true
    }

  export interface keyword_metricsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['keyword_metrics'], meta: { name: 'keyword_metrics' } }
    /**
     * Find zero or one Keyword_metrics that matches the filter.
     * @param {keyword_metricsFindUniqueArgs} args - Arguments to find a Keyword_metrics
     * @example
     * // Get one Keyword_metrics
     * const keyword_metrics = await prisma.keyword_metrics.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends keyword_metricsFindUniqueArgs>(args: SelectSubset<T, keyword_metricsFindUniqueArgs<ExtArgs>>): Prisma__keyword_metricsClient<$Result.GetResult<Prisma.$keyword_metricsPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Keyword_metrics that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {keyword_metricsFindUniqueOrThrowArgs} args - Arguments to find a Keyword_metrics
     * @example
     * // Get one Keyword_metrics
     * const keyword_metrics = await prisma.keyword_metrics.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends keyword_metricsFindUniqueOrThrowArgs>(args: SelectSubset<T, keyword_metricsFindUniqueOrThrowArgs<ExtArgs>>): Prisma__keyword_metricsClient<$Result.GetResult<Prisma.$keyword_metricsPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Keyword_metrics that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {keyword_metricsFindFirstArgs} args - Arguments to find a Keyword_metrics
     * @example
     * // Get one Keyword_metrics
     * const keyword_metrics = await prisma.keyword_metrics.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends keyword_metricsFindFirstArgs>(args?: SelectSubset<T, keyword_metricsFindFirstArgs<ExtArgs>>): Prisma__keyword_metricsClient<$Result.GetResult<Prisma.$keyword_metricsPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Keyword_metrics that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {keyword_metricsFindFirstOrThrowArgs} args - Arguments to find a Keyword_metrics
     * @example
     * // Get one Keyword_metrics
     * const keyword_metrics = await prisma.keyword_metrics.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends keyword_metricsFindFirstOrThrowArgs>(args?: SelectSubset<T, keyword_metricsFindFirstOrThrowArgs<ExtArgs>>): Prisma__keyword_metricsClient<$Result.GetResult<Prisma.$keyword_metricsPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Keyword_metrics that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {keyword_metricsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Keyword_metrics
     * const keyword_metrics = await prisma.keyword_metrics.findMany()
     * 
     * // Get first 10 Keyword_metrics
     * const keyword_metrics = await prisma.keyword_metrics.findMany({ take: 10 })
     * 
     * // Only select the `mongoId`
     * const keyword_metricsWithMongoIdOnly = await prisma.keyword_metrics.findMany({ select: { mongoId: true } })
     * 
     */
    findMany<T extends keyword_metricsFindManyArgs>(args?: SelectSubset<T, keyword_metricsFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$keyword_metricsPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Keyword_metrics.
     * @param {keyword_metricsCreateArgs} args - Arguments to create a Keyword_metrics.
     * @example
     * // Create one Keyword_metrics
     * const Keyword_metrics = await prisma.keyword_metrics.create({
     *   data: {
     *     // ... data to create a Keyword_metrics
     *   }
     * })
     * 
     */
    create<T extends keyword_metricsCreateArgs>(args: SelectSubset<T, keyword_metricsCreateArgs<ExtArgs>>): Prisma__keyword_metricsClient<$Result.GetResult<Prisma.$keyword_metricsPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Keyword_metrics.
     * @param {keyword_metricsCreateManyArgs} args - Arguments to create many Keyword_metrics.
     * @example
     * // Create many Keyword_metrics
     * const keyword_metrics = await prisma.keyword_metrics.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends keyword_metricsCreateManyArgs>(args?: SelectSubset<T, keyword_metricsCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Keyword_metrics.
     * @param {keyword_metricsDeleteArgs} args - Arguments to delete one Keyword_metrics.
     * @example
     * // Delete one Keyword_metrics
     * const Keyword_metrics = await prisma.keyword_metrics.delete({
     *   where: {
     *     // ... filter to delete one Keyword_metrics
     *   }
     * })
     * 
     */
    delete<T extends keyword_metricsDeleteArgs>(args: SelectSubset<T, keyword_metricsDeleteArgs<ExtArgs>>): Prisma__keyword_metricsClient<$Result.GetResult<Prisma.$keyword_metricsPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Keyword_metrics.
     * @param {keyword_metricsUpdateArgs} args - Arguments to update one Keyword_metrics.
     * @example
     * // Update one Keyword_metrics
     * const keyword_metrics = await prisma.keyword_metrics.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends keyword_metricsUpdateArgs>(args: SelectSubset<T, keyword_metricsUpdateArgs<ExtArgs>>): Prisma__keyword_metricsClient<$Result.GetResult<Prisma.$keyword_metricsPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Keyword_metrics.
     * @param {keyword_metricsDeleteManyArgs} args - Arguments to filter Keyword_metrics to delete.
     * @example
     * // Delete a few Keyword_metrics
     * const { count } = await prisma.keyword_metrics.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends keyword_metricsDeleteManyArgs>(args?: SelectSubset<T, keyword_metricsDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Keyword_metrics.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {keyword_metricsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Keyword_metrics
     * const keyword_metrics = await prisma.keyword_metrics.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends keyword_metricsUpdateManyArgs>(args: SelectSubset<T, keyword_metricsUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Keyword_metrics.
     * @param {keyword_metricsUpsertArgs} args - Arguments to update or create a Keyword_metrics.
     * @example
     * // Update or create a Keyword_metrics
     * const keyword_metrics = await prisma.keyword_metrics.upsert({
     *   create: {
     *     // ... data to create a Keyword_metrics
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Keyword_metrics we want to update
     *   }
     * })
     */
    upsert<T extends keyword_metricsUpsertArgs>(args: SelectSubset<T, keyword_metricsUpsertArgs<ExtArgs>>): Prisma__keyword_metricsClient<$Result.GetResult<Prisma.$keyword_metricsPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Keyword_metrics that matches the filter.
     * @param {keyword_metricsFindRawArgs} args - Select which filters you would like to apply.
     * @example
     * const keyword_metrics = await prisma.keyword_metrics.findRaw({
     *   filter: { age: { $gt: 25 } }
     * })
     */
    findRaw(args?: keyword_metricsFindRawArgs): Prisma.PrismaPromise<JsonObject>

    /**
     * Perform aggregation operations on a Keyword_metrics.
     * @param {keyword_metricsAggregateRawArgs} args - Select which aggregations you would like to apply.
     * @example
     * const keyword_metrics = await prisma.keyword_metrics.aggregateRaw({
     *   pipeline: [
     *     { $match: { status: "registered" } },
     *     { $group: { _id: "$country", total: { $sum: 1 } } }
     *   ]
     * })
     */
    aggregateRaw(args?: keyword_metricsAggregateRawArgs): Prisma.PrismaPromise<JsonObject>


    /**
     * Count the number of Keyword_metrics.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {keyword_metricsCountArgs} args - Arguments to filter Keyword_metrics to count.
     * @example
     * // Count the number of Keyword_metrics
     * const count = await prisma.keyword_metrics.count({
     *   where: {
     *     // ... the filter for the Keyword_metrics we want to count
     *   }
     * })
    **/
    count<T extends keyword_metricsCountArgs>(
      args?: Subset<T, keyword_metricsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Keyword_metricsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Keyword_metrics.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Keyword_metricsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Keyword_metricsAggregateArgs>(args: Subset<T, Keyword_metricsAggregateArgs>): Prisma.PrismaPromise<GetKeyword_metricsAggregateType<T>>

    /**
     * Group by Keyword_metrics.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {keyword_metricsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends keyword_metricsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: keyword_metricsGroupByArgs['orderBy'] }
        : { orderBy?: keyword_metricsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, keyword_metricsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetKeyword_metricsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the keyword_metrics model
   */
  readonly fields: keyword_metricsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for keyword_metrics.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__keyword_metricsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the keyword_metrics model
   */ 
  interface keyword_metricsFieldRefs {
    readonly mongoId: FieldRef<"keyword_metrics", 'String'>
    readonly fk_group_id: FieldRef<"keyword_metrics", 'Json'>
    readonly fk_keyword_id: FieldRef<"keyword_metrics", 'Json'>
    readonly fk_user_id: FieldRef<"keyword_metrics", 'Json'>
    readonly id: FieldRef<"keyword_metrics", 'Json'>
  }
    

  // Custom InputTypes
  /**
   * keyword_metrics findUnique
   */
  export type keyword_metricsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the keyword_metrics
     */
    select?: keyword_metricsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the keyword_metrics
     */
    omit?: keyword_metricsOmit<ExtArgs> | null
    /**
     * Filter, which keyword_metrics to fetch.
     */
    where: keyword_metricsWhereUniqueInput
  }

  /**
   * keyword_metrics findUniqueOrThrow
   */
  export type keyword_metricsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the keyword_metrics
     */
    select?: keyword_metricsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the keyword_metrics
     */
    omit?: keyword_metricsOmit<ExtArgs> | null
    /**
     * Filter, which keyword_metrics to fetch.
     */
    where: keyword_metricsWhereUniqueInput
  }

  /**
   * keyword_metrics findFirst
   */
  export type keyword_metricsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the keyword_metrics
     */
    select?: keyword_metricsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the keyword_metrics
     */
    omit?: keyword_metricsOmit<ExtArgs> | null
    /**
     * Filter, which keyword_metrics to fetch.
     */
    where?: keyword_metricsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of keyword_metrics to fetch.
     */
    orderBy?: keyword_metricsOrderByWithRelationInput | keyword_metricsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for keyword_metrics.
     */
    cursor?: keyword_metricsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` keyword_metrics from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` keyword_metrics.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of keyword_metrics.
     */
    distinct?: Keyword_metricsScalarFieldEnum | Keyword_metricsScalarFieldEnum[]
  }

  /**
   * keyword_metrics findFirstOrThrow
   */
  export type keyword_metricsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the keyword_metrics
     */
    select?: keyword_metricsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the keyword_metrics
     */
    omit?: keyword_metricsOmit<ExtArgs> | null
    /**
     * Filter, which keyword_metrics to fetch.
     */
    where?: keyword_metricsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of keyword_metrics to fetch.
     */
    orderBy?: keyword_metricsOrderByWithRelationInput | keyword_metricsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for keyword_metrics.
     */
    cursor?: keyword_metricsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` keyword_metrics from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` keyword_metrics.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of keyword_metrics.
     */
    distinct?: Keyword_metricsScalarFieldEnum | Keyword_metricsScalarFieldEnum[]
  }

  /**
   * keyword_metrics findMany
   */
  export type keyword_metricsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the keyword_metrics
     */
    select?: keyword_metricsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the keyword_metrics
     */
    omit?: keyword_metricsOmit<ExtArgs> | null
    /**
     * Filter, which keyword_metrics to fetch.
     */
    where?: keyword_metricsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of keyword_metrics to fetch.
     */
    orderBy?: keyword_metricsOrderByWithRelationInput | keyword_metricsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing keyword_metrics.
     */
    cursor?: keyword_metricsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` keyword_metrics from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` keyword_metrics.
     */
    skip?: number
    distinct?: Keyword_metricsScalarFieldEnum | Keyword_metricsScalarFieldEnum[]
  }

  /**
   * keyword_metrics create
   */
  export type keyword_metricsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the keyword_metrics
     */
    select?: keyword_metricsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the keyword_metrics
     */
    omit?: keyword_metricsOmit<ExtArgs> | null
    /**
     * The data needed to create a keyword_metrics.
     */
    data?: XOR<keyword_metricsCreateInput, keyword_metricsUncheckedCreateInput>
  }

  /**
   * keyword_metrics createMany
   */
  export type keyword_metricsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many keyword_metrics.
     */
    data: keyword_metricsCreateManyInput | keyword_metricsCreateManyInput[]
  }

  /**
   * keyword_metrics update
   */
  export type keyword_metricsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the keyword_metrics
     */
    select?: keyword_metricsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the keyword_metrics
     */
    omit?: keyword_metricsOmit<ExtArgs> | null
    /**
     * The data needed to update a keyword_metrics.
     */
    data: XOR<keyword_metricsUpdateInput, keyword_metricsUncheckedUpdateInput>
    /**
     * Choose, which keyword_metrics to update.
     */
    where: keyword_metricsWhereUniqueInput
  }

  /**
   * keyword_metrics updateMany
   */
  export type keyword_metricsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update keyword_metrics.
     */
    data: XOR<keyword_metricsUpdateManyMutationInput, keyword_metricsUncheckedUpdateManyInput>
    /**
     * Filter which keyword_metrics to update
     */
    where?: keyword_metricsWhereInput
    /**
     * Limit how many keyword_metrics to update.
     */
    limit?: number
  }

  /**
   * keyword_metrics upsert
   */
  export type keyword_metricsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the keyword_metrics
     */
    select?: keyword_metricsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the keyword_metrics
     */
    omit?: keyword_metricsOmit<ExtArgs> | null
    /**
     * The filter to search for the keyword_metrics to update in case it exists.
     */
    where: keyword_metricsWhereUniqueInput
    /**
     * In case the keyword_metrics found by the `where` argument doesn't exist, create a new keyword_metrics with this data.
     */
    create: XOR<keyword_metricsCreateInput, keyword_metricsUncheckedCreateInput>
    /**
     * In case the keyword_metrics was found with the provided `where` argument, update it with this data.
     */
    update: XOR<keyword_metricsUpdateInput, keyword_metricsUncheckedUpdateInput>
  }

  /**
   * keyword_metrics delete
   */
  export type keyword_metricsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the keyword_metrics
     */
    select?: keyword_metricsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the keyword_metrics
     */
    omit?: keyword_metricsOmit<ExtArgs> | null
    /**
     * Filter which keyword_metrics to delete.
     */
    where: keyword_metricsWhereUniqueInput
  }

  /**
   * keyword_metrics deleteMany
   */
  export type keyword_metricsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which keyword_metrics to delete
     */
    where?: keyword_metricsWhereInput
    /**
     * Limit how many keyword_metrics to delete.
     */
    limit?: number
  }

  /**
   * keyword_metrics findRaw
   */
  export type keyword_metricsFindRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The query predicate filter. If unspecified, then all documents in the collection will match the predicate. ${@link https://docs.mongodb.com/manual/reference/operator/query MongoDB Docs}.
     */
    filter?: InputJsonValue
    /**
     * Additional options to pass to the `find` command ${@link https://docs.mongodb.com/manual/reference/command/find/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * keyword_metrics aggregateRaw
   */
  export type keyword_metricsAggregateRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * An array of aggregation stages to process and transform the document stream via the aggregation pipeline. ${@link https://docs.mongodb.com/manual/reference/operator/aggregation-pipeline MongoDB Docs}.
     */
    pipeline?: InputJsonValue[]
    /**
     * Additional options to pass to the `aggregate` command ${@link https://docs.mongodb.com/manual/reference/command/aggregate/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * keyword_metrics without action
   */
  export type keyword_metricsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the keyword_metrics
     */
    select?: keyword_metricsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the keyword_metrics
     */
    omit?: keyword_metricsOmit<ExtArgs> | null
  }


  /**
   * Model language
   */

  export type AggregateLanguage = {
    _count: LanguageCountAggregateOutputType | null
    _avg: LanguageAvgAggregateOutputType | null
    _sum: LanguageSumAggregateOutputType | null
    _min: LanguageMinAggregateOutputType | null
    _max: LanguageMaxAggregateOutputType | null
  }

  export type LanguageAvgAggregateOutputType = {
    id_: number | null
  }

  export type LanguageSumAggregateOutputType = {
    id_: number | null
  }

  export type LanguageMinAggregateOutputType = {
    id: string | null
    created_date: Date | null
    id_: number | null
    language_code: string | null
    language_name: string | null
    updated_date: Date | null
  }

  export type LanguageMaxAggregateOutputType = {
    id: string | null
    created_date: Date | null
    id_: number | null
    language_code: string | null
    language_name: string | null
    updated_date: Date | null
  }

  export type LanguageCountAggregateOutputType = {
    id: number
    created_date: number
    id_: number
    language_code: number
    language_name: number
    updated_date: number
    _all: number
  }


  export type LanguageAvgAggregateInputType = {
    id_?: true
  }

  export type LanguageSumAggregateInputType = {
    id_?: true
  }

  export type LanguageMinAggregateInputType = {
    id?: true
    created_date?: true
    id_?: true
    language_code?: true
    language_name?: true
    updated_date?: true
  }

  export type LanguageMaxAggregateInputType = {
    id?: true
    created_date?: true
    id_?: true
    language_code?: true
    language_name?: true
    updated_date?: true
  }

  export type LanguageCountAggregateInputType = {
    id?: true
    created_date?: true
    id_?: true
    language_code?: true
    language_name?: true
    updated_date?: true
    _all?: true
  }

  export type LanguageAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which language to aggregate.
     */
    where?: languageWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of languages to fetch.
     */
    orderBy?: languageOrderByWithRelationInput | languageOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: languageWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` languages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` languages.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned languages
    **/
    _count?: true | LanguageCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: LanguageAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: LanguageSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: LanguageMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: LanguageMaxAggregateInputType
  }

  export type GetLanguageAggregateType<T extends LanguageAggregateArgs> = {
        [P in keyof T & keyof AggregateLanguage]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateLanguage[P]>
      : GetScalarType<T[P], AggregateLanguage[P]>
  }




  export type languageGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: languageWhereInput
    orderBy?: languageOrderByWithAggregationInput | languageOrderByWithAggregationInput[]
    by: LanguageScalarFieldEnum[] | LanguageScalarFieldEnum
    having?: languageScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: LanguageCountAggregateInputType | true
    _avg?: LanguageAvgAggregateInputType
    _sum?: LanguageSumAggregateInputType
    _min?: LanguageMinAggregateInputType
    _max?: LanguageMaxAggregateInputType
  }

  export type LanguageGroupByOutputType = {
    id: string
    created_date: Date
    id_: number
    language_code: string
    language_name: string
    updated_date: Date
    _count: LanguageCountAggregateOutputType | null
    _avg: LanguageAvgAggregateOutputType | null
    _sum: LanguageSumAggregateOutputType | null
    _min: LanguageMinAggregateOutputType | null
    _max: LanguageMaxAggregateOutputType | null
  }

  type GetLanguageGroupByPayload<T extends languageGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<LanguageGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof LanguageGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], LanguageGroupByOutputType[P]>
            : GetScalarType<T[P], LanguageGroupByOutputType[P]>
        }
      >
    >


  export type languageSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    created_date?: boolean
    id_?: boolean
    language_code?: boolean
    language_name?: boolean
    updated_date?: boolean
  }, ExtArgs["result"]["language"]>



  export type languageSelectScalar = {
    id?: boolean
    created_date?: boolean
    id_?: boolean
    language_code?: boolean
    language_name?: boolean
    updated_date?: boolean
  }

  export type languageOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "created_date" | "id_" | "language_code" | "language_name" | "updated_date", ExtArgs["result"]["language"]>

  export type $languagePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "language"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: string
      created_date: Date
      id_: number
      language_code: string
      language_name: string
      updated_date: Date
    }, ExtArgs["result"]["language"]>
    composites: {}
  }

  type languageGetPayload<S extends boolean | null | undefined | languageDefaultArgs> = $Result.GetResult<Prisma.$languagePayload, S>

  type languageCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<languageFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: LanguageCountAggregateInputType | true
    }

  export interface languageDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['language'], meta: { name: 'language' } }
    /**
     * Find zero or one Language that matches the filter.
     * @param {languageFindUniqueArgs} args - Arguments to find a Language
     * @example
     * // Get one Language
     * const language = await prisma.language.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends languageFindUniqueArgs>(args: SelectSubset<T, languageFindUniqueArgs<ExtArgs>>): Prisma__languageClient<$Result.GetResult<Prisma.$languagePayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Language that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {languageFindUniqueOrThrowArgs} args - Arguments to find a Language
     * @example
     * // Get one Language
     * const language = await prisma.language.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends languageFindUniqueOrThrowArgs>(args: SelectSubset<T, languageFindUniqueOrThrowArgs<ExtArgs>>): Prisma__languageClient<$Result.GetResult<Prisma.$languagePayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Language that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {languageFindFirstArgs} args - Arguments to find a Language
     * @example
     * // Get one Language
     * const language = await prisma.language.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends languageFindFirstArgs>(args?: SelectSubset<T, languageFindFirstArgs<ExtArgs>>): Prisma__languageClient<$Result.GetResult<Prisma.$languagePayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Language that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {languageFindFirstOrThrowArgs} args - Arguments to find a Language
     * @example
     * // Get one Language
     * const language = await prisma.language.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends languageFindFirstOrThrowArgs>(args?: SelectSubset<T, languageFindFirstOrThrowArgs<ExtArgs>>): Prisma__languageClient<$Result.GetResult<Prisma.$languagePayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Languages that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {languageFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Languages
     * const languages = await prisma.language.findMany()
     * 
     * // Get first 10 Languages
     * const languages = await prisma.language.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const languageWithIdOnly = await prisma.language.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends languageFindManyArgs>(args?: SelectSubset<T, languageFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$languagePayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Language.
     * @param {languageCreateArgs} args - Arguments to create a Language.
     * @example
     * // Create one Language
     * const Language = await prisma.language.create({
     *   data: {
     *     // ... data to create a Language
     *   }
     * })
     * 
     */
    create<T extends languageCreateArgs>(args: SelectSubset<T, languageCreateArgs<ExtArgs>>): Prisma__languageClient<$Result.GetResult<Prisma.$languagePayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Languages.
     * @param {languageCreateManyArgs} args - Arguments to create many Languages.
     * @example
     * // Create many Languages
     * const language = await prisma.language.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends languageCreateManyArgs>(args?: SelectSubset<T, languageCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Language.
     * @param {languageDeleteArgs} args - Arguments to delete one Language.
     * @example
     * // Delete one Language
     * const Language = await prisma.language.delete({
     *   where: {
     *     // ... filter to delete one Language
     *   }
     * })
     * 
     */
    delete<T extends languageDeleteArgs>(args: SelectSubset<T, languageDeleteArgs<ExtArgs>>): Prisma__languageClient<$Result.GetResult<Prisma.$languagePayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Language.
     * @param {languageUpdateArgs} args - Arguments to update one Language.
     * @example
     * // Update one Language
     * const language = await prisma.language.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends languageUpdateArgs>(args: SelectSubset<T, languageUpdateArgs<ExtArgs>>): Prisma__languageClient<$Result.GetResult<Prisma.$languagePayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Languages.
     * @param {languageDeleteManyArgs} args - Arguments to filter Languages to delete.
     * @example
     * // Delete a few Languages
     * const { count } = await prisma.language.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends languageDeleteManyArgs>(args?: SelectSubset<T, languageDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Languages.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {languageUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Languages
     * const language = await prisma.language.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends languageUpdateManyArgs>(args: SelectSubset<T, languageUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Language.
     * @param {languageUpsertArgs} args - Arguments to update or create a Language.
     * @example
     * // Update or create a Language
     * const language = await prisma.language.upsert({
     *   create: {
     *     // ... data to create a Language
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Language we want to update
     *   }
     * })
     */
    upsert<T extends languageUpsertArgs>(args: SelectSubset<T, languageUpsertArgs<ExtArgs>>): Prisma__languageClient<$Result.GetResult<Prisma.$languagePayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Languages that matches the filter.
     * @param {languageFindRawArgs} args - Select which filters you would like to apply.
     * @example
     * const language = await prisma.language.findRaw({
     *   filter: { age: { $gt: 25 } }
     * })
     */
    findRaw(args?: languageFindRawArgs): Prisma.PrismaPromise<JsonObject>

    /**
     * Perform aggregation operations on a Language.
     * @param {languageAggregateRawArgs} args - Select which aggregations you would like to apply.
     * @example
     * const language = await prisma.language.aggregateRaw({
     *   pipeline: [
     *     { $match: { status: "registered" } },
     *     { $group: { _id: "$country", total: { $sum: 1 } } }
     *   ]
     * })
     */
    aggregateRaw(args?: languageAggregateRawArgs): Prisma.PrismaPromise<JsonObject>


    /**
     * Count the number of Languages.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {languageCountArgs} args - Arguments to filter Languages to count.
     * @example
     * // Count the number of Languages
     * const count = await prisma.language.count({
     *   where: {
     *     // ... the filter for the Languages we want to count
     *   }
     * })
    **/
    count<T extends languageCountArgs>(
      args?: Subset<T, languageCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], LanguageCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Language.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {LanguageAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends LanguageAggregateArgs>(args: Subset<T, LanguageAggregateArgs>): Prisma.PrismaPromise<GetLanguageAggregateType<T>>

    /**
     * Group by Language.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {languageGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends languageGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: languageGroupByArgs['orderBy'] }
        : { orderBy?: languageGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, languageGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetLanguageGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the language model
   */
  readonly fields: languageFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for language.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__languageClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the language model
   */ 
  interface languageFieldRefs {
    readonly id: FieldRef<"language", 'String'>
    readonly created_date: FieldRef<"language", 'DateTime'>
    readonly id_: FieldRef<"language", 'Int'>
    readonly language_code: FieldRef<"language", 'String'>
    readonly language_name: FieldRef<"language", 'String'>
    readonly updated_date: FieldRef<"language", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * language findUnique
   */
  export type languageFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the language
     */
    select?: languageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the language
     */
    omit?: languageOmit<ExtArgs> | null
    /**
     * Filter, which language to fetch.
     */
    where: languageWhereUniqueInput
  }

  /**
   * language findUniqueOrThrow
   */
  export type languageFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the language
     */
    select?: languageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the language
     */
    omit?: languageOmit<ExtArgs> | null
    /**
     * Filter, which language to fetch.
     */
    where: languageWhereUniqueInput
  }

  /**
   * language findFirst
   */
  export type languageFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the language
     */
    select?: languageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the language
     */
    omit?: languageOmit<ExtArgs> | null
    /**
     * Filter, which language to fetch.
     */
    where?: languageWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of languages to fetch.
     */
    orderBy?: languageOrderByWithRelationInput | languageOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for languages.
     */
    cursor?: languageWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` languages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` languages.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of languages.
     */
    distinct?: LanguageScalarFieldEnum | LanguageScalarFieldEnum[]
  }

  /**
   * language findFirstOrThrow
   */
  export type languageFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the language
     */
    select?: languageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the language
     */
    omit?: languageOmit<ExtArgs> | null
    /**
     * Filter, which language to fetch.
     */
    where?: languageWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of languages to fetch.
     */
    orderBy?: languageOrderByWithRelationInput | languageOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for languages.
     */
    cursor?: languageWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` languages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` languages.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of languages.
     */
    distinct?: LanguageScalarFieldEnum | LanguageScalarFieldEnum[]
  }

  /**
   * language findMany
   */
  export type languageFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the language
     */
    select?: languageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the language
     */
    omit?: languageOmit<ExtArgs> | null
    /**
     * Filter, which languages to fetch.
     */
    where?: languageWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of languages to fetch.
     */
    orderBy?: languageOrderByWithRelationInput | languageOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing languages.
     */
    cursor?: languageWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` languages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` languages.
     */
    skip?: number
    distinct?: LanguageScalarFieldEnum | LanguageScalarFieldEnum[]
  }

  /**
   * language create
   */
  export type languageCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the language
     */
    select?: languageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the language
     */
    omit?: languageOmit<ExtArgs> | null
    /**
     * The data needed to create a language.
     */
    data: XOR<languageCreateInput, languageUncheckedCreateInput>
  }

  /**
   * language createMany
   */
  export type languageCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many languages.
     */
    data: languageCreateManyInput | languageCreateManyInput[]
  }

  /**
   * language update
   */
  export type languageUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the language
     */
    select?: languageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the language
     */
    omit?: languageOmit<ExtArgs> | null
    /**
     * The data needed to update a language.
     */
    data: XOR<languageUpdateInput, languageUncheckedUpdateInput>
    /**
     * Choose, which language to update.
     */
    where: languageWhereUniqueInput
  }

  /**
   * language updateMany
   */
  export type languageUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update languages.
     */
    data: XOR<languageUpdateManyMutationInput, languageUncheckedUpdateManyInput>
    /**
     * Filter which languages to update
     */
    where?: languageWhereInput
    /**
     * Limit how many languages to update.
     */
    limit?: number
  }

  /**
   * language upsert
   */
  export type languageUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the language
     */
    select?: languageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the language
     */
    omit?: languageOmit<ExtArgs> | null
    /**
     * The filter to search for the language to update in case it exists.
     */
    where: languageWhereUniqueInput
    /**
     * In case the language found by the `where` argument doesn't exist, create a new language with this data.
     */
    create: XOR<languageCreateInput, languageUncheckedCreateInput>
    /**
     * In case the language was found with the provided `where` argument, update it with this data.
     */
    update: XOR<languageUpdateInput, languageUncheckedUpdateInput>
  }

  /**
   * language delete
   */
  export type languageDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the language
     */
    select?: languageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the language
     */
    omit?: languageOmit<ExtArgs> | null
    /**
     * Filter which language to delete.
     */
    where: languageWhereUniqueInput
  }

  /**
   * language deleteMany
   */
  export type languageDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which languages to delete
     */
    where?: languageWhereInput
    /**
     * Limit how many languages to delete.
     */
    limit?: number
  }

  /**
   * language findRaw
   */
  export type languageFindRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The query predicate filter. If unspecified, then all documents in the collection will match the predicate. ${@link https://docs.mongodb.com/manual/reference/operator/query MongoDB Docs}.
     */
    filter?: InputJsonValue
    /**
     * Additional options to pass to the `find` command ${@link https://docs.mongodb.com/manual/reference/command/find/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * language aggregateRaw
   */
  export type languageAggregateRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * An array of aggregation stages to process and transform the document stream via the aggregation pipeline. ${@link https://docs.mongodb.com/manual/reference/operator/aggregation-pipeline MongoDB Docs}.
     */
    pipeline?: InputJsonValue[]
    /**
     * Additional options to pass to the `aggregate` command ${@link https://docs.mongodb.com/manual/reference/command/aggregate/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * language without action
   */
  export type languageDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the language
     */
    select?: languageSelect<ExtArgs> | null
    /**
     * Omit specific fields from the language
     */
    omit?: languageOmit<ExtArgs> | null
  }


  /**
   * Model mainsettings
   */

  export type AggregateMainsettings = {
    _count: MainsettingsCountAggregateOutputType | null
    _min: MainsettingsMinAggregateOutputType | null
    _max: MainsettingsMaxAggregateOutputType | null
  }

  export type MainsettingsMinAggregateOutputType = {
    mongoId: string | null
  }

  export type MainsettingsMaxAggregateOutputType = {
    mongoId: string | null
  }

  export type MainsettingsCountAggregateOutputType = {
    mongoId: number
    id: number
    _all: number
  }


  export type MainsettingsMinAggregateInputType = {
    mongoId?: true
  }

  export type MainsettingsMaxAggregateInputType = {
    mongoId?: true
  }

  export type MainsettingsCountAggregateInputType = {
    mongoId?: true
    id?: true
    _all?: true
  }

  export type MainsettingsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which mainsettings to aggregate.
     */
    where?: mainsettingsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of mainsettings to fetch.
     */
    orderBy?: mainsettingsOrderByWithRelationInput | mainsettingsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: mainsettingsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` mainsettings from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` mainsettings.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned mainsettings
    **/
    _count?: true | MainsettingsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: MainsettingsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: MainsettingsMaxAggregateInputType
  }

  export type GetMainsettingsAggregateType<T extends MainsettingsAggregateArgs> = {
        [P in keyof T & keyof AggregateMainsettings]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateMainsettings[P]>
      : GetScalarType<T[P], AggregateMainsettings[P]>
  }




  export type mainsettingsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: mainsettingsWhereInput
    orderBy?: mainsettingsOrderByWithAggregationInput | mainsettingsOrderByWithAggregationInput[]
    by: MainsettingsScalarFieldEnum[] | MainsettingsScalarFieldEnum
    having?: mainsettingsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: MainsettingsCountAggregateInputType | true
    _min?: MainsettingsMinAggregateInputType
    _max?: MainsettingsMaxAggregateInputType
  }

  export type MainsettingsGroupByOutputType = {
    mongoId: string
    id: JsonValue | null
    _count: MainsettingsCountAggregateOutputType | null
    _min: MainsettingsMinAggregateOutputType | null
    _max: MainsettingsMaxAggregateOutputType | null
  }

  type GetMainsettingsGroupByPayload<T extends mainsettingsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<MainsettingsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof MainsettingsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], MainsettingsGroupByOutputType[P]>
            : GetScalarType<T[P], MainsettingsGroupByOutputType[P]>
        }
      >
    >


  export type mainsettingsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    mongoId?: boolean
    id?: boolean
  }, ExtArgs["result"]["mainsettings"]>



  export type mainsettingsSelectScalar = {
    mongoId?: boolean
    id?: boolean
  }

  export type mainsettingsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"mongoId" | "id", ExtArgs["result"]["mainsettings"]>

  export type $mainsettingsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "mainsettings"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      mongoId: string
      /**
       * Field referred in an index, but found no data to define the type.
       */
      id: Prisma.JsonValue | null
    }, ExtArgs["result"]["mainsettings"]>
    composites: {}
  }

  type mainsettingsGetPayload<S extends boolean | null | undefined | mainsettingsDefaultArgs> = $Result.GetResult<Prisma.$mainsettingsPayload, S>

  type mainsettingsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<mainsettingsFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: MainsettingsCountAggregateInputType | true
    }

  export interface mainsettingsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['mainsettings'], meta: { name: 'mainsettings' } }
    /**
     * Find zero or one Mainsettings that matches the filter.
     * @param {mainsettingsFindUniqueArgs} args - Arguments to find a Mainsettings
     * @example
     * // Get one Mainsettings
     * const mainsettings = await prisma.mainsettings.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends mainsettingsFindUniqueArgs>(args: SelectSubset<T, mainsettingsFindUniqueArgs<ExtArgs>>): Prisma__mainsettingsClient<$Result.GetResult<Prisma.$mainsettingsPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Mainsettings that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {mainsettingsFindUniqueOrThrowArgs} args - Arguments to find a Mainsettings
     * @example
     * // Get one Mainsettings
     * const mainsettings = await prisma.mainsettings.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends mainsettingsFindUniqueOrThrowArgs>(args: SelectSubset<T, mainsettingsFindUniqueOrThrowArgs<ExtArgs>>): Prisma__mainsettingsClient<$Result.GetResult<Prisma.$mainsettingsPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Mainsettings that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {mainsettingsFindFirstArgs} args - Arguments to find a Mainsettings
     * @example
     * // Get one Mainsettings
     * const mainsettings = await prisma.mainsettings.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends mainsettingsFindFirstArgs>(args?: SelectSubset<T, mainsettingsFindFirstArgs<ExtArgs>>): Prisma__mainsettingsClient<$Result.GetResult<Prisma.$mainsettingsPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Mainsettings that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {mainsettingsFindFirstOrThrowArgs} args - Arguments to find a Mainsettings
     * @example
     * // Get one Mainsettings
     * const mainsettings = await prisma.mainsettings.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends mainsettingsFindFirstOrThrowArgs>(args?: SelectSubset<T, mainsettingsFindFirstOrThrowArgs<ExtArgs>>): Prisma__mainsettingsClient<$Result.GetResult<Prisma.$mainsettingsPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Mainsettings that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {mainsettingsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Mainsettings
     * const mainsettings = await prisma.mainsettings.findMany()
     * 
     * // Get first 10 Mainsettings
     * const mainsettings = await prisma.mainsettings.findMany({ take: 10 })
     * 
     * // Only select the `mongoId`
     * const mainsettingsWithMongoIdOnly = await prisma.mainsettings.findMany({ select: { mongoId: true } })
     * 
     */
    findMany<T extends mainsettingsFindManyArgs>(args?: SelectSubset<T, mainsettingsFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$mainsettingsPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Mainsettings.
     * @param {mainsettingsCreateArgs} args - Arguments to create a Mainsettings.
     * @example
     * // Create one Mainsettings
     * const Mainsettings = await prisma.mainsettings.create({
     *   data: {
     *     // ... data to create a Mainsettings
     *   }
     * })
     * 
     */
    create<T extends mainsettingsCreateArgs>(args: SelectSubset<T, mainsettingsCreateArgs<ExtArgs>>): Prisma__mainsettingsClient<$Result.GetResult<Prisma.$mainsettingsPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Mainsettings.
     * @param {mainsettingsCreateManyArgs} args - Arguments to create many Mainsettings.
     * @example
     * // Create many Mainsettings
     * const mainsettings = await prisma.mainsettings.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends mainsettingsCreateManyArgs>(args?: SelectSubset<T, mainsettingsCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Mainsettings.
     * @param {mainsettingsDeleteArgs} args - Arguments to delete one Mainsettings.
     * @example
     * // Delete one Mainsettings
     * const Mainsettings = await prisma.mainsettings.delete({
     *   where: {
     *     // ... filter to delete one Mainsettings
     *   }
     * })
     * 
     */
    delete<T extends mainsettingsDeleteArgs>(args: SelectSubset<T, mainsettingsDeleteArgs<ExtArgs>>): Prisma__mainsettingsClient<$Result.GetResult<Prisma.$mainsettingsPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Mainsettings.
     * @param {mainsettingsUpdateArgs} args - Arguments to update one Mainsettings.
     * @example
     * // Update one Mainsettings
     * const mainsettings = await prisma.mainsettings.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends mainsettingsUpdateArgs>(args: SelectSubset<T, mainsettingsUpdateArgs<ExtArgs>>): Prisma__mainsettingsClient<$Result.GetResult<Prisma.$mainsettingsPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Mainsettings.
     * @param {mainsettingsDeleteManyArgs} args - Arguments to filter Mainsettings to delete.
     * @example
     * // Delete a few Mainsettings
     * const { count } = await prisma.mainsettings.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends mainsettingsDeleteManyArgs>(args?: SelectSubset<T, mainsettingsDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Mainsettings.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {mainsettingsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Mainsettings
     * const mainsettings = await prisma.mainsettings.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends mainsettingsUpdateManyArgs>(args: SelectSubset<T, mainsettingsUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Mainsettings.
     * @param {mainsettingsUpsertArgs} args - Arguments to update or create a Mainsettings.
     * @example
     * // Update or create a Mainsettings
     * const mainsettings = await prisma.mainsettings.upsert({
     *   create: {
     *     // ... data to create a Mainsettings
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Mainsettings we want to update
     *   }
     * })
     */
    upsert<T extends mainsettingsUpsertArgs>(args: SelectSubset<T, mainsettingsUpsertArgs<ExtArgs>>): Prisma__mainsettingsClient<$Result.GetResult<Prisma.$mainsettingsPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Mainsettings that matches the filter.
     * @param {mainsettingsFindRawArgs} args - Select which filters you would like to apply.
     * @example
     * const mainsettings = await prisma.mainsettings.findRaw({
     *   filter: { age: { $gt: 25 } }
     * })
     */
    findRaw(args?: mainsettingsFindRawArgs): Prisma.PrismaPromise<JsonObject>

    /**
     * Perform aggregation operations on a Mainsettings.
     * @param {mainsettingsAggregateRawArgs} args - Select which aggregations you would like to apply.
     * @example
     * const mainsettings = await prisma.mainsettings.aggregateRaw({
     *   pipeline: [
     *     { $match: { status: "registered" } },
     *     { $group: { _id: "$country", total: { $sum: 1 } } }
     *   ]
     * })
     */
    aggregateRaw(args?: mainsettingsAggregateRawArgs): Prisma.PrismaPromise<JsonObject>


    /**
     * Count the number of Mainsettings.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {mainsettingsCountArgs} args - Arguments to filter Mainsettings to count.
     * @example
     * // Count the number of Mainsettings
     * const count = await prisma.mainsettings.count({
     *   where: {
     *     // ... the filter for the Mainsettings we want to count
     *   }
     * })
    **/
    count<T extends mainsettingsCountArgs>(
      args?: Subset<T, mainsettingsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], MainsettingsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Mainsettings.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MainsettingsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends MainsettingsAggregateArgs>(args: Subset<T, MainsettingsAggregateArgs>): Prisma.PrismaPromise<GetMainsettingsAggregateType<T>>

    /**
     * Group by Mainsettings.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {mainsettingsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends mainsettingsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: mainsettingsGroupByArgs['orderBy'] }
        : { orderBy?: mainsettingsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, mainsettingsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetMainsettingsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the mainsettings model
   */
  readonly fields: mainsettingsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for mainsettings.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__mainsettingsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the mainsettings model
   */ 
  interface mainsettingsFieldRefs {
    readonly mongoId: FieldRef<"mainsettings", 'String'>
    readonly id: FieldRef<"mainsettings", 'Json'>
  }
    

  // Custom InputTypes
  /**
   * mainsettings findUnique
   */
  export type mainsettingsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the mainsettings
     */
    select?: mainsettingsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the mainsettings
     */
    omit?: mainsettingsOmit<ExtArgs> | null
    /**
     * Filter, which mainsettings to fetch.
     */
    where: mainsettingsWhereUniqueInput
  }

  /**
   * mainsettings findUniqueOrThrow
   */
  export type mainsettingsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the mainsettings
     */
    select?: mainsettingsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the mainsettings
     */
    omit?: mainsettingsOmit<ExtArgs> | null
    /**
     * Filter, which mainsettings to fetch.
     */
    where: mainsettingsWhereUniqueInput
  }

  /**
   * mainsettings findFirst
   */
  export type mainsettingsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the mainsettings
     */
    select?: mainsettingsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the mainsettings
     */
    omit?: mainsettingsOmit<ExtArgs> | null
    /**
     * Filter, which mainsettings to fetch.
     */
    where?: mainsettingsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of mainsettings to fetch.
     */
    orderBy?: mainsettingsOrderByWithRelationInput | mainsettingsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for mainsettings.
     */
    cursor?: mainsettingsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` mainsettings from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` mainsettings.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of mainsettings.
     */
    distinct?: MainsettingsScalarFieldEnum | MainsettingsScalarFieldEnum[]
  }

  /**
   * mainsettings findFirstOrThrow
   */
  export type mainsettingsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the mainsettings
     */
    select?: mainsettingsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the mainsettings
     */
    omit?: mainsettingsOmit<ExtArgs> | null
    /**
     * Filter, which mainsettings to fetch.
     */
    where?: mainsettingsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of mainsettings to fetch.
     */
    orderBy?: mainsettingsOrderByWithRelationInput | mainsettingsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for mainsettings.
     */
    cursor?: mainsettingsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` mainsettings from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` mainsettings.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of mainsettings.
     */
    distinct?: MainsettingsScalarFieldEnum | MainsettingsScalarFieldEnum[]
  }

  /**
   * mainsettings findMany
   */
  export type mainsettingsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the mainsettings
     */
    select?: mainsettingsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the mainsettings
     */
    omit?: mainsettingsOmit<ExtArgs> | null
    /**
     * Filter, which mainsettings to fetch.
     */
    where?: mainsettingsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of mainsettings to fetch.
     */
    orderBy?: mainsettingsOrderByWithRelationInput | mainsettingsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing mainsettings.
     */
    cursor?: mainsettingsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` mainsettings from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` mainsettings.
     */
    skip?: number
    distinct?: MainsettingsScalarFieldEnum | MainsettingsScalarFieldEnum[]
  }

  /**
   * mainsettings create
   */
  export type mainsettingsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the mainsettings
     */
    select?: mainsettingsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the mainsettings
     */
    omit?: mainsettingsOmit<ExtArgs> | null
    /**
     * The data needed to create a mainsettings.
     */
    data?: XOR<mainsettingsCreateInput, mainsettingsUncheckedCreateInput>
  }

  /**
   * mainsettings createMany
   */
  export type mainsettingsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many mainsettings.
     */
    data: mainsettingsCreateManyInput | mainsettingsCreateManyInput[]
  }

  /**
   * mainsettings update
   */
  export type mainsettingsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the mainsettings
     */
    select?: mainsettingsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the mainsettings
     */
    omit?: mainsettingsOmit<ExtArgs> | null
    /**
     * The data needed to update a mainsettings.
     */
    data: XOR<mainsettingsUpdateInput, mainsettingsUncheckedUpdateInput>
    /**
     * Choose, which mainsettings to update.
     */
    where: mainsettingsWhereUniqueInput
  }

  /**
   * mainsettings updateMany
   */
  export type mainsettingsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update mainsettings.
     */
    data: XOR<mainsettingsUpdateManyMutationInput, mainsettingsUncheckedUpdateManyInput>
    /**
     * Filter which mainsettings to update
     */
    where?: mainsettingsWhereInput
    /**
     * Limit how many mainsettings to update.
     */
    limit?: number
  }

  /**
   * mainsettings upsert
   */
  export type mainsettingsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the mainsettings
     */
    select?: mainsettingsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the mainsettings
     */
    omit?: mainsettingsOmit<ExtArgs> | null
    /**
     * The filter to search for the mainsettings to update in case it exists.
     */
    where: mainsettingsWhereUniqueInput
    /**
     * In case the mainsettings found by the `where` argument doesn't exist, create a new mainsettings with this data.
     */
    create: XOR<mainsettingsCreateInput, mainsettingsUncheckedCreateInput>
    /**
     * In case the mainsettings was found with the provided `where` argument, update it with this data.
     */
    update: XOR<mainsettingsUpdateInput, mainsettingsUncheckedUpdateInput>
  }

  /**
   * mainsettings delete
   */
  export type mainsettingsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the mainsettings
     */
    select?: mainsettingsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the mainsettings
     */
    omit?: mainsettingsOmit<ExtArgs> | null
    /**
     * Filter which mainsettings to delete.
     */
    where: mainsettingsWhereUniqueInput
  }

  /**
   * mainsettings deleteMany
   */
  export type mainsettingsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which mainsettings to delete
     */
    where?: mainsettingsWhereInput
    /**
     * Limit how many mainsettings to delete.
     */
    limit?: number
  }

  /**
   * mainsettings findRaw
   */
  export type mainsettingsFindRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The query predicate filter. If unspecified, then all documents in the collection will match the predicate. ${@link https://docs.mongodb.com/manual/reference/operator/query MongoDB Docs}.
     */
    filter?: InputJsonValue
    /**
     * Additional options to pass to the `find` command ${@link https://docs.mongodb.com/manual/reference/command/find/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * mainsettings aggregateRaw
   */
  export type mainsettingsAggregateRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * An array of aggregation stages to process and transform the document stream via the aggregation pipeline. ${@link https://docs.mongodb.com/manual/reference/operator/aggregation-pipeline MongoDB Docs}.
     */
    pipeline?: InputJsonValue[]
    /**
     * Additional options to pass to the `aggregate` command ${@link https://docs.mongodb.com/manual/reference/command/aggregate/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * mainsettings without action
   */
  export type mainsettingsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the mainsettings
     */
    select?: mainsettingsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the mainsettings
     */
    omit?: mainsettingsOmit<ExtArgs> | null
  }


  /**
   * Model region
   */

  export type AggregateRegion = {
    _count: RegionCountAggregateOutputType | null
    _avg: RegionAvgAggregateOutputType | null
    _sum: RegionSumAggregateOutputType | null
    _min: RegionMinAggregateOutputType | null
    _max: RegionMaxAggregateOutputType | null
  }

  export type RegionAvgAggregateOutputType = {
    id_: number | null
  }

  export type RegionSumAggregateOutputType = {
    id_: number | null
  }

  export type RegionMinAggregateOutputType = {
    id: string | null
    created_date: Date | null
    id_: number | null
    region_code: string | null
    region_country: string | null
    region_name: string | null
    searchvolume_country_id: string | null
    updated_date: Date | null
  }

  export type RegionMaxAggregateOutputType = {
    id: string | null
    created_date: Date | null
    id_: number | null
    region_code: string | null
    region_country: string | null
    region_name: string | null
    searchvolume_country_id: string | null
    updated_date: Date | null
  }

  export type RegionCountAggregateOutputType = {
    id: number
    created_date: number
    id_: number
    region_code: number
    region_country: number
    region_name: number
    searchvolume_country_id: number
    updated_date: number
    _all: number
  }


  export type RegionAvgAggregateInputType = {
    id_?: true
  }

  export type RegionSumAggregateInputType = {
    id_?: true
  }

  export type RegionMinAggregateInputType = {
    id?: true
    created_date?: true
    id_?: true
    region_code?: true
    region_country?: true
    region_name?: true
    searchvolume_country_id?: true
    updated_date?: true
  }

  export type RegionMaxAggregateInputType = {
    id?: true
    created_date?: true
    id_?: true
    region_code?: true
    region_country?: true
    region_name?: true
    searchvolume_country_id?: true
    updated_date?: true
  }

  export type RegionCountAggregateInputType = {
    id?: true
    created_date?: true
    id_?: true
    region_code?: true
    region_country?: true
    region_name?: true
    searchvolume_country_id?: true
    updated_date?: true
    _all?: true
  }

  export type RegionAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which region to aggregate.
     */
    where?: regionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of regions to fetch.
     */
    orderBy?: regionOrderByWithRelationInput | regionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: regionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` regions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` regions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned regions
    **/
    _count?: true | RegionCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: RegionAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: RegionSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: RegionMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: RegionMaxAggregateInputType
  }

  export type GetRegionAggregateType<T extends RegionAggregateArgs> = {
        [P in keyof T & keyof AggregateRegion]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateRegion[P]>
      : GetScalarType<T[P], AggregateRegion[P]>
  }




  export type regionGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: regionWhereInput
    orderBy?: regionOrderByWithAggregationInput | regionOrderByWithAggregationInput[]
    by: RegionScalarFieldEnum[] | RegionScalarFieldEnum
    having?: regionScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: RegionCountAggregateInputType | true
    _avg?: RegionAvgAggregateInputType
    _sum?: RegionSumAggregateInputType
    _min?: RegionMinAggregateInputType
    _max?: RegionMaxAggregateInputType
  }

  export type RegionGroupByOutputType = {
    id: string
    created_date: Date
    id_: number
    region_code: string
    region_country: string
    region_name: string
    searchvolume_country_id: string | null
    updated_date: Date
    _count: RegionCountAggregateOutputType | null
    _avg: RegionAvgAggregateOutputType | null
    _sum: RegionSumAggregateOutputType | null
    _min: RegionMinAggregateOutputType | null
    _max: RegionMaxAggregateOutputType | null
  }

  type GetRegionGroupByPayload<T extends regionGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<RegionGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof RegionGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], RegionGroupByOutputType[P]>
            : GetScalarType<T[P], RegionGroupByOutputType[P]>
        }
      >
    >


  export type regionSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    created_date?: boolean
    id_?: boolean
    region_code?: boolean
    region_country?: boolean
    region_name?: boolean
    searchvolume_country_id?: boolean
    updated_date?: boolean
  }, ExtArgs["result"]["region"]>



  export type regionSelectScalar = {
    id?: boolean
    created_date?: boolean
    id_?: boolean
    region_code?: boolean
    region_country?: boolean
    region_name?: boolean
    searchvolume_country_id?: boolean
    updated_date?: boolean
  }

  export type regionOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "created_date" | "id_" | "region_code" | "region_country" | "region_name" | "searchvolume_country_id" | "updated_date", ExtArgs["result"]["region"]>

  export type $regionPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "region"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: string
      created_date: Date
      id_: number
      region_code: string
      region_country: string
      region_name: string
      searchvolume_country_id: string | null
      updated_date: Date
    }, ExtArgs["result"]["region"]>
    composites: {}
  }

  type regionGetPayload<S extends boolean | null | undefined | regionDefaultArgs> = $Result.GetResult<Prisma.$regionPayload, S>

  type regionCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<regionFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: RegionCountAggregateInputType | true
    }

  export interface regionDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['region'], meta: { name: 'region' } }
    /**
     * Find zero or one Region that matches the filter.
     * @param {regionFindUniqueArgs} args - Arguments to find a Region
     * @example
     * // Get one Region
     * const region = await prisma.region.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends regionFindUniqueArgs>(args: SelectSubset<T, regionFindUniqueArgs<ExtArgs>>): Prisma__regionClient<$Result.GetResult<Prisma.$regionPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Region that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {regionFindUniqueOrThrowArgs} args - Arguments to find a Region
     * @example
     * // Get one Region
     * const region = await prisma.region.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends regionFindUniqueOrThrowArgs>(args: SelectSubset<T, regionFindUniqueOrThrowArgs<ExtArgs>>): Prisma__regionClient<$Result.GetResult<Prisma.$regionPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Region that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {regionFindFirstArgs} args - Arguments to find a Region
     * @example
     * // Get one Region
     * const region = await prisma.region.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends regionFindFirstArgs>(args?: SelectSubset<T, regionFindFirstArgs<ExtArgs>>): Prisma__regionClient<$Result.GetResult<Prisma.$regionPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Region that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {regionFindFirstOrThrowArgs} args - Arguments to find a Region
     * @example
     * // Get one Region
     * const region = await prisma.region.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends regionFindFirstOrThrowArgs>(args?: SelectSubset<T, regionFindFirstOrThrowArgs<ExtArgs>>): Prisma__regionClient<$Result.GetResult<Prisma.$regionPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Regions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {regionFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Regions
     * const regions = await prisma.region.findMany()
     * 
     * // Get first 10 Regions
     * const regions = await prisma.region.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const regionWithIdOnly = await prisma.region.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends regionFindManyArgs>(args?: SelectSubset<T, regionFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$regionPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Region.
     * @param {regionCreateArgs} args - Arguments to create a Region.
     * @example
     * // Create one Region
     * const Region = await prisma.region.create({
     *   data: {
     *     // ... data to create a Region
     *   }
     * })
     * 
     */
    create<T extends regionCreateArgs>(args: SelectSubset<T, regionCreateArgs<ExtArgs>>): Prisma__regionClient<$Result.GetResult<Prisma.$regionPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Regions.
     * @param {regionCreateManyArgs} args - Arguments to create many Regions.
     * @example
     * // Create many Regions
     * const region = await prisma.region.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends regionCreateManyArgs>(args?: SelectSubset<T, regionCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Delete a Region.
     * @param {regionDeleteArgs} args - Arguments to delete one Region.
     * @example
     * // Delete one Region
     * const Region = await prisma.region.delete({
     *   where: {
     *     // ... filter to delete one Region
     *   }
     * })
     * 
     */
    delete<T extends regionDeleteArgs>(args: SelectSubset<T, regionDeleteArgs<ExtArgs>>): Prisma__regionClient<$Result.GetResult<Prisma.$regionPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Region.
     * @param {regionUpdateArgs} args - Arguments to update one Region.
     * @example
     * // Update one Region
     * const region = await prisma.region.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends regionUpdateArgs>(args: SelectSubset<T, regionUpdateArgs<ExtArgs>>): Prisma__regionClient<$Result.GetResult<Prisma.$regionPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Regions.
     * @param {regionDeleteManyArgs} args - Arguments to filter Regions to delete.
     * @example
     * // Delete a few Regions
     * const { count } = await prisma.region.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends regionDeleteManyArgs>(args?: SelectSubset<T, regionDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Regions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {regionUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Regions
     * const region = await prisma.region.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends regionUpdateManyArgs>(args: SelectSubset<T, regionUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Region.
     * @param {regionUpsertArgs} args - Arguments to update or create a Region.
     * @example
     * // Update or create a Region
     * const region = await prisma.region.upsert({
     *   create: {
     *     // ... data to create a Region
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Region we want to update
     *   }
     * })
     */
    upsert<T extends regionUpsertArgs>(args: SelectSubset<T, regionUpsertArgs<ExtArgs>>): Prisma__regionClient<$Result.GetResult<Prisma.$regionPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Regions that matches the filter.
     * @param {regionFindRawArgs} args - Select which filters you would like to apply.
     * @example
     * const region = await prisma.region.findRaw({
     *   filter: { age: { $gt: 25 } }
     * })
     */
    findRaw(args?: regionFindRawArgs): Prisma.PrismaPromise<JsonObject>

    /**
     * Perform aggregation operations on a Region.
     * @param {regionAggregateRawArgs} args - Select which aggregations you would like to apply.
     * @example
     * const region = await prisma.region.aggregateRaw({
     *   pipeline: [
     *     { $match: { status: "registered" } },
     *     { $group: { _id: "$country", total: { $sum: 1 } } }
     *   ]
     * })
     */
    aggregateRaw(args?: regionAggregateRawArgs): Prisma.PrismaPromise<JsonObject>


    /**
     * Count the number of Regions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {regionCountArgs} args - Arguments to filter Regions to count.
     * @example
     * // Count the number of Regions
     * const count = await prisma.region.count({
     *   where: {
     *     // ... the filter for the Regions we want to count
     *   }
     * })
    **/
    count<T extends regionCountArgs>(
      args?: Subset<T, regionCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], RegionCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Region.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RegionAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends RegionAggregateArgs>(args: Subset<T, RegionAggregateArgs>): Prisma.PrismaPromise<GetRegionAggregateType<T>>

    /**
     * Group by Region.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {regionGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends regionGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: regionGroupByArgs['orderBy'] }
        : { orderBy?: regionGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, regionGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetRegionGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the region model
   */
  readonly fields: regionFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for region.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__regionClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the region model
   */ 
  interface regionFieldRefs {
    readonly id: FieldRef<"region", 'String'>
    readonly created_date: FieldRef<"region", 'DateTime'>
    readonly id_: FieldRef<"region", 'Float'>
    readonly region_code: FieldRef<"region", 'String'>
    readonly region_country: FieldRef<"region", 'String'>
    readonly region_name: FieldRef<"region", 'String'>
    readonly searchvolume_country_id: FieldRef<"region", 'String'>
    readonly updated_date: FieldRef<"region", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * region findUnique
   */
  export type regionFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the region
     */
    select?: regionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the region
     */
    omit?: regionOmit<ExtArgs> | null
    /**
     * Filter, which region to fetch.
     */
    where: regionWhereUniqueInput
  }

  /**
   * region findUniqueOrThrow
   */
  export type regionFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the region
     */
    select?: regionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the region
     */
    omit?: regionOmit<ExtArgs> | null
    /**
     * Filter, which region to fetch.
     */
    where: regionWhereUniqueInput
  }

  /**
   * region findFirst
   */
  export type regionFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the region
     */
    select?: regionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the region
     */
    omit?: regionOmit<ExtArgs> | null
    /**
     * Filter, which region to fetch.
     */
    where?: regionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of regions to fetch.
     */
    orderBy?: regionOrderByWithRelationInput | regionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for regions.
     */
    cursor?: regionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` regions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` regions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of regions.
     */
    distinct?: RegionScalarFieldEnum | RegionScalarFieldEnum[]
  }

  /**
   * region findFirstOrThrow
   */
  export type regionFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the region
     */
    select?: regionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the region
     */
    omit?: regionOmit<ExtArgs> | null
    /**
     * Filter, which region to fetch.
     */
    where?: regionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of regions to fetch.
     */
    orderBy?: regionOrderByWithRelationInput | regionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for regions.
     */
    cursor?: regionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` regions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` regions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of regions.
     */
    distinct?: RegionScalarFieldEnum | RegionScalarFieldEnum[]
  }

  /**
   * region findMany
   */
  export type regionFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the region
     */
    select?: regionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the region
     */
    omit?: regionOmit<ExtArgs> | null
    /**
     * Filter, which regions to fetch.
     */
    where?: regionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of regions to fetch.
     */
    orderBy?: regionOrderByWithRelationInput | regionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing regions.
     */
    cursor?: regionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` regions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` regions.
     */
    skip?: number
    distinct?: RegionScalarFieldEnum | RegionScalarFieldEnum[]
  }

  /**
   * region create
   */
  export type regionCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the region
     */
    select?: regionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the region
     */
    omit?: regionOmit<ExtArgs> | null
    /**
     * The data needed to create a region.
     */
    data: XOR<regionCreateInput, regionUncheckedCreateInput>
  }

  /**
   * region createMany
   */
  export type regionCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many regions.
     */
    data: regionCreateManyInput | regionCreateManyInput[]
  }

  /**
   * region update
   */
  export type regionUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the region
     */
    select?: regionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the region
     */
    omit?: regionOmit<ExtArgs> | null
    /**
     * The data needed to update a region.
     */
    data: XOR<regionUpdateInput, regionUncheckedUpdateInput>
    /**
     * Choose, which region to update.
     */
    where: regionWhereUniqueInput
  }

  /**
   * region updateMany
   */
  export type regionUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update regions.
     */
    data: XOR<regionUpdateManyMutationInput, regionUncheckedUpdateManyInput>
    /**
     * Filter which regions to update
     */
    where?: regionWhereInput
    /**
     * Limit how many regions to update.
     */
    limit?: number
  }

  /**
   * region upsert
   */
  export type regionUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the region
     */
    select?: regionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the region
     */
    omit?: regionOmit<ExtArgs> | null
    /**
     * The filter to search for the region to update in case it exists.
     */
    where: regionWhereUniqueInput
    /**
     * In case the region found by the `where` argument doesn't exist, create a new region with this data.
     */
    create: XOR<regionCreateInput, regionUncheckedCreateInput>
    /**
     * In case the region was found with the provided `where` argument, update it with this data.
     */
    update: XOR<regionUpdateInput, regionUncheckedUpdateInput>
  }

  /**
   * region delete
   */
  export type regionDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the region
     */
    select?: regionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the region
     */
    omit?: regionOmit<ExtArgs> | null
    /**
     * Filter which region to delete.
     */
    where: regionWhereUniqueInput
  }

  /**
   * region deleteMany
   */
  export type regionDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which regions to delete
     */
    where?: regionWhereInput
    /**
     * Limit how many regions to delete.
     */
    limit?: number
  }

  /**
   * region findRaw
   */
  export type regionFindRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The query predicate filter. If unspecified, then all documents in the collection will match the predicate. ${@link https://docs.mongodb.com/manual/reference/operator/query MongoDB Docs}.
     */
    filter?: InputJsonValue
    /**
     * Additional options to pass to the `find` command ${@link https://docs.mongodb.com/manual/reference/command/find/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * region aggregateRaw
   */
  export type regionAggregateRawArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * An array of aggregation stages to process and transform the document stream via the aggregation pipeline. ${@link https://docs.mongodb.com/manual/reference/operator/aggregation-pipeline MongoDB Docs}.
     */
    pipeline?: InputJsonValue[]
    /**
     * Additional options to pass to the `aggregate` command ${@link https://docs.mongodb.com/manual/reference/command/aggregate/#command-fields MongoDB Docs}.
     */
    options?: InputJsonValue
  }

  /**
   * region without action
   */
  export type regionDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the region
     */
    select?: regionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the region
     */
    omit?: regionOmit<ExtArgs> | null
  }


  /**
   * Enums
   */

  export const Schema__ScalarFieldEnum: {
    id: 'id',
    name: 'name'
  };

  export type Schema__ScalarFieldEnum = (typeof Schema__ScalarFieldEnum)[keyof typeof Schema__ScalarFieldEnum]


  export const AccountScalarFieldEnum: {
    id: 'id',
    account_status: 'account_status',
    date_joined: 'date_joined',
    email: 'email',
    id_: 'id_',
    is_active: 'is_active',
    is_admin: 'is_admin',
    is_staff: 'is_staff',
    is_superuser: 'is_superuser',
    last_home_visit: 'last_home_visit',
    last_login: 'last_login',
    last_logout: 'last_logout',
    password: 'password',
    username: 'username'
  };

  export type AccountScalarFieldEnum = (typeof AccountScalarFieldEnum)[keyof typeof AccountScalarFieldEnum]


  export const Account_trackerScalarFieldEnum: {
    id: 'id',
    city: 'city',
    client_agent: 'client_agent',
    client_ip: 'client_ip',
    country: 'country',
    country_code: 'country_code',
    created_date: 'created_date',
    fb_user_id: 'fb_user_id',
    id_: 'id_',
    mobile: 'mobile',
    modified_date: 'modified_date',
    other_info: 'other_info',
    region: 'region',
    status: 'status',
    time_zone: 'time_zone',
    user_automation_time: 'user_automation_time'
  };

  export type Account_trackerScalarFieldEnum = (typeof Account_trackerScalarFieldEnum)[keyof typeof Account_trackerScalarFieldEnum]


  export const AccountusageScalarFieldEnum: {
    mongoId: 'mongoId',
    fb_user_id: 'fb_user_id',
    id: 'id'
  };

  export type AccountusageScalarFieldEnum = (typeof AccountusageScalarFieldEnum)[keyof typeof AccountusageScalarFieldEnum]


  export const Auth_groupScalarFieldEnum: {
    mongoId: 'mongoId',
    id: 'id',
    name: 'name'
  };

  export type Auth_groupScalarFieldEnum = (typeof Auth_groupScalarFieldEnum)[keyof typeof Auth_groupScalarFieldEnum]


  export const Auth_group_permissionsScalarFieldEnum: {
    mongoId: 'mongoId',
    group_id: 'group_id',
    id: 'id',
    permission_id: 'permission_id'
  };

  export type Auth_group_permissionsScalarFieldEnum = (typeof Auth_group_permissionsScalarFieldEnum)[keyof typeof Auth_group_permissionsScalarFieldEnum]


  export const Auth_permissionScalarFieldEnum: {
    id: 'id',
    codename: 'codename',
    content_type_id: 'content_type_id',
    id_: 'id_',
    name: 'name'
  };

  export type Auth_permissionScalarFieldEnum = (typeof Auth_permissionScalarFieldEnum)[keyof typeof Auth_permissionScalarFieldEnum]


  export const Authtoken_tokenScalarFieldEnum: {
    id: 'id',
    created: 'created',
    key: 'key',
    user_id: 'user_id'
  };

  export type Authtoken_tokenScalarFieldEnum = (typeof Authtoken_tokenScalarFieldEnum)[keyof typeof Authtoken_tokenScalarFieldEnum]


  export const CompetitorsScalarFieldEnum: {
    id: 'id',
    created_date: 'created_date',
    fk_group_id: 'fk_group_id',
    fk_user_id: 'fk_user_id',
    id_: 'id_',
    modified_date: 'modified_date',
    track_status: 'track_status',
    url: 'url'
  };

  export type CompetitorsScalarFieldEnum = (typeof CompetitorsScalarFieldEnum)[keyof typeof CompetitorsScalarFieldEnum]


  export const Django_admin_logScalarFieldEnum: {
    mongoId: 'mongoId',
    content_type_id: 'content_type_id',
    id: 'id',
    user_id: 'user_id'
  };

  export type Django_admin_logScalarFieldEnum = (typeof Django_admin_logScalarFieldEnum)[keyof typeof Django_admin_logScalarFieldEnum]


  export const Django_content_typeScalarFieldEnum: {
    id: 'id',
    app_label: 'app_label',
    id_: 'id_',
    model: 'model'
  };

  export type Django_content_typeScalarFieldEnum = (typeof Django_content_typeScalarFieldEnum)[keyof typeof Django_content_typeScalarFieldEnum]


  export const Django_migrationsScalarFieldEnum: {
    id: 'id',
    app: 'app',
    applied: 'applied',
    id_: 'id_',
    name: 'name'
  };

  export type Django_migrationsScalarFieldEnum = (typeof Django_migrationsScalarFieldEnum)[keyof typeof Django_migrationsScalarFieldEnum]


  export const Django_sessionScalarFieldEnum: {
    id: 'id',
    expire_date: 'expire_date',
    session_key: 'session_key'
  };

  export type Django_sessionScalarFieldEnum = (typeof Django_sessionScalarFieldEnum)[keyof typeof Django_sessionScalarFieldEnum]


  export const GroupScalarFieldEnum: {
    id: 'id',
    created_date: 'created_date',
    domain_name: 'domain_name',
    downtrend_cnt: 'downtrend_cnt',
    fk_user_id: 'fk_user_id',
    group_call_end: 'group_call_end',
    group_call_start: 'group_call_start',
    group_call_status: 'group_call_status',
    group_name: 'group_name',
    id_: 'id_',
    keyword_difficulty: 'keyword_difficulty',
    metric_status: 'metric_status',
    project_automation_time: 'project_automation_time',
    track_status: 'track_status',
    updated_date: 'updated_date',
    uptrend_cnt: 'uptrend_cnt'
  };

  export type GroupScalarFieldEnum = (typeof GroupScalarFieldEnum)[keyof typeof GroupScalarFieldEnum]


  export const KeywordScalarFieldEnum: {
    id: 'id',
    auto_call_status: 'auto_call_status',
    auto_refresh_count: 'auto_refresh_count',
    cpc: 'cpc',
    crawlurl: 'crawlurl',
    created_date: 'created_date',
    daymark: 'daymark',
    dayval: 'dayval',
    exactdomain: 'exactdomain',
    fk_group_id: 'fk_group_id',
    fk_user_id: 'fk_user_id',
    halfmonthmark: 'halfmonthmark',
    halfmonthval: 'halfmonthval',
    id_: 'id_',
    isocode: 'isocode',
    keyword: 'keyword',
    keyword_difficulty: 'keyword_difficulty',
    keyword_suggestions: 'keyword_suggestions',
    language: 'language',
    language_code: 'language_code',
    lastranked_date: 'lastranked_date',
    location: 'location',
    location_code: 'location_code',
    metric_status: 'metric_status',
    modified_date: 'modified_date',
    monthmark: 'monthmark',
    monthval: 'monthval',
    page_uuid: 'page_uuid',
    page_uuid_url: 'page_uuid_url',
    platform: 'platform',
    rank: 'rank',
    rank_sincestart: 'rank_sincestart',
    rank_trend: 'rank_trend',
    ranked_url: 'ranked_url',
    ranknow: 'ranknow',
    region: 'region',
    search_intent: 'search_intent',
    search_volume: 'search_volume',
    site_url: 'site_url',
    status_from_start: 'status_from_start',
    target: 'target',
    top_rank: 'top_rank',
    track_status: 'track_status',
    traffic: 'traffic',
    updated_date: 'updated_date',
    weekmark: 'weekmark',
    weekval: 'weekval'
  };

  export type KeywordScalarFieldEnum = (typeof KeywordScalarFieldEnum)[keyof typeof KeywordScalarFieldEnum]


  export const Keyword_metricsScalarFieldEnum: {
    mongoId: 'mongoId',
    fk_group_id: 'fk_group_id',
    fk_keyword_id: 'fk_keyword_id',
    fk_user_id: 'fk_user_id',
    id: 'id'
  };

  export type Keyword_metricsScalarFieldEnum = (typeof Keyword_metricsScalarFieldEnum)[keyof typeof Keyword_metricsScalarFieldEnum]


  export const LanguageScalarFieldEnum: {
    id: 'id',
    created_date: 'created_date',
    id_: 'id_',
    language_code: 'language_code',
    language_name: 'language_name',
    updated_date: 'updated_date'
  };

  export type LanguageScalarFieldEnum = (typeof LanguageScalarFieldEnum)[keyof typeof LanguageScalarFieldEnum]


  export const MainsettingsScalarFieldEnum: {
    mongoId: 'mongoId',
    id: 'id'
  };

  export type MainsettingsScalarFieldEnum = (typeof MainsettingsScalarFieldEnum)[keyof typeof MainsettingsScalarFieldEnum]


  export const RegionScalarFieldEnum: {
    id: 'id',
    created_date: 'created_date',
    id_: 'id_',
    region_code: 'region_code',
    region_country: 'region_country',
    region_name: 'region_name',
    searchvolume_country_id: 'searchvolume_country_id',
    updated_date: 'updated_date'
  };

  export type RegionScalarFieldEnum = (typeof RegionScalarFieldEnum)[keyof typeof RegionScalarFieldEnum]


  export const SortOrder: {
    asc: 'asc',
    desc: 'desc'
  };

  export type SortOrder = (typeof SortOrder)[keyof typeof SortOrder]


  export const QueryMode: {
    default: 'default',
    insensitive: 'insensitive'
  };

  export type QueryMode = (typeof QueryMode)[keyof typeof QueryMode]


  /**
   * Field references 
   */


  /**
   * Reference to a field of type 'String'
   */
  export type StringFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'String'>
    


  /**
   * Reference to a field of type 'String[]'
   */
  export type ListStringFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'String[]'>
    


  /**
   * Reference to a field of type 'DateTime'
   */
  export type DateTimeFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'DateTime'>
    


  /**
   * Reference to a field of type 'DateTime[]'
   */
  export type ListDateTimeFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'DateTime[]'>
    


  /**
   * Reference to a field of type 'Int'
   */
  export type IntFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Int'>
    


  /**
   * Reference to a field of type 'Int[]'
   */
  export type ListIntFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Int[]'>
    


  /**
   * Reference to a field of type 'Boolean'
   */
  export type BooleanFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Boolean'>
    


  /**
   * Reference to a field of type 'Json'
   */
  export type JsonFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Json'>
    


  /**
   * Reference to a field of type 'Float'
   */
  export type FloatFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Float'>
    


  /**
   * Reference to a field of type 'Float[]'
   */
  export type ListFloatFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Float[]'>
    
  /**
   * Deep Input Types
   */


  export type schema__WhereInput = {
    AND?: schema__WhereInput | schema__WhereInput[]
    OR?: schema__WhereInput[]
    NOT?: schema__WhereInput | schema__WhereInput[]
    id?: StringFilter<"schema__"> | string
    auto?: XOR<SchemaAutoNullableCompositeFilter, SchemaAutoObjectEqualityInput> | null
    fields?: XOR<SchemaFieldsCompositeFilter, SchemaFieldsObjectEqualityInput>
    name?: StringFilter<"schema__"> | string
  }

  export type schema__OrderByWithRelationInput = {
    id?: SortOrder
    auto?: SchemaAutoOrderByInput
    fields?: SchemaFieldsOrderByInput
    name?: SortOrder
  }

  export type schema__WhereUniqueInput = Prisma.AtLeast<{
    id?: string
    name?: string
    AND?: schema__WhereInput | schema__WhereInput[]
    OR?: schema__WhereInput[]
    NOT?: schema__WhereInput | schema__WhereInput[]
    auto?: XOR<SchemaAutoNullableCompositeFilter, SchemaAutoObjectEqualityInput> | null
    fields?: XOR<SchemaFieldsCompositeFilter, SchemaFieldsObjectEqualityInput>
  }, "id" | "name">

  export type schema__OrderByWithAggregationInput = {
    id?: SortOrder
    name?: SortOrder
    _count?: schema__CountOrderByAggregateInput
    _max?: schema__MaxOrderByAggregateInput
    _min?: schema__MinOrderByAggregateInput
  }

  export type schema__ScalarWhereWithAggregatesInput = {
    AND?: schema__ScalarWhereWithAggregatesInput | schema__ScalarWhereWithAggregatesInput[]
    OR?: schema__ScalarWhereWithAggregatesInput[]
    NOT?: schema__ScalarWhereWithAggregatesInput | schema__ScalarWhereWithAggregatesInput[]
    id?: StringWithAggregatesFilter<"schema__"> | string
    name?: StringWithAggregatesFilter<"schema__"> | string
  }

  export type accountWhereInput = {
    AND?: accountWhereInput | accountWhereInput[]
    OR?: accountWhereInput[]
    NOT?: accountWhereInput | accountWhereInput[]
    id?: StringFilter<"account"> | string
    account_status?: StringFilter<"account"> | string
    date_joined?: DateTimeFilter<"account"> | Date | string
    email?: StringFilter<"account"> | string
    id_?: IntFilter<"account"> | number
    is_active?: BoolFilter<"account"> | boolean
    is_admin?: BoolFilter<"account"> | boolean
    is_staff?: BoolFilter<"account"> | boolean
    is_superuser?: BoolFilter<"account"> | boolean
    last_home_visit?: JsonNullableFilter<"account">
    last_login?: DateTimeFilter<"account"> | Date | string
    last_logout?: DateTimeFilter<"account"> | Date | string
    password?: StringFilter<"account"> | string
    username?: StringFilter<"account"> | string
  }

  export type accountOrderByWithRelationInput = {
    id?: SortOrder
    account_status?: SortOrder
    date_joined?: SortOrder
    email?: SortOrder
    id_?: SortOrder
    is_active?: SortOrder
    is_admin?: SortOrder
    is_staff?: SortOrder
    is_superuser?: SortOrder
    last_home_visit?: SortOrder
    last_login?: SortOrder
    last_logout?: SortOrder
    password?: SortOrder
    username?: SortOrder
  }

  export type accountWhereUniqueInput = Prisma.AtLeast<{
    id?: string
    email?: string
    id_?: number
    AND?: accountWhereInput | accountWhereInput[]
    OR?: accountWhereInput[]
    NOT?: accountWhereInput | accountWhereInput[]
    account_status?: StringFilter<"account"> | string
    date_joined?: DateTimeFilter<"account"> | Date | string
    is_active?: BoolFilter<"account"> | boolean
    is_admin?: BoolFilter<"account"> | boolean
    is_staff?: BoolFilter<"account"> | boolean
    is_superuser?: BoolFilter<"account"> | boolean
    last_home_visit?: JsonNullableFilter<"account">
    last_login?: DateTimeFilter<"account"> | Date | string
    last_logout?: DateTimeFilter<"account"> | Date | string
    password?: StringFilter<"account"> | string
    username?: StringFilter<"account"> | string
  }, "id" | "email" | "id_">

  export type accountOrderByWithAggregationInput = {
    id?: SortOrder
    account_status?: SortOrder
    date_joined?: SortOrder
    email?: SortOrder
    id_?: SortOrder
    is_active?: SortOrder
    is_admin?: SortOrder
    is_staff?: SortOrder
    is_superuser?: SortOrder
    last_home_visit?: SortOrder
    last_login?: SortOrder
    last_logout?: SortOrder
    password?: SortOrder
    username?: SortOrder
    _count?: accountCountOrderByAggregateInput
    _avg?: accountAvgOrderByAggregateInput
    _max?: accountMaxOrderByAggregateInput
    _min?: accountMinOrderByAggregateInput
    _sum?: accountSumOrderByAggregateInput
  }

  export type accountScalarWhereWithAggregatesInput = {
    AND?: accountScalarWhereWithAggregatesInput | accountScalarWhereWithAggregatesInput[]
    OR?: accountScalarWhereWithAggregatesInput[]
    NOT?: accountScalarWhereWithAggregatesInput | accountScalarWhereWithAggregatesInput[]
    id?: StringWithAggregatesFilter<"account"> | string
    account_status?: StringWithAggregatesFilter<"account"> | string
    date_joined?: DateTimeWithAggregatesFilter<"account"> | Date | string
    email?: StringWithAggregatesFilter<"account"> | string
    id_?: IntWithAggregatesFilter<"account"> | number
    is_active?: BoolWithAggregatesFilter<"account"> | boolean
    is_admin?: BoolWithAggregatesFilter<"account"> | boolean
    is_staff?: BoolWithAggregatesFilter<"account"> | boolean
    is_superuser?: BoolWithAggregatesFilter<"account"> | boolean
    last_home_visit?: JsonNullableWithAggregatesFilter<"account">
    last_login?: DateTimeWithAggregatesFilter<"account"> | Date | string
    last_logout?: DateTimeWithAggregatesFilter<"account"> | Date | string
    password?: StringWithAggregatesFilter<"account"> | string
    username?: StringWithAggregatesFilter<"account"> | string
  }

  export type account_trackerWhereInput = {
    AND?: account_trackerWhereInput | account_trackerWhereInput[]
    OR?: account_trackerWhereInput[]
    NOT?: account_trackerWhereInput | account_trackerWhereInput[]
    id?: StringFilter<"account_tracker"> | string
    city?: JsonNullableFilter<"account_tracker">
    client_agent?: StringFilter<"account_tracker"> | string
    client_ip?: StringFilter<"account_tracker"> | string
    country?: JsonNullableFilter<"account_tracker">
    country_code?: JsonNullableFilter<"account_tracker">
    created_date?: DateTimeFilter<"account_tracker"> | Date | string
    fb_user_id?: IntFilter<"account_tracker"> | number
    id_?: IntFilter<"account_tracker"> | number
    mobile?: BoolFilter<"account_tracker"> | boolean
    modified_date?: DateTimeFilter<"account_tracker"> | Date | string
    other_info?: JsonFilter<"account_tracker">
    region?: JsonNullableFilter<"account_tracker">
    status?: StringFilter<"account_tracker"> | string
    time_zone?: JsonNullableFilter<"account_tracker">
    user_automation_time?: JsonNullableFilter<"account_tracker">
  }

  export type account_trackerOrderByWithRelationInput = {
    id?: SortOrder
    city?: SortOrder
    client_agent?: SortOrder
    client_ip?: SortOrder
    country?: SortOrder
    country_code?: SortOrder
    created_date?: SortOrder
    fb_user_id?: SortOrder
    id_?: SortOrder
    mobile?: SortOrder
    modified_date?: SortOrder
    other_info?: SortOrder
    region?: SortOrder
    status?: SortOrder
    time_zone?: SortOrder
    user_automation_time?: SortOrder
  }

  export type account_trackerWhereUniqueInput = Prisma.AtLeast<{
    id?: string
    id_?: number
    AND?: account_trackerWhereInput | account_trackerWhereInput[]
    OR?: account_trackerWhereInput[]
    NOT?: account_trackerWhereInput | account_trackerWhereInput[]
    city?: JsonNullableFilter<"account_tracker">
    client_agent?: StringFilter<"account_tracker"> | string
    client_ip?: StringFilter<"account_tracker"> | string
    country?: JsonNullableFilter<"account_tracker">
    country_code?: JsonNullableFilter<"account_tracker">
    created_date?: DateTimeFilter<"account_tracker"> | Date | string
    fb_user_id?: IntFilter<"account_tracker"> | number
    mobile?: BoolFilter<"account_tracker"> | boolean
    modified_date?: DateTimeFilter<"account_tracker"> | Date | string
    other_info?: JsonFilter<"account_tracker">
    region?: JsonNullableFilter<"account_tracker">
    status?: StringFilter<"account_tracker"> | string
    time_zone?: JsonNullableFilter<"account_tracker">
    user_automation_time?: JsonNullableFilter<"account_tracker">
  }, "id" | "id_">

  export type account_trackerOrderByWithAggregationInput = {
    id?: SortOrder
    city?: SortOrder
    client_agent?: SortOrder
    client_ip?: SortOrder
    country?: SortOrder
    country_code?: SortOrder
    created_date?: SortOrder
    fb_user_id?: SortOrder
    id_?: SortOrder
    mobile?: SortOrder
    modified_date?: SortO