
/**
 * Client
**/

import * as runtime from './runtime/library.js';
import $Types = runtime.Types // general types
import $Public = runtime.Types.Public
import $Utils = runtime.Types.Utils
import $Extensions = runtime.Types.Extensions
import $Result = runtime.Types.Result

export type PrismaPromise<T> = $Public.PrismaPromise<T>


/**
 * Model User
 * 
 */
export type User = $Result.DefaultSelection<Prisma.$UserPayload>
/**
 * Model UserDetails
 * 
 */
export type UserDetails = $Result.DefaultSelection<Prisma.$UserDetailsPayload>
/**
 * Model ProjectCategory
 * 
 */
export type ProjectCategory = $Result.DefaultSelection<Prisma.$ProjectCategoryPayload>
/**
 * Model Project
 * 
 */
export type Project = $Result.DefaultSelection<Prisma.$ProjectPayload>
/**
 * Model ProjectUser
 * 
 */
export type ProjectUser = $Result.DefaultSelection<Prisma.$ProjectUserPayload>
/**
 * Model Backlink
 * 
 */
export type Backlink = $Result.DefaultSelection<Prisma.$BacklinkPayload>
/**
 * Model Process
 * 
 */
export type Process = $Result.DefaultSelection<Prisma.$ProcessPayload>
/**
 * Model Team
 * 
 */
export type Team = $Result.DefaultSelection<Prisma.$TeamPayload>
/**
 * Model AssignTeamMember
 * 
 */
export type AssignTeamMember = $Result.DefaultSelection<Prisma.$AssignTeamMemberPayload>
/**
 * Model TempLinks
 * 
 */
export type TempLinks = $Result.DefaultSelection<Prisma.$TempLinksPayload>
/**
 * Model UserJobs
 * 
 */
export type UserJobs = $Result.DefaultSelection<Prisma.$UserJobsPayload>
/**
 * Model ProjectDetails
 * 
 */
export type ProjectDetails = $Result.DefaultSelection<Prisma.$ProjectDetailsPayload>
/**
 * Model ReferDomainCategory
 * 
 */
export type ReferDomainCategory = $Result.DefaultSelection<Prisma.$ReferDomainCategoryPayload>
/**
 * Model ReferDomain
 * 
 */
export type ReferDomain = $Result.DefaultSelection<Prisma.$ReferDomainPayload>
/**
 * Model GuideLines
 * 
 */
export type GuideLines = $Result.DefaultSelection<Prisma.$GuideLinesPayload>
/**
 * Model ProjectGuideLines
 * 
 */
export type ProjectGuideLines = $Result.DefaultSelection<Prisma.$ProjectGuideLinesPayload>
/**
 * Model seo_packages
 * 
 */
export type seo_packages = $Result.DefaultSelection<Prisma.$seo_packagesPayload>
/**
 * Model package_features
 * 
 */
export type package_features = $Result.DefaultSelection<Prisma.$package_featuresPayload>
/**
 * Model ranker_user
 * 
 */
export type ranker_user = $Result.DefaultSelection<Prisma.$ranker_userPayload>

/**
 * Enums
 */
export namespace $Enums {
  export const Status: {
  INACTIVE: 'INACTIVE',
  ACTIVE: 'ACTIVE',
  DELETED: 'DELETED'
};

export type Status = (typeof Status)[keyof typeof Status]


export const ProcessStatus: {
  PROCESSING: 'PROCESSING',
  COMPLETED: 'COMPLETED',
  FAIL: 'FAIL'
};

export type ProcessStatus = (typeof ProcessStatus)[keyof typeof ProcessStatus]


export const LinkStatus: {
  INITIAL: 'INITIAL',
  ONGOING: 'ONGOING',
  COMPLETED: 'COMPLETED',
  FAILED: 'FAILED'
};

export type LinkStatus = (typeof LinkStatus)[keyof typeof LinkStatus]


export const JobStatus: {
  INITIAL: 'INITIAL',
  ONGOING: 'ONGOING',
  COMPLETED: 'COMPLETED',
  FAILED: 'FAILED'
};

export type JobStatus = (typeof JobStatus)[keyof typeof JobStatus]

}

export type Status = $Enums.Status

export const Status: typeof $Enums.Status

export type ProcessStatus = $Enums.ProcessStatus

export const ProcessStatus: typeof $Enums.ProcessStatus

export type LinkStatus = $Enums.LinkStatus

export const LinkStatus: typeof $Enums.LinkStatus

export type JobStatus = $Enums.JobStatus

export const JobStatus: typeof $Enums.JobStatus

/**
 * ##  Prisma Client ʲˢ
 *
 * Type-safe database client for TypeScript & Node.js
 * @example
 * ```
 * const prisma = new PrismaClient()
 * // Fetch zero or more Users
 * const users = await prisma.user.findMany()
 * ```
 *
 *
 * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
 */
export class PrismaClient<
  ClientOptions extends Prisma.PrismaClientOptions = Prisma.PrismaClientOptions,
  U = 'log' extends keyof ClientOptions ? ClientOptions['log'] extends Array<Prisma.LogLevel | Prisma.LogDefinition> ? Prisma.GetEvents<ClientOptions['log']> : never : never,
  ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs
> {
  [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['other'] }

    /**
   * ##  Prisma Client ʲˢ
   *
   * Type-safe database client for TypeScript & Node.js
   * @example
   * ```
   * const prisma = new PrismaClient()
   * // Fetch zero or more Users
   * const users = await prisma.user.findMany()
   * ```
   *
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
   */

  constructor(optionsArg ?: Prisma.Subset<ClientOptions, Prisma.PrismaClientOptions>);
  $on<V extends U>(eventType: V, callback: (event: V extends 'query' ? Prisma.QueryEvent : Prisma.LogEvent) => void): void;

  /**
   * Connect with the database
   */
  $connect(): $Utils.JsPromise<void>;

  /**
   * Disconnect from the database
   */
  $disconnect(): $Utils.JsPromise<void>;

  /**
   * Add a middleware
   * @deprecated since 4.16.0. For new code, prefer client extensions instead.
   * @see https://pris.ly/d/extensions
   */
  $use(cb: Prisma.Middleware): void

/**
   * Executes a prepared raw query and returns the number of affected rows.
   * @example
   * ```
   * const result = await prisma.$executeRaw`UPDATE User SET cool = ${true} WHERE email = ${'user@email.com'};`
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Executes a raw query and returns the number of affected rows.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$executeRawUnsafe('UPDATE User SET cool = $1 WHERE email = $2 ;', true, 'user@email.com')
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Performs a prepared raw query and returns the `SELECT` data.
   * @example
   * ```
   * const result = await prisma.$queryRaw`SELECT * FROM User WHERE id = ${1} OR email = ${'user@email.com'};`
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<T>;

  /**
   * Performs a raw query and returns the `SELECT` data.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$queryRawUnsafe('SELECT * FROM User WHERE id = $1 OR email = $2;', 1, 'user@email.com')
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<T>;


  /**
   * Allows the running of a sequence of read/write operations that are guaranteed to either succeed or fail as a whole.
   * @example
   * ```
   * const [george, bob, alice] = await prisma.$transaction([
   *   prisma.user.create({ data: { name: 'George' } }),
   *   prisma.user.create({ data: { name: 'Bob' } }),
   *   prisma.user.create({ data: { name: 'Alice' } }),
   * ])
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/concepts/components/prisma-client/transactions).
   */
  $transaction<P extends Prisma.PrismaPromise<any>[]>(arg: [...P], options?: { isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<runtime.Types.Utils.UnwrapTuple<P>>

  $transaction<R>(fn: (prisma: Omit<PrismaClient, runtime.ITXClientDenyList>) => $Utils.JsPromise<R>, options?: { maxWait?: number, timeout?: number, isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<R>


  $extends: $Extensions.ExtendsHook<"extends", Prisma.TypeMapCb, ExtArgs, $Utils.Call<Prisma.TypeMapCb, {
    extArgs: ExtArgs
  }>, ClientOptions>

      /**
   * `prisma.user`: Exposes CRUD operations for the **User** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Users
    * const users = await prisma.user.findMany()
    * ```
    */
  get user(): Prisma.UserDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.userDetails`: Exposes CRUD operations for the **UserDetails** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more UserDetails
    * const userDetails = await prisma.userDetails.findMany()
    * ```
    */
  get userDetails(): Prisma.UserDetailsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.projectCategory`: Exposes CRUD operations for the **ProjectCategory** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ProjectCategories
    * const projectCategories = await prisma.projectCategory.findMany()
    * ```
    */
  get projectCategory(): Prisma.ProjectCategoryDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.project`: Exposes CRUD operations for the **Project** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Projects
    * const projects = await prisma.project.findMany()
    * ```
    */
  get project(): Prisma.ProjectDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.projectUser`: Exposes CRUD operations for the **ProjectUser** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ProjectUsers
    * const projectUsers = await prisma.projectUser.findMany()
    * ```
    */
  get projectUser(): Prisma.ProjectUserDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.backlink`: Exposes CRUD operations for the **Backlink** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Backlinks
    * const backlinks = await prisma.backlink.findMany()
    * ```
    */
  get backlink(): Prisma.BacklinkDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.process`: Exposes CRUD operations for the **Process** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Processes
    * const processes = await prisma.process.findMany()
    * ```
    */
  get process(): Prisma.ProcessDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.team`: Exposes CRUD operations for the **Team** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Teams
    * const teams = await prisma.team.findMany()
    * ```
    */
  get team(): Prisma.TeamDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.assignTeamMember`: Exposes CRUD operations for the **AssignTeamMember** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more AssignTeamMembers
    * const assignTeamMembers = await prisma.assignTeamMember.findMany()
    * ```
    */
  get assignTeamMember(): Prisma.AssignTeamMemberDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.tempLinks`: Exposes CRUD operations for the **TempLinks** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more TempLinks
    * const tempLinks = await prisma.tempLinks.findMany()
    * ```
    */
  get tempLinks(): Prisma.TempLinksDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.userJobs`: Exposes CRUD operations for the **UserJobs** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more UserJobs
    * const userJobs = await prisma.userJobs.findMany()
    * ```
    */
  get userJobs(): Prisma.UserJobsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.projectDetails`: Exposes CRUD operations for the **ProjectDetails** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ProjectDetails
    * const projectDetails = await prisma.projectDetails.findMany()
    * ```
    */
  get projectDetails(): Prisma.ProjectDetailsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.referDomainCategory`: Exposes CRUD operations for the **ReferDomainCategory** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ReferDomainCategories
    * const referDomainCategories = await prisma.referDomainCategory.findMany()
    * ```
    */
  get referDomainCategory(): Prisma.ReferDomainCategoryDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.referDomain`: Exposes CRUD operations for the **ReferDomain** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ReferDomains
    * const referDomains = await prisma.referDomain.findMany()
    * ```
    */
  get referDomain(): Prisma.ReferDomainDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.guideLines`: Exposes CRUD operations for the **GuideLines** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more GuideLines
    * const guideLines = await prisma.guideLines.findMany()
    * ```
    */
  get guideLines(): Prisma.GuideLinesDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.projectGuideLines`: Exposes CRUD operations for the **ProjectGuideLines** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more ProjectGuideLines
    * const projectGuideLines = await prisma.projectGuideLines.findMany()
    * ```
    */
  get projectGuideLines(): Prisma.ProjectGuideLinesDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.seo_packages`: Exposes CRUD operations for the **seo_packages** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Seo_packages
    * const seo_packages = await prisma.seo_packages.findMany()
    * ```
    */
  get seo_packages(): Prisma.seo_packagesDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.package_features`: Exposes CRUD operations for the **package_features** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Package_features
    * const package_features = await prisma.package_features.findMany()
    * ```
    */
  get package_features(): Prisma.package_featuresDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.ranker_user`: Exposes CRUD operations for the **ranker_user** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Ranker_users
    * const ranker_users = await prisma.ranker_user.findMany()
    * ```
    */
  get ranker_user(): Prisma.ranker_userDelegate<ExtArgs, ClientOptions>;
}

export namespace Prisma {
  export import DMMF = runtime.DMMF

  export type PrismaPromise<T> = $Public.PrismaPromise<T>

  /**
   * Validator
   */
  export import validator = runtime.Public.validator

  /**
   * Prisma Errors
   */
  export import PrismaClientKnownRequestError = runtime.PrismaClientKnownRequestError
  export import PrismaClientUnknownRequestError = runtime.PrismaClientUnknownRequestError
  export import PrismaClientRustPanicError = runtime.PrismaClientRustPanicError
  export import PrismaClientInitializationError = runtime.PrismaClientInitializationError
  export import PrismaClientValidationError = runtime.PrismaClientValidationError

  /**
   * Re-export of sql-template-tag
   */
  export import sql = runtime.sqltag
  export import empty = runtime.empty
  export import join = runtime.join
  export import raw = runtime.raw
  export import Sql = runtime.Sql



  /**
   * Decimal.js
   */
  export import Decimal = runtime.Decimal

  export type DecimalJsLike = runtime.DecimalJsLike

  /**
   * Metrics
   */
  export type Metrics = runtime.Metrics
  export type Metric<T> = runtime.Metric<T>
  export type MetricHistogram = runtime.MetricHistogram
  export type MetricHistogramBucket = runtime.MetricHistogramBucket

  /**
  * Extensions
  */
  export import Extension = $Extensions.UserArgs
  export import getExtensionContext = runtime.Extensions.getExtensionContext
  export import Args = $Public.Args
  export import Payload = $Public.Payload
  export import Result = $Public.Result
  export import Exact = $Public.Exact

  /**
   * Prisma Client JS version: 6.4.1
   * Query Engine version: a9055b89e58b4b5bfb59600785423b1db3d0e75d
   */
  export type PrismaVersion = {
    client: string
  }

  export const prismaVersion: PrismaVersion

  /**
   * Utility Types
   */


  export import JsonObject = runtime.JsonObject
  export import JsonArray = runtime.JsonArray
  export import JsonValue = runtime.JsonValue
  export import InputJsonObject = runtime.InputJsonObject
  export import InputJsonArray = runtime.InputJsonArray
  export import InputJsonValue = runtime.InputJsonValue

  /**
   * Types of the values used to represent different kinds of `null` values when working with JSON fields.
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  namespace NullTypes {
    /**
    * Type of `Prisma.DbNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.DbNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class DbNull {
      private DbNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.JsonNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.JsonNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class JsonNull {
      private JsonNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.AnyNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.AnyNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class AnyNull {
      private AnyNull: never
      private constructor()
    }
  }

  /**
   * Helper for filtering JSON entries that have `null` on the database (empty on the db)
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const DbNull: NullTypes.DbNull

  /**
   * Helper for filtering JSON entries that have JSON `null` values (not empty on the db)
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const JsonNull: NullTypes.JsonNull

  /**
   * Helper for filtering JSON entries that are `Prisma.DbNull` or `Prisma.JsonNull`
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const AnyNull: NullTypes.AnyNull

  type SelectAndInclude = {
    select: any
    include: any
  }

  type SelectAndOmit = {
    select: any
    omit: any
  }

  /**
   * Get the type of the value, that the Promise holds.
   */
  export type PromiseType<T extends PromiseLike<any>> = T extends PromiseLike<infer U> ? U : T;

  /**
   * Get the return type of a function which returns a Promise.
   */
  export type PromiseReturnType<T extends (...args: any) => $Utils.JsPromise<any>> = PromiseType<ReturnType<T>>

  /**
   * From T, pick a set of properties whose keys are in the union K
   */
  type Prisma__Pick<T, K extends keyof T> = {
      [P in K]: T[P];
  };


  export type Enumerable<T> = T | Array<T>;

  export type RequiredKeys<T> = {
    [K in keyof T]-?: {} extends Prisma__Pick<T, K> ? never : K
  }[keyof T]

  export type TruthyKeys<T> = keyof {
    [K in keyof T as T[K] extends false | undefined | null ? never : K]: K
  }

  export type TrueKeys<T> = TruthyKeys<Prisma__Pick<T, RequiredKeys<T>>>

  /**
   * Subset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection
   */
  export type Subset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never;
  };

  /**
   * SelectSubset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection.
   * Additionally, it validates, if both select and include are present. If the case, it errors.
   */
  export type SelectSubset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    (T extends SelectAndInclude
      ? 'Please either choose `select` or `include`.'
      : T extends SelectAndOmit
        ? 'Please either choose `select` or `omit`.'
        : {})

  /**
   * Subset + Intersection
   * @desc From `T` pick properties that exist in `U` and intersect `K`
   */
  export type SubsetIntersection<T, U, K> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    K

  type Without<T, U> = { [P in Exclude<keyof T, keyof U>]?: never };

  /**
   * XOR is needed to have a real mutually exclusive union type
   * https://stackoverflow.com/questions/42123407/does-typescript-support-mutually-exclusive-types
   */
  type XOR<T, U> =
    T extends object ?
    U extends object ?
      (Without<T, U> & U) | (Without<U, T> & T)
    : U : T


  /**
   * Is T a Record?
   */
  type IsObject<T extends any> = T extends Array<any>
  ? False
  : T extends Date
  ? False
  : T extends Uint8Array
  ? False
  : T extends BigInt
  ? False
  : T extends object
  ? True
  : False


  /**
   * If it's T[], return T
   */
  export type UnEnumerate<T extends unknown> = T extends Array<infer U> ? U : T

  /**
   * From ts-toolbelt
   */

  type __Either<O extends object, K extends Key> = Omit<O, K> &
    {
      // Merge all but K
      [P in K]: Prisma__Pick<O, P & keyof O> // With K possibilities
    }[K]

  type EitherStrict<O extends object, K extends Key> = Strict<__Either<O, K>>

  type EitherLoose<O extends object, K extends Key> = ComputeRaw<__Either<O, K>>

  type _Either<
    O extends object,
    K extends Key,
    strict extends Boolean
  > = {
    1: EitherStrict<O, K>
    0: EitherLoose<O, K>
  }[strict]

  type Either<
    O extends object,
    K extends Key,
    strict extends Boolean = 1
  > = O extends unknown ? _Either<O, K, strict> : never

  export type Union = any

  type PatchUndefined<O extends object, O1 extends object> = {
    [K in keyof O]: O[K] extends undefined ? At<O1, K> : O[K]
  } & {}

  /** Helper Types for "Merge" **/
  export type IntersectOf<U extends Union> = (
    U extends unknown ? (k: U) => void : never
  ) extends (k: infer I) => void
    ? I
    : never

  export type Overwrite<O extends object, O1 extends object> = {
      [K in keyof O]: K extends keyof O1 ? O1[K] : O[K];
  } & {};

  type _Merge<U extends object> = IntersectOf<Overwrite<U, {
      [K in keyof U]-?: At<U, K>;
  }>>;

  type Key = string | number | symbol;
  type AtBasic<O extends object, K extends Key> = K extends keyof O ? O[K] : never;
  type AtStrict<O extends object, K extends Key> = O[K & keyof O];
  type AtLoose<O extends object, K extends Key> = O extends unknown ? AtStrict<O, K> : never;
  export type At<O extends object, K extends Key, strict extends Boolean = 1> = {
      1: AtStrict<O, K>;
      0: AtLoose<O, K>;
  }[strict];

  export type ComputeRaw<A extends any> = A extends Function ? A : {
    [K in keyof A]: A[K];
  } & {};

  export type OptionalFlat<O> = {
    [K in keyof O]?: O[K];
  } & {};

  type _Record<K extends keyof any, T> = {
    [P in K]: T;
  };

  // cause typescript not to expand types and preserve names
  type NoExpand<T> = T extends unknown ? T : never;

  // this type assumes the passed object is entirely optional
  type AtLeast<O extends object, K extends string> = NoExpand<
    O extends unknown
    ? | (K extends keyof O ? { [P in K]: O[P] } & O : O)
      | {[P in keyof O as P extends K ? K : never]-?: O[P]} & O
    : never>;

  type _Strict<U, _U = U> = U extends unknown ? U & OptionalFlat<_Record<Exclude<Keys<_U>, keyof U>, never>> : never;

  export type Strict<U extends object> = ComputeRaw<_Strict<U>>;
  /** End Helper Types for "Merge" **/

  export type Merge<U extends object> = ComputeRaw<_Merge<Strict<U>>>;

  /**
  A [[Boolean]]
  */
  export type Boolean = True | False

  // /**
  // 1
  // */
  export type True = 1

  /**
  0
  */
  export type False = 0

  export type Not<B extends Boolean> = {
    0: 1
    1: 0
  }[B]

  export type Extends<A1 extends any, A2 extends any> = [A1] extends [never]
    ? 0 // anything `never` is false
    : A1 extends A2
    ? 1
    : 0

  export type Has<U extends Union, U1 extends Union> = Not<
    Extends<Exclude<U1, U>, U1>
  >

  export type Or<B1 extends Boolean, B2 extends Boolean> = {
    0: {
      0: 0
      1: 1
    }
    1: {
      0: 1
      1: 1
    }
  }[B1][B2]

  export type Keys<U extends Union> = U extends unknown ? keyof U : never

  type Cast<A, B> = A extends B ? A : B;

  export const type: unique symbol;



  /**
   * Used by group by
   */

  export type GetScalarType<T, O> = O extends object ? {
    [P in keyof T]: P extends keyof O
      ? O[P]
      : never
  } : never

  type FieldPaths<
    T,
    U = Omit<T, '_avg' | '_sum' | '_count' | '_min' | '_max'>
  > = IsObject<T> extends True ? U : T

  type GetHavingFields<T> = {
    [K in keyof T]: Or<
      Or<Extends<'OR', K>, Extends<'AND', K>>,
      Extends<'NOT', K>
    > extends True
      ? // infer is only needed to not hit TS limit
        // based on the brilliant idea of Pierre-Antoine Mills
        // https://github.com/microsoft/TypeScript/issues/30188#issuecomment-478938437
        T[K] extends infer TK
        ? GetHavingFields<UnEnumerate<TK> extends object ? Merge<UnEnumerate<TK>> : never>
        : never
      : {} extends FieldPaths<T[K]>
      ? never
      : K
  }[keyof T]

  /**
   * Convert tuple to union
   */
  type _TupleToUnion<T> = T extends (infer E)[] ? E : never
  type TupleToUnion<K extends readonly any[]> = _TupleToUnion<K>
  type MaybeTupleToUnion<T> = T extends any[] ? TupleToUnion<T> : T

  /**
   * Like `Pick`, but additionally can also accept an array of keys
   */
  type PickEnumerable<T, K extends Enumerable<keyof T> | keyof T> = Prisma__Pick<T, MaybeTupleToUnion<K>>

  /**
   * Exclude all keys with underscores
   */
  type ExcludeUnderscoreKeys<T extends string> = T extends `_${string}` ? never : T


  export type FieldRef<Model, FieldType> = runtime.FieldRef<Model, FieldType>

  type FieldRefInputType<Model, FieldType> = Model extends never ? never : FieldRef<Model, FieldType>


  export const ModelName: {
    User: 'User',
    UserDetails: 'UserDetails',
    ProjectCategory: 'ProjectCategory',
    Project: 'Project',
    ProjectUser: 'ProjectUser',
    Backlink: 'Backlink',
    Process: 'Process',
    Team: 'Team',
    AssignTeamMember: 'AssignTeamMember',
    TempLinks: 'TempLinks',
    UserJobs: 'UserJobs',
    ProjectDetails: 'ProjectDetails',
    ReferDomainCategory: 'ReferDomainCategory',
    ReferDomain: 'ReferDomain',
    GuideLines: 'GuideLines',
    ProjectGuideLines: 'ProjectGuideLines',
    seo_packages: 'seo_packages',
    package_features: 'package_features',
    ranker_user: 'ranker_user'
  };

  export type ModelName = (typeof ModelName)[keyof typeof ModelName]


  export type Datasources = {
    db?: Datasource
  }

  interface TypeMapCb extends $Utils.Fn<{extArgs: $Extensions.InternalArgs, clientOptions: PrismaClientOptions }, $Utils.Record<string, any>> {
    returns: Prisma.TypeMap<this['params']['extArgs'], this['params']['clientOptions']>
  }

  export type TypeMap<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> = {
    meta: {
      modelProps: "user" | "userDetails" | "projectCategory" | "project" | "projectUser" | "backlink" | "process" | "team" | "assignTeamMember" | "tempLinks" | "userJobs" | "projectDetails" | "referDomainCategory" | "referDomain" | "guideLines" | "projectGuideLines" | "seo_packages" | "package_features" | "ranker_user"
      txIsolationLevel: Prisma.TransactionIsolationLevel
    }
    model: {
      User: {
        payload: Prisma.$UserPayload<ExtArgs>
        fields: Prisma.UserFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UserFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UserFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          findFirst: {
            args: Prisma.UserFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UserFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          findMany: {
            args: Prisma.UserFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>[]
          }
          create: {
            args: Prisma.UserCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          createMany: {
            args: Prisma.UserCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.UserCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>[]
          }
          delete: {
            args: Prisma.UserDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          update: {
            args: Prisma.UserUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          deleteMany: {
            args: Prisma.UserDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.UserUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.UserUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>[]
          }
          upsert: {
            args: Prisma.UserUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          aggregate: {
            args: Prisma.UserAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateUser>
          }
          groupBy: {
            args: Prisma.UserGroupByArgs<ExtArgs>
            result: $Utils.Optional<UserGroupByOutputType>[]
          }
          count: {
            args: Prisma.UserCountArgs<ExtArgs>
            result: $Utils.Optional<UserCountAggregateOutputType> | number
          }
        }
      }
      UserDetails: {
        payload: Prisma.$UserDetailsPayload<ExtArgs>
        fields: Prisma.UserDetailsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UserDetailsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserDetailsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UserDetailsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserDetailsPayload>
          }
          findFirst: {
            args: Prisma.UserDetailsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserDetailsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UserDetailsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserDetailsPayload>
          }
          findMany: {
            args: Prisma.UserDetailsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserDetailsPayload>[]
          }
          create: {
            args: Prisma.UserDetailsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserDetailsPayload>
          }
          createMany: {
            args: Prisma.UserDetailsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.UserDetailsCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserDetailsPayload>[]
          }
          delete: {
            args: Prisma.UserDetailsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserDetailsPayload>
          }
          update: {
            args: Prisma.UserDetailsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserDetailsPayload>
          }
          deleteMany: {
            args: Prisma.UserDetailsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.UserDetailsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.UserDetailsUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserDetailsPayload>[]
          }
          upsert: {
            args: Prisma.UserDetailsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserDetailsPayload>
          }
          aggregate: {
            args: Prisma.UserDetailsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateUserDetails>
          }
          groupBy: {
            args: Prisma.UserDetailsGroupByArgs<ExtArgs>
            result: $Utils.Optional<UserDetailsGroupByOutputType>[]
          }
          count: {
            args: Prisma.UserDetailsCountArgs<ExtArgs>
            result: $Utils.Optional<UserDetailsCountAggregateOutputType> | number
          }
        }
      }
      ProjectCategory: {
        payload: Prisma.$ProjectCategoryPayload<ExtArgs>
        fields: Prisma.ProjectCategoryFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ProjectCategoryFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectCategoryPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ProjectCategoryFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectCategoryPayload>
          }
          findFirst: {
            args: Prisma.ProjectCategoryFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectCategoryPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ProjectCategoryFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectCategoryPayload>
          }
          findMany: {
            args: Prisma.ProjectCategoryFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectCategoryPayload>[]
          }
          create: {
            args: Prisma.ProjectCategoryCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectCategoryPayload>
          }
          createMany: {
            args: Prisma.ProjectCategoryCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ProjectCategoryCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectCategoryPayload>[]
          }
          delete: {
            args: Prisma.ProjectCategoryDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectCategoryPayload>
          }
          update: {
            args: Prisma.ProjectCategoryUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectCategoryPayload>
          }
          deleteMany: {
            args: Prisma.ProjectCategoryDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ProjectCategoryUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.ProjectCategoryUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectCategoryPayload>[]
          }
          upsert: {
            args: Prisma.ProjectCategoryUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectCategoryPayload>
          }
          aggregate: {
            args: Prisma.ProjectCategoryAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateProjectCategory>
          }
          groupBy: {
            args: Prisma.ProjectCategoryGroupByArgs<ExtArgs>
            result: $Utils.Optional<ProjectCategoryGroupByOutputType>[]
          }
          count: {
            args: Prisma.ProjectCategoryCountArgs<ExtArgs>
            result: $Utils.Optional<ProjectCategoryCountAggregateOutputType> | number
          }
        }
      }
      Project: {
        payload: Prisma.$ProjectPayload<ExtArgs>
        fields: Prisma.ProjectFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ProjectFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ProjectFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectPayload>
          }
          findFirst: {
            args: Prisma.ProjectFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ProjectFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectPayload>
          }
          findMany: {
            args: Prisma.ProjectFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectPayload>[]
          }
          create: {
            args: Prisma.ProjectCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectPayload>
          }
          createMany: {
            args: Prisma.ProjectCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ProjectCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectPayload>[]
          }
          delete: {
            args: Prisma.ProjectDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectPayload>
          }
          update: {
            args: Prisma.ProjectUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectPayload>
          }
          deleteMany: {
            args: Prisma.ProjectDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ProjectUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.ProjectUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectPayload>[]
          }
          upsert: {
            args: Prisma.ProjectUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectPayload>
          }
          aggregate: {
            args: Prisma.ProjectAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateProject>
          }
          groupBy: {
            args: Prisma.ProjectGroupByArgs<ExtArgs>
            result: $Utils.Optional<ProjectGroupByOutputType>[]
          }
          count: {
            args: Prisma.ProjectCountArgs<ExtArgs>
            result: $Utils.Optional<ProjectCountAggregateOutputType> | number
          }
        }
      }
      ProjectUser: {
        payload: Prisma.$ProjectUserPayload<ExtArgs>
        fields: Prisma.ProjectUserFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ProjectUserFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectUserPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ProjectUserFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectUserPayload>
          }
          findFirst: {
            args: Prisma.ProjectUserFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectUserPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ProjectUserFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectUserPayload>
          }
          findMany: {
            args: Prisma.ProjectUserFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectUserPayload>[]
          }
          create: {
            args: Prisma.ProjectUserCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectUserPayload>
          }
          createMany: {
            args: Prisma.ProjectUserCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ProjectUserCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectUserPayload>[]
          }
          delete: {
            args: Prisma.ProjectUserDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectUserPayload>
          }
          update: {
            args: Prisma.ProjectUserUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectUserPayload>
          }
          deleteMany: {
            args: Prisma.ProjectUserDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ProjectUserUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.ProjectUserUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectUserPayload>[]
          }
          upsert: {
            args: Prisma.ProjectUserUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectUserPayload>
          }
          aggregate: {
            args: Prisma.ProjectUserAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateProjectUser>
          }
          groupBy: {
            args: Prisma.ProjectUserGroupByArgs<ExtArgs>
            result: $Utils.Optional<ProjectUserGroupByOutputType>[]
          }
          count: {
            args: Prisma.ProjectUserCountArgs<ExtArgs>
            result: $Utils.Optional<ProjectUserCountAggregateOutputType> | number
          }
        }
      }
      Backlink: {
        payload: Prisma.$BacklinkPayload<ExtArgs>
        fields: Prisma.BacklinkFieldRefs
        operations: {
          findUnique: {
            args: Prisma.BacklinkFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BacklinkPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.BacklinkFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BacklinkPayload>
          }
          findFirst: {
            args: Prisma.BacklinkFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BacklinkPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.BacklinkFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BacklinkPayload>
          }
          findMany: {
            args: Prisma.BacklinkFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BacklinkPayload>[]
          }
          create: {
            args: Prisma.BacklinkCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BacklinkPayload>
          }
          createMany: {
            args: Prisma.BacklinkCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.BacklinkCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BacklinkPayload>[]
          }
          delete: {
            args: Prisma.BacklinkDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BacklinkPayload>
          }
          update: {
            args: Prisma.BacklinkUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BacklinkPayload>
          }
          deleteMany: {
            args: Prisma.BacklinkDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.BacklinkUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.BacklinkUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BacklinkPayload>[]
          }
          upsert: {
            args: Prisma.BacklinkUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BacklinkPayload>
          }
          aggregate: {
            args: Prisma.BacklinkAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateBacklink>
          }
          groupBy: {
            args: Prisma.BacklinkGroupByArgs<ExtArgs>
            result: $Utils.Optional<BacklinkGroupByOutputType>[]
          }
          count: {
            args: Prisma.BacklinkCountArgs<ExtArgs>
            result: $Utils.Optional<BacklinkCountAggregateOutputType> | number
          }
        }
      }
      Process: {
        payload: Prisma.$ProcessPayload<ExtArgs>
        fields: Prisma.ProcessFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ProcessFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProcessPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ProcessFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProcessPayload>
          }
          findFirst: {
            args: Prisma.ProcessFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProcessPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ProcessFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProcessPayload>
          }
          findMany: {
            args: Prisma.ProcessFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProcessPayload>[]
          }
          create: {
            args: Prisma.ProcessCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProcessPayload>
          }
          createMany: {
            args: Prisma.ProcessCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ProcessCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProcessPayload>[]
          }
          delete: {
            args: Prisma.ProcessDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProcessPayload>
          }
          update: {
            args: Prisma.ProcessUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProcessPayload>
          }
          deleteMany: {
            args: Prisma.ProcessDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ProcessUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.ProcessUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProcessPayload>[]
          }
          upsert: {
            args: Prisma.ProcessUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProcessPayload>
          }
          aggregate: {
            args: Prisma.ProcessAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateProcess>
          }
          groupBy: {
            args: Prisma.ProcessGroupByArgs<ExtArgs>
            result: $Utils.Optional<ProcessGroupByOutputType>[]
          }
          count: {
            args: Prisma.ProcessCountArgs<ExtArgs>
            result: $Utils.Optional<ProcessCountAggregateOutputType> | number
          }
        }
      }
      Team: {
        payload: Prisma.$TeamPayload<ExtArgs>
        fields: Prisma.TeamFieldRefs
        operations: {
          findUnique: {
            args: Prisma.TeamFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TeamPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.TeamFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TeamPayload>
          }
          findFirst: {
            args: Prisma.TeamFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TeamPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.TeamFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TeamPayload>
          }
          findMany: {
            args: Prisma.TeamFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TeamPayload>[]
          }
          create: {
            args: Prisma.TeamCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TeamPayload>
          }
          createMany: {
            args: Prisma.TeamCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.TeamCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TeamPayload>[]
          }
          delete: {
            args: Prisma.TeamDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TeamPayload>
          }
          update: {
            args: Prisma.TeamUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TeamPayload>
          }
          deleteMany: {
            args: Prisma.TeamDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.TeamUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.TeamUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TeamPayload>[]
          }
          upsert: {
            args: Prisma.TeamUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TeamPayload>
          }
          aggregate: {
            args: Prisma.TeamAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateTeam>
          }
          groupBy: {
            args: Prisma.TeamGroupByArgs<ExtArgs>
            result: $Utils.Optional<TeamGroupByOutputType>[]
          }
          count: {
            args: Prisma.TeamCountArgs<ExtArgs>
            result: $Utils.Optional<TeamCountAggregateOutputType> | number
          }
        }
      }
      AssignTeamMember: {
        payload: Prisma.$AssignTeamMemberPayload<ExtArgs>
        fields: Prisma.AssignTeamMemberFieldRefs
        operations: {
          findUnique: {
            args: Prisma.AssignTeamMemberFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AssignTeamMemberPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.AssignTeamMemberFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AssignTeamMemberPayload>
          }
          findFirst: {
            args: Prisma.AssignTeamMemberFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AssignTeamMemberPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.AssignTeamMemberFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AssignTeamMemberPayload>
          }
          findMany: {
            args: Prisma.AssignTeamMemberFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AssignTeamMemberPayload>[]
          }
          create: {
            args: Prisma.AssignTeamMemberCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AssignTeamMemberPayload>
          }
          createMany: {
            args: Prisma.AssignTeamMemberCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.AssignTeamMemberCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AssignTeamMemberPayload>[]
          }
          delete: {
            args: Prisma.AssignTeamMemberDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AssignTeamMemberPayload>
          }
          update: {
            args: Prisma.AssignTeamMemberUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AssignTeamMemberPayload>
          }
          deleteMany: {
            args: Prisma.AssignTeamMemberDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.AssignTeamMemberUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.AssignTeamMemberUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AssignTeamMemberPayload>[]
          }
          upsert: {
            args: Prisma.AssignTeamMemberUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$AssignTeamMemberPayload>
          }
          aggregate: {
            args: Prisma.AssignTeamMemberAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateAssignTeamMember>
          }
          groupBy: {
            args: Prisma.AssignTeamMemberGroupByArgs<ExtArgs>
            result: $Utils.Optional<AssignTeamMemberGroupByOutputType>[]
          }
          count: {
            args: Prisma.AssignTeamMemberCountArgs<ExtArgs>
            result: $Utils.Optional<AssignTeamMemberCountAggregateOutputType> | number
          }
        }
      }
      TempLinks: {
        payload: Prisma.$TempLinksPayload<ExtArgs>
        fields: Prisma.TempLinksFieldRefs
        operations: {
          findUnique: {
            args: Prisma.TempLinksFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TempLinksPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.TempLinksFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TempLinksPayload>
          }
          findFirst: {
            args: Prisma.TempLinksFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TempLinksPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.TempLinksFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TempLinksPayload>
          }
          findMany: {
            args: Prisma.TempLinksFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TempLinksPayload>[]
          }
          create: {
            args: Prisma.TempLinksCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TempLinksPayload>
          }
          createMany: {
            args: Prisma.TempLinksCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.TempLinksCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TempLinksPayload>[]
          }
          delete: {
            args: Prisma.TempLinksDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TempLinksPayload>
          }
          update: {
            args: Prisma.TempLinksUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TempLinksPayload>
          }
          deleteMany: {
            args: Prisma.TempLinksDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.TempLinksUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.TempLinksUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TempLinksPayload>[]
          }
          upsert: {
            args: Prisma.TempLinksUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$TempLinksPayload>
          }
          aggregate: {
            args: Prisma.TempLinksAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateTempLinks>
          }
          groupBy: {
            args: Prisma.TempLinksGroupByArgs<ExtArgs>
            result: $Utils.Optional<TempLinksGroupByOutputType>[]
          }
          count: {
            args: Prisma.TempLinksCountArgs<ExtArgs>
            result: $Utils.Optional<TempLinksCountAggregateOutputType> | number
          }
        }
      }
      UserJobs: {
        payload: Prisma.$UserJobsPayload<ExtArgs>
        fields: Prisma.UserJobsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UserJobsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserJobsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UserJobsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserJobsPayload>
          }
          findFirst: {
            args: Prisma.UserJobsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserJobsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UserJobsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserJobsPayload>
          }
          findMany: {
            args: Prisma.UserJobsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserJobsPayload>[]
          }
          create: {
            args: Prisma.UserJobsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserJobsPayload>
          }
          createMany: {
            args: Prisma.UserJobsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.UserJobsCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserJobsPayload>[]
          }
          delete: {
            args: Prisma.UserJobsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserJobsPayload>
          }
          update: {
            args: Prisma.UserJobsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserJobsPayload>
          }
          deleteMany: {
            args: Prisma.UserJobsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.UserJobsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.UserJobsUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserJobsPayload>[]
          }
          upsert: {
            args: Prisma.UserJobsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$UserJobsPayload>
          }
          aggregate: {
            args: Prisma.UserJobsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateUserJobs>
          }
          groupBy: {
            args: Prisma.UserJobsGroupByArgs<ExtArgs>
            result: $Utils.Optional<UserJobsGroupByOutputType>[]
          }
          count: {
            args: Prisma.UserJobsCountArgs<ExtArgs>
            result: $Utils.Optional<UserJobsCountAggregateOutputType> | number
          }
        }
      }
      ProjectDetails: {
        payload: Prisma.$ProjectDetailsPayload<ExtArgs>
        fields: Prisma.ProjectDetailsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ProjectDetailsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectDetailsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ProjectDetailsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectDetailsPayload>
          }
          findFirst: {
            args: Prisma.ProjectDetailsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectDetailsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ProjectDetailsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectDetailsPayload>
          }
          findMany: {
            args: Prisma.ProjectDetailsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectDetailsPayload>[]
          }
          create: {
            args: Prisma.ProjectDetailsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectDetailsPayload>
          }
          createMany: {
            args: Prisma.ProjectDetailsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ProjectDetailsCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectDetailsPayload>[]
          }
          delete: {
            args: Prisma.ProjectDetailsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectDetailsPayload>
          }
          update: {
            args: Prisma.ProjectDetailsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectDetailsPayload>
          }
          deleteMany: {
            args: Prisma.ProjectDetailsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ProjectDetailsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.ProjectDetailsUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectDetailsPayload>[]
          }
          upsert: {
            args: Prisma.ProjectDetailsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectDetailsPayload>
          }
          aggregate: {
            args: Prisma.ProjectDetailsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateProjectDetails>
          }
          groupBy: {
            args: Prisma.ProjectDetailsGroupByArgs<ExtArgs>
            result: $Utils.Optional<ProjectDetailsGroupByOutputType>[]
          }
          count: {
            args: Prisma.ProjectDetailsCountArgs<ExtArgs>
            result: $Utils.Optional<ProjectDetailsCountAggregateOutputType> | number
          }
        }
      }
      ReferDomainCategory: {
        payload: Prisma.$ReferDomainCategoryPayload<ExtArgs>
        fields: Prisma.ReferDomainCategoryFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ReferDomainCategoryFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferDomainCategoryPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ReferDomainCategoryFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferDomainCategoryPayload>
          }
          findFirst: {
            args: Prisma.ReferDomainCategoryFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferDomainCategoryPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ReferDomainCategoryFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferDomainCategoryPayload>
          }
          findMany: {
            args: Prisma.ReferDomainCategoryFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferDomainCategoryPayload>[]
          }
          create: {
            args: Prisma.ReferDomainCategoryCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferDomainCategoryPayload>
          }
          createMany: {
            args: Prisma.ReferDomainCategoryCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ReferDomainCategoryCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferDomainCategoryPayload>[]
          }
          delete: {
            args: Prisma.ReferDomainCategoryDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferDomainCategoryPayload>
          }
          update: {
            args: Prisma.ReferDomainCategoryUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferDomainCategoryPayload>
          }
          deleteMany: {
            args: Prisma.ReferDomainCategoryDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ReferDomainCategoryUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.ReferDomainCategoryUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferDomainCategoryPayload>[]
          }
          upsert: {
            args: Prisma.ReferDomainCategoryUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferDomainCategoryPayload>
          }
          aggregate: {
            args: Prisma.ReferDomainCategoryAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateReferDomainCategory>
          }
          groupBy: {
            args: Prisma.ReferDomainCategoryGroupByArgs<ExtArgs>
            result: $Utils.Optional<ReferDomainCategoryGroupByOutputType>[]
          }
          count: {
            args: Prisma.ReferDomainCategoryCountArgs<ExtArgs>
            result: $Utils.Optional<ReferDomainCategoryCountAggregateOutputType> | number
          }
        }
      }
      ReferDomain: {
        payload: Prisma.$ReferDomainPayload<ExtArgs>
        fields: Prisma.ReferDomainFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ReferDomainFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferDomainPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ReferDomainFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferDomainPayload>
          }
          findFirst: {
            args: Prisma.ReferDomainFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferDomainPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ReferDomainFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferDomainPayload>
          }
          findMany: {
            args: Prisma.ReferDomainFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferDomainPayload>[]
          }
          create: {
            args: Prisma.ReferDomainCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferDomainPayload>
          }
          createMany: {
            args: Prisma.ReferDomainCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ReferDomainCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferDomainPayload>[]
          }
          delete: {
            args: Prisma.ReferDomainDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferDomainPayload>
          }
          update: {
            args: Prisma.ReferDomainUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferDomainPayload>
          }
          deleteMany: {
            args: Prisma.ReferDomainDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ReferDomainUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.ReferDomainUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferDomainPayload>[]
          }
          upsert: {
            args: Prisma.ReferDomainUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ReferDomainPayload>
          }
          aggregate: {
            args: Prisma.ReferDomainAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateReferDomain>
          }
          groupBy: {
            args: Prisma.ReferDomainGroupByArgs<ExtArgs>
            result: $Utils.Optional<ReferDomainGroupByOutputType>[]
          }
          count: {
            args: Prisma.ReferDomainCountArgs<ExtArgs>
            result: $Utils.Optional<ReferDomainCountAggregateOutputType> | number
          }
        }
      }
      GuideLines: {
        payload: Prisma.$GuideLinesPayload<ExtArgs>
        fields: Prisma.GuideLinesFieldRefs
        operations: {
          findUnique: {
            args: Prisma.GuideLinesFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GuideLinesPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.GuideLinesFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GuideLinesPayload>
          }
          findFirst: {
            args: Prisma.GuideLinesFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GuideLinesPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.GuideLinesFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GuideLinesPayload>
          }
          findMany: {
            args: Prisma.GuideLinesFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GuideLinesPayload>[]
          }
          create: {
            args: Prisma.GuideLinesCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GuideLinesPayload>
          }
          createMany: {
            args: Prisma.GuideLinesCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.GuideLinesCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GuideLinesPayload>[]
          }
          delete: {
            args: Prisma.GuideLinesDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GuideLinesPayload>
          }
          update: {
            args: Prisma.GuideLinesUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GuideLinesPayload>
          }
          deleteMany: {
            args: Prisma.GuideLinesDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.GuideLinesUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.GuideLinesUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GuideLinesPayload>[]
          }
          upsert: {
            args: Prisma.GuideLinesUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$GuideLinesPayload>
          }
          aggregate: {
            args: Prisma.GuideLinesAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateGuideLines>
          }
          groupBy: {
            args: Prisma.GuideLinesGroupByArgs<ExtArgs>
            result: $Utils.Optional<GuideLinesGroupByOutputType>[]
          }
          count: {
            args: Prisma.GuideLinesCountArgs<ExtArgs>
            result: $Utils.Optional<GuideLinesCountAggregateOutputType> | number
          }
        }
      }
      ProjectGuideLines: {
        payload: Prisma.$ProjectGuideLinesPayload<ExtArgs>
        fields: Prisma.ProjectGuideLinesFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ProjectGuideLinesFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectGuideLinesPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ProjectGuideLinesFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectGuideLinesPayload>
          }
          findFirst: {
            args: Prisma.ProjectGuideLinesFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectGuideLinesPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ProjectGuideLinesFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectGuideLinesPayload>
          }
          findMany: {
            args: Prisma.ProjectGuideLinesFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectGuideLinesPayload>[]
          }
          create: {
            args: Prisma.ProjectGuideLinesCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectGuideLinesPayload>
          }
          createMany: {
            args: Prisma.ProjectGuideLinesCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ProjectGuideLinesCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectGuideLinesPayload>[]
          }
          delete: {
            args: Prisma.ProjectGuideLinesDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectGuideLinesPayload>
          }
          update: {
            args: Prisma.ProjectGuideLinesUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectGuideLinesPayload>
          }
          deleteMany: {
            args: Prisma.ProjectGuideLinesDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ProjectGuideLinesUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.ProjectGuideLinesUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectGuideLinesPayload>[]
          }
          upsert: {
            args: Prisma.ProjectGuideLinesUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectGuideLinesPayload>
          }
          aggregate: {
            args: Prisma.ProjectGuideLinesAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateProjectGuideLines>
          }
          groupBy: {
            args: Prisma.ProjectGuideLinesGroupByArgs<ExtArgs>
            result: $Utils.Optional<ProjectGuideLinesGroupByOutputType>[]
          }
          count: {
            args: Prisma.ProjectGuideLinesCountArgs<ExtArgs>
            result: $Utils.Optional<ProjectGuideLinesCountAggregateOutputType> | number
          }
        }
      }
      seo_packages: {
        payload: Prisma.$seo_packagesPayload<ExtArgs>
        fields: Prisma.seo_packagesFieldRefs
        operations: {
          findUnique: {
            args: Prisma.seo_packagesFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$seo_packagesPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.seo_packagesFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$seo_packagesPayload>
          }
          findFirst: {
            args: Prisma.seo_packagesFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$seo_packagesPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.seo_packagesFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$seo_packagesPayload>
          }
          findMany: {
            args: Prisma.seo_packagesFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$seo_packagesPayload>[]
          }
          create: {
            args: Prisma.seo_packagesCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$seo_packagesPayload>
          }
          createMany: {
            args: Prisma.seo_packagesCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.seo_packagesCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$seo_packagesPayload>[]
          }
          delete: {
            args: Prisma.seo_packagesDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$seo_packagesPayload>
          }
          update: {
            args: Prisma.seo_packagesUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$seo_packagesPayload>
          }
          deleteMany: {
            args: Prisma.seo_packagesDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.seo_packagesUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.seo_packagesUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$seo_packagesPayload>[]
          }
          upsert: {
            args: Prisma.seo_packagesUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$seo_packagesPayload>
          }
          aggregate: {
            args: Prisma.Seo_packagesAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateSeo_packages>
          }
          groupBy: {
            args: Prisma.seo_packagesGroupByArgs<ExtArgs>
            result: $Utils.Optional<Seo_packagesGroupByOutputType>[]
          }
          count: {
            args: Prisma.seo_packagesCountArgs<ExtArgs>
            result: $Utils.Optional<Seo_packagesCountAggregateOutputType> | number
          }
        }
      }
      package_features: {
        payload: Prisma.$package_featuresPayload<ExtArgs>
        fields: Prisma.package_featuresFieldRefs
        operations: {
          findUnique: {
            args: Prisma.package_featuresFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$package_featuresPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.package_featuresFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$package_featuresPayload>
          }
          findFirst: {
            args: Prisma.package_featuresFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$package_featuresPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.package_featuresFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$package_featuresPayload>
          }
          findMany: {
            args: Prisma.package_featuresFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$package_featuresPayload>[]
          }
          create: {
            args: Prisma.package_featuresCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$package_featuresPayload>
          }
          createMany: {
            args: Prisma.package_featuresCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.package_featuresCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$package_featuresPayload>[]
          }
          delete: {
            args: Prisma.package_featuresDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$package_featuresPayload>
          }
          update: {
            args: Prisma.package_featuresUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$package_featuresPayload>
          }
          deleteMany: {
            args: Prisma.package_featuresDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.package_featuresUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.package_featuresUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$package_featuresPayload>[]
          }
          upsert: {
            args: Prisma.package_featuresUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$package_featuresPayload>
          }
          aggregate: {
            args: Prisma.Package_featuresAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregatePackage_features>
          }
          groupBy: {
            args: Prisma.package_featuresGroupByArgs<ExtArgs>
            result: $Utils.Optional<Package_featuresGroupByOutputType>[]
          }
          count: {
            args: Prisma.package_featuresCountArgs<ExtArgs>
            result: $Utils.Optional<Package_featuresCountAggregateOutputType> | number
          }
        }
      }
      ranker_user: {
        payload: Prisma.$ranker_userPayload<ExtArgs>
        fields: Prisma.ranker_userFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ranker_userFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ranker_userPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ranker_userFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ranker_userPayload>
          }
          findFirst: {
            args: Prisma.ranker_userFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ranker_userPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ranker_userFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ranker_userPayload>
          }
          findMany: {
            args: Prisma.ranker_userFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ranker_userPayload>[]
          }
          create: {
            args: Prisma.ranker_userCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ranker_userPayload>
          }
          createMany: {
            args: Prisma.ranker_userCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ranker_userCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ranker_userPayload>[]
          }
          delete: {
            args: Prisma.ranker_userDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ranker_userPayload>
          }
          update: {
            args: Prisma.ranker_userUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ranker_userPayload>
          }
          deleteMany: {
            args: Prisma.ranker_userDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ranker_userUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.ranker_userUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ranker_userPayload>[]
          }
          upsert: {
            args: Prisma.ranker_userUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ranker_userPayload>
          }
          aggregate: {
            args: Prisma.Ranker_userAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateRanker_user>
          }
          groupBy: {
            args: Prisma.ranker_userGroupByArgs<ExtArgs>
            result: $Utils.Optional<Ranker_userGroupByOutputType>[]
          }
          count: {
            args: Prisma.ranker_userCountArgs<ExtArgs>
            result: $Utils.Optional<Ranker_userCountAggregateOutputType> | number
          }
        }
      }
    }
  } & {
    other: {
      payload: any
      operations: {
        $executeRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
        $executeRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
        $queryRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
        $queryRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
      }
    }
  }
  export const defineExtension: $Extensions.ExtendsHook<"define", Prisma.TypeMapCb, $Extensions.DefaultArgs>
  export type DefaultPrismaClient = PrismaClient
  export type ErrorFormat = 'pretty' | 'colorless' | 'minimal'
  export interface PrismaClientOptions {
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasources?: Datasources
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasourceUrl?: string
    /**
     * @default "colorless"
     */
    errorFormat?: ErrorFormat
    /**
     * @example
     * ```
     * // Defaults to stdout
     * log: ['query', 'info', 'warn', 'error']
     * 
     * // Emit as events
     * log: [
     *   { emit: 'stdout', level: 'query' },
     *   { emit: 'stdout', level: 'info' },
     *   { emit: 'stdout', level: 'warn' }
     *   { emit: 'stdout', level: 'error' }
     * ]
     * ```
     * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/logging#the-log-option).
     */
    log?: (LogLevel | LogDefinition)[]
    /**
     * The default values for transactionOptions
     * maxWait ?= 2000
     * timeout ?= 5000
     */
    transactionOptions?: {
      maxWait?: number
      timeout?: number
      isolationLevel?: Prisma.TransactionIsolationLevel
    }
    /**
     * Global configuration for omitting model fields by default.
     * 
     * @example
     * ```
     * const prisma = new PrismaClient({
     *   omit: {
     *     user: {
     *       password: true
     *     }
     *   }
     * })
     * ```
     */
    omit?: Prisma.GlobalOmitConfig
  }
  export type GlobalOmitConfig = {
    user?: UserOmit
    userDetails?: UserDetailsOmit
    projectCategory?: ProjectCategoryOmit
    project?: ProjectOmit
    projectUser?: ProjectUserOmit
    backlink?: BacklinkOmit
    process?: ProcessOmit
    team?: TeamOmit
    assignTeamMember?: AssignTeamMemberOmit
    tempLinks?: TempLinksOmit
    userJobs?: UserJobsOmit
    projectDetails?: ProjectDetailsOmit
    referDomainCategory?: ReferDomainCategoryOmit
    referDomain?: ReferDomainOmit
    guideLines?: GuideLinesOmit
    projectGuideLines?: ProjectGuideLinesOmit
    seo_packages?: seo_packagesOmit
    package_features?: package_featuresOmit
    ranker_user?: ranker_userOmit
  }

  /* Types for Logging */
  export type LogLevel = 'info' | 'query' | 'warn' | 'error'
  export type LogDefinition = {
    level: LogLevel
    emit: 'stdout' | 'event'
  }

  export type GetLogType<T extends LogLevel | LogDefinition> = T extends LogDefinition ? T['emit'] extends 'event' ? T['level'] : never : never
  export type GetEvents<T extends any> = T extends Array<LogLevel | LogDefinition> ?
    GetLogType<T[0]> | GetLogType<T[1]> | GetLogType<T[2]> | GetLogType<T[3]>
    : never

  export type QueryEvent = {
    timestamp: Date
    query: string
    params: string
    duration: number
    target: string
  }

  export type LogEvent = {
    timestamp: Date
    message: string
    target: string
  }
  /* End Types for Logging */


  export type PrismaAction =
    | 'findUnique'
    | 'findUniqueOrThrow'
    | 'findMany'
    | 'findFirst'
    | 'findFirstOrThrow'
    | 'create'
    | 'createMany'
    | 'createManyAndReturn'
    | 'update'
    | 'updateMany'
    | 'updateManyAndReturn'
    | 'upsert'
    | 'delete'
    | 'deleteMany'
    | 'executeRaw'
    | 'queryRaw'
    | 'aggregate'
    | 'count'
    | 'runCommandRaw'
    | 'findRaw'
    | 'groupBy'

  /**
   * These options are being passed into the middleware as "params"
   */
  export type MiddlewareParams = {
    model?: ModelName
    action: PrismaAction
    args: any
    dataPath: string[]
    runInTransaction: boolean
  }

  /**
   * The `T` type makes sure, that the `return proceed` is not forgotten in the middleware implementation
   */
  export type Middleware<T = any> = (
    params: MiddlewareParams,
    next: (params: MiddlewareParams) => $Utils.JsPromise<T>,
  ) => $Utils.JsPromise<T>

  // tested in getLogLevel.test.ts
  export function getLogLevel(log: Array<LogLevel | LogDefinition>): LogLevel | undefined;

  /**
   * `PrismaClient` proxy available in interactive transactions.
   */
  export type TransactionClient = Omit<Prisma.DefaultPrismaClient, runtime.ITXClientDenyList>

  export type Datasource = {
    url?: string
  }

  /**
   * Count Types
   */


  /**
   * Count Type UserCountOutputType
   */

  export type UserCountOutputType = {
    created_projects: number
    backlinks: number
    ProjectCategory: number
    assignedProjects: number
    memberProjects: number
    Backlink: number
    Process: number
    TempLinks: number
    UserJobs: number
    ReferDomain: number
    ReferDomainCategory: number
    GuideLines: number
    Project: number
    OrganisationTeam: number
    CreatedByTeam: number
    UserTeam: number
    AssignToTeamMember: number
    AssignByTeamMember: number
    AssignUserMember: number
    AssignOrgMember: number
  }

  export type UserCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    created_projects?: boolean | UserCountOutputTypeCountCreated_projectsArgs
    backlinks?: boolean | UserCountOutputTypeCountBacklinksArgs
    ProjectCategory?: boolean | UserCountOutputTypeCountProjectCategoryArgs
    assignedProjects?: boolean | UserCountOutputTypeCountAssignedProjectsArgs
    memberProjects?: boolean | UserCountOutputTypeCountMemberProjectsArgs
    Backlink?: boolean | UserCountOutputTypeCountBacklinkArgs
    Process?: boolean | UserCountOutputTypeCountProcessArgs
    TempLinks?: boolean | UserCountOutputTypeCountTempLinksArgs
    UserJobs?: boolean | UserCountOutputTypeCountUserJobsArgs
    ReferDomain?: boolean | UserCountOutputTypeCountReferDomainArgs
    ReferDomainCategory?: boolean | UserCountOutputTypeCountReferDomainCategoryArgs
    GuideLines?: boolean | UserCountOutputTypeCountGuideLinesArgs
    Project?: boolean | UserCountOutputTypeCountProjectArgs
    OrganisationTeam?: boolean | UserCountOutputTypeCountOrganisationTeamArgs
    CreatedByTeam?: boolean | UserCountOutputTypeCountCreatedByTeamArgs
    UserTeam?: boolean | UserCountOutputTypeCountUserTeamArgs
    AssignToTeamMember?: boolean | UserCountOutputTypeCountAssignToTeamMemberArgs
    AssignByTeamMember?: boolean | UserCountOutputTypeCountAssignByTeamMemberArgs
    AssignUserMember?: boolean | UserCountOutputTypeCountAssignUserMemberArgs
    AssignOrgMember?: boolean | UserCountOutputTypeCountAssignOrgMemberArgs
  }

  // Custom InputTypes
  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserCountOutputType
     */
    select?: UserCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_projectsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProjectWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountBacklinksArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: BacklinkWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountProjectCategoryArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProjectCategoryWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountAssignedProjectsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProjectUserWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountMemberProjectsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProjectUserWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountBacklinkArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: BacklinkWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountProcessArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProcessWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountTempLinksArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: TempLinksWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUserJobsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserJobsWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountReferDomainArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ReferDomainWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountReferDomainCategoryArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ReferDomainCategoryWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountGuideLinesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: GuideLinesWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountProjectArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProjectWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountOrganisationTeamArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: TeamWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreatedByTeamArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: TeamWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUserTeamArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: TeamWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountAssignToTeamMemberArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: AssignTeamMemberWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountAssignByTeamMemberArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: AssignTeamMemberWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountAssignUserMemberArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: AssignTeamMemberWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountAssignOrgMemberArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: AssignTeamMemberWhereInput
  }


  /**
   * Count Type ProjectCategoryCountOutputType
   */

  export type ProjectCategoryCountOutputType = {
    projects: number
  }

  export type ProjectCategoryCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    projects?: boolean | ProjectCategoryCountOutputTypeCountProjectsArgs
  }

  // Custom InputTypes
  /**
   * ProjectCategoryCountOutputType without action
   */
  export type ProjectCategoryCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectCategoryCountOutputType
     */
    select?: ProjectCategoryCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * ProjectCategoryCountOutputType without action
   */
  export type ProjectCategoryCountOutputTypeCountProjectsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProjectWhereInput
  }


  /**
   * Count Type ProjectCountOutputType
   */

  export type ProjectCountOutputType = {
    backlinks: number
    ProjectMember: number
    ProjectDetails: number
    TempLinks: number
    SeoProjectDetails: number
    UserJobs: number
    ProjectGuideLines: number
  }

  export type ProjectCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    backlinks?: boolean | ProjectCountOutputTypeCountBacklinksArgs
    ProjectMember?: boolean | ProjectCountOutputTypeCountProjectMemberArgs
    ProjectDetails?: boolean | ProjectCountOutputTypeCountProjectDetailsArgs
    TempLinks?: boolean | ProjectCountOutputTypeCountTempLinksArgs
    SeoProjectDetails?: boolean | ProjectCountOutputTypeCountSeoProjectDetailsArgs
    UserJobs?: boolean | ProjectCountOutputTypeCountUserJobsArgs
    ProjectGuideLines?: boolean | ProjectCountOutputTypeCountProjectGuideLinesArgs
  }

  // Custom InputTypes
  /**
   * ProjectCountOutputType without action
   */
  export type ProjectCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectCountOutputType
     */
    select?: ProjectCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * ProjectCountOutputType without action
   */
  export type ProjectCountOutputTypeCountBacklinksArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: BacklinkWhereInput
  }

  /**
   * ProjectCountOutputType without action
   */
  export type ProjectCountOutputTypeCountProjectMemberArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProjectUserWhereInput
  }

  /**
   * ProjectCountOutputType without action
   */
  export type ProjectCountOutputTypeCountProjectDetailsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProjectDetailsWhereInput
  }

  /**
   * ProjectCountOutputType without action
   */
  export type ProjectCountOutputTypeCountTempLinksArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: TempLinksWhereInput
  }

  /**
   * ProjectCountOutputType without action
   */
  export type ProjectCountOutputTypeCountSeoProjectDetailsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProjectDetailsWhereInput
  }

  /**
   * ProjectCountOutputType without action
   */
  export type ProjectCountOutputTypeCountUserJobsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserJobsWhereInput
  }

  /**
   * ProjectCountOutputType without action
   */
  export type ProjectCountOutputTypeCountProjectGuideLinesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProjectGuideLinesWhereInput
  }


  /**
   * Count Type ProcessCountOutputType
   */

  export type ProcessCountOutputType = {
    BacklinkProcess: number
  }

  export type ProcessCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    BacklinkProcess?: boolean | ProcessCountOutputTypeCountBacklinkProcessArgs
  }

  // Custom InputTypes
  /**
   * ProcessCountOutputType without action
   */
  export type ProcessCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProcessCountOutputType
     */
    select?: ProcessCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * ProcessCountOutputType without action
   */
  export type ProcessCountOutputTypeCountBacklinkProcessArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: BacklinkWhereInput
  }


  /**
   * Count Type UserJobsCountOutputType
   */

  export type UserJobsCountOutputType = {
    TempLinks: number
    Backlink: number
  }

  export type UserJobsCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    TempLinks?: boolean | UserJobsCountOutputTypeCountTempLinksArgs
    Backlink?: boolean | UserJobsCountOutputTypeCountBacklinkArgs
  }

  // Custom InputTypes
  /**
   * UserJobsCountOutputType without action
   */
  export type UserJobsCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserJobsCountOutputType
     */
    select?: UserJobsCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * UserJobsCountOutputType without action
   */
  export type UserJobsCountOutputTypeCountTempLinksArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: TempLinksWhereInput
  }

  /**
   * UserJobsCountOutputType without action
   */
  export type UserJobsCountOutputTypeCountBacklinkArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: BacklinkWhereInput
  }


  /**
   * Count Type ReferDomainCategoryCountOutputType
   */

  export type ReferDomainCategoryCountOutputType = {
    ReferDomain: number
  }

  export type ReferDomainCategoryCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    ReferDomain?: boolean | ReferDomainCategoryCountOutputTypeCountReferDomainArgs
  }

  // Custom InputTypes
  /**
   * ReferDomainCategoryCountOutputType without action
   */
  export type ReferDomainCategoryCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomainCategoryCountOutputType
     */
    select?: ReferDomainCategoryCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * ReferDomainCategoryCountOutputType without action
   */
  export type ReferDomainCategoryCountOutputTypeCountReferDomainArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ReferDomainWhereInput
  }


  /**
   * Count Type GuideLinesCountOutputType
   */

  export type GuideLinesCountOutputType = {
    ProjectGuideLines: number
    TempLinks: number
    Backlink: number
  }

  export type GuideLinesCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    ProjectGuideLines?: boolean | GuideLinesCountOutputTypeCountProjectGuideLinesArgs
    TempLinks?: boolean | GuideLinesCountOutputTypeCountTempLinksArgs
    Backlink?: boolean | GuideLinesCountOutputTypeCountBacklinkArgs
  }

  // Custom InputTypes
  /**
   * GuideLinesCountOutputType without action
   */
  export type GuideLinesCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuideLinesCountOutputType
     */
    select?: GuideLinesCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * GuideLinesCountOutputType without action
   */
  export type GuideLinesCountOutputTypeCountProjectGuideLinesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProjectGuideLinesWhereInput
  }

  /**
   * GuideLinesCountOutputType without action
   */
  export type GuideLinesCountOutputTypeCountTempLinksArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: TempLinksWhereInput
  }

  /**
   * GuideLinesCountOutputType without action
   */
  export type GuideLinesCountOutputTypeCountBacklinkArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: BacklinkWhereInput
  }


  /**
   * Count Type Seo_packagesCountOutputType
   */

  export type Seo_packagesCountOutputType = {
    package_features: number
    Project: number
    ProjectGuideLines: number
  }

  export type Seo_packagesCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    package_features?: boolean | Seo_packagesCountOutputTypeCountPackage_featuresArgs
    Project?: boolean | Seo_packagesCountOutputTypeCountProjectArgs
    ProjectGuideLines?: boolean | Seo_packagesCountOutputTypeCountProjectGuideLinesArgs
  }

  // Custom InputTypes
  /**
   * Seo_packagesCountOutputType without action
   */
  export type Seo_packagesCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Seo_packagesCountOutputType
     */
    select?: Seo_packagesCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * Seo_packagesCountOutputType without action
   */
  export type Seo_packagesCountOutputTypeCountPackage_featuresArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: package_featuresWhereInput
  }

  /**
   * Seo_packagesCountOutputType without action
   */
  export type Seo_packagesCountOutputTypeCountProjectArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProjectWhereInput
  }

  /**
   * Seo_packagesCountOutputType without action
   */
  export type Seo_packagesCountOutputTypeCountProjectGuideLinesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProjectGuideLinesWhereInput
  }


  /**
   * Models
   */

  /**
   * Model User
   */

  export type AggregateUser = {
    _count: UserCountAggregateOutputType | null
    _avg: UserAvgAggregateOutputType | null
    _sum: UserSumAggregateOutputType | null
    _min: UserMinAggregateOutputType | null
    _max: UserMaxAggregateOutputType | null
  }

  export type UserAvgAggregateOutputType = {
    id: number | null
    create_by: number | null
  }

  export type UserSumAggregateOutputType = {
    id: number | null
    create_by: number | null
  }

  export type UserMinAggregateOutputType = {
    id: number | null
    first_name: string | null
    last_name: string | null
    email: string | null
    password: string | null
    phone_no: string | null
    country_code: string | null
    country_iso_code: string | null
    condition: boolean | null
    create_by: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    is_verified: boolean | null
    status: $Enums.Status | null
  }

  export type UserMaxAggregateOutputType = {
    id: number | null
    first_name: string | null
    last_name: string | null
    email: string | null
    password: string | null
    phone_no: string | null
    country_code: string | null
    country_iso_code: string | null
    condition: boolean | null
    create_by: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    is_verified: boolean | null
    status: $Enums.Status | null
  }

  export type UserCountAggregateOutputType = {
    id: number
    first_name: number
    last_name: number
    email: number
    password: number
    phone_no: number
    country_code: number
    country_iso_code: number
    condition: number
    create_by: number
    created_at: number
    updated_at: number
    deleted_at: number
    is_verified: number
    status: number
    _all: number
  }


  export type UserAvgAggregateInputType = {
    id?: true
    create_by?: true
  }

  export type UserSumAggregateInputType = {
    id?: true
    create_by?: true
  }

  export type UserMinAggregateInputType = {
    id?: true
    first_name?: true
    last_name?: true
    email?: true
    password?: true
    phone_no?: true
    country_code?: true
    country_iso_code?: true
    condition?: true
    create_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    is_verified?: true
    status?: true
  }

  export type UserMaxAggregateInputType = {
    id?: true
    first_name?: true
    last_name?: true
    email?: true
    password?: true
    phone_no?: true
    country_code?: true
    country_iso_code?: true
    condition?: true
    create_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    is_verified?: true
    status?: true
  }

  export type UserCountAggregateInputType = {
    id?: true
    first_name?: true
    last_name?: true
    email?: true
    password?: true
    phone_no?: true
    country_code?: true
    country_iso_code?: true
    condition?: true
    create_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    is_verified?: true
    status?: true
    _all?: true
  }

  export type UserAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which User to aggregate.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Users
    **/
    _count?: true | UserCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: UserAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: UserSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserMaxAggregateInputType
  }

  export type GetUserAggregateType<T extends UserAggregateArgs> = {
        [P in keyof T & keyof AggregateUser]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUser[P]>
      : GetScalarType<T[P], AggregateUser[P]>
  }




  export type UserGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserWhereInput
    orderBy?: UserOrderByWithAggregationInput | UserOrderByWithAggregationInput[]
    by: UserScalarFieldEnum[] | UserScalarFieldEnum
    having?: UserScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserCountAggregateInputType | true
    _avg?: UserAvgAggregateInputType
    _sum?: UserSumAggregateInputType
    _min?: UserMinAggregateInputType
    _max?: UserMaxAggregateInputType
  }

  export type UserGroupByOutputType = {
    id: number
    first_name: string
    last_name: string | null
    email: string
    password: string
    phone_no: string | null
    country_code: string | null
    country_iso_code: string | null
    condition: boolean
    create_by: number
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    is_verified: boolean
    status: $Enums.Status
    _count: UserCountAggregateOutputType | null
    _avg: UserAvgAggregateOutputType | null
    _sum: UserSumAggregateOutputType | null
    _min: UserMinAggregateOutputType | null
    _max: UserMaxAggregateOutputType | null
  }

  type GetUserGroupByPayload<T extends UserGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserGroupByOutputType[P]>
            : GetScalarType<T[P], UserGroupByOutputType[P]>
        }
      >
    >


  export type UserSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    first_name?: boolean
    last_name?: boolean
    email?: boolean
    password?: boolean
    phone_no?: boolean
    country_code?: boolean
    country_iso_code?: boolean
    condition?: boolean
    create_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    is_verified?: boolean
    status?: boolean
    created_projects?: boolean | User$created_projectsArgs<ExtArgs>
    backlinks?: boolean | User$backlinksArgs<ExtArgs>
    ProjectCategory?: boolean | User$ProjectCategoryArgs<ExtArgs>
    assignedProjects?: boolean | User$assignedProjectsArgs<ExtArgs>
    memberProjects?: boolean | User$memberProjectsArgs<ExtArgs>
    Backlink?: boolean | User$BacklinkArgs<ExtArgs>
    Process?: boolean | User$ProcessArgs<ExtArgs>
    TempLinks?: boolean | User$TempLinksArgs<ExtArgs>
    UserJobs?: boolean | User$UserJobsArgs<ExtArgs>
    ReferDomain?: boolean | User$ReferDomainArgs<ExtArgs>
    ReferDomainCategory?: boolean | User$ReferDomainCategoryArgs<ExtArgs>
    GuideLines?: boolean | User$GuideLinesArgs<ExtArgs>
    Project?: boolean | User$ProjectArgs<ExtArgs>
    OrganisationTeam?: boolean | User$OrganisationTeamArgs<ExtArgs>
    CreatedByTeam?: boolean | User$CreatedByTeamArgs<ExtArgs>
    UserTeam?: boolean | User$UserTeamArgs<ExtArgs>
    AssignToTeamMember?: boolean | User$AssignToTeamMemberArgs<ExtArgs>
    AssignByTeamMember?: boolean | User$AssignByTeamMemberArgs<ExtArgs>
    AssignUserMember?: boolean | User$AssignUserMemberArgs<ExtArgs>
    AssignOrgMember?: boolean | User$AssignOrgMemberArgs<ExtArgs>
    UserInfo?: boolean | User$UserInfoArgs<ExtArgs>
    _count?: boolean | UserCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["user"]>

  export type UserSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    first_name?: boolean
    last_name?: boolean
    email?: boolean
    password?: boolean
    phone_no?: boolean
    country_code?: boolean
    country_iso_code?: boolean
    condition?: boolean
    create_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    is_verified?: boolean
    status?: boolean
  }, ExtArgs["result"]["user"]>

  export type UserSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    first_name?: boolean
    last_name?: boolean
    email?: boolean
    password?: boolean
    phone_no?: boolean
    country_code?: boolean
    country_iso_code?: boolean
    condition?: boolean
    create_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    is_verified?: boolean
    status?: boolean
  }, ExtArgs["result"]["user"]>

  export type UserSelectScalar = {
    id?: boolean
    first_name?: boolean
    last_name?: boolean
    email?: boolean
    password?: boolean
    phone_no?: boolean
    country_code?: boolean
    country_iso_code?: boolean
    condition?: boolean
    create_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    is_verified?: boolean
    status?: boolean
  }

  export type UserOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "first_name" | "last_name" | "email" | "password" | "phone_no" | "country_code" | "country_iso_code" | "condition" | "create_by" | "created_at" | "updated_at" | "deleted_at" | "is_verified" | "status", ExtArgs["result"]["user"]>
  export type UserInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    created_projects?: boolean | User$created_projectsArgs<ExtArgs>
    backlinks?: boolean | User$backlinksArgs<ExtArgs>
    ProjectCategory?: boolean | User$ProjectCategoryArgs<ExtArgs>
    assignedProjects?: boolean | User$assignedProjectsArgs<ExtArgs>
    memberProjects?: boolean | User$memberProjectsArgs<ExtArgs>
    Backlink?: boolean | User$BacklinkArgs<ExtArgs>
    Process?: boolean | User$ProcessArgs<ExtArgs>
    TempLinks?: boolean | User$TempLinksArgs<ExtArgs>
    UserJobs?: boolean | User$UserJobsArgs<ExtArgs>
    ReferDomain?: boolean | User$ReferDomainArgs<ExtArgs>
    ReferDomainCategory?: boolean | User$ReferDomainCategoryArgs<ExtArgs>
    GuideLines?: boolean | User$GuideLinesArgs<ExtArgs>
    Project?: boolean | User$ProjectArgs<ExtArgs>
    OrganisationTeam?: boolean | User$OrganisationTeamArgs<ExtArgs>
    CreatedByTeam?: boolean | User$CreatedByTeamArgs<ExtArgs>
    UserTeam?: boolean | User$UserTeamArgs<ExtArgs>
    AssignToTeamMember?: boolean | User$AssignToTeamMemberArgs<ExtArgs>
    AssignByTeamMember?: boolean | User$AssignByTeamMemberArgs<ExtArgs>
    AssignUserMember?: boolean | User$AssignUserMemberArgs<ExtArgs>
    AssignOrgMember?: boolean | User$AssignOrgMemberArgs<ExtArgs>
    UserInfo?: boolean | User$UserInfoArgs<ExtArgs>
    _count?: boolean | UserCountOutputTypeDefaultArgs<ExtArgs>
  }
  export type UserIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {}
  export type UserIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {}

  export type $UserPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "User"
    objects: {
      created_projects: Prisma.$ProjectPayload<ExtArgs>[]
      backlinks: Prisma.$BacklinkPayload<ExtArgs>[]
      ProjectCategory: Prisma.$ProjectCategoryPayload<ExtArgs>[]
      assignedProjects: Prisma.$ProjectUserPayload<ExtArgs>[]
      memberProjects: Prisma.$ProjectUserPayload<ExtArgs>[]
      Backlink: Prisma.$BacklinkPayload<ExtArgs>[]
      Process: Prisma.$ProcessPayload<ExtArgs>[]
      TempLinks: Prisma.$TempLinksPayload<ExtArgs>[]
      UserJobs: Prisma.$UserJobsPayload<ExtArgs>[]
      ReferDomain: Prisma.$ReferDomainPayload<ExtArgs>[]
      ReferDomainCategory: Prisma.$ReferDomainCategoryPayload<ExtArgs>[]
      GuideLines: Prisma.$GuideLinesPayload<ExtArgs>[]
      Project: Prisma.$ProjectPayload<ExtArgs>[]
      OrganisationTeam: Prisma.$TeamPayload<ExtArgs>[]
      CreatedByTeam: Prisma.$TeamPayload<ExtArgs>[]
      UserTeam: Prisma.$TeamPayload<ExtArgs>[]
      AssignToTeamMember: Prisma.$AssignTeamMemberPayload<ExtArgs>[]
      AssignByTeamMember: Prisma.$AssignTeamMemberPayload<ExtArgs>[]
      AssignUserMember: Prisma.$AssignTeamMemberPayload<ExtArgs>[]
      AssignOrgMember: Prisma.$AssignTeamMemberPayload<ExtArgs>[]
      UserInfo: Prisma.$UserDetailsPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      first_name: string
      last_name: string | null
      email: string
      password: string
      phone_no: string | null
      country_code: string | null
      country_iso_code: string | null
      condition: boolean
      create_by: number
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
      is_verified: boolean
      status: $Enums.Status
    }, ExtArgs["result"]["user"]>
    composites: {}
  }

  type UserGetPayload<S extends boolean | null | undefined | UserDefaultArgs> = $Result.GetResult<Prisma.$UserPayload, S>

  type UserCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<UserFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: UserCountAggregateInputType | true
    }

  export interface UserDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['User'], meta: { name: 'User' } }
    /**
     * Find zero or one User that matches the filter.
     * @param {UserFindUniqueArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends UserFindUniqueArgs>(args: SelectSubset<T, UserFindUniqueArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one User that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {UserFindUniqueOrThrowArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends UserFindUniqueOrThrowArgs>(args: SelectSubset<T, UserFindUniqueOrThrowArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first User that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindFirstArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends UserFindFirstArgs>(args?: SelectSubset<T, UserFindFirstArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first User that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindFirstOrThrowArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends UserFindFirstOrThrowArgs>(args?: SelectSubset<T, UserFindFirstOrThrowArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Users that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Users
     * const users = await prisma.user.findMany()
     * 
     * // Get first 10 Users
     * const users = await prisma.user.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const userWithIdOnly = await prisma.user.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends UserFindManyArgs>(args?: SelectSubset<T, UserFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a User.
     * @param {UserCreateArgs} args - Arguments to create a User.
     * @example
     * // Create one User
     * const User = await prisma.user.create({
     *   data: {
     *     // ... data to create a User
     *   }
     * })
     * 
     */
    create<T extends UserCreateArgs>(args: SelectSubset<T, UserCreateArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Users.
     * @param {UserCreateManyArgs} args - Arguments to create many Users.
     * @example
     * // Create many Users
     * const user = await prisma.user.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends UserCreateManyArgs>(args?: SelectSubset<T, UserCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Users and returns the data saved in the database.
     * @param {UserCreateManyAndReturnArgs} args - Arguments to create many Users.
     * @example
     * // Create many Users
     * const user = await prisma.user.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Users and only return the `id`
     * const userWithIdOnly = await prisma.user.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends UserCreateManyAndReturnArgs>(args?: SelectSubset<T, UserCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a User.
     * @param {UserDeleteArgs} args - Arguments to delete one User.
     * @example
     * // Delete one User
     * const User = await prisma.user.delete({
     *   where: {
     *     // ... filter to delete one User
     *   }
     * })
     * 
     */
    delete<T extends UserDeleteArgs>(args: SelectSubset<T, UserDeleteArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one User.
     * @param {UserUpdateArgs} args - Arguments to update one User.
     * @example
     * // Update one User
     * const user = await prisma.user.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends UserUpdateArgs>(args: SelectSubset<T, UserUpdateArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Users.
     * @param {UserDeleteManyArgs} args - Arguments to filter Users to delete.
     * @example
     * // Delete a few Users
     * const { count } = await prisma.user.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends UserDeleteManyArgs>(args?: SelectSubset<T, UserDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Users.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Users
     * const user = await prisma.user.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends UserUpdateManyArgs>(args: SelectSubset<T, UserUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Users and returns the data updated in the database.
     * @param {UserUpdateManyAndReturnArgs} args - Arguments to update many Users.
     * @example
     * // Update many Users
     * const user = await prisma.user.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Users and only return the `id`
     * const userWithIdOnly = await prisma.user.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends UserUpdateManyAndReturnArgs>(args: SelectSubset<T, UserUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one User.
     * @param {UserUpsertArgs} args - Arguments to update or create a User.
     * @example
     * // Update or create a User
     * const user = await prisma.user.upsert({
     *   create: {
     *     // ... data to create a User
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the User we want to update
     *   }
     * })
     */
    upsert<T extends UserUpsertArgs>(args: SelectSubset<T, UserUpsertArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of Users.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserCountArgs} args - Arguments to filter Users to count.
     * @example
     * // Count the number of Users
     * const count = await prisma.user.count({
     *   where: {
     *     // ... the filter for the Users we want to count
     *   }
     * })
    **/
    count<T extends UserCountArgs>(
      args?: Subset<T, UserCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a User.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserAggregateArgs>(args: Subset<T, UserAggregateArgs>): Prisma.PrismaPromise<GetUserAggregateType<T>>

    /**
     * Group by User.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UserGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UserGroupByArgs['orderBy'] }
        : { orderBy?: UserGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UserGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the User model
   */
  readonly fields: UserFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for User.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__UserClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    created_projects<T extends User$created_projectsArgs<ExtArgs> = {}>(args?: Subset<T, User$created_projectsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    backlinks<T extends User$backlinksArgs<ExtArgs> = {}>(args?: Subset<T, User$backlinksArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    ProjectCategory<T extends User$ProjectCategoryArgs<ExtArgs> = {}>(args?: Subset<T, User$ProjectCategoryArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectCategoryPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    assignedProjects<T extends User$assignedProjectsArgs<ExtArgs> = {}>(args?: Subset<T, User$assignedProjectsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectUserPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    memberProjects<T extends User$memberProjectsArgs<ExtArgs> = {}>(args?: Subset<T, User$memberProjectsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectUserPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    Backlink<T extends User$BacklinkArgs<ExtArgs> = {}>(args?: Subset<T, User$BacklinkArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    Process<T extends User$ProcessArgs<ExtArgs> = {}>(args?: Subset<T, User$ProcessArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProcessPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    TempLinks<T extends User$TempLinksArgs<ExtArgs> = {}>(args?: Subset<T, User$TempLinksArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TempLinksPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    UserJobs<T extends User$UserJobsArgs<ExtArgs> = {}>(args?: Subset<T, User$UserJobsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserJobsPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    ReferDomain<T extends User$ReferDomainArgs<ExtArgs> = {}>(args?: Subset<T, User$ReferDomainArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ReferDomainPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    ReferDomainCategory<T extends User$ReferDomainCategoryArgs<ExtArgs> = {}>(args?: Subset<T, User$ReferDomainCategoryArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ReferDomainCategoryPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    GuideLines<T extends User$GuideLinesArgs<ExtArgs> = {}>(args?: Subset<T, User$GuideLinesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$GuideLinesPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    Project<T extends User$ProjectArgs<ExtArgs> = {}>(args?: Subset<T, User$ProjectArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    OrganisationTeam<T extends User$OrganisationTeamArgs<ExtArgs> = {}>(args?: Subset<T, User$OrganisationTeamArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TeamPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    CreatedByTeam<T extends User$CreatedByTeamArgs<ExtArgs> = {}>(args?: Subset<T, User$CreatedByTeamArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TeamPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    UserTeam<T extends User$UserTeamArgs<ExtArgs> = {}>(args?: Subset<T, User$UserTeamArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TeamPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    AssignToTeamMember<T extends User$AssignToTeamMemberArgs<ExtArgs> = {}>(args?: Subset<T, User$AssignToTeamMemberArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AssignTeamMemberPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    AssignByTeamMember<T extends User$AssignByTeamMemberArgs<ExtArgs> = {}>(args?: Subset<T, User$AssignByTeamMemberArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AssignTeamMemberPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    AssignUserMember<T extends User$AssignUserMemberArgs<ExtArgs> = {}>(args?: Subset<T, User$AssignUserMemberArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AssignTeamMemberPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    AssignOrgMember<T extends User$AssignOrgMemberArgs<ExtArgs> = {}>(args?: Subset<T, User$AssignOrgMemberArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AssignTeamMemberPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    UserInfo<T extends User$UserInfoArgs<ExtArgs> = {}>(args?: Subset<T, User$UserInfoArgs<ExtArgs>>): Prisma__UserDetailsClient<$Result.GetResult<Prisma.$UserDetailsPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | null, null, ExtArgs, ClientOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the User model
   */ 
  interface UserFieldRefs {
    readonly id: FieldRef<"User", 'Int'>
    readonly first_name: FieldRef<"User", 'String'>
    readonly last_name: FieldRef<"User", 'String'>
    readonly email: FieldRef<"User", 'String'>
    readonly password: FieldRef<"User", 'String'>
    readonly phone_no: FieldRef<"User", 'String'>
    readonly country_code: FieldRef<"User", 'String'>
    readonly country_iso_code: FieldRef<"User", 'String'>
    readonly condition: FieldRef<"User", 'Boolean'>
    readonly create_by: FieldRef<"User", 'Int'>
    readonly created_at: FieldRef<"User", 'DateTime'>
    readonly updated_at: FieldRef<"User", 'DateTime'>
    readonly deleted_at: FieldRef<"User", 'DateTime'>
    readonly is_verified: FieldRef<"User", 'Boolean'>
    readonly status: FieldRef<"User", 'Status'>
  }
    

  // Custom InputTypes
  /**
   * User findUnique
   */
  export type UserFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User findUniqueOrThrow
   */
  export type UserFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User findFirst
   */
  export type UserFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Users.
     */
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User findFirstOrThrow
   */
  export type UserFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Users.
     */
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User findMany
   */
  export type UserFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which Users to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User create
   */
  export type UserCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The data needed to create a User.
     */
    data: XOR<UserCreateInput, UserUncheckedCreateInput>
  }

  /**
   * User createMany
   */
  export type UserCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Users.
     */
    data: UserCreateManyInput | UserCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * User createManyAndReturn
   */
  export type UserCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * The data used to create many Users.
     */
    data: UserCreateManyInput | UserCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * User update
   */
  export type UserUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The data needed to update a User.
     */
    data: XOR<UserUpdateInput, UserUncheckedUpdateInput>
    /**
     * Choose, which User to update.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User updateMany
   */
  export type UserUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Users.
     */
    data: XOR<UserUpdateManyMutationInput, UserUncheckedUpdateManyInput>
    /**
     * Filter which Users to update
     */
    where?: UserWhereInput
    /**
     * Limit how many Users to update.
     */
    limit?: number
  }

  /**
   * User updateManyAndReturn
   */
  export type UserUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * The data used to update Users.
     */
    data: XOR<UserUpdateManyMutationInput, UserUncheckedUpdateManyInput>
    /**
     * Filter which Users to update
     */
    where?: UserWhereInput
    /**
     * Limit how many Users to update.
     */
    limit?: number
  }

  /**
   * User upsert
   */
  export type UserUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The filter to search for the User to update in case it exists.
     */
    where: UserWhereUniqueInput
    /**
     * In case the User found by the `where` argument doesn't exist, create a new User with this data.
     */
    create: XOR<UserCreateInput, UserUncheckedCreateInput>
    /**
     * In case the User was found with the provided `where` argument, update it with this data.
     */
    update: XOR<UserUpdateInput, UserUncheckedUpdateInput>
  }

  /**
   * User delete
   */
  export type UserDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter which User to delete.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User deleteMany
   */
  export type UserDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Users to delete
     */
    where?: UserWhereInput
    /**
     * Limit how many Users to delete.
     */
    limit?: number
  }

  /**
   * User.created_projects
   */
  export type User$created_projectsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Project
     */
    select?: ProjectSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Project
     */
    omit?: ProjectOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectInclude<ExtArgs> | null
    where?: ProjectWhereInput
    orderBy?: ProjectOrderByWithRelationInput | ProjectOrderByWithRelationInput[]
    cursor?: ProjectWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ProjectScalarFieldEnum | ProjectScalarFieldEnum[]
  }

  /**
   * User.backlinks
   */
  export type User$backlinksArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    where?: BacklinkWhereInput
    orderBy?: BacklinkOrderByWithRelationInput | BacklinkOrderByWithRelationInput[]
    cursor?: BacklinkWhereUniqueInput
    take?: number
    skip?: number
    distinct?: BacklinkScalarFieldEnum | BacklinkScalarFieldEnum[]
  }

  /**
   * User.ProjectCategory
   */
  export type User$ProjectCategoryArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectCategory
     */
    select?: ProjectCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectCategory
     */
    omit?: ProjectCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectCategoryInclude<ExtArgs> | null
    where?: ProjectCategoryWhereInput
    orderBy?: ProjectCategoryOrderByWithRelationInput | ProjectCategoryOrderByWithRelationInput[]
    cursor?: ProjectCategoryWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ProjectCategoryScalarFieldEnum | ProjectCategoryScalarFieldEnum[]
  }

  /**
   * User.assignedProjects
   */
  export type User$assignedProjectsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectUser
     */
    select?: ProjectUserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectUser
     */
    omit?: ProjectUserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectUserInclude<ExtArgs> | null
    where?: ProjectUserWhereInput
    orderBy?: ProjectUserOrderByWithRelationInput | ProjectUserOrderByWithRelationInput[]
    cursor?: ProjectUserWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ProjectUserScalarFieldEnum | ProjectUserScalarFieldEnum[]
  }

  /**
   * User.memberProjects
   */
  export type User$memberProjectsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectUser
     */
    select?: ProjectUserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectUser
     */
    omit?: ProjectUserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectUserInclude<ExtArgs> | null
    where?: ProjectUserWhereInput
    orderBy?: ProjectUserOrderByWithRelationInput | ProjectUserOrderByWithRelationInput[]
    cursor?: ProjectUserWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ProjectUserScalarFieldEnum | ProjectUserScalarFieldEnum[]
  }

  /**
   * User.Backlink
   */
  export type User$BacklinkArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    where?: BacklinkWhereInput
    orderBy?: BacklinkOrderByWithRelationInput | BacklinkOrderByWithRelationInput[]
    cursor?: BacklinkWhereUniqueInput
    take?: number
    skip?: number
    distinct?: BacklinkScalarFieldEnum | BacklinkScalarFieldEnum[]
  }

  /**
   * User.Process
   */
  export type User$ProcessArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Process
     */
    select?: ProcessSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Process
     */
    omit?: ProcessOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProcessInclude<ExtArgs> | null
    where?: ProcessWhereInput
    orderBy?: ProcessOrderByWithRelationInput | ProcessOrderByWithRelationInput[]
    cursor?: ProcessWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ProcessScalarFieldEnum | ProcessScalarFieldEnum[]
  }

  /**
   * User.TempLinks
   */
  export type User$TempLinksArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TempLinks
     */
    select?: TempLinksSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TempLinks
     */
    omit?: TempLinksOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TempLinksInclude<ExtArgs> | null
    where?: TempLinksWhereInput
    orderBy?: TempLinksOrderByWithRelationInput | TempLinksOrderByWithRelationInput[]
    cursor?: TempLinksWhereUniqueInput
    take?: number
    skip?: number
    distinct?: TempLinksScalarFieldEnum | TempLinksScalarFieldEnum[]
  }

  /**
   * User.UserJobs
   */
  export type User$UserJobsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserJobs
     */
    select?: UserJobsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserJobs
     */
    omit?: UserJobsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserJobsInclude<ExtArgs> | null
    where?: UserJobsWhereInput
    orderBy?: UserJobsOrderByWithRelationInput | UserJobsOrderByWithRelationInput[]
    cursor?: UserJobsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserJobsScalarFieldEnum | UserJobsScalarFieldEnum[]
  }

  /**
   * User.ReferDomain
   */
  export type User$ReferDomainArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomain
     */
    select?: ReferDomainSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomain
     */
    omit?: ReferDomainOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainInclude<ExtArgs> | null
    where?: ReferDomainWhereInput
    orderBy?: ReferDomainOrderByWithRelationInput | ReferDomainOrderByWithRelationInput[]
    cursor?: ReferDomainWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ReferDomainScalarFieldEnum | ReferDomainScalarFieldEnum[]
  }

  /**
   * User.ReferDomainCategory
   */
  export type User$ReferDomainCategoryArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomainCategory
     */
    select?: ReferDomainCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomainCategory
     */
    omit?: ReferDomainCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainCategoryInclude<ExtArgs> | null
    where?: ReferDomainCategoryWhereInput
    orderBy?: ReferDomainCategoryOrderByWithRelationInput | ReferDomainCategoryOrderByWithRelationInput[]
    cursor?: ReferDomainCategoryWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ReferDomainCategoryScalarFieldEnum | ReferDomainCategoryScalarFieldEnum[]
  }

  /**
   * User.GuideLines
   */
  export type User$GuideLinesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuideLines
     */
    select?: GuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the GuideLines
     */
    omit?: GuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: GuideLinesInclude<ExtArgs> | null
    where?: GuideLinesWhereInput
    orderBy?: GuideLinesOrderByWithRelationInput | GuideLinesOrderByWithRelationInput[]
    cursor?: GuideLinesWhereUniqueInput
    take?: number
    skip?: number
    distinct?: GuideLinesScalarFieldEnum | GuideLinesScalarFieldEnum[]
  }

  /**
   * User.Project
   */
  export type User$ProjectArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Project
     */
    select?: ProjectSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Project
     */
    omit?: ProjectOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectInclude<ExtArgs> | null
    where?: ProjectWhereInput
    orderBy?: ProjectOrderByWithRelationInput | ProjectOrderByWithRelationInput[]
    cursor?: ProjectWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ProjectScalarFieldEnum | ProjectScalarFieldEnum[]
  }

  /**
   * User.OrganisationTeam
   */
  export type User$OrganisationTeamArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Team
     */
    select?: TeamSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Team
     */
    omit?: TeamOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TeamInclude<ExtArgs> | null
    where?: TeamWhereInput
    orderBy?: TeamOrderByWithRelationInput | TeamOrderByWithRelationInput[]
    cursor?: TeamWhereUniqueInput
    take?: number
    skip?: number
    distinct?: TeamScalarFieldEnum | TeamScalarFieldEnum[]
  }

  /**
   * User.CreatedByTeam
   */
  export type User$CreatedByTeamArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Team
     */
    select?: TeamSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Team
     */
    omit?: TeamOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TeamInclude<ExtArgs> | null
    where?: TeamWhereInput
    orderBy?: TeamOrderByWithRelationInput | TeamOrderByWithRelationInput[]
    cursor?: TeamWhereUniqueInput
    take?: number
    skip?: number
    distinct?: TeamScalarFieldEnum | TeamScalarFieldEnum[]
  }

  /**
   * User.UserTeam
   */
  export type User$UserTeamArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Team
     */
    select?: TeamSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Team
     */
    omit?: TeamOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TeamInclude<ExtArgs> | null
    where?: TeamWhereInput
    orderBy?: TeamOrderByWithRelationInput | TeamOrderByWithRelationInput[]
    cursor?: TeamWhereUniqueInput
    take?: number
    skip?: number
    distinct?: TeamScalarFieldEnum | TeamScalarFieldEnum[]
  }

  /**
   * User.AssignToTeamMember
   */
  export type User$AssignToTeamMemberArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AssignTeamMember
     */
    select?: AssignTeamMemberSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AssignTeamMember
     */
    omit?: AssignTeamMemberOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AssignTeamMemberInclude<ExtArgs> | null
    where?: AssignTeamMemberWhereInput
    orderBy?: AssignTeamMemberOrderByWithRelationInput | AssignTeamMemberOrderByWithRelationInput[]
    cursor?: AssignTeamMemberWhereUniqueInput
    take?: number
    skip?: number
    distinct?: AssignTeamMemberScalarFieldEnum | AssignTeamMemberScalarFieldEnum[]
  }

  /**
   * User.AssignByTeamMember
   */
  export type User$AssignByTeamMemberArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AssignTeamMember
     */
    select?: AssignTeamMemberSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AssignTeamMember
     */
    omit?: AssignTeamMemberOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AssignTeamMemberInclude<ExtArgs> | null
    where?: AssignTeamMemberWhereInput
    orderBy?: AssignTeamMemberOrderByWithRelationInput | AssignTeamMemberOrderByWithRelationInput[]
    cursor?: AssignTeamMemberWhereUniqueInput
    take?: number
    skip?: number
    distinct?: AssignTeamMemberScalarFieldEnum | AssignTeamMemberScalarFieldEnum[]
  }

  /**
   * User.AssignUserMember
   */
  export type User$AssignUserMemberArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AssignTeamMember
     */
    select?: AssignTeamMemberSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AssignTeamMember
     */
    omit?: AssignTeamMemberOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AssignTeamMemberInclude<ExtArgs> | null
    where?: AssignTeamMemberWhereInput
    orderBy?: AssignTeamMemberOrderByWithRelationInput | AssignTeamMemberOrderByWithRelationInput[]
    cursor?: AssignTeamMemberWhereUniqueInput
    take?: number
    skip?: number
    distinct?: AssignTeamMemberScalarFieldEnum | AssignTeamMemberScalarFieldEnum[]
  }

  /**
   * User.AssignOrgMember
   */
  export type User$AssignOrgMemberArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AssignTeamMember
     */
    select?: AssignTeamMemberSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AssignTeamMember
     */
    omit?: AssignTeamMemberOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AssignTeamMemberInclude<ExtArgs> | null
    where?: AssignTeamMemberWhereInput
    orderBy?: AssignTeamMemberOrderByWithRelationInput | AssignTeamMemberOrderByWithRelationInput[]
    cursor?: AssignTeamMemberWhereUniqueInput
    take?: number
    skip?: number
    distinct?: AssignTeamMemberScalarFieldEnum | AssignTeamMemberScalarFieldEnum[]
  }

  /**
   * User.UserInfo
   */
  export type User$UserInfoArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetails
     */
    select?: UserDetailsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserDetails
     */
    omit?: UserDetailsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailsInclude<ExtArgs> | null
    where?: UserDetailsWhereInput
  }

  /**
   * User without action
   */
  export type UserDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
  }


  /**
   * Model UserDetails
   */

  export type AggregateUserDetails = {
    _count: UserDetailsCountAggregateOutputType | null
    _avg: UserDetailsAvgAggregateOutputType | null
    _sum: UserDetailsSumAggregateOutputType | null
    _min: UserDetailsMinAggregateOutputType | null
    _max: UserDetailsMaxAggregateOutputType | null
  }

  export type UserDetailsAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
    organisation_id: number | null
    role_id: number | null
  }

  export type UserDetailsSumAggregateOutputType = {
    id: number | null
    user_id: number | null
    organisation_id: number | null
    role_id: number | null
  }

  export type UserDetailsMinAggregateOutputType = {
    id: number | null
    address: string | null
    user_id: number | null
    organisation_id: number | null
    created_at: Date | null
    updated_at: Date | null
    role_id: number | null
  }

  export type UserDetailsMaxAggregateOutputType = {
    id: number | null
    address: string | null
    user_id: number | null
    organisation_id: number | null
    created_at: Date | null
    updated_at: Date | null
    role_id: number | null
  }

  export type UserDetailsCountAggregateOutputType = {
    id: number
    address: number
    user_id: number
    organisation_id: number
    created_at: number
    updated_at: number
    role_id: number
    _all: number
  }


  export type UserDetailsAvgAggregateInputType = {
    id?: true
    user_id?: true
    organisation_id?: true
    role_id?: true
  }

  export type UserDetailsSumAggregateInputType = {
    id?: true
    user_id?: true
    organisation_id?: true
    role_id?: true
  }

  export type UserDetailsMinAggregateInputType = {
    id?: true
    address?: true
    user_id?: true
    organisation_id?: true
    created_at?: true
    updated_at?: true
    role_id?: true
  }

  export type UserDetailsMaxAggregateInputType = {
    id?: true
    address?: true
    user_id?: true
    organisation_id?: true
    created_at?: true
    updated_at?: true
    role_id?: true
  }

  export type UserDetailsCountAggregateInputType = {
    id?: true
    address?: true
    user_id?: true
    organisation_id?: true
    created_at?: true
    updated_at?: true
    role_id?: true
    _all?: true
  }

  export type UserDetailsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserDetails to aggregate.
     */
    where?: UserDetailsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserDetails to fetch.
     */
    orderBy?: UserDetailsOrderByWithRelationInput | UserDetailsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UserDetailsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserDetails.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned UserDetails
    **/
    _count?: true | UserDetailsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: UserDetailsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: UserDetailsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserDetailsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserDetailsMaxAggregateInputType
  }

  export type GetUserDetailsAggregateType<T extends UserDetailsAggregateArgs> = {
        [P in keyof T & keyof AggregateUserDetails]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUserDetails[P]>
      : GetScalarType<T[P], AggregateUserDetails[P]>
  }




  export type UserDetailsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserDetailsWhereInput
    orderBy?: UserDetailsOrderByWithAggregationInput | UserDetailsOrderByWithAggregationInput[]
    by: UserDetailsScalarFieldEnum[] | UserDetailsScalarFieldEnum
    having?: UserDetailsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserDetailsCountAggregateInputType | true
    _avg?: UserDetailsAvgAggregateInputType
    _sum?: UserDetailsSumAggregateInputType
    _min?: UserDetailsMinAggregateInputType
    _max?: UserDetailsMaxAggregateInputType
  }

  export type UserDetailsGroupByOutputType = {
    id: number
    address: string | null
    user_id: number
    organisation_id: number | null
    created_at: Date
    updated_at: Date
    role_id: number
    _count: UserDetailsCountAggregateOutputType | null
    _avg: UserDetailsAvgAggregateOutputType | null
    _sum: UserDetailsSumAggregateOutputType | null
    _min: UserDetailsMinAggregateOutputType | null
    _max: UserDetailsMaxAggregateOutputType | null
  }

  type GetUserDetailsGroupByPayload<T extends UserDetailsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserDetailsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserDetailsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserDetailsGroupByOutputType[P]>
            : GetScalarType<T[P], UserDetailsGroupByOutputType[P]>
        }
      >
    >


  export type UserDetailsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    address?: boolean
    user_id?: boolean
    organisation_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    role_id?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userDetails"]>

  export type UserDetailsSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    address?: boolean
    user_id?: boolean
    organisation_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    role_id?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userDetails"]>

  export type UserDetailsSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    address?: boolean
    user_id?: boolean
    organisation_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    role_id?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userDetails"]>

  export type UserDetailsSelectScalar = {
    id?: boolean
    address?: boolean
    user_id?: boolean
    organisation_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    role_id?: boolean
  }

  export type UserDetailsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "address" | "user_id" | "organisation_id" | "created_at" | "updated_at" | "role_id", ExtArgs["result"]["userDetails"]>
  export type UserDetailsInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
  }
  export type UserDetailsIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
  }
  export type UserDetailsIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
  }

  export type $UserDetailsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "UserDetails"
    objects: {
      user: Prisma.$UserPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      address: string | null
      user_id: number
      organisation_id: number | null
      created_at: Date
      updated_at: Date
      role_id: number
    }, ExtArgs["result"]["userDetails"]>
    composites: {}
  }

  type UserDetailsGetPayload<S extends boolean | null | undefined | UserDetailsDefaultArgs> = $Result.GetResult<Prisma.$UserDetailsPayload, S>

  type UserDetailsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<UserDetailsFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: UserDetailsCountAggregateInputType | true
    }

  export interface UserDetailsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['UserDetails'], meta: { name: 'UserDetails' } }
    /**
     * Find zero or one UserDetails that matches the filter.
     * @param {UserDetailsFindUniqueArgs} args - Arguments to find a UserDetails
     * @example
     * // Get one UserDetails
     * const userDetails = await prisma.userDetails.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends UserDetailsFindUniqueArgs>(args: SelectSubset<T, UserDetailsFindUniqueArgs<ExtArgs>>): Prisma__UserDetailsClient<$Result.GetResult<Prisma.$UserDetailsPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one UserDetails that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {UserDetailsFindUniqueOrThrowArgs} args - Arguments to find a UserDetails
     * @example
     * // Get one UserDetails
     * const userDetails = await prisma.userDetails.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends UserDetailsFindUniqueOrThrowArgs>(args: SelectSubset<T, UserDetailsFindUniqueOrThrowArgs<ExtArgs>>): Prisma__UserDetailsClient<$Result.GetResult<Prisma.$UserDetailsPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first UserDetails that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailsFindFirstArgs} args - Arguments to find a UserDetails
     * @example
     * // Get one UserDetails
     * const userDetails = await prisma.userDetails.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends UserDetailsFindFirstArgs>(args?: SelectSubset<T, UserDetailsFindFirstArgs<ExtArgs>>): Prisma__UserDetailsClient<$Result.GetResult<Prisma.$UserDetailsPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first UserDetails that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailsFindFirstOrThrowArgs} args - Arguments to find a UserDetails
     * @example
     * // Get one UserDetails
     * const userDetails = await prisma.userDetails.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends UserDetailsFindFirstOrThrowArgs>(args?: SelectSubset<T, UserDetailsFindFirstOrThrowArgs<ExtArgs>>): Prisma__UserDetailsClient<$Result.GetResult<Prisma.$UserDetailsPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more UserDetails that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all UserDetails
     * const userDetails = await prisma.userDetails.findMany()
     * 
     * // Get first 10 UserDetails
     * const userDetails = await prisma.userDetails.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const userDetailsWithIdOnly = await prisma.userDetails.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends UserDetailsFindManyArgs>(args?: SelectSubset<T, UserDetailsFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserDetailsPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a UserDetails.
     * @param {UserDetailsCreateArgs} args - Arguments to create a UserDetails.
     * @example
     * // Create one UserDetails
     * const UserDetails = await prisma.userDetails.create({
     *   data: {
     *     // ... data to create a UserDetails
     *   }
     * })
     * 
     */
    create<T extends UserDetailsCreateArgs>(args: SelectSubset<T, UserDetailsCreateArgs<ExtArgs>>): Prisma__UserDetailsClient<$Result.GetResult<Prisma.$UserDetailsPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many UserDetails.
     * @param {UserDetailsCreateManyArgs} args - Arguments to create many UserDetails.
     * @example
     * // Create many UserDetails
     * const userDetails = await prisma.userDetails.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends UserDetailsCreateManyArgs>(args?: SelectSubset<T, UserDetailsCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many UserDetails and returns the data saved in the database.
     * @param {UserDetailsCreateManyAndReturnArgs} args - Arguments to create many UserDetails.
     * @example
     * // Create many UserDetails
     * const userDetails = await prisma.userDetails.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many UserDetails and only return the `id`
     * const userDetailsWithIdOnly = await prisma.userDetails.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends UserDetailsCreateManyAndReturnArgs>(args?: SelectSubset<T, UserDetailsCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserDetailsPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a UserDetails.
     * @param {UserDetailsDeleteArgs} args - Arguments to delete one UserDetails.
     * @example
     * // Delete one UserDetails
     * const UserDetails = await prisma.userDetails.delete({
     *   where: {
     *     // ... filter to delete one UserDetails
     *   }
     * })
     * 
     */
    delete<T extends UserDetailsDeleteArgs>(args: SelectSubset<T, UserDetailsDeleteArgs<ExtArgs>>): Prisma__UserDetailsClient<$Result.GetResult<Prisma.$UserDetailsPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one UserDetails.
     * @param {UserDetailsUpdateArgs} args - Arguments to update one UserDetails.
     * @example
     * // Update one UserDetails
     * const userDetails = await prisma.userDetails.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends UserDetailsUpdateArgs>(args: SelectSubset<T, UserDetailsUpdateArgs<ExtArgs>>): Prisma__UserDetailsClient<$Result.GetResult<Prisma.$UserDetailsPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more UserDetails.
     * @param {UserDetailsDeleteManyArgs} args - Arguments to filter UserDetails to delete.
     * @example
     * // Delete a few UserDetails
     * const { count } = await prisma.userDetails.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends UserDetailsDeleteManyArgs>(args?: SelectSubset<T, UserDetailsDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more UserDetails.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many UserDetails
     * const userDetails = await prisma.userDetails.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends UserDetailsUpdateManyArgs>(args: SelectSubset<T, UserDetailsUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more UserDetails and returns the data updated in the database.
     * @param {UserDetailsUpdateManyAndReturnArgs} args - Arguments to update many UserDetails.
     * @example
     * // Update many UserDetails
     * const userDetails = await prisma.userDetails.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more UserDetails and only return the `id`
     * const userDetailsWithIdOnly = await prisma.userDetails.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends UserDetailsUpdateManyAndReturnArgs>(args: SelectSubset<T, UserDetailsUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserDetailsPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one UserDetails.
     * @param {UserDetailsUpsertArgs} args - Arguments to update or create a UserDetails.
     * @example
     * // Update or create a UserDetails
     * const userDetails = await prisma.userDetails.upsert({
     *   create: {
     *     // ... data to create a UserDetails
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the UserDetails we want to update
     *   }
     * })
     */
    upsert<T extends UserDetailsUpsertArgs>(args: SelectSubset<T, UserDetailsUpsertArgs<ExtArgs>>): Prisma__UserDetailsClient<$Result.GetResult<Prisma.$UserDetailsPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of UserDetails.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailsCountArgs} args - Arguments to filter UserDetails to count.
     * @example
     * // Count the number of UserDetails
     * const count = await prisma.userDetails.count({
     *   where: {
     *     // ... the filter for the UserDetails we want to count
     *   }
     * })
    **/
    count<T extends UserDetailsCountArgs>(
      args?: Subset<T, UserDetailsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserDetailsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a UserDetails.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserDetailsAggregateArgs>(args: Subset<T, UserDetailsAggregateArgs>): Prisma.PrismaPromise<GetUserDetailsAggregateType<T>>

    /**
     * Group by UserDetails.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UserDetailsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UserDetailsGroupByArgs['orderBy'] }
        : { orderBy?: UserDetailsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UserDetailsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserDetailsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the UserDetails model
   */
  readonly fields: UserDetailsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for UserDetails.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__UserDetailsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    user<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the UserDetails model
   */ 
  interface UserDetailsFieldRefs {
    readonly id: FieldRef<"UserDetails", 'Int'>
    readonly address: FieldRef<"UserDetails", 'String'>
    readonly user_id: FieldRef<"UserDetails", 'Int'>
    readonly organisation_id: FieldRef<"UserDetails", 'Int'>
    readonly created_at: FieldRef<"UserDetails", 'DateTime'>
    readonly updated_at: FieldRef<"UserDetails", 'DateTime'>
    readonly role_id: FieldRef<"UserDetails", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * UserDetails findUnique
   */
  export type UserDetailsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetails
     */
    select?: UserDetailsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserDetails
     */
    omit?: UserDetailsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailsInclude<ExtArgs> | null
    /**
     * Filter, which UserDetails to fetch.
     */
    where: UserDetailsWhereUniqueInput
  }

  /**
   * UserDetails findUniqueOrThrow
   */
  export type UserDetailsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetails
     */
    select?: UserDetailsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserDetails
     */
    omit?: UserDetailsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailsInclude<ExtArgs> | null
    /**
     * Filter, which UserDetails to fetch.
     */
    where: UserDetailsWhereUniqueInput
  }

  /**
   * UserDetails findFirst
   */
  export type UserDetailsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetails
     */
    select?: UserDetailsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserDetails
     */
    omit?: UserDetailsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailsInclude<ExtArgs> | null
    /**
     * Filter, which UserDetails to fetch.
     */
    where?: UserDetailsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserDetails to fetch.
     */
    orderBy?: UserDetailsOrderByWithRelationInput | UserDetailsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserDetails.
     */
    cursor?: UserDetailsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserDetails.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserDetails.
     */
    distinct?: UserDetailsScalarFieldEnum | UserDetailsScalarFieldEnum[]
  }

  /**
   * UserDetails findFirstOrThrow
   */
  export type UserDetailsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetails
     */
    select?: UserDetailsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserDetails
     */
    omit?: UserDetailsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailsInclude<ExtArgs> | null
    /**
     * Filter, which UserDetails to fetch.
     */
    where?: UserDetailsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserDetails to fetch.
     */
    orderBy?: UserDetailsOrderByWithRelationInput | UserDetailsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserDetails.
     */
    cursor?: UserDetailsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserDetails.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserDetails.
     */
    distinct?: UserDetailsScalarFieldEnum | UserDetailsScalarFieldEnum[]
  }

  /**
   * UserDetails findMany
   */
  export type UserDetailsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetails
     */
    select?: UserDetailsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserDetails
     */
    omit?: UserDetailsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailsInclude<ExtArgs> | null
    /**
     * Filter, which UserDetails to fetch.
     */
    where?: UserDetailsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserDetails to fetch.
     */
    orderBy?: UserDetailsOrderByWithRelationInput | UserDetailsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing UserDetails.
     */
    cursor?: UserDetailsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserDetails.
     */
    skip?: number
    distinct?: UserDetailsScalarFieldEnum | UserDetailsScalarFieldEnum[]
  }

  /**
   * UserDetails create
   */
  export type UserDetailsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetails
     */
    select?: UserDetailsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserDetails
     */
    omit?: UserDetailsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailsInclude<ExtArgs> | null
    /**
     * The data needed to create a UserDetails.
     */
    data: XOR<UserDetailsCreateInput, UserDetailsUncheckedCreateInput>
  }

  /**
   * UserDetails createMany
   */
  export type UserDetailsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many UserDetails.
     */
    data: UserDetailsCreateManyInput | UserDetailsCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * UserDetails createManyAndReturn
   */
  export type UserDetailsCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetails
     */
    select?: UserDetailsSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the UserDetails
     */
    omit?: UserDetailsOmit<ExtArgs> | null
    /**
     * The data used to create many UserDetails.
     */
    data: UserDetailsCreateManyInput | UserDetailsCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailsIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * UserDetails update
   */
  export type UserDetailsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetails
     */
    select?: UserDetailsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserDetails
     */
    omit?: UserDetailsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailsInclude<ExtArgs> | null
    /**
     * The data needed to update a UserDetails.
     */
    data: XOR<UserDetailsUpdateInput, UserDetailsUncheckedUpdateInput>
    /**
     * Choose, which UserDetails to update.
     */
    where: UserDetailsWhereUniqueInput
  }

  /**
   * UserDetails updateMany
   */
  export type UserDetailsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update UserDetails.
     */
    data: XOR<UserDetailsUpdateManyMutationInput, UserDetailsUncheckedUpdateManyInput>
    /**
     * Filter which UserDetails to update
     */
    where?: UserDetailsWhereInput
    /**
     * Limit how many UserDetails to update.
     */
    limit?: number
  }

  /**
   * UserDetails updateManyAndReturn
   */
  export type UserDetailsUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetails
     */
    select?: UserDetailsSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the UserDetails
     */
    omit?: UserDetailsOmit<ExtArgs> | null
    /**
     * The data used to update UserDetails.
     */
    data: XOR<UserDetailsUpdateManyMutationInput, UserDetailsUncheckedUpdateManyInput>
    /**
     * Filter which UserDetails to update
     */
    where?: UserDetailsWhereInput
    /**
     * Limit how many UserDetails to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailsIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * UserDetails upsert
   */
  export type UserDetailsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetails
     */
    select?: UserDetailsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserDetails
     */
    omit?: UserDetailsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailsInclude<ExtArgs> | null
    /**
     * The filter to search for the UserDetails to update in case it exists.
     */
    where: UserDetailsWhereUniqueInput
    /**
     * In case the UserDetails found by the `where` argument doesn't exist, create a new UserDetails with this data.
     */
    create: XOR<UserDetailsCreateInput, UserDetailsUncheckedCreateInput>
    /**
     * In case the UserDetails was found with the provided `where` argument, update it with this data.
     */
    update: XOR<UserDetailsUpdateInput, UserDetailsUncheckedUpdateInput>
  }

  /**
   * UserDetails delete
   */
  export type UserDetailsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetails
     */
    select?: UserDetailsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserDetails
     */
    omit?: UserDetailsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailsInclude<ExtArgs> | null
    /**
     * Filter which UserDetails to delete.
     */
    where: UserDetailsWhereUniqueInput
  }

  /**
   * UserDetails deleteMany
   */
  export type UserDetailsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserDetails to delete
     */
    where?: UserDetailsWhereInput
    /**
     * Limit how many UserDetails to delete.
     */
    limit?: number
  }

  /**
   * UserDetails without action
   */
  export type UserDetailsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetails
     */
    select?: UserDetailsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserDetails
     */
    omit?: UserDetailsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailsInclude<ExtArgs> | null
  }


  /**
   * Model ProjectCategory
   */

  export type AggregateProjectCategory = {
    _count: ProjectCategoryCountAggregateOutputType | null
    _avg: ProjectCategoryAvgAggregateOutputType | null
    _sum: ProjectCategorySumAggregateOutputType | null
    _min: ProjectCategoryMinAggregateOutputType | null
    _max: ProjectCategoryMaxAggregateOutputType | null
  }

  export type ProjectCategoryAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type ProjectCategorySumAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type ProjectCategoryMinAggregateOutputType = {
    id: number | null
    category_name: string | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    user_id: number | null
  }

  export type ProjectCategoryMaxAggregateOutputType = {
    id: number | null
    category_name: string | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    user_id: number | null
  }

  export type ProjectCategoryCountAggregateOutputType = {
    id: number
    category_name: number
    created_at: number
    updated_at: number
    deleted_at: number
    user_id: number
    _all: number
  }


  export type ProjectCategoryAvgAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type ProjectCategorySumAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type ProjectCategoryMinAggregateInputType = {
    id?: true
    category_name?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    user_id?: true
  }

  export type ProjectCategoryMaxAggregateInputType = {
    id?: true
    category_name?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    user_id?: true
  }

  export type ProjectCategoryCountAggregateInputType = {
    id?: true
    category_name?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    user_id?: true
    _all?: true
  }

  export type ProjectCategoryAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ProjectCategory to aggregate.
     */
    where?: ProjectCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProjectCategories to fetch.
     */
    orderBy?: ProjectCategoryOrderByWithRelationInput | ProjectCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ProjectCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProjectCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProjectCategories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ProjectCategories
    **/
    _count?: true | ProjectCategoryCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ProjectCategoryAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ProjectCategorySumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ProjectCategoryMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ProjectCategoryMaxAggregateInputType
  }

  export type GetProjectCategoryAggregateType<T extends ProjectCategoryAggregateArgs> = {
        [P in keyof T & keyof AggregateProjectCategory]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateProjectCategory[P]>
      : GetScalarType<T[P], AggregateProjectCategory[P]>
  }




  export type ProjectCategoryGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProjectCategoryWhereInput
    orderBy?: ProjectCategoryOrderByWithAggregationInput | ProjectCategoryOrderByWithAggregationInput[]
    by: ProjectCategoryScalarFieldEnum[] | ProjectCategoryScalarFieldEnum
    having?: ProjectCategoryScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ProjectCategoryCountAggregateInputType | true
    _avg?: ProjectCategoryAvgAggregateInputType
    _sum?: ProjectCategorySumAggregateInputType
    _min?: ProjectCategoryMinAggregateInputType
    _max?: ProjectCategoryMaxAggregateInputType
  }

  export type ProjectCategoryGroupByOutputType = {
    id: number
    category_name: string
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    user_id: number
    _count: ProjectCategoryCountAggregateOutputType | null
    _avg: ProjectCategoryAvgAggregateOutputType | null
    _sum: ProjectCategorySumAggregateOutputType | null
    _min: ProjectCategoryMinAggregateOutputType | null
    _max: ProjectCategoryMaxAggregateOutputType | null
  }

  type GetProjectCategoryGroupByPayload<T extends ProjectCategoryGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ProjectCategoryGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ProjectCategoryGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ProjectCategoryGroupByOutputType[P]>
            : GetScalarType<T[P], ProjectCategoryGroupByOutputType[P]>
        }
      >
    >


  export type ProjectCategorySelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    category_name?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    user_id?: boolean
    projects?: boolean | ProjectCategory$projectsArgs<ExtArgs>
    createdby?: boolean | UserDefaultArgs<ExtArgs>
    _count?: boolean | ProjectCategoryCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["projectCategory"]>

  export type ProjectCategorySelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    category_name?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    user_id?: boolean
    createdby?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["projectCategory"]>

  export type ProjectCategorySelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    category_name?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    user_id?: boolean
    createdby?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["projectCategory"]>

  export type ProjectCategorySelectScalar = {
    id?: boolean
    category_name?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    user_id?: boolean
  }

  export type ProjectCategoryOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "category_name" | "created_at" | "updated_at" | "deleted_at" | "user_id", ExtArgs["result"]["projectCategory"]>
  export type ProjectCategoryInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    projects?: boolean | ProjectCategory$projectsArgs<ExtArgs>
    createdby?: boolean | UserDefaultArgs<ExtArgs>
    _count?: boolean | ProjectCategoryCountOutputTypeDefaultArgs<ExtArgs>
  }
  export type ProjectCategoryIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    createdby?: boolean | UserDefaultArgs<ExtArgs>
  }
  export type ProjectCategoryIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    createdby?: boolean | UserDefaultArgs<ExtArgs>
  }

  export type $ProjectCategoryPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "ProjectCategory"
    objects: {
      projects: Prisma.$ProjectPayload<ExtArgs>[]
      createdby: Prisma.$UserPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      category_name: string
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
      user_id: number
    }, ExtArgs["result"]["projectCategory"]>
    composites: {}
  }

  type ProjectCategoryGetPayload<S extends boolean | null | undefined | ProjectCategoryDefaultArgs> = $Result.GetResult<Prisma.$ProjectCategoryPayload, S>

  type ProjectCategoryCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<ProjectCategoryFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: ProjectCategoryCountAggregateInputType | true
    }

  export interface ProjectCategoryDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['ProjectCategory'], meta: { name: 'ProjectCategory' } }
    /**
     * Find zero or one ProjectCategory that matches the filter.
     * @param {ProjectCategoryFindUniqueArgs} args - Arguments to find a ProjectCategory
     * @example
     * // Get one ProjectCategory
     * const projectCategory = await prisma.projectCategory.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ProjectCategoryFindUniqueArgs>(args: SelectSubset<T, ProjectCategoryFindUniqueArgs<ExtArgs>>): Prisma__ProjectCategoryClient<$Result.GetResult<Prisma.$ProjectCategoryPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one ProjectCategory that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {ProjectCategoryFindUniqueOrThrowArgs} args - Arguments to find a ProjectCategory
     * @example
     * // Get one ProjectCategory
     * const projectCategory = await prisma.projectCategory.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ProjectCategoryFindUniqueOrThrowArgs>(args: SelectSubset<T, ProjectCategoryFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ProjectCategoryClient<$Result.GetResult<Prisma.$ProjectCategoryPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first ProjectCategory that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectCategoryFindFirstArgs} args - Arguments to find a ProjectCategory
     * @example
     * // Get one ProjectCategory
     * const projectCategory = await prisma.projectCategory.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ProjectCategoryFindFirstArgs>(args?: SelectSubset<T, ProjectCategoryFindFirstArgs<ExtArgs>>): Prisma__ProjectCategoryClient<$Result.GetResult<Prisma.$ProjectCategoryPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first ProjectCategory that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectCategoryFindFirstOrThrowArgs} args - Arguments to find a ProjectCategory
     * @example
     * // Get one ProjectCategory
     * const projectCategory = await prisma.projectCategory.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ProjectCategoryFindFirstOrThrowArgs>(args?: SelectSubset<T, ProjectCategoryFindFirstOrThrowArgs<ExtArgs>>): Prisma__ProjectCategoryClient<$Result.GetResult<Prisma.$ProjectCategoryPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more ProjectCategories that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectCategoryFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all ProjectCategories
     * const projectCategories = await prisma.projectCategory.findMany()
     * 
     * // Get first 10 ProjectCategories
     * const projectCategories = await prisma.projectCategory.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const projectCategoryWithIdOnly = await prisma.projectCategory.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ProjectCategoryFindManyArgs>(args?: SelectSubset<T, ProjectCategoryFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectCategoryPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a ProjectCategory.
     * @param {ProjectCategoryCreateArgs} args - Arguments to create a ProjectCategory.
     * @example
     * // Create one ProjectCategory
     * const ProjectCategory = await prisma.projectCategory.create({
     *   data: {
     *     // ... data to create a ProjectCategory
     *   }
     * })
     * 
     */
    create<T extends ProjectCategoryCreateArgs>(args: SelectSubset<T, ProjectCategoryCreateArgs<ExtArgs>>): Prisma__ProjectCategoryClient<$Result.GetResult<Prisma.$ProjectCategoryPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many ProjectCategories.
     * @param {ProjectCategoryCreateManyArgs} args - Arguments to create many ProjectCategories.
     * @example
     * // Create many ProjectCategories
     * const projectCategory = await prisma.projectCategory.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ProjectCategoryCreateManyArgs>(args?: SelectSubset<T, ProjectCategoryCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many ProjectCategories and returns the data saved in the database.
     * @param {ProjectCategoryCreateManyAndReturnArgs} args - Arguments to create many ProjectCategories.
     * @example
     * // Create many ProjectCategories
     * const projectCategory = await prisma.projectCategory.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many ProjectCategories and only return the `id`
     * const projectCategoryWithIdOnly = await prisma.projectCategory.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends ProjectCategoryCreateManyAndReturnArgs>(args?: SelectSubset<T, ProjectCategoryCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectCategoryPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a ProjectCategory.
     * @param {ProjectCategoryDeleteArgs} args - Arguments to delete one ProjectCategory.
     * @example
     * // Delete one ProjectCategory
     * const ProjectCategory = await prisma.projectCategory.delete({
     *   where: {
     *     // ... filter to delete one ProjectCategory
     *   }
     * })
     * 
     */
    delete<T extends ProjectCategoryDeleteArgs>(args: SelectSubset<T, ProjectCategoryDeleteArgs<ExtArgs>>): Prisma__ProjectCategoryClient<$Result.GetResult<Prisma.$ProjectCategoryPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one ProjectCategory.
     * @param {ProjectCategoryUpdateArgs} args - Arguments to update one ProjectCategory.
     * @example
     * // Update one ProjectCategory
     * const projectCategory = await prisma.projectCategory.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ProjectCategoryUpdateArgs>(args: SelectSubset<T, ProjectCategoryUpdateArgs<ExtArgs>>): Prisma__ProjectCategoryClient<$Result.GetResult<Prisma.$ProjectCategoryPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more ProjectCategories.
     * @param {ProjectCategoryDeleteManyArgs} args - Arguments to filter ProjectCategories to delete.
     * @example
     * // Delete a few ProjectCategories
     * const { count } = await prisma.projectCategory.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ProjectCategoryDeleteManyArgs>(args?: SelectSubset<T, ProjectCategoryDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ProjectCategories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectCategoryUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many ProjectCategories
     * const projectCategory = await prisma.projectCategory.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ProjectCategoryUpdateManyArgs>(args: SelectSubset<T, ProjectCategoryUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ProjectCategories and returns the data updated in the database.
     * @param {ProjectCategoryUpdateManyAndReturnArgs} args - Arguments to update many ProjectCategories.
     * @example
     * // Update many ProjectCategories
     * const projectCategory = await prisma.projectCategory.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more ProjectCategories and only return the `id`
     * const projectCategoryWithIdOnly = await prisma.projectCategory.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends ProjectCategoryUpdateManyAndReturnArgs>(args: SelectSubset<T, ProjectCategoryUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectCategoryPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one ProjectCategory.
     * @param {ProjectCategoryUpsertArgs} args - Arguments to update or create a ProjectCategory.
     * @example
     * // Update or create a ProjectCategory
     * const projectCategory = await prisma.projectCategory.upsert({
     *   create: {
     *     // ... data to create a ProjectCategory
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the ProjectCategory we want to update
     *   }
     * })
     */
    upsert<T extends ProjectCategoryUpsertArgs>(args: SelectSubset<T, ProjectCategoryUpsertArgs<ExtArgs>>): Prisma__ProjectCategoryClient<$Result.GetResult<Prisma.$ProjectCategoryPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of ProjectCategories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectCategoryCountArgs} args - Arguments to filter ProjectCategories to count.
     * @example
     * // Count the number of ProjectCategories
     * const count = await prisma.projectCategory.count({
     *   where: {
     *     // ... the filter for the ProjectCategories we want to count
     *   }
     * })
    **/
    count<T extends ProjectCategoryCountArgs>(
      args?: Subset<T, ProjectCategoryCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ProjectCategoryCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a ProjectCategory.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectCategoryAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ProjectCategoryAggregateArgs>(args: Subset<T, ProjectCategoryAggregateArgs>): Prisma.PrismaPromise<GetProjectCategoryAggregateType<T>>

    /**
     * Group by ProjectCategory.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectCategoryGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ProjectCategoryGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ProjectCategoryGroupByArgs['orderBy'] }
        : { orderBy?: ProjectCategoryGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ProjectCategoryGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetProjectCategoryGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the ProjectCategory model
   */
  readonly fields: ProjectCategoryFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for ProjectCategory.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ProjectCategoryClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    projects<T extends ProjectCategory$projectsArgs<ExtArgs> = {}>(args?: Subset<T, ProjectCategory$projectsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    createdby<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the ProjectCategory model
   */ 
  interface ProjectCategoryFieldRefs {
    readonly id: FieldRef<"ProjectCategory", 'Int'>
    readonly category_name: FieldRef<"ProjectCategory", 'String'>
    readonly created_at: FieldRef<"ProjectCategory", 'DateTime'>
    readonly updated_at: FieldRef<"ProjectCategory", 'DateTime'>
    readonly deleted_at: FieldRef<"ProjectCategory", 'DateTime'>
    readonly user_id: FieldRef<"ProjectCategory", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * ProjectCategory findUnique
   */
  export type ProjectCategoryFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectCategory
     */
    select?: ProjectCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectCategory
     */
    omit?: ProjectCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectCategoryInclude<ExtArgs> | null
    /**
     * Filter, which ProjectCategory to fetch.
     */
    where: ProjectCategoryWhereUniqueInput
  }

  /**
   * ProjectCategory findUniqueOrThrow
   */
  export type ProjectCategoryFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectCategory
     */
    select?: ProjectCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectCategory
     */
    omit?: ProjectCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectCategoryInclude<ExtArgs> | null
    /**
     * Filter, which ProjectCategory to fetch.
     */
    where: ProjectCategoryWhereUniqueInput
  }

  /**
   * ProjectCategory findFirst
   */
  export type ProjectCategoryFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectCategory
     */
    select?: ProjectCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectCategory
     */
    omit?: ProjectCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectCategoryInclude<ExtArgs> | null
    /**
     * Filter, which ProjectCategory to fetch.
     */
    where?: ProjectCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProjectCategories to fetch.
     */
    orderBy?: ProjectCategoryOrderByWithRelationInput | ProjectCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ProjectCategories.
     */
    cursor?: ProjectCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProjectCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProjectCategories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ProjectCategories.
     */
    distinct?: ProjectCategoryScalarFieldEnum | ProjectCategoryScalarFieldEnum[]
  }

  /**
   * ProjectCategory findFirstOrThrow
   */
  export type ProjectCategoryFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectCategory
     */
    select?: ProjectCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectCategory
     */
    omit?: ProjectCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectCategoryInclude<ExtArgs> | null
    /**
     * Filter, which ProjectCategory to fetch.
     */
    where?: ProjectCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProjectCategories to fetch.
     */
    orderBy?: ProjectCategoryOrderByWithRelationInput | ProjectCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ProjectCategories.
     */
    cursor?: ProjectCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProjectCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProjectCategories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ProjectCategories.
     */
    distinct?: ProjectCategoryScalarFieldEnum | ProjectCategoryScalarFieldEnum[]
  }

  /**
   * ProjectCategory findMany
   */
  export type ProjectCategoryFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectCategory
     */
    select?: ProjectCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectCategory
     */
    omit?: ProjectCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectCategoryInclude<ExtArgs> | null
    /**
     * Filter, which ProjectCategories to fetch.
     */
    where?: ProjectCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProjectCategories to fetch.
     */
    orderBy?: ProjectCategoryOrderByWithRelationInput | ProjectCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing ProjectCategories.
     */
    cursor?: ProjectCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProjectCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProjectCategories.
     */
    skip?: number
    distinct?: ProjectCategoryScalarFieldEnum | ProjectCategoryScalarFieldEnum[]
  }

  /**
   * ProjectCategory create
   */
  export type ProjectCategoryCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectCategory
     */
    select?: ProjectCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectCategory
     */
    omit?: ProjectCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectCategoryInclude<ExtArgs> | null
    /**
     * The data needed to create a ProjectCategory.
     */
    data: XOR<ProjectCategoryCreateInput, ProjectCategoryUncheckedCreateInput>
  }

  /**
   * ProjectCategory createMany
   */
  export type ProjectCategoryCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many ProjectCategories.
     */
    data: ProjectCategoryCreateManyInput | ProjectCategoryCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * ProjectCategory createManyAndReturn
   */
  export type ProjectCategoryCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectCategory
     */
    select?: ProjectCategorySelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectCategory
     */
    omit?: ProjectCategoryOmit<ExtArgs> | null
    /**
     * The data used to create many ProjectCategories.
     */
    data: ProjectCategoryCreateManyInput | ProjectCategoryCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectCategoryIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * ProjectCategory update
   */
  export type ProjectCategoryUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectCategory
     */
    select?: ProjectCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectCategory
     */
    omit?: ProjectCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectCategoryInclude<ExtArgs> | null
    /**
     * The data needed to update a ProjectCategory.
     */
    data: XOR<ProjectCategoryUpdateInput, ProjectCategoryUncheckedUpdateInput>
    /**
     * Choose, which ProjectCategory to update.
     */
    where: ProjectCategoryWhereUniqueInput
  }

  /**
   * ProjectCategory updateMany
   */
  export type ProjectCategoryUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update ProjectCategories.
     */
    data: XOR<ProjectCategoryUpdateManyMutationInput, ProjectCategoryUncheckedUpdateManyInput>
    /**
     * Filter which ProjectCategories to update
     */
    where?: ProjectCategoryWhereInput
    /**
     * Limit how many ProjectCategories to update.
     */
    limit?: number
  }

  /**
   * ProjectCategory updateManyAndReturn
   */
  export type ProjectCategoryUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectCategory
     */
    select?: ProjectCategorySelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectCategory
     */
    omit?: ProjectCategoryOmit<ExtArgs> | null
    /**
     * The data used to update ProjectCategories.
     */
    data: XOR<ProjectCategoryUpdateManyMutationInput, ProjectCategoryUncheckedUpdateManyInput>
    /**
     * Filter which ProjectCategories to update
     */
    where?: ProjectCategoryWhereInput
    /**
     * Limit how many ProjectCategories to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectCategoryIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * ProjectCategory upsert
   */
  export type ProjectCategoryUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectCategory
     */
    select?: ProjectCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectCategory
     */
    omit?: ProjectCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectCategoryInclude<ExtArgs> | null
    /**
     * The filter to search for the ProjectCategory to update in case it exists.
     */
    where: ProjectCategoryWhereUniqueInput
    /**
     * In case the ProjectCategory found by the `where` argument doesn't exist, create a new ProjectCategory with this data.
     */
    create: XOR<ProjectCategoryCreateInput, ProjectCategoryUncheckedCreateInput>
    /**
     * In case the ProjectCategory was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ProjectCategoryUpdateInput, ProjectCategoryUncheckedUpdateInput>
  }

  /**
   * ProjectCategory delete
   */
  export type ProjectCategoryDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectCategory
     */
    select?: ProjectCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectCategory
     */
    omit?: ProjectCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectCategoryInclude<ExtArgs> | null
    /**
     * Filter which ProjectCategory to delete.
     */
    where: ProjectCategoryWhereUniqueInput
  }

  /**
   * ProjectCategory deleteMany
   */
  export type ProjectCategoryDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ProjectCategories to delete
     */
    where?: ProjectCategoryWhereInput
    /**
     * Limit how many ProjectCategories to delete.
     */
    limit?: number
  }

  /**
   * ProjectCategory.projects
   */
  export type ProjectCategory$projectsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Project
     */
    select?: ProjectSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Project
     */
    omit?: ProjectOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectInclude<ExtArgs> | null
    where?: ProjectWhereInput
    orderBy?: ProjectOrderByWithRelationInput | ProjectOrderByWithRelationInput[]
    cursor?: ProjectWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ProjectScalarFieldEnum | ProjectScalarFieldEnum[]
  }

  /**
   * ProjectCategory without action
   */
  export type ProjectCategoryDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectCategory
     */
    select?: ProjectCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectCategory
     */
    omit?: ProjectCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectCategoryInclude<ExtArgs> | null
  }


  /**
   * Model Project
   */

  export type AggregateProject = {
    _count: ProjectCountAggregateOutputType | null
    _avg: ProjectAvgAggregateOutputType | null
    _sum: ProjectSumAggregateOutputType | null
    _min: ProjectMinAggregateOutputType | null
    _max: ProjectMaxAggregateOutputType | null
  }

  export type ProjectAvgAggregateOutputType = {
    id: number | null
    category_id: number | null
    created_by_id: number | null
    total_tasks_count: number | null
    completed_tasks_count: number | null
    package_id: number | null
    time_around_days: number | null
    organisation_id: number | null
    daily_target_links: number | null
  }

  export type ProjectSumAggregateOutputType = {
    id: number | null
    category_id: number | null
    created_by_id: number | null
    total_tasks_count: number | null
    completed_tasks_count: number | null
    package_id: number | null
    time_around_days: number | null
    organisation_id: number | null
    daily_target_links: number | null
  }

  export type ProjectMinAggregateOutputType = {
    id: number | null
    domain_name: string | null
    domain_url: string | null
    category_id: number | null
    created_by_id: number | null
    total_tasks_count: number | null
    completed_tasks_count: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    time_around: Date | null
    package_id: number | null
    time_around_days: number | null
    organisation_id: number | null
    daily_target_links: number | null
  }

  export type ProjectMaxAggregateOutputType = {
    id: number | null
    domain_name: string | null
    domain_url: string | null
    category_id: number | null
    created_by_id: number | null
    total_tasks_count: number | null
    completed_tasks_count: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    time_around: Date | null
    package_id: number | null
    time_around_days: number | null
    organisation_id: number | null
    daily_target_links: number | null
  }

  export type ProjectCountAggregateOutputType = {
    id: number
    domain_name: number
    domain_url: number
    category_id: number
    created_by_id: number
    total_tasks_count: number
    completed_tasks_count: number
    created_at: number
    updated_at: number
    deleted_at: number
    time_around: number
    package_id: number
    time_around_days: number
    organisation_id: number
    daily_target_links: number
    _all: number
  }


  export type ProjectAvgAggregateInputType = {
    id?: true
    category_id?: true
    created_by_id?: true
    total_tasks_count?: true
    completed_tasks_count?: true
    package_id?: true
    time_around_days?: true
    organisation_id?: true
    daily_target_links?: true
  }

  export type ProjectSumAggregateInputType = {
    id?: true
    category_id?: true
    created_by_id?: true
    total_tasks_count?: true
    completed_tasks_count?: true
    package_id?: true
    time_around_days?: true
    organisation_id?: true
    daily_target_links?: true
  }

  export type ProjectMinAggregateInputType = {
    id?: true
    domain_name?: true
    domain_url?: true
    category_id?: true
    created_by_id?: true
    total_tasks_count?: true
    completed_tasks_count?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    time_around?: true
    package_id?: true
    time_around_days?: true
    organisation_id?: true
    daily_target_links?: true
  }

  export type ProjectMaxAggregateInputType = {
    id?: true
    domain_name?: true
    domain_url?: true
    category_id?: true
    created_by_id?: true
    total_tasks_count?: true
    completed_tasks_count?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    time_around?: true
    package_id?: true
    time_around_days?: true
    organisation_id?: true
    daily_target_links?: true
  }

  export type ProjectCountAggregateInputType = {
    id?: true
    domain_name?: true
    domain_url?: true
    category_id?: true
    created_by_id?: true
    total_tasks_count?: true
    completed_tasks_count?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    time_around?: true
    package_id?: true
    time_around_days?: true
    organisation_id?: true
    daily_target_links?: true
    _all?: true
  }

  export type ProjectAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Project to aggregate.
     */
    where?: ProjectWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Projects to fetch.
     */
    orderBy?: ProjectOrderByWithRelationInput | ProjectOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ProjectWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Projects from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Projects.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Projects
    **/
    _count?: true | ProjectCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ProjectAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ProjectSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ProjectMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ProjectMaxAggregateInputType
  }

  export type GetProjectAggregateType<T extends ProjectAggregateArgs> = {
        [P in keyof T & keyof AggregateProject]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateProject[P]>
      : GetScalarType<T[P], AggregateProject[P]>
  }




  export type ProjectGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProjectWhereInput
    orderBy?: ProjectOrderByWithAggregationInput | ProjectOrderByWithAggregationInput[]
    by: ProjectScalarFieldEnum[] | ProjectScalarFieldEnum
    having?: ProjectScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ProjectCountAggregateInputType | true
    _avg?: ProjectAvgAggregateInputType
    _sum?: ProjectSumAggregateInputType
    _min?: ProjectMinAggregateInputType
    _max?: ProjectMaxAggregateInputType
  }

  export type ProjectGroupByOutputType = {
    id: number
    domain_name: string
    domain_url: string
    category_id: number
    created_by_id: number
    total_tasks_count: number | null
    completed_tasks_count: number | null
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    time_around: Date | null
    package_id: number
    time_around_days: number
    organisation_id: number
    daily_target_links: number
    _count: ProjectCountAggregateOutputType | null
    _avg: ProjectAvgAggregateOutputType | null
    _sum: ProjectSumAggregateOutputType | null
    _min: ProjectMinAggregateOutputType | null
    _max: ProjectMaxAggregateOutputType | null
  }

  type GetProjectGroupByPayload<T extends ProjectGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ProjectGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ProjectGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ProjectGroupByOutputType[P]>
            : GetScalarType<T[P], ProjectGroupByOutputType[P]>
        }
      >
    >


  export type ProjectSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    domain_name?: boolean
    domain_url?: boolean
    category_id?: boolean
    created_by_id?: boolean
    total_tasks_count?: boolean
    completed_tasks_count?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    time_around?: boolean
    package_id?: boolean
    time_around_days?: boolean
    organisation_id?: boolean
    daily_target_links?: boolean
    category?: boolean | ProjectCategoryDefaultArgs<ExtArgs>
    created_by?: boolean | UserDefaultArgs<ExtArgs>
    backlinks?: boolean | Project$backlinksArgs<ExtArgs>
    ProjectMember?: boolean | Project$ProjectMemberArgs<ExtArgs>
    ProjectDetails?: boolean | Project$ProjectDetailsArgs<ExtArgs>
    TempLinks?: boolean | Project$TempLinksArgs<ExtArgs>
    SeoProjectDetails?: boolean | Project$SeoProjectDetailsArgs<ExtArgs>
    UserJobs?: boolean | Project$UserJobsArgs<ExtArgs>
    ProjectGuideLines?: boolean | Project$ProjectGuideLinesArgs<ExtArgs>
    OrganisationProject?: boolean | UserDefaultArgs<ExtArgs>
    ProjectPackage?: boolean | seo_packagesDefaultArgs<ExtArgs>
    _count?: boolean | ProjectCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["project"]>

  export type ProjectSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    domain_name?: boolean
    domain_url?: boolean
    category_id?: boolean
    created_by_id?: boolean
    total_tasks_count?: boolean
    completed_tasks_count?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    time_around?: boolean
    package_id?: boolean
    time_around_days?: boolean
    organisation_id?: boolean
    daily_target_links?: boolean
    category?: boolean | ProjectCategoryDefaultArgs<ExtArgs>
    created_by?: boolean | UserDefaultArgs<ExtArgs>
    OrganisationProject?: boolean | UserDefaultArgs<ExtArgs>
    ProjectPackage?: boolean | seo_packagesDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["project"]>

  export type ProjectSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    domain_name?: boolean
    domain_url?: boolean
    category_id?: boolean
    created_by_id?: boolean
    total_tasks_count?: boolean
    completed_tasks_count?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    time_around?: boolean
    package_id?: boolean
    time_around_days?: boolean
    organisation_id?: boolean
    daily_target_links?: boolean
    category?: boolean | ProjectCategoryDefaultArgs<ExtArgs>
    created_by?: boolean | UserDefaultArgs<ExtArgs>
    OrganisationProject?: boolean | UserDefaultArgs<ExtArgs>
    ProjectPackage?: boolean | seo_packagesDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["project"]>

  export type ProjectSelectScalar = {
    id?: boolean
    domain_name?: boolean
    domain_url?: boolean
    category_id?: boolean
    created_by_id?: boolean
    total_tasks_count?: boolean
    completed_tasks_count?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    time_around?: boolean
    package_id?: boolean
    time_around_days?: boolean
    organisation_id?: boolean
    daily_target_links?: boolean
  }

  export type ProjectOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "domain_name" | "domain_url" | "category_id" | "created_by_id" | "total_tasks_count" | "completed_tasks_count" | "created_at" | "updated_at" | "deleted_at" | "time_around" | "package_id" | "time_around_days" | "organisation_id" | "daily_target_links", ExtArgs["result"]["project"]>
  export type ProjectInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    category?: boolean | ProjectCategoryDefaultArgs<ExtArgs>
    created_by?: boolean | UserDefaultArgs<ExtArgs>
    backlinks?: boolean | Project$backlinksArgs<ExtArgs>
    ProjectMember?: boolean | Project$ProjectMemberArgs<ExtArgs>
    ProjectDetails?: boolean | Project$ProjectDetailsArgs<ExtArgs>
    TempLinks?: boolean | Project$TempLinksArgs<ExtArgs>
    SeoProjectDetails?: boolean | Project$SeoProjectDetailsArgs<ExtArgs>
    UserJobs?: boolean | Project$UserJobsArgs<ExtArgs>
    ProjectGuideLines?: boolean | Project$ProjectGuideLinesArgs<ExtArgs>
    OrganisationProject?: boolean | UserDefaultArgs<ExtArgs>
    ProjectPackage?: boolean | seo_packagesDefaultArgs<ExtArgs>
    _count?: boolean | ProjectCountOutputTypeDefaultArgs<ExtArgs>
  }
  export type ProjectIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    category?: boolean | ProjectCategoryDefaultArgs<ExtArgs>
    created_by?: boolean | UserDefaultArgs<ExtArgs>
    OrganisationProject?: boolean | UserDefaultArgs<ExtArgs>
    ProjectPackage?: boolean | seo_packagesDefaultArgs<ExtArgs>
  }
  export type ProjectIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    category?: boolean | ProjectCategoryDefaultArgs<ExtArgs>
    created_by?: boolean | UserDefaultArgs<ExtArgs>
    OrganisationProject?: boolean | UserDefaultArgs<ExtArgs>
    ProjectPackage?: boolean | seo_packagesDefaultArgs<ExtArgs>
  }

  export type $ProjectPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Project"
    objects: {
      category: Prisma.$ProjectCategoryPayload<ExtArgs>
      created_by: Prisma.$UserPayload<ExtArgs>
      backlinks: Prisma.$BacklinkPayload<ExtArgs>[]
      ProjectMember: Prisma.$ProjectUserPayload<ExtArgs>[]
      ProjectDetails: Prisma.$ProjectDetailsPayload<ExtArgs>[]
      TempLinks: Prisma.$TempLinksPayload<ExtArgs>[]
      SeoProjectDetails: Prisma.$ProjectDetailsPayload<ExtArgs>[]
      UserJobs: Prisma.$UserJobsPayload<ExtArgs>[]
      ProjectGuideLines: Prisma.$ProjectGuideLinesPayload<ExtArgs>[]
      OrganisationProject: Prisma.$UserPayload<ExtArgs>
      ProjectPackage: Prisma.$seo_packagesPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      domain_name: string
      domain_url: string
      category_id: number
      created_by_id: number
      total_tasks_count: number | null
      completed_tasks_count: number | null
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
      time_around: Date | null
      package_id: number
      time_around_days: number
      organisation_id: number
      daily_target_links: number
    }, ExtArgs["result"]["project"]>
    composites: {}
  }

  type ProjectGetPayload<S extends boolean | null | undefined | ProjectDefaultArgs> = $Result.GetResult<Prisma.$ProjectPayload, S>

  type ProjectCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<ProjectFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: ProjectCountAggregateInputType | true
    }

  export interface ProjectDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Project'], meta: { name: 'Project' } }
    /**
     * Find zero or one Project that matches the filter.
     * @param {ProjectFindUniqueArgs} args - Arguments to find a Project
     * @example
     * // Get one Project
     * const project = await prisma.project.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ProjectFindUniqueArgs>(args: SelectSubset<T, ProjectFindUniqueArgs<ExtArgs>>): Prisma__ProjectClient<$Result.GetResult<Prisma.$ProjectPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Project that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {ProjectFindUniqueOrThrowArgs} args - Arguments to find a Project
     * @example
     * // Get one Project
     * const project = await prisma.project.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ProjectFindUniqueOrThrowArgs>(args: SelectSubset<T, ProjectFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ProjectClient<$Result.GetResult<Prisma.$ProjectPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Project that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectFindFirstArgs} args - Arguments to find a Project
     * @example
     * // Get one Project
     * const project = await prisma.project.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ProjectFindFirstArgs>(args?: SelectSubset<T, ProjectFindFirstArgs<ExtArgs>>): Prisma__ProjectClient<$Result.GetResult<Prisma.$ProjectPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Project that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectFindFirstOrThrowArgs} args - Arguments to find a Project
     * @example
     * // Get one Project
     * const project = await prisma.project.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ProjectFindFirstOrThrowArgs>(args?: SelectSubset<T, ProjectFindFirstOrThrowArgs<ExtArgs>>): Prisma__ProjectClient<$Result.GetResult<Prisma.$ProjectPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Projects that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Projects
     * const projects = await prisma.project.findMany()
     * 
     * // Get first 10 Projects
     * const projects = await prisma.project.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const projectWithIdOnly = await prisma.project.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ProjectFindManyArgs>(args?: SelectSubset<T, ProjectFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Project.
     * @param {ProjectCreateArgs} args - Arguments to create a Project.
     * @example
     * // Create one Project
     * const Project = await prisma.project.create({
     *   data: {
     *     // ... data to create a Project
     *   }
     * })
     * 
     */
    create<T extends ProjectCreateArgs>(args: SelectSubset<T, ProjectCreateArgs<ExtArgs>>): Prisma__ProjectClient<$Result.GetResult<Prisma.$ProjectPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Projects.
     * @param {ProjectCreateManyArgs} args - Arguments to create many Projects.
     * @example
     * // Create many Projects
     * const project = await prisma.project.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ProjectCreateManyArgs>(args?: SelectSubset<T, ProjectCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Projects and returns the data saved in the database.
     * @param {ProjectCreateManyAndReturnArgs} args - Arguments to create many Projects.
     * @example
     * // Create many Projects
     * const project = await prisma.project.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Projects and only return the `id`
     * const projectWithIdOnly = await prisma.project.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends ProjectCreateManyAndReturnArgs>(args?: SelectSubset<T, ProjectCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a Project.
     * @param {ProjectDeleteArgs} args - Arguments to delete one Project.
     * @example
     * // Delete one Project
     * const Project = await prisma.project.delete({
     *   where: {
     *     // ... filter to delete one Project
     *   }
     * })
     * 
     */
    delete<T extends ProjectDeleteArgs>(args: SelectSubset<T, ProjectDeleteArgs<ExtArgs>>): Prisma__ProjectClient<$Result.GetResult<Prisma.$ProjectPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Project.
     * @param {ProjectUpdateArgs} args - Arguments to update one Project.
     * @example
     * // Update one Project
     * const project = await prisma.project.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ProjectUpdateArgs>(args: SelectSubset<T, ProjectUpdateArgs<ExtArgs>>): Prisma__ProjectClient<$Result.GetResult<Prisma.$ProjectPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Projects.
     * @param {ProjectDeleteManyArgs} args - Arguments to filter Projects to delete.
     * @example
     * // Delete a few Projects
     * const { count } = await prisma.project.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ProjectDeleteManyArgs>(args?: SelectSubset<T, ProjectDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Projects.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Projects
     * const project = await prisma.project.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ProjectUpdateManyArgs>(args: SelectSubset<T, ProjectUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Projects and returns the data updated in the database.
     * @param {ProjectUpdateManyAndReturnArgs} args - Arguments to update many Projects.
     * @example
     * // Update many Projects
     * const project = await prisma.project.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Projects and only return the `id`
     * const projectWithIdOnly = await prisma.project.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends ProjectUpdateManyAndReturnArgs>(args: SelectSubset<T, ProjectUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one Project.
     * @param {ProjectUpsertArgs} args - Arguments to update or create a Project.
     * @example
     * // Update or create a Project
     * const project = await prisma.project.upsert({
     *   create: {
     *     // ... data to create a Project
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Project we want to update
     *   }
     * })
     */
    upsert<T extends ProjectUpsertArgs>(args: SelectSubset<T, ProjectUpsertArgs<ExtArgs>>): Prisma__ProjectClient<$Result.GetResult<Prisma.$ProjectPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of Projects.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectCountArgs} args - Arguments to filter Projects to count.
     * @example
     * // Count the number of Projects
     * const count = await prisma.project.count({
     *   where: {
     *     // ... the filter for the Projects we want to count
     *   }
     * })
    **/
    count<T extends ProjectCountArgs>(
      args?: Subset<T, ProjectCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ProjectCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Project.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ProjectAggregateArgs>(args: Subset<T, ProjectAggregateArgs>): Prisma.PrismaPromise<GetProjectAggregateType<T>>

    /**
     * Group by Project.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ProjectGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ProjectGroupByArgs['orderBy'] }
        : { orderBy?: ProjectGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ProjectGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetProjectGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Project model
   */
  readonly fields: ProjectFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Project.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ProjectClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    category<T extends ProjectCategoryDefaultArgs<ExtArgs> = {}>(args?: Subset<T, ProjectCategoryDefaultArgs<ExtArgs>>): Prisma__ProjectCategoryClient<$Result.GetResult<Prisma.$ProjectCategoryPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    created_by<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    backlinks<T extends Project$backlinksArgs<ExtArgs> = {}>(args?: Subset<T, Project$backlinksArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    ProjectMember<T extends Project$ProjectMemberArgs<ExtArgs> = {}>(args?: Subset<T, Project$ProjectMemberArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectUserPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    ProjectDetails<T extends Project$ProjectDetailsArgs<ExtArgs> = {}>(args?: Subset<T, Project$ProjectDetailsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectDetailsPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    TempLinks<T extends Project$TempLinksArgs<ExtArgs> = {}>(args?: Subset<T, Project$TempLinksArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TempLinksPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    SeoProjectDetails<T extends Project$SeoProjectDetailsArgs<ExtArgs> = {}>(args?: Subset<T, Project$SeoProjectDetailsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectDetailsPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    UserJobs<T extends Project$UserJobsArgs<ExtArgs> = {}>(args?: Subset<T, Project$UserJobsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserJobsPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    ProjectGuideLines<T extends Project$ProjectGuideLinesArgs<ExtArgs> = {}>(args?: Subset<T, Project$ProjectGuideLinesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectGuideLinesPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    OrganisationProject<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    ProjectPackage<T extends seo_packagesDefaultArgs<ExtArgs> = {}>(args?: Subset<T, seo_packagesDefaultArgs<ExtArgs>>): Prisma__seo_packagesClient<$Result.GetResult<Prisma.$seo_packagesPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Project model
   */ 
  interface ProjectFieldRefs {
    readonly id: FieldRef<"Project", 'Int'>
    readonly domain_name: FieldRef<"Project", 'String'>
    readonly domain_url: FieldRef<"Project", 'String'>
    readonly category_id: FieldRef<"Project", 'Int'>
    readonly created_by_id: FieldRef<"Project", 'Int'>
    readonly total_tasks_count: FieldRef<"Project", 'Int'>
    readonly completed_tasks_count: FieldRef<"Project", 'Int'>
    readonly created_at: FieldRef<"Project", 'DateTime'>
    readonly updated_at: FieldRef<"Project", 'DateTime'>
    readonly deleted_at: FieldRef<"Project", 'DateTime'>
    readonly time_around: FieldRef<"Project", 'DateTime'>
    readonly package_id: FieldRef<"Project", 'Int'>
    readonly time_around_days: FieldRef<"Project", 'Int'>
    readonly organisation_id: FieldRef<"Project", 'Int'>
    readonly daily_target_links: FieldRef<"Project", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * Project findUnique
   */
  export type ProjectFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Project
     */
    select?: ProjectSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Project
     */
    omit?: ProjectOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectInclude<ExtArgs> | null
    /**
     * Filter, which Project to fetch.
     */
    where: ProjectWhereUniqueInput
  }

  /**
   * Project findUniqueOrThrow
   */
  export type ProjectFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Project
     */
    select?: ProjectSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Project
     */
    omit?: ProjectOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectInclude<ExtArgs> | null
    /**
     * Filter, which Project to fetch.
     */
    where: ProjectWhereUniqueInput
  }

  /**
   * Project findFirst
   */
  export type ProjectFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Project
     */
    select?: ProjectSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Project
     */
    omit?: ProjectOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectInclude<ExtArgs> | null
    /**
     * Filter, which Project to fetch.
     */
    where?: ProjectWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Projects to fetch.
     */
    orderBy?: ProjectOrderByWithRelationInput | ProjectOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Projects.
     */
    cursor?: ProjectWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Projects from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Projects.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Projects.
     */
    distinct?: ProjectScalarFieldEnum | ProjectScalarFieldEnum[]
  }

  /**
   * Project findFirstOrThrow
   */
  export type ProjectFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Project
     */
    select?: ProjectSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Project
     */
    omit?: ProjectOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectInclude<ExtArgs> | null
    /**
     * Filter, which Project to fetch.
     */
    where?: ProjectWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Projects to fetch.
     */
    orderBy?: ProjectOrderByWithRelationInput | ProjectOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Projects.
     */
    cursor?: ProjectWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Projects from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Projects.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Projects.
     */
    distinct?: ProjectScalarFieldEnum | ProjectScalarFieldEnum[]
  }

  /**
   * Project findMany
   */
  export type ProjectFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Project
     */
    select?: ProjectSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Project
     */
    omit?: ProjectOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectInclude<ExtArgs> | null
    /**
     * Filter, which Projects to fetch.
     */
    where?: ProjectWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Projects to fetch.
     */
    orderBy?: ProjectOrderByWithRelationInput | ProjectOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Projects.
     */
    cursor?: ProjectWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Projects from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Projects.
     */
    skip?: number
    distinct?: ProjectScalarFieldEnum | ProjectScalarFieldEnum[]
  }

  /**
   * Project create
   */
  export type ProjectCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Project
     */
    select?: ProjectSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Project
     */
    omit?: ProjectOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectInclude<ExtArgs> | null
    /**
     * The data needed to create a Project.
     */
    data: XOR<ProjectCreateInput, ProjectUncheckedCreateInput>
  }

  /**
   * Project createMany
   */
  export type ProjectCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Projects.
     */
    data: ProjectCreateManyInput | ProjectCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Project createManyAndReturn
   */
  export type ProjectCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Project
     */
    select?: ProjectSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Project
     */
    omit?: ProjectOmit<ExtArgs> | null
    /**
     * The data used to create many Projects.
     */
    data: ProjectCreateManyInput | ProjectCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * Project update
   */
  export type ProjectUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Project
     */
    select?: ProjectSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Project
     */
    omit?: ProjectOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectInclude<ExtArgs> | null
    /**
     * The data needed to update a Project.
     */
    data: XOR<ProjectUpdateInput, ProjectUncheckedUpdateInput>
    /**
     * Choose, which Project to update.
     */
    where: ProjectWhereUniqueInput
  }

  /**
   * Project updateMany
   */
  export type ProjectUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Projects.
     */
    data: XOR<ProjectUpdateManyMutationInput, ProjectUncheckedUpdateManyInput>
    /**
     * Filter which Projects to update
     */
    where?: ProjectWhereInput
    /**
     * Limit how many Projects to update.
     */
    limit?: number
  }

  /**
   * Project updateManyAndReturn
   */
  export type ProjectUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Project
     */
    select?: ProjectSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Project
     */
    omit?: ProjectOmit<ExtArgs> | null
    /**
     * The data used to update Projects.
     */
    data: XOR<ProjectUpdateManyMutationInput, ProjectUncheckedUpdateManyInput>
    /**
     * Filter which Projects to update
     */
    where?: ProjectWhereInput
    /**
     * Limit how many Projects to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * Project upsert
   */
  export type ProjectUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Project
     */
    select?: ProjectSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Project
     */
    omit?: ProjectOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectInclude<ExtArgs> | null
    /**
     * The filter to search for the Project to update in case it exists.
     */
    where: ProjectWhereUniqueInput
    /**
     * In case the Project found by the `where` argument doesn't exist, create a new Project with this data.
     */
    create: XOR<ProjectCreateInput, ProjectUncheckedCreateInput>
    /**
     * In case the Project was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ProjectUpdateInput, ProjectUncheckedUpdateInput>
  }

  /**
   * Project delete
   */
  export type ProjectDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Project
     */
    select?: ProjectSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Project
     */
    omit?: ProjectOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectInclude<ExtArgs> | null
    /**
     * Filter which Project to delete.
     */
    where: ProjectWhereUniqueInput
  }

  /**
   * Project deleteMany
   */
  export type ProjectDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Projects to delete
     */
    where?: ProjectWhereInput
    /**
     * Limit how many Projects to delete.
     */
    limit?: number
  }

  /**
   * Project.backlinks
   */
  export type Project$backlinksArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    where?: BacklinkWhereInput
    orderBy?: BacklinkOrderByWithRelationInput | BacklinkOrderByWithRelationInput[]
    cursor?: BacklinkWhereUniqueInput
    take?: number
    skip?: number
    distinct?: BacklinkScalarFieldEnum | BacklinkScalarFieldEnum[]
  }

  /**
   * Project.ProjectMember
   */
  export type Project$ProjectMemberArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectUser
     */
    select?: ProjectUserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectUser
     */
    omit?: ProjectUserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectUserInclude<ExtArgs> | null
    where?: ProjectUserWhereInput
    orderBy?: ProjectUserOrderByWithRelationInput | ProjectUserOrderByWithRelationInput[]
    cursor?: ProjectUserWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ProjectUserScalarFieldEnum | ProjectUserScalarFieldEnum[]
  }

  /**
   * Project.ProjectDetails
   */
  export type Project$ProjectDetailsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectDetails
     */
    select?: ProjectDetailsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectDetails
     */
    omit?: ProjectDetailsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectDetailsInclude<ExtArgs> | null
    where?: ProjectDetailsWhereInput
    orderBy?: ProjectDetailsOrderByWithRelationInput | ProjectDetailsOrderByWithRelationInput[]
    cursor?: ProjectDetailsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ProjectDetailsScalarFieldEnum | ProjectDetailsScalarFieldEnum[]
  }

  /**
   * Project.TempLinks
   */
  export type Project$TempLinksArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TempLinks
     */
    select?: TempLinksSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TempLinks
     */
    omit?: TempLinksOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TempLinksInclude<ExtArgs> | null
    where?: TempLinksWhereInput
    orderBy?: TempLinksOrderByWithRelationInput | TempLinksOrderByWithRelationInput[]
    cursor?: TempLinksWhereUniqueInput
    take?: number
    skip?: number
    distinct?: TempLinksScalarFieldEnum | TempLinksScalarFieldEnum[]
  }

  /**
   * Project.SeoProjectDetails
   */
  export type Project$SeoProjectDetailsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectDetails
     */
    select?: ProjectDetailsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectDetails
     */
    omit?: ProjectDetailsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectDetailsInclude<ExtArgs> | null
    where?: ProjectDetailsWhereInput
    orderBy?: ProjectDetailsOrderByWithRelationInput | ProjectDetailsOrderByWithRelationInput[]
    cursor?: ProjectDetailsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ProjectDetailsScalarFieldEnum | ProjectDetailsScalarFieldEnum[]
  }

  /**
   * Project.UserJobs
   */
  export type Project$UserJobsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserJobs
     */
    select?: UserJobsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserJobs
     */
    omit?: UserJobsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserJobsInclude<ExtArgs> | null
    where?: UserJobsWhereInput
    orderBy?: UserJobsOrderByWithRelationInput | UserJobsOrderByWithRelationInput[]
    cursor?: UserJobsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserJobsScalarFieldEnum | UserJobsScalarFieldEnum[]
  }

  /**
   * Project.ProjectGuideLines
   */
  export type Project$ProjectGuideLinesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectGuideLines
     */
    select?: ProjectGuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectGuideLines
     */
    omit?: ProjectGuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectGuideLinesInclude<ExtArgs> | null
    where?: ProjectGuideLinesWhereInput
    orderBy?: ProjectGuideLinesOrderByWithRelationInput | ProjectGuideLinesOrderByWithRelationInput[]
    cursor?: ProjectGuideLinesWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ProjectGuideLinesScalarFieldEnum | ProjectGuideLinesScalarFieldEnum[]
  }

  /**
   * Project without action
   */
  export type ProjectDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Project
     */
    select?: ProjectSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Project
     */
    omit?: ProjectOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectInclude<ExtArgs> | null
  }


  /**
   * Model ProjectUser
   */

  export type AggregateProjectUser = {
    _count: ProjectUserCountAggregateOutputType | null
    _avg: ProjectUserAvgAggregateOutputType | null
    _sum: ProjectUserSumAggregateOutputType | null
    _min: ProjectUserMinAggregateOutputType | null
    _max: ProjectUserMaxAggregateOutputType | null
  }

  export type ProjectUserAvgAggregateOutputType = {
    id: number | null
    assign_by: number | null
    assign_to: number | null
    project_id: number | null
  }

  export type ProjectUserSumAggregateOutputType = {
    id: number | null
    assign_by: number | null
    assign_to: number | null
    project_id: number | null
  }

  export type ProjectUserMinAggregateOutputType = {
    id: number | null
    assign_by: number | null
    assign_to: number | null
    project_id: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    status: boolean | null
  }

  export type ProjectUserMaxAggregateOutputType = {
    id: number | null
    assign_by: number | null
    assign_to: number | null
    project_id: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    status: boolean | null
  }

  export type ProjectUserCountAggregateOutputType = {
    id: number
    assign_by: number
    assign_to: number
    project_id: number
    created_at: number
    updated_at: number
    deleted_at: number
    status: number
    _all: number
  }


  export type ProjectUserAvgAggregateInputType = {
    id?: true
    assign_by?: true
    assign_to?: true
    project_id?: true
  }

  export type ProjectUserSumAggregateInputType = {
    id?: true
    assign_by?: true
    assign_to?: true
    project_id?: true
  }

  export type ProjectUserMinAggregateInputType = {
    id?: true
    assign_by?: true
    assign_to?: true
    project_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    status?: true
  }

  export type ProjectUserMaxAggregateInputType = {
    id?: true
    assign_by?: true
    assign_to?: true
    project_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    status?: true
  }

  export type ProjectUserCountAggregateInputType = {
    id?: true
    assign_by?: true
    assign_to?: true
    project_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    status?: true
    _all?: true
  }

  export type ProjectUserAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ProjectUser to aggregate.
     */
    where?: ProjectUserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProjectUsers to fetch.
     */
    orderBy?: ProjectUserOrderByWithRelationInput | ProjectUserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ProjectUserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProjectUsers from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProjectUsers.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ProjectUsers
    **/
    _count?: true | ProjectUserCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ProjectUserAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ProjectUserSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ProjectUserMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ProjectUserMaxAggregateInputType
  }

  export type GetProjectUserAggregateType<T extends ProjectUserAggregateArgs> = {
        [P in keyof T & keyof AggregateProjectUser]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateProjectUser[P]>
      : GetScalarType<T[P], AggregateProjectUser[P]>
  }




  export type ProjectUserGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProjectUserWhereInput
    orderBy?: ProjectUserOrderByWithAggregationInput | ProjectUserOrderByWithAggregationInput[]
    by: ProjectUserScalarFieldEnum[] | ProjectUserScalarFieldEnum
    having?: ProjectUserScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ProjectUserCountAggregateInputType | true
    _avg?: ProjectUserAvgAggregateInputType
    _sum?: ProjectUserSumAggregateInputType
    _min?: ProjectUserMinAggregateInputType
    _max?: ProjectUserMaxAggregateInputType
  }

  export type ProjectUserGroupByOutputType = {
    id: number
    assign_by: number
    assign_to: number
    project_id: number
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    status: boolean
    _count: ProjectUserCountAggregateOutputType | null
    _avg: ProjectUserAvgAggregateOutputType | null
    _sum: ProjectUserSumAggregateOutputType | null
    _min: ProjectUserMinAggregateOutputType | null
    _max: ProjectUserMaxAggregateOutputType | null
  }

  type GetProjectUserGroupByPayload<T extends ProjectUserGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ProjectUserGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ProjectUserGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ProjectUserGroupByOutputType[P]>
            : GetScalarType<T[P], ProjectUserGroupByOutputType[P]>
        }
      >
    >


  export type ProjectUserSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    assign_by?: boolean
    assign_to?: boolean
    project_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    status?: boolean
    assignBY?: boolean | UserDefaultArgs<ExtArgs>
    assignTo?: boolean | UserDefaultArgs<ExtArgs>
    userProjects?: boolean | ProjectDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["projectUser"]>

  export type ProjectUserSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    assign_by?: boolean
    assign_to?: boolean
    project_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    status?: boolean
    assignBY?: boolean | UserDefaultArgs<ExtArgs>
    assignTo?: boolean | UserDefaultArgs<ExtArgs>
    userProjects?: boolean | ProjectDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["projectUser"]>

  export type ProjectUserSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    assign_by?: boolean
    assign_to?: boolean
    project_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    status?: boolean
    assignBY?: boolean | UserDefaultArgs<ExtArgs>
    assignTo?: boolean | UserDefaultArgs<ExtArgs>
    userProjects?: boolean | ProjectDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["projectUser"]>

  export type ProjectUserSelectScalar = {
    id?: boolean
    assign_by?: boolean
    assign_to?: boolean
    project_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    status?: boolean
  }

  export type ProjectUserOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "assign_by" | "assign_to" | "project_id" | "created_at" | "updated_at" | "deleted_at" | "status", ExtArgs["result"]["projectUser"]>
  export type ProjectUserInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    assignBY?: boolean | UserDefaultArgs<ExtArgs>
    assignTo?: boolean | UserDefaultArgs<ExtArgs>
    userProjects?: boolean | ProjectDefaultArgs<ExtArgs>
  }
  export type ProjectUserIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    assignBY?: boolean | UserDefaultArgs<ExtArgs>
    assignTo?: boolean | UserDefaultArgs<ExtArgs>
    userProjects?: boolean | ProjectDefaultArgs<ExtArgs>
  }
  export type ProjectUserIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    assignBY?: boolean | UserDefaultArgs<ExtArgs>
    assignTo?: boolean | UserDefaultArgs<ExtArgs>
    userProjects?: boolean | ProjectDefaultArgs<ExtArgs>
  }

  export type $ProjectUserPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "ProjectUser"
    objects: {
      assignBY: Prisma.$UserPayload<ExtArgs>
      assignTo: Prisma.$UserPayload<ExtArgs>
      userProjects: Prisma.$ProjectPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      assign_by: number
      assign_to: number
      project_id: number
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
      status: boolean
    }, ExtArgs["result"]["projectUser"]>
    composites: {}
  }

  type ProjectUserGetPayload<S extends boolean | null | undefined | ProjectUserDefaultArgs> = $Result.GetResult<Prisma.$ProjectUserPayload, S>

  type ProjectUserCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<ProjectUserFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: ProjectUserCountAggregateInputType | true
    }

  export interface ProjectUserDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['ProjectUser'], meta: { name: 'ProjectUser' } }
    /**
     * Find zero or one ProjectUser that matches the filter.
     * @param {ProjectUserFindUniqueArgs} args - Arguments to find a ProjectUser
     * @example
     * // Get one ProjectUser
     * const projectUser = await prisma.projectUser.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ProjectUserFindUniqueArgs>(args: SelectSubset<T, ProjectUserFindUniqueArgs<ExtArgs>>): Prisma__ProjectUserClient<$Result.GetResult<Prisma.$ProjectUserPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one ProjectUser that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {ProjectUserFindUniqueOrThrowArgs} args - Arguments to find a ProjectUser
     * @example
     * // Get one ProjectUser
     * const projectUser = await prisma.projectUser.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ProjectUserFindUniqueOrThrowArgs>(args: SelectSubset<T, ProjectUserFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ProjectUserClient<$Result.GetResult<Prisma.$ProjectUserPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first ProjectUser that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectUserFindFirstArgs} args - Arguments to find a ProjectUser
     * @example
     * // Get one ProjectUser
     * const projectUser = await prisma.projectUser.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ProjectUserFindFirstArgs>(args?: SelectSubset<T, ProjectUserFindFirstArgs<ExtArgs>>): Prisma__ProjectUserClient<$Result.GetResult<Prisma.$ProjectUserPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first ProjectUser that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectUserFindFirstOrThrowArgs} args - Arguments to find a ProjectUser
     * @example
     * // Get one ProjectUser
     * const projectUser = await prisma.projectUser.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ProjectUserFindFirstOrThrowArgs>(args?: SelectSubset<T, ProjectUserFindFirstOrThrowArgs<ExtArgs>>): Prisma__ProjectUserClient<$Result.GetResult<Prisma.$ProjectUserPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more ProjectUsers that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectUserFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all ProjectUsers
     * const projectUsers = await prisma.projectUser.findMany()
     * 
     * // Get first 10 ProjectUsers
     * const projectUsers = await prisma.projectUser.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const projectUserWithIdOnly = await prisma.projectUser.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ProjectUserFindManyArgs>(args?: SelectSubset<T, ProjectUserFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectUserPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a ProjectUser.
     * @param {ProjectUserCreateArgs} args - Arguments to create a ProjectUser.
     * @example
     * // Create one ProjectUser
     * const ProjectUser = await prisma.projectUser.create({
     *   data: {
     *     // ... data to create a ProjectUser
     *   }
     * })
     * 
     */
    create<T extends ProjectUserCreateArgs>(args: SelectSubset<T, ProjectUserCreateArgs<ExtArgs>>): Prisma__ProjectUserClient<$Result.GetResult<Prisma.$ProjectUserPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many ProjectUsers.
     * @param {ProjectUserCreateManyArgs} args - Arguments to create many ProjectUsers.
     * @example
     * // Create many ProjectUsers
     * const projectUser = await prisma.projectUser.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ProjectUserCreateManyArgs>(args?: SelectSubset<T, ProjectUserCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many ProjectUsers and returns the data saved in the database.
     * @param {ProjectUserCreateManyAndReturnArgs} args - Arguments to create many ProjectUsers.
     * @example
     * // Create many ProjectUsers
     * const projectUser = await prisma.projectUser.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many ProjectUsers and only return the `id`
     * const projectUserWithIdOnly = await prisma.projectUser.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends ProjectUserCreateManyAndReturnArgs>(args?: SelectSubset<T, ProjectUserCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectUserPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a ProjectUser.
     * @param {ProjectUserDeleteArgs} args - Arguments to delete one ProjectUser.
     * @example
     * // Delete one ProjectUser
     * const ProjectUser = await prisma.projectUser.delete({
     *   where: {
     *     // ... filter to delete one ProjectUser
     *   }
     * })
     * 
     */
    delete<T extends ProjectUserDeleteArgs>(args: SelectSubset<T, ProjectUserDeleteArgs<ExtArgs>>): Prisma__ProjectUserClient<$Result.GetResult<Prisma.$ProjectUserPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one ProjectUser.
     * @param {ProjectUserUpdateArgs} args - Arguments to update one ProjectUser.
     * @example
     * // Update one ProjectUser
     * const projectUser = await prisma.projectUser.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ProjectUserUpdateArgs>(args: SelectSubset<T, ProjectUserUpdateArgs<ExtArgs>>): Prisma__ProjectUserClient<$Result.GetResult<Prisma.$ProjectUserPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more ProjectUsers.
     * @param {ProjectUserDeleteManyArgs} args - Arguments to filter ProjectUsers to delete.
     * @example
     * // Delete a few ProjectUsers
     * const { count } = await prisma.projectUser.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ProjectUserDeleteManyArgs>(args?: SelectSubset<T, ProjectUserDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ProjectUsers.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectUserUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many ProjectUsers
     * const projectUser = await prisma.projectUser.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ProjectUserUpdateManyArgs>(args: SelectSubset<T, ProjectUserUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ProjectUsers and returns the data updated in the database.
     * @param {ProjectUserUpdateManyAndReturnArgs} args - Arguments to update many ProjectUsers.
     * @example
     * // Update many ProjectUsers
     * const projectUser = await prisma.projectUser.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more ProjectUsers and only return the `id`
     * const projectUserWithIdOnly = await prisma.projectUser.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends ProjectUserUpdateManyAndReturnArgs>(args: SelectSubset<T, ProjectUserUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectUserPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one ProjectUser.
     * @param {ProjectUserUpsertArgs} args - Arguments to update or create a ProjectUser.
     * @example
     * // Update or create a ProjectUser
     * const projectUser = await prisma.projectUser.upsert({
     *   create: {
     *     // ... data to create a ProjectUser
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the ProjectUser we want to update
     *   }
     * })
     */
    upsert<T extends ProjectUserUpsertArgs>(args: SelectSubset<T, ProjectUserUpsertArgs<ExtArgs>>): Prisma__ProjectUserClient<$Result.GetResult<Prisma.$ProjectUserPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of ProjectUsers.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectUserCountArgs} args - Arguments to filter ProjectUsers to count.
     * @example
     * // Count the number of ProjectUsers
     * const count = await prisma.projectUser.count({
     *   where: {
     *     // ... the filter for the ProjectUsers we want to count
     *   }
     * })
    **/
    count<T extends ProjectUserCountArgs>(
      args?: Subset<T, ProjectUserCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ProjectUserCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a ProjectUser.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectUserAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ProjectUserAggregateArgs>(args: Subset<T, ProjectUserAggregateArgs>): Prisma.PrismaPromise<GetProjectUserAggregateType<T>>

    /**
     * Group by ProjectUser.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectUserGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ProjectUserGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ProjectUserGroupByArgs['orderBy'] }
        : { orderBy?: ProjectUserGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ProjectUserGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetProjectUserGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the ProjectUser model
   */
  readonly fields: ProjectUserFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for ProjectUser.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ProjectUserClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    assignBY<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    assignTo<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    userProjects<T extends ProjectDefaultArgs<ExtArgs> = {}>(args?: Subset<T, ProjectDefaultArgs<ExtArgs>>): Prisma__ProjectClient<$Result.GetResult<Prisma.$ProjectPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the ProjectUser model
   */ 
  interface ProjectUserFieldRefs {
    readonly id: FieldRef<"ProjectUser", 'Int'>
    readonly assign_by: FieldRef<"ProjectUser", 'Int'>
    readonly assign_to: FieldRef<"ProjectUser", 'Int'>
    readonly project_id: FieldRef<"ProjectUser", 'Int'>
    readonly created_at: FieldRef<"ProjectUser", 'DateTime'>
    readonly updated_at: FieldRef<"ProjectUser", 'DateTime'>
    readonly deleted_at: FieldRef<"ProjectUser", 'DateTime'>
    readonly status: FieldRef<"ProjectUser", 'Boolean'>
  }
    

  // Custom InputTypes
  /**
   * ProjectUser findUnique
   */
  export type ProjectUserFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectUser
     */
    select?: ProjectUserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectUser
     */
    omit?: ProjectUserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectUserInclude<ExtArgs> | null
    /**
     * Filter, which ProjectUser to fetch.
     */
    where: ProjectUserWhereUniqueInput
  }

  /**
   * ProjectUser findUniqueOrThrow
   */
  export type ProjectUserFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectUser
     */
    select?: ProjectUserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectUser
     */
    omit?: ProjectUserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectUserInclude<ExtArgs> | null
    /**
     * Filter, which ProjectUser to fetch.
     */
    where: ProjectUserWhereUniqueInput
  }

  /**
   * ProjectUser findFirst
   */
  export type ProjectUserFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectUser
     */
    select?: ProjectUserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectUser
     */
    omit?: ProjectUserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectUserInclude<ExtArgs> | null
    /**
     * Filter, which ProjectUser to fetch.
     */
    where?: ProjectUserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProjectUsers to fetch.
     */
    orderBy?: ProjectUserOrderByWithRelationInput | ProjectUserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ProjectUsers.
     */
    cursor?: ProjectUserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProjectUsers from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProjectUsers.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ProjectUsers.
     */
    distinct?: ProjectUserScalarFieldEnum | ProjectUserScalarFieldEnum[]
  }

  /**
   * ProjectUser findFirstOrThrow
   */
  export type ProjectUserFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectUser
     */
    select?: ProjectUserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectUser
     */
    omit?: ProjectUserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectUserInclude<ExtArgs> | null
    /**
     * Filter, which ProjectUser to fetch.
     */
    where?: ProjectUserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProjectUsers to fetch.
     */
    orderBy?: ProjectUserOrderByWithRelationInput | ProjectUserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ProjectUsers.
     */
    cursor?: ProjectUserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProjectUsers from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProjectUsers.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ProjectUsers.
     */
    distinct?: ProjectUserScalarFieldEnum | ProjectUserScalarFieldEnum[]
  }

  /**
   * ProjectUser findMany
   */
  export type ProjectUserFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectUser
     */
    select?: ProjectUserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectUser
     */
    omit?: ProjectUserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectUserInclude<ExtArgs> | null
    /**
     * Filter, which ProjectUsers to fetch.
     */
    where?: ProjectUserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProjectUsers to fetch.
     */
    orderBy?: ProjectUserOrderByWithRelationInput | ProjectUserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing ProjectUsers.
     */
    cursor?: ProjectUserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProjectUsers from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProjectUsers.
     */
    skip?: number
    distinct?: ProjectUserScalarFieldEnum | ProjectUserScalarFieldEnum[]
  }

  /**
   * ProjectUser create
   */
  export type ProjectUserCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectUser
     */
    select?: ProjectUserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectUser
     */
    omit?: ProjectUserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectUserInclude<ExtArgs> | null
    /**
     * The data needed to create a ProjectUser.
     */
    data: XOR<ProjectUserCreateInput, ProjectUserUncheckedCreateInput>
  }

  /**
   * ProjectUser createMany
   */
  export type ProjectUserCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many ProjectUsers.
     */
    data: ProjectUserCreateManyInput | ProjectUserCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * ProjectUser createManyAndReturn
   */
  export type ProjectUserCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectUser
     */
    select?: ProjectUserSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectUser
     */
    omit?: ProjectUserOmit<ExtArgs> | null
    /**
     * The data used to create many ProjectUsers.
     */
    data: ProjectUserCreateManyInput | ProjectUserCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectUserIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * ProjectUser update
   */
  export type ProjectUserUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectUser
     */
    select?: ProjectUserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectUser
     */
    omit?: ProjectUserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectUserInclude<ExtArgs> | null
    /**
     * The data needed to update a ProjectUser.
     */
    data: XOR<ProjectUserUpdateInput, ProjectUserUncheckedUpdateInput>
    /**
     * Choose, which ProjectUser to update.
     */
    where: ProjectUserWhereUniqueInput
  }

  /**
   * ProjectUser updateMany
   */
  export type ProjectUserUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update ProjectUsers.
     */
    data: XOR<ProjectUserUpdateManyMutationInput, ProjectUserUncheckedUpdateManyInput>
    /**
     * Filter which ProjectUsers to update
     */
    where?: ProjectUserWhereInput
    /**
     * Limit how many ProjectUsers to update.
     */
    limit?: number
  }

  /**
   * ProjectUser updateManyAndReturn
   */
  export type ProjectUserUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectUser
     */
    select?: ProjectUserSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectUser
     */
    omit?: ProjectUserOmit<ExtArgs> | null
    /**
     * The data used to update ProjectUsers.
     */
    data: XOR<ProjectUserUpdateManyMutationInput, ProjectUserUncheckedUpdateManyInput>
    /**
     * Filter which ProjectUsers to update
     */
    where?: ProjectUserWhereInput
    /**
     * Limit how many ProjectUsers to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectUserIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * ProjectUser upsert
   */
  export type ProjectUserUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectUser
     */
    select?: ProjectUserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectUser
     */
    omit?: ProjectUserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectUserInclude<ExtArgs> | null
    /**
     * The filter to search for the ProjectUser to update in case it exists.
     */
    where: ProjectUserWhereUniqueInput
    /**
     * In case the ProjectUser found by the `where` argument doesn't exist, create a new ProjectUser with this data.
     */
    create: XOR<ProjectUserCreateInput, ProjectUserUncheckedCreateInput>
    /**
     * In case the ProjectUser was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ProjectUserUpdateInput, ProjectUserUncheckedUpdateInput>
  }

  /**
   * ProjectUser delete
   */
  export type ProjectUserDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectUser
     */
    select?: ProjectUserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectUser
     */
    omit?: ProjectUserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectUserInclude<ExtArgs> | null
    /**
     * Filter which ProjectUser to delete.
     */
    where: ProjectUserWhereUniqueInput
  }

  /**
   * ProjectUser deleteMany
   */
  export type ProjectUserDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ProjectUsers to delete
     */
    where?: ProjectUserWhereInput
    /**
     * Limit how many ProjectUsers to delete.
     */
    limit?: number
  }

  /**
   * ProjectUser without action
   */
  export type ProjectUserDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectUser
     */
    select?: ProjectUserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectUser
     */
    omit?: ProjectUserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectUserInclude<ExtArgs> | null
  }


  /**
   * Model Backlink
   */

  export type AggregateBacklink = {
    _count: BacklinkCountAggregateOutputType | null
    _avg: BacklinkAvgAggregateOutputType | null
    _sum: BacklinkSumAggregateOutputType | null
    _min: BacklinkMinAggregateOutputType | null
    _max: BacklinkMaxAggregateOutputType | null
  }

  export type BacklinkAvgAggregateOutputType = {
    id: number | null
    link_status: number | null
    project_id: number | null
    uploaded_by_id: number | null
    managed_by: number | null
    link_category: number | null
    job_id: number | null
    processId: number | null
  }

  export type BacklinkSumAggregateOutputType = {
    id: number | null
    link_status: number | null
    project_id: number | null
    uploaded_by_id: number | null
    managed_by: number | null
    link_category: number | null
    job_id: number | null
    processId: number | null
  }

  export type BacklinkMinAggregateOutputType = {
    id: number | null
    link_url: string | null
    link_status: number | null
    is_index: boolean | null
    link_rel: string | null
    anchor_text: string | null
    targeted_url: string | null
    project_id: number | null
    uploaded_by_id: number | null
    first_seen: Date | null
    last_seen: Date | null
    added_date: Date | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    refer_domain: string | null
    refering_domain: boolean | null
    backlink_duplicate: boolean | null
    managed_by: number | null
    link_category: number | null
    job_id: number | null
    processId: number | null
  }

  export type BacklinkMaxAggregateOutputType = {
    id: number | null
    link_url: string | null
    link_status: number | null
    is_index: boolean | null
    link_rel: string | null
    anchor_text: string | null
    targeted_url: string | null
    project_id: number | null
    uploaded_by_id: number | null
    first_seen: Date | null
    last_seen: Date | null
    added_date: Date | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    refer_domain: string | null
    refering_domain: boolean | null
    backlink_duplicate: boolean | null
    managed_by: number | null
    link_category: number | null
    job_id: number | null
    processId: number | null
  }

  export type BacklinkCountAggregateOutputType = {
    id: number
    link_url: number
    link_status: number
    is_index: number
    link_rel: number
    anchor_text: number
    targeted_url: number
    project_id: number
    uploaded_by_id: number
    first_seen: number
    last_seen: number
    added_date: number
    created_at: number
    updated_at: number
    deleted_at: number
    refer_domain: number
    refering_domain: number
    backlink_duplicate: number
    managed_by: number
    link_category: number
    job_id: number
    processId: number
    _all: number
  }


  export type BacklinkAvgAggregateInputType = {
    id?: true
    link_status?: true
    project_id?: true
    uploaded_by_id?: true
    managed_by?: true
    link_category?: true
    job_id?: true
    processId?: true
  }

  export type BacklinkSumAggregateInputType = {
    id?: true
    link_status?: true
    project_id?: true
    uploaded_by_id?: true
    managed_by?: true
    link_category?: true
    job_id?: true
    processId?: true
  }

  export type BacklinkMinAggregateInputType = {
    id?: true
    link_url?: true
    link_status?: true
    is_index?: true
    link_rel?: true
    anchor_text?: true
    targeted_url?: true
    project_id?: true
    uploaded_by_id?: true
    first_seen?: true
    last_seen?: true
    added_date?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    refer_domain?: true
    refering_domain?: true
    backlink_duplicate?: true
    managed_by?: true
    link_category?: true
    job_id?: true
    processId?: true
  }

  export type BacklinkMaxAggregateInputType = {
    id?: true
    link_url?: true
    link_status?: true
    is_index?: true
    link_rel?: true
    anchor_text?: true
    targeted_url?: true
    project_id?: true
    uploaded_by_id?: true
    first_seen?: true
    last_seen?: true
    added_date?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    refer_domain?: true
    refering_domain?: true
    backlink_duplicate?: true
    managed_by?: true
    link_category?: true
    job_id?: true
    processId?: true
  }

  export type BacklinkCountAggregateInputType = {
    id?: true
    link_url?: true
    link_status?: true
    is_index?: true
    link_rel?: true
    anchor_text?: true
    targeted_url?: true
    project_id?: true
    uploaded_by_id?: true
    first_seen?: true
    last_seen?: true
    added_date?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    refer_domain?: true
    refering_domain?: true
    backlink_duplicate?: true
    managed_by?: true
    link_category?: true
    job_id?: true
    processId?: true
    _all?: true
  }

  export type BacklinkAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Backlink to aggregate.
     */
    where?: BacklinkWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Backlinks to fetch.
     */
    orderBy?: BacklinkOrderByWithRelationInput | BacklinkOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: BacklinkWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Backlinks from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Backlinks.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Backlinks
    **/
    _count?: true | BacklinkCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: BacklinkAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: BacklinkSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: BacklinkMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: BacklinkMaxAggregateInputType
  }

  export type GetBacklinkAggregateType<T extends BacklinkAggregateArgs> = {
        [P in keyof T & keyof AggregateBacklink]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateBacklink[P]>
      : GetScalarType<T[P], AggregateBacklink[P]>
  }




  export type BacklinkGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: BacklinkWhereInput
    orderBy?: BacklinkOrderByWithAggregationInput | BacklinkOrderByWithAggregationInput[]
    by: BacklinkScalarFieldEnum[] | BacklinkScalarFieldEnum
    having?: BacklinkScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: BacklinkCountAggregateInputType | true
    _avg?: BacklinkAvgAggregateInputType
    _sum?: BacklinkSumAggregateInputType
    _min?: BacklinkMinAggregateInputType
    _max?: BacklinkMaxAggregateInputType
  }

  export type BacklinkGroupByOutputType = {
    id: number
    link_url: string
    link_status: number
    is_index: boolean | null
    link_rel: string | null
    anchor_text: string | null
    targeted_url: string | null
    project_id: number
    uploaded_by_id: number
    first_seen: Date | null
    last_seen: Date | null
    added_date: Date | null
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    refer_domain: string
    refering_domain: boolean | null
    backlink_duplicate: boolean | null
    managed_by: number
    link_category: number
    job_id: number
    processId: number | null
    _count: BacklinkCountAggregateOutputType | null
    _avg: BacklinkAvgAggregateOutputType | null
    _sum: BacklinkSumAggregateOutputType | null
    _min: BacklinkMinAggregateOutputType | null
    _max: BacklinkMaxAggregateOutputType | null
  }

  type GetBacklinkGroupByPayload<T extends BacklinkGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<BacklinkGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof BacklinkGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], BacklinkGroupByOutputType[P]>
            : GetScalarType<T[P], BacklinkGroupByOutputType[P]>
        }
      >
    >


  export type BacklinkSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    link_url?: boolean
    link_status?: boolean
    is_index?: boolean
    link_rel?: boolean
    anchor_text?: boolean
    targeted_url?: boolean
    project_id?: boolean
    uploaded_by_id?: boolean
    first_seen?: boolean
    last_seen?: boolean
    added_date?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    refer_domain?: boolean
    refering_domain?: boolean
    backlink_duplicate?: boolean
    managed_by?: boolean
    link_category?: boolean
    job_id?: boolean
    processId?: boolean
    created_by?: boolean | UserDefaultArgs<ExtArgs>
    ManagedBy?: boolean | UserDefaultArgs<ExtArgs>
    project?: boolean | ProjectDefaultArgs<ExtArgs>
    LinksCategories?: boolean | GuideLinesDefaultArgs<ExtArgs>
    jobLinks?: boolean | UserJobsDefaultArgs<ExtArgs>
    Process?: boolean | Backlink$ProcessArgs<ExtArgs>
  }, ExtArgs["result"]["backlink"]>

  export type BacklinkSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    link_url?: boolean
    link_status?: boolean
    is_index?: boolean
    link_rel?: boolean
    anchor_text?: boolean
    targeted_url?: boolean
    project_id?: boolean
    uploaded_by_id?: boolean
    first_seen?: boolean
    last_seen?: boolean
    added_date?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    refer_domain?: boolean
    refering_domain?: boolean
    backlink_duplicate?: boolean
    managed_by?: boolean
    link_category?: boolean
    job_id?: boolean
    processId?: boolean
    created_by?: boolean | UserDefaultArgs<ExtArgs>
    ManagedBy?: boolean | UserDefaultArgs<ExtArgs>
    project?: boolean | ProjectDefaultArgs<ExtArgs>
    LinksCategories?: boolean | GuideLinesDefaultArgs<ExtArgs>
    jobLinks?: boolean | UserJobsDefaultArgs<ExtArgs>
    Process?: boolean | Backlink$ProcessArgs<ExtArgs>
  }, ExtArgs["result"]["backlink"]>

  export type BacklinkSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    link_url?: boolean
    link_status?: boolean
    is_index?: boolean
    link_rel?: boolean
    anchor_text?: boolean
    targeted_url?: boolean
    project_id?: boolean
    uploaded_by_id?: boolean
    first_seen?: boolean
    last_seen?: boolean
    added_date?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    refer_domain?: boolean
    refering_domain?: boolean
    backlink_duplicate?: boolean
    managed_by?: boolean
    link_category?: boolean
    job_id?: boolean
    processId?: boolean
    created_by?: boolean | UserDefaultArgs<ExtArgs>
    ManagedBy?: boolean | UserDefaultArgs<ExtArgs>
    project?: boolean | ProjectDefaultArgs<ExtArgs>
    LinksCategories?: boolean | GuideLinesDefaultArgs<ExtArgs>
    jobLinks?: boolean | UserJobsDefaultArgs<ExtArgs>
    Process?: boolean | Backlink$ProcessArgs<ExtArgs>
  }, ExtArgs["result"]["backlink"]>

  export type BacklinkSelectScalar = {
    id?: boolean
    link_url?: boolean
    link_status?: boolean
    is_index?: boolean
    link_rel?: boolean
    anchor_text?: boolean
    targeted_url?: boolean
    project_id?: boolean
    uploaded_by_id?: boolean
    first_seen?: boolean
    last_seen?: boolean
    added_date?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    refer_domain?: boolean
    refering_domain?: boolean
    backlink_duplicate?: boolean
    managed_by?: boolean
    link_category?: boolean
    job_id?: boolean
    processId?: boolean
  }

  export type BacklinkOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "link_url" | "link_status" | "is_index" | "link_rel" | "anchor_text" | "targeted_url" | "project_id" | "uploaded_by_id" | "first_seen" | "last_seen" | "added_date" | "created_at" | "updated_at" | "deleted_at" | "refer_domain" | "refering_domain" | "backlink_duplicate" | "managed_by" | "link_category" | "job_id" | "processId", ExtArgs["result"]["backlink"]>
  export type BacklinkInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    created_by?: boolean | UserDefaultArgs<ExtArgs>
    ManagedBy?: boolean | UserDefaultArgs<ExtArgs>
    project?: boolean | ProjectDefaultArgs<ExtArgs>
    LinksCategories?: boolean | GuideLinesDefaultArgs<ExtArgs>
    jobLinks?: boolean | UserJobsDefaultArgs<ExtArgs>
    Process?: boolean | Backlink$ProcessArgs<ExtArgs>
  }
  export type BacklinkIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    created_by?: boolean | UserDefaultArgs<ExtArgs>
    ManagedBy?: boolean | UserDefaultArgs<ExtArgs>
    project?: boolean | ProjectDefaultArgs<ExtArgs>
    LinksCategories?: boolean | GuideLinesDefaultArgs<ExtArgs>
    jobLinks?: boolean | UserJobsDefaultArgs<ExtArgs>
    Process?: boolean | Backlink$ProcessArgs<ExtArgs>
  }
  export type BacklinkIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    created_by?: boolean | UserDefaultArgs<ExtArgs>
    ManagedBy?: boolean | UserDefaultArgs<ExtArgs>
    project?: boolean | ProjectDefaultArgs<ExtArgs>
    LinksCategories?: boolean | GuideLinesDefaultArgs<ExtArgs>
    jobLinks?: boolean | UserJobsDefaultArgs<ExtArgs>
    Process?: boolean | Backlink$ProcessArgs<ExtArgs>
  }

  export type $BacklinkPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Backlink"
    objects: {
      created_by: Prisma.$UserPayload<ExtArgs>
      ManagedBy: Prisma.$UserPayload<ExtArgs>
      project: Prisma.$ProjectPayload<ExtArgs>
      LinksCategories: Prisma.$GuideLinesPayload<ExtArgs>
      jobLinks: Prisma.$UserJobsPayload<ExtArgs>
      Process: Prisma.$ProcessPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      link_url: string
      link_status: number
      is_index: boolean | null
      link_rel: string | null
      anchor_text: string | null
      targeted_url: string | null
      project_id: number
      uploaded_by_id: number
      first_seen: Date | null
      last_seen: Date | null
      added_date: Date | null
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
      refer_domain: string
      refering_domain: boolean | null
      backlink_duplicate: boolean | null
      managed_by: number
      link_category: number
      job_id: number
      processId: number | null
    }, ExtArgs["result"]["backlink"]>
    composites: {}
  }

  type BacklinkGetPayload<S extends boolean | null | undefined | BacklinkDefaultArgs> = $Result.GetResult<Prisma.$BacklinkPayload, S>

  type BacklinkCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<BacklinkFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: BacklinkCountAggregateInputType | true
    }

  export interface BacklinkDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Backlink'], meta: { name: 'Backlink' } }
    /**
     * Find zero or one Backlink that matches the filter.
     * @param {BacklinkFindUniqueArgs} args - Arguments to find a Backlink
     * @example
     * // Get one Backlink
     * const backlink = await prisma.backlink.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends BacklinkFindUniqueArgs>(args: SelectSubset<T, BacklinkFindUniqueArgs<ExtArgs>>): Prisma__BacklinkClient<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Backlink that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {BacklinkFindUniqueOrThrowArgs} args - Arguments to find a Backlink
     * @example
     * // Get one Backlink
     * const backlink = await prisma.backlink.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends BacklinkFindUniqueOrThrowArgs>(args: SelectSubset<T, BacklinkFindUniqueOrThrowArgs<ExtArgs>>): Prisma__BacklinkClient<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Backlink that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {BacklinkFindFirstArgs} args - Arguments to find a Backlink
     * @example
     * // Get one Backlink
     * const backlink = await prisma.backlink.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends BacklinkFindFirstArgs>(args?: SelectSubset<T, BacklinkFindFirstArgs<ExtArgs>>): Prisma__BacklinkClient<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Backlink that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {BacklinkFindFirstOrThrowArgs} args - Arguments to find a Backlink
     * @example
     * // Get one Backlink
     * const backlink = await prisma.backlink.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends BacklinkFindFirstOrThrowArgs>(args?: SelectSubset<T, BacklinkFindFirstOrThrowArgs<ExtArgs>>): Prisma__BacklinkClient<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Backlinks that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {BacklinkFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Backlinks
     * const backlinks = await prisma.backlink.findMany()
     * 
     * // Get first 10 Backlinks
     * const backlinks = await prisma.backlink.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const backlinkWithIdOnly = await prisma.backlink.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends BacklinkFindManyArgs>(args?: SelectSubset<T, BacklinkFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Backlink.
     * @param {BacklinkCreateArgs} args - Arguments to create a Backlink.
     * @example
     * // Create one Backlink
     * const Backlink = await prisma.backlink.create({
     *   data: {
     *     // ... data to create a Backlink
     *   }
     * })
     * 
     */
    create<T extends BacklinkCreateArgs>(args: SelectSubset<T, BacklinkCreateArgs<ExtArgs>>): Prisma__BacklinkClient<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Backlinks.
     * @param {BacklinkCreateManyArgs} args - Arguments to create many Backlinks.
     * @example
     * // Create many Backlinks
     * const backlink = await prisma.backlink.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends BacklinkCreateManyArgs>(args?: SelectSubset<T, BacklinkCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Backlinks and returns the data saved in the database.
     * @param {BacklinkCreateManyAndReturnArgs} args - Arguments to create many Backlinks.
     * @example
     * // Create many Backlinks
     * const backlink = await prisma.backlink.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Backlinks and only return the `id`
     * const backlinkWithIdOnly = await prisma.backlink.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends BacklinkCreateManyAndReturnArgs>(args?: SelectSubset<T, BacklinkCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a Backlink.
     * @param {BacklinkDeleteArgs} args - Arguments to delete one Backlink.
     * @example
     * // Delete one Backlink
     * const Backlink = await prisma.backlink.delete({
     *   where: {
     *     // ... filter to delete one Backlink
     *   }
     * })
     * 
     */
    delete<T extends BacklinkDeleteArgs>(args: SelectSubset<T, BacklinkDeleteArgs<ExtArgs>>): Prisma__BacklinkClient<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Backlink.
     * @param {BacklinkUpdateArgs} args - Arguments to update one Backlink.
     * @example
     * // Update one Backlink
     * const backlink = await prisma.backlink.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends BacklinkUpdateArgs>(args: SelectSubset<T, BacklinkUpdateArgs<ExtArgs>>): Prisma__BacklinkClient<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Backlinks.
     * @param {BacklinkDeleteManyArgs} args - Arguments to filter Backlinks to delete.
     * @example
     * // Delete a few Backlinks
     * const { count } = await prisma.backlink.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends BacklinkDeleteManyArgs>(args?: SelectSubset<T, BacklinkDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Backlinks.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {BacklinkUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Backlinks
     * const backlink = await prisma.backlink.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends BacklinkUpdateManyArgs>(args: SelectSubset<T, BacklinkUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Backlinks and returns the data updated in the database.
     * @param {BacklinkUpdateManyAndReturnArgs} args - Arguments to update many Backlinks.
     * @example
     * // Update many Backlinks
     * const backlink = await prisma.backlink.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Backlinks and only return the `id`
     * const backlinkWithIdOnly = await prisma.backlink.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends BacklinkUpdateManyAndReturnArgs>(args: SelectSubset<T, BacklinkUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one Backlink.
     * @param {BacklinkUpsertArgs} args - Arguments to update or create a Backlink.
     * @example
     * // Update or create a Backlink
     * const backlink = await prisma.backlink.upsert({
     *   create: {
     *     // ... data to create a Backlink
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Backlink we want to update
     *   }
     * })
     */
    upsert<T extends BacklinkUpsertArgs>(args: SelectSubset<T, BacklinkUpsertArgs<ExtArgs>>): Prisma__BacklinkClient<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of Backlinks.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {BacklinkCountArgs} args - Arguments to filter Backlinks to count.
     * @example
     * // Count the number of Backlinks
     * const count = await prisma.backlink.count({
     *   where: {
     *     // ... the filter for the Backlinks we want to count
     *   }
     * })
    **/
    count<T extends BacklinkCountArgs>(
      args?: Subset<T, BacklinkCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], BacklinkCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Backlink.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {BacklinkAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends BacklinkAggregateArgs>(args: Subset<T, BacklinkAggregateArgs>): Prisma.PrismaPromise<GetBacklinkAggregateType<T>>

    /**
     * Group by Backlink.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {BacklinkGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends BacklinkGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: BacklinkGroupByArgs['orderBy'] }
        : { orderBy?: BacklinkGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, BacklinkGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetBacklinkGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Backlink model
   */
  readonly fields: BacklinkFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Backlink.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__BacklinkClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    created_by<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    ManagedBy<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    project<T extends ProjectDefaultArgs<ExtArgs> = {}>(args?: Subset<T, ProjectDefaultArgs<ExtArgs>>): Prisma__ProjectClient<$Result.GetResult<Prisma.$ProjectPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    LinksCategories<T extends GuideLinesDefaultArgs<ExtArgs> = {}>(args?: Subset<T, GuideLinesDefaultArgs<ExtArgs>>): Prisma__GuideLinesClient<$Result.GetResult<Prisma.$GuideLinesPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    jobLinks<T extends UserJobsDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserJobsDefaultArgs<ExtArgs>>): Prisma__UserJobsClient<$Result.GetResult<Prisma.$UserJobsPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    Process<T extends Backlink$ProcessArgs<ExtArgs> = {}>(args?: Subset<T, Backlink$ProcessArgs<ExtArgs>>): Prisma__ProcessClient<$Result.GetResult<Prisma.$ProcessPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | null, null, ExtArgs, ClientOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Backlink model
   */ 
  interface BacklinkFieldRefs {
    readonly id: FieldRef<"Backlink", 'Int'>
    readonly link_url: FieldRef<"Backlink", 'String'>
    readonly link_status: FieldRef<"Backlink", 'Int'>
    readonly is_index: FieldRef<"Backlink", 'Boolean'>
    readonly link_rel: FieldRef<"Backlink", 'String'>
    readonly anchor_text: FieldRef<"Backlink", 'String'>
    readonly targeted_url: FieldRef<"Backlink", 'String'>
    readonly project_id: FieldRef<"Backlink", 'Int'>
    readonly uploaded_by_id: FieldRef<"Backlink", 'Int'>
    readonly first_seen: FieldRef<"Backlink", 'DateTime'>
    readonly last_seen: FieldRef<"Backlink", 'DateTime'>
    readonly added_date: FieldRef<"Backlink", 'DateTime'>
    readonly created_at: FieldRef<"Backlink", 'DateTime'>
    readonly updated_at: FieldRef<"Backlink", 'DateTime'>
    readonly deleted_at: FieldRef<"Backlink", 'DateTime'>
    readonly refer_domain: FieldRef<"Backlink", 'String'>
    readonly refering_domain: FieldRef<"Backlink", 'Boolean'>
    readonly backlink_duplicate: FieldRef<"Backlink", 'Boolean'>
    readonly managed_by: FieldRef<"Backlink", 'Int'>
    readonly link_category: FieldRef<"Backlink", 'Int'>
    readonly job_id: FieldRef<"Backlink", 'Int'>
    readonly processId: FieldRef<"Backlink", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * Backlink findUnique
   */
  export type BacklinkFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    /**
     * Filter, which Backlink to fetch.
     */
    where: BacklinkWhereUniqueInput
  }

  /**
   * Backlink findUniqueOrThrow
   */
  export type BacklinkFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    /**
     * Filter, which Backlink to fetch.
     */
    where: BacklinkWhereUniqueInput
  }

  /**
   * Backlink findFirst
   */
  export type BacklinkFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    /**
     * Filter, which Backlink to fetch.
     */
    where?: BacklinkWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Backlinks to fetch.
     */
    orderBy?: BacklinkOrderByWithRelationInput | BacklinkOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Backlinks.
     */
    cursor?: BacklinkWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Backlinks from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Backlinks.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Backlinks.
     */
    distinct?: BacklinkScalarFieldEnum | BacklinkScalarFieldEnum[]
  }

  /**
   * Backlink findFirstOrThrow
   */
  export type BacklinkFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    /**
     * Filter, which Backlink to fetch.
     */
    where?: BacklinkWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Backlinks to fetch.
     */
    orderBy?: BacklinkOrderByWithRelationInput | BacklinkOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Backlinks.
     */
    cursor?: BacklinkWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Backlinks from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Backlinks.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Backlinks.
     */
    distinct?: BacklinkScalarFieldEnum | BacklinkScalarFieldEnum[]
  }

  /**
   * Backlink findMany
   */
  export type BacklinkFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    /**
     * Filter, which Backlinks to fetch.
     */
    where?: BacklinkWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Backlinks to fetch.
     */
    orderBy?: BacklinkOrderByWithRelationInput | BacklinkOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Backlinks.
     */
    cursor?: BacklinkWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Backlinks from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Backlinks.
     */
    skip?: number
    distinct?: BacklinkScalarFieldEnum | BacklinkScalarFieldEnum[]
  }

  /**
   * Backlink create
   */
  export type BacklinkCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    /**
     * The data needed to create a Backlink.
     */
    data: XOR<BacklinkCreateInput, BacklinkUncheckedCreateInput>
  }

  /**
   * Backlink createMany
   */
  export type BacklinkCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Backlinks.
     */
    data: BacklinkCreateManyInput | BacklinkCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Backlink createManyAndReturn
   */
  export type BacklinkCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * The data used to create many Backlinks.
     */
    data: BacklinkCreateManyInput | BacklinkCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * Backlink update
   */
  export type BacklinkUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    /**
     * The data needed to update a Backlink.
     */
    data: XOR<BacklinkUpdateInput, BacklinkUncheckedUpdateInput>
    /**
     * Choose, which Backlink to update.
     */
    where: BacklinkWhereUniqueInput
  }

  /**
   * Backlink updateMany
   */
  export type BacklinkUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Backlinks.
     */
    data: XOR<BacklinkUpdateManyMutationInput, BacklinkUncheckedUpdateManyInput>
    /**
     * Filter which Backlinks to update
     */
    where?: BacklinkWhereInput
    /**
     * Limit how many Backlinks to update.
     */
    limit?: number
  }

  /**
   * Backlink updateManyAndReturn
   */
  export type BacklinkUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * The data used to update Backlinks.
     */
    data: XOR<BacklinkUpdateManyMutationInput, BacklinkUncheckedUpdateManyInput>
    /**
     * Filter which Backlinks to update
     */
    where?: BacklinkWhereInput
    /**
     * Limit how many Backlinks to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * Backlink upsert
   */
  export type BacklinkUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    /**
     * The filter to search for the Backlink to update in case it exists.
     */
    where: BacklinkWhereUniqueInput
    /**
     * In case the Backlink found by the `where` argument doesn't exist, create a new Backlink with this data.
     */
    create: XOR<BacklinkCreateInput, BacklinkUncheckedCreateInput>
    /**
     * In case the Backlink was found with the provided `where` argument, update it with this data.
     */
    update: XOR<BacklinkUpdateInput, BacklinkUncheckedUpdateInput>
  }

  /**
   * Backlink delete
   */
  export type BacklinkDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    /**
     * Filter which Backlink to delete.
     */
    where: BacklinkWhereUniqueInput
  }

  /**
   * Backlink deleteMany
   */
  export type BacklinkDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Backlinks to delete
     */
    where?: BacklinkWhereInput
    /**
     * Limit how many Backlinks to delete.
     */
    limit?: number
  }

  /**
   * Backlink.Process
   */
  export type Backlink$ProcessArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Process
     */
    select?: ProcessSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Process
     */
    omit?: ProcessOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProcessInclude<ExtArgs> | null
    where?: ProcessWhereInput
  }

  /**
   * Backlink without action
   */
  export type BacklinkDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
  }


  /**
   * Model Process
   */

  export type AggregateProcess = {
    _count: ProcessCountAggregateOutputType | null
    _avg: ProcessAvgAggregateOutputType | null
    _sum: ProcessSumAggregateOutputType | null
    _min: ProcessMinAggregateOutputType | null
    _max: ProcessMaxAggregateOutputType | null
  }

  export type ProcessAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type ProcessSumAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type ProcessMinAggregateOutputType = {
    id: number | null
    status: $Enums.ProcessStatus | null
    user_id: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type ProcessMaxAggregateOutputType = {
    id: number | null
    status: $Enums.ProcessStatus | null
    user_id: number | null
    created_at: Date | null
    updated_at: Date | null
  }

  export type ProcessCountAggregateOutputType = {
    id: number
    status: number
    user_id: number
    created_at: number
    updated_at: number
    _all: number
  }


  export type ProcessAvgAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type ProcessSumAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type ProcessMinAggregateInputType = {
    id?: true
    status?: true
    user_id?: true
    created_at?: true
    updated_at?: true
  }

  export type ProcessMaxAggregateInputType = {
    id?: true
    status?: true
    user_id?: true
    created_at?: true
    updated_at?: true
  }

  export type ProcessCountAggregateInputType = {
    id?: true
    status?: true
    user_id?: true
    created_at?: true
    updated_at?: true
    _all?: true
  }

  export type ProcessAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Process to aggregate.
     */
    where?: ProcessWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Processes to fetch.
     */
    orderBy?: ProcessOrderByWithRelationInput | ProcessOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ProcessWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Processes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Processes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Processes
    **/
    _count?: true | ProcessCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ProcessAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ProcessSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ProcessMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ProcessMaxAggregateInputType
  }

  export type GetProcessAggregateType<T extends ProcessAggregateArgs> = {
        [P in keyof T & keyof AggregateProcess]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateProcess[P]>
      : GetScalarType<T[P], AggregateProcess[P]>
  }




  export type ProcessGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProcessWhereInput
    orderBy?: ProcessOrderByWithAggregationInput | ProcessOrderByWithAggregationInput[]
    by: ProcessScalarFieldEnum[] | ProcessScalarFieldEnum
    having?: ProcessScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ProcessCountAggregateInputType | true
    _avg?: ProcessAvgAggregateInputType
    _sum?: ProcessSumAggregateInputType
    _min?: ProcessMinAggregateInputType
    _max?: ProcessMaxAggregateInputType
  }

  export type ProcessGroupByOutputType = {
    id: number
    status: $Enums.ProcessStatus
    user_id: number
    created_at: Date
    updated_at: Date
    _count: ProcessCountAggregateOutputType | null
    _avg: ProcessAvgAggregateOutputType | null
    _sum: ProcessSumAggregateOutputType | null
    _min: ProcessMinAggregateOutputType | null
    _max: ProcessMaxAggregateOutputType | null
  }

  type GetProcessGroupByPayload<T extends ProcessGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ProcessGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ProcessGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ProcessGroupByOutputType[P]>
            : GetScalarType<T[P], ProcessGroupByOutputType[P]>
        }
      >
    >


  export type ProcessSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    status?: boolean
    user_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    userProcess?: boolean | UserDefaultArgs<ExtArgs>
    BacklinkProcess?: boolean | Process$BacklinkProcessArgs<ExtArgs>
    _count?: boolean | ProcessCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["process"]>

  export type ProcessSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    status?: boolean
    user_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    userProcess?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["process"]>

  export type ProcessSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    status?: boolean
    user_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    userProcess?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["process"]>

  export type ProcessSelectScalar = {
    id?: boolean
    status?: boolean
    user_id?: boolean
    created_at?: boolean
    updated_at?: boolean
  }

  export type ProcessOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "status" | "user_id" | "created_at" | "updated_at", ExtArgs["result"]["process"]>
  export type ProcessInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    userProcess?: boolean | UserDefaultArgs<ExtArgs>
    BacklinkProcess?: boolean | Process$BacklinkProcessArgs<ExtArgs>
    _count?: boolean | ProcessCountOutputTypeDefaultArgs<ExtArgs>
  }
  export type ProcessIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    userProcess?: boolean | UserDefaultArgs<ExtArgs>
  }
  export type ProcessIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    userProcess?: boolean | UserDefaultArgs<ExtArgs>
  }

  export type $ProcessPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Process"
    objects: {
      userProcess: Prisma.$UserPayload<ExtArgs>
      BacklinkProcess: Prisma.$BacklinkPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      status: $Enums.ProcessStatus
      user_id: number
      created_at: Date
      updated_at: Date
    }, ExtArgs["result"]["process"]>
    composites: {}
  }

  type ProcessGetPayload<S extends boolean | null | undefined | ProcessDefaultArgs> = $Result.GetResult<Prisma.$ProcessPayload, S>

  type ProcessCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<ProcessFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: ProcessCountAggregateInputType | true
    }

  export interface ProcessDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Process'], meta: { name: 'Process' } }
    /**
     * Find zero or one Process that matches the filter.
     * @param {ProcessFindUniqueArgs} args - Arguments to find a Process
     * @example
     * // Get one Process
     * const process = await prisma.process.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ProcessFindUniqueArgs>(args: SelectSubset<T, ProcessFindUniqueArgs<ExtArgs>>): Prisma__ProcessClient<$Result.GetResult<Prisma.$ProcessPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Process that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {ProcessFindUniqueOrThrowArgs} args - Arguments to find a Process
     * @example
     * // Get one Process
     * const process = await prisma.process.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ProcessFindUniqueOrThrowArgs>(args: SelectSubset<T, ProcessFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ProcessClient<$Result.GetResult<Prisma.$ProcessPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Process that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProcessFindFirstArgs} args - Arguments to find a Process
     * @example
     * // Get one Process
     * const process = await prisma.process.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ProcessFindFirstArgs>(args?: SelectSubset<T, ProcessFindFirstArgs<ExtArgs>>): Prisma__ProcessClient<$Result.GetResult<Prisma.$ProcessPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Process that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProcessFindFirstOrThrowArgs} args - Arguments to find a Process
     * @example
     * // Get one Process
     * const process = await prisma.process.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ProcessFindFirstOrThrowArgs>(args?: SelectSubset<T, ProcessFindFirstOrThrowArgs<ExtArgs>>): Prisma__ProcessClient<$Result.GetResult<Prisma.$ProcessPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Processes that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProcessFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Processes
     * const processes = await prisma.process.findMany()
     * 
     * // Get first 10 Processes
     * const processes = await prisma.process.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const processWithIdOnly = await prisma.process.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ProcessFindManyArgs>(args?: SelectSubset<T, ProcessFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProcessPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Process.
     * @param {ProcessCreateArgs} args - Arguments to create a Process.
     * @example
     * // Create one Process
     * const Process = await prisma.process.create({
     *   data: {
     *     // ... data to create a Process
     *   }
     * })
     * 
     */
    create<T extends ProcessCreateArgs>(args: SelectSubset<T, ProcessCreateArgs<ExtArgs>>): Prisma__ProcessClient<$Result.GetResult<Prisma.$ProcessPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Processes.
     * @param {ProcessCreateManyArgs} args - Arguments to create many Processes.
     * @example
     * // Create many Processes
     * const process = await prisma.process.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ProcessCreateManyArgs>(args?: SelectSubset<T, ProcessCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Processes and returns the data saved in the database.
     * @param {ProcessCreateManyAndReturnArgs} args - Arguments to create many Processes.
     * @example
     * // Create many Processes
     * const process = await prisma.process.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Processes and only return the `id`
     * const processWithIdOnly = await prisma.process.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends ProcessCreateManyAndReturnArgs>(args?: SelectSubset<T, ProcessCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProcessPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a Process.
     * @param {ProcessDeleteArgs} args - Arguments to delete one Process.
     * @example
     * // Delete one Process
     * const Process = await prisma.process.delete({
     *   where: {
     *     // ... filter to delete one Process
     *   }
     * })
     * 
     */
    delete<T extends ProcessDeleteArgs>(args: SelectSubset<T, ProcessDeleteArgs<ExtArgs>>): Prisma__ProcessClient<$Result.GetResult<Prisma.$ProcessPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Process.
     * @param {ProcessUpdateArgs} args - Arguments to update one Process.
     * @example
     * // Update one Process
     * const process = await prisma.process.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ProcessUpdateArgs>(args: SelectSubset<T, ProcessUpdateArgs<ExtArgs>>): Prisma__ProcessClient<$Result.GetResult<Prisma.$ProcessPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Processes.
     * @param {ProcessDeleteManyArgs} args - Arguments to filter Processes to delete.
     * @example
     * // Delete a few Processes
     * const { count } = await prisma.process.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ProcessDeleteManyArgs>(args?: SelectSubset<T, ProcessDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Processes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProcessUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Processes
     * const process = await prisma.process.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ProcessUpdateManyArgs>(args: SelectSubset<T, ProcessUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Processes and returns the data updated in the database.
     * @param {ProcessUpdateManyAndReturnArgs} args - Arguments to update many Processes.
     * @example
     * // Update many Processes
     * const process = await prisma.process.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Processes and only return the `id`
     * const processWithIdOnly = await prisma.process.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends ProcessUpdateManyAndReturnArgs>(args: SelectSubset<T, ProcessUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProcessPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one Process.
     * @param {ProcessUpsertArgs} args - Arguments to update or create a Process.
     * @example
     * // Update or create a Process
     * const process = await prisma.process.upsert({
     *   create: {
     *     // ... data to create a Process
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Process we want to update
     *   }
     * })
     */
    upsert<T extends ProcessUpsertArgs>(args: SelectSubset<T, ProcessUpsertArgs<ExtArgs>>): Prisma__ProcessClient<$Result.GetResult<Prisma.$ProcessPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of Processes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProcessCountArgs} args - Arguments to filter Processes to count.
     * @example
     * // Count the number of Processes
     * const count = await prisma.process.count({
     *   where: {
     *     // ... the filter for the Processes we want to count
     *   }
     * })
    **/
    count<T extends ProcessCountArgs>(
      args?: Subset<T, ProcessCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ProcessCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Process.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProcessAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ProcessAggregateArgs>(args: Subset<T, ProcessAggregateArgs>): Prisma.PrismaPromise<GetProcessAggregateType<T>>

    /**
     * Group by Process.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProcessGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ProcessGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ProcessGroupByArgs['orderBy'] }
        : { orderBy?: ProcessGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ProcessGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetProcessGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Process model
   */
  readonly fields: ProcessFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Process.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ProcessClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    userProcess<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    BacklinkProcess<T extends Process$BacklinkProcessArgs<ExtArgs> = {}>(args?: Subset<T, Process$BacklinkProcessArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Process model
   */ 
  interface ProcessFieldRefs {
    readonly id: FieldRef<"Process", 'Int'>
    readonly status: FieldRef<"Process", 'ProcessStatus'>
    readonly user_id: FieldRef<"Process", 'Int'>
    readonly created_at: FieldRef<"Process", 'DateTime'>
    readonly updated_at: FieldRef<"Process", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Process findUnique
   */
  export type ProcessFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Process
     */
    select?: ProcessSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Process
     */
    omit?: ProcessOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProcessInclude<ExtArgs> | null
    /**
     * Filter, which Process to fetch.
     */
    where: ProcessWhereUniqueInput
  }

  /**
   * Process findUniqueOrThrow
   */
  export type ProcessFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Process
     */
    select?: ProcessSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Process
     */
    omit?: ProcessOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProcessInclude<ExtArgs> | null
    /**
     * Filter, which Process to fetch.
     */
    where: ProcessWhereUniqueInput
  }

  /**
   * Process findFirst
   */
  export type ProcessFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Process
     */
    select?: ProcessSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Process
     */
    omit?: ProcessOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProcessInclude<ExtArgs> | null
    /**
     * Filter, which Process to fetch.
     */
    where?: ProcessWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Processes to fetch.
     */
    orderBy?: ProcessOrderByWithRelationInput | ProcessOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Processes.
     */
    cursor?: ProcessWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Processes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Processes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Processes.
     */
    distinct?: ProcessScalarFieldEnum | ProcessScalarFieldEnum[]
  }

  /**
   * Process findFirstOrThrow
   */
  export type ProcessFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Process
     */
    select?: ProcessSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Process
     */
    omit?: ProcessOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProcessInclude<ExtArgs> | null
    /**
     * Filter, which Process to fetch.
     */
    where?: ProcessWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Processes to fetch.
     */
    orderBy?: ProcessOrderByWithRelationInput | ProcessOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Processes.
     */
    cursor?: ProcessWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Processes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Processes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Processes.
     */
    distinct?: ProcessScalarFieldEnum | ProcessScalarFieldEnum[]
  }

  /**
   * Process findMany
   */
  export type ProcessFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Process
     */
    select?: ProcessSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Process
     */
    omit?: ProcessOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProcessInclude<ExtArgs> | null
    /**
     * Filter, which Processes to fetch.
     */
    where?: ProcessWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Processes to fetch.
     */
    orderBy?: ProcessOrderByWithRelationInput | ProcessOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Processes.
     */
    cursor?: ProcessWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Processes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Processes.
     */
    skip?: number
    distinct?: ProcessScalarFieldEnum | ProcessScalarFieldEnum[]
  }

  /**
   * Process create
   */
  export type ProcessCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Process
     */
    select?: ProcessSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Process
     */
    omit?: ProcessOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProcessInclude<ExtArgs> | null
    /**
     * The data needed to create a Process.
     */
    data: XOR<ProcessCreateInput, ProcessUncheckedCreateInput>
  }

  /**
   * Process createMany
   */
  export type ProcessCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Processes.
     */
    data: ProcessCreateManyInput | ProcessCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Process createManyAndReturn
   */
  export type ProcessCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Process
     */
    select?: ProcessSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Process
     */
    omit?: ProcessOmit<ExtArgs> | null
    /**
     * The data used to create many Processes.
     */
    data: ProcessCreateManyInput | ProcessCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProcessIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * Process update
   */
  export type ProcessUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Process
     */
    select?: ProcessSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Process
     */
    omit?: ProcessOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProcessInclude<ExtArgs> | null
    /**
     * The data needed to update a Process.
     */
    data: XOR<ProcessUpdateInput, ProcessUncheckedUpdateInput>
    /**
     * Choose, which Process to update.
     */
    where: ProcessWhereUniqueInput
  }

  /**
   * Process updateMany
   */
  export type ProcessUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Processes.
     */
    data: XOR<ProcessUpdateManyMutationInput, ProcessUncheckedUpdateManyInput>
    /**
     * Filter which Processes to update
     */
    where?: ProcessWhereInput
    /**
     * Limit how many Processes to update.
     */
    limit?: number
  }

  /**
   * Process updateManyAndReturn
   */
  export type ProcessUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Process
     */
    select?: ProcessSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Process
     */
    omit?: ProcessOmit<ExtArgs> | null
    /**
     * The data used to update Processes.
     */
    data: XOR<ProcessUpdateManyMutationInput, ProcessUncheckedUpdateManyInput>
    /**
     * Filter which Processes to update
     */
    where?: ProcessWhereInput
    /**
     * Limit how many Processes to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProcessIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * Process upsert
   */
  export type ProcessUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Process
     */
    select?: ProcessSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Process
     */
    omit?: ProcessOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProcessInclude<ExtArgs> | null
    /**
     * The filter to search for the Process to update in case it exists.
     */
    where: ProcessWhereUniqueInput
    /**
     * In case the Process found by the `where` argument doesn't exist, create a new Process with this data.
     */
    create: XOR<ProcessCreateInput, ProcessUncheckedCreateInput>
    /**
     * In case the Process was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ProcessUpdateInput, ProcessUncheckedUpdateInput>
  }

  /**
   * Process delete
   */
  export type ProcessDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Process
     */
    select?: ProcessSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Process
     */
    omit?: ProcessOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProcessInclude<ExtArgs> | null
    /**
     * Filter which Process to delete.
     */
    where: ProcessWhereUniqueInput
  }

  /**
   * Process deleteMany
   */
  export type ProcessDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Processes to delete
     */
    where?: ProcessWhereInput
    /**
     * Limit how many Processes to delete.
     */
    limit?: number
  }

  /**
   * Process.BacklinkProcess
   */
  export type Process$BacklinkProcessArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    where?: BacklinkWhereInput
    orderBy?: BacklinkOrderByWithRelationInput | BacklinkOrderByWithRelationInput[]
    cursor?: BacklinkWhereUniqueInput
    take?: number
    skip?: number
    distinct?: BacklinkScalarFieldEnum | BacklinkScalarFieldEnum[]
  }

  /**
   * Process without action
   */
  export type ProcessDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Process
     */
    select?: ProcessSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Process
     */
    omit?: ProcessOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProcessInclude<ExtArgs> | null
  }


  /**
   * Model Team
   */

  export type AggregateTeam = {
    _count: TeamCountAggregateOutputType | null
    _avg: TeamAvgAggregateOutputType | null
    _sum: TeamSumAggregateOutputType | null
    _min: TeamMinAggregateOutputType | null
    _max: TeamMaxAggregateOutputType | null
  }

  export type TeamAvgAggregateOutputType = {
    id: number | null
    organisation_id: number | null
    created_by: number | null
    user_id: number | null
    role_id: number | null
  }

  export type TeamSumAggregateOutputType = {
    id: number | null
    organisation_id: number | null
    created_by: number | null
    user_id: number | null
    role_id: number | null
  }

  export type TeamMinAggregateOutputType = {
    id: number | null
    organisation_id: number | null
    created_by: number | null
    user_id: number | null
    role_id: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type TeamMaxAggregateOutputType = {
    id: number | null
    organisation_id: number | null
    created_by: number | null
    user_id: number | null
    role_id: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type TeamCountAggregateOutputType = {
    id: number
    organisation_id: number
    created_by: number
    user_id: number
    role_id: number
    created_at: number
    updated_at: number
    deleted_at: number
    _all: number
  }


  export type TeamAvgAggregateInputType = {
    id?: true
    organisation_id?: true
    created_by?: true
    user_id?: true
    role_id?: true
  }

  export type TeamSumAggregateInputType = {
    id?: true
    organisation_id?: true
    created_by?: true
    user_id?: true
    role_id?: true
  }

  export type TeamMinAggregateInputType = {
    id?: true
    organisation_id?: true
    created_by?: true
    user_id?: true
    role_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type TeamMaxAggregateInputType = {
    id?: true
    organisation_id?: true
    created_by?: true
    user_id?: true
    role_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type TeamCountAggregateInputType = {
    id?: true
    organisation_id?: true
    created_by?: true
    user_id?: true
    role_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    _all?: true
  }

  export type TeamAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Team to aggregate.
     */
    where?: TeamWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Teams to fetch.
     */
    orderBy?: TeamOrderByWithRelationInput | TeamOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: TeamWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Teams from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Teams.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Teams
    **/
    _count?: true | TeamCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: TeamAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: TeamSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: TeamMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: TeamMaxAggregateInputType
  }

  export type GetTeamAggregateType<T extends TeamAggregateArgs> = {
        [P in keyof T & keyof AggregateTeam]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateTeam[P]>
      : GetScalarType<T[P], AggregateTeam[P]>
  }




  export type TeamGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: TeamWhereInput
    orderBy?: TeamOrderByWithAggregationInput | TeamOrderByWithAggregationInput[]
    by: TeamScalarFieldEnum[] | TeamScalarFieldEnum
    having?: TeamScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: TeamCountAggregateInputType | true
    _avg?: TeamAvgAggregateInputType
    _sum?: TeamSumAggregateInputType
    _min?: TeamMinAggregateInputType
    _max?: TeamMaxAggregateInputType
  }

  export type TeamGroupByOutputType = {
    id: number
    organisation_id: number | null
    created_by: number
    user_id: number
    role_id: number
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    _count: TeamCountAggregateOutputType | null
    _avg: TeamAvgAggregateOutputType | null
    _sum: TeamSumAggregateOutputType | null
    _min: TeamMinAggregateOutputType | null
    _max: TeamMaxAggregateOutputType | null
  }

  type GetTeamGroupByPayload<T extends TeamGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<TeamGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof TeamGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], TeamGroupByOutputType[P]>
            : GetScalarType<T[P], TeamGroupByOutputType[P]>
        }
      >
    >


  export type TeamSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    organisation_id?: boolean
    created_by?: boolean
    user_id?: boolean
    role_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    Organisation?: boolean | Team$OrganisationArgs<ExtArgs>
    CreatedBy?: boolean | UserDefaultArgs<ExtArgs>
    UserId?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["team"]>

  export type TeamSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    organisation_id?: boolean
    created_by?: boolean
    user_id?: boolean
    role_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    Organisation?: boolean | Team$OrganisationArgs<ExtArgs>
    CreatedBy?: boolean | UserDefaultArgs<ExtArgs>
    UserId?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["team"]>

  export type TeamSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    organisation_id?: boolean
    created_by?: boolean
    user_id?: boolean
    role_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    Organisation?: boolean | Team$OrganisationArgs<ExtArgs>
    CreatedBy?: boolean | UserDefaultArgs<ExtArgs>
    UserId?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["team"]>

  export type TeamSelectScalar = {
    id?: boolean
    organisation_id?: boolean
    created_by?: boolean
    user_id?: boolean
    role_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }

  export type TeamOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "organisation_id" | "created_by" | "user_id" | "role_id" | "created_at" | "updated_at" | "deleted_at", ExtArgs["result"]["team"]>
  export type TeamInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    Organisation?: boolean | Team$OrganisationArgs<ExtArgs>
    CreatedBy?: boolean | UserDefaultArgs<ExtArgs>
    UserId?: boolean | UserDefaultArgs<ExtArgs>
  }
  export type TeamIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    Organisation?: boolean | Team$OrganisationArgs<ExtArgs>
    CreatedBy?: boolean | UserDefaultArgs<ExtArgs>
    UserId?: boolean | UserDefaultArgs<ExtArgs>
  }
  export type TeamIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    Organisation?: boolean | Team$OrganisationArgs<ExtArgs>
    CreatedBy?: boolean | UserDefaultArgs<ExtArgs>
    UserId?: boolean | UserDefaultArgs<ExtArgs>
  }

  export type $TeamPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Team"
    objects: {
      Organisation: Prisma.$UserPayload<ExtArgs> | null
      CreatedBy: Prisma.$UserPayload<ExtArgs>
      UserId: Prisma.$UserPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      organisation_id: number | null
      created_by: number
      user_id: number
      role_id: number
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
    }, ExtArgs["result"]["team"]>
    composites: {}
  }

  type TeamGetPayload<S extends boolean | null | undefined | TeamDefaultArgs> = $Result.GetResult<Prisma.$TeamPayload, S>

  type TeamCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<TeamFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: TeamCountAggregateInputType | true
    }

  export interface TeamDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Team'], meta: { name: 'Team' } }
    /**
     * Find zero or one Team that matches the filter.
     * @param {TeamFindUniqueArgs} args - Arguments to find a Team
     * @example
     * // Get one Team
     * const team = await prisma.team.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends TeamFindUniqueArgs>(args: SelectSubset<T, TeamFindUniqueArgs<ExtArgs>>): Prisma__TeamClient<$Result.GetResult<Prisma.$TeamPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Team that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {TeamFindUniqueOrThrowArgs} args - Arguments to find a Team
     * @example
     * // Get one Team
     * const team = await prisma.team.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends TeamFindUniqueOrThrowArgs>(args: SelectSubset<T, TeamFindUniqueOrThrowArgs<ExtArgs>>): Prisma__TeamClient<$Result.GetResult<Prisma.$TeamPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Team that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TeamFindFirstArgs} args - Arguments to find a Team
     * @example
     * // Get one Team
     * const team = await prisma.team.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends TeamFindFirstArgs>(args?: SelectSubset<T, TeamFindFirstArgs<ExtArgs>>): Prisma__TeamClient<$Result.GetResult<Prisma.$TeamPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Team that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TeamFindFirstOrThrowArgs} args - Arguments to find a Team
     * @example
     * // Get one Team
     * const team = await prisma.team.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends TeamFindFirstOrThrowArgs>(args?: SelectSubset<T, TeamFindFirstOrThrowArgs<ExtArgs>>): Prisma__TeamClient<$Result.GetResult<Prisma.$TeamPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Teams that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TeamFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Teams
     * const teams = await prisma.team.findMany()
     * 
     * // Get first 10 Teams
     * const teams = await prisma.team.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const teamWithIdOnly = await prisma.team.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends TeamFindManyArgs>(args?: SelectSubset<T, TeamFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TeamPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Team.
     * @param {TeamCreateArgs} args - Arguments to create a Team.
     * @example
     * // Create one Team
     * const Team = await prisma.team.create({
     *   data: {
     *     // ... data to create a Team
     *   }
     * })
     * 
     */
    create<T extends TeamCreateArgs>(args: SelectSubset<T, TeamCreateArgs<ExtArgs>>): Prisma__TeamClient<$Result.GetResult<Prisma.$TeamPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Teams.
     * @param {TeamCreateManyArgs} args - Arguments to create many Teams.
     * @example
     * // Create many Teams
     * const team = await prisma.team.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends TeamCreateManyArgs>(args?: SelectSubset<T, TeamCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Teams and returns the data saved in the database.
     * @param {TeamCreateManyAndReturnArgs} args - Arguments to create many Teams.
     * @example
     * // Create many Teams
     * const team = await prisma.team.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Teams and only return the `id`
     * const teamWithIdOnly = await prisma.team.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends TeamCreateManyAndReturnArgs>(args?: SelectSubset<T, TeamCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TeamPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a Team.
     * @param {TeamDeleteArgs} args - Arguments to delete one Team.
     * @example
     * // Delete one Team
     * const Team = await prisma.team.delete({
     *   where: {
     *     // ... filter to delete one Team
     *   }
     * })
     * 
     */
    delete<T extends TeamDeleteArgs>(args: SelectSubset<T, TeamDeleteArgs<ExtArgs>>): Prisma__TeamClient<$Result.GetResult<Prisma.$TeamPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Team.
     * @param {TeamUpdateArgs} args - Arguments to update one Team.
     * @example
     * // Update one Team
     * const team = await prisma.team.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends TeamUpdateArgs>(args: SelectSubset<T, TeamUpdateArgs<ExtArgs>>): Prisma__TeamClient<$Result.GetResult<Prisma.$TeamPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Teams.
     * @param {TeamDeleteManyArgs} args - Arguments to filter Teams to delete.
     * @example
     * // Delete a few Teams
     * const { count } = await prisma.team.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends TeamDeleteManyArgs>(args?: SelectSubset<T, TeamDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Teams.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TeamUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Teams
     * const team = await prisma.team.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends TeamUpdateManyArgs>(args: SelectSubset<T, TeamUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Teams and returns the data updated in the database.
     * @param {TeamUpdateManyAndReturnArgs} args - Arguments to update many Teams.
     * @example
     * // Update many Teams
     * const team = await prisma.team.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Teams and only return the `id`
     * const teamWithIdOnly = await prisma.team.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends TeamUpdateManyAndReturnArgs>(args: SelectSubset<T, TeamUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TeamPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one Team.
     * @param {TeamUpsertArgs} args - Arguments to update or create a Team.
     * @example
     * // Update or create a Team
     * const team = await prisma.team.upsert({
     *   create: {
     *     // ... data to create a Team
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Team we want to update
     *   }
     * })
     */
    upsert<T extends TeamUpsertArgs>(args: SelectSubset<T, TeamUpsertArgs<ExtArgs>>): Prisma__TeamClient<$Result.GetResult<Prisma.$TeamPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of Teams.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TeamCountArgs} args - Arguments to filter Teams to count.
     * @example
     * // Count the number of Teams
     * const count = await prisma.team.count({
     *   where: {
     *     // ... the filter for the Teams we want to count
     *   }
     * })
    **/
    count<T extends TeamCountArgs>(
      args?: Subset<T, TeamCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], TeamCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Team.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TeamAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends TeamAggregateArgs>(args: Subset<T, TeamAggregateArgs>): Prisma.PrismaPromise<GetTeamAggregateType<T>>

    /**
     * Group by Team.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TeamGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends TeamGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: TeamGroupByArgs['orderBy'] }
        : { orderBy?: TeamGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, TeamGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetTeamGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Team model
   */
  readonly fields: TeamFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Team.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__TeamClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    Organisation<T extends Team$OrganisationArgs<ExtArgs> = {}>(args?: Subset<T, Team$OrganisationArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | null, null, ExtArgs, ClientOptions>
    CreatedBy<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    UserId<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Team model
   */ 
  interface TeamFieldRefs {
    readonly id: FieldRef<"Team", 'Int'>
    readonly organisation_id: FieldRef<"Team", 'Int'>
    readonly created_by: FieldRef<"Team", 'Int'>
    readonly user_id: FieldRef<"Team", 'Int'>
    readonly role_id: FieldRef<"Team", 'Int'>
    readonly created_at: FieldRef<"Team", 'DateTime'>
    readonly updated_at: FieldRef<"Team", 'DateTime'>
    readonly deleted_at: FieldRef<"Team", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * Team findUnique
   */
  export type TeamFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Team
     */
    select?: TeamSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Team
     */
    omit?: TeamOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TeamInclude<ExtArgs> | null
    /**
     * Filter, which Team to fetch.
     */
    where: TeamWhereUniqueInput
  }

  /**
   * Team findUniqueOrThrow
   */
  export type TeamFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Team
     */
    select?: TeamSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Team
     */
    omit?: TeamOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TeamInclude<ExtArgs> | null
    /**
     * Filter, which Team to fetch.
     */
    where: TeamWhereUniqueInput
  }

  /**
   * Team findFirst
   */
  export type TeamFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Team
     */
    select?: TeamSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Team
     */
    omit?: TeamOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TeamInclude<ExtArgs> | null
    /**
     * Filter, which Team to fetch.
     */
    where?: TeamWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Teams to fetch.
     */
    orderBy?: TeamOrderByWithRelationInput | TeamOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Teams.
     */
    cursor?: TeamWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Teams from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Teams.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Teams.
     */
    distinct?: TeamScalarFieldEnum | TeamScalarFieldEnum[]
  }

  /**
   * Team findFirstOrThrow
   */
  export type TeamFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Team
     */
    select?: TeamSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Team
     */
    omit?: TeamOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TeamInclude<ExtArgs> | null
    /**
     * Filter, which Team to fetch.
     */
    where?: TeamWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Teams to fetch.
     */
    orderBy?: TeamOrderByWithRelationInput | TeamOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Teams.
     */
    cursor?: TeamWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Teams from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Teams.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Teams.
     */
    distinct?: TeamScalarFieldEnum | TeamScalarFieldEnum[]
  }

  /**
   * Team findMany
   */
  export type TeamFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Team
     */
    select?: TeamSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Team
     */
    omit?: TeamOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TeamInclude<ExtArgs> | null
    /**
     * Filter, which Teams to fetch.
     */
    where?: TeamWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Teams to fetch.
     */
    orderBy?: TeamOrderByWithRelationInput | TeamOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Teams.
     */
    cursor?: TeamWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Teams from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Teams.
     */
    skip?: number
    distinct?: TeamScalarFieldEnum | TeamScalarFieldEnum[]
  }

  /**
   * Team create
   */
  export type TeamCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Team
     */
    select?: TeamSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Team
     */
    omit?: TeamOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TeamInclude<ExtArgs> | null
    /**
     * The data needed to create a Team.
     */
    data: XOR<TeamCreateInput, TeamUncheckedCreateInput>
  }

  /**
   * Team createMany
   */
  export type TeamCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Teams.
     */
    data: TeamCreateManyInput | TeamCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Team createManyAndReturn
   */
  export type TeamCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Team
     */
    select?: TeamSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Team
     */
    omit?: TeamOmit<ExtArgs> | null
    /**
     * The data used to create many Teams.
     */
    data: TeamCreateManyInput | TeamCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TeamIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * Team update
   */
  export type TeamUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Team
     */
    select?: TeamSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Team
     */
    omit?: TeamOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TeamInclude<ExtArgs> | null
    /**
     * The data needed to update a Team.
     */
    data: XOR<TeamUpdateInput, TeamUncheckedUpdateInput>
    /**
     * Choose, which Team to update.
     */
    where: TeamWhereUniqueInput
  }

  /**
   * Team updateMany
   */
  export type TeamUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Teams.
     */
    data: XOR<TeamUpdateManyMutationInput, TeamUncheckedUpdateManyInput>
    /**
     * Filter which Teams to update
     */
    where?: TeamWhereInput
    /**
     * Limit how many Teams to update.
     */
    limit?: number
  }

  /**
   * Team updateManyAndReturn
   */
  export type TeamUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Team
     */
    select?: TeamSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Team
     */
    omit?: TeamOmit<ExtArgs> | null
    /**
     * The data used to update Teams.
     */
    data: XOR<TeamUpdateManyMutationInput, TeamUncheckedUpdateManyInput>
    /**
     * Filter which Teams to update
     */
    where?: TeamWhereInput
    /**
     * Limit how many Teams to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TeamIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * Team upsert
   */
  export type TeamUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Team
     */
    select?: TeamSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Team
     */
    omit?: TeamOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TeamInclude<ExtArgs> | null
    /**
     * The filter to search for the Team to update in case it exists.
     */
    where: TeamWhereUniqueInput
    /**
     * In case the Team found by the `where` argument doesn't exist, create a new Team with this data.
     */
    create: XOR<TeamCreateInput, TeamUncheckedCreateInput>
    /**
     * In case the Team was found with the provided `where` argument, update it with this data.
     */
    update: XOR<TeamUpdateInput, TeamUncheckedUpdateInput>
  }

  /**
   * Team delete
   */
  export type TeamDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Team
     */
    select?: TeamSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Team
     */
    omit?: TeamOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TeamInclude<ExtArgs> | null
    /**
     * Filter which Team to delete.
     */
    where: TeamWhereUniqueInput
  }

  /**
   * Team deleteMany
   */
  export type TeamDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Teams to delete
     */
    where?: TeamWhereInput
    /**
     * Limit how many Teams to delete.
     */
    limit?: number
  }

  /**
   * Team.Organisation
   */
  export type Team$OrganisationArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Omit specific fields from the User
     */
    omit?: UserOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * Team without action
   */
  export type TeamDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Team
     */
    select?: TeamSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Team
     */
    omit?: TeamOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TeamInclude<ExtArgs> | null
  }


  /**
   * Model AssignTeamMember
   */

  export type AggregateAssignTeamMember = {
    _count: AssignTeamMemberCountAggregateOutputType | null
    _avg: AssignTeamMemberAvgAggregateOutputType | null
    _sum: AssignTeamMemberSumAggregateOutputType | null
    _min: AssignTeamMemberMinAggregateOutputType | null
    _max: AssignTeamMemberMaxAggregateOutputType | null
  }

  export type AssignTeamMemberAvgAggregateOutputType = {
    id: number | null
    organisation_id: number | null
    assign_to_id: number | null
    assign_by_id: number | null
    role_id: number | null
    assign_user: number | null
  }

  export type AssignTeamMemberSumAggregateOutputType = {
    id: number | null
    organisation_id: number | null
    assign_to_id: number | null
    assign_by_id: number | null
    role_id: number | null
    assign_user: number | null
  }

  export type AssignTeamMemberMinAggregateOutputType = {
    id: number | null
    organisation_id: number | null
    assign_to_id: number | null
    assign_by_id: number | null
    role_id: number | null
    assign_user: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type AssignTeamMemberMaxAggregateOutputType = {
    id: number | null
    organisation_id: number | null
    assign_to_id: number | null
    assign_by_id: number | null
    role_id: number | null
    assign_user: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type AssignTeamMemberCountAggregateOutputType = {
    id: number
    organisation_id: number
    assign_to_id: number
    assign_by_id: number
    role_id: number
    assign_user: number
    created_at: number
    updated_at: number
    deleted_at: number
    _all: number
  }


  export type AssignTeamMemberAvgAggregateInputType = {
    id?: true
    organisation_id?: true
    assign_to_id?: true
    assign_by_id?: true
    role_id?: true
    assign_user?: true
  }

  export type AssignTeamMemberSumAggregateInputType = {
    id?: true
    organisation_id?: true
    assign_to_id?: true
    assign_by_id?: true
    role_id?: true
    assign_user?: true
  }

  export type AssignTeamMemberMinAggregateInputType = {
    id?: true
    organisation_id?: true
    assign_to_id?: true
    assign_by_id?: true
    role_id?: true
    assign_user?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type AssignTeamMemberMaxAggregateInputType = {
    id?: true
    organisation_id?: true
    assign_to_id?: true
    assign_by_id?: true
    role_id?: true
    assign_user?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type AssignTeamMemberCountAggregateInputType = {
    id?: true
    organisation_id?: true
    assign_to_id?: true
    assign_by_id?: true
    role_id?: true
    assign_user?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    _all?: true
  }

  export type AssignTeamMemberAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which AssignTeamMember to aggregate.
     */
    where?: AssignTeamMemberWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of AssignTeamMembers to fetch.
     */
    orderBy?: AssignTeamMemberOrderByWithRelationInput | AssignTeamMemberOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: AssignTeamMemberWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` AssignTeamMembers from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` AssignTeamMembers.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned AssignTeamMembers
    **/
    _count?: true | AssignTeamMemberCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: AssignTeamMemberAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: AssignTeamMemberSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: AssignTeamMemberMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: AssignTeamMemberMaxAggregateInputType
  }

  export type GetAssignTeamMemberAggregateType<T extends AssignTeamMemberAggregateArgs> = {
        [P in keyof T & keyof AggregateAssignTeamMember]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateAssignTeamMember[P]>
      : GetScalarType<T[P], AggregateAssignTeamMember[P]>
  }




  export type AssignTeamMemberGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: AssignTeamMemberWhereInput
    orderBy?: AssignTeamMemberOrderByWithAggregationInput | AssignTeamMemberOrderByWithAggregationInput[]
    by: AssignTeamMemberScalarFieldEnum[] | AssignTeamMemberScalarFieldEnum
    having?: AssignTeamMemberScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: AssignTeamMemberCountAggregateInputType | true
    _avg?: AssignTeamMemberAvgAggregateInputType
    _sum?: AssignTeamMemberSumAggregateInputType
    _min?: AssignTeamMemberMinAggregateInputType
    _max?: AssignTeamMemberMaxAggregateInputType
  }

  export type AssignTeamMemberGroupByOutputType = {
    id: number
    organisation_id: number
    assign_to_id: number
    assign_by_id: number
    role_id: number
    assign_user: number
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    _count: AssignTeamMemberCountAggregateOutputType | null
    _avg: AssignTeamMemberAvgAggregateOutputType | null
    _sum: AssignTeamMemberSumAggregateOutputType | null
    _min: AssignTeamMemberMinAggregateOutputType | null
    _max: AssignTeamMemberMaxAggregateOutputType | null
  }

  type GetAssignTeamMemberGroupByPayload<T extends AssignTeamMemberGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<AssignTeamMemberGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof AssignTeamMemberGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], AssignTeamMemberGroupByOutputType[P]>
            : GetScalarType<T[P], AssignTeamMemberGroupByOutputType[P]>
        }
      >
    >


  export type AssignTeamMemberSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    organisation_id?: boolean
    assign_to_id?: boolean
    assign_by_id?: boolean
    role_id?: boolean
    assign_user?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    AssignOrg?: boolean | UserDefaultArgs<ExtArgs>
    AssignBY?: boolean | UserDefaultArgs<ExtArgs>
    CreatedBy?: boolean | UserDefaultArgs<ExtArgs>
    AssignedUser?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["assignTeamMember"]>

  export type AssignTeamMemberSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    organisation_id?: boolean
    assign_to_id?: boolean
    assign_by_id?: boolean
    role_id?: boolean
    assign_user?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    AssignOrg?: boolean | UserDefaultArgs<ExtArgs>
    AssignBY?: boolean | UserDefaultArgs<ExtArgs>
    CreatedBy?: boolean | UserDefaultArgs<ExtArgs>
    AssignedUser?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["assignTeamMember"]>

  export type AssignTeamMemberSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    organisation_id?: boolean
    assign_to_id?: boolean
    assign_by_id?: boolean
    role_id?: boolean
    assign_user?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    AssignOrg?: boolean | UserDefaultArgs<ExtArgs>
    AssignBY?: boolean | UserDefaultArgs<ExtArgs>
    CreatedBy?: boolean | UserDefaultArgs<ExtArgs>
    AssignedUser?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["assignTeamMember"]>

  export type AssignTeamMemberSelectScalar = {
    id?: boolean
    organisation_id?: boolean
    assign_to_id?: boolean
    assign_by_id?: boolean
    role_id?: boolean
    assign_user?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }

  export type AssignTeamMemberOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "organisation_id" | "assign_to_id" | "assign_by_id" | "role_id" | "assign_user" | "created_at" | "updated_at" | "deleted_at", ExtArgs["result"]["assignTeamMember"]>
  export type AssignTeamMemberInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    AssignOrg?: boolean | UserDefaultArgs<ExtArgs>
    AssignBY?: boolean | UserDefaultArgs<ExtArgs>
    CreatedBy?: boolean | UserDefaultArgs<ExtArgs>
    AssignedUser?: boolean | UserDefaultArgs<ExtArgs>
  }
  export type AssignTeamMemberIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    AssignOrg?: boolean | UserDefaultArgs<ExtArgs>
    AssignBY?: boolean | UserDefaultArgs<ExtArgs>
    CreatedBy?: boolean | UserDefaultArgs<ExtArgs>
    AssignedUser?: boolean | UserDefaultArgs<ExtArgs>
  }
  export type AssignTeamMemberIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    AssignOrg?: boolean | UserDefaultArgs<ExtArgs>
    AssignBY?: boolean | UserDefaultArgs<ExtArgs>
    CreatedBy?: boolean | UserDefaultArgs<ExtArgs>
    AssignedUser?: boolean | UserDefaultArgs<ExtArgs>
  }

  export type $AssignTeamMemberPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "AssignTeamMember"
    objects: {
      AssignOrg: Prisma.$UserPayload<ExtArgs>
      AssignBY: Prisma.$UserPayload<ExtArgs>
      CreatedBy: Prisma.$UserPayload<ExtArgs>
      AssignedUser: Prisma.$UserPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      organisation_id: number
      assign_to_id: number
      assign_by_id: number
      role_id: number
      assign_user: number
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
    }, ExtArgs["result"]["assignTeamMember"]>
    composites: {}
  }

  type AssignTeamMemberGetPayload<S extends boolean | null | undefined | AssignTeamMemberDefaultArgs> = $Result.GetResult<Prisma.$AssignTeamMemberPayload, S>

  type AssignTeamMemberCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<AssignTeamMemberFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: AssignTeamMemberCountAggregateInputType | true
    }

  export interface AssignTeamMemberDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['AssignTeamMember'], meta: { name: 'AssignTeamMember' } }
    /**
     * Find zero or one AssignTeamMember that matches the filter.
     * @param {AssignTeamMemberFindUniqueArgs} args - Arguments to find a AssignTeamMember
     * @example
     * // Get one AssignTeamMember
     * const assignTeamMember = await prisma.assignTeamMember.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends AssignTeamMemberFindUniqueArgs>(args: SelectSubset<T, AssignTeamMemberFindUniqueArgs<ExtArgs>>): Prisma__AssignTeamMemberClient<$Result.GetResult<Prisma.$AssignTeamMemberPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one AssignTeamMember that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {AssignTeamMemberFindUniqueOrThrowArgs} args - Arguments to find a AssignTeamMember
     * @example
     * // Get one AssignTeamMember
     * const assignTeamMember = await prisma.assignTeamMember.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends AssignTeamMemberFindUniqueOrThrowArgs>(args: SelectSubset<T, AssignTeamMemberFindUniqueOrThrowArgs<ExtArgs>>): Prisma__AssignTeamMemberClient<$Result.GetResult<Prisma.$AssignTeamMemberPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first AssignTeamMember that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AssignTeamMemberFindFirstArgs} args - Arguments to find a AssignTeamMember
     * @example
     * // Get one AssignTeamMember
     * const assignTeamMember = await prisma.assignTeamMember.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends AssignTeamMemberFindFirstArgs>(args?: SelectSubset<T, AssignTeamMemberFindFirstArgs<ExtArgs>>): Prisma__AssignTeamMemberClient<$Result.GetResult<Prisma.$AssignTeamMemberPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first AssignTeamMember that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AssignTeamMemberFindFirstOrThrowArgs} args - Arguments to find a AssignTeamMember
     * @example
     * // Get one AssignTeamMember
     * const assignTeamMember = await prisma.assignTeamMember.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends AssignTeamMemberFindFirstOrThrowArgs>(args?: SelectSubset<T, AssignTeamMemberFindFirstOrThrowArgs<ExtArgs>>): Prisma__AssignTeamMemberClient<$Result.GetResult<Prisma.$AssignTeamMemberPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more AssignTeamMembers that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AssignTeamMemberFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all AssignTeamMembers
     * const assignTeamMembers = await prisma.assignTeamMember.findMany()
     * 
     * // Get first 10 AssignTeamMembers
     * const assignTeamMembers = await prisma.assignTeamMember.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const assignTeamMemberWithIdOnly = await prisma.assignTeamMember.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends AssignTeamMemberFindManyArgs>(args?: SelectSubset<T, AssignTeamMemberFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AssignTeamMemberPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a AssignTeamMember.
     * @param {AssignTeamMemberCreateArgs} args - Arguments to create a AssignTeamMember.
     * @example
     * // Create one AssignTeamMember
     * const AssignTeamMember = await prisma.assignTeamMember.create({
     *   data: {
     *     // ... data to create a AssignTeamMember
     *   }
     * })
     * 
     */
    create<T extends AssignTeamMemberCreateArgs>(args: SelectSubset<T, AssignTeamMemberCreateArgs<ExtArgs>>): Prisma__AssignTeamMemberClient<$Result.GetResult<Prisma.$AssignTeamMemberPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many AssignTeamMembers.
     * @param {AssignTeamMemberCreateManyArgs} args - Arguments to create many AssignTeamMembers.
     * @example
     * // Create many AssignTeamMembers
     * const assignTeamMember = await prisma.assignTeamMember.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends AssignTeamMemberCreateManyArgs>(args?: SelectSubset<T, AssignTeamMemberCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many AssignTeamMembers and returns the data saved in the database.
     * @param {AssignTeamMemberCreateManyAndReturnArgs} args - Arguments to create many AssignTeamMembers.
     * @example
     * // Create many AssignTeamMembers
     * const assignTeamMember = await prisma.assignTeamMember.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many AssignTeamMembers and only return the `id`
     * const assignTeamMemberWithIdOnly = await prisma.assignTeamMember.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends AssignTeamMemberCreateManyAndReturnArgs>(args?: SelectSubset<T, AssignTeamMemberCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AssignTeamMemberPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a AssignTeamMember.
     * @param {AssignTeamMemberDeleteArgs} args - Arguments to delete one AssignTeamMember.
     * @example
     * // Delete one AssignTeamMember
     * const AssignTeamMember = await prisma.assignTeamMember.delete({
     *   where: {
     *     // ... filter to delete one AssignTeamMember
     *   }
     * })
     * 
     */
    delete<T extends AssignTeamMemberDeleteArgs>(args: SelectSubset<T, AssignTeamMemberDeleteArgs<ExtArgs>>): Prisma__AssignTeamMemberClient<$Result.GetResult<Prisma.$AssignTeamMemberPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one AssignTeamMember.
     * @param {AssignTeamMemberUpdateArgs} args - Arguments to update one AssignTeamMember.
     * @example
     * // Update one AssignTeamMember
     * const assignTeamMember = await prisma.assignTeamMember.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends AssignTeamMemberUpdateArgs>(args: SelectSubset<T, AssignTeamMemberUpdateArgs<ExtArgs>>): Prisma__AssignTeamMemberClient<$Result.GetResult<Prisma.$AssignTeamMemberPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more AssignTeamMembers.
     * @param {AssignTeamMemberDeleteManyArgs} args - Arguments to filter AssignTeamMembers to delete.
     * @example
     * // Delete a few AssignTeamMembers
     * const { count } = await prisma.assignTeamMember.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends AssignTeamMemberDeleteManyArgs>(args?: SelectSubset<T, AssignTeamMemberDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more AssignTeamMembers.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AssignTeamMemberUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many AssignTeamMembers
     * const assignTeamMember = await prisma.assignTeamMember.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends AssignTeamMemberUpdateManyArgs>(args: SelectSubset<T, AssignTeamMemberUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more AssignTeamMembers and returns the data updated in the database.
     * @param {AssignTeamMemberUpdateManyAndReturnArgs} args - Arguments to update many AssignTeamMembers.
     * @example
     * // Update many AssignTeamMembers
     * const assignTeamMember = await prisma.assignTeamMember.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more AssignTeamMembers and only return the `id`
     * const assignTeamMemberWithIdOnly = await prisma.assignTeamMember.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends AssignTeamMemberUpdateManyAndReturnArgs>(args: SelectSubset<T, AssignTeamMemberUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$AssignTeamMemberPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one AssignTeamMember.
     * @param {AssignTeamMemberUpsertArgs} args - Arguments to update or create a AssignTeamMember.
     * @example
     * // Update or create a AssignTeamMember
     * const assignTeamMember = await prisma.assignTeamMember.upsert({
     *   create: {
     *     // ... data to create a AssignTeamMember
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the AssignTeamMember we want to update
     *   }
     * })
     */
    upsert<T extends AssignTeamMemberUpsertArgs>(args: SelectSubset<T, AssignTeamMemberUpsertArgs<ExtArgs>>): Prisma__AssignTeamMemberClient<$Result.GetResult<Prisma.$AssignTeamMemberPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of AssignTeamMembers.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AssignTeamMemberCountArgs} args - Arguments to filter AssignTeamMembers to count.
     * @example
     * // Count the number of AssignTeamMembers
     * const count = await prisma.assignTeamMember.count({
     *   where: {
     *     // ... the filter for the AssignTeamMembers we want to count
     *   }
     * })
    **/
    count<T extends AssignTeamMemberCountArgs>(
      args?: Subset<T, AssignTeamMemberCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], AssignTeamMemberCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a AssignTeamMember.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AssignTeamMemberAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends AssignTeamMemberAggregateArgs>(args: Subset<T, AssignTeamMemberAggregateArgs>): Prisma.PrismaPromise<GetAssignTeamMemberAggregateType<T>>

    /**
     * Group by AssignTeamMember.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {AssignTeamMemberGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends AssignTeamMemberGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: AssignTeamMemberGroupByArgs['orderBy'] }
        : { orderBy?: AssignTeamMemberGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, AssignTeamMemberGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetAssignTeamMemberGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the AssignTeamMember model
   */
  readonly fields: AssignTeamMemberFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for AssignTeamMember.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__AssignTeamMemberClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    AssignOrg<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    AssignBY<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    CreatedBy<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    AssignedUser<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the AssignTeamMember model
   */ 
  interface AssignTeamMemberFieldRefs {
    readonly id: FieldRef<"AssignTeamMember", 'Int'>
    readonly organisation_id: FieldRef<"AssignTeamMember", 'Int'>
    readonly assign_to_id: FieldRef<"AssignTeamMember", 'Int'>
    readonly assign_by_id: FieldRef<"AssignTeamMember", 'Int'>
    readonly role_id: FieldRef<"AssignTeamMember", 'Int'>
    readonly assign_user: FieldRef<"AssignTeamMember", 'Int'>
    readonly created_at: FieldRef<"AssignTeamMember", 'DateTime'>
    readonly updated_at: FieldRef<"AssignTeamMember", 'DateTime'>
    readonly deleted_at: FieldRef<"AssignTeamMember", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * AssignTeamMember findUnique
   */
  export type AssignTeamMemberFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AssignTeamMember
     */
    select?: AssignTeamMemberSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AssignTeamMember
     */
    omit?: AssignTeamMemberOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AssignTeamMemberInclude<ExtArgs> | null
    /**
     * Filter, which AssignTeamMember to fetch.
     */
    where: AssignTeamMemberWhereUniqueInput
  }

  /**
   * AssignTeamMember findUniqueOrThrow
   */
  export type AssignTeamMemberFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AssignTeamMember
     */
    select?: AssignTeamMemberSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AssignTeamMember
     */
    omit?: AssignTeamMemberOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AssignTeamMemberInclude<ExtArgs> | null
    /**
     * Filter, which AssignTeamMember to fetch.
     */
    where: AssignTeamMemberWhereUniqueInput
  }

  /**
   * AssignTeamMember findFirst
   */
  export type AssignTeamMemberFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AssignTeamMember
     */
    select?: AssignTeamMemberSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AssignTeamMember
     */
    omit?: AssignTeamMemberOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AssignTeamMemberInclude<ExtArgs> | null
    /**
     * Filter, which AssignTeamMember to fetch.
     */
    where?: AssignTeamMemberWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of AssignTeamMembers to fetch.
     */
    orderBy?: AssignTeamMemberOrderByWithRelationInput | AssignTeamMemberOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for AssignTeamMembers.
     */
    cursor?: AssignTeamMemberWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` AssignTeamMembers from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` AssignTeamMembers.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of AssignTeamMembers.
     */
    distinct?: AssignTeamMemberScalarFieldEnum | AssignTeamMemberScalarFieldEnum[]
  }

  /**
   * AssignTeamMember findFirstOrThrow
   */
  export type AssignTeamMemberFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AssignTeamMember
     */
    select?: AssignTeamMemberSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AssignTeamMember
     */
    omit?: AssignTeamMemberOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AssignTeamMemberInclude<ExtArgs> | null
    /**
     * Filter, which AssignTeamMember to fetch.
     */
    where?: AssignTeamMemberWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of AssignTeamMembers to fetch.
     */
    orderBy?: AssignTeamMemberOrderByWithRelationInput | AssignTeamMemberOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for AssignTeamMembers.
     */
    cursor?: AssignTeamMemberWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` AssignTeamMembers from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` AssignTeamMembers.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of AssignTeamMembers.
     */
    distinct?: AssignTeamMemberScalarFieldEnum | AssignTeamMemberScalarFieldEnum[]
  }

  /**
   * AssignTeamMember findMany
   */
  export type AssignTeamMemberFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AssignTeamMember
     */
    select?: AssignTeamMemberSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AssignTeamMember
     */
    omit?: AssignTeamMemberOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AssignTeamMemberInclude<ExtArgs> | null
    /**
     * Filter, which AssignTeamMembers to fetch.
     */
    where?: AssignTeamMemberWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of AssignTeamMembers to fetch.
     */
    orderBy?: AssignTeamMemberOrderByWithRelationInput | AssignTeamMemberOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing AssignTeamMembers.
     */
    cursor?: AssignTeamMemberWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` AssignTeamMembers from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` AssignTeamMembers.
     */
    skip?: number
    distinct?: AssignTeamMemberScalarFieldEnum | AssignTeamMemberScalarFieldEnum[]
  }

  /**
   * AssignTeamMember create
   */
  export type AssignTeamMemberCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AssignTeamMember
     */
    select?: AssignTeamMemberSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AssignTeamMember
     */
    omit?: AssignTeamMemberOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AssignTeamMemberInclude<ExtArgs> | null
    /**
     * The data needed to create a AssignTeamMember.
     */
    data: XOR<AssignTeamMemberCreateInput, AssignTeamMemberUncheckedCreateInput>
  }

  /**
   * AssignTeamMember createMany
   */
  export type AssignTeamMemberCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many AssignTeamMembers.
     */
    data: AssignTeamMemberCreateManyInput | AssignTeamMemberCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * AssignTeamMember createManyAndReturn
   */
  export type AssignTeamMemberCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AssignTeamMember
     */
    select?: AssignTeamMemberSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the AssignTeamMember
     */
    omit?: AssignTeamMemberOmit<ExtArgs> | null
    /**
     * The data used to create many AssignTeamMembers.
     */
    data: AssignTeamMemberCreateManyInput | AssignTeamMemberCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AssignTeamMemberIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * AssignTeamMember update
   */
  export type AssignTeamMemberUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AssignTeamMember
     */
    select?: AssignTeamMemberSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AssignTeamMember
     */
    omit?: AssignTeamMemberOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AssignTeamMemberInclude<ExtArgs> | null
    /**
     * The data needed to update a AssignTeamMember.
     */
    data: XOR<AssignTeamMemberUpdateInput, AssignTeamMemberUncheckedUpdateInput>
    /**
     * Choose, which AssignTeamMember to update.
     */
    where: AssignTeamMemberWhereUniqueInput
  }

  /**
   * AssignTeamMember updateMany
   */
  export type AssignTeamMemberUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update AssignTeamMembers.
     */
    data: XOR<AssignTeamMemberUpdateManyMutationInput, AssignTeamMemberUncheckedUpdateManyInput>
    /**
     * Filter which AssignTeamMembers to update
     */
    where?: AssignTeamMemberWhereInput
    /**
     * Limit how many AssignTeamMembers to update.
     */
    limit?: number
  }

  /**
   * AssignTeamMember updateManyAndReturn
   */
  export type AssignTeamMemberUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AssignTeamMember
     */
    select?: AssignTeamMemberSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the AssignTeamMember
     */
    omit?: AssignTeamMemberOmit<ExtArgs> | null
    /**
     * The data used to update AssignTeamMembers.
     */
    data: XOR<AssignTeamMemberUpdateManyMutationInput, AssignTeamMemberUncheckedUpdateManyInput>
    /**
     * Filter which AssignTeamMembers to update
     */
    where?: AssignTeamMemberWhereInput
    /**
     * Limit how many AssignTeamMembers to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AssignTeamMemberIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * AssignTeamMember upsert
   */
  export type AssignTeamMemberUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AssignTeamMember
     */
    select?: AssignTeamMemberSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AssignTeamMember
     */
    omit?: AssignTeamMemberOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AssignTeamMemberInclude<ExtArgs> | null
    /**
     * The filter to search for the AssignTeamMember to update in case it exists.
     */
    where: AssignTeamMemberWhereUniqueInput
    /**
     * In case the AssignTeamMember found by the `where` argument doesn't exist, create a new AssignTeamMember with this data.
     */
    create: XOR<AssignTeamMemberCreateInput, AssignTeamMemberUncheckedCreateInput>
    /**
     * In case the AssignTeamMember was found with the provided `where` argument, update it with this data.
     */
    update: XOR<AssignTeamMemberUpdateInput, AssignTeamMemberUncheckedUpdateInput>
  }

  /**
   * AssignTeamMember delete
   */
  export type AssignTeamMemberDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AssignTeamMember
     */
    select?: AssignTeamMemberSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AssignTeamMember
     */
    omit?: AssignTeamMemberOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AssignTeamMemberInclude<ExtArgs> | null
    /**
     * Filter which AssignTeamMember to delete.
     */
    where: AssignTeamMemberWhereUniqueInput
  }

  /**
   * AssignTeamMember deleteMany
   */
  export type AssignTeamMemberDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which AssignTeamMembers to delete
     */
    where?: AssignTeamMemberWhereInput
    /**
     * Limit how many AssignTeamMembers to delete.
     */
    limit?: number
  }

  /**
   * AssignTeamMember without action
   */
  export type AssignTeamMemberDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the AssignTeamMember
     */
    select?: AssignTeamMemberSelect<ExtArgs> | null
    /**
     * Omit specific fields from the AssignTeamMember
     */
    omit?: AssignTeamMemberOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: AssignTeamMemberInclude<ExtArgs> | null
  }


  /**
   * Model TempLinks
   */

  export type AggregateTempLinks = {
    _count: TempLinksCountAggregateOutputType | null
    _avg: TempLinksAvgAggregateOutputType | null
    _sum: TempLinksSumAggregateOutputType | null
    _min: TempLinksMinAggregateOutputType | null
    _max: TempLinksMaxAggregateOutputType | null
  }

  export type TempLinksAvgAggregateOutputType = {
    id: number | null
    job_id: number | null
    userId: number | null
    project_id: number | null
    links_category_id: number | null
  }

  export type TempLinksSumAggregateOutputType = {
    id: number | null
    job_id: number | null
    userId: number | null
    project_id: number | null
    links_category_id: number | null
  }

  export type TempLinksMinAggregateOutputType = {
    id: number | null
    status: $Enums.LinkStatus | null
    job_id: number | null
    userId: number | null
    link_url: string | null
    project_id: number | null
    links_category_id: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type TempLinksMaxAggregateOutputType = {
    id: number | null
    status: $Enums.LinkStatus | null
    job_id: number | null
    userId: number | null
    link_url: string | null
    project_id: number | null
    links_category_id: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type TempLinksCountAggregateOutputType = {
    id: number
    status: number
    job_id: number
    userId: number
    link_url: number
    project_id: number
    links_category_id: number
    created_at: number
    updated_at: number
    deleted_at: number
    _all: number
  }


  export type TempLinksAvgAggregateInputType = {
    id?: true
    job_id?: true
    userId?: true
    project_id?: true
    links_category_id?: true
  }

  export type TempLinksSumAggregateInputType = {
    id?: true
    job_id?: true
    userId?: true
    project_id?: true
    links_category_id?: true
  }

  export type TempLinksMinAggregateInputType = {
    id?: true
    status?: true
    job_id?: true
    userId?: true
    link_url?: true
    project_id?: true
    links_category_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type TempLinksMaxAggregateInputType = {
    id?: true
    status?: true
    job_id?: true
    userId?: true
    link_url?: true
    project_id?: true
    links_category_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type TempLinksCountAggregateInputType = {
    id?: true
    status?: true
    job_id?: true
    userId?: true
    link_url?: true
    project_id?: true
    links_category_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    _all?: true
  }

  export type TempLinksAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which TempLinks to aggregate.
     */
    where?: TempLinksWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of TempLinks to fetch.
     */
    orderBy?: TempLinksOrderByWithRelationInput | TempLinksOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: TempLinksWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` TempLinks from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` TempLinks.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned TempLinks
    **/
    _count?: true | TempLinksCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: TempLinksAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: TempLinksSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: TempLinksMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: TempLinksMaxAggregateInputType
  }

  export type GetTempLinksAggregateType<T extends TempLinksAggregateArgs> = {
        [P in keyof T & keyof AggregateTempLinks]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateTempLinks[P]>
      : GetScalarType<T[P], AggregateTempLinks[P]>
  }




  export type TempLinksGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: TempLinksWhereInput
    orderBy?: TempLinksOrderByWithAggregationInput | TempLinksOrderByWithAggregationInput[]
    by: TempLinksScalarFieldEnum[] | TempLinksScalarFieldEnum
    having?: TempLinksScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: TempLinksCountAggregateInputType | true
    _avg?: TempLinksAvgAggregateInputType
    _sum?: TempLinksSumAggregateInputType
    _min?: TempLinksMinAggregateInputType
    _max?: TempLinksMaxAggregateInputType
  }

  export type TempLinksGroupByOutputType = {
    id: number
    status: $Enums.LinkStatus
    job_id: number
    userId: number
    link_url: string
    project_id: number
    links_category_id: number
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    _count: TempLinksCountAggregateOutputType | null
    _avg: TempLinksAvgAggregateOutputType | null
    _sum: TempLinksSumAggregateOutputType | null
    _min: TempLinksMinAggregateOutputType | null
    _max: TempLinksMaxAggregateOutputType | null
  }

  type GetTempLinksGroupByPayload<T extends TempLinksGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<TempLinksGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof TempLinksGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], TempLinksGroupByOutputType[P]>
            : GetScalarType<T[P], TempLinksGroupByOutputType[P]>
        }
      >
    >


  export type TempLinksSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    status?: boolean
    job_id?: boolean
    userId?: boolean
    link_url?: boolean
    project_id?: boolean
    links_category_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    LinksCategory?: boolean | GuideLinesDefaultArgs<ExtArgs>
    ProjectLinks?: boolean | ProjectDefaultArgs<ExtArgs>
    jobLinks?: boolean | UserJobsDefaultArgs<ExtArgs>
    UserLinks?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["tempLinks"]>

  export type TempLinksSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    status?: boolean
    job_id?: boolean
    userId?: boolean
    link_url?: boolean
    project_id?: boolean
    links_category_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    LinksCategory?: boolean | GuideLinesDefaultArgs<ExtArgs>
    ProjectLinks?: boolean | ProjectDefaultArgs<ExtArgs>
    jobLinks?: boolean | UserJobsDefaultArgs<ExtArgs>
    UserLinks?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["tempLinks"]>

  export type TempLinksSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    status?: boolean
    job_id?: boolean
    userId?: boolean
    link_url?: boolean
    project_id?: boolean
    links_category_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    LinksCategory?: boolean | GuideLinesDefaultArgs<ExtArgs>
    ProjectLinks?: boolean | ProjectDefaultArgs<ExtArgs>
    jobLinks?: boolean | UserJobsDefaultArgs<ExtArgs>
    UserLinks?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["tempLinks"]>

  export type TempLinksSelectScalar = {
    id?: boolean
    status?: boolean
    job_id?: boolean
    userId?: boolean
    link_url?: boolean
    project_id?: boolean
    links_category_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }

  export type TempLinksOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "status" | "job_id" | "userId" | "link_url" | "project_id" | "links_category_id" | "created_at" | "updated_at" | "deleted_at", ExtArgs["result"]["tempLinks"]>
  export type TempLinksInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    LinksCategory?: boolean | GuideLinesDefaultArgs<ExtArgs>
    ProjectLinks?: boolean | ProjectDefaultArgs<ExtArgs>
    jobLinks?: boolean | UserJobsDefaultArgs<ExtArgs>
    UserLinks?: boolean | UserDefaultArgs<ExtArgs>
  }
  export type TempLinksIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    LinksCategory?: boolean | GuideLinesDefaultArgs<ExtArgs>
    ProjectLinks?: boolean | ProjectDefaultArgs<ExtArgs>
    jobLinks?: boolean | UserJobsDefaultArgs<ExtArgs>
    UserLinks?: boolean | UserDefaultArgs<ExtArgs>
  }
  export type TempLinksIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    LinksCategory?: boolean | GuideLinesDefaultArgs<ExtArgs>
    ProjectLinks?: boolean | ProjectDefaultArgs<ExtArgs>
    jobLinks?: boolean | UserJobsDefaultArgs<ExtArgs>
    UserLinks?: boolean | UserDefaultArgs<ExtArgs>
  }

  export type $TempLinksPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "TempLinks"
    objects: {
      LinksCategory: Prisma.$GuideLinesPayload<ExtArgs>
      ProjectLinks: Prisma.$ProjectPayload<ExtArgs>
      jobLinks: Prisma.$UserJobsPayload<ExtArgs>
      UserLinks: Prisma.$UserPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      status: $Enums.LinkStatus
      job_id: number
      userId: number
      link_url: string
      project_id: number
      links_category_id: number
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
    }, ExtArgs["result"]["tempLinks"]>
    composites: {}
  }

  type TempLinksGetPayload<S extends boolean | null | undefined | TempLinksDefaultArgs> = $Result.GetResult<Prisma.$TempLinksPayload, S>

  type TempLinksCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<TempLinksFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: TempLinksCountAggregateInputType | true
    }

  export interface TempLinksDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['TempLinks'], meta: { name: 'TempLinks' } }
    /**
     * Find zero or one TempLinks that matches the filter.
     * @param {TempLinksFindUniqueArgs} args - Arguments to find a TempLinks
     * @example
     * // Get one TempLinks
     * const tempLinks = await prisma.tempLinks.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends TempLinksFindUniqueArgs>(args: SelectSubset<T, TempLinksFindUniqueArgs<ExtArgs>>): Prisma__TempLinksClient<$Result.GetResult<Prisma.$TempLinksPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one TempLinks that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {TempLinksFindUniqueOrThrowArgs} args - Arguments to find a TempLinks
     * @example
     * // Get one TempLinks
     * const tempLinks = await prisma.tempLinks.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends TempLinksFindUniqueOrThrowArgs>(args: SelectSubset<T, TempLinksFindUniqueOrThrowArgs<ExtArgs>>): Prisma__TempLinksClient<$Result.GetResult<Prisma.$TempLinksPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first TempLinks that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TempLinksFindFirstArgs} args - Arguments to find a TempLinks
     * @example
     * // Get one TempLinks
     * const tempLinks = await prisma.tempLinks.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends TempLinksFindFirstArgs>(args?: SelectSubset<T, TempLinksFindFirstArgs<ExtArgs>>): Prisma__TempLinksClient<$Result.GetResult<Prisma.$TempLinksPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first TempLinks that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TempLinksFindFirstOrThrowArgs} args - Arguments to find a TempLinks
     * @example
     * // Get one TempLinks
     * const tempLinks = await prisma.tempLinks.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends TempLinksFindFirstOrThrowArgs>(args?: SelectSubset<T, TempLinksFindFirstOrThrowArgs<ExtArgs>>): Prisma__TempLinksClient<$Result.GetResult<Prisma.$TempLinksPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more TempLinks that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TempLinksFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all TempLinks
     * const tempLinks = await prisma.tempLinks.findMany()
     * 
     * // Get first 10 TempLinks
     * const tempLinks = await prisma.tempLinks.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const tempLinksWithIdOnly = await prisma.tempLinks.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends TempLinksFindManyArgs>(args?: SelectSubset<T, TempLinksFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TempLinksPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a TempLinks.
     * @param {TempLinksCreateArgs} args - Arguments to create a TempLinks.
     * @example
     * // Create one TempLinks
     * const TempLinks = await prisma.tempLinks.create({
     *   data: {
     *     // ... data to create a TempLinks
     *   }
     * })
     * 
     */
    create<T extends TempLinksCreateArgs>(args: SelectSubset<T, TempLinksCreateArgs<ExtArgs>>): Prisma__TempLinksClient<$Result.GetResult<Prisma.$TempLinksPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many TempLinks.
     * @param {TempLinksCreateManyArgs} args - Arguments to create many TempLinks.
     * @example
     * // Create many TempLinks
     * const tempLinks = await prisma.tempLinks.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends TempLinksCreateManyArgs>(args?: SelectSubset<T, TempLinksCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many TempLinks and returns the data saved in the database.
     * @param {TempLinksCreateManyAndReturnArgs} args - Arguments to create many TempLinks.
     * @example
     * // Create many TempLinks
     * const tempLinks = await prisma.tempLinks.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many TempLinks and only return the `id`
     * const tempLinksWithIdOnly = await prisma.tempLinks.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends TempLinksCreateManyAndReturnArgs>(args?: SelectSubset<T, TempLinksCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TempLinksPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a TempLinks.
     * @param {TempLinksDeleteArgs} args - Arguments to delete one TempLinks.
     * @example
     * // Delete one TempLinks
     * const TempLinks = await prisma.tempLinks.delete({
     *   where: {
     *     // ... filter to delete one TempLinks
     *   }
     * })
     * 
     */
    delete<T extends TempLinksDeleteArgs>(args: SelectSubset<T, TempLinksDeleteArgs<ExtArgs>>): Prisma__TempLinksClient<$Result.GetResult<Prisma.$TempLinksPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one TempLinks.
     * @param {TempLinksUpdateArgs} args - Arguments to update one TempLinks.
     * @example
     * // Update one TempLinks
     * const tempLinks = await prisma.tempLinks.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends TempLinksUpdateArgs>(args: SelectSubset<T, TempLinksUpdateArgs<ExtArgs>>): Prisma__TempLinksClient<$Result.GetResult<Prisma.$TempLinksPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more TempLinks.
     * @param {TempLinksDeleteManyArgs} args - Arguments to filter TempLinks to delete.
     * @example
     * // Delete a few TempLinks
     * const { count } = await prisma.tempLinks.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends TempLinksDeleteManyArgs>(args?: SelectSubset<T, TempLinksDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more TempLinks.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TempLinksUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many TempLinks
     * const tempLinks = await prisma.tempLinks.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends TempLinksUpdateManyArgs>(args: SelectSubset<T, TempLinksUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more TempLinks and returns the data updated in the database.
     * @param {TempLinksUpdateManyAndReturnArgs} args - Arguments to update many TempLinks.
     * @example
     * // Update many TempLinks
     * const tempLinks = await prisma.tempLinks.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more TempLinks and only return the `id`
     * const tempLinksWithIdOnly = await prisma.tempLinks.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends TempLinksUpdateManyAndReturnArgs>(args: SelectSubset<T, TempLinksUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TempLinksPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one TempLinks.
     * @param {TempLinksUpsertArgs} args - Arguments to update or create a TempLinks.
     * @example
     * // Update or create a TempLinks
     * const tempLinks = await prisma.tempLinks.upsert({
     *   create: {
     *     // ... data to create a TempLinks
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the TempLinks we want to update
     *   }
     * })
     */
    upsert<T extends TempLinksUpsertArgs>(args: SelectSubset<T, TempLinksUpsertArgs<ExtArgs>>): Prisma__TempLinksClient<$Result.GetResult<Prisma.$TempLinksPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of TempLinks.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TempLinksCountArgs} args - Arguments to filter TempLinks to count.
     * @example
     * // Count the number of TempLinks
     * const count = await prisma.tempLinks.count({
     *   where: {
     *     // ... the filter for the TempLinks we want to count
     *   }
     * })
    **/
    count<T extends TempLinksCountArgs>(
      args?: Subset<T, TempLinksCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], TempLinksCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a TempLinks.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TempLinksAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends TempLinksAggregateArgs>(args: Subset<T, TempLinksAggregateArgs>): Prisma.PrismaPromise<GetTempLinksAggregateType<T>>

    /**
     * Group by TempLinks.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {TempLinksGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends TempLinksGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: TempLinksGroupByArgs['orderBy'] }
        : { orderBy?: TempLinksGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, TempLinksGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetTempLinksGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the TempLinks model
   */
  readonly fields: TempLinksFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for TempLinks.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__TempLinksClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    LinksCategory<T extends GuideLinesDefaultArgs<ExtArgs> = {}>(args?: Subset<T, GuideLinesDefaultArgs<ExtArgs>>): Prisma__GuideLinesClient<$Result.GetResult<Prisma.$GuideLinesPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    ProjectLinks<T extends ProjectDefaultArgs<ExtArgs> = {}>(args?: Subset<T, ProjectDefaultArgs<ExtArgs>>): Prisma__ProjectClient<$Result.GetResult<Prisma.$ProjectPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    jobLinks<T extends UserJobsDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserJobsDefaultArgs<ExtArgs>>): Prisma__UserJobsClient<$Result.GetResult<Prisma.$UserJobsPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    UserLinks<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the TempLinks model
   */ 
  interface TempLinksFieldRefs {
    readonly id: FieldRef<"TempLinks", 'Int'>
    readonly status: FieldRef<"TempLinks", 'LinkStatus'>
    readonly job_id: FieldRef<"TempLinks", 'Int'>
    readonly userId: FieldRef<"TempLinks", 'Int'>
    readonly link_url: FieldRef<"TempLinks", 'String'>
    readonly project_id: FieldRef<"TempLinks", 'Int'>
    readonly links_category_id: FieldRef<"TempLinks", 'Int'>
    readonly created_at: FieldRef<"TempLinks", 'DateTime'>
    readonly updated_at: FieldRef<"TempLinks", 'DateTime'>
    readonly deleted_at: FieldRef<"TempLinks", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * TempLinks findUnique
   */
  export type TempLinksFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TempLinks
     */
    select?: TempLinksSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TempLinks
     */
    omit?: TempLinksOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TempLinksInclude<ExtArgs> | null
    /**
     * Filter, which TempLinks to fetch.
     */
    where: TempLinksWhereUniqueInput
  }

  /**
   * TempLinks findUniqueOrThrow
   */
  export type TempLinksFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TempLinks
     */
    select?: TempLinksSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TempLinks
     */
    omit?: TempLinksOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TempLinksInclude<ExtArgs> | null
    /**
     * Filter, which TempLinks to fetch.
     */
    where: TempLinksWhereUniqueInput
  }

  /**
   * TempLinks findFirst
   */
  export type TempLinksFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TempLinks
     */
    select?: TempLinksSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TempLinks
     */
    omit?: TempLinksOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TempLinksInclude<ExtArgs> | null
    /**
     * Filter, which TempLinks to fetch.
     */
    where?: TempLinksWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of TempLinks to fetch.
     */
    orderBy?: TempLinksOrderByWithRelationInput | TempLinksOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for TempLinks.
     */
    cursor?: TempLinksWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` TempLinks from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` TempLinks.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of TempLinks.
     */
    distinct?: TempLinksScalarFieldEnum | TempLinksScalarFieldEnum[]
  }

  /**
   * TempLinks findFirstOrThrow
   */
  export type TempLinksFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TempLinks
     */
    select?: TempLinksSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TempLinks
     */
    omit?: TempLinksOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TempLinksInclude<ExtArgs> | null
    /**
     * Filter, which TempLinks to fetch.
     */
    where?: TempLinksWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of TempLinks to fetch.
     */
    orderBy?: TempLinksOrderByWithRelationInput | TempLinksOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for TempLinks.
     */
    cursor?: TempLinksWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` TempLinks from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` TempLinks.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of TempLinks.
     */
    distinct?: TempLinksScalarFieldEnum | TempLinksScalarFieldEnum[]
  }

  /**
   * TempLinks findMany
   */
  export type TempLinksFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TempLinks
     */
    select?: TempLinksSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TempLinks
     */
    omit?: TempLinksOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TempLinksInclude<ExtArgs> | null
    /**
     * Filter, which TempLinks to fetch.
     */
    where?: TempLinksWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of TempLinks to fetch.
     */
    orderBy?: TempLinksOrderByWithRelationInput | TempLinksOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing TempLinks.
     */
    cursor?: TempLinksWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` TempLinks from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` TempLinks.
     */
    skip?: number
    distinct?: TempLinksScalarFieldEnum | TempLinksScalarFieldEnum[]
  }

  /**
   * TempLinks create
   */
  export type TempLinksCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TempLinks
     */
    select?: TempLinksSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TempLinks
     */
    omit?: TempLinksOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TempLinksInclude<ExtArgs> | null
    /**
     * The data needed to create a TempLinks.
     */
    data: XOR<TempLinksCreateInput, TempLinksUncheckedCreateInput>
  }

  /**
   * TempLinks createMany
   */
  export type TempLinksCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many TempLinks.
     */
    data: TempLinksCreateManyInput | TempLinksCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * TempLinks createManyAndReturn
   */
  export type TempLinksCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TempLinks
     */
    select?: TempLinksSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the TempLinks
     */
    omit?: TempLinksOmit<ExtArgs> | null
    /**
     * The data used to create many TempLinks.
     */
    data: TempLinksCreateManyInput | TempLinksCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TempLinksIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * TempLinks update
   */
  export type TempLinksUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TempLinks
     */
    select?: TempLinksSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TempLinks
     */
    omit?: TempLinksOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TempLinksInclude<ExtArgs> | null
    /**
     * The data needed to update a TempLinks.
     */
    data: XOR<TempLinksUpdateInput, TempLinksUncheckedUpdateInput>
    /**
     * Choose, which TempLinks to update.
     */
    where: TempLinksWhereUniqueInput
  }

  /**
   * TempLinks updateMany
   */
  export type TempLinksUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update TempLinks.
     */
    data: XOR<TempLinksUpdateManyMutationInput, TempLinksUncheckedUpdateManyInput>
    /**
     * Filter which TempLinks to update
     */
    where?: TempLinksWhereInput
    /**
     * Limit how many TempLinks to update.
     */
    limit?: number
  }

  /**
   * TempLinks updateManyAndReturn
   */
  export type TempLinksUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TempLinks
     */
    select?: TempLinksSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the TempLinks
     */
    omit?: TempLinksOmit<ExtArgs> | null
    /**
     * The data used to update TempLinks.
     */
    data: XOR<TempLinksUpdateManyMutationInput, TempLinksUncheckedUpdateManyInput>
    /**
     * Filter which TempLinks to update
     */
    where?: TempLinksWhereInput
    /**
     * Limit how many TempLinks to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TempLinksIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * TempLinks upsert
   */
  export type TempLinksUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TempLinks
     */
    select?: TempLinksSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TempLinks
     */
    omit?: TempLinksOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TempLinksInclude<ExtArgs> | null
    /**
     * The filter to search for the TempLinks to update in case it exists.
     */
    where: TempLinksWhereUniqueInput
    /**
     * In case the TempLinks found by the `where` argument doesn't exist, create a new TempLinks with this data.
     */
    create: XOR<TempLinksCreateInput, TempLinksUncheckedCreateInput>
    /**
     * In case the TempLinks was found with the provided `where` argument, update it with this data.
     */
    update: XOR<TempLinksUpdateInput, TempLinksUncheckedUpdateInput>
  }

  /**
   * TempLinks delete
   */
  export type TempLinksDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TempLinks
     */
    select?: TempLinksSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TempLinks
     */
    omit?: TempLinksOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TempLinksInclude<ExtArgs> | null
    /**
     * Filter which TempLinks to delete.
     */
    where: TempLinksWhereUniqueInput
  }

  /**
   * TempLinks deleteMany
   */
  export type TempLinksDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which TempLinks to delete
     */
    where?: TempLinksWhereInput
    /**
     * Limit how many TempLinks to delete.
     */
    limit?: number
  }

  /**
   * TempLinks without action
   */
  export type TempLinksDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TempLinks
     */
    select?: TempLinksSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TempLinks
     */
    omit?: TempLinksOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TempLinksInclude<ExtArgs> | null
  }


  /**
   * Model UserJobs
   */

  export type AggregateUserJobs = {
    _count: UserJobsCountAggregateOutputType | null
    _avg: UserJobsAvgAggregateOutputType | null
    _sum: UserJobsSumAggregateOutputType | null
    _min: UserJobsMinAggregateOutputType | null
    _max: UserJobsMaxAggregateOutputType | null
  }

  export type UserJobsAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
    total_links: number | null
    project_id: number | null
    processing_status: number | null
    type: number | null
  }

  export type UserJobsSumAggregateOutputType = {
    id: number | null
    user_id: number | null
    total_links: number | null
    project_id: number | null
    processing_status: number | null
    type: number | null
  }

  export type UserJobsMinAggregateOutputType = {
    id: number | null
    status: $Enums.JobStatus | null
    name: string | null
    user_id: number | null
    total_links: number | null
    project_id: number | null
    created_at: Date | null
    updated_at: Date | null
    processing_status: number | null
    type: number | null
  }

  export type UserJobsMaxAggregateOutputType = {
    id: number | null
    status: $Enums.JobStatus | null
    name: string | null
    user_id: number | null
    total_links: number | null
    project_id: number | null
    created_at: Date | null
    updated_at: Date | null
    processing_status: number | null
    type: number | null
  }

  export type UserJobsCountAggregateOutputType = {
    id: number
    status: number
    name: number
    user_id: number
    total_links: number
    project_id: number
    created_at: number
    updated_at: number
    processing_status: number
    type: number
    _all: number
  }


  export type UserJobsAvgAggregateInputType = {
    id?: true
    user_id?: true
    total_links?: true
    project_id?: true
    processing_status?: true
    type?: true
  }

  export type UserJobsSumAggregateInputType = {
    id?: true
    user_id?: true
    total_links?: true
    project_id?: true
    processing_status?: true
    type?: true
  }

  export type UserJobsMinAggregateInputType = {
    id?: true
    status?: true
    name?: true
    user_id?: true
    total_links?: true
    project_id?: true
    created_at?: true
    updated_at?: true
    processing_status?: true
    type?: true
  }

  export type UserJobsMaxAggregateInputType = {
    id?: true
    status?: true
    name?: true
    user_id?: true
    total_links?: true
    project_id?: true
    created_at?: true
    updated_at?: true
    processing_status?: true
    type?: true
  }

  export type UserJobsCountAggregateInputType = {
    id?: true
    status?: true
    name?: true
    user_id?: true
    total_links?: true
    project_id?: true
    created_at?: true
    updated_at?: true
    processing_status?: true
    type?: true
    _all?: true
  }

  export type UserJobsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserJobs to aggregate.
     */
    where?: UserJobsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserJobs to fetch.
     */
    orderBy?: UserJobsOrderByWithRelationInput | UserJobsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UserJobsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserJobs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserJobs.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned UserJobs
    **/
    _count?: true | UserJobsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: UserJobsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: UserJobsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserJobsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserJobsMaxAggregateInputType
  }

  export type GetUserJobsAggregateType<T extends UserJobsAggregateArgs> = {
        [P in keyof T & keyof AggregateUserJobs]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUserJobs[P]>
      : GetScalarType<T[P], AggregateUserJobs[P]>
  }




  export type UserJobsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserJobsWhereInput
    orderBy?: UserJobsOrderByWithAggregationInput | UserJobsOrderByWithAggregationInput[]
    by: UserJobsScalarFieldEnum[] | UserJobsScalarFieldEnum
    having?: UserJobsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserJobsCountAggregateInputType | true
    _avg?: UserJobsAvgAggregateInputType
    _sum?: UserJobsSumAggregateInputType
    _min?: UserJobsMinAggregateInputType
    _max?: UserJobsMaxAggregateInputType
  }

  export type UserJobsGroupByOutputType = {
    id: number
    status: $Enums.JobStatus
    name: string | null
    user_id: number
    total_links: number
    project_id: number
    created_at: Date
    updated_at: Date
    processing_status: number
    type: number
    _count: UserJobsCountAggregateOutputType | null
    _avg: UserJobsAvgAggregateOutputType | null
    _sum: UserJobsSumAggregateOutputType | null
    _min: UserJobsMinAggregateOutputType | null
    _max: UserJobsMaxAggregateOutputType | null
  }

  type GetUserJobsGroupByPayload<T extends UserJobsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserJobsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserJobsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserJobsGroupByOutputType[P]>
            : GetScalarType<T[P], UserJobsGroupByOutputType[P]>
        }
      >
    >


  export type UserJobsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    status?: boolean
    name?: boolean
    user_id?: boolean
    total_links?: boolean
    project_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    processing_status?: boolean
    type?: boolean
    usersJobs?: boolean | UserDefaultArgs<ExtArgs>
    jobProjects?: boolean | ProjectDefaultArgs<ExtArgs>
    TempLinks?: boolean | UserJobs$TempLinksArgs<ExtArgs>
    Backlink?: boolean | UserJobs$BacklinkArgs<ExtArgs>
    _count?: boolean | UserJobsCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userJobs"]>

  export type UserJobsSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    status?: boolean
    name?: boolean
    user_id?: boolean
    total_links?: boolean
    project_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    processing_status?: boolean
    type?: boolean
    usersJobs?: boolean | UserDefaultArgs<ExtArgs>
    jobProjects?: boolean | ProjectDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userJobs"]>

  export type UserJobsSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    status?: boolean
    name?: boolean
    user_id?: boolean
    total_links?: boolean
    project_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    processing_status?: boolean
    type?: boolean
    usersJobs?: boolean | UserDefaultArgs<ExtArgs>
    jobProjects?: boolean | ProjectDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userJobs"]>

  export type UserJobsSelectScalar = {
    id?: boolean
    status?: boolean
    name?: boolean
    user_id?: boolean
    total_links?: boolean
    project_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    processing_status?: boolean
    type?: boolean
  }

  export type UserJobsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "status" | "name" | "user_id" | "total_links" | "project_id" | "created_at" | "updated_at" | "processing_status" | "type", ExtArgs["result"]["userJobs"]>
  export type UserJobsInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    usersJobs?: boolean | UserDefaultArgs<ExtArgs>
    jobProjects?: boolean | ProjectDefaultArgs<ExtArgs>
    TempLinks?: boolean | UserJobs$TempLinksArgs<ExtArgs>
    Backlink?: boolean | UserJobs$BacklinkArgs<ExtArgs>
    _count?: boolean | UserJobsCountOutputTypeDefaultArgs<ExtArgs>
  }
  export type UserJobsIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    usersJobs?: boolean | UserDefaultArgs<ExtArgs>
    jobProjects?: boolean | ProjectDefaultArgs<ExtArgs>
  }
  export type UserJobsIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    usersJobs?: boolean | UserDefaultArgs<ExtArgs>
    jobProjects?: boolean | ProjectDefaultArgs<ExtArgs>
  }

  export type $UserJobsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "UserJobs"
    objects: {
      usersJobs: Prisma.$UserPayload<ExtArgs>
      jobProjects: Prisma.$ProjectPayload<ExtArgs>
      TempLinks: Prisma.$TempLinksPayload<ExtArgs>[]
      Backlink: Prisma.$BacklinkPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      status: $Enums.JobStatus
      name: string | null
      user_id: number
      total_links: number
      project_id: number
      created_at: Date
      updated_at: Date
      processing_status: number
      type: number
    }, ExtArgs["result"]["userJobs"]>
    composites: {}
  }

  type UserJobsGetPayload<S extends boolean | null | undefined | UserJobsDefaultArgs> = $Result.GetResult<Prisma.$UserJobsPayload, S>

  type UserJobsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<UserJobsFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: UserJobsCountAggregateInputType | true
    }

  export interface UserJobsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['UserJobs'], meta: { name: 'UserJobs' } }
    /**
     * Find zero or one UserJobs that matches the filter.
     * @param {UserJobsFindUniqueArgs} args - Arguments to find a UserJobs
     * @example
     * // Get one UserJobs
     * const userJobs = await prisma.userJobs.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends UserJobsFindUniqueArgs>(args: SelectSubset<T, UserJobsFindUniqueArgs<ExtArgs>>): Prisma__UserJobsClient<$Result.GetResult<Prisma.$UserJobsPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one UserJobs that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {UserJobsFindUniqueOrThrowArgs} args - Arguments to find a UserJobs
     * @example
     * // Get one UserJobs
     * const userJobs = await prisma.userJobs.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends UserJobsFindUniqueOrThrowArgs>(args: SelectSubset<T, UserJobsFindUniqueOrThrowArgs<ExtArgs>>): Prisma__UserJobsClient<$Result.GetResult<Prisma.$UserJobsPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first UserJobs that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserJobsFindFirstArgs} args - Arguments to find a UserJobs
     * @example
     * // Get one UserJobs
     * const userJobs = await prisma.userJobs.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends UserJobsFindFirstArgs>(args?: SelectSubset<T, UserJobsFindFirstArgs<ExtArgs>>): Prisma__UserJobsClient<$Result.GetResult<Prisma.$UserJobsPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first UserJobs that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserJobsFindFirstOrThrowArgs} args - Arguments to find a UserJobs
     * @example
     * // Get one UserJobs
     * const userJobs = await prisma.userJobs.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends UserJobsFindFirstOrThrowArgs>(args?: SelectSubset<T, UserJobsFindFirstOrThrowArgs<ExtArgs>>): Prisma__UserJobsClient<$Result.GetResult<Prisma.$UserJobsPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more UserJobs that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserJobsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all UserJobs
     * const userJobs = await prisma.userJobs.findMany()
     * 
     * // Get first 10 UserJobs
     * const userJobs = await prisma.userJobs.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const userJobsWithIdOnly = await prisma.userJobs.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends UserJobsFindManyArgs>(args?: SelectSubset<T, UserJobsFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserJobsPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a UserJobs.
     * @param {UserJobsCreateArgs} args - Arguments to create a UserJobs.
     * @example
     * // Create one UserJobs
     * const UserJobs = await prisma.userJobs.create({
     *   data: {
     *     // ... data to create a UserJobs
     *   }
     * })
     * 
     */
    create<T extends UserJobsCreateArgs>(args: SelectSubset<T, UserJobsCreateArgs<ExtArgs>>): Prisma__UserJobsClient<$Result.GetResult<Prisma.$UserJobsPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many UserJobs.
     * @param {UserJobsCreateManyArgs} args - Arguments to create many UserJobs.
     * @example
     * // Create many UserJobs
     * const userJobs = await prisma.userJobs.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends UserJobsCreateManyArgs>(args?: SelectSubset<T, UserJobsCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many UserJobs and returns the data saved in the database.
     * @param {UserJobsCreateManyAndReturnArgs} args - Arguments to create many UserJobs.
     * @example
     * // Create many UserJobs
     * const userJobs = await prisma.userJobs.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many UserJobs and only return the `id`
     * const userJobsWithIdOnly = await prisma.userJobs.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends UserJobsCreateManyAndReturnArgs>(args?: SelectSubset<T, UserJobsCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserJobsPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a UserJobs.
     * @param {UserJobsDeleteArgs} args - Arguments to delete one UserJobs.
     * @example
     * // Delete one UserJobs
     * const UserJobs = await prisma.userJobs.delete({
     *   where: {
     *     // ... filter to delete one UserJobs
     *   }
     * })
     * 
     */
    delete<T extends UserJobsDeleteArgs>(args: SelectSubset<T, UserJobsDeleteArgs<ExtArgs>>): Prisma__UserJobsClient<$Result.GetResult<Prisma.$UserJobsPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one UserJobs.
     * @param {UserJobsUpdateArgs} args - Arguments to update one UserJobs.
     * @example
     * // Update one UserJobs
     * const userJobs = await prisma.userJobs.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends UserJobsUpdateArgs>(args: SelectSubset<T, UserJobsUpdateArgs<ExtArgs>>): Prisma__UserJobsClient<$Result.GetResult<Prisma.$UserJobsPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more UserJobs.
     * @param {UserJobsDeleteManyArgs} args - Arguments to filter UserJobs to delete.
     * @example
     * // Delete a few UserJobs
     * const { count } = await prisma.userJobs.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends UserJobsDeleteManyArgs>(args?: SelectSubset<T, UserJobsDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more UserJobs.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserJobsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many UserJobs
     * const userJobs = await prisma.userJobs.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends UserJobsUpdateManyArgs>(args: SelectSubset<T, UserJobsUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more UserJobs and returns the data updated in the database.
     * @param {UserJobsUpdateManyAndReturnArgs} args - Arguments to update many UserJobs.
     * @example
     * // Update many UserJobs
     * const userJobs = await prisma.userJobs.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more UserJobs and only return the `id`
     * const userJobsWithIdOnly = await prisma.userJobs.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends UserJobsUpdateManyAndReturnArgs>(args: SelectSubset<T, UserJobsUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserJobsPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one UserJobs.
     * @param {UserJobsUpsertArgs} args - Arguments to update or create a UserJobs.
     * @example
     * // Update or create a UserJobs
     * const userJobs = await prisma.userJobs.upsert({
     *   create: {
     *     // ... data to create a UserJobs
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the UserJobs we want to update
     *   }
     * })
     */
    upsert<T extends UserJobsUpsertArgs>(args: SelectSubset<T, UserJobsUpsertArgs<ExtArgs>>): Prisma__UserJobsClient<$Result.GetResult<Prisma.$UserJobsPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of UserJobs.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserJobsCountArgs} args - Arguments to filter UserJobs to count.
     * @example
     * // Count the number of UserJobs
     * const count = await prisma.userJobs.count({
     *   where: {
     *     // ... the filter for the UserJobs we want to count
     *   }
     * })
    **/
    count<T extends UserJobsCountArgs>(
      args?: Subset<T, UserJobsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserJobsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a UserJobs.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserJobsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserJobsAggregateArgs>(args: Subset<T, UserJobsAggregateArgs>): Prisma.PrismaPromise<GetUserJobsAggregateType<T>>

    /**
     * Group by UserJobs.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserJobsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UserJobsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UserJobsGroupByArgs['orderBy'] }
        : { orderBy?: UserJobsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UserJobsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserJobsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the UserJobs model
   */
  readonly fields: UserJobsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for UserJobs.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__UserJobsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    usersJobs<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    jobProjects<T extends ProjectDefaultArgs<ExtArgs> = {}>(args?: Subset<T, ProjectDefaultArgs<ExtArgs>>): Prisma__ProjectClient<$Result.GetResult<Prisma.$ProjectPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    TempLinks<T extends UserJobs$TempLinksArgs<ExtArgs> = {}>(args?: Subset<T, UserJobs$TempLinksArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TempLinksPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    Backlink<T extends UserJobs$BacklinkArgs<ExtArgs> = {}>(args?: Subset<T, UserJobs$BacklinkArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the UserJobs model
   */ 
  interface UserJobsFieldRefs {
    readonly id: FieldRef<"UserJobs", 'Int'>
    readonly status: FieldRef<"UserJobs", 'JobStatus'>
    readonly name: FieldRef<"UserJobs", 'String'>
    readonly user_id: FieldRef<"UserJobs", 'Int'>
    readonly total_links: FieldRef<"UserJobs", 'Int'>
    readonly project_id: FieldRef<"UserJobs", 'Int'>
    readonly created_at: FieldRef<"UserJobs", 'DateTime'>
    readonly updated_at: FieldRef<"UserJobs", 'DateTime'>
    readonly processing_status: FieldRef<"UserJobs", 'Int'>
    readonly type: FieldRef<"UserJobs", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * UserJobs findUnique
   */
  export type UserJobsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserJobs
     */
    select?: UserJobsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserJobs
     */
    omit?: UserJobsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserJobsInclude<ExtArgs> | null
    /**
     * Filter, which UserJobs to fetch.
     */
    where: UserJobsWhereUniqueInput
  }

  /**
   * UserJobs findUniqueOrThrow
   */
  export type UserJobsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserJobs
     */
    select?: UserJobsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserJobs
     */
    omit?: UserJobsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserJobsInclude<ExtArgs> | null
    /**
     * Filter, which UserJobs to fetch.
     */
    where: UserJobsWhereUniqueInput
  }

  /**
   * UserJobs findFirst
   */
  export type UserJobsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserJobs
     */
    select?: UserJobsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserJobs
     */
    omit?: UserJobsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserJobsInclude<ExtArgs> | null
    /**
     * Filter, which UserJobs to fetch.
     */
    where?: UserJobsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserJobs to fetch.
     */
    orderBy?: UserJobsOrderByWithRelationInput | UserJobsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserJobs.
     */
    cursor?: UserJobsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserJobs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserJobs.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserJobs.
     */
    distinct?: UserJobsScalarFieldEnum | UserJobsScalarFieldEnum[]
  }

  /**
   * UserJobs findFirstOrThrow
   */
  export type UserJobsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserJobs
     */
    select?: UserJobsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserJobs
     */
    omit?: UserJobsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserJobsInclude<ExtArgs> | null
    /**
     * Filter, which UserJobs to fetch.
     */
    where?: UserJobsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserJobs to fetch.
     */
    orderBy?: UserJobsOrderByWithRelationInput | UserJobsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserJobs.
     */
    cursor?: UserJobsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserJobs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserJobs.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserJobs.
     */
    distinct?: UserJobsScalarFieldEnum | UserJobsScalarFieldEnum[]
  }

  /**
   * UserJobs findMany
   */
  export type UserJobsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserJobs
     */
    select?: UserJobsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserJobs
     */
    omit?: UserJobsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserJobsInclude<ExtArgs> | null
    /**
     * Filter, which UserJobs to fetch.
     */
    where?: UserJobsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserJobs to fetch.
     */
    orderBy?: UserJobsOrderByWithRelationInput | UserJobsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing UserJobs.
     */
    cursor?: UserJobsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserJobs from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserJobs.
     */
    skip?: number
    distinct?: UserJobsScalarFieldEnum | UserJobsScalarFieldEnum[]
  }

  /**
   * UserJobs create
   */
  export type UserJobsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserJobs
     */
    select?: UserJobsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserJobs
     */
    omit?: UserJobsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserJobsInclude<ExtArgs> | null
    /**
     * The data needed to create a UserJobs.
     */
    data: XOR<UserJobsCreateInput, UserJobsUncheckedCreateInput>
  }

  /**
   * UserJobs createMany
   */
  export type UserJobsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many UserJobs.
     */
    data: UserJobsCreateManyInput | UserJobsCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * UserJobs createManyAndReturn
   */
  export type UserJobsCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserJobs
     */
    select?: UserJobsSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the UserJobs
     */
    omit?: UserJobsOmit<ExtArgs> | null
    /**
     * The data used to create many UserJobs.
     */
    data: UserJobsCreateManyInput | UserJobsCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserJobsIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * UserJobs update
   */
  export type UserJobsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserJobs
     */
    select?: UserJobsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserJobs
     */
    omit?: UserJobsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserJobsInclude<ExtArgs> | null
    /**
     * The data needed to update a UserJobs.
     */
    data: XOR<UserJobsUpdateInput, UserJobsUncheckedUpdateInput>
    /**
     * Choose, which UserJobs to update.
     */
    where: UserJobsWhereUniqueInput
  }

  /**
   * UserJobs updateMany
   */
  export type UserJobsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update UserJobs.
     */
    data: XOR<UserJobsUpdateManyMutationInput, UserJobsUncheckedUpdateManyInput>
    /**
     * Filter which UserJobs to update
     */
    where?: UserJobsWhereInput
    /**
     * Limit how many UserJobs to update.
     */
    limit?: number
  }

  /**
   * UserJobs updateManyAndReturn
   */
  export type UserJobsUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserJobs
     */
    select?: UserJobsSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the UserJobs
     */
    omit?: UserJobsOmit<ExtArgs> | null
    /**
     * The data used to update UserJobs.
     */
    data: XOR<UserJobsUpdateManyMutationInput, UserJobsUncheckedUpdateManyInput>
    /**
     * Filter which UserJobs to update
     */
    where?: UserJobsWhereInput
    /**
     * Limit how many UserJobs to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserJobsIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * UserJobs upsert
   */
  export type UserJobsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserJobs
     */
    select?: UserJobsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserJobs
     */
    omit?: UserJobsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserJobsInclude<ExtArgs> | null
    /**
     * The filter to search for the UserJobs to update in case it exists.
     */
    where: UserJobsWhereUniqueInput
    /**
     * In case the UserJobs found by the `where` argument doesn't exist, create a new UserJobs with this data.
     */
    create: XOR<UserJobsCreateInput, UserJobsUncheckedCreateInput>
    /**
     * In case the UserJobs was found with the provided `where` argument, update it with this data.
     */
    update: XOR<UserJobsUpdateInput, UserJobsUncheckedUpdateInput>
  }

  /**
   * UserJobs delete
   */
  export type UserJobsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserJobs
     */
    select?: UserJobsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserJobs
     */
    omit?: UserJobsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserJobsInclude<ExtArgs> | null
    /**
     * Filter which UserJobs to delete.
     */
    where: UserJobsWhereUniqueInput
  }

  /**
   * UserJobs deleteMany
   */
  export type UserJobsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserJobs to delete
     */
    where?: UserJobsWhereInput
    /**
     * Limit how many UserJobs to delete.
     */
    limit?: number
  }

  /**
   * UserJobs.TempLinks
   */
  export type UserJobs$TempLinksArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TempLinks
     */
    select?: TempLinksSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TempLinks
     */
    omit?: TempLinksOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TempLinksInclude<ExtArgs> | null
    where?: TempLinksWhereInput
    orderBy?: TempLinksOrderByWithRelationInput | TempLinksOrderByWithRelationInput[]
    cursor?: TempLinksWhereUniqueInput
    take?: number
    skip?: number
    distinct?: TempLinksScalarFieldEnum | TempLinksScalarFieldEnum[]
  }

  /**
   * UserJobs.Backlink
   */
  export type UserJobs$BacklinkArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    where?: BacklinkWhereInput
    orderBy?: BacklinkOrderByWithRelationInput | BacklinkOrderByWithRelationInput[]
    cursor?: BacklinkWhereUniqueInput
    take?: number
    skip?: number
    distinct?: BacklinkScalarFieldEnum | BacklinkScalarFieldEnum[]
  }

  /**
   * UserJobs without action
   */
  export type UserJobsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserJobs
     */
    select?: UserJobsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the UserJobs
     */
    omit?: UserJobsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserJobsInclude<ExtArgs> | null
  }


  /**
   * Model ProjectDetails
   */

  export type AggregateProjectDetails = {
    _count: ProjectDetailsCountAggregateOutputType | null
    _avg: ProjectDetailsAvgAggregateOutputType | null
    _sum: ProjectDetailsSumAggregateOutputType | null
    _min: ProjectDetailsMinAggregateOutputType | null
    _max: ProjectDetailsMaxAggregateOutputType | null
  }

  export type ProjectDetailsAvgAggregateOutputType = {
    id: number | null
    project_id: number | null
    seo_package_id: number | null
  }

  export type ProjectDetailsSumAggregateOutputType = {
    id: number | null
    project_id: number | null
    seo_package_id: number | null
  }

  export type ProjectDetailsMinAggregateOutputType = {
    id: number | null
    project_id: number | null
    seo_package_id: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type ProjectDetailsMaxAggregateOutputType = {
    id: number | null
    project_id: number | null
    seo_package_id: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type ProjectDetailsCountAggregateOutputType = {
    id: number
    project_id: number
    seo_package_id: number
    created_at: number
    updated_at: number
    deleted_at: number
    _all: number
  }


  export type ProjectDetailsAvgAggregateInputType = {
    id?: true
    project_id?: true
    seo_package_id?: true
  }

  export type ProjectDetailsSumAggregateInputType = {
    id?: true
    project_id?: true
    seo_package_id?: true
  }

  export type ProjectDetailsMinAggregateInputType = {
    id?: true
    project_id?: true
    seo_package_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type ProjectDetailsMaxAggregateInputType = {
    id?: true
    project_id?: true
    seo_package_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type ProjectDetailsCountAggregateInputType = {
    id?: true
    project_id?: true
    seo_package_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    _all?: true
  }

  export type ProjectDetailsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ProjectDetails to aggregate.
     */
    where?: ProjectDetailsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProjectDetails to fetch.
     */
    orderBy?: ProjectDetailsOrderByWithRelationInput | ProjectDetailsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ProjectDetailsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProjectDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProjectDetails.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ProjectDetails
    **/
    _count?: true | ProjectDetailsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ProjectDetailsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ProjectDetailsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ProjectDetailsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ProjectDetailsMaxAggregateInputType
  }

  export type GetProjectDetailsAggregateType<T extends ProjectDetailsAggregateArgs> = {
        [P in keyof T & keyof AggregateProjectDetails]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateProjectDetails[P]>
      : GetScalarType<T[P], AggregateProjectDetails[P]>
  }




  export type ProjectDetailsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProjectDetailsWhereInput
    orderBy?: ProjectDetailsOrderByWithAggregationInput | ProjectDetailsOrderByWithAggregationInput[]
    by: ProjectDetailsScalarFieldEnum[] | ProjectDetailsScalarFieldEnum
    having?: ProjectDetailsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ProjectDetailsCountAggregateInputType | true
    _avg?: ProjectDetailsAvgAggregateInputType
    _sum?: ProjectDetailsSumAggregateInputType
    _min?: ProjectDetailsMinAggregateInputType
    _max?: ProjectDetailsMaxAggregateInputType
  }

  export type ProjectDetailsGroupByOutputType = {
    id: number
    project_id: number
    seo_package_id: number
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    _count: ProjectDetailsCountAggregateOutputType | null
    _avg: ProjectDetailsAvgAggregateOutputType | null
    _sum: ProjectDetailsSumAggregateOutputType | null
    _min: ProjectDetailsMinAggregateOutputType | null
    _max: ProjectDetailsMaxAggregateOutputType | null
  }

  type GetProjectDetailsGroupByPayload<T extends ProjectDetailsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ProjectDetailsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ProjectDetailsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ProjectDetailsGroupByOutputType[P]>
            : GetScalarType<T[P], ProjectDetailsGroupByOutputType[P]>
        }
      >
    >


  export type ProjectDetailsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    project_id?: boolean
    seo_package_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    detailsProject?: boolean | ProjectDefaultArgs<ExtArgs>
    ProjectSeoPackage?: boolean | ProjectDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["projectDetails"]>

  export type ProjectDetailsSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    project_id?: boolean
    seo_package_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    detailsProject?: boolean | ProjectDefaultArgs<ExtArgs>
    ProjectSeoPackage?: boolean | ProjectDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["projectDetails"]>

  export type ProjectDetailsSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    project_id?: boolean
    seo_package_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    detailsProject?: boolean | ProjectDefaultArgs<ExtArgs>
    ProjectSeoPackage?: boolean | ProjectDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["projectDetails"]>

  export type ProjectDetailsSelectScalar = {
    id?: boolean
    project_id?: boolean
    seo_package_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }

  export type ProjectDetailsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "project_id" | "seo_package_id" | "created_at" | "updated_at" | "deleted_at", ExtArgs["result"]["projectDetails"]>
  export type ProjectDetailsInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    detailsProject?: boolean | ProjectDefaultArgs<ExtArgs>
    ProjectSeoPackage?: boolean | ProjectDefaultArgs<ExtArgs>
  }
  export type ProjectDetailsIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    detailsProject?: boolean | ProjectDefaultArgs<ExtArgs>
    ProjectSeoPackage?: boolean | ProjectDefaultArgs<ExtArgs>
  }
  export type ProjectDetailsIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    detailsProject?: boolean | ProjectDefaultArgs<ExtArgs>
    ProjectSeoPackage?: boolean | ProjectDefaultArgs<ExtArgs>
  }

  export type $ProjectDetailsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "ProjectDetails"
    objects: {
      detailsProject: Prisma.$ProjectPayload<ExtArgs>
      ProjectSeoPackage: Prisma.$ProjectPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      project_id: number
      seo_package_id: number
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
    }, ExtArgs["result"]["projectDetails"]>
    composites: {}
  }

  type ProjectDetailsGetPayload<S extends boolean | null | undefined | ProjectDetailsDefaultArgs> = $Result.GetResult<Prisma.$ProjectDetailsPayload, S>

  type ProjectDetailsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<ProjectDetailsFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: ProjectDetailsCountAggregateInputType | true
    }

  export interface ProjectDetailsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['ProjectDetails'], meta: { name: 'ProjectDetails' } }
    /**
     * Find zero or one ProjectDetails that matches the filter.
     * @param {ProjectDetailsFindUniqueArgs} args - Arguments to find a ProjectDetails
     * @example
     * // Get one ProjectDetails
     * const projectDetails = await prisma.projectDetails.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ProjectDetailsFindUniqueArgs>(args: SelectSubset<T, ProjectDetailsFindUniqueArgs<ExtArgs>>): Prisma__ProjectDetailsClient<$Result.GetResult<Prisma.$ProjectDetailsPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one ProjectDetails that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {ProjectDetailsFindUniqueOrThrowArgs} args - Arguments to find a ProjectDetails
     * @example
     * // Get one ProjectDetails
     * const projectDetails = await prisma.projectDetails.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ProjectDetailsFindUniqueOrThrowArgs>(args: SelectSubset<T, ProjectDetailsFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ProjectDetailsClient<$Result.GetResult<Prisma.$ProjectDetailsPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first ProjectDetails that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectDetailsFindFirstArgs} args - Arguments to find a ProjectDetails
     * @example
     * // Get one ProjectDetails
     * const projectDetails = await prisma.projectDetails.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ProjectDetailsFindFirstArgs>(args?: SelectSubset<T, ProjectDetailsFindFirstArgs<ExtArgs>>): Prisma__ProjectDetailsClient<$Result.GetResult<Prisma.$ProjectDetailsPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first ProjectDetails that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectDetailsFindFirstOrThrowArgs} args - Arguments to find a ProjectDetails
     * @example
     * // Get one ProjectDetails
     * const projectDetails = await prisma.projectDetails.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ProjectDetailsFindFirstOrThrowArgs>(args?: SelectSubset<T, ProjectDetailsFindFirstOrThrowArgs<ExtArgs>>): Prisma__ProjectDetailsClient<$Result.GetResult<Prisma.$ProjectDetailsPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more ProjectDetails that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectDetailsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all ProjectDetails
     * const projectDetails = await prisma.projectDetails.findMany()
     * 
     * // Get first 10 ProjectDetails
     * const projectDetails = await prisma.projectDetails.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const projectDetailsWithIdOnly = await prisma.projectDetails.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ProjectDetailsFindManyArgs>(args?: SelectSubset<T, ProjectDetailsFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectDetailsPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a ProjectDetails.
     * @param {ProjectDetailsCreateArgs} args - Arguments to create a ProjectDetails.
     * @example
     * // Create one ProjectDetails
     * const ProjectDetails = await prisma.projectDetails.create({
     *   data: {
     *     // ... data to create a ProjectDetails
     *   }
     * })
     * 
     */
    create<T extends ProjectDetailsCreateArgs>(args: SelectSubset<T, ProjectDetailsCreateArgs<ExtArgs>>): Prisma__ProjectDetailsClient<$Result.GetResult<Prisma.$ProjectDetailsPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many ProjectDetails.
     * @param {ProjectDetailsCreateManyArgs} args - Arguments to create many ProjectDetails.
     * @example
     * // Create many ProjectDetails
     * const projectDetails = await prisma.projectDetails.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ProjectDetailsCreateManyArgs>(args?: SelectSubset<T, ProjectDetailsCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many ProjectDetails and returns the data saved in the database.
     * @param {ProjectDetailsCreateManyAndReturnArgs} args - Arguments to create many ProjectDetails.
     * @example
     * // Create many ProjectDetails
     * const projectDetails = await prisma.projectDetails.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many ProjectDetails and only return the `id`
     * const projectDetailsWithIdOnly = await prisma.projectDetails.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends ProjectDetailsCreateManyAndReturnArgs>(args?: SelectSubset<T, ProjectDetailsCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectDetailsPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a ProjectDetails.
     * @param {ProjectDetailsDeleteArgs} args - Arguments to delete one ProjectDetails.
     * @example
     * // Delete one ProjectDetails
     * const ProjectDetails = await prisma.projectDetails.delete({
     *   where: {
     *     // ... filter to delete one ProjectDetails
     *   }
     * })
     * 
     */
    delete<T extends ProjectDetailsDeleteArgs>(args: SelectSubset<T, ProjectDetailsDeleteArgs<ExtArgs>>): Prisma__ProjectDetailsClient<$Result.GetResult<Prisma.$ProjectDetailsPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one ProjectDetails.
     * @param {ProjectDetailsUpdateArgs} args - Arguments to update one ProjectDetails.
     * @example
     * // Update one ProjectDetails
     * const projectDetails = await prisma.projectDetails.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ProjectDetailsUpdateArgs>(args: SelectSubset<T, ProjectDetailsUpdateArgs<ExtArgs>>): Prisma__ProjectDetailsClient<$Result.GetResult<Prisma.$ProjectDetailsPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more ProjectDetails.
     * @param {ProjectDetailsDeleteManyArgs} args - Arguments to filter ProjectDetails to delete.
     * @example
     * // Delete a few ProjectDetails
     * const { count } = await prisma.projectDetails.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ProjectDetailsDeleteManyArgs>(args?: SelectSubset<T, ProjectDetailsDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ProjectDetails.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectDetailsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many ProjectDetails
     * const projectDetails = await prisma.projectDetails.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ProjectDetailsUpdateManyArgs>(args: SelectSubset<T, ProjectDetailsUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ProjectDetails and returns the data updated in the database.
     * @param {ProjectDetailsUpdateManyAndReturnArgs} args - Arguments to update many ProjectDetails.
     * @example
     * // Update many ProjectDetails
     * const projectDetails = await prisma.projectDetails.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more ProjectDetails and only return the `id`
     * const projectDetailsWithIdOnly = await prisma.projectDetails.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends ProjectDetailsUpdateManyAndReturnArgs>(args: SelectSubset<T, ProjectDetailsUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectDetailsPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one ProjectDetails.
     * @param {ProjectDetailsUpsertArgs} args - Arguments to update or create a ProjectDetails.
     * @example
     * // Update or create a ProjectDetails
     * const projectDetails = await prisma.projectDetails.upsert({
     *   create: {
     *     // ... data to create a ProjectDetails
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the ProjectDetails we want to update
     *   }
     * })
     */
    upsert<T extends ProjectDetailsUpsertArgs>(args: SelectSubset<T, ProjectDetailsUpsertArgs<ExtArgs>>): Prisma__ProjectDetailsClient<$Result.GetResult<Prisma.$ProjectDetailsPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of ProjectDetails.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectDetailsCountArgs} args - Arguments to filter ProjectDetails to count.
     * @example
     * // Count the number of ProjectDetails
     * const count = await prisma.projectDetails.count({
     *   where: {
     *     // ... the filter for the ProjectDetails we want to count
     *   }
     * })
    **/
    count<T extends ProjectDetailsCountArgs>(
      args?: Subset<T, ProjectDetailsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ProjectDetailsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a ProjectDetails.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectDetailsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ProjectDetailsAggregateArgs>(args: Subset<T, ProjectDetailsAggregateArgs>): Prisma.PrismaPromise<GetProjectDetailsAggregateType<T>>

    /**
     * Group by ProjectDetails.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectDetailsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ProjectDetailsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ProjectDetailsGroupByArgs['orderBy'] }
        : { orderBy?: ProjectDetailsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ProjectDetailsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetProjectDetailsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the ProjectDetails model
   */
  readonly fields: ProjectDetailsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for ProjectDetails.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ProjectDetailsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    detailsProject<T extends ProjectDefaultArgs<ExtArgs> = {}>(args?: Subset<T, ProjectDefaultArgs<ExtArgs>>): Prisma__ProjectClient<$Result.GetResult<Prisma.$ProjectPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    ProjectSeoPackage<T extends ProjectDefaultArgs<ExtArgs> = {}>(args?: Subset<T, ProjectDefaultArgs<ExtArgs>>): Prisma__ProjectClient<$Result.GetResult<Prisma.$ProjectPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the ProjectDetails model
   */ 
  interface ProjectDetailsFieldRefs {
    readonly id: FieldRef<"ProjectDetails", 'Int'>
    readonly project_id: FieldRef<"ProjectDetails", 'Int'>
    readonly seo_package_id: FieldRef<"ProjectDetails", 'Int'>
    readonly created_at: FieldRef<"ProjectDetails", 'DateTime'>
    readonly updated_at: FieldRef<"ProjectDetails", 'DateTime'>
    readonly deleted_at: FieldRef<"ProjectDetails", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * ProjectDetails findUnique
   */
  export type ProjectDetailsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectDetails
     */
    select?: ProjectDetailsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectDetails
     */
    omit?: ProjectDetailsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectDetailsInclude<ExtArgs> | null
    /**
     * Filter, which ProjectDetails to fetch.
     */
    where: ProjectDetailsWhereUniqueInput
  }

  /**
   * ProjectDetails findUniqueOrThrow
   */
  export type ProjectDetailsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectDetails
     */
    select?: ProjectDetailsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectDetails
     */
    omit?: ProjectDetailsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectDetailsInclude<ExtArgs> | null
    /**
     * Filter, which ProjectDetails to fetch.
     */
    where: ProjectDetailsWhereUniqueInput
  }

  /**
   * ProjectDetails findFirst
   */
  export type ProjectDetailsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectDetails
     */
    select?: ProjectDetailsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectDetails
     */
    omit?: ProjectDetailsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectDetailsInclude<ExtArgs> | null
    /**
     * Filter, which ProjectDetails to fetch.
     */
    where?: ProjectDetailsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProjectDetails to fetch.
     */
    orderBy?: ProjectDetailsOrderByWithRelationInput | ProjectDetailsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ProjectDetails.
     */
    cursor?: ProjectDetailsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProjectDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProjectDetails.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ProjectDetails.
     */
    distinct?: ProjectDetailsScalarFieldEnum | ProjectDetailsScalarFieldEnum[]
  }

  /**
   * ProjectDetails findFirstOrThrow
   */
  export type ProjectDetailsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectDetails
     */
    select?: ProjectDetailsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectDetails
     */
    omit?: ProjectDetailsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectDetailsInclude<ExtArgs> | null
    /**
     * Filter, which ProjectDetails to fetch.
     */
    where?: ProjectDetailsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProjectDetails to fetch.
     */
    orderBy?: ProjectDetailsOrderByWithRelationInput | ProjectDetailsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ProjectDetails.
     */
    cursor?: ProjectDetailsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProjectDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProjectDetails.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ProjectDetails.
     */
    distinct?: ProjectDetailsScalarFieldEnum | ProjectDetailsScalarFieldEnum[]
  }

  /**
   * ProjectDetails findMany
   */
  export type ProjectDetailsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectDetails
     */
    select?: ProjectDetailsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectDetails
     */
    omit?: ProjectDetailsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectDetailsInclude<ExtArgs> | null
    /**
     * Filter, which ProjectDetails to fetch.
     */
    where?: ProjectDetailsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProjectDetails to fetch.
     */
    orderBy?: ProjectDetailsOrderByWithRelationInput | ProjectDetailsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing ProjectDetails.
     */
    cursor?: ProjectDetailsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProjectDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProjectDetails.
     */
    skip?: number
    distinct?: ProjectDetailsScalarFieldEnum | ProjectDetailsScalarFieldEnum[]
  }

  /**
   * ProjectDetails create
   */
  export type ProjectDetailsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectDetails
     */
    select?: ProjectDetailsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectDetails
     */
    omit?: ProjectDetailsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectDetailsInclude<ExtArgs> | null
    /**
     * The data needed to create a ProjectDetails.
     */
    data: XOR<ProjectDetailsCreateInput, ProjectDetailsUncheckedCreateInput>
  }

  /**
   * ProjectDetails createMany
   */
  export type ProjectDetailsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many ProjectDetails.
     */
    data: ProjectDetailsCreateManyInput | ProjectDetailsCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * ProjectDetails createManyAndReturn
   */
  export type ProjectDetailsCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectDetails
     */
    select?: ProjectDetailsSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectDetails
     */
    omit?: ProjectDetailsOmit<ExtArgs> | null
    /**
     * The data used to create many ProjectDetails.
     */
    data: ProjectDetailsCreateManyInput | ProjectDetailsCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectDetailsIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * ProjectDetails update
   */
  export type ProjectDetailsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectDetails
     */
    select?: ProjectDetailsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectDetails
     */
    omit?: ProjectDetailsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectDetailsInclude<ExtArgs> | null
    /**
     * The data needed to update a ProjectDetails.
     */
    data: XOR<ProjectDetailsUpdateInput, ProjectDetailsUncheckedUpdateInput>
    /**
     * Choose, which ProjectDetails to update.
     */
    where: ProjectDetailsWhereUniqueInput
  }

  /**
   * ProjectDetails updateMany
   */
  export type ProjectDetailsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update ProjectDetails.
     */
    data: XOR<ProjectDetailsUpdateManyMutationInput, ProjectDetailsUncheckedUpdateManyInput>
    /**
     * Filter which ProjectDetails to update
     */
    where?: ProjectDetailsWhereInput
    /**
     * Limit how many ProjectDetails to update.
     */
    limit?: number
  }

  /**
   * ProjectDetails updateManyAndReturn
   */
  export type ProjectDetailsUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectDetails
     */
    select?: ProjectDetailsSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectDetails
     */
    omit?: ProjectDetailsOmit<ExtArgs> | null
    /**
     * The data used to update ProjectDetails.
     */
    data: XOR<ProjectDetailsUpdateManyMutationInput, ProjectDetailsUncheckedUpdateManyInput>
    /**
     * Filter which ProjectDetails to update
     */
    where?: ProjectDetailsWhereInput
    /**
     * Limit how many ProjectDetails to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectDetailsIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * ProjectDetails upsert
   */
  export type ProjectDetailsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectDetails
     */
    select?: ProjectDetailsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectDetails
     */
    omit?: ProjectDetailsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectDetailsInclude<ExtArgs> | null
    /**
     * The filter to search for the ProjectDetails to update in case it exists.
     */
    where: ProjectDetailsWhereUniqueInput
    /**
     * In case the ProjectDetails found by the `where` argument doesn't exist, create a new ProjectDetails with this data.
     */
    create: XOR<ProjectDetailsCreateInput, ProjectDetailsUncheckedCreateInput>
    /**
     * In case the ProjectDetails was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ProjectDetailsUpdateInput, ProjectDetailsUncheckedUpdateInput>
  }

  /**
   * ProjectDetails delete
   */
  export type ProjectDetailsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectDetails
     */
    select?: ProjectDetailsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectDetails
     */
    omit?: ProjectDetailsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectDetailsInclude<ExtArgs> | null
    /**
     * Filter which ProjectDetails to delete.
     */
    where: ProjectDetailsWhereUniqueInput
  }

  /**
   * ProjectDetails deleteMany
   */
  export type ProjectDetailsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ProjectDetails to delete
     */
    where?: ProjectDetailsWhereInput
    /**
     * Limit how many ProjectDetails to delete.
     */
    limit?: number
  }

  /**
   * ProjectDetails without action
   */
  export type ProjectDetailsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectDetails
     */
    select?: ProjectDetailsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectDetails
     */
    omit?: ProjectDetailsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectDetailsInclude<ExtArgs> | null
  }


  /**
   * Model ReferDomainCategory
   */

  export type AggregateReferDomainCategory = {
    _count: ReferDomainCategoryCountAggregateOutputType | null
    _avg: ReferDomainCategoryAvgAggregateOutputType | null
    _sum: ReferDomainCategorySumAggregateOutputType | null
    _min: ReferDomainCategoryMinAggregateOutputType | null
    _max: ReferDomainCategoryMaxAggregateOutputType | null
  }

  export type ReferDomainCategoryAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type ReferDomainCategorySumAggregateOutputType = {
    id: number | null
    user_id: number | null
  }

  export type ReferDomainCategoryMinAggregateOutputType = {
    id: number | null
    category_name: string | null
    user_id: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type ReferDomainCategoryMaxAggregateOutputType = {
    id: number | null
    category_name: string | null
    user_id: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type ReferDomainCategoryCountAggregateOutputType = {
    id: number
    category_name: number
    user_id: number
    created_at: number
    updated_at: number
    deleted_at: number
    _all: number
  }


  export type ReferDomainCategoryAvgAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type ReferDomainCategorySumAggregateInputType = {
    id?: true
    user_id?: true
  }

  export type ReferDomainCategoryMinAggregateInputType = {
    id?: true
    category_name?: true
    user_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type ReferDomainCategoryMaxAggregateInputType = {
    id?: true
    category_name?: true
    user_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type ReferDomainCategoryCountAggregateInputType = {
    id?: true
    category_name?: true
    user_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    _all?: true
  }

  export type ReferDomainCategoryAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ReferDomainCategory to aggregate.
     */
    where?: ReferDomainCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ReferDomainCategories to fetch.
     */
    orderBy?: ReferDomainCategoryOrderByWithRelationInput | ReferDomainCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ReferDomainCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ReferDomainCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ReferDomainCategories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ReferDomainCategories
    **/
    _count?: true | ReferDomainCategoryCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ReferDomainCategoryAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ReferDomainCategorySumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ReferDomainCategoryMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ReferDomainCategoryMaxAggregateInputType
  }

  export type GetReferDomainCategoryAggregateType<T extends ReferDomainCategoryAggregateArgs> = {
        [P in keyof T & keyof AggregateReferDomainCategory]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateReferDomainCategory[P]>
      : GetScalarType<T[P], AggregateReferDomainCategory[P]>
  }




  export type ReferDomainCategoryGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ReferDomainCategoryWhereInput
    orderBy?: ReferDomainCategoryOrderByWithAggregationInput | ReferDomainCategoryOrderByWithAggregationInput[]
    by: ReferDomainCategoryScalarFieldEnum[] | ReferDomainCategoryScalarFieldEnum
    having?: ReferDomainCategoryScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ReferDomainCategoryCountAggregateInputType | true
    _avg?: ReferDomainCategoryAvgAggregateInputType
    _sum?: ReferDomainCategorySumAggregateInputType
    _min?: ReferDomainCategoryMinAggregateInputType
    _max?: ReferDomainCategoryMaxAggregateInputType
  }

  export type ReferDomainCategoryGroupByOutputType = {
    id: number
    category_name: string
    user_id: number
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    _count: ReferDomainCategoryCountAggregateOutputType | null
    _avg: ReferDomainCategoryAvgAggregateOutputType | null
    _sum: ReferDomainCategorySumAggregateOutputType | null
    _min: ReferDomainCategoryMinAggregateOutputType | null
    _max: ReferDomainCategoryMaxAggregateOutputType | null
  }

  type GetReferDomainCategoryGroupByPayload<T extends ReferDomainCategoryGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ReferDomainCategoryGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ReferDomainCategoryGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ReferDomainCategoryGroupByOutputType[P]>
            : GetScalarType<T[P], ReferDomainCategoryGroupByOutputType[P]>
        }
      >
    >


  export type ReferDomainCategorySelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    category_name?: boolean
    user_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    UserRdCategory?: boolean | UserDefaultArgs<ExtArgs>
    ReferDomain?: boolean | ReferDomainCategory$ReferDomainArgs<ExtArgs>
    _count?: boolean | ReferDomainCategoryCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["referDomainCategory"]>

  export type ReferDomainCategorySelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    category_name?: boolean
    user_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    UserRdCategory?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["referDomainCategory"]>

  export type ReferDomainCategorySelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    category_name?: boolean
    user_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    UserRdCategory?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["referDomainCategory"]>

  export type ReferDomainCategorySelectScalar = {
    id?: boolean
    category_name?: boolean
    user_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }

  export type ReferDomainCategoryOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "category_name" | "user_id" | "created_at" | "updated_at" | "deleted_at", ExtArgs["result"]["referDomainCategory"]>
  export type ReferDomainCategoryInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    UserRdCategory?: boolean | UserDefaultArgs<ExtArgs>
    ReferDomain?: boolean | ReferDomainCategory$ReferDomainArgs<ExtArgs>
    _count?: boolean | ReferDomainCategoryCountOutputTypeDefaultArgs<ExtArgs>
  }
  export type ReferDomainCategoryIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    UserRdCategory?: boolean | UserDefaultArgs<ExtArgs>
  }
  export type ReferDomainCategoryIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    UserRdCategory?: boolean | UserDefaultArgs<ExtArgs>
  }

  export type $ReferDomainCategoryPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "ReferDomainCategory"
    objects: {
      UserRdCategory: Prisma.$UserPayload<ExtArgs>
      ReferDomain: Prisma.$ReferDomainPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      category_name: string
      user_id: number
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
    }, ExtArgs["result"]["referDomainCategory"]>
    composites: {}
  }

  type ReferDomainCategoryGetPayload<S extends boolean | null | undefined | ReferDomainCategoryDefaultArgs> = $Result.GetResult<Prisma.$ReferDomainCategoryPayload, S>

  type ReferDomainCategoryCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<ReferDomainCategoryFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: ReferDomainCategoryCountAggregateInputType | true
    }

  export interface ReferDomainCategoryDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['ReferDomainCategory'], meta: { name: 'ReferDomainCategory' } }
    /**
     * Find zero or one ReferDomainCategory that matches the filter.
     * @param {ReferDomainCategoryFindUniqueArgs} args - Arguments to find a ReferDomainCategory
     * @example
     * // Get one ReferDomainCategory
     * const referDomainCategory = await prisma.referDomainCategory.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ReferDomainCategoryFindUniqueArgs>(args: SelectSubset<T, ReferDomainCategoryFindUniqueArgs<ExtArgs>>): Prisma__ReferDomainCategoryClient<$Result.GetResult<Prisma.$ReferDomainCategoryPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one ReferDomainCategory that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {ReferDomainCategoryFindUniqueOrThrowArgs} args - Arguments to find a ReferDomainCategory
     * @example
     * // Get one ReferDomainCategory
     * const referDomainCategory = await prisma.referDomainCategory.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ReferDomainCategoryFindUniqueOrThrowArgs>(args: SelectSubset<T, ReferDomainCategoryFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ReferDomainCategoryClient<$Result.GetResult<Prisma.$ReferDomainCategoryPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first ReferDomainCategory that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReferDomainCategoryFindFirstArgs} args - Arguments to find a ReferDomainCategory
     * @example
     * // Get one ReferDomainCategory
     * const referDomainCategory = await prisma.referDomainCategory.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ReferDomainCategoryFindFirstArgs>(args?: SelectSubset<T, ReferDomainCategoryFindFirstArgs<ExtArgs>>): Prisma__ReferDomainCategoryClient<$Result.GetResult<Prisma.$ReferDomainCategoryPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first ReferDomainCategory that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReferDomainCategoryFindFirstOrThrowArgs} args - Arguments to find a ReferDomainCategory
     * @example
     * // Get one ReferDomainCategory
     * const referDomainCategory = await prisma.referDomainCategory.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ReferDomainCategoryFindFirstOrThrowArgs>(args?: SelectSubset<T, ReferDomainCategoryFindFirstOrThrowArgs<ExtArgs>>): Prisma__ReferDomainCategoryClient<$Result.GetResult<Prisma.$ReferDomainCategoryPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more ReferDomainCategories that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReferDomainCategoryFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all ReferDomainCategories
     * const referDomainCategories = await prisma.referDomainCategory.findMany()
     * 
     * // Get first 10 ReferDomainCategories
     * const referDomainCategories = await prisma.referDomainCategory.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const referDomainCategoryWithIdOnly = await prisma.referDomainCategory.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ReferDomainCategoryFindManyArgs>(args?: SelectSubset<T, ReferDomainCategoryFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ReferDomainCategoryPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a ReferDomainCategory.
     * @param {ReferDomainCategoryCreateArgs} args - Arguments to create a ReferDomainCategory.
     * @example
     * // Create one ReferDomainCategory
     * const ReferDomainCategory = await prisma.referDomainCategory.create({
     *   data: {
     *     // ... data to create a ReferDomainCategory
     *   }
     * })
     * 
     */
    create<T extends ReferDomainCategoryCreateArgs>(args: SelectSubset<T, ReferDomainCategoryCreateArgs<ExtArgs>>): Prisma__ReferDomainCategoryClient<$Result.GetResult<Prisma.$ReferDomainCategoryPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many ReferDomainCategories.
     * @param {ReferDomainCategoryCreateManyArgs} args - Arguments to create many ReferDomainCategories.
     * @example
     * // Create many ReferDomainCategories
     * const referDomainCategory = await prisma.referDomainCategory.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ReferDomainCategoryCreateManyArgs>(args?: SelectSubset<T, ReferDomainCategoryCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many ReferDomainCategories and returns the data saved in the database.
     * @param {ReferDomainCategoryCreateManyAndReturnArgs} args - Arguments to create many ReferDomainCategories.
     * @example
     * // Create many ReferDomainCategories
     * const referDomainCategory = await prisma.referDomainCategory.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many ReferDomainCategories and only return the `id`
     * const referDomainCategoryWithIdOnly = await prisma.referDomainCategory.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends ReferDomainCategoryCreateManyAndReturnArgs>(args?: SelectSubset<T, ReferDomainCategoryCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ReferDomainCategoryPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a ReferDomainCategory.
     * @param {ReferDomainCategoryDeleteArgs} args - Arguments to delete one ReferDomainCategory.
     * @example
     * // Delete one ReferDomainCategory
     * const ReferDomainCategory = await prisma.referDomainCategory.delete({
     *   where: {
     *     // ... filter to delete one ReferDomainCategory
     *   }
     * })
     * 
     */
    delete<T extends ReferDomainCategoryDeleteArgs>(args: SelectSubset<T, ReferDomainCategoryDeleteArgs<ExtArgs>>): Prisma__ReferDomainCategoryClient<$Result.GetResult<Prisma.$ReferDomainCategoryPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one ReferDomainCategory.
     * @param {ReferDomainCategoryUpdateArgs} args - Arguments to update one ReferDomainCategory.
     * @example
     * // Update one ReferDomainCategory
     * const referDomainCategory = await prisma.referDomainCategory.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ReferDomainCategoryUpdateArgs>(args: SelectSubset<T, ReferDomainCategoryUpdateArgs<ExtArgs>>): Prisma__ReferDomainCategoryClient<$Result.GetResult<Prisma.$ReferDomainCategoryPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more ReferDomainCategories.
     * @param {ReferDomainCategoryDeleteManyArgs} args - Arguments to filter ReferDomainCategories to delete.
     * @example
     * // Delete a few ReferDomainCategories
     * const { count } = await prisma.referDomainCategory.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ReferDomainCategoryDeleteManyArgs>(args?: SelectSubset<T, ReferDomainCategoryDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ReferDomainCategories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReferDomainCategoryUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many ReferDomainCategories
     * const referDomainCategory = await prisma.referDomainCategory.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ReferDomainCategoryUpdateManyArgs>(args: SelectSubset<T, ReferDomainCategoryUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ReferDomainCategories and returns the data updated in the database.
     * @param {ReferDomainCategoryUpdateManyAndReturnArgs} args - Arguments to update many ReferDomainCategories.
     * @example
     * // Update many ReferDomainCategories
     * const referDomainCategory = await prisma.referDomainCategory.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more ReferDomainCategories and only return the `id`
     * const referDomainCategoryWithIdOnly = await prisma.referDomainCategory.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends ReferDomainCategoryUpdateManyAndReturnArgs>(args: SelectSubset<T, ReferDomainCategoryUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ReferDomainCategoryPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one ReferDomainCategory.
     * @param {ReferDomainCategoryUpsertArgs} args - Arguments to update or create a ReferDomainCategory.
     * @example
     * // Update or create a ReferDomainCategory
     * const referDomainCategory = await prisma.referDomainCategory.upsert({
     *   create: {
     *     // ... data to create a ReferDomainCategory
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the ReferDomainCategory we want to update
     *   }
     * })
     */
    upsert<T extends ReferDomainCategoryUpsertArgs>(args: SelectSubset<T, ReferDomainCategoryUpsertArgs<ExtArgs>>): Prisma__ReferDomainCategoryClient<$Result.GetResult<Prisma.$ReferDomainCategoryPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of ReferDomainCategories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReferDomainCategoryCountArgs} args - Arguments to filter ReferDomainCategories to count.
     * @example
     * // Count the number of ReferDomainCategories
     * const count = await prisma.referDomainCategory.count({
     *   where: {
     *     // ... the filter for the ReferDomainCategories we want to count
     *   }
     * })
    **/
    count<T extends ReferDomainCategoryCountArgs>(
      args?: Subset<T, ReferDomainCategoryCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ReferDomainCategoryCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a ReferDomainCategory.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReferDomainCategoryAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ReferDomainCategoryAggregateArgs>(args: Subset<T, ReferDomainCategoryAggregateArgs>): Prisma.PrismaPromise<GetReferDomainCategoryAggregateType<T>>

    /**
     * Group by ReferDomainCategory.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReferDomainCategoryGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ReferDomainCategoryGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ReferDomainCategoryGroupByArgs['orderBy'] }
        : { orderBy?: ReferDomainCategoryGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ReferDomainCategoryGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetReferDomainCategoryGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the ReferDomainCategory model
   */
  readonly fields: ReferDomainCategoryFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for ReferDomainCategory.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ReferDomainCategoryClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    UserRdCategory<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    ReferDomain<T extends ReferDomainCategory$ReferDomainArgs<ExtArgs> = {}>(args?: Subset<T, ReferDomainCategory$ReferDomainArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ReferDomainPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the ReferDomainCategory model
   */ 
  interface ReferDomainCategoryFieldRefs {
    readonly id: FieldRef<"ReferDomainCategory", 'Int'>
    readonly category_name: FieldRef<"ReferDomainCategory", 'String'>
    readonly user_id: FieldRef<"ReferDomainCategory", 'Int'>
    readonly created_at: FieldRef<"ReferDomainCategory", 'DateTime'>
    readonly updated_at: FieldRef<"ReferDomainCategory", 'DateTime'>
    readonly deleted_at: FieldRef<"ReferDomainCategory", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * ReferDomainCategory findUnique
   */
  export type ReferDomainCategoryFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomainCategory
     */
    select?: ReferDomainCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomainCategory
     */
    omit?: ReferDomainCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainCategoryInclude<ExtArgs> | null
    /**
     * Filter, which ReferDomainCategory to fetch.
     */
    where: ReferDomainCategoryWhereUniqueInput
  }

  /**
   * ReferDomainCategory findUniqueOrThrow
   */
  export type ReferDomainCategoryFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomainCategory
     */
    select?: ReferDomainCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomainCategory
     */
    omit?: ReferDomainCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainCategoryInclude<ExtArgs> | null
    /**
     * Filter, which ReferDomainCategory to fetch.
     */
    where: ReferDomainCategoryWhereUniqueInput
  }

  /**
   * ReferDomainCategory findFirst
   */
  export type ReferDomainCategoryFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomainCategory
     */
    select?: ReferDomainCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomainCategory
     */
    omit?: ReferDomainCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainCategoryInclude<ExtArgs> | null
    /**
     * Filter, which ReferDomainCategory to fetch.
     */
    where?: ReferDomainCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ReferDomainCategories to fetch.
     */
    orderBy?: ReferDomainCategoryOrderByWithRelationInput | ReferDomainCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ReferDomainCategories.
     */
    cursor?: ReferDomainCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ReferDomainCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ReferDomainCategories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ReferDomainCategories.
     */
    distinct?: ReferDomainCategoryScalarFieldEnum | ReferDomainCategoryScalarFieldEnum[]
  }

  /**
   * ReferDomainCategory findFirstOrThrow
   */
  export type ReferDomainCategoryFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomainCategory
     */
    select?: ReferDomainCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomainCategory
     */
    omit?: ReferDomainCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainCategoryInclude<ExtArgs> | null
    /**
     * Filter, which ReferDomainCategory to fetch.
     */
    where?: ReferDomainCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ReferDomainCategories to fetch.
     */
    orderBy?: ReferDomainCategoryOrderByWithRelationInput | ReferDomainCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ReferDomainCategories.
     */
    cursor?: ReferDomainCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ReferDomainCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ReferDomainCategories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ReferDomainCategories.
     */
    distinct?: ReferDomainCategoryScalarFieldEnum | ReferDomainCategoryScalarFieldEnum[]
  }

  /**
   * ReferDomainCategory findMany
   */
  export type ReferDomainCategoryFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomainCategory
     */
    select?: ReferDomainCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomainCategory
     */
    omit?: ReferDomainCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainCategoryInclude<ExtArgs> | null
    /**
     * Filter, which ReferDomainCategories to fetch.
     */
    where?: ReferDomainCategoryWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ReferDomainCategories to fetch.
     */
    orderBy?: ReferDomainCategoryOrderByWithRelationInput | ReferDomainCategoryOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing ReferDomainCategories.
     */
    cursor?: ReferDomainCategoryWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ReferDomainCategories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ReferDomainCategories.
     */
    skip?: number
    distinct?: ReferDomainCategoryScalarFieldEnum | ReferDomainCategoryScalarFieldEnum[]
  }

  /**
   * ReferDomainCategory create
   */
  export type ReferDomainCategoryCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomainCategory
     */
    select?: ReferDomainCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomainCategory
     */
    omit?: ReferDomainCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainCategoryInclude<ExtArgs> | null
    /**
     * The data needed to create a ReferDomainCategory.
     */
    data: XOR<ReferDomainCategoryCreateInput, ReferDomainCategoryUncheckedCreateInput>
  }

  /**
   * ReferDomainCategory createMany
   */
  export type ReferDomainCategoryCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many ReferDomainCategories.
     */
    data: ReferDomainCategoryCreateManyInput | ReferDomainCategoryCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * ReferDomainCategory createManyAndReturn
   */
  export type ReferDomainCategoryCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomainCategory
     */
    select?: ReferDomainCategorySelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomainCategory
     */
    omit?: ReferDomainCategoryOmit<ExtArgs> | null
    /**
     * The data used to create many ReferDomainCategories.
     */
    data: ReferDomainCategoryCreateManyInput | ReferDomainCategoryCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainCategoryIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * ReferDomainCategory update
   */
  export type ReferDomainCategoryUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomainCategory
     */
    select?: ReferDomainCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomainCategory
     */
    omit?: ReferDomainCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainCategoryInclude<ExtArgs> | null
    /**
     * The data needed to update a ReferDomainCategory.
     */
    data: XOR<ReferDomainCategoryUpdateInput, ReferDomainCategoryUncheckedUpdateInput>
    /**
     * Choose, which ReferDomainCategory to update.
     */
    where: ReferDomainCategoryWhereUniqueInput
  }

  /**
   * ReferDomainCategory updateMany
   */
  export type ReferDomainCategoryUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update ReferDomainCategories.
     */
    data: XOR<ReferDomainCategoryUpdateManyMutationInput, ReferDomainCategoryUncheckedUpdateManyInput>
    /**
     * Filter which ReferDomainCategories to update
     */
    where?: ReferDomainCategoryWhereInput
    /**
     * Limit how many ReferDomainCategories to update.
     */
    limit?: number
  }

  /**
   * ReferDomainCategory updateManyAndReturn
   */
  export type ReferDomainCategoryUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomainCategory
     */
    select?: ReferDomainCategorySelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomainCategory
     */
    omit?: ReferDomainCategoryOmit<ExtArgs> | null
    /**
     * The data used to update ReferDomainCategories.
     */
    data: XOR<ReferDomainCategoryUpdateManyMutationInput, ReferDomainCategoryUncheckedUpdateManyInput>
    /**
     * Filter which ReferDomainCategories to update
     */
    where?: ReferDomainCategoryWhereInput
    /**
     * Limit how many ReferDomainCategories to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainCategoryIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * ReferDomainCategory upsert
   */
  export type ReferDomainCategoryUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomainCategory
     */
    select?: ReferDomainCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomainCategory
     */
    omit?: ReferDomainCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainCategoryInclude<ExtArgs> | null
    /**
     * The filter to search for the ReferDomainCategory to update in case it exists.
     */
    where: ReferDomainCategoryWhereUniqueInput
    /**
     * In case the ReferDomainCategory found by the `where` argument doesn't exist, create a new ReferDomainCategory with this data.
     */
    create: XOR<ReferDomainCategoryCreateInput, ReferDomainCategoryUncheckedCreateInput>
    /**
     * In case the ReferDomainCategory was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ReferDomainCategoryUpdateInput, ReferDomainCategoryUncheckedUpdateInput>
  }

  /**
   * ReferDomainCategory delete
   */
  export type ReferDomainCategoryDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomainCategory
     */
    select?: ReferDomainCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomainCategory
     */
    omit?: ReferDomainCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainCategoryInclude<ExtArgs> | null
    /**
     * Filter which ReferDomainCategory to delete.
     */
    where: ReferDomainCategoryWhereUniqueInput
  }

  /**
   * ReferDomainCategory deleteMany
   */
  export type ReferDomainCategoryDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ReferDomainCategories to delete
     */
    where?: ReferDomainCategoryWhereInput
    /**
     * Limit how many ReferDomainCategories to delete.
     */
    limit?: number
  }

  /**
   * ReferDomainCategory.ReferDomain
   */
  export type ReferDomainCategory$ReferDomainArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomain
     */
    select?: ReferDomainSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomain
     */
    omit?: ReferDomainOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainInclude<ExtArgs> | null
    where?: ReferDomainWhereInput
    orderBy?: ReferDomainOrderByWithRelationInput | ReferDomainOrderByWithRelationInput[]
    cursor?: ReferDomainWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ReferDomainScalarFieldEnum | ReferDomainScalarFieldEnum[]
  }

  /**
   * ReferDomainCategory without action
   */
  export type ReferDomainCategoryDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomainCategory
     */
    select?: ReferDomainCategorySelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomainCategory
     */
    omit?: ReferDomainCategoryOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainCategoryInclude<ExtArgs> | null
  }


  /**
   * Model ReferDomain
   */

  export type AggregateReferDomain = {
    _count: ReferDomainCountAggregateOutputType | null
    _avg: ReferDomainAvgAggregateOutputType | null
    _sum: ReferDomainSumAggregateOutputType | null
    _min: ReferDomainMinAggregateOutputType | null
    _max: ReferDomainMaxAggregateOutputType | null
  }

  export type ReferDomainAvgAggregateOutputType = {
    id: number | null
    category_id: number | null
    user_id: number | null
    status: number | null
  }

  export type ReferDomainSumAggregateOutputType = {
    id: number | null
    category_id: number | null
    user_id: number | null
    status: number | null
  }

  export type ReferDomainMinAggregateOutputType = {
    id: number | null
    category_id: number | null
    rd_link: string | null
    user_id: number | null
    status: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type ReferDomainMaxAggregateOutputType = {
    id: number | null
    category_id: number | null
    rd_link: string | null
    user_id: number | null
    status: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type ReferDomainCountAggregateOutputType = {
    id: number
    category_id: number
    rd_link: number
    user_id: number
    status: number
    created_at: number
    updated_at: number
    deleted_at: number
    _all: number
  }


  export type ReferDomainAvgAggregateInputType = {
    id?: true
    category_id?: true
    user_id?: true
    status?: true
  }

  export type ReferDomainSumAggregateInputType = {
    id?: true
    category_id?: true
    user_id?: true
    status?: true
  }

  export type ReferDomainMinAggregateInputType = {
    id?: true
    category_id?: true
    rd_link?: true
    user_id?: true
    status?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type ReferDomainMaxAggregateInputType = {
    id?: true
    category_id?: true
    rd_link?: true
    user_id?: true
    status?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type ReferDomainCountAggregateInputType = {
    id?: true
    category_id?: true
    rd_link?: true
    user_id?: true
    status?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    _all?: true
  }

  export type ReferDomainAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ReferDomain to aggregate.
     */
    where?: ReferDomainWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ReferDomains to fetch.
     */
    orderBy?: ReferDomainOrderByWithRelationInput | ReferDomainOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ReferDomainWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ReferDomains from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ReferDomains.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ReferDomains
    **/
    _count?: true | ReferDomainCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ReferDomainAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ReferDomainSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ReferDomainMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ReferDomainMaxAggregateInputType
  }

  export type GetReferDomainAggregateType<T extends ReferDomainAggregateArgs> = {
        [P in keyof T & keyof AggregateReferDomain]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateReferDomain[P]>
      : GetScalarType<T[P], AggregateReferDomain[P]>
  }




  export type ReferDomainGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ReferDomainWhereInput
    orderBy?: ReferDomainOrderByWithAggregationInput | ReferDomainOrderByWithAggregationInput[]
    by: ReferDomainScalarFieldEnum[] | ReferDomainScalarFieldEnum
    having?: ReferDomainScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ReferDomainCountAggregateInputType | true
    _avg?: ReferDomainAvgAggregateInputType
    _sum?: ReferDomainSumAggregateInputType
    _min?: ReferDomainMinAggregateInputType
    _max?: ReferDomainMaxAggregateInputType
  }

  export type ReferDomainGroupByOutputType = {
    id: number
    category_id: number
    rd_link: string
    user_id: number
    status: number
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    _count: ReferDomainCountAggregateOutputType | null
    _avg: ReferDomainAvgAggregateOutputType | null
    _sum: ReferDomainSumAggregateOutputType | null
    _min: ReferDomainMinAggregateOutputType | null
    _max: ReferDomainMaxAggregateOutputType | null
  }

  type GetReferDomainGroupByPayload<T extends ReferDomainGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ReferDomainGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ReferDomainGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ReferDomainGroupByOutputType[P]>
            : GetScalarType<T[P], ReferDomainGroupByOutputType[P]>
        }
      >
    >


  export type ReferDomainSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    category_id?: boolean
    rd_link?: boolean
    user_id?: boolean
    status?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    UserRd?: boolean | UserDefaultArgs<ExtArgs>
    RdCategory?: boolean | ReferDomainCategoryDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["referDomain"]>

  export type ReferDomainSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    category_id?: boolean
    rd_link?: boolean
    user_id?: boolean
    status?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    UserRd?: boolean | UserDefaultArgs<ExtArgs>
    RdCategory?: boolean | ReferDomainCategoryDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["referDomain"]>

  export type ReferDomainSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    category_id?: boolean
    rd_link?: boolean
    user_id?: boolean
    status?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    UserRd?: boolean | UserDefaultArgs<ExtArgs>
    RdCategory?: boolean | ReferDomainCategoryDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["referDomain"]>

  export type ReferDomainSelectScalar = {
    id?: boolean
    category_id?: boolean
    rd_link?: boolean
    user_id?: boolean
    status?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }

  export type ReferDomainOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "category_id" | "rd_link" | "user_id" | "status" | "created_at" | "updated_at" | "deleted_at", ExtArgs["result"]["referDomain"]>
  export type ReferDomainInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    UserRd?: boolean | UserDefaultArgs<ExtArgs>
    RdCategory?: boolean | ReferDomainCategoryDefaultArgs<ExtArgs>
  }
  export type ReferDomainIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    UserRd?: boolean | UserDefaultArgs<ExtArgs>
    RdCategory?: boolean | ReferDomainCategoryDefaultArgs<ExtArgs>
  }
  export type ReferDomainIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    UserRd?: boolean | UserDefaultArgs<ExtArgs>
    RdCategory?: boolean | ReferDomainCategoryDefaultArgs<ExtArgs>
  }

  export type $ReferDomainPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "ReferDomain"
    objects: {
      UserRd: Prisma.$UserPayload<ExtArgs>
      RdCategory: Prisma.$ReferDomainCategoryPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      category_id: number
      rd_link: string
      user_id: number
      status: number
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
    }, ExtArgs["result"]["referDomain"]>
    composites: {}
  }

  type ReferDomainGetPayload<S extends boolean | null | undefined | ReferDomainDefaultArgs> = $Result.GetResult<Prisma.$ReferDomainPayload, S>

  type ReferDomainCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<ReferDomainFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: ReferDomainCountAggregateInputType | true
    }

  export interface ReferDomainDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['ReferDomain'], meta: { name: 'ReferDomain' } }
    /**
     * Find zero or one ReferDomain that matches the filter.
     * @param {ReferDomainFindUniqueArgs} args - Arguments to find a ReferDomain
     * @example
     * // Get one ReferDomain
     * const referDomain = await prisma.referDomain.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ReferDomainFindUniqueArgs>(args: SelectSubset<T, ReferDomainFindUniqueArgs<ExtArgs>>): Prisma__ReferDomainClient<$Result.GetResult<Prisma.$ReferDomainPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one ReferDomain that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {ReferDomainFindUniqueOrThrowArgs} args - Arguments to find a ReferDomain
     * @example
     * // Get one ReferDomain
     * const referDomain = await prisma.referDomain.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ReferDomainFindUniqueOrThrowArgs>(args: SelectSubset<T, ReferDomainFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ReferDomainClient<$Result.GetResult<Prisma.$ReferDomainPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first ReferDomain that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReferDomainFindFirstArgs} args - Arguments to find a ReferDomain
     * @example
     * // Get one ReferDomain
     * const referDomain = await prisma.referDomain.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ReferDomainFindFirstArgs>(args?: SelectSubset<T, ReferDomainFindFirstArgs<ExtArgs>>): Prisma__ReferDomainClient<$Result.GetResult<Prisma.$ReferDomainPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first ReferDomain that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReferDomainFindFirstOrThrowArgs} args - Arguments to find a ReferDomain
     * @example
     * // Get one ReferDomain
     * const referDomain = await prisma.referDomain.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ReferDomainFindFirstOrThrowArgs>(args?: SelectSubset<T, ReferDomainFindFirstOrThrowArgs<ExtArgs>>): Prisma__ReferDomainClient<$Result.GetResult<Prisma.$ReferDomainPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more ReferDomains that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReferDomainFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all ReferDomains
     * const referDomains = await prisma.referDomain.findMany()
     * 
     * // Get first 10 ReferDomains
     * const referDomains = await prisma.referDomain.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const referDomainWithIdOnly = await prisma.referDomain.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ReferDomainFindManyArgs>(args?: SelectSubset<T, ReferDomainFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ReferDomainPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a ReferDomain.
     * @param {ReferDomainCreateArgs} args - Arguments to create a ReferDomain.
     * @example
     * // Create one ReferDomain
     * const ReferDomain = await prisma.referDomain.create({
     *   data: {
     *     // ... data to create a ReferDomain
     *   }
     * })
     * 
     */
    create<T extends ReferDomainCreateArgs>(args: SelectSubset<T, ReferDomainCreateArgs<ExtArgs>>): Prisma__ReferDomainClient<$Result.GetResult<Prisma.$ReferDomainPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many ReferDomains.
     * @param {ReferDomainCreateManyArgs} args - Arguments to create many ReferDomains.
     * @example
     * // Create many ReferDomains
     * const referDomain = await prisma.referDomain.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ReferDomainCreateManyArgs>(args?: SelectSubset<T, ReferDomainCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many ReferDomains and returns the data saved in the database.
     * @param {ReferDomainCreateManyAndReturnArgs} args - Arguments to create many ReferDomains.
     * @example
     * // Create many ReferDomains
     * const referDomain = await prisma.referDomain.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many ReferDomains and only return the `id`
     * const referDomainWithIdOnly = await prisma.referDomain.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends ReferDomainCreateManyAndReturnArgs>(args?: SelectSubset<T, ReferDomainCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ReferDomainPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a ReferDomain.
     * @param {ReferDomainDeleteArgs} args - Arguments to delete one ReferDomain.
     * @example
     * // Delete one ReferDomain
     * const ReferDomain = await prisma.referDomain.delete({
     *   where: {
     *     // ... filter to delete one ReferDomain
     *   }
     * })
     * 
     */
    delete<T extends ReferDomainDeleteArgs>(args: SelectSubset<T, ReferDomainDeleteArgs<ExtArgs>>): Prisma__ReferDomainClient<$Result.GetResult<Prisma.$ReferDomainPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one ReferDomain.
     * @param {ReferDomainUpdateArgs} args - Arguments to update one ReferDomain.
     * @example
     * // Update one ReferDomain
     * const referDomain = await prisma.referDomain.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ReferDomainUpdateArgs>(args: SelectSubset<T, ReferDomainUpdateArgs<ExtArgs>>): Prisma__ReferDomainClient<$Result.GetResult<Prisma.$ReferDomainPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more ReferDomains.
     * @param {ReferDomainDeleteManyArgs} args - Arguments to filter ReferDomains to delete.
     * @example
     * // Delete a few ReferDomains
     * const { count } = await prisma.referDomain.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ReferDomainDeleteManyArgs>(args?: SelectSubset<T, ReferDomainDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ReferDomains.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReferDomainUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many ReferDomains
     * const referDomain = await prisma.referDomain.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ReferDomainUpdateManyArgs>(args: SelectSubset<T, ReferDomainUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ReferDomains and returns the data updated in the database.
     * @param {ReferDomainUpdateManyAndReturnArgs} args - Arguments to update many ReferDomains.
     * @example
     * // Update many ReferDomains
     * const referDomain = await prisma.referDomain.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more ReferDomains and only return the `id`
     * const referDomainWithIdOnly = await prisma.referDomain.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends ReferDomainUpdateManyAndReturnArgs>(args: SelectSubset<T, ReferDomainUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ReferDomainPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one ReferDomain.
     * @param {ReferDomainUpsertArgs} args - Arguments to update or create a ReferDomain.
     * @example
     * // Update or create a ReferDomain
     * const referDomain = await prisma.referDomain.upsert({
     *   create: {
     *     // ... data to create a ReferDomain
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the ReferDomain we want to update
     *   }
     * })
     */
    upsert<T extends ReferDomainUpsertArgs>(args: SelectSubset<T, ReferDomainUpsertArgs<ExtArgs>>): Prisma__ReferDomainClient<$Result.GetResult<Prisma.$ReferDomainPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of ReferDomains.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReferDomainCountArgs} args - Arguments to filter ReferDomains to count.
     * @example
     * // Count the number of ReferDomains
     * const count = await prisma.referDomain.count({
     *   where: {
     *     // ... the filter for the ReferDomains we want to count
     *   }
     * })
    **/
    count<T extends ReferDomainCountArgs>(
      args?: Subset<T, ReferDomainCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ReferDomainCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a ReferDomain.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReferDomainAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ReferDomainAggregateArgs>(args: Subset<T, ReferDomainAggregateArgs>): Prisma.PrismaPromise<GetReferDomainAggregateType<T>>

    /**
     * Group by ReferDomain.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ReferDomainGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ReferDomainGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ReferDomainGroupByArgs['orderBy'] }
        : { orderBy?: ReferDomainGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ReferDomainGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetReferDomainGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the ReferDomain model
   */
  readonly fields: ReferDomainFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for ReferDomain.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ReferDomainClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    UserRd<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    RdCategory<T extends ReferDomainCategoryDefaultArgs<ExtArgs> = {}>(args?: Subset<T, ReferDomainCategoryDefaultArgs<ExtArgs>>): Prisma__ReferDomainCategoryClient<$Result.GetResult<Prisma.$ReferDomainCategoryPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the ReferDomain model
   */ 
  interface ReferDomainFieldRefs {
    readonly id: FieldRef<"ReferDomain", 'Int'>
    readonly category_id: FieldRef<"ReferDomain", 'Int'>
    readonly rd_link: FieldRef<"ReferDomain", 'String'>
    readonly user_id: FieldRef<"ReferDomain", 'Int'>
    readonly status: FieldRef<"ReferDomain", 'Int'>
    readonly created_at: FieldRef<"ReferDomain", 'DateTime'>
    readonly updated_at: FieldRef<"ReferDomain", 'DateTime'>
    readonly deleted_at: FieldRef<"ReferDomain", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * ReferDomain findUnique
   */
  export type ReferDomainFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomain
     */
    select?: ReferDomainSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomain
     */
    omit?: ReferDomainOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainInclude<ExtArgs> | null
    /**
     * Filter, which ReferDomain to fetch.
     */
    where: ReferDomainWhereUniqueInput
  }

  /**
   * ReferDomain findUniqueOrThrow
   */
  export type ReferDomainFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomain
     */
    select?: ReferDomainSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomain
     */
    omit?: ReferDomainOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainInclude<ExtArgs> | null
    /**
     * Filter, which ReferDomain to fetch.
     */
    where: ReferDomainWhereUniqueInput
  }

  /**
   * ReferDomain findFirst
   */
  export type ReferDomainFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomain
     */
    select?: ReferDomainSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomain
     */
    omit?: ReferDomainOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainInclude<ExtArgs> | null
    /**
     * Filter, which ReferDomain to fetch.
     */
    where?: ReferDomainWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ReferDomains to fetch.
     */
    orderBy?: ReferDomainOrderByWithRelationInput | ReferDomainOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ReferDomains.
     */
    cursor?: ReferDomainWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ReferDomains from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ReferDomains.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ReferDomains.
     */
    distinct?: ReferDomainScalarFieldEnum | ReferDomainScalarFieldEnum[]
  }

  /**
   * ReferDomain findFirstOrThrow
   */
  export type ReferDomainFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomain
     */
    select?: ReferDomainSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomain
     */
    omit?: ReferDomainOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainInclude<ExtArgs> | null
    /**
     * Filter, which ReferDomain to fetch.
     */
    where?: ReferDomainWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ReferDomains to fetch.
     */
    orderBy?: ReferDomainOrderByWithRelationInput | ReferDomainOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ReferDomains.
     */
    cursor?: ReferDomainWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ReferDomains from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ReferDomains.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ReferDomains.
     */
    distinct?: ReferDomainScalarFieldEnum | ReferDomainScalarFieldEnum[]
  }

  /**
   * ReferDomain findMany
   */
  export type ReferDomainFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomain
     */
    select?: ReferDomainSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomain
     */
    omit?: ReferDomainOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainInclude<ExtArgs> | null
    /**
     * Filter, which ReferDomains to fetch.
     */
    where?: ReferDomainWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ReferDomains to fetch.
     */
    orderBy?: ReferDomainOrderByWithRelationInput | ReferDomainOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing ReferDomains.
     */
    cursor?: ReferDomainWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ReferDomains from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ReferDomains.
     */
    skip?: number
    distinct?: ReferDomainScalarFieldEnum | ReferDomainScalarFieldEnum[]
  }

  /**
   * ReferDomain create
   */
  export type ReferDomainCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomain
     */
    select?: ReferDomainSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomain
     */
    omit?: ReferDomainOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainInclude<ExtArgs> | null
    /**
     * The data needed to create a ReferDomain.
     */
    data: XOR<ReferDomainCreateInput, ReferDomainUncheckedCreateInput>
  }

  /**
   * ReferDomain createMany
   */
  export type ReferDomainCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many ReferDomains.
     */
    data: ReferDomainCreateManyInput | ReferDomainCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * ReferDomain createManyAndReturn
   */
  export type ReferDomainCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomain
     */
    select?: ReferDomainSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomain
     */
    omit?: ReferDomainOmit<ExtArgs> | null
    /**
     * The data used to create many ReferDomains.
     */
    data: ReferDomainCreateManyInput | ReferDomainCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * ReferDomain update
   */
  export type ReferDomainUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomain
     */
    select?: ReferDomainSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomain
     */
    omit?: ReferDomainOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainInclude<ExtArgs> | null
    /**
     * The data needed to update a ReferDomain.
     */
    data: XOR<ReferDomainUpdateInput, ReferDomainUncheckedUpdateInput>
    /**
     * Choose, which ReferDomain to update.
     */
    where: ReferDomainWhereUniqueInput
  }

  /**
   * ReferDomain updateMany
   */
  export type ReferDomainUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update ReferDomains.
     */
    data: XOR<ReferDomainUpdateManyMutationInput, ReferDomainUncheckedUpdateManyInput>
    /**
     * Filter which ReferDomains to update
     */
    where?: ReferDomainWhereInput
    /**
     * Limit how many ReferDomains to update.
     */
    limit?: number
  }

  /**
   * ReferDomain updateManyAndReturn
   */
  export type ReferDomainUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomain
     */
    select?: ReferDomainSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomain
     */
    omit?: ReferDomainOmit<ExtArgs> | null
    /**
     * The data used to update ReferDomains.
     */
    data: XOR<ReferDomainUpdateManyMutationInput, ReferDomainUncheckedUpdateManyInput>
    /**
     * Filter which ReferDomains to update
     */
    where?: ReferDomainWhereInput
    /**
     * Limit how many ReferDomains to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * ReferDomain upsert
   */
  export type ReferDomainUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomain
     */
    select?: ReferDomainSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomain
     */
    omit?: ReferDomainOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainInclude<ExtArgs> | null
    /**
     * The filter to search for the ReferDomain to update in case it exists.
     */
    where: ReferDomainWhereUniqueInput
    /**
     * In case the ReferDomain found by the `where` argument doesn't exist, create a new ReferDomain with this data.
     */
    create: XOR<ReferDomainCreateInput, ReferDomainUncheckedCreateInput>
    /**
     * In case the ReferDomain was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ReferDomainUpdateInput, ReferDomainUncheckedUpdateInput>
  }

  /**
   * ReferDomain delete
   */
  export type ReferDomainDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomain
     */
    select?: ReferDomainSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomain
     */
    omit?: ReferDomainOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainInclude<ExtArgs> | null
    /**
     * Filter which ReferDomain to delete.
     */
    where: ReferDomainWhereUniqueInput
  }

  /**
   * ReferDomain deleteMany
   */
  export type ReferDomainDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ReferDomains to delete
     */
    where?: ReferDomainWhereInput
    /**
     * Limit how many ReferDomains to delete.
     */
    limit?: number
  }

  /**
   * ReferDomain without action
   */
  export type ReferDomainDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ReferDomain
     */
    select?: ReferDomainSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ReferDomain
     */
    omit?: ReferDomainOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ReferDomainInclude<ExtArgs> | null
  }


  /**
   * Model GuideLines
   */

  export type AggregateGuideLines = {
    _count: GuideLinesCountAggregateOutputType | null
    _avg: GuideLinesAvgAggregateOutputType | null
    _sum: GuideLinesSumAggregateOutputType | null
    _min: GuideLinesMinAggregateOutputType | null
    _max: GuideLinesMaxAggregateOutputType | null
  }

  export type GuideLinesAvgAggregateOutputType = {
    id: number | null
    uploaded_by: number | null
  }

  export type GuideLinesSumAggregateOutputType = {
    id: number | null
    uploaded_by: number | null
  }

  export type GuideLinesMinAggregateOutputType = {
    id: number | null
    task_name: string | null
    key_name: string | null
    uploaded_by: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type GuideLinesMaxAggregateOutputType = {
    id: number | null
    task_name: string | null
    key_name: string | null
    uploaded_by: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type GuideLinesCountAggregateOutputType = {
    id: number
    task_name: number
    key_name: number
    uploaded_by: number
    created_at: number
    updated_at: number
    deleted_at: number
    _all: number
  }


  export type GuideLinesAvgAggregateInputType = {
    id?: true
    uploaded_by?: true
  }

  export type GuideLinesSumAggregateInputType = {
    id?: true
    uploaded_by?: true
  }

  export type GuideLinesMinAggregateInputType = {
    id?: true
    task_name?: true
    key_name?: true
    uploaded_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type GuideLinesMaxAggregateInputType = {
    id?: true
    task_name?: true
    key_name?: true
    uploaded_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type GuideLinesCountAggregateInputType = {
    id?: true
    task_name?: true
    key_name?: true
    uploaded_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    _all?: true
  }

  export type GuideLinesAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which GuideLines to aggregate.
     */
    where?: GuideLinesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of GuideLines to fetch.
     */
    orderBy?: GuideLinesOrderByWithRelationInput | GuideLinesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: GuideLinesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` GuideLines from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` GuideLines.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned GuideLines
    **/
    _count?: true | GuideLinesCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: GuideLinesAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: GuideLinesSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: GuideLinesMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: GuideLinesMaxAggregateInputType
  }

  export type GetGuideLinesAggregateType<T extends GuideLinesAggregateArgs> = {
        [P in keyof T & keyof AggregateGuideLines]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateGuideLines[P]>
      : GetScalarType<T[P], AggregateGuideLines[P]>
  }




  export type GuideLinesGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: GuideLinesWhereInput
    orderBy?: GuideLinesOrderByWithAggregationInput | GuideLinesOrderByWithAggregationInput[]
    by: GuideLinesScalarFieldEnum[] | GuideLinesScalarFieldEnum
    having?: GuideLinesScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: GuideLinesCountAggregateInputType | true
    _avg?: GuideLinesAvgAggregateInputType
    _sum?: GuideLinesSumAggregateInputType
    _min?: GuideLinesMinAggregateInputType
    _max?: GuideLinesMaxAggregateInputType
  }

  export type GuideLinesGroupByOutputType = {
    id: number
    task_name: string
    key_name: string
    uploaded_by: number
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    _count: GuideLinesCountAggregateOutputType | null
    _avg: GuideLinesAvgAggregateOutputType | null
    _sum: GuideLinesSumAggregateOutputType | null
    _min: GuideLinesMinAggregateOutputType | null
    _max: GuideLinesMaxAggregateOutputType | null
  }

  type GetGuideLinesGroupByPayload<T extends GuideLinesGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<GuideLinesGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof GuideLinesGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], GuideLinesGroupByOutputType[P]>
            : GetScalarType<T[P], GuideLinesGroupByOutputType[P]>
        }
      >
    >


  export type GuideLinesSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    task_name?: boolean
    key_name?: boolean
    uploaded_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    TaskUploadedBy?: boolean | UserDefaultArgs<ExtArgs>
    ProjectGuideLines?: boolean | GuideLines$ProjectGuideLinesArgs<ExtArgs>
    TempLinks?: boolean | GuideLines$TempLinksArgs<ExtArgs>
    Backlink?: boolean | GuideLines$BacklinkArgs<ExtArgs>
    _count?: boolean | GuideLinesCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["guideLines"]>

  export type GuideLinesSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    task_name?: boolean
    key_name?: boolean
    uploaded_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    TaskUploadedBy?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["guideLines"]>

  export type GuideLinesSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    task_name?: boolean
    key_name?: boolean
    uploaded_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    TaskUploadedBy?: boolean | UserDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["guideLines"]>

  export type GuideLinesSelectScalar = {
    id?: boolean
    task_name?: boolean
    key_name?: boolean
    uploaded_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }

  export type GuideLinesOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "task_name" | "key_name" | "uploaded_by" | "created_at" | "updated_at" | "deleted_at", ExtArgs["result"]["guideLines"]>
  export type GuideLinesInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    TaskUploadedBy?: boolean | UserDefaultArgs<ExtArgs>
    ProjectGuideLines?: boolean | GuideLines$ProjectGuideLinesArgs<ExtArgs>
    TempLinks?: boolean | GuideLines$TempLinksArgs<ExtArgs>
    Backlink?: boolean | GuideLines$BacklinkArgs<ExtArgs>
    _count?: boolean | GuideLinesCountOutputTypeDefaultArgs<ExtArgs>
  }
  export type GuideLinesIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    TaskUploadedBy?: boolean | UserDefaultArgs<ExtArgs>
  }
  export type GuideLinesIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    TaskUploadedBy?: boolean | UserDefaultArgs<ExtArgs>
  }

  export type $GuideLinesPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "GuideLines"
    objects: {
      TaskUploadedBy: Prisma.$UserPayload<ExtArgs>
      ProjectGuideLines: Prisma.$ProjectGuideLinesPayload<ExtArgs>[]
      TempLinks: Prisma.$TempLinksPayload<ExtArgs>[]
      Backlink: Prisma.$BacklinkPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      task_name: string
      key_name: string
      uploaded_by: number
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
    }, ExtArgs["result"]["guideLines"]>
    composites: {}
  }

  type GuideLinesGetPayload<S extends boolean | null | undefined | GuideLinesDefaultArgs> = $Result.GetResult<Prisma.$GuideLinesPayload, S>

  type GuideLinesCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<GuideLinesFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: GuideLinesCountAggregateInputType | true
    }

  export interface GuideLinesDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['GuideLines'], meta: { name: 'GuideLines' } }
    /**
     * Find zero or one GuideLines that matches the filter.
     * @param {GuideLinesFindUniqueArgs} args - Arguments to find a GuideLines
     * @example
     * // Get one GuideLines
     * const guideLines = await prisma.guideLines.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends GuideLinesFindUniqueArgs>(args: SelectSubset<T, GuideLinesFindUniqueArgs<ExtArgs>>): Prisma__GuideLinesClient<$Result.GetResult<Prisma.$GuideLinesPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one GuideLines that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {GuideLinesFindUniqueOrThrowArgs} args - Arguments to find a GuideLines
     * @example
     * // Get one GuideLines
     * const guideLines = await prisma.guideLines.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends GuideLinesFindUniqueOrThrowArgs>(args: SelectSubset<T, GuideLinesFindUniqueOrThrowArgs<ExtArgs>>): Prisma__GuideLinesClient<$Result.GetResult<Prisma.$GuideLinesPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first GuideLines that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GuideLinesFindFirstArgs} args - Arguments to find a GuideLines
     * @example
     * // Get one GuideLines
     * const guideLines = await prisma.guideLines.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends GuideLinesFindFirstArgs>(args?: SelectSubset<T, GuideLinesFindFirstArgs<ExtArgs>>): Prisma__GuideLinesClient<$Result.GetResult<Prisma.$GuideLinesPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first GuideLines that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GuideLinesFindFirstOrThrowArgs} args - Arguments to find a GuideLines
     * @example
     * // Get one GuideLines
     * const guideLines = await prisma.guideLines.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends GuideLinesFindFirstOrThrowArgs>(args?: SelectSubset<T, GuideLinesFindFirstOrThrowArgs<ExtArgs>>): Prisma__GuideLinesClient<$Result.GetResult<Prisma.$GuideLinesPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more GuideLines that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GuideLinesFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all GuideLines
     * const guideLines = await prisma.guideLines.findMany()
     * 
     * // Get first 10 GuideLines
     * const guideLines = await prisma.guideLines.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const guideLinesWithIdOnly = await prisma.guideLines.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends GuideLinesFindManyArgs>(args?: SelectSubset<T, GuideLinesFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$GuideLinesPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a GuideLines.
     * @param {GuideLinesCreateArgs} args - Arguments to create a GuideLines.
     * @example
     * // Create one GuideLines
     * const GuideLines = await prisma.guideLines.create({
     *   data: {
     *     // ... data to create a GuideLines
     *   }
     * })
     * 
     */
    create<T extends GuideLinesCreateArgs>(args: SelectSubset<T, GuideLinesCreateArgs<ExtArgs>>): Prisma__GuideLinesClient<$Result.GetResult<Prisma.$GuideLinesPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many GuideLines.
     * @param {GuideLinesCreateManyArgs} args - Arguments to create many GuideLines.
     * @example
     * // Create many GuideLines
     * const guideLines = await prisma.guideLines.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends GuideLinesCreateManyArgs>(args?: SelectSubset<T, GuideLinesCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many GuideLines and returns the data saved in the database.
     * @param {GuideLinesCreateManyAndReturnArgs} args - Arguments to create many GuideLines.
     * @example
     * // Create many GuideLines
     * const guideLines = await prisma.guideLines.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many GuideLines and only return the `id`
     * const guideLinesWithIdOnly = await prisma.guideLines.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends GuideLinesCreateManyAndReturnArgs>(args?: SelectSubset<T, GuideLinesCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$GuideLinesPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a GuideLines.
     * @param {GuideLinesDeleteArgs} args - Arguments to delete one GuideLines.
     * @example
     * // Delete one GuideLines
     * const GuideLines = await prisma.guideLines.delete({
     *   where: {
     *     // ... filter to delete one GuideLines
     *   }
     * })
     * 
     */
    delete<T extends GuideLinesDeleteArgs>(args: SelectSubset<T, GuideLinesDeleteArgs<ExtArgs>>): Prisma__GuideLinesClient<$Result.GetResult<Prisma.$GuideLinesPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one GuideLines.
     * @param {GuideLinesUpdateArgs} args - Arguments to update one GuideLines.
     * @example
     * // Update one GuideLines
     * const guideLines = await prisma.guideLines.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends GuideLinesUpdateArgs>(args: SelectSubset<T, GuideLinesUpdateArgs<ExtArgs>>): Prisma__GuideLinesClient<$Result.GetResult<Prisma.$GuideLinesPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more GuideLines.
     * @param {GuideLinesDeleteManyArgs} args - Arguments to filter GuideLines to delete.
     * @example
     * // Delete a few GuideLines
     * const { count } = await prisma.guideLines.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends GuideLinesDeleteManyArgs>(args?: SelectSubset<T, GuideLinesDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more GuideLines.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GuideLinesUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many GuideLines
     * const guideLines = await prisma.guideLines.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends GuideLinesUpdateManyArgs>(args: SelectSubset<T, GuideLinesUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more GuideLines and returns the data updated in the database.
     * @param {GuideLinesUpdateManyAndReturnArgs} args - Arguments to update many GuideLines.
     * @example
     * // Update many GuideLines
     * const guideLines = await prisma.guideLines.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more GuideLines and only return the `id`
     * const guideLinesWithIdOnly = await prisma.guideLines.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends GuideLinesUpdateManyAndReturnArgs>(args: SelectSubset<T, GuideLinesUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$GuideLinesPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one GuideLines.
     * @param {GuideLinesUpsertArgs} args - Arguments to update or create a GuideLines.
     * @example
     * // Update or create a GuideLines
     * const guideLines = await prisma.guideLines.upsert({
     *   create: {
     *     // ... data to create a GuideLines
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the GuideLines we want to update
     *   }
     * })
     */
    upsert<T extends GuideLinesUpsertArgs>(args: SelectSubset<T, GuideLinesUpsertArgs<ExtArgs>>): Prisma__GuideLinesClient<$Result.GetResult<Prisma.$GuideLinesPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of GuideLines.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GuideLinesCountArgs} args - Arguments to filter GuideLines to count.
     * @example
     * // Count the number of GuideLines
     * const count = await prisma.guideLines.count({
     *   where: {
     *     // ... the filter for the GuideLines we want to count
     *   }
     * })
    **/
    count<T extends GuideLinesCountArgs>(
      args?: Subset<T, GuideLinesCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], GuideLinesCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a GuideLines.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GuideLinesAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends GuideLinesAggregateArgs>(args: Subset<T, GuideLinesAggregateArgs>): Prisma.PrismaPromise<GetGuideLinesAggregateType<T>>

    /**
     * Group by GuideLines.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {GuideLinesGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends GuideLinesGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: GuideLinesGroupByArgs['orderBy'] }
        : { orderBy?: GuideLinesGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, GuideLinesGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetGuideLinesGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the GuideLines model
   */
  readonly fields: GuideLinesFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for GuideLines.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__GuideLinesClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    TaskUploadedBy<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    ProjectGuideLines<T extends GuideLines$ProjectGuideLinesArgs<ExtArgs> = {}>(args?: Subset<T, GuideLines$ProjectGuideLinesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectGuideLinesPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    TempLinks<T extends GuideLines$TempLinksArgs<ExtArgs> = {}>(args?: Subset<T, GuideLines$TempLinksArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$TempLinksPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    Backlink<T extends GuideLines$BacklinkArgs<ExtArgs> = {}>(args?: Subset<T, GuideLines$BacklinkArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the GuideLines model
   */ 
  interface GuideLinesFieldRefs {
    readonly id: FieldRef<"GuideLines", 'Int'>
    readonly task_name: FieldRef<"GuideLines", 'String'>
    readonly key_name: FieldRef<"GuideLines", 'String'>
    readonly uploaded_by: FieldRef<"GuideLines", 'Int'>
    readonly created_at: FieldRef<"GuideLines", 'DateTime'>
    readonly updated_at: FieldRef<"GuideLines", 'DateTime'>
    readonly deleted_at: FieldRef<"GuideLines", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * GuideLines findUnique
   */
  export type GuideLinesFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuideLines
     */
    select?: GuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the GuideLines
     */
    omit?: GuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: GuideLinesInclude<ExtArgs> | null
    /**
     * Filter, which GuideLines to fetch.
     */
    where: GuideLinesWhereUniqueInput
  }

  /**
   * GuideLines findUniqueOrThrow
   */
  export type GuideLinesFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuideLines
     */
    select?: GuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the GuideLines
     */
    omit?: GuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: GuideLinesInclude<ExtArgs> | null
    /**
     * Filter, which GuideLines to fetch.
     */
    where: GuideLinesWhereUniqueInput
  }

  /**
   * GuideLines findFirst
   */
  export type GuideLinesFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuideLines
     */
    select?: GuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the GuideLines
     */
    omit?: GuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: GuideLinesInclude<ExtArgs> | null
    /**
     * Filter, which GuideLines to fetch.
     */
    where?: GuideLinesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of GuideLines to fetch.
     */
    orderBy?: GuideLinesOrderByWithRelationInput | GuideLinesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for GuideLines.
     */
    cursor?: GuideLinesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` GuideLines from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` GuideLines.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of GuideLines.
     */
    distinct?: GuideLinesScalarFieldEnum | GuideLinesScalarFieldEnum[]
  }

  /**
   * GuideLines findFirstOrThrow
   */
  export type GuideLinesFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuideLines
     */
    select?: GuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the GuideLines
     */
    omit?: GuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: GuideLinesInclude<ExtArgs> | null
    /**
     * Filter, which GuideLines to fetch.
     */
    where?: GuideLinesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of GuideLines to fetch.
     */
    orderBy?: GuideLinesOrderByWithRelationInput | GuideLinesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for GuideLines.
     */
    cursor?: GuideLinesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` GuideLines from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` GuideLines.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of GuideLines.
     */
    distinct?: GuideLinesScalarFieldEnum | GuideLinesScalarFieldEnum[]
  }

  /**
   * GuideLines findMany
   */
  export type GuideLinesFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuideLines
     */
    select?: GuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the GuideLines
     */
    omit?: GuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: GuideLinesInclude<ExtArgs> | null
    /**
     * Filter, which GuideLines to fetch.
     */
    where?: GuideLinesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of GuideLines to fetch.
     */
    orderBy?: GuideLinesOrderByWithRelationInput | GuideLinesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing GuideLines.
     */
    cursor?: GuideLinesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` GuideLines from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` GuideLines.
     */
    skip?: number
    distinct?: GuideLinesScalarFieldEnum | GuideLinesScalarFieldEnum[]
  }

  /**
   * GuideLines create
   */
  export type GuideLinesCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuideLines
     */
    select?: GuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the GuideLines
     */
    omit?: GuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: GuideLinesInclude<ExtArgs> | null
    /**
     * The data needed to create a GuideLines.
     */
    data: XOR<GuideLinesCreateInput, GuideLinesUncheckedCreateInput>
  }

  /**
   * GuideLines createMany
   */
  export type GuideLinesCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many GuideLines.
     */
    data: GuideLinesCreateManyInput | GuideLinesCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * GuideLines createManyAndReturn
   */
  export type GuideLinesCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuideLines
     */
    select?: GuideLinesSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the GuideLines
     */
    omit?: GuideLinesOmit<ExtArgs> | null
    /**
     * The data used to create many GuideLines.
     */
    data: GuideLinesCreateManyInput | GuideLinesCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: GuideLinesIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * GuideLines update
   */
  export type GuideLinesUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuideLines
     */
    select?: GuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the GuideLines
     */
    omit?: GuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: GuideLinesInclude<ExtArgs> | null
    /**
     * The data needed to update a GuideLines.
     */
    data: XOR<GuideLinesUpdateInput, GuideLinesUncheckedUpdateInput>
    /**
     * Choose, which GuideLines to update.
     */
    where: GuideLinesWhereUniqueInput
  }

  /**
   * GuideLines updateMany
   */
  export type GuideLinesUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update GuideLines.
     */
    data: XOR<GuideLinesUpdateManyMutationInput, GuideLinesUncheckedUpdateManyInput>
    /**
     * Filter which GuideLines to update
     */
    where?: GuideLinesWhereInput
    /**
     * Limit how many GuideLines to update.
     */
    limit?: number
  }

  /**
   * GuideLines updateManyAndReturn
   */
  export type GuideLinesUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuideLines
     */
    select?: GuideLinesSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the GuideLines
     */
    omit?: GuideLinesOmit<ExtArgs> | null
    /**
     * The data used to update GuideLines.
     */
    data: XOR<GuideLinesUpdateManyMutationInput, GuideLinesUncheckedUpdateManyInput>
    /**
     * Filter which GuideLines to update
     */
    where?: GuideLinesWhereInput
    /**
     * Limit how many GuideLines to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: GuideLinesIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * GuideLines upsert
   */
  export type GuideLinesUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuideLines
     */
    select?: GuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the GuideLines
     */
    omit?: GuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: GuideLinesInclude<ExtArgs> | null
    /**
     * The filter to search for the GuideLines to update in case it exists.
     */
    where: GuideLinesWhereUniqueInput
    /**
     * In case the GuideLines found by the `where` argument doesn't exist, create a new GuideLines with this data.
     */
    create: XOR<GuideLinesCreateInput, GuideLinesUncheckedCreateInput>
    /**
     * In case the GuideLines was found with the provided `where` argument, update it with this data.
     */
    update: XOR<GuideLinesUpdateInput, GuideLinesUncheckedUpdateInput>
  }

  /**
   * GuideLines delete
   */
  export type GuideLinesDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuideLines
     */
    select?: GuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the GuideLines
     */
    omit?: GuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: GuideLinesInclude<ExtArgs> | null
    /**
     * Filter which GuideLines to delete.
     */
    where: GuideLinesWhereUniqueInput
  }

  /**
   * GuideLines deleteMany
   */
  export type GuideLinesDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which GuideLines to delete
     */
    where?: GuideLinesWhereInput
    /**
     * Limit how many GuideLines to delete.
     */
    limit?: number
  }

  /**
   * GuideLines.ProjectGuideLines
   */
  export type GuideLines$ProjectGuideLinesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectGuideLines
     */
    select?: ProjectGuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectGuideLines
     */
    omit?: ProjectGuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectGuideLinesInclude<ExtArgs> | null
    where?: ProjectGuideLinesWhereInput
    orderBy?: ProjectGuideLinesOrderByWithRelationInput | ProjectGuideLinesOrderByWithRelationInput[]
    cursor?: ProjectGuideLinesWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ProjectGuideLinesScalarFieldEnum | ProjectGuideLinesScalarFieldEnum[]
  }

  /**
   * GuideLines.TempLinks
   */
  export type GuideLines$TempLinksArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the TempLinks
     */
    select?: TempLinksSelect<ExtArgs> | null
    /**
     * Omit specific fields from the TempLinks
     */
    omit?: TempLinksOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: TempLinksInclude<ExtArgs> | null
    where?: TempLinksWhereInput
    orderBy?: TempLinksOrderByWithRelationInput | TempLinksOrderByWithRelationInput[]
    cursor?: TempLinksWhereUniqueInput
    take?: number
    skip?: number
    distinct?: TempLinksScalarFieldEnum | TempLinksScalarFieldEnum[]
  }

  /**
   * GuideLines.Backlink
   */
  export type GuideLines$BacklinkArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    where?: BacklinkWhereInput
    orderBy?: BacklinkOrderByWithRelationInput | BacklinkOrderByWithRelationInput[]
    cursor?: BacklinkWhereUniqueInput
    take?: number
    skip?: number
    distinct?: BacklinkScalarFieldEnum | BacklinkScalarFieldEnum[]
  }

  /**
   * GuideLines without action
   */
  export type GuideLinesDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuideLines
     */
    select?: GuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the GuideLines
     */
    omit?: GuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: GuideLinesInclude<ExtArgs> | null
  }


  /**
   * Model ProjectGuideLines
   */

  export type AggregateProjectGuideLines = {
    _count: ProjectGuideLinesCountAggregateOutputType | null
    _avg: ProjectGuideLinesAvgAggregateOutputType | null
    _sum: ProjectGuideLinesSumAggregateOutputType | null
    _min: ProjectGuideLinesMinAggregateOutputType | null
    _max: ProjectGuideLinesMaxAggregateOutputType | null
  }

  export type ProjectGuideLinesAvgAggregateOutputType = {
    id: number | null
    guide_id: number | null
    project_id: number | null
    link_count: number | null
    status: number | null
    uploaded_counts: number | null
    guideLinesId: number | null
  }

  export type ProjectGuideLinesSumAggregateOutputType = {
    id: number | null
    guide_id: number | null
    project_id: number | null
    link_count: number | null
    status: number | null
    uploaded_counts: number | null
    guideLinesId: number | null
  }

  export type ProjectGuideLinesMinAggregateOutputType = {
    id: number | null
    guide_id: number | null
    project_id: number | null
    link_count: number | null
    status: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    uploaded_counts: number | null
    guideLinesId: number | null
  }

  export type ProjectGuideLinesMaxAggregateOutputType = {
    id: number | null
    guide_id: number | null
    project_id: number | null
    link_count: number | null
    status: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    uploaded_counts: number | null
    guideLinesId: number | null
  }

  export type ProjectGuideLinesCountAggregateOutputType = {
    id: number
    guide_id: number
    project_id: number
    link_count: number
    status: number
    created_at: number
    updated_at: number
    deleted_at: number
    uploaded_counts: number
    guideLinesId: number
    _all: number
  }


  export type ProjectGuideLinesAvgAggregateInputType = {
    id?: true
    guide_id?: true
    project_id?: true
    link_count?: true
    status?: true
    uploaded_counts?: true
    guideLinesId?: true
  }

  export type ProjectGuideLinesSumAggregateInputType = {
    id?: true
    guide_id?: true
    project_id?: true
    link_count?: true
    status?: true
    uploaded_counts?: true
    guideLinesId?: true
  }

  export type ProjectGuideLinesMinAggregateInputType = {
    id?: true
    guide_id?: true
    project_id?: true
    link_count?: true
    status?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    uploaded_counts?: true
    guideLinesId?: true
  }

  export type ProjectGuideLinesMaxAggregateInputType = {
    id?: true
    guide_id?: true
    project_id?: true
    link_count?: true
    status?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    uploaded_counts?: true
    guideLinesId?: true
  }

  export type ProjectGuideLinesCountAggregateInputType = {
    id?: true
    guide_id?: true
    project_id?: true
    link_count?: true
    status?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    uploaded_counts?: true
    guideLinesId?: true
    _all?: true
  }

  export type ProjectGuideLinesAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ProjectGuideLines to aggregate.
     */
    where?: ProjectGuideLinesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProjectGuideLines to fetch.
     */
    orderBy?: ProjectGuideLinesOrderByWithRelationInput | ProjectGuideLinesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ProjectGuideLinesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProjectGuideLines from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProjectGuideLines.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ProjectGuideLines
    **/
    _count?: true | ProjectGuideLinesCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ProjectGuideLinesAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ProjectGuideLinesSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ProjectGuideLinesMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ProjectGuideLinesMaxAggregateInputType
  }

  export type GetProjectGuideLinesAggregateType<T extends ProjectGuideLinesAggregateArgs> = {
        [P in keyof T & keyof AggregateProjectGuideLines]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateProjectGuideLines[P]>
      : GetScalarType<T[P], AggregateProjectGuideLines[P]>
  }




  export type ProjectGuideLinesGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProjectGuideLinesWhereInput
    orderBy?: ProjectGuideLinesOrderByWithAggregationInput | ProjectGuideLinesOrderByWithAggregationInput[]
    by: ProjectGuideLinesScalarFieldEnum[] | ProjectGuideLinesScalarFieldEnum
    having?: ProjectGuideLinesScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ProjectGuideLinesCountAggregateInputType | true
    _avg?: ProjectGuideLinesAvgAggregateInputType
    _sum?: ProjectGuideLinesSumAggregateInputType
    _min?: ProjectGuideLinesMinAggregateInputType
    _max?: ProjectGuideLinesMaxAggregateInputType
  }

  export type ProjectGuideLinesGroupByOutputType = {
    id: number
    guide_id: number
    project_id: number
    link_count: number
    status: number
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    uploaded_counts: number
    guideLinesId: number | null
    _count: ProjectGuideLinesCountAggregateOutputType | null
    _avg: ProjectGuideLinesAvgAggregateOutputType | null
    _sum: ProjectGuideLinesSumAggregateOutputType | null
    _min: ProjectGuideLinesMinAggregateOutputType | null
    _max: ProjectGuideLinesMaxAggregateOutputType | null
  }

  type GetProjectGuideLinesGroupByPayload<T extends ProjectGuideLinesGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ProjectGuideLinesGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ProjectGuideLinesGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ProjectGuideLinesGroupByOutputType[P]>
            : GetScalarType<T[P], ProjectGuideLinesGroupByOutputType[P]>
        }
      >
    >


  export type ProjectGuideLinesSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    guide_id?: boolean
    project_id?: boolean
    link_count?: boolean
    status?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    uploaded_counts?: boolean
    guideLinesId?: boolean
    GuideLineId?: boolean | seo_packagesDefaultArgs<ExtArgs>
    ProjectGuides?: boolean | ProjectDefaultArgs<ExtArgs>
    GuideLines?: boolean | ProjectGuideLines$GuideLinesArgs<ExtArgs>
  }, ExtArgs["result"]["projectGuideLines"]>

  export type ProjectGuideLinesSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    guide_id?: boolean
    project_id?: boolean
    link_count?: boolean
    status?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    uploaded_counts?: boolean
    guideLinesId?: boolean
    GuideLineId?: boolean | seo_packagesDefaultArgs<ExtArgs>
    ProjectGuides?: boolean | ProjectDefaultArgs<ExtArgs>
    GuideLines?: boolean | ProjectGuideLines$GuideLinesArgs<ExtArgs>
  }, ExtArgs["result"]["projectGuideLines"]>

  export type ProjectGuideLinesSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    guide_id?: boolean
    project_id?: boolean
    link_count?: boolean
    status?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    uploaded_counts?: boolean
    guideLinesId?: boolean
    GuideLineId?: boolean | seo_packagesDefaultArgs<ExtArgs>
    ProjectGuides?: boolean | ProjectDefaultArgs<ExtArgs>
    GuideLines?: boolean | ProjectGuideLines$GuideLinesArgs<ExtArgs>
  }, ExtArgs["result"]["projectGuideLines"]>

  export type ProjectGuideLinesSelectScalar = {
    id?: boolean
    guide_id?: boolean
    project_id?: boolean
    link_count?: boolean
    status?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    uploaded_counts?: boolean
    guideLinesId?: boolean
  }

  export type ProjectGuideLinesOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "guide_id" | "project_id" | "link_count" | "status" | "created_at" | "updated_at" | "deleted_at" | "uploaded_counts" | "guideLinesId", ExtArgs["result"]["projectGuideLines"]>
  export type ProjectGuideLinesInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    GuideLineId?: boolean | seo_packagesDefaultArgs<ExtArgs>
    ProjectGuides?: boolean | ProjectDefaultArgs<ExtArgs>
    GuideLines?: boolean | ProjectGuideLines$GuideLinesArgs<ExtArgs>
  }
  export type ProjectGuideLinesIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    GuideLineId?: boolean | seo_packagesDefaultArgs<ExtArgs>
    ProjectGuides?: boolean | ProjectDefaultArgs<ExtArgs>
    GuideLines?: boolean | ProjectGuideLines$GuideLinesArgs<ExtArgs>
  }
  export type ProjectGuideLinesIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    GuideLineId?: boolean | seo_packagesDefaultArgs<ExtArgs>
    ProjectGuides?: boolean | ProjectDefaultArgs<ExtArgs>
    GuideLines?: boolean | ProjectGuideLines$GuideLinesArgs<ExtArgs>
  }

  export type $ProjectGuideLinesPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "ProjectGuideLines"
    objects: {
      GuideLineId: Prisma.$seo_packagesPayload<ExtArgs>
      ProjectGuides: Prisma.$ProjectPayload<ExtArgs>
      GuideLines: Prisma.$GuideLinesPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      guide_id: number
      project_id: number
      link_count: number
      status: number
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
      uploaded_counts: number
      guideLinesId: number | null
    }, ExtArgs["result"]["projectGuideLines"]>
    composites: {}
  }

  type ProjectGuideLinesGetPayload<S extends boolean | null | undefined | ProjectGuideLinesDefaultArgs> = $Result.GetResult<Prisma.$ProjectGuideLinesPayload, S>

  type ProjectGuideLinesCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<ProjectGuideLinesFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: ProjectGuideLinesCountAggregateInputType | true
    }

  export interface ProjectGuideLinesDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['ProjectGuideLines'], meta: { name: 'ProjectGuideLines' } }
    /**
     * Find zero or one ProjectGuideLines that matches the filter.
     * @param {ProjectGuideLinesFindUniqueArgs} args - Arguments to find a ProjectGuideLines
     * @example
     * // Get one ProjectGuideLines
     * const projectGuideLines = await prisma.projectGuideLines.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ProjectGuideLinesFindUniqueArgs>(args: SelectSubset<T, ProjectGuideLinesFindUniqueArgs<ExtArgs>>): Prisma__ProjectGuideLinesClient<$Result.GetResult<Prisma.$ProjectGuideLinesPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one ProjectGuideLines that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {ProjectGuideLinesFindUniqueOrThrowArgs} args - Arguments to find a ProjectGuideLines
     * @example
     * // Get one ProjectGuideLines
     * const projectGuideLines = await prisma.projectGuideLines.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ProjectGuideLinesFindUniqueOrThrowArgs>(args: SelectSubset<T, ProjectGuideLinesFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ProjectGuideLinesClient<$Result.GetResult<Prisma.$ProjectGuideLinesPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first ProjectGuideLines that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectGuideLinesFindFirstArgs} args - Arguments to find a ProjectGuideLines
     * @example
     * // Get one ProjectGuideLines
     * const projectGuideLines = await prisma.projectGuideLines.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ProjectGuideLinesFindFirstArgs>(args?: SelectSubset<T, ProjectGuideLinesFindFirstArgs<ExtArgs>>): Prisma__ProjectGuideLinesClient<$Result.GetResult<Prisma.$ProjectGuideLinesPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first ProjectGuideLines that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectGuideLinesFindFirstOrThrowArgs} args - Arguments to find a ProjectGuideLines
     * @example
     * // Get one ProjectGuideLines
     * const projectGuideLines = await prisma.projectGuideLines.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ProjectGuideLinesFindFirstOrThrowArgs>(args?: SelectSubset<T, ProjectGuideLinesFindFirstOrThrowArgs<ExtArgs>>): Prisma__ProjectGuideLinesClient<$Result.GetResult<Prisma.$ProjectGuideLinesPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more ProjectGuideLines that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectGuideLinesFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all ProjectGuideLines
     * const projectGuideLines = await prisma.projectGuideLines.findMany()
     * 
     * // Get first 10 ProjectGuideLines
     * const projectGuideLines = await prisma.projectGuideLines.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const projectGuideLinesWithIdOnly = await prisma.projectGuideLines.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ProjectGuideLinesFindManyArgs>(args?: SelectSubset<T, ProjectGuideLinesFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectGuideLinesPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a ProjectGuideLines.
     * @param {ProjectGuideLinesCreateArgs} args - Arguments to create a ProjectGuideLines.
     * @example
     * // Create one ProjectGuideLines
     * const ProjectGuideLines = await prisma.projectGuideLines.create({
     *   data: {
     *     // ... data to create a ProjectGuideLines
     *   }
     * })
     * 
     */
    create<T extends ProjectGuideLinesCreateArgs>(args: SelectSubset<T, ProjectGuideLinesCreateArgs<ExtArgs>>): Prisma__ProjectGuideLinesClient<$Result.GetResult<Prisma.$ProjectGuideLinesPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many ProjectGuideLines.
     * @param {ProjectGuideLinesCreateManyArgs} args - Arguments to create many ProjectGuideLines.
     * @example
     * // Create many ProjectGuideLines
     * const projectGuideLines = await prisma.projectGuideLines.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ProjectGuideLinesCreateManyArgs>(args?: SelectSubset<T, ProjectGuideLinesCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many ProjectGuideLines and returns the data saved in the database.
     * @param {ProjectGuideLinesCreateManyAndReturnArgs} args - Arguments to create many ProjectGuideLines.
     * @example
     * // Create many ProjectGuideLines
     * const projectGuideLines = await prisma.projectGuideLines.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many ProjectGuideLines and only return the `id`
     * const projectGuideLinesWithIdOnly = await prisma.projectGuideLines.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends ProjectGuideLinesCreateManyAndReturnArgs>(args?: SelectSubset<T, ProjectGuideLinesCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectGuideLinesPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a ProjectGuideLines.
     * @param {ProjectGuideLinesDeleteArgs} args - Arguments to delete one ProjectGuideLines.
     * @example
     * // Delete one ProjectGuideLines
     * const ProjectGuideLines = await prisma.projectGuideLines.delete({
     *   where: {
     *     // ... filter to delete one ProjectGuideLines
     *   }
     * })
     * 
     */
    delete<T extends ProjectGuideLinesDeleteArgs>(args: SelectSubset<T, ProjectGuideLinesDeleteArgs<ExtArgs>>): Prisma__ProjectGuideLinesClient<$Result.GetResult<Prisma.$ProjectGuideLinesPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one ProjectGuideLines.
     * @param {ProjectGuideLinesUpdateArgs} args - Arguments to update one ProjectGuideLines.
     * @example
     * // Update one ProjectGuideLines
     * const projectGuideLines = await prisma.projectGuideLines.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ProjectGuideLinesUpdateArgs>(args: SelectSubset<T, ProjectGuideLinesUpdateArgs<ExtArgs>>): Prisma__ProjectGuideLinesClient<$Result.GetResult<Prisma.$ProjectGuideLinesPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more ProjectGuideLines.
     * @param {ProjectGuideLinesDeleteManyArgs} args - Arguments to filter ProjectGuideLines to delete.
     * @example
     * // Delete a few ProjectGuideLines
     * const { count } = await prisma.projectGuideLines.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ProjectGuideLinesDeleteManyArgs>(args?: SelectSubset<T, ProjectGuideLinesDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ProjectGuideLines.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectGuideLinesUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many ProjectGuideLines
     * const projectGuideLines = await prisma.projectGuideLines.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ProjectGuideLinesUpdateManyArgs>(args: SelectSubset<T, ProjectGuideLinesUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more ProjectGuideLines and returns the data updated in the database.
     * @param {ProjectGuideLinesUpdateManyAndReturnArgs} args - Arguments to update many ProjectGuideLines.
     * @example
     * // Update many ProjectGuideLines
     * const projectGuideLines = await prisma.projectGuideLines.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more ProjectGuideLines and only return the `id`
     * const projectGuideLinesWithIdOnly = await prisma.projectGuideLines.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends ProjectGuideLinesUpdateManyAndReturnArgs>(args: SelectSubset<T, ProjectGuideLinesUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectGuideLinesPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one ProjectGuideLines.
     * @param {ProjectGuideLinesUpsertArgs} args - Arguments to update or create a ProjectGuideLines.
     * @example
     * // Update or create a ProjectGuideLines
     * const projectGuideLines = await prisma.projectGuideLines.upsert({
     *   create: {
     *     // ... data to create a ProjectGuideLines
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the ProjectGuideLines we want to update
     *   }
     * })
     */
    upsert<T extends ProjectGuideLinesUpsertArgs>(args: SelectSubset<T, ProjectGuideLinesUpsertArgs<ExtArgs>>): Prisma__ProjectGuideLinesClient<$Result.GetResult<Prisma.$ProjectGuideLinesPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of ProjectGuideLines.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectGuideLinesCountArgs} args - Arguments to filter ProjectGuideLines to count.
     * @example
     * // Count the number of ProjectGuideLines
     * const count = await prisma.projectGuideLines.count({
     *   where: {
     *     // ... the filter for the ProjectGuideLines we want to count
     *   }
     * })
    **/
    count<T extends ProjectGuideLinesCountArgs>(
      args?: Subset<T, ProjectGuideLinesCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ProjectGuideLinesCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a ProjectGuideLines.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectGuideLinesAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ProjectGuideLinesAggregateArgs>(args: Subset<T, ProjectGuideLinesAggregateArgs>): Prisma.PrismaPromise<GetProjectGuideLinesAggregateType<T>>

    /**
     * Group by ProjectGuideLines.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectGuideLinesGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ProjectGuideLinesGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ProjectGuideLinesGroupByArgs['orderBy'] }
        : { orderBy?: ProjectGuideLinesGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ProjectGuideLinesGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetProjectGuideLinesGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the ProjectGuideLines model
   */
  readonly fields: ProjectGuideLinesFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for ProjectGuideLines.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ProjectGuideLinesClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    GuideLineId<T extends seo_packagesDefaultArgs<ExtArgs> = {}>(args?: Subset<T, seo_packagesDefaultArgs<ExtArgs>>): Prisma__seo_packagesClient<$Result.GetResult<Prisma.$seo_packagesPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    ProjectGuides<T extends ProjectDefaultArgs<ExtArgs> = {}>(args?: Subset<T, ProjectDefaultArgs<ExtArgs>>): Prisma__ProjectClient<$Result.GetResult<Prisma.$ProjectPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    GuideLines<T extends ProjectGuideLines$GuideLinesArgs<ExtArgs> = {}>(args?: Subset<T, ProjectGuideLines$GuideLinesArgs<ExtArgs>>): Prisma__GuideLinesClient<$Result.GetResult<Prisma.$GuideLinesPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | null, null, ExtArgs, ClientOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the ProjectGuideLines model
   */ 
  interface ProjectGuideLinesFieldRefs {
    readonly id: FieldRef<"ProjectGuideLines", 'Int'>
    readonly guide_id: FieldRef<"ProjectGuideLines", 'Int'>
    readonly project_id: FieldRef<"ProjectGuideLines", 'Int'>
    readonly link_count: FieldRef<"ProjectGuideLines", 'Int'>
    readonly status: FieldRef<"ProjectGuideLines", 'Int'>
    readonly created_at: FieldRef<"ProjectGuideLines", 'DateTime'>
    readonly updated_at: FieldRef<"ProjectGuideLines", 'DateTime'>
    readonly deleted_at: FieldRef<"ProjectGuideLines", 'DateTime'>
    readonly uploaded_counts: FieldRef<"ProjectGuideLines", 'Int'>
    readonly guideLinesId: FieldRef<"ProjectGuideLines", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * ProjectGuideLines findUnique
   */
  export type ProjectGuideLinesFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectGuideLines
     */
    select?: ProjectGuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectGuideLines
     */
    omit?: ProjectGuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectGuideLinesInclude<ExtArgs> | null
    /**
     * Filter, which ProjectGuideLines to fetch.
     */
    where: ProjectGuideLinesWhereUniqueInput
  }

  /**
   * ProjectGuideLines findUniqueOrThrow
   */
  export type ProjectGuideLinesFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectGuideLines
     */
    select?: ProjectGuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectGuideLines
     */
    omit?: ProjectGuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectGuideLinesInclude<ExtArgs> | null
    /**
     * Filter, which ProjectGuideLines to fetch.
     */
    where: ProjectGuideLinesWhereUniqueInput
  }

  /**
   * ProjectGuideLines findFirst
   */
  export type ProjectGuideLinesFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectGuideLines
     */
    select?: ProjectGuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectGuideLines
     */
    omit?: ProjectGuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectGuideLinesInclude<ExtArgs> | null
    /**
     * Filter, which ProjectGuideLines to fetch.
     */
    where?: ProjectGuideLinesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProjectGuideLines to fetch.
     */
    orderBy?: ProjectGuideLinesOrderByWithRelationInput | ProjectGuideLinesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ProjectGuideLines.
     */
    cursor?: ProjectGuideLinesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProjectGuideLines from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProjectGuideLines.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ProjectGuideLines.
     */
    distinct?: ProjectGuideLinesScalarFieldEnum | ProjectGuideLinesScalarFieldEnum[]
  }

  /**
   * ProjectGuideLines findFirstOrThrow
   */
  export type ProjectGuideLinesFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectGuideLines
     */
    select?: ProjectGuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectGuideLines
     */
    omit?: ProjectGuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectGuideLinesInclude<ExtArgs> | null
    /**
     * Filter, which ProjectGuideLines to fetch.
     */
    where?: ProjectGuideLinesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProjectGuideLines to fetch.
     */
    orderBy?: ProjectGuideLinesOrderByWithRelationInput | ProjectGuideLinesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ProjectGuideLines.
     */
    cursor?: ProjectGuideLinesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProjectGuideLines from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProjectGuideLines.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ProjectGuideLines.
     */
    distinct?: ProjectGuideLinesScalarFieldEnum | ProjectGuideLinesScalarFieldEnum[]
  }

  /**
   * ProjectGuideLines findMany
   */
  export type ProjectGuideLinesFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectGuideLines
     */
    select?: ProjectGuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectGuideLines
     */
    omit?: ProjectGuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectGuideLinesInclude<ExtArgs> | null
    /**
     * Filter, which ProjectGuideLines to fetch.
     */
    where?: ProjectGuideLinesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ProjectGuideLines to fetch.
     */
    orderBy?: ProjectGuideLinesOrderByWithRelationInput | ProjectGuideLinesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing ProjectGuideLines.
     */
    cursor?: ProjectGuideLinesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ProjectGuideLines from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ProjectGuideLines.
     */
    skip?: number
    distinct?: ProjectGuideLinesScalarFieldEnum | ProjectGuideLinesScalarFieldEnum[]
  }

  /**
   * ProjectGuideLines create
   */
  export type ProjectGuideLinesCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectGuideLines
     */
    select?: ProjectGuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectGuideLines
     */
    omit?: ProjectGuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectGuideLinesInclude<ExtArgs> | null
    /**
     * The data needed to create a ProjectGuideLines.
     */
    data: XOR<ProjectGuideLinesCreateInput, ProjectGuideLinesUncheckedCreateInput>
  }

  /**
   * ProjectGuideLines createMany
   */
  export type ProjectGuideLinesCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many ProjectGuideLines.
     */
    data: ProjectGuideLinesCreateManyInput | ProjectGuideLinesCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * ProjectGuideLines createManyAndReturn
   */
  export type ProjectGuideLinesCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectGuideLines
     */
    select?: ProjectGuideLinesSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectGuideLines
     */
    omit?: ProjectGuideLinesOmit<ExtArgs> | null
    /**
     * The data used to create many ProjectGuideLines.
     */
    data: ProjectGuideLinesCreateManyInput | ProjectGuideLinesCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectGuideLinesIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * ProjectGuideLines update
   */
  export type ProjectGuideLinesUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectGuideLines
     */
    select?: ProjectGuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectGuideLines
     */
    omit?: ProjectGuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectGuideLinesInclude<ExtArgs> | null
    /**
     * The data needed to update a ProjectGuideLines.
     */
    data: XOR<ProjectGuideLinesUpdateInput, ProjectGuideLinesUncheckedUpdateInput>
    /**
     * Choose, which ProjectGuideLines to update.
     */
    where: ProjectGuideLinesWhereUniqueInput
  }

  /**
   * ProjectGuideLines updateMany
   */
  export type ProjectGuideLinesUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update ProjectGuideLines.
     */
    data: XOR<ProjectGuideLinesUpdateManyMutationInput, ProjectGuideLinesUncheckedUpdateManyInput>
    /**
     * Filter which ProjectGuideLines to update
     */
    where?: ProjectGuideLinesWhereInput
    /**
     * Limit how many ProjectGuideLines to update.
     */
    limit?: number
  }

  /**
   * ProjectGuideLines updateManyAndReturn
   */
  export type ProjectGuideLinesUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectGuideLines
     */
    select?: ProjectGuideLinesSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectGuideLines
     */
    omit?: ProjectGuideLinesOmit<ExtArgs> | null
    /**
     * The data used to update ProjectGuideLines.
     */
    data: XOR<ProjectGuideLinesUpdateManyMutationInput, ProjectGuideLinesUncheckedUpdateManyInput>
    /**
     * Filter which ProjectGuideLines to update
     */
    where?: ProjectGuideLinesWhereInput
    /**
     * Limit how many ProjectGuideLines to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectGuideLinesIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * ProjectGuideLines upsert
   */
  export type ProjectGuideLinesUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectGuideLines
     */
    select?: ProjectGuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectGuideLines
     */
    omit?: ProjectGuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectGuideLinesInclude<ExtArgs> | null
    /**
     * The filter to search for the ProjectGuideLines to update in case it exists.
     */
    where: ProjectGuideLinesWhereUniqueInput
    /**
     * In case the ProjectGuideLines found by the `where` argument doesn't exist, create a new ProjectGuideLines with this data.
     */
    create: XOR<ProjectGuideLinesCreateInput, ProjectGuideLinesUncheckedCreateInput>
    /**
     * In case the ProjectGuideLines was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ProjectGuideLinesUpdateInput, ProjectGuideLinesUncheckedUpdateInput>
  }

  /**
   * ProjectGuideLines delete
   */
  export type ProjectGuideLinesDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectGuideLines
     */
    select?: ProjectGuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectGuideLines
     */
    omit?: ProjectGuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectGuideLinesInclude<ExtArgs> | null
    /**
     * Filter which ProjectGuideLines to delete.
     */
    where: ProjectGuideLinesWhereUniqueInput
  }

  /**
   * ProjectGuideLines deleteMany
   */
  export type ProjectGuideLinesDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ProjectGuideLines to delete
     */
    where?: ProjectGuideLinesWhereInput
    /**
     * Limit how many ProjectGuideLines to delete.
     */
    limit?: number
  }

  /**
   * ProjectGuideLines.GuideLines
   */
  export type ProjectGuideLines$GuideLinesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the GuideLines
     */
    select?: GuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the GuideLines
     */
    omit?: GuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: GuideLinesInclude<ExtArgs> | null
    where?: GuideLinesWhereInput
  }

  /**
   * ProjectGuideLines without action
   */
  export type ProjectGuideLinesDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectGuideLines
     */
    select?: ProjectGuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectGuideLines
     */
    omit?: ProjectGuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectGuideLinesInclude<ExtArgs> | null
  }


  /**
   * Model seo_packages
   */

  export type AggregateSeo_packages = {
    _count: Seo_packagesCountAggregateOutputType | null
    _avg: Seo_packagesAvgAggregateOutputType | null
    _sum: Seo_packagesSumAggregateOutputType | null
    _min: Seo_packagesMinAggregateOutputType | null
    _max: Seo_packagesMaxAggregateOutputType | null
  }

  export type Seo_packagesAvgAggregateOutputType = {
    id: number | null
    status: number | null
  }

  export type Seo_packagesSumAggregateOutputType = {
    id: number | null
    status: number | null
  }

  export type Seo_packagesMinAggregateOutputType = {
    id: number | null
    status: number | null
    title: string | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type Seo_packagesMaxAggregateOutputType = {
    id: number | null
    status: number | null
    title: string | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type Seo_packagesCountAggregateOutputType = {
    id: number
    status: number
    title: number
    created_at: number
    updated_at: number
    deleted_at: number
    _all: number
  }


  export type Seo_packagesAvgAggregateInputType = {
    id?: true
    status?: true
  }

  export type Seo_packagesSumAggregateInputType = {
    id?: true
    status?: true
  }

  export type Seo_packagesMinAggregateInputType = {
    id?: true
    status?: true
    title?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type Seo_packagesMaxAggregateInputType = {
    id?: true
    status?: true
    title?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type Seo_packagesCountAggregateInputType = {
    id?: true
    status?: true
    title?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    _all?: true
  }

  export type Seo_packagesAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which seo_packages to aggregate.
     */
    where?: seo_packagesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of seo_packages to fetch.
     */
    orderBy?: seo_packagesOrderByWithRelationInput | seo_packagesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: seo_packagesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` seo_packages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` seo_packages.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned seo_packages
    **/
    _count?: true | Seo_packagesCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Seo_packagesAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Seo_packagesSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Seo_packagesMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Seo_packagesMaxAggregateInputType
  }

  export type GetSeo_packagesAggregateType<T extends Seo_packagesAggregateArgs> = {
        [P in keyof T & keyof AggregateSeo_packages]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateSeo_packages[P]>
      : GetScalarType<T[P], AggregateSeo_packages[P]>
  }




  export type seo_packagesGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: seo_packagesWhereInput
    orderBy?: seo_packagesOrderByWithAggregationInput | seo_packagesOrderByWithAggregationInput[]
    by: Seo_packagesScalarFieldEnum[] | Seo_packagesScalarFieldEnum
    having?: seo_packagesScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Seo_packagesCountAggregateInputType | true
    _avg?: Seo_packagesAvgAggregateInputType
    _sum?: Seo_packagesSumAggregateInputType
    _min?: Seo_packagesMinAggregateInputType
    _max?: Seo_packagesMaxAggregateInputType
  }

  export type Seo_packagesGroupByOutputType = {
    id: number
    status: number
    title: string
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    _count: Seo_packagesCountAggregateOutputType | null
    _avg: Seo_packagesAvgAggregateOutputType | null
    _sum: Seo_packagesSumAggregateOutputType | null
    _min: Seo_packagesMinAggregateOutputType | null
    _max: Seo_packagesMaxAggregateOutputType | null
  }

  type GetSeo_packagesGroupByPayload<T extends seo_packagesGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Seo_packagesGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Seo_packagesGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Seo_packagesGroupByOutputType[P]>
            : GetScalarType<T[P], Seo_packagesGroupByOutputType[P]>
        }
      >
    >


  export type seo_packagesSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    status?: boolean
    title?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    package_features?: boolean | seo_packages$package_featuresArgs<ExtArgs>
    Project?: boolean | seo_packages$ProjectArgs<ExtArgs>
    ProjectGuideLines?: boolean | seo_packages$ProjectGuideLinesArgs<ExtArgs>
    _count?: boolean | Seo_packagesCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["seo_packages"]>

  export type seo_packagesSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    status?: boolean
    title?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }, ExtArgs["result"]["seo_packages"]>

  export type seo_packagesSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    status?: boolean
    title?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }, ExtArgs["result"]["seo_packages"]>

  export type seo_packagesSelectScalar = {
    id?: boolean
    status?: boolean
    title?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }

  export type seo_packagesOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "status" | "title" | "created_at" | "updated_at" | "deleted_at", ExtArgs["result"]["seo_packages"]>
  export type seo_packagesInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    package_features?: boolean | seo_packages$package_featuresArgs<ExtArgs>
    Project?: boolean | seo_packages$ProjectArgs<ExtArgs>
    ProjectGuideLines?: boolean | seo_packages$ProjectGuideLinesArgs<ExtArgs>
    _count?: boolean | Seo_packagesCountOutputTypeDefaultArgs<ExtArgs>
  }
  export type seo_packagesIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {}
  export type seo_packagesIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {}

  export type $seo_packagesPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "seo_packages"
    objects: {
      package_features: Prisma.$package_featuresPayload<ExtArgs>[]
      Project: Prisma.$ProjectPayload<ExtArgs>[]
      ProjectGuideLines: Prisma.$ProjectGuideLinesPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      status: number
      title: string
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
    }, ExtArgs["result"]["seo_packages"]>
    composites: {}
  }

  type seo_packagesGetPayload<S extends boolean | null | undefined | seo_packagesDefaultArgs> = $Result.GetResult<Prisma.$seo_packagesPayload, S>

  type seo_packagesCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<seo_packagesFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Seo_packagesCountAggregateInputType | true
    }

  export interface seo_packagesDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['seo_packages'], meta: { name: 'seo_packages' } }
    /**
     * Find zero or one Seo_packages that matches the filter.
     * @param {seo_packagesFindUniqueArgs} args - Arguments to find a Seo_packages
     * @example
     * // Get one Seo_packages
     * const seo_packages = await prisma.seo_packages.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends seo_packagesFindUniqueArgs>(args: SelectSubset<T, seo_packagesFindUniqueArgs<ExtArgs>>): Prisma__seo_packagesClient<$Result.GetResult<Prisma.$seo_packagesPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Seo_packages that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {seo_packagesFindUniqueOrThrowArgs} args - Arguments to find a Seo_packages
     * @example
     * // Get one Seo_packages
     * const seo_packages = await prisma.seo_packages.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends seo_packagesFindUniqueOrThrowArgs>(args: SelectSubset<T, seo_packagesFindUniqueOrThrowArgs<ExtArgs>>): Prisma__seo_packagesClient<$Result.GetResult<Prisma.$seo_packagesPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Seo_packages that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {seo_packagesFindFirstArgs} args - Arguments to find a Seo_packages
     * @example
     * // Get one Seo_packages
     * const seo_packages = await prisma.seo_packages.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends seo_packagesFindFirstArgs>(args?: SelectSubset<T, seo_packagesFindFirstArgs<ExtArgs>>): Prisma__seo_packagesClient<$Result.GetResult<Prisma.$seo_packagesPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Seo_packages that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {seo_packagesFindFirstOrThrowArgs} args - Arguments to find a Seo_packages
     * @example
     * // Get one Seo_packages
     * const seo_packages = await prisma.seo_packages.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends seo_packagesFindFirstOrThrowArgs>(args?: SelectSubset<T, seo_packagesFindFirstOrThrowArgs<ExtArgs>>): Prisma__seo_packagesClient<$Result.GetResult<Prisma.$seo_packagesPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Seo_packages that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {seo_packagesFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Seo_packages
     * const seo_packages = await prisma.seo_packages.findMany()
     * 
     * // Get first 10 Seo_packages
     * const seo_packages = await prisma.seo_packages.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const seo_packagesWithIdOnly = await prisma.seo_packages.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends seo_packagesFindManyArgs>(args?: SelectSubset<T, seo_packagesFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$seo_packagesPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Seo_packages.
     * @param {seo_packagesCreateArgs} args - Arguments to create a Seo_packages.
     * @example
     * // Create one Seo_packages
     * const Seo_packages = await prisma.seo_packages.create({
     *   data: {
     *     // ... data to create a Seo_packages
     *   }
     * })
     * 
     */
    create<T extends seo_packagesCreateArgs>(args: SelectSubset<T, seo_packagesCreateArgs<ExtArgs>>): Prisma__seo_packagesClient<$Result.GetResult<Prisma.$seo_packagesPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Seo_packages.
     * @param {seo_packagesCreateManyArgs} args - Arguments to create many Seo_packages.
     * @example
     * // Create many Seo_packages
     * const seo_packages = await prisma.seo_packages.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends seo_packagesCreateManyArgs>(args?: SelectSubset<T, seo_packagesCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Seo_packages and returns the data saved in the database.
     * @param {seo_packagesCreateManyAndReturnArgs} args - Arguments to create many Seo_packages.
     * @example
     * // Create many Seo_packages
     * const seo_packages = await prisma.seo_packages.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Seo_packages and only return the `id`
     * const seo_packagesWithIdOnly = await prisma.seo_packages.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends seo_packagesCreateManyAndReturnArgs>(args?: SelectSubset<T, seo_packagesCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$seo_packagesPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a Seo_packages.
     * @param {seo_packagesDeleteArgs} args - Arguments to delete one Seo_packages.
     * @example
     * // Delete one Seo_packages
     * const Seo_packages = await prisma.seo_packages.delete({
     *   where: {
     *     // ... filter to delete one Seo_packages
     *   }
     * })
     * 
     */
    delete<T extends seo_packagesDeleteArgs>(args: SelectSubset<T, seo_packagesDeleteArgs<ExtArgs>>): Prisma__seo_packagesClient<$Result.GetResult<Prisma.$seo_packagesPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Seo_packages.
     * @param {seo_packagesUpdateArgs} args - Arguments to update one Seo_packages.
     * @example
     * // Update one Seo_packages
     * const seo_packages = await prisma.seo_packages.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends seo_packagesUpdateArgs>(args: SelectSubset<T, seo_packagesUpdateArgs<ExtArgs>>): Prisma__seo_packagesClient<$Result.GetResult<Prisma.$seo_packagesPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Seo_packages.
     * @param {seo_packagesDeleteManyArgs} args - Arguments to filter Seo_packages to delete.
     * @example
     * // Delete a few Seo_packages
     * const { count } = await prisma.seo_packages.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends seo_packagesDeleteManyArgs>(args?: SelectSubset<T, seo_packagesDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Seo_packages.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {seo_packagesUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Seo_packages
     * const seo_packages = await prisma.seo_packages.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends seo_packagesUpdateManyArgs>(args: SelectSubset<T, seo_packagesUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Seo_packages and returns the data updated in the database.
     * @param {seo_packagesUpdateManyAndReturnArgs} args - Arguments to update many Seo_packages.
     * @example
     * // Update many Seo_packages
     * const seo_packages = await prisma.seo_packages.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Seo_packages and only return the `id`
     * const seo_packagesWithIdOnly = await prisma.seo_packages.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends seo_packagesUpdateManyAndReturnArgs>(args: SelectSubset<T, seo_packagesUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$seo_packagesPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one Seo_packages.
     * @param {seo_packagesUpsertArgs} args - Arguments to update or create a Seo_packages.
     * @example
     * // Update or create a Seo_packages
     * const seo_packages = await prisma.seo_packages.upsert({
     *   create: {
     *     // ... data to create a Seo_packages
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Seo_packages we want to update
     *   }
     * })
     */
    upsert<T extends seo_packagesUpsertArgs>(args: SelectSubset<T, seo_packagesUpsertArgs<ExtArgs>>): Prisma__seo_packagesClient<$Result.GetResult<Prisma.$seo_packagesPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of Seo_packages.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {seo_packagesCountArgs} args - Arguments to filter Seo_packages to count.
     * @example
     * // Count the number of Seo_packages
     * const count = await prisma.seo_packages.count({
     *   where: {
     *     // ... the filter for the Seo_packages we want to count
     *   }
     * })
    **/
    count<T extends seo_packagesCountArgs>(
      args?: Subset<T, seo_packagesCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Seo_packagesCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Seo_packages.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Seo_packagesAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Seo_packagesAggregateArgs>(args: Subset<T, Seo_packagesAggregateArgs>): Prisma.PrismaPromise<GetSeo_packagesAggregateType<T>>

    /**
     * Group by Seo_packages.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {seo_packagesGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends seo_packagesGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: seo_packagesGroupByArgs['orderBy'] }
        : { orderBy?: seo_packagesGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, seo_packagesGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetSeo_packagesGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the seo_packages model
   */
  readonly fields: seo_packagesFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for seo_packages.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__seo_packagesClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    package_features<T extends seo_packages$package_featuresArgs<ExtArgs> = {}>(args?: Subset<T, seo_packages$package_featuresArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    Project<T extends seo_packages$ProjectArgs<ExtArgs> = {}>(args?: Subset<T, seo_packages$ProjectArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    ProjectGuideLines<T extends seo_packages$ProjectGuideLinesArgs<ExtArgs> = {}>(args?: Subset<T, seo_packages$ProjectGuideLinesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectGuideLinesPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the seo_packages model
   */ 
  interface seo_packagesFieldRefs {
    readonly id: FieldRef<"seo_packages", 'Int'>
    readonly status: FieldRef<"seo_packages", 'Int'>
    readonly title: FieldRef<"seo_packages", 'String'>
    readonly created_at: FieldRef<"seo_packages", 'DateTime'>
    readonly updated_at: FieldRef<"seo_packages", 'DateTime'>
    readonly deleted_at: FieldRef<"seo_packages", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * seo_packages findUnique
   */
  export type seo_packagesFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the seo_packages
     */
    select?: seo_packagesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the seo_packages
     */
    omit?: seo_packagesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: seo_packagesInclude<ExtArgs> | null
    /**
     * Filter, which seo_packages to fetch.
     */
    where: seo_packagesWhereUniqueInput
  }

  /**
   * seo_packages findUniqueOrThrow
   */
  export type seo_packagesFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the seo_packages
     */
    select?: seo_packagesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the seo_packages
     */
    omit?: seo_packagesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: seo_packagesInclude<ExtArgs> | null
    /**
     * Filter, which seo_packages to fetch.
     */
    where: seo_packagesWhereUniqueInput
  }

  /**
   * seo_packages findFirst
   */
  export type seo_packagesFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the seo_packages
     */
    select?: seo_packagesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the seo_packages
     */
    omit?: seo_packagesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: seo_packagesInclude<ExtArgs> | null
    /**
     * Filter, which seo_packages to fetch.
     */
    where?: seo_packagesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of seo_packages to fetch.
     */
    orderBy?: seo_packagesOrderByWithRelationInput | seo_packagesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for seo_packages.
     */
    cursor?: seo_packagesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` seo_packages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` seo_packages.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of seo_packages.
     */
    distinct?: Seo_packagesScalarFieldEnum | Seo_packagesScalarFieldEnum[]
  }

  /**
   * seo_packages findFirstOrThrow
   */
  export type seo_packagesFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the seo_packages
     */
    select?: seo_packagesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the seo_packages
     */
    omit?: seo_packagesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: seo_packagesInclude<ExtArgs> | null
    /**
     * Filter, which seo_packages to fetch.
     */
    where?: seo_packagesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of seo_packages to fetch.
     */
    orderBy?: seo_packagesOrderByWithRelationInput | seo_packagesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for seo_packages.
     */
    cursor?: seo_packagesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` seo_packages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` seo_packages.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of seo_packages.
     */
    distinct?: Seo_packagesScalarFieldEnum | Seo_packagesScalarFieldEnum[]
  }

  /**
   * seo_packages findMany
   */
  export type seo_packagesFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the seo_packages
     */
    select?: seo_packagesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the seo_packages
     */
    omit?: seo_packagesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: seo_packagesInclude<ExtArgs> | null
    /**
     * Filter, which seo_packages to fetch.
     */
    where?: seo_packagesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of seo_packages to fetch.
     */
    orderBy?: seo_packagesOrderByWithRelationInput | seo_packagesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing seo_packages.
     */
    cursor?: seo_packagesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` seo_packages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` seo_packages.
     */
    skip?: number
    distinct?: Seo_packagesScalarFieldEnum | Seo_packagesScalarFieldEnum[]
  }

  /**
   * seo_packages create
   */
  export type seo_packagesCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the seo_packages
     */
    select?: seo_packagesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the seo_packages
     */
    omit?: seo_packagesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: seo_packagesInclude<ExtArgs> | null
    /**
     * The data needed to create a seo_packages.
     */
    data: XOR<seo_packagesCreateInput, seo_packagesUncheckedCreateInput>
  }

  /**
   * seo_packages createMany
   */
  export type seo_packagesCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many seo_packages.
     */
    data: seo_packagesCreateManyInput | seo_packagesCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * seo_packages createManyAndReturn
   */
  export type seo_packagesCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the seo_packages
     */
    select?: seo_packagesSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the seo_packages
     */
    omit?: seo_packagesOmit<ExtArgs> | null
    /**
     * The data used to create many seo_packages.
     */
    data: seo_packagesCreateManyInput | seo_packagesCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * seo_packages update
   */
  export type seo_packagesUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the seo_packages
     */
    select?: seo_packagesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the seo_packages
     */
    omit?: seo_packagesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: seo_packagesInclude<ExtArgs> | null
    /**
     * The data needed to update a seo_packages.
     */
    data: XOR<seo_packagesUpdateInput, seo_packagesUncheckedUpdateInput>
    /**
     * Choose, which seo_packages to update.
     */
    where: seo_packagesWhereUniqueInput
  }

  /**
   * seo_packages updateMany
   */
  export type seo_packagesUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update seo_packages.
     */
    data: XOR<seo_packagesUpdateManyMutationInput, seo_packagesUncheckedUpdateManyInput>
    /**
     * Filter which seo_packages to update
     */
    where?: seo_packagesWhereInput
    /**
     * Limit how many seo_packages to update.
     */
    limit?: number
  }

  /**
   * seo_packages updateManyAndReturn
   */
  export type seo_packagesUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the seo_packages
     */
    select?: seo_packagesSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the seo_packages
     */
    omit?: seo_packagesOmit<ExtArgs> | null
    /**
     * The data used to update seo_packages.
     */
    data: XOR<seo_packagesUpdateManyMutationInput, seo_packagesUncheckedUpdateManyInput>
    /**
     * Filter which seo_packages to update
     */
    where?: seo_packagesWhereInput
    /**
     * Limit how many seo_packages to update.
     */
    limit?: number
  }

  /**
   * seo_packages upsert
   */
  export type seo_packagesUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the seo_packages
     */
    select?: seo_packagesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the seo_packages
     */
    omit?: seo_packagesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: seo_packagesInclude<ExtArgs> | null
    /**
     * The filter to search for the seo_packages to update in case it exists.
     */
    where: seo_packagesWhereUniqueInput
    /**
     * In case the seo_packages found by the `where` argument doesn't exist, create a new seo_packages with this data.
     */
    create: XOR<seo_packagesCreateInput, seo_packagesUncheckedCreateInput>
    /**
     * In case the seo_packages was found with the provided `where` argument, update it with this data.
     */
    update: XOR<seo_packagesUpdateInput, seo_packagesUncheckedUpdateInput>
  }

  /**
   * seo_packages delete
   */
  export type seo_packagesDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the seo_packages
     */
    select?: seo_packagesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the seo_packages
     */
    omit?: seo_packagesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: seo_packagesInclude<ExtArgs> | null
    /**
     * Filter which seo_packages to delete.
     */
    where: seo_packagesWhereUniqueInput
  }

  /**
   * seo_packages deleteMany
   */
  export type seo_packagesDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which seo_packages to delete
     */
    where?: seo_packagesWhereInput
    /**
     * Limit how many seo_packages to delete.
     */
    limit?: number
  }

  /**
   * seo_packages.package_features
   */
  export type seo_packages$package_featuresArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelect<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresInclude<ExtArgs> | null
    where?: package_featuresWhereInput
    orderBy?: package_featuresOrderByWithRelationInput | package_featuresOrderByWithRelationInput[]
    cursor?: package_featuresWhereUniqueInput
    take?: number
    skip?: number
    distinct?: Package_featuresScalarFieldEnum | Package_featuresScalarFieldEnum[]
  }

  /**
   * seo_packages.Project
   */
  export type seo_packages$ProjectArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Project
     */
    select?: ProjectSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Project
     */
    omit?: ProjectOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectInclude<ExtArgs> | null
    where?: ProjectWhereInput
    orderBy?: ProjectOrderByWithRelationInput | ProjectOrderByWithRelationInput[]
    cursor?: ProjectWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ProjectScalarFieldEnum | ProjectScalarFieldEnum[]
  }

  /**
   * seo_packages.ProjectGuideLines
   */
  export type seo_packages$ProjectGuideLinesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectGuideLines
     */
    select?: ProjectGuideLinesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ProjectGuideLines
     */
    omit?: ProjectGuideLinesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectGuideLinesInclude<ExtArgs> | null
    where?: ProjectGuideLinesWhereInput
    orderBy?: ProjectGuideLinesOrderByWithRelationInput | ProjectGuideLinesOrderByWithRelationInput[]
    cursor?: ProjectGuideLinesWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ProjectGuideLinesScalarFieldEnum | ProjectGuideLinesScalarFieldEnum[]
  }

  /**
   * seo_packages without action
   */
  export type seo_packagesDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the seo_packages
     */
    select?: seo_packagesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the seo_packages
     */
    omit?: seo_packagesOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: seo_packagesInclude<ExtArgs> | null
  }


  /**
   * Model package_features
   */

  export type AggregatePackage_features = {
    _count: Package_featuresCountAggregateOutputType | null
    _avg: Package_featuresAvgAggregateOutputType | null
    _sum: Package_featuresSumAggregateOutputType | null
    _min: Package_featuresMinAggregateOutputType | null
    _max: Package_featuresMaxAggregateOutputType | null
  }

  export type Package_featuresAvgAggregateOutputType = {
    id: number | null
    package_id: number | null
    competition_analysis: number | null
    competitor_backlinks_opportunity: number | null
    web_2_0_400_600_words_blog_Writing: number | null
    article_writing: number | null
    classified_writing: number | null
    press_release_writing: number | null
    ppt_pdf_creation_writing: number | null
    web_2_0_400_600_words_submission: number | null
    web_2_0_blog_promotion: number | null
    article_submission: number | null
    article_promotion: number | null
    guest_blogging: number | null
    social_bookmarking_links: number | null
    press_release_submission: number | null
    local_citation: number | null
    classified_submissions: number | null
    ppt_submission: number | null
    ppt_promotion_backlinks: number | null
    pdf_submission: number | null
    pdf_promotion_backlinks: number | null
    quora_Q_A: number | null
    profile_creation: number | null
    blog_commenting_niche_edu: number | null
    forum_submission: number | null
    local_citation_submissions: number | null
    customer_reviews_ratings: number | null
    local_classified_ads: number | null
    status: number | null
  }

  export type Package_featuresSumAggregateOutputType = {
    id: number | null
    package_id: number | null
    competition_analysis: number | null
    competitor_backlinks_opportunity: number | null
    web_2_0_400_600_words_blog_Writing: number | null
    article_writing: number | null
    classified_writing: number | null
    press_release_writing: number | null
    ppt_pdf_creation_writing: number | null
    web_2_0_400_600_words_submission: number | null
    web_2_0_blog_promotion: number | null
    article_submission: number | null
    article_promotion: number | null
    guest_blogging: number | null
    social_bookmarking_links: number | null
    press_release_submission: number | null
    local_citation: number | null
    classified_submissions: number | null
    ppt_submission: number | null
    ppt_promotion_backlinks: number | null
    pdf_submission: number | null
    pdf_promotion_backlinks: number | null
    quora_Q_A: number | null
    profile_creation: number | null
    blog_commenting_niche_edu: number | null
    forum_submission: number | null
    local_citation_submissions: number | null
    customer_reviews_ratings: number | null
    local_classified_ads: number | null
    status: number | null
  }

  export type Package_featuresMinAggregateOutputType = {
    id: number | null
    package_id: number | null
    website_analysis: boolean | null
    content_duplicacy: boolean | null
    initial_backlinks: boolean | null
    critical_seo_analysis: boolean | null
    google_penalty_check: boolean | null
    competition_analysis: number | null
    competitor_backlinks_opportunity: number | null
    keyword_research_analysis: boolean | null
    on_page_optimization: boolean | null
    title_tags_optimization: boolean | null
    meta_tags_optimization: boolean | null
    content_optimization: boolean | null
    html_code_optimization: boolean | null
    website_permalinks_analysis: boolean | null
    seo_friendly_urls: boolean | null
    schema_markup_analysis: boolean | null
    internal_linking_optimization: boolean | null
    crawl_error_resolution: boolean | null
    heading_tags_optimization: boolean | null
    canonicalization_301_redirect: boolean | null
    custom_404_errors: boolean | null
    images_optimization: boolean | null
    hyperlink_optimization: boolean | null
    robots_txt_creation_optimization: boolean | null
    sitemap_creation: boolean | null
    google_webmaster_tools_setup: boolean | null
    bing_Webmaster_tools_setup: boolean | null
    google_analytics_setup_Integration: boolean | null
    website_responsive_check: boolean | null
    page_speed_analysis: boolean | null
    mobile_responsive_compatibility_check: boolean | null
    navigation_ux_factors: boolean | null
    ssl_certificate: boolean | null
    web_2_0_400_600_words_blog_Writing: number | null
    article_writing: number | null
    classified_writing: number | null
    press_release_writing: number | null
    ppt_pdf_creation_writing: number | null
    web_2_0_400_600_words_submission: number | null
    web_2_0_blog_promotion: number | null
    article_submission: number | null
    article_promotion: number | null
    guest_blogging: number | null
    custom_graphics_to_support_your_blogs: boolean | null
    social_bookmarking_links: number | null
    press_release_submission: number | null
    local_citation: number | null
    classified_submissions: number | null
    ppt_submission: number | null
    ppt_promotion_backlinks: number | null
    pdf_submission: number | null
    pdf_promotion_backlinks: number | null
    quora_Q_A: number | null
    profile_creation: number | null
    blog_commenting_niche_edu: number | null
    forum_submission: number | null
    google_my_business_setup_verification: boolean | null
    local_citation_submissions: number | null
    google_places_photo_multimedia_additions: boolean | null
    customer_reviews_ratings: number | null
    local_classified_ads: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    status: number | null
  }

  export type Package_featuresMaxAggregateOutputType = {
    id: number | null
    package_id: number | null
    website_analysis: boolean | null
    content_duplicacy: boolean | null
    initial_backlinks: boolean | null
    critical_seo_analysis: boolean | null
    google_penalty_check: boolean | null
    competition_analysis: number | null
    competitor_backlinks_opportunity: number | null
    keyword_research_analysis: boolean | null
    on_page_optimization: boolean | null
    title_tags_optimization: boolean | null
    meta_tags_optimization: boolean | null
    content_optimization: boolean | null
    html_code_optimization: boolean | null
    website_permalinks_analysis: boolean | null
    seo_friendly_urls: boolean | null
    schema_markup_analysis: boolean | null
    internal_linking_optimization: boolean | null
    crawl_error_resolution: boolean | null
    heading_tags_optimization: boolean | null
    canonicalization_301_redirect: boolean | null
    custom_404_errors: boolean | null
    images_optimization: boolean | null
    hyperlink_optimization: boolean | null
    robots_txt_creation_optimization: boolean | null
    sitemap_creation: boolean | null
    google_webmaster_tools_setup: boolean | null
    bing_Webmaster_tools_setup: boolean | null
    google_analytics_setup_Integration: boolean | null
    website_responsive_check: boolean | null
    page_speed_analysis: boolean | null
    mobile_responsive_compatibility_check: boolean | null
    navigation_ux_factors: boolean | null
    ssl_certificate: boolean | null
    web_2_0_400_600_words_blog_Writing: number | null
    article_writing: number | null
    classified_writing: number | null
    press_release_writing: number | null
    ppt_pdf_creation_writing: number | null
    web_2_0_400_600_words_submission: number | null
    web_2_0_blog_promotion: number | null
    article_submission: number | null
    article_promotion: number | null
    guest_blogging: number | null
    custom_graphics_to_support_your_blogs: boolean | null
    social_bookmarking_links: number | null
    press_release_submission: number | null
    local_citation: number | null
    classified_submissions: number | null
    ppt_submission: number | null
    ppt_promotion_backlinks: number | null
    pdf_submission: number | null
    pdf_promotion_backlinks: number | null
    quora_Q_A: number | null
    profile_creation: number | null
    blog_commenting_niche_edu: number | null
    forum_submission: number | null
    google_my_business_setup_verification: boolean | null
    local_citation_submissions: number | null
    google_places_photo_multimedia_additions: boolean | null
    customer_reviews_ratings: number | null
    local_classified_ads: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    status: number | null
  }

  export type Package_featuresCountAggregateOutputType = {
    id: number
    package_id: number
    website_analysis: number
    content_duplicacy: number
    initial_backlinks: number
    critical_seo_analysis: number
    google_penalty_check: number
    competition_analysis: number
    competitor_backlinks_opportunity: number
    keyword_research_analysis: number
    on_page_optimization: number
    title_tags_optimization: number
    meta_tags_optimization: number
    content_optimization: number
    html_code_optimization: number
    website_permalinks_analysis: number
    seo_friendly_urls: number
    schema_markup_analysis: number
    internal_linking_optimization: number
    crawl_error_resolution: number
    heading_tags_optimization: number
    canonicalization_301_redirect: number
    custom_404_errors: number
    images_optimization: number
    hyperlink_optimization: number
    robots_txt_creation_optimization: number
    sitemap_creation: number
    google_webmaster_tools_setup: number
    bing_Webmaster_tools_setup: number
    google_analytics_setup_Integration: number
    website_responsive_check: number
    page_speed_analysis: number
    mobile_responsive_compatibility_check: number
    navigation_ux_factors: number
    ssl_certificate: number
    web_2_0_400_600_words_blog_Writing: number
    article_writing: number
    classified_writing: number
    press_release_writing: number
    ppt_pdf_creation_writing: number
    web_2_0_400_600_words_submission: number
    web_2_0_blog_promotion: number
    article_submission: number
    article_promotion: number
    guest_blogging: number
    custom_graphics_to_support_your_blogs: number
    social_bookmarking_links: number
    press_release_submission: number
    local_citation: number
    classified_submissions: number
    ppt_submission: number
    ppt_promotion_backlinks: number
    pdf_submission: number
    pdf_promotion_backlinks: number
    quora_Q_A: number
    profile_creation: number
    blog_commenting_niche_edu: number
    forum_submission: number
    google_my_business_setup_verification: number
    local_citation_submissions: number
    google_places_photo_multimedia_additions: number
    customer_reviews_ratings: number
    local_classified_ads: number
    created_at: number
    updated_at: number
    deleted_at: number
    status: number
    _all: number
  }


  export type Package_featuresAvgAggregateInputType = {
    id?: true
    package_id?: true
    competition_analysis?: true
    competitor_backlinks_opportunity?: true
    web_2_0_400_600_words_blog_Writing?: true
    article_writing?: true
    classified_writing?: true
    press_release_writing?: true
    ppt_pdf_creation_writing?: true
    web_2_0_400_600_words_submission?: true
    web_2_0_blog_promotion?: true
    article_submission?: true
    article_promotion?: true
    guest_blogging?: true
    social_bookmarking_links?: true
    press_release_submission?: true
    local_citation?: true
    classified_submissions?: true
    ppt_submission?: true
    ppt_promotion_backlinks?: true
    pdf_submission?: true
    pdf_promotion_backlinks?: true
    quora_Q_A?: true
    profile_creation?: true
    blog_commenting_niche_edu?: true
    forum_submission?: true
    local_citation_submissions?: true
    customer_reviews_ratings?: true
    local_classified_ads?: true
    status?: true
  }

  export type Package_featuresSumAggregateInputType = {
    id?: true
    package_id?: true
    competition_analysis?: true
    competitor_backlinks_opportunity?: true
    web_2_0_400_600_words_blog_Writing?: true
    article_writing?: true
    classified_writing?: true
    press_release_writing?: true
    ppt_pdf_creation_writing?: true
    web_2_0_400_600_words_submission?: true
    web_2_0_blog_promotion?: true
    article_submission?: true
    article_promotion?: true
    guest_blogging?: true
    social_bookmarking_links?: true
    press_release_submission?: true
    local_citation?: true
    classified_submissions?: true
    ppt_submission?: true
    ppt_promotion_backlinks?: true
    pdf_submission?: true
    pdf_promotion_backlinks?: true
    quora_Q_A?: true
    profile_creation?: true
    blog_commenting_niche_edu?: true
    forum_submission?: true
    local_citation_submissions?: true
    customer_reviews_ratings?: true
    local_classified_ads?: true
    status?: true
  }

  export type Package_featuresMinAggregateInputType = {
    id?: true
    package_id?: true
    website_analysis?: true
    content_duplicacy?: true
    initial_backlinks?: true
    critical_seo_analysis?: true
    google_penalty_check?: true
    competition_analysis?: true
    competitor_backlinks_opportunity?: true
    keyword_research_analysis?: true
    on_page_optimization?: true
    title_tags_optimization?: true
    meta_tags_optimization?: true
    content_optimization?: true
    html_code_optimization?: true
    website_permalinks_analysis?: true
    seo_friendly_urls?: true
    schema_markup_analysis?: true
    internal_linking_optimization?: true
    crawl_error_resolution?: true
    heading_tags_optimization?: true
    canonicalization_301_redirect?: true
    custom_404_errors?: true
    images_optimization?: true
    hyperlink_optimization?: true
    robots_txt_creation_optimization?: true
    sitemap_creation?: true
    google_webmaster_tools_setup?: true
    bing_Webmaster_tools_setup?: true
    google_analytics_setup_Integration?: true
    website_responsive_check?: true
    page_speed_analysis?: true
    mobile_responsive_compatibility_check?: true
    navigation_ux_factors?: true
    ssl_certificate?: true
    web_2_0_400_600_words_blog_Writing?: true
    article_writing?: true
    classified_writing?: true
    press_release_writing?: true
    ppt_pdf_creation_writing?: true
    web_2_0_400_600_words_submission?: true
    web_2_0_blog_promotion?: true
    article_submission?: true
    article_promotion?: true
    guest_blogging?: true
    custom_graphics_to_support_your_blogs?: true
    social_bookmarking_links?: true
    press_release_submission?: true
    local_citation?: true
    classified_submissions?: true
    ppt_submission?: true
    ppt_promotion_backlinks?: true
    pdf_submission?: true
    pdf_promotion_backlinks?: true
    quora_Q_A?: true
    profile_creation?: true
    blog_commenting_niche_edu?: true
    forum_submission?: true
    google_my_business_setup_verification?: true
    local_citation_submissions?: true
    google_places_photo_multimedia_additions?: true
    customer_reviews_ratings?: true
    local_classified_ads?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    status?: true
  }

  export type Package_featuresMaxAggregateInputType = {
    id?: true
    package_id?: true
    website_analysis?: true
    content_duplicacy?: true
    initial_backlinks?: true
    critical_seo_analysis?: true
    google_penalty_check?: true
    competition_analysis?: true
    competitor_backlinks_opportunity?: true
    keyword_research_analysis?: true
    on_page_optimization?: true
    title_tags_optimization?: true
    meta_tags_optimization?: true
    content_optimization?: true
    html_code_optimization?: true
    website_permalinks_analysis?: true
    seo_friendly_urls?: true
    schema_markup_analysis?: true
    internal_linking_optimization?: true
    crawl_error_resolution?: true
    heading_tags_optimization?: true
    canonicalization_301_redirect?: true
    custom_404_errors?: true
    images_optimization?: true
    hyperlink_optimization?: true
    robots_txt_creation_optimization?: true
    sitemap_creation?: true
    google_webmaster_tools_setup?: true
    bing_Webmaster_tools_setup?: true
    google_analytics_setup_Integration?: true
    website_responsive_check?: true
    page_speed_analysis?: true
    mobile_responsive_compatibility_check?: true
    navigation_ux_factors?: true
    ssl_certificate?: true
    web_2_0_400_600_words_blog_Writing?: true
    article_writing?: true
    classified_writing?: true
    press_release_writing?: true
    ppt_pdf_creation_writing?: true
    web_2_0_400_600_words_submission?: true
    web_2_0_blog_promotion?: true
    article_submission?: true
    article_promotion?: true
    guest_blogging?: true
    custom_graphics_to_support_your_blogs?: true
    social_bookmarking_links?: true
    press_release_submission?: true
    local_citation?: true
    classified_submissions?: true
    ppt_submission?: true
    ppt_promotion_backlinks?: true
    pdf_submission?: true
    pdf_promotion_backlinks?: true
    quora_Q_A?: true
    profile_creation?: true
    blog_commenting_niche_edu?: true
    forum_submission?: true
    google_my_business_setup_verification?: true
    local_citation_submissions?: true
    google_places_photo_multimedia_additions?: true
    customer_reviews_ratings?: true
    local_classified_ads?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    status?: true
  }

  export type Package_featuresCountAggregateInputType = {
    id?: true
    package_id?: true
    website_analysis?: true
    content_duplicacy?: true
    initial_backlinks?: true
    critical_seo_analysis?: true
    google_penalty_check?: true
    competition_analysis?: true
    competitor_backlinks_opportunity?: true
    keyword_research_analysis?: true
    on_page_optimization?: true
    title_tags_optimization?: true
    meta_tags_optimization?: true
    content_optimization?: true
    html_code_optimization?: true
    website_permalinks_analysis?: true
    seo_friendly_urls?: true
    schema_markup_analysis?: true
    internal_linking_optimization?: true
    crawl_error_resolution?: true
    heading_tags_optimization?: true
    canonicalization_301_redirect?: true
    custom_404_errors?: true
    images_optimization?: true
    hyperlink_optimization?: true
    robots_txt_creation_optimization?: true
    sitemap_creation?: true
    google_webmaster_tools_setup?: true
    bing_Webmaster_tools_setup?: true
    google_analytics_setup_Integration?: true
    website_responsive_check?: true
    page_speed_analysis?: true
    mobile_responsive_compatibility_check?: true
    navigation_ux_factors?: true
    ssl_certificate?: true
    web_2_0_400_600_words_blog_Writing?: true
    article_writing?: true
    classified_writing?: true
    press_release_writing?: true
    ppt_pdf_creation_writing?: true
    web_2_0_400_600_words_submission?: true
    web_2_0_blog_promotion?: true
    article_submission?: true
    article_promotion?: true
    guest_blogging?: true
    custom_graphics_to_support_your_blogs?: true
    social_bookmarking_links?: true
    press_release_submission?: true
    local_citation?: true
    classified_submissions?: true
    ppt_submission?: true
    ppt_promotion_backlinks?: true
    pdf_submission?: true
    pdf_promotion_backlinks?: true
    quora_Q_A?: true
    profile_creation?: true
    blog_commenting_niche_edu?: true
    forum_submission?: true
    google_my_business_setup_verification?: true
    local_citation_submissions?: true
    google_places_photo_multimedia_additions?: true
    customer_reviews_ratings?: true
    local_classified_ads?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    status?: true
    _all?: true
  }

  export type Package_featuresAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which package_features to aggregate.
     */
    where?: package_featuresWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of package_features to fetch.
     */
    orderBy?: package_featuresOrderByWithRelationInput | package_featuresOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: package_featuresWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` package_features from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` package_features.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned package_features
    **/
    _count?: true | Package_featuresCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Package_featuresAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Package_featuresSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Package_featuresMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Package_featuresMaxAggregateInputType
  }

  export type GetPackage_featuresAggregateType<T extends Package_featuresAggregateArgs> = {
        [P in keyof T & keyof AggregatePackage_features]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregatePackage_features[P]>
      : GetScalarType<T[P], AggregatePackage_features[P]>
  }




  export type package_featuresGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: package_featuresWhereInput
    orderBy?: package_featuresOrderByWithAggregationInput | package_featuresOrderByWithAggregationInput[]
    by: Package_featuresScalarFieldEnum[] | Package_featuresScalarFieldEnum
    having?: package_featuresScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Package_featuresCountAggregateInputType | true
    _avg?: Package_featuresAvgAggregateInputType
    _sum?: Package_featuresSumAggregateInputType
    _min?: Package_featuresMinAggregateInputType
    _max?: Package_featuresMaxAggregateInputType
  }

  export type Package_featuresGroupByOutputType = {
    id: number
    package_id: number
    website_analysis: boolean
    content_duplicacy: boolean
    initial_backlinks: boolean
    critical_seo_analysis: boolean
    google_penalty_check: boolean
    competition_analysis: number
    competitor_backlinks_opportunity: number
    keyword_research_analysis: boolean
    on_page_optimization: boolean
    title_tags_optimization: boolean
    meta_tags_optimization: boolean
    content_optimization: boolean
    html_code_optimization: boolean
    website_permalinks_analysis: boolean
    seo_friendly_urls: boolean
    schema_markup_analysis: boolean
    internal_linking_optimization: boolean
    crawl_error_resolution: boolean
    heading_tags_optimization: boolean
    canonicalization_301_redirect: boolean
    custom_404_errors: boolean
    images_optimization: boolean
    hyperlink_optimization: boolean
    robots_txt_creation_optimization: boolean
    sitemap_creation: boolean
    google_webmaster_tools_setup: boolean
    bing_Webmaster_tools_setup: boolean
    google_analytics_setup_Integration: boolean
    website_responsive_check: boolean
    page_speed_analysis: boolean
    mobile_responsive_compatibility_check: boolean
    navigation_ux_factors: boolean
    ssl_certificate: boolean
    web_2_0_400_600_words_blog_Writing: number
    article_writing: number
    classified_writing: number
    press_release_writing: number
    ppt_pdf_creation_writing: number
    web_2_0_400_600_words_submission: number
    web_2_0_blog_promotion: number
    article_submission: number
    article_promotion: number
    guest_blogging: number
    custom_graphics_to_support_your_blogs: boolean
    social_bookmarking_links: number
    press_release_submission: number
    local_citation: number
    classified_submissions: number
    ppt_submission: number
    ppt_promotion_backlinks: number
    pdf_submission: number
    pdf_promotion_backlinks: number
    quora_Q_A: number
    profile_creation: number
    blog_commenting_niche_edu: number
    forum_submission: number
    google_my_business_setup_verification: boolean
    local_citation_submissions: number
    google_places_photo_multimedia_additions: boolean
    customer_reviews_ratings: number
    local_classified_ads: number
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    status: number | null
    _count: Package_featuresCountAggregateOutputType | null
    _avg: Package_featuresAvgAggregateOutputType | null
    _sum: Package_featuresSumAggregateOutputType | null
    _min: Package_featuresMinAggregateOutputType | null
    _max: Package_featuresMaxAggregateOutputType | null
  }

  type GetPackage_featuresGroupByPayload<T extends package_featuresGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Package_featuresGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Package_featuresGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Package_featuresGroupByOutputType[P]>
            : GetScalarType<T[P], Package_featuresGroupByOutputType[P]>
        }
      >
    >


  export type package_featuresSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    package_id?: boolean
    website_analysis?: boolean
    content_duplicacy?: boolean
    initial_backlinks?: boolean
    critical_seo_analysis?: boolean
    google_penalty_check?: boolean
    competition_analysis?: boolean
    competitor_backlinks_opportunity?: boolean
    keyword_research_analysis?: boolean
    on_page_optimization?: boolean
    title_tags_optimization?: boolean
    meta_tags_optimization?: boolean
    content_optimization?: boolean
    html_code_optimization?: boolean
    website_permalinks_analysis?: boolean
    seo_friendly_urls?: boolean
    schema_markup_analysis?: boolean
    internal_linking_optimization?: boolean
    crawl_error_resolution?: boolean
    heading_tags_optimization?: boolean
    canonicalization_301_redirect?: boolean
    custom_404_errors?: boolean
    images_optimization?: boolean
    hyperlink_optimization?: boolean
    robots_txt_creation_optimization?: boolean
    sitemap_creation?: boolean
    google_webmaster_tools_setup?: boolean
    bing_Webmaster_tools_setup?: boolean
    google_analytics_setup_Integration?: boolean
    website_responsive_check?: boolean
    page_speed_analysis?: boolean
    mobile_responsive_compatibility_check?: boolean
    navigation_ux_factors?: boolean
    ssl_certificate?: boolean
    web_2_0_400_600_words_blog_Writing?: boolean
    article_writing?: boolean
    classified_writing?: boolean
    press_release_writing?: boolean
    ppt_pdf_creation_writing?: boolean
    web_2_0_400_600_words_submission?: boolean
    web_2_0_blog_promotion?: boolean
    article_submission?: boolean
    article_promotion?: boolean
    guest_blogging?: boolean
    custom_graphics_to_support_your_blogs?: boolean
    social_bookmarking_links?: boolean
    press_release_submission?: boolean
    local_citation?: boolean
    classified_submissions?: boolean
    ppt_submission?: boolean
    ppt_promotion_backlinks?: boolean
    pdf_submission?: boolean
    pdf_promotion_backlinks?: boolean
    quora_Q_A?: boolean
    profile_creation?: boolean
    blog_commenting_niche_edu?: boolean
    forum_submission?: boolean
    google_my_business_setup_verification?: boolean
    local_citation_submissions?: boolean
    google_places_photo_multimedia_additions?: boolean
    customer_reviews_ratings?: boolean
    local_classified_ads?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    status?: boolean
    SeoPackageFeatures?: boolean | seo_packagesDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["package_features"]>

  export type package_featuresSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    package_id?: boolean
    website_analysis?: boolean
    content_duplicacy?: boolean
    initial_backlinks?: boolean
    critical_seo_analysis?: boolean
    google_penalty_check?: boolean
    competition_analysis?: boolean
    competitor_backlinks_opportunity?: boolean
    keyword_research_analysis?: boolean
    on_page_optimization?: boolean
    title_tags_optimization?: boolean
    meta_tags_optimization?: boolean
    content_optimization?: boolean
    html_code_optimization?: boolean
    website_permalinks_analysis?: boolean
    seo_friendly_urls?: boolean
    schema_markup_analysis?: boolean
    internal_linking_optimization?: boolean
    crawl_error_resolution?: boolean
    heading_tags_optimization?: boolean
    canonicalization_301_redirect?: boolean
    custom_404_errors?: boolean
    images_optimization?: boolean
    hyperlink_optimization?: boolean
    robots_txt_creation_optimization?: boolean
    sitemap_creation?: boolean
    google_webmaster_tools_setup?: boolean
    bing_Webmaster_tools_setup?: boolean
    google_analytics_setup_Integration?: boolean
    website_responsive_check?: boolean
    page_speed_analysis?: boolean
    mobile_responsive_compatibility_check?: boolean
    navigation_ux_factors?: boolean
    ssl_certificate?: boolean
    web_2_0_400_600_words_blog_Writing?: boolean
    article_writing?: boolean
    classified_writing?: boolean
    press_release_writing?: boolean
    ppt_pdf_creation_writing?: boolean
    web_2_0_400_600_words_submission?: boolean
    web_2_0_blog_promotion?: boolean
    article_submission?: boolean
    article_promotion?: boolean
    guest_blogging?: boolean
    custom_graphics_to_support_your_blogs?: boolean
    social_bookmarking_links?: boolean
    press_release_submission?: boolean
    local_citation?: boolean
    classified_submissions?: boolean
    ppt_submission?: boolean
    ppt_promotion_backlinks?: boolean
    pdf_submission?: boolean
    pdf_promotion_backlinks?: boolean
    quora_Q_A?: boolean
    profile_creation?: boolean
    blog_commenting_niche_edu?: boolean
    forum_submission?: boolean
    google_my_business_setup_verification?: boolean
    local_citation_submissions?: boolean
    google_places_photo_multimedia_additions?: boolean
    customer_reviews_ratings?: boolean
    local_classified_ads?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    status?: boolean
    SeoPackageFeatures?: boolean | seo_packagesDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["package_features"]>

  export type package_featuresSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    package_id?: boolean
    website_analysis?: boolean
    content_duplicacy?: boolean
    initial_backlinks?: boolean
    critical_seo_analysis?: boolean
    google_penalty_check?: boolean
    competition_analysis?: boolean
    competitor_backlinks_opportunity?: boolean
    keyword_research_analysis?: boolean
    on_page_optimization?: boolean
    title_tags_optimization?: boolean
    meta_tags_optimization?: boolean
    content_optimization?: boolean
    html_code_optimization?: boolean
    website_permalinks_analysis?: boolean
    seo_friendly_urls?: boolean
    schema_markup_analysis?: boolean
    internal_linking_optimization?: boolean
    crawl_error_resolution?: boolean
    heading_tags_optimization?: boolean
    canonicalization_301_redirect?: boolean
    custom_404_errors?: boolean
    images_optimization?: boolean
    hyperlink_optimization?: boolean
    robots_txt_creation_optimization?: boolean
    sitemap_creation?: boolean
    google_webmaster_tools_setup?: boolean
    bing_Webmaster_tools_setup?: boolean
    google_analytics_setup_Integration?: boolean
    website_responsive_check?: boolean
    page_speed_analysis?: boolean
    mobile_responsive_compatibility_check?: boolean
    navigation_ux_factors?: boolean
    ssl_certificate?: boolean
    web_2_0_400_600_words_blog_Writing?: boolean
    article_writing?: boolean
    classified_writing?: boolean
    press_release_writing?: boolean
    ppt_pdf_creation_writing?: boolean
    web_2_0_400_600_words_submission?: boolean
    web_2_0_blog_promotion?: boolean
    article_submission?: boolean
    article_promotion?: boolean
    guest_blogging?: boolean
    custom_graphics_to_support_your_blogs?: boolean
    social_bookmarking_links?: boolean
    press_release_submission?: boolean
    local_citation?: boolean
    classified_submissions?: boolean
    ppt_submission?: boolean
    ppt_promotion_backlinks?: boolean
    pdf_submission?: boolean
    pdf_promotion_backlinks?: boolean
    quora_Q_A?: boolean
    profile_creation?: boolean
    blog_commenting_niche_edu?: boolean
    forum_submission?: boolean
    google_my_business_setup_verification?: boolean
    local_citation_submissions?: boolean
    google_places_photo_multimedia_additions?: boolean
    customer_reviews_ratings?: boolean
    local_classified_ads?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    status?: boolean
    SeoPackageFeatures?: boolean | seo_packagesDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["package_features"]>

  export type package_featuresSelectScalar = {
    id?: boolean
    package_id?: boolean
    website_analysis?: boolean
    content_duplicacy?: boolean
    initial_backlinks?: boolean
    critical_seo_analysis?: boolean
    google_penalty_check?: boolean
    competition_analysis?: boolean
    competitor_backlinks_opportunity?: boolean
    keyword_research_analysis?: boolean
    on_page_optimization?: boolean
    title_tags_optimization?: boolean
    meta_tags_optimization?: boolean
    content_optimization?: boolean
    html_code_optimization?: boolean
    website_permalinks_analysis?: boolean
    seo_friendly_urls?: boolean
    schema_markup_analysis?: boolean
    internal_linking_optimization?: boolean
    crawl_error_resolution?: boolean
    heading_tags_optimization?: boolean
    canonicalization_301_redirect?: boolean
    custom_404_errors?: boolean
    images_optimization?: boolean
    hyperlink_optimization?: boolean
    robots_txt_creation_optimization?: boolean
    sitemap_creation?: boolean
    google_webmaster_tools_setup?: boolean
    bing_Webmaster_tools_setup?: boolean
    google_analytics_setup_Integration?: boolean
    website_responsive_check?: boolean
    page_speed_analysis?: boolean
    mobile_responsive_compatibility_check?: boolean
    navigation_ux_factors?: boolean
    ssl_certificate?: boolean
    web_2_0_400_600_words_blog_Writing?: boolean
    article_writing?: boolean
    classified_writing?: boolean
    press_release_writing?: boolean
    ppt_pdf_creation_writing?: boolean
    web_2_0_400_600_words_submission?: boolean
    web_2_0_blog_promotion?: boolean
    article_submission?: boolean
    article_promotion?: boolean
    guest_blogging?: boolean
    custom_graphics_to_support_your_blogs?: boolean
    social_bookmarking_links?: boolean
    press_release_submission?: boolean
    local_citation?: boolean
    classified_submissions?: boolean
    ppt_submission?: boolean
    ppt_promotion_backlinks?: boolean
    pdf_submission?: boolean
    pdf_promotion_backlinks?: boolean
    quora_Q_A?: boolean
    profile_creation?: boolean
    blog_commenting_niche_edu?: boolean
    forum_submission?: boolean
    google_my_business_setup_verification?: boolean
    local_citation_submissions?: boolean
    google_places_photo_multimedia_additions?: boolean
    customer_reviews_ratings?: boolean
    local_classified_ads?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    status?: boolean
  }

  export type package_featuresOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "package_id" | "website_analysis" | "content_duplicacy" | "initial_backlinks" | "critical_seo_analysis" | "google_penalty_check" | "competition_analysis" | "competitor_backlinks_opportunity" | "keyword_research_analysis" | "on_page_optimization" | "title_tags_optimization" | "meta_tags_optimization" | "content_optimization" | "html_code_optimization" | "website_permalinks_analysis" | "seo_friendly_urls" | "schema_markup_analysis" | "internal_linking_optimization" | "crawl_error_resolution" | "heading_tags_optimization" | "canonicalization_301_redirect" | "custom_404_errors" | "images_optimization" | "hyperlink_optimization" | "robots_txt_creation_optimization" | "sitemap_creation" | "google_webmaster_tools_setup" | "bing_Webmaster_tools_setup" | "google_analytics_setup_Integration" | "website_responsive_check" | "page_speed_analysis" | "mobile_responsive_compatibility_check" | "navigation_ux_factors" | "ssl_certificate" | "web_2_0_400_600_words_blog_Writing" | "article_writing" | "classified_writing" | "press_release_writing" | "ppt_pdf_creation_writing" | "web_2_0_400_600_words_submission" | "web_2_0_blog_promotion" | "article_submission" | "article_promotion" | "guest_blogging" | "custom_graphics_to_support_your_blogs" | "social_bookmarking_links" | "press_release_submission" | "local_citation" | "classified_submissions" | "ppt_submission" | "ppt_promotion_backlinks" | "pdf_submission" | "pdf_promotion_backlinks" | "quora_Q_A" | "profile_creation" | "blog_commenting_niche_edu" | "forum_submission" | "google_my_business_setup_verification" | "local_citation_submissions" | "google_places_photo_multimedia_additions" | "customer_reviews_ratings" | "local_classified_ads" | "created_at" | "updated_at" | "deleted_at" | "status", ExtArgs["result"]["package_features"]>
  export type package_featuresInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    SeoPackageFeatures?: boolean | seo_packagesDefaultArgs<ExtArgs>
  }
  export type package_featuresIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    SeoPackageFeatures?: boolean | seo_packagesDefaultArgs<ExtArgs>
  }
  export type package_featuresIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    SeoPackageFeatures?: boolean | seo_packagesDefaultArgs<ExtArgs>
  }

  export type $package_featuresPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "package_features"
    objects: {
      SeoPackageFeatures: Prisma.$seo_packagesPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      package_id: number
      website_analysis: boolean
      content_duplicacy: boolean
      initial_backlinks: boolean
      critical_seo_analysis: boolean
      google_penalty_check: boolean
      competition_analysis: number
      competitor_backlinks_opportunity: number
      keyword_research_analysis: boolean
      on_page_optimization: boolean
      title_tags_optimization: boolean
      meta_tags_optimization: boolean
      content_optimization: boolean
      html_code_optimization: boolean
      website_permalinks_analysis: boolean
      seo_friendly_urls: boolean
      schema_markup_analysis: boolean
      internal_linking_optimization: boolean
      crawl_error_resolution: boolean
      heading_tags_optimization: boolean
      canonicalization_301_redirect: boolean
      custom_404_errors: boolean
      images_optimization: boolean
      hyperlink_optimization: boolean
      robots_txt_creation_optimization: boolean
      sitemap_creation: boolean
      google_webmaster_tools_setup: boolean
      bing_Webmaster_tools_setup: boolean
      google_analytics_setup_Integration: boolean
      website_responsive_check: boolean
      page_speed_analysis: boolean
      mobile_responsive_compatibility_check: boolean
      navigation_ux_factors: boolean
      ssl_certificate: boolean
      web_2_0_400_600_words_blog_Writing: number
      article_writing: number
      classified_writing: number
      press_release_writing: number
      ppt_pdf_creation_writing: number
      web_2_0_400_600_words_submission: number
      web_2_0_blog_promotion: number
      article_submission: number
      article_promotion: number
      guest_blogging: number
      custom_graphics_to_support_your_blogs: boolean
      social_bookmarking_links: number
      press_release_submission: number
      local_citation: number
      classified_submissions: number
      ppt_submission: number
      ppt_promotion_backlinks: number
      pdf_submission: number
      pdf_promotion_backlinks: number
      quora_Q_A: number
      profile_creation: number
      blog_commenting_niche_edu: number
      forum_submission: number
      google_my_business_setup_verification: boolean
      local_citation_submissions: number
      google_places_photo_multimedia_additions: boolean
      customer_reviews_ratings: number
      local_classified_ads: number
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
      status: number | null
    }, ExtArgs["result"]["package_features"]>
    composites: {}
  }

  type package_featuresGetPayload<S extends boolean | null | undefined | package_featuresDefaultArgs> = $Result.GetResult<Prisma.$package_featuresPayload, S>

  type package_featuresCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<package_featuresFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Package_featuresCountAggregateInputType | true
    }

  export interface package_featuresDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['package_features'], meta: { name: 'package_features' } }
    /**
     * Find zero or one Package_features that matches the filter.
     * @param {package_featuresFindUniqueArgs} args - Arguments to find a Package_features
     * @example
     * // Get one Package_features
     * const package_features = await prisma.package_features.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends package_featuresFindUniqueArgs>(args: SelectSubset<T, package_featuresFindUniqueArgs<ExtArgs>>): Prisma__package_featuresClient<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Package_features that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {package_featuresFindUniqueOrThrowArgs} args - Arguments to find a Package_features
     * @example
     * // Get one Package_features
     * const package_features = await prisma.package_features.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends package_featuresFindUniqueOrThrowArgs>(args: SelectSubset<T, package_featuresFindUniqueOrThrowArgs<ExtArgs>>): Prisma__package_featuresClient<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Package_features that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {package_featuresFindFirstArgs} args - Arguments to find a Package_features
     * @example
     * // Get one Package_features
     * const package_features = await prisma.package_features.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends package_featuresFindFirstArgs>(args?: SelectSubset<T, package_featuresFindFirstArgs<ExtArgs>>): Prisma__package_featuresClient<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Package_features that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {package_featuresFindFirstOrThrowArgs} args - Arguments to find a Package_features
     * @example
     * // Get one Package_features
     * const package_features = await prisma.package_features.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends package_featuresFindFirstOrThrowArgs>(args?: SelectSubset<T, package_featuresFindFirstOrThrowArgs<ExtArgs>>): Prisma__package_featuresClient<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Package_features that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {package_featuresFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Package_features
     * const package_features = await prisma.package_features.findMany()
     * 
     * // Get first 10 Package_features
     * const package_features = await prisma.package_features.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const package_featuresWithIdOnly = await prisma.package_features.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends package_featuresFindManyArgs>(args?: SelectSubset<T, package_featuresFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Package_features.
     * @param {package_featuresCreateArgs} args - Arguments to create a Package_features.
     * @example
     * // Create one Package_features
     * const Package_features = await prisma.package_features.create({
     *   data: {
     *     // ... data to create a Package_features
     *   }
     * })
     * 
     */
    create<T extends package_featuresCreateArgs>(args: SelectSubset<T, package_featuresCreateArgs<ExtArgs>>): Prisma__package_featuresClient<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Package_features.
     * @param {package_featuresCreateManyArgs} args - Arguments to create many Package_features.
     * @example
     * // Create many Package_features
     * const package_features = await prisma.package_features.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends package_featuresCreateManyArgs>(args?: SelectSubset<T, package_featuresCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Package_features and returns the data saved in the database.
     * @param {package_featuresCreateManyAndReturnArgs} args - Arguments to create many Package_features.
     * @example
     * // Create many Package_features
     * const package_features = await prisma.package_features.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Package_features and only return the `id`
     * const package_featuresWithIdOnly = await prisma.package_features.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends package_featuresCreateManyAndReturnArgs>(args?: SelectSubset<T, package_featuresCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a Package_features.
     * @param {package_featuresDeleteArgs} args - Arguments to delete one Package_features.
     * @example
     * // Delete one Package_features
     * const Package_features = await prisma.package_features.delete({
     *   where: {
     *     // ... filter to delete one Package_features
     *   }
     * })
     * 
     */
    delete<T extends package_featuresDeleteArgs>(args: SelectSubset<T, package_featuresDeleteArgs<ExtArgs>>): Prisma__package_featuresClient<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Package_features.
     * @param {package_featuresUpdateArgs} args - Arguments to update one Package_features.
     * @example
     * // Update one Package_features
     * const package_features = await prisma.package_features.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends package_featuresUpdateArgs>(args: SelectSubset<T, package_featuresUpdateArgs<ExtArgs>>): Prisma__package_featuresClient<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Package_features.
     * @param {package_featuresDeleteManyArgs} args - Arguments to filter Package_features to delete.
     * @example
     * // Delete a few Package_features
     * const { count } = await prisma.package_features.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends package_featuresDeleteManyArgs>(args?: SelectSubset<T, package_featuresDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Package_features.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {package_featuresUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Package_features
     * const package_features = await prisma.package_features.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends package_featuresUpdateManyArgs>(args: SelectSubset<T, package_featuresUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Package_features and returns the data updated in the database.
     * @param {package_featuresUpdateManyAndReturnArgs} args - Arguments to update many Package_features.
     * @example
     * // Update many Package_features
     * const package_features = await prisma.package_features.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Package_features and only return the `id`
     * const package_featuresWithIdOnly = await prisma.package_features.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends package_featuresUpdateManyAndReturnArgs>(args: SelectSubset<T, package_featuresUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one Package_features.
     * @param {package_featuresUpsertArgs} args - Arguments to update or create a Package_features.
     * @example
     * // Update or create a Package_features
     * const package_features = await prisma.package_features.upsert({
     *   create: {
     *     // ... data to create a Package_features
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Package_features we want to update
     *   }
     * })
     */
    upsert<T extends package_featuresUpsertArgs>(args: SelectSubset<T, package_featuresUpsertArgs<ExtArgs>>): Prisma__package_featuresClient<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of Package_features.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {package_featuresCountArgs} args - Arguments to filter Package_features to count.
     * @example
     * // Count the number of Package_features
     * const count = await prisma.package_features.count({
     *   where: {
     *     // ... the filter for the Package_features we want to count
     *   }
     * })
    **/
    count<T extends package_featuresCountArgs>(
      args?: Subset<T, package_featuresCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Package_featuresCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Package_features.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Package_featuresAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Package_featuresAggregateArgs>(args: Subset<T, Package_featuresAggregateArgs>): Prisma.PrismaPromise<GetPackage_featuresAggregateType<T>>

    /**
     * Group by Package_features.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {package_featuresGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends package_featuresGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: package_featuresGroupByArgs['orderBy'] }
        : { orderBy?: package_featuresGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, package_featuresGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetPackage_featuresGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the package_features model
   */
  readonly fields: package_featuresFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for package_features.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__package_featuresClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    SeoPackageFeatures<T extends seo_packagesDefaultArgs<ExtArgs> = {}>(args?: Subset<T, seo_packagesDefaultArgs<ExtArgs>>): Prisma__seo_packagesClient<$Result.GetResult<Prisma.$seo_packagesPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the package_features model
   */ 
  interface package_featuresFieldRefs {
    readonly id: FieldRef<"package_features", 'Int'>
    readonly package_id: FieldRef<"package_features", 'Int'>
    readonly website_analysis: FieldRef<"package_features", 'Boolean'>
    readonly content_duplicacy: FieldRef<"package_features", 'Boolean'>
    readonly initial_backlinks: FieldRef<"package_features", 'Boolean'>
    readonly critical_seo_analysis: FieldRef<"package_features", 'Boolean'>
    readonly google_penalty_check: FieldRef<"package_features", 'Boolean'>
    readonly competition_analysis: FieldRef<"package_features", 'Int'>
    readonly competitor_backlinks_opportunity: FieldRef<"package_features", 'Int'>
    readonly keyword_research_analysis: FieldRef<"package_features", 'Boolean'>
    readonly on_page_optimization: FieldRef<"package_features", 'Boolean'>
    readonly title_tags_optimization: FieldRef<"package_features", 'Boolean'>
    readonly meta_tags_optimization: FieldRef<"package_features", 'Boolean'>
    readonly content_optimization: FieldRef<"package_features", 'Boolean'>
    readonly html_code_optimization: FieldRef<"package_features", 'Boolean'>
    readonly website_permalinks_analysis: FieldRef<"package_features", 'Boolean'>
    readonly seo_friendly_urls: FieldRef<"package_features", 'Boolean'>
    readonly schema_markup_analysis: FieldRef<"package_features", 'Boolean'>
    readonly internal_linking_optimization: FieldRef<"package_features", 'Boolean'>
    readonly crawl_error_resolution: FieldRef<"package_features", 'Boolean'>
    readonly heading_tags_optimization: FieldRef<"package_features", 'Boolean'>
    readonly canonicalization_301_redirect: FieldRef<"package_features", 'Boolean'>
    readonly custom_404_errors: FieldRef<"package_features", 'Boolean'>
    readonly images_optimization: FieldRef<"package_features", 'Boolean'>
    readonly hyperlink_optimization: FieldRef<"package_features", 'Boolean'>
    readonly robots_txt_creation_optimization: FieldRef<"package_features", 'Boolean'>
    readonly sitemap_creation: FieldRef<"package_features", 'Boolean'>
    readonly google_webmaster_tools_setup: FieldRef<"package_features", 'Boolean'>
    readonly bing_Webmaster_tools_setup: FieldRef<"package_features", 'Boolean'>
    readonly google_analytics_setup_Integration: FieldRef<"package_features", 'Boolean'>
    readonly website_responsive_check: FieldRef<"package_features", 'Boolean'>
    readonly page_speed_analysis: FieldRef<"package_features", 'Boolean'>
    readonly mobile_responsive_compatibility_check: FieldRef<"package_features", 'Boolean'>
    readonly navigation_ux_factors: FieldRef<"package_features", 'Boolean'>
    readonly ssl_certificate: FieldRef<"package_features", 'Boolean'>
    readonly web_2_0_400_600_words_blog_Writing: FieldRef<"package_features", 'Int'>
    readonly article_writing: FieldRef<"package_features", 'Int'>
    readonly classified_writing: FieldRef<"package_features", 'Int'>
    readonly press_release_writing: FieldRef<"package_features", 'Int'>
    readonly ppt_pdf_creation_writing: FieldRef<"package_features", 'Int'>
    readonly web_2_0_400_600_words_submission: FieldRef<"package_features", 'Int'>
    readonly web_2_0_blog_promotion: FieldRef<"package_features", 'Int'>
    readonly article_submission: FieldRef<"package_features", 'Int'>
    readonly article_promotion: FieldRef<"package_features", 'Int'>
    readonly guest_blogging: FieldRef<"package_features", 'Int'>
    readonly custom_graphics_to_support_your_blogs: FieldRef<"package_features", 'Boolean'>
    readonly social_bookmarking_links: FieldRef<"package_features", 'Int'>
    readonly press_release_submission: FieldRef<"package_features", 'Int'>
    readonly local_citation: FieldRef<"package_features", 'Int'>
    readonly classified_submissions: FieldRef<"package_features", 'Int'>
    readonly ppt_submission: FieldRef<"package_features", 'Int'>
    readonly ppt_promotion_backlinks: FieldRef<"package_features", 'Int'>
    readonly pdf_submission: FieldRef<"package_features", 'Int'>
    readonly pdf_promotion_backlinks: FieldRef<"package_features", 'Int'>
    readonly quora_Q_A: FieldRef<"package_features", 'Int'>
    readonly profile_creation: FieldRef<"package_features", 'Int'>
    readonly blog_commenting_niche_edu: FieldRef<"package_features", 'Int'>
    readonly forum_submission: FieldRef<"package_features", 'Int'>
    readonly google_my_business_setup_verification: FieldRef<"package_features", 'Boolean'>
    readonly local_citation_submissions: FieldRef<"package_features", 'Int'>
    readonly google_places_photo_multimedia_additions: FieldRef<"package_features", 'Boolean'>
    readonly customer_reviews_ratings: FieldRef<"package_features", 'Int'>
    readonly local_classified_ads: FieldRef<"package_features", 'Int'>
    readonly created_at: FieldRef<"package_features", 'DateTime'>
    readonly updated_at: FieldRef<"package_features", 'DateTime'>
    readonly deleted_at: FieldRef<"package_features", 'DateTime'>
    readonly status: FieldRef<"package_features", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * package_features findUnique
   */
  export type package_featuresFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelect<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresInclude<ExtArgs> | null
    /**
     * Filter, which package_features to fetch.
     */
    where: package_featuresWhereUniqueInput
  }

  /**
   * package_features findUniqueOrThrow
   */
  export type package_featuresFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelect<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresInclude<ExtArgs> | null
    /**
     * Filter, which package_features to fetch.
     */
    where: package_featuresWhereUniqueInput
  }

  /**
   * package_features findFirst
   */
  export type package_featuresFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelect<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresInclude<ExtArgs> | null
    /**
     * Filter, which package_features to fetch.
     */
    where?: package_featuresWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of package_features to fetch.
     */
    orderBy?: package_featuresOrderByWithRelationInput | package_featuresOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for package_features.
     */
    cursor?: package_featuresWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` package_features from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` package_features.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of package_features.
     */
    distinct?: Package_featuresScalarFieldEnum | Package_featuresScalarFieldEnum[]
  }

  /**
   * package_features findFirstOrThrow
   */
  export type package_featuresFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelect<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresInclude<ExtArgs> | null
    /**
     * Filter, which package_features to fetch.
     */
    where?: package_featuresWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of package_features to fetch.
     */
    orderBy?: package_featuresOrderByWithRelationInput | package_featuresOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for package_features.
     */
    cursor?: package_featuresWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` package_features from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` package_features.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of package_features.
     */
    distinct?: Package_featuresScalarFieldEnum | Package_featuresScalarFieldEnum[]
  }

  /**
   * package_features findMany
   */
  export type package_featuresFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelect<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresInclude<ExtArgs> | null
    /**
     * Filter, which package_features to fetch.
     */
    where?: package_featuresWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of package_features to fetch.
     */
    orderBy?: package_featuresOrderByWithRelationInput | package_featuresOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing package_features.
     */
    cursor?: package_featuresWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` package_features from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` package_features.
     */
    skip?: number
    distinct?: Package_featuresScalarFieldEnum | Package_featuresScalarFieldEnum[]
  }

  /**
   * package_features create
   */
  export type package_featuresCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelect<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresInclude<ExtArgs> | null
    /**
     * The data needed to create a package_features.
     */
    data: XOR<package_featuresCreateInput, package_featuresUncheckedCreateInput>
  }

  /**
   * package_features createMany
   */
  export type package_featuresCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many package_features.
     */
    data: package_featuresCreateManyInput | package_featuresCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * package_features createManyAndReturn
   */
  export type package_featuresCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * The data used to create many package_features.
     */
    data: package_featuresCreateManyInput | package_featuresCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * package_features update
   */
  export type package_featuresUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelect<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresInclude<ExtArgs> | null
    /**
     * The data needed to update a package_features.
     */
    data: XOR<package_featuresUpdateInput, package_featuresUncheckedUpdateInput>
    /**
     * Choose, which package_features to update.
     */
    where: package_featuresWhereUniqueInput
  }

  /**
   * package_features updateMany
   */
  export type package_featuresUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update package_features.
     */
    data: XOR<package_featuresUpdateManyMutationInput, package_featuresUncheckedUpdateManyInput>
    /**
     * Filter which package_features to update
     */
    where?: package_featuresWhereInput
    /**
     * Limit how many package_features to update.
     */
    limit?: number
  }

  /**
   * package_features updateManyAndReturn
   */
  export type package_featuresUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * The data used to update package_features.
     */
    data: XOR<package_featuresUpdateManyMutationInput, package_featuresUncheckedUpdateManyInput>
    /**
     * Filter which package_features to update
     */
    where?: package_featuresWhereInput
    /**
     * Limit how many package_features to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * package_features upsert
   */
  export type package_featuresUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelect<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresInclude<ExtArgs> | null
    /**
     * The filter to search for the package_features to update in case it exists.
     */
    where: package_featuresWhereUniqueInput
    /**
     * In case the package_features found by the `where` argument doesn't exist, create a new package_features with this data.
     */
    create: XOR<package_featuresCreateInput, package_featuresUncheckedCreateInput>
    /**
     * In case the package_features was found with the provided `where` argument, update it with this data.
     */
    update: XOR<package_featuresUpdateInput, package_featuresUncheckedUpdateInput>
  }

  /**
   * package_features delete
   */
  export type package_featuresDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelect<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresInclude<ExtArgs> | null
    /**
     * Filter which package_features to delete.
     */
    where: package_featuresWhereUniqueInput
  }

  /**
   * package_features deleteMany
   */
  export type package_featuresDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which package_features to delete
     */
    where?: package_featuresWhereInput
    /**
     * Limit how many package_features to delete.
     */
    limit?: number
  }

  /**
   * package_features without action
   */
  export type package_featuresDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelect<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresInclude<ExtArgs> | null
  }


  /**
   * Model ranker_user
   */

  export type AggregateRanker_user = {
    _count: Ranker_userCountAggregateOutputType | null
    _avg: Ranker_userAvgAggregateOutputType | null
    _sum: Ranker_userSumAggregateOutputType | null
    _min: Ranker_userMinAggregateOutputType | null
    _max: Ranker_userMaxAggregateOutputType | null
  }

  export type Ranker_userAvgAggregateOutputType = {
    id: number | null
    monogo_user_id: number | null
  }

  export type Ranker_userSumAggregateOutputType = {
    id: number | null
    monogo_user_id: number | null
  }

  export type Ranker_userMinAggregateOutputType = {
    id: number | null
    email: string | null
    monogo_user_id: number | null
    username: string | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type Ranker_userMaxAggregateOutputType = {
    id: number | null
    email: string | null
    monogo_user_id: number | null
    username: string | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type Ranker_userCountAggregateOutputType = {
    id: number
    email: number
    monogo_user_id: number
    username: number
    created_at: number
    updated_at: number
    deleted_at: number
    _all: number
  }


  export type Ranker_userAvgAggregateInputType = {
    id?: true
    monogo_user_id?: true
  }

  export type Ranker_userSumAggregateInputType = {
    id?: true
    monogo_user_id?: true
  }

  export type Ranker_userMinAggregateInputType = {
    id?: true
    email?: true
    monogo_user_id?: true
    username?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type Ranker_userMaxAggregateInputType = {
    id?: true
    email?: true
    monogo_user_id?: true
    username?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type Ranker_userCountAggregateInputType = {
    id?: true
    email?: true
    monogo_user_id?: true
    username?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    _all?: true
  }

  export type Ranker_userAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ranker_user to aggregate.
     */
    where?: ranker_userWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ranker_users to fetch.
     */
    orderBy?: ranker_userOrderByWithRelationInput | ranker_userOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ranker_userWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ranker_users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ranker_users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned ranker_users
    **/
    _count?: true | Ranker_userCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Ranker_userAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Ranker_userSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Ranker_userMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Ranker_userMaxAggregateInputType
  }

  export type GetRanker_userAggregateType<T extends Ranker_userAggregateArgs> = {
        [P in keyof T & keyof AggregateRanker_user]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateRanker_user[P]>
      : GetScalarType<T[P], AggregateRanker_user[P]>
  }




  export type ranker_userGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ranker_userWhereInput
    orderBy?: ranker_userOrderByWithAggregationInput | ranker_userOrderByWithAggregationInput[]
    by: Ranker_userScalarFieldEnum[] | Ranker_userScalarFieldEnum
    having?: ranker_userScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Ranker_userCountAggregateInputType | true
    _avg?: Ranker_userAvgAggregateInputType
    _sum?: Ranker_userSumAggregateInputType
    _min?: Ranker_userMinAggregateInputType
    _max?: Ranker_userMaxAggregateInputType
  }

  export type Ranker_userGroupByOutputType = {
    id: number
    email: string
    monogo_user_id: number
    username: string
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    _count: Ranker_userCountAggregateOutputType | null
    _avg: Ranker_userAvgAggregateOutputType | null
    _sum: Ranker_userSumAggregateOutputType | null
    _min: Ranker_userMinAggregateOutputType | null
    _max: Ranker_userMaxAggregateOutputType | null
  }

  type GetRanker_userGroupByPayload<T extends ranker_userGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Ranker_userGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Ranker_userGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Ranker_userGroupByOutputType[P]>
            : GetScalarType<T[P], Ranker_userGroupByOutputType[P]>
        }
      >
    >


  export type ranker_userSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    email?: boolean
    monogo_user_id?: boolean
    username?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }, ExtArgs["result"]["ranker_user"]>

  export type ranker_userSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    email?: boolean
    monogo_user_id?: boolean
    username?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }, ExtArgs["result"]["ranker_user"]>

  export type ranker_userSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    email?: boolean
    monogo_user_id?: boolean
    username?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }, ExtArgs["result"]["ranker_user"]>

  export type ranker_userSelectScalar = {
    id?: boolean
    email?: boolean
    monogo_user_id?: boolean
    username?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }

  export type ranker_userOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "email" | "monogo_user_id" | "username" | "created_at" | "updated_at" | "deleted_at", ExtArgs["result"]["ranker_user"]>

  export type $ranker_userPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "ranker_user"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      email: string
      monogo_user_id: number
      username: string
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
    }, ExtArgs["result"]["ranker_user"]>
    composites: {}
  }

  type ranker_userGetPayload<S extends boolean | null | undefined | ranker_userDefaultArgs> = $Result.GetResult<Prisma.$ranker_userPayload, S>

  type ranker_userCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<ranker_userFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Ranker_userCountAggregateInputType | true
    }

  export interface ranker_userDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['ranker_user'], meta: { name: 'ranker_user' } }
    /**
     * Find zero or one Ranker_user that matches the filter.
     * @param {ranker_userFindUniqueArgs} args - Arguments to find a Ranker_user
     * @example
     * // Get one Ranker_user
     * const ranker_user = await prisma.ranker_user.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ranker_userFindUniqueArgs>(args: SelectSubset<T, ranker_userFindUniqueArgs<ExtArgs>>): Prisma__ranker_userClient<$Result.GetResult<Prisma.$ranker_userPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Ranker_user that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {ranker_userFindUniqueOrThrowArgs} args - Arguments to find a Ranker_user
     * @example
     * // Get one Ranker_user
     * const ranker_user = await prisma.ranker_user.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ranker_userFindUniqueOrThrowArgs>(args: SelectSubset<T, ranker_userFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ranker_userClient<$Result.GetResult<Prisma.$ranker_userPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Ranker_user that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ranker_userFindFirstArgs} args - Arguments to find a Ranker_user
     * @example
     * // Get one Ranker_user
     * const ranker_user = await prisma.ranker_user.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ranker_userFindFirstArgs>(args?: SelectSubset<T, ranker_userFindFirstArgs<ExtArgs>>): Prisma__ranker_userClient<$Result.GetResult<Prisma.$ranker_userPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Ranker_user that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ranker_userFindFirstOrThrowArgs} args - Arguments to find a Ranker_user
     * @example
     * // Get one Ranker_user
     * const ranker_user = await prisma.ranker_user.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ranker_userFindFirstOrThrowArgs>(args?: SelectSubset<T, ranker_userFindFirstOrThrowArgs<ExtArgs>>): Prisma__ranker_userClient<$Result.GetResult<Prisma.$ranker_userPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Ranker_users that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ranker_userFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Ranker_users
     * const ranker_users = await prisma.ranker_user.findMany()
     * 
     * // Get first 10 Ranker_users
     * const ranker_users = await prisma.ranker_user.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const ranker_userWithIdOnly = await prisma.ranker_user.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ranker_userFindManyArgs>(args?: SelectSubset<T, ranker_userFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ranker_userPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Ranker_user.
     * @param {ranker_userCreateArgs} args - Arguments to create a Ranker_user.
     * @example
     * // Create one Ranker_user
     * const Ranker_user = await prisma.ranker_user.create({
     *   data: {
     *     // ... data to create a Ranker_user
     *   }
     * })
     * 
     */
    create<T extends ranker_userCreateArgs>(args: SelectSubset<T, ranker_userCreateArgs<ExtArgs>>): Prisma__ranker_userClient<$Result.GetResult<Prisma.$ranker_userPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Ranker_users.
     * @param {ranker_userCreateManyArgs} args - Arguments to create many Ranker_users.
     * @example
     * // Create many Ranker_users
     * const ranker_user = await prisma.ranker_user.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ranker_userCreateManyArgs>(args?: SelectSubset<T, ranker_userCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Ranker_users and returns the data saved in the database.
     * @param {ranker_userCreateManyAndReturnArgs} args - Arguments to create many Ranker_users.
     * @example
     * // Create many Ranker_users
     * const ranker_user = await prisma.ranker_user.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Ranker_users and only return the `id`
     * const ranker_userWithIdOnly = await prisma.ranker_user.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends ranker_userCreateManyAndReturnArgs>(args?: SelectSubset<T, ranker_userCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ranker_userPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a Ranker_user.
     * @param {ranker_userDeleteArgs} args - Arguments to delete one Ranker_user.
     * @example
     * // Delete one Ranker_user
     * const Ranker_user = await prisma.ranker_user.delete({
     *   where: {
     *     // ... filter to delete one Ranker_user
     *   }
     * })
     * 
     */
    delete<T extends ranker_userDeleteArgs>(args: SelectSubset<T, ranker_userDeleteArgs<ExtArgs>>): Prisma__ranker_userClient<$Result.GetResult<Prisma.$ranker_userPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Ranker_user.
     * @param {ranker_userUpdateArgs} args - Arguments to update one Ranker_user.
     * @example
     * // Update one Ranker_user
     * const ranker_user = await prisma.ranker_user.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ranker_userUpdateArgs>(args: SelectSubset<T, ranker_userUpdateArgs<ExtArgs>>): Prisma__ranker_userClient<$Result.GetResult<Prisma.$ranker_userPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Ranker_users.
     * @param {ranker_userDeleteManyArgs} args - Arguments to filter Ranker_users to delete.
     * @example
     * // Delete a few Ranker_users
     * const { count } = await prisma.ranker_user.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ranker_userDeleteManyArgs>(args?: SelectSubset<T, ranker_userDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Ranker_users.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ranker_userUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Ranker_users
     * const ranker_user = await prisma.ranker_user.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ranker_userUpdateManyArgs>(args: SelectSubset<T, ranker_userUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Ranker_users and returns the data updated in the database.
     * @param {ranker_userUpdateManyAndReturnArgs} args - Arguments to update many Ranker_users.
     * @example
     * // Update many Ranker_users
     * const ranker_user = await prisma.ranker_user.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Ranker_users and only return the `id`
     * const ranker_userWithIdOnly = await prisma.ranker_user.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends ranker_userUpdateManyAndReturnArgs>(args: SelectSubset<T, ranker_userUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ranker_userPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one Ranker_user.
     * @param {ranker_userUpsertArgs} args - Arguments to update or create a Ranker_user.
     * @example
     * // Update or create a Ranker_user
     * const ranker_user = await prisma.ranker_user.upsert({
     *   create: {
     *     // ... data to create a Ranker_user
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Ranker_user we want to update
     *   }
     * })
     */
    upsert<T extends ranker_userUpsertArgs>(args: SelectSubset<T, ranker_userUpsertArgs<ExtArgs>>): Prisma__ranker_userClient<$Result.GetResult<Prisma.$ranker_userPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of Ranker_users.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ranker_userCountArgs} args - Arguments to filter Ranker_users to count.
     * @example
     * // Count the number of Ranker_users
     * const count = await prisma.ranker_user.count({
     *   where: {
     *     // ... the filter for the Ranker_users we want to count
     *   }
     * })
    **/
    count<T extends ranker_userCountArgs>(
      args?: Subset<T, ranker_userCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Ranker_userCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Ranker_user.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Ranker_userAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Ranker_userAggregateArgs>(args: Subset<T, Ranker_userAggregateArgs>): Prisma.PrismaPromise<GetRanker_userAggregateType<T>>

    /**
     * Group by Ranker_user.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ranker_userGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ranker_userGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ranker_userGroupByArgs['orderBy'] }
        : { orderBy?: ranker_userGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ranker_userGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetRanker_userGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the ranker_user model
   */
  readonly fields: ranker_userFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for ranker_user.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ranker_userClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the ranker_user model
   */ 
  interface ranker_userFieldRefs {
    readonly id: FieldRef<"ranker_user", 'Int'>
    readonly email: FieldRef<"ranker_user", 'String'>
    readonly monogo_user_id: FieldRef<"ranker_user", 'Int'>
    readonly username: FieldRef<"ranker_user", 'String'>
    readonly created_at: FieldRef<"ranker_user", 'DateTime'>
    readonly updated_at: FieldRef<"ranker_user", 'DateTime'>
    readonly deleted_at: FieldRef<"ranker_user", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * ranker_user findUnique
   */
  export type ranker_userFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ranker_user
     */
    select?: ranker_userSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ranker_user
     */
    omit?: ranker_userOmit<ExtArgs> | null
    /**
     * Filter, which ranker_user to fetch.
     */
    where: ranker_userWhereUniqueInput
  }

  /**
   * ranker_user findUniqueOrThrow
   */
  export type ranker_userFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ranker_user
     */
    select?: ranker_userSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ranker_user
     */
    omit?: ranker_userOmit<ExtArgs> | null
    /**
     * Filter, which ranker_user to fetch.
     */
    where: ranker_userWhereUniqueInput
  }

  /**
   * ranker_user findFirst
   */
  export type ranker_userFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ranker_user
     */
    select?: ranker_userSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ranker_user
     */
    omit?: ranker_userOmit<ExtArgs> | null
    /**
     * Filter, which ranker_user to fetch.
     */
    where?: ranker_userWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ranker_users to fetch.
     */
    orderBy?: ranker_userOrderByWithRelationInput | ranker_userOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ranker_users.
     */
    cursor?: ranker_userWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ranker_users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ranker_users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ranker_users.
     */
    distinct?: Ranker_userScalarFieldEnum | Ranker_userScalarFieldEnum[]
  }

  /**
   * ranker_user findFirstOrThrow
   */
  export type ranker_userFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ranker_user
     */
    select?: ranker_userSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ranker_user
     */
    omit?: ranker_userOmit<ExtArgs> | null
    /**
     * Filter, which ranker_user to fetch.
     */
    where?: ranker_userWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ranker_users to fetch.
     */
    orderBy?: ranker_userOrderByWithRelationInput | ranker_userOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for ranker_users.
     */
    cursor?: ranker_userWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ranker_users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ranker_users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of ranker_users.
     */
    distinct?: Ranker_userScalarFieldEnum | Ranker_userScalarFieldEnum[]
  }

  /**
   * ranker_user findMany
   */
  export type ranker_userFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ranker_user
     */
    select?: ranker_userSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ranker_user
     */
    omit?: ranker_userOmit<ExtArgs> | null
    /**
     * Filter, which ranker_users to fetch.
     */
    where?: ranker_userWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of ranker_users to fetch.
     */
    orderBy?: ranker_userOrderByWithRelationInput | ranker_userOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing ranker_users.
     */
    cursor?: ranker_userWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` ranker_users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` ranker_users.
     */
    skip?: number
    distinct?: Ranker_userScalarFieldEnum | Ranker_userScalarFieldEnum[]
  }

  /**
   * ranker_user create
   */
  export type ranker_userCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ranker_user
     */
    select?: ranker_userSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ranker_user
     */
    omit?: ranker_userOmit<ExtArgs> | null
    /**
     * The data needed to create a ranker_user.
     */
    data: XOR<ranker_userCreateInput, ranker_userUncheckedCreateInput>
  }

  /**
   * ranker_user createMany
   */
  export type ranker_userCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many ranker_users.
     */
    data: ranker_userCreateManyInput | ranker_userCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * ranker_user createManyAndReturn
   */
  export type ranker_userCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ranker_user
     */
    select?: ranker_userSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the ranker_user
     */
    omit?: ranker_userOmit<ExtArgs> | null
    /**
     * The data used to create many ranker_users.
     */
    data: ranker_userCreateManyInput | ranker_userCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * ranker_user update
   */
  export type ranker_userUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ranker_user
     */
    select?: ranker_userSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ranker_user
     */
    omit?: ranker_userOmit<ExtArgs> | null
    /**
     * The data needed to update a ranker_user.
     */
    data: XOR<ranker_userUpdateInput, ranker_userUncheckedUpdateInput>
    /**
     * Choose, which ranker_user to update.
     */
    where: ranker_userWhereUniqueInput
  }

  /**
   * ranker_user updateMany
   */
  export type ranker_userUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update ranker_users.
     */
    data: XOR<ranker_userUpdateManyMutationInput, ranker_userUncheckedUpdateManyInput>
    /**
     * Filter which ranker_users to update
     */
    where?: ranker_userWhereInput
    /**
     * Limit how many ranker_users to update.
     */
    limit?: number
  }

  /**
   * ranker_user updateManyAndReturn
   */
  export type ranker_userUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ranker_user
     */
    select?: ranker_userSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the ranker_user
     */
    omit?: ranker_userOmit<ExtArgs> | null
    /**
     * The data used to update ranker_users.
     */
    data: XOR<ranker_userUpdateManyMutationInput, ranker_userUncheckedUpdateManyInput>
    /**
     * Filter which ranker_users to update
     */
    where?: ranker_userWhereInput
    /**
     * Limit how many ranker_users to update.
     */
    limit?: number
  }

  /**
   * ranker_user upsert
   */
  export type ranker_userUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ranker_user
     */
    select?: ranker_userSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ranker_user
     */
    omit?: ranker_userOmit<ExtArgs> | null
    /**
     * The filter to search for the ranker_user to update in case it exists.
     */
    where: ranker_userWhereUniqueInput
    /**
     * In case the ranker_user found by the `where` argument doesn't exist, create a new ranker_user with this data.
     */
    create: XOR<ranker_userCreateInput, ranker_userUncheckedCreateInput>
    /**
     * In case the ranker_user was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ranker_userUpdateInput, ranker_userUncheckedUpdateInput>
  }

  /**
   * ranker_user delete
   */
  export type ranker_userDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ranker_user
     */
    select?: ranker_userSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ranker_user
     */
    omit?: ranker_userOmit<ExtArgs> | null
    /**
     * Filter which ranker_user to delete.
     */
    where: ranker_userWhereUniqueInput
  }

  /**
   * ranker_user deleteMany
   */
  export type ranker_userDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which ranker_users to delete
     */
    where?: ranker_userWhereInput
    /**
     * Limit how many ranker_users to delete.
     */
    limit?: number
  }

  /**
   * ranker_user without action
   */
  export type ranker_userDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ranker_user
     */
    select?: ranker_userSelect<ExtArgs> | null
    /**
     * Omit specific fields from the ranker_user
     */
    omit?: ranker_userOmit<ExtArgs> | null
  }


  /**
   * Enums
   */

  export const TransactionIsolationLevel: {
    ReadUncommitted: 'ReadUncommitted',
    ReadCommitted: 'ReadCommitted',
    RepeatableRead: 'RepeatableRead',
    Serializable: 'Serializable'
  };

  export type TransactionIsolationLevel = (typeof TransactionIsolationLevel)[keyof typeof TransactionIsolationLevel]


  export const UserScalarFieldEnum: {
    id: 'id',
    first_name: 'first_name',
    last_name: 'last_name',
    email: 'email',
    password: 'password',
    phone_no: 'phone_no',
    country_code: 'country_code',
    country_iso_code: 'country_iso_code',
    condition: 'condition',
    create_by: 'create_by',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at',
    is_verified: 'is_verified',
    status: 'status'
  };

  export type UserScalarFieldEnum = (typeof UserScalarFieldEnum)[keyof typeof UserScalarFieldEnum]


  export const UserDetailsScalarFieldEnum: {
    id: 'id',
    address: 'address',
    user_id: 'user_id',
    organisation_id: 'organisation_id',
    created_at: 'created_at',
    updated_at: 'updated_at',
    role_id: 'role_id'
  };

  export type UserDetailsScalarFieldEnum = (typeof UserDetailsScalarFieldEnum)[keyof typeof UserDetailsScalarFieldEnum]


  export const ProjectCategoryScalarFieldEnum: {
    id: 'id',
    category_name: 'category_name',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at',
    user_id: 'user_id'
  };

  export type ProjectCategoryScalarFieldEnum = (typeof ProjectCategoryScalarFieldEnum)[keyof typeof ProjectCategoryScalarFieldEnum]


  export const ProjectScalarFieldEnum: {
    id: 'id',
    domain_name: 'domain_name',
    domain_url: 'domain_url',
    category_id: 'category_id',
    created_by_id: 'created_by_id',
    total_tasks_count: 'total_tasks_count',
    completed_tasks_count: 'completed_tasks_count',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at',
    time_around: 'time_around',
    package_id: 'package_id',
    time_around_days: 'time_around_days',
    organisation_id: 'organisation_id',
    daily_target_links: 'daily_target_links'
  };

  export type ProjectScalarFieldEnum = (typeof ProjectScalarFieldEnum)[keyof typeof ProjectScalarFieldEnum]


  export const ProjectUserScalarFieldEnum: {
    id: 'id',
    assign_by: 'assign_by',
    assign_to: 'assign_to',
    project_id: 'project_id',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at',
    status: 'status'
  };

  export type ProjectUserScalarFieldEnum = (typeof ProjectUserScalarFieldEnum)[keyof typeof ProjectUserScalarFieldEnum]


  export const BacklinkScalarFieldEnum: {
    id: 'id',
    link_url: 'link_url',
    link_status: 'link_status',
    is_index: 'is_index',
    link_rel: 'link_rel',
    anchor_text: 'anchor_text',
    targeted_url: 'targeted_url',
    project_id: 'project_id',
    uploaded_by_id: 'uploaded_by_id',
    first_seen: 'first_seen',
    last_seen: 'last_seen',
    added_date: 'added_date',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at',
    refer_domain: 'refer_domain',
    refering_domain: 'refering_domain',
    backlink_duplicate: 'backlink_duplicate',
    managed_by: 'managed_by',
    link_category: 'link_category',
    job_id: 'job_id',
    processId: 'processId'
  };

  export type BacklinkScalarFieldEnum = (typeof BacklinkScalarFieldEnum)[keyof typeof BacklinkScalarFieldEnum]


  export const ProcessScalarFieldEnum: {
    id: 'id',
    status: 'status',
    user_id: 'user_id',
    created_at: 'created_at',
    updated_at: 'updated_at'
  };

  export type ProcessScalarFieldEnum = (typeof ProcessScalarFieldEnum)[keyof typeof ProcessScalarFieldEnum]


  export const TeamScalarFieldEnum: {
    id: 'id',
    organisation_id: 'organisation_id',
    created_by: 'created_by',
    user_id: 'user_id',
    role_id: 'role_id',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at'
  };

  export type TeamScalarFieldEnum = (typeof TeamScalarFieldEnum)[keyof typeof TeamScalarFieldEnum]


  export const AssignTeamMemberScalarFieldEnum: {
    id: 'id',
    organisation_id: 'organisation_id',
    assign_to_id: 'assign_to_id',
    assign_by_id: 'assign_by_id',
    role_id: 'role_id',
    assign_user: 'assign_user',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at'
  };

  export type AssignTeamMemberScalarFieldEnum = (typeof AssignTeamMemberScalarFieldEnum)[keyof typeof AssignTeamMemberScalarFieldEnum]


  export const TempLinksScalarFieldEnum: {
    id: 'id',
    status: 'status',
    job_id: 'job_id',
    userId: 'userId',
    link_url: 'link_url',
    project_id: 'project_id',
    links_category_id: 'links_category_id',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at'
  };

  export type TempLinksScalarFieldEnum = (typeof TempLinksScalarFieldEnum)[keyof typeof TempLinksScalarFieldEnum]


  export const UserJobsScalarFieldEnum: {
    id: 'id',
    status: 'status',
    name: 'name',
    user_id: 'user_id',
    total_links: 'total_links',
    project_id: 'project_id',
    created_at: 'created_at',
    updated_at: 'updated_at',
    processing_status: 'processing_status',
    type: 'type'
  };

  export type UserJobsScalarFieldEnum = (typeof UserJobsScalarFieldEnum)[keyof typeof UserJobsScalarFieldEnum]


  export const ProjectDetailsScalarFieldEnum: {
    id: 'id',
    project_id: 'project_id',
    seo_package_id: 'seo_package_id',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at'
  };

  export type ProjectDetailsScalarFieldEnum = (typeof ProjectDetailsScalarFieldEnum)[keyof typeof ProjectDetailsScalarFieldEnum]


  export const ReferDomainCategoryScalarFieldEnum: {
    id: 'id',
    category_name: 'category_name',
    user_id: 'user_id',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at'
  };

  export type ReferDomainCategoryScalarFieldEnum = (typeof ReferDomainCategoryScalarFieldEnum)[keyof typeof ReferDomainCategoryScalarFieldEnum]


  export const ReferDomainScalarFieldEnum: {
    id: 'id',
    category_id: 'category_id',
    rd_link: 'rd_link',
    user_id: 'user_id',
    status: 'status',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at'
  };

  export type ReferDomainScalarFieldEnum = (typeof ReferDomainScalarFieldEnum)[keyof typeof ReferDomainScalarFieldEnum]


  export const GuideLinesScalarFieldEnum: {
    id: 'id',
    task_name: 'task_name',
    key_name: 'key_name',
    uploaded_by: 'uploaded_by',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at'
  };

  export type GuideLinesScalarFieldEnum = (typeof GuideLinesScalarFieldEnum)[keyof typeof GuideLinesScalarFieldEnum]


  export const ProjectGuideLinesScalarFieldEnum: {
    id: 'id',
    guide_id: 'guide_id',
    project_id: 'project_id',
    link_count: 'link_count',
    status: 'status',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at',
    uploaded_counts: 'uploaded_counts',
    guideLinesId: 'guideLinesId'
  };

  export type ProjectGuideLinesScalarFieldEnum = (typeof ProjectGuideLinesScalarFieldEnum)[keyof typeof ProjectGuideLinesScalarFieldEnum]


  export const Seo_packagesScalarFieldEnum: {
    id: 'id',
    status: 'status',
    title: 'title',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at'
  };

  export type Seo_packagesScalarFieldEnum = (typeof Seo_packagesScalarFieldEnum)[keyof typeof Seo_packagesScalarFieldEnum]


  export const Package_featuresScalarFieldEnum: {
    id: 'id',
    package_id: 'package_id',
    website_analysis: 'website_analysis',
    content_duplicacy: 'content_duplicacy',
    initial_backlinks: 'initial_backlinks',
    critical_seo_analysis: 'critical_seo_analysis',
    google_penalty_check: 'google_penalty_check',
    competition_analysis: 'competition_analysis',
    competitor_backlinks_opportunity: 'competitor_backlinks_opportunity',
    keyword_research_analysis: 'keyword_research_analysis',
    on_page_optimization: 'on_page_optimization',
    title_tags_optimization: 'title_tags_optimization',
    meta_tags_optimization: 'meta_tags_optimization',
    content_optimization: 'content_optimization',
    html_code_optimization: 'html_code_optimization',
    website_permalinks_analysis: 'website_permalinks_analysis',
    seo_friendly_urls: 'seo_friendly_urls',
    schema_markup_analysis: 'schema_markup_analysis',
    internal_linking_optimization: 'internal_linking_optimization',
    crawl_error_resolution: 'crawl_error_resolution',
    heading_tags_optimization: 'heading_tags_optimization',
    canonicalization_301_redirect: 'canonicalization_301_redirect',
    custom_404_errors: 'custom_404_errors',
    images_optimization: 'images_optimization',
    hyperlink_optimization: 'hyperlink_optimization',
    robots_txt_creation_optimization: 'robots_txt_creation_optimization',
    sitemap_creation: 'sitemap_creation',
    google_webmaster_tools_setup: 'google_webmaster_tools_setup',
    bing_Webmaster_tools_setup: 'bing_Webmaster_tools_setup',
    google_analytics_setup_Integration: 'google_analytics_setup_Integration',
    website_responsive_check: 'website_responsive_check',
    page_speed_analysis: 'page_speed_analysis',
    mobile_responsive_compatibility_check: 'mobile_responsive_compatibility_check',
    navigation_ux_factors: 'navigation_ux_factors',
    ssl_certificate: 'ssl_certificate',
    web_2_0_400_600_words_blog_Writing: 'web_2_0_400_600_words_blog_Writing',
    article_writing: 'article_writing',
    classified_writing: 'classified_writing',
    press_release_writing: 'press_release_writing',
    ppt_pdf_creation_writing: 'ppt_pdf_creation_writing',
    web_2_0_400_600_words_submission: 'web_2_0_400_600_words_submission',
    web_2_0_blog_promotion: 'web_2_0_blog_promotion',
    article_submission: 'article_submission',
    article_promotion: 'article_promotion',
    guest_blogging: 'guest_blogging',
    custom_graphics_to_support_your_blogs: 'custom_graphics_to_support_your_blogs',
    social_bookmarking_links: 'social_bookmarking_links',
    press_release_submission: 'press_release_submission',
    local_citation: 'local_citation',
    classified_submissions: 'classified_submissions',
    ppt_submission: 'ppt_submission',
    ppt_promotion_backlinks: 'ppt_promotion_backlinks',
    pdf_submission: 'pdf_submission',
    pdf_promotion_backlinks: 'pdf_promotion_backlinks',
    quora_Q_A: 'quora_Q_A',
    profile_creation: 'profile_creation',
    blog_commenting_niche_edu: 'blog_commenting_niche_edu',
    forum_submission: 'forum_submission',
    google_my_business_setup_verification: 'google_my_business_setup_verification',
    local_citation_submissions: 'local_citation_submissions',
    google_places_photo_multimedia_additions: 'google_places_photo_multimedia_additions',
    customer_reviews_ratings: 'customer_reviews_ratings',
    local_classified_ads: 'local_classified_ads',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at',
    status: 'status'
  };

  export type Package_featuresScalarFieldEnum = (typeof Package_featuresScalarFieldEnum)[keyof typeof Package_featuresScalarFieldEnum]


  export const Ranker_userScalarFieldEnum: {
    id: 'id',
    email: 'email',
    monogo_user_id: 'monogo_user_id',
    username: 'username',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at'
  };

  export type Ranker_userScalarFieldEnum = (typeof Ranker_userScalarFieldEnum)[keyof typeof Ranker_userScalarFieldEnum]


  export const SortOrder: {
    asc: 'asc',
    desc: 'desc'
  };

  export type SortOrder = (typeof SortOrder)[keyof typeof SortOrder]


  export const QueryMode: {
    default: 'default',
    insensitive: 'insensitive'
  };

  export type QueryMode = (typeof QueryMode)[keyof typeof QueryMode]


  export const NullsOrder: {
    first: 'first',
    last: 'last'
  };

  export type NullsOrder = (typeof NullsOrder)[keyof typeof NullsOrder]


  /**
   * Field references 
   */


  /**
   * Reference to a field of type 'Int'
   */
  export type IntFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Int'>
    


  /**
   * Reference to a field of type 'Int[]'
   */
  export type ListIntFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Int[]'>
    


  /**
   * Reference to a field of type 'String'
   */
  export type StringFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'String'>
    


  /**
   * Reference to a field of type 'String[]'
   */
  export type ListStringFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'String[]'>
    


  /**
   * Reference to a field of type 'Boolean'
   */
  export type BooleanFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Boolean'>
    


  /**
   * Reference to a field of type 'DateTime'
   */
  export type DateTimeFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'DateTime'>
    


  /**
   * Reference to a field of type 'DateTime[]'
   */
  export type ListDateTimeFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'DateTime[]'>
    


  /**
   * Reference to a field of type 'Status'
   */
  export type EnumStatusFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Status'>
    


  /**
   * Reference to a field of type 'Status[]'
   */
  export type ListEnumStatusFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Status[]'>
    


  /**
   * Reference to a field of type 'ProcessStatus'
   */
  export type EnumProcessStatusFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'ProcessStatus'>
    


  /**
   * Reference to a field of type 'ProcessStatus[]'
   */
  export type ListEnumProcessStatusFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'ProcessStatus[]'>
    


  /**
   * Reference to a field of type 'LinkStatus'
   */
  export type EnumLinkStatusFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'LinkStatus'>
    


  /**
   * Reference to a field of type 'LinkStatus[]'
   */
  export type ListEnumLinkStatusFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'LinkStatus[]'>
    


  /**
   * Reference to a field of type 'JobStatus'
   */
  export type EnumJobStatusFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'JobStatus'>
    


  /**
   * Reference to a field of type 'JobStatus[]'
   */
  export type ListEnumJobStatusFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'JobStatus[]'>
    


  /**
   * Reference to a field of type 'Float'
   */
  export type FloatFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Float'>
    


  /**
   * Reference to a field of type 'Float[]'
   */
  export type ListFloatFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Float[]'>
    
  /**
   * Deep Input Types
   */


  export type UserWhereInput = {
    AND?: UserWhereInput | UserWhereInput[]
    OR?: UserWhereInput[]
    NOT?: UserWhereInput | UserWhereInput[]
    id?: IntFilter<"User"> | number
    first_name?: StringFilter<"User"> | string
    last_name?: StringNullableFilter<"User"> | string | null
    email?: StringFilter<"User"> | string
    password?: StringFilter<"User"> | string
    phone_no?: StringNullableFilter<"User"> | string | null
    country_code?: StringNullableFilter<"User"> | string | null
    country_iso_code?: StringNullableFilter<"User"> | string | null
    condition?: BoolFilter<"User"> | boolean
    create_by?: IntFilter<"User"> | number
    created_at?: DateTimeFilter<"User"> | Date | string
    updated_at?: DateTimeFilter<"User"> | Date | string
    deleted_at?: DateTimeNullableFilter<"User"> | Date | string | null
    is_verified?: BoolFilter<"User"> | boolean
    status?: EnumStatusFilter<"User"> | $Enums.Status
    created_projects?: ProjectListRelationFilter
    backlinks?: BacklinkListRelationFilter
    ProjectCategory?: ProjectCategoryListRelationFilter
    assignedProjects?: ProjectUserListRelationFilter
    memberProjects?: ProjectUserListRelationFilter
    Backlink?: BacklinkListRelationFilter
    Process?: ProcessListRelationFilter
    TempLinks?: TempLinksListRelationFilter
    UserJobs?: UserJobsListRelationFilter
    ReferDomain?: ReferDomainListRelationFilter
    ReferDomainCategory?: ReferDomainCategoryListRelationFilter
    GuideLines?: GuideLinesListRelationFilter
    Project?: ProjectListRelationFilter
    OrganisationTeam?: TeamListRelationFilter
    CreatedByTeam?: TeamListRelationFilter
    UserTeam?: TeamListRelationFilter
    AssignToTeamMember?: AssignTeamMemberListRelationFilter
    AssignByTeamMember?: AssignTeamMemberListRelationFilter
    AssignUserMember?: AssignTeamMemberListRelationFilter
    AssignOrgMember?: AssignTeamMemberListRelationFilter
    UserInfo?: XOR<UserDetailsNullableScalarRelationFilter, UserDetailsWhereInput> | null
  }

  export type UserOrderByWithRelationInput = {
    id?: SortOrder
    first_name?: SortOrder
    last_name?: SortOrderInput | SortOrder
    email?: SortOrder
    password?: SortOrder
    phone_no?: SortOrderInput | SortOrder
    country_code?: SortOrderInput | SortOrder
    country_iso_code?: SortOrderInput | SortOrder
    condition?: SortOrder
    create_by?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrderInput | SortOrder
    is_verified?: SortOrder
    status?: SortOrder
    created_projects?: ProjectOrderByRelationAggregateInput
    backlinks?: BacklinkOrderByRelationAggregateInput
    ProjectCategory?: ProjectCategoryOrderByRelationAggregateInput
    assignedProjects?: ProjectUserOrderByRelationAggregateInput
    memberProjects?: ProjectUserOrderByRelationAggregateInput
    Backlink?: BacklinkOrderByRelationAggregateInput
    Process?: ProcessOrderByRelationAggregateInput
    TempLinks?: TempLinksOrderByRelationAggregateInput
    UserJobs?: UserJobsOrderByRelationAggregateInput
    ReferDomain?: ReferDomainOrderByRelationAggregateInput
    ReferDomainCategory?: ReferDomainCategoryOrderByRelationAggregateInput
    GuideLines?: GuideLinesOrderByRelationAggregateInput
    Project?: ProjectOrderByRelationAggregateInput
    OrganisationTeam?: TeamOrderByRelationAggregateInput
    CreatedByTeam?: TeamOrderByRelationAggregateInput
    UserTeam?: TeamOrderByRelationAggregateInput
    AssignToTeamMember?: AssignTeamMemberOrderByRelationAggregateInput
    AssignByTeamMember?: AssignTeamMemberOrderByRelationAggregateInput
    AssignUserMember?: AssignTeamMemberOrderByRelationAggregateInput
    AssignOrgMember?: AssignTeamMemberOrderByRelationAggregateInput
    UserInfo?: UserDetailsOrderByWithRelationInput
  }

  export type UserWhereUniqueInput = Prisma.AtLeast<{
    id?: number
    email?: string
    AND?: UserWhereInput | UserWhereInput[]
    OR?: UserWhereInput[]
    NOT?: UserWhereInput | UserWhereInput[]
    first_name?: StringFilter<"User"> | string
    last_name?: StringNullableFilter<"User"> | string | null
    password?: StringFilter<"User"> | string
    phone_no?: StringNullableFilter<"User"> | string | null
    country_code?: StringNullableFilter<"User"> | string | null
    country_iso_code?: StringNullableFilter<"User"> | string | null
    condition?: BoolFilter<"User"> | boolean
    create_by?: IntFilter<"User"> | number
    created_at?: DateTimeFilter<"User"> | Date | string
    updated_at?: DateTimeFilter<"User"> | Date | string
    deleted_at?: DateTimeNullableFilter<"User"> | Date | string | null
    is_verified?: BoolFilter<"User"> | boolean
    status?: EnumStatusFilter<"User"> | $Enums.Status
    created_projects?: ProjectListRelationFilter
    backlinks?: BacklinkListRelationFilter
    ProjectCategory?: ProjectCategoryListRelationFilter
    assignedProjects?: ProjectUserListRelationFilter
    memberProjects?: ProjectUserListRelationFilter
    Backlink?: BacklinkListRelationFilter
    Process?: ProcessListRelationFilter
    TempLinks?: TempLinksListRelationFilter
    UserJobs?: UserJobsListRelationFilter
    ReferDomain?: ReferDomainListRelationFilter
    ReferDomainCategory?: ReferDomainCategoryListRelationFilter
    GuideLines?: GuideLinesListRelationFilter
    Project?: ProjectListRelationFilter
    OrganisationTeam?: TeamListRelationFilter
    CreatedByTeam?: TeamListRelationFilter
    UserTeam?: TeamListRelationFilter
    AssignToTeamMember?: AssignTeamMemberListRelationFilter
    AssignByTeamMember?: AssignTeamMemberListRelationFilter
    AssignUserMember?: AssignTeamMemberListRelationFilter
    AssignOrgMember?: AssignTeamMemberListRelationFilter
    UserInfo?: XOR<UserDetailsNullableScalarRelationFilter, UserDetailsWhereInput> | null
  }, "id" | "email">

  export type UserOrderByWithAggregationInput = {
    id?: SortOrder
    first_name?: SortOrder
    last_name?: SortOrderInput | SortOrder
    email?: SortOrder
    password?: SortOrder
    phone_no?: SortOrderInput | SortOrder
    country_code?: SortOrderInput | SortOrder
    country_iso_code?: SortOrderInput | SortOrder
    condition?: SortOrder
    create_by?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrderInput | SortOrder
    is_verified?: SortOrder
    status?: SortOrder
    _count?: UserCountOrderByAggregateInput
    _avg?: UserAvgOrderByAggregateInput
    _max?: UserMaxOrderByAggregateInput
    _min?: UserMinOrderByAggregateInput
    _sum?: UserSumOrderByAggregateInput
  }

  export type UserScalarWhereWithAggregatesInput = {
    AND?: UserScalarWhereWithAggregatesInput | UserScalarWhereWithAggregatesInput[]
    OR?: UserScalarWhereWithAggregatesInput[]
    NOT?: UserScalarWhereWithAggregatesInput | UserScalarWhereWithAggregatesInput[]
    id?: IntWithAggregatesFilter<"User"> | number
    first_name?: StringWithAggregatesFilter<"User"> | string
    last_name?: StringNullableWithAggregatesFilter<"User"> | string | null
    email?: StringWithAggregatesFilter<"User"> | string
    password?: StringWithAggregatesFilter<"User"> | string
    phone_no?: StringNullableWithAggregatesFilter<"User"> | string | null
    country_code?: StringNullableWithAggregatesFilter<"User"> | string | null
    country_iso_code?: StringNullableWithAggregatesFilter<"User"> | string | null
    condition?: BoolWithAggregatesFilter<"User"> | boolean
    create_by?: IntWithAggregatesFilter<"User"> | number
    created_at?: DateTimeWithAggregatesFilter<"User"> | Date | string
    updated_at?: DateTimeWithAggregatesFilter<"User"> | Date | string
    deleted_at?: DateTimeNullableWithAggregatesFilter<"User"> | Date | string | null
    is_verified?: BoolWithAggregatesFilter<"User"> | boolean
    status?: EnumStatusWithAggregatesFilter<"User"> | $Enums.Status
  }

  export type UserDetailsWhereInput = {
    AND?: UserDetailsWhereInput | UserDetailsWhereInput[]
    OR?: UserDetailsWhereInput[]
    NOT?: UserDetailsWhereInput | UserDetailsWhereInput[]
    id?: IntFilter<"UserDetails"> | number
    address?: StringNullableFilter<"UserDetails"> | string | null
    user_id?: IntFilter<"UserDetails"> | number
    organisation_id?: IntNullableFilter<"UserDetails"> | number | null
    created_at?: DateTimeFilter<"UserDetails"> | Date | string
    updated_at?: DateTimeFilter<"UserDetails"> | Date | string
    role_id?: IntFilter<"UserDetails"> | number
    user?: XOR<UserScalarRelationFilter, UserWhereInput>
  }

  export type UserDetailsOrderByWithRelationInput = {
    id?: SortOrder
    address?: SortOrderInput | SortOrder
    user_id?: SortOrder
    organisation_id?: SortOrderInput | SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    role_id?: SortOrder
    user?: UserOrderByWithRelationInput
  }

  export type UserDetailsWhereUniqueInput = Prisma.AtLeast<{
    id?: number
    user_id?: number
    AND?: UserDetailsWhereInput | UserDetailsWhereInput[]
    OR?: UserDetailsWhereInput[]
    NOT?: UserDetailsWhereInput | UserDetailsWhereInput[]
    address?: StringNullableFilter<"UserDetails"> | string | null
    organisation_id?: IntNullableFilter<"UserDetails"> | number | null
    created_at?: DateTimeFilter<"UserDetails"> | Date | string
    updated_at?: DateTimeFilter<"UserDetails"> | Date | string
    role_id?: IntFilter<"UserDetails"> | number
    user?: XOR<UserScalarRelationFilter, UserWhereInput>
  }, "id" | "user_id">

  export type UserDetailsOrderByWithAggregationInput = {
    id?: SortOrder
    address?: SortOrderInput | SortOrder
    user_id?: SortOrder
    organisation_id?: SortOrderInput | SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    role_id?: SortOrder
    _count?: UserDetailsCountOrderByAggregateInput
    _avg?: UserDetailsAvgOrderByAggregateInput
    _max?: UserDetailsMaxOrderByAggregateInput
    _min?: UserDetailsMin