
Object.defineProperty(exports, "__esModule", { value: true });

const {
  Decimal,
  objectEnumValues,
  makeStrictEnum,
  Public,
  getRuntime,
  skip
} = require('./runtime/index-browser.js')


const Prisma = {}

exports.Prisma = Prisma
exports.$Enums = {}

/**
 * Prisma Client JS version: 6.4.1
 * Query Engine version: a9055b89e58b4b5bfb59600785423b1db3d0e75d
 */
Prisma.prismaVersion = {
  client: "6.4.1",
  engine: "a9055b89e58b4b5bfb59600785423b1db3d0e75d"
}

Prisma.PrismaClientKnownRequestError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientKnownRequestError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)};
Prisma.PrismaClientUnknownRequestError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientUnknownRequestError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.PrismaClientRustPanicError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientRustPanicError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.PrismaClientInitializationError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientInitializationError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.PrismaClientValidationError = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`PrismaClientValidationError is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.Decimal = Decimal

/**
 * Re-export of sql-template-tag
 */
Prisma.sql = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`sqltag is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.empty = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`empty is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.join = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`join is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.raw = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`raw is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.validator = Public.validator

/**
* Extensions
*/
Prisma.getExtensionContext = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`Extensions.getExtensionContext is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}
Prisma.defineExtension = () => {
  const runtimeName = getRuntime().prettyName;
  throw new Error(`Extensions.defineExtension is unable to run in this browser environment, or has been bundled for the browser (running in ${runtimeName}).
In case this error is unexpected for you, please report it in https://pris.ly/prisma-prisma-bug-report`,
)}

/**
 * Shorthand utilities for JSON filtering
 */
Prisma.DbNull = objectEnumValues.instances.DbNull
Prisma.JsonNull = objectEnumValues.instances.JsonNull
Prisma.AnyNull = objectEnumValues.instances.AnyNull

Prisma.NullTypes = {
  DbNull: objectEnumValues.classes.DbNull,
  JsonNull: objectEnumValues.classes.JsonNull,
  AnyNull: objectEnumValues.classes.AnyNull
}



/**
 * Enums
 */

exports.Prisma.TransactionIsolationLevel = makeStrictEnum({
  ReadUncommitted: 'ReadUncommitted',
  ReadCommitted: 'ReadCommitted',
  RepeatableRead: 'RepeatableRead',
  Serializable: 'Serializable'
});

exports.Prisma.ProjectsScalarFieldEnum = {
  id: 'id',
  domain_name: 'domain_name',
  domain_url: 'domain_url',
  category_id: 'category_id',
  created_by_id: 'created_by_id',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at',
  time_around: 'time_around',
  time_around_days: 'time_around_days'
};

exports.Prisma.BacklinkScalarFieldEnum = {
  id: 'id',
  link_url: 'link_url',
  link_status: 'link_status',
  is_index: 'is_index',
  link_rel: 'link_rel',
  anchor_text: 'anchor_text',
  targeted_url: 'targeted_url',
  project_id: 'project_id',
  uploaded_by_id: 'uploaded_by_id',
  first_seen: 'first_seen',
  last_seen: 'last_seen',
  added_date: 'added_date',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at',
  backlink_duplicate: 'backlink_duplicate',
  referring_domain: 'referring_domain',
  managed_by: 'managed_by'
};

exports.Prisma.Permissions_listScalarFieldEnum = {
  id: 'id',
  title: 'title',
  type: 'type',
  created_by: 'created_by',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.RolesScalarFieldEnum = {
  id: 'id',
  name: 'name',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.SubscriptionScalarFieldEnum = {
  id: 'id',
  name: 'name',
  status: 'status',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.Subscription_featureScalarFieldEnum = {
  id: 'id',
  status: 'status',
  subscription_id: 'subscription_id',
  permission_id: 'permission_id',
  limit: 'limit',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.User_subscriptionScalarFieldEnum = {
  id: 'id',
  user_id: 'user_id',
  created_by_id: 'created_by_id',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at',
  subscription_id: 'subscription_id'
};

exports.Prisma.User_permissionsScalarFieldEnum = {
  id: 'id',
  user_id: 'user_id',
  limit: 'limit',
  permission_id: 'permission_id',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at'
};

exports.Prisma.Package_featuresScalarFieldEnum = {
  id: 'id',
  subscription_id: 'subscription_id',
  website_analysis: 'website_analysis',
  content_duplicacy: 'content_duplicacy',
  initial_backlinks: 'initial_backlinks',
  critical_seo_analysis: 'critical_seo_analysis',
  google_penalty_check: 'google_penalty_check',
  competition_analysis: 'competition_analysis',
  competitor_backlinks_opportunity: 'competitor_backlinks_opportunity',
  keyword_research_analysis: 'keyword_research_analysis',
  on_page_optimization: 'on_page_optimization',
  title_tags_optimization: 'title_tags_optimization',
  meta_tags_optimization: 'meta_tags_optimization',
  content_optimization: 'content_optimization',
  html_code_optimization: 'html_code_optimization',
  website_permalinks_analysis: 'website_permalinks_analysis',
  seo_friendly_urls: 'seo_friendly_urls',
  schema_markup_analysis: 'schema_markup_analysis',
  internal_linking_optimization: 'internal_linking_optimization',
  crawl_error_resolution: 'crawl_error_resolution',
  heading_tags_optimization: 'heading_tags_optimization',
  canonicalization_301_redirect: 'canonicalization_301_redirect',
  custom_404_errors: 'custom_404_errors',
  images_optimization: 'images_optimization',
  hyperlink_optimization: 'hyperlink_optimization',
  robots_txt_creation_optimization: 'robots_txt_creation_optimization',
  sitemap_creation: 'sitemap_creation',
  google_webmaster_tools_setup: 'google_webmaster_tools_setup',
  bing_Webmaster_tools_setup: 'bing_Webmaster_tools_setup',
  google_analytics_setup_Integration: 'google_analytics_setup_Integration',
  website_responsive_check: 'website_responsive_check',
  page_speed_analysis: 'page_speed_analysis',
  mobile_responsive_compatibility_check: 'mobile_responsive_compatibility_check',
  navigation_ux_factors: 'navigation_ux_factors',
  ssl_certificate: 'ssl_certificate',
  web_2_0_400_600_words_blog_Writing: 'web_2_0_400_600_words_blog_Writing',
  article_writing: 'article_writing',
  classified_writing: 'classified_writing',
  press_release_writing: 'press_release_writing',
  ppt_pdf_creation_writing: 'ppt_pdf_creation_writing',
  web_2_0_400_600_words_submission: 'web_2_0_400_600_words_submission',
  web_2_0_blog_promotion: 'web_2_0_blog_promotion',
  article_submission: 'article_submission',
  article_promotion: 'article_promotion',
  guest_blogging: 'guest_blogging',
  custom_graphics_to_support_your_blogs: 'custom_graphics_to_support_your_blogs',
  social_bookmarking_links: 'social_bookmarking_links',
  press_release_submission: 'press_release_submission',
  local_citation: 'local_citation',
  classified_submissions: 'classified_submissions',
  ppt_submission: 'ppt_submission',
  ppt_promotion_backlinks: 'ppt_promotion_backlinks',
  pdf_submission: 'pdf_submission',
  pdf_promotion_backlinks: 'pdf_promotion_backlinks',
  quora_Q_A: 'quora_Q_A',
  profile_creation: 'profile_creation',
  blog_commenting_niche_edu: 'blog_commenting_niche_edu',
  forum_submission: 'forum_submission',
  google_my_business_setup_verification: 'google_my_business_setup_verification',
  local_citation_submissions: 'local_citation_submissions',
  google_places_photo_multimedia_additions: 'google_places_photo_multimedia_additions',
  customer_reviews_ratings: 'customer_reviews_ratings',
  local_classified_ads: 'local_classified_ads',
  monthly_keyword_improvement_report: 'monthly_keyword_improvement_report',
  monthly_back_links_report: 'monthly_back_links_report',
  monthly_google_analytic_static_report: 'monthly_google_analytic_static_report',
  email: 'email',
  telephone_whatsapp_telegram: 'telephone_whatsapp_telegram',
  internet_messenger_skype: 'internet_messenger_skype',
  created_at: 'created_at',
  updated_at: 'updated_at',
  deleted_at: 'deleted_at',
  status: 'status'
};

exports.Prisma.SortOrder = {
  asc: 'asc',
  desc: 'desc'
};

exports.Prisma.QueryMode = {
  default: 'default',
  insensitive: 'insensitive'
};

exports.Prisma.NullsOrder = {
  first: 'first',
  last: 'last'
};


exports.Prisma.ModelName = {
  Projects: 'Projects',
  Backlink: 'Backlink',
  permissions_list: 'permissions_list',
  roles: 'roles',
  subscription: 'subscription',
  subscription_feature: 'subscription_feature',
  user_subscription: 'user_subscription',
  user_permissions: 'user_permissions',
  package_features: 'package_features'
};

/**
 * This is a stub Prisma Client that will error at runtime if called.
 */
class PrismaClient {
  constructor() {
    return new Proxy(this, {
      get(target, prop) {
        let message
        const runtime = getRuntime()
        if (runtime.isEdge) {
          message = `PrismaClient is not configured to run in ${runtime.prettyName}. In order to run Prisma Client on edge runtime, either:
- Use Prisma Accelerate: https://pris.ly/d/accelerate
- Use Driver Adapters: https://pris.ly/d/driver-adapters
`;
        } else {
          message = 'PrismaClient is unable to run in this browser environment, or has been bundled for the browser (running in `' + runtime.prettyName + '`).'
        }
        
        message += `
If this is unexpected, please open an issue: https://pris.ly/prisma-prisma-bug-report`

        throw new Error(message)
      }
    })
  }
}

exports.PrismaClient = PrismaClient

Object.assign(exports, Prisma)
