
/**
 * Client
**/

import * as runtime from './runtime/library.js';
import $Types = runtime.Types // general types
import $Public = runtime.Types.Public
import $Utils = runtime.Types.Utils
import $Extensions = runtime.Types.Extensions
import $Result = runtime.Types.Result

export type PrismaPromise<T> = $Public.PrismaPromise<T>


/**
 * Model Projects
 * 
 */
export type Projects = $Result.DefaultSelection<Prisma.$ProjectsPayload>
/**
 * Model Backlink
 * 
 */
export type Backlink = $Result.DefaultSelection<Prisma.$BacklinkPayload>
/**
 * Model permissions_list
 * 
 */
export type permissions_list = $Result.DefaultSelection<Prisma.$permissions_listPayload>
/**
 * Model roles
 * 
 */
export type roles = $Result.DefaultSelection<Prisma.$rolesPayload>
/**
 * Model subscription
 * 
 */
export type subscription = $Result.DefaultSelection<Prisma.$subscriptionPayload>
/**
 * Model subscription_feature
 * 
 */
export type subscription_feature = $Result.DefaultSelection<Prisma.$subscription_featurePayload>
/**
 * Model user_subscription
 * 
 */
export type user_subscription = $Result.DefaultSelection<Prisma.$user_subscriptionPayload>
/**
 * Model user_permissions
 * 
 */
export type user_permissions = $Result.DefaultSelection<Prisma.$user_permissionsPayload>
/**
 * Model package_features
 * 
 */
export type package_features = $Result.DefaultSelection<Prisma.$package_featuresPayload>

/**
 * ##  Prisma Client ʲˢ
 *
 * Type-safe database client for TypeScript & Node.js
 * @example
 * ```
 * const prisma = new PrismaClient()
 * // Fetch zero or more Projects
 * const projects = await prisma.projects.findMany()
 * ```
 *
 *
 * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
 */
export class PrismaClient<
  ClientOptions extends Prisma.PrismaClientOptions = Prisma.PrismaClientOptions,
  U = 'log' extends keyof ClientOptions ? ClientOptions['log'] extends Array<Prisma.LogLevel | Prisma.LogDefinition> ? Prisma.GetEvents<ClientOptions['log']> : never : never,
  ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs
> {
  [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['other'] }

    /**
   * ##  Prisma Client ʲˢ
   *
   * Type-safe database client for TypeScript & Node.js
   * @example
   * ```
   * const prisma = new PrismaClient()
   * // Fetch zero or more Projects
   * const projects = await prisma.projects.findMany()
   * ```
   *
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
   */

  constructor(optionsArg ?: Prisma.Subset<ClientOptions, Prisma.PrismaClientOptions>);
  $on<V extends U>(eventType: V, callback: (event: V extends 'query' ? Prisma.QueryEvent : Prisma.LogEvent) => void): void;

  /**
   * Connect with the database
   */
  $connect(): $Utils.JsPromise<void>;

  /**
   * Disconnect from the database
   */
  $disconnect(): $Utils.JsPromise<void>;

  /**
   * Add a middleware
   * @deprecated since 4.16.0. For new code, prefer client extensions instead.
   * @see https://pris.ly/d/extensions
   */
  $use(cb: Prisma.Middleware): void

/**
   * Executes a prepared raw query and returns the number of affected rows.
   * @example
   * ```
   * const result = await prisma.$executeRaw`UPDATE User SET cool = ${true} WHERE email = ${'user@email.com'};`
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Executes a raw query and returns the number of affected rows.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$executeRawUnsafe('UPDATE User SET cool = $1 WHERE email = $2 ;', true, 'user@email.com')
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Performs a prepared raw query and returns the `SELECT` data.
   * @example
   * ```
   * const result = await prisma.$queryRaw`SELECT * FROM User WHERE id = ${1} OR email = ${'user@email.com'};`
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<T>;

  /**
   * Performs a raw query and returns the `SELECT` data.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$queryRawUnsafe('SELECT * FROM User WHERE id = $1 OR email = $2;', 1, 'user@email.com')
   * ```
   *
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<T>;


  /**
   * Allows the running of a sequence of read/write operations that are guaranteed to either succeed or fail as a whole.
   * @example
   * ```
   * const [george, bob, alice] = await prisma.$transaction([
   *   prisma.user.create({ data: { name: 'George' } }),
   *   prisma.user.create({ data: { name: 'Bob' } }),
   *   prisma.user.create({ data: { name: 'Alice' } }),
   * ])
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/concepts/components/prisma-client/transactions).
   */
  $transaction<P extends Prisma.PrismaPromise<any>[]>(arg: [...P], options?: { isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<runtime.Types.Utils.UnwrapTuple<P>>

  $transaction<R>(fn: (prisma: Omit<PrismaClient, runtime.ITXClientDenyList>) => $Utils.JsPromise<R>, options?: { maxWait?: number, timeout?: number, isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<R>


  $extends: $Extensions.ExtendsHook<"extends", Prisma.TypeMapCb, ExtArgs, $Utils.Call<Prisma.TypeMapCb, {
    extArgs: ExtArgs
  }>, ClientOptions>

      /**
   * `prisma.projects`: Exposes CRUD operations for the **Projects** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Projects
    * const projects = await prisma.projects.findMany()
    * ```
    */
  get projects(): Prisma.ProjectsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.backlink`: Exposes CRUD operations for the **Backlink** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Backlinks
    * const backlinks = await prisma.backlink.findMany()
    * ```
    */
  get backlink(): Prisma.BacklinkDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.permissions_list`: Exposes CRUD operations for the **permissions_list** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Permissions_lists
    * const permissions_lists = await prisma.permissions_list.findMany()
    * ```
    */
  get permissions_list(): Prisma.permissions_listDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.roles`: Exposes CRUD operations for the **roles** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Roles
    * const roles = await prisma.roles.findMany()
    * ```
    */
  get roles(): Prisma.rolesDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.subscription`: Exposes CRUD operations for the **subscription** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Subscriptions
    * const subscriptions = await prisma.subscription.findMany()
    * ```
    */
  get subscription(): Prisma.subscriptionDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.subscription_feature`: Exposes CRUD operations for the **subscription_feature** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Subscription_features
    * const subscription_features = await prisma.subscription_feature.findMany()
    * ```
    */
  get subscription_feature(): Prisma.subscription_featureDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.user_subscription`: Exposes CRUD operations for the **user_subscription** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more User_subscriptions
    * const user_subscriptions = await prisma.user_subscription.findMany()
    * ```
    */
  get user_subscription(): Prisma.user_subscriptionDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.user_permissions`: Exposes CRUD operations for the **user_permissions** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more User_permissions
    * const user_permissions = await prisma.user_permissions.findMany()
    * ```
    */
  get user_permissions(): Prisma.user_permissionsDelegate<ExtArgs, ClientOptions>;

  /**
   * `prisma.package_features`: Exposes CRUD operations for the **package_features** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Package_features
    * const package_features = await prisma.package_features.findMany()
    * ```
    */
  get package_features(): Prisma.package_featuresDelegate<ExtArgs, ClientOptions>;
}

export namespace Prisma {
  export import DMMF = runtime.DMMF

  export type PrismaPromise<T> = $Public.PrismaPromise<T>

  /**
   * Validator
   */
  export import validator = runtime.Public.validator

  /**
   * Prisma Errors
   */
  export import PrismaClientKnownRequestError = runtime.PrismaClientKnownRequestError
  export import PrismaClientUnknownRequestError = runtime.PrismaClientUnknownRequestError
  export import PrismaClientRustPanicError = runtime.PrismaClientRustPanicError
  export import PrismaClientInitializationError = runtime.PrismaClientInitializationError
  export import PrismaClientValidationError = runtime.PrismaClientValidationError

  /**
   * Re-export of sql-template-tag
   */
  export import sql = runtime.sqltag
  export import empty = runtime.empty
  export import join = runtime.join
  export import raw = runtime.raw
  export import Sql = runtime.Sql



  /**
   * Decimal.js
   */
  export import Decimal = runtime.Decimal

  export type DecimalJsLike = runtime.DecimalJsLike

  /**
   * Metrics
   */
  export type Metrics = runtime.Metrics
  export type Metric<T> = runtime.Metric<T>
  export type MetricHistogram = runtime.MetricHistogram
  export type MetricHistogramBucket = runtime.MetricHistogramBucket

  /**
  * Extensions
  */
  export import Extension = $Extensions.UserArgs
  export import getExtensionContext = runtime.Extensions.getExtensionContext
  export import Args = $Public.Args
  export import Payload = $Public.Payload
  export import Result = $Public.Result
  export import Exact = $Public.Exact

  /**
   * Prisma Client JS version: 6.4.1
   * Query Engine version: a9055b89e58b4b5bfb59600785423b1db3d0e75d
   */
  export type PrismaVersion = {
    client: string
  }

  export const prismaVersion: PrismaVersion

  /**
   * Utility Types
   */


  export import JsonObject = runtime.JsonObject
  export import JsonArray = runtime.JsonArray
  export import JsonValue = runtime.JsonValue
  export import InputJsonObject = runtime.InputJsonObject
  export import InputJsonArray = runtime.InputJsonArray
  export import InputJsonValue = runtime.InputJsonValue

  /**
   * Types of the values used to represent different kinds of `null` values when working with JSON fields.
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  namespace NullTypes {
    /**
    * Type of `Prisma.DbNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.DbNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class DbNull {
      private DbNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.JsonNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.JsonNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class JsonNull {
      private JsonNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.AnyNull`.
    *
    * You cannot use other instances of this class. Please use the `Prisma.AnyNull` value.
    *
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class AnyNull {
      private AnyNull: never
      private constructor()
    }
  }

  /**
   * Helper for filtering JSON entries that have `null` on the database (empty on the db)
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const DbNull: NullTypes.DbNull

  /**
   * Helper for filtering JSON entries that have JSON `null` values (not empty on the db)
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const JsonNull: NullTypes.JsonNull

  /**
   * Helper for filtering JSON entries that are `Prisma.DbNull` or `Prisma.JsonNull`
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const AnyNull: NullTypes.AnyNull

  type SelectAndInclude = {
    select: any
    include: any
  }

  type SelectAndOmit = {
    select: any
    omit: any
  }

  /**
   * Get the type of the value, that the Promise holds.
   */
  export type PromiseType<T extends PromiseLike<any>> = T extends PromiseLike<infer U> ? U : T;

  /**
   * Get the return type of a function which returns a Promise.
   */
  export type PromiseReturnType<T extends (...args: any) => $Utils.JsPromise<any>> = PromiseType<ReturnType<T>>

  /**
   * From T, pick a set of properties whose keys are in the union K
   */
  type Prisma__Pick<T, K extends keyof T> = {
      [P in K]: T[P];
  };


  export type Enumerable<T> = T | Array<T>;

  export type RequiredKeys<T> = {
    [K in keyof T]-?: {} extends Prisma__Pick<T, K> ? never : K
  }[keyof T]

  export type TruthyKeys<T> = keyof {
    [K in keyof T as T[K] extends false | undefined | null ? never : K]: K
  }

  export type TrueKeys<T> = TruthyKeys<Prisma__Pick<T, RequiredKeys<T>>>

  /**
   * Subset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection
   */
  export type Subset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never;
  };

  /**
   * SelectSubset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection.
   * Additionally, it validates, if both select and include are present. If the case, it errors.
   */
  export type SelectSubset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    (T extends SelectAndInclude
      ? 'Please either choose `select` or `include`.'
      : T extends SelectAndOmit
        ? 'Please either choose `select` or `omit`.'
        : {})

  /**
   * Subset + Intersection
   * @desc From `T` pick properties that exist in `U` and intersect `K`
   */
  export type SubsetIntersection<T, U, K> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    K

  type Without<T, U> = { [P in Exclude<keyof T, keyof U>]?: never };

  /**
   * XOR is needed to have a real mutually exclusive union type
   * https://stackoverflow.com/questions/42123407/does-typescript-support-mutually-exclusive-types
   */
  type XOR<T, U> =
    T extends object ?
    U extends object ?
      (Without<T, U> & U) | (Without<U, T> & T)
    : U : T


  /**
   * Is T a Record?
   */
  type IsObject<T extends any> = T extends Array<any>
  ? False
  : T extends Date
  ? False
  : T extends Uint8Array
  ? False
  : T extends BigInt
  ? False
  : T extends object
  ? True
  : False


  /**
   * If it's T[], return T
   */
  export type UnEnumerate<T extends unknown> = T extends Array<infer U> ? U : T

  /**
   * From ts-toolbelt
   */

  type __Either<O extends object, K extends Key> = Omit<O, K> &
    {
      // Merge all but K
      [P in K]: Prisma__Pick<O, P & keyof O> // With K possibilities
    }[K]

  type EitherStrict<O extends object, K extends Key> = Strict<__Either<O, K>>

  type EitherLoose<O extends object, K extends Key> = ComputeRaw<__Either<O, K>>

  type _Either<
    O extends object,
    K extends Key,
    strict extends Boolean
  > = {
    1: EitherStrict<O, K>
    0: EitherLoose<O, K>
  }[strict]

  type Either<
    O extends object,
    K extends Key,
    strict extends Boolean = 1
  > = O extends unknown ? _Either<O, K, strict> : never

  export type Union = any

  type PatchUndefined<O extends object, O1 extends object> = {
    [K in keyof O]: O[K] extends undefined ? At<O1, K> : O[K]
  } & {}

  /** Helper Types for "Merge" **/
  export type IntersectOf<U extends Union> = (
    U extends unknown ? (k: U) => void : never
  ) extends (k: infer I) => void
    ? I
    : never

  export type Overwrite<O extends object, O1 extends object> = {
      [K in keyof O]: K extends keyof O1 ? O1[K] : O[K];
  } & {};

  type _Merge<U extends object> = IntersectOf<Overwrite<U, {
      [K in keyof U]-?: At<U, K>;
  }>>;

  type Key = string | number | symbol;
  type AtBasic<O extends object, K extends Key> = K extends keyof O ? O[K] : never;
  type AtStrict<O extends object, K extends Key> = O[K & keyof O];
  type AtLoose<O extends object, K extends Key> = O extends unknown ? AtStrict<O, K> : never;
  export type At<O extends object, K extends Key, strict extends Boolean = 1> = {
      1: AtStrict<O, K>;
      0: AtLoose<O, K>;
  }[strict];

  export type ComputeRaw<A extends any> = A extends Function ? A : {
    [K in keyof A]: A[K];
  } & {};

  export type OptionalFlat<O> = {
    [K in keyof O]?: O[K];
  } & {};

  type _Record<K extends keyof any, T> = {
    [P in K]: T;
  };

  // cause typescript not to expand types and preserve names
  type NoExpand<T> = T extends unknown ? T : never;

  // this type assumes the passed object is entirely optional
  type AtLeast<O extends object, K extends string> = NoExpand<
    O extends unknown
    ? | (K extends keyof O ? { [P in K]: O[P] } & O : O)
      | {[P in keyof O as P extends K ? K : never]-?: O[P]} & O
    : never>;

  type _Strict<U, _U = U> = U extends unknown ? U & OptionalFlat<_Record<Exclude<Keys<_U>, keyof U>, never>> : never;

  export type Strict<U extends object> = ComputeRaw<_Strict<U>>;
  /** End Helper Types for "Merge" **/

  export type Merge<U extends object> = ComputeRaw<_Merge<Strict<U>>>;

  /**
  A [[Boolean]]
  */
  export type Boolean = True | False

  // /**
  // 1
  // */
  export type True = 1

  /**
  0
  */
  export type False = 0

  export type Not<B extends Boolean> = {
    0: 1
    1: 0
  }[B]

  export type Extends<A1 extends any, A2 extends any> = [A1] extends [never]
    ? 0 // anything `never` is false
    : A1 extends A2
    ? 1
    : 0

  export type Has<U extends Union, U1 extends Union> = Not<
    Extends<Exclude<U1, U>, U1>
  >

  export type Or<B1 extends Boolean, B2 extends Boolean> = {
    0: {
      0: 0
      1: 1
    }
    1: {
      0: 1
      1: 1
    }
  }[B1][B2]

  export type Keys<U extends Union> = U extends unknown ? keyof U : never

  type Cast<A, B> = A extends B ? A : B;

  export const type: unique symbol;



  /**
   * Used by group by
   */

  export type GetScalarType<T, O> = O extends object ? {
    [P in keyof T]: P extends keyof O
      ? O[P]
      : never
  } : never

  type FieldPaths<
    T,
    U = Omit<T, '_avg' | '_sum' | '_count' | '_min' | '_max'>
  > = IsObject<T> extends True ? U : T

  type GetHavingFields<T> = {
    [K in keyof T]: Or<
      Or<Extends<'OR', K>, Extends<'AND', K>>,
      Extends<'NOT', K>
    > extends True
      ? // infer is only needed to not hit TS limit
        // based on the brilliant idea of Pierre-Antoine Mills
        // https://github.com/microsoft/TypeScript/issues/30188#issuecomment-478938437
        T[K] extends infer TK
        ? GetHavingFields<UnEnumerate<TK> extends object ? Merge<UnEnumerate<TK>> : never>
        : never
      : {} extends FieldPaths<T[K]>
      ? never
      : K
  }[keyof T]

  /**
   * Convert tuple to union
   */
  type _TupleToUnion<T> = T extends (infer E)[] ? E : never
  type TupleToUnion<K extends readonly any[]> = _TupleToUnion<K>
  type MaybeTupleToUnion<T> = T extends any[] ? TupleToUnion<T> : T

  /**
   * Like `Pick`, but additionally can also accept an array of keys
   */
  type PickEnumerable<T, K extends Enumerable<keyof T> | keyof T> = Prisma__Pick<T, MaybeTupleToUnion<K>>

  /**
   * Exclude all keys with underscores
   */
  type ExcludeUnderscoreKeys<T extends string> = T extends `_${string}` ? never : T


  export type FieldRef<Model, FieldType> = runtime.FieldRef<Model, FieldType>

  type FieldRefInputType<Model, FieldType> = Model extends never ? never : FieldRef<Model, FieldType>


  export const ModelName: {
    Projects: 'Projects',
    Backlink: 'Backlink',
    permissions_list: 'permissions_list',
    roles: 'roles',
    subscription: 'subscription',
    subscription_feature: 'subscription_feature',
    user_subscription: 'user_subscription',
    user_permissions: 'user_permissions',
    package_features: 'package_features'
  };

  export type ModelName = (typeof ModelName)[keyof typeof ModelName]


  export type Datasources = {
    db?: Datasource
  }

  interface TypeMapCb extends $Utils.Fn<{extArgs: $Extensions.InternalArgs, clientOptions: PrismaClientOptions }, $Utils.Record<string, any>> {
    returns: Prisma.TypeMap<this['params']['extArgs'], this['params']['clientOptions']>
  }

  export type TypeMap<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> = {
    meta: {
      modelProps: "projects" | "backlink" | "permissions_list" | "roles" | "subscription" | "subscription_feature" | "user_subscription" | "user_permissions" | "package_features"
      txIsolationLevel: Prisma.TransactionIsolationLevel
    }
    model: {
      Projects: {
        payload: Prisma.$ProjectsPayload<ExtArgs>
        fields: Prisma.ProjectsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ProjectsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ProjectsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectsPayload>
          }
          findFirst: {
            args: Prisma.ProjectsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ProjectsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectsPayload>
          }
          findMany: {
            args: Prisma.ProjectsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectsPayload>[]
          }
          create: {
            args: Prisma.ProjectsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectsPayload>
          }
          createMany: {
            args: Prisma.ProjectsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ProjectsCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectsPayload>[]
          }
          delete: {
            args: Prisma.ProjectsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectsPayload>
          }
          update: {
            args: Prisma.ProjectsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectsPayload>
          }
          deleteMany: {
            args: Prisma.ProjectsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.ProjectsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.ProjectsUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectsPayload>[]
          }
          upsert: {
            args: Prisma.ProjectsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$ProjectsPayload>
          }
          aggregate: {
            args: Prisma.ProjectsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateProjects>
          }
          groupBy: {
            args: Prisma.ProjectsGroupByArgs<ExtArgs>
            result: $Utils.Optional<ProjectsGroupByOutputType>[]
          }
          count: {
            args: Prisma.ProjectsCountArgs<ExtArgs>
            result: $Utils.Optional<ProjectsCountAggregateOutputType> | number
          }
        }
      }
      Backlink: {
        payload: Prisma.$BacklinkPayload<ExtArgs>
        fields: Prisma.BacklinkFieldRefs
        operations: {
          findUnique: {
            args: Prisma.BacklinkFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BacklinkPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.BacklinkFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BacklinkPayload>
          }
          findFirst: {
            args: Prisma.BacklinkFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BacklinkPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.BacklinkFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BacklinkPayload>
          }
          findMany: {
            args: Prisma.BacklinkFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BacklinkPayload>[]
          }
          create: {
            args: Prisma.BacklinkCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BacklinkPayload>
          }
          createMany: {
            args: Prisma.BacklinkCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.BacklinkCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BacklinkPayload>[]
          }
          delete: {
            args: Prisma.BacklinkDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BacklinkPayload>
          }
          update: {
            args: Prisma.BacklinkUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BacklinkPayload>
          }
          deleteMany: {
            args: Prisma.BacklinkDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.BacklinkUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.BacklinkUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BacklinkPayload>[]
          }
          upsert: {
            args: Prisma.BacklinkUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$BacklinkPayload>
          }
          aggregate: {
            args: Prisma.BacklinkAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateBacklink>
          }
          groupBy: {
            args: Prisma.BacklinkGroupByArgs<ExtArgs>
            result: $Utils.Optional<BacklinkGroupByOutputType>[]
          }
          count: {
            args: Prisma.BacklinkCountArgs<ExtArgs>
            result: $Utils.Optional<BacklinkCountAggregateOutputType> | number
          }
        }
      }
      permissions_list: {
        payload: Prisma.$permissions_listPayload<ExtArgs>
        fields: Prisma.permissions_listFieldRefs
        operations: {
          findUnique: {
            args: Prisma.permissions_listFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permissions_listPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.permissions_listFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permissions_listPayload>
          }
          findFirst: {
            args: Prisma.permissions_listFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permissions_listPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.permissions_listFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permissions_listPayload>
          }
          findMany: {
            args: Prisma.permissions_listFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permissions_listPayload>[]
          }
          create: {
            args: Prisma.permissions_listCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permissions_listPayload>
          }
          createMany: {
            args: Prisma.permissions_listCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.permissions_listCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permissions_listPayload>[]
          }
          delete: {
            args: Prisma.permissions_listDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permissions_listPayload>
          }
          update: {
            args: Prisma.permissions_listUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permissions_listPayload>
          }
          deleteMany: {
            args: Prisma.permissions_listDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.permissions_listUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.permissions_listUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permissions_listPayload>[]
          }
          upsert: {
            args: Prisma.permissions_listUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$permissions_listPayload>
          }
          aggregate: {
            args: Prisma.Permissions_listAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregatePermissions_list>
          }
          groupBy: {
            args: Prisma.permissions_listGroupByArgs<ExtArgs>
            result: $Utils.Optional<Permissions_listGroupByOutputType>[]
          }
          count: {
            args: Prisma.permissions_listCountArgs<ExtArgs>
            result: $Utils.Optional<Permissions_listCountAggregateOutputType> | number
          }
        }
      }
      roles: {
        payload: Prisma.$rolesPayload<ExtArgs>
        fields: Prisma.rolesFieldRefs
        operations: {
          findUnique: {
            args: Prisma.rolesFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rolesPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.rolesFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rolesPayload>
          }
          findFirst: {
            args: Prisma.rolesFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rolesPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.rolesFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rolesPayload>
          }
          findMany: {
            args: Prisma.rolesFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rolesPayload>[]
          }
          create: {
            args: Prisma.rolesCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rolesPayload>
          }
          createMany: {
            args: Prisma.rolesCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.rolesCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rolesPayload>[]
          }
          delete: {
            args: Prisma.rolesDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rolesPayload>
          }
          update: {
            args: Prisma.rolesUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rolesPayload>
          }
          deleteMany: {
            args: Prisma.rolesDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.rolesUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.rolesUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rolesPayload>[]
          }
          upsert: {
            args: Prisma.rolesUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$rolesPayload>
          }
          aggregate: {
            args: Prisma.RolesAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateRoles>
          }
          groupBy: {
            args: Prisma.rolesGroupByArgs<ExtArgs>
            result: $Utils.Optional<RolesGroupByOutputType>[]
          }
          count: {
            args: Prisma.rolesCountArgs<ExtArgs>
            result: $Utils.Optional<RolesCountAggregateOutputType> | number
          }
        }
      }
      subscription: {
        payload: Prisma.$subscriptionPayload<ExtArgs>
        fields: Prisma.subscriptionFieldRefs
        operations: {
          findUnique: {
            args: Prisma.subscriptionFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$subscriptionPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.subscriptionFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$subscriptionPayload>
          }
          findFirst: {
            args: Prisma.subscriptionFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$subscriptionPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.subscriptionFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$subscriptionPayload>
          }
          findMany: {
            args: Prisma.subscriptionFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$subscriptionPayload>[]
          }
          create: {
            args: Prisma.subscriptionCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$subscriptionPayload>
          }
          createMany: {
            args: Prisma.subscriptionCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.subscriptionCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$subscriptionPayload>[]
          }
          delete: {
            args: Prisma.subscriptionDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$subscriptionPayload>
          }
          update: {
            args: Prisma.subscriptionUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$subscriptionPayload>
          }
          deleteMany: {
            args: Prisma.subscriptionDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.subscriptionUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.subscriptionUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$subscriptionPayload>[]
          }
          upsert: {
            args: Prisma.subscriptionUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$subscriptionPayload>
          }
          aggregate: {
            args: Prisma.SubscriptionAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateSubscription>
          }
          groupBy: {
            args: Prisma.subscriptionGroupByArgs<ExtArgs>
            result: $Utils.Optional<SubscriptionGroupByOutputType>[]
          }
          count: {
            args: Prisma.subscriptionCountArgs<ExtArgs>
            result: $Utils.Optional<SubscriptionCountAggregateOutputType> | number
          }
        }
      }
      subscription_feature: {
        payload: Prisma.$subscription_featurePayload<ExtArgs>
        fields: Prisma.subscription_featureFieldRefs
        operations: {
          findUnique: {
            args: Prisma.subscription_featureFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$subscription_featurePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.subscription_featureFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$subscription_featurePayload>
          }
          findFirst: {
            args: Prisma.subscription_featureFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$subscription_featurePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.subscription_featureFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$subscription_featurePayload>
          }
          findMany: {
            args: Prisma.subscription_featureFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$subscription_featurePayload>[]
          }
          create: {
            args: Prisma.subscription_featureCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$subscription_featurePayload>
          }
          createMany: {
            args: Prisma.subscription_featureCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.subscription_featureCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$subscription_featurePayload>[]
          }
          delete: {
            args: Prisma.subscription_featureDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$subscription_featurePayload>
          }
          update: {
            args: Prisma.subscription_featureUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$subscription_featurePayload>
          }
          deleteMany: {
            args: Prisma.subscription_featureDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.subscription_featureUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.subscription_featureUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$subscription_featurePayload>[]
          }
          upsert: {
            args: Prisma.subscription_featureUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$subscription_featurePayload>
          }
          aggregate: {
            args: Prisma.Subscription_featureAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateSubscription_feature>
          }
          groupBy: {
            args: Prisma.subscription_featureGroupByArgs<ExtArgs>
            result: $Utils.Optional<Subscription_featureGroupByOutputType>[]
          }
          count: {
            args: Prisma.subscription_featureCountArgs<ExtArgs>
            result: $Utils.Optional<Subscription_featureCountAggregateOutputType> | number
          }
        }
      }
      user_subscription: {
        payload: Prisma.$user_subscriptionPayload<ExtArgs>
        fields: Prisma.user_subscriptionFieldRefs
        operations: {
          findUnique: {
            args: Prisma.user_subscriptionFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$user_subscriptionPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.user_subscriptionFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$user_subscriptionPayload>
          }
          findFirst: {
            args: Prisma.user_subscriptionFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$user_subscriptionPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.user_subscriptionFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$user_subscriptionPayload>
          }
          findMany: {
            args: Prisma.user_subscriptionFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$user_subscriptionPayload>[]
          }
          create: {
            args: Prisma.user_subscriptionCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$user_subscriptionPayload>
          }
          createMany: {
            args: Prisma.user_subscriptionCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.user_subscriptionCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$user_subscriptionPayload>[]
          }
          delete: {
            args: Prisma.user_subscriptionDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$user_subscriptionPayload>
          }
          update: {
            args: Prisma.user_subscriptionUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$user_subscriptionPayload>
          }
          deleteMany: {
            args: Prisma.user_subscriptionDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.user_subscriptionUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.user_subscriptionUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$user_subscriptionPayload>[]
          }
          upsert: {
            args: Prisma.user_subscriptionUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$user_subscriptionPayload>
          }
          aggregate: {
            args: Prisma.User_subscriptionAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateUser_subscription>
          }
          groupBy: {
            args: Prisma.user_subscriptionGroupByArgs<ExtArgs>
            result: $Utils.Optional<User_subscriptionGroupByOutputType>[]
          }
          count: {
            args: Prisma.user_subscriptionCountArgs<ExtArgs>
            result: $Utils.Optional<User_subscriptionCountAggregateOutputType> | number
          }
        }
      }
      user_permissions: {
        payload: Prisma.$user_permissionsPayload<ExtArgs>
        fields: Prisma.user_permissionsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.user_permissionsFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$user_permissionsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.user_permissionsFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$user_permissionsPayload>
          }
          findFirst: {
            args: Prisma.user_permissionsFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$user_permissionsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.user_permissionsFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$user_permissionsPayload>
          }
          findMany: {
            args: Prisma.user_permissionsFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$user_permissionsPayload>[]
          }
          create: {
            args: Prisma.user_permissionsCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$user_permissionsPayload>
          }
          createMany: {
            args: Prisma.user_permissionsCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.user_permissionsCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$user_permissionsPayload>[]
          }
          delete: {
            args: Prisma.user_permissionsDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$user_permissionsPayload>
          }
          update: {
            args: Prisma.user_permissionsUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$user_permissionsPayload>
          }
          deleteMany: {
            args: Prisma.user_permissionsDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.user_permissionsUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.user_permissionsUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$user_permissionsPayload>[]
          }
          upsert: {
            args: Prisma.user_permissionsUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$user_permissionsPayload>
          }
          aggregate: {
            args: Prisma.User_permissionsAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregateUser_permissions>
          }
          groupBy: {
            args: Prisma.user_permissionsGroupByArgs<ExtArgs>
            result: $Utils.Optional<User_permissionsGroupByOutputType>[]
          }
          count: {
            args: Prisma.user_permissionsCountArgs<ExtArgs>
            result: $Utils.Optional<User_permissionsCountAggregateOutputType> | number
          }
        }
      }
      package_features: {
        payload: Prisma.$package_featuresPayload<ExtArgs>
        fields: Prisma.package_featuresFieldRefs
        operations: {
          findUnique: {
            args: Prisma.package_featuresFindUniqueArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$package_featuresPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.package_featuresFindUniqueOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$package_featuresPayload>
          }
          findFirst: {
            args: Prisma.package_featuresFindFirstArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$package_featuresPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.package_featuresFindFirstOrThrowArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$package_featuresPayload>
          }
          findMany: {
            args: Prisma.package_featuresFindManyArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$package_featuresPayload>[]
          }
          create: {
            args: Prisma.package_featuresCreateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$package_featuresPayload>
          }
          createMany: {
            args: Prisma.package_featuresCreateManyArgs<ExtArgs>
            result: BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.package_featuresCreateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$package_featuresPayload>[]
          }
          delete: {
            args: Prisma.package_featuresDeleteArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$package_featuresPayload>
          }
          update: {
            args: Prisma.package_featuresUpdateArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$package_featuresPayload>
          }
          deleteMany: {
            args: Prisma.package_featuresDeleteManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateMany: {
            args: Prisma.package_featuresUpdateManyArgs<ExtArgs>
            result: BatchPayload
          }
          updateManyAndReturn: {
            args: Prisma.package_featuresUpdateManyAndReturnArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$package_featuresPayload>[]
          }
          upsert: {
            args: Prisma.package_featuresUpsertArgs<ExtArgs>
            result: $Utils.PayloadToResult<Prisma.$package_featuresPayload>
          }
          aggregate: {
            args: Prisma.Package_featuresAggregateArgs<ExtArgs>
            result: $Utils.Optional<AggregatePackage_features>
          }
          groupBy: {
            args: Prisma.package_featuresGroupByArgs<ExtArgs>
            result: $Utils.Optional<Package_featuresGroupByOutputType>[]
          }
          count: {
            args: Prisma.package_featuresCountArgs<ExtArgs>
            result: $Utils.Optional<Package_featuresCountAggregateOutputType> | number
          }
        }
      }
    }
  } & {
    other: {
      payload: any
      operations: {
        $executeRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
        $executeRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
        $queryRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
        $queryRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
      }
    }
  }
  export const defineExtension: $Extensions.ExtendsHook<"define", Prisma.TypeMapCb, $Extensions.DefaultArgs>
  export type DefaultPrismaClient = PrismaClient
  export type ErrorFormat = 'pretty' | 'colorless' | 'minimal'
  export interface PrismaClientOptions {
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasources?: Datasources
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasourceUrl?: string
    /**
     * @default "colorless"
     */
    errorFormat?: ErrorFormat
    /**
     * @example
     * ```
     * // Defaults to stdout
     * log: ['query', 'info', 'warn', 'error']
     * 
     * // Emit as events
     * log: [
     *   { emit: 'stdout', level: 'query' },
     *   { emit: 'stdout', level: 'info' },
     *   { emit: 'stdout', level: 'warn' }
     *   { emit: 'stdout', level: 'error' }
     * ]
     * ```
     * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/logging#the-log-option).
     */
    log?: (LogLevel | LogDefinition)[]
    /**
     * The default values for transactionOptions
     * maxWait ?= 2000
     * timeout ?= 5000
     */
    transactionOptions?: {
      maxWait?: number
      timeout?: number
      isolationLevel?: Prisma.TransactionIsolationLevel
    }
    /**
     * Global configuration for omitting model fields by default.
     * 
     * @example
     * ```
     * const prisma = new PrismaClient({
     *   omit: {
     *     user: {
     *       password: true
     *     }
     *   }
     * })
     * ```
     */
    omit?: Prisma.GlobalOmitConfig
  }
  export type GlobalOmitConfig = {
    projects?: ProjectsOmit
    backlink?: BacklinkOmit
    permissions_list?: permissions_listOmit
    roles?: rolesOmit
    subscription?: subscriptionOmit
    subscription_feature?: subscription_featureOmit
    user_subscription?: user_subscriptionOmit
    user_permissions?: user_permissionsOmit
    package_features?: package_featuresOmit
  }

  /* Types for Logging */
  export type LogLevel = 'info' | 'query' | 'warn' | 'error'
  export type LogDefinition = {
    level: LogLevel
    emit: 'stdout' | 'event'
  }

  export type GetLogType<T extends LogLevel | LogDefinition> = T extends LogDefinition ? T['emit'] extends 'event' ? T['level'] : never : never
  export type GetEvents<T extends any> = T extends Array<LogLevel | LogDefinition> ?
    GetLogType<T[0]> | GetLogType<T[1]> | GetLogType<T[2]> | GetLogType<T[3]>
    : never

  export type QueryEvent = {
    timestamp: Date
    query: string
    params: string
    duration: number
    target: string
  }

  export type LogEvent = {
    timestamp: Date
    message: string
    target: string
  }
  /* End Types for Logging */


  export type PrismaAction =
    | 'findUnique'
    | 'findUniqueOrThrow'
    | 'findMany'
    | 'findFirst'
    | 'findFirstOrThrow'
    | 'create'
    | 'createMany'
    | 'createManyAndReturn'
    | 'update'
    | 'updateMany'
    | 'updateManyAndReturn'
    | 'upsert'
    | 'delete'
    | 'deleteMany'
    | 'executeRaw'
    | 'queryRaw'
    | 'aggregate'
    | 'count'
    | 'runCommandRaw'
    | 'findRaw'
    | 'groupBy'

  /**
   * These options are being passed into the middleware as "params"
   */
  export type MiddlewareParams = {
    model?: ModelName
    action: PrismaAction
    args: any
    dataPath: string[]
    runInTransaction: boolean
  }

  /**
   * The `T` type makes sure, that the `return proceed` is not forgotten in the middleware implementation
   */
  export type Middleware<T = any> = (
    params: MiddlewareParams,
    next: (params: MiddlewareParams) => $Utils.JsPromise<T>,
  ) => $Utils.JsPromise<T>

  // tested in getLogLevel.test.ts
  export function getLogLevel(log: Array<LogLevel | LogDefinition>): LogLevel | undefined;

  /**
   * `PrismaClient` proxy available in interactive transactions.
   */
  export type TransactionClient = Omit<Prisma.DefaultPrismaClient, runtime.ITXClientDenyList>

  export type Datasource = {
    url?: string
  }

  /**
   * Count Types
   */


  /**
   * Count Type ProjectsCountOutputType
   */

  export type ProjectsCountOutputType = {
    Backlink: number
  }

  export type ProjectsCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    Backlink?: boolean | ProjectsCountOutputTypeCountBacklinkArgs
  }

  // Custom InputTypes
  /**
   * ProjectsCountOutputType without action
   */
  export type ProjectsCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the ProjectsCountOutputType
     */
    select?: ProjectsCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * ProjectsCountOutputType without action
   */
  export type ProjectsCountOutputTypeCountBacklinkArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: BacklinkWhereInput
  }


  /**
   * Count Type Permissions_listCountOutputType
   */

  export type Permissions_listCountOutputType = {
    user_permissions: number
    subscription_feature: number
  }

  export type Permissions_listCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user_permissions?: boolean | Permissions_listCountOutputTypeCountUser_permissionsArgs
    subscription_feature?: boolean | Permissions_listCountOutputTypeCountSubscription_featureArgs
  }

  // Custom InputTypes
  /**
   * Permissions_listCountOutputType without action
   */
  export type Permissions_listCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions_listCountOutputType
     */
    select?: Permissions_listCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * Permissions_listCountOutputType without action
   */
  export type Permissions_listCountOutputTypeCountUser_permissionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: user_permissionsWhereInput
  }

  /**
   * Permissions_listCountOutputType without action
   */
  export type Permissions_listCountOutputTypeCountSubscription_featureArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: subscription_featureWhereInput
  }


  /**
   * Count Type SubscriptionCountOutputType
   */

  export type SubscriptionCountOutputType = {
    user_subscription: number
    subscription_feature: number
    package_features: number
  }

  export type SubscriptionCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user_subscription?: boolean | SubscriptionCountOutputTypeCountUser_subscriptionArgs
    subscription_feature?: boolean | SubscriptionCountOutputTypeCountSubscription_featureArgs
    package_features?: boolean | SubscriptionCountOutputTypeCountPackage_featuresArgs
  }

  // Custom InputTypes
  /**
   * SubscriptionCountOutputType without action
   */
  export type SubscriptionCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the SubscriptionCountOutputType
     */
    select?: SubscriptionCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * SubscriptionCountOutputType without action
   */
  export type SubscriptionCountOutputTypeCountUser_subscriptionArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: user_subscriptionWhereInput
  }

  /**
   * SubscriptionCountOutputType without action
   */
  export type SubscriptionCountOutputTypeCountSubscription_featureArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: subscription_featureWhereInput
  }

  /**
   * SubscriptionCountOutputType without action
   */
  export type SubscriptionCountOutputTypeCountPackage_featuresArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: package_featuresWhereInput
  }


  /**
   * Models
   */

  /**
   * Model Projects
   */

  export type AggregateProjects = {
    _count: ProjectsCountAggregateOutputType | null
    _avg: ProjectsAvgAggregateOutputType | null
    _sum: ProjectsSumAggregateOutputType | null
    _min: ProjectsMinAggregateOutputType | null
    _max: ProjectsMaxAggregateOutputType | null
  }

  export type ProjectsAvgAggregateOutputType = {
    id: number | null
    category_id: number | null
    created_by_id: number | null
    time_around_days: number | null
  }

  export type ProjectsSumAggregateOutputType = {
    id: number | null
    category_id: number | null
    created_by_id: number | null
    time_around_days: number | null
  }

  export type ProjectsMinAggregateOutputType = {
    id: number | null
    domain_name: string | null
    domain_url: string | null
    category_id: number | null
    created_by_id: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    time_around: Date | null
    time_around_days: number | null
  }

  export type ProjectsMaxAggregateOutputType = {
    id: number | null
    domain_name: string | null
    domain_url: string | null
    category_id: number | null
    created_by_id: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    time_around: Date | null
    time_around_days: number | null
  }

  export type ProjectsCountAggregateOutputType = {
    id: number
    domain_name: number
    domain_url: number
    category_id: number
    created_by_id: number
    created_at: number
    updated_at: number
    deleted_at: number
    time_around: number
    time_around_days: number
    _all: number
  }


  export type ProjectsAvgAggregateInputType = {
    id?: true
    category_id?: true
    created_by_id?: true
    time_around_days?: true
  }

  export type ProjectsSumAggregateInputType = {
    id?: true
    category_id?: true
    created_by_id?: true
    time_around_days?: true
  }

  export type ProjectsMinAggregateInputType = {
    id?: true
    domain_name?: true
    domain_url?: true
    category_id?: true
    created_by_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    time_around?: true
    time_around_days?: true
  }

  export type ProjectsMaxAggregateInputType = {
    id?: true
    domain_name?: true
    domain_url?: true
    category_id?: true
    created_by_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    time_around?: true
    time_around_days?: true
  }

  export type ProjectsCountAggregateInputType = {
    id?: true
    domain_name?: true
    domain_url?: true
    category_id?: true
    created_by_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    time_around?: true
    time_around_days?: true
    _all?: true
  }

  export type ProjectsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Projects to aggregate.
     */
    where?: ProjectsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Projects to fetch.
     */
    orderBy?: ProjectsOrderByWithRelationInput | ProjectsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ProjectsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Projects from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Projects.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Projects
    **/
    _count?: true | ProjectsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ProjectsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ProjectsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ProjectsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ProjectsMaxAggregateInputType
  }

  export type GetProjectsAggregateType<T extends ProjectsAggregateArgs> = {
        [P in keyof T & keyof AggregateProjects]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateProjects[P]>
      : GetScalarType<T[P], AggregateProjects[P]>
  }




  export type ProjectsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ProjectsWhereInput
    orderBy?: ProjectsOrderByWithAggregationInput | ProjectsOrderByWithAggregationInput[]
    by: ProjectsScalarFieldEnum[] | ProjectsScalarFieldEnum
    having?: ProjectsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ProjectsCountAggregateInputType | true
    _avg?: ProjectsAvgAggregateInputType
    _sum?: ProjectsSumAggregateInputType
    _min?: ProjectsMinAggregateInputType
    _max?: ProjectsMaxAggregateInputType
  }

  export type ProjectsGroupByOutputType = {
    id: number
    domain_name: string
    domain_url: string
    category_id: number
    created_by_id: number
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    time_around: Date | null
    time_around_days: number
    _count: ProjectsCountAggregateOutputType | null
    _avg: ProjectsAvgAggregateOutputType | null
    _sum: ProjectsSumAggregateOutputType | null
    _min: ProjectsMinAggregateOutputType | null
    _max: ProjectsMaxAggregateOutputType | null
  }

  type GetProjectsGroupByPayload<T extends ProjectsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ProjectsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ProjectsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ProjectsGroupByOutputType[P]>
            : GetScalarType<T[P], ProjectsGroupByOutputType[P]>
        }
      >
    >


  export type ProjectsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    domain_name?: boolean
    domain_url?: boolean
    category_id?: boolean
    created_by_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    time_around?: boolean
    time_around_days?: boolean
    Backlink?: boolean | Projects$BacklinkArgs<ExtArgs>
    _count?: boolean | ProjectsCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["projects"]>

  export type ProjectsSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    domain_name?: boolean
    domain_url?: boolean
    category_id?: boolean
    created_by_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    time_around?: boolean
    time_around_days?: boolean
  }, ExtArgs["result"]["projects"]>

  export type ProjectsSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    domain_name?: boolean
    domain_url?: boolean
    category_id?: boolean
    created_by_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    time_around?: boolean
    time_around_days?: boolean
  }, ExtArgs["result"]["projects"]>

  export type ProjectsSelectScalar = {
    id?: boolean
    domain_name?: boolean
    domain_url?: boolean
    category_id?: boolean
    created_by_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    time_around?: boolean
    time_around_days?: boolean
  }

  export type ProjectsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "domain_name" | "domain_url" | "category_id" | "created_by_id" | "created_at" | "updated_at" | "deleted_at" | "time_around" | "time_around_days", ExtArgs["result"]["projects"]>
  export type ProjectsInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    Backlink?: boolean | Projects$BacklinkArgs<ExtArgs>
    _count?: boolean | ProjectsCountOutputTypeDefaultArgs<ExtArgs>
  }
  export type ProjectsIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {}
  export type ProjectsIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {}

  export type $ProjectsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Projects"
    objects: {
      Backlink: Prisma.$BacklinkPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      domain_name: string
      domain_url: string
      category_id: number
      created_by_id: number
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
      time_around: Date | null
      time_around_days: number
    }, ExtArgs["result"]["projects"]>
    composites: {}
  }

  type ProjectsGetPayload<S extends boolean | null | undefined | ProjectsDefaultArgs> = $Result.GetResult<Prisma.$ProjectsPayload, S>

  type ProjectsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<ProjectsFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: ProjectsCountAggregateInputType | true
    }

  export interface ProjectsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Projects'], meta: { name: 'Projects' } }
    /**
     * Find zero or one Projects that matches the filter.
     * @param {ProjectsFindUniqueArgs} args - Arguments to find a Projects
     * @example
     * // Get one Projects
     * const projects = await prisma.projects.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends ProjectsFindUniqueArgs>(args: SelectSubset<T, ProjectsFindUniqueArgs<ExtArgs>>): Prisma__ProjectsClient<$Result.GetResult<Prisma.$ProjectsPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Projects that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {ProjectsFindUniqueOrThrowArgs} args - Arguments to find a Projects
     * @example
     * // Get one Projects
     * const projects = await prisma.projects.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends ProjectsFindUniqueOrThrowArgs>(args: SelectSubset<T, ProjectsFindUniqueOrThrowArgs<ExtArgs>>): Prisma__ProjectsClient<$Result.GetResult<Prisma.$ProjectsPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Projects that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectsFindFirstArgs} args - Arguments to find a Projects
     * @example
     * // Get one Projects
     * const projects = await prisma.projects.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends ProjectsFindFirstArgs>(args?: SelectSubset<T, ProjectsFindFirstArgs<ExtArgs>>): Prisma__ProjectsClient<$Result.GetResult<Prisma.$ProjectsPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Projects that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectsFindFirstOrThrowArgs} args - Arguments to find a Projects
     * @example
     * // Get one Projects
     * const projects = await prisma.projects.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends ProjectsFindFirstOrThrowArgs>(args?: SelectSubset<T, ProjectsFindFirstOrThrowArgs<ExtArgs>>): Prisma__ProjectsClient<$Result.GetResult<Prisma.$ProjectsPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Projects that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Projects
     * const projects = await prisma.projects.findMany()
     * 
     * // Get first 10 Projects
     * const projects = await prisma.projects.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const projectsWithIdOnly = await prisma.projects.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends ProjectsFindManyArgs>(args?: SelectSubset<T, ProjectsFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectsPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Projects.
     * @param {ProjectsCreateArgs} args - Arguments to create a Projects.
     * @example
     * // Create one Projects
     * const Projects = await prisma.projects.create({
     *   data: {
     *     // ... data to create a Projects
     *   }
     * })
     * 
     */
    create<T extends ProjectsCreateArgs>(args: SelectSubset<T, ProjectsCreateArgs<ExtArgs>>): Prisma__ProjectsClient<$Result.GetResult<Prisma.$ProjectsPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Projects.
     * @param {ProjectsCreateManyArgs} args - Arguments to create many Projects.
     * @example
     * // Create many Projects
     * const projects = await prisma.projects.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends ProjectsCreateManyArgs>(args?: SelectSubset<T, ProjectsCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Projects and returns the data saved in the database.
     * @param {ProjectsCreateManyAndReturnArgs} args - Arguments to create many Projects.
     * @example
     * // Create many Projects
     * const projects = await prisma.projects.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Projects and only return the `id`
     * const projectsWithIdOnly = await prisma.projects.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends ProjectsCreateManyAndReturnArgs>(args?: SelectSubset<T, ProjectsCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectsPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a Projects.
     * @param {ProjectsDeleteArgs} args - Arguments to delete one Projects.
     * @example
     * // Delete one Projects
     * const Projects = await prisma.projects.delete({
     *   where: {
     *     // ... filter to delete one Projects
     *   }
     * })
     * 
     */
    delete<T extends ProjectsDeleteArgs>(args: SelectSubset<T, ProjectsDeleteArgs<ExtArgs>>): Prisma__ProjectsClient<$Result.GetResult<Prisma.$ProjectsPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Projects.
     * @param {ProjectsUpdateArgs} args - Arguments to update one Projects.
     * @example
     * // Update one Projects
     * const projects = await prisma.projects.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends ProjectsUpdateArgs>(args: SelectSubset<T, ProjectsUpdateArgs<ExtArgs>>): Prisma__ProjectsClient<$Result.GetResult<Prisma.$ProjectsPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Projects.
     * @param {ProjectsDeleteManyArgs} args - Arguments to filter Projects to delete.
     * @example
     * // Delete a few Projects
     * const { count } = await prisma.projects.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends ProjectsDeleteManyArgs>(args?: SelectSubset<T, ProjectsDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Projects.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Projects
     * const projects = await prisma.projects.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends ProjectsUpdateManyArgs>(args: SelectSubset<T, ProjectsUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Projects and returns the data updated in the database.
     * @param {ProjectsUpdateManyAndReturnArgs} args - Arguments to update many Projects.
     * @example
     * // Update many Projects
     * const projects = await prisma.projects.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Projects and only return the `id`
     * const projectsWithIdOnly = await prisma.projects.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends ProjectsUpdateManyAndReturnArgs>(args: SelectSubset<T, ProjectsUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ProjectsPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one Projects.
     * @param {ProjectsUpsertArgs} args - Arguments to update or create a Projects.
     * @example
     * // Update or create a Projects
     * const projects = await prisma.projects.upsert({
     *   create: {
     *     // ... data to create a Projects
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Projects we want to update
     *   }
     * })
     */
    upsert<T extends ProjectsUpsertArgs>(args: SelectSubset<T, ProjectsUpsertArgs<ExtArgs>>): Prisma__ProjectsClient<$Result.GetResult<Prisma.$ProjectsPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of Projects.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectsCountArgs} args - Arguments to filter Projects to count.
     * @example
     * // Count the number of Projects
     * const count = await prisma.projects.count({
     *   where: {
     *     // ... the filter for the Projects we want to count
     *   }
     * })
    **/
    count<T extends ProjectsCountArgs>(
      args?: Subset<T, ProjectsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ProjectsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Projects.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ProjectsAggregateArgs>(args: Subset<T, ProjectsAggregateArgs>): Prisma.PrismaPromise<GetProjectsAggregateType<T>>

    /**
     * Group by Projects.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ProjectsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ProjectsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ProjectsGroupByArgs['orderBy'] }
        : { orderBy?: ProjectsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ProjectsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetProjectsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Projects model
   */
  readonly fields: ProjectsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Projects.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ProjectsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    Backlink<T extends Projects$BacklinkArgs<ExtArgs> = {}>(args?: Subset<T, Projects$BacklinkArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Projects model
   */ 
  interface ProjectsFieldRefs {
    readonly id: FieldRef<"Projects", 'Int'>
    readonly domain_name: FieldRef<"Projects", 'String'>
    readonly domain_url: FieldRef<"Projects", 'String'>
    readonly category_id: FieldRef<"Projects", 'Int'>
    readonly created_by_id: FieldRef<"Projects", 'Int'>
    readonly created_at: FieldRef<"Projects", 'DateTime'>
    readonly updated_at: FieldRef<"Projects", 'DateTime'>
    readonly deleted_at: FieldRef<"Projects", 'DateTime'>
    readonly time_around: FieldRef<"Projects", 'DateTime'>
    readonly time_around_days: FieldRef<"Projects", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * Projects findUnique
   */
  export type ProjectsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Projects
     */
    select?: ProjectsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Projects
     */
    omit?: ProjectsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectsInclude<ExtArgs> | null
    /**
     * Filter, which Projects to fetch.
     */
    where: ProjectsWhereUniqueInput
  }

  /**
   * Projects findUniqueOrThrow
   */
  export type ProjectsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Projects
     */
    select?: ProjectsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Projects
     */
    omit?: ProjectsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectsInclude<ExtArgs> | null
    /**
     * Filter, which Projects to fetch.
     */
    where: ProjectsWhereUniqueInput
  }

  /**
   * Projects findFirst
   */
  export type ProjectsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Projects
     */
    select?: ProjectsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Projects
     */
    omit?: ProjectsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectsInclude<ExtArgs> | null
    /**
     * Filter, which Projects to fetch.
     */
    where?: ProjectsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Projects to fetch.
     */
    orderBy?: ProjectsOrderByWithRelationInput | ProjectsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Projects.
     */
    cursor?: ProjectsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Projects from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Projects.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Projects.
     */
    distinct?: ProjectsScalarFieldEnum | ProjectsScalarFieldEnum[]
  }

  /**
   * Projects findFirstOrThrow
   */
  export type ProjectsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Projects
     */
    select?: ProjectsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Projects
     */
    omit?: ProjectsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectsInclude<ExtArgs> | null
    /**
     * Filter, which Projects to fetch.
     */
    where?: ProjectsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Projects to fetch.
     */
    orderBy?: ProjectsOrderByWithRelationInput | ProjectsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Projects.
     */
    cursor?: ProjectsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Projects from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Projects.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Projects.
     */
    distinct?: ProjectsScalarFieldEnum | ProjectsScalarFieldEnum[]
  }

  /**
   * Projects findMany
   */
  export type ProjectsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Projects
     */
    select?: ProjectsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Projects
     */
    omit?: ProjectsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectsInclude<ExtArgs> | null
    /**
     * Filter, which Projects to fetch.
     */
    where?: ProjectsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Projects to fetch.
     */
    orderBy?: ProjectsOrderByWithRelationInput | ProjectsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Projects.
     */
    cursor?: ProjectsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Projects from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Projects.
     */
    skip?: number
    distinct?: ProjectsScalarFieldEnum | ProjectsScalarFieldEnum[]
  }

  /**
   * Projects create
   */
  export type ProjectsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Projects
     */
    select?: ProjectsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Projects
     */
    omit?: ProjectsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectsInclude<ExtArgs> | null
    /**
     * The data needed to create a Projects.
     */
    data: XOR<ProjectsCreateInput, ProjectsUncheckedCreateInput>
  }

  /**
   * Projects createMany
   */
  export type ProjectsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Projects.
     */
    data: ProjectsCreateManyInput | ProjectsCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Projects createManyAndReturn
   */
  export type ProjectsCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Projects
     */
    select?: ProjectsSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Projects
     */
    omit?: ProjectsOmit<ExtArgs> | null
    /**
     * The data used to create many Projects.
     */
    data: ProjectsCreateManyInput | ProjectsCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Projects update
   */
  export type ProjectsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Projects
     */
    select?: ProjectsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Projects
     */
    omit?: ProjectsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectsInclude<ExtArgs> | null
    /**
     * The data needed to update a Projects.
     */
    data: XOR<ProjectsUpdateInput, ProjectsUncheckedUpdateInput>
    /**
     * Choose, which Projects to update.
     */
    where: ProjectsWhereUniqueInput
  }

  /**
   * Projects updateMany
   */
  export type ProjectsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Projects.
     */
    data: XOR<ProjectsUpdateManyMutationInput, ProjectsUncheckedUpdateManyInput>
    /**
     * Filter which Projects to update
     */
    where?: ProjectsWhereInput
    /**
     * Limit how many Projects to update.
     */
    limit?: number
  }

  /**
   * Projects updateManyAndReturn
   */
  export type ProjectsUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Projects
     */
    select?: ProjectsSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Projects
     */
    omit?: ProjectsOmit<ExtArgs> | null
    /**
     * The data used to update Projects.
     */
    data: XOR<ProjectsUpdateManyMutationInput, ProjectsUncheckedUpdateManyInput>
    /**
     * Filter which Projects to update
     */
    where?: ProjectsWhereInput
    /**
     * Limit how many Projects to update.
     */
    limit?: number
  }

  /**
   * Projects upsert
   */
  export type ProjectsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Projects
     */
    select?: ProjectsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Projects
     */
    omit?: ProjectsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectsInclude<ExtArgs> | null
    /**
     * The filter to search for the Projects to update in case it exists.
     */
    where: ProjectsWhereUniqueInput
    /**
     * In case the Projects found by the `where` argument doesn't exist, create a new Projects with this data.
     */
    create: XOR<ProjectsCreateInput, ProjectsUncheckedCreateInput>
    /**
     * In case the Projects was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ProjectsUpdateInput, ProjectsUncheckedUpdateInput>
  }

  /**
   * Projects delete
   */
  export type ProjectsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Projects
     */
    select?: ProjectsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Projects
     */
    omit?: ProjectsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectsInclude<ExtArgs> | null
    /**
     * Filter which Projects to delete.
     */
    where: ProjectsWhereUniqueInput
  }

  /**
   * Projects deleteMany
   */
  export type ProjectsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Projects to delete
     */
    where?: ProjectsWhereInput
    /**
     * Limit how many Projects to delete.
     */
    limit?: number
  }

  /**
   * Projects.Backlink
   */
  export type Projects$BacklinkArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    where?: BacklinkWhereInput
    orderBy?: BacklinkOrderByWithRelationInput | BacklinkOrderByWithRelationInput[]
    cursor?: BacklinkWhereUniqueInput
    take?: number
    skip?: number
    distinct?: BacklinkScalarFieldEnum | BacklinkScalarFieldEnum[]
  }

  /**
   * Projects without action
   */
  export type ProjectsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Projects
     */
    select?: ProjectsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Projects
     */
    omit?: ProjectsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ProjectsInclude<ExtArgs> | null
  }


  /**
   * Model Backlink
   */

  export type AggregateBacklink = {
    _count: BacklinkCountAggregateOutputType | null
    _avg: BacklinkAvgAggregateOutputType | null
    _sum: BacklinkSumAggregateOutputType | null
    _min: BacklinkMinAggregateOutputType | null
    _max: BacklinkMaxAggregateOutputType | null
  }

  export type BacklinkAvgAggregateOutputType = {
    id: number | null
    link_status: number | null
    project_id: number | null
    uploaded_by_id: number | null
    managed_by: number | null
  }

  export type BacklinkSumAggregateOutputType = {
    id: number | null
    link_status: number | null
    project_id: number | null
    uploaded_by_id: number | null
    managed_by: number | null
  }

  export type BacklinkMinAggregateOutputType = {
    id: number | null
    link_url: string | null
    link_status: number | null
    is_index: boolean | null
    link_rel: string | null
    anchor_text: string | null
    targeted_url: string | null
    project_id: number | null
    uploaded_by_id: number | null
    first_seen: Date | null
    last_seen: Date | null
    added_date: Date | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    backlink_duplicate: boolean | null
    referring_domain: boolean | null
    managed_by: number | null
  }

  export type BacklinkMaxAggregateOutputType = {
    id: number | null
    link_url: string | null
    link_status: number | null
    is_index: boolean | null
    link_rel: string | null
    anchor_text: string | null
    targeted_url: string | null
    project_id: number | null
    uploaded_by_id: number | null
    first_seen: Date | null
    last_seen: Date | null
    added_date: Date | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    backlink_duplicate: boolean | null
    referring_domain: boolean | null
    managed_by: number | null
  }

  export type BacklinkCountAggregateOutputType = {
    id: number
    link_url: number
    link_status: number
    is_index: number
    link_rel: number
    anchor_text: number
    targeted_url: number
    project_id: number
    uploaded_by_id: number
    first_seen: number
    last_seen: number
    added_date: number
    created_at: number
    updated_at: number
    deleted_at: number
    backlink_duplicate: number
    referring_domain: number
    managed_by: number
    _all: number
  }


  export type BacklinkAvgAggregateInputType = {
    id?: true
    link_status?: true
    project_id?: true
    uploaded_by_id?: true
    managed_by?: true
  }

  export type BacklinkSumAggregateInputType = {
    id?: true
    link_status?: true
    project_id?: true
    uploaded_by_id?: true
    managed_by?: true
  }

  export type BacklinkMinAggregateInputType = {
    id?: true
    link_url?: true
    link_status?: true
    is_index?: true
    link_rel?: true
    anchor_text?: true
    targeted_url?: true
    project_id?: true
    uploaded_by_id?: true
    first_seen?: true
    last_seen?: true
    added_date?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    backlink_duplicate?: true
    referring_domain?: true
    managed_by?: true
  }

  export type BacklinkMaxAggregateInputType = {
    id?: true
    link_url?: true
    link_status?: true
    is_index?: true
    link_rel?: true
    anchor_text?: true
    targeted_url?: true
    project_id?: true
    uploaded_by_id?: true
    first_seen?: true
    last_seen?: true
    added_date?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    backlink_duplicate?: true
    referring_domain?: true
    managed_by?: true
  }

  export type BacklinkCountAggregateInputType = {
    id?: true
    link_url?: true
    link_status?: true
    is_index?: true
    link_rel?: true
    anchor_text?: true
    targeted_url?: true
    project_id?: true
    uploaded_by_id?: true
    first_seen?: true
    last_seen?: true
    added_date?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    backlink_duplicate?: true
    referring_domain?: true
    managed_by?: true
    _all?: true
  }

  export type BacklinkAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Backlink to aggregate.
     */
    where?: BacklinkWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Backlinks to fetch.
     */
    orderBy?: BacklinkOrderByWithRelationInput | BacklinkOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: BacklinkWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Backlinks from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Backlinks.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Backlinks
    **/
    _count?: true | BacklinkCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: BacklinkAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: BacklinkSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: BacklinkMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: BacklinkMaxAggregateInputType
  }

  export type GetBacklinkAggregateType<T extends BacklinkAggregateArgs> = {
        [P in keyof T & keyof AggregateBacklink]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateBacklink[P]>
      : GetScalarType<T[P], AggregateBacklink[P]>
  }




  export type BacklinkGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: BacklinkWhereInput
    orderBy?: BacklinkOrderByWithAggregationInput | BacklinkOrderByWithAggregationInput[]
    by: BacklinkScalarFieldEnum[] | BacklinkScalarFieldEnum
    having?: BacklinkScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: BacklinkCountAggregateInputType | true
    _avg?: BacklinkAvgAggregateInputType
    _sum?: BacklinkSumAggregateInputType
    _min?: BacklinkMinAggregateInputType
    _max?: BacklinkMaxAggregateInputType
  }

  export type BacklinkGroupByOutputType = {
    id: number
    link_url: string
    link_status: number
    is_index: boolean | null
    link_rel: string | null
    anchor_text: string | null
    targeted_url: string | null
    project_id: number
    uploaded_by_id: number | null
    first_seen: Date | null
    last_seen: Date | null
    added_date: Date | null
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    backlink_duplicate: boolean | null
    referring_domain: boolean | null
    managed_by: number | null
    _count: BacklinkCountAggregateOutputType | null
    _avg: BacklinkAvgAggregateOutputType | null
    _sum: BacklinkSumAggregateOutputType | null
    _min: BacklinkMinAggregateOutputType | null
    _max: BacklinkMaxAggregateOutputType | null
  }

  type GetBacklinkGroupByPayload<T extends BacklinkGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<BacklinkGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof BacklinkGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], BacklinkGroupByOutputType[P]>
            : GetScalarType<T[P], BacklinkGroupByOutputType[P]>
        }
      >
    >


  export type BacklinkSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    link_url?: boolean
    link_status?: boolean
    is_index?: boolean
    link_rel?: boolean
    anchor_text?: boolean
    targeted_url?: boolean
    project_id?: boolean
    uploaded_by_id?: boolean
    first_seen?: boolean
    last_seen?: boolean
    added_date?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    backlink_duplicate?: boolean
    referring_domain?: boolean
    managed_by?: boolean
    ProjectLinks?: boolean | ProjectsDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["backlink"]>

  export type BacklinkSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    link_url?: boolean
    link_status?: boolean
    is_index?: boolean
    link_rel?: boolean
    anchor_text?: boolean
    targeted_url?: boolean
    project_id?: boolean
    uploaded_by_id?: boolean
    first_seen?: boolean
    last_seen?: boolean
    added_date?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    backlink_duplicate?: boolean
    referring_domain?: boolean
    managed_by?: boolean
    ProjectLinks?: boolean | ProjectsDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["backlink"]>

  export type BacklinkSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    link_url?: boolean
    link_status?: boolean
    is_index?: boolean
    link_rel?: boolean
    anchor_text?: boolean
    targeted_url?: boolean
    project_id?: boolean
    uploaded_by_id?: boolean
    first_seen?: boolean
    last_seen?: boolean
    added_date?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    backlink_duplicate?: boolean
    referring_domain?: boolean
    managed_by?: boolean
    ProjectLinks?: boolean | ProjectsDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["backlink"]>

  export type BacklinkSelectScalar = {
    id?: boolean
    link_url?: boolean
    link_status?: boolean
    is_index?: boolean
    link_rel?: boolean
    anchor_text?: boolean
    targeted_url?: boolean
    project_id?: boolean
    uploaded_by_id?: boolean
    first_seen?: boolean
    last_seen?: boolean
    added_date?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    backlink_duplicate?: boolean
    referring_domain?: boolean
    managed_by?: boolean
  }

  export type BacklinkOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "link_url" | "link_status" | "is_index" | "link_rel" | "anchor_text" | "targeted_url" | "project_id" | "uploaded_by_id" | "first_seen" | "last_seen" | "added_date" | "created_at" | "updated_at" | "deleted_at" | "backlink_duplicate" | "referring_domain" | "managed_by", ExtArgs["result"]["backlink"]>
  export type BacklinkInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    ProjectLinks?: boolean | ProjectsDefaultArgs<ExtArgs>
  }
  export type BacklinkIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    ProjectLinks?: boolean | ProjectsDefaultArgs<ExtArgs>
  }
  export type BacklinkIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    ProjectLinks?: boolean | ProjectsDefaultArgs<ExtArgs>
  }

  export type $BacklinkPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Backlink"
    objects: {
      ProjectLinks: Prisma.$ProjectsPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      link_url: string
      link_status: number
      is_index: boolean | null
      link_rel: string | null
      anchor_text: string | null
      targeted_url: string | null
      project_id: number
      uploaded_by_id: number | null
      first_seen: Date | null
      last_seen: Date | null
      added_date: Date | null
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
      backlink_duplicate: boolean | null
      referring_domain: boolean | null
      managed_by: number | null
    }, ExtArgs["result"]["backlink"]>
    composites: {}
  }

  type BacklinkGetPayload<S extends boolean | null | undefined | BacklinkDefaultArgs> = $Result.GetResult<Prisma.$BacklinkPayload, S>

  type BacklinkCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<BacklinkFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: BacklinkCountAggregateInputType | true
    }

  export interface BacklinkDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Backlink'], meta: { name: 'Backlink' } }
    /**
     * Find zero or one Backlink that matches the filter.
     * @param {BacklinkFindUniqueArgs} args - Arguments to find a Backlink
     * @example
     * // Get one Backlink
     * const backlink = await prisma.backlink.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends BacklinkFindUniqueArgs>(args: SelectSubset<T, BacklinkFindUniqueArgs<ExtArgs>>): Prisma__BacklinkClient<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Backlink that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {BacklinkFindUniqueOrThrowArgs} args - Arguments to find a Backlink
     * @example
     * // Get one Backlink
     * const backlink = await prisma.backlink.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends BacklinkFindUniqueOrThrowArgs>(args: SelectSubset<T, BacklinkFindUniqueOrThrowArgs<ExtArgs>>): Prisma__BacklinkClient<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Backlink that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {BacklinkFindFirstArgs} args - Arguments to find a Backlink
     * @example
     * // Get one Backlink
     * const backlink = await prisma.backlink.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends BacklinkFindFirstArgs>(args?: SelectSubset<T, BacklinkFindFirstArgs<ExtArgs>>): Prisma__BacklinkClient<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Backlink that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {BacklinkFindFirstOrThrowArgs} args - Arguments to find a Backlink
     * @example
     * // Get one Backlink
     * const backlink = await prisma.backlink.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends BacklinkFindFirstOrThrowArgs>(args?: SelectSubset<T, BacklinkFindFirstOrThrowArgs<ExtArgs>>): Prisma__BacklinkClient<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Backlinks that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {BacklinkFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Backlinks
     * const backlinks = await prisma.backlink.findMany()
     * 
     * // Get first 10 Backlinks
     * const backlinks = await prisma.backlink.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const backlinkWithIdOnly = await prisma.backlink.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends BacklinkFindManyArgs>(args?: SelectSubset<T, BacklinkFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Backlink.
     * @param {BacklinkCreateArgs} args - Arguments to create a Backlink.
     * @example
     * // Create one Backlink
     * const Backlink = await prisma.backlink.create({
     *   data: {
     *     // ... data to create a Backlink
     *   }
     * })
     * 
     */
    create<T extends BacklinkCreateArgs>(args: SelectSubset<T, BacklinkCreateArgs<ExtArgs>>): Prisma__BacklinkClient<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Backlinks.
     * @param {BacklinkCreateManyArgs} args - Arguments to create many Backlinks.
     * @example
     * // Create many Backlinks
     * const backlink = await prisma.backlink.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends BacklinkCreateManyArgs>(args?: SelectSubset<T, BacklinkCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Backlinks and returns the data saved in the database.
     * @param {BacklinkCreateManyAndReturnArgs} args - Arguments to create many Backlinks.
     * @example
     * // Create many Backlinks
     * const backlink = await prisma.backlink.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Backlinks and only return the `id`
     * const backlinkWithIdOnly = await prisma.backlink.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends BacklinkCreateManyAndReturnArgs>(args?: SelectSubset<T, BacklinkCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a Backlink.
     * @param {BacklinkDeleteArgs} args - Arguments to delete one Backlink.
     * @example
     * // Delete one Backlink
     * const Backlink = await prisma.backlink.delete({
     *   where: {
     *     // ... filter to delete one Backlink
     *   }
     * })
     * 
     */
    delete<T extends BacklinkDeleteArgs>(args: SelectSubset<T, BacklinkDeleteArgs<ExtArgs>>): Prisma__BacklinkClient<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Backlink.
     * @param {BacklinkUpdateArgs} args - Arguments to update one Backlink.
     * @example
     * // Update one Backlink
     * const backlink = await prisma.backlink.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends BacklinkUpdateArgs>(args: SelectSubset<T, BacklinkUpdateArgs<ExtArgs>>): Prisma__BacklinkClient<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Backlinks.
     * @param {BacklinkDeleteManyArgs} args - Arguments to filter Backlinks to delete.
     * @example
     * // Delete a few Backlinks
     * const { count } = await prisma.backlink.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends BacklinkDeleteManyArgs>(args?: SelectSubset<T, BacklinkDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Backlinks.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {BacklinkUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Backlinks
     * const backlink = await prisma.backlink.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends BacklinkUpdateManyArgs>(args: SelectSubset<T, BacklinkUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Backlinks and returns the data updated in the database.
     * @param {BacklinkUpdateManyAndReturnArgs} args - Arguments to update many Backlinks.
     * @example
     * // Update many Backlinks
     * const backlink = await prisma.backlink.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Backlinks and only return the `id`
     * const backlinkWithIdOnly = await prisma.backlink.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends BacklinkUpdateManyAndReturnArgs>(args: SelectSubset<T, BacklinkUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one Backlink.
     * @param {BacklinkUpsertArgs} args - Arguments to update or create a Backlink.
     * @example
     * // Update or create a Backlink
     * const backlink = await prisma.backlink.upsert({
     *   create: {
     *     // ... data to create a Backlink
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Backlink we want to update
     *   }
     * })
     */
    upsert<T extends BacklinkUpsertArgs>(args: SelectSubset<T, BacklinkUpsertArgs<ExtArgs>>): Prisma__BacklinkClient<$Result.GetResult<Prisma.$BacklinkPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of Backlinks.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {BacklinkCountArgs} args - Arguments to filter Backlinks to count.
     * @example
     * // Count the number of Backlinks
     * const count = await prisma.backlink.count({
     *   where: {
     *     // ... the filter for the Backlinks we want to count
     *   }
     * })
    **/
    count<T extends BacklinkCountArgs>(
      args?: Subset<T, BacklinkCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], BacklinkCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Backlink.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {BacklinkAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends BacklinkAggregateArgs>(args: Subset<T, BacklinkAggregateArgs>): Prisma.PrismaPromise<GetBacklinkAggregateType<T>>

    /**
     * Group by Backlink.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {BacklinkGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends BacklinkGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: BacklinkGroupByArgs['orderBy'] }
        : { orderBy?: BacklinkGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, BacklinkGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetBacklinkGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Backlink model
   */
  readonly fields: BacklinkFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Backlink.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__BacklinkClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    ProjectLinks<T extends ProjectsDefaultArgs<ExtArgs> = {}>(args?: Subset<T, ProjectsDefaultArgs<ExtArgs>>): Prisma__ProjectsClient<$Result.GetResult<Prisma.$ProjectsPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the Backlink model
   */ 
  interface BacklinkFieldRefs {
    readonly id: FieldRef<"Backlink", 'Int'>
    readonly link_url: FieldRef<"Backlink", 'String'>
    readonly link_status: FieldRef<"Backlink", 'Int'>
    readonly is_index: FieldRef<"Backlink", 'Boolean'>
    readonly link_rel: FieldRef<"Backlink", 'String'>
    readonly anchor_text: FieldRef<"Backlink", 'String'>
    readonly targeted_url: FieldRef<"Backlink", 'String'>
    readonly project_id: FieldRef<"Backlink", 'Int'>
    readonly uploaded_by_id: FieldRef<"Backlink", 'Int'>
    readonly first_seen: FieldRef<"Backlink", 'DateTime'>
    readonly last_seen: FieldRef<"Backlink", 'DateTime'>
    readonly added_date: FieldRef<"Backlink", 'DateTime'>
    readonly created_at: FieldRef<"Backlink", 'DateTime'>
    readonly updated_at: FieldRef<"Backlink", 'DateTime'>
    readonly deleted_at: FieldRef<"Backlink", 'DateTime'>
    readonly backlink_duplicate: FieldRef<"Backlink", 'Boolean'>
    readonly referring_domain: FieldRef<"Backlink", 'Boolean'>
    readonly managed_by: FieldRef<"Backlink", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * Backlink findUnique
   */
  export type BacklinkFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    /**
     * Filter, which Backlink to fetch.
     */
    where: BacklinkWhereUniqueInput
  }

  /**
   * Backlink findUniqueOrThrow
   */
  export type BacklinkFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    /**
     * Filter, which Backlink to fetch.
     */
    where: BacklinkWhereUniqueInput
  }

  /**
   * Backlink findFirst
   */
  export type BacklinkFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    /**
     * Filter, which Backlink to fetch.
     */
    where?: BacklinkWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Backlinks to fetch.
     */
    orderBy?: BacklinkOrderByWithRelationInput | BacklinkOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Backlinks.
     */
    cursor?: BacklinkWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Backlinks from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Backlinks.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Backlinks.
     */
    distinct?: BacklinkScalarFieldEnum | BacklinkScalarFieldEnum[]
  }

  /**
   * Backlink findFirstOrThrow
   */
  export type BacklinkFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    /**
     * Filter, which Backlink to fetch.
     */
    where?: BacklinkWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Backlinks to fetch.
     */
    orderBy?: BacklinkOrderByWithRelationInput | BacklinkOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Backlinks.
     */
    cursor?: BacklinkWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Backlinks from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Backlinks.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Backlinks.
     */
    distinct?: BacklinkScalarFieldEnum | BacklinkScalarFieldEnum[]
  }

  /**
   * Backlink findMany
   */
  export type BacklinkFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    /**
     * Filter, which Backlinks to fetch.
     */
    where?: BacklinkWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Backlinks to fetch.
     */
    orderBy?: BacklinkOrderByWithRelationInput | BacklinkOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Backlinks.
     */
    cursor?: BacklinkWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Backlinks from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Backlinks.
     */
    skip?: number
    distinct?: BacklinkScalarFieldEnum | BacklinkScalarFieldEnum[]
  }

  /**
   * Backlink create
   */
  export type BacklinkCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    /**
     * The data needed to create a Backlink.
     */
    data: XOR<BacklinkCreateInput, BacklinkUncheckedCreateInput>
  }

  /**
   * Backlink createMany
   */
  export type BacklinkCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Backlinks.
     */
    data: BacklinkCreateManyInput | BacklinkCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * Backlink createManyAndReturn
   */
  export type BacklinkCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * The data used to create many Backlinks.
     */
    data: BacklinkCreateManyInput | BacklinkCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * Backlink update
   */
  export type BacklinkUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    /**
     * The data needed to update a Backlink.
     */
    data: XOR<BacklinkUpdateInput, BacklinkUncheckedUpdateInput>
    /**
     * Choose, which Backlink to update.
     */
    where: BacklinkWhereUniqueInput
  }

  /**
   * Backlink updateMany
   */
  export type BacklinkUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Backlinks.
     */
    data: XOR<BacklinkUpdateManyMutationInput, BacklinkUncheckedUpdateManyInput>
    /**
     * Filter which Backlinks to update
     */
    where?: BacklinkWhereInput
    /**
     * Limit how many Backlinks to update.
     */
    limit?: number
  }

  /**
   * Backlink updateManyAndReturn
   */
  export type BacklinkUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * The data used to update Backlinks.
     */
    data: XOR<BacklinkUpdateManyMutationInput, BacklinkUncheckedUpdateManyInput>
    /**
     * Filter which Backlinks to update
     */
    where?: BacklinkWhereInput
    /**
     * Limit how many Backlinks to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * Backlink upsert
   */
  export type BacklinkUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    /**
     * The filter to search for the Backlink to update in case it exists.
     */
    where: BacklinkWhereUniqueInput
    /**
     * In case the Backlink found by the `where` argument doesn't exist, create a new Backlink with this data.
     */
    create: XOR<BacklinkCreateInput, BacklinkUncheckedCreateInput>
    /**
     * In case the Backlink was found with the provided `where` argument, update it with this data.
     */
    update: XOR<BacklinkUpdateInput, BacklinkUncheckedUpdateInput>
  }

  /**
   * Backlink delete
   */
  export type BacklinkDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
    /**
     * Filter which Backlink to delete.
     */
    where: BacklinkWhereUniqueInput
  }

  /**
   * Backlink deleteMany
   */
  export type BacklinkDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Backlinks to delete
     */
    where?: BacklinkWhereInput
    /**
     * Limit how many Backlinks to delete.
     */
    limit?: number
  }

  /**
   * Backlink without action
   */
  export type BacklinkDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Backlink
     */
    select?: BacklinkSelect<ExtArgs> | null
    /**
     * Omit specific fields from the Backlink
     */
    omit?: BacklinkOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: BacklinkInclude<ExtArgs> | null
  }


  /**
   * Model permissions_list
   */

  export type AggregatePermissions_list = {
    _count: Permissions_listCountAggregateOutputType | null
    _avg: Permissions_listAvgAggregateOutputType | null
    _sum: Permissions_listSumAggregateOutputType | null
    _min: Permissions_listMinAggregateOutputType | null
    _max: Permissions_listMaxAggregateOutputType | null
  }

  export type Permissions_listAvgAggregateOutputType = {
    id: number | null
    created_by: number | null
  }

  export type Permissions_listSumAggregateOutputType = {
    id: number | null
    created_by: number | null
  }

  export type Permissions_listMinAggregateOutputType = {
    id: number | null
    title: string | null
    type: string | null
    created_by: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type Permissions_listMaxAggregateOutputType = {
    id: number | null
    title: string | null
    type: string | null
    created_by: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type Permissions_listCountAggregateOutputType = {
    id: number
    title: number
    type: number
    created_by: number
    created_at: number
    updated_at: number
    deleted_at: number
    _all: number
  }


  export type Permissions_listAvgAggregateInputType = {
    id?: true
    created_by?: true
  }

  export type Permissions_listSumAggregateInputType = {
    id?: true
    created_by?: true
  }

  export type Permissions_listMinAggregateInputType = {
    id?: true
    title?: true
    type?: true
    created_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type Permissions_listMaxAggregateInputType = {
    id?: true
    title?: true
    type?: true
    created_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type Permissions_listCountAggregateInputType = {
    id?: true
    title?: true
    type?: true
    created_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    _all?: true
  }

  export type Permissions_listAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which permissions_list to aggregate.
     */
    where?: permissions_listWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of permissions_lists to fetch.
     */
    orderBy?: permissions_listOrderByWithRelationInput | permissions_listOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: permissions_listWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` permissions_lists from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` permissions_lists.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned permissions_lists
    **/
    _count?: true | Permissions_listCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Permissions_listAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Permissions_listSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Permissions_listMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Permissions_listMaxAggregateInputType
  }

  export type GetPermissions_listAggregateType<T extends Permissions_listAggregateArgs> = {
        [P in keyof T & keyof AggregatePermissions_list]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregatePermissions_list[P]>
      : GetScalarType<T[P], AggregatePermissions_list[P]>
  }




  export type permissions_listGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: permissions_listWhereInput
    orderBy?: permissions_listOrderByWithAggregationInput | permissions_listOrderByWithAggregationInput[]
    by: Permissions_listScalarFieldEnum[] | Permissions_listScalarFieldEnum
    having?: permissions_listScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Permissions_listCountAggregateInputType | true
    _avg?: Permissions_listAvgAggregateInputType
    _sum?: Permissions_listSumAggregateInputType
    _min?: Permissions_listMinAggregateInputType
    _max?: Permissions_listMaxAggregateInputType
  }

  export type Permissions_listGroupByOutputType = {
    id: number
    title: string
    type: string
    created_by: number
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    _count: Permissions_listCountAggregateOutputType | null
    _avg: Permissions_listAvgAggregateOutputType | null
    _sum: Permissions_listSumAggregateOutputType | null
    _min: Permissions_listMinAggregateOutputType | null
    _max: Permissions_listMaxAggregateOutputType | null
  }

  type GetPermissions_listGroupByPayload<T extends permissions_listGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Permissions_listGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Permissions_listGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Permissions_listGroupByOutputType[P]>
            : GetScalarType<T[P], Permissions_listGroupByOutputType[P]>
        }
      >
    >


  export type permissions_listSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    title?: boolean
    type?: boolean
    created_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    user_permissions?: boolean | permissions_list$user_permissionsArgs<ExtArgs>
    subscription_feature?: boolean | permissions_list$subscription_featureArgs<ExtArgs>
    _count?: boolean | Permissions_listCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["permissions_list"]>

  export type permissions_listSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    title?: boolean
    type?: boolean
    created_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }, ExtArgs["result"]["permissions_list"]>

  export type permissions_listSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    title?: boolean
    type?: boolean
    created_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }, ExtArgs["result"]["permissions_list"]>

  export type permissions_listSelectScalar = {
    id?: boolean
    title?: boolean
    type?: boolean
    created_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }

  export type permissions_listOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "title" | "type" | "created_by" | "created_at" | "updated_at" | "deleted_at", ExtArgs["result"]["permissions_list"]>
  export type permissions_listInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user_permissions?: boolean | permissions_list$user_permissionsArgs<ExtArgs>
    subscription_feature?: boolean | permissions_list$subscription_featureArgs<ExtArgs>
    _count?: boolean | Permissions_listCountOutputTypeDefaultArgs<ExtArgs>
  }
  export type permissions_listIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {}
  export type permissions_listIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {}

  export type $permissions_listPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "permissions_list"
    objects: {
      user_permissions: Prisma.$user_permissionsPayload<ExtArgs>[]
      subscription_feature: Prisma.$subscription_featurePayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      title: string
      type: string
      created_by: number
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
    }, ExtArgs["result"]["permissions_list"]>
    composites: {}
  }

  type permissions_listGetPayload<S extends boolean | null | undefined | permissions_listDefaultArgs> = $Result.GetResult<Prisma.$permissions_listPayload, S>

  type permissions_listCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<permissions_listFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Permissions_listCountAggregateInputType | true
    }

  export interface permissions_listDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['permissions_list'], meta: { name: 'permissions_list' } }
    /**
     * Find zero or one Permissions_list that matches the filter.
     * @param {permissions_listFindUniqueArgs} args - Arguments to find a Permissions_list
     * @example
     * // Get one Permissions_list
     * const permissions_list = await prisma.permissions_list.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends permissions_listFindUniqueArgs>(args: SelectSubset<T, permissions_listFindUniqueArgs<ExtArgs>>): Prisma__permissions_listClient<$Result.GetResult<Prisma.$permissions_listPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Permissions_list that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {permissions_listFindUniqueOrThrowArgs} args - Arguments to find a Permissions_list
     * @example
     * // Get one Permissions_list
     * const permissions_list = await prisma.permissions_list.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends permissions_listFindUniqueOrThrowArgs>(args: SelectSubset<T, permissions_listFindUniqueOrThrowArgs<ExtArgs>>): Prisma__permissions_listClient<$Result.GetResult<Prisma.$permissions_listPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Permissions_list that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {permissions_listFindFirstArgs} args - Arguments to find a Permissions_list
     * @example
     * // Get one Permissions_list
     * const permissions_list = await prisma.permissions_list.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends permissions_listFindFirstArgs>(args?: SelectSubset<T, permissions_listFindFirstArgs<ExtArgs>>): Prisma__permissions_listClient<$Result.GetResult<Prisma.$permissions_listPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Permissions_list that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {permissions_listFindFirstOrThrowArgs} args - Arguments to find a Permissions_list
     * @example
     * // Get one Permissions_list
     * const permissions_list = await prisma.permissions_list.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends permissions_listFindFirstOrThrowArgs>(args?: SelectSubset<T, permissions_listFindFirstOrThrowArgs<ExtArgs>>): Prisma__permissions_listClient<$Result.GetResult<Prisma.$permissions_listPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Permissions_lists that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {permissions_listFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Permissions_lists
     * const permissions_lists = await prisma.permissions_list.findMany()
     * 
     * // Get first 10 Permissions_lists
     * const permissions_lists = await prisma.permissions_list.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const permissions_listWithIdOnly = await prisma.permissions_list.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends permissions_listFindManyArgs>(args?: SelectSubset<T, permissions_listFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$permissions_listPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Permissions_list.
     * @param {permissions_listCreateArgs} args - Arguments to create a Permissions_list.
     * @example
     * // Create one Permissions_list
     * const Permissions_list = await prisma.permissions_list.create({
     *   data: {
     *     // ... data to create a Permissions_list
     *   }
     * })
     * 
     */
    create<T extends permissions_listCreateArgs>(args: SelectSubset<T, permissions_listCreateArgs<ExtArgs>>): Prisma__permissions_listClient<$Result.GetResult<Prisma.$permissions_listPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Permissions_lists.
     * @param {permissions_listCreateManyArgs} args - Arguments to create many Permissions_lists.
     * @example
     * // Create many Permissions_lists
     * const permissions_list = await prisma.permissions_list.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends permissions_listCreateManyArgs>(args?: SelectSubset<T, permissions_listCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Permissions_lists and returns the data saved in the database.
     * @param {permissions_listCreateManyAndReturnArgs} args - Arguments to create many Permissions_lists.
     * @example
     * // Create many Permissions_lists
     * const permissions_list = await prisma.permissions_list.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Permissions_lists and only return the `id`
     * const permissions_listWithIdOnly = await prisma.permissions_list.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends permissions_listCreateManyAndReturnArgs>(args?: SelectSubset<T, permissions_listCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$permissions_listPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a Permissions_list.
     * @param {permissions_listDeleteArgs} args - Arguments to delete one Permissions_list.
     * @example
     * // Delete one Permissions_list
     * const Permissions_list = await prisma.permissions_list.delete({
     *   where: {
     *     // ... filter to delete one Permissions_list
     *   }
     * })
     * 
     */
    delete<T extends permissions_listDeleteArgs>(args: SelectSubset<T, permissions_listDeleteArgs<ExtArgs>>): Prisma__permissions_listClient<$Result.GetResult<Prisma.$permissions_listPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Permissions_list.
     * @param {permissions_listUpdateArgs} args - Arguments to update one Permissions_list.
     * @example
     * // Update one Permissions_list
     * const permissions_list = await prisma.permissions_list.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends permissions_listUpdateArgs>(args: SelectSubset<T, permissions_listUpdateArgs<ExtArgs>>): Prisma__permissions_listClient<$Result.GetResult<Prisma.$permissions_listPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Permissions_lists.
     * @param {permissions_listDeleteManyArgs} args - Arguments to filter Permissions_lists to delete.
     * @example
     * // Delete a few Permissions_lists
     * const { count } = await prisma.permissions_list.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends permissions_listDeleteManyArgs>(args?: SelectSubset<T, permissions_listDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Permissions_lists.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {permissions_listUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Permissions_lists
     * const permissions_list = await prisma.permissions_list.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends permissions_listUpdateManyArgs>(args: SelectSubset<T, permissions_listUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Permissions_lists and returns the data updated in the database.
     * @param {permissions_listUpdateManyAndReturnArgs} args - Arguments to update many Permissions_lists.
     * @example
     * // Update many Permissions_lists
     * const permissions_list = await prisma.permissions_list.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Permissions_lists and only return the `id`
     * const permissions_listWithIdOnly = await prisma.permissions_list.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends permissions_listUpdateManyAndReturnArgs>(args: SelectSubset<T, permissions_listUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$permissions_listPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one Permissions_list.
     * @param {permissions_listUpsertArgs} args - Arguments to update or create a Permissions_list.
     * @example
     * // Update or create a Permissions_list
     * const permissions_list = await prisma.permissions_list.upsert({
     *   create: {
     *     // ... data to create a Permissions_list
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Permissions_list we want to update
     *   }
     * })
     */
    upsert<T extends permissions_listUpsertArgs>(args: SelectSubset<T, permissions_listUpsertArgs<ExtArgs>>): Prisma__permissions_listClient<$Result.GetResult<Prisma.$permissions_listPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of Permissions_lists.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {permissions_listCountArgs} args - Arguments to filter Permissions_lists to count.
     * @example
     * // Count the number of Permissions_lists
     * const count = await prisma.permissions_list.count({
     *   where: {
     *     // ... the filter for the Permissions_lists we want to count
     *   }
     * })
    **/
    count<T extends permissions_listCountArgs>(
      args?: Subset<T, permissions_listCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Permissions_listCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Permissions_list.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Permissions_listAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Permissions_listAggregateArgs>(args: Subset<T, Permissions_listAggregateArgs>): Prisma.PrismaPromise<GetPermissions_listAggregateType<T>>

    /**
     * Group by Permissions_list.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {permissions_listGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends permissions_listGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: permissions_listGroupByArgs['orderBy'] }
        : { orderBy?: permissions_listGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, permissions_listGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetPermissions_listGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the permissions_list model
   */
  readonly fields: permissions_listFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for permissions_list.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__permissions_listClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    user_permissions<T extends permissions_list$user_permissionsArgs<ExtArgs> = {}>(args?: Subset<T, permissions_list$user_permissionsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$user_permissionsPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    subscription_feature<T extends permissions_list$subscription_featureArgs<ExtArgs> = {}>(args?: Subset<T, permissions_list$subscription_featureArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$subscription_featurePayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the permissions_list model
   */ 
  interface permissions_listFieldRefs {
    readonly id: FieldRef<"permissions_list", 'Int'>
    readonly title: FieldRef<"permissions_list", 'String'>
    readonly type: FieldRef<"permissions_list", 'String'>
    readonly created_by: FieldRef<"permissions_list", 'Int'>
    readonly created_at: FieldRef<"permissions_list", 'DateTime'>
    readonly updated_at: FieldRef<"permissions_list", 'DateTime'>
    readonly deleted_at: FieldRef<"permissions_list", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * permissions_list findUnique
   */
  export type permissions_listFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the permissions_list
     */
    select?: permissions_listSelect<ExtArgs> | null
    /**
     * Omit specific fields from the permissions_list
     */
    omit?: permissions_listOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: permissions_listInclude<ExtArgs> | null
    /**
     * Filter, which permissions_list to fetch.
     */
    where: permissions_listWhereUniqueInput
  }

  /**
   * permissions_list findUniqueOrThrow
   */
  export type permissions_listFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the permissions_list
     */
    select?: permissions_listSelect<ExtArgs> | null
    /**
     * Omit specific fields from the permissions_list
     */
    omit?: permissions_listOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: permissions_listInclude<ExtArgs> | null
    /**
     * Filter, which permissions_list to fetch.
     */
    where: permissions_listWhereUniqueInput
  }

  /**
   * permissions_list findFirst
   */
  export type permissions_listFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the permissions_list
     */
    select?: permissions_listSelect<ExtArgs> | null
    /**
     * Omit specific fields from the permissions_list
     */
    omit?: permissions_listOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: permissions_listInclude<ExtArgs> | null
    /**
     * Filter, which permissions_list to fetch.
     */
    where?: permissions_listWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of permissions_lists to fetch.
     */
    orderBy?: permissions_listOrderByWithRelationInput | permissions_listOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for permissions_lists.
     */
    cursor?: permissions_listWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` permissions_lists from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` permissions_lists.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of permissions_lists.
     */
    distinct?: Permissions_listScalarFieldEnum | Permissions_listScalarFieldEnum[]
  }

  /**
   * permissions_list findFirstOrThrow
   */
  export type permissions_listFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the permissions_list
     */
    select?: permissions_listSelect<ExtArgs> | null
    /**
     * Omit specific fields from the permissions_list
     */
    omit?: permissions_listOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: permissions_listInclude<ExtArgs> | null
    /**
     * Filter, which permissions_list to fetch.
     */
    where?: permissions_listWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of permissions_lists to fetch.
     */
    orderBy?: permissions_listOrderByWithRelationInput | permissions_listOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for permissions_lists.
     */
    cursor?: permissions_listWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` permissions_lists from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` permissions_lists.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of permissions_lists.
     */
    distinct?: Permissions_listScalarFieldEnum | Permissions_listScalarFieldEnum[]
  }

  /**
   * permissions_list findMany
   */
  export type permissions_listFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the permissions_list
     */
    select?: permissions_listSelect<ExtArgs> | null
    /**
     * Omit specific fields from the permissions_list
     */
    omit?: permissions_listOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: permissions_listInclude<ExtArgs> | null
    /**
     * Filter, which permissions_lists to fetch.
     */
    where?: permissions_listWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of permissions_lists to fetch.
     */
    orderBy?: permissions_listOrderByWithRelationInput | permissions_listOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing permissions_lists.
     */
    cursor?: permissions_listWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` permissions_lists from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` permissions_lists.
     */
    skip?: number
    distinct?: Permissions_listScalarFieldEnum | Permissions_listScalarFieldEnum[]
  }

  /**
   * permissions_list create
   */
  export type permissions_listCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the permissions_list
     */
    select?: permissions_listSelect<ExtArgs> | null
    /**
     * Omit specific fields from the permissions_list
     */
    omit?: permissions_listOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: permissions_listInclude<ExtArgs> | null
    /**
     * The data needed to create a permissions_list.
     */
    data: XOR<permissions_listCreateInput, permissions_listUncheckedCreateInput>
  }

  /**
   * permissions_list createMany
   */
  export type permissions_listCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many permissions_lists.
     */
    data: permissions_listCreateManyInput | permissions_listCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * permissions_list createManyAndReturn
   */
  export type permissions_listCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the permissions_list
     */
    select?: permissions_listSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the permissions_list
     */
    omit?: permissions_listOmit<ExtArgs> | null
    /**
     * The data used to create many permissions_lists.
     */
    data: permissions_listCreateManyInput | permissions_listCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * permissions_list update
   */
  export type permissions_listUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the permissions_list
     */
    select?: permissions_listSelect<ExtArgs> | null
    /**
     * Omit specific fields from the permissions_list
     */
    omit?: permissions_listOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: permissions_listInclude<ExtArgs> | null
    /**
     * The data needed to update a permissions_list.
     */
    data: XOR<permissions_listUpdateInput, permissions_listUncheckedUpdateInput>
    /**
     * Choose, which permissions_list to update.
     */
    where: permissions_listWhereUniqueInput
  }

  /**
   * permissions_list updateMany
   */
  export type permissions_listUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update permissions_lists.
     */
    data: XOR<permissions_listUpdateManyMutationInput, permissions_listUncheckedUpdateManyInput>
    /**
     * Filter which permissions_lists to update
     */
    where?: permissions_listWhereInput
    /**
     * Limit how many permissions_lists to update.
     */
    limit?: number
  }

  /**
   * permissions_list updateManyAndReturn
   */
  export type permissions_listUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the permissions_list
     */
    select?: permissions_listSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the permissions_list
     */
    omit?: permissions_listOmit<ExtArgs> | null
    /**
     * The data used to update permissions_lists.
     */
    data: XOR<permissions_listUpdateManyMutationInput, permissions_listUncheckedUpdateManyInput>
    /**
     * Filter which permissions_lists to update
     */
    where?: permissions_listWhereInput
    /**
     * Limit how many permissions_lists to update.
     */
    limit?: number
  }

  /**
   * permissions_list upsert
   */
  export type permissions_listUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the permissions_list
     */
    select?: permissions_listSelect<ExtArgs> | null
    /**
     * Omit specific fields from the permissions_list
     */
    omit?: permissions_listOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: permissions_listInclude<ExtArgs> | null
    /**
     * The filter to search for the permissions_list to update in case it exists.
     */
    where: permissions_listWhereUniqueInput
    /**
     * In case the permissions_list found by the `where` argument doesn't exist, create a new permissions_list with this data.
     */
    create: XOR<permissions_listCreateInput, permissions_listUncheckedCreateInput>
    /**
     * In case the permissions_list was found with the provided `where` argument, update it with this data.
     */
    update: XOR<permissions_listUpdateInput, permissions_listUncheckedUpdateInput>
  }

  /**
   * permissions_list delete
   */
  export type permissions_listDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the permissions_list
     */
    select?: permissions_listSelect<ExtArgs> | null
    /**
     * Omit specific fields from the permissions_list
     */
    omit?: permissions_listOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: permissions_listInclude<ExtArgs> | null
    /**
     * Filter which permissions_list to delete.
     */
    where: permissions_listWhereUniqueInput
  }

  /**
   * permissions_list deleteMany
   */
  export type permissions_listDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which permissions_lists to delete
     */
    where?: permissions_listWhereInput
    /**
     * Limit how many permissions_lists to delete.
     */
    limit?: number
  }

  /**
   * permissions_list.user_permissions
   */
  export type permissions_list$user_permissionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_permissions
     */
    select?: user_permissionsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user_permissions
     */
    omit?: user_permissionsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_permissionsInclude<ExtArgs> | null
    where?: user_permissionsWhereInput
    orderBy?: user_permissionsOrderByWithRelationInput | user_permissionsOrderByWithRelationInput[]
    cursor?: user_permissionsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: User_permissionsScalarFieldEnum | User_permissionsScalarFieldEnum[]
  }

  /**
   * permissions_list.subscription_feature
   */
  export type permissions_list$subscription_featureArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription_feature
     */
    select?: subscription_featureSelect<ExtArgs> | null
    /**
     * Omit specific fields from the subscription_feature
     */
    omit?: subscription_featureOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscription_featureInclude<ExtArgs> | null
    where?: subscription_featureWhereInput
    orderBy?: subscription_featureOrderByWithRelationInput | subscription_featureOrderByWithRelationInput[]
    cursor?: subscription_featureWhereUniqueInput
    take?: number
    skip?: number
    distinct?: Subscription_featureScalarFieldEnum | Subscription_featureScalarFieldEnum[]
  }

  /**
   * permissions_list without action
   */
  export type permissions_listDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the permissions_list
     */
    select?: permissions_listSelect<ExtArgs> | null
    /**
     * Omit specific fields from the permissions_list
     */
    omit?: permissions_listOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: permissions_listInclude<ExtArgs> | null
  }


  /**
   * Model roles
   */

  export type AggregateRoles = {
    _count: RolesCountAggregateOutputType | null
    _avg: RolesAvgAggregateOutputType | null
    _sum: RolesSumAggregateOutputType | null
    _min: RolesMinAggregateOutputType | null
    _max: RolesMaxAggregateOutputType | null
  }

  export type RolesAvgAggregateOutputType = {
    id: number | null
  }

  export type RolesSumAggregateOutputType = {
    id: number | null
  }

  export type RolesMinAggregateOutputType = {
    id: number | null
    name: string | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type RolesMaxAggregateOutputType = {
    id: number | null
    name: string | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type RolesCountAggregateOutputType = {
    id: number
    name: number
    created_at: number
    updated_at: number
    deleted_at: number
    _all: number
  }


  export type RolesAvgAggregateInputType = {
    id?: true
  }

  export type RolesSumAggregateInputType = {
    id?: true
  }

  export type RolesMinAggregateInputType = {
    id?: true
    name?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type RolesMaxAggregateInputType = {
    id?: true
    name?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type RolesCountAggregateInputType = {
    id?: true
    name?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    _all?: true
  }

  export type RolesAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which roles to aggregate.
     */
    where?: rolesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of roles to fetch.
     */
    orderBy?: rolesOrderByWithRelationInput | rolesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: rolesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` roles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` roles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned roles
    **/
    _count?: true | RolesCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: RolesAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: RolesSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: RolesMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: RolesMaxAggregateInputType
  }

  export type GetRolesAggregateType<T extends RolesAggregateArgs> = {
        [P in keyof T & keyof AggregateRoles]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateRoles[P]>
      : GetScalarType<T[P], AggregateRoles[P]>
  }




  export type rolesGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: rolesWhereInput
    orderBy?: rolesOrderByWithAggregationInput | rolesOrderByWithAggregationInput[]
    by: RolesScalarFieldEnum[] | RolesScalarFieldEnum
    having?: rolesScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: RolesCountAggregateInputType | true
    _avg?: RolesAvgAggregateInputType
    _sum?: RolesSumAggregateInputType
    _min?: RolesMinAggregateInputType
    _max?: RolesMaxAggregateInputType
  }

  export type RolesGroupByOutputType = {
    id: number
    name: string
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    _count: RolesCountAggregateOutputType | null
    _avg: RolesAvgAggregateOutputType | null
    _sum: RolesSumAggregateOutputType | null
    _min: RolesMinAggregateOutputType | null
    _max: RolesMaxAggregateOutputType | null
  }

  type GetRolesGroupByPayload<T extends rolesGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<RolesGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof RolesGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], RolesGroupByOutputType[P]>
            : GetScalarType<T[P], RolesGroupByOutputType[P]>
        }
      >
    >


  export type rolesSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }, ExtArgs["result"]["roles"]>

  export type rolesSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }, ExtArgs["result"]["roles"]>

  export type rolesSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }, ExtArgs["result"]["roles"]>

  export type rolesSelectScalar = {
    id?: boolean
    name?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }

  export type rolesOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "name" | "created_at" | "updated_at" | "deleted_at", ExtArgs["result"]["roles"]>

  export type $rolesPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "roles"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      name: string
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
    }, ExtArgs["result"]["roles"]>
    composites: {}
  }

  type rolesGetPayload<S extends boolean | null | undefined | rolesDefaultArgs> = $Result.GetResult<Prisma.$rolesPayload, S>

  type rolesCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<rolesFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: RolesCountAggregateInputType | true
    }

  export interface rolesDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['roles'], meta: { name: 'roles' } }
    /**
     * Find zero or one Roles that matches the filter.
     * @param {rolesFindUniqueArgs} args - Arguments to find a Roles
     * @example
     * // Get one Roles
     * const roles = await prisma.roles.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends rolesFindUniqueArgs>(args: SelectSubset<T, rolesFindUniqueArgs<ExtArgs>>): Prisma__rolesClient<$Result.GetResult<Prisma.$rolesPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Roles that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {rolesFindUniqueOrThrowArgs} args - Arguments to find a Roles
     * @example
     * // Get one Roles
     * const roles = await prisma.roles.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends rolesFindUniqueOrThrowArgs>(args: SelectSubset<T, rolesFindUniqueOrThrowArgs<ExtArgs>>): Prisma__rolesClient<$Result.GetResult<Prisma.$rolesPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Roles that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {rolesFindFirstArgs} args - Arguments to find a Roles
     * @example
     * // Get one Roles
     * const roles = await prisma.roles.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends rolesFindFirstArgs>(args?: SelectSubset<T, rolesFindFirstArgs<ExtArgs>>): Prisma__rolesClient<$Result.GetResult<Prisma.$rolesPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Roles that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {rolesFindFirstOrThrowArgs} args - Arguments to find a Roles
     * @example
     * // Get one Roles
     * const roles = await prisma.roles.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends rolesFindFirstOrThrowArgs>(args?: SelectSubset<T, rolesFindFirstOrThrowArgs<ExtArgs>>): Prisma__rolesClient<$Result.GetResult<Prisma.$rolesPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Roles that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {rolesFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Roles
     * const roles = await prisma.roles.findMany()
     * 
     * // Get first 10 Roles
     * const roles = await prisma.roles.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const rolesWithIdOnly = await prisma.roles.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends rolesFindManyArgs>(args?: SelectSubset<T, rolesFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$rolesPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Roles.
     * @param {rolesCreateArgs} args - Arguments to create a Roles.
     * @example
     * // Create one Roles
     * const Roles = await prisma.roles.create({
     *   data: {
     *     // ... data to create a Roles
     *   }
     * })
     * 
     */
    create<T extends rolesCreateArgs>(args: SelectSubset<T, rolesCreateArgs<ExtArgs>>): Prisma__rolesClient<$Result.GetResult<Prisma.$rolesPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Roles.
     * @param {rolesCreateManyArgs} args - Arguments to create many Roles.
     * @example
     * // Create many Roles
     * const roles = await prisma.roles.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends rolesCreateManyArgs>(args?: SelectSubset<T, rolesCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Roles and returns the data saved in the database.
     * @param {rolesCreateManyAndReturnArgs} args - Arguments to create many Roles.
     * @example
     * // Create many Roles
     * const roles = await prisma.roles.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Roles and only return the `id`
     * const rolesWithIdOnly = await prisma.roles.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends rolesCreateManyAndReturnArgs>(args?: SelectSubset<T, rolesCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$rolesPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a Roles.
     * @param {rolesDeleteArgs} args - Arguments to delete one Roles.
     * @example
     * // Delete one Roles
     * const Roles = await prisma.roles.delete({
     *   where: {
     *     // ... filter to delete one Roles
     *   }
     * })
     * 
     */
    delete<T extends rolesDeleteArgs>(args: SelectSubset<T, rolesDeleteArgs<ExtArgs>>): Prisma__rolesClient<$Result.GetResult<Prisma.$rolesPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Roles.
     * @param {rolesUpdateArgs} args - Arguments to update one Roles.
     * @example
     * // Update one Roles
     * const roles = await prisma.roles.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends rolesUpdateArgs>(args: SelectSubset<T, rolesUpdateArgs<ExtArgs>>): Prisma__rolesClient<$Result.GetResult<Prisma.$rolesPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Roles.
     * @param {rolesDeleteManyArgs} args - Arguments to filter Roles to delete.
     * @example
     * // Delete a few Roles
     * const { count } = await prisma.roles.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends rolesDeleteManyArgs>(args?: SelectSubset<T, rolesDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Roles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {rolesUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Roles
     * const roles = await prisma.roles.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends rolesUpdateManyArgs>(args: SelectSubset<T, rolesUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Roles and returns the data updated in the database.
     * @param {rolesUpdateManyAndReturnArgs} args - Arguments to update many Roles.
     * @example
     * // Update many Roles
     * const roles = await prisma.roles.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Roles and only return the `id`
     * const rolesWithIdOnly = await prisma.roles.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends rolesUpdateManyAndReturnArgs>(args: SelectSubset<T, rolesUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$rolesPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one Roles.
     * @param {rolesUpsertArgs} args - Arguments to update or create a Roles.
     * @example
     * // Update or create a Roles
     * const roles = await prisma.roles.upsert({
     *   create: {
     *     // ... data to create a Roles
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Roles we want to update
     *   }
     * })
     */
    upsert<T extends rolesUpsertArgs>(args: SelectSubset<T, rolesUpsertArgs<ExtArgs>>): Prisma__rolesClient<$Result.GetResult<Prisma.$rolesPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of Roles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {rolesCountArgs} args - Arguments to filter Roles to count.
     * @example
     * // Count the number of Roles
     * const count = await prisma.roles.count({
     *   where: {
     *     // ... the filter for the Roles we want to count
     *   }
     * })
    **/
    count<T extends rolesCountArgs>(
      args?: Subset<T, rolesCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], RolesCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Roles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RolesAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends RolesAggregateArgs>(args: Subset<T, RolesAggregateArgs>): Prisma.PrismaPromise<GetRolesAggregateType<T>>

    /**
     * Group by Roles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {rolesGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends rolesGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: rolesGroupByArgs['orderBy'] }
        : { orderBy?: rolesGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, rolesGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetRolesGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the roles model
   */
  readonly fields: rolesFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for roles.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__rolesClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the roles model
   */ 
  interface rolesFieldRefs {
    readonly id: FieldRef<"roles", 'Int'>
    readonly name: FieldRef<"roles", 'String'>
    readonly created_at: FieldRef<"roles", 'DateTime'>
    readonly updated_at: FieldRef<"roles", 'DateTime'>
    readonly deleted_at: FieldRef<"roles", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * roles findUnique
   */
  export type rolesFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the roles
     */
    select?: rolesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the roles
     */
    omit?: rolesOmit<ExtArgs> | null
    /**
     * Filter, which roles to fetch.
     */
    where: rolesWhereUniqueInput
  }

  /**
   * roles findUniqueOrThrow
   */
  export type rolesFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the roles
     */
    select?: rolesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the roles
     */
    omit?: rolesOmit<ExtArgs> | null
    /**
     * Filter, which roles to fetch.
     */
    where: rolesWhereUniqueInput
  }

  /**
   * roles findFirst
   */
  export type rolesFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the roles
     */
    select?: rolesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the roles
     */
    omit?: rolesOmit<ExtArgs> | null
    /**
     * Filter, which roles to fetch.
     */
    where?: rolesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of roles to fetch.
     */
    orderBy?: rolesOrderByWithRelationInput | rolesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for roles.
     */
    cursor?: rolesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` roles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` roles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of roles.
     */
    distinct?: RolesScalarFieldEnum | RolesScalarFieldEnum[]
  }

  /**
   * roles findFirstOrThrow
   */
  export type rolesFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the roles
     */
    select?: rolesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the roles
     */
    omit?: rolesOmit<ExtArgs> | null
    /**
     * Filter, which roles to fetch.
     */
    where?: rolesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of roles to fetch.
     */
    orderBy?: rolesOrderByWithRelationInput | rolesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for roles.
     */
    cursor?: rolesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` roles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` roles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of roles.
     */
    distinct?: RolesScalarFieldEnum | RolesScalarFieldEnum[]
  }

  /**
   * roles findMany
   */
  export type rolesFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the roles
     */
    select?: rolesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the roles
     */
    omit?: rolesOmit<ExtArgs> | null
    /**
     * Filter, which roles to fetch.
     */
    where?: rolesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of roles to fetch.
     */
    orderBy?: rolesOrderByWithRelationInput | rolesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing roles.
     */
    cursor?: rolesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` roles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` roles.
     */
    skip?: number
    distinct?: RolesScalarFieldEnum | RolesScalarFieldEnum[]
  }

  /**
   * roles create
   */
  export type rolesCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the roles
     */
    select?: rolesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the roles
     */
    omit?: rolesOmit<ExtArgs> | null
    /**
     * The data needed to create a roles.
     */
    data: XOR<rolesCreateInput, rolesUncheckedCreateInput>
  }

  /**
   * roles createMany
   */
  export type rolesCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many roles.
     */
    data: rolesCreateManyInput | rolesCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * roles createManyAndReturn
   */
  export type rolesCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the roles
     */
    select?: rolesSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the roles
     */
    omit?: rolesOmit<ExtArgs> | null
    /**
     * The data used to create many roles.
     */
    data: rolesCreateManyInput | rolesCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * roles update
   */
  export type rolesUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the roles
     */
    select?: rolesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the roles
     */
    omit?: rolesOmit<ExtArgs> | null
    /**
     * The data needed to update a roles.
     */
    data: XOR<rolesUpdateInput, rolesUncheckedUpdateInput>
    /**
     * Choose, which roles to update.
     */
    where: rolesWhereUniqueInput
  }

  /**
   * roles updateMany
   */
  export type rolesUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update roles.
     */
    data: XOR<rolesUpdateManyMutationInput, rolesUncheckedUpdateManyInput>
    /**
     * Filter which roles to update
     */
    where?: rolesWhereInput
    /**
     * Limit how many roles to update.
     */
    limit?: number
  }

  /**
   * roles updateManyAndReturn
   */
  export type rolesUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the roles
     */
    select?: rolesSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the roles
     */
    omit?: rolesOmit<ExtArgs> | null
    /**
     * The data used to update roles.
     */
    data: XOR<rolesUpdateManyMutationInput, rolesUncheckedUpdateManyInput>
    /**
     * Filter which roles to update
     */
    where?: rolesWhereInput
    /**
     * Limit how many roles to update.
     */
    limit?: number
  }

  /**
   * roles upsert
   */
  export type rolesUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the roles
     */
    select?: rolesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the roles
     */
    omit?: rolesOmit<ExtArgs> | null
    /**
     * The filter to search for the roles to update in case it exists.
     */
    where: rolesWhereUniqueInput
    /**
     * In case the roles found by the `where` argument doesn't exist, create a new roles with this data.
     */
    create: XOR<rolesCreateInput, rolesUncheckedCreateInput>
    /**
     * In case the roles was found with the provided `where` argument, update it with this data.
     */
    update: XOR<rolesUpdateInput, rolesUncheckedUpdateInput>
  }

  /**
   * roles delete
   */
  export type rolesDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the roles
     */
    select?: rolesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the roles
     */
    omit?: rolesOmit<ExtArgs> | null
    /**
     * Filter which roles to delete.
     */
    where: rolesWhereUniqueInput
  }

  /**
   * roles deleteMany
   */
  export type rolesDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which roles to delete
     */
    where?: rolesWhereInput
    /**
     * Limit how many roles to delete.
     */
    limit?: number
  }

  /**
   * roles without action
   */
  export type rolesDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the roles
     */
    select?: rolesSelect<ExtArgs> | null
    /**
     * Omit specific fields from the roles
     */
    omit?: rolesOmit<ExtArgs> | null
  }


  /**
   * Model subscription
   */

  export type AggregateSubscription = {
    _count: SubscriptionCountAggregateOutputType | null
    _avg: SubscriptionAvgAggregateOutputType | null
    _sum: SubscriptionSumAggregateOutputType | null
    _min: SubscriptionMinAggregateOutputType | null
    _max: SubscriptionMaxAggregateOutputType | null
  }

  export type SubscriptionAvgAggregateOutputType = {
    id: number | null
    status: number | null
  }

  export type SubscriptionSumAggregateOutputType = {
    id: number | null
    status: number | null
  }

  export type SubscriptionMinAggregateOutputType = {
    id: number | null
    name: string | null
    status: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type SubscriptionMaxAggregateOutputType = {
    id: number | null
    name: string | null
    status: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type SubscriptionCountAggregateOutputType = {
    id: number
    name: number
    status: number
    created_at: number
    updated_at: number
    deleted_at: number
    _all: number
  }


  export type SubscriptionAvgAggregateInputType = {
    id?: true
    status?: true
  }

  export type SubscriptionSumAggregateInputType = {
    id?: true
    status?: true
  }

  export type SubscriptionMinAggregateInputType = {
    id?: true
    name?: true
    status?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type SubscriptionMaxAggregateInputType = {
    id?: true
    name?: true
    status?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type SubscriptionCountAggregateInputType = {
    id?: true
    name?: true
    status?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    _all?: true
  }

  export type SubscriptionAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which subscription to aggregate.
     */
    where?: subscriptionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of subscriptions to fetch.
     */
    orderBy?: subscriptionOrderByWithRelationInput | subscriptionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: subscriptionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` subscriptions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` subscriptions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned subscriptions
    **/
    _count?: true | SubscriptionCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: SubscriptionAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: SubscriptionSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: SubscriptionMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: SubscriptionMaxAggregateInputType
  }

  export type GetSubscriptionAggregateType<T extends SubscriptionAggregateArgs> = {
        [P in keyof T & keyof AggregateSubscription]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateSubscription[P]>
      : GetScalarType<T[P], AggregateSubscription[P]>
  }




  export type subscriptionGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: subscriptionWhereInput
    orderBy?: subscriptionOrderByWithAggregationInput | subscriptionOrderByWithAggregationInput[]
    by: SubscriptionScalarFieldEnum[] | SubscriptionScalarFieldEnum
    having?: subscriptionScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: SubscriptionCountAggregateInputType | true
    _avg?: SubscriptionAvgAggregateInputType
    _sum?: SubscriptionSumAggregateInputType
    _min?: SubscriptionMinAggregateInputType
    _max?: SubscriptionMaxAggregateInputType
  }

  export type SubscriptionGroupByOutputType = {
    id: number
    name: string
    status: number
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    _count: SubscriptionCountAggregateOutputType | null
    _avg: SubscriptionAvgAggregateOutputType | null
    _sum: SubscriptionSumAggregateOutputType | null
    _min: SubscriptionMinAggregateOutputType | null
    _max: SubscriptionMaxAggregateOutputType | null
  }

  type GetSubscriptionGroupByPayload<T extends subscriptionGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<SubscriptionGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof SubscriptionGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], SubscriptionGroupByOutputType[P]>
            : GetScalarType<T[P], SubscriptionGroupByOutputType[P]>
        }
      >
    >


  export type subscriptionSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    status?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    user_subscription?: boolean | subscription$user_subscriptionArgs<ExtArgs>
    subscription_feature?: boolean | subscription$subscription_featureArgs<ExtArgs>
    package_features?: boolean | subscription$package_featuresArgs<ExtArgs>
    _count?: boolean | SubscriptionCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["subscription"]>

  export type subscriptionSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    status?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }, ExtArgs["result"]["subscription"]>

  export type subscriptionSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    status?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }, ExtArgs["result"]["subscription"]>

  export type subscriptionSelectScalar = {
    id?: boolean
    name?: boolean
    status?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }

  export type subscriptionOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "name" | "status" | "created_at" | "updated_at" | "deleted_at", ExtArgs["result"]["subscription"]>
  export type subscriptionInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user_subscription?: boolean | subscription$user_subscriptionArgs<ExtArgs>
    subscription_feature?: boolean | subscription$subscription_featureArgs<ExtArgs>
    package_features?: boolean | subscription$package_featuresArgs<ExtArgs>
    _count?: boolean | SubscriptionCountOutputTypeDefaultArgs<ExtArgs>
  }
  export type subscriptionIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {}
  export type subscriptionIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {}

  export type $subscriptionPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "subscription"
    objects: {
      user_subscription: Prisma.$user_subscriptionPayload<ExtArgs>[]
      subscription_feature: Prisma.$subscription_featurePayload<ExtArgs>[]
      package_features: Prisma.$package_featuresPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      name: string
      status: number
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
    }, ExtArgs["result"]["subscription"]>
    composites: {}
  }

  type subscriptionGetPayload<S extends boolean | null | undefined | subscriptionDefaultArgs> = $Result.GetResult<Prisma.$subscriptionPayload, S>

  type subscriptionCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<subscriptionFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: SubscriptionCountAggregateInputType | true
    }

  export interface subscriptionDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['subscription'], meta: { name: 'subscription' } }
    /**
     * Find zero or one Subscription that matches the filter.
     * @param {subscriptionFindUniqueArgs} args - Arguments to find a Subscription
     * @example
     * // Get one Subscription
     * const subscription = await prisma.subscription.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends subscriptionFindUniqueArgs>(args: SelectSubset<T, subscriptionFindUniqueArgs<ExtArgs>>): Prisma__subscriptionClient<$Result.GetResult<Prisma.$subscriptionPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Subscription that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {subscriptionFindUniqueOrThrowArgs} args - Arguments to find a Subscription
     * @example
     * // Get one Subscription
     * const subscription = await prisma.subscription.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends subscriptionFindUniqueOrThrowArgs>(args: SelectSubset<T, subscriptionFindUniqueOrThrowArgs<ExtArgs>>): Prisma__subscriptionClient<$Result.GetResult<Prisma.$subscriptionPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Subscription that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {subscriptionFindFirstArgs} args - Arguments to find a Subscription
     * @example
     * // Get one Subscription
     * const subscription = await prisma.subscription.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends subscriptionFindFirstArgs>(args?: SelectSubset<T, subscriptionFindFirstArgs<ExtArgs>>): Prisma__subscriptionClient<$Result.GetResult<Prisma.$subscriptionPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Subscription that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {subscriptionFindFirstOrThrowArgs} args - Arguments to find a Subscription
     * @example
     * // Get one Subscription
     * const subscription = await prisma.subscription.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends subscriptionFindFirstOrThrowArgs>(args?: SelectSubset<T, subscriptionFindFirstOrThrowArgs<ExtArgs>>): Prisma__subscriptionClient<$Result.GetResult<Prisma.$subscriptionPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Subscriptions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {subscriptionFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Subscriptions
     * const subscriptions = await prisma.subscription.findMany()
     * 
     * // Get first 10 Subscriptions
     * const subscriptions = await prisma.subscription.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const subscriptionWithIdOnly = await prisma.subscription.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends subscriptionFindManyArgs>(args?: SelectSubset<T, subscriptionFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$subscriptionPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Subscription.
     * @param {subscriptionCreateArgs} args - Arguments to create a Subscription.
     * @example
     * // Create one Subscription
     * const Subscription = await prisma.subscription.create({
     *   data: {
     *     // ... data to create a Subscription
     *   }
     * })
     * 
     */
    create<T extends subscriptionCreateArgs>(args: SelectSubset<T, subscriptionCreateArgs<ExtArgs>>): Prisma__subscriptionClient<$Result.GetResult<Prisma.$subscriptionPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Subscriptions.
     * @param {subscriptionCreateManyArgs} args - Arguments to create many Subscriptions.
     * @example
     * // Create many Subscriptions
     * const subscription = await prisma.subscription.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends subscriptionCreateManyArgs>(args?: SelectSubset<T, subscriptionCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Subscriptions and returns the data saved in the database.
     * @param {subscriptionCreateManyAndReturnArgs} args - Arguments to create many Subscriptions.
     * @example
     * // Create many Subscriptions
     * const subscription = await prisma.subscription.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Subscriptions and only return the `id`
     * const subscriptionWithIdOnly = await prisma.subscription.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends subscriptionCreateManyAndReturnArgs>(args?: SelectSubset<T, subscriptionCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$subscriptionPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a Subscription.
     * @param {subscriptionDeleteArgs} args - Arguments to delete one Subscription.
     * @example
     * // Delete one Subscription
     * const Subscription = await prisma.subscription.delete({
     *   where: {
     *     // ... filter to delete one Subscription
     *   }
     * })
     * 
     */
    delete<T extends subscriptionDeleteArgs>(args: SelectSubset<T, subscriptionDeleteArgs<ExtArgs>>): Prisma__subscriptionClient<$Result.GetResult<Prisma.$subscriptionPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Subscription.
     * @param {subscriptionUpdateArgs} args - Arguments to update one Subscription.
     * @example
     * // Update one Subscription
     * const subscription = await prisma.subscription.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends subscriptionUpdateArgs>(args: SelectSubset<T, subscriptionUpdateArgs<ExtArgs>>): Prisma__subscriptionClient<$Result.GetResult<Prisma.$subscriptionPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Subscriptions.
     * @param {subscriptionDeleteManyArgs} args - Arguments to filter Subscriptions to delete.
     * @example
     * // Delete a few Subscriptions
     * const { count } = await prisma.subscription.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends subscriptionDeleteManyArgs>(args?: SelectSubset<T, subscriptionDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Subscriptions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {subscriptionUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Subscriptions
     * const subscription = await prisma.subscription.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends subscriptionUpdateManyArgs>(args: SelectSubset<T, subscriptionUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Subscriptions and returns the data updated in the database.
     * @param {subscriptionUpdateManyAndReturnArgs} args - Arguments to update many Subscriptions.
     * @example
     * // Update many Subscriptions
     * const subscription = await prisma.subscription.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Subscriptions and only return the `id`
     * const subscriptionWithIdOnly = await prisma.subscription.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends subscriptionUpdateManyAndReturnArgs>(args: SelectSubset<T, subscriptionUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$subscriptionPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one Subscription.
     * @param {subscriptionUpsertArgs} args - Arguments to update or create a Subscription.
     * @example
     * // Update or create a Subscription
     * const subscription = await prisma.subscription.upsert({
     *   create: {
     *     // ... data to create a Subscription
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Subscription we want to update
     *   }
     * })
     */
    upsert<T extends subscriptionUpsertArgs>(args: SelectSubset<T, subscriptionUpsertArgs<ExtArgs>>): Prisma__subscriptionClient<$Result.GetResult<Prisma.$subscriptionPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of Subscriptions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {subscriptionCountArgs} args - Arguments to filter Subscriptions to count.
     * @example
     * // Count the number of Subscriptions
     * const count = await prisma.subscription.count({
     *   where: {
     *     // ... the filter for the Subscriptions we want to count
     *   }
     * })
    **/
    count<T extends subscriptionCountArgs>(
      args?: Subset<T, subscriptionCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], SubscriptionCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Subscription.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {SubscriptionAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends SubscriptionAggregateArgs>(args: Subset<T, SubscriptionAggregateArgs>): Prisma.PrismaPromise<GetSubscriptionAggregateType<T>>

    /**
     * Group by Subscription.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {subscriptionGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends subscriptionGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: subscriptionGroupByArgs['orderBy'] }
        : { orderBy?: subscriptionGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, subscriptionGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetSubscriptionGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the subscription model
   */
  readonly fields: subscriptionFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for subscription.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__subscriptionClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    user_subscription<T extends subscription$user_subscriptionArgs<ExtArgs> = {}>(args?: Subset<T, subscription$user_subscriptionArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$user_subscriptionPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    subscription_feature<T extends subscription$subscription_featureArgs<ExtArgs> = {}>(args?: Subset<T, subscription$subscription_featureArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$subscription_featurePayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    package_features<T extends subscription$package_featuresArgs<ExtArgs> = {}>(args?: Subset<T, subscription$package_featuresArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "findMany", ClientOptions> | Null>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the subscription model
   */ 
  interface subscriptionFieldRefs {
    readonly id: FieldRef<"subscription", 'Int'>
    readonly name: FieldRef<"subscription", 'String'>
    readonly status: FieldRef<"subscription", 'Int'>
    readonly created_at: FieldRef<"subscription", 'DateTime'>
    readonly updated_at: FieldRef<"subscription", 'DateTime'>
    readonly deleted_at: FieldRef<"subscription", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * subscription findUnique
   */
  export type subscriptionFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription
     */
    select?: subscriptionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the subscription
     */
    omit?: subscriptionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscriptionInclude<ExtArgs> | null
    /**
     * Filter, which subscription to fetch.
     */
    where: subscriptionWhereUniqueInput
  }

  /**
   * subscription findUniqueOrThrow
   */
  export type subscriptionFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription
     */
    select?: subscriptionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the subscription
     */
    omit?: subscriptionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscriptionInclude<ExtArgs> | null
    /**
     * Filter, which subscription to fetch.
     */
    where: subscriptionWhereUniqueInput
  }

  /**
   * subscription findFirst
   */
  export type subscriptionFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription
     */
    select?: subscriptionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the subscription
     */
    omit?: subscriptionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscriptionInclude<ExtArgs> | null
    /**
     * Filter, which subscription to fetch.
     */
    where?: subscriptionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of subscriptions to fetch.
     */
    orderBy?: subscriptionOrderByWithRelationInput | subscriptionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for subscriptions.
     */
    cursor?: subscriptionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` subscriptions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` subscriptions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of subscriptions.
     */
    distinct?: SubscriptionScalarFieldEnum | SubscriptionScalarFieldEnum[]
  }

  /**
   * subscription findFirstOrThrow
   */
  export type subscriptionFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription
     */
    select?: subscriptionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the subscription
     */
    omit?: subscriptionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscriptionInclude<ExtArgs> | null
    /**
     * Filter, which subscription to fetch.
     */
    where?: subscriptionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of subscriptions to fetch.
     */
    orderBy?: subscriptionOrderByWithRelationInput | subscriptionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for subscriptions.
     */
    cursor?: subscriptionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` subscriptions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` subscriptions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of subscriptions.
     */
    distinct?: SubscriptionScalarFieldEnum | SubscriptionScalarFieldEnum[]
  }

  /**
   * subscription findMany
   */
  export type subscriptionFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription
     */
    select?: subscriptionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the subscription
     */
    omit?: subscriptionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscriptionInclude<ExtArgs> | null
    /**
     * Filter, which subscriptions to fetch.
     */
    where?: subscriptionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of subscriptions to fetch.
     */
    orderBy?: subscriptionOrderByWithRelationInput | subscriptionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing subscriptions.
     */
    cursor?: subscriptionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` subscriptions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` subscriptions.
     */
    skip?: number
    distinct?: SubscriptionScalarFieldEnum | SubscriptionScalarFieldEnum[]
  }

  /**
   * subscription create
   */
  export type subscriptionCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription
     */
    select?: subscriptionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the subscription
     */
    omit?: subscriptionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscriptionInclude<ExtArgs> | null
    /**
     * The data needed to create a subscription.
     */
    data: XOR<subscriptionCreateInput, subscriptionUncheckedCreateInput>
  }

  /**
   * subscription createMany
   */
  export type subscriptionCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many subscriptions.
     */
    data: subscriptionCreateManyInput | subscriptionCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * subscription createManyAndReturn
   */
  export type subscriptionCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription
     */
    select?: subscriptionSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the subscription
     */
    omit?: subscriptionOmit<ExtArgs> | null
    /**
     * The data used to create many subscriptions.
     */
    data: subscriptionCreateManyInput | subscriptionCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * subscription update
   */
  export type subscriptionUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription
     */
    select?: subscriptionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the subscription
     */
    omit?: subscriptionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscriptionInclude<ExtArgs> | null
    /**
     * The data needed to update a subscription.
     */
    data: XOR<subscriptionUpdateInput, subscriptionUncheckedUpdateInput>
    /**
     * Choose, which subscription to update.
     */
    where: subscriptionWhereUniqueInput
  }

  /**
   * subscription updateMany
   */
  export type subscriptionUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update subscriptions.
     */
    data: XOR<subscriptionUpdateManyMutationInput, subscriptionUncheckedUpdateManyInput>
    /**
     * Filter which subscriptions to update
     */
    where?: subscriptionWhereInput
    /**
     * Limit how many subscriptions to update.
     */
    limit?: number
  }

  /**
   * subscription updateManyAndReturn
   */
  export type subscriptionUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription
     */
    select?: subscriptionSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the subscription
     */
    omit?: subscriptionOmit<ExtArgs> | null
    /**
     * The data used to update subscriptions.
     */
    data: XOR<subscriptionUpdateManyMutationInput, subscriptionUncheckedUpdateManyInput>
    /**
     * Filter which subscriptions to update
     */
    where?: subscriptionWhereInput
    /**
     * Limit how many subscriptions to update.
     */
    limit?: number
  }

  /**
   * subscription upsert
   */
  export type subscriptionUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription
     */
    select?: subscriptionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the subscription
     */
    omit?: subscriptionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscriptionInclude<ExtArgs> | null
    /**
     * The filter to search for the subscription to update in case it exists.
     */
    where: subscriptionWhereUniqueInput
    /**
     * In case the subscription found by the `where` argument doesn't exist, create a new subscription with this data.
     */
    create: XOR<subscriptionCreateInput, subscriptionUncheckedCreateInput>
    /**
     * In case the subscription was found with the provided `where` argument, update it with this data.
     */
    update: XOR<subscriptionUpdateInput, subscriptionUncheckedUpdateInput>
  }

  /**
   * subscription delete
   */
  export type subscriptionDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription
     */
    select?: subscriptionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the subscription
     */
    omit?: subscriptionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscriptionInclude<ExtArgs> | null
    /**
     * Filter which subscription to delete.
     */
    where: subscriptionWhereUniqueInput
  }

  /**
   * subscription deleteMany
   */
  export type subscriptionDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which subscriptions to delete
     */
    where?: subscriptionWhereInput
    /**
     * Limit how many subscriptions to delete.
     */
    limit?: number
  }

  /**
   * subscription.user_subscription
   */
  export type subscription$user_subscriptionArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_subscription
     */
    select?: user_subscriptionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user_subscription
     */
    omit?: user_subscriptionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_subscriptionInclude<ExtArgs> | null
    where?: user_subscriptionWhereInput
    orderBy?: user_subscriptionOrderByWithRelationInput | user_subscriptionOrderByWithRelationInput[]
    cursor?: user_subscriptionWhereUniqueInput
    take?: number
    skip?: number
    distinct?: User_subscriptionScalarFieldEnum | User_subscriptionScalarFieldEnum[]
  }

  /**
   * subscription.subscription_feature
   */
  export type subscription$subscription_featureArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription_feature
     */
    select?: subscription_featureSelect<ExtArgs> | null
    /**
     * Omit specific fields from the subscription_feature
     */
    omit?: subscription_featureOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscription_featureInclude<ExtArgs> | null
    where?: subscription_featureWhereInput
    orderBy?: subscription_featureOrderByWithRelationInput | subscription_featureOrderByWithRelationInput[]
    cursor?: subscription_featureWhereUniqueInput
    take?: number
    skip?: number
    distinct?: Subscription_featureScalarFieldEnum | Subscription_featureScalarFieldEnum[]
  }

  /**
   * subscription.package_features
   */
  export type subscription$package_featuresArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelect<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresInclude<ExtArgs> | null
    where?: package_featuresWhereInput
    orderBy?: package_featuresOrderByWithRelationInput | package_featuresOrderByWithRelationInput[]
    cursor?: package_featuresWhereUniqueInput
    take?: number
    skip?: number
    distinct?: Package_featuresScalarFieldEnum | Package_featuresScalarFieldEnum[]
  }

  /**
   * subscription without action
   */
  export type subscriptionDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription
     */
    select?: subscriptionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the subscription
     */
    omit?: subscriptionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscriptionInclude<ExtArgs> | null
  }


  /**
   * Model subscription_feature
   */

  export type AggregateSubscription_feature = {
    _count: Subscription_featureCountAggregateOutputType | null
    _avg: Subscription_featureAvgAggregateOutputType | null
    _sum: Subscription_featureSumAggregateOutputType | null
    _min: Subscription_featureMinAggregateOutputType | null
    _max: Subscription_featureMaxAggregateOutputType | null
  }

  export type Subscription_featureAvgAggregateOutputType = {
    id: number | null
    status: number | null
    subscription_id: number | null
    permission_id: number | null
    limit: number | null
  }

  export type Subscription_featureSumAggregateOutputType = {
    id: number | null
    status: number | null
    subscription_id: number | null
    permission_id: number | null
    limit: number | null
  }

  export type Subscription_featureMinAggregateOutputType = {
    id: number | null
    status: number | null
    subscription_id: number | null
    permission_id: number | null
    limit: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type Subscription_featureMaxAggregateOutputType = {
    id: number | null
    status: number | null
    subscription_id: number | null
    permission_id: number | null
    limit: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type Subscription_featureCountAggregateOutputType = {
    id: number
    status: number
    subscription_id: number
    permission_id: number
    limit: number
    created_at: number
    updated_at: number
    deleted_at: number
    _all: number
  }


  export type Subscription_featureAvgAggregateInputType = {
    id?: true
    status?: true
    subscription_id?: true
    permission_id?: true
    limit?: true
  }

  export type Subscription_featureSumAggregateInputType = {
    id?: true
    status?: true
    subscription_id?: true
    permission_id?: true
    limit?: true
  }

  export type Subscription_featureMinAggregateInputType = {
    id?: true
    status?: true
    subscription_id?: true
    permission_id?: true
    limit?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type Subscription_featureMaxAggregateInputType = {
    id?: true
    status?: true
    subscription_id?: true
    permission_id?: true
    limit?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type Subscription_featureCountAggregateInputType = {
    id?: true
    status?: true
    subscription_id?: true
    permission_id?: true
    limit?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    _all?: true
  }

  export type Subscription_featureAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which subscription_feature to aggregate.
     */
    where?: subscription_featureWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of subscription_features to fetch.
     */
    orderBy?: subscription_featureOrderByWithRelationInput | subscription_featureOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: subscription_featureWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` subscription_features from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` subscription_features.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned subscription_features
    **/
    _count?: true | Subscription_featureCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Subscription_featureAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Subscription_featureSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Subscription_featureMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Subscription_featureMaxAggregateInputType
  }

  export type GetSubscription_featureAggregateType<T extends Subscription_featureAggregateArgs> = {
        [P in keyof T & keyof AggregateSubscription_feature]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateSubscription_feature[P]>
      : GetScalarType<T[P], AggregateSubscription_feature[P]>
  }




  export type subscription_featureGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: subscription_featureWhereInput
    orderBy?: subscription_featureOrderByWithAggregationInput | subscription_featureOrderByWithAggregationInput[]
    by: Subscription_featureScalarFieldEnum[] | Subscription_featureScalarFieldEnum
    having?: subscription_featureScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Subscription_featureCountAggregateInputType | true
    _avg?: Subscription_featureAvgAggregateInputType
    _sum?: Subscription_featureSumAggregateInputType
    _min?: Subscription_featureMinAggregateInputType
    _max?: Subscription_featureMaxAggregateInputType
  }

  export type Subscription_featureGroupByOutputType = {
    id: number
    status: number
    subscription_id: number
    permission_id: number
    limit: number
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    _count: Subscription_featureCountAggregateOutputType | null
    _avg: Subscription_featureAvgAggregateOutputType | null
    _sum: Subscription_featureSumAggregateOutputType | null
    _min: Subscription_featureMinAggregateOutputType | null
    _max: Subscription_featureMaxAggregateOutputType | null
  }

  type GetSubscription_featureGroupByPayload<T extends subscription_featureGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Subscription_featureGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Subscription_featureGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Subscription_featureGroupByOutputType[P]>
            : GetScalarType<T[P], Subscription_featureGroupByOutputType[P]>
        }
      >
    >


  export type subscription_featureSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    status?: boolean
    subscription_id?: boolean
    permission_id?: boolean
    limit?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    subscricption_package?: boolean | subscriptionDefaultArgs<ExtArgs>
    features?: boolean | permissions_listDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["subscription_feature"]>

  export type subscription_featureSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    status?: boolean
    subscription_id?: boolean
    permission_id?: boolean
    limit?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    subscricption_package?: boolean | subscriptionDefaultArgs<ExtArgs>
    features?: boolean | permissions_listDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["subscription_feature"]>

  export type subscription_featureSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    status?: boolean
    subscription_id?: boolean
    permission_id?: boolean
    limit?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    subscricption_package?: boolean | subscriptionDefaultArgs<ExtArgs>
    features?: boolean | permissions_listDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["subscription_feature"]>

  export type subscription_featureSelectScalar = {
    id?: boolean
    status?: boolean
    subscription_id?: boolean
    permission_id?: boolean
    limit?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }

  export type subscription_featureOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "status" | "subscription_id" | "permission_id" | "limit" | "created_at" | "updated_at" | "deleted_at", ExtArgs["result"]["subscription_feature"]>
  export type subscription_featureInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    subscricption_package?: boolean | subscriptionDefaultArgs<ExtArgs>
    features?: boolean | permissions_listDefaultArgs<ExtArgs>
  }
  export type subscription_featureIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    subscricption_package?: boolean | subscriptionDefaultArgs<ExtArgs>
    features?: boolean | permissions_listDefaultArgs<ExtArgs>
  }
  export type subscription_featureIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    subscricption_package?: boolean | subscriptionDefaultArgs<ExtArgs>
    features?: boolean | permissions_listDefaultArgs<ExtArgs>
  }

  export type $subscription_featurePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "subscription_feature"
    objects: {
      subscricption_package: Prisma.$subscriptionPayload<ExtArgs>
      features: Prisma.$permissions_listPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      status: number
      subscription_id: number
      permission_id: number
      limit: number
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
    }, ExtArgs["result"]["subscription_feature"]>
    composites: {}
  }

  type subscription_featureGetPayload<S extends boolean | null | undefined | subscription_featureDefaultArgs> = $Result.GetResult<Prisma.$subscription_featurePayload, S>

  type subscription_featureCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<subscription_featureFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Subscription_featureCountAggregateInputType | true
    }

  export interface subscription_featureDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['subscription_feature'], meta: { name: 'subscription_feature' } }
    /**
     * Find zero or one Subscription_feature that matches the filter.
     * @param {subscription_featureFindUniqueArgs} args - Arguments to find a Subscription_feature
     * @example
     * // Get one Subscription_feature
     * const subscription_feature = await prisma.subscription_feature.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends subscription_featureFindUniqueArgs>(args: SelectSubset<T, subscription_featureFindUniqueArgs<ExtArgs>>): Prisma__subscription_featureClient<$Result.GetResult<Prisma.$subscription_featurePayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Subscription_feature that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {subscription_featureFindUniqueOrThrowArgs} args - Arguments to find a Subscription_feature
     * @example
     * // Get one Subscription_feature
     * const subscription_feature = await prisma.subscription_feature.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends subscription_featureFindUniqueOrThrowArgs>(args: SelectSubset<T, subscription_featureFindUniqueOrThrowArgs<ExtArgs>>): Prisma__subscription_featureClient<$Result.GetResult<Prisma.$subscription_featurePayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Subscription_feature that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {subscription_featureFindFirstArgs} args - Arguments to find a Subscription_feature
     * @example
     * // Get one Subscription_feature
     * const subscription_feature = await prisma.subscription_feature.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends subscription_featureFindFirstArgs>(args?: SelectSubset<T, subscription_featureFindFirstArgs<ExtArgs>>): Prisma__subscription_featureClient<$Result.GetResult<Prisma.$subscription_featurePayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Subscription_feature that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {subscription_featureFindFirstOrThrowArgs} args - Arguments to find a Subscription_feature
     * @example
     * // Get one Subscription_feature
     * const subscription_feature = await prisma.subscription_feature.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends subscription_featureFindFirstOrThrowArgs>(args?: SelectSubset<T, subscription_featureFindFirstOrThrowArgs<ExtArgs>>): Prisma__subscription_featureClient<$Result.GetResult<Prisma.$subscription_featurePayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Subscription_features that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {subscription_featureFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Subscription_features
     * const subscription_features = await prisma.subscription_feature.findMany()
     * 
     * // Get first 10 Subscription_features
     * const subscription_features = await prisma.subscription_feature.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const subscription_featureWithIdOnly = await prisma.subscription_feature.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends subscription_featureFindManyArgs>(args?: SelectSubset<T, subscription_featureFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$subscription_featurePayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Subscription_feature.
     * @param {subscription_featureCreateArgs} args - Arguments to create a Subscription_feature.
     * @example
     * // Create one Subscription_feature
     * const Subscription_feature = await prisma.subscription_feature.create({
     *   data: {
     *     // ... data to create a Subscription_feature
     *   }
     * })
     * 
     */
    create<T extends subscription_featureCreateArgs>(args: SelectSubset<T, subscription_featureCreateArgs<ExtArgs>>): Prisma__subscription_featureClient<$Result.GetResult<Prisma.$subscription_featurePayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Subscription_features.
     * @param {subscription_featureCreateManyArgs} args - Arguments to create many Subscription_features.
     * @example
     * // Create many Subscription_features
     * const subscription_feature = await prisma.subscription_feature.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends subscription_featureCreateManyArgs>(args?: SelectSubset<T, subscription_featureCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Subscription_features and returns the data saved in the database.
     * @param {subscription_featureCreateManyAndReturnArgs} args - Arguments to create many Subscription_features.
     * @example
     * // Create many Subscription_features
     * const subscription_feature = await prisma.subscription_feature.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Subscription_features and only return the `id`
     * const subscription_featureWithIdOnly = await prisma.subscription_feature.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends subscription_featureCreateManyAndReturnArgs>(args?: SelectSubset<T, subscription_featureCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$subscription_featurePayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a Subscription_feature.
     * @param {subscription_featureDeleteArgs} args - Arguments to delete one Subscription_feature.
     * @example
     * // Delete one Subscription_feature
     * const Subscription_feature = await prisma.subscription_feature.delete({
     *   where: {
     *     // ... filter to delete one Subscription_feature
     *   }
     * })
     * 
     */
    delete<T extends subscription_featureDeleteArgs>(args: SelectSubset<T, subscription_featureDeleteArgs<ExtArgs>>): Prisma__subscription_featureClient<$Result.GetResult<Prisma.$subscription_featurePayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Subscription_feature.
     * @param {subscription_featureUpdateArgs} args - Arguments to update one Subscription_feature.
     * @example
     * // Update one Subscription_feature
     * const subscription_feature = await prisma.subscription_feature.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends subscription_featureUpdateArgs>(args: SelectSubset<T, subscription_featureUpdateArgs<ExtArgs>>): Prisma__subscription_featureClient<$Result.GetResult<Prisma.$subscription_featurePayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Subscription_features.
     * @param {subscription_featureDeleteManyArgs} args - Arguments to filter Subscription_features to delete.
     * @example
     * // Delete a few Subscription_features
     * const { count } = await prisma.subscription_feature.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends subscription_featureDeleteManyArgs>(args?: SelectSubset<T, subscription_featureDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Subscription_features.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {subscription_featureUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Subscription_features
     * const subscription_feature = await prisma.subscription_feature.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends subscription_featureUpdateManyArgs>(args: SelectSubset<T, subscription_featureUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Subscription_features and returns the data updated in the database.
     * @param {subscription_featureUpdateManyAndReturnArgs} args - Arguments to update many Subscription_features.
     * @example
     * // Update many Subscription_features
     * const subscription_feature = await prisma.subscription_feature.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Subscription_features and only return the `id`
     * const subscription_featureWithIdOnly = await prisma.subscription_feature.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends subscription_featureUpdateManyAndReturnArgs>(args: SelectSubset<T, subscription_featureUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$subscription_featurePayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one Subscription_feature.
     * @param {subscription_featureUpsertArgs} args - Arguments to update or create a Subscription_feature.
     * @example
     * // Update or create a Subscription_feature
     * const subscription_feature = await prisma.subscription_feature.upsert({
     *   create: {
     *     // ... data to create a Subscription_feature
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Subscription_feature we want to update
     *   }
     * })
     */
    upsert<T extends subscription_featureUpsertArgs>(args: SelectSubset<T, subscription_featureUpsertArgs<ExtArgs>>): Prisma__subscription_featureClient<$Result.GetResult<Prisma.$subscription_featurePayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of Subscription_features.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {subscription_featureCountArgs} args - Arguments to filter Subscription_features to count.
     * @example
     * // Count the number of Subscription_features
     * const count = await prisma.subscription_feature.count({
     *   where: {
     *     // ... the filter for the Subscription_features we want to count
     *   }
     * })
    **/
    count<T extends subscription_featureCountArgs>(
      args?: Subset<T, subscription_featureCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Subscription_featureCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Subscription_feature.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Subscription_featureAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Subscription_featureAggregateArgs>(args: Subset<T, Subscription_featureAggregateArgs>): Prisma.PrismaPromise<GetSubscription_featureAggregateType<T>>

    /**
     * Group by Subscription_feature.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {subscription_featureGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends subscription_featureGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: subscription_featureGroupByArgs['orderBy'] }
        : { orderBy?: subscription_featureGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, subscription_featureGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetSubscription_featureGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the subscription_feature model
   */
  readonly fields: subscription_featureFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for subscription_feature.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__subscription_featureClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    subscricption_package<T extends subscriptionDefaultArgs<ExtArgs> = {}>(args?: Subset<T, subscriptionDefaultArgs<ExtArgs>>): Prisma__subscriptionClient<$Result.GetResult<Prisma.$subscriptionPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    features<T extends permissions_listDefaultArgs<ExtArgs> = {}>(args?: Subset<T, permissions_listDefaultArgs<ExtArgs>>): Prisma__permissions_listClient<$Result.GetResult<Prisma.$permissions_listPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the subscription_feature model
   */ 
  interface subscription_featureFieldRefs {
    readonly id: FieldRef<"subscription_feature", 'Int'>
    readonly status: FieldRef<"subscription_feature", 'Int'>
    readonly subscription_id: FieldRef<"subscription_feature", 'Int'>
    readonly permission_id: FieldRef<"subscription_feature", 'Int'>
    readonly limit: FieldRef<"subscription_feature", 'Int'>
    readonly created_at: FieldRef<"subscription_feature", 'DateTime'>
    readonly updated_at: FieldRef<"subscription_feature", 'DateTime'>
    readonly deleted_at: FieldRef<"subscription_feature", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * subscription_feature findUnique
   */
  export type subscription_featureFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription_feature
     */
    select?: subscription_featureSelect<ExtArgs> | null
    /**
     * Omit specific fields from the subscription_feature
     */
    omit?: subscription_featureOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscription_featureInclude<ExtArgs> | null
    /**
     * Filter, which subscription_feature to fetch.
     */
    where: subscription_featureWhereUniqueInput
  }

  /**
   * subscription_feature findUniqueOrThrow
   */
  export type subscription_featureFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription_feature
     */
    select?: subscription_featureSelect<ExtArgs> | null
    /**
     * Omit specific fields from the subscription_feature
     */
    omit?: subscription_featureOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscription_featureInclude<ExtArgs> | null
    /**
     * Filter, which subscription_feature to fetch.
     */
    where: subscription_featureWhereUniqueInput
  }

  /**
   * subscription_feature findFirst
   */
  export type subscription_featureFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription_feature
     */
    select?: subscription_featureSelect<ExtArgs> | null
    /**
     * Omit specific fields from the subscription_feature
     */
    omit?: subscription_featureOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscription_featureInclude<ExtArgs> | null
    /**
     * Filter, which subscription_feature to fetch.
     */
    where?: subscription_featureWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of subscription_features to fetch.
     */
    orderBy?: subscription_featureOrderByWithRelationInput | subscription_featureOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for subscription_features.
     */
    cursor?: subscription_featureWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` subscription_features from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` subscription_features.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of subscription_features.
     */
    distinct?: Subscription_featureScalarFieldEnum | Subscription_featureScalarFieldEnum[]
  }

  /**
   * subscription_feature findFirstOrThrow
   */
  export type subscription_featureFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription_feature
     */
    select?: subscription_featureSelect<ExtArgs> | null
    /**
     * Omit specific fields from the subscription_feature
     */
    omit?: subscription_featureOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscription_featureInclude<ExtArgs> | null
    /**
     * Filter, which subscription_feature to fetch.
     */
    where?: subscription_featureWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of subscription_features to fetch.
     */
    orderBy?: subscription_featureOrderByWithRelationInput | subscription_featureOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for subscription_features.
     */
    cursor?: subscription_featureWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` subscription_features from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` subscription_features.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of subscription_features.
     */
    distinct?: Subscription_featureScalarFieldEnum | Subscription_featureScalarFieldEnum[]
  }

  /**
   * subscription_feature findMany
   */
  export type subscription_featureFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription_feature
     */
    select?: subscription_featureSelect<ExtArgs> | null
    /**
     * Omit specific fields from the subscription_feature
     */
    omit?: subscription_featureOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscription_featureInclude<ExtArgs> | null
    /**
     * Filter, which subscription_features to fetch.
     */
    where?: subscription_featureWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of subscription_features to fetch.
     */
    orderBy?: subscription_featureOrderByWithRelationInput | subscription_featureOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing subscription_features.
     */
    cursor?: subscription_featureWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` subscription_features from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` subscription_features.
     */
    skip?: number
    distinct?: Subscription_featureScalarFieldEnum | Subscription_featureScalarFieldEnum[]
  }

  /**
   * subscription_feature create
   */
  export type subscription_featureCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription_feature
     */
    select?: subscription_featureSelect<ExtArgs> | null
    /**
     * Omit specific fields from the subscription_feature
     */
    omit?: subscription_featureOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscription_featureInclude<ExtArgs> | null
    /**
     * The data needed to create a subscription_feature.
     */
    data: XOR<subscription_featureCreateInput, subscription_featureUncheckedCreateInput>
  }

  /**
   * subscription_feature createMany
   */
  export type subscription_featureCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many subscription_features.
     */
    data: subscription_featureCreateManyInput | subscription_featureCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * subscription_feature createManyAndReturn
   */
  export type subscription_featureCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription_feature
     */
    select?: subscription_featureSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the subscription_feature
     */
    omit?: subscription_featureOmit<ExtArgs> | null
    /**
     * The data used to create many subscription_features.
     */
    data: subscription_featureCreateManyInput | subscription_featureCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscription_featureIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * subscription_feature update
   */
  export type subscription_featureUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription_feature
     */
    select?: subscription_featureSelect<ExtArgs> | null
    /**
     * Omit specific fields from the subscription_feature
     */
    omit?: subscription_featureOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscription_featureInclude<ExtArgs> | null
    /**
     * The data needed to update a subscription_feature.
     */
    data: XOR<subscription_featureUpdateInput, subscription_featureUncheckedUpdateInput>
    /**
     * Choose, which subscription_feature to update.
     */
    where: subscription_featureWhereUniqueInput
  }

  /**
   * subscription_feature updateMany
   */
  export type subscription_featureUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update subscription_features.
     */
    data: XOR<subscription_featureUpdateManyMutationInput, subscription_featureUncheckedUpdateManyInput>
    /**
     * Filter which subscription_features to update
     */
    where?: subscription_featureWhereInput
    /**
     * Limit how many subscription_features to update.
     */
    limit?: number
  }

  /**
   * subscription_feature updateManyAndReturn
   */
  export type subscription_featureUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription_feature
     */
    select?: subscription_featureSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the subscription_feature
     */
    omit?: subscription_featureOmit<ExtArgs> | null
    /**
     * The data used to update subscription_features.
     */
    data: XOR<subscription_featureUpdateManyMutationInput, subscription_featureUncheckedUpdateManyInput>
    /**
     * Filter which subscription_features to update
     */
    where?: subscription_featureWhereInput
    /**
     * Limit how many subscription_features to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscription_featureIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * subscription_feature upsert
   */
  export type subscription_featureUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription_feature
     */
    select?: subscription_featureSelect<ExtArgs> | null
    /**
     * Omit specific fields from the subscription_feature
     */
    omit?: subscription_featureOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscription_featureInclude<ExtArgs> | null
    /**
     * The filter to search for the subscription_feature to update in case it exists.
     */
    where: subscription_featureWhereUniqueInput
    /**
     * In case the subscription_feature found by the `where` argument doesn't exist, create a new subscription_feature with this data.
     */
    create: XOR<subscription_featureCreateInput, subscription_featureUncheckedCreateInput>
    /**
     * In case the subscription_feature was found with the provided `where` argument, update it with this data.
     */
    update: XOR<subscription_featureUpdateInput, subscription_featureUncheckedUpdateInput>
  }

  /**
   * subscription_feature delete
   */
  export type subscription_featureDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription_feature
     */
    select?: subscription_featureSelect<ExtArgs> | null
    /**
     * Omit specific fields from the subscription_feature
     */
    omit?: subscription_featureOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscription_featureInclude<ExtArgs> | null
    /**
     * Filter which subscription_feature to delete.
     */
    where: subscription_featureWhereUniqueInput
  }

  /**
   * subscription_feature deleteMany
   */
  export type subscription_featureDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which subscription_features to delete
     */
    where?: subscription_featureWhereInput
    /**
     * Limit how many subscription_features to delete.
     */
    limit?: number
  }

  /**
   * subscription_feature without action
   */
  export type subscription_featureDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the subscription_feature
     */
    select?: subscription_featureSelect<ExtArgs> | null
    /**
     * Omit specific fields from the subscription_feature
     */
    omit?: subscription_featureOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: subscription_featureInclude<ExtArgs> | null
  }


  /**
   * Model user_subscription
   */

  export type AggregateUser_subscription = {
    _count: User_subscriptionCountAggregateOutputType | null
    _avg: User_subscriptionAvgAggregateOutputType | null
    _sum: User_subscriptionSumAggregateOutputType | null
    _min: User_subscriptionMinAggregateOutputType | null
    _max: User_subscriptionMaxAggregateOutputType | null
  }

  export type User_subscriptionAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
    created_by_id: number | null
    subscription_id: number | null
  }

  export type User_subscriptionSumAggregateOutputType = {
    id: number | null
    user_id: number | null
    created_by_id: number | null
    subscription_id: number | null
  }

  export type User_subscriptionMinAggregateOutputType = {
    id: number | null
    user_id: number | null
    created_by_id: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    subscription_id: number | null
  }

  export type User_subscriptionMaxAggregateOutputType = {
    id: number | null
    user_id: number | null
    created_by_id: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    subscription_id: number | null
  }

  export type User_subscriptionCountAggregateOutputType = {
    id: number
    user_id: number
    created_by_id: number
    created_at: number
    updated_at: number
    deleted_at: number
    subscription_id: number
    _all: number
  }


  export type User_subscriptionAvgAggregateInputType = {
    id?: true
    user_id?: true
    created_by_id?: true
    subscription_id?: true
  }

  export type User_subscriptionSumAggregateInputType = {
    id?: true
    user_id?: true
    created_by_id?: true
    subscription_id?: true
  }

  export type User_subscriptionMinAggregateInputType = {
    id?: true
    user_id?: true
    created_by_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    subscription_id?: true
  }

  export type User_subscriptionMaxAggregateInputType = {
    id?: true
    user_id?: true
    created_by_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    subscription_id?: true
  }

  export type User_subscriptionCountAggregateInputType = {
    id?: true
    user_id?: true
    created_by_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    subscription_id?: true
    _all?: true
  }

  export type User_subscriptionAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which user_subscription to aggregate.
     */
    where?: user_subscriptionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of user_subscriptions to fetch.
     */
    orderBy?: user_subscriptionOrderByWithRelationInput | user_subscriptionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: user_subscriptionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` user_subscriptions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` user_subscriptions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned user_subscriptions
    **/
    _count?: true | User_subscriptionCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: User_subscriptionAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: User_subscriptionSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: User_subscriptionMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: User_subscriptionMaxAggregateInputType
  }

  export type GetUser_subscriptionAggregateType<T extends User_subscriptionAggregateArgs> = {
        [P in keyof T & keyof AggregateUser_subscription]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUser_subscription[P]>
      : GetScalarType<T[P], AggregateUser_subscription[P]>
  }




  export type user_subscriptionGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: user_subscriptionWhereInput
    orderBy?: user_subscriptionOrderByWithAggregationInput | user_subscriptionOrderByWithAggregationInput[]
    by: User_subscriptionScalarFieldEnum[] | User_subscriptionScalarFieldEnum
    having?: user_subscriptionScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: User_subscriptionCountAggregateInputType | true
    _avg?: User_subscriptionAvgAggregateInputType
    _sum?: User_subscriptionSumAggregateInputType
    _min?: User_subscriptionMinAggregateInputType
    _max?: User_subscriptionMaxAggregateInputType
  }

  export type User_subscriptionGroupByOutputType = {
    id: number
    user_id: number
    created_by_id: number
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    subscription_id: number
    _count: User_subscriptionCountAggregateOutputType | null
    _avg: User_subscriptionAvgAggregateOutputType | null
    _sum: User_subscriptionSumAggregateOutputType | null
    _min: User_subscriptionMinAggregateOutputType | null
    _max: User_subscriptionMaxAggregateOutputType | null
  }

  type GetUser_subscriptionGroupByPayload<T extends user_subscriptionGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<User_subscriptionGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof User_subscriptionGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], User_subscriptionGroupByOutputType[P]>
            : GetScalarType<T[P], User_subscriptionGroupByOutputType[P]>
        }
      >
    >


  export type user_subscriptionSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    created_by_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    subscription_id?: boolean
    usersubscriptions?: boolean | subscriptionDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["user_subscription"]>

  export type user_subscriptionSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    created_by_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    subscription_id?: boolean
    usersubscriptions?: boolean | subscriptionDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["user_subscription"]>

  export type user_subscriptionSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    created_by_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    subscription_id?: boolean
    usersubscriptions?: boolean | subscriptionDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["user_subscription"]>

  export type user_subscriptionSelectScalar = {
    id?: boolean
    user_id?: boolean
    created_by_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    subscription_id?: boolean
  }

  export type user_subscriptionOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "user_id" | "created_by_id" | "created_at" | "updated_at" | "deleted_at" | "subscription_id", ExtArgs["result"]["user_subscription"]>
  export type user_subscriptionInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    usersubscriptions?: boolean | subscriptionDefaultArgs<ExtArgs>
  }
  export type user_subscriptionIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    usersubscriptions?: boolean | subscriptionDefaultArgs<ExtArgs>
  }
  export type user_subscriptionIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    usersubscriptions?: boolean | subscriptionDefaultArgs<ExtArgs>
  }

  export type $user_subscriptionPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "user_subscription"
    objects: {
      usersubscriptions: Prisma.$subscriptionPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      user_id: number
      created_by_id: number
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
      subscription_id: number
    }, ExtArgs["result"]["user_subscription"]>
    composites: {}
  }

  type user_subscriptionGetPayload<S extends boolean | null | undefined | user_subscriptionDefaultArgs> = $Result.GetResult<Prisma.$user_subscriptionPayload, S>

  type user_subscriptionCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<user_subscriptionFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: User_subscriptionCountAggregateInputType | true
    }

  export interface user_subscriptionDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['user_subscription'], meta: { name: 'user_subscription' } }
    /**
     * Find zero or one User_subscription that matches the filter.
     * @param {user_subscriptionFindUniqueArgs} args - Arguments to find a User_subscription
     * @example
     * // Get one User_subscription
     * const user_subscription = await prisma.user_subscription.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends user_subscriptionFindUniqueArgs>(args: SelectSubset<T, user_subscriptionFindUniqueArgs<ExtArgs>>): Prisma__user_subscriptionClient<$Result.GetResult<Prisma.$user_subscriptionPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one User_subscription that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {user_subscriptionFindUniqueOrThrowArgs} args - Arguments to find a User_subscription
     * @example
     * // Get one User_subscription
     * const user_subscription = await prisma.user_subscription.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends user_subscriptionFindUniqueOrThrowArgs>(args: SelectSubset<T, user_subscriptionFindUniqueOrThrowArgs<ExtArgs>>): Prisma__user_subscriptionClient<$Result.GetResult<Prisma.$user_subscriptionPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first User_subscription that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {user_subscriptionFindFirstArgs} args - Arguments to find a User_subscription
     * @example
     * // Get one User_subscription
     * const user_subscription = await prisma.user_subscription.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends user_subscriptionFindFirstArgs>(args?: SelectSubset<T, user_subscriptionFindFirstArgs<ExtArgs>>): Prisma__user_subscriptionClient<$Result.GetResult<Prisma.$user_subscriptionPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first User_subscription that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {user_subscriptionFindFirstOrThrowArgs} args - Arguments to find a User_subscription
     * @example
     * // Get one User_subscription
     * const user_subscription = await prisma.user_subscription.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends user_subscriptionFindFirstOrThrowArgs>(args?: SelectSubset<T, user_subscriptionFindFirstOrThrowArgs<ExtArgs>>): Prisma__user_subscriptionClient<$Result.GetResult<Prisma.$user_subscriptionPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more User_subscriptions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {user_subscriptionFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all User_subscriptions
     * const user_subscriptions = await prisma.user_subscription.findMany()
     * 
     * // Get first 10 User_subscriptions
     * const user_subscriptions = await prisma.user_subscription.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const user_subscriptionWithIdOnly = await prisma.user_subscription.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends user_subscriptionFindManyArgs>(args?: SelectSubset<T, user_subscriptionFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$user_subscriptionPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a User_subscription.
     * @param {user_subscriptionCreateArgs} args - Arguments to create a User_subscription.
     * @example
     * // Create one User_subscription
     * const User_subscription = await prisma.user_subscription.create({
     *   data: {
     *     // ... data to create a User_subscription
     *   }
     * })
     * 
     */
    create<T extends user_subscriptionCreateArgs>(args: SelectSubset<T, user_subscriptionCreateArgs<ExtArgs>>): Prisma__user_subscriptionClient<$Result.GetResult<Prisma.$user_subscriptionPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many User_subscriptions.
     * @param {user_subscriptionCreateManyArgs} args - Arguments to create many User_subscriptions.
     * @example
     * // Create many User_subscriptions
     * const user_subscription = await prisma.user_subscription.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends user_subscriptionCreateManyArgs>(args?: SelectSubset<T, user_subscriptionCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many User_subscriptions and returns the data saved in the database.
     * @param {user_subscriptionCreateManyAndReturnArgs} args - Arguments to create many User_subscriptions.
     * @example
     * // Create many User_subscriptions
     * const user_subscription = await prisma.user_subscription.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many User_subscriptions and only return the `id`
     * const user_subscriptionWithIdOnly = await prisma.user_subscription.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends user_subscriptionCreateManyAndReturnArgs>(args?: SelectSubset<T, user_subscriptionCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$user_subscriptionPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a User_subscription.
     * @param {user_subscriptionDeleteArgs} args - Arguments to delete one User_subscription.
     * @example
     * // Delete one User_subscription
     * const User_subscription = await prisma.user_subscription.delete({
     *   where: {
     *     // ... filter to delete one User_subscription
     *   }
     * })
     * 
     */
    delete<T extends user_subscriptionDeleteArgs>(args: SelectSubset<T, user_subscriptionDeleteArgs<ExtArgs>>): Prisma__user_subscriptionClient<$Result.GetResult<Prisma.$user_subscriptionPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one User_subscription.
     * @param {user_subscriptionUpdateArgs} args - Arguments to update one User_subscription.
     * @example
     * // Update one User_subscription
     * const user_subscription = await prisma.user_subscription.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends user_subscriptionUpdateArgs>(args: SelectSubset<T, user_subscriptionUpdateArgs<ExtArgs>>): Prisma__user_subscriptionClient<$Result.GetResult<Prisma.$user_subscriptionPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more User_subscriptions.
     * @param {user_subscriptionDeleteManyArgs} args - Arguments to filter User_subscriptions to delete.
     * @example
     * // Delete a few User_subscriptions
     * const { count } = await prisma.user_subscription.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends user_subscriptionDeleteManyArgs>(args?: SelectSubset<T, user_subscriptionDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more User_subscriptions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {user_subscriptionUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many User_subscriptions
     * const user_subscription = await prisma.user_subscription.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends user_subscriptionUpdateManyArgs>(args: SelectSubset<T, user_subscriptionUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more User_subscriptions and returns the data updated in the database.
     * @param {user_subscriptionUpdateManyAndReturnArgs} args - Arguments to update many User_subscriptions.
     * @example
     * // Update many User_subscriptions
     * const user_subscription = await prisma.user_subscription.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more User_subscriptions and only return the `id`
     * const user_subscriptionWithIdOnly = await prisma.user_subscription.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends user_subscriptionUpdateManyAndReturnArgs>(args: SelectSubset<T, user_subscriptionUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$user_subscriptionPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one User_subscription.
     * @param {user_subscriptionUpsertArgs} args - Arguments to update or create a User_subscription.
     * @example
     * // Update or create a User_subscription
     * const user_subscription = await prisma.user_subscription.upsert({
     *   create: {
     *     // ... data to create a User_subscription
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the User_subscription we want to update
     *   }
     * })
     */
    upsert<T extends user_subscriptionUpsertArgs>(args: SelectSubset<T, user_subscriptionUpsertArgs<ExtArgs>>): Prisma__user_subscriptionClient<$Result.GetResult<Prisma.$user_subscriptionPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of User_subscriptions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {user_subscriptionCountArgs} args - Arguments to filter User_subscriptions to count.
     * @example
     * // Count the number of User_subscriptions
     * const count = await prisma.user_subscription.count({
     *   where: {
     *     // ... the filter for the User_subscriptions we want to count
     *   }
     * })
    **/
    count<T extends user_subscriptionCountArgs>(
      args?: Subset<T, user_subscriptionCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], User_subscriptionCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a User_subscription.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {User_subscriptionAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends User_subscriptionAggregateArgs>(args: Subset<T, User_subscriptionAggregateArgs>): Prisma.PrismaPromise<GetUser_subscriptionAggregateType<T>>

    /**
     * Group by User_subscription.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {user_subscriptionGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends user_subscriptionGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: user_subscriptionGroupByArgs['orderBy'] }
        : { orderBy?: user_subscriptionGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, user_subscriptionGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUser_subscriptionGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the user_subscription model
   */
  readonly fields: user_subscriptionFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for user_subscription.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__user_subscriptionClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    usersubscriptions<T extends subscriptionDefaultArgs<ExtArgs> = {}>(args?: Subset<T, subscriptionDefaultArgs<ExtArgs>>): Prisma__subscriptionClient<$Result.GetResult<Prisma.$subscriptionPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the user_subscription model
   */ 
  interface user_subscriptionFieldRefs {
    readonly id: FieldRef<"user_subscription", 'Int'>
    readonly user_id: FieldRef<"user_subscription", 'Int'>
    readonly created_by_id: FieldRef<"user_subscription", 'Int'>
    readonly created_at: FieldRef<"user_subscription", 'DateTime'>
    readonly updated_at: FieldRef<"user_subscription", 'DateTime'>
    readonly deleted_at: FieldRef<"user_subscription", 'DateTime'>
    readonly subscription_id: FieldRef<"user_subscription", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * user_subscription findUnique
   */
  export type user_subscriptionFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_subscription
     */
    select?: user_subscriptionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user_subscription
     */
    omit?: user_subscriptionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_subscriptionInclude<ExtArgs> | null
    /**
     * Filter, which user_subscription to fetch.
     */
    where: user_subscriptionWhereUniqueInput
  }

  /**
   * user_subscription findUniqueOrThrow
   */
  export type user_subscriptionFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_subscription
     */
    select?: user_subscriptionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user_subscription
     */
    omit?: user_subscriptionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_subscriptionInclude<ExtArgs> | null
    /**
     * Filter, which user_subscription to fetch.
     */
    where: user_subscriptionWhereUniqueInput
  }

  /**
   * user_subscription findFirst
   */
  export type user_subscriptionFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_subscription
     */
    select?: user_subscriptionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user_subscription
     */
    omit?: user_subscriptionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_subscriptionInclude<ExtArgs> | null
    /**
     * Filter, which user_subscription to fetch.
     */
    where?: user_subscriptionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of user_subscriptions to fetch.
     */
    orderBy?: user_subscriptionOrderByWithRelationInput | user_subscriptionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for user_subscriptions.
     */
    cursor?: user_subscriptionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` user_subscriptions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` user_subscriptions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of user_subscriptions.
     */
    distinct?: User_subscriptionScalarFieldEnum | User_subscriptionScalarFieldEnum[]
  }

  /**
   * user_subscription findFirstOrThrow
   */
  export type user_subscriptionFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_subscription
     */
    select?: user_subscriptionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user_subscription
     */
    omit?: user_subscriptionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_subscriptionInclude<ExtArgs> | null
    /**
     * Filter, which user_subscription to fetch.
     */
    where?: user_subscriptionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of user_subscriptions to fetch.
     */
    orderBy?: user_subscriptionOrderByWithRelationInput | user_subscriptionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for user_subscriptions.
     */
    cursor?: user_subscriptionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` user_subscriptions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` user_subscriptions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of user_subscriptions.
     */
    distinct?: User_subscriptionScalarFieldEnum | User_subscriptionScalarFieldEnum[]
  }

  /**
   * user_subscription findMany
   */
  export type user_subscriptionFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_subscription
     */
    select?: user_subscriptionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user_subscription
     */
    omit?: user_subscriptionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_subscriptionInclude<ExtArgs> | null
    /**
     * Filter, which user_subscriptions to fetch.
     */
    where?: user_subscriptionWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of user_subscriptions to fetch.
     */
    orderBy?: user_subscriptionOrderByWithRelationInput | user_subscriptionOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing user_subscriptions.
     */
    cursor?: user_subscriptionWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` user_subscriptions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` user_subscriptions.
     */
    skip?: number
    distinct?: User_subscriptionScalarFieldEnum | User_subscriptionScalarFieldEnum[]
  }

  /**
   * user_subscription create
   */
  export type user_subscriptionCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_subscription
     */
    select?: user_subscriptionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user_subscription
     */
    omit?: user_subscriptionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_subscriptionInclude<ExtArgs> | null
    /**
     * The data needed to create a user_subscription.
     */
    data: XOR<user_subscriptionCreateInput, user_subscriptionUncheckedCreateInput>
  }

  /**
   * user_subscription createMany
   */
  export type user_subscriptionCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many user_subscriptions.
     */
    data: user_subscriptionCreateManyInput | user_subscriptionCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * user_subscription createManyAndReturn
   */
  export type user_subscriptionCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_subscription
     */
    select?: user_subscriptionSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the user_subscription
     */
    omit?: user_subscriptionOmit<ExtArgs> | null
    /**
     * The data used to create many user_subscriptions.
     */
    data: user_subscriptionCreateManyInput | user_subscriptionCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_subscriptionIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * user_subscription update
   */
  export type user_subscriptionUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_subscription
     */
    select?: user_subscriptionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user_subscription
     */
    omit?: user_subscriptionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_subscriptionInclude<ExtArgs> | null
    /**
     * The data needed to update a user_subscription.
     */
    data: XOR<user_subscriptionUpdateInput, user_subscriptionUncheckedUpdateInput>
    /**
     * Choose, which user_subscription to update.
     */
    where: user_subscriptionWhereUniqueInput
  }

  /**
   * user_subscription updateMany
   */
  export type user_subscriptionUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update user_subscriptions.
     */
    data: XOR<user_subscriptionUpdateManyMutationInput, user_subscriptionUncheckedUpdateManyInput>
    /**
     * Filter which user_subscriptions to update
     */
    where?: user_subscriptionWhereInput
    /**
     * Limit how many user_subscriptions to update.
     */
    limit?: number
  }

  /**
   * user_subscription updateManyAndReturn
   */
  export type user_subscriptionUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_subscription
     */
    select?: user_subscriptionSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the user_subscription
     */
    omit?: user_subscriptionOmit<ExtArgs> | null
    /**
     * The data used to update user_subscriptions.
     */
    data: XOR<user_subscriptionUpdateManyMutationInput, user_subscriptionUncheckedUpdateManyInput>
    /**
     * Filter which user_subscriptions to update
     */
    where?: user_subscriptionWhereInput
    /**
     * Limit how many user_subscriptions to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_subscriptionIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * user_subscription upsert
   */
  export type user_subscriptionUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_subscription
     */
    select?: user_subscriptionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user_subscription
     */
    omit?: user_subscriptionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_subscriptionInclude<ExtArgs> | null
    /**
     * The filter to search for the user_subscription to update in case it exists.
     */
    where: user_subscriptionWhereUniqueInput
    /**
     * In case the user_subscription found by the `where` argument doesn't exist, create a new user_subscription with this data.
     */
    create: XOR<user_subscriptionCreateInput, user_subscriptionUncheckedCreateInput>
    /**
     * In case the user_subscription was found with the provided `where` argument, update it with this data.
     */
    update: XOR<user_subscriptionUpdateInput, user_subscriptionUncheckedUpdateInput>
  }

  /**
   * user_subscription delete
   */
  export type user_subscriptionDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_subscription
     */
    select?: user_subscriptionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user_subscription
     */
    omit?: user_subscriptionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_subscriptionInclude<ExtArgs> | null
    /**
     * Filter which user_subscription to delete.
     */
    where: user_subscriptionWhereUniqueInput
  }

  /**
   * user_subscription deleteMany
   */
  export type user_subscriptionDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which user_subscriptions to delete
     */
    where?: user_subscriptionWhereInput
    /**
     * Limit how many user_subscriptions to delete.
     */
    limit?: number
  }

  /**
   * user_subscription without action
   */
  export type user_subscriptionDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_subscription
     */
    select?: user_subscriptionSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user_subscription
     */
    omit?: user_subscriptionOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_subscriptionInclude<ExtArgs> | null
  }


  /**
   * Model user_permissions
   */

  export type AggregateUser_permissions = {
    _count: User_permissionsCountAggregateOutputType | null
    _avg: User_permissionsAvgAggregateOutputType | null
    _sum: User_permissionsSumAggregateOutputType | null
    _min: User_permissionsMinAggregateOutputType | null
    _max: User_permissionsMaxAggregateOutputType | null
  }

  export type User_permissionsAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
    limit: number | null
    permission_id: number | null
  }

  export type User_permissionsSumAggregateOutputType = {
    id: number | null
    user_id: number | null
    limit: number | null
    permission_id: number | null
  }

  export type User_permissionsMinAggregateOutputType = {
    id: number | null
    user_id: number | null
    limit: number | null
    permission_id: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type User_permissionsMaxAggregateOutputType = {
    id: number | null
    user_id: number | null
    limit: number | null
    permission_id: number | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
  }

  export type User_permissionsCountAggregateOutputType = {
    id: number
    user_id: number
    limit: number
    permission_id: number
    created_at: number
    updated_at: number
    deleted_at: number
    _all: number
  }


  export type User_permissionsAvgAggregateInputType = {
    id?: true
    user_id?: true
    limit?: true
    permission_id?: true
  }

  export type User_permissionsSumAggregateInputType = {
    id?: true
    user_id?: true
    limit?: true
    permission_id?: true
  }

  export type User_permissionsMinAggregateInputType = {
    id?: true
    user_id?: true
    limit?: true
    permission_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type User_permissionsMaxAggregateInputType = {
    id?: true
    user_id?: true
    limit?: true
    permission_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
  }

  export type User_permissionsCountAggregateInputType = {
    id?: true
    user_id?: true
    limit?: true
    permission_id?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    _all?: true
  }

  export type User_permissionsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which user_permissions to aggregate.
     */
    where?: user_permissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of user_permissions to fetch.
     */
    orderBy?: user_permissionsOrderByWithRelationInput | user_permissionsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: user_permissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` user_permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` user_permissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned user_permissions
    **/
    _count?: true | User_permissionsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: User_permissionsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: User_permissionsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: User_permissionsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: User_permissionsMaxAggregateInputType
  }

  export type GetUser_permissionsAggregateType<T extends User_permissionsAggregateArgs> = {
        [P in keyof T & keyof AggregateUser_permissions]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUser_permissions[P]>
      : GetScalarType<T[P], AggregateUser_permissions[P]>
  }




  export type user_permissionsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: user_permissionsWhereInput
    orderBy?: user_permissionsOrderByWithAggregationInput | user_permissionsOrderByWithAggregationInput[]
    by: User_permissionsScalarFieldEnum[] | User_permissionsScalarFieldEnum
    having?: user_permissionsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: User_permissionsCountAggregateInputType | true
    _avg?: User_permissionsAvgAggregateInputType
    _sum?: User_permissionsSumAggregateInputType
    _min?: User_permissionsMinAggregateInputType
    _max?: User_permissionsMaxAggregateInputType
  }

  export type User_permissionsGroupByOutputType = {
    id: number
    user_id: number
    limit: number | null
    permission_id: number
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    _count: User_permissionsCountAggregateOutputType | null
    _avg: User_permissionsAvgAggregateOutputType | null
    _sum: User_permissionsSumAggregateOutputType | null
    _min: User_permissionsMinAggregateOutputType | null
    _max: User_permissionsMaxAggregateOutputType | null
  }

  type GetUser_permissionsGroupByPayload<T extends user_permissionsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<User_permissionsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof User_permissionsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], User_permissionsGroupByOutputType[P]>
            : GetScalarType<T[P], User_permissionsGroupByOutputType[P]>
        }
      >
    >


  export type user_permissionsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    limit?: boolean
    permission_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    userPermission?: boolean | permissions_listDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["user_permissions"]>

  export type user_permissionsSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    limit?: boolean
    permission_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    userPermission?: boolean | permissions_listDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["user_permissions"]>

  export type user_permissionsSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    limit?: boolean
    permission_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    userPermission?: boolean | permissions_listDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["user_permissions"]>

  export type user_permissionsSelectScalar = {
    id?: boolean
    user_id?: boolean
    limit?: boolean
    permission_id?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
  }

  export type user_permissionsOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "user_id" | "limit" | "permission_id" | "created_at" | "updated_at" | "deleted_at", ExtArgs["result"]["user_permissions"]>
  export type user_permissionsInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    userPermission?: boolean | permissions_listDefaultArgs<ExtArgs>
  }
  export type user_permissionsIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    userPermission?: boolean | permissions_listDefaultArgs<ExtArgs>
  }
  export type user_permissionsIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    userPermission?: boolean | permissions_listDefaultArgs<ExtArgs>
  }

  export type $user_permissionsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "user_permissions"
    objects: {
      userPermission: Prisma.$permissions_listPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      user_id: number
      limit: number | null
      permission_id: number
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
    }, ExtArgs["result"]["user_permissions"]>
    composites: {}
  }

  type user_permissionsGetPayload<S extends boolean | null | undefined | user_permissionsDefaultArgs> = $Result.GetResult<Prisma.$user_permissionsPayload, S>

  type user_permissionsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<user_permissionsFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: User_permissionsCountAggregateInputType | true
    }

  export interface user_permissionsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['user_permissions'], meta: { name: 'user_permissions' } }
    /**
     * Find zero or one User_permissions that matches the filter.
     * @param {user_permissionsFindUniqueArgs} args - Arguments to find a User_permissions
     * @example
     * // Get one User_permissions
     * const user_permissions = await prisma.user_permissions.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends user_permissionsFindUniqueArgs>(args: SelectSubset<T, user_permissionsFindUniqueArgs<ExtArgs>>): Prisma__user_permissionsClient<$Result.GetResult<Prisma.$user_permissionsPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one User_permissions that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {user_permissionsFindUniqueOrThrowArgs} args - Arguments to find a User_permissions
     * @example
     * // Get one User_permissions
     * const user_permissions = await prisma.user_permissions.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends user_permissionsFindUniqueOrThrowArgs>(args: SelectSubset<T, user_permissionsFindUniqueOrThrowArgs<ExtArgs>>): Prisma__user_permissionsClient<$Result.GetResult<Prisma.$user_permissionsPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first User_permissions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {user_permissionsFindFirstArgs} args - Arguments to find a User_permissions
     * @example
     * // Get one User_permissions
     * const user_permissions = await prisma.user_permissions.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends user_permissionsFindFirstArgs>(args?: SelectSubset<T, user_permissionsFindFirstArgs<ExtArgs>>): Prisma__user_permissionsClient<$Result.GetResult<Prisma.$user_permissionsPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first User_permissions that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {user_permissionsFindFirstOrThrowArgs} args - Arguments to find a User_permissions
     * @example
     * // Get one User_permissions
     * const user_permissions = await prisma.user_permissions.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends user_permissionsFindFirstOrThrowArgs>(args?: SelectSubset<T, user_permissionsFindFirstOrThrowArgs<ExtArgs>>): Prisma__user_permissionsClient<$Result.GetResult<Prisma.$user_permissionsPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more User_permissions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {user_permissionsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all User_permissions
     * const user_permissions = await prisma.user_permissions.findMany()
     * 
     * // Get first 10 User_permissions
     * const user_permissions = await prisma.user_permissions.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const user_permissionsWithIdOnly = await prisma.user_permissions.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends user_permissionsFindManyArgs>(args?: SelectSubset<T, user_permissionsFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$user_permissionsPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a User_permissions.
     * @param {user_permissionsCreateArgs} args - Arguments to create a User_permissions.
     * @example
     * // Create one User_permissions
     * const User_permissions = await prisma.user_permissions.create({
     *   data: {
     *     // ... data to create a User_permissions
     *   }
     * })
     * 
     */
    create<T extends user_permissionsCreateArgs>(args: SelectSubset<T, user_permissionsCreateArgs<ExtArgs>>): Prisma__user_permissionsClient<$Result.GetResult<Prisma.$user_permissionsPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many User_permissions.
     * @param {user_permissionsCreateManyArgs} args - Arguments to create many User_permissions.
     * @example
     * // Create many User_permissions
     * const user_permissions = await prisma.user_permissions.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends user_permissionsCreateManyArgs>(args?: SelectSubset<T, user_permissionsCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many User_permissions and returns the data saved in the database.
     * @param {user_permissionsCreateManyAndReturnArgs} args - Arguments to create many User_permissions.
     * @example
     * // Create many User_permissions
     * const user_permissions = await prisma.user_permissions.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many User_permissions and only return the `id`
     * const user_permissionsWithIdOnly = await prisma.user_permissions.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends user_permissionsCreateManyAndReturnArgs>(args?: SelectSubset<T, user_permissionsCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$user_permissionsPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a User_permissions.
     * @param {user_permissionsDeleteArgs} args - Arguments to delete one User_permissions.
     * @example
     * // Delete one User_permissions
     * const User_permissions = await prisma.user_permissions.delete({
     *   where: {
     *     // ... filter to delete one User_permissions
     *   }
     * })
     * 
     */
    delete<T extends user_permissionsDeleteArgs>(args: SelectSubset<T, user_permissionsDeleteArgs<ExtArgs>>): Prisma__user_permissionsClient<$Result.GetResult<Prisma.$user_permissionsPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one User_permissions.
     * @param {user_permissionsUpdateArgs} args - Arguments to update one User_permissions.
     * @example
     * // Update one User_permissions
     * const user_permissions = await prisma.user_permissions.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends user_permissionsUpdateArgs>(args: SelectSubset<T, user_permissionsUpdateArgs<ExtArgs>>): Prisma__user_permissionsClient<$Result.GetResult<Prisma.$user_permissionsPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more User_permissions.
     * @param {user_permissionsDeleteManyArgs} args - Arguments to filter User_permissions to delete.
     * @example
     * // Delete a few User_permissions
     * const { count } = await prisma.user_permissions.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends user_permissionsDeleteManyArgs>(args?: SelectSubset<T, user_permissionsDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more User_permissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {user_permissionsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many User_permissions
     * const user_permissions = await prisma.user_permissions.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends user_permissionsUpdateManyArgs>(args: SelectSubset<T, user_permissionsUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more User_permissions and returns the data updated in the database.
     * @param {user_permissionsUpdateManyAndReturnArgs} args - Arguments to update many User_permissions.
     * @example
     * // Update many User_permissions
     * const user_permissions = await prisma.user_permissions.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more User_permissions and only return the `id`
     * const user_permissionsWithIdOnly = await prisma.user_permissions.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends user_permissionsUpdateManyAndReturnArgs>(args: SelectSubset<T, user_permissionsUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$user_permissionsPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one User_permissions.
     * @param {user_permissionsUpsertArgs} args - Arguments to update or create a User_permissions.
     * @example
     * // Update or create a User_permissions
     * const user_permissions = await prisma.user_permissions.upsert({
     *   create: {
     *     // ... data to create a User_permissions
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the User_permissions we want to update
     *   }
     * })
     */
    upsert<T extends user_permissionsUpsertArgs>(args: SelectSubset<T, user_permissionsUpsertArgs<ExtArgs>>): Prisma__user_permissionsClient<$Result.GetResult<Prisma.$user_permissionsPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of User_permissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {user_permissionsCountArgs} args - Arguments to filter User_permissions to count.
     * @example
     * // Count the number of User_permissions
     * const count = await prisma.user_permissions.count({
     *   where: {
     *     // ... the filter for the User_permissions we want to count
     *   }
     * })
    **/
    count<T extends user_permissionsCountArgs>(
      args?: Subset<T, user_permissionsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], User_permissionsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a User_permissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {User_permissionsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends User_permissionsAggregateArgs>(args: Subset<T, User_permissionsAggregateArgs>): Prisma.PrismaPromise<GetUser_permissionsAggregateType<T>>

    /**
     * Group by User_permissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {user_permissionsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends user_permissionsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: user_permissionsGroupByArgs['orderBy'] }
        : { orderBy?: user_permissionsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, user_permissionsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUser_permissionsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the user_permissions model
   */
  readonly fields: user_permissionsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for user_permissions.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__user_permissionsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    userPermission<T extends permissions_listDefaultArgs<ExtArgs> = {}>(args?: Subset<T, permissions_listDefaultArgs<ExtArgs>>): Prisma__permissions_listClient<$Result.GetResult<Prisma.$permissions_listPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the user_permissions model
   */ 
  interface user_permissionsFieldRefs {
    readonly id: FieldRef<"user_permissions", 'Int'>
    readonly user_id: FieldRef<"user_permissions", 'Int'>
    readonly limit: FieldRef<"user_permissions", 'Int'>
    readonly permission_id: FieldRef<"user_permissions", 'Int'>
    readonly created_at: FieldRef<"user_permissions", 'DateTime'>
    readonly updated_at: FieldRef<"user_permissions", 'DateTime'>
    readonly deleted_at: FieldRef<"user_permissions", 'DateTime'>
  }
    

  // Custom InputTypes
  /**
   * user_permissions findUnique
   */
  export type user_permissionsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_permissions
     */
    select?: user_permissionsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user_permissions
     */
    omit?: user_permissionsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_permissionsInclude<ExtArgs> | null
    /**
     * Filter, which user_permissions to fetch.
     */
    where: user_permissionsWhereUniqueInput
  }

  /**
   * user_permissions findUniqueOrThrow
   */
  export type user_permissionsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_permissions
     */
    select?: user_permissionsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user_permissions
     */
    omit?: user_permissionsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_permissionsInclude<ExtArgs> | null
    /**
     * Filter, which user_permissions to fetch.
     */
    where: user_permissionsWhereUniqueInput
  }

  /**
   * user_permissions findFirst
   */
  export type user_permissionsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_permissions
     */
    select?: user_permissionsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user_permissions
     */
    omit?: user_permissionsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_permissionsInclude<ExtArgs> | null
    /**
     * Filter, which user_permissions to fetch.
     */
    where?: user_permissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of user_permissions to fetch.
     */
    orderBy?: user_permissionsOrderByWithRelationInput | user_permissionsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for user_permissions.
     */
    cursor?: user_permissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` user_permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` user_permissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of user_permissions.
     */
    distinct?: User_permissionsScalarFieldEnum | User_permissionsScalarFieldEnum[]
  }

  /**
   * user_permissions findFirstOrThrow
   */
  export type user_permissionsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_permissions
     */
    select?: user_permissionsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user_permissions
     */
    omit?: user_permissionsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_permissionsInclude<ExtArgs> | null
    /**
     * Filter, which user_permissions to fetch.
     */
    where?: user_permissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of user_permissions to fetch.
     */
    orderBy?: user_permissionsOrderByWithRelationInput | user_permissionsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for user_permissions.
     */
    cursor?: user_permissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` user_permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` user_permissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of user_permissions.
     */
    distinct?: User_permissionsScalarFieldEnum | User_permissionsScalarFieldEnum[]
  }

  /**
   * user_permissions findMany
   */
  export type user_permissionsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_permissions
     */
    select?: user_permissionsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user_permissions
     */
    omit?: user_permissionsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_permissionsInclude<ExtArgs> | null
    /**
     * Filter, which user_permissions to fetch.
     */
    where?: user_permissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of user_permissions to fetch.
     */
    orderBy?: user_permissionsOrderByWithRelationInput | user_permissionsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing user_permissions.
     */
    cursor?: user_permissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` user_permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` user_permissions.
     */
    skip?: number
    distinct?: User_permissionsScalarFieldEnum | User_permissionsScalarFieldEnum[]
  }

  /**
   * user_permissions create
   */
  export type user_permissionsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_permissions
     */
    select?: user_permissionsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user_permissions
     */
    omit?: user_permissionsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_permissionsInclude<ExtArgs> | null
    /**
     * The data needed to create a user_permissions.
     */
    data: XOR<user_permissionsCreateInput, user_permissionsUncheckedCreateInput>
  }

  /**
   * user_permissions createMany
   */
  export type user_permissionsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many user_permissions.
     */
    data: user_permissionsCreateManyInput | user_permissionsCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * user_permissions createManyAndReturn
   */
  export type user_permissionsCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_permissions
     */
    select?: user_permissionsSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the user_permissions
     */
    omit?: user_permissionsOmit<ExtArgs> | null
    /**
     * The data used to create many user_permissions.
     */
    data: user_permissionsCreateManyInput | user_permissionsCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_permissionsIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * user_permissions update
   */
  export type user_permissionsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_permissions
     */
    select?: user_permissionsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user_permissions
     */
    omit?: user_permissionsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_permissionsInclude<ExtArgs> | null
    /**
     * The data needed to update a user_permissions.
     */
    data: XOR<user_permissionsUpdateInput, user_permissionsUncheckedUpdateInput>
    /**
     * Choose, which user_permissions to update.
     */
    where: user_permissionsWhereUniqueInput
  }

  /**
   * user_permissions updateMany
   */
  export type user_permissionsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update user_permissions.
     */
    data: XOR<user_permissionsUpdateManyMutationInput, user_permissionsUncheckedUpdateManyInput>
    /**
     * Filter which user_permissions to update
     */
    where?: user_permissionsWhereInput
    /**
     * Limit how many user_permissions to update.
     */
    limit?: number
  }

  /**
   * user_permissions updateManyAndReturn
   */
  export type user_permissionsUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_permissions
     */
    select?: user_permissionsSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the user_permissions
     */
    omit?: user_permissionsOmit<ExtArgs> | null
    /**
     * The data used to update user_permissions.
     */
    data: XOR<user_permissionsUpdateManyMutationInput, user_permissionsUncheckedUpdateManyInput>
    /**
     * Filter which user_permissions to update
     */
    where?: user_permissionsWhereInput
    /**
     * Limit how many user_permissions to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_permissionsIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * user_permissions upsert
   */
  export type user_permissionsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_permissions
     */
    select?: user_permissionsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user_permissions
     */
    omit?: user_permissionsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_permissionsInclude<ExtArgs> | null
    /**
     * The filter to search for the user_permissions to update in case it exists.
     */
    where: user_permissionsWhereUniqueInput
    /**
     * In case the user_permissions found by the `where` argument doesn't exist, create a new user_permissions with this data.
     */
    create: XOR<user_permissionsCreateInput, user_permissionsUncheckedCreateInput>
    /**
     * In case the user_permissions was found with the provided `where` argument, update it with this data.
     */
    update: XOR<user_permissionsUpdateInput, user_permissionsUncheckedUpdateInput>
  }

  /**
   * user_permissions delete
   */
  export type user_permissionsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_permissions
     */
    select?: user_permissionsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user_permissions
     */
    omit?: user_permissionsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_permissionsInclude<ExtArgs> | null
    /**
     * Filter which user_permissions to delete.
     */
    where: user_permissionsWhereUniqueInput
  }

  /**
   * user_permissions deleteMany
   */
  export type user_permissionsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which user_permissions to delete
     */
    where?: user_permissionsWhereInput
    /**
     * Limit how many user_permissions to delete.
     */
    limit?: number
  }

  /**
   * user_permissions without action
   */
  export type user_permissionsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the user_permissions
     */
    select?: user_permissionsSelect<ExtArgs> | null
    /**
     * Omit specific fields from the user_permissions
     */
    omit?: user_permissionsOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: user_permissionsInclude<ExtArgs> | null
  }


  /**
   * Model package_features
   */

  export type AggregatePackage_features = {
    _count: Package_featuresCountAggregateOutputType | null
    _avg: Package_featuresAvgAggregateOutputType | null
    _sum: Package_featuresSumAggregateOutputType | null
    _min: Package_featuresMinAggregateOutputType | null
    _max: Package_featuresMaxAggregateOutputType | null
  }

  export type Package_featuresAvgAggregateOutputType = {
    id: number | null
    subscription_id: number | null
    competition_analysis: number | null
    competitor_backlinks_opportunity: number | null
    web_2_0_400_600_words_blog_Writing: number | null
    article_writing: number | null
    classified_writing: number | null
    press_release_writing: number | null
    ppt_pdf_creation_writing: number | null
    web_2_0_400_600_words_submission: number | null
    web_2_0_blog_promotion: number | null
    article_submission: number | null
    article_promotion: number | null
    guest_blogging: number | null
    social_bookmarking_links: number | null
    press_release_submission: number | null
    local_citation: number | null
    classified_submissions: number | null
    ppt_submission: number | null
    ppt_promotion_backlinks: number | null
    pdf_submission: number | null
    pdf_promotion_backlinks: number | null
    quora_Q_A: number | null
    profile_creation: number | null
    blog_commenting_niche_edu: number | null
    forum_submission: number | null
    local_citation_submissions: number | null
    customer_reviews_ratings: number | null
    local_classified_ads: number | null
    status: number | null
  }

  export type Package_featuresSumAggregateOutputType = {
    id: number | null
    subscription_id: number | null
    competition_analysis: number | null
    competitor_backlinks_opportunity: number | null
    web_2_0_400_600_words_blog_Writing: number | null
    article_writing: number | null
    classified_writing: number | null
    press_release_writing: number | null
    ppt_pdf_creation_writing: number | null
    web_2_0_400_600_words_submission: number | null
    web_2_0_blog_promotion: number | null
    article_submission: number | null
    article_promotion: number | null
    guest_blogging: number | null
    social_bookmarking_links: number | null
    press_release_submission: number | null
    local_citation: number | null
    classified_submissions: number | null
    ppt_submission: number | null
    ppt_promotion_backlinks: number | null
    pdf_submission: number | null
    pdf_promotion_backlinks: number | null
    quora_Q_A: number | null
    profile_creation: number | null
    blog_commenting_niche_edu: number | null
    forum_submission: number | null
    local_citation_submissions: number | null
    customer_reviews_ratings: number | null
    local_classified_ads: number | null
    status: number | null
  }

  export type Package_featuresMinAggregateOutputType = {
    id: number | null
    subscription_id: number | null
    website_analysis: boolean | null
    content_duplicacy: boolean | null
    initial_backlinks: boolean | null
    critical_seo_analysis: boolean | null
    google_penalty_check: boolean | null
    competition_analysis: number | null
    competitor_backlinks_opportunity: number | null
    keyword_research_analysis: boolean | null
    on_page_optimization: boolean | null
    title_tags_optimization: boolean | null
    meta_tags_optimization: boolean | null
    content_optimization: boolean | null
    html_code_optimization: boolean | null
    website_permalinks_analysis: boolean | null
    seo_friendly_urls: boolean | null
    schema_markup_analysis: boolean | null
    internal_linking_optimization: boolean | null
    crawl_error_resolution: boolean | null
    heading_tags_optimization: boolean | null
    canonicalization_301_redirect: boolean | null
    custom_404_errors: boolean | null
    images_optimization: boolean | null
    hyperlink_optimization: boolean | null
    robots_txt_creation_optimization: boolean | null
    sitemap_creation: boolean | null
    google_webmaster_tools_setup: boolean | null
    bing_Webmaster_tools_setup: boolean | null
    google_analytics_setup_Integration: boolean | null
    website_responsive_check: boolean | null
    page_speed_analysis: boolean | null
    mobile_responsive_compatibility_check: boolean | null
    navigation_ux_factors: boolean | null
    ssl_certificate: boolean | null
    web_2_0_400_600_words_blog_Writing: number | null
    article_writing: number | null
    classified_writing: number | null
    press_release_writing: number | null
    ppt_pdf_creation_writing: number | null
    web_2_0_400_600_words_submission: number | null
    web_2_0_blog_promotion: number | null
    article_submission: number | null
    article_promotion: number | null
    guest_blogging: number | null
    custom_graphics_to_support_your_blogs: boolean | null
    social_bookmarking_links: number | null
    press_release_submission: number | null
    local_citation: number | null
    classified_submissions: number | null
    ppt_submission: number | null
    ppt_promotion_backlinks: number | null
    pdf_submission: number | null
    pdf_promotion_backlinks: number | null
    quora_Q_A: number | null
    profile_creation: number | null
    blog_commenting_niche_edu: number | null
    forum_submission: number | null
    google_my_business_setup_verification: boolean | null
    local_citation_submissions: number | null
    google_places_photo_multimedia_additions: boolean | null
    customer_reviews_ratings: number | null
    local_classified_ads: number | null
    monthly_keyword_improvement_report: boolean | null
    monthly_back_links_report: boolean | null
    monthly_google_analytic_static_report: boolean | null
    email: boolean | null
    telephone_whatsapp_telegram: boolean | null
    internet_messenger_skype: boolean | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    status: number | null
  }

  export type Package_featuresMaxAggregateOutputType = {
    id: number | null
    subscription_id: number | null
    website_analysis: boolean | null
    content_duplicacy: boolean | null
    initial_backlinks: boolean | null
    critical_seo_analysis: boolean | null
    google_penalty_check: boolean | null
    competition_analysis: number | null
    competitor_backlinks_opportunity: number | null
    keyword_research_analysis: boolean | null
    on_page_optimization: boolean | null
    title_tags_optimization: boolean | null
    meta_tags_optimization: boolean | null
    content_optimization: boolean | null
    html_code_optimization: boolean | null
    website_permalinks_analysis: boolean | null
    seo_friendly_urls: boolean | null
    schema_markup_analysis: boolean | null
    internal_linking_optimization: boolean | null
    crawl_error_resolution: boolean | null
    heading_tags_optimization: boolean | null
    canonicalization_301_redirect: boolean | null
    custom_404_errors: boolean | null
    images_optimization: boolean | null
    hyperlink_optimization: boolean | null
    robots_txt_creation_optimization: boolean | null
    sitemap_creation: boolean | null
    google_webmaster_tools_setup: boolean | null
    bing_Webmaster_tools_setup: boolean | null
    google_analytics_setup_Integration: boolean | null
    website_responsive_check: boolean | null
    page_speed_analysis: boolean | null
    mobile_responsive_compatibility_check: boolean | null
    navigation_ux_factors: boolean | null
    ssl_certificate: boolean | null
    web_2_0_400_600_words_blog_Writing: number | null
    article_writing: number | null
    classified_writing: number | null
    press_release_writing: number | null
    ppt_pdf_creation_writing: number | null
    web_2_0_400_600_words_submission: number | null
    web_2_0_blog_promotion: number | null
    article_submission: number | null
    article_promotion: number | null
    guest_blogging: number | null
    custom_graphics_to_support_your_blogs: boolean | null
    social_bookmarking_links: number | null
    press_release_submission: number | null
    local_citation: number | null
    classified_submissions: number | null
    ppt_submission: number | null
    ppt_promotion_backlinks: number | null
    pdf_submission: number | null
    pdf_promotion_backlinks: number | null
    quora_Q_A: number | null
    profile_creation: number | null
    blog_commenting_niche_edu: number | null
    forum_submission: number | null
    google_my_business_setup_verification: boolean | null
    local_citation_submissions: number | null
    google_places_photo_multimedia_additions: boolean | null
    customer_reviews_ratings: number | null
    local_classified_ads: number | null
    monthly_keyword_improvement_report: boolean | null
    monthly_back_links_report: boolean | null
    monthly_google_analytic_static_report: boolean | null
    email: boolean | null
    telephone_whatsapp_telegram: boolean | null
    internet_messenger_skype: boolean | null
    created_at: Date | null
    updated_at: Date | null
    deleted_at: Date | null
    status: number | null
  }

  export type Package_featuresCountAggregateOutputType = {
    id: number
    subscription_id: number
    website_analysis: number
    content_duplicacy: number
    initial_backlinks: number
    critical_seo_analysis: number
    google_penalty_check: number
    competition_analysis: number
    competitor_backlinks_opportunity: number
    keyword_research_analysis: number
    on_page_optimization: number
    title_tags_optimization: number
    meta_tags_optimization: number
    content_optimization: number
    html_code_optimization: number
    website_permalinks_analysis: number
    seo_friendly_urls: number
    schema_markup_analysis: number
    internal_linking_optimization: number
    crawl_error_resolution: number
    heading_tags_optimization: number
    canonicalization_301_redirect: number
    custom_404_errors: number
    images_optimization: number
    hyperlink_optimization: number
    robots_txt_creation_optimization: number
    sitemap_creation: number
    google_webmaster_tools_setup: number
    bing_Webmaster_tools_setup: number
    google_analytics_setup_Integration: number
    website_responsive_check: number
    page_speed_analysis: number
    mobile_responsive_compatibility_check: number
    navigation_ux_factors: number
    ssl_certificate: number
    web_2_0_400_600_words_blog_Writing: number
    article_writing: number
    classified_writing: number
    press_release_writing: number
    ppt_pdf_creation_writing: number
    web_2_0_400_600_words_submission: number
    web_2_0_blog_promotion: number
    article_submission: number
    article_promotion: number
    guest_blogging: number
    custom_graphics_to_support_your_blogs: number
    social_bookmarking_links: number
    press_release_submission: number
    local_citation: number
    classified_submissions: number
    ppt_submission: number
    ppt_promotion_backlinks: number
    pdf_submission: number
    pdf_promotion_backlinks: number
    quora_Q_A: number
    profile_creation: number
    blog_commenting_niche_edu: number
    forum_submission: number
    google_my_business_setup_verification: number
    local_citation_submissions: number
    google_places_photo_multimedia_additions: number
    customer_reviews_ratings: number
    local_classified_ads: number
    monthly_keyword_improvement_report: number
    monthly_back_links_report: number
    monthly_google_analytic_static_report: number
    email: number
    telephone_whatsapp_telegram: number
    internet_messenger_skype: number
    created_at: number
    updated_at: number
    deleted_at: number
    status: number
    _all: number
  }


  export type Package_featuresAvgAggregateInputType = {
    id?: true
    subscription_id?: true
    competition_analysis?: true
    competitor_backlinks_opportunity?: true
    web_2_0_400_600_words_blog_Writing?: true
    article_writing?: true
    classified_writing?: true
    press_release_writing?: true
    ppt_pdf_creation_writing?: true
    web_2_0_400_600_words_submission?: true
    web_2_0_blog_promotion?: true
    article_submission?: true
    article_promotion?: true
    guest_blogging?: true
    social_bookmarking_links?: true
    press_release_submission?: true
    local_citation?: true
    classified_submissions?: true
    ppt_submission?: true
    ppt_promotion_backlinks?: true
    pdf_submission?: true
    pdf_promotion_backlinks?: true
    quora_Q_A?: true
    profile_creation?: true
    blog_commenting_niche_edu?: true
    forum_submission?: true
    local_citation_submissions?: true
    customer_reviews_ratings?: true
    local_classified_ads?: true
    status?: true
  }

  export type Package_featuresSumAggregateInputType = {
    id?: true
    subscription_id?: true
    competition_analysis?: true
    competitor_backlinks_opportunity?: true
    web_2_0_400_600_words_blog_Writing?: true
    article_writing?: true
    classified_writing?: true
    press_release_writing?: true
    ppt_pdf_creation_writing?: true
    web_2_0_400_600_words_submission?: true
    web_2_0_blog_promotion?: true
    article_submission?: true
    article_promotion?: true
    guest_blogging?: true
    social_bookmarking_links?: true
    press_release_submission?: true
    local_citation?: true
    classified_submissions?: true
    ppt_submission?: true
    ppt_promotion_backlinks?: true
    pdf_submission?: true
    pdf_promotion_backlinks?: true
    quora_Q_A?: true
    profile_creation?: true
    blog_commenting_niche_edu?: true
    forum_submission?: true
    local_citation_submissions?: true
    customer_reviews_ratings?: true
    local_classified_ads?: true
    status?: true
  }

  export type Package_featuresMinAggregateInputType = {
    id?: true
    subscription_id?: true
    website_analysis?: true
    content_duplicacy?: true
    initial_backlinks?: true
    critical_seo_analysis?: true
    google_penalty_check?: true
    competition_analysis?: true
    competitor_backlinks_opportunity?: true
    keyword_research_analysis?: true
    on_page_optimization?: true
    title_tags_optimization?: true
    meta_tags_optimization?: true
    content_optimization?: true
    html_code_optimization?: true
    website_permalinks_analysis?: true
    seo_friendly_urls?: true
    schema_markup_analysis?: true
    internal_linking_optimization?: true
    crawl_error_resolution?: true
    heading_tags_optimization?: true
    canonicalization_301_redirect?: true
    custom_404_errors?: true
    images_optimization?: true
    hyperlink_optimization?: true
    robots_txt_creation_optimization?: true
    sitemap_creation?: true
    google_webmaster_tools_setup?: true
    bing_Webmaster_tools_setup?: true
    google_analytics_setup_Integration?: true
    website_responsive_check?: true
    page_speed_analysis?: true
    mobile_responsive_compatibility_check?: true
    navigation_ux_factors?: true
    ssl_certificate?: true
    web_2_0_400_600_words_blog_Writing?: true
    article_writing?: true
    classified_writing?: true
    press_release_writing?: true
    ppt_pdf_creation_writing?: true
    web_2_0_400_600_words_submission?: true
    web_2_0_blog_promotion?: true
    article_submission?: true
    article_promotion?: true
    guest_blogging?: true
    custom_graphics_to_support_your_blogs?: true
    social_bookmarking_links?: true
    press_release_submission?: true
    local_citation?: true
    classified_submissions?: true
    ppt_submission?: true
    ppt_promotion_backlinks?: true
    pdf_submission?: true
    pdf_promotion_backlinks?: true
    quora_Q_A?: true
    profile_creation?: true
    blog_commenting_niche_edu?: true
    forum_submission?: true
    google_my_business_setup_verification?: true
    local_citation_submissions?: true
    google_places_photo_multimedia_additions?: true
    customer_reviews_ratings?: true
    local_classified_ads?: true
    monthly_keyword_improvement_report?: true
    monthly_back_links_report?: true
    monthly_google_analytic_static_report?: true
    email?: true
    telephone_whatsapp_telegram?: true
    internet_messenger_skype?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    status?: true
  }

  export type Package_featuresMaxAggregateInputType = {
    id?: true
    subscription_id?: true
    website_analysis?: true
    content_duplicacy?: true
    initial_backlinks?: true
    critical_seo_analysis?: true
    google_penalty_check?: true
    competition_analysis?: true
    competitor_backlinks_opportunity?: true
    keyword_research_analysis?: true
    on_page_optimization?: true
    title_tags_optimization?: true
    meta_tags_optimization?: true
    content_optimization?: true
    html_code_optimization?: true
    website_permalinks_analysis?: true
    seo_friendly_urls?: true
    schema_markup_analysis?: true
    internal_linking_optimization?: true
    crawl_error_resolution?: true
    heading_tags_optimization?: true
    canonicalization_301_redirect?: true
    custom_404_errors?: true
    images_optimization?: true
    hyperlink_optimization?: true
    robots_txt_creation_optimization?: true
    sitemap_creation?: true
    google_webmaster_tools_setup?: true
    bing_Webmaster_tools_setup?: true
    google_analytics_setup_Integration?: true
    website_responsive_check?: true
    page_speed_analysis?: true
    mobile_responsive_compatibility_check?: true
    navigation_ux_factors?: true
    ssl_certificate?: true
    web_2_0_400_600_words_blog_Writing?: true
    article_writing?: true
    classified_writing?: true
    press_release_writing?: true
    ppt_pdf_creation_writing?: true
    web_2_0_400_600_words_submission?: true
    web_2_0_blog_promotion?: true
    article_submission?: true
    article_promotion?: true
    guest_blogging?: true
    custom_graphics_to_support_your_blogs?: true
    social_bookmarking_links?: true
    press_release_submission?: true
    local_citation?: true
    classified_submissions?: true
    ppt_submission?: true
    ppt_promotion_backlinks?: true
    pdf_submission?: true
    pdf_promotion_backlinks?: true
    quora_Q_A?: true
    profile_creation?: true
    blog_commenting_niche_edu?: true
    forum_submission?: true
    google_my_business_setup_verification?: true
    local_citation_submissions?: true
    google_places_photo_multimedia_additions?: true
    customer_reviews_ratings?: true
    local_classified_ads?: true
    monthly_keyword_improvement_report?: true
    monthly_back_links_report?: true
    monthly_google_analytic_static_report?: true
    email?: true
    telephone_whatsapp_telegram?: true
    internet_messenger_skype?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    status?: true
  }

  export type Package_featuresCountAggregateInputType = {
    id?: true
    subscription_id?: true
    website_analysis?: true
    content_duplicacy?: true
    initial_backlinks?: true
    critical_seo_analysis?: true
    google_penalty_check?: true
    competition_analysis?: true
    competitor_backlinks_opportunity?: true
    keyword_research_analysis?: true
    on_page_optimization?: true
    title_tags_optimization?: true
    meta_tags_optimization?: true
    content_optimization?: true
    html_code_optimization?: true
    website_permalinks_analysis?: true
    seo_friendly_urls?: true
    schema_markup_analysis?: true
    internal_linking_optimization?: true
    crawl_error_resolution?: true
    heading_tags_optimization?: true
    canonicalization_301_redirect?: true
    custom_404_errors?: true
    images_optimization?: true
    hyperlink_optimization?: true
    robots_txt_creation_optimization?: true
    sitemap_creation?: true
    google_webmaster_tools_setup?: true
    bing_Webmaster_tools_setup?: true
    google_analytics_setup_Integration?: true
    website_responsive_check?: true
    page_speed_analysis?: true
    mobile_responsive_compatibility_check?: true
    navigation_ux_factors?: true
    ssl_certificate?: true
    web_2_0_400_600_words_blog_Writing?: true
    article_writing?: true
    classified_writing?: true
    press_release_writing?: true
    ppt_pdf_creation_writing?: true
    web_2_0_400_600_words_submission?: true
    web_2_0_blog_promotion?: true
    article_submission?: true
    article_promotion?: true
    guest_blogging?: true
    custom_graphics_to_support_your_blogs?: true
    social_bookmarking_links?: true
    press_release_submission?: true
    local_citation?: true
    classified_submissions?: true
    ppt_submission?: true
    ppt_promotion_backlinks?: true
    pdf_submission?: true
    pdf_promotion_backlinks?: true
    quora_Q_A?: true
    profile_creation?: true
    blog_commenting_niche_edu?: true
    forum_submission?: true
    google_my_business_setup_verification?: true
    local_citation_submissions?: true
    google_places_photo_multimedia_additions?: true
    customer_reviews_ratings?: true
    local_classified_ads?: true
    monthly_keyword_improvement_report?: true
    monthly_back_links_report?: true
    monthly_google_analytic_static_report?: true
    email?: true
    telephone_whatsapp_telegram?: true
    internet_messenger_skype?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    status?: true
    _all?: true
  }

  export type Package_featuresAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which package_features to aggregate.
     */
    where?: package_featuresWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of package_features to fetch.
     */
    orderBy?: package_featuresOrderByWithRelationInput | package_featuresOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: package_featuresWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` package_features from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` package_features.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned package_features
    **/
    _count?: true | Package_featuresCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: Package_featuresAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: Package_featuresSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: Package_featuresMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: Package_featuresMaxAggregateInputType
  }

  export type GetPackage_featuresAggregateType<T extends Package_featuresAggregateArgs> = {
        [P in keyof T & keyof AggregatePackage_features]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregatePackage_features[P]>
      : GetScalarType<T[P], AggregatePackage_features[P]>
  }




  export type package_featuresGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: package_featuresWhereInput
    orderBy?: package_featuresOrderByWithAggregationInput | package_featuresOrderByWithAggregationInput[]
    by: Package_featuresScalarFieldEnum[] | Package_featuresScalarFieldEnum
    having?: package_featuresScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: Package_featuresCountAggregateInputType | true
    _avg?: Package_featuresAvgAggregateInputType
    _sum?: Package_featuresSumAggregateInputType
    _min?: Package_featuresMinAggregateInputType
    _max?: Package_featuresMaxAggregateInputType
  }

  export type Package_featuresGroupByOutputType = {
    id: number
    subscription_id: number
    website_analysis: boolean
    content_duplicacy: boolean
    initial_backlinks: boolean
    critical_seo_analysis: boolean
    google_penalty_check: boolean
    competition_analysis: number
    competitor_backlinks_opportunity: number
    keyword_research_analysis: boolean
    on_page_optimization: boolean
    title_tags_optimization: boolean
    meta_tags_optimization: boolean
    content_optimization: boolean
    html_code_optimization: boolean
    website_permalinks_analysis: boolean
    seo_friendly_urls: boolean
    schema_markup_analysis: boolean
    internal_linking_optimization: boolean
    crawl_error_resolution: boolean
    heading_tags_optimization: boolean
    canonicalization_301_redirect: boolean
    custom_404_errors: boolean
    images_optimization: boolean
    hyperlink_optimization: boolean
    robots_txt_creation_optimization: boolean
    sitemap_creation: boolean
    google_webmaster_tools_setup: boolean
    bing_Webmaster_tools_setup: boolean
    google_analytics_setup_Integration: boolean
    website_responsive_check: boolean
    page_speed_analysis: boolean
    mobile_responsive_compatibility_check: boolean
    navigation_ux_factors: boolean
    ssl_certificate: boolean
    web_2_0_400_600_words_blog_Writing: number
    article_writing: number
    classified_writing: number
    press_release_writing: number
    ppt_pdf_creation_writing: number
    web_2_0_400_600_words_submission: number
    web_2_0_blog_promotion: number
    article_submission: number
    article_promotion: number
    guest_blogging: number
    custom_graphics_to_support_your_blogs: boolean
    social_bookmarking_links: number
    press_release_submission: number
    local_citation: number
    classified_submissions: number
    ppt_submission: number
    ppt_promotion_backlinks: number
    pdf_submission: number
    pdf_promotion_backlinks: number
    quora_Q_A: number
    profile_creation: number
    blog_commenting_niche_edu: number
    forum_submission: number
    google_my_business_setup_verification: boolean
    local_citation_submissions: number
    google_places_photo_multimedia_additions: boolean
    customer_reviews_ratings: number
    local_classified_ads: number
    monthly_keyword_improvement_report: boolean
    monthly_back_links_report: boolean
    monthly_google_analytic_static_report: boolean
    email: boolean
    telephone_whatsapp_telegram: boolean
    internet_messenger_skype: boolean
    created_at: Date
    updated_at: Date
    deleted_at: Date | null
    status: number | null
    _count: Package_featuresCountAggregateOutputType | null
    _avg: Package_featuresAvgAggregateOutputType | null
    _sum: Package_featuresSumAggregateOutputType | null
    _min: Package_featuresMinAggregateOutputType | null
    _max: Package_featuresMaxAggregateOutputType | null
  }

  type GetPackage_featuresGroupByPayload<T extends package_featuresGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<Package_featuresGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof Package_featuresGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], Package_featuresGroupByOutputType[P]>
            : GetScalarType<T[P], Package_featuresGroupByOutputType[P]>
        }
      >
    >


  export type package_featuresSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    subscription_id?: boolean
    website_analysis?: boolean
    content_duplicacy?: boolean
    initial_backlinks?: boolean
    critical_seo_analysis?: boolean
    google_penalty_check?: boolean
    competition_analysis?: boolean
    competitor_backlinks_opportunity?: boolean
    keyword_research_analysis?: boolean
    on_page_optimization?: boolean
    title_tags_optimization?: boolean
    meta_tags_optimization?: boolean
    content_optimization?: boolean
    html_code_optimization?: boolean
    website_permalinks_analysis?: boolean
    seo_friendly_urls?: boolean
    schema_markup_analysis?: boolean
    internal_linking_optimization?: boolean
    crawl_error_resolution?: boolean
    heading_tags_optimization?: boolean
    canonicalization_301_redirect?: boolean
    custom_404_errors?: boolean
    images_optimization?: boolean
    hyperlink_optimization?: boolean
    robots_txt_creation_optimization?: boolean
    sitemap_creation?: boolean
    google_webmaster_tools_setup?: boolean
    bing_Webmaster_tools_setup?: boolean
    google_analytics_setup_Integration?: boolean
    website_responsive_check?: boolean
    page_speed_analysis?: boolean
    mobile_responsive_compatibility_check?: boolean
    navigation_ux_factors?: boolean
    ssl_certificate?: boolean
    web_2_0_400_600_words_blog_Writing?: boolean
    article_writing?: boolean
    classified_writing?: boolean
    press_release_writing?: boolean
    ppt_pdf_creation_writing?: boolean
    web_2_0_400_600_words_submission?: boolean
    web_2_0_blog_promotion?: boolean
    article_submission?: boolean
    article_promotion?: boolean
    guest_blogging?: boolean
    custom_graphics_to_support_your_blogs?: boolean
    social_bookmarking_links?: boolean
    press_release_submission?: boolean
    local_citation?: boolean
    classified_submissions?: boolean
    ppt_submission?: boolean
    ppt_promotion_backlinks?: boolean
    pdf_submission?: boolean
    pdf_promotion_backlinks?: boolean
    quora_Q_A?: boolean
    profile_creation?: boolean
    blog_commenting_niche_edu?: boolean
    forum_submission?: boolean
    google_my_business_setup_verification?: boolean
    local_citation_submissions?: boolean
    google_places_photo_multimedia_additions?: boolean
    customer_reviews_ratings?: boolean
    local_classified_ads?: boolean
    monthly_keyword_improvement_report?: boolean
    monthly_back_links_report?: boolean
    monthly_google_analytic_static_report?: boolean
    email?: boolean
    telephone_whatsapp_telegram?: boolean
    internet_messenger_skype?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    status?: boolean
    Features?: boolean | subscriptionDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["package_features"]>

  export type package_featuresSelectCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    subscription_id?: boolean
    website_analysis?: boolean
    content_duplicacy?: boolean
    initial_backlinks?: boolean
    critical_seo_analysis?: boolean
    google_penalty_check?: boolean
    competition_analysis?: boolean
    competitor_backlinks_opportunity?: boolean
    keyword_research_analysis?: boolean
    on_page_optimization?: boolean
    title_tags_optimization?: boolean
    meta_tags_optimization?: boolean
    content_optimization?: boolean
    html_code_optimization?: boolean
    website_permalinks_analysis?: boolean
    seo_friendly_urls?: boolean
    schema_markup_analysis?: boolean
    internal_linking_optimization?: boolean
    crawl_error_resolution?: boolean
    heading_tags_optimization?: boolean
    canonicalization_301_redirect?: boolean
    custom_404_errors?: boolean
    images_optimization?: boolean
    hyperlink_optimization?: boolean
    robots_txt_creation_optimization?: boolean
    sitemap_creation?: boolean
    google_webmaster_tools_setup?: boolean
    bing_Webmaster_tools_setup?: boolean
    google_analytics_setup_Integration?: boolean
    website_responsive_check?: boolean
    page_speed_analysis?: boolean
    mobile_responsive_compatibility_check?: boolean
    navigation_ux_factors?: boolean
    ssl_certificate?: boolean
    web_2_0_400_600_words_blog_Writing?: boolean
    article_writing?: boolean
    classified_writing?: boolean
    press_release_writing?: boolean
    ppt_pdf_creation_writing?: boolean
    web_2_0_400_600_words_submission?: boolean
    web_2_0_blog_promotion?: boolean
    article_submission?: boolean
    article_promotion?: boolean
    guest_blogging?: boolean
    custom_graphics_to_support_your_blogs?: boolean
    social_bookmarking_links?: boolean
    press_release_submission?: boolean
    local_citation?: boolean
    classified_submissions?: boolean
    ppt_submission?: boolean
    ppt_promotion_backlinks?: boolean
    pdf_submission?: boolean
    pdf_promotion_backlinks?: boolean
    quora_Q_A?: boolean
    profile_creation?: boolean
    blog_commenting_niche_edu?: boolean
    forum_submission?: boolean
    google_my_business_setup_verification?: boolean
    local_citation_submissions?: boolean
    google_places_photo_multimedia_additions?: boolean
    customer_reviews_ratings?: boolean
    local_classified_ads?: boolean
    monthly_keyword_improvement_report?: boolean
    monthly_back_links_report?: boolean
    monthly_google_analytic_static_report?: boolean
    email?: boolean
    telephone_whatsapp_telegram?: boolean
    internet_messenger_skype?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    status?: boolean
    Features?: boolean | subscriptionDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["package_features"]>

  export type package_featuresSelectUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    subscription_id?: boolean
    website_analysis?: boolean
    content_duplicacy?: boolean
    initial_backlinks?: boolean
    critical_seo_analysis?: boolean
    google_penalty_check?: boolean
    competition_analysis?: boolean
    competitor_backlinks_opportunity?: boolean
    keyword_research_analysis?: boolean
    on_page_optimization?: boolean
    title_tags_optimization?: boolean
    meta_tags_optimization?: boolean
    content_optimization?: boolean
    html_code_optimization?: boolean
    website_permalinks_analysis?: boolean
    seo_friendly_urls?: boolean
    schema_markup_analysis?: boolean
    internal_linking_optimization?: boolean
    crawl_error_resolution?: boolean
    heading_tags_optimization?: boolean
    canonicalization_301_redirect?: boolean
    custom_404_errors?: boolean
    images_optimization?: boolean
    hyperlink_optimization?: boolean
    robots_txt_creation_optimization?: boolean
    sitemap_creation?: boolean
    google_webmaster_tools_setup?: boolean
    bing_Webmaster_tools_setup?: boolean
    google_analytics_setup_Integration?: boolean
    website_responsive_check?: boolean
    page_speed_analysis?: boolean
    mobile_responsive_compatibility_check?: boolean
    navigation_ux_factors?: boolean
    ssl_certificate?: boolean
    web_2_0_400_600_words_blog_Writing?: boolean
    article_writing?: boolean
    classified_writing?: boolean
    press_release_writing?: boolean
    ppt_pdf_creation_writing?: boolean
    web_2_0_400_600_words_submission?: boolean
    web_2_0_blog_promotion?: boolean
    article_submission?: boolean
    article_promotion?: boolean
    guest_blogging?: boolean
    custom_graphics_to_support_your_blogs?: boolean
    social_bookmarking_links?: boolean
    press_release_submission?: boolean
    local_citation?: boolean
    classified_submissions?: boolean
    ppt_submission?: boolean
    ppt_promotion_backlinks?: boolean
    pdf_submission?: boolean
    pdf_promotion_backlinks?: boolean
    quora_Q_A?: boolean
    profile_creation?: boolean
    blog_commenting_niche_edu?: boolean
    forum_submission?: boolean
    google_my_business_setup_verification?: boolean
    local_citation_submissions?: boolean
    google_places_photo_multimedia_additions?: boolean
    customer_reviews_ratings?: boolean
    local_classified_ads?: boolean
    monthly_keyword_improvement_report?: boolean
    monthly_back_links_report?: boolean
    monthly_google_analytic_static_report?: boolean
    email?: boolean
    telephone_whatsapp_telegram?: boolean
    internet_messenger_skype?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    status?: boolean
    Features?: boolean | subscriptionDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["package_features"]>

  export type package_featuresSelectScalar = {
    id?: boolean
    subscription_id?: boolean
    website_analysis?: boolean
    content_duplicacy?: boolean
    initial_backlinks?: boolean
    critical_seo_analysis?: boolean
    google_penalty_check?: boolean
    competition_analysis?: boolean
    competitor_backlinks_opportunity?: boolean
    keyword_research_analysis?: boolean
    on_page_optimization?: boolean
    title_tags_optimization?: boolean
    meta_tags_optimization?: boolean
    content_optimization?: boolean
    html_code_optimization?: boolean
    website_permalinks_analysis?: boolean
    seo_friendly_urls?: boolean
    schema_markup_analysis?: boolean
    internal_linking_optimization?: boolean
    crawl_error_resolution?: boolean
    heading_tags_optimization?: boolean
    canonicalization_301_redirect?: boolean
    custom_404_errors?: boolean
    images_optimization?: boolean
    hyperlink_optimization?: boolean
    robots_txt_creation_optimization?: boolean
    sitemap_creation?: boolean
    google_webmaster_tools_setup?: boolean
    bing_Webmaster_tools_setup?: boolean
    google_analytics_setup_Integration?: boolean
    website_responsive_check?: boolean
    page_speed_analysis?: boolean
    mobile_responsive_compatibility_check?: boolean
    navigation_ux_factors?: boolean
    ssl_certificate?: boolean
    web_2_0_400_600_words_blog_Writing?: boolean
    article_writing?: boolean
    classified_writing?: boolean
    press_release_writing?: boolean
    ppt_pdf_creation_writing?: boolean
    web_2_0_400_600_words_submission?: boolean
    web_2_0_blog_promotion?: boolean
    article_submission?: boolean
    article_promotion?: boolean
    guest_blogging?: boolean
    custom_graphics_to_support_your_blogs?: boolean
    social_bookmarking_links?: boolean
    press_release_submission?: boolean
    local_citation?: boolean
    classified_submissions?: boolean
    ppt_submission?: boolean
    ppt_promotion_backlinks?: boolean
    pdf_submission?: boolean
    pdf_promotion_backlinks?: boolean
    quora_Q_A?: boolean
    profile_creation?: boolean
    blog_commenting_niche_edu?: boolean
    forum_submission?: boolean
    google_my_business_setup_verification?: boolean
    local_citation_submissions?: boolean
    google_places_photo_multimedia_additions?: boolean
    customer_reviews_ratings?: boolean
    local_classified_ads?: boolean
    monthly_keyword_improvement_report?: boolean
    monthly_back_links_report?: boolean
    monthly_google_analytic_static_report?: boolean
    email?: boolean
    telephone_whatsapp_telegram?: boolean
    internet_messenger_skype?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    status?: boolean
  }

  export type package_featuresOmit<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetOmit<"id" | "subscription_id" | "website_analysis" | "content_duplicacy" | "initial_backlinks" | "critical_seo_analysis" | "google_penalty_check" | "competition_analysis" | "competitor_backlinks_opportunity" | "keyword_research_analysis" | "on_page_optimization" | "title_tags_optimization" | "meta_tags_optimization" | "content_optimization" | "html_code_optimization" | "website_permalinks_analysis" | "seo_friendly_urls" | "schema_markup_analysis" | "internal_linking_optimization" | "crawl_error_resolution" | "heading_tags_optimization" | "canonicalization_301_redirect" | "custom_404_errors" | "images_optimization" | "hyperlink_optimization" | "robots_txt_creation_optimization" | "sitemap_creation" | "google_webmaster_tools_setup" | "bing_Webmaster_tools_setup" | "google_analytics_setup_Integration" | "website_responsive_check" | "page_speed_analysis" | "mobile_responsive_compatibility_check" | "navigation_ux_factors" | "ssl_certificate" | "web_2_0_400_600_words_blog_Writing" | "article_writing" | "classified_writing" | "press_release_writing" | "ppt_pdf_creation_writing" | "web_2_0_400_600_words_submission" | "web_2_0_blog_promotion" | "article_submission" | "article_promotion" | "guest_blogging" | "custom_graphics_to_support_your_blogs" | "social_bookmarking_links" | "press_release_submission" | "local_citation" | "classified_submissions" | "ppt_submission" | "ppt_promotion_backlinks" | "pdf_submission" | "pdf_promotion_backlinks" | "quora_Q_A" | "profile_creation" | "blog_commenting_niche_edu" | "forum_submission" | "google_my_business_setup_verification" | "local_citation_submissions" | "google_places_photo_multimedia_additions" | "customer_reviews_ratings" | "local_classified_ads" | "monthly_keyword_improvement_report" | "monthly_back_links_report" | "monthly_google_analytic_static_report" | "email" | "telephone_whatsapp_telegram" | "internet_messenger_skype" | "created_at" | "updated_at" | "deleted_at" | "status", ExtArgs["result"]["package_features"]>
  export type package_featuresInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    Features?: boolean | subscriptionDefaultArgs<ExtArgs>
  }
  export type package_featuresIncludeCreateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    Features?: boolean | subscriptionDefaultArgs<ExtArgs>
  }
  export type package_featuresIncludeUpdateManyAndReturn<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    Features?: boolean | subscriptionDefaultArgs<ExtArgs>
  }

  export type $package_featuresPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "package_features"
    objects: {
      Features: Prisma.$subscriptionPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      subscription_id: number
      website_analysis: boolean
      content_duplicacy: boolean
      initial_backlinks: boolean
      critical_seo_analysis: boolean
      google_penalty_check: boolean
      competition_analysis: number
      competitor_backlinks_opportunity: number
      keyword_research_analysis: boolean
      on_page_optimization: boolean
      title_tags_optimization: boolean
      meta_tags_optimization: boolean
      content_optimization: boolean
      html_code_optimization: boolean
      website_permalinks_analysis: boolean
      seo_friendly_urls: boolean
      schema_markup_analysis: boolean
      internal_linking_optimization: boolean
      crawl_error_resolution: boolean
      heading_tags_optimization: boolean
      canonicalization_301_redirect: boolean
      custom_404_errors: boolean
      images_optimization: boolean
      hyperlink_optimization: boolean
      robots_txt_creation_optimization: boolean
      sitemap_creation: boolean
      google_webmaster_tools_setup: boolean
      bing_Webmaster_tools_setup: boolean
      google_analytics_setup_Integration: boolean
      website_responsive_check: boolean
      page_speed_analysis: boolean
      mobile_responsive_compatibility_check: boolean
      navigation_ux_factors: boolean
      ssl_certificate: boolean
      web_2_0_400_600_words_blog_Writing: number
      article_writing: number
      classified_writing: number
      press_release_writing: number
      ppt_pdf_creation_writing: number
      web_2_0_400_600_words_submission: number
      web_2_0_blog_promotion: number
      article_submission: number
      article_promotion: number
      guest_blogging: number
      custom_graphics_to_support_your_blogs: boolean
      social_bookmarking_links: number
      press_release_submission: number
      local_citation: number
      classified_submissions: number
      ppt_submission: number
      ppt_promotion_backlinks: number
      pdf_submission: number
      pdf_promotion_backlinks: number
      quora_Q_A: number
      profile_creation: number
      blog_commenting_niche_edu: number
      forum_submission: number
      google_my_business_setup_verification: boolean
      local_citation_submissions: number
      google_places_photo_multimedia_additions: boolean
      customer_reviews_ratings: number
      local_classified_ads: number
      monthly_keyword_improvement_report: boolean
      monthly_back_links_report: boolean
      monthly_google_analytic_static_report: boolean
      email: boolean
      telephone_whatsapp_telegram: boolean
      internet_messenger_skype: boolean
      created_at: Date
      updated_at: Date
      deleted_at: Date | null
      status: number | null
    }, ExtArgs["result"]["package_features"]>
    composites: {}
  }

  type package_featuresGetPayload<S extends boolean | null | undefined | package_featuresDefaultArgs> = $Result.GetResult<Prisma.$package_featuresPayload, S>

  type package_featuresCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> =
    Omit<package_featuresFindManyArgs, 'select' | 'include' | 'distinct' | 'omit'> & {
      select?: Package_featuresCountAggregateInputType | true
    }

  export interface package_featuresDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['package_features'], meta: { name: 'package_features' } }
    /**
     * Find zero or one Package_features that matches the filter.
     * @param {package_featuresFindUniqueArgs} args - Arguments to find a Package_features
     * @example
     * // Get one Package_features
     * const package_features = await prisma.package_features.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUnique<T extends package_featuresFindUniqueArgs>(args: SelectSubset<T, package_featuresFindUniqueArgs<ExtArgs>>): Prisma__package_featuresClient<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "findUnique", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find one Package_features that matches the filter or throw an error with `error.code='P2025'`
     * if no matches were found.
     * @param {package_featuresFindUniqueOrThrowArgs} args - Arguments to find a Package_features
     * @example
     * // Get one Package_features
     * const package_features = await prisma.package_features.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findUniqueOrThrow<T extends package_featuresFindUniqueOrThrowArgs>(args: SelectSubset<T, package_featuresFindUniqueOrThrowArgs<ExtArgs>>): Prisma__package_featuresClient<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find the first Package_features that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {package_featuresFindFirstArgs} args - Arguments to find a Package_features
     * @example
     * // Get one Package_features
     * const package_features = await prisma.package_features.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirst<T extends package_featuresFindFirstArgs>(args?: SelectSubset<T, package_featuresFindFirstArgs<ExtArgs>>): Prisma__package_featuresClient<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "findFirst", ClientOptions> | null, null, ExtArgs, ClientOptions>

    /**
     * Find the first Package_features that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {package_featuresFindFirstOrThrowArgs} args - Arguments to find a Package_features
     * @example
     * // Get one Package_features
     * const package_features = await prisma.package_features.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     */
    findFirstOrThrow<T extends package_featuresFindFirstOrThrowArgs>(args?: SelectSubset<T, package_featuresFindFirstOrThrowArgs<ExtArgs>>): Prisma__package_featuresClient<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "findFirstOrThrow", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Find zero or more Package_features that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {package_featuresFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Package_features
     * const package_features = await prisma.package_features.findMany()
     * 
     * // Get first 10 Package_features
     * const package_features = await prisma.package_features.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const package_featuresWithIdOnly = await prisma.package_features.findMany({ select: { id: true } })
     * 
     */
    findMany<T extends package_featuresFindManyArgs>(args?: SelectSubset<T, package_featuresFindManyArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "findMany", ClientOptions>>

    /**
     * Create a Package_features.
     * @param {package_featuresCreateArgs} args - Arguments to create a Package_features.
     * @example
     * // Create one Package_features
     * const Package_features = await prisma.package_features.create({
     *   data: {
     *     // ... data to create a Package_features
     *   }
     * })
     * 
     */
    create<T extends package_featuresCreateArgs>(args: SelectSubset<T, package_featuresCreateArgs<ExtArgs>>): Prisma__package_featuresClient<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "create", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Create many Package_features.
     * @param {package_featuresCreateManyArgs} args - Arguments to create many Package_features.
     * @example
     * // Create many Package_features
     * const package_features = await prisma.package_features.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
     */
    createMany<T extends package_featuresCreateManyArgs>(args?: SelectSubset<T, package_featuresCreateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Package_features and returns the data saved in the database.
     * @param {package_featuresCreateManyAndReturnArgs} args - Arguments to create many Package_features.
     * @example
     * // Create many Package_features
     * const package_features = await prisma.package_features.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Package_features and only return the `id`
     * const package_featuresWithIdOnly = await prisma.package_features.createManyAndReturn({
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    createManyAndReturn<T extends package_featuresCreateManyAndReturnArgs>(args?: SelectSubset<T, package_featuresCreateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "createManyAndReturn", ClientOptions>>

    /**
     * Delete a Package_features.
     * @param {package_featuresDeleteArgs} args - Arguments to delete one Package_features.
     * @example
     * // Delete one Package_features
     * const Package_features = await prisma.package_features.delete({
     *   where: {
     *     // ... filter to delete one Package_features
     *   }
     * })
     * 
     */
    delete<T extends package_featuresDeleteArgs>(args: SelectSubset<T, package_featuresDeleteArgs<ExtArgs>>): Prisma__package_featuresClient<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "delete", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Update one Package_features.
     * @param {package_featuresUpdateArgs} args - Arguments to update one Package_features.
     * @example
     * // Update one Package_features
     * const package_features = await prisma.package_features.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    update<T extends package_featuresUpdateArgs>(args: SelectSubset<T, package_featuresUpdateArgs<ExtArgs>>): Prisma__package_featuresClient<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "update", ClientOptions>, never, ExtArgs, ClientOptions>

    /**
     * Delete zero or more Package_features.
     * @param {package_featuresDeleteManyArgs} args - Arguments to filter Package_features to delete.
     * @example
     * // Delete a few Package_features
     * const { count } = await prisma.package_features.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
     */
    deleteMany<T extends package_featuresDeleteManyArgs>(args?: SelectSubset<T, package_featuresDeleteManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Package_features.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {package_featuresUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Package_features
     * const package_features = await prisma.package_features.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
     */
    updateMany<T extends package_featuresUpdateManyArgs>(args: SelectSubset<T, package_featuresUpdateManyArgs<ExtArgs>>): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Package_features and returns the data updated in the database.
     * @param {package_featuresUpdateManyAndReturnArgs} args - Arguments to update many Package_features.
     * @example
     * // Update many Package_features
     * const package_features = await prisma.package_features.updateManyAndReturn({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Update zero or more Package_features and only return the `id`
     * const package_featuresWithIdOnly = await prisma.package_features.updateManyAndReturn({
     *   select: { id: true },
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
     */
    updateManyAndReturn<T extends package_featuresUpdateManyAndReturnArgs>(args: SelectSubset<T, package_featuresUpdateManyAndReturnArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "updateManyAndReturn", ClientOptions>>

    /**
     * Create or update one Package_features.
     * @param {package_featuresUpsertArgs} args - Arguments to update or create a Package_features.
     * @example
     * // Update or create a Package_features
     * const package_features = await prisma.package_features.upsert({
     *   create: {
     *     // ... data to create a Package_features
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Package_features we want to update
     *   }
     * })
     */
    upsert<T extends package_featuresUpsertArgs>(args: SelectSubset<T, package_featuresUpsertArgs<ExtArgs>>): Prisma__package_featuresClient<$Result.GetResult<Prisma.$package_featuresPayload<ExtArgs>, T, "upsert", ClientOptions>, never, ExtArgs, ClientOptions>


    /**
     * Count the number of Package_features.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {package_featuresCountArgs} args - Arguments to filter Package_features to count.
     * @example
     * // Count the number of Package_features
     * const count = await prisma.package_features.count({
     *   where: {
     *     // ... the filter for the Package_features we want to count
     *   }
     * })
    **/
    count<T extends package_featuresCountArgs>(
      args?: Subset<T, package_featuresCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], Package_featuresCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Package_features.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {Package_featuresAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends Package_featuresAggregateArgs>(args: Subset<T, Package_featuresAggregateArgs>): Prisma.PrismaPromise<GetPackage_featuresAggregateType<T>>

    /**
     * Group by Package_features.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {package_featuresGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends package_featuresGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: package_featuresGroupByArgs['orderBy'] }
        : { orderBy?: package_featuresGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, package_featuresGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetPackage_featuresGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the package_features model
   */
  readonly fields: package_featuresFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for package_features.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__package_featuresClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs, ClientOptions = {}> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: "PrismaPromise"
    Features<T extends subscriptionDefaultArgs<ExtArgs> = {}>(args?: Subset<T, subscriptionDefaultArgs<ExtArgs>>): Prisma__subscriptionClient<$Result.GetResult<Prisma.$subscriptionPayload<ExtArgs>, T, "findUniqueOrThrow", ClientOptions> | Null, Null, ExtArgs, ClientOptions>
    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>
  }




  /**
   * Fields of the package_features model
   */ 
  interface package_featuresFieldRefs {
    readonly id: FieldRef<"package_features", 'Int'>
    readonly subscription_id: FieldRef<"package_features", 'Int'>
    readonly website_analysis: FieldRef<"package_features", 'Boolean'>
    readonly content_duplicacy: FieldRef<"package_features", 'Boolean'>
    readonly initial_backlinks: FieldRef<"package_features", 'Boolean'>
    readonly critical_seo_analysis: FieldRef<"package_features", 'Boolean'>
    readonly google_penalty_check: FieldRef<"package_features", 'Boolean'>
    readonly competition_analysis: FieldRef<"package_features", 'Int'>
    readonly competitor_backlinks_opportunity: FieldRef<"package_features", 'Int'>
    readonly keyword_research_analysis: FieldRef<"package_features", 'Boolean'>
    readonly on_page_optimization: FieldRef<"package_features", 'Boolean'>
    readonly title_tags_optimization: FieldRef<"package_features", 'Boolean'>
    readonly meta_tags_optimization: FieldRef<"package_features", 'Boolean'>
    readonly content_optimization: FieldRef<"package_features", 'Boolean'>
    readonly html_code_optimization: FieldRef<"package_features", 'Boolean'>
    readonly website_permalinks_analysis: FieldRef<"package_features", 'Boolean'>
    readonly seo_friendly_urls: FieldRef<"package_features", 'Boolean'>
    readonly schema_markup_analysis: FieldRef<"package_features", 'Boolean'>
    readonly internal_linking_optimization: FieldRef<"package_features", 'Boolean'>
    readonly crawl_error_resolution: FieldRef<"package_features", 'Boolean'>
    readonly heading_tags_optimization: FieldRef<"package_features", 'Boolean'>
    readonly canonicalization_301_redirect: FieldRef<"package_features", 'Boolean'>
    readonly custom_404_errors: FieldRef<"package_features", 'Boolean'>
    readonly images_optimization: FieldRef<"package_features", 'Boolean'>
    readonly hyperlink_optimization: FieldRef<"package_features", 'Boolean'>
    readonly robots_txt_creation_optimization: FieldRef<"package_features", 'Boolean'>
    readonly sitemap_creation: FieldRef<"package_features", 'Boolean'>
    readonly google_webmaster_tools_setup: FieldRef<"package_features", 'Boolean'>
    readonly bing_Webmaster_tools_setup: FieldRef<"package_features", 'Boolean'>
    readonly google_analytics_setup_Integration: FieldRef<"package_features", 'Boolean'>
    readonly website_responsive_check: FieldRef<"package_features", 'Boolean'>
    readonly page_speed_analysis: FieldRef<"package_features", 'Boolean'>
    readonly mobile_responsive_compatibility_check: FieldRef<"package_features", 'Boolean'>
    readonly navigation_ux_factors: FieldRef<"package_features", 'Boolean'>
    readonly ssl_certificate: FieldRef<"package_features", 'Boolean'>
    readonly web_2_0_400_600_words_blog_Writing: FieldRef<"package_features", 'Int'>
    readonly article_writing: FieldRef<"package_features", 'Int'>
    readonly classified_writing: FieldRef<"package_features", 'Int'>
    readonly press_release_writing: FieldRef<"package_features", 'Int'>
    readonly ppt_pdf_creation_writing: FieldRef<"package_features", 'Int'>
    readonly web_2_0_400_600_words_submission: FieldRef<"package_features", 'Int'>
    readonly web_2_0_blog_promotion: FieldRef<"package_features", 'Int'>
    readonly article_submission: FieldRef<"package_features", 'Int'>
    readonly article_promotion: FieldRef<"package_features", 'Int'>
    readonly guest_blogging: FieldRef<"package_features", 'Int'>
    readonly custom_graphics_to_support_your_blogs: FieldRef<"package_features", 'Boolean'>
    readonly social_bookmarking_links: FieldRef<"package_features", 'Int'>
    readonly press_release_submission: FieldRef<"package_features", 'Int'>
    readonly local_citation: FieldRef<"package_features", 'Int'>
    readonly classified_submissions: FieldRef<"package_features", 'Int'>
    readonly ppt_submission: FieldRef<"package_features", 'Int'>
    readonly ppt_promotion_backlinks: FieldRef<"package_features", 'Int'>
    readonly pdf_submission: FieldRef<"package_features", 'Int'>
    readonly pdf_promotion_backlinks: FieldRef<"package_features", 'Int'>
    readonly quora_Q_A: FieldRef<"package_features", 'Int'>
    readonly profile_creation: FieldRef<"package_features", 'Int'>
    readonly blog_commenting_niche_edu: FieldRef<"package_features", 'Int'>
    readonly forum_submission: FieldRef<"package_features", 'Int'>
    readonly google_my_business_setup_verification: FieldRef<"package_features", 'Boolean'>
    readonly local_citation_submissions: FieldRef<"package_features", 'Int'>
    readonly google_places_photo_multimedia_additions: FieldRef<"package_features", 'Boolean'>
    readonly customer_reviews_ratings: FieldRef<"package_features", 'Int'>
    readonly local_classified_ads: FieldRef<"package_features", 'Int'>
    readonly monthly_keyword_improvement_report: FieldRef<"package_features", 'Boolean'>
    readonly monthly_back_links_report: FieldRef<"package_features", 'Boolean'>
    readonly monthly_google_analytic_static_report: FieldRef<"package_features", 'Boolean'>
    readonly email: FieldRef<"package_features", 'Boolean'>
    readonly telephone_whatsapp_telegram: FieldRef<"package_features", 'Boolean'>
    readonly internet_messenger_skype: FieldRef<"package_features", 'Boolean'>
    readonly created_at: FieldRef<"package_features", 'DateTime'>
    readonly updated_at: FieldRef<"package_features", 'DateTime'>
    readonly deleted_at: FieldRef<"package_features", 'DateTime'>
    readonly status: FieldRef<"package_features", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * package_features findUnique
   */
  export type package_featuresFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelect<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresInclude<ExtArgs> | null
    /**
     * Filter, which package_features to fetch.
     */
    where: package_featuresWhereUniqueInput
  }

  /**
   * package_features findUniqueOrThrow
   */
  export type package_featuresFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelect<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresInclude<ExtArgs> | null
    /**
     * Filter, which package_features to fetch.
     */
    where: package_featuresWhereUniqueInput
  }

  /**
   * package_features findFirst
   */
  export type package_featuresFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelect<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresInclude<ExtArgs> | null
    /**
     * Filter, which package_features to fetch.
     */
    where?: package_featuresWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of package_features to fetch.
     */
    orderBy?: package_featuresOrderByWithRelationInput | package_featuresOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for package_features.
     */
    cursor?: package_featuresWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` package_features from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` package_features.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of package_features.
     */
    distinct?: Package_featuresScalarFieldEnum | Package_featuresScalarFieldEnum[]
  }

  /**
   * package_features findFirstOrThrow
   */
  export type package_featuresFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelect<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresInclude<ExtArgs> | null
    /**
     * Filter, which package_features to fetch.
     */
    where?: package_featuresWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of package_features to fetch.
     */
    orderBy?: package_featuresOrderByWithRelationInput | package_featuresOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for package_features.
     */
    cursor?: package_featuresWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` package_features from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` package_features.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of package_features.
     */
    distinct?: Package_featuresScalarFieldEnum | Package_featuresScalarFieldEnum[]
  }

  /**
   * package_features findMany
   */
  export type package_featuresFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelect<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresInclude<ExtArgs> | null
    /**
     * Filter, which package_features to fetch.
     */
    where?: package_featuresWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of package_features to fetch.
     */
    orderBy?: package_featuresOrderByWithRelationInput | package_featuresOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing package_features.
     */
    cursor?: package_featuresWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` package_features from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` package_features.
     */
    skip?: number
    distinct?: Package_featuresScalarFieldEnum | Package_featuresScalarFieldEnum[]
  }

  /**
   * package_features create
   */
  export type package_featuresCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelect<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresInclude<ExtArgs> | null
    /**
     * The data needed to create a package_features.
     */
    data: XOR<package_featuresCreateInput, package_featuresUncheckedCreateInput>
  }

  /**
   * package_features createMany
   */
  export type package_featuresCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many package_features.
     */
    data: package_featuresCreateManyInput | package_featuresCreateManyInput[]
    skipDuplicates?: boolean
  }

  /**
   * package_features createManyAndReturn
   */
  export type package_featuresCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelectCreateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * The data used to create many package_features.
     */
    data: package_featuresCreateManyInput | package_featuresCreateManyInput[]
    skipDuplicates?: boolean
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresIncludeCreateManyAndReturn<ExtArgs> | null
  }

  /**
   * package_features update
   */
  export type package_featuresUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelect<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresInclude<ExtArgs> | null
    /**
     * The data needed to update a package_features.
     */
    data: XOR<package_featuresUpdateInput, package_featuresUncheckedUpdateInput>
    /**
     * Choose, which package_features to update.
     */
    where: package_featuresWhereUniqueInput
  }

  /**
   * package_features updateMany
   */
  export type package_featuresUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update package_features.
     */
    data: XOR<package_featuresUpdateManyMutationInput, package_featuresUncheckedUpdateManyInput>
    /**
     * Filter which package_features to update
     */
    where?: package_featuresWhereInput
    /**
     * Limit how many package_features to update.
     */
    limit?: number
  }

  /**
   * package_features updateManyAndReturn
   */
  export type package_featuresUpdateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelectUpdateManyAndReturn<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * The data used to update package_features.
     */
    data: XOR<package_featuresUpdateManyMutationInput, package_featuresUncheckedUpdateManyInput>
    /**
     * Filter which package_features to update
     */
    where?: package_featuresWhereInput
    /**
     * Limit how many package_features to update.
     */
    limit?: number
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresIncludeUpdateManyAndReturn<ExtArgs> | null
  }

  /**
   * package_features upsert
   */
  export type package_featuresUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelect<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresInclude<ExtArgs> | null
    /**
     * The filter to search for the package_features to update in case it exists.
     */
    where: package_featuresWhereUniqueInput
    /**
     * In case the package_features found by the `where` argument doesn't exist, create a new package_features with this data.
     */
    create: XOR<package_featuresCreateInput, package_featuresUncheckedCreateInput>
    /**
     * In case the package_features was found with the provided `where` argument, update it with this data.
     */
    update: XOR<package_featuresUpdateInput, package_featuresUncheckedUpdateInput>
  }

  /**
   * package_features delete
   */
  export type package_featuresDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelect<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresInclude<ExtArgs> | null
    /**
     * Filter which package_features to delete.
     */
    where: package_featuresWhereUniqueInput
  }

  /**
   * package_features deleteMany
   */
  export type package_featuresDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which package_features to delete
     */
    where?: package_featuresWhereInput
    /**
     * Limit how many package_features to delete.
     */
    limit?: number
  }

  /**
   * package_features without action
   */
  export type package_featuresDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the package_features
     */
    select?: package_featuresSelect<ExtArgs> | null
    /**
     * Omit specific fields from the package_features
     */
    omit?: package_featuresOmit<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: package_featuresInclude<ExtArgs> | null
  }


  /**
   * Enums
   */

  export const TransactionIsolationLevel: {
    ReadUncommitted: 'ReadUncommitted',
    ReadCommitted: 'ReadCommitted',
    RepeatableRead: 'RepeatableRead',
    Serializable: 'Serializable'
  };

  export type TransactionIsolationLevel = (typeof TransactionIsolationLevel)[keyof typeof TransactionIsolationLevel]


  export const ProjectsScalarFieldEnum: {
    id: 'id',
    domain_name: 'domain_name',
    domain_url: 'domain_url',
    category_id: 'category_id',
    created_by_id: 'created_by_id',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at',
    time_around: 'time_around',
    time_around_days: 'time_around_days'
  };

  export type ProjectsScalarFieldEnum = (typeof ProjectsScalarFieldEnum)[keyof typeof ProjectsScalarFieldEnum]


  export const BacklinkScalarFieldEnum: {
    id: 'id',
    link_url: 'link_url',
    link_status: 'link_status',
    is_index: 'is_index',
    link_rel: 'link_rel',
    anchor_text: 'anchor_text',
    targeted_url: 'targeted_url',
    project_id: 'project_id',
    uploaded_by_id: 'uploaded_by_id',
    first_seen: 'first_seen',
    last_seen: 'last_seen',
    added_date: 'added_date',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at',
    backlink_duplicate: 'backlink_duplicate',
    referring_domain: 'referring_domain',
    managed_by: 'managed_by'
  };

  export type BacklinkScalarFieldEnum = (typeof BacklinkScalarFieldEnum)[keyof typeof BacklinkScalarFieldEnum]


  export const Permissions_listScalarFieldEnum: {
    id: 'id',
    title: 'title',
    type: 'type',
    created_by: 'created_by',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at'
  };

  export type Permissions_listScalarFieldEnum = (typeof Permissions_listScalarFieldEnum)[keyof typeof Permissions_listScalarFieldEnum]


  export const RolesScalarFieldEnum: {
    id: 'id',
    name: 'name',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at'
  };

  export type RolesScalarFieldEnum = (typeof RolesScalarFieldEnum)[keyof typeof RolesScalarFieldEnum]


  export const SubscriptionScalarFieldEnum: {
    id: 'id',
    name: 'name',
    status: 'status',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at'
  };

  export type SubscriptionScalarFieldEnum = (typeof SubscriptionScalarFieldEnum)[keyof typeof SubscriptionScalarFieldEnum]


  export const Subscription_featureScalarFieldEnum: {
    id: 'id',
    status: 'status',
    subscription_id: 'subscription_id',
    permission_id: 'permission_id',
    limit: 'limit',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at'
  };

  export type Subscription_featureScalarFieldEnum = (typeof Subscription_featureScalarFieldEnum)[keyof typeof Subscription_featureScalarFieldEnum]


  export const User_subscriptionScalarFieldEnum: {
    id: 'id',
    user_id: 'user_id',
    created_by_id: 'created_by_id',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at',
    subscription_id: 'subscription_id'
  };

  export type User_subscriptionScalarFieldEnum = (typeof User_subscriptionScalarFieldEnum)[keyof typeof User_subscriptionScalarFieldEnum]


  export const User_permissionsScalarFieldEnum: {
    id: 'id',
    user_id: 'user_id',
    limit: 'limit',
    permission_id: 'permission_id',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at'
  };

  export type User_permissionsScalarFieldEnum = (typeof User_permissionsScalarFieldEnum)[keyof typeof User_permissionsScalarFieldEnum]


  export const Package_featuresScalarFieldEnum: {
    id: 'id',
    subscription_id: 'subscription_id',
    website_analysis: 'website_analysis',
    content_duplicacy: 'content_duplicacy',
    initial_backlinks: 'initial_backlinks',
    critical_seo_analysis: 'critical_seo_analysis',
    google_penalty_check: 'google_penalty_check',
    competition_analysis: 'competition_analysis',
    competitor_backlinks_opportunity: 'competitor_backlinks_opportunity',
    keyword_research_analysis: 'keyword_research_analysis',
    on_page_optimization: 'on_page_optimization',
    title_tags_optimization: 'title_tags_optimization',
    meta_tags_optimization: 'meta_tags_optimization',
    content_optimization: 'content_optimization',
    html_code_optimization: 'html_code_optimization',
    website_permalinks_analysis: 'website_permalinks_analysis',
    seo_friendly_urls: 'seo_friendly_urls',
    schema_markup_analysis: 'schema_markup_analysis',
    internal_linking_optimization: 'internal_linking_optimization',
    crawl_error_resolution: 'crawl_error_resolution',
    heading_tags_optimization: 'heading_tags_optimization',
    canonicalization_301_redirect: 'canonicalization_301_redirect',
    custom_404_errors: 'custom_404_errors',
    images_optimization: 'images_optimization',
    hyperlink_optimization: 'hyperlink_optimization',
    robots_txt_creation_optimization: 'robots_txt_creation_optimization',
    sitemap_creation: 'sitemap_creation',
    google_webmaster_tools_setup: 'google_webmaster_tools_setup',
    bing_Webmaster_tools_setup: 'bing_Webmaster_tools_setup',
    google_analytics_setup_Integration: 'google_analytics_setup_Integration',
    website_responsive_check: 'website_responsive_check',
    page_speed_analysis: 'page_speed_analysis',
    mobile_responsive_compatibility_check: 'mobile_responsive_compatibility_check',
    navigation_ux_factors: 'navigation_ux_factors',
    ssl_certificate: 'ssl_certificate',
    web_2_0_400_600_words_blog_Writing: 'web_2_0_400_600_words_blog_Writing',
    article_writing: 'article_writing',
    classified_writing: 'classified_writing',
    press_release_writing: 'press_release_writing',
    ppt_pdf_creation_writing: 'ppt_pdf_creation_writing',
    web_2_0_400_600_words_submission: 'web_2_0_400_600_words_submission',
    web_2_0_blog_promotion: 'web_2_0_blog_promotion',
    article_submission: 'article_submission',
    article_promotion: 'article_promotion',
    guest_blogging: 'guest_blogging',
    custom_graphics_to_support_your_blogs: 'custom_graphics_to_support_your_blogs',
    social_bookmarking_links: 'social_bookmarking_links',
    press_release_submission: 'press_release_submission',
    local_citation: 'local_citation',
    classified_submissions: 'classified_submissions',
    ppt_submission: 'ppt_submission',
    ppt_promotion_backlinks: 'ppt_promotion_backlinks',
    pdf_submission: 'pdf_submission',
    pdf_promotion_backlinks: 'pdf_promotion_backlinks',
    quora_Q_A: 'quora_Q_A',
    profile_creation: 'profile_creation',
    blog_commenting_niche_edu: 'blog_commenting_niche_edu',
    forum_submission: 'forum_submission',
    google_my_business_setup_verification: 'google_my_business_setup_verification',
    local_citation_submissions: 'local_citation_submissions',
    google_places_photo_multimedia_additions: 'google_places_photo_multimedia_additions',
    customer_reviews_ratings: 'customer_reviews_ratings',
    local_classified_ads: 'local_classified_ads',
    monthly_keyword_improvement_report: 'monthly_keyword_improvement_report',
    monthly_back_links_report: 'monthly_back_links_report',
    monthly_google_analytic_static_report: 'monthly_google_analytic_static_report',
    email: 'email',
    telephone_whatsapp_telegram: 'telephone_whatsapp_telegram',
    internet_messenger_skype: 'internet_messenger_skype',
    created_at: 'created_at',
    updated_at: 'updated_at',
    deleted_at: 'deleted_at',
    status: 'status'
  };

  export type Package_featuresScalarFieldEnum = (typeof Package_featuresScalarFieldEnum)[keyof typeof Package_featuresScalarFieldEnum]


  export const SortOrder: {
    asc: 'asc',
    desc: 'desc'
  };

  export type SortOrder = (typeof SortOrder)[keyof typeof SortOrder]


  export const QueryMode: {
    default: 'default',
    insensitive: 'insensitive'
  };

  export type QueryMode = (typeof QueryMode)[keyof typeof QueryMode]


  export const NullsOrder: {
    first: 'first',
    last: 'last'
  };

  export type NullsOrder = (typeof NullsOrder)[keyof typeof NullsOrder]


  /**
   * Field references 
   */


  /**
   * Reference to a field of type 'Int'
   */
  export type IntFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Int'>
    


  /**
   * Reference to a field of type 'Int[]'
   */
  export type ListIntFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Int[]'>
    


  /**
   * Reference to a field of type 'String'
   */
  export type StringFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'String'>
    


  /**
   * Reference to a field of type 'String[]'
   */
  export type ListStringFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'String[]'>
    


  /**
   * Reference to a field of type 'DateTime'
   */
  export type DateTimeFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'DateTime'>
    


  /**
   * Reference to a field of type 'DateTime[]'
   */
  export type ListDateTimeFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'DateTime[]'>
    


  /**
   * Reference to a field of type 'Boolean'
   */
  export type BooleanFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Boolean'>
    


  /**
   * Reference to a field of type 'Float'
   */
  export type FloatFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Float'>
    


  /**
   * Reference to a field of type 'Float[]'
   */
  export type ListFloatFieldRefInput<$PrismaModel> = FieldRefInputType<$PrismaModel, 'Float[]'>
    
  /**
   * Deep Input Types
   */


  export type ProjectsWhereInput = {
    AND?: ProjectsWhereInput | ProjectsWhereInput[]
    OR?: ProjectsWhereInput[]
    NOT?: ProjectsWhereInput | ProjectsWhereInput[]
    id?: IntFilter<"Projects"> | number
    domain_name?: StringFilter<"Projects"> | string
    domain_url?: StringFilter<"Projects"> | string
    category_id?: IntFilter<"Projects"> | number
    created_by_id?: IntFilter<"Projects"> | number
    created_at?: DateTimeFilter<"Projects"> | Date | string
    updated_at?: DateTimeFilter<"Projects"> | Date | string
    deleted_at?: DateTimeNullableFilter<"Projects"> | Date | string | null
    time_around?: DateTimeNullableFilter<"Projects"> | Date | string | null
    time_around_days?: IntFilter<"Projects"> | number
    Backlink?: BacklinkListRelationFilter
  }

  export type ProjectsOrderByWithRelationInput = {
    id?: SortOrder
    domain_name?: SortOrder
    domain_url?: SortOrder
    category_id?: SortOrder
    created_by_id?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrderInput | SortOrder
    time_around?: SortOrderInput | SortOrder
    time_around_days?: SortOrder
    Backlink?: BacklinkOrderByRelationAggregateInput
  }

  export type ProjectsWhereUniqueInput = Prisma.AtLeast<{
    id?: number
    domain_url?: string
    AND?: ProjectsWhereInput | ProjectsWhereInput[]
    OR?: ProjectsWhereInput[]
    NOT?: ProjectsWhereInput | ProjectsWhereInput[]
    domain_name?: StringFilter<"Projects"> | string
    category_id?: IntFilter<"Projects"> | number
    created_by_id?: IntFilter<"Projects"> | number
    created_at?: DateTimeFilter<"Projects"> | Date | string
    updated_at?: DateTimeFilter<"Projects"> | Date | string
    deleted_at?: DateTimeNullableFilter<"Projects"> | Date | string | null
    time_around?: DateTimeNullableFilter<"Projects"> | Date | string | null
    time_around_days?: IntFilter<"Projects"> | number
    Backlink?: BacklinkListRelationFilter
  }, "id" | "domain_url">

  export type ProjectsOrderByWithAggregationInput = {
    id?: SortOrder
    domain_name?: SortOrder
    domain_url?: SortOrder
    category_id?: SortOrder
    created_by_id?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrderInput | SortOrder
    time_around?: SortOrderInput | SortOrder
    time_around_days?: SortOrder
    _count?: ProjectsCountOrderByAggregateInput
    _avg?: ProjectsAvgOrderByAggregateInput
    _max?: ProjectsMaxOrderByAggregateInput
    _min?: ProjectsMinOrderByAggregateInput
    _sum?: ProjectsSumOrderByAggregateInput
  }

  export type ProjectsScalarWhereWithAggregatesInput = {
    AND?: ProjectsScalarWhereWithAggregatesInput | ProjectsScalarWhereWithAggregatesInput[]
    OR?: ProjectsScalarWhereWithAggregatesInput[]
    NOT?: ProjectsScalarWhereWithAggregatesInput | ProjectsScalarWhereWithAggregatesInput[]
    id?: IntWithAggregatesFilter<"Projects"> | number
    domain_name?: StringWithAggregatesFilter<"Projects"> | string
    domain_url?: StringWithAggregatesFilter<"Projects"> | string
    category_id?: IntWithAggregatesFilter<"Projects"> | number
    created_by_id?: IntWithAggregatesFilter<"Projects"> | number
    created_at?: DateTimeWithAggregatesFilter<"Projects"> | Date | string
    updated_at?: DateTimeWithAggregatesFilter<"Projects"> | Date | string
    deleted_at?: DateTimeNullableWithAggregatesFilter<"Projects"> | Date | string | null
    time_around?: DateTimeNullableWithAggregatesFilter<"Projects"> | Date | string | null
    time_around_days?: IntWithAggregatesFilter<"Projects"> | number
  }

  export type BacklinkWhereInput = {
    AND?: BacklinkWhereInput | BacklinkWhereInput[]
    OR?: BacklinkWhereInput[]
    NOT?: BacklinkWhereInput | BacklinkWhereInput[]
    id?: IntFilter<"Backlink"> | number
    link_url?: StringFilter<"Backlink"> | string
    link_status?: IntFilter<"Backlink"> | number
    is_index?: BoolNullableFilter<"Backlink"> | boolean | null
    link_rel?: StringNullableFilter<"Backlink"> | string | null
    anchor_text?: StringNullableFilter<"Backlink"> | string | null
    targeted_url?: StringNullableFilter<"Backlink"> | string | null
    project_id?: IntFilter<"Backlink"> | number
    uploaded_by_id?: IntNullableFilter<"Backlink"> | number | null
    first_seen?: DateTimeNullableFilter<"Backlink"> | Date | string | null
    last_seen?: DateTimeNullableFilter<"Backlink"> | Date | string | null
    added_date?: DateTimeNullableFilter<"Backlink"> | Date | string | null
    created_at?: DateTimeFilter<"Backlink"> | Date | string
    updated_at?: DateTimeFilter<"Backlink"> | Date | string
    deleted_at?: DateTimeNullableFilter<"Backlink"> | Date | string | null
    backlink_duplicate?: BoolNullableFilter<"Backlink"> | boolean | null
    referring_domain?: BoolNullableFilter<"Backlink"> | boolean | null
    managed_by?: IntNullableFilter<"Backlink"> | number | null
    ProjectLinks?: XOR<ProjectsScalarRelationFilter, ProjectsWhereInput>
  }

  export type BacklinkOrderByWithRelationInput = {
    id?: SortOrder
    link_url?: SortOrder
    link_status?: SortOrder
    is_index?: SortOrderInput | SortOrder
    link_rel?: SortOrderInput | SortOrder
    anchor_text?: SortOrderInput | SortOrder
    targeted_url?: SortOrderInput | SortOrder
    project_id?: SortOrder
    uploaded_by_id?: SortOrderInput | SortOrder
    first_seen?: SortOrderInput | SortOrder
    last_seen?: SortOrderInput | SortOrder
    added_date?: SortOrderInput | SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrderInput | SortOrder
    backlink_duplicate?: SortOrderInput | SortOrder
    referring_domain?: SortOrderInput | SortOrder
    managed_by?: SortOrderInput | SortOrder
    ProjectLinks?: ProjectsOrderByWithRelationInput
  }

  export type BacklinkWhereUniqueInput = Prisma.AtLeast<{
    id?: number
    AND?: BacklinkWhereInput | BacklinkWhereInput[]
    OR?: BacklinkWhereInput[]
    NOT?: BacklinkWhereInput | BacklinkWhereInput[]
    link_url?: StringFilter<"Backlink"> | string
    link_status?: IntFilter<"Backlink"> | number
    is_index?: BoolNullableFilter<"Backlink"> | boolean | null
    link_rel?: StringNullableFilter<"Backlink"> | string | null
    anchor_text?: StringNullableFilter<"Backlink"> | string | null
    targeted_url?: StringNullableFilter<"Backlink"> | string | null
    project_id?: IntFilter<"Backlink"> | number
    uploaded_by_id?: IntNullableFilter<"Backlink"> | number | null
    first_seen?: DateTimeNullableFilter<"Backlink"> | Date | string | null
    last_seen?: DateTimeNullableFilter<"Backlink"> | Date | string | null
    added_date?: DateTimeNullableFilter<"Backlink"> | Date | string | null
    created_at?: DateTimeFilter<"Backlink"> | Date | string
    updated_at?: DateTimeFilter<"Backlink"> | Date | string
    deleted_at?: DateTimeNullableFilter<"Backlink"> | Date | string | null
    backlink_duplicate?: BoolNullableFilter<"Backlink"> | boolean | null
    referring_domain?: BoolNullableFilter<"Backlink"> | boolean | null
    managed_by?: IntNullableFilter<"Backlink"> | number | null
    ProjectLinks?: XOR<ProjectsScalarRelationFilter, ProjectsWhereInput>
  }, "id">

  export type BacklinkOrderByWithAggregationInput = {
    id?: SortOrder
    link_url?: SortOrder
    link_status?: SortOrder
    is_index?: SortOrderInput | SortOrder
    link_rel?: SortOrderInput | SortOrder
    anchor_text?: SortOrderInput | SortOrder
    targeted_url?: SortOrderInput | SortOrder
    project_id?: SortOrder
    uploaded_by_id?: SortOrderInput | SortOrder
    first_seen?: SortOrderInput | SortOrder
    last_seen?: SortOrderInput | SortOrder
    added_date?: SortOrderInput | SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrderInput | SortOrder
    backlink_duplicate?: SortOrderInput | SortOrder
    referring_domain?: SortOrderInput | SortOrder
    managed_by?: SortOrderInput | SortOrder
    _count?: BacklinkCountOrderByAggregateInput
    _avg?: BacklinkAvgOrderByAggregateInput
    _max?: BacklinkMaxOrderByAggregateInput
    _min?: BacklinkMinOrderByAggregateInput
    _sum?: BacklinkSumOrderByAggregateInput
  }

  export type BacklinkScalarWhereWithAggregatesInput = {
    AND?: BacklinkScalarWhereWithAggregatesInput | BacklinkScalarWhereWithAggregatesInput[]
    OR?: BacklinkScalarWhereWithAggregatesInput[]
    NOT?: BacklinkScalarWhereWithAggregatesInput | BacklinkScalarWhereWithAggregatesInput[]
    id?: IntWithAggregatesFilter<"Backlink"> | number
    link_url?: StringWithAggregatesFilter<"Backlink"> | string
    link_status?: IntWithAggregatesFilter<"Backlink"> | number
    is_index?: BoolNullableWithAggregatesFilter<"Backlink"> | boolean | null
    link_rel?: StringNullableWithAggregatesFilter<"Backlink"> | string | null
    anchor_text?: StringNullableWithAggregatesFilter<"Backlink"> | string | null
    targeted_url?: StringNullableWithAggregatesFilter<"Backlink"> | string | null
    project_id?: IntWithAggregatesFilter<"Backlink"> | number
    uploaded_by_id?: IntNullableWithAggregatesFilter<"Backlink"> | number | null
    first_seen?: DateTimeNullableWithAggregatesFilter<"Backlink"> | Date | string | null
    last_seen?: DateTimeNullableWithAggregatesFilter<"Backlink"> | Date | string | null
    added_date?: DateTimeNullableWithAggregatesFilter<"Backlink"> | Date | string | null
    created_at?: DateTimeWithAggregatesFilter<"Backlink"> | Date | string
    updated_at?: DateTimeWithAggregatesFilter<"Backlink"> | Date | string
    deleted_at?: DateTimeNullableWithAggregatesFilter<"Backlink"> | Date | string | null
    backlink_duplicate?: BoolNullableWithAggregatesFilter<"Backlink"> | boolean | null
    referring_domain?: BoolNullableWithAggregatesFilter<"Backlink"> | boolean | null
    managed_by?: IntNullableWithAggregatesFilter<"Backlink"> | number | null
  }

  export type permissions_listWhereInput = {
    AND?: permissions_listWhereInput | permissions_listWhereInput[]
    OR?: permissions_listWhereInput[]
    NOT?: permissions_listWhereInput | permissions_listWhereInput[]
    id?: IntFilter<"permissions_list"> | number
    title?: StringFilter<"permissions_list"> | string
    type?: StringFilter<"permissions_list"> | string
    created_by?: IntFilter<"permissions_list"> | number
    created_at?: DateTimeFilter<"permissions_list"> | Date | string
    updated_at?: DateTimeFilter<"permissions_list"> | Date | string
    deleted_at?: DateTimeNullableFilter<"permissions_list"> | Date | string | null
    user_permissions?: User_permissionsListRelationFilter
    subscription_feature?: Subscription_featureListRelationFilter
  }

  export type permissions_listOrderByWithRelationInput = {
    id?: SortOrder
    title?: SortOrder
    type?: SortOrder
    created_by?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrderInput | SortOrder
    user_permissions?: user_permissionsOrderByRelationAggregateInput
    subscription_feature?: subscription_featureOrderByRelationAggregateInput
  }

  export type permissions_listWhereUniqueInput = Prisma.AtLeast<{
    id?: number
    title?: string
    AND?: permissions_listWhereInput | permissions_listWhereInput[]
    OR?: permissions_listWhereInput[]
    NOT?: permissions_listWhereInput | permissions_listWhereInput[]
    type?: StringFilter<"permissions_list"> | string
    created_by?: IntFilter<"permissions_list"> | number
    created_at?: DateTimeFilter<"permissions_list"> | Date | string
    updated_at?: DateTimeFilter<"permissions_list"> | Date | string
    deleted_at?: DateTimeNullableFilter<"permissions_list"> | Date | string | null
    user_permissions?: User_permissionsListRelationFilter
    subscription_feature?: Subscription_featureListRelationFilter
  }, "id" | "title">

  export type permissions_listOrderByWithAggregationInput = {
    id?: SortOrder
    title?: SortOrder
    type?: SortOrder
    created_by?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrderInput | SortOrder
    _count?: permissions_listCountOrderByAggregateInput
    _avg?: permissions_listAvgOrderByAggregateInput
    _max?: permissions_listMaxOrderByAggregateInput
    _min?: permissions_listMinOrderByAggregateInput
    _sum?: permissions_listSumOrderByAggregateInput
  }

  export type permissions_listScalarWhereWithAggregatesInput = {
    AND?: permissions_listScalarWhereWithAggregatesInput | permissions_listScalarWhereWithAggregatesInput[]
    OR?: permissions_listScalarWhereWithAggregatesInput[]
    NOT?: permissions_listScalarWhereWithAggregatesInput | permissions_listScalarWhereWithAggregatesInput[]
    id?: IntWithAggregatesFilter<"permissions_list"> | number
    title?: StringWithAggregatesFilter<"permissions_list"> | string
    type?: StringWithAggregatesFilter<"permissions_list"> | string
    created_by?: IntWithAggregatesFilter<"permissions_list"> | number
    created_at?: DateTimeWithAggregatesFilter<"permissions_list"> | Date | string
    updated_at?: DateTimeWithAggregatesFilter<"permissions_list"> | Date | string
    deleted_at?: DateTimeNullableWithAggregatesFilter<"permissions_list"> | Date | string | null
  }

  export type rolesWhereInput = {
    AND?: rolesWhereInput | rolesWhereInput[]
    OR?: rolesWhereInput[]
    NOT?: rolesWhereInput | rolesWhereInput[]
    id?: IntFilter<"roles"> | number
    name?: StringFilter<"roles"> | string
    created_at?: DateTimeFilter<"roles"> | Date | string
    updated_at?: DateTimeFilter<"roles"> | Date | string
    deleted_at?: DateTimeNullableFilter<"roles"> | Date | string | null
  }

  export type rolesOrderByWithRelationInput = {
    id?: SortOrder
    name?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrderInput | SortOrder
  }

  export type rolesWhereUniqueInput = Prisma.AtLeast<{
    id?: number
    name?: string
    AND?: rolesWhereInput | rolesWhereInput[]
    OR?: rolesWhereInput[]
    NOT?: rolesWhereInput | rolesWhereInput[]
    created_at?: DateTimeFilter<"roles"> | Date | string
    updated_at?: DateTimeFilter<"roles"> | Date | string
    deleted_at?: DateTimeNullableFilter<"roles"> | Date | string | null
  }, "id" | "name">

  export type rolesOrderByWithAggregationInput = {
    id?: SortOrder
    name?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrderInput | SortOrder
    _count?: rolesCountOrderByAggregateInput
    _avg?: rolesAvgOrderByAggregateInput
    _max?: rolesMaxOrderByAggregateInput
    _min?: rolesMinOrderByAggregateInput
    _sum?: rolesSumOrderByAggregateInput
  }

  export type rolesScalarWhereWithAggregatesInput = {
    AND?: rolesScalarWhereWithAggregatesInput | rolesScalarWhereWithAggregatesInput[]
    OR?: rolesScalarWhereWithAggregatesInput[]
    NOT?: rolesScalarWhereWithAggregatesInput | rolesScalarWhereWithAggregatesInput[]
    id?: IntWithAggregatesFilter<"roles"> | number
    name?: StringWithAggregatesFilter<"roles"> | string
    created_at?: DateTimeWithAggregatesFilter<"roles"> | Date | string
    updated_at?: DateTimeWithAggregatesFilter<"roles"> | Date | string
    deleted_at?: DateTimeNullableWithAggregatesFilter<"roles"> | Date | string | null
  }

  export type subscriptionWhereInput = {
    AND?: subscriptionWhereInput | subscriptionWhereInput[]
    OR?: subscriptionWhereInput[]
    NOT?: subscriptionWhereInput | subscriptionWhereInput[]
    id?: IntFilter<"subscription"> | number
    name?: StringFilter<"subscription"> | string
    status?: IntFilter<"subscription"> | number
    created_at?: DateTimeFilter<"subscription"> | Date | string
    updated_at?: DateTimeFilter<"subscription"> | Date | string
    deleted_at?: DateTimeNullableFilter<"subscription"> | Date | string | null
    user_subscription?: User_subscriptionListRelationFilter
    subscription_feature?: Subscription_featureListRelationFilter
    package_features?: Package_featuresListRelationFilter
  }

  export type subscriptionOrderByWithRelationInput = {
    id?: SortOrder
    name?: SortOrder
    status?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrderInput | SortOrder
    user_subscription?: user_subscriptionOrderByRelationAggregateInput
    subscription_feature?: subscription_featureOrderByRelationAggregateInput
    package_features?: package_featuresOrderByRelationAggregateInput
  }

  export type subscriptionWhereUniqueInput = Prisma.AtLeast<{
    id?: number
    AND?: subscriptionWhereInput | subscriptionWhereInput[]
    OR?: subscriptionWhereInput[]
    NOT?: subscriptionWhereInput | subscriptionWhereInput[]
    name?: StringFilter<"subscription"> | string
    status?: IntFilter<"subscription"> | number
    created_at?: DateTimeFilter<"subscription"> | Date | string
    updated_at?: DateTimeFilter<"subscription"> | Date | string
    deleted_at?: DateTimeNullableFilter<"subscription"> | Date | string | null
    user_subscription?: User_subscriptionListRelationFilter
    subscription_feature?: Subscription_featureListRelationFilter
    package_features?: Package_featuresListRelationFilter
  }, "id">

  export type subscriptionOrderByWithAggregationInput = {
    id?: SortOrder
    name?: SortOrder
    status?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrderInput | SortOrder
    _count?: subscriptionCountOrderByAggregateInput
    _avg?: subscriptionAvgOrderByAggregateInput
    _max?: subscriptionMaxOrderByAggregateInput
    _min?: subscriptionMinOrderByAggregateInput
    _sum?: subscriptionSumOrderByAggregateInput
  }

  export type subscriptionScalarWhereWithAggregatesInput = {
    AND?: subscriptionScalarWhereWithAggregatesInput | subscriptionScalarWhereWithAggregatesInput[]
    OR?: subscriptionScalarWhereWithAggregatesInput[]
    NOT?: subscriptionScalarWhereWithAggregatesInput | subscriptionScalarWhereWithAggregatesInput[]
    id?: IntWithAggregatesFilter<"subscription"> | number
    name?: StringWithAggregatesFilter<"subscription"> | string
    status?: IntWithAggregatesFilter<"subscription"> | number
    created_at?: DateTimeWithAggregatesFilter<"subscription"> | Date | string
    updated_at?: DateTimeWithAggregatesFilter<"subscription"> | Date | string
    deleted_at?: DateTimeNullableWithAggregatesFilter<"subscription"> | Date | string | null
  }

  export type subscription_featureWhereInput = {
    AND?: subscription_featureWhereInput | subscription_featureWhereInput[]
    OR?: subscription_featureWhereInput[]
    NOT?: subscription_featureWhereInput | subscription_featureWhereInput[]
    id?: IntFilter<"subscription_feature"> | number
    status?: IntFilter<"subscription_feature"> | number
    subscription_id?: IntFilter<"subscription_feature"> | number
    permission_id?: IntFilter<"subscription_feature"> | number
    limit?: IntFilter<"subscription_feature"> | number
    created_at?: DateTimeFilter<"subscription_feature"> | Date | string
    updated_at?: DateTimeFilter<"subscription_feature"> | Date | string
    deleted_at?: DateTimeNullableFilter<"subscription_feature"> | Date | string | null
    subscricption_package?: XOR<SubscriptionScalarRelationFilter, subscriptionWhereInput>
    features?: XOR<Permissions_listScalarRelationFilter, permissions_listWhereInput>
  }

  export type subscription_featureOrderByWithRelationInput = {
    id?: SortOrder
    status?: SortOrder
    subscription_id?: SortOrder
    permission_id?: SortOrder
    limit?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrderInput | SortOrder
    subscricption_package?: subscriptionOrderByWithRelationInput
    features?: permissions_listOrderByWithRelationInput
  }

  export type subscription_featureWhereUniqueInput = Prisma.AtLeast<{
    id?: number
    AND?: subscription_featureWhereInput | subscription_featureWhereInput[]
    OR?: subscription_featureWhereInput[]
    NOT?: subscription_featureWhereInput | subscription_featureWhereInput[]
    status?: IntFilter<"subscription_feature"> | number
    subscription_id?: IntFilter<"subscription_feature"> | number
    permission_id?: IntFilter<"subscription_feature"> | number
    limit?: IntFilter<"subscription_feature"> | number
    created_at?: DateTimeFilter<"subscription_feature"> | Date | string
    updated_at?: DateTimeFilter<"subscription_feature"> | Date | string
    deleted_at?: DateTimeNullableFilter<"subscription_feature"> | Date | string | null
    subscricption_package?: XOR<SubscriptionScalarRelationFilter, subscriptionWhereInput>
    features?: XOR<Permissions_listScalarRelationFilter, permissions_listWhereInput>
  }, "id">

  export type subscription_featureOrderByWithAggregationInput = {
    id?: SortOrder
    status?: SortOrder
    subscription_id?: SortOrder
    permission_id?: SortOrder
    limit?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrderInput | SortOrder
    _count?: subscription_featureCountOrderByAggregateInput
    _avg?: subscription_featureAvgOrderByAggregateInput
    _max?: subscription_featureMaxOrderByAggregateInput
    _min?: subscription_featureMinOrderByAggregateInput
    _sum?: subscription_featureSumOrderByAggregateInput
  }

  export type subscription_featureScalarWhereWithAggregatesInput = {
    AND?: subscription_featureScalarWhereWithAggregatesInput | subscription_featureScalarWhereWithAggregatesInput[]
    OR?: subscription_featureScalarWhereWithAggregatesInput[]
    NOT?: subscription_featureScalarWhereWithAggregatesInput | subscription_featureScalarWhereWithAggregatesInput[]
    id?: IntWithAggregatesFilter<"subscription_feature"> | number
    status?: IntWithAggregatesFilter<"subscription_feature"> | number
    subscription_id?: IntWithAggregatesFilter<"subscription_feature"> | number
    permission_id?: IntWithAggregatesFilter<"subscription_feature"> | number
    limit?: IntWithAggregatesFilter<"subscription_feature"> | number
    created_at?: DateTimeWithAggregatesFilter<"subscription_feature"> | Date | string
    updated_at?: DateTimeWithAggregatesFilter<"subscription_feature"> | Date | string
    deleted_at?: DateTimeNullableWithAggregatesFilter<"subscription_feature"> | Date | string | null
  }

  export type user_subscriptionWhereInput = {
    AND?: user_subscriptionWhereInput | user_subscriptionWhereInput[]
    OR?: user_subscriptionWhereInput[]
    NOT?: user_subscriptionWhereInput | user_subscriptionWhereInput[]
    id?: IntFilter<"user_subscription"> | number
    user_id?: IntFilter<"user_subscription"> | number
    created_by_id?: IntFilter<"user_subscription"> | number
    created_at?: DateTimeFilter<"user_subscription"> | Date | string
    updated_at?: DateTimeFilter<"user_subscription"> | Date | string
    deleted_at?: DateTimeNullableFilter<"user_subscription"> | Date | string | null
    subscription_id?: IntFilter<"user_subscription"> | number
    usersubscriptions?: XOR<SubscriptionScalarRelationFilter, subscriptionWhereInput>
  }

  export type user_subscriptionOrderByWithRelationInput = {
    id?: SortOrder
    user_id?: SortOrder
    created_by_id?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrderInput | SortOrder
    subscription_id?: SortOrder
    usersubscriptions?: subscriptionOrderByWithRelationInput
  }

  export type user_subscriptionWhereUniqueInput = Prisma.AtLeast<{
    id?: number
    AND?: user_subscriptionWhereInput | user_subscriptionWhereInput[]
    OR?: user_subscriptionWhereInput[]
    NOT?: user_subscriptionWhereInput | user_subscriptionWhereInput[]
    user_id?: IntFilter<"user_subscription"> | number
    created_by_id?: IntFilter<"user_subscription"> | number
    created_at?: DateTimeFilter<"user_subscription"> | Date | string
    updated_at?: DateTimeFilter<"user_subscription"> | Date | string
    deleted_at?: DateTimeNullableFilter<"user_subscription"> | Date | string | null
    subscription_id?: IntFilter<"user_subscription"> | number
    usersubscriptions?: XOR<SubscriptionScalarRelationFilter, subscriptionWhereInput>
  }, "id">

  export type user_subscriptionOrderByWithAggregationInput = {
    id?: SortOrder
    user_id?: SortOrder
    created_by_id?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrderInput | SortOrder
    subscription_id?: SortOrder
    _count?: user_subscriptionCountOrderByAggregateInput
    _avg?: user_subscriptionAvgOrderByAggregateInput
    _max?: user_subscriptionMaxOrderByAggregateInput
    _min?: user_subscriptionMinOrderByAggregateInput
    _sum?: user_subscriptionSumOrderByAggregateInput
  }

  export type user_subscriptionScalarWhereWithAggregatesInput = {
    AND?: user_subscriptionScalarWhereWithAggregatesInput | user_subscriptionScalarWhereWithAggregatesInput[]
    OR?: user_subscriptionScalarWhereWithAggregatesInput[]
    NOT?: user_subscriptionScalarWhereWithAggregatesInput | user_subscriptionScalarWhereWithAggregatesInput[]
    id?: IntWithAggregatesFilter<"user_subscription"> | number
    user_id?: IntWithAggregatesFilter<"user_subscription"> | number
    created_by_id?: IntWithAggregatesFilter<"user_subscription"> | number
    created_at?: DateTimeWithAggregatesFilter<"user_subscription"> | Date | string
    updated_at?: DateTimeWithAggregatesFilter<"user_subscription"> | Date | string
    deleted_at?: DateTimeNullableWithAggregatesFilter<"user_subscription"> | Date | string | null
    subscription_id?: IntWithAggregatesFilter<"user_subscription"> | number
  }

  export type user_permissionsWhereInput = {
    AND?: user_permissionsWhereInput | user_permissionsWhereInput[]
    OR?: user_permissionsWhereInput[]
    NOT?: user_permissionsWhereInput | user_permissionsWhereInput[]
    id?: IntFilter<"user_permissions"> | number
    user_id?: IntFilter<"user_permissions"> | number
    limit?: IntNullableFilter<"user_permissions"> | number | null
    permission_id?: IntFilter<"user_permissions"> | number
    created_at?: DateTimeFilter<"user_permissions"> | Date | string
    updated_at?: DateTimeFilter<"user_permissions"> | Date | string
    deleted_at?: DateTimeNullableFilter<"user_permissions"> | Date | string | null
    userPermission?: XOR<Permissions_listScalarRelationFilter, permissions_listWhereInput>
  }

  export type user_permissionsOrderByWithRelationInput = {
    id?: SortOrder
    user_id?: SortOrder
    limit?: SortOrderInput | SortOrder
    permission_id?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrderInput | SortOrder
    userPermission?: permissions_listOrderByWithRelationInput
  }

  export type user_permissionsWhereUniqueInput = Prisma.AtLeast<{
    id?: number
    AND?: user_permissionsWhereInput | user_permissionsWhereInput[]
    OR?: user_permissionsWhereInput[]
    NOT?: user_permissionsWhereInput | user_permissionsWhereInput[]
    user_id?: IntFilter<"user_permissions"> | number
    limit?: IntNullableFilter<"user_permissions"> | number | null
    permission_id?: IntFilter<"user_permissions"> | number
    created_at?: DateTimeFilter<"user_permissions"> | Date | string
    updated_at?: DateTimeFilter<"user_permissions"> | Date | string
    deleted_at?: DateTimeNullableFilter<"user_permissions"> | Date | string | null
    userPermission?: XOR<Permissions_listScalarRelationFilter, permissions_listWhereInput>
  }, "id">

  export type user_permissionsOrderByWithAggregationInput = {
    id?: SortOrder
    user_id?: SortOrder
    limit?: SortOrderInput | SortOrder
    permission_id?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrderInput | SortOrder
    _count?: user_permissionsCountOrderByAggregateInput
    _avg?: user_permissionsAvgOrderByAggregateInput
    _max?: user_permissionsMaxOrderByAggregateInput
    _min?: user_permissionsMinOrderByAggregateInput
    _sum?: user_permissionsSumOrderByAggregateInput
  }

  export type user_permissionsScalarWhereWithAggregatesInput = {
    AND?: user_permissionsScalarWhereWithAggregatesInput | user_permissionsScalarWhereWithAggregatesInput[]
    OR?: user_permissionsScalarWhereWithAggregatesInput[]
    NOT?: user_permissionsScalarWhereWithAggregatesInput | user_permissionsScalarWhereWithAggregatesInput[]
    id?: IntWithAggregatesFilter<"user_permissions"> | number
    user_id?: IntWithAggregatesFilter<"user_permissions"> | number
    limit?: IntNullableWithAggregatesFilter<"user_permissions"> | number | null
    permission_id?: IntWithAggregatesFilter<"user_permissions"> | number
    created_at?: DateTimeWithAggregatesFilter<"user_permissions"> | Date | string
    updated_at?: DateTimeWithAggregatesFilter<"user_permissions"> | Date | string
    deleted_at?: DateTimeNullableWithAggregatesFilter<"user_permissions"> | Date | string | null
  }

  export type package_featuresWhereInput = {
    AND?: package_featuresWhereInput | package_featuresWhereInput[]
    OR?: package_featuresWhereInput[]
    NOT?: package_featuresWhereInput | package_featuresWhereInput[]
    id?: IntFilter<"package_features"> | number
    subscription_id?: IntFilter<"package_features"> | number
    website_analysis?: BoolFilter<"package_features"> | boolean
    content_duplicacy?: BoolFilter<"package_features"> | boolean
    initial_backlinks?: BoolFilter<"package_features"> | boolean
    critical_seo_analysis?: BoolFilter<"package_features"> | boolean
    google_penalty_check?: BoolFilter<"package_features"> | boolean
    competition_analysis?: IntFilter<"package_features"> | number
    competitor_backlinks_opportunity?: IntFilter<"package_features"> | number
    keyword_research_analysis?: BoolFilter<"package_features"> | boolean
    on_page_optimization?: BoolFilter<"package_features"> | boolean
    title_tags_optimization?: BoolFilter<"package_features"> | boolean
    meta_tags_optimization?: BoolFilter<"package_features"> | boolean
    content_optimization?: BoolFilter<"package_features"> | boolean
    html_code_optimization?: BoolFilter<"package_features"> | boolean
    website_permalinks_analysis?: BoolFilter<"package_features"> | boolean
    seo_friendly_urls?: BoolFilter<"package_features"> | boolean
    schema_markup_analysis?: BoolFilter<"package_features"> | boolean
    internal_linking_optimization?: BoolFilter<"package_features"> | boolean
    crawl_error_resolution?: BoolFilter<"package_features"> | boolean
    heading_tags_optimization?: BoolFilter<"package_features"> | boolean
    canonicalization_301_redirect?: BoolFilter<"package_features"> | boolean
    custom_404_errors?: BoolFilter<"package_features"> | boolean
    images_optimization?: BoolFilter<"package_features"> | boolean
    hyperlink_optimization?: BoolFilter<"package_features"> | boolean
    robots_txt_creation_optimization?: BoolFilter<"package_features"> | boolean
    sitemap_creation?: BoolFilter<"package_features"> | boolean
    google_webmaster_tools_setup?: BoolFilter<"package_features"> | boolean
    bing_Webmaster_tools_setup?: BoolFilter<"package_features"> | boolean
    google_analytics_setup_Integration?: BoolFilter<"package_features"> | boolean
    website_responsive_check?: BoolFilter<"package_features"> | boolean
    page_speed_analysis?: BoolFilter<"package_features"> | boolean
    mobile_responsive_compatibility_check?: BoolFilter<"package_features"> | boolean
    navigation_ux_factors?: BoolFilter<"package_features"> | boolean
    ssl_certificate?: BoolFilter<"package_features"> | boolean
    web_2_0_400_600_words_blog_Writing?: IntFilter<"package_features"> | number
    article_writing?: IntFilter<"package_features"> | number
    classified_writing?: IntFilter<"package_features"> | number
    press_release_writing?: IntFilter<"package_features"> | number
    ppt_pdf_creation_writing?: IntFilter<"package_features"> | number
    web_2_0_400_600_words_submission?: IntFilter<"package_features"> | number
    web_2_0_blog_promotion?: IntFilter<"package_features"> | number
    article_submission?: IntFilter<"package_features"> | number
    article_promotion?: IntFilter<"package_features"> | number
    guest_blogging?: IntFilter<"package_features"> | number
    custom_graphics_to_support_your_blogs?: BoolFilter<"package_features"> | boolean
    social_bookmarking_links?: IntFilter<"package_features"> | number
    press_release_submission?: IntFilter<"package_features"> | number
    local_citation?: IntFilter<"package_features"> | number
    classified_submissions?: IntFilter<"package_features"> | number
    ppt_submission?: IntFilter<"package_features"> | number
    ppt_promotion_backlinks?: IntFilter<"package_features"> | number
    pdf_submission?: IntFilter<"package_features"> | number
    pdf_promotion_backlinks?: IntFilter<"package_features"> | number
    quora_Q_A?: IntFilter<"package_features"> | number
    profile_creation?: IntFilter<"package_features"> | number
    blog_commenting_niche_edu?: IntFilter<"package_features"> | number
    forum_submission?: IntFilter<"package_features"> | number
    google_my_business_setup_verification?: BoolFilter<"package_features"> | boolean
    local_citation_submissions?: IntFilter<"package_features"> | number
    google_places_photo_multimedia_additions?: BoolFilter<"package_features"> | boolean
    customer_reviews_ratings?: IntFilter<"package_features"> | number
    local_classified_ads?: IntFilter<"package_features"> | number
    monthly_keyword_improvement_report?: BoolFilter<"package_features"> | boolean
    monthly_back_links_report?: BoolFilter<"package_features"> | boolean
    monthly_google_analytic_static_report?: BoolFilter<"package_features"> | boolean
    email?: BoolFilter<"package_features"> | boolean
    telephone_whatsapp_telegram?: BoolFilter<"package_features"> | boolean
    internet_messenger_skype?: BoolFilter<"package_features"> | boolean
    created_at?: DateTimeFilter<"package_features"> | Date | string
    updated_at?: DateTimeFilter<"package_features"> | Date | string
    deleted_at?: DateTimeNullableFilter<"package_features"> | Date | string | null
    status?: IntNullableFilter<"package_features"> | number | null
    Features?: XOR<SubscriptionScalarRelationFilter, subscriptionWhereInput>
  }

  export type package_featuresOrderByWithRelationInput = {
    id?: SortOrder
    subscription_id?: SortOrder
    website_analysis?: SortOrder
    content_duplicacy?: SortOrder
    initial_backlinks?: SortOrder
    critical_seo_analysis?: SortOrder
    google_penalty_check?: SortOrder
    competition_analysis?: SortOrder
    competitor_backlinks_opportunity?: SortOrder
    keyword_research_analysis?: SortOrder
    on_page_optimization?: SortOrder
    title_tags_optimization?: SortOrder
    meta_tags_optimization?: SortOrder
    content_optimization?: SortOrder
    html_code_optimization?: SortOrder
    website_permalinks_analysis?: SortOrder
    seo_friendly_urls?: SortOrder
    schema_markup_analysis?: SortOrder
    internal_linking_optimization?: SortOrder
    crawl_error_resolution?: SortOrder
    heading_tags_optimization?: SortOrder
    canonicalization_301_redirect?: SortOrder
    custom_404_errors?: SortOrder
    images_optimization?: SortOrder
    hyperlink_optimization?: SortOrder
    robots_txt_creation_optimization?: SortOrder
    sitemap_creation?: SortOrder
    google_webmaster_tools_setup?: SortOrder
    bing_Webmaster_tools_setup?: SortOrder
    google_analytics_setup_Integration?: SortOrder
    website_responsive_check?: SortOrder
    page_speed_analysis?: SortOrder
    mobile_responsive_compatibility_check?: SortOrder
    navigation_ux_factors?: SortOrder
    ssl_certificate?: SortOrder
    web_2_0_400_600_words_blog_Writing?: SortOrder
    article_writing?: SortOrder
    classified_writing?: SortOrder
    press_release_writing?: SortOrder
    ppt_pdf_creation_writing?: SortOrder
    web_2_0_400_600_words_submission?: SortOrder
    web_2_0_blog_promotion?: SortOrder
    article_submission?: SortOrder
    article_promotion?: SortOrder
    guest_blogging?: SortOrder
    custom_graphics_to_support_your_blogs?: SortOrder
    social_bookmarking_links?: SortOrder
    press_release_submission?: SortOrder
    local_citation?: SortOrder
    classified_submissions?: SortOrder
    ppt_submission?: SortOrder
    ppt_promotion_backlinks?: SortOrder
    pdf_submission?: SortOrder
    pdf_promotion_backlinks?: SortOrder
    quora_Q_A?: SortOrder
    profile_creation?: SortOrder
    blog_commenting_niche_edu?: SortOrder
    forum_submission?: SortOrder
    google_my_business_setup_verification?: SortOrder
    local_citation_submissions?: SortOrder
    google_places_photo_multimedia_additions?: SortOrder
    customer_reviews_ratings?: SortOrder
    local_classified_ads?: SortOrder
    monthly_keyword_improvement_report?: SortOrder
    monthly_back_links_report?: SortOrder
    monthly_google_analytic_static_report?: SortOrder
    email?: SortOrder
    telephone_whatsapp_telegram?: SortOrder
    internet_messenger_skype?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrderInput | SortOrder
    status?: SortOrderInput | SortOrder
    Features?: subscriptionOrderByWithRelationInput
  }

  export type package_featuresWhereUniqueInput = Prisma.AtLeast<{
    id?: number
    AND?: package_featuresWhereInput | package_featuresWhereInput[]
    OR?: package_featuresWhereInput[]
    NOT?: package_featuresWhereInput | package_featuresWhereInput[]
    subscription_id?: IntFilter<"package_features"> | number
    website_analysis?: BoolFilter<"package_features"> | boolean
    content_duplicacy?: BoolFilter<"package_features"> | boolean
    initial_backlinks?: BoolFilter<"package_features"> | boolean
    critical_seo_analysis?: BoolFilter<"package_features"> | boolean
    google_penalty_check?: BoolFilter<"package_features"> | boolean
    competition_analysis?: IntFilter<"package_features"> | number
    competitor_backlinks_opportunity?: IntFilter<"package_features"> | number
    keyword_research_analysis?: BoolFilter<"package_features"> | boolean
    on_page_optimization?: BoolFilter<"package_features"> | boolean
    title_tags_optimization?: BoolFilter<"package_features"> | boolean
    meta_tags_optimization?: BoolFilter<"package_features"> | boolean
    content_optimization?: BoolFilter<"package_features"> | boolean
    html_code_optimization?: BoolFilter<"package_features"> | boolean
    website_permalinks_analysis?: BoolFilter<"package_features"> | boolean
    seo_friendly_urls?: BoolFilter<"package_features"> | boolean
    schema_markup_analysis?: BoolFilter<"package_features"> | boolean
    internal_linking_optimization?: BoolFilter<"package_features"> | boolean
    crawl_error_resolution?: BoolFilter<"package_features"> | boolean
    heading_tags_optimization?: BoolFilter<"package_features"> | boolean
    canonicalization_301_redirect?: BoolFilter<"package_features"> | boolean
    custom_404_errors?: BoolFilter<"package_features"> | boolean
    images_optimization?: BoolFilter<"package_features"> | boolean
    hyperlink_optimization?: BoolFilter<"package_features"> | boolean
    robots_txt_creation_optimization?: BoolFilter<"package_features"> | boolean
    sitemap_creation?: BoolFilter<"package_features"> | boolean
    google_webmaster_tools_setup?: BoolFilter<"package_features"> | boolean
    bing_Webmaster_tools_setup?: BoolFilter<"package_features"> | boolean
    google_analytics_setup_Integration?: BoolFilter<"package_features"> | boolean
    website_responsive_check?: BoolFilter<"package_features"> | boolean
    page_speed_analysis?: BoolFilter<"package_features"> | boolean
    mobile_responsive_compatibility_check?: BoolFilter<"package_features"> | boolean
    navigation_ux_factors?: BoolFilter<"package_features"> | boolean
    ssl_certificate?: BoolFilter<"package_features"> | boolean
    web_2_0_400_600_words_blog_Writing?: IntFilter<"package_features"> | number
    article_writing?: IntFilter<"package_features"> | number
    classified_writing?: IntFilter<"package_features"> | number
    press_release_writing?: IntFilter<"package_features"> | number
    ppt_pdf_creation_writing?: IntFilter<"package_features"> | number
    web_2_0_400_600_words_submission?: IntFilter<"package_features"> | number
    web_2_0_blog_promotion?: IntFilter<"package_features"> | number
    article_submission?: IntFilter<"package_features"> | number
    article_promotion?: IntFilter<"package_features"> | number
    guest_blogging?: IntFilter<"package_features"> | number
    custom_graphics_to_support_your_blogs?: BoolFilter<"package_features"> | boolean
    social_bookmarking_links?: IntFilter<"package_features"> | number
    press_release_submission?: IntFilter<"package_features"> | number
    local_citation?: IntFilter<"package_features"> | number
    classified_submissions?: IntFilter<"package_features"> | number
    ppt_submission?: IntFilter<"package_features"> | number
    ppt_promotion_backlinks?: IntFilter<"package_features"> | number
    pdf_submission?: IntFilter<"package_features"> | number
    pdf_promotion_backlinks?: IntFilter<"package_features"> | number
    quora_Q_A?: IntFilter<"package_features"> | number
    profile_creation?: IntFilter<"package_features"> | number
    blog_commenting_niche_edu?: IntFilter<"package_features"> | number
    forum_submission?: IntFilter<"package_features"> | number
    google_my_business_setup_verification?: BoolFilter<"package_features"> | boolean
    local_citation_submissions?: IntFilter<"package_features"> | number
    google_places_photo_multimedia_additions?: BoolFilter<"package_features"> | boolean
    customer_reviews_ratings?: IntFilter<"package_features"> | number
    local_classified_ads?: IntFilter<"package_features"> | number
    monthly_keyword_improvement_report?: BoolFilter<"package_features"> | boolean
    monthly_back_links_report?: BoolFilter<"package_features"> | boolean
    monthly_google_analytic_static_report?: BoolFilter<"package_features"> | boolean
    email?: BoolFilter<"package_features"> | boolean
    telephone_whatsapp_telegram?: BoolFilter<"package_features"> | boolean
    internet_messenger_skype?: BoolFilter<"package_features"> | boolean
    created_at?: DateTimeFilter<"package_features"> | Date | string
    updated_at?: DateTimeFilter<"package_features"> | Date | string
    deleted_at?: DateTimeNullableFilter<"package_features"> | Date | string | null
    status?: IntNullableFilter<"package_features"> | number | null
    Features?: XOR<SubscriptionScalarRelationFilter, subscriptionWhereInput>
  }, "id">

  export type package_featuresOrderByWithAggregationInput = {
    id?: SortOrder
    subscription_id?: SortOrder
    website_analysis?: SortOrder
    content_duplicacy?: SortOrder
    initial_backlinks?: SortOrder
    critical_seo_analysis?: SortOrder
    google_penalty_check?: SortOrder
    competition_analysis?: SortOrder
    competitor_backlinks_opportunity?: SortOrder
    keyword_research_analysis?: SortOrder
    on_page_optimization?: SortOrder
    title_tags_optimization?: SortOrder
    meta_tags_optimization?: SortOrder
    content_optimization?: SortOrder
    html_code_optimization?: SortOrder
    website_permalinks_analysis?: SortOrder
    seo_friendly_urls?: SortOrder
    schema_markup_analysis?: SortOrder
    internal_linking_optimization?: SortOrder
    crawl_error_resolution?: SortOrder
    heading_tags_optimization?: SortOrder
    canonicalization_301_redirect?: SortOrder
    custom_404_errors?: SortOrder
    images_optimization?: SortOrder
    hyperlink_optimization?: SortOrder
    robots_txt_creation_optimization?: SortOrder
    sitemap_creation?: SortOrder
    google_webmaster_tools_setup?: SortOrder
    bing_Webmaster_tools_setup?: SortOrder
    google_analytics_setup_Integration?: SortOrder
    website_responsive_check?: SortOrder
    page_speed_analysis?: SortOrder
    mobile_responsive_compatibility_check?: SortOrder
    navigation_ux_factors?: SortOrder
    ssl_certificate?: SortOrder
    web_2_0_400_600_words_blog_Writing?: SortOrder
    article_writing?: SortOrder
    classified_writing?: SortOrder
    press_release_writing?: SortOrder
    ppt_pdf_creation_writing?: SortOrder
    web_2_0_400_600_words_submission?: SortOrder
    web_2_0_blog_promotion?: SortOrder
    article_submission?: SortOrder
    article_promotion?: SortOrder
    guest_blogging?: SortOrder
    custom_graphics_to_support_your_blogs?: SortOrder
    social_bookmarking_links?: SortOrder
    press_release_submission?: SortOrder
    local_citation?: SortOrder
    classified_submissions?: SortOrder
    ppt_submission?: SortOrder
    ppt_promotion_backlinks?: SortOrder
    pdf_submission?: SortOrder
    pdf_promotion_backlinks?: SortOrder
    quora_Q_A?: SortOrder
    profile_creation?: SortOrder
    blog_commenting_niche_edu?: SortOrder
    forum_submission?: SortOrder
    google_my_business_setup_verification?: SortOrder
    local_citation_submissions?: SortOrder
    google_places_photo_multimedia_additions?: SortOrder
    customer_reviews_ratings?: SortOrder
    local_classified_ads?: SortOrder
    monthly_keyword_improvement_report?: SortOrder
    monthly_back_links_report?: SortOrder
    monthly_google_analytic_static_report?: SortOrder
    email?: SortOrder
    telephone_whatsapp_telegram?: SortOrder
    internet_messenger_skype?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrderInput | SortOrder
    status?: SortOrderInput | SortOrder
    _count?: package_featuresCountOrderByAggregateInput
    _avg?: package_featuresAvgOrderByAggregateInput
    _max?: package_featuresMaxOrderByAggregateInput
    _min?: package_featuresMinOrderByAggregateInput
    _sum?: package_featuresSumOrderByAggregateInput
  }

  export type package_featuresScalarWhereWithAggregatesInput = {
    AND?: package_featuresScalarWhereWithAggregatesInput | package_featuresScalarWhereWithAggregatesInput[]
    OR?: package_featuresScalarWhereWithAggregatesInput[]
    NOT?: package_featuresScalarWhereWithAggregatesInput | package_featuresScalarWhereWithAggregatesInput[]
    id?: IntWithAggregatesFilter<"package_features"> | number
    subscription_id?: IntWithAggregatesFilter<"package_features"> | number
    website_analysis?: BoolWithAggregatesFilter<"package_features"> | boolean
    content_duplicacy?: BoolWithAggregatesFilter<"package_features"> | boolean
    initial_backlinks?: BoolWithAggregatesFilter<"package_features"> | boolean
    critical_seo_analysis?: BoolWithAggregatesFilter<"package_features"> | boolean
    google_penalty_check?: BoolWithAggregatesFilter<"package_features"> | boolean
    competition_analysis?: IntWithAggregatesFilter<"package_features"> | number
    competitor_backlinks_opportunity?: IntWithAggregatesFilter<"package_features"> | number
    keyword_research_analysis?: BoolWithAggregatesFilter<"package_features"> | boolean
    on_page_optimization?: BoolWithAggregatesFilter<"package_features"> | boolean
    title_tags_optimization?: BoolWithAggregatesFilter<"package_features"> | boolean
    meta_tags_optimization?: BoolWithAggregatesFilter<"package_features"> | boolean
    content_optimization?: BoolWithAggregatesFilter<"package_features"> | boolean
    html_code_optimization?: BoolWithAggregatesFilter<"package_features"> | boolean
    website_permalinks_analysis?: BoolWithAggregatesFilter<"package_features"> | boolean
    seo_friendly_urls?: BoolWithAggregatesFilter<"package_features"> | boolean
    schema_markup_analysis?: BoolWithAggregatesFilter<"package_features"> | boolean
    internal_linking_optimization?: BoolWithAggregatesFilter<"package_features"> | boolean
    crawl_error_resolution?: BoolWithAggregatesFilter<"package_features"> | boolean
    heading_tags_optimization?: BoolWithAggregatesFilter<"package_features"> | boolean
    canonicalization_301_redirect?: BoolWithAggregatesFilter<"package_features"> | boolean
    custom_404_errors?: BoolWithAggregatesFilter<"package_features"> | boolean
    images_optimization?: BoolWithAggregatesFilter<"package_features"> | boolean
    hyperlink_optimization?: BoolWithAggregatesFilter<"package_features"> | boolean
    robots_txt_creation_optimization?: BoolWithAggregatesFilter<"package_features"> | boolean
    sitemap_creation?: BoolWithAggregatesFilter<"package_features"> | boolean
    google_webmaster_tools_setup?: BoolWithAggregatesFilter<"package_features"> | boolean
    bing_Webmaster_tools_setup?: BoolWithAggregatesFilter<"package_features"> | boolean
    google_analytics_setup_Integration?: BoolWithAggregatesFilter<"package_features"> | boolean
    website_responsive_check?: BoolWithAggregatesFilter<"package_features"> | boolean
    page_speed_analysis?: BoolWithAggregatesFilter<"package_features"> | boolean
    mobile_responsive_compatibility_check?: BoolWithAggregatesFilter<"package_features"> | boolean
    navigation_ux_factors?: BoolWithAggregatesFilter<"package_features"> | boolean
    ssl_certificate?: BoolWithAggregatesFilter<"package_features"> | boolean
    web_2_0_400_600_words_blog_Writing?: IntWithAggregatesFilter<"package_features"> | number
    article_writing?: IntWithAggregatesFilter<"package_features"> | number
    classified_writing?: IntWithAggregatesFilter<"package_features"> | number
    press_release_writing?: IntWithAggregatesFilter<"package_features"> | number
    ppt_pdf_creation_writing?: IntWithAggregatesFilter<"package_features"> | number
    web_2_0_400_600_words_submission?: IntWithAggregatesFilter<"package_features"> | number
    web_2_0_blog_promotion?: IntWithAggregatesFilter<"package_features"> | number
    article_submission?: IntWithAggregatesFilter<"package_features"> | number
    article_promotion?: IntWithAggregatesFilter<"package_features"> | number
    guest_blogging?: IntWithAggregatesFilter<"package_features"> | number
    custom_graphics_to_support_your_blogs?: BoolWithAggregatesFilter<"package_features"> | boolean
    social_bookmarking_links?: IntWithAggregatesFilter<"package_features"> | number
    press_release_submission?: IntWithAggregatesFilter<"package_features"> | number
    local_citation?: IntWithAggregatesFilter<"package_features"> | number
    classified_submissions?: IntWithAggregatesFilter<"package_features"> | number
    ppt_submission?: IntWithAggregatesFilter<"package_features"> | number
    ppt_promotion_backlinks?: IntWithAggregatesFilter<"package_features"> | number
    pdf_submission?: IntWithAggregatesFilter<"package_features"> | number
    pdf_promotion_backlinks?: IntWithAggregatesFilter<"package_features"> | number
    quora_Q_A?: IntWithAggregatesFilter<"package_features"> | number
    profile_creation?: IntWithAggregatesFilter<"package_features"> | number
    blog_commenting_niche_edu?: IntWithAggregatesFilter<"package_features"> | number
    forum_submission?: IntWithAggregatesFilter<"package_features"> | number
    google_my_business_setup_verification?: BoolWithAggregatesFilter<"package_features"> | boolean
    local_citation_submissions?: IntWithAggregatesFilter<"package_features"> | number
    google_places_photo_multimedia_additions?: BoolWithAggregatesFilter<"package_features"> | boolean
    customer_reviews_ratings?: IntWithAggregatesFilter<"package_features"> | number
    local_classified_ads?: IntWithAggregatesFilter<"package_features"> | number
    monthly_keyword_improvement_report?: BoolWithAggregatesFilter<"package_features"> | boolean
    monthly_back_links_report?: BoolWithAggregatesFilter<"package_features"> | boolean
    monthly_google_analytic_static_report?: BoolWithAggregatesFilter<"package_features"> | boolean
    email?: BoolWithAggregatesFilter<"package_features"> | boolean
    telephone_whatsapp_telegram?: BoolWithAggregatesFilter<"package_features"> | boolean
    internet_messenger_skype?: BoolWithAggregatesFilter<"package_features"> | boolean
    created_at?: DateTimeWithAggregatesFilter<"package_features"> | Date | string
    updated_at?: DateTimeWithAggregatesFilter<"package_features"> | Date | string
    deleted_at?: DateTimeNullableWithAggregatesFilter<"package_features"> | Date | string | null
    status?: IntNullableWithAggregatesFilter<"package_features"> | number | null
  }

  export type ProjectsCreateInput = {
    domain_name: string
    domain_url: string
    category_id: number
    created_by_id: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    time_around?: Date | string | null
    time_around_days?: number
    Backlink?: BacklinkCreateNestedManyWithoutProjectLinksInput
  }

  export type ProjectsUncheckedCreateInput = {
    id?: number
    domain_name: string
    domain_url: string
    category_id: number
    created_by_id: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    time_around?: Date | string | null
    time_around_days?: number
    Backlink?: BacklinkUncheckedCreateNestedManyWithoutProjectLinksInput
  }

  export type ProjectsUpdateInput = {
    domain_name?: StringFieldUpdateOperationsInput | string
    domain_url?: StringFieldUpdateOperationsInput | string
    category_id?: IntFieldUpdateOperationsInput | number
    created_by_id?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    time_around?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    time_around_days?: IntFieldUpdateOperationsInput | number
    Backlink?: BacklinkUpdateManyWithoutProjectLinksNestedInput
  }

  export type ProjectsUncheckedUpdateInput = {
    id?: IntFieldUpdateOperationsInput | number
    domain_name?: StringFieldUpdateOperationsInput | string
    domain_url?: StringFieldUpdateOperationsInput | string
    category_id?: IntFieldUpdateOperationsInput | number
    created_by_id?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    time_around?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    time_around_days?: IntFieldUpdateOperationsInput | number
    Backlink?: BacklinkUncheckedUpdateManyWithoutProjectLinksNestedInput
  }

  export type ProjectsCreateManyInput = {
    id?: number
    domain_name: string
    domain_url: string
    category_id: number
    created_by_id: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    time_around?: Date | string | null
    time_around_days?: number
  }

  export type ProjectsUpdateManyMutationInput = {
    domain_name?: StringFieldUpdateOperationsInput | string
    domain_url?: StringFieldUpdateOperationsInput | string
    category_id?: IntFieldUpdateOperationsInput | number
    created_by_id?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    time_around?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    time_around_days?: IntFieldUpdateOperationsInput | number
  }

  export type ProjectsUncheckedUpdateManyInput = {
    id?: IntFieldUpdateOperationsInput | number
    domain_name?: StringFieldUpdateOperationsInput | string
    domain_url?: StringFieldUpdateOperationsInput | string
    category_id?: IntFieldUpdateOperationsInput | number
    created_by_id?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    time_around?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    time_around_days?: IntFieldUpdateOperationsInput | number
  }

  export type BacklinkCreateInput = {
    link_url: string
    link_status: number
    is_index?: boolean | null
    link_rel?: string | null
    anchor_text?: string | null
    targeted_url?: string | null
    uploaded_by_id?: number | null
    first_seen?: Date | string | null
    last_seen?: Date | string | null
    added_date?: Date | string | null
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    backlink_duplicate?: boolean | null
    referring_domain?: boolean | null
    managed_by?: number | null
    ProjectLinks: ProjectsCreateNestedOneWithoutBacklinkInput
  }

  export type BacklinkUncheckedCreateInput = {
    id?: number
    link_url: string
    link_status: number
    is_index?: boolean | null
    link_rel?: string | null
    anchor_text?: string | null
    targeted_url?: string | null
    project_id: number
    uploaded_by_id?: number | null
    first_seen?: Date | string | null
    last_seen?: Date | string | null
    added_date?: Date | string | null
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    backlink_duplicate?: boolean | null
    referring_domain?: boolean | null
    managed_by?: number | null
  }

  export type BacklinkUpdateInput = {
    link_url?: StringFieldUpdateOperationsInput | string
    link_status?: IntFieldUpdateOperationsInput | number
    is_index?: NullableBoolFieldUpdateOperationsInput | boolean | null
    link_rel?: NullableStringFieldUpdateOperationsInput | string | null
    anchor_text?: NullableStringFieldUpdateOperationsInput | string | null
    targeted_url?: NullableStringFieldUpdateOperationsInput | string | null
    uploaded_by_id?: NullableIntFieldUpdateOperationsInput | number | null
    first_seen?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    last_seen?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    added_date?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    backlink_duplicate?: NullableBoolFieldUpdateOperationsInput | boolean | null
    referring_domain?: NullableBoolFieldUpdateOperationsInput | boolean | null
    managed_by?: NullableIntFieldUpdateOperationsInput | number | null
    ProjectLinks?: ProjectsUpdateOneRequiredWithoutBacklinkNestedInput
  }

  export type BacklinkUncheckedUpdateInput = {
    id?: IntFieldUpdateOperationsInput | number
    link_url?: StringFieldUpdateOperationsInput | string
    link_status?: IntFieldUpdateOperationsInput | number
    is_index?: NullableBoolFieldUpdateOperationsInput | boolean | null
    link_rel?: NullableStringFieldUpdateOperationsInput | string | null
    anchor_text?: NullableStringFieldUpdateOperationsInput | string | null
    targeted_url?: NullableStringFieldUpdateOperationsInput | string | null
    project_id?: IntFieldUpdateOperationsInput | number
    uploaded_by_id?: NullableIntFieldUpdateOperationsInput | number | null
    first_seen?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    last_seen?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    added_date?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    backlink_duplicate?: NullableBoolFieldUpdateOperationsInput | boolean | null
    referring_domain?: NullableBoolFieldUpdateOperationsInput | boolean | null
    managed_by?: NullableIntFieldUpdateOperationsInput | number | null
  }

  export type BacklinkCreateManyInput = {
    id?: number
    link_url: string
    link_status: number
    is_index?: boolean | null
    link_rel?: string | null
    anchor_text?: string | null
    targeted_url?: string | null
    project_id: number
    uploaded_by_id?: number | null
    first_seen?: Date | string | null
    last_seen?: Date | string | null
    added_date?: Date | string | null
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    backlink_duplicate?: boolean | null
    referring_domain?: boolean | null
    managed_by?: number | null
  }

  export type BacklinkUpdateManyMutationInput = {
    link_url?: StringFieldUpdateOperationsInput | string
    link_status?: IntFieldUpdateOperationsInput | number
    is_index?: NullableBoolFieldUpdateOperationsInput | boolean | null
    link_rel?: NullableStringFieldUpdateOperationsInput | string | null
    anchor_text?: NullableStringFieldUpdateOperationsInput | string | null
    targeted_url?: NullableStringFieldUpdateOperationsInput | string | null
    uploaded_by_id?: NullableIntFieldUpdateOperationsInput | number | null
    first_seen?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    last_seen?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    added_date?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    backlink_duplicate?: NullableBoolFieldUpdateOperationsInput | boolean | null
    referring_domain?: NullableBoolFieldUpdateOperationsInput | boolean | null
    managed_by?: NullableIntFieldUpdateOperationsInput | number | null
  }

  export type BacklinkUncheckedUpdateManyInput = {
    id?: IntFieldUpdateOperationsInput | number
    link_url?: StringFieldUpdateOperationsInput | string
    link_status?: IntFieldUpdateOperationsInput | number
    is_index?: NullableBoolFieldUpdateOperationsInput | boolean | null
    link_rel?: NullableStringFieldUpdateOperationsInput | string | null
    anchor_text?: NullableStringFieldUpdateOperationsInput | string | null
    targeted_url?: NullableStringFieldUpdateOperationsInput | string | null
    project_id?: IntFieldUpdateOperationsInput | number
    uploaded_by_id?: NullableIntFieldUpdateOperationsInput | number | null
    first_seen?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    last_seen?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    added_date?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    backlink_duplicate?: NullableBoolFieldUpdateOperationsInput | boolean | null
    referring_domain?: NullableBoolFieldUpdateOperationsInput | boolean | null
    managed_by?: NullableIntFieldUpdateOperationsInput | number | null
  }

  export type permissions_listCreateInput = {
    title: string
    type: string
    created_by: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    user_permissions?: user_permissionsCreateNestedManyWithoutUserPermissionInput
    subscription_feature?: subscription_featureCreateNestedManyWithoutFeaturesInput
  }

  export type permissions_listUncheckedCreateInput = {
    id?: number
    title: string
    type: string
    created_by: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    user_permissions?: user_permissionsUncheckedCreateNestedManyWithoutUserPermissionInput
    subscription_feature?: subscription_featureUncheckedCreateNestedManyWithoutFeaturesInput
  }

  export type permissions_listUpdateInput = {
    title?: StringFieldUpdateOperationsInput | string
    type?: StringFieldUpdateOperationsInput | string
    created_by?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    user_permissions?: user_permissionsUpdateManyWithoutUserPermissionNestedInput
    subscription_feature?: subscription_featureUpdateManyWithoutFeaturesNestedInput
  }

  export type permissions_listUncheckedUpdateInput = {
    id?: IntFieldUpdateOperationsInput | number
    title?: StringFieldUpdateOperationsInput | string
    type?: StringFieldUpdateOperationsInput | string
    created_by?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    user_permissions?: user_permissionsUncheckedUpdateManyWithoutUserPermissionNestedInput
    subscription_feature?: subscription_featureUncheckedUpdateManyWithoutFeaturesNestedInput
  }

  export type permissions_listCreateManyInput = {
    id?: number
    title: string
    type: string
    created_by: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
  }

  export type permissions_listUpdateManyMutationInput = {
    title?: StringFieldUpdateOperationsInput | string
    type?: StringFieldUpdateOperationsInput | string
    created_by?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type permissions_listUncheckedUpdateManyInput = {
    id?: IntFieldUpdateOperationsInput | number
    title?: StringFieldUpdateOperationsInput | string
    type?: StringFieldUpdateOperationsInput | string
    created_by?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type rolesCreateInput = {
    name: string
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
  }

  export type rolesUncheckedCreateInput = {
    id?: number
    name: string
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
  }

  export type rolesUpdateInput = {
    name?: StringFieldUpdateOperationsInput | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type rolesUncheckedUpdateInput = {
    id?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type rolesCreateManyInput = {
    id?: number
    name: string
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
  }

  export type rolesUpdateManyMutationInput = {
    name?: StringFieldUpdateOperationsInput | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type rolesUncheckedUpdateManyInput = {
    id?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type subscriptionCreateInput = {
    name?: string
    status?: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    user_subscription?: user_subscriptionCreateNestedManyWithoutUsersubscriptionsInput
    subscription_feature?: subscription_featureCreateNestedManyWithoutSubscricption_packageInput
    package_features?: package_featuresCreateNestedManyWithoutFeaturesInput
  }

  export type subscriptionUncheckedCreateInput = {
    id?: number
    name?: string
    status?: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    user_subscription?: user_subscriptionUncheckedCreateNestedManyWithoutUsersubscriptionsInput
    subscription_feature?: subscription_featureUncheckedCreateNestedManyWithoutSubscricption_packageInput
    package_features?: package_featuresUncheckedCreateNestedManyWithoutFeaturesInput
  }

  export type subscriptionUpdateInput = {
    name?: StringFieldUpdateOperationsInput | string
    status?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    user_subscription?: user_subscriptionUpdateManyWithoutUsersubscriptionsNestedInput
    subscription_feature?: subscription_featureUpdateManyWithoutSubscricption_packageNestedInput
    package_features?: package_featuresUpdateManyWithoutFeaturesNestedInput
  }

  export type subscriptionUncheckedUpdateInput = {
    id?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    status?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    user_subscription?: user_subscriptionUncheckedUpdateManyWithoutUsersubscriptionsNestedInput
    subscription_feature?: subscription_featureUncheckedUpdateManyWithoutSubscricption_packageNestedInput
    package_features?: package_featuresUncheckedUpdateManyWithoutFeaturesNestedInput
  }

  export type subscriptionCreateManyInput = {
    id?: number
    name?: string
    status?: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
  }

  export type subscriptionUpdateManyMutationInput = {
    name?: StringFieldUpdateOperationsInput | string
    status?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type subscriptionUncheckedUpdateManyInput = {
    id?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    status?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type subscription_featureCreateInput = {
    status?: number
    limit?: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    subscricption_package: subscriptionCreateNestedOneWithoutSubscription_featureInput
    features: permissions_listCreateNestedOneWithoutSubscription_featureInput
  }

  export type subscription_featureUncheckedCreateInput = {
    id?: number
    status?: number
    subscription_id: number
    permission_id: number
    limit?: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
  }

  export type subscription_featureUpdateInput = {
    status?: IntFieldUpdateOperationsInput | number
    limit?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    subscricption_package?: subscriptionUpdateOneRequiredWithoutSubscription_featureNestedInput
    features?: permissions_listUpdateOneRequiredWithoutSubscription_featureNestedInput
  }

  export type subscription_featureUncheckedUpdateInput = {
    id?: IntFieldUpdateOperationsInput | number
    status?: IntFieldUpdateOperationsInput | number
    subscription_id?: IntFieldUpdateOperationsInput | number
    permission_id?: IntFieldUpdateOperationsInput | number
    limit?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type subscription_featureCreateManyInput = {
    id?: number
    status?: number
    subscription_id: number
    permission_id: number
    limit?: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
  }

  export type subscription_featureUpdateManyMutationInput = {
    status?: IntFieldUpdateOperationsInput | number
    limit?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type subscription_featureUncheckedUpdateManyInput = {
    id?: IntFieldUpdateOperationsInput | number
    status?: IntFieldUpdateOperationsInput | number
    subscription_id?: IntFieldUpdateOperationsInput | number
    permission_id?: IntFieldUpdateOperationsInput | number
    limit?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type user_subscriptionCreateInput = {
    user_id: number
    created_by_id: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    usersubscriptions: subscriptionCreateNestedOneWithoutUser_subscriptionInput
  }

  export type user_subscriptionUncheckedCreateInput = {
    id?: number
    user_id: number
    created_by_id: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    subscription_id: number
  }

  export type user_subscriptionUpdateInput = {
    user_id?: IntFieldUpdateOperationsInput | number
    created_by_id?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    usersubscriptions?: subscriptionUpdateOneRequiredWithoutUser_subscriptionNestedInput
  }

  export type user_subscriptionUncheckedUpdateInput = {
    id?: IntFieldUpdateOperationsInput | number
    user_id?: IntFieldUpdateOperationsInput | number
    created_by_id?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    subscription_id?: IntFieldUpdateOperationsInput | number
  }

  export type user_subscriptionCreateManyInput = {
    id?: number
    user_id: number
    created_by_id: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    subscription_id: number
  }

  export type user_subscriptionUpdateManyMutationInput = {
    user_id?: IntFieldUpdateOperationsInput | number
    created_by_id?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type user_subscriptionUncheckedUpdateManyInput = {
    id?: IntFieldUpdateOperationsInput | number
    user_id?: IntFieldUpdateOperationsInput | number
    created_by_id?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    subscription_id?: IntFieldUpdateOperationsInput | number
  }

  export type user_permissionsCreateInput = {
    user_id: number
    limit?: number | null
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    userPermission: permissions_listCreateNestedOneWithoutUser_permissionsInput
  }

  export type user_permissionsUncheckedCreateInput = {
    id?: number
    user_id: number
    limit?: number | null
    permission_id: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
  }

  export type user_permissionsUpdateInput = {
    user_id?: IntFieldUpdateOperationsInput | number
    limit?: NullableIntFieldUpdateOperationsInput | number | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    userPermission?: permissions_listUpdateOneRequiredWithoutUser_permissionsNestedInput
  }

  export type user_permissionsUncheckedUpdateInput = {
    id?: IntFieldUpdateOperationsInput | number
    user_id?: IntFieldUpdateOperationsInput | number
    limit?: NullableIntFieldUpdateOperationsInput | number | null
    permission_id?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type user_permissionsCreateManyInput = {
    id?: number
    user_id: number
    limit?: number | null
    permission_id: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
  }

  export type user_permissionsUpdateManyMutationInput = {
    user_id?: IntFieldUpdateOperationsInput | number
    limit?: NullableIntFieldUpdateOperationsInput | number | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type user_permissionsUncheckedUpdateManyInput = {
    id?: IntFieldUpdateOperationsInput | number
    user_id?: IntFieldUpdateOperationsInput | number
    limit?: NullableIntFieldUpdateOperationsInput | number | null
    permission_id?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type package_featuresCreateInput = {
    website_analysis?: boolean
    content_duplicacy?: boolean
    initial_backlinks?: boolean
    critical_seo_analysis?: boolean
    google_penalty_check?: boolean
    competition_analysis?: number
    competitor_backlinks_opportunity?: number
    keyword_research_analysis?: boolean
    on_page_optimization?: boolean
    title_tags_optimization?: boolean
    meta_tags_optimization?: boolean
    content_optimization?: boolean
    html_code_optimization?: boolean
    website_permalinks_analysis?: boolean
    seo_friendly_urls?: boolean
    schema_markup_analysis?: boolean
    internal_linking_optimization?: boolean
    crawl_error_resolution?: boolean
    heading_tags_optimization?: boolean
    canonicalization_301_redirect?: boolean
    custom_404_errors?: boolean
    images_optimization?: boolean
    hyperlink_optimization?: boolean
    robots_txt_creation_optimization?: boolean
    sitemap_creation?: boolean
    google_webmaster_tools_setup?: boolean
    bing_Webmaster_tools_setup?: boolean
    google_analytics_setup_Integration?: boolean
    website_responsive_check?: boolean
    page_speed_analysis?: boolean
    mobile_responsive_compatibility_check?: boolean
    navigation_ux_factors?: boolean
    ssl_certificate?: boolean
    web_2_0_400_600_words_blog_Writing?: number
    article_writing?: number
    classified_writing?: number
    press_release_writing?: number
    ppt_pdf_creation_writing?: number
    web_2_0_400_600_words_submission?: number
    web_2_0_blog_promotion?: number
    article_submission?: number
    article_promotion?: number
    guest_blogging?: number
    custom_graphics_to_support_your_blogs?: boolean
    social_bookmarking_links?: number
    press_release_submission?: number
    local_citation?: number
    classified_submissions?: number
    ppt_submission?: number
    ppt_promotion_backlinks?: number
    pdf_submission?: number
    pdf_promotion_backlinks?: number
    quora_Q_A?: number
    profile_creation?: number
    blog_commenting_niche_edu?: number
    forum_submission?: number
    google_my_business_setup_verification?: boolean
    local_citation_submissions?: number
    google_places_photo_multimedia_additions?: boolean
    customer_reviews_ratings?: number
    local_classified_ads?: number
    monthly_keyword_improvement_report?: boolean
    monthly_back_links_report?: boolean
    monthly_google_analytic_static_report?: boolean
    email?: boolean
    telephone_whatsapp_telegram?: boolean
    internet_messenger_skype?: boolean
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    status?: number | null
    Features: subscriptionCreateNestedOneWithoutPackage_featuresInput
  }

  export type package_featuresUncheckedCreateInput = {
    id?: number
    subscription_id: number
    website_analysis?: boolean
    content_duplicacy?: boolean
    initial_backlinks?: boolean
    critical_seo_analysis?: boolean
    google_penalty_check?: boolean
    competition_analysis?: number
    competitor_backlinks_opportunity?: number
    keyword_research_analysis?: boolean
    on_page_optimization?: boolean
    title_tags_optimization?: boolean
    meta_tags_optimization?: boolean
    content_optimization?: boolean
    html_code_optimization?: boolean
    website_permalinks_analysis?: boolean
    seo_friendly_urls?: boolean
    schema_markup_analysis?: boolean
    internal_linking_optimization?: boolean
    crawl_error_resolution?: boolean
    heading_tags_optimization?: boolean
    canonicalization_301_redirect?: boolean
    custom_404_errors?: boolean
    images_optimization?: boolean
    hyperlink_optimization?: boolean
    robots_txt_creation_optimization?: boolean
    sitemap_creation?: boolean
    google_webmaster_tools_setup?: boolean
    bing_Webmaster_tools_setup?: boolean
    google_analytics_setup_Integration?: boolean
    website_responsive_check?: boolean
    page_speed_analysis?: boolean
    mobile_responsive_compatibility_check?: boolean
    navigation_ux_factors?: boolean
    ssl_certificate?: boolean
    web_2_0_400_600_words_blog_Writing?: number
    article_writing?: number
    classified_writing?: number
    press_release_writing?: number
    ppt_pdf_creation_writing?: number
    web_2_0_400_600_words_submission?: number
    web_2_0_blog_promotion?: number
    article_submission?: number
    article_promotion?: number
    guest_blogging?: number
    custom_graphics_to_support_your_blogs?: boolean
    social_bookmarking_links?: number
    press_release_submission?: number
    local_citation?: number
    classified_submissions?: number
    ppt_submission?: number
    ppt_promotion_backlinks?: number
    pdf_submission?: number
    pdf_promotion_backlinks?: number
    quora_Q_A?: number
    profile_creation?: number
    blog_commenting_niche_edu?: number
    forum_submission?: number
    google_my_business_setup_verification?: boolean
    local_citation_submissions?: number
    google_places_photo_multimedia_additions?: boolean
    customer_reviews_ratings?: number
    local_classified_ads?: number
    monthly_keyword_improvement_report?: boolean
    monthly_back_links_report?: boolean
    monthly_google_analytic_static_report?: boolean
    email?: boolean
    telephone_whatsapp_telegram?: boolean
    internet_messenger_skype?: boolean
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    status?: number | null
  }

  export type package_featuresUpdateInput = {
    website_analysis?: BoolFieldUpdateOperationsInput | boolean
    content_duplicacy?: BoolFieldUpdateOperationsInput | boolean
    initial_backlinks?: BoolFieldUpdateOperationsInput | boolean
    critical_seo_analysis?: BoolFieldUpdateOperationsInput | boolean
    google_penalty_check?: BoolFieldUpdateOperationsInput | boolean
    competition_analysis?: IntFieldUpdateOperationsInput | number
    competitor_backlinks_opportunity?: IntFieldUpdateOperationsInput | number
    keyword_research_analysis?: BoolFieldUpdateOperationsInput | boolean
    on_page_optimization?: BoolFieldUpdateOperationsInput | boolean
    title_tags_optimization?: BoolFieldUpdateOperationsInput | boolean
    meta_tags_optimization?: BoolFieldUpdateOperationsInput | boolean
    content_optimization?: BoolFieldUpdateOperationsInput | boolean
    html_code_optimization?: BoolFieldUpdateOperationsInput | boolean
    website_permalinks_analysis?: BoolFieldUpdateOperationsInput | boolean
    seo_friendly_urls?: BoolFieldUpdateOperationsInput | boolean
    schema_markup_analysis?: BoolFieldUpdateOperationsInput | boolean
    internal_linking_optimization?: BoolFieldUpdateOperationsInput | boolean
    crawl_error_resolution?: BoolFieldUpdateOperationsInput | boolean
    heading_tags_optimization?: BoolFieldUpdateOperationsInput | boolean
    canonicalization_301_redirect?: BoolFieldUpdateOperationsInput | boolean
    custom_404_errors?: BoolFieldUpdateOperationsInput | boolean
    images_optimization?: BoolFieldUpdateOperationsInput | boolean
    hyperlink_optimization?: BoolFieldUpdateOperationsInput | boolean
    robots_txt_creation_optimization?: BoolFieldUpdateOperationsInput | boolean
    sitemap_creation?: BoolFieldUpdateOperationsInput | boolean
    google_webmaster_tools_setup?: BoolFieldUpdateOperationsInput | boolean
    bing_Webmaster_tools_setup?: BoolFieldUpdateOperationsInput | boolean
    google_analytics_setup_Integration?: BoolFieldUpdateOperationsInput | boolean
    website_responsive_check?: BoolFieldUpdateOperationsInput | boolean
    page_speed_analysis?: BoolFieldUpdateOperationsInput | boolean
    mobile_responsive_compatibility_check?: BoolFieldUpdateOperationsInput | boolean
    navigation_ux_factors?: BoolFieldUpdateOperationsInput | boolean
    ssl_certificate?: BoolFieldUpdateOperationsInput | boolean
    web_2_0_400_600_words_blog_Writing?: IntFieldUpdateOperationsInput | number
    article_writing?: IntFieldUpdateOperationsInput | number
    classified_writing?: IntFieldUpdateOperationsInput | number
    press_release_writing?: IntFieldUpdateOperationsInput | number
    ppt_pdf_creation_writing?: IntFieldUpdateOperationsInput | number
    web_2_0_400_600_words_submission?: IntFieldUpdateOperationsInput | number
    web_2_0_blog_promotion?: IntFieldUpdateOperationsInput | number
    article_submission?: IntFieldUpdateOperationsInput | number
    article_promotion?: IntFieldUpdateOperationsInput | number
    guest_blogging?: IntFieldUpdateOperationsInput | number
    custom_graphics_to_support_your_blogs?: BoolFieldUpdateOperationsInput | boolean
    social_bookmarking_links?: IntFieldUpdateOperationsInput | number
    press_release_submission?: IntFieldUpdateOperationsInput | number
    local_citation?: IntFieldUpdateOperationsInput | number
    classified_submissions?: IntFieldUpdateOperationsInput | number
    ppt_submission?: IntFieldUpdateOperationsInput | number
    ppt_promotion_backlinks?: IntFieldUpdateOperationsInput | number
    pdf_submission?: IntFieldUpdateOperationsInput | number
    pdf_promotion_backlinks?: IntFieldUpdateOperationsInput | number
    quora_Q_A?: IntFieldUpdateOperationsInput | number
    profile_creation?: IntFieldUpdateOperationsInput | number
    blog_commenting_niche_edu?: IntFieldUpdateOperationsInput | number
    forum_submission?: IntFieldUpdateOperationsInput | number
    google_my_business_setup_verification?: BoolFieldUpdateOperationsInput | boolean
    local_citation_submissions?: IntFieldUpdateOperationsInput | number
    google_places_photo_multimedia_additions?: BoolFieldUpdateOperationsInput | boolean
    customer_reviews_ratings?: IntFieldUpdateOperationsInput | number
    local_classified_ads?: IntFieldUpdateOperationsInput | number
    monthly_keyword_improvement_report?: BoolFieldUpdateOperationsInput | boolean
    monthly_back_links_report?: BoolFieldUpdateOperationsInput | boolean
    monthly_google_analytic_static_report?: BoolFieldUpdateOperationsInput | boolean
    email?: BoolFieldUpdateOperationsInput | boolean
    telephone_whatsapp_telegram?: BoolFieldUpdateOperationsInput | boolean
    internet_messenger_skype?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    status?: NullableIntFieldUpdateOperationsInput | number | null
    Features?: subscriptionUpdateOneRequiredWithoutPackage_featuresNestedInput
  }

  export type package_featuresUncheckedUpdateInput = {
    id?: IntFieldUpdateOperationsInput | number
    subscription_id?: IntFieldUpdateOperationsInput | number
    website_analysis?: BoolFieldUpdateOperationsInput | boolean
    content_duplicacy?: BoolFieldUpdateOperationsInput | boolean
    initial_backlinks?: BoolFieldUpdateOperationsInput | boolean
    critical_seo_analysis?: BoolFieldUpdateOperationsInput | boolean
    google_penalty_check?: BoolFieldUpdateOperationsInput | boolean
    competition_analysis?: IntFieldUpdateOperationsInput | number
    competitor_backlinks_opportunity?: IntFieldUpdateOperationsInput | number
    keyword_research_analysis?: BoolFieldUpdateOperationsInput | boolean
    on_page_optimization?: BoolFieldUpdateOperationsInput | boolean
    title_tags_optimization?: BoolFieldUpdateOperationsInput | boolean
    meta_tags_optimization?: BoolFieldUpdateOperationsInput | boolean
    content_optimization?: BoolFieldUpdateOperationsInput | boolean
    html_code_optimization?: BoolFieldUpdateOperationsInput | boolean
    website_permalinks_analysis?: BoolFieldUpdateOperationsInput | boolean
    seo_friendly_urls?: BoolFieldUpdateOperationsInput | boolean
    schema_markup_analysis?: BoolFieldUpdateOperationsInput | boolean
    internal_linking_optimization?: BoolFieldUpdateOperationsInput | boolean
    crawl_error_resolution?: BoolFieldUpdateOperationsInput | boolean
    heading_tags_optimization?: BoolFieldUpdateOperationsInput | boolean
    canonicalization_301_redirect?: BoolFieldUpdateOperationsInput | boolean
    custom_404_errors?: BoolFieldUpdateOperationsInput | boolean
    images_optimization?: BoolFieldUpdateOperationsInput | boolean
    hyperlink_optimization?: BoolFieldUpdateOperationsInput | boolean
    robots_txt_creation_optimization?: BoolFieldUpdateOperationsInput | boolean
    sitemap_creation?: BoolFieldUpdateOperationsInput | boolean
    google_webmaster_tools_setup?: BoolFieldUpdateOperationsInput | boolean
    bing_Webmaster_tools_setup?: BoolFieldUpdateOperationsInput | boolean
    google_analytics_setup_Integration?: BoolFieldUpdateOperationsInput | boolean
    website_responsive_check?: BoolFieldUpdateOperationsInput | boolean
    page_speed_analysis?: BoolFieldUpdateOperationsInput | boolean
    mobile_responsive_compatibility_check?: BoolFieldUpdateOperationsInput | boolean
    navigation_ux_factors?: BoolFieldUpdateOperationsInput | boolean
    ssl_certificate?: BoolFieldUpdateOperationsInput | boolean
    web_2_0_400_600_words_blog_Writing?: IntFieldUpdateOperationsInput | number
    article_writing?: IntFieldUpdateOperationsInput | number
    classified_writing?: IntFieldUpdateOperationsInput | number
    press_release_writing?: IntFieldUpdateOperationsInput | number
    ppt_pdf_creation_writing?: IntFieldUpdateOperationsInput | number
    web_2_0_400_600_words_submission?: IntFieldUpdateOperationsInput | number
    web_2_0_blog_promotion?: IntFieldUpdateOperationsInput | number
    article_submission?: IntFieldUpdateOperationsInput | number
    article_promotion?: IntFieldUpdateOperationsInput | number
    guest_blogging?: IntFieldUpdateOperationsInput | number
    custom_graphics_to_support_your_blogs?: BoolFieldUpdateOperationsInput | boolean
    social_bookmarking_links?: IntFieldUpdateOperationsInput | number
    press_release_submission?: IntFieldUpdateOperationsInput | number
    local_citation?: IntFieldUpdateOperationsInput | number
    classified_submissions?: IntFieldUpdateOperationsInput | number
    ppt_submission?: IntFieldUpdateOperationsInput | number
    ppt_promotion_backlinks?: IntFieldUpdateOperationsInput | number
    pdf_submission?: IntFieldUpdateOperationsInput | number
    pdf_promotion_backlinks?: IntFieldUpdateOperationsInput | number
    quora_Q_A?: IntFieldUpdateOperationsInput | number
    profile_creation?: IntFieldUpdateOperationsInput | number
    blog_commenting_niche_edu?: IntFieldUpdateOperationsInput | number
    forum_submission?: IntFieldUpdateOperationsInput | number
    google_my_business_setup_verification?: BoolFieldUpdateOperationsInput | boolean
    local_citation_submissions?: IntFieldUpdateOperationsInput | number
    google_places_photo_multimedia_additions?: BoolFieldUpdateOperationsInput | boolean
    customer_reviews_ratings?: IntFieldUpdateOperationsInput | number
    local_classified_ads?: IntFieldUpdateOperationsInput | number
    monthly_keyword_improvement_report?: BoolFieldUpdateOperationsInput | boolean
    monthly_back_links_report?: BoolFieldUpdateOperationsInput | boolean
    monthly_google_analytic_static_report?: BoolFieldUpdateOperationsInput | boolean
    email?: BoolFieldUpdateOperationsInput | boolean
    telephone_whatsapp_telegram?: BoolFieldUpdateOperationsInput | boolean
    internet_messenger_skype?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    status?: NullableIntFieldUpdateOperationsInput | number | null
  }

  export type package_featuresCreateManyInput = {
    id?: number
    subscription_id: number
    website_analysis?: boolean
    content_duplicacy?: boolean
    initial_backlinks?: boolean
    critical_seo_analysis?: boolean
    google_penalty_check?: boolean
    competition_analysis?: number
    competitor_backlinks_opportunity?: number
    keyword_research_analysis?: boolean
    on_page_optimization?: boolean
    title_tags_optimization?: boolean
    meta_tags_optimization?: boolean
    content_optimization?: boolean
    html_code_optimization?: boolean
    website_permalinks_analysis?: boolean
    seo_friendly_urls?: boolean
    schema_markup_analysis?: boolean
    internal_linking_optimization?: boolean
    crawl_error_resolution?: boolean
    heading_tags_optimization?: boolean
    canonicalization_301_redirect?: boolean
    custom_404_errors?: boolean
    images_optimization?: boolean
    hyperlink_optimization?: boolean
    robots_txt_creation_optimization?: boolean
    sitemap_creation?: boolean
    google_webmaster_tools_setup?: boolean
    bing_Webmaster_tools_setup?: boolean
    google_analytics_setup_Integration?: boolean
    website_responsive_check?: boolean
    page_speed_analysis?: boolean
    mobile_responsive_compatibility_check?: boolean
    navigation_ux_factors?: boolean
    ssl_certificate?: boolean
    web_2_0_400_600_words_blog_Writing?: number
    article_writing?: number
    classified_writing?: number
    press_release_writing?: number
    ppt_pdf_creation_writing?: number
    web_2_0_400_600_words_submission?: number
    web_2_0_blog_promotion?: number
    article_submission?: number
    article_promotion?: number
    guest_blogging?: number
    custom_graphics_to_support_your_blogs?: boolean
    social_bookmarking_links?: number
    press_release_submission?: number
    local_citation?: number
    classified_submissions?: number
    ppt_submission?: number
    ppt_promotion_backlinks?: number
    pdf_submission?: number
    pdf_promotion_backlinks?: number
    quora_Q_A?: number
    profile_creation?: number
    blog_commenting_niche_edu?: number
    forum_submission?: number
    google_my_business_setup_verification?: boolean
    local_citation_submissions?: number
    google_places_photo_multimedia_additions?: boolean
    customer_reviews_ratings?: number
    local_classified_ads?: number
    monthly_keyword_improvement_report?: boolean
    monthly_back_links_report?: boolean
    monthly_google_analytic_static_report?: boolean
    email?: boolean
    telephone_whatsapp_telegram?: boolean
    internet_messenger_skype?: boolean
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    status?: number | null
  }

  export type package_featuresUpdateManyMutationInput = {
    website_analysis?: BoolFieldUpdateOperationsInput | boolean
    content_duplicacy?: BoolFieldUpdateOperationsInput | boolean
    initial_backlinks?: BoolFieldUpdateOperationsInput | boolean
    critical_seo_analysis?: BoolFieldUpdateOperationsInput | boolean
    google_penalty_check?: BoolFieldUpdateOperationsInput | boolean
    competition_analysis?: IntFieldUpdateOperationsInput | number
    competitor_backlinks_opportunity?: IntFieldUpdateOperationsInput | number
    keyword_research_analysis?: BoolFieldUpdateOperationsInput | boolean
    on_page_optimization?: BoolFieldUpdateOperationsInput | boolean
    title_tags_optimization?: BoolFieldUpdateOperationsInput | boolean
    meta_tags_optimization?: BoolFieldUpdateOperationsInput | boolean
    content_optimization?: BoolFieldUpdateOperationsInput | boolean
    html_code_optimization?: BoolFieldUpdateOperationsInput | boolean
    website_permalinks_analysis?: BoolFieldUpdateOperationsInput | boolean
    seo_friendly_urls?: BoolFieldUpdateOperationsInput | boolean
    schema_markup_analysis?: BoolFieldUpdateOperationsInput | boolean
    internal_linking_optimization?: BoolFieldUpdateOperationsInput | boolean
    crawl_error_resolution?: BoolFieldUpdateOperationsInput | boolean
    heading_tags_optimization?: BoolFieldUpdateOperationsInput | boolean
    canonicalization_301_redirect?: BoolFieldUpdateOperationsInput | boolean
    custom_404_errors?: BoolFieldUpdateOperationsInput | boolean
    images_optimization?: BoolFieldUpdateOperationsInput | boolean
    hyperlink_optimization?: BoolFieldUpdateOperationsInput | boolean
    robots_txt_creation_optimization?: BoolFieldUpdateOperationsInput | boolean
    sitemap_creation?: BoolFieldUpdateOperationsInput | boolean
    google_webmaster_tools_setup?: BoolFieldUpdateOperationsInput | boolean
    bing_Webmaster_tools_setup?: BoolFieldUpdateOperationsInput | boolean
    google_analytics_setup_Integration?: BoolFieldUpdateOperationsInput | boolean
    website_responsive_check?: BoolFieldUpdateOperationsInput | boolean
    page_speed_analysis?: BoolFieldUpdateOperationsInput | boolean
    mobile_responsive_compatibility_check?: BoolFieldUpdateOperationsInput | boolean
    navigation_ux_factors?: BoolFieldUpdateOperationsInput | boolean
    ssl_certificate?: BoolFieldUpdateOperationsInput | boolean
    web_2_0_400_600_words_blog_Writing?: IntFieldUpdateOperationsInput | number
    article_writing?: IntFieldUpdateOperationsInput | number
    classified_writing?: IntFieldUpdateOperationsInput | number
    press_release_writing?: IntFieldUpdateOperationsInput | number
    ppt_pdf_creation_writing?: IntFieldUpdateOperationsInput | number
    web_2_0_400_600_words_submission?: IntFieldUpdateOperationsInput | number
    web_2_0_blog_promotion?: IntFieldUpdateOperationsInput | number
    article_submission?: IntFieldUpdateOperationsInput | number
    article_promotion?: IntFieldUpdateOperationsInput | number
    guest_blogging?: IntFieldUpdateOperationsInput | number
    custom_graphics_to_support_your_blogs?: BoolFieldUpdateOperationsInput | boolean
    social_bookmarking_links?: IntFieldUpdateOperationsInput | number
    press_release_submission?: IntFieldUpdateOperationsInput | number
    local_citation?: IntFieldUpdateOperationsInput | number
    classified_submissions?: IntFieldUpdateOperationsInput | number
    ppt_submission?: IntFieldUpdateOperationsInput | number
    ppt_promotion_backlinks?: IntFieldUpdateOperationsInput | number
    pdf_submission?: IntFieldUpdateOperationsInput | number
    pdf_promotion_backlinks?: IntFieldUpdateOperationsInput | number
    quora_Q_A?: IntFieldUpdateOperationsInput | number
    profile_creation?: IntFieldUpdateOperationsInput | number
    blog_commenting_niche_edu?: IntFieldUpdateOperationsInput | number
    forum_submission?: IntFieldUpdateOperationsInput | number
    google_my_business_setup_verification?: BoolFieldUpdateOperationsInput | boolean
    local_citation_submissions?: IntFieldUpdateOperationsInput | number
    google_places_photo_multimedia_additions?: BoolFieldUpdateOperationsInput | boolean
    customer_reviews_ratings?: IntFieldUpdateOperationsInput | number
    local_classified_ads?: IntFieldUpdateOperationsInput | number
    monthly_keyword_improvement_report?: BoolFieldUpdateOperationsInput | boolean
    monthly_back_links_report?: BoolFieldUpdateOperationsInput | boolean
    monthly_google_analytic_static_report?: BoolFieldUpdateOperationsInput | boolean
    email?: BoolFieldUpdateOperationsInput | boolean
    telephone_whatsapp_telegram?: BoolFieldUpdateOperationsInput | boolean
    internet_messenger_skype?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    status?: NullableIntFieldUpdateOperationsInput | number | null
  }

  export type package_featuresUncheckedUpdateManyInput = {
    id?: IntFieldUpdateOperationsInput | number
    subscription_id?: IntFieldUpdateOperationsInput | number
    website_analysis?: BoolFieldUpdateOperationsInput | boolean
    content_duplicacy?: BoolFieldUpdateOperationsInput | boolean
    initial_backlinks?: BoolFieldUpdateOperationsInput | boolean
    critical_seo_analysis?: BoolFieldUpdateOperationsInput | boolean
    google_penalty_check?: BoolFieldUpdateOperationsInput | boolean
    competition_analysis?: IntFieldUpdateOperationsInput | number
    competitor_backlinks_opportunity?: IntFieldUpdateOperationsInput | number
    keyword_research_analysis?: BoolFieldUpdateOperationsInput | boolean
    on_page_optimization?: BoolFieldUpdateOperationsInput | boolean
    title_tags_optimization?: BoolFieldUpdateOperationsInput | boolean
    meta_tags_optimization?: BoolFieldUpdateOperationsInput | boolean
    content_optimization?: BoolFieldUpdateOperationsInput | boolean
    html_code_optimization?: BoolFieldUpdateOperationsInput | boolean
    website_permalinks_analysis?: BoolFieldUpdateOperationsInput | boolean
    seo_friendly_urls?: BoolFieldUpdateOperationsInput | boolean
    schema_markup_analysis?: BoolFieldUpdateOperationsInput | boolean
    internal_linking_optimization?: BoolFieldUpdateOperationsInput | boolean
    crawl_error_resolution?: BoolFieldUpdateOperationsInput | boolean
    heading_tags_optimization?: BoolFieldUpdateOperationsInput | boolean
    canonicalization_301_redirect?: BoolFieldUpdateOperationsInput | boolean
    custom_404_errors?: BoolFieldUpdateOperationsInput | boolean
    images_optimization?: BoolFieldUpdateOperationsInput | boolean
    hyperlink_optimization?: BoolFieldUpdateOperationsInput | boolean
    robots_txt_creation_optimization?: BoolFieldUpdateOperationsInput | boolean
    sitemap_creation?: BoolFieldUpdateOperationsInput | boolean
    google_webmaster_tools_setup?: BoolFieldUpdateOperationsInput | boolean
    bing_Webmaster_tools_setup?: BoolFieldUpdateOperationsInput | boolean
    google_analytics_setup_Integration?: BoolFieldUpdateOperationsInput | boolean
    website_responsive_check?: BoolFieldUpdateOperationsInput | boolean
    page_speed_analysis?: BoolFieldUpdateOperationsInput | boolean
    mobile_responsive_compatibility_check?: BoolFieldUpdateOperationsInput | boolean
    navigation_ux_factors?: BoolFieldUpdateOperationsInput | boolean
    ssl_certificate?: BoolFieldUpdateOperationsInput | boolean
    web_2_0_400_600_words_blog_Writing?: IntFieldUpdateOperationsInput | number
    article_writing?: IntFieldUpdateOperationsInput | number
    classified_writing?: IntFieldUpdateOperationsInput | number
    press_release_writing?: IntFieldUpdateOperationsInput | number
    ppt_pdf_creation_writing?: IntFieldUpdateOperationsInput | number
    web_2_0_400_600_words_submission?: IntFieldUpdateOperationsInput | number
    web_2_0_blog_promotion?: IntFieldUpdateOperationsInput | number
    article_submission?: IntFieldUpdateOperationsInput | number
    article_promotion?: IntFieldUpdateOperationsInput | number
    guest_blogging?: IntFieldUpdateOperationsInput | number
    custom_graphics_to_support_your_blogs?: BoolFieldUpdateOperationsInput | boolean
    social_bookmarking_links?: IntFieldUpdateOperationsInput | number
    press_release_submission?: IntFieldUpdateOperationsInput | number
    local_citation?: IntFieldUpdateOperationsInput | number
    classified_submissions?: IntFieldUpdateOperationsInput | number
    ppt_submission?: IntFieldUpdateOperationsInput | number
    ppt_promotion_backlinks?: IntFieldUpdateOperationsInput | number
    pdf_submission?: IntFieldUpdateOperationsInput | number
    pdf_promotion_backlinks?: IntFieldUpdateOperationsInput | number
    quora_Q_A?: IntFieldUpdateOperationsInput | number
    profile_creation?: IntFieldUpdateOperationsInput | number
    blog_commenting_niche_edu?: IntFieldUpdateOperationsInput | number
    forum_submission?: IntFieldUpdateOperationsInput | number
    google_my_business_setup_verification?: BoolFieldUpdateOperationsInput | boolean
    local_citation_submissions?: IntFieldUpdateOperationsInput | number
    google_places_photo_multimedia_additions?: BoolFieldUpdateOperationsInput | boolean
    customer_reviews_ratings?: IntFieldUpdateOperationsInput | number
    local_classified_ads?: IntFieldUpdateOperationsInput | number
    monthly_keyword_improvement_report?: BoolFieldUpdateOperationsInput | boolean
    monthly_back_links_report?: BoolFieldUpdateOperationsInput | boolean
    monthly_google_analytic_static_report?: BoolFieldUpdateOperationsInput | boolean
    email?: BoolFieldUpdateOperationsInput | boolean
    telephone_whatsapp_telegram?: BoolFieldUpdateOperationsInput | boolean
    internet_messenger_skype?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    status?: NullableIntFieldUpdateOperationsInput | number | null
  }

  export type IntFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[] | ListIntFieldRefInput<$PrismaModel>
    notIn?: number[] | ListIntFieldRefInput<$PrismaModel>
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntFilter<$PrismaModel> | number
  }

  export type StringFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[] | ListStringFieldRefInput<$PrismaModel>
    notIn?: string[] | ListStringFieldRefInput<$PrismaModel>
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    mode?: QueryMode
    not?: NestedStringFilter<$PrismaModel> | string
  }

  export type DateTimeFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeFilter<$PrismaModel> | Date | string
  }

  export type DateTimeNullableFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel> | null
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeNullableFilter<$PrismaModel> | Date | string | null
  }

  export type BacklinkListRelationFilter = {
    every?: BacklinkWhereInput
    some?: BacklinkWhereInput
    none?: BacklinkWhereInput
  }

  export type SortOrderInput = {
    sort: SortOrder
    nulls?: NullsOrder
  }

  export type BacklinkOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type ProjectsCountOrderByAggregateInput = {
    id?: SortOrder
    domain_name?: SortOrder
    domain_url?: SortOrder
    category_id?: SortOrder
    created_by_id?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
    time_around?: SortOrder
    time_around_days?: SortOrder
  }

  export type ProjectsAvgOrderByAggregateInput = {
    id?: SortOrder
    category_id?: SortOrder
    created_by_id?: SortOrder
    time_around_days?: SortOrder
  }

  export type ProjectsMaxOrderByAggregateInput = {
    id?: SortOrder
    domain_name?: SortOrder
    domain_url?: SortOrder
    category_id?: SortOrder
    created_by_id?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
    time_around?: SortOrder
    time_around_days?: SortOrder
  }

  export type ProjectsMinOrderByAggregateInput = {
    id?: SortOrder
    domain_name?: SortOrder
    domain_url?: SortOrder
    category_id?: SortOrder
    created_by_id?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
    time_around?: SortOrder
    time_around_days?: SortOrder
  }

  export type ProjectsSumOrderByAggregateInput = {
    id?: SortOrder
    category_id?: SortOrder
    created_by_id?: SortOrder
    time_around_days?: SortOrder
  }

  export type IntWithAggregatesFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[] | ListIntFieldRefInput<$PrismaModel>
    notIn?: number[] | ListIntFieldRefInput<$PrismaModel>
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntWithAggregatesFilter<$PrismaModel> | number
    _count?: NestedIntFilter<$PrismaModel>
    _avg?: NestedFloatFilter<$PrismaModel>
    _sum?: NestedIntFilter<$PrismaModel>
    _min?: NestedIntFilter<$PrismaModel>
    _max?: NestedIntFilter<$PrismaModel>
  }

  export type StringWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[] | ListStringFieldRefInput<$PrismaModel>
    notIn?: string[] | ListStringFieldRefInput<$PrismaModel>
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    mode?: QueryMode
    not?: NestedStringWithAggregatesFilter<$PrismaModel> | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedStringFilter<$PrismaModel>
    _max?: NestedStringFilter<$PrismaModel>
  }

  export type DateTimeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeWithAggregatesFilter<$PrismaModel> | Date | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedDateTimeFilter<$PrismaModel>
    _max?: NestedDateTimeFilter<$PrismaModel>
  }

  export type DateTimeNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel> | null
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeNullableWithAggregatesFilter<$PrismaModel> | Date | string | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedDateTimeNullableFilter<$PrismaModel>
    _max?: NestedDateTimeNullableFilter<$PrismaModel>
  }

  export type BoolNullableFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel> | null
    not?: NestedBoolNullableFilter<$PrismaModel> | boolean | null
  }

  export type StringNullableFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | ListStringFieldRefInput<$PrismaModel> | null
    notIn?: string[] | ListStringFieldRefInput<$PrismaModel> | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    mode?: QueryMode
    not?: NestedStringNullableFilter<$PrismaModel> | string | null
  }

  export type IntNullableFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel> | null
    in?: number[] | ListIntFieldRefInput<$PrismaModel> | null
    notIn?: number[] | ListIntFieldRefInput<$PrismaModel> | null
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntNullableFilter<$PrismaModel> | number | null
  }

  export type ProjectsScalarRelationFilter = {
    is?: ProjectsWhereInput
    isNot?: ProjectsWhereInput
  }

  export type BacklinkCountOrderByAggregateInput = {
    id?: SortOrder
    link_url?: SortOrder
    link_status?: SortOrder
    is_index?: SortOrder
    link_rel?: SortOrder
    anchor_text?: SortOrder
    targeted_url?: SortOrder
    project_id?: SortOrder
    uploaded_by_id?: SortOrder
    first_seen?: SortOrder
    last_seen?: SortOrder
    added_date?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
    backlink_duplicate?: SortOrder
    referring_domain?: SortOrder
    managed_by?: SortOrder
  }

  export type BacklinkAvgOrderByAggregateInput = {
    id?: SortOrder
    link_status?: SortOrder
    project_id?: SortOrder
    uploaded_by_id?: SortOrder
    managed_by?: SortOrder
  }

  export type BacklinkMaxOrderByAggregateInput = {
    id?: SortOrder
    link_url?: SortOrder
    link_status?: SortOrder
    is_index?: SortOrder
    link_rel?: SortOrder
    anchor_text?: SortOrder
    targeted_url?: SortOrder
    project_id?: SortOrder
    uploaded_by_id?: SortOrder
    first_seen?: SortOrder
    last_seen?: SortOrder
    added_date?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
    backlink_duplicate?: SortOrder
    referring_domain?: SortOrder
    managed_by?: SortOrder
  }

  export type BacklinkMinOrderByAggregateInput = {
    id?: SortOrder
    link_url?: SortOrder
    link_status?: SortOrder
    is_index?: SortOrder
    link_rel?: SortOrder
    anchor_text?: SortOrder
    targeted_url?: SortOrder
    project_id?: SortOrder
    uploaded_by_id?: SortOrder
    first_seen?: SortOrder
    last_seen?: SortOrder
    added_date?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
    backlink_duplicate?: SortOrder
    referring_domain?: SortOrder
    managed_by?: SortOrder
  }

  export type BacklinkSumOrderByAggregateInput = {
    id?: SortOrder
    link_status?: SortOrder
    project_id?: SortOrder
    uploaded_by_id?: SortOrder
    managed_by?: SortOrder
  }

  export type BoolNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel> | null
    not?: NestedBoolNullableWithAggregatesFilter<$PrismaModel> | boolean | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedBoolNullableFilter<$PrismaModel>
    _max?: NestedBoolNullableFilter<$PrismaModel>
  }

  export type StringNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | ListStringFieldRefInput<$PrismaModel> | null
    notIn?: string[] | ListStringFieldRefInput<$PrismaModel> | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    mode?: QueryMode
    not?: NestedStringNullableWithAggregatesFilter<$PrismaModel> | string | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedStringNullableFilter<$PrismaModel>
    _max?: NestedStringNullableFilter<$PrismaModel>
  }

  export type IntNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel> | null
    in?: number[] | ListIntFieldRefInput<$PrismaModel> | null
    notIn?: number[] | ListIntFieldRefInput<$PrismaModel> | null
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntNullableWithAggregatesFilter<$PrismaModel> | number | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _avg?: NestedFloatNullableFilter<$PrismaModel>
    _sum?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedIntNullableFilter<$PrismaModel>
    _max?: NestedIntNullableFilter<$PrismaModel>
  }

  export type User_permissionsListRelationFilter = {
    every?: user_permissionsWhereInput
    some?: user_permissionsWhereInput
    none?: user_permissionsWhereInput
  }

  export type Subscription_featureListRelationFilter = {
    every?: subscription_featureWhereInput
    some?: subscription_featureWhereInput
    none?: subscription_featureWhereInput
  }

  export type user_permissionsOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type subscription_featureOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type permissions_listCountOrderByAggregateInput = {
    id?: SortOrder
    title?: SortOrder
    type?: SortOrder
    created_by?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
  }

  export type permissions_listAvgOrderByAggregateInput = {
    id?: SortOrder
    created_by?: SortOrder
  }

  export type permissions_listMaxOrderByAggregateInput = {
    id?: SortOrder
    title?: SortOrder
    type?: SortOrder
    created_by?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
  }

  export type permissions_listMinOrderByAggregateInput = {
    id?: SortOrder
    title?: SortOrder
    type?: SortOrder
    created_by?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
  }

  export type permissions_listSumOrderByAggregateInput = {
    id?: SortOrder
    created_by?: SortOrder
  }

  export type rolesCountOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
  }

  export type rolesAvgOrderByAggregateInput = {
    id?: SortOrder
  }

  export type rolesMaxOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
  }

  export type rolesMinOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
  }

  export type rolesSumOrderByAggregateInput = {
    id?: SortOrder
  }

  export type User_subscriptionListRelationFilter = {
    every?: user_subscriptionWhereInput
    some?: user_subscriptionWhereInput
    none?: user_subscriptionWhereInput
  }

  export type Package_featuresListRelationFilter = {
    every?: package_featuresWhereInput
    some?: package_featuresWhereInput
    none?: package_featuresWhereInput
  }

  export type user_subscriptionOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type package_featuresOrderByRelationAggregateInput = {
    _count?: SortOrder
  }

  export type subscriptionCountOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    status?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
  }

  export type subscriptionAvgOrderByAggregateInput = {
    id?: SortOrder
    status?: SortOrder
  }

  export type subscriptionMaxOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    status?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
  }

  export type subscriptionMinOrderByAggregateInput = {
    id?: SortOrder
    name?: SortOrder
    status?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
  }

  export type subscriptionSumOrderByAggregateInput = {
    id?: SortOrder
    status?: SortOrder
  }

  export type SubscriptionScalarRelationFilter = {
    is?: subscriptionWhereInput
    isNot?: subscriptionWhereInput
  }

  export type Permissions_listScalarRelationFilter = {
    is?: permissions_listWhereInput
    isNot?: permissions_listWhereInput
  }

  export type subscription_featureCountOrderByAggregateInput = {
    id?: SortOrder
    status?: SortOrder
    subscription_id?: SortOrder
    permission_id?: SortOrder
    limit?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
  }

  export type subscription_featureAvgOrderByAggregateInput = {
    id?: SortOrder
    status?: SortOrder
    subscription_id?: SortOrder
    permission_id?: SortOrder
    limit?: SortOrder
  }

  export type subscription_featureMaxOrderByAggregateInput = {
    id?: SortOrder
    status?: SortOrder
    subscription_id?: SortOrder
    permission_id?: SortOrder
    limit?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
  }

  export type subscription_featureMinOrderByAggregateInput = {
    id?: SortOrder
    status?: SortOrder
    subscription_id?: SortOrder
    permission_id?: SortOrder
    limit?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
  }

  export type subscription_featureSumOrderByAggregateInput = {
    id?: SortOrder
    status?: SortOrder
    subscription_id?: SortOrder
    permission_id?: SortOrder
    limit?: SortOrder
  }

  export type user_subscriptionCountOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    created_by_id?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
    subscription_id?: SortOrder
  }

  export type user_subscriptionAvgOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    created_by_id?: SortOrder
    subscription_id?: SortOrder
  }

  export type user_subscriptionMaxOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    created_by_id?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
    subscription_id?: SortOrder
  }

  export type user_subscriptionMinOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    created_by_id?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
    subscription_id?: SortOrder
  }

  export type user_subscriptionSumOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    created_by_id?: SortOrder
    subscription_id?: SortOrder
  }

  export type user_permissionsCountOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    limit?: SortOrder
    permission_id?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
  }

  export type user_permissionsAvgOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    limit?: SortOrder
    permission_id?: SortOrder
  }

  export type user_permissionsMaxOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    limit?: SortOrder
    permission_id?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
  }

  export type user_permissionsMinOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    limit?: SortOrder
    permission_id?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
  }

  export type user_permissionsSumOrderByAggregateInput = {
    id?: SortOrder
    user_id?: SortOrder
    limit?: SortOrder
    permission_id?: SortOrder
  }

  export type BoolFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel>
    not?: NestedBoolFilter<$PrismaModel> | boolean
  }

  export type package_featuresCountOrderByAggregateInput = {
    id?: SortOrder
    subscription_id?: SortOrder
    website_analysis?: SortOrder
    content_duplicacy?: SortOrder
    initial_backlinks?: SortOrder
    critical_seo_analysis?: SortOrder
    google_penalty_check?: SortOrder
    competition_analysis?: SortOrder
    competitor_backlinks_opportunity?: SortOrder
    keyword_research_analysis?: SortOrder
    on_page_optimization?: SortOrder
    title_tags_optimization?: SortOrder
    meta_tags_optimization?: SortOrder
    content_optimization?: SortOrder
    html_code_optimization?: SortOrder
    website_permalinks_analysis?: SortOrder
    seo_friendly_urls?: SortOrder
    schema_markup_analysis?: SortOrder
    internal_linking_optimization?: SortOrder
    crawl_error_resolution?: SortOrder
    heading_tags_optimization?: SortOrder
    canonicalization_301_redirect?: SortOrder
    custom_404_errors?: SortOrder
    images_optimization?: SortOrder
    hyperlink_optimization?: SortOrder
    robots_txt_creation_optimization?: SortOrder
    sitemap_creation?: SortOrder
    google_webmaster_tools_setup?: SortOrder
    bing_Webmaster_tools_setup?: SortOrder
    google_analytics_setup_Integration?: SortOrder
    website_responsive_check?: SortOrder
    page_speed_analysis?: SortOrder
    mobile_responsive_compatibility_check?: SortOrder
    navigation_ux_factors?: SortOrder
    ssl_certificate?: SortOrder
    web_2_0_400_600_words_blog_Writing?: SortOrder
    article_writing?: SortOrder
    classified_writing?: SortOrder
    press_release_writing?: SortOrder
    ppt_pdf_creation_writing?: SortOrder
    web_2_0_400_600_words_submission?: SortOrder
    web_2_0_blog_promotion?: SortOrder
    article_submission?: SortOrder
    article_promotion?: SortOrder
    guest_blogging?: SortOrder
    custom_graphics_to_support_your_blogs?: SortOrder
    social_bookmarking_links?: SortOrder
    press_release_submission?: SortOrder
    local_citation?: SortOrder
    classified_submissions?: SortOrder
    ppt_submission?: SortOrder
    ppt_promotion_backlinks?: SortOrder
    pdf_submission?: SortOrder
    pdf_promotion_backlinks?: SortOrder
    quora_Q_A?: SortOrder
    profile_creation?: SortOrder
    blog_commenting_niche_edu?: SortOrder
    forum_submission?: SortOrder
    google_my_business_setup_verification?: SortOrder
    local_citation_submissions?: SortOrder
    google_places_photo_multimedia_additions?: SortOrder
    customer_reviews_ratings?: SortOrder
    local_classified_ads?: SortOrder
    monthly_keyword_improvement_report?: SortOrder
    monthly_back_links_report?: SortOrder
    monthly_google_analytic_static_report?: SortOrder
    email?: SortOrder
    telephone_whatsapp_telegram?: SortOrder
    internet_messenger_skype?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
    status?: SortOrder
  }

  export type package_featuresAvgOrderByAggregateInput = {
    id?: SortOrder
    subscription_id?: SortOrder
    competition_analysis?: SortOrder
    competitor_backlinks_opportunity?: SortOrder
    web_2_0_400_600_words_blog_Writing?: SortOrder
    article_writing?: SortOrder
    classified_writing?: SortOrder
    press_release_writing?: SortOrder
    ppt_pdf_creation_writing?: SortOrder
    web_2_0_400_600_words_submission?: SortOrder
    web_2_0_blog_promotion?: SortOrder
    article_submission?: SortOrder
    article_promotion?: SortOrder
    guest_blogging?: SortOrder
    social_bookmarking_links?: SortOrder
    press_release_submission?: SortOrder
    local_citation?: SortOrder
    classified_submissions?: SortOrder
    ppt_submission?: SortOrder
    ppt_promotion_backlinks?: SortOrder
    pdf_submission?: SortOrder
    pdf_promotion_backlinks?: SortOrder
    quora_Q_A?: SortOrder
    profile_creation?: SortOrder
    blog_commenting_niche_edu?: SortOrder
    forum_submission?: SortOrder
    local_citation_submissions?: SortOrder
    customer_reviews_ratings?: SortOrder
    local_classified_ads?: SortOrder
    status?: SortOrder
  }

  export type package_featuresMaxOrderByAggregateInput = {
    id?: SortOrder
    subscription_id?: SortOrder
    website_analysis?: SortOrder
    content_duplicacy?: SortOrder
    initial_backlinks?: SortOrder
    critical_seo_analysis?: SortOrder
    google_penalty_check?: SortOrder
    competition_analysis?: SortOrder
    competitor_backlinks_opportunity?: SortOrder
    keyword_research_analysis?: SortOrder
    on_page_optimization?: SortOrder
    title_tags_optimization?: SortOrder
    meta_tags_optimization?: SortOrder
    content_optimization?: SortOrder
    html_code_optimization?: SortOrder
    website_permalinks_analysis?: SortOrder
    seo_friendly_urls?: SortOrder
    schema_markup_analysis?: SortOrder
    internal_linking_optimization?: SortOrder
    crawl_error_resolution?: SortOrder
    heading_tags_optimization?: SortOrder
    canonicalization_301_redirect?: SortOrder
    custom_404_errors?: SortOrder
    images_optimization?: SortOrder
    hyperlink_optimization?: SortOrder
    robots_txt_creation_optimization?: SortOrder
    sitemap_creation?: SortOrder
    google_webmaster_tools_setup?: SortOrder
    bing_Webmaster_tools_setup?: SortOrder
    google_analytics_setup_Integration?: SortOrder
    website_responsive_check?: SortOrder
    page_speed_analysis?: SortOrder
    mobile_responsive_compatibility_check?: SortOrder
    navigation_ux_factors?: SortOrder
    ssl_certificate?: SortOrder
    web_2_0_400_600_words_blog_Writing?: SortOrder
    article_writing?: SortOrder
    classified_writing?: SortOrder
    press_release_writing?: SortOrder
    ppt_pdf_creation_writing?: SortOrder
    web_2_0_400_600_words_submission?: SortOrder
    web_2_0_blog_promotion?: SortOrder
    article_submission?: SortOrder
    article_promotion?: SortOrder
    guest_blogging?: SortOrder
    custom_graphics_to_support_your_blogs?: SortOrder
    social_bookmarking_links?: SortOrder
    press_release_submission?: SortOrder
    local_citation?: SortOrder
    classified_submissions?: SortOrder
    ppt_submission?: SortOrder
    ppt_promotion_backlinks?: SortOrder
    pdf_submission?: SortOrder
    pdf_promotion_backlinks?: SortOrder
    quora_Q_A?: SortOrder
    profile_creation?: SortOrder
    blog_commenting_niche_edu?: SortOrder
    forum_submission?: SortOrder
    google_my_business_setup_verification?: SortOrder
    local_citation_submissions?: SortOrder
    google_places_photo_multimedia_additions?: SortOrder
    customer_reviews_ratings?: SortOrder
    local_classified_ads?: SortOrder
    monthly_keyword_improvement_report?: SortOrder
    monthly_back_links_report?: SortOrder
    monthly_google_analytic_static_report?: SortOrder
    email?: SortOrder
    telephone_whatsapp_telegram?: SortOrder
    internet_messenger_skype?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
    status?: SortOrder
  }

  export type package_featuresMinOrderByAggregateInput = {
    id?: SortOrder
    subscription_id?: SortOrder
    website_analysis?: SortOrder
    content_duplicacy?: SortOrder
    initial_backlinks?: SortOrder
    critical_seo_analysis?: SortOrder
    google_penalty_check?: SortOrder
    competition_analysis?: SortOrder
    competitor_backlinks_opportunity?: SortOrder
    keyword_research_analysis?: SortOrder
    on_page_optimization?: SortOrder
    title_tags_optimization?: SortOrder
    meta_tags_optimization?: SortOrder
    content_optimization?: SortOrder
    html_code_optimization?: SortOrder
    website_permalinks_analysis?: SortOrder
    seo_friendly_urls?: SortOrder
    schema_markup_analysis?: SortOrder
    internal_linking_optimization?: SortOrder
    crawl_error_resolution?: SortOrder
    heading_tags_optimization?: SortOrder
    canonicalization_301_redirect?: SortOrder
    custom_404_errors?: SortOrder
    images_optimization?: SortOrder
    hyperlink_optimization?: SortOrder
    robots_txt_creation_optimization?: SortOrder
    sitemap_creation?: SortOrder
    google_webmaster_tools_setup?: SortOrder
    bing_Webmaster_tools_setup?: SortOrder
    google_analytics_setup_Integration?: SortOrder
    website_responsive_check?: SortOrder
    page_speed_analysis?: SortOrder
    mobile_responsive_compatibility_check?: SortOrder
    navigation_ux_factors?: SortOrder
    ssl_certificate?: SortOrder
    web_2_0_400_600_words_blog_Writing?: SortOrder
    article_writing?: SortOrder
    classified_writing?: SortOrder
    press_release_writing?: SortOrder
    ppt_pdf_creation_writing?: SortOrder
    web_2_0_400_600_words_submission?: SortOrder
    web_2_0_blog_promotion?: SortOrder
    article_submission?: SortOrder
    article_promotion?: SortOrder
    guest_blogging?: SortOrder
    custom_graphics_to_support_your_blogs?: SortOrder
    social_bookmarking_links?: SortOrder
    press_release_submission?: SortOrder
    local_citation?: SortOrder
    classified_submissions?: SortOrder
    ppt_submission?: SortOrder
    ppt_promotion_backlinks?: SortOrder
    pdf_submission?: SortOrder
    pdf_promotion_backlinks?: SortOrder
    quora_Q_A?: SortOrder
    profile_creation?: SortOrder
    blog_commenting_niche_edu?: SortOrder
    forum_submission?: SortOrder
    google_my_business_setup_verification?: SortOrder
    local_citation_submissions?: SortOrder
    google_places_photo_multimedia_additions?: SortOrder
    customer_reviews_ratings?: SortOrder
    local_classified_ads?: SortOrder
    monthly_keyword_improvement_report?: SortOrder
    monthly_back_links_report?: SortOrder
    monthly_google_analytic_static_report?: SortOrder
    email?: SortOrder
    telephone_whatsapp_telegram?: SortOrder
    internet_messenger_skype?: SortOrder
    created_at?: SortOrder
    updated_at?: SortOrder
    deleted_at?: SortOrder
    status?: SortOrder
  }

  export type package_featuresSumOrderByAggregateInput = {
    id?: SortOrder
    subscription_id?: SortOrder
    competition_analysis?: SortOrder
    competitor_backlinks_opportunity?: SortOrder
    web_2_0_400_600_words_blog_Writing?: SortOrder
    article_writing?: SortOrder
    classified_writing?: SortOrder
    press_release_writing?: SortOrder
    ppt_pdf_creation_writing?: SortOrder
    web_2_0_400_600_words_submission?: SortOrder
    web_2_0_blog_promotion?: SortOrder
    article_submission?: SortOrder
    article_promotion?: SortOrder
    guest_blogging?: SortOrder
    social_bookmarking_links?: SortOrder
    press_release_submission?: SortOrder
    local_citation?: SortOrder
    classified_submissions?: SortOrder
    ppt_submission?: SortOrder
    ppt_promotion_backlinks?: SortOrder
    pdf_submission?: SortOrder
    pdf_promotion_backlinks?: SortOrder
    quora_Q_A?: SortOrder
    profile_creation?: SortOrder
    blog_commenting_niche_edu?: SortOrder
    forum_submission?: SortOrder
    local_citation_submissions?: SortOrder
    customer_reviews_ratings?: SortOrder
    local_classified_ads?: SortOrder
    status?: SortOrder
  }

  export type BoolWithAggregatesFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel>
    not?: NestedBoolWithAggregatesFilter<$PrismaModel> | boolean
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedBoolFilter<$PrismaModel>
    _max?: NestedBoolFilter<$PrismaModel>
  }

  export type BacklinkCreateNestedManyWithoutProjectLinksInput = {
    create?: XOR<BacklinkCreateWithoutProjectLinksInput, BacklinkUncheckedCreateWithoutProjectLinksInput> | BacklinkCreateWithoutProjectLinksInput[] | BacklinkUncheckedCreateWithoutProjectLinksInput[]
    connectOrCreate?: BacklinkCreateOrConnectWithoutProjectLinksInput | BacklinkCreateOrConnectWithoutProjectLinksInput[]
    createMany?: BacklinkCreateManyProjectLinksInputEnvelope
    connect?: BacklinkWhereUniqueInput | BacklinkWhereUniqueInput[]
  }

  export type BacklinkUncheckedCreateNestedManyWithoutProjectLinksInput = {
    create?: XOR<BacklinkCreateWithoutProjectLinksInput, BacklinkUncheckedCreateWithoutProjectLinksInput> | BacklinkCreateWithoutProjectLinksInput[] | BacklinkUncheckedCreateWithoutProjectLinksInput[]
    connectOrCreate?: BacklinkCreateOrConnectWithoutProjectLinksInput | BacklinkCreateOrConnectWithoutProjectLinksInput[]
    createMany?: BacklinkCreateManyProjectLinksInputEnvelope
    connect?: BacklinkWhereUniqueInput | BacklinkWhereUniqueInput[]
  }

  export type StringFieldUpdateOperationsInput = {
    set?: string
  }

  export type IntFieldUpdateOperationsInput = {
    set?: number
    increment?: number
    decrement?: number
    multiply?: number
    divide?: number
  }

  export type DateTimeFieldUpdateOperationsInput = {
    set?: Date | string
  }

  export type NullableDateTimeFieldUpdateOperationsInput = {
    set?: Date | string | null
  }

  export type BacklinkUpdateManyWithoutProjectLinksNestedInput = {
    create?: XOR<BacklinkCreateWithoutProjectLinksInput, BacklinkUncheckedCreateWithoutProjectLinksInput> | BacklinkCreateWithoutProjectLinksInput[] | BacklinkUncheckedCreateWithoutProjectLinksInput[]
    connectOrCreate?: BacklinkCreateOrConnectWithoutProjectLinksInput | BacklinkCreateOrConnectWithoutProjectLinksInput[]
    upsert?: BacklinkUpsertWithWhereUniqueWithoutProjectLinksInput | BacklinkUpsertWithWhereUniqueWithoutProjectLinksInput[]
    createMany?: BacklinkCreateManyProjectLinksInputEnvelope
    set?: BacklinkWhereUniqueInput | BacklinkWhereUniqueInput[]
    disconnect?: BacklinkWhereUniqueInput | BacklinkWhereUniqueInput[]
    delete?: BacklinkWhereUniqueInput | BacklinkWhereUniqueInput[]
    connect?: BacklinkWhereUniqueInput | BacklinkWhereUniqueInput[]
    update?: BacklinkUpdateWithWhereUniqueWithoutProjectLinksInput | BacklinkUpdateWithWhereUniqueWithoutProjectLinksInput[]
    updateMany?: BacklinkUpdateManyWithWhereWithoutProjectLinksInput | BacklinkUpdateManyWithWhereWithoutProjectLinksInput[]
    deleteMany?: BacklinkScalarWhereInput | BacklinkScalarWhereInput[]
  }

  export type BacklinkUncheckedUpdateManyWithoutProjectLinksNestedInput = {
    create?: XOR<BacklinkCreateWithoutProjectLinksInput, BacklinkUncheckedCreateWithoutProjectLinksInput> | BacklinkCreateWithoutProjectLinksInput[] | BacklinkUncheckedCreateWithoutProjectLinksInput[]
    connectOrCreate?: BacklinkCreateOrConnectWithoutProjectLinksInput | BacklinkCreateOrConnectWithoutProjectLinksInput[]
    upsert?: BacklinkUpsertWithWhereUniqueWithoutProjectLinksInput | BacklinkUpsertWithWhereUniqueWithoutProjectLinksInput[]
    createMany?: BacklinkCreateManyProjectLinksInputEnvelope
    set?: BacklinkWhereUniqueInput | BacklinkWhereUniqueInput[]
    disconnect?: BacklinkWhereUniqueInput | BacklinkWhereUniqueInput[]
    delete?: BacklinkWhereUniqueInput | BacklinkWhereUniqueInput[]
    connect?: BacklinkWhereUniqueInput | BacklinkWhereUniqueInput[]
    update?: BacklinkUpdateWithWhereUniqueWithoutProjectLinksInput | BacklinkUpdateWithWhereUniqueWithoutProjectLinksInput[]
    updateMany?: BacklinkUpdateManyWithWhereWithoutProjectLinksInput | BacklinkUpdateManyWithWhereWithoutProjectLinksInput[]
    deleteMany?: BacklinkScalarWhereInput | BacklinkScalarWhereInput[]
  }

  export type ProjectsCreateNestedOneWithoutBacklinkInput = {
    create?: XOR<ProjectsCreateWithoutBacklinkInput, ProjectsUncheckedCreateWithoutBacklinkInput>
    connectOrCreate?: ProjectsCreateOrConnectWithoutBacklinkInput
    connect?: ProjectsWhereUniqueInput
  }

  export type NullableBoolFieldUpdateOperationsInput = {
    set?: boolean | null
  }

  export type NullableStringFieldUpdateOperationsInput = {
    set?: string | null
  }

  export type NullableIntFieldUpdateOperationsInput = {
    set?: number | null
    increment?: number
    decrement?: number
    multiply?: number
    divide?: number
  }

  export type ProjectsUpdateOneRequiredWithoutBacklinkNestedInput = {
    create?: XOR<ProjectsCreateWithoutBacklinkInput, ProjectsUncheckedCreateWithoutBacklinkInput>
    connectOrCreate?: ProjectsCreateOrConnectWithoutBacklinkInput
    upsert?: ProjectsUpsertWithoutBacklinkInput
    connect?: ProjectsWhereUniqueInput
    update?: XOR<XOR<ProjectsUpdateToOneWithWhereWithoutBacklinkInput, ProjectsUpdateWithoutBacklinkInput>, ProjectsUncheckedUpdateWithoutBacklinkInput>
  }

  export type user_permissionsCreateNestedManyWithoutUserPermissionInput = {
    create?: XOR<user_permissionsCreateWithoutUserPermissionInput, user_permissionsUncheckedCreateWithoutUserPermissionInput> | user_permissionsCreateWithoutUserPermissionInput[] | user_permissionsUncheckedCreateWithoutUserPermissionInput[]
    connectOrCreate?: user_permissionsCreateOrConnectWithoutUserPermissionInput | user_permissionsCreateOrConnectWithoutUserPermissionInput[]
    createMany?: user_permissionsCreateManyUserPermissionInputEnvelope
    connect?: user_permissionsWhereUniqueInput | user_permissionsWhereUniqueInput[]
  }

  export type subscription_featureCreateNestedManyWithoutFeaturesInput = {
    create?: XOR<subscription_featureCreateWithoutFeaturesInput, subscription_featureUncheckedCreateWithoutFeaturesInput> | subscription_featureCreateWithoutFeaturesInput[] | subscription_featureUncheckedCreateWithoutFeaturesInput[]
    connectOrCreate?: subscription_featureCreateOrConnectWithoutFeaturesInput | subscription_featureCreateOrConnectWithoutFeaturesInput[]
    createMany?: subscription_featureCreateManyFeaturesInputEnvelope
    connect?: subscription_featureWhereUniqueInput | subscription_featureWhereUniqueInput[]
  }

  export type user_permissionsUncheckedCreateNestedManyWithoutUserPermissionInput = {
    create?: XOR<user_permissionsCreateWithoutUserPermissionInput, user_permissionsUncheckedCreateWithoutUserPermissionInput> | user_permissionsCreateWithoutUserPermissionInput[] | user_permissionsUncheckedCreateWithoutUserPermissionInput[]
    connectOrCreate?: user_permissionsCreateOrConnectWithoutUserPermissionInput | user_permissionsCreateOrConnectWithoutUserPermissionInput[]
    createMany?: user_permissionsCreateManyUserPermissionInputEnvelope
    connect?: user_permissionsWhereUniqueInput | user_permissionsWhereUniqueInput[]
  }

  export type subscription_featureUncheckedCreateNestedManyWithoutFeaturesInput = {
    create?: XOR<subscription_featureCreateWithoutFeaturesInput, subscription_featureUncheckedCreateWithoutFeaturesInput> | subscription_featureCreateWithoutFeaturesInput[] | subscription_featureUncheckedCreateWithoutFeaturesInput[]
    connectOrCreate?: subscription_featureCreateOrConnectWithoutFeaturesInput | subscription_featureCreateOrConnectWithoutFeaturesInput[]
    createMany?: subscription_featureCreateManyFeaturesInputEnvelope
    connect?: subscription_featureWhereUniqueInput | subscription_featureWhereUniqueInput[]
  }

  export type user_permissionsUpdateManyWithoutUserPermissionNestedInput = {
    create?: XOR<user_permissionsCreateWithoutUserPermissionInput, user_permissionsUncheckedCreateWithoutUserPermissionInput> | user_permissionsCreateWithoutUserPermissionInput[] | user_permissionsUncheckedCreateWithoutUserPermissionInput[]
    connectOrCreate?: user_permissionsCreateOrConnectWithoutUserPermissionInput | user_permissionsCreateOrConnectWithoutUserPermissionInput[]
    upsert?: user_permissionsUpsertWithWhereUniqueWithoutUserPermissionInput | user_permissionsUpsertWithWhereUniqueWithoutUserPermissionInput[]
    createMany?: user_permissionsCreateManyUserPermissionInputEnvelope
    set?: user_permissionsWhereUniqueInput | user_permissionsWhereUniqueInput[]
    disconnect?: user_permissionsWhereUniqueInput | user_permissionsWhereUniqueInput[]
    delete?: user_permissionsWhereUniqueInput | user_permissionsWhereUniqueInput[]
    connect?: user_permissionsWhereUniqueInput | user_permissionsWhereUniqueInput[]
    update?: user_permissionsUpdateWithWhereUniqueWithoutUserPermissionInput | user_permissionsUpdateWithWhereUniqueWithoutUserPermissionInput[]
    updateMany?: user_permissionsUpdateManyWithWhereWithoutUserPermissionInput | user_permissionsUpdateManyWithWhereWithoutUserPermissionInput[]
    deleteMany?: user_permissionsScalarWhereInput | user_permissionsScalarWhereInput[]
  }

  export type subscription_featureUpdateManyWithoutFeaturesNestedInput = {
    create?: XOR<subscription_featureCreateWithoutFeaturesInput, subscription_featureUncheckedCreateWithoutFeaturesInput> | subscription_featureCreateWithoutFeaturesInput[] | subscription_featureUncheckedCreateWithoutFeaturesInput[]
    connectOrCreate?: subscription_featureCreateOrConnectWithoutFeaturesInput | subscription_featureCreateOrConnectWithoutFeaturesInput[]
    upsert?: subscription_featureUpsertWithWhereUniqueWithoutFeaturesInput | subscription_featureUpsertWithWhereUniqueWithoutFeaturesInput[]
    createMany?: subscription_featureCreateManyFeaturesInputEnvelope
    set?: subscription_featureWhereUniqueInput | subscription_featureWhereUniqueInput[]
    disconnect?: subscription_featureWhereUniqueInput | subscription_featureWhereUniqueInput[]
    delete?: subscription_featureWhereUniqueInput | subscription_featureWhereUniqueInput[]
    connect?: subscription_featureWhereUniqueInput | subscription_featureWhereUniqueInput[]
    update?: subscription_featureUpdateWithWhereUniqueWithoutFeaturesInput | subscription_featureUpdateWithWhereUniqueWithoutFeaturesInput[]
    updateMany?: subscription_featureUpdateManyWithWhereWithoutFeaturesInput | subscription_featureUpdateManyWithWhereWithoutFeaturesInput[]
    deleteMany?: subscription_featureScalarWhereInput | subscription_featureScalarWhereInput[]
  }

  export type user_permissionsUncheckedUpdateManyWithoutUserPermissionNestedInput = {
    create?: XOR<user_permissionsCreateWithoutUserPermissionInput, user_permissionsUncheckedCreateWithoutUserPermissionInput> | user_permissionsCreateWithoutUserPermissionInput[] | user_permissionsUncheckedCreateWithoutUserPermissionInput[]
    connectOrCreate?: user_permissionsCreateOrConnectWithoutUserPermissionInput | user_permissionsCreateOrConnectWithoutUserPermissionInput[]
    upsert?: user_permissionsUpsertWithWhereUniqueWithoutUserPermissionInput | user_permissionsUpsertWithWhereUniqueWithoutUserPermissionInput[]
    createMany?: user_permissionsCreateManyUserPermissionInputEnvelope
    set?: user_permissionsWhereUniqueInput | user_permissionsWhereUniqueInput[]
    disconnect?: user_permissionsWhereUniqueInput | user_permissionsWhereUniqueInput[]
    delete?: user_permissionsWhereUniqueInput | user_permissionsWhereUniqueInput[]
    connect?: user_permissionsWhereUniqueInput | user_permissionsWhereUniqueInput[]
    update?: user_permissionsUpdateWithWhereUniqueWithoutUserPermissionInput | user_permissionsUpdateWithWhereUniqueWithoutUserPermissionInput[]
    updateMany?: user_permissionsUpdateManyWithWhereWithoutUserPermissionInput | user_permissionsUpdateManyWithWhereWithoutUserPermissionInput[]
    deleteMany?: user_permissionsScalarWhereInput | user_permissionsScalarWhereInput[]
  }

  export type subscription_featureUncheckedUpdateManyWithoutFeaturesNestedInput = {
    create?: XOR<subscription_featureCreateWithoutFeaturesInput, subscription_featureUncheckedCreateWithoutFeaturesInput> | subscription_featureCreateWithoutFeaturesInput[] | subscription_featureUncheckedCreateWithoutFeaturesInput[]
    connectOrCreate?: subscription_featureCreateOrConnectWithoutFeaturesInput | subscription_featureCreateOrConnectWithoutFeaturesInput[]
    upsert?: subscription_featureUpsertWithWhereUniqueWithoutFeaturesInput | subscription_featureUpsertWithWhereUniqueWithoutFeaturesInput[]
    createMany?: subscription_featureCreateManyFeaturesInputEnvelope
    set?: subscription_featureWhereUniqueInput | subscription_featureWhereUniqueInput[]
    disconnect?: subscription_featureWhereUniqueInput | subscription_featureWhereUniqueInput[]
    delete?: subscription_featureWhereUniqueInput | subscription_featureWhereUniqueInput[]
    connect?: subscription_featureWhereUniqueInput | subscription_featureWhereUniqueInput[]
    update?: subscription_featureUpdateWithWhereUniqueWithoutFeaturesInput | subscription_featureUpdateWithWhereUniqueWithoutFeaturesInput[]
    updateMany?: subscription_featureUpdateManyWithWhereWithoutFeaturesInput | subscription_featureUpdateManyWithWhereWithoutFeaturesInput[]
    deleteMany?: subscription_featureScalarWhereInput | subscription_featureScalarWhereInput[]
  }

  export type user_subscriptionCreateNestedManyWithoutUsersubscriptionsInput = {
    create?: XOR<user_subscriptionCreateWithoutUsersubscriptionsInput, user_subscriptionUncheckedCreateWithoutUsersubscriptionsInput> | user_subscriptionCreateWithoutUsersubscriptionsInput[] | user_subscriptionUncheckedCreateWithoutUsersubscriptionsInput[]
    connectOrCreate?: user_subscriptionCreateOrConnectWithoutUsersubscriptionsInput | user_subscriptionCreateOrConnectWithoutUsersubscriptionsInput[]
    createMany?: user_subscriptionCreateManyUsersubscriptionsInputEnvelope
    connect?: user_subscriptionWhereUniqueInput | user_subscriptionWhereUniqueInput[]
  }

  export type subscription_featureCreateNestedManyWithoutSubscricption_packageInput = {
    create?: XOR<subscription_featureCreateWithoutSubscricption_packageInput, subscription_featureUncheckedCreateWithoutSubscricption_packageInput> | subscription_featureCreateWithoutSubscricption_packageInput[] | subscription_featureUncheckedCreateWithoutSubscricption_packageInput[]
    connectOrCreate?: subscription_featureCreateOrConnectWithoutSubscricption_packageInput | subscription_featureCreateOrConnectWithoutSubscricption_packageInput[]
    createMany?: subscription_featureCreateManySubscricption_packageInputEnvelope
    connect?: subscription_featureWhereUniqueInput | subscription_featureWhereUniqueInput[]
  }

  export type package_featuresCreateNestedManyWithoutFeaturesInput = {
    create?: XOR<package_featuresCreateWithoutFeaturesInput, package_featuresUncheckedCreateWithoutFeaturesInput> | package_featuresCreateWithoutFeaturesInput[] | package_featuresUncheckedCreateWithoutFeaturesInput[]
    connectOrCreate?: package_featuresCreateOrConnectWithoutFeaturesInput | package_featuresCreateOrConnectWithoutFeaturesInput[]
    createMany?: package_featuresCreateManyFeaturesInputEnvelope
    connect?: package_featuresWhereUniqueInput | package_featuresWhereUniqueInput[]
  }

  export type user_subscriptionUncheckedCreateNestedManyWithoutUsersubscriptionsInput = {
    create?: XOR<user_subscriptionCreateWithoutUsersubscriptionsInput, user_subscriptionUncheckedCreateWithoutUsersubscriptionsInput> | user_subscriptionCreateWithoutUsersubscriptionsInput[] | user_subscriptionUncheckedCreateWithoutUsersubscriptionsInput[]
    connectOrCreate?: user_subscriptionCreateOrConnectWithoutUsersubscriptionsInput | user_subscriptionCreateOrConnectWithoutUsersubscriptionsInput[]
    createMany?: user_subscriptionCreateManyUsersubscriptionsInputEnvelope
    connect?: user_subscriptionWhereUniqueInput | user_subscriptionWhereUniqueInput[]
  }

  export type subscription_featureUncheckedCreateNestedManyWithoutSubscricption_packageInput = {
    create?: XOR<subscription_featureCreateWithoutSubscricption_packageInput, subscription_featureUncheckedCreateWithoutSubscricption_packageInput> | subscription_featureCreateWithoutSubscricption_packageInput[] | subscription_featureUncheckedCreateWithoutSubscricption_packageInput[]
    connectOrCreate?: subscription_featureCreateOrConnectWithoutSubscricption_packageInput | subscription_featureCreateOrConnectWithoutSubscricption_packageInput[]
    createMany?: subscription_featureCreateManySubscricption_packageInputEnvelope
    connect?: subscription_featureWhereUniqueInput | subscription_featureWhereUniqueInput[]
  }

  export type package_featuresUncheckedCreateNestedManyWithoutFeaturesInput = {
    create?: XOR<package_featuresCreateWithoutFeaturesInput, package_featuresUncheckedCreateWithoutFeaturesInput> | package_featuresCreateWithoutFeaturesInput[] | package_featuresUncheckedCreateWithoutFeaturesInput[]
    connectOrCreate?: package_featuresCreateOrConnectWithoutFeaturesInput | package_featuresCreateOrConnectWithoutFeaturesInput[]
    createMany?: package_featuresCreateManyFeaturesInputEnvelope
    connect?: package_featuresWhereUniqueInput | package_featuresWhereUniqueInput[]
  }

  export type user_subscriptionUpdateManyWithoutUsersubscriptionsNestedInput = {
    create?: XOR<user_subscriptionCreateWithoutUsersubscriptionsInput, user_subscriptionUncheckedCreateWithoutUsersubscriptionsInput> | user_subscriptionCreateWithoutUsersubscriptionsInput[] | user_subscriptionUncheckedCreateWithoutUsersubscriptionsInput[]
    connectOrCreate?: user_subscriptionCreateOrConnectWithoutUsersubscriptionsInput | user_subscriptionCreateOrConnectWithoutUsersubscriptionsInput[]
    upsert?: user_subscriptionUpsertWithWhereUniqueWithoutUsersubscriptionsInput | user_subscriptionUpsertWithWhereUniqueWithoutUsersubscriptionsInput[]
    createMany?: user_subscriptionCreateManyUsersubscriptionsInputEnvelope
    set?: user_subscriptionWhereUniqueInput | user_subscriptionWhereUniqueInput[]
    disconnect?: user_subscriptionWhereUniqueInput | user_subscriptionWhereUniqueInput[]
    delete?: user_subscriptionWhereUniqueInput | user_subscriptionWhereUniqueInput[]
    connect?: user_subscriptionWhereUniqueInput | user_subscriptionWhereUniqueInput[]
    update?: user_subscriptionUpdateWithWhereUniqueWithoutUsersubscriptionsInput | user_subscriptionUpdateWithWhereUniqueWithoutUsersubscriptionsInput[]
    updateMany?: user_subscriptionUpdateManyWithWhereWithoutUsersubscriptionsInput | user_subscriptionUpdateManyWithWhereWithoutUsersubscriptionsInput[]
    deleteMany?: user_subscriptionScalarWhereInput | user_subscriptionScalarWhereInput[]
  }

  export type subscription_featureUpdateManyWithoutSubscricption_packageNestedInput = {
    create?: XOR<subscription_featureCreateWithoutSubscricption_packageInput, subscription_featureUncheckedCreateWithoutSubscricption_packageInput> | subscription_featureCreateWithoutSubscricption_packageInput[] | subscription_featureUncheckedCreateWithoutSubscricption_packageInput[]
    connectOrCreate?: subscription_featureCreateOrConnectWithoutSubscricption_packageInput | subscription_featureCreateOrConnectWithoutSubscricption_packageInput[]
    upsert?: subscription_featureUpsertWithWhereUniqueWithoutSubscricption_packageInput | subscription_featureUpsertWithWhereUniqueWithoutSubscricption_packageInput[]
    createMany?: subscription_featureCreateManySubscricption_packageInputEnvelope
    set?: subscription_featureWhereUniqueInput | subscription_featureWhereUniqueInput[]
    disconnect?: subscription_featureWhereUniqueInput | subscription_featureWhereUniqueInput[]
    delete?: subscription_featureWhereUniqueInput | subscription_featureWhereUniqueInput[]
    connect?: subscription_featureWhereUniqueInput | subscription_featureWhereUniqueInput[]
    update?: subscription_featureUpdateWithWhereUniqueWithoutSubscricption_packageInput | subscription_featureUpdateWithWhereUniqueWithoutSubscricption_packageInput[]
    updateMany?: subscription_featureUpdateManyWithWhereWithoutSubscricption_packageInput | subscription_featureUpdateManyWithWhereWithoutSubscricption_packageInput[]
    deleteMany?: subscription_featureScalarWhereInput | subscription_featureScalarWhereInput[]
  }

  export type package_featuresUpdateManyWithoutFeaturesNestedInput = {
    create?: XOR<package_featuresCreateWithoutFeaturesInput, package_featuresUncheckedCreateWithoutFeaturesInput> | package_featuresCreateWithoutFeaturesInput[] | package_featuresUncheckedCreateWithoutFeaturesInput[]
    connectOrCreate?: package_featuresCreateOrConnectWithoutFeaturesInput | package_featuresCreateOrConnectWithoutFeaturesInput[]
    upsert?: package_featuresUpsertWithWhereUniqueWithoutFeaturesInput | package_featuresUpsertWithWhereUniqueWithoutFeaturesInput[]
    createMany?: package_featuresCreateManyFeaturesInputEnvelope
    set?: package_featuresWhereUniqueInput | package_featuresWhereUniqueInput[]
    disconnect?: package_featuresWhereUniqueInput | package_featuresWhereUniqueInput[]
    delete?: package_featuresWhereUniqueInput | package_featuresWhereUniqueInput[]
    connect?: package_featuresWhereUniqueInput | package_featuresWhereUniqueInput[]
    update?: package_featuresUpdateWithWhereUniqueWithoutFeaturesInput | package_featuresUpdateWithWhereUniqueWithoutFeaturesInput[]
    updateMany?: package_featuresUpdateManyWithWhereWithoutFeaturesInput | package_featuresUpdateManyWithWhereWithoutFeaturesInput[]
    deleteMany?: package_featuresScalarWhereInput | package_featuresScalarWhereInput[]
  }

  export type user_subscriptionUncheckedUpdateManyWithoutUsersubscriptionsNestedInput = {
    create?: XOR<user_subscriptionCreateWithoutUsersubscriptionsInput, user_subscriptionUncheckedCreateWithoutUsersubscriptionsInput> | user_subscriptionCreateWithoutUsersubscriptionsInput[] | user_subscriptionUncheckedCreateWithoutUsersubscriptionsInput[]
    connectOrCreate?: user_subscriptionCreateOrConnectWithoutUsersubscriptionsInput | user_subscriptionCreateOrConnectWithoutUsersubscriptionsInput[]
    upsert?: user_subscriptionUpsertWithWhereUniqueWithoutUsersubscriptionsInput | user_subscriptionUpsertWithWhereUniqueWithoutUsersubscriptionsInput[]
    createMany?: user_subscriptionCreateManyUsersubscriptionsInputEnvelope
    set?: user_subscriptionWhereUniqueInput | user_subscriptionWhereUniqueInput[]
    disconnect?: user_subscriptionWhereUniqueInput | user_subscriptionWhereUniqueInput[]
    delete?: user_subscriptionWhereUniqueInput | user_subscriptionWhereUniqueInput[]
    connect?: user_subscriptionWhereUniqueInput | user_subscriptionWhereUniqueInput[]
    update?: user_subscriptionUpdateWithWhereUniqueWithoutUsersubscriptionsInput | user_subscriptionUpdateWithWhereUniqueWithoutUsersubscriptionsInput[]
    updateMany?: user_subscriptionUpdateManyWithWhereWithoutUsersubscriptionsInput | user_subscriptionUpdateManyWithWhereWithoutUsersubscriptionsInput[]
    deleteMany?: user_subscriptionScalarWhereInput | user_subscriptionScalarWhereInput[]
  }

  export type subscription_featureUncheckedUpdateManyWithoutSubscricption_packageNestedInput = {
    create?: XOR<subscription_featureCreateWithoutSubscricption_packageInput, subscription_featureUncheckedCreateWithoutSubscricption_packageInput> | subscription_featureCreateWithoutSubscricption_packageInput[] | subscription_featureUncheckedCreateWithoutSubscricption_packageInput[]
    connectOrCreate?: subscription_featureCreateOrConnectWithoutSubscricption_packageInput | subscription_featureCreateOrConnectWithoutSubscricption_packageInput[]
    upsert?: subscription_featureUpsertWithWhereUniqueWithoutSubscricption_packageInput | subscription_featureUpsertWithWhereUniqueWithoutSubscricption_packageInput[]
    createMany?: subscription_featureCreateManySubscricption_packageInputEnvelope
    set?: subscription_featureWhereUniqueInput | subscription_featureWhereUniqueInput[]
    disconnect?: subscription_featureWhereUniqueInput | subscription_featureWhereUniqueInput[]
    delete?: subscription_featureWhereUniqueInput | subscription_featureWhereUniqueInput[]
    connect?: subscription_featureWhereUniqueInput | subscription_featureWhereUniqueInput[]
    update?: subscription_featureUpdateWithWhereUniqueWithoutSubscricption_packageInput | subscription_featureUpdateWithWhereUniqueWithoutSubscricption_packageInput[]
    updateMany?: subscription_featureUpdateManyWithWhereWithoutSubscricption_packageInput | subscription_featureUpdateManyWithWhereWithoutSubscricption_packageInput[]
    deleteMany?: subscription_featureScalarWhereInput | subscription_featureScalarWhereInput[]
  }

  export type package_featuresUncheckedUpdateManyWithoutFeaturesNestedInput = {
    create?: XOR<package_featuresCreateWithoutFeaturesInput, package_featuresUncheckedCreateWithoutFeaturesInput> | package_featuresCreateWithoutFeaturesInput[] | package_featuresUncheckedCreateWithoutFeaturesInput[]
    connectOrCreate?: package_featuresCreateOrConnectWithoutFeaturesInput | package_featuresCreateOrConnectWithoutFeaturesInput[]
    upsert?: package_featuresUpsertWithWhereUniqueWithoutFeaturesInput | package_featuresUpsertWithWhereUniqueWithoutFeaturesInput[]
    createMany?: package_featuresCreateManyFeaturesInputEnvelope
    set?: package_featuresWhereUniqueInput | package_featuresWhereUniqueInput[]
    disconnect?: package_featuresWhereUniqueInput | package_featuresWhereUniqueInput[]
    delete?: package_featuresWhereUniqueInput | package_featuresWhereUniqueInput[]
    connect?: package_featuresWhereUniqueInput | package_featuresWhereUniqueInput[]
    update?: package_featuresUpdateWithWhereUniqueWithoutFeaturesInput | package_featuresUpdateWithWhereUniqueWithoutFeaturesInput[]
    updateMany?: package_featuresUpdateManyWithWhereWithoutFeaturesInput | package_featuresUpdateManyWithWhereWithoutFeaturesInput[]
    deleteMany?: package_featuresScalarWhereInput | package_featuresScalarWhereInput[]
  }

  export type subscriptionCreateNestedOneWithoutSubscription_featureInput = {
    create?: XOR<subscriptionCreateWithoutSubscription_featureInput, subscriptionUncheckedCreateWithoutSubscription_featureInput>
    connectOrCreate?: subscriptionCreateOrConnectWithoutSubscription_featureInput
    connect?: subscriptionWhereUniqueInput
  }

  export type permissions_listCreateNestedOneWithoutSubscription_featureInput = {
    create?: XOR<permissions_listCreateWithoutSubscription_featureInput, permissions_listUncheckedCreateWithoutSubscription_featureInput>
    connectOrCreate?: permissions_listCreateOrConnectWithoutSubscription_featureInput
    connect?: permissions_listWhereUniqueInput
  }

  export type subscriptionUpdateOneRequiredWithoutSubscription_featureNestedInput = {
    create?: XOR<subscriptionCreateWithoutSubscription_featureInput, subscriptionUncheckedCreateWithoutSubscription_featureInput>
    connectOrCreate?: subscriptionCreateOrConnectWithoutSubscription_featureInput
    upsert?: subscriptionUpsertWithoutSubscription_featureInput
    connect?: subscriptionWhereUniqueInput
    update?: XOR<XOR<subscriptionUpdateToOneWithWhereWithoutSubscription_featureInput, subscriptionUpdateWithoutSubscription_featureInput>, subscriptionUncheckedUpdateWithoutSubscription_featureInput>
  }

  export type permissions_listUpdateOneRequiredWithoutSubscription_featureNestedInput = {
    create?: XOR<permissions_listCreateWithoutSubscription_featureInput, permissions_listUncheckedCreateWithoutSubscription_featureInput>
    connectOrCreate?: permissions_listCreateOrConnectWithoutSubscription_featureInput
    upsert?: permissions_listUpsertWithoutSubscription_featureInput
    connect?: permissions_listWhereUniqueInput
    update?: XOR<XOR<permissions_listUpdateToOneWithWhereWithoutSubscription_featureInput, permissions_listUpdateWithoutSubscription_featureInput>, permissions_listUncheckedUpdateWithoutSubscription_featureInput>
  }

  export type subscriptionCreateNestedOneWithoutUser_subscriptionInput = {
    create?: XOR<subscriptionCreateWithoutUser_subscriptionInput, subscriptionUncheckedCreateWithoutUser_subscriptionInput>
    connectOrCreate?: subscriptionCreateOrConnectWithoutUser_subscriptionInput
    connect?: subscriptionWhereUniqueInput
  }

  export type subscriptionUpdateOneRequiredWithoutUser_subscriptionNestedInput = {
    create?: XOR<subscriptionCreateWithoutUser_subscriptionInput, subscriptionUncheckedCreateWithoutUser_subscriptionInput>
    connectOrCreate?: subscriptionCreateOrConnectWithoutUser_subscriptionInput
    upsert?: subscriptionUpsertWithoutUser_subscriptionInput
    connect?: subscriptionWhereUniqueInput
    update?: XOR<XOR<subscriptionUpdateToOneWithWhereWithoutUser_subscriptionInput, subscriptionUpdateWithoutUser_subscriptionInput>, subscriptionUncheckedUpdateWithoutUser_subscriptionInput>
  }

  export type permissions_listCreateNestedOneWithoutUser_permissionsInput = {
    create?: XOR<permissions_listCreateWithoutUser_permissionsInput, permissions_listUncheckedCreateWithoutUser_permissionsInput>
    connectOrCreate?: permissions_listCreateOrConnectWithoutUser_permissionsInput
    connect?: permissions_listWhereUniqueInput
  }

  export type permissions_listUpdateOneRequiredWithoutUser_permissionsNestedInput = {
    create?: XOR<permissions_listCreateWithoutUser_permissionsInput, permissions_listUncheckedCreateWithoutUser_permissionsInput>
    connectOrCreate?: permissions_listCreateOrConnectWithoutUser_permissionsInput
    upsert?: permissions_listUpsertWithoutUser_permissionsInput
    connect?: permissions_listWhereUniqueInput
    update?: XOR<XOR<permissions_listUpdateToOneWithWhereWithoutUser_permissionsInput, permissions_listUpdateWithoutUser_permissionsInput>, permissions_listUncheckedUpdateWithoutUser_permissionsInput>
  }

  export type subscriptionCreateNestedOneWithoutPackage_featuresInput = {
    create?: XOR<subscriptionCreateWithoutPackage_featuresInput, subscriptionUncheckedCreateWithoutPackage_featuresInput>
    connectOrCreate?: subscriptionCreateOrConnectWithoutPackage_featuresInput
    connect?: subscriptionWhereUniqueInput
  }

  export type BoolFieldUpdateOperationsInput = {
    set?: boolean
  }

  export type subscriptionUpdateOneRequiredWithoutPackage_featuresNestedInput = {
    create?: XOR<subscriptionCreateWithoutPackage_featuresInput, subscriptionUncheckedCreateWithoutPackage_featuresInput>
    connectOrCreate?: subscriptionCreateOrConnectWithoutPackage_featuresInput
    upsert?: subscriptionUpsertWithoutPackage_featuresInput
    connect?: subscriptionWhereUniqueInput
    update?: XOR<XOR<subscriptionUpdateToOneWithWhereWithoutPackage_featuresInput, subscriptionUpdateWithoutPackage_featuresInput>, subscriptionUncheckedUpdateWithoutPackage_featuresInput>
  }

  export type NestedIntFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[] | ListIntFieldRefInput<$PrismaModel>
    notIn?: number[] | ListIntFieldRefInput<$PrismaModel>
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntFilter<$PrismaModel> | number
  }

  export type NestedStringFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[] | ListStringFieldRefInput<$PrismaModel>
    notIn?: string[] | ListStringFieldRefInput<$PrismaModel>
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    not?: NestedStringFilter<$PrismaModel> | string
  }

  export type NestedDateTimeFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeFilter<$PrismaModel> | Date | string
  }

  export type NestedDateTimeNullableFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel> | null
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeNullableFilter<$PrismaModel> | Date | string | null
  }

  export type NestedIntWithAggregatesFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel>
    in?: number[] | ListIntFieldRefInput<$PrismaModel>
    notIn?: number[] | ListIntFieldRefInput<$PrismaModel>
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntWithAggregatesFilter<$PrismaModel> | number
    _count?: NestedIntFilter<$PrismaModel>
    _avg?: NestedFloatFilter<$PrismaModel>
    _sum?: NestedIntFilter<$PrismaModel>
    _min?: NestedIntFilter<$PrismaModel>
    _max?: NestedIntFilter<$PrismaModel>
  }

  export type NestedFloatFilter<$PrismaModel = never> = {
    equals?: number | FloatFieldRefInput<$PrismaModel>
    in?: number[] | ListFloatFieldRefInput<$PrismaModel>
    notIn?: number[] | ListFloatFieldRefInput<$PrismaModel>
    lt?: number | FloatFieldRefInput<$PrismaModel>
    lte?: number | FloatFieldRefInput<$PrismaModel>
    gt?: number | FloatFieldRefInput<$PrismaModel>
    gte?: number | FloatFieldRefInput<$PrismaModel>
    not?: NestedFloatFilter<$PrismaModel> | number
  }

  export type NestedStringWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel>
    in?: string[] | ListStringFieldRefInput<$PrismaModel>
    notIn?: string[] | ListStringFieldRefInput<$PrismaModel>
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    not?: NestedStringWithAggregatesFilter<$PrismaModel> | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedStringFilter<$PrismaModel>
    _max?: NestedStringFilter<$PrismaModel>
  }

  export type NestedDateTimeWithAggregatesFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel>
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeWithAggregatesFilter<$PrismaModel> | Date | string
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedDateTimeFilter<$PrismaModel>
    _max?: NestedDateTimeFilter<$PrismaModel>
  }

  export type NestedDateTimeNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: Date | string | DateTimeFieldRefInput<$PrismaModel> | null
    in?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    notIn?: Date[] | string[] | ListDateTimeFieldRefInput<$PrismaModel> | null
    lt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    lte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gt?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    gte?: Date | string | DateTimeFieldRefInput<$PrismaModel>
    not?: NestedDateTimeNullableWithAggregatesFilter<$PrismaModel> | Date | string | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedDateTimeNullableFilter<$PrismaModel>
    _max?: NestedDateTimeNullableFilter<$PrismaModel>
  }

  export type NestedIntNullableFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel> | null
    in?: number[] | ListIntFieldRefInput<$PrismaModel> | null
    notIn?: number[] | ListIntFieldRefInput<$PrismaModel> | null
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntNullableFilter<$PrismaModel> | number | null
  }

  export type NestedBoolNullableFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel> | null
    not?: NestedBoolNullableFilter<$PrismaModel> | boolean | null
  }

  export type NestedStringNullableFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | ListStringFieldRefInput<$PrismaModel> | null
    notIn?: string[] | ListStringFieldRefInput<$PrismaModel> | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    not?: NestedStringNullableFilter<$PrismaModel> | string | null
  }

  export type NestedBoolNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel> | null
    not?: NestedBoolNullableWithAggregatesFilter<$PrismaModel> | boolean | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedBoolNullableFilter<$PrismaModel>
    _max?: NestedBoolNullableFilter<$PrismaModel>
  }

  export type NestedStringNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: string | StringFieldRefInput<$PrismaModel> | null
    in?: string[] | ListStringFieldRefInput<$PrismaModel> | null
    notIn?: string[] | ListStringFieldRefInput<$PrismaModel> | null
    lt?: string | StringFieldRefInput<$PrismaModel>
    lte?: string | StringFieldRefInput<$PrismaModel>
    gt?: string | StringFieldRefInput<$PrismaModel>
    gte?: string | StringFieldRefInput<$PrismaModel>
    contains?: string | StringFieldRefInput<$PrismaModel>
    startsWith?: string | StringFieldRefInput<$PrismaModel>
    endsWith?: string | StringFieldRefInput<$PrismaModel>
    not?: NestedStringNullableWithAggregatesFilter<$PrismaModel> | string | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedStringNullableFilter<$PrismaModel>
    _max?: NestedStringNullableFilter<$PrismaModel>
  }

  export type NestedIntNullableWithAggregatesFilter<$PrismaModel = never> = {
    equals?: number | IntFieldRefInput<$PrismaModel> | null
    in?: number[] | ListIntFieldRefInput<$PrismaModel> | null
    notIn?: number[] | ListIntFieldRefInput<$PrismaModel> | null
    lt?: number | IntFieldRefInput<$PrismaModel>
    lte?: number | IntFieldRefInput<$PrismaModel>
    gt?: number | IntFieldRefInput<$PrismaModel>
    gte?: number | IntFieldRefInput<$PrismaModel>
    not?: NestedIntNullableWithAggregatesFilter<$PrismaModel> | number | null
    _count?: NestedIntNullableFilter<$PrismaModel>
    _avg?: NestedFloatNullableFilter<$PrismaModel>
    _sum?: NestedIntNullableFilter<$PrismaModel>
    _min?: NestedIntNullableFilter<$PrismaModel>
    _max?: NestedIntNullableFilter<$PrismaModel>
  }

  export type NestedFloatNullableFilter<$PrismaModel = never> = {
    equals?: number | FloatFieldRefInput<$PrismaModel> | null
    in?: number[] | ListFloatFieldRefInput<$PrismaModel> | null
    notIn?: number[] | ListFloatFieldRefInput<$PrismaModel> | null
    lt?: number | FloatFieldRefInput<$PrismaModel>
    lte?: number | FloatFieldRefInput<$PrismaModel>
    gt?: number | FloatFieldRefInput<$PrismaModel>
    gte?: number | FloatFieldRefInput<$PrismaModel>
    not?: NestedFloatNullableFilter<$PrismaModel> | number | null
  }

  export type NestedBoolFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel>
    not?: NestedBoolFilter<$PrismaModel> | boolean
  }

  export type NestedBoolWithAggregatesFilter<$PrismaModel = never> = {
    equals?: boolean | BooleanFieldRefInput<$PrismaModel>
    not?: NestedBoolWithAggregatesFilter<$PrismaModel> | boolean
    _count?: NestedIntFilter<$PrismaModel>
    _min?: NestedBoolFilter<$PrismaModel>
    _max?: NestedBoolFilter<$PrismaModel>
  }

  export type BacklinkCreateWithoutProjectLinksInput = {
    link_url: string
    link_status: number
    is_index?: boolean | null
    link_rel?: string | null
    anchor_text?: string | null
    targeted_url?: string | null
    uploaded_by_id?: number | null
    first_seen?: Date | string | null
    last_seen?: Date | string | null
    added_date?: Date | string | null
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    backlink_duplicate?: boolean | null
    referring_domain?: boolean | null
    managed_by?: number | null
  }

  export type BacklinkUncheckedCreateWithoutProjectLinksInput = {
    id?: number
    link_url: string
    link_status: number
    is_index?: boolean | null
    link_rel?: string | null
    anchor_text?: string | null
    targeted_url?: string | null
    uploaded_by_id?: number | null
    first_seen?: Date | string | null
    last_seen?: Date | string | null
    added_date?: Date | string | null
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    backlink_duplicate?: boolean | null
    referring_domain?: boolean | null
    managed_by?: number | null
  }

  export type BacklinkCreateOrConnectWithoutProjectLinksInput = {
    where: BacklinkWhereUniqueInput
    create: XOR<BacklinkCreateWithoutProjectLinksInput, BacklinkUncheckedCreateWithoutProjectLinksInput>
  }

  export type BacklinkCreateManyProjectLinksInputEnvelope = {
    data: BacklinkCreateManyProjectLinksInput | BacklinkCreateManyProjectLinksInput[]
    skipDuplicates?: boolean
  }

  export type BacklinkUpsertWithWhereUniqueWithoutProjectLinksInput = {
    where: BacklinkWhereUniqueInput
    update: XOR<BacklinkUpdateWithoutProjectLinksInput, BacklinkUncheckedUpdateWithoutProjectLinksInput>
    create: XOR<BacklinkCreateWithoutProjectLinksInput, BacklinkUncheckedCreateWithoutProjectLinksInput>
  }

  export type BacklinkUpdateWithWhereUniqueWithoutProjectLinksInput = {
    where: BacklinkWhereUniqueInput
    data: XOR<BacklinkUpdateWithoutProjectLinksInput, BacklinkUncheckedUpdateWithoutProjectLinksInput>
  }

  export type BacklinkUpdateManyWithWhereWithoutProjectLinksInput = {
    where: BacklinkScalarWhereInput
    data: XOR<BacklinkUpdateManyMutationInput, BacklinkUncheckedUpdateManyWithoutProjectLinksInput>
  }

  export type BacklinkScalarWhereInput = {
    AND?: BacklinkScalarWhereInput | BacklinkScalarWhereInput[]
    OR?: BacklinkScalarWhereInput[]
    NOT?: BacklinkScalarWhereInput | BacklinkScalarWhereInput[]
    id?: IntFilter<"Backlink"> | number
    link_url?: StringFilter<"Backlink"> | string
    link_status?: IntFilter<"Backlink"> | number
    is_index?: BoolNullableFilter<"Backlink"> | boolean | null
    link_rel?: StringNullableFilter<"Backlink"> | string | null
    anchor_text?: StringNullableFilter<"Backlink"> | string | null
    targeted_url?: StringNullableFilter<"Backlink"> | string | null
    project_id?: IntFilter<"Backlink"> | number
    uploaded_by_id?: IntNullableFilter<"Backlink"> | number | null
    first_seen?: DateTimeNullableFilter<"Backlink"> | Date | string | null
    last_seen?: DateTimeNullableFilter<"Backlink"> | Date | string | null
    added_date?: DateTimeNullableFilter<"Backlink"> | Date | string | null
    created_at?: DateTimeFilter<"Backlink"> | Date | string
    updated_at?: DateTimeFilter<"Backlink"> | Date | string
    deleted_at?: DateTimeNullableFilter<"Backlink"> | Date | string | null
    backlink_duplicate?: BoolNullableFilter<"Backlink"> | boolean | null
    referring_domain?: BoolNullableFilter<"Backlink"> | boolean | null
    managed_by?: IntNullableFilter<"Backlink"> | number | null
  }

  export type ProjectsCreateWithoutBacklinkInput = {
    domain_name: string
    domain_url: string
    category_id: number
    created_by_id: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    time_around?: Date | string | null
    time_around_days?: number
  }

  export type ProjectsUncheckedCreateWithoutBacklinkInput = {
    id?: number
    domain_name: string
    domain_url: string
    category_id: number
    created_by_id: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    time_around?: Date | string | null
    time_around_days?: number
  }

  export type ProjectsCreateOrConnectWithoutBacklinkInput = {
    where: ProjectsWhereUniqueInput
    create: XOR<ProjectsCreateWithoutBacklinkInput, ProjectsUncheckedCreateWithoutBacklinkInput>
  }

  export type ProjectsUpsertWithoutBacklinkInput = {
    update: XOR<ProjectsUpdateWithoutBacklinkInput, ProjectsUncheckedUpdateWithoutBacklinkInput>
    create: XOR<ProjectsCreateWithoutBacklinkInput, ProjectsUncheckedCreateWithoutBacklinkInput>
    where?: ProjectsWhereInput
  }

  export type ProjectsUpdateToOneWithWhereWithoutBacklinkInput = {
    where?: ProjectsWhereInput
    data: XOR<ProjectsUpdateWithoutBacklinkInput, ProjectsUncheckedUpdateWithoutBacklinkInput>
  }

  export type ProjectsUpdateWithoutBacklinkInput = {
    domain_name?: StringFieldUpdateOperationsInput | string
    domain_url?: StringFieldUpdateOperationsInput | string
    category_id?: IntFieldUpdateOperationsInput | number
    created_by_id?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    time_around?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    time_around_days?: IntFieldUpdateOperationsInput | number
  }

  export type ProjectsUncheckedUpdateWithoutBacklinkInput = {
    id?: IntFieldUpdateOperationsInput | number
    domain_name?: StringFieldUpdateOperationsInput | string
    domain_url?: StringFieldUpdateOperationsInput | string
    category_id?: IntFieldUpdateOperationsInput | number
    created_by_id?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    time_around?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    time_around_days?: IntFieldUpdateOperationsInput | number
  }

  export type user_permissionsCreateWithoutUserPermissionInput = {
    user_id: number
    limit?: number | null
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
  }

  export type user_permissionsUncheckedCreateWithoutUserPermissionInput = {
    id?: number
    user_id: number
    limit?: number | null
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
  }

  export type user_permissionsCreateOrConnectWithoutUserPermissionInput = {
    where: user_permissionsWhereUniqueInput
    create: XOR<user_permissionsCreateWithoutUserPermissionInput, user_permissionsUncheckedCreateWithoutUserPermissionInput>
  }

  export type user_permissionsCreateManyUserPermissionInputEnvelope = {
    data: user_permissionsCreateManyUserPermissionInput | user_permissionsCreateManyUserPermissionInput[]
    skipDuplicates?: boolean
  }

  export type subscription_featureCreateWithoutFeaturesInput = {
    status?: number
    limit?: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    subscricption_package: subscriptionCreateNestedOneWithoutSubscription_featureInput
  }

  export type subscription_featureUncheckedCreateWithoutFeaturesInput = {
    id?: number
    status?: number
    subscription_id: number
    limit?: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
  }

  export type subscription_featureCreateOrConnectWithoutFeaturesInput = {
    where: subscription_featureWhereUniqueInput
    create: XOR<subscription_featureCreateWithoutFeaturesInput, subscription_featureUncheckedCreateWithoutFeaturesInput>
  }

  export type subscription_featureCreateManyFeaturesInputEnvelope = {
    data: subscription_featureCreateManyFeaturesInput | subscription_featureCreateManyFeaturesInput[]
    skipDuplicates?: boolean
  }

  export type user_permissionsUpsertWithWhereUniqueWithoutUserPermissionInput = {
    where: user_permissionsWhereUniqueInput
    update: XOR<user_permissionsUpdateWithoutUserPermissionInput, user_permissionsUncheckedUpdateWithoutUserPermissionInput>
    create: XOR<user_permissionsCreateWithoutUserPermissionInput, user_permissionsUncheckedCreateWithoutUserPermissionInput>
  }

  export type user_permissionsUpdateWithWhereUniqueWithoutUserPermissionInput = {
    where: user_permissionsWhereUniqueInput
    data: XOR<user_permissionsUpdateWithoutUserPermissionInput, user_permissionsUncheckedUpdateWithoutUserPermissionInput>
  }

  export type user_permissionsUpdateManyWithWhereWithoutUserPermissionInput = {
    where: user_permissionsScalarWhereInput
    data: XOR<user_permissionsUpdateManyMutationInput, user_permissionsUncheckedUpdateManyWithoutUserPermissionInput>
  }

  export type user_permissionsScalarWhereInput = {
    AND?: user_permissionsScalarWhereInput | user_permissionsScalarWhereInput[]
    OR?: user_permissionsScalarWhereInput[]
    NOT?: user_permissionsScalarWhereInput | user_permissionsScalarWhereInput[]
    id?: IntFilter<"user_permissions"> | number
    user_id?: IntFilter<"user_permissions"> | number
    limit?: IntNullableFilter<"user_permissions"> | number | null
    permission_id?: IntFilter<"user_permissions"> | number
    created_at?: DateTimeFilter<"user_permissions"> | Date | string
    updated_at?: DateTimeFilter<"user_permissions"> | Date | string
    deleted_at?: DateTimeNullableFilter<"user_permissions"> | Date | string | null
  }

  export type subscription_featureUpsertWithWhereUniqueWithoutFeaturesInput = {
    where: subscription_featureWhereUniqueInput
    update: XOR<subscription_featureUpdateWithoutFeaturesInput, subscription_featureUncheckedUpdateWithoutFeaturesInput>
    create: XOR<subscription_featureCreateWithoutFeaturesInput, subscription_featureUncheckedCreateWithoutFeaturesInput>
  }

  export type subscription_featureUpdateWithWhereUniqueWithoutFeaturesInput = {
    where: subscription_featureWhereUniqueInput
    data: XOR<subscription_featureUpdateWithoutFeaturesInput, subscription_featureUncheckedUpdateWithoutFeaturesInput>
  }

  export type subscription_featureUpdateManyWithWhereWithoutFeaturesInput = {
    where: subscription_featureScalarWhereInput
    data: XOR<subscription_featureUpdateManyMutationInput, subscription_featureUncheckedUpdateManyWithoutFeaturesInput>
  }

  export type subscription_featureScalarWhereInput = {
    AND?: subscription_featureScalarWhereInput | subscription_featureScalarWhereInput[]
    OR?: subscription_featureScalarWhereInput[]
    NOT?: subscription_featureScalarWhereInput | subscription_featureScalarWhereInput[]
    id?: IntFilter<"subscription_feature"> | number
    status?: IntFilter<"subscription_feature"> | number
    subscription_id?: IntFilter<"subscription_feature"> | number
    permission_id?: IntFilter<"subscription_feature"> | number
    limit?: IntFilter<"subscription_feature"> | number
    created_at?: DateTimeFilter<"subscription_feature"> | Date | string
    updated_at?: DateTimeFilter<"subscription_feature"> | Date | string
    deleted_at?: DateTimeNullableFilter<"subscription_feature"> | Date | string | null
  }

  export type user_subscriptionCreateWithoutUsersubscriptionsInput = {
    user_id: number
    created_by_id: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
  }

  export type user_subscriptionUncheckedCreateWithoutUsersubscriptionsInput = {
    id?: number
    user_id: number
    created_by_id: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
  }

  export type user_subscriptionCreateOrConnectWithoutUsersubscriptionsInput = {
    where: user_subscriptionWhereUniqueInput
    create: XOR<user_subscriptionCreateWithoutUsersubscriptionsInput, user_subscriptionUncheckedCreateWithoutUsersubscriptionsInput>
  }

  export type user_subscriptionCreateManyUsersubscriptionsInputEnvelope = {
    data: user_subscriptionCreateManyUsersubscriptionsInput | user_subscriptionCreateManyUsersubscriptionsInput[]
    skipDuplicates?: boolean
  }

  export type subscription_featureCreateWithoutSubscricption_packageInput = {
    status?: number
    limit?: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    features: permissions_listCreateNestedOneWithoutSubscription_featureInput
  }

  export type subscription_featureUncheckedCreateWithoutSubscricption_packageInput = {
    id?: number
    status?: number
    permission_id: number
    limit?: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
  }

  export type subscription_featureCreateOrConnectWithoutSubscricption_packageInput = {
    where: subscription_featureWhereUniqueInput
    create: XOR<subscription_featureCreateWithoutSubscricption_packageInput, subscription_featureUncheckedCreateWithoutSubscricption_packageInput>
  }

  export type subscription_featureCreateManySubscricption_packageInputEnvelope = {
    data: subscription_featureCreateManySubscricption_packageInput | subscription_featureCreateManySubscricption_packageInput[]
    skipDuplicates?: boolean
  }

  export type package_featuresCreateWithoutFeaturesInput = {
    website_analysis?: boolean
    content_duplicacy?: boolean
    initial_backlinks?: boolean
    critical_seo_analysis?: boolean
    google_penalty_check?: boolean
    competition_analysis?: number
    competitor_backlinks_opportunity?: number
    keyword_research_analysis?: boolean
    on_page_optimization?: boolean
    title_tags_optimization?: boolean
    meta_tags_optimization?: boolean
    content_optimization?: boolean
    html_code_optimization?: boolean
    website_permalinks_analysis?: boolean
    seo_friendly_urls?: boolean
    schema_markup_analysis?: boolean
    internal_linking_optimization?: boolean
    crawl_error_resolution?: boolean
    heading_tags_optimization?: boolean
    canonicalization_301_redirect?: boolean
    custom_404_errors?: boolean
    images_optimization?: boolean
    hyperlink_optimization?: boolean
    robots_txt_creation_optimization?: boolean
    sitemap_creation?: boolean
    google_webmaster_tools_setup?: boolean
    bing_Webmaster_tools_setup?: boolean
    google_analytics_setup_Integration?: boolean
    website_responsive_check?: boolean
    page_speed_analysis?: boolean
    mobile_responsive_compatibility_check?: boolean
    navigation_ux_factors?: boolean
    ssl_certificate?: boolean
    web_2_0_400_600_words_blog_Writing?: number
    article_writing?: number
    classified_writing?: number
    press_release_writing?: number
    ppt_pdf_creation_writing?: number
    web_2_0_400_600_words_submission?: number
    web_2_0_blog_promotion?: number
    article_submission?: number
    article_promotion?: number
    guest_blogging?: number
    custom_graphics_to_support_your_blogs?: boolean
    social_bookmarking_links?: number
    press_release_submission?: number
    local_citation?: number
    classified_submissions?: number
    ppt_submission?: number
    ppt_promotion_backlinks?: number
    pdf_submission?: number
    pdf_promotion_backlinks?: number
    quora_Q_A?: number
    profile_creation?: number
    blog_commenting_niche_edu?: number
    forum_submission?: number
    google_my_business_setup_verification?: boolean
    local_citation_submissions?: number
    google_places_photo_multimedia_additions?: boolean
    customer_reviews_ratings?: number
    local_classified_ads?: number
    monthly_keyword_improvement_report?: boolean
    monthly_back_links_report?: boolean
    monthly_google_analytic_static_report?: boolean
    email?: boolean
    telephone_whatsapp_telegram?: boolean
    internet_messenger_skype?: boolean
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    status?: number | null
  }

  export type package_featuresUncheckedCreateWithoutFeaturesInput = {
    id?: number
    website_analysis?: boolean
    content_duplicacy?: boolean
    initial_backlinks?: boolean
    critical_seo_analysis?: boolean
    google_penalty_check?: boolean
    competition_analysis?: number
    competitor_backlinks_opportunity?: number
    keyword_research_analysis?: boolean
    on_page_optimization?: boolean
    title_tags_optimization?: boolean
    meta_tags_optimization?: boolean
    content_optimization?: boolean
    html_code_optimization?: boolean
    website_permalinks_analysis?: boolean
    seo_friendly_urls?: boolean
    schema_markup_analysis?: boolean
    internal_linking_optimization?: boolean
    crawl_error_resolution?: boolean
    heading_tags_optimization?: boolean
    canonicalization_301_redirect?: boolean
    custom_404_errors?: boolean
    images_optimization?: boolean
    hyperlink_optimization?: boolean
    robots_txt_creation_optimization?: boolean
    sitemap_creation?: boolean
    google_webmaster_tools_setup?: boolean
    bing_Webmaster_tools_setup?: boolean
    google_analytics_setup_Integration?: boolean
    website_responsive_check?: boolean
    page_speed_analysis?: boolean
    mobile_responsive_compatibility_check?: boolean
    navigation_ux_factors?: boolean
    ssl_certificate?: boolean
    web_2_0_400_600_words_blog_Writing?: number
    article_writing?: number
    classified_writing?: number
    press_release_writing?: number
    ppt_pdf_creation_writing?: number
    web_2_0_400_600_words_submission?: number
    web_2_0_blog_promotion?: number
    article_submission?: number
    article_promotion?: number
    guest_blogging?: number
    custom_graphics_to_support_your_blogs?: boolean
    social_bookmarking_links?: number
    press_release_submission?: number
    local_citation?: number
    classified_submissions?: number
    ppt_submission?: number
    ppt_promotion_backlinks?: number
    pdf_submission?: number
    pdf_promotion_backlinks?: number
    quora_Q_A?: number
    profile_creation?: number
    blog_commenting_niche_edu?: number
    forum_submission?: number
    google_my_business_setup_verification?: boolean
    local_citation_submissions?: number
    google_places_photo_multimedia_additions?: boolean
    customer_reviews_ratings?: number
    local_classified_ads?: number
    monthly_keyword_improvement_report?: boolean
    monthly_back_links_report?: boolean
    monthly_google_analytic_static_report?: boolean
    email?: boolean
    telephone_whatsapp_telegram?: boolean
    internet_messenger_skype?: boolean
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    status?: number | null
  }

  export type package_featuresCreateOrConnectWithoutFeaturesInput = {
    where: package_featuresWhereUniqueInput
    create: XOR<package_featuresCreateWithoutFeaturesInput, package_featuresUncheckedCreateWithoutFeaturesInput>
  }

  export type package_featuresCreateManyFeaturesInputEnvelope = {
    data: package_featuresCreateManyFeaturesInput | package_featuresCreateManyFeaturesInput[]
    skipDuplicates?: boolean
  }

  export type user_subscriptionUpsertWithWhereUniqueWithoutUsersubscriptionsInput = {
    where: user_subscriptionWhereUniqueInput
    update: XOR<user_subscriptionUpdateWithoutUsersubscriptionsInput, user_subscriptionUncheckedUpdateWithoutUsersubscriptionsInput>
    create: XOR<user_subscriptionCreateWithoutUsersubscriptionsInput, user_subscriptionUncheckedCreateWithoutUsersubscriptionsInput>
  }

  export type user_subscriptionUpdateWithWhereUniqueWithoutUsersubscriptionsInput = {
    where: user_subscriptionWhereUniqueInput
    data: XOR<user_subscriptionUpdateWithoutUsersubscriptionsInput, user_subscriptionUncheckedUpdateWithoutUsersubscriptionsInput>
  }

  export type user_subscriptionUpdateManyWithWhereWithoutUsersubscriptionsInput = {
    where: user_subscriptionScalarWhereInput
    data: XOR<user_subscriptionUpdateManyMutationInput, user_subscriptionUncheckedUpdateManyWithoutUsersubscriptionsInput>
  }

  export type user_subscriptionScalarWhereInput = {
    AND?: user_subscriptionScalarWhereInput | user_subscriptionScalarWhereInput[]
    OR?: user_subscriptionScalarWhereInput[]
    NOT?: user_subscriptionScalarWhereInput | user_subscriptionScalarWhereInput[]
    id?: IntFilter<"user_subscription"> | number
    user_id?: IntFilter<"user_subscription"> | number
    created_by_id?: IntFilter<"user_subscription"> | number
    created_at?: DateTimeFilter<"user_subscription"> | Date | string
    updated_at?: DateTimeFilter<"user_subscription"> | Date | string
    deleted_at?: DateTimeNullableFilter<"user_subscription"> | Date | string | null
    subscription_id?: IntFilter<"user_subscription"> | number
  }

  export type subscription_featureUpsertWithWhereUniqueWithoutSubscricption_packageInput = {
    where: subscription_featureWhereUniqueInput
    update: XOR<subscription_featureUpdateWithoutSubscricption_packageInput, subscription_featureUncheckedUpdateWithoutSubscricption_packageInput>
    create: XOR<subscription_featureCreateWithoutSubscricption_packageInput, subscription_featureUncheckedCreateWithoutSubscricption_packageInput>
  }

  export type subscription_featureUpdateWithWhereUniqueWithoutSubscricption_packageInput = {
    where: subscription_featureWhereUniqueInput
    data: XOR<subscription_featureUpdateWithoutSubscricption_packageInput, subscription_featureUncheckedUpdateWithoutSubscricption_packageInput>
  }

  export type subscription_featureUpdateManyWithWhereWithoutSubscricption_packageInput = {
    where: subscription_featureScalarWhereInput
    data: XOR<subscription_featureUpdateManyMutationInput, subscription_featureUncheckedUpdateManyWithoutSubscricption_packageInput>
  }

  export type package_featuresUpsertWithWhereUniqueWithoutFeaturesInput = {
    where: package_featuresWhereUniqueInput
    update: XOR<package_featuresUpdateWithoutFeaturesInput, package_featuresUncheckedUpdateWithoutFeaturesInput>
    create: XOR<package_featuresCreateWithoutFeaturesInput, package_featuresUncheckedCreateWithoutFeaturesInput>
  }

  export type package_featuresUpdateWithWhereUniqueWithoutFeaturesInput = {
    where: package_featuresWhereUniqueInput
    data: XOR<package_featuresUpdateWithoutFeaturesInput, package_featuresUncheckedUpdateWithoutFeaturesInput>
  }

  export type package_featuresUpdateManyWithWhereWithoutFeaturesInput = {
    where: package_featuresScalarWhereInput
    data: XOR<package_featuresUpdateManyMutationInput, package_featuresUncheckedUpdateManyWithoutFeaturesInput>
  }

  export type package_featuresScalarWhereInput = {
    AND?: package_featuresScalarWhereInput | package_featuresScalarWhereInput[]
    OR?: package_featuresScalarWhereInput[]
    NOT?: package_featuresScalarWhereInput | package_featuresScalarWhereInput[]
    id?: IntFilter<"package_features"> | number
    subscription_id?: IntFilter<"package_features"> | number
    website_analysis?: BoolFilter<"package_features"> | boolean
    content_duplicacy?: BoolFilter<"package_features"> | boolean
    initial_backlinks?: BoolFilter<"package_features"> | boolean
    critical_seo_analysis?: BoolFilter<"package_features"> | boolean
    google_penalty_check?: BoolFilter<"package_features"> | boolean
    competition_analysis?: IntFilter<"package_features"> | number
    competitor_backlinks_opportunity?: IntFilter<"package_features"> | number
    keyword_research_analysis?: BoolFilter<"package_features"> | boolean
    on_page_optimization?: BoolFilter<"package_features"> | boolean
    title_tags_optimization?: BoolFilter<"package_features"> | boolean
    meta_tags_optimization?: BoolFilter<"package_features"> | boolean
    content_optimization?: BoolFilter<"package_features"> | boolean
    html_code_optimization?: BoolFilter<"package_features"> | boolean
    website_permalinks_analysis?: BoolFilter<"package_features"> | boolean
    seo_friendly_urls?: BoolFilter<"package_features"> | boolean
    schema_markup_analysis?: BoolFilter<"package_features"> | boolean
    internal_linking_optimization?: BoolFilter<"package_features"> | boolean
    crawl_error_resolution?: BoolFilter<"package_features"> | boolean
    heading_tags_optimization?: BoolFilter<"package_features"> | boolean
    canonicalization_301_redirect?: BoolFilter<"package_features"> | boolean
    custom_404_errors?: BoolFilter<"package_features"> | boolean
    images_optimization?: BoolFilter<"package_features"> | boolean
    hyperlink_optimization?: BoolFilter<"package_features"> | boolean
    robots_txt_creation_optimization?: BoolFilter<"package_features"> | boolean
    sitemap_creation?: BoolFilter<"package_features"> | boolean
    google_webmaster_tools_setup?: BoolFilter<"package_features"> | boolean
    bing_Webmaster_tools_setup?: BoolFilter<"package_features"> | boolean
    google_analytics_setup_Integration?: BoolFilter<"package_features"> | boolean
    website_responsive_check?: BoolFilter<"package_features"> | boolean
    page_speed_analysis?: BoolFilter<"package_features"> | boolean
    mobile_responsive_compatibility_check?: BoolFilter<"package_features"> | boolean
    navigation_ux_factors?: BoolFilter<"package_features"> | boolean
    ssl_certificate?: BoolFilter<"package_features"> | boolean
    web_2_0_400_600_words_blog_Writing?: IntFilter<"package_features"> | number
    article_writing?: IntFilter<"package_features"> | number
    classified_writing?: IntFilter<"package_features"> | number
    press_release_writing?: IntFilter<"package_features"> | number
    ppt_pdf_creation_writing?: IntFilter<"package_features"> | number
    web_2_0_400_600_words_submission?: IntFilter<"package_features"> | number
    web_2_0_blog_promotion?: IntFilter<"package_features"> | number
    article_submission?: IntFilter<"package_features"> | number
    article_promotion?: IntFilter<"package_features"> | number
    guest_blogging?: IntFilter<"package_features"> | number
    custom_graphics_to_support_your_blogs?: BoolFilter<"package_features"> | boolean
    social_bookmarking_links?: IntFilter<"package_features"> | number
    press_release_submission?: IntFilter<"package_features"> | number
    local_citation?: IntFilter<"package_features"> | number
    classified_submissions?: IntFilter<"package_features"> | number
    ppt_submission?: IntFilter<"package_features"> | number
    ppt_promotion_backlinks?: IntFilter<"package_features"> | number
    pdf_submission?: IntFilter<"package_features"> | number
    pdf_promotion_backlinks?: IntFilter<"package_features"> | number
    quora_Q_A?: IntFilter<"package_features"> | number
    profile_creation?: IntFilter<"package_features"> | number
    blog_commenting_niche_edu?: IntFilter<"package_features"> | number
    forum_submission?: IntFilter<"package_features"> | number
    google_my_business_setup_verification?: BoolFilter<"package_features"> | boolean
    local_citation_submissions?: IntFilter<"package_features"> | number
    google_places_photo_multimedia_additions?: BoolFilter<"package_features"> | boolean
    customer_reviews_ratings?: IntFilter<"package_features"> | number
    local_classified_ads?: IntFilter<"package_features"> | number
    monthly_keyword_improvement_report?: BoolFilter<"package_features"> | boolean
    monthly_back_links_report?: BoolFilter<"package_features"> | boolean
    monthly_google_analytic_static_report?: BoolFilter<"package_features"> | boolean
    email?: BoolFilter<"package_features"> | boolean
    telephone_whatsapp_telegram?: BoolFilter<"package_features"> | boolean
    internet_messenger_skype?: BoolFilter<"package_features"> | boolean
    created_at?: DateTimeFilter<"package_features"> | Date | string
    updated_at?: DateTimeFilter<"package_features"> | Date | string
    deleted_at?: DateTimeNullableFilter<"package_features"> | Date | string | null
    status?: IntNullableFilter<"package_features"> | number | null
  }

  export type subscriptionCreateWithoutSubscription_featureInput = {
    name?: string
    status?: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    user_subscription?: user_subscriptionCreateNestedManyWithoutUsersubscriptionsInput
    package_features?: package_featuresCreateNestedManyWithoutFeaturesInput
  }

  export type subscriptionUncheckedCreateWithoutSubscription_featureInput = {
    id?: number
    name?: string
    status?: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    user_subscription?: user_subscriptionUncheckedCreateNestedManyWithoutUsersubscriptionsInput
    package_features?: package_featuresUncheckedCreateNestedManyWithoutFeaturesInput
  }

  export type subscriptionCreateOrConnectWithoutSubscription_featureInput = {
    where: subscriptionWhereUniqueInput
    create: XOR<subscriptionCreateWithoutSubscription_featureInput, subscriptionUncheckedCreateWithoutSubscription_featureInput>
  }

  export type permissions_listCreateWithoutSubscription_featureInput = {
    title: string
    type: string
    created_by: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    user_permissions?: user_permissionsCreateNestedManyWithoutUserPermissionInput
  }

  export type permissions_listUncheckedCreateWithoutSubscription_featureInput = {
    id?: number
    title: string
    type: string
    created_by: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    user_permissions?: user_permissionsUncheckedCreateNestedManyWithoutUserPermissionInput
  }

  export type permissions_listCreateOrConnectWithoutSubscription_featureInput = {
    where: permissions_listWhereUniqueInput
    create: XOR<permissions_listCreateWithoutSubscription_featureInput, permissions_listUncheckedCreateWithoutSubscription_featureInput>
  }

  export type subscriptionUpsertWithoutSubscription_featureInput = {
    update: XOR<subscriptionUpdateWithoutSubscription_featureInput, subscriptionUncheckedUpdateWithoutSubscription_featureInput>
    create: XOR<subscriptionCreateWithoutSubscription_featureInput, subscriptionUncheckedCreateWithoutSubscription_featureInput>
    where?: subscriptionWhereInput
  }

  export type subscriptionUpdateToOneWithWhereWithoutSubscription_featureInput = {
    where?: subscriptionWhereInput
    data: XOR<subscriptionUpdateWithoutSubscription_featureInput, subscriptionUncheckedUpdateWithoutSubscription_featureInput>
  }

  export type subscriptionUpdateWithoutSubscription_featureInput = {
    name?: StringFieldUpdateOperationsInput | string
    status?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    user_subscription?: user_subscriptionUpdateManyWithoutUsersubscriptionsNestedInput
    package_features?: package_featuresUpdateManyWithoutFeaturesNestedInput
  }

  export type subscriptionUncheckedUpdateWithoutSubscription_featureInput = {
    id?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    status?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    user_subscription?: user_subscriptionUncheckedUpdateManyWithoutUsersubscriptionsNestedInput
    package_features?: package_featuresUncheckedUpdateManyWithoutFeaturesNestedInput
  }

  export type permissions_listUpsertWithoutSubscription_featureInput = {
    update: XOR<permissions_listUpdateWithoutSubscription_featureInput, permissions_listUncheckedUpdateWithoutSubscription_featureInput>
    create: XOR<permissions_listCreateWithoutSubscription_featureInput, permissions_listUncheckedCreateWithoutSubscription_featureInput>
    where?: permissions_listWhereInput
  }

  export type permissions_listUpdateToOneWithWhereWithoutSubscription_featureInput = {
    where?: permissions_listWhereInput
    data: XOR<permissions_listUpdateWithoutSubscription_featureInput, permissions_listUncheckedUpdateWithoutSubscription_featureInput>
  }

  export type permissions_listUpdateWithoutSubscription_featureInput = {
    title?: StringFieldUpdateOperationsInput | string
    type?: StringFieldUpdateOperationsInput | string
    created_by?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    user_permissions?: user_permissionsUpdateManyWithoutUserPermissionNestedInput
  }

  export type permissions_listUncheckedUpdateWithoutSubscription_featureInput = {
    id?: IntFieldUpdateOperationsInput | number
    title?: StringFieldUpdateOperationsInput | string
    type?: StringFieldUpdateOperationsInput | string
    created_by?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    user_permissions?: user_permissionsUncheckedUpdateManyWithoutUserPermissionNestedInput
  }

  export type subscriptionCreateWithoutUser_subscriptionInput = {
    name?: string
    status?: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    subscription_feature?: subscription_featureCreateNestedManyWithoutSubscricption_packageInput
    package_features?: package_featuresCreateNestedManyWithoutFeaturesInput
  }

  export type subscriptionUncheckedCreateWithoutUser_subscriptionInput = {
    id?: number
    name?: string
    status?: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    subscription_feature?: subscription_featureUncheckedCreateNestedManyWithoutSubscricption_packageInput
    package_features?: package_featuresUncheckedCreateNestedManyWithoutFeaturesInput
  }

  export type subscriptionCreateOrConnectWithoutUser_subscriptionInput = {
    where: subscriptionWhereUniqueInput
    create: XOR<subscriptionCreateWithoutUser_subscriptionInput, subscriptionUncheckedCreateWithoutUser_subscriptionInput>
  }

  export type subscriptionUpsertWithoutUser_subscriptionInput = {
    update: XOR<subscriptionUpdateWithoutUser_subscriptionInput, subscriptionUncheckedUpdateWithoutUser_subscriptionInput>
    create: XOR<subscriptionCreateWithoutUser_subscriptionInput, subscriptionUncheckedCreateWithoutUser_subscriptionInput>
    where?: subscriptionWhereInput
  }

  export type subscriptionUpdateToOneWithWhereWithoutUser_subscriptionInput = {
    where?: subscriptionWhereInput
    data: XOR<subscriptionUpdateWithoutUser_subscriptionInput, subscriptionUncheckedUpdateWithoutUser_subscriptionInput>
  }

  export type subscriptionUpdateWithoutUser_subscriptionInput = {
    name?: StringFieldUpdateOperationsInput | string
    status?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    subscription_feature?: subscription_featureUpdateManyWithoutSubscricption_packageNestedInput
    package_features?: package_featuresUpdateManyWithoutFeaturesNestedInput
  }

  export type subscriptionUncheckedUpdateWithoutUser_subscriptionInput = {
    id?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    status?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    subscription_feature?: subscription_featureUncheckedUpdateManyWithoutSubscricption_packageNestedInput
    package_features?: package_featuresUncheckedUpdateManyWithoutFeaturesNestedInput
  }

  export type permissions_listCreateWithoutUser_permissionsInput = {
    title: string
    type: string
    created_by: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    subscription_feature?: subscription_featureCreateNestedManyWithoutFeaturesInput
  }

  export type permissions_listUncheckedCreateWithoutUser_permissionsInput = {
    id?: number
    title: string
    type: string
    created_by: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    subscription_feature?: subscription_featureUncheckedCreateNestedManyWithoutFeaturesInput
  }

  export type permissions_listCreateOrConnectWithoutUser_permissionsInput = {
    where: permissions_listWhereUniqueInput
    create: XOR<permissions_listCreateWithoutUser_permissionsInput, permissions_listUncheckedCreateWithoutUser_permissionsInput>
  }

  export type permissions_listUpsertWithoutUser_permissionsInput = {
    update: XOR<permissions_listUpdateWithoutUser_permissionsInput, permissions_listUncheckedUpdateWithoutUser_permissionsInput>
    create: XOR<permissions_listCreateWithoutUser_permissionsInput, permissions_listUncheckedCreateWithoutUser_permissionsInput>
    where?: permissions_listWhereInput
  }

  export type permissions_listUpdateToOneWithWhereWithoutUser_permissionsInput = {
    where?: permissions_listWhereInput
    data: XOR<permissions_listUpdateWithoutUser_permissionsInput, permissions_listUncheckedUpdateWithoutUser_permissionsInput>
  }

  export type permissions_listUpdateWithoutUser_permissionsInput = {
    title?: StringFieldUpdateOperationsInput | string
    type?: StringFieldUpdateOperationsInput | string
    created_by?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    subscription_feature?: subscription_featureUpdateManyWithoutFeaturesNestedInput
  }

  export type permissions_listUncheckedUpdateWithoutUser_permissionsInput = {
    id?: IntFieldUpdateOperationsInput | number
    title?: StringFieldUpdateOperationsInput | string
    type?: StringFieldUpdateOperationsInput | string
    created_by?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    subscription_feature?: subscription_featureUncheckedUpdateManyWithoutFeaturesNestedInput
  }

  export type subscriptionCreateWithoutPackage_featuresInput = {
    name?: string
    status?: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    user_subscription?: user_subscriptionCreateNestedManyWithoutUsersubscriptionsInput
    subscription_feature?: subscription_featureCreateNestedManyWithoutSubscricption_packageInput
  }

  export type subscriptionUncheckedCreateWithoutPackage_featuresInput = {
    id?: number
    name?: string
    status?: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    user_subscription?: user_subscriptionUncheckedCreateNestedManyWithoutUsersubscriptionsInput
    subscription_feature?: subscription_featureUncheckedCreateNestedManyWithoutSubscricption_packageInput
  }

  export type subscriptionCreateOrConnectWithoutPackage_featuresInput = {
    where: subscriptionWhereUniqueInput
    create: XOR<subscriptionCreateWithoutPackage_featuresInput, subscriptionUncheckedCreateWithoutPackage_featuresInput>
  }

  export type subscriptionUpsertWithoutPackage_featuresInput = {
    update: XOR<subscriptionUpdateWithoutPackage_featuresInput, subscriptionUncheckedUpdateWithoutPackage_featuresInput>
    create: XOR<subscriptionCreateWithoutPackage_featuresInput, subscriptionUncheckedCreateWithoutPackage_featuresInput>
    where?: subscriptionWhereInput
  }

  export type subscriptionUpdateToOneWithWhereWithoutPackage_featuresInput = {
    where?: subscriptionWhereInput
    data: XOR<subscriptionUpdateWithoutPackage_featuresInput, subscriptionUncheckedUpdateWithoutPackage_featuresInput>
  }

  export type subscriptionUpdateWithoutPackage_featuresInput = {
    name?: StringFieldUpdateOperationsInput | string
    status?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    user_subscription?: user_subscriptionUpdateManyWithoutUsersubscriptionsNestedInput
    subscription_feature?: subscription_featureUpdateManyWithoutSubscricption_packageNestedInput
  }

  export type subscriptionUncheckedUpdateWithoutPackage_featuresInput = {
    id?: IntFieldUpdateOperationsInput | number
    name?: StringFieldUpdateOperationsInput | string
    status?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    user_subscription?: user_subscriptionUncheckedUpdateManyWithoutUsersubscriptionsNestedInput
    subscription_feature?: subscription_featureUncheckedUpdateManyWithoutSubscricption_packageNestedInput
  }

  export type BacklinkCreateManyProjectLinksInput = {
    id?: number
    link_url: string
    link_status: number
    is_index?: boolean | null
    link_rel?: string | null
    anchor_text?: string | null
    targeted_url?: string | null
    uploaded_by_id?: number | null
    first_seen?: Date | string | null
    last_seen?: Date | string | null
    added_date?: Date | string | null
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    backlink_duplicate?: boolean | null
    referring_domain?: boolean | null
    managed_by?: number | null
  }

  export type BacklinkUpdateWithoutProjectLinksInput = {
    link_url?: StringFieldUpdateOperationsInput | string
    link_status?: IntFieldUpdateOperationsInput | number
    is_index?: NullableBoolFieldUpdateOperationsInput | boolean | null
    link_rel?: NullableStringFieldUpdateOperationsInput | string | null
    anchor_text?: NullableStringFieldUpdateOperationsInput | string | null
    targeted_url?: NullableStringFieldUpdateOperationsInput | string | null
    uploaded_by_id?: NullableIntFieldUpdateOperationsInput | number | null
    first_seen?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    last_seen?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    added_date?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    backlink_duplicate?: NullableBoolFieldUpdateOperationsInput | boolean | null
    referring_domain?: NullableBoolFieldUpdateOperationsInput | boolean | null
    managed_by?: NullableIntFieldUpdateOperationsInput | number | null
  }

  export type BacklinkUncheckedUpdateWithoutProjectLinksInput = {
    id?: IntFieldUpdateOperationsInput | number
    link_url?: StringFieldUpdateOperationsInput | string
    link_status?: IntFieldUpdateOperationsInput | number
    is_index?: NullableBoolFieldUpdateOperationsInput | boolean | null
    link_rel?: NullableStringFieldUpdateOperationsInput | string | null
    anchor_text?: NullableStringFieldUpdateOperationsInput | string | null
    targeted_url?: NullableStringFieldUpdateOperationsInput | string | null
    uploaded_by_id?: NullableIntFieldUpdateOperationsInput | number | null
    first_seen?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    last_seen?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    added_date?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    backlink_duplicate?: NullableBoolFieldUpdateOperationsInput | boolean | null
    referring_domain?: NullableBoolFieldUpdateOperationsInput | boolean | null
    managed_by?: NullableIntFieldUpdateOperationsInput | number | null
  }

  export type BacklinkUncheckedUpdateManyWithoutProjectLinksInput = {
    id?: IntFieldUpdateOperationsInput | number
    link_url?: StringFieldUpdateOperationsInput | string
    link_status?: IntFieldUpdateOperationsInput | number
    is_index?: NullableBoolFieldUpdateOperationsInput | boolean | null
    link_rel?: NullableStringFieldUpdateOperationsInput | string | null
    anchor_text?: NullableStringFieldUpdateOperationsInput | string | null
    targeted_url?: NullableStringFieldUpdateOperationsInput | string | null
    uploaded_by_id?: NullableIntFieldUpdateOperationsInput | number | null
    first_seen?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    last_seen?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    added_date?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    backlink_duplicate?: NullableBoolFieldUpdateOperationsInput | boolean | null
    referring_domain?: NullableBoolFieldUpdateOperationsInput | boolean | null
    managed_by?: NullableIntFieldUpdateOperationsInput | number | null
  }

  export type user_permissionsCreateManyUserPermissionInput = {
    id?: number
    user_id: number
    limit?: number | null
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
  }

  export type subscription_featureCreateManyFeaturesInput = {
    id?: number
    status?: number
    subscription_id: number
    limit?: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
  }

  export type user_permissionsUpdateWithoutUserPermissionInput = {
    user_id?: IntFieldUpdateOperationsInput | number
    limit?: NullableIntFieldUpdateOperationsInput | number | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type user_permissionsUncheckedUpdateWithoutUserPermissionInput = {
    id?: IntFieldUpdateOperationsInput | number
    user_id?: IntFieldUpdateOperationsInput | number
    limit?: NullableIntFieldUpdateOperationsInput | number | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type user_permissionsUncheckedUpdateManyWithoutUserPermissionInput = {
    id?: IntFieldUpdateOperationsInput | number
    user_id?: IntFieldUpdateOperationsInput | number
    limit?: NullableIntFieldUpdateOperationsInput | number | null
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type subscription_featureUpdateWithoutFeaturesInput = {
    status?: IntFieldUpdateOperationsInput | number
    limit?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    subscricption_package?: subscriptionUpdateOneRequiredWithoutSubscription_featureNestedInput
  }

  export type subscription_featureUncheckedUpdateWithoutFeaturesInput = {
    id?: IntFieldUpdateOperationsInput | number
    status?: IntFieldUpdateOperationsInput | number
    subscription_id?: IntFieldUpdateOperationsInput | number
    limit?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type subscription_featureUncheckedUpdateManyWithoutFeaturesInput = {
    id?: IntFieldUpdateOperationsInput | number
    status?: IntFieldUpdateOperationsInput | number
    subscription_id?: IntFieldUpdateOperationsInput | number
    limit?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type user_subscriptionCreateManyUsersubscriptionsInput = {
    id?: number
    user_id: number
    created_by_id: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
  }

  export type subscription_featureCreateManySubscricption_packageInput = {
    id?: number
    status?: number
    permission_id: number
    limit?: number
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
  }

  export type package_featuresCreateManyFeaturesInput = {
    id?: number
    website_analysis?: boolean
    content_duplicacy?: boolean
    initial_backlinks?: boolean
    critical_seo_analysis?: boolean
    google_penalty_check?: boolean
    competition_analysis?: number
    competitor_backlinks_opportunity?: number
    keyword_research_analysis?: boolean
    on_page_optimization?: boolean
    title_tags_optimization?: boolean
    meta_tags_optimization?: boolean
    content_optimization?: boolean
    html_code_optimization?: boolean
    website_permalinks_analysis?: boolean
    seo_friendly_urls?: boolean
    schema_markup_analysis?: boolean
    internal_linking_optimization?: boolean
    crawl_error_resolution?: boolean
    heading_tags_optimization?: boolean
    canonicalization_301_redirect?: boolean
    custom_404_errors?: boolean
    images_optimization?: boolean
    hyperlink_optimization?: boolean
    robots_txt_creation_optimization?: boolean
    sitemap_creation?: boolean
    google_webmaster_tools_setup?: boolean
    bing_Webmaster_tools_setup?: boolean
    google_analytics_setup_Integration?: boolean
    website_responsive_check?: boolean
    page_speed_analysis?: boolean
    mobile_responsive_compatibility_check?: boolean
    navigation_ux_factors?: boolean
    ssl_certificate?: boolean
    web_2_0_400_600_words_blog_Writing?: number
    article_writing?: number
    classified_writing?: number
    press_release_writing?: number
    ppt_pdf_creation_writing?: number
    web_2_0_400_600_words_submission?: number
    web_2_0_blog_promotion?: number
    article_submission?: number
    article_promotion?: number
    guest_blogging?: number
    custom_graphics_to_support_your_blogs?: boolean
    social_bookmarking_links?: number
    press_release_submission?: number
    local_citation?: number
    classified_submissions?: number
    ppt_submission?: number
    ppt_promotion_backlinks?: number
    pdf_submission?: number
    pdf_promotion_backlinks?: number
    quora_Q_A?: number
    profile_creation?: number
    blog_commenting_niche_edu?: number
    forum_submission?: number
    google_my_business_setup_verification?: boolean
    local_citation_submissions?: number
    google_places_photo_multimedia_additions?: boolean
    customer_reviews_ratings?: number
    local_classified_ads?: number
    monthly_keyword_improvement_report?: boolean
    monthly_back_links_report?: boolean
    monthly_google_analytic_static_report?: boolean
    email?: boolean
    telephone_whatsapp_telegram?: boolean
    internet_messenger_skype?: boolean
    created_at?: Date | string
    updated_at?: Date | string
    deleted_at?: Date | string | null
    status?: number | null
  }

  export type user_subscriptionUpdateWithoutUsersubscriptionsInput = {
    user_id?: IntFieldUpdateOperationsInput | number
    created_by_id?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type user_subscriptionUncheckedUpdateWithoutUsersubscriptionsInput = {
    id?: IntFieldUpdateOperationsInput | number
    user_id?: IntFieldUpdateOperationsInput | number
    created_by_id?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type user_subscriptionUncheckedUpdateManyWithoutUsersubscriptionsInput = {
    id?: IntFieldUpdateOperationsInput | number
    user_id?: IntFieldUpdateOperationsInput | number
    created_by_id?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type subscription_featureUpdateWithoutSubscricption_packageInput = {
    status?: IntFieldUpdateOperationsInput | number
    limit?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    features?: permissions_listUpdateOneRequiredWithoutSubscription_featureNestedInput
  }

  export type subscription_featureUncheckedUpdateWithoutSubscricption_packageInput = {
    id?: IntFieldUpdateOperationsInput | number
    status?: IntFieldUpdateOperationsInput | number
    permission_id?: IntFieldUpdateOperationsInput | number
    limit?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type subscription_featureUncheckedUpdateManyWithoutSubscricption_packageInput = {
    id?: IntFieldUpdateOperationsInput | number
    status?: IntFieldUpdateOperationsInput | number
    permission_id?: IntFieldUpdateOperationsInput | number
    limit?: IntFieldUpdateOperationsInput | number
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
  }

  export type package_featuresUpdateWithoutFeaturesInput = {
    website_analysis?: BoolFieldUpdateOperationsInput | boolean
    content_duplicacy?: BoolFieldUpdateOperationsInput | boolean
    initial_backlinks?: BoolFieldUpdateOperationsInput | boolean
    critical_seo_analysis?: BoolFieldUpdateOperationsInput | boolean
    google_penalty_check?: BoolFieldUpdateOperationsInput | boolean
    competition_analysis?: IntFieldUpdateOperationsInput | number
    competitor_backlinks_opportunity?: IntFieldUpdateOperationsInput | number
    keyword_research_analysis?: BoolFieldUpdateOperationsInput | boolean
    on_page_optimization?: BoolFieldUpdateOperationsInput | boolean
    title_tags_optimization?: BoolFieldUpdateOperationsInput | boolean
    meta_tags_optimization?: BoolFieldUpdateOperationsInput | boolean
    content_optimization?: BoolFieldUpdateOperationsInput | boolean
    html_code_optimization?: BoolFieldUpdateOperationsInput | boolean
    website_permalinks_analysis?: BoolFieldUpdateOperationsInput | boolean
    seo_friendly_urls?: BoolFieldUpdateOperationsInput | boolean
    schema_markup_analysis?: BoolFieldUpdateOperationsInput | boolean
    internal_linking_optimization?: BoolFieldUpdateOperationsInput | boolean
    crawl_error_resolution?: BoolFieldUpdateOperationsInput | boolean
    heading_tags_optimization?: BoolFieldUpdateOperationsInput | boolean
    canonicalization_301_redirect?: BoolFieldUpdateOperationsInput | boolean
    custom_404_errors?: BoolFieldUpdateOperationsInput | boolean
    images_optimization?: BoolFieldUpdateOperationsInput | boolean
    hyperlink_optimization?: BoolFieldUpdateOperationsInput | boolean
    robots_txt_creation_optimization?: BoolFieldUpdateOperationsInput | boolean
    sitemap_creation?: BoolFieldUpdateOperationsInput | boolean
    google_webmaster_tools_setup?: BoolFieldUpdateOperationsInput | boolean
    bing_Webmaster_tools_setup?: BoolFieldUpdateOperationsInput | boolean
    google_analytics_setup_Integration?: BoolFieldUpdateOperationsInput | boolean
    website_responsive_check?: BoolFieldUpdateOperationsInput | boolean
    page_speed_analysis?: BoolFieldUpdateOperationsInput | boolean
    mobile_responsive_compatibility_check?: BoolFieldUpdateOperationsInput | boolean
    navigation_ux_factors?: BoolFieldUpdateOperationsInput | boolean
    ssl_certificate?: BoolFieldUpdateOperationsInput | boolean
    web_2_0_400_600_words_blog_Writing?: IntFieldUpdateOperationsInput | number
    article_writing?: IntFieldUpdateOperationsInput | number
    classified_writing?: IntFieldUpdateOperationsInput | number
    press_release_writing?: IntFieldUpdateOperationsInput | number
    ppt_pdf_creation_writing?: IntFieldUpdateOperationsInput | number
    web_2_0_400_600_words_submission?: IntFieldUpdateOperationsInput | number
    web_2_0_blog_promotion?: IntFieldUpdateOperationsInput | number
    article_submission?: IntFieldUpdateOperationsInput | number
    article_promotion?: IntFieldUpdateOperationsInput | number
    guest_blogging?: IntFieldUpdateOperationsInput | number
    custom_graphics_to_support_your_blogs?: BoolFieldUpdateOperationsInput | boolean
    social_bookmarking_links?: IntFieldUpdateOperationsInput | number
    press_release_submission?: IntFieldUpdateOperationsInput | number
    local_citation?: IntFieldUpdateOperationsInput | number
    classified_submissions?: IntFieldUpdateOperationsInput | number
    ppt_submission?: IntFieldUpdateOperationsInput | number
    ppt_promotion_backlinks?: IntFieldUpdateOperationsInput | number
    pdf_submission?: IntFieldUpdateOperationsInput | number
    pdf_promotion_backlinks?: IntFieldUpdateOperationsInput | number
    quora_Q_A?: IntFieldUpdateOperationsInput | number
    profile_creation?: IntFieldUpdateOperationsInput | number
    blog_commenting_niche_edu?: IntFieldUpdateOperationsInput | number
    forum_submission?: IntFieldUpdateOperationsInput | number
    google_my_business_setup_verification?: BoolFieldUpdateOperationsInput | boolean
    local_citation_submissions?: IntFieldUpdateOperationsInput | number
    google_places_photo_multimedia_additions?: BoolFieldUpdateOperationsInput | boolean
    customer_reviews_ratings?: IntFieldUpdateOperationsInput | number
    local_classified_ads?: IntFieldUpdateOperationsInput | number
    monthly_keyword_improvement_report?: BoolFieldUpdateOperationsInput | boolean
    monthly_back_links_report?: BoolFieldUpdateOperationsInput | boolean
    monthly_google_analytic_static_report?: BoolFieldUpdateOperationsInput | boolean
    email?: BoolFieldUpdateOperationsInput | boolean
    telephone_whatsapp_telegram?: BoolFieldUpdateOperationsInput | boolean
    internet_messenger_skype?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    status?: NullableIntFieldUpdateOperationsInput | number | null
  }

  export type package_featuresUncheckedUpdateWithoutFeaturesInput = {
    id?: IntFieldUpdateOperationsInput | number
    website_analysis?: BoolFieldUpdateOperationsInput | boolean
    content_duplicacy?: BoolFieldUpdateOperationsInput | boolean
    initial_backlinks?: BoolFieldUpdateOperationsInput | boolean
    critical_seo_analysis?: BoolFieldUpdateOperationsInput | boolean
    google_penalty_check?: BoolFieldUpdateOperationsInput | boolean
    competition_analysis?: IntFieldUpdateOperationsInput | number
    competitor_backlinks_opportunity?: IntFieldUpdateOperationsInput | number
    keyword_research_analysis?: BoolFieldUpdateOperationsInput | boolean
    on_page_optimization?: BoolFieldUpdateOperationsInput | boolean
    title_tags_optimization?: BoolFieldUpdateOperationsInput | boolean
    meta_tags_optimization?: BoolFieldUpdateOperationsInput | boolean
    content_optimization?: BoolFieldUpdateOperationsInput | boolean
    html_code_optimization?: BoolFieldUpdateOperationsInput | boolean
    website_permalinks_analysis?: BoolFieldUpdateOperationsInput | boolean
    seo_friendly_urls?: BoolFieldUpdateOperationsInput | boolean
    schema_markup_analysis?: BoolFieldUpdateOperationsInput | boolean
    internal_linking_optimization?: BoolFieldUpdateOperationsInput | boolean
    crawl_error_resolution?: BoolFieldUpdateOperationsInput | boolean
    heading_tags_optimization?: BoolFieldUpdateOperationsInput | boolean
    canonicalization_301_redirect?: BoolFieldUpdateOperationsInput | boolean
    custom_404_errors?: BoolFieldUpdateOperationsInput | boolean
    images_optimization?: BoolFieldUpdateOperationsInput | boolean
    hyperlink_optimization?: BoolFieldUpdateOperationsInput | boolean
    robots_txt_creation_optimization?: BoolFieldUpdateOperationsInput | boolean
    sitemap_creation?: BoolFieldUpdateOperationsInput | boolean
    google_webmaster_tools_setup?: BoolFieldUpdateOperationsInput | boolean
    bing_Webmaster_tools_setup?: BoolFieldUpdateOperationsInput | boolean
    google_analytics_setup_Integration?: BoolFieldUpdateOperationsInput | boolean
    website_responsive_check?: BoolFieldUpdateOperationsInput | boolean
    page_speed_analysis?: BoolFieldUpdateOperationsInput | boolean
    mobile_responsive_compatibility_check?: BoolFieldUpdateOperationsInput | boolean
    navigation_ux_factors?: BoolFieldUpdateOperationsInput | boolean
    ssl_certificate?: BoolFieldUpdateOperationsInput | boolean
    web_2_0_400_600_words_blog_Writing?: IntFieldUpdateOperationsInput | number
    article_writing?: IntFieldUpdateOperationsInput | number
    classified_writing?: IntFieldUpdateOperationsInput | number
    press_release_writing?: IntFieldUpdateOperationsInput | number
    ppt_pdf_creation_writing?: IntFieldUpdateOperationsInput | number
    web_2_0_400_600_words_submission?: IntFieldUpdateOperationsInput | number
    web_2_0_blog_promotion?: IntFieldUpdateOperationsInput | number
    article_submission?: IntFieldUpdateOperationsInput | number
    article_promotion?: IntFieldUpdateOperationsInput | number
    guest_blogging?: IntFieldUpdateOperationsInput | number
    custom_graphics_to_support_your_blogs?: BoolFieldUpdateOperationsInput | boolean
    social_bookmarking_links?: IntFieldUpdateOperationsInput | number
    press_release_submission?: IntFieldUpdateOperationsInput | number
    local_citation?: IntFieldUpdateOperationsInput | number
    classified_submissions?: IntFieldUpdateOperationsInput | number
    ppt_submission?: IntFieldUpdateOperationsInput | number
    ppt_promotion_backlinks?: IntFieldUpdateOperationsInput | number
    pdf_submission?: IntFieldUpdateOperationsInput | number
    pdf_promotion_backlinks?: IntFieldUpdateOperationsInput | number
    quora_Q_A?: IntFieldUpdateOperationsInput | number
    profile_creation?: IntFieldUpdateOperationsInput | number
    blog_commenting_niche_edu?: IntFieldUpdateOperationsInput | number
    forum_submission?: IntFieldUpdateOperationsInput | number
    google_my_business_setup_verification?: BoolFieldUpdateOperationsInput | boolean
    local_citation_submissions?: IntFieldUpdateOperationsInput | number
    google_places_photo_multimedia_additions?: BoolFieldUpdateOperationsInput | boolean
    customer_reviews_ratings?: IntFieldUpdateOperationsInput | number
    local_classified_ads?: IntFieldUpdateOperationsInput | number
    monthly_keyword_improvement_report?: BoolFieldUpdateOperationsInput | boolean
    monthly_back_links_report?: BoolFieldUpdateOperationsInput | boolean
    monthly_google_analytic_static_report?: BoolFieldUpdateOperationsInput | boolean
    email?: BoolFieldUpdateOperationsInput | boolean
    telephone_whatsapp_telegram?: BoolFieldUpdateOperationsInput | boolean
    internet_messenger_skype?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    status?: NullableIntFieldUpdateOperationsInput | number | null
  }

  export type package_featuresUncheckedUpdateManyWithoutFeaturesInput = {
    id?: IntFieldUpdateOperationsInput | number
    website_analysis?: BoolFieldUpdateOperationsInput | boolean
    content_duplicacy?: BoolFieldUpdateOperationsInput | boolean
    initial_backlinks?: BoolFieldUpdateOperationsInput | boolean
    critical_seo_analysis?: BoolFieldUpdateOperationsInput | boolean
    google_penalty_check?: BoolFieldUpdateOperationsInput | boolean
    competition_analysis?: IntFieldUpdateOperationsInput | number
    competitor_backlinks_opportunity?: IntFieldUpdateOperationsInput | number
    keyword_research_analysis?: BoolFieldUpdateOperationsInput | boolean
    on_page_optimization?: BoolFieldUpdateOperationsInput | boolean
    title_tags_optimization?: BoolFieldUpdateOperationsInput | boolean
    meta_tags_optimization?: BoolFieldUpdateOperationsInput | boolean
    content_optimization?: BoolFieldUpdateOperationsInput | boolean
    html_code_optimization?: BoolFieldUpdateOperationsInput | boolean
    website_permalinks_analysis?: BoolFieldUpdateOperationsInput | boolean
    seo_friendly_urls?: BoolFieldUpdateOperationsInput | boolean
    schema_markup_analysis?: BoolFieldUpdateOperationsInput | boolean
    internal_linking_optimization?: BoolFieldUpdateOperationsInput | boolean
    crawl_error_resolution?: BoolFieldUpdateOperationsInput | boolean
    heading_tags_optimization?: BoolFieldUpdateOperationsInput | boolean
    canonicalization_301_redirect?: BoolFieldUpdateOperationsInput | boolean
    custom_404_errors?: BoolFieldUpdateOperationsInput | boolean
    images_optimization?: BoolFieldUpdateOperationsInput | boolean
    hyperlink_optimization?: BoolFieldUpdateOperationsInput | boolean
    robots_txt_creation_optimization?: BoolFieldUpdateOperationsInput | boolean
    sitemap_creation?: BoolFieldUpdateOperationsInput | boolean
    google_webmaster_tools_setup?: BoolFieldUpdateOperationsInput | boolean
    bing_Webmaster_tools_setup?: BoolFieldUpdateOperationsInput | boolean
    google_analytics_setup_Integration?: BoolFieldUpdateOperationsInput | boolean
    website_responsive_check?: BoolFieldUpdateOperationsInput | boolean
    page_speed_analysis?: BoolFieldUpdateOperationsInput | boolean
    mobile_responsive_compatibility_check?: BoolFieldUpdateOperationsInput | boolean
    navigation_ux_factors?: BoolFieldUpdateOperationsInput | boolean
    ssl_certificate?: BoolFieldUpdateOperationsInput | boolean
    web_2_0_400_600_words_blog_Writing?: IntFieldUpdateOperationsInput | number
    article_writing?: IntFieldUpdateOperationsInput | number
    classified_writing?: IntFieldUpdateOperationsInput | number
    press_release_writing?: IntFieldUpdateOperationsInput | number
    ppt_pdf_creation_writing?: IntFieldUpdateOperationsInput | number
    web_2_0_400_600_words_submission?: IntFieldUpdateOperationsInput | number
    web_2_0_blog_promotion?: IntFieldUpdateOperationsInput | number
    article_submission?: IntFieldUpdateOperationsInput | number
    article_promotion?: IntFieldUpdateOperationsInput | number
    guest_blogging?: IntFieldUpdateOperationsInput | number
    custom_graphics_to_support_your_blogs?: BoolFieldUpdateOperationsInput | boolean
    social_bookmarking_links?: IntFieldUpdateOperationsInput | number
    press_release_submission?: IntFieldUpdateOperationsInput | number
    local_citation?: IntFieldUpdateOperationsInput | number
    classified_submissions?: IntFieldUpdateOperationsInput | number
    ppt_submission?: IntFieldUpdateOperationsInput | number
    ppt_promotion_backlinks?: IntFieldUpdateOperationsInput | number
    pdf_submission?: IntFieldUpdateOperationsInput | number
    pdf_promotion_backlinks?: IntFieldUpdateOperationsInput | number
    quora_Q_A?: IntFieldUpdateOperationsInput | number
    profile_creation?: IntFieldUpdateOperationsInput | number
    blog_commenting_niche_edu?: IntFieldUpdateOperationsInput | number
    forum_submission?: IntFieldUpdateOperationsInput | number
    google_my_business_setup_verification?: BoolFieldUpdateOperationsInput | boolean
    local_citation_submissions?: IntFieldUpdateOperationsInput | number
    google_places_photo_multimedia_additions?: BoolFieldUpdateOperationsInput | boolean
    customer_reviews_ratings?: IntFieldUpdateOperationsInput | number
    local_classified_ads?: IntFieldUpdateOperationsInput | number
    monthly_keyword_improvement_report?: BoolFieldUpdateOperationsInput | boolean
    monthly_back_links_report?: BoolFieldUpdateOperationsInput | boolean
    monthly_google_analytic_static_report?: BoolFieldUpdateOperationsInput | boolean
    email?: BoolFieldUpdateOperationsInput | boolean
    telephone_whatsapp_telegram?: BoolFieldUpdateOperationsInput | boolean
    internet_messenger_skype?: BoolFieldUpdateOperationsInput | boolean
    created_at?: DateTimeFieldUpdateOperationsInput | Date | string
    updated_at?: DateTimeFieldUpdateOperationsInput | Date | string
    deleted_at?: NullableDateTimeFieldUpdateOperationsInput | Date | string | null
    status?: NullableIntFieldUpdateOperationsInput | number | null
  }



  /**
   * Batch Payload for updateMany & deleteMany & createMany
   */

  export type BatchPayload = {
    count: number
  }

  /**
   * DMMF
   */
  export const dmmf: runtime.BaseDMMF
}