# Generated by Django 4.2.17 on 2025-04-14 07:42

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import djongo.models.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Groups',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('group_name', models.CharField(max_length=100)),
                ('domain_name', models.CharField(max_length=500, null=True)),
                ('project_automation_time', models.DateTimeField(null=True)),
                ('group_call_status', models.CharField(default='INIT', max_length=5)),
                ('track_status', models.CharField(default='INIT', max_length=50)),
                ('group_call_start', models.DateTimeField(auto_now=True)),
                ('group_call_end', models.DateTimeField(auto_now=True)),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('updated_date', models.DateTimeField(auto_now=True)),
                ('fk_user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'group',
            },
        ),
        migrations.CreateModel(
            name='Keyword',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('keyword', models.TextField()),
                ('site_url', models.TextField()),
                ('target', models.TextField(null=True)),
                ('platform', models.CharField(max_length=10)),
                ('exactdomain', models.BooleanField(default=0)),
                ('location', models.TextField(null=True)),
                ('isocode', models.CharField(max_length=5)),
                ('region', models.CharField(max_length=20)),
                ('language', models.CharField(max_length=15)),
                ('language_code', models.CharField(max_length=8, null=True)),
                ('ranknow', models.IntegerField(default=0)),
                ('keyword_difficulty', models.CharField(default='NA', max_length=50)),
                ('search_intent', models.CharField(default='NA', max_length=50)),
                ('cpc', models.CharField(default='NA', max_length=50)),
                ('traffic', models.CharField(default='NA', max_length=50)),
                ('ranked_url', models.CharField(default='NA', max_length=50)),
                ('rank', djongo.models.fields.JSONField(blank=True, default=[])),
                ('search_volume_data', djongo.models.fields.JSONField(blank=True, default=[])),
                ('keyword_suggestions', djongo.models.fields.JSONField(blank=True, default=[])),
                ('track_status', models.CharField(default='INIT', max_length=50)),
                ('rank_sincestart', models.IntegerField(default=0)),
                ('top_rank', models.IntegerField(default=0)),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('updated_date', models.DateTimeField(auto_now=True)),
                ('modified_date', models.DateTimeField()),
                ('lastranked_date', models.DateTimeField()),
                ('dayval', models.IntegerField(default=0)),
                ('weekval', models.IntegerField(default=0)),
                ('monthval', models.IntegerField(default=0)),
                ('halfmonthval', models.IntegerField(default=0)),
                ('daymark', models.CharField(max_length=5)),
                ('weekmark', models.CharField(max_length=5)),
                ('monthmark', models.CharField(max_length=5)),
                ('halfmonthmark', models.CharField(default='-', max_length=5)),
                ('status_from_start', models.CharField(max_length=5)),
                ('auto_refresh_count', models.IntegerField(blank=True, default=0, null=True)),
                ('auto_call_status', models.CharField(default='done', max_length=5)),
                ('crawlurl', models.TextField(default='-')),
                ('page_uuid_url', models.TextField(default='-')),
                ('page_uuid', models.TextField(default='-')),
                ('fk_group', models.ForeignKey(default=1, on_delete=django.db.models.deletion.CASCADE, to='serp.groups')),
                ('fk_user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'keyword',
            },
        ),
        migrations.CreateModel(
            name='Language',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('language_name', models.CharField(max_length=100)),
                ('language_code', models.CharField(max_length=10)),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('updated_date', models.DateTimeField(auto_now=True)),
            ],
            options={
                'db_table': 'language',
            },
        ),
        migrations.CreateModel(
            name='Region',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('region_name', models.CharField(max_length=30)),
                ('region_code', models.CharField(max_length=3)),
                ('region_country', models.CharField(max_length=100)),
                ('searchvolume_country_id', models.CharField(default='', max_length=100)),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('updated_date', models.DateTimeField(auto_now=True)),
            ],
            options={
                'db_table': 'region',
            },
        ),
        migrations.CreateModel(
            name='Settings',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('core_mode', models.BooleanField(default=1)),
                ('core_manual_mail', models.BooleanField(default=1)),
                ('results_per_page', models.IntegerField(default=100)),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('modified_date', models.DateTimeField(auto_now=True)),
                ('core_refresh_time', models.DateField(auto_now_add=True)),
                ('daily_automation_count', djongo.models.fields.JSONField(blank=True, default=[])),
                ('proxy_maximum_load_limit', models.IntegerField(default=1000)),
                ('proxy_success_count', models.IntegerField(default=0)),
                ('proxy_exceeds_count', models.IntegerField(default=0)),
                ('proxy_invalid_count', models.IntegerField(default=0)),
                ('proxy_reset_counter', models.IntegerField(default=0)),
            ],
            options={
                'db_table': 'mainsettings',
            },
        ),
        migrations.CreateModel(
            name='keywordMetrics',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('keyword', models.TextField()),
                ('keyword_slug', models.TextField()),
                ('region_name', models.CharField(max_length=20)),
                ('region_code', models.CharField(max_length=8, null=True)),
                ('searchvolume_country_id', models.CharField(max_length=8, null=True)),
                ('status', models.CharField(default='new', max_length=10)),
                ('month_wise_volume', djongo.models.fields.JSONField(blank=True, default=[])),
                ('past_months', djongo.models.fields.JSONField(blank=True, default=[])),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('modified_date', models.DateTimeField(auto_now=True)),
                ('fk_group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='serp.groups')),
                ('fk_keyword', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='serp.keyword')),
                ('fk_user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'keyword_metrics',
            },
        ),
        migrations.CreateModel(
            name='Competitors',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.TextField()),
                ('keywords', djongo.models.fields.JSONField(blank=True, default=[])),
                ('track_status', models.CharField(default='INIT', max_length=50)),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('modified_date', models.DateTimeField(auto_now=True)),
                ('fk_group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='serp.groups')),
                ('fk_user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'competitors',
            },
        ),
        migrations.CreateModel(
            name='clientTracker',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('client_ip', models.CharField(max_length=60, null=True)),
                ('client_agent', models.TextField(null=True)),
                ('time_zone', models.CharField(max_length=50, null=True)),
                ('country_code', models.CharField(max_length=5, null=True)),
                ('country', models.CharField(max_length=70, null=True)),
                ('region', models.CharField(max_length=100, null=True)),
                ('city', models.CharField(max_length=100, null=True)),
                ('mobile', models.BooleanField(default=0)),
                ('other_info', djongo.models.fields.JSONField(default={})),
                ('status', models.CharField(max_length=6, null=True)),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('modified_date', models.DateTimeField(auto_now=True)),
                ('user_automation_time', models.DateTimeField(null=True)),
                ('fb_user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'account_tracker',
            },
        ),
        migrations.CreateModel(
            name='Accountusage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('plan_keyword_limit', models.IntegerField(default=0)),
                ('plan_project_limit', models.IntegerField(default=1)),
                ('status', models.CharField(max_length=100)),
                ('created_date', models.DateTimeField(auto_now_add=True)),
                ('modified_date', models.DateTimeField(auto_now=True)),
                ('fb_user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'accountusage',
            },
        ),
    ]
