"""Rankmax URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/4.0/topics/http/urls/
"""

from django.contrib import admin
from django.urls import path, include

urlpatterns = [
    path("", include("serp.urls")),
    path('api/account/', include(('account.api.urls', 'account_api'))),
    path('admin/', admin.site.urls),
]

# Custom error handlers (optional, uncomment if needed)
# handler401 = "glassend.views.handler404"
# handler404 = "glassend.views.handler404"
# handler405 = "glassend.views.handler404"
# handler500 = "glassend.views.handler500"

admin.site.site_header = "Ranker Admin Version BETA"
admin.site.site_title = "Ranker Admin Panel"
admin.site.index_title = "Welcome to Ranker Admin Panel"
admin.site.site_url = "https://app.ranker.io/"
