from django.db import IntegrityError
from django.db.models.signals import post_save
from django.dispatch import receiver

from account.models import Account  # Your Mongo-based user model
from account_pg.models import AccountPG  # Your Postgres model

@receiver(post_save, sender=Account)
def sync_to_postgres(sender, instance, created, **kwargs):
    if created:
        try:
            AccountPG.objects.using('postgres').create(
                email=instance.email,
                username=instance.username,
                monogo_user_id=instance.id,  # Mongo user ID, adjust if needed
                # created_at and updated_at will be handled by Django automatically
            )
            print(f"[SYNC] User {instance.email} saved to Postgres")
        except IntegrityError as e:
            print(f"[SYNC ERROR] Could not sync {instance.email}: {e}")