from django.urls import path
from rest_framework.authtoken.views import obtain_auth_token
from account.api import views
from account.api.views import (
    registration_view,
    login,
    ChangePasswordView,
    serviceauthenticate,
)

app_name = "account"

urlpatterns = [
    path("register/", registration_view, name="register"),
    path("login/", login, name="login"),
    path("serviceauthenticate/", serviceauthenticate, name="serviceauthenticate"),
    path("token/", obtain_auth_token, name="token"),
    path("changepassword/", ChangePasswordView.as_view(), name="update"),
]
